'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var LoaderParser = require('./LoaderParser.js');

const loadJson = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: LoaderParser.LoaderParserPriority.Low
  },
  test(url) {
    return core.utils.path.extname(url).includes(".json");
  },
  async load(url) {
    const response = await core.settings.ADAPTER.fetch(url);
    const json = await response.json();
    return json;
  }
};
core.extensions.add(loadJson);

exports.loadJson = loadJson;
//# sourceMappingURL=loadJson.js.map
