import { ExtensionType, utils, settings, extensions } from '@pixi/core';
import { LoaderParserPriority } from './LoaderParser.mjs';

const loadJson = {
  extension: {
    type: ExtensionType.LoadParser,
    priority: LoaderParserPriority.Low
  },
  test(url) {
    return utils.path.extname(url).includes(".json");
  },
  async load(url) {
    const response = await settings.ADAPTER.fetch(url);
    const json = await response.json();
    return json;
  }
};
extensions.add(loadJson);

export { loadJson };
//# sourceMappingURL=loadJson.mjs.map
