'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var LoaderParser = require('./LoaderParser.js');

const loadTxt = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: LoaderParser.LoaderParserPriority.Low
  },
  test(url) {
    return core.utils.path.extname(url).includes(".txt");
  },
  async load(url) {
    const response = await core.settings.ADAPTER.fetch(url);
    const txt = await response.text();
    return txt;
  }
};
core.extensions.add(loadTxt);

exports.loadTxt = loadTxt;
//# sourceMappingURL=loadTxt.js.map
