import { ExtensionType, utils, settings, extensions } from '@pixi/core';
import { LoaderParserPriority } from './LoaderParser.mjs';

const loadTxt = {
  extension: {
    type: ExtensionType.LoadParser,
    priority: LoaderParserPriority.Low
  },
  test(url) {
    return utils.path.extname(url).includes(".txt");
  },
  async load(url) {
    const response = await settings.ADAPTER.fetch(url);
    const txt = await response.text();
    return txt;
  }
};
extensions.add(loadTxt);

export { loadTxt };
//# sourceMappingURL=loadTxt.mjs.map
