'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var LoaderParser = require('./LoaderParser.js');

const validWeights = [
  "normal",
  "bold",
  "100",
  "200",
  "300",
  "400",
  "500",
  "600",
  "700",
  "800",
  "900"
];
const validFonts = ["woff", "woff2", "ttf", "otf"];
function getFontFamilyName(url) {
  const ext = core.utils.path.extname(url);
  const name = core.utils.path.basename(url, ext);
  const nameWithSpaces = name.replace(/(-|_)/g, " ");
  const nameTitleCase = nameWithSpaces.toLowerCase().split(" ").map((word) => word.charAt(0).toUpperCase() + word.slice(1)).join(" ");
  return nameTitleCase;
}
const loadWebFont = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: LoaderParser.LoaderParserPriority.Low
  },
  test(url) {
    const tempURL = url.split("?")[0];
    const extension = tempURL.split(".").pop();
    return validFonts.includes(extension);
  },
  async load(url, options) {
    if (!globalThis.navigator.onLine) {
      throw new Error("[loadWebFont] Cannot load font - navigator is offline");
    }
    const fonts = core.settings.ADAPTER.getFontFaceSet();
    if (fonts) {
      const fontFaces = [];
      const name = options.data?.family ?? getFontFamilyName(url);
      const weights = options.data?.weights?.filter((weight) => validWeights.includes(weight)) ?? ["normal"];
      const data = options.data ?? {};
      for (let i = 0; i < weights.length; i++) {
        const weight = weights[i];
        const font = new FontFace(name, `url(${url})`, {
          ...data,
          weight
        });
        await font.load();
        fonts.add(font);
        fontFaces.push(font);
      }
      return fontFaces.length === 1 ? fontFaces[0] : fontFaces;
    }
    return null;
  },
  unload(font) {
    (Array.isArray(font) ? font : [font]).forEach((t) => core.settings.ADAPTER.getFontFaceSet().delete(t));
  }
};
core.extensions.add(loadWebFont);

exports.getFontFamilyName = getFontFamilyName;
exports.loadWebFont = loadWebFont;
//# sourceMappingURL=loadWebFont.js.map
