'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var LoaderParser = require('../LoaderParser.js');
var loadTextures = require('./loadTextures.js');
var createTexture = require('./utils/createTexture.js');

const loadSVG = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: LoaderParser.LoaderParserPriority.High
  },
  test(url) {
    return core.utils.path.extname(url).includes(".svg");
  },
  async testParse(data) {
    return core.SVGResource.test(data);
  },
  async parse(asset, data, loader) {
    const src = new core.SVGResource(asset, data?.data?.resourceOptions);
    const base = new core.BaseTexture(src, {
      resolution: core.utils.getResolutionOfUrl(asset),
      ...data?.data
    });
    base.resource.src = asset;
    const texture = createTexture.createTexture(base, loader, asset);
    if (!data?.data?.resourceOptions?.autoLoad) {
      await src.load();
    }
    return texture;
  },
  async load(url, _options) {
    const response = await core.settings.ADAPTER.fetch(url);
    return response.text();
  },
  unload: loadTextures.loadTextures.unload
};

exports.loadSVG = loadSVG;
//# sourceMappingURL=loadSVG.js.map
