import { ExtensionType, utils, SVGResource, BaseTexture, settings } from '@pixi/core';
import { LoaderParserPriority } from '../LoaderParser.mjs';
import { loadTextures } from './loadTextures.mjs';
import { createTexture } from './utils/createTexture.mjs';

const loadSVG = {
  extension: {
    type: ExtensionType.LoadParser,
    priority: LoaderParserPriority.High
  },
  test(url) {
    return utils.path.extname(url).includes(".svg");
  },
  async testParse(data) {
    return SVGResource.test(data);
  },
  async parse(asset, data, loader) {
    const src = new SVGResource(asset, data?.data?.resourceOptions);
    const base = new BaseTexture(src, {
      resolution: utils.getResolutionOfUrl(asset),
      ...data?.data
    });
    base.resource.src = asset;
    const texture = createTexture(base, loader, asset);
    if (!data?.data?.resourceOptions?.autoLoad) {
      await src.load();
    }
    return texture;
  },
  async load(url, _options) {
    const response = await settings.ADAPTER.fetch(url);
    return response.text();
  },
  unload: loadTextures.unload
};

export { loadSVG };
//# sourceMappingURL=loadSVG.mjs.map
