import type { IBaseTextureOptions, Texture } from '@pixi/core';
import type { LoaderParser } from '../LoaderParser';
/**
 * Returns a promise that resolves an ImageBitmaps.
 * This function is designed to be used by a worker.
 * Part of WorkerManager!
 * @param url - The image to load an image bitmap for
 */
export declare function loadImageBitmap(url: string): Promise<ImageBitmap>;
/**
 * Loads our textures!
 * this makes use of imageBitmaps where available.
 * We load the ImageBitmap on a different thread using the WorkerManager
 * We can then use the ImageBitmap as a source for a Pixi Texture
 */
export declare const loadTextures: LoaderParser<Texture<import("@pixi/core").Resource>, IBaseTextureOptions<any>>;
