import { ExtensionType, settings, MIPMAP_MODES, ALPHA_MODES, utils, BaseTexture, extensions } from '@pixi/core';
import { LoaderParserPriority, checkExtension, createTexture } from '@pixi/assets';
import '../parsers/index.mjs';
import { parseKTX } from '../parsers/parseKTX.mjs';

const loadKTX = {
  extension: {
    type: ExtensionType.LoadParser,
    priority: LoaderParserPriority.High
  },
  test(url) {
    return checkExtension(url, ".ktx");
  },
  async load(url, asset, loader) {
    const response = await settings.ADAPTER.fetch(url);
    const arrayBuffer = await response.arrayBuffer();
    const { compressed, uncompressed, kvData } = parseKTX(url, arrayBuffer);
    const resources = compressed ?? uncompressed;
    const options = {
      mipmap: MIPMAP_MODES.OFF,
      alphaMode: ALPHA_MODES.NO_PREMULTIPLIED_ALPHA,
      resolution: utils.getResolutionOfUrl(url),
      ...asset.data
    };
    const textures = resources.map((resource) => {
      if (resources === uncompressed) {
        Object.assign(options, {
          type: resource.type,
          format: resource.format
        });
      }
      const base = new BaseTexture(resource, options);
      base.ktxKeyValueData = kvData;
      return createTexture(base, loader, url);
    });
    return textures.length === 1 ? textures[0] : textures;
  },
  unload(texture) {
    if (Array.isArray(texture)) {
      texture.forEach((t) => t.destroy(true));
    } else {
      texture.destroy(true);
    }
  }
};
extensions.add(loadKTX);

export { loadKTX };
//# sourceMappingURL=loadKTX.mjs.map
