import type { Resource } from '@pixi/core';
import { ViewableBuffer, BufferResource } from '@pixi/core';
interface IBlobOptions {
    autoLoad?: boolean;
    width: number;
    height: number;
}
/**
 * Resource that fetches texture data over the network and stores it in a buffer.
 * @class
 * @extends PIXI.Resource
 * @memberof PIXI
 */
export declare abstract class BlobResource extends BufferResource {
    protected origin: string;
    protected buffer: ViewableBuffer;
    protected loaded: boolean;
    /**
     * @param {string} source - the URL of the texture file
     * @param {PIXI.IBlobOptions} options
     * @param {boolean}[options.autoLoad] - whether to fetch the data immediately;
     *  you can fetch it later via {@link BlobResource#load}
     * @param {boolean}[options.width] - the width in pixels.
     * @param {boolean}[options.height] - the height in pixels.
     */
    constructor(source: string | Uint8Array | Uint32Array | Float32Array, options?: IBlobOptions);
    protected onBlobLoaded(_data: ArrayBuffer): void;
    /** Loads the blob */
    load(): Promise<Resource>;
}
export {};
