import { BufferResource, ViewableBuffer } from '@pixi/core';

class BlobResource extends BufferResource {
  constructor(source, options = { width: 1, height: 1, autoLoad: true }) {
    let origin;
    let data;
    if (typeof source === "string") {
      origin = source;
      data = new Uint8Array();
    } else {
      origin = null;
      data = source;
    }
    super(data, options);
    this.origin = origin;
    this.buffer = data ? new ViewableBuffer(data) : null;
    if (this.origin && options.autoLoad !== false) {
      this.load();
    }
    if (data?.length) {
      this.loaded = true;
      this.onBlobLoaded(this.buffer.rawBinaryData);
    }
  }
  onBlobLoaded(_data) {
  }
  async load() {
    const response = await fetch(this.origin);
    const blob = await response.blob();
    const arrayBuffer = await blob.arrayBuffer();
    this.data = new Uint32Array(arrayBuffer);
    this.buffer = new ViewableBuffer(arrayBuffer);
    this.loaded = true;
    this.onBlobLoaded(arrayBuffer);
    this.update();
    return this;
  }
}

export { BlobResource };
//# sourceMappingURL=BlobResource.mjs.map
