import type { utils } from '@pixi/core';
import type { FederatedEventMap } from './FederatedEventMap';
export declare type Cursor = 'auto' | 'default' | 'none' | 'context-menu' | 'help' | 'pointer' | 'progress' | 'wait' | 'cell' | 'crosshair' | 'text' | 'vertical-text' | 'alias' | 'copy' | 'move' | 'no-drop' | 'not-allowed' | 'e-resize' | 'n-resize' | 'ne-resize' | 'nw-resize' | 's-resize' | 'se-resize' | 'sw-resize' | 'w-resize' | 'ns-resize' | 'ew-resize' | 'nesw-resize' | 'col-resize' | 'nwse-resize' | 'row-resize' | 'all-scroll' | 'zoom-in' | 'zoom-out' | 'grab' | 'grabbing';
export interface IHitArea {
    contains(x: number, y: number): boolean;
}
/**
 * Describes the shape for a {@link FederatedEvent}'s' `eventTarget`.
 * @memberof PIXI
 */
export interface FederatedEventTarget extends utils.EventEmitter, EventTarget {
    /** The cursor preferred when the mouse pointer is hovering over. */
    cursor: Cursor | string;
    /** The parent of this event target. */
    readonly parent?: FederatedEventTarget;
    /** The children of this event target. */
    readonly children?: ReadonlyArray<FederatedEventTarget>;
    /** Whether this event target should fire UI events. */
    interactive: boolean;
    /** Whether this event target has any children that need UI events. This can be used optimize event propagation. */
    interactiveChildren: boolean;
    /** The hit-area specifies the area for which pointer events should be captured by this event target. */
    hitArea: IHitArea | null;
    /** Remove all listeners, or those of the specified event. */
    removeAllListeners(event?: string | symbol): this;
}
declare type AddListenerOptions = boolean | AddEventListenerOptions;
declare type RemoveListenerOptions = boolean | EventListenerOptions;
export interface IFederatedDisplayObject extends Omit<FederatedEventTarget, 'parent' | 'children' | keyof utils.EventEmitter | 'cursor'> {
    addEventListener<K extends keyof FederatedEventMap>(type: K, listener: (e: FederatedEventMap[K]) => any, options?: AddListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: AddListenerOptions): void;
    removeEventListener<K extends keyof FederatedEventMap>(type: K, listener: (e: FederatedEventMap[K]) => any, options?: RemoveListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: RemoveListenerOptions): void;
}
export declare const FederatedDisplayObject: IFederatedDisplayObject;
export {};
