'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var FederatedEvent = require('./FederatedEvent.js');
var core = require('@pixi/core');

class FederatedMouseEvent extends FederatedEvent.FederatedEvent {
  constructor() {
    super(...arguments);
    this.client = new core.Point();
    this.movement = new core.Point();
    this.offset = new core.Point();
    this.global = new core.Point();
    this.screen = new core.Point();
  }
  get clientX() {
    return this.client.x;
  }
  get clientY() {
    return this.client.y;
  }
  get x() {
    return this.clientX;
  }
  get y() {
    return this.clientY;
  }
  get movementX() {
    return this.movement.x;
  }
  get movementY() {
    return this.movement.y;
  }
  get offsetX() {
    return this.offset.x;
  }
  get offsetY() {
    return this.offset.y;
  }
  get globalX() {
    return this.global.x;
  }
  get globalY() {
    return this.global.y;
  }
  get screenX() {
    return this.screen.x;
  }
  get screenY() {
    return this.screen.y;
  }
  getModifierState(key) {
    return "getModifierState" in this.nativeEvent && this.nativeEvent.getModifierState(key);
  }
  initMouseEvent(_typeArg, _canBubbleArg, _cancelableArg, _viewArg, _detailArg, _screenXArg, _screenYArg, _clientXArg, _clientYArg, _ctrlKeyArg, _altKeyArg, _shiftKeyArg, _metaKeyArg, _buttonArg, _relatedTargetArg) {
    throw new Error("Method not implemented.");
  }
}

exports.FederatedMouseEvent = FederatedMouseEvent;
//# sourceMappingURL=FederatedMouseEvent.js.map
