/// <reference path="../global.d.ts" />
export * from './const';
export * from './styles/FillStyle';
export * from './Graphics';
export * from './GraphicsData';
export * from './GraphicsGeometry';
export * from './styles/LineStyle';
import { buildLine, ArcUtils, BezierUtils, QuadraticUtils, BatchPart } from './utils';
import type { BatchDrawCall } from '@pixi/core/';
import type { IShapeBuildCommand } from './utils/IShapeBuildCommand';
import type { SHAPES } from '@pixi/core';
export declare const graphicsUtils: {
    buildPoly: IShapeBuildCommand;
    buildCircle: IShapeBuildCommand;
    buildRectangle: IShapeBuildCommand;
    buildRoundedRectangle: IShapeBuildCommand;
    buildLine: typeof buildLine;
    ArcUtils: typeof ArcUtils;
    BezierUtils: typeof BezierUtils;
    QuadraticUtils: typeof QuadraticUtils;
    BatchPart: typeof BatchPart;
    FILL_COMMANDS: Record<SHAPES, IShapeBuildCommand>;
    BATCH_POOL: BatchPart[];
    DRAW_CALL_POOL: BatchDrawCall[];
};
