import { Texture } from '@pixi/core';

class FillStyle {
  constructor() {
    this.color = 16777215;
    this.alpha = 1;
    this.texture = Texture.WHITE;
    this.matrix = null;
    this.visible = false;
    this.reset();
  }
  clone() {
    const obj = new FillStyle();
    obj.color = this.color;
    obj.alpha = this.alpha;
    obj.texture = this.texture;
    obj.matrix = this.matrix;
    obj.visible = this.visible;
    return obj;
  }
  reset() {
    this.color = 16777215;
    this.alpha = 1;
    this.texture = Texture.WHITE;
    this.matrix = null;
    this.visible = false;
  }
  destroy() {
    this.texture = null;
    this.matrix = null;
  }
}

export { FillStyle };
//# sourceMappingURL=FillStyle.mjs.map
