'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var buildPoly = require('./buildPoly.js');
var buildCircle = require('./buildCircle.js');
var buildRectangle = require('./buildRectangle.js');
var buildRoundedRectangle = require('./buildRoundedRectangle.js');
var buildLine = require('./buildLine.js');
var ArcUtils = require('./ArcUtils.js');
var BezierUtils = require('./BezierUtils.js');
var QuadraticUtils = require('./QuadraticUtils.js');
var BatchPart = require('./BatchPart.js');
var core = require('@pixi/core');

const FILL_COMMANDS = {
  [core.SHAPES.POLY]: buildPoly.buildPoly,
  [core.SHAPES.CIRC]: buildCircle.buildCircle,
  [core.SHAPES.ELIP]: buildCircle.buildCircle,
  [core.SHAPES.RECT]: buildRectangle.buildRectangle,
  [core.SHAPES.RREC]: buildRoundedRectangle.buildRoundedRectangle
};
const BATCH_POOL = [];
const DRAW_CALL_POOL = [];

exports.buildPoly = buildPoly.buildPoly;
exports.buildCircle = buildCircle.buildCircle;
exports.buildRectangle = buildRectangle.buildRectangle;
exports.buildRoundedRectangle = buildRoundedRectangle.buildRoundedRectangle;
exports.buildLine = buildLine.buildLine;
exports.ArcUtils = ArcUtils.ArcUtils;
exports.BezierUtils = BezierUtils.BezierUtils;
exports.QuadraticUtils = QuadraticUtils.QuadraticUtils;
exports.BatchPart = BatchPart.BatchPart;
exports.BATCH_POOL = BATCH_POOL;
exports.DRAW_CALL_POOL = DRAW_CALL_POOL;
exports.FILL_COMMANDS = FILL_COMMANDS;
//# sourceMappingURL=index.js.map
