'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var mesh = require('@pixi/mesh');
var core = require('@pixi/core');

class SimpleMesh extends mesh.Mesh {
  constructor(texture = core.Texture.EMPTY, vertices, uvs, indices, drawMode) {
    const geometry = new mesh.MeshGeometry(vertices, uvs, indices);
    geometry.getBuffer("aVertexPosition").static = false;
    const meshMaterial = new mesh.MeshMaterial(texture);
    super(geometry, meshMaterial, null, drawMode);
    this.autoUpdate = true;
  }
  get vertices() {
    return this.geometry.getBuffer("aVertexPosition").data;
  }
  set vertices(value) {
    this.geometry.getBuffer("aVertexPosition").data = value;
  }
  _render(renderer) {
    if (this.autoUpdate) {
      this.geometry.getBuffer("aVertexPosition").update();
    }
    super._render(renderer);
  }
}

exports.SimpleMesh = SimpleMesh;
//# sourceMappingURL=SimpleMesh.js.map
