'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');

class MeshGeometry extends core.Geometry {
  constructor(vertices, uvs, index) {
    super();
    const verticesBuffer = new core.Buffer(vertices);
    const uvsBuffer = new core.Buffer(uvs, true);
    const indexBuffer = new core.Buffer(index, true, true);
    this.addAttribute("aVertexPosition", verticesBuffer, 2, false, core.TYPES.FLOAT).addAttribute("aTextureCoord", uvsBuffer, 2, false, core.TYPES.FLOAT).addIndex(indexBuffer);
    this._updateId = -1;
  }
  get vertexDirtyId() {
    return this.buffers[0]._updateID;
  }
}

exports.MeshGeometry = MeshGeometry;
//# sourceMappingURL=MeshGeometry.js.map
