import { Geometry, Buffer, TYPES } from '@pixi/core';

class MeshGeometry extends Geometry {
  constructor(vertices, uvs, index) {
    super();
    const verticesBuffer = new Buffer(vertices);
    const uvsBuffer = new Buffer(uvs, true);
    const indexBuffer = new Buffer(index, true, true);
    this.addAttribute("aVertexPosition", verticesBuffer, 2, false, TYPES.FLOAT).addAttribute("aTextureCoord", uvsBuffer, 2, false, TYPES.FLOAT).addIndex(indexBuffer);
    this._updateId = -1;
  }
  get vertexDirtyId() {
    return this.buffers[0]._updateID;
  }
}

export { MeshGeometry };
//# sourceMappingURL=MeshGeometry.mjs.map
