'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var display = require('@pixi/display');

class ParticleContainer extends display.Container {
  constructor(maxSize = 1500, properties, batchSize = 16384, autoResize = false) {
    super();
    const maxBatchSize = 16384;
    if (batchSize > maxBatchSize) {
      batchSize = maxBatchSize;
    }
    this._properties = [false, true, false, false, false];
    this._maxSize = maxSize;
    this._batchSize = batchSize;
    this._buffers = null;
    this._bufferUpdateIDs = [];
    this._updateID = 0;
    this.interactiveChildren = false;
    this.blendMode = core.BLEND_MODES.NORMAL;
    this.autoResize = autoResize;
    this.roundPixels = true;
    this.baseTexture = null;
    this.setProperties(properties);
    this._tint = 0;
    this.tintRgb = new Float32Array(4);
    this.tint = 16777215;
  }
  setProperties(properties) {
    if (properties) {
      this._properties[0] = "vertices" in properties || "scale" in properties ? !!properties.vertices || !!properties.scale : this._properties[0];
      this._properties[1] = "position" in properties ? !!properties.position : this._properties[1];
      this._properties[2] = "rotation" in properties ? !!properties.rotation : this._properties[2];
      this._properties[3] = "uvs" in properties ? !!properties.uvs : this._properties[3];
      this._properties[4] = "tint" in properties || "alpha" in properties ? !!properties.tint || !!properties.alpha : this._properties[4];
    }
  }
  updateTransform() {
    this.displayObjectUpdateTransform();
  }
  get tint() {
    return this._tint;
  }
  set tint(value) {
    this._tint = value;
    core.utils.hex2rgb(value, this.tintRgb);
  }
  render(renderer) {
    if (!this.visible || this.worldAlpha <= 0 || !this.children.length || !this.renderable) {
      return;
    }
    if (!this.baseTexture) {
      this.baseTexture = this.children[0]._texture.baseTexture;
      if (!this.baseTexture.valid) {
        this.baseTexture.once("update", () => this.onChildrenChange(0));
      }
    }
    renderer.batch.setObjectRenderer(renderer.plugins.particle);
    renderer.plugins.particle.render(this);
  }
  onChildrenChange(smallestChildIndex) {
    const bufferIndex = Math.floor(smallestChildIndex / this._batchSize);
    while (this._bufferUpdateIDs.length < bufferIndex) {
      this._bufferUpdateIDs.push(0);
    }
    this._bufferUpdateIDs[bufferIndex] = ++this._updateID;
  }
  dispose() {
    if (this._buffers) {
      for (let i = 0; i < this._buffers.length; ++i) {
        this._buffers[i].destroy();
      }
      this._buffers = null;
    }
  }
  destroy(options) {
    super.destroy(options);
    this.dispose();
    this._properties = null;
    this._buffers = null;
    this._bufferUpdateIDs = null;
  }
}

exports.ParticleContainer = ParticleContainer;
//# sourceMappingURL=ParticleContainer.js.map
