'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

class TimeLimiter {
  constructor(maxMilliseconds) {
    this.maxMilliseconds = maxMilliseconds;
    this.frameStart = 0;
  }
  beginFrame() {
    this.frameStart = Date.now();
  }
  allowedToUpload() {
    return Date.now() - this.frameStart < this.maxMilliseconds;
  }
}

exports.TimeLimiter = TimeLimiter;
//# sourceMappingURL=TimeLimiter.js.map
