'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var constants = require('@pixi/constants');
var adapter = require('./adapter.js');
var canUploadSameBuffer = require('./utils/canUploadSameBuffer.js');
var isMobile = require('./utils/isMobile.js');
var maxRecommendedTextures = require('./utils/maxRecommendedTextures.js');

const settings = {
  ADAPTER: adapter.BrowserAdapter,
  MIPMAP_TEXTURES: constants.MIPMAP_MODES.POW2,
  ANISOTROPIC_LEVEL: 0,
  RESOLUTION: 1,
  FILTER_RESOLUTION: 1,
  FILTER_MULTISAMPLE: constants.MSAA_QUALITY.NONE,
  SPRITE_MAX_TEXTURES: maxRecommendedTextures.maxRecommendedTextures(32),
  SPRITE_BATCH_SIZE: 4096,
  RENDER_OPTIONS: {
    view: null,
    antialias: false,
    autoDensity: false,
    backgroundColor: 0,
    backgroundAlpha: 1,
    useContextAlpha: true,
    clearBeforeRender: true,
    preserveDrawingBuffer: false,
    width: 800,
    height: 600,
    legacy: false,
    hello: false
  },
  GC_MODE: constants.GC_MODES.AUTO,
  GC_MAX_IDLE: 60 * 60,
  GC_MAX_CHECK_COUNT: 60 * 10,
  WRAP_MODE: constants.WRAP_MODES.CLAMP,
  SCALE_MODE: constants.SCALE_MODES.LINEAR,
  PRECISION_VERTEX: constants.PRECISION.HIGH,
  PRECISION_FRAGMENT: isMobile.isMobile.apple.device ? constants.PRECISION.HIGH : constants.PRECISION.MEDIUM,
  CAN_UPLOAD_SAME_BUFFER: canUploadSameBuffer.canUploadSameBuffer(),
  CREATE_IMAGE_BITMAP: false,
  ROUND_PIXELS: false
};

exports.settings = settings;
//# sourceMappingURL=settings.js.map
