import { MIPMAP_MODES, MSAA_QUALITY, GC_MODES, WRAP_MODES, SCALE_MODES, PRECISION } from '@pixi/constants';
import { BrowserAdapter } from './adapter.mjs';
import { canUploadSameBuffer } from './utils/canUploadSameBuffer.mjs';
import { isMobile } from './utils/isMobile.mjs';
import { maxRecommendedTextures } from './utils/maxRecommendedTextures.mjs';

const settings = {
  ADAPTER: BrowserAdapter,
  MIPMAP_TEXTURES: MIPMAP_MODES.POW2,
  ANISOTROPIC_LEVEL: 0,
  RESOLUTION: 1,
  FILTER_RESOLUTION: 1,
  FILTER_MULTISAMPLE: MSAA_QUALITY.NONE,
  SPRITE_MAX_TEXTURES: maxRecommendedTextures(32),
  SPRITE_BATCH_SIZE: 4096,
  RENDER_OPTIONS: {
    view: null,
    antialias: false,
    autoDensity: false,
    backgroundColor: 0,
    backgroundAlpha: 1,
    useContextAlpha: true,
    clearBeforeRender: true,
    preserveDrawingBuffer: false,
    width: 800,
    height: 600,
    legacy: false,
    hello: false
  },
  GC_MODE: GC_MODES.AUTO,
  GC_MAX_IDLE: 60 * 60,
  GC_MAX_CHECK_COUNT: 60 * 10,
  WRAP_MODE: WRAP_MODES.CLAMP,
  SCALE_MODE: SCALE_MODES.LINEAR,
  PRECISION_VERTEX: PRECISION.HIGH,
  PRECISION_FRAGMENT: isMobile.apple.device ? PRECISION.HIGH : PRECISION.MEDIUM,
  CAN_UPLOAD_SAME_BUFFER: canUploadSameBuffer(),
  CREATE_IMAGE_BITMAP: false,
  ROUND_PIXELS: false
};

export { settings };
//# sourceMappingURL=settings.mjs.map
