'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var isMobile = require('./isMobile.js');

function maxRecommendedTextures(max) {
  let allowMax = true;
  if (isMobile.isMobile.tablet || isMobile.isMobile.phone) {
    if (isMobile.isMobile.apple.device) {
      const match = navigator.userAgent.match(/OS (\d+)_(\d+)?/);
      if (match) {
        const majorVersion = parseInt(match[1], 10);
        if (majorVersion < 11) {
          allowMax = false;
        }
      }
    }
    if (isMobile.isMobile.android.device) {
      const match = navigator.userAgent.match(/Android\s([0-9.]*)/);
      if (match) {
        const majorVersion = parseInt(match[1], 10);
        if (majorVersion < 7) {
          allowMax = false;
        }
      }
    }
  }
  return allowMax ? max : 4;
}

exports.maxRecommendedTextures = maxRecommendedTextures;
//# sourceMappingURL=maxRecommendedTextures.js.map
