import { Spritesheet } from './Spritesheet';
import type { AssetExtension } from '@pixi/assets';
import type { ISpritesheetData } from './Spritesheet';
interface SpriteSheetJson extends ISpritesheetData {
    meta: {
        image: string;
        scale: string;
        related_multi_packs?: string[];
    };
}
/**
 * Asset extension for loading spritesheets.
 * @memberof PIXI
 */
export declare const spritesheetAsset: AssetExtension<Spritesheet | SpriteSheetJson, any>;
export {};
