'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var assets = require('@pixi/assets');
var BitmapFont = require('./BitmapFont.js');
require('./formats/index.js');
var TextFormat = require('./formats/TextFormat.js');
var XMLStringFormat = require('./formats/XMLStringFormat.js');

const validExtensions = [".xml", ".fnt"];
const loadBitmapFont = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: assets.LoaderParserPriority.Normal
  },
  test(url) {
    return validExtensions.includes(core.utils.path.extname(url));
  },
  async testParse(data) {
    return TextFormat.TextFormat.test(data) || XMLStringFormat.XMLStringFormat.test(data);
  },
  async parse(asset, data, loader) {
    const fontData = TextFormat.TextFormat.test(asset) ? TextFormat.TextFormat.parse(asset) : XMLStringFormat.XMLStringFormat.parse(asset);
    const { src } = data;
    const { page: pages } = fontData;
    const textureUrls = [];
    for (let i = 0; i < pages.length; ++i) {
      const pageFile = pages[i].file;
      const imagePath = core.utils.path.join(core.utils.path.dirname(src), pageFile);
      textureUrls.push(imagePath);
    }
    const loadedTextures = await loader.load(textureUrls);
    const textures = textureUrls.map((url) => loadedTextures[url]);
    return BitmapFont.BitmapFont.install(fontData, textures, true);
  },
  async load(url, _options) {
    const response = await core.settings.ADAPTER.fetch(url);
    return response.text();
  },
  unload(bitmapFont) {
    bitmapFont.destroy();
  }
};
core.extensions.add(loadBitmapFont);

exports.loadBitmapFont = loadBitmapFont;
//# sourceMappingURL=loadBitmapFont.js.map
