import { ExtensionType, utils, settings, extensions } from '@pixi/core';
import { LoaderParserPriority } from '@pixi/assets';
import { BitmapFont } from './BitmapFont.mjs';
import './formats/index.mjs';
import { TextFormat } from './formats/TextFormat.mjs';
import { XMLStringFormat } from './formats/XMLStringFormat.mjs';

const validExtensions = [".xml", ".fnt"];
const loadBitmapFont = {
  extension: {
    type: ExtensionType.LoadParser,
    priority: LoaderParserPriority.Normal
  },
  test(url) {
    return validExtensions.includes(utils.path.extname(url));
  },
  async testParse(data) {
    return TextFormat.test(data) || XMLStringFormat.test(data);
  },
  async parse(asset, data, loader) {
    const fontData = TextFormat.test(asset) ? TextFormat.parse(asset) : XMLStringFormat.parse(asset);
    const { src } = data;
    const { page: pages } = fontData;
    const textureUrls = [];
    for (let i = 0; i < pages.length; ++i) {
      const pageFile = pages[i].file;
      const imagePath = utils.path.join(utils.path.dirname(src), pageFile);
      textureUrls.push(imagePath);
    }
    const loadedTextures = await loader.load(textureUrls);
    const textures = textureUrls.map((url) => loadedTextures[url]);
    return BitmapFont.install(fontData, textures, true);
  },
  async load(url, _options) {
    const response = await settings.ADAPTER.fetch(url);
    return response.text();
  },
  unload(bitmapFont) {
    bitmapFont.destroy();
  }
};
extensions.add(loadBitmapFont);

export { loadBitmapFont };
//# sourceMappingURL=loadBitmapFont.mjs.map
