'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var settings = require('@pixi/settings');
var eventemitter3 = require('eventemitter3');
var earcut = require('earcut');
var url = require('./url.js');
var path = require('./path.js');
require('./settings.js');
var hello = require('./browser/hello.js');
var isWebGLSupported = require('./browser/isWebGLSupported.js');
var hex = require('./color/hex.js');
var premultiply = require('./color/premultiply.js');
var createIndicesForQuads = require('./data/createIndicesForQuads.js');
var getBufferType = require('./data/getBufferType.js');
var interleaveTypedArrays = require('./data/interleaveTypedArrays.js');
var pow2 = require('./data/pow2.js');
var removeItems = require('./data/removeItems.js');
var sign = require('./data/sign.js');
var uid = require('./data/uid.js');
var deprecation = require('./logging/deprecation.js');
var caches = require('./media/caches.js');
var CanvasRenderTarget = require('./media/CanvasRenderTarget.js');
var trimCanvas = require('./media/trimCanvas.js');
var decomposeDataUri = require('./network/decomposeDataUri.js');
var determineCrossOrigin = require('./network/determineCrossOrigin.js');
var getResolutionOfUrl = require('./network/getResolutionOfUrl.js');
var _const = require('./const.js');
require('./types/index.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var eventemitter3__default = /*#__PURE__*/_interopDefaultLegacy(eventemitter3);
var earcut__default = /*#__PURE__*/_interopDefaultLegacy(earcut);



Object.defineProperty(exports, 'isMobile', {
	enumerable: true,
	get: function () { return settings.isMobile; }
});
Object.defineProperty(exports, 'EventEmitter', {
	enumerable: true,
	get: function () { return eventemitter3__default["default"]; }
});
Object.defineProperty(exports, 'earcut', {
	enumerable: true,
	get: function () { return earcut__default["default"]; }
});
exports.url = url.url;
exports.path = path.path;
exports.sayHello = hello.sayHello;
exports.skipHello = hello.skipHello;
exports.isWebGLSupported = isWebGLSupported.isWebGLSupported;
exports.hex2rgb = hex.hex2rgb;
exports.hex2string = hex.hex2string;
exports.rgb2hex = hex.rgb2hex;
exports.string2hex = hex.string2hex;
exports.correctBlendMode = premultiply.correctBlendMode;
exports.premultiplyBlendMode = premultiply.premultiplyBlendMode;
exports.premultiplyRgba = premultiply.premultiplyRgba;
exports.premultiplyTint = premultiply.premultiplyTint;
exports.premultiplyTintToRgba = premultiply.premultiplyTintToRgba;
exports.createIndicesForQuads = createIndicesForQuads.createIndicesForQuads;
exports.getBufferType = getBufferType.getBufferType;
exports.interleaveTypedArrays = interleaveTypedArrays.interleaveTypedArrays;
exports.isPow2 = pow2.isPow2;
exports.log2 = pow2.log2;
exports.nextPow2 = pow2.nextPow2;
exports.removeItems = removeItems.removeItems;
exports.sign = sign.sign;
exports.uid = uid.uid;
exports.deprecation = deprecation.deprecation;
exports.BaseTextureCache = caches.BaseTextureCache;
exports.ProgramCache = caches.ProgramCache;
exports.TextureCache = caches.TextureCache;
exports.clearTextureCache = caches.clearTextureCache;
exports.destroyTextureCache = caches.destroyTextureCache;
exports.CanvasRenderTarget = CanvasRenderTarget.CanvasRenderTarget;
exports.trimCanvas = trimCanvas.trimCanvas;
exports.decomposeDataUri = decomposeDataUri.decomposeDataUri;
exports.determineCrossOrigin = determineCrossOrigin.determineCrossOrigin;
exports.getResolutionOfUrl = getResolutionOfUrl.getResolutionOfUrl;
exports.DATA_URI = _const.DATA_URI;
//# sourceMappingURL=index.js.map
