'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var settings = require('@pixi/settings');

class CanvasRenderTarget {
  constructor(width, height, resolution) {
    this.canvas = settings.settings.ADAPTER.createCanvas();
    this.context = this.canvas.getContext("2d");
    this.resolution = resolution || settings.settings.RESOLUTION;
    this.resize(width, height);
  }
  clear() {
    this.context.setTransform(1, 0, 0, 1, 0, 0);
    this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
  }
  resize(desiredWidth, desiredHeight) {
    this.canvas.width = Math.round(desiredWidth * this.resolution);
    this.canvas.height = Math.round(desiredHeight * this.resolution);
  }
  destroy() {
    this.context = null;
    this.canvas = null;
  }
  get width() {
    return this.canvas.width;
  }
  set width(val) {
    this.canvas.width = Math.round(val);
  }
  get height() {
    return this.canvas.height;
  }
  set height(val) {
    this.canvas.height = Math.round(val);
  }
}

exports.CanvasRenderTarget = CanvasRenderTarget;
//# sourceMappingURL=CanvasRenderTarget.js.map
