import { settings } from '@pixi/settings';

class CanvasRenderTarget {
  constructor(width, height, resolution) {
    this.canvas = settings.ADAPTER.createCanvas();
    this.context = this.canvas.getContext("2d");
    this.resolution = resolution || settings.RESOLUTION;
    this.resize(width, height);
  }
  clear() {
    this.context.setTransform(1, 0, 0, 1, 0, 0);
    this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
  }
  resize(desiredWidth, desiredHeight) {
    this.canvas.width = Math.round(desiredWidth * this.resolution);
    this.canvas.height = Math.round(desiredHeight * this.resolution);
  }
  destroy() {
    this.context = null;
    this.canvas = null;
  }
  get width() {
    return this.canvas.width;
  }
  set width(val) {
    this.canvas.width = Math.round(val);
  }
  get height() {
    return this.canvas.height;
  }
  set height(val) {
    this.canvas.height = Math.round(val);
  }
}

export { CanvasRenderTarget };
//# sourceMappingURL=CanvasRenderTarget.mjs.map
