# placeholders [![NPM version](https://img.shields.io/npm/v/placeholders.svg?style=flat)](https://www.npmjs.com/package/placeholders) [![NPM monthly downloads](https://img.shields.io/npm/dm/placeholders.svg?style=flat)](https://npmjs.org/package/placeholders)  [![NPM total downloads](https://img.shields.io/npm/dt/placeholders.svg?style=flat)](https://npmjs.org/package/placeholders) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/placeholders.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/placeholders) [![Windows Build Status](https://img.shields.io/appveyor/ci/jonschlinkert/placeholders.svg?style=flat&label=AppVeyor)](https://ci.appveyor.com/project/jonschlinkert/placeholders)

> Replace placeholder values in a file path.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save placeholders
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add placeholders
```

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save placeholders
```

## Usage

```js
var placeholders = require('placeholders')(options);

placeholders('/site/blog/:path', {path: 'foo-bar.md'});
//=> '/site/blog/foo-bar.md'
```

## Options

Options may be passed to the main function.

```js
var placeholders = require('placeholders')(options);
```

### options.regex

Pass a custom regex to use for replacements.

**Type**: `{RegExp}`

**Default**: the default regex matches es6 delimiters and lodash template syntax.

**Example**

Match [printf-like](https://en.wikipedia.org/wiki/Printf_format_string) strings:

```js
var placeholders = require('placeholders')({
  regex: /%([^%]+)%/
});
```

### options.data

Pass a `data` object on the main function to use for resolving values.

**Type**: `{Object}`

**Default**: `undefined`

**Example**

```js
var placeholders = require('placeholders')({
  data: {foo: 'one', bar: 'two'}
});

placeholders(':foo/:bar/:baz', {baz: 'three'})
//=> 'one/two/three'
```

### returns a function when no data is passed

This allows you to reuse the same pattern with different data,
like a compiled template.

```js
var placeholders = require('placeholders')({
  regex: /%([^%]+)%/
});

var fn = placeholders('foo/%bar%/%baz%');
fn({bar: 'one', baz: 'two'})
//=> 'foo/one/two'
fn({bar: 'a', baz: 'b'})
//=> 'foo/a/b'
```

## About

### Related projects

* [assign-deep](https://www.npmjs.com/package/assign-deep): Deeply assign the enumerable properties and/or es6 Symbol properies of source objects to the target… [more](https://github.com/jonschlinkert/assign-deep) | [homepage](https://github.com/jonschlinkert/assign-deep "Deeply assign the enumerable properties and/or es6 Symbol properies of source objects to the target (first) object.")
* [expand](https://www.npmjs.com/package/expand): Recursively resolve templates in an object, string or array. | [homepage](https://github.com/jonschlinkert/expand "Recursively resolve templates in an object, string or array.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** |  
| --- | --- |  
| 13 | [jonschlinkert](https://github.com/jonschlinkert) |  
| 8  | [doowb](https://github.com/doowb) |  

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on June 17, 2017._