/**
 * Logs a frame number.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_RENDER_FRAME: string;
/**
 * Logs a frame time.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_RENDER_FRAME_TIME: string;
/**
 * Logs basic information about generated render passes.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_RENDER_PASS: string;
/**
 * Logs additional detail for render passes.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_RENDER_PASS_DETAIL: string;
/**
 * Logs render actions created by the layer composition. Only executes when the
 * layer composition changes.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_RENDER_ACTION: string;
/**
 * Logs the allocation of render targets.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_RENDER_TARGET_ALLOC: string;
/**
 * Logs the allocation of textures.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_TEXTURE_ALLOC: string;
/**
 * Logs the creation of shaders.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_SHADER_ALLOC: string;
/**
 * Logs the compilation time of shaders.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_SHADER_COMPILE: string;
/**
 * Logs the vram use by the textures.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_VRAM_TEXTURE: string;
/**
 * Logs the vram use by the vertex buffers.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_VRAM_VB: string;
/**
 * Logs the vram use by the index buffers.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_VRAM_IB: string;
/**
 * Logs the creation of bind groups.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_BINDGROUP_ALLOC: string;
/**
 * Logs the creation of bind group formats.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_BINDGROUPFORMAT_ALLOC: string;
/**
 * Logs the creation of render pipelines. WebBPU only.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_RENDERPIPELINE_ALLOC: string;
/**
 * Logs the creation of compute pipelines. WebGPU only.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_COMPUTEPIPELINE_ALLOC: string;
/**
 * Logs the creation of pipeline layouts. WebBPU only.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_PIPELINELAYOUT_ALLOC: string;
/**
 * Logs the internal debug information for Elements.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACE_ID_ELEMENT: string;
/**
 * Logs the vram use by all textures in memory.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_TEXTURES: string;
/**
 * Logs the render queue commands.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_RENDER_QUEUE: string;
/**
 * Logs the GPU timings.
 *
 * @type {string}
 * @category Debug
 */
declare const TRACEID_GPU_TIMINGS: string;

/**
 * A linear interpolation scheme.
 *
 * @type {number}
 * @category Math
 */
declare const CURVE_LINEAR: number;
/**
 * A smooth step interpolation scheme.
 *
 * @type {number}
 * @category Math
 */
declare const CURVE_SMOOTHSTEP: number;
/**
 * A Catmull-Rom spline interpolation scheme. This interpolation scheme is deprecated. Use
 * CURVE_SPLINE instead.
 *
 * @type {number}
 * @deprecated
 * @ignore
 */
declare const CURVE_CATMULL: number;
/**
 * A cardinal spline interpolation scheme. This interpolation scheme is deprecated. Use
 * CURVE_SPLINE instead.
 *
 * @type {number}
 * @deprecated
 * @ignore
 */
declare const CURVE_CARDINAL: number;
/**
 * Cardinal spline interpolation scheme. For Catmull-Rom, specify curve tension 0.5.
 *
 * @type {number}
 * @category Math
 */
declare const CURVE_SPLINE: number;
/**
 * A stepped interpolator, free from the shackles of blending.
 *
 * @type {number}
 * @category Math
 */
declare const CURVE_STEP: number;

/**
 * Linear distance model.
 *
 * @type {string}
 * @category Sound
 */
declare const DISTANCE_LINEAR: string;
/**
 * Inverse distance model.
 *
 * @type {string}
 * @category Sound
 */
declare const DISTANCE_INVERSE: string;
/**
 * Exponential distance model.
 *
 * @type {string}
 * @category Sound
 */
declare const DISTANCE_EXPONENTIAL: string;

/**
 * Ignores the integer part of texture coordinates, using only the fractional part.
 *
 * @type {number}
 * @category Graphics
 */
declare const ADDRESS_REPEAT: number;
/**
 * Clamps texture coordinate to the range 0 to 1.
 *
 * @type {number}
 * @category Graphics
 */
declare const ADDRESS_CLAMP_TO_EDGE: number;
/**
 * Texture coordinate to be set to the fractional part if the integer part is even. If the integer
 * part is odd, then the texture coordinate is set to 1 minus the fractional part.
 *
 * @type {number}
 * @category Graphics
 */
declare const ADDRESS_MIRRORED_REPEAT: number;
/**
 * Multiply all fragment components by zero.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_ZERO: number;
/**
 * Multiply all fragment components by one.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_ONE: number;
/**
 * Multiply all fragment components by the components of the source fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_SRC_COLOR: number;
/**
 * Multiply all fragment components by one minus the components of the source fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_ONE_MINUS_SRC_COLOR: number;
/**
 * Multiply all fragment components by the components of the destination fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_DST_COLOR: number;
/**
 * Multiply all fragment components by one minus the components of the destination fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_ONE_MINUS_DST_COLOR: number;
/**
 * Multiply all fragment components by the alpha value of the source fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_SRC_ALPHA: number;
/**
 * Multiply all fragment components by the alpha value of the source fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_SRC_ALPHA_SATURATE: number;
/**
 * Multiply all fragment components by one minus the alpha value of the source fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_ONE_MINUS_SRC_ALPHA: number;
/**
 * Multiply all fragment components by the alpha value of the destination fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_DST_ALPHA: number;
/**
 * Multiply all fragment components by one minus the alpha value of the destination fragment.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_ONE_MINUS_DST_ALPHA: number;
/**
 * Multiplies all fragment components by a constant.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_CONSTANT: number;
/**
 * Multiplies all fragment components by 1 minus a constant.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDMODE_ONE_MINUS_CONSTANT: number;
/**
 * Add the results of the source and destination fragment multiplies.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDEQUATION_ADD: number;
/**
 * Subtract the results of the source and destination fragment multiplies.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDEQUATION_SUBTRACT: number;
/**
 * Reverse and subtract the results of the source and destination fragment multiplies.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDEQUATION_REVERSE_SUBTRACT: number;
/**
 * Use the smallest value. Check app.graphicsDevice.extBlendMinmax for support.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDEQUATION_MIN: number;
/**
 * Use the largest value. Check app.graphicsDevice.extBlendMinmax for support.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLENDEQUATION_MAX: number;
/**
 * The data store contents will be modified once and used many times.
 *
 * @type {number}
 * @category Graphics
 */
declare const BUFFER_STATIC: number;
/**
 * The data store contents will be modified repeatedly and used many times.
 *
 * @type {number}
 * @category Graphics
 */
declare const BUFFER_DYNAMIC: number;
/**
 * The data store contents will be modified once and used at most a few times.
 *
 * @type {number}
 * @category Graphics
 */
declare const BUFFER_STREAM: number;
/**
 * The data store contents will be modified repeatedly on the GPU and used many times. Optimal for
 * transform feedback usage (WebGL2 only).
 *
 * @type {number}
 * @category Graphics
 */
declare const BUFFER_GPUDYNAMIC: number;
/**
 * Clear the color buffer.
 *
 * @type {number}
 * @category Graphics
 */
declare const CLEARFLAG_COLOR: number;
/**
 * Clear the depth buffer.
 *
 * @type {number}
 * @category Graphics
 */
declare const CLEARFLAG_DEPTH: number;
/**
 * Clear the stencil buffer.
 *
 * @type {number}
 * @category Graphics
 */
declare const CLEARFLAG_STENCIL: number;
/**
 * The positive X face of a cubemap.
 *
 * @type {number}
 * @category Graphics
 */
declare const CUBEFACE_POSX: number;
/**
 * The negative X face of a cubemap.
 *
 * @type {number}
 * @category Graphics
 */
declare const CUBEFACE_NEGX: number;
/**
 * The positive Y face of a cubemap.
 *
 * @type {number}
 * @category Graphics
 */
declare const CUBEFACE_POSY: number;
/**
 * The negative Y face of a cubemap.
 *
 * @type {number}
 * @category Graphics
 */
declare const CUBEFACE_NEGY: number;
/**
 * The positive Z face of a cubemap.
 *
 * @type {number}
 * @category Graphics
 */
declare const CUBEFACE_POSZ: number;
/**
 * The negative Z face of a cubemap.
 *
 * @type {number}
 * @category Graphics
 */
declare const CUBEFACE_NEGZ: number;
/**
 * No triangles are culled.
 *
 * @type {number}
 * @category Graphics
 */
declare const CULLFACE_NONE: number;
/**
 * Triangles facing away from the view direction are culled.
 *
 * @type {number}
 * @category Graphics
 */
declare const CULLFACE_BACK: number;
/**
 * Triangles facing the view direction are culled.
 *
 * @type {number}
 * @category Graphics
 */
declare const CULLFACE_FRONT: number;
/**
 * Triangles are culled regardless of their orientation with respect to the view direction. Note
 * that point or line primitives are unaffected by this render state.
 *
 * @type {number}
 * @ignore
 * @category Graphics
 */
declare const CULLFACE_FRONTANDBACK: number;
/**
 * Point sample filtering.
 *
 * @type {number}
 * @category Graphics
 */
declare const FILTER_NEAREST: number;
/**
 * Bilinear filtering.
 *
 * @type {number}
 * @category Graphics
 */
declare const FILTER_LINEAR: number;
/**
 * Use the nearest neighbor in the nearest mipmap level.
 *
 * @type {number}
 * @category Graphics
 */
declare const FILTER_NEAREST_MIPMAP_NEAREST: number;
/**
 * Linearly interpolate in the nearest mipmap level.
 *
 * @type {number}
 * @category Graphics
 */
declare const FILTER_NEAREST_MIPMAP_LINEAR: number;
/**
 * Use the nearest neighbor after linearly interpolating between mipmap levels.
 *
 * @type {number}
 * @category Graphics
 */
declare const FILTER_LINEAR_MIPMAP_NEAREST: number;
/**
 * Linearly interpolate both the mipmap levels and between texels.
 *
 * @type {number}
 * @category Graphics
 */
declare const FILTER_LINEAR_MIPMAP_LINEAR: number;
/**
 * Never pass.
 *
 * @type {number}
 * @category Graphics
 */
declare const FUNC_NEVER: number;
/**
 * Pass if (ref & mask) < (stencil & mask).
 *
 * @type {number}
 * @category Graphics
 */
declare const FUNC_LESS: number;
/**
 * Pass if (ref & mask) == (stencil & mask).
 *
 * @type {number}
 * @category Graphics
 */
declare const FUNC_EQUAL: number;
/**
 * Pass if (ref & mask) <= (stencil & mask).
 *
 * @type {number}
 * @category Graphics
 */
declare const FUNC_LESSEQUAL: number;
/**
 * Pass if (ref & mask) > (stencil & mask).
 *
 * @type {number}
 * @category Graphics
 */
declare const FUNC_GREATER: number;
/**
 * Pass if (ref & mask) != (stencil & mask).
 *
 * @type {number}
 * @category Graphics
 */
declare const FUNC_NOTEQUAL: number;
/**
 * Pass if (ref & mask) >= (stencil & mask).
 *
 * @type {number}
 * @category Graphics
 */
declare const FUNC_GREATEREQUAL: number;
/**
 * Always pass.
 *
 * @type {number}
 * @category Graphics
 */
declare const FUNC_ALWAYS: number;
/**
 * 8-bit unsigned vertex indices (0 to 255).
 *
 * @type {number}
 * @category Graphics
 */
declare const INDEXFORMAT_UINT8: number;
/**
 * 16-bit unsigned vertex indices (0 to 65,535).
 *
 * @type {number}
 * @category Graphics
 */
declare const INDEXFORMAT_UINT16: number;
/**
 * 32-bit unsigned vertex indices (0 to 4,294,967,295).
 *
 * @type {number}
 * @category Graphics
 */
declare const INDEXFORMAT_UINT32: number;
/**
 * 8-bit alpha.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_A8: number;
/**
 * 8-bit luminance.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_L8: number;
/**
 * 8-bit luminance with 8-bit alpha.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_LA8: number;
/**
 * 16-bit RGB (5-bits for red channel, 6 for green and 5 for blue).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGB565: number;
/**
 * 16-bit RGBA (5-bits for red channel, 5 for green, 5 for blue with 1-bit alpha).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA5551: number;
/**
 * 16-bit RGBA (4-bits for red channel, 4 for green, 4 for blue with 4-bit alpha).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA4: number;
/**
 * 24-bit RGB (8-bits for red channel, 8 for green and 8 for blue).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGB8: number;
/**
 * 32-bit RGBA (8-bits for red channel, 8 for green, 8 for blue with 8-bit alpha).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA8: number;
/**
 * Block compressed format storing 16 input pixels in 64 bits of output, consisting of two 16-bit
 * RGB 5:6:5 color values and a 4x4 two bit lookup table.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_DXT1: number;
/**
 * Block compressed format storing 16 input pixels (corresponding to a 4x4 pixel block) into 128
 * bits of output, consisting of 64 bits of alpha channel data (4 bits for each pixel) followed by
 * 64 bits of color data; encoded the same way as DXT1.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_DXT3: number;
/**
 * Block compressed format storing 16 input pixels into 128 bits of output, consisting of 64 bits
 * of alpha channel data (two 8 bit alpha values and a 4x4 3 bit lookup table) followed by 64 bits
 * of color data (encoded the same way as DXT1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_DXT5: number;
/**
 * 16-bit floating point RGB (16-bit float for each red, green and blue channels).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGB16F: number;
/**
 * 16-bit floating point RGBA (16-bit float for each red, green, blue and alpha channels).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA16F: number;
/**
 * 32-bit floating point RGB (32-bit float for each red, green and blue channels).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGB32F: number;
/**
 * 32-bit floating point RGBA (32-bit float for each red, green, blue and alpha channels).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA32F: number;
/**
 * 32-bit floating point single channel format (WebGL2 only).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_R32F: number;
/**
 * A readable depth buffer format.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_DEPTH: number;
/**
 * A readable depth/stencil buffer format (WebGL2 only).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_DEPTHSTENCIL: number;
/**
 * A floating-point color-only format with 11 bits for red and green channels and 10 bits for the
 * blue channel (WebGL2 only).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_111110F: number;
/**
 * Color-only sRGB format (WebGL2 only).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_SRGB: number;
/**
 * Color sRGB format with additional alpha channel (WebGL2 only).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_SRGBA: number;
/**
 * ETC1 compressed format.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_ETC1: number;
/**
 * ETC2 (RGB) compressed format.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_ETC2_RGB: number;
/**
 * ETC2 (RGBA) compressed format.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_ETC2_RGBA: number;
/**
 * PVRTC (2BPP RGB) compressed format.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_PVRTC_2BPP_RGB_1: number;
/**
 * PVRTC (2BPP RGBA) compressed format.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_PVRTC_2BPP_RGBA_1: number;
/**
 * PVRTC (4BPP RGB) compressed format.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_PVRTC_4BPP_RGB_1: number;
/**
 * PVRTC (4BPP RGBA) compressed format.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_PVRTC_4BPP_RGBA_1: number;
/**
 * ATC compressed format with alpha channel in blocks of 4x4.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_ASTC_4x4: number;
/**
 * ATC compressed format with no alpha channel.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_ATC_RGB: number;
/**
 * ATC compressed format with alpha channel.
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_ATC_RGBA: number;
/**
 * 32-bit BGRA (8-bits for blue channel, 8 for green, 8 for red with 8-bit alpha).
 *
 * @type {number}
 * @ignore
 * @category Graphics
 */
declare const PIXELFORMAT_BGRA8: number;
/**
 * 8-bit signed integer single-channel (R) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_R8I: number;
/**
 * 8-bit unsigned integer single-channel (R) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_R8U: number;
/**
 * 16-bit signed integer single-channel (R) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_R16I: number;
/**
 * 16-bit unsigned integer single-channel (R) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_R16U: number;
/**
 * 32-bit signed integer single-channel (R) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_R32I: number;
/**
 * 32-bit unsigned integer single-channel (R) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_R32U: number;
/**
 * 8-bit per-channel signed integer (RG) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RG8I: number;
/**
 * 8-bit per-channel unsigned integer (RG) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RG8U: number;
/**
 * 16-bit per-channel signed integer (RG) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RG16I: number;
/**
 * 16-bit per-channel unsigned integer (RG) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RG16U: number;
/**
 * 32-bit per-channel signed integer (RG) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RG32I: number;
/**
 * 32-bit per-channel unsigned integer (RG) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RG32U: number;
/**
 * 8-bit per-channel signed integer (RGBA) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA8I: number;
/**
 * 8-bit per-channel unsigned integer (RGBA) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA8U: number;
/**
 * 16-bit per-channel signed integer (RGBA) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA16I: number;
/**
 * 16-bit per-channel unsigned integer (RGBA) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA16U: number;
/**
 * 32-bit per-channel signed integer (RGBA) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA32I: number;
/**
 * 32-bit per-channel unsigned integer (RGBA) format (Not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RGBA32U: number;
/**
 * 16-bit floating point R (16-bit float for red channel).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_R16F: number;
/**
 * 16-bit floating point RG (16-bit float for each red and green channels).
 *
 * @type {number}
 * @category Graphics
 */
declare const PIXELFORMAT_RG16F: number;
declare const pixelFormatInfo: Map<number, {
    name: string;
    size: number;
    blockSize?: undefined;
    isInt?: undefined;
} | {
    name: string;
    blockSize: number;
    size?: undefined;
    isInt?: undefined;
} | {
    name: string;
    size: number;
    isInt: boolean;
    blockSize?: undefined;
}>;
declare function isCompressedPixelFormat(format: any): boolean;
declare function isIntegerPixelFormat(format: any): boolean;
declare function getPixelFormatArrayType(format: any): Int8ArrayConstructor | Uint8ArrayConstructor | Int16ArrayConstructor | Uint16ArrayConstructor | Int32ArrayConstructor | Uint32ArrayConstructor | Float32ArrayConstructor;
/**
 * List of distinct points.
 *
 * @type {number}
 * @category Graphics
 */
declare const PRIMITIVE_POINTS: number;
/**
 * Discrete list of line segments.
 *
 * @type {number}
 * @category Graphics
 */
declare const PRIMITIVE_LINES: number;
/**
 * List of points that are linked sequentially by line segments, with a closing line segment
 * between the last and first points.
 *
 * @type {number}
 * @category Graphics
 */
declare const PRIMITIVE_LINELOOP: number;
/**
 * List of points that are linked sequentially by line segments.
 *
 * @type {number}
 * @category Graphics
 */
declare const PRIMITIVE_LINESTRIP: number;
/**
 * Discrete list of triangles.
 *
 * @type {number}
 * @category Graphics
 */
declare const PRIMITIVE_TRIANGLES: number;
/**
 * Connected strip of triangles where a specified vertex forms a triangle using the previous two.
 *
 * @type {number}
 * @category Graphics
 */
declare const PRIMITIVE_TRISTRIP: number;
/**
 * Connected fan of triangles where the first vertex forms triangles with the following pairs of vertices.
 *
 * @type {number}
 * @category Graphics
 */
declare const PRIMITIVE_TRIFAN: number;
/**
 * Vertex attribute to be treated as a position.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_POSITION: string;
/**
 * Vertex attribute to be treated as a normal.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_NORMAL: string;
/**
 * Vertex attribute to be treated as a tangent.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TANGENT: string;
/**
 * Vertex attribute to be treated as skin blend weights.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_BLENDWEIGHT: string;
/**
 * Vertex attribute to be treated as skin blend indices.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_BLENDINDICES: string;
/**
 * Vertex attribute to be treated as a color.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_COLOR: string;
declare const SEMANTIC_TEXCOORD: "TEXCOORD";
/**
 * Vertex attribute to be treated as a texture coordinate (set 0).
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TEXCOORD0: string;
/**
 * Vertex attribute to be treated as a texture coordinate (set 1).
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TEXCOORD1: string;
/**
 * Vertex attribute to be treated as a texture coordinate (set 2).
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TEXCOORD2: string;
/**
 * Vertex attribute to be treated as a texture coordinate (set 3).
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TEXCOORD3: string;
/**
 * Vertex attribute to be treated as a texture coordinate (set 4).
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TEXCOORD4: string;
/**
 * Vertex attribute to be treated as a texture coordinate (set 5).
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TEXCOORD5: string;
/**
 * Vertex attribute to be treated as a texture coordinate (set 6).
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TEXCOORD6: string;
/**
 * Vertex attribute to be treated as a texture coordinate (set 7).
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_TEXCOORD7: string;
declare const SEMANTIC_ATTR: "ATTR";
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR0: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR1: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR2: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR3: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR4: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR5: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR6: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR7: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR8: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR9: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR10: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR11: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR12: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR13: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR14: string;
/**
 * Vertex attribute with a user defined semantic.
 *
 * @type {string}
 * @category Graphics
 */
declare const SEMANTIC_ATTR15: string;
declare const SHADERTAG_MATERIAL: 1;
/**
 * Don't change the stencil buffer value.
 *
 * @type {number}
 * @category Graphics
 */
declare const STENCILOP_KEEP: number;
/**
 * Set value to zero.
 *
 * @type {number}
 * @category Graphics
 */
declare const STENCILOP_ZERO: number;
/**
 * Replace value with the reference value (see {@link StencilParameters}).
 *
 * @type {number}
 * @category Graphics
 */
declare const STENCILOP_REPLACE: number;
/**
 * Increment the value.
 *
 * @type {number}
 * @category Graphics
 */
declare const STENCILOP_INCREMENT: number;
/**
 * Increment the value but wrap it to zero when it's larger than a maximum representable value.
 *
 * @type {number}
 * @category Graphics
 */
declare const STENCILOP_INCREMENTWRAP: number;
/**
 * Decrement the value.
 *
 * @type {number}
 * @category Graphics
 */
declare const STENCILOP_DECREMENT: number;
/**
 * Decrement the value but wrap it to a maximum representable value if the current value is 0.
 *
 * @type {number}
 * @category Graphics
 */
declare const STENCILOP_DECREMENTWRAP: number;
/**
 * Invert the value bitwise.
 *
 * @type {number}
 * @category Graphics
 */
declare const STENCILOP_INVERT: number;
/**
 * The texture is not in a locked state.
 *
 * @type {number}
 */
declare const TEXTURELOCK_NONE: number;
/**
 * Read only. Any changes to the locked mip level's pixels will not update the texture.
 *
 * @type {number}
 * @category Graphics
 */
declare const TEXTURELOCK_READ: number;
/**
 * Write only. The contents of the specified mip level will be entirely replaced.
 *
 * @type {number}
 * @category Graphics
 */
declare const TEXTURELOCK_WRITE: number;
/**
 * Texture is a default type.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTURETYPE_DEFAULT: string;
/**
 * Texture stores high dynamic range data in RGBM format.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTURETYPE_RGBM: string;
/**
 * Texture stores high dynamic range data in RGBE format.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTURETYPE_RGBE: string;
/**
 * Texture stores high dynamic range data in RGBP encoding.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTURETYPE_RGBP: string;
/**
 * Texture stores normalmap data swizzled in GGGR format. This is used for tangent space normal
 * maps. The R component is stored in alpha and G is stored in RGB. This packing can result in
 * higher quality when the texture data is compressed.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTURETYPE_SWIZZLEGGGR: string;
declare const TEXHINT_NONE: 0;
declare const TEXHINT_SHADOWMAP: 1;
declare const TEXHINT_ASSET: 2;
declare const TEXHINT_LIGHTMAP: 3;
declare const TEXTUREDIMENSION_1D: "1d";
declare const TEXTUREDIMENSION_2D: "2d";
declare const TEXTUREDIMENSION_2D_ARRAY: "2d-array";
declare const TEXTUREDIMENSION_CUBE: "cube";
declare const TEXTUREDIMENSION_CUBE_ARRAY: "cube-array";
declare const TEXTUREDIMENSION_3D: "3d";
declare const SAMPLETYPE_FLOAT: 0;
declare const SAMPLETYPE_UNFILTERABLE_FLOAT: 1;
declare const SAMPLETYPE_DEPTH: 2;
declare const SAMPLETYPE_INT: 3;
declare const SAMPLETYPE_UINT: 4;
/**
 * Texture data is not stored a specific projection format.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTUREPROJECTION_NONE: string;
/**
 * Texture data is stored in cubemap projection format.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTUREPROJECTION_CUBE: string;
/**
 * Texture data is stored in equirectangular projection format.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTUREPROJECTION_EQUIRECT: string;
/**
 * Texture data is stored in octahedral projection format.
 *
 * @type {string}
 * @category Graphics
 */
declare const TEXTUREPROJECTION_OCTAHEDRAL: string;
/**
 * Shader source code uses GLSL language.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERLANGUAGE_GLSL: string;
/**
 * Shader source code uses WGSL language.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERLANGUAGE_WGSL: string;
/**
 * Signed byte vertex element type.
 *
 * @type {number}
 * @category Graphics
 */
declare const TYPE_INT8: number;
/**
 * Unsigned byte vertex element type.
 *
 * @type {number}
 * @category Graphics
 */
declare const TYPE_UINT8: number;
/**
 * Signed short vertex element type.
 *
 * @type {number}
 * @category Graphics
 */
declare const TYPE_INT16: number;
/**
 * Unsigned short vertex element type.
 *
 * @type {number}
 * @category Graphics
 */
declare const TYPE_UINT16: number;
/**
 * Signed integer vertex element type.
 *
 * @type {number}
 * @category Graphics
 */
declare const TYPE_INT32: number;
/**
 * Unsigned integer vertex element type.
 *
 * @type {number}
 * @category Graphics
 */
declare const TYPE_UINT32: number;
/**
 * Floating point vertex element type.
 *
 * @type {number}
 * @category Graphics
 */
declare const TYPE_FLOAT32: number;
/**
 * 16-bit floating point vertex element type (not supported by WebGL1).
 *
 * @type {number}
 * @category Graphics
 */
declare const TYPE_FLOAT16: number;
declare const UNIFORMTYPE_BOOL: 0;
declare const UNIFORMTYPE_INT: 1;
declare const UNIFORMTYPE_FLOAT: 2;
declare const UNIFORMTYPE_VEC2: 3;
declare const UNIFORMTYPE_VEC3: 4;
declare const UNIFORMTYPE_VEC4: 5;
declare const UNIFORMTYPE_IVEC2: 6;
declare const UNIFORMTYPE_IVEC3: 7;
declare const UNIFORMTYPE_IVEC4: 8;
declare const UNIFORMTYPE_BVEC2: 9;
declare const UNIFORMTYPE_BVEC3: 10;
declare const UNIFORMTYPE_BVEC4: 11;
declare const UNIFORMTYPE_MAT2: 12;
declare const UNIFORMTYPE_MAT3: 13;
declare const UNIFORMTYPE_MAT4: 14;
declare const UNIFORMTYPE_TEXTURE2D: 15;
declare const UNIFORMTYPE_TEXTURECUBE: 16;
declare const UNIFORMTYPE_FLOATARRAY: 17;
declare const UNIFORMTYPE_TEXTURE2D_SHADOW: 18;
declare const UNIFORMTYPE_TEXTURECUBE_SHADOW: 19;
declare const UNIFORMTYPE_TEXTURE3D: 20;
declare const UNIFORMTYPE_VEC2ARRAY: 21;
declare const UNIFORMTYPE_VEC3ARRAY: 22;
declare const UNIFORMTYPE_VEC4ARRAY: 23;
declare const UNIFORMTYPE_MAT4ARRAY: 24;
declare const UNIFORMTYPE_TEXTURE2D_ARRAY: 25;
declare const UNIFORMTYPE_UINT: 26;
declare const UNIFORMTYPE_UVEC2: 27;
declare const UNIFORMTYPE_UVEC3: 28;
declare const UNIFORMTYPE_UVEC4: 29;
declare const UNIFORMTYPE_INTARRAY: 30;
declare const UNIFORMTYPE_UINTARRAY: 31;
declare const UNIFORMTYPE_BOOLARRAY: 32;
declare const UNIFORMTYPE_IVEC2ARRAY: 33;
declare const UNIFORMTYPE_UVEC2ARRAY: 34;
declare const UNIFORMTYPE_BVEC2ARRAY: 35;
declare const UNIFORMTYPE_IVEC3ARRAY: 36;
declare const UNIFORMTYPE_UVEC3ARRAY: 37;
declare const UNIFORMTYPE_BVEC3ARRAY: 38;
declare const UNIFORMTYPE_IVEC4ARRAY: 39;
declare const UNIFORMTYPE_UVEC4ARRAY: 40;
declare const UNIFORMTYPE_BVEC4ARRAY: 41;
declare const UNIFORMTYPE_ITEXTURE2D: 42;
declare const UNIFORMTYPE_UTEXTURE2D: 43;
declare const UNIFORMTYPE_ITEXTURECUBE: 44;
declare const UNIFORMTYPE_UTEXTURECUBE: 45;
declare const UNIFORMTYPE_ITEXTURE3D: 46;
declare const UNIFORMTYPE_UTEXTURE3D: 47;
declare const UNIFORMTYPE_ITEXTURE2D_ARRAY: 48;
declare const UNIFORMTYPE_UTEXTURE2D_ARRAY: 49;
declare const uniformTypeToName: string[];
declare const uniformTypeToStorage: Uint8Array;
/**
 * A WebGL 1 device type.
 *
 * @type {string}
 * @category Graphics
 */
declare const DEVICETYPE_WEBGL1: string;
/**
 * A WebGL 2 device type.
 *
 * @type {string}
 * @category Graphics
 */
declare const DEVICETYPE_WEBGL2: string;
/**
 * A WebGPU device type.
 *
 * @type {string}
 * @category Graphics
 */
declare const DEVICETYPE_WEBGPU: string;
/**
 * A Null device type.
 *
 * @type {string}
 * @category Graphics
 */
declare const DEVICETYPE_NULL: string;
declare const SHADERSTAGE_VERTEX: 1;
declare const SHADERSTAGE_FRAGMENT: 2;
declare const SHADERSTAGE_COMPUTE: 4;
declare const BINDGROUP_MESH: 0;
declare const BINDGROUP_VIEW: 1;
declare const bindGroupNames: string[];
declare const UNIFORM_BUFFER_DEFAULT_SLOT_NAME: "default";
declare const typedArrayTypes: (Int8ArrayConstructor | Uint8ArrayConstructor | Int16ArrayConstructor | Uint16ArrayConstructor | Int32ArrayConstructor | Uint32ArrayConstructor | Float32ArrayConstructor)[];
declare const typedArrayTypesByteSize: number[];
declare const vertexTypesNames: string[];
declare namespace typedArrayToType {
    export { TYPE_INT8 as Int8Array };
    export { TYPE_UINT8 as Uint8Array };
    export { TYPE_INT16 as Int16Array };
    export { TYPE_UINT16 as Uint16Array };
    export { TYPE_INT32 as Int32Array };
    export { TYPE_UINT32 as Uint32Array };
    export { TYPE_FLOAT32 as Float32Array };
}
declare const typedArrayIndexFormats: (Uint8ArrayConstructor | Uint16ArrayConstructor | Uint32ArrayConstructor)[];
declare const typedArrayIndexFormatsByteSize: number[];
/**
 * Map of engine semantics into location on device in range 0..15 (note - semantics mapping to the
 * same location cannot be used at the same time) organized in a way that ATTR0-ATTR7 do not
 * overlap with common important semantics.
 *
 * @type {object}
 * @ignore
 * @category Graphics
 */
declare const semanticToLocation: object;
/**
 * Chunk API versions
 *
 * @type {string}
 * @category Graphics
 */
declare const CHUNKAPI_1_51: string;
declare const CHUNKAPI_1_55: "1.55";
declare const CHUNKAPI_1_56: "1.56";
declare const CHUNKAPI_1_57: "1.57";
declare const CHUNKAPI_1_58: "1.58";
declare const CHUNKAPI_1_60: "1.60";
declare const CHUNKAPI_1_62: "1.62";
declare const CHUNKAPI_1_65: "1.65";

declare const ACTION_MOUSE: "mouse";
declare const ACTION_KEYBOARD: "keyboard";
declare const ACTION_GAMEPAD: "gamepad";
declare const AXIS_MOUSE_X: "mousex";
declare const AXIS_MOUSE_Y: "mousey";
declare const AXIS_PAD_L_X: "padlx";
declare const AXIS_PAD_L_Y: "padly";
declare const AXIS_PAD_R_X: "padrx";
declare const AXIS_PAD_R_Y: "padry";
declare const AXIS_KEY: "key";
/**
 * Name of event fired when a key is pressed.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_KEYDOWN: string;
/**
 * Name of event fired when a key is released.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_KEYUP: string;
/**
 * Name of event fired when a mouse button is pressed.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_MOUSEDOWN: string;
/**
 * Name of event fired when the mouse is moved.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_MOUSEMOVE: string;
/**
 * Name of event fired when a mouse button is released.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_MOUSEUP: string;
/**
 * Name of event fired when the mouse wheel is rotated.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_MOUSEWHEEL: string;
/**
 * Name of event fired when a new touch occurs. For example, a finger is placed on the device.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_TOUCHSTART: string;
/**
 * Name of event fired when touch ends. For example, a finger is lifted off the device.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_TOUCHEND: string;
/**
 * Name of event fired when a touch moves.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_TOUCHMOVE: string;
/**
 * Name of event fired when a touch point is interrupted in some way. The exact reasons for
 * canceling a touch can vary from device to device. For example, a modal alert pops up during the
 * interaction; the touch point leaves the document area, or there are more touch points than the
 * device supports, in which case the earliest touch point is canceled.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_TOUCHCANCEL: string;
/**
 * Name of event fired when a new xr select occurs. For example, primary trigger was pressed.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_SELECT: string;
/**
 * Name of event fired when a new xr select starts. For example, primary trigger is now pressed.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_SELECTSTART: string;
/**
 * Name of event fired when xr select ends. For example, a primary trigger is now released.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_SELECTEND: string;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_BACKSPACE: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_TAB: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_RETURN: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_ENTER: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_SHIFT: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_CONTROL: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_ALT: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_PAUSE: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_CAPS_LOCK: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_ESCAPE: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_SPACE: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_PAGE_UP: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_PAGE_DOWN: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_END: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_HOME: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_LEFT: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_UP: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_RIGHT: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_DOWN: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_PRINT_SCREEN: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_INSERT: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_DELETE: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_0: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_1: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_2: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_3: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_4: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_5: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_6: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_7: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_8: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_9: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_SEMICOLON: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_EQUAL: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_A: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_B: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_C: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_D: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_E: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_G: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_H: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_I: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_J: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_K: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_L: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_M: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_N: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_O: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_P: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_Q: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_R: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_S: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_T: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_U: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_V: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_W: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_X: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_Y: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_Z: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_WINDOWS: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_CONTEXT_MENU: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_0: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_1: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_2: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_3: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_4: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_5: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_6: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_7: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_8: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_NUMPAD_9: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_MULTIPLY: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_ADD: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_SEPARATOR: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_SUBTRACT: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_DECIMAL: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_DIVIDE: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F1: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F2: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F3: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F4: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F5: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F6: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F7: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F8: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F9: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F10: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F11: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_F12: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_COMMA: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_PERIOD: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_SLASH: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_OPEN_BRACKET: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_BACK_SLASH: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_CLOSE_BRACKET: number;
/**
 * @type {number}
 * @category Input
 */
declare const KEY_META: number;
/**
 * No mouse buttons pressed.
 *
 * @type {number}
 * @category Input
 */
declare const MOUSEBUTTON_NONE: number;
/**
 * The left mouse button.
 *
 * @type {number}
 * @category Input
 */
declare const MOUSEBUTTON_LEFT: number;
/**
 * The middle mouse button.
 *
 * @type {number}
 * @category Input
 */
declare const MOUSEBUTTON_MIDDLE: number;
/**
 * The right mouse button.
 *
 * @type {number}
 * @category Input
 */
declare const MOUSEBUTTON_RIGHT: number;
/**
 * Index for pad 1.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_1: number;
/**
 * Index for pad 2.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_2: number;
/**
 * Index for pad 3.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_3: number;
/**
 * Index for pad 4.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_4: number;
/**
 * The first face button, from bottom going clockwise.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_FACE_1: number;
/**
 * The second face button, from bottom going clockwise.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_FACE_2: number;
/**
 * The third face button, from bottom going clockwise.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_FACE_3: number;
/**
 * The fourth face button, from bottom going clockwise.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_FACE_4: number;
/**
 * The first shoulder button on the left.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_L_SHOULDER_1: number;
/**
 * The first shoulder button on the right.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_R_SHOULDER_1: number;
/**
 * The second shoulder button on the left.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_L_SHOULDER_2: number;
/**
 * The second shoulder button on the right.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_R_SHOULDER_2: number;
/**
 * The select button.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_SELECT: number;
/**
 * The start button.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_START: number;
/**
 * The button when depressing the left analogue stick.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_L_STICK_BUTTON: number;
/**
 * The button when depressing the right analogue stick.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_R_STICK_BUTTON: number;
/**
 * Direction pad up.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_UP: number;
/**
 * Direction pad down.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_DOWN: number;
/**
 * Direction pad left.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_LEFT: number;
/**
 * Direction pad right.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_RIGHT: number;
/**
 * Vendor specific button.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_VENDOR: number;
/**
 * Horizontal axis on the left analogue stick.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_L_STICK_X: number;
/**
 * Vertical axis on the left analogue stick.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_L_STICK_Y: number;
/**
 * Horizontal axis on the right analogue stick.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_R_STICK_X: number;
/**
 * Vertical axis on the right analogue stick.
 *
 * @type {number}
 * @category Input
 */
declare const PAD_R_STICK_Y: number;
/**
 * Name of event fired when a gamepad connects.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_GAMEPADCONNECTED: string;
/**
 * Name of event fired when a gamepad disconnects.
 *
 * @type {string}
 * @category Input
 */
declare const EVENT_GAMEPADDISCONNECTED: string;
/**
 * Horizontal axis on the touchpad of a XR pad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_TOUCHPAD_X: number;
/**
 * Vertical axis on the thouchpad of a XR pad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_TOUCHPAD_Y: number;
/**
 * Horizontal axis on the stick of a XR pad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_STICK_X: number;
/**
 * Vertical axis on the stick of a XR pad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_STICK_Y: number;
/**
 * The button when pressing the XR pad's touchpad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_TOUCHPAD_BUTTON: number;
/**
 * The trigger button from XR pad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_TRIGGER: number;
/**
 * The squeeze button from XR pad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_SQUEEZE: number;
/**
 * The button when pressing the XR pad's stick.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_STICK_BUTTON: number;
/**
 * The A button from XR pad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_A: number;
/**
 * The B button from XR pad.
 *
 * @type {number}
 * @category Input
 */
declare const XRPAD_B: number;

/**
 * Subtract the color of the source fragment from the destination fragment and write the result to
 * the frame buffer.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_SUBTRACTIVE: number;
/**
 * Add the color of the source fragment to the destination fragment and write the result to the
 * frame buffer.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_ADDITIVE: number;
/**
 * Enable simple translucency for materials such as glass. This is equivalent to enabling a source
 * blend mode of {@link BLENDMODE_SRC_ALPHA} and a destination blend mode of
 * {@link BLENDMODE_ONE_MINUS_SRC_ALPHA}.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_NORMAL: number;
/**
 * Disable blending.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_NONE: number;
/**
 * Similar to {@link BLEND_NORMAL} expect the source fragment is assumed to have already been
 * multiplied by the source alpha value.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_PREMULTIPLIED: number;
/**
 * Multiply the color of the source fragment by the color of the destination fragment and write the
 * result to the frame buffer.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_MULTIPLICATIVE: number;
/**
 * Same as {@link BLEND_ADDITIVE} except the source RGB is multiplied by the source alpha.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_ADDITIVEALPHA: number;
/**
 * Multiplies colors and doubles the result.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_MULTIPLICATIVE2X: number;
/**
 * Softer version of additive.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_SCREEN: number;
/**
 * Minimum color. Check app.graphicsDevice.extBlendMinmax for support.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_MIN: number;
/**
 * Maximum color. Check app.graphicsDevice.extBlendMinmax for support.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLEND_MAX: number;
/**
 * No fog is applied to the scene.
 *
 * @type {string}
 * @category Graphics
 */
declare const FOG_NONE: string;
/**
 * Fog rises linearly from zero to 1 between a start and end depth.
 *
 * @type {string}
 * @category Graphics
 */
declare const FOG_LINEAR: string;
/**
 * Fog rises according to an exponential curve controlled by a density value.
 *
 * @type {string}
 * @category Graphics
 */
declare const FOG_EXP: string;
/**
 * Fog rises according to an exponential curve controlled by a density value.
 *
 * @type {string}
 * @category Graphics
 */
declare const FOG_EXP2: string;
/**
 * No Fresnel.
 *
 * @type {number}
 * @category Graphics
 */
declare const FRESNEL_NONE: number;
/**
 * Schlick's approximation of Fresnel.
 *
 * @type {number}
 * @category Graphics
 */
declare const FRESNEL_SCHLICK: number;
declare const LAYER_HUD: 0;
declare const LAYER_GIZMO: 1;
declare const LAYER_FX: 2;
declare const LAYER_WORLD: 15;
/**
 * The world layer.
 *
 * @type {number}
 * @category Graphics
 */
declare const LAYERID_WORLD: number;
/**
 * The depth layer.
 *
 * @type {number}
 * @category Graphics
 */
declare const LAYERID_DEPTH: number;
/**
 * The skybox layer.
 *
 * @type {number}
 * @category Graphics
 */
declare const LAYERID_SKYBOX: number;
/**
 * The immediate layer.
 *
 * @type {number}
 * @category Graphics
 */
declare const LAYERID_IMMEDIATE: number;
/**
 * The UI layer.
 *
 * @type {number}
 * @category Graphics
 */
declare const LAYERID_UI: number;
/**
 * Directional (global) light source.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTTYPE_DIRECTIONAL: number;
/**
 * Omni-directional (local) light source.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTTYPE_OMNI: number;
/**
 * Point (local) light source.
 *
 * @type {number}
 * @ignore
 * @category Graphics
 */
declare const LIGHTTYPE_POINT: number;
/**
 * Spot (local) light source.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTTYPE_SPOT: number;
declare const LIGHTTYPE_COUNT: 3;
/**
 * Infinitesimally small point light source shape.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTSHAPE_PUNCTUAL: number;
/**
 * Rectangle shape of light source.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTSHAPE_RECT: number;
/**
 * Disk shape of light source.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTSHAPE_DISK: number;
/**
 * Sphere shape of light source.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTSHAPE_SPHERE: number;
/**
 * Linear distance falloff model for light attenuation.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTFALLOFF_LINEAR: number;
/**
 * Inverse squared distance falloff model for light attenuation.
 *
 * @type {number}
 * @category Graphics
 */
declare const LIGHTFALLOFF_INVERSESQUARED: number;
/**
 * Render depth (color-packed on WebGL 1.0), can be used for PCF 3x3 sampling.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOW_PCF3: number;
declare const SHADOW_DEPTH: 0;
/**
 * Render packed variance shadow map. All shadow receivers must also cast shadows for this mode to
 * work correctly.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOW_VSM8: number;
/**
 * Render 16-bit exponential variance shadow map. Requires OES_texture_half_float extension. Falls
 * back to {@link SHADOW_VSM8}, if not supported.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOW_VSM16: number;
/**
 * Render 32-bit exponential variance shadow map. Requires OES_texture_float extension. Falls back
 * to {@link SHADOW_VSM16}, if not supported.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOW_VSM32: number;
/**
 * Render depth buffer only, can be used for hardware-accelerated PCF 5x5 sampling. Requires
 * WebGL 2. Falls back to {@link SHADOW_PCF3} on WebGL 1.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOW_PCF5: number;
/**
 * Render depth (color-packed on WebGL 1.0), can be used for PCF 1x1 sampling.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOW_PCF1: number;
/**
 * Render depth as color for PCSS software filtering.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOW_PCSS: number;
/**
 * map of engine SHADOW__*** to a string representation
 *
 * @type {object}
 * @ignore
 * @category Graphics
 */
declare const shadowTypeToString: object;
/**
 * Box filter.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLUR_BOX: number;
/**
 * Gaussian filter. May look smoother than box, but requires more samples.
 *
 * @type {number}
 * @category Graphics
 */
declare const BLUR_GAUSSIAN: number;
/**
 * No sorting, particles are drawn in arbitrary order. Can be simulated on GPU.
 *
 * @type {number}
 * @category Graphics
 */
declare const PARTICLESORT_NONE: number;
/**
 * Sorting based on distance to the camera. CPU only.
 *
 * @type {number}
 * @category Graphics
 */
declare const PARTICLESORT_DISTANCE: number;
/**
 * Newer particles are drawn first. CPU only.
 *
 * @type {number}
 * @category Graphics
 */
declare const PARTICLESORT_NEWER_FIRST: number;
/**
 * Older particles are drawn first. CPU only.
 *
 * @type {number}
 * @category Graphics
 */
declare const PARTICLESORT_OLDER_FIRST: number;
declare const PARTICLEMODE_GPU: 0;
declare const PARTICLEMODE_CPU: 1;
/**
 * Box shape parameterized by emitterExtents. Initial velocity is directed towards local Z axis.
 *
 * @type {number}
 * @category Graphics
 */
declare const EMITTERSHAPE_BOX: number;
/**
 * Sphere shape parameterized by emitterRadius. Initial velocity is directed outwards from the
 * center.
 *
 * @type {number}
 * @category Graphics
 */
declare const EMITTERSHAPE_SPHERE: number;
/**
 * Particles are facing camera.
 *
 * @type {number}
 * @category Graphics
 */
declare const PARTICLEORIENTATION_SCREEN: number;
/**
 * User defines world space normal (particleNormal) to set planes orientation.
 *
 * @type {number}
 * @category Graphics
 */
declare const PARTICLEORIENTATION_WORLD: number;
/**
 * Similar to previous, but the normal is affected by emitter(entity) transformation.
 *
 * @type {number}
 * @category Graphics
 */
declare const PARTICLEORIENTATION_EMITTER: number;
/**
 * A perspective camera projection where the frustum shape is essentially pyramidal.
 *
 * @type {number}
 * @category Graphics
 */
declare const PROJECTION_PERSPECTIVE: number;
/**
 * An orthographic camera projection where the frustum shape is essentially a cuboid.
 *
 * @type {number}
 * @category Graphics
 */
declare const PROJECTION_ORTHOGRAPHIC: number;
/**
 * Render mesh instance as solid geometry.
 *
 * @type {number}
 * @category Graphics
 */
declare const RENDERSTYLE_SOLID: number;
/**
 * Render mesh instance as wireframe.
 *
 * @type {number}
 * @category Graphics
 */
declare const RENDERSTYLE_WIREFRAME: number;
/**
 * Render mesh instance as points.
 *
 * @type {number}
 * @category Graphics
 */
declare const RENDERSTYLE_POINTS: number;
/**
 * The cube map is treated as if it is infinitely far away.
 *
 * @type {number}
 * @category Graphics
 */
declare const CUBEPROJ_NONE: number;
/**
 * The cube map is box-projected based on a world space axis-aligned bounding box.
 *
 * @type {number}
 * @category Graphics
 */
declare const CUBEPROJ_BOX: number;
/**
 * Phong without energy conservation. You should only use it as a backwards compatibility with
 * older projects.
 *
 * @type {number}
 * @category Graphics
 */
declare const SPECULAR_PHONG: number;
/**
 * Energy-conserving Blinn-Phong.
 *
 * @type {number}
 * @category Graphics
 */
declare const SPECULAR_BLINN: number;
/**
 * Multiply together the primary and secondary colors.
 *
 * @type {string}
 * @category Graphics
 */
declare const DETAILMODE_MUL: string;
/**
 * Add together the primary and secondary colors.
 *
 * @type {string}
 * @category Graphics
 */
declare const DETAILMODE_ADD: string;
/**
 * Softer version of {@link DETAILMODE_ADD}.
 *
 * @type {string}
 * @category Graphics
 */
declare const DETAILMODE_SCREEN: string;
/**
 * Multiplies or screens the colors, depending on the primary color.
 *
 * @type {string}
 * @category Graphics
 */
declare const DETAILMODE_OVERLAY: string;
/**
 * Select whichever of the primary and secondary colors is darker, component-wise.
 *
 * @type {string}
 * @category Graphics
 */
declare const DETAILMODE_MIN: string;
/**
 * Select whichever of the primary and secondary colors is lighter, component-wise.
 *
 * @type {string}
 * @category Graphics
 */
declare const DETAILMODE_MAX: string;
/**
 * No gamma correction.
 *
 * @type {number}
 * @category Graphics
 */
declare const GAMMA_NONE: number;
/**
 * Apply sRGB gamma correction.
 *
 * @type {number}
 * @category Graphics
 */
declare const GAMMA_SRGB: number;
/**
 * Apply sRGB (fast) gamma correction.
 *
 * @type {number}
 * @deprecated
 * @ignore
 * @category Graphics
 */
declare const GAMMA_SRGBFAST: number;
/**
 * Apply sRGB (HDR) gamma correction.
 *
 * @type {number}
 * @category Graphics
 */
declare const GAMMA_SRGBHDR: number;
/**
 * Linear tonemapping.
 *
 * @type {number}
 * @category Graphics
 */
declare const TONEMAP_LINEAR: number;
/**
 * Filmic tonemapping curve.
 *
 * @type {number}
 * @category Graphics
 */
declare const TONEMAP_FILMIC: number;
/**
 * Hejl filmic tonemapping curve.
 *
 * @type {number}
 * @category Graphics
 */
declare const TONEMAP_HEJL: number;
/**
 * ACES filmic tonemapping curve.
 *
 * @type {number}
 * @category Graphics
 */
declare const TONEMAP_ACES: number;
/**
 * ACES v2 filmic tonemapping curve.
 *
 * @type {number}
 * @category Graphics
 */
declare const TONEMAP_ACES2: number;
/**
 * No specular occlusion.
 *
 * @type {number}
 * @category Graphics
 */
declare const SPECOCC_NONE: number;
/**
 * Use AO directly to occlude specular.
 *
 * @type {number}
 * @category Graphics
 */
declare const SPECOCC_AO: number;
/**
 * Modify AO based on material glossiness/view angle to occlude specular.
 *
 * @type {number}
 * @category Graphics
 */
declare const SPECOCC_GLOSSDEPENDENT: number;
declare const SHADERDEF_NOSHADOW: 1;
declare const SHADERDEF_SKIN: 2;
declare const SHADERDEF_UV0: 4;
declare const SHADERDEF_UV1: 8;
declare const SHADERDEF_VCOLOR: 16;
declare const SHADERDEF_INSTANCING: 32;
declare const SHADERDEF_LM: 64;
declare const SHADERDEF_DIRLM: 128;
declare const SHADERDEF_SCREENSPACE: 256;
declare const SHADERDEF_TANGENTS: 512;
declare const SHADERDEF_MORPH_POSITION: 1024;
declare const SHADERDEF_MORPH_NORMAL: 2048;
declare const SHADERDEF_MORPH_TEXTURE_BASED: 4096;
declare const SHADERDEF_LMAMBIENT: 8192;
/**
 * The shadow map is not to be updated.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOWUPDATE_NONE: number;
/**
 * The shadow map is regenerated this frame and not on subsequent frames.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOWUPDATE_THISFRAME: number;
/**
 * The shadow map is regenerated every frame.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADOWUPDATE_REALTIME: number;
declare const SORTKEY_FORWARD: 0;
declare const SORTKEY_DEPTH: 1;
declare const MASK_AFFECT_DYNAMIC: 1;
declare const MASK_AFFECT_LIGHTMAPPED: 2;
declare const MASK_BAKE: 4;
/**
 * Render shaded materials with gamma correction and tonemapping.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADER_FORWARD: number;
/**
 * Render shaded materials without gamma correction and tonemapping.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADER_FORWARDHDR: number;
/**
 * Render RGBA-encoded depth value.
 *
 * @type {number}
 * @category Graphics
 */
declare const SHADER_DEPTH: number;
declare const SHADER_PICK: 3;
declare const SHADER_SHADOW: 4;
declare const SHADER_PREPASS_VELOCITY: 5;
/**
 * Shader that performs forward rendering.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_FORWARD: string;
/**
 * Shader used for debug rendering of albedo.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_ALBEDO: string;
/**
 * Shader used for debug rendering of world normal.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_WORLDNORMAL: string;
/**
 * Shader used for debug rendering of opacity.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_OPACITY: string;
/**
 * Shader used for debug rendering of specularity.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_SPECULARITY: string;
/**
 * Shader used for debug rendering of gloss.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_GLOSS: string;
/**
 * Shader used for debug rendering of metalness.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_METALNESS: string;
/**
 * Shader used for debug rendering of ao.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_AO: string;
/**
 * Shader used for debug rendering of emission.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_EMISSION: string;
/**
 * Shader used for debug rendering of lighting.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_LIGHTING: string;
/**
 * Shader used for debug rendering of UV0 texture coordinates.
 *
 * @type {string}
 * @category Graphics
 */
declare const SHADERPASS_UV0: string;
/**
 * This mode renders a sprite as a simple quad.
 *
 * @type {number}
 * @category Graphics
 */
declare const SPRITE_RENDERMODE_SIMPLE: number;
/**
 * This mode renders a sprite using 9-slicing in 'sliced' mode. Sliced mode stretches the top and
 * bottom regions of the sprite horizontally, the left and right regions vertically and the middle
 * region both horizontally and vertically.
 *
 * @type {number}
 * @category Graphics
 */
declare const SPRITE_RENDERMODE_SLICED: number;
/**
 * This mode renders a sprite using 9-slicing in 'tiled' mode. Tiled mode tiles the top and bottom
 * regions of the sprite horizontally, the left and right regions vertically and the middle region
 * both horizontally and vertically.
 *
 * @type {number}
 * @category Graphics
 */
declare const SPRITE_RENDERMODE_TILED: number;
/**
 * Single color lightmap.
 *
 * @type {number}
 * @category Graphics
 */
declare const BAKE_COLOR: number;
/**
 * Single color lightmap + dominant light direction (used for bump/specular).
 *
 * @type {number}
 * @category Graphics
 */
declare const BAKE_COLORDIR: number;
/**
 * Center of view.
 *
 * @type {number}
 * @category Graphics
 */
declare const VIEW_CENTER: number;
/**
 * Left of view. Only used in stereo rendering.
 *
 * @type {number}
 * @category Graphics
 */
declare const VIEW_LEFT: number;
/**
 * Right of view. Only used in stereo rendering.
 *
 * @type {number}
 * @category Graphics
 */
declare const VIEW_RIGHT: number;
/**
 * No sorting is applied. Mesh instances are rendered in the same order they were added to a layer.
 *
 * @type {number}
 * @category Graphics
 */
declare const SORTMODE_NONE: number;
/**
 * Mesh instances are sorted based on {@link MeshInstance#drawOrder}.
 *
 * @type {number}
 * @category Graphics
 */
declare const SORTMODE_MANUAL: number;
/**
 * Mesh instances are sorted to minimize switching between materials and meshes to improve
 * rendering performance.
 *
 * @type {number}
 * @category Graphics
 */
declare const SORTMODE_MATERIALMESH: number;
/**
 * Mesh instances are sorted back to front. This is the way to properly render many
 * semi-transparent objects on different depth, one is blended on top of another.
 *
 * @type {number}
 * @category Graphics
 */
declare const SORTMODE_BACK2FRONT: number;
/**
 * Mesh instances are sorted front to back. Depending on GPU and the scene, this option may give
 * better performance than {@link SORTMODE_MATERIALMESH} due to reduced overdraw.
 *
 * @type {number}
 * @category Graphics
 */
declare const SORTMODE_FRONT2BACK: number;
/**
 * Provide custom functions for sorting drawcalls and calculating distance.
 *
 * @type {number}
 * @ignore
 * @category Graphics
 */
declare const SORTMODE_CUSTOM: number;
/**
 * Automatically set aspect ratio to current render target's width divided by height.
 *
 * @type {number}
 * @category Graphics
 */
declare const ASPECT_AUTO: number;
/**
 * Use the manual aspect ratio value.
 *
 * @type {number}
 * @category Graphics
 */
declare const ASPECT_MANUAL: number;
/**
 * Horizontal orientation.
 *
 * @type {number}
 * @category Graphics
 */
declare const ORIENTATION_HORIZONTAL: number;
/**
 * Vertical orientation.
 *
 * @type {number}
 * @category Graphics
 */
declare const ORIENTATION_VERTICAL: number;
/**
 * A sky texture is rendered using an infinite projection.
 *
 * @type {string}
 * @category Graphics
 */
declare const SKYTYPE_INFINITE: string;
/**
 * A sky texture is rendered using a box projection. This is generally suitable for interior
 * environments.
 *
 * @type {string}
 * @category Graphics
 */
declare const SKYTYPE_BOX: string;
/**
 *  A sky texture is rendered using a dome projection. This is generally suitable for exterior
 * environments.
 *
 * @type {string}
 * @category Graphics
 */
declare const SKYTYPE_DOME: string;
/**
 * Opacity dithering is disabled.
 *
 * @type {string}
 * @category Graphics
 */
declare const DITHER_NONE: string;
/**
 * Opacity is dithered using a Bayer 8 matrix.
 *
 * @type {string}
 * @category Graphics
 */
declare const DITHER_BAYER8: string;
/**
 * Opacity is dithered using a blue noise texture.
 *
 * @type {string}
 * @category Graphics
 */
declare const DITHER_BLUENOISE: string;

/**
 * When resizing the window the size of the canvas will not change.
 *
 * @type {string}
 */
declare const FILLMODE_NONE: string;
/**
 * When resizing the window the size of the canvas will change to fill the window exactly.
 *
 * @type {string}
 */
declare const FILLMODE_FILL_WINDOW: string;
/**
 * When resizing the window the size of the canvas will change to fill the window as best it can,
 * while maintaining the same aspect ratio.
 *
 * @type {string}
 */
declare const FILLMODE_KEEP_ASPECT: string;
/**
 * When the canvas is resized the resolution of the canvas will change to match the size of the
 * canvas.
 *
 * @type {string}
 */
declare const RESOLUTION_AUTO: string;
/**
 * When the canvas is resized the resolution of the canvas will remain at the same value and the
 * output will just be scaled to fit the canvas.
 *
 * @type {string}
 */
declare const RESOLUTION_FIXED: string;

/**
 * Specifies different color tints for the hover, pressed and inactive states.
 *
 * @type {number}
 * @category User Interface
 */
declare const BUTTON_TRANSITION_MODE_TINT: number;
/**
 * Specifies different sprites for the hover, pressed and inactive states.
 *
 * @type {number}
 * @category User Interface
 */
declare const BUTTON_TRANSITION_MODE_SPRITE_CHANGE: number;

/**
 * A {@link ElementComponent} that contains child {@link ElementComponent}s.
 *
 * @type {string}
 * @category User Interface
 */
declare const ELEMENTTYPE_GROUP: string;
/**
 * A {@link ElementComponent} that displays an image.
 *
 * @type {string}
 * @category User Interface
 */
declare const ELEMENTTYPE_IMAGE: string;
/**
 * A {@link ElementComponent} that displays text.
 *
 * @type {string}
 * @category User Interface
 */
declare const ELEMENTTYPE_TEXT: string;
/**
 * Fit the content exactly to Element's bounding box.
 *
 * @type {string}
 * @category User Interface
 */
declare const FITMODE_STRETCH: string;
/**
 * Fit the content within the Element's bounding box while preserving its Aspect Ratio.
 *
 * @type {string}
 * @category User Interface
 */
declare const FITMODE_CONTAIN: string;
/**
 * Fit the content to cover the entire Element's bounding box while preserving its Aspect Ratio.
 *
 * @type {string}
 * @category User Interface
 */
declare const FITMODE_COVER: string;

/**
 * Specified degree of freedom has free movement.
 *
 * @type {string}
 * @ignore
 */
declare const MOTION_FREE: string;
/**
 * Specified degree of freedom has limited movement.
 *
 * @type {string}
 * @ignore
 */
declare const MOTION_LIMITED: string;
/**
 * Specified degree of freedom is locked and allows no movement.
 *
 * @type {string}
 * @ignore
 */
declare const MOTION_LOCKED: string;

/**
 * Disable all fitting logic.
 *
 * @type {number}
 * @category User Interface
 */
declare const FITTING_NONE: number;
/**
 * Stretch child elements to fit the parent container.
 *
 * @type {number}
 * @category User Interface
 */
declare const FITTING_STRETCH: number;
/**
 * Shrink child elements to fit the parent container.
 *
 * @type {number}
 * @category User Interface
 */
declare const FITTING_SHRINK: number;
/**
 * Apply both STRETCH and SHRINK fitting logic where applicable.
 *
 * @type {number}
 * @category User Interface
 */
declare const FITTING_BOTH: number;

/**
 * Rigid body has infinite mass and cannot move.
 *
 * @type {string}
 * @category Physics
 */
declare const BODYTYPE_STATIC: string;
/**
 * Rigid body is simulated according to applied forces.
 *
 * @type {string}
 * @category Physics
 */
declare const BODYTYPE_DYNAMIC: string;
/**
 * Rigid body has infinite mass and does not respond to forces but can still be moved by setting
 * their velocity or position.
 *
 * @type {string}
 * @category Physics
 */
declare const BODYTYPE_KINEMATIC: string;
declare const BODYFLAG_STATIC_OBJECT: 1;
declare const BODYFLAG_KINEMATIC_OBJECT: 2;
declare const BODYFLAG_NORESPONSE_OBJECT: 4;
declare const BODYSTATE_ACTIVE_TAG: 1;
declare const BODYSTATE_ISLAND_SLEEPING: 2;
declare const BODYSTATE_WANTS_DEACTIVATION: 3;
declare const BODYSTATE_DISABLE_DEACTIVATION: 4;
declare const BODYSTATE_DISABLE_SIMULATION: 5;
declare const BODYGROUP_NONE: 0;
declare const BODYGROUP_DEFAULT: 1;
declare const BODYGROUP_DYNAMIC: 1;
declare const BODYGROUP_STATIC: 2;
declare const BODYGROUP_KINEMATIC: 4;
declare const BODYGROUP_ENGINE_1: 8;
declare const BODYGROUP_TRIGGER: 16;
declare const BODYGROUP_ENGINE_2: 32;
declare const BODYGROUP_ENGINE_3: 64;
declare const BODYGROUP_USER_1: 128;
declare const BODYGROUP_USER_2: 256;
declare const BODYGROUP_USER_3: 512;
declare const BODYGROUP_USER_4: 1024;
declare const BODYGROUP_USER_5: 2048;
declare const BODYGROUP_USER_6: 4096;
declare const BODYGROUP_USER_7: 8192;
declare const BODYGROUP_USER_8: 16384;
declare const BODYMASK_NONE: 0;
declare const BODYMASK_ALL: 65535;
declare const BODYMASK_STATIC: 2;
declare const BODYMASK_NOT_STATIC: number;
declare const BODYMASK_NOT_STATIC_KINEMATIC: number;

/**
 * Always use the application's resolution as the resolution for the {@link ScreenComponent}.
 *
 * @type {string}
 * @category User Interface
 */
declare const SCALEMODE_NONE: string;
/**
 * Scale the {@link ScreenComponent} when the application's resolution is different than the
 * ScreenComponent's referenceResolution.
 *
 * @type {string}
 * @category User Interface
 */
declare const SCALEMODE_BLEND: string;

/**
 * Content does not scroll any further than its bounds.
 *
 * @type {number}
 * @category User Interface
 */
declare const SCROLL_MODE_CLAMP: number;
/**
 * Content scrolls past its bounds and then gently bounces back.
 *
 * @type {number}
 * @category User Interface
 */
declare const SCROLL_MODE_BOUNCE: number;
/**
 * Content can scroll forever.
 *
 * @type {number}
 * @category User Interface
 */
declare const SCROLL_MODE_INFINITE: number;
/**
 * The scrollbar will be visible all the time.
 *
 * @type {number}
 * @category User Interface
 */
declare const SCROLLBAR_VISIBILITY_SHOW_ALWAYS: number;
/**
 * The scrollbar will be visible only when content exceeds the size of the viewport.
 *
 * @type {number}
 * @category User Interface
 */
declare const SCROLLBAR_VISIBILITY_SHOW_WHEN_REQUIRED: number;

/**
 * A {@link SpriteComponent} that displays a single frame from a sprite asset.
 *
 * @type {string}
 * @category Graphics
 */
declare const SPRITETYPE_SIMPLE: string;
/**
 * A {@link SpriteComponent} that renders sprite animations.
 *
 * @type {string}
 * @category Graphics
 */
declare const SPRITETYPE_ANIMATED: string;

/**
 * A stepped interpolation scheme.
 *
 * @type {number}
 * @category Animation
 */
declare const INTERPOLATION_STEP: number;
/**
 * A linear interpolation scheme.
 *
 * @type {number}
 * @category Animation
 */
declare const INTERPOLATION_LINEAR: number;
/**
 * A cubic spline interpolation scheme.
 *
 * @type {number}
 * @category Animation
 */
declare const INTERPOLATION_CUBIC: number;

/**
 * Used to set the anim state graph transition interruption source to no state.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_INTERRUPTION_NONE: string;
/**
 * Used to set the anim state graph transition interruption source as the previous state only.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_INTERRUPTION_PREV: string;
/**
 * Used to set the anim state graph transition interruption source as the next state only.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_INTERRUPTION_NEXT: string;
/**
 * Used to set the anim state graph transition interruption sources as the previous state followed
 * by the next state.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_INTERRUPTION_PREV_NEXT: string;
/**
 * Used to set the anim state graph transition interruption sources as the next state followed by
 * the previous state.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_INTERRUPTION_NEXT_PREV: string;
/**
 * Used to set an anim state graph transition condition predicate as '>'.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_GREATER_THAN: string;
/**
 * Used to set an anim state graph transition condition predicate as '<'.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_LESS_THAN: string;
/**
 * Used to set an anim state graph transition condition predicate as '>='.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_GREATER_THAN_EQUAL_TO: string;
/**
 * Used to set an anim state graph transition condition predicate as '<='.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_LESS_THAN_EQUAL_TO: string;
/**
 * Used to set an anim state graph transition condition predicate as '==='.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_EQUAL_TO: string;
/**
 * Used to set an anim state graph transition condition predicate as '!=='.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_NOT_EQUAL_TO: string;
/**
 * Used to set an anim state graph parameter as type integer.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_PARAMETER_INTEGER: string;
/**
 * Used to set an anim state graph parameter as type float.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_PARAMETER_FLOAT: string;
/**
 * Used to set an anim state graph parameter as type boolean.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_PARAMETER_BOOLEAN: string;
/**
 * Used to set an anim state graph parameter as type trigger.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_PARAMETER_TRIGGER: string;
/**
 * @type {string}
 * @category Animation
 */
declare const ANIM_BLEND_1D: string;
/**
 * @type {string}
 * @category Animation
 */
declare const ANIM_BLEND_2D_DIRECTIONAL: string;
/**
 * @type {string}
 * @category Animation
 */
declare const ANIM_BLEND_2D_CARTESIAN: string;
/**
 * @type {string}
 * @category Animation
 */
declare const ANIM_BLEND_DIRECT: string;
/**
 * The starting state in an anim state graph layer.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_STATE_START: string;
/**
 * The ending state in an anim state graph layer.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_STATE_END: string;
/**
 * Used to indicate any state in an anim state graph layer.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_STATE_ANY: string;
declare const ANIM_CONTROL_STATES: string[];
/**
 * Used to indicate that a layers animations should overwrite all previous layers.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_LAYER_OVERWRITE: string;
/**
 * Used to indicate that a layers animations should blend additively with previous layers.
 *
 * @type {string}
 * @category Animation
 */
declare const ANIM_LAYER_ADDITIVE: string;

declare const ABSOLUTE_URL: RegExp;
/**
 * Asset type name for animation.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_ANIMATION: string;
/**
 * Asset type name for audio.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_AUDIO: string;
/**
 * Asset type name for image.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_IMAGE: string;
/**
 * Asset type name for json.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_JSON: string;
/**
 * Asset type name for model.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_MODEL: string;
/**
 * Asset type name for material.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_MATERIAL: string;
/**
 * Asset type name for text.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_TEXT: string;
/**
 * Asset type name for texture.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_TEXTURE: string;
/**
 * Asset type name for textureatlas.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_TEXTUREATLAS: string;
/**
 * Asset type name for cubemap.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_CUBEMAP: string;
/**
 * Asset type name for shader.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_SHADER: string;
/**
 * Asset type name for CSS.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_CSS: string;
/**
 * Asset type name for HTML.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_HTML: string;
/**
 * Asset type name for script.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_SCRIPT: string;
/**
 * Asset type name for a container.
 *
 * @type {string}
 * @category Asset
 */
declare const ASSET_CONTAINER: string;

declare const FONT_MSDF: "msdf";
declare const FONT_BITMAP: "bitmap";

/**
 * Inline - always available type of session. It has limited features availability and is rendered
 * into HTML element.
 *
 * @type {string}
 * @category XR
 */
declare const XRTYPE_INLINE: string;
/**
 * Immersive VR - session that provides exclusive access to VR device with best available tracking
 * features.
 *
 * @type {string}
 * @category XR
 */
declare const XRTYPE_VR: string;
/**
 * Immersive AR - session that provides exclusive access to VR/AR device that is intended to be
 * blended with real-world environment.
 *
 * @type {string}
 * @category XR
 */
declare const XRTYPE_AR: string;
/**
 * Viewer - always supported space with some basic tracking capabilities.
 *
 * @type {string}
 * @category XR
 */
declare const XRSPACE_VIEWER: string;
/**
 * Local - represents a tracking space with a native origin near the viewer at the time of
 * creation. The exact position and orientation will be initialized based on the conventions of the
 * underlying platform. When using this reference space the user is not expected to move beyond
 * their initial position much, if at all, and tracking is optimized for that purpose. For devices
 * with 6DoF tracking, local reference spaces should emphasize keeping the origin stable relative
 * to the user's environment.
 *
 * @type {string}
 * @category XR
 */
declare const XRSPACE_LOCAL: string;
/**
 * Local Floor - represents a tracking space with a native origin at the floor in a safe position
 * for the user to stand. The y axis equals 0 at floor level, with the x and z position and
 * orientation initialized based on the conventions of the underlying platform. Floor level value
 * might be estimated by the underlying platform. When using this reference space, the user is not
 * expected to move beyond their initial position much, if at all, and tracking is optimized for
 * that purpose. For devices with 6DoF tracking, local-floor reference spaces should emphasize
 * keeping the origin stable relative to the user's environment.
 *
 * @type {string}
 * @category XR
 */
declare const XRSPACE_LOCALFLOOR: string;
/**
 * Bounded Floor - represents a tracking space with its native origin at the floor, where the user
 * is expected to move within a pre-established boundary. Tracking in a bounded-floor reference
 * space is optimized for keeping the native origin and bounds geometry stable relative to the
 * user's environment.
 *
 * @type {string}
 * @category XR
 */
declare const XRSPACE_BOUNDEDFLOOR: string;
/**
 * Unbounded - represents a tracking space where the user is expected to move freely around their
 * environment, potentially even long distances from their starting point. Tracking in an unbounded
 * reference space is optimized for stability around the user's current position, and as such the
 * native origin may drift over time.
 *
 * @type {string}
 * @category XR
 */
declare const XRSPACE_UNBOUNDED: string;
/**
 * Gaze - indicates the target ray will originate at the viewer and follow the direction it is
 * facing. This is commonly referred to as a "gaze input" device in the context of head-mounted
 * displays.
 *
 * @type {string}
 * @category XR
 */
declare const XRTARGETRAY_GAZE: string;
/**
 * Screen - indicates that the input source was an interaction with the canvas element associated
 * with an inline session's output context, such as a mouse click or touch event.
 *
 * @type {string}
 * @category XR
 */
declare const XRTARGETRAY_SCREEN: string;
/**
 * Tracked Pointer - indicates that the target ray originates from either a handheld device or
 * other hand-tracking mechanism and represents that the user is using their hands or the held
 * device for pointing.
 *
 * @type {string}
 * @category XR
 */
declare const XRTARGETRAY_POINTER: string;
/**
 * None - view associated with a monoscopic screen, such as mobile phone screens.
 *
 * @type {string}
 * @category XR
 */
declare const XREYE_NONE: string;
/**
 * Left - view associated with left eye.
 *
 * @type {string}
 * @category XR
 */
declare const XREYE_LEFT: string;
/**
 * Right - view associated with right eye.
 *
 * @type {string}
 * @category XR
 */
declare const XREYE_RIGHT: string;
/**
 * None - input source is not meant to be held in hands.
 *
 * @type {string}
 * @category XR
 */
declare const XRHAND_NONE: string;
/**
 * Left - indicates that input source is meant to be held in left hand.
 *
 * @type {string}
 * @category XR
 */
declare const XRHAND_LEFT: string;
/**
 * Right - indicates that input source is meant to be held in right hand.
 *
 * @type {string}
 * @category XR
 */
declare const XRHAND_RIGHT: string;
/**
 * Point - indicates that the hit test results will be computed based on the feature points
 * detected by the underlying Augmented Reality system.
 *
 * @type {string}
 * @category XR
 */
declare const XRTRACKABLE_POINT: string;
/**
 * Plane - indicates that the hit test results will be computed based on the planes detected by the
 * underlying Augmented Reality system.
 *
 * @type {string}
 * @category XR
 */
declare const XRTRACKABLE_PLANE: string;
/**
 * Mesh - indicates that the hit test results will be computed based on the meshes detected by the
 * underlying Augmented Reality system.
 *
 * @type {string}
 * @category XR
 */
declare const XRTRACKABLE_MESH: string;
/**
 * CPU - indicates that depth sensing preferred usage is CPU. This usage path is guaranteed to be
 * supported.
 *
 * @type {string}
 * @category XR
 */
declare const XRDEPTHSENSINGUSAGE_CPU: string;
/**
 * GPU - indicates that depth sensing preferred usage is GPU.
 *
 * @type {string}
 * @category XR
 */
declare const XRDEPTHSENSINGUSAGE_GPU: string;
/**
 * Luminance Alpha - indicates that depth sensing preferred raw data format is Luminance Alpha.
 * This format is guaranteed to be supported.
 *
 * @type {string}
 * @category XR
 */
declare const XRDEPTHSENSINGFORMAT_L8A8: string;
/**
 * Float 32 - indicates that depth sensing preferred raw data format is Float 32.
 *
 * @type {string}
 * @category XR
 */
declare const XRDEPTHSENSINGFORMAT_F32: string;

/**
 * Get current time in milliseconds. Use it to measure time difference. Reference time may differ
 * on different platforms.
 *
 * @returns {number} The time in milliseconds.
 * @ignore
 */
declare const now: any;

/**
 * 3-dimensional vector.
 *
 * @category Math
 */
declare class Vec3 {
    /**
     * A constant vector set to [0, 0, 0].
     *
     * @type {Vec3}
     * @readonly
     */
    static readonly ZERO: Vec3;
    /**
     * A constant vector set to [1, 1, 1].
     *
     * @type {Vec3}
     * @readonly
     */
    static readonly ONE: Vec3;
    /**
     * A constant vector set to [0, 1, 0].
     *
     * @type {Vec3}
     * @readonly
     */
    static readonly UP: Vec3;
    /**
     * A constant vector set to [0, -1, 0].
     *
     * @type {Vec3}
     * @readonly
     */
    static readonly DOWN: Vec3;
    /**
     * A constant vector set to [1, 0, 0].
     *
     * @type {Vec3}
     * @readonly
     */
    static readonly RIGHT: Vec3;
    /**
     * A constant vector set to [-1, 0, 0].
     *
     * @type {Vec3}
     * @readonly
     */
    static readonly LEFT: Vec3;
    /**
     * A constant vector set to [0, 0, -1].
     *
     * @type {Vec3}
     * @readonly
     */
    static readonly FORWARD: Vec3;
    /**
     * A constant vector set to [0, 0, 1].
     *
     * @type {Vec3}
     * @readonly
     */
    static readonly BACK: Vec3;
    /**
     * Creates a new Vec3 object.
     *
     * @param {number|number[]} [x] - The x value. Defaults to 0. If x is an array of length 3, the
     * array will be used to populate all components.
     * @param {number} [y] - The y value. Defaults to 0.
     * @param {number} [z] - The z value. Defaults to 0.
     * @example
     * const v = new pc.Vec3(1, 2, 3);
     */
    constructor(x?: number | number[], y?: number, z?: number);
    /**
     * The first component of the vector.
     *
     * @type {number}
     */
    x: number;
    /**
     * The second component of the vector.
     *
     * @type {number}
     */
    y: number;
    /**
     * The third component of the vector.
     *
     * @type {number}
     */
    z: number;
    /**
     * Adds a 3-dimensional vector to another in place.
     *
     * @param {Vec3} rhs - The vector to add to the specified vector.
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(10, 10, 10);
     * const b = new pc.Vec3(20, 20, 20);
     *
     * a.add(b);
     *
     * // Outputs [30, 30, 30]
     * console.log("The result of the addition is: " + a.toString());
     */
    add(rhs: Vec3): Vec3;
    /**
     * Adds two 3-dimensional vectors together and returns the result.
     *
     * @param {Vec3} lhs - The first vector operand for the addition.
     * @param {Vec3} rhs - The second vector operand for the addition.
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(10, 10, 10);
     * const b = new pc.Vec3(20, 20, 20);
     * const r = new pc.Vec3();
     *
     * r.add2(a, b);
     * // Outputs [30, 30, 30]
     *
     * console.log("The result of the addition is: " + r.toString());
     */
    add2(lhs: Vec3, rhs: Vec3): Vec3;
    /**
     * Adds a number to each element of a vector.
     *
     * @param {number} scalar - The number to add.
     * @returns {Vec3} Self for chaining.
     * @example
     * const vec = new pc.Vec3(3, 4, 5);
     *
     * vec.addScalar(2);
     *
     * // Outputs [5, 6, 7]
     * console.log("The result of the addition is: " + vec.toString());
     */
    addScalar(scalar: number): Vec3;
    /**
     * Adds a 3-dimensional vector scaled by scalar value. Does not modify the vector being added.
     *
     * @param {Vec3} rhs - The vector to add to the specified vector.
     * @param {number} scalar - The number to multiply the added vector with.
     * @returns {Vec3} Self for chaining.
     * @example
     * const vec = new pc.Vec3(1, 2, 3);
     *
     * vec.addScaled(pc.Vec3.UP, 2);
     *
     * // Outputs [1, 4, 3]
     * console.log("The result of the addition is: " + vec.toString());
     */
    addScaled(rhs: Vec3, scalar: number): Vec3;
    /**
     * Returns an identical copy of the specified 3-dimensional vector.
     *
     * @returns {this} A 3-dimensional vector containing the result of the cloning.
     * @example
     * const v = new pc.Vec3(10, 20, 30);
     * const vclone = v.clone();
     * console.log("The result of the cloning is: " + vclone.toString());
     */
    clone(): this;
    /**
     * Copies the contents of a source 3-dimensional vector to a destination 3-dimensional vector.
     *
     * @param {Vec3} rhs - A vector to copy to the specified vector.
     * @returns {Vec3} Self for chaining.
     * @example
     * const src = new pc.Vec3(10, 20, 30);
     * const dst = new pc.Vec3();
     *
     * dst.copy(src);
     *
     * console.log("The two vectors are " + (dst.equals(src) ? "equal" : "different"));
     */
    copy(rhs: Vec3): Vec3;
    /**
     * Returns the result of a cross product operation performed on the two specified 3-dimensional
     * vectors.
     *
     * @param {Vec3} lhs - The first 3-dimensional vector operand of the cross product.
     * @param {Vec3} rhs - The second 3-dimensional vector operand of the cross product.
     * @returns {Vec3} Self for chaining.
     * @example
     * const back = new pc.Vec3().cross(pc.Vec3.RIGHT, pc.Vec3.UP);
     *
     * // Prints the Z axis (i.e. [0, 0, 1])
     * console.log("The result of the cross product is: " + back.toString());
     */
    cross(lhs: Vec3, rhs: Vec3): Vec3;
    /**
     * Returns the distance between the two specified 3-dimensional vectors.
     *
     * @param {Vec3} rhs - The second 3-dimensional vector to test.
     * @returns {number} The distance between the two vectors.
     * @example
     * const v1 = new pc.Vec3(5, 10, 20);
     * const v2 = new pc.Vec3(10, 20, 40);
     * const d = v1.distance(v2);
     * console.log("The distance between v1 and v2 is: " + d);
     */
    distance(rhs: Vec3): number;
    /**
     * Divides a 3-dimensional vector by another in place.
     *
     * @param {Vec3} rhs - The vector to divide the specified vector by.
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(4, 9, 16);
     * const b = new pc.Vec3(2, 3, 4);
     *
     * a.div(b);
     *
     * // Outputs [2, 3, 4]
     * console.log("The result of the division is: " + a.toString());
     */
    div(rhs: Vec3): Vec3;
    /**
     * Divides one 3-dimensional vector by another and writes the result to the specified vector.
     *
     * @param {Vec3} lhs - The dividend vector (the vector being divided).
     * @param {Vec3} rhs - The divisor vector (the vector dividing the dividend).
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(4, 9, 16);
     * const b = new pc.Vec3(2, 3, 4);
     * const r = new pc.Vec3();
     *
     * r.div2(a, b);
     * // Outputs [2, 3, 4]
     *
     * console.log("The result of the division is: " + r.toString());
     */
    div2(lhs: Vec3, rhs: Vec3): Vec3;
    /**
     * Divides each element of a vector by a number.
     *
     * @param {number} scalar - The number to divide by.
     * @returns {Vec3} Self for chaining.
     * @example
     * const vec = new pc.Vec3(3, 6, 9);
     *
     * vec.divScalar(3);
     *
     * // Outputs [1, 2, 3]
     * console.log("The result of the division is: " + vec.toString());
     */
    divScalar(scalar: number): Vec3;
    /**
     * Returns the result of a dot product operation performed on the two specified 3-dimensional
     * vectors.
     *
     * @param {Vec3} rhs - The second 3-dimensional vector operand of the dot product.
     * @returns {number} The result of the dot product operation.
     * @example
     * const v1 = new pc.Vec3(5, 10, 20);
     * const v2 = new pc.Vec3(10, 20, 40);
     * const v1dotv2 = v1.dot(v2);
     * console.log("The result of the dot product is: " + v1dotv2);
     */
    dot(rhs: Vec3): number;
    /**
     * Reports whether two vectors are equal.
     *
     * @param {Vec3} rhs - The vector to compare to the specified vector.
     * @returns {boolean} True if the vectors are equal and false otherwise.
     * @example
     * const a = new pc.Vec3(1, 2, 3);
     * const b = new pc.Vec3(4, 5, 6);
     * console.log("The two vectors are " + (a.equals(b) ? "equal" : "different"));
     */
    equals(rhs: Vec3): boolean;
    /**
     * Reports whether two vectors are equal using an absolute error tolerance.
     *
     * @param {Vec3} rhs - The vector to be compared against.
     * @param {number} [epsilon] - The maximum difference between each component of the two
     * vectors. Defaults to 1e-6.
     * @returns {boolean} True if the vectors are equal and false otherwise.
     * @example
     * const a = new pc.Vec3();
     * const b = new pc.Vec3();
     * console.log("The two vectors are approximately " + (a.equalsApprox(b, 1e-9) ? "equal" : "different"));
     */
    equalsApprox(rhs: Vec3, epsilon?: number): boolean;
    /**
     * Returns the magnitude of the specified 3-dimensional vector.
     *
     * @returns {number} The magnitude of the specified 3-dimensional vector.
     * @example
     * const vec = new pc.Vec3(3, 4, 0);
     * const len = vec.length();
     * // Outputs 5
     * console.log("The length of the vector is: " + len);
     */
    length(): number;
    /**
     * Returns the magnitude squared of the specified 3-dimensional vector.
     *
     * @returns {number} The magnitude of the specified 3-dimensional vector.
     * @example
     * const vec = new pc.Vec3(3, 4, 0);
     * const len = vec.lengthSq();
     * // Outputs 25
     * console.log("The length squared of the vector is: " + len);
     */
    lengthSq(): number;
    /**
     * Returns the result of a linear interpolation between two specified 3-dimensional vectors.
     *
     * @param {Vec3} lhs - The 3-dimensional to interpolate from.
     * @param {Vec3} rhs - The 3-dimensional to interpolate to.
     * @param {number} alpha - The value controlling the point of interpolation. Between 0 and 1,
     * the linear interpolant will occur on a straight line between lhs and rhs. Outside of this
     * range, the linear interpolant will occur on a ray extrapolated from this line.
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(0, 0, 0);
     * const b = new pc.Vec3(10, 10, 10);
     * const r = new pc.Vec3();
     *
     * r.lerp(a, b, 0);   // r is equal to a
     * r.lerp(a, b, 0.5); // r is 5, 5, 5
     * r.lerp(a, b, 1);   // r is equal to b
     */
    lerp(lhs: Vec3, rhs: Vec3, alpha: number): Vec3;
    /**
     * Multiplies a 3-dimensional vector to another in place.
     *
     * @param {Vec3} rhs - The 3-dimensional vector used as the second multiplicand of the operation.
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(2, 3, 4);
     * const b = new pc.Vec3(4, 5, 6);
     *
     * a.mul(b);
     *
     * // Outputs 8, 15, 24
     * console.log("The result of the multiplication is: " + a.toString());
     */
    mul(rhs: Vec3): Vec3;
    /**
     * Returns the result of multiplying the specified 3-dimensional vectors together.
     *
     * @param {Vec3} lhs - The 3-dimensional vector used as the first multiplicand of the operation.
     * @param {Vec3} rhs - The 3-dimensional vector used as the second multiplicand of the operation.
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(2, 3, 4);
     * const b = new pc.Vec3(4, 5, 6);
     * const r = new pc.Vec3();
     *
     * r.mul2(a, b);
     *
     * // Outputs 8, 15, 24
     * console.log("The result of the multiplication is: " + r.toString());
     */
    mul2(lhs: Vec3, rhs: Vec3): Vec3;
    /**
     * Multiplies each element of a vector by a number.
     *
     * @param {number} scalar - The number to multiply by.
     * @returns {Vec3} Self for chaining.
     * @example
     * const vec = new pc.Vec3(3, 6, 9);
     *
     * vec.mulScalar(3);
     *
     * // Outputs [9, 18, 27]
     * console.log("The result of the multiplication is: " + vec.toString());
     */
    mulScalar(scalar: number): Vec3;
    /**
     * Returns this 3-dimensional vector converted to a unit vector in place. If the vector has a
     * length of zero, the vector's elements will be set to zero.
     *
     * @param {Vec3} [src] - The vector to normalize. If not set, the operation is done in place.
     * @returns {Vec3} Self for chaining.
     * @example
     * const v = new pc.Vec3(25, 0, 0);
     *
     * v.normalize();
     *
     * // Outputs 1, 0, 0
     * console.log("The result of the vector normalization is: " + v.toString());
     */
    normalize(src?: Vec3): Vec3;
    /**
     * Each element is set to the largest integer less than or equal to its value.
     *
     * @param {Vec3} [src] - The vector to floor. If not set, the operation is done in place.
     * @returns {Vec3} Self for chaining.
     */
    floor(src?: Vec3): Vec3;
    /**
     * Each element is rounded up to the next largest integer.
     *
     * @param {Vec3} [src] - The vector to ceil. If not set, the operation is done in place.
     * @returns {Vec3} Self for chaining.
     */
    ceil(src?: Vec3): Vec3;
    /**
     * Each element is rounded up or down to the nearest integer.
     *
     * @param {Vec3} [src] - The vector to round. If not set, the operation is done in place.
     * @returns {Vec3} Self for chaining.
     */
    round(src?: Vec3): Vec3;
    /**
     * Each element is assigned a value from rhs parameter if it is smaller.
     *
     * @param {Vec3} rhs - The 3-dimensional vector used as the source of elements to compare to.
     * @returns {Vec3} Self for chaining.
     */
    min(rhs: Vec3): Vec3;
    /**
     * Each element is assigned a value from rhs parameter if it is larger.
     *
     * @param {Vec3} rhs - The 3-dimensional vector used as the source of elements to compare to.
     * @returns {Vec3} Self for chaining.
     */
    max(rhs: Vec3): Vec3;
    /**
     * Projects this 3-dimensional vector onto the specified vector.
     *
     * @param {Vec3} rhs - The vector onto which the original vector will be projected on.
     * @returns {Vec3} Self for chaining.
     * @example
     * const v = new pc.Vec3(5, 5, 5);
     * const normal = new pc.Vec3(1, 0, 0);
     *
     * v.project(normal);
     *
     * // Outputs 5, 0, 0
     * console.log("The result of the vector projection is: " + v.toString());
     */
    project(rhs: Vec3): Vec3;
    /**
     * Sets the specified 3-dimensional vector to the supplied numerical values.
     *
     * @param {number} x - The value to set on the first component of the vector.
     * @param {number} y - The value to set on the second component of the vector.
     * @param {number} z - The value to set on the third component of the vector.
     * @returns {Vec3} Self for chaining.
     * @example
     * const v = new pc.Vec3();
     * v.set(5, 10, 20);
     *
     * // Outputs 5, 10, 20
     * console.log("The result of the vector set is: " + v.toString());
     */
    set(x: number, y: number, z: number): Vec3;
    /**
     * Subtracts a 3-dimensional vector from another in place.
     *
     * @param {Vec3} rhs - The vector to subtract from the specified vector.
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(10, 10, 10);
     * const b = new pc.Vec3(20, 20, 20);
     *
     * a.sub(b);
     *
     * // Outputs [-10, -10, -10]
     * console.log("The result of the subtraction is: " + a.toString());
     */
    sub(rhs: Vec3): Vec3;
    /**
     * Subtracts two 3-dimensional vectors from one another and returns the result.
     *
     * @param {Vec3} lhs - The first vector operand for the subtraction.
     * @param {Vec3} rhs - The second vector operand for the subtraction.
     * @returns {Vec3} Self for chaining.
     * @example
     * const a = new pc.Vec3(10, 10, 10);
     * const b = new pc.Vec3(20, 20, 20);
     * const r = new pc.Vec3();
     *
     * r.sub2(a, b);
     *
     * // Outputs [-10, -10, -10]
     * console.log("The result of the subtraction is: " + r.toString());
     */
    sub2(lhs: Vec3, rhs: Vec3): Vec3;
    /**
     * Subtracts a number from each element of a vector.
     *
     * @param {number} scalar - The number to subtract.
     * @returns {Vec3} Self for chaining.
     * @example
     * const vec = new pc.Vec3(3, 4, 5);
     *
     * vec.subScalar(2);
     *
     * // Outputs [1, 2, 3]
     * console.log("The result of the subtraction is: " + vec.toString());
     */
    subScalar(scalar: number): Vec3;
    /**
     * Converts the vector to string form.
     *
     * @returns {string} The vector in string form.
     * @example
     * const v = new pc.Vec3(20, 10, 5);
     * // Outputs [20, 10, 5]
     * console.log(v.toString());
     */
    toString(): string;
}

/**
 * An infinite ray.
 *
 * @category Math
 */
declare class Ray {
    /**
     * Creates a new Ray instance. The ray is infinite, starting at a given origin and pointing in
     * a given direction.
     *
     * @param {Vec3} [origin] - The starting point of the ray. The constructor copies
     * this parameter. Defaults to the origin (0, 0, 0).
     * @param {Vec3} [direction] - The direction of the ray. The constructor copies
     * this parameter. Defaults to a direction down the world negative Z axis (0, 0, -1).
     * @example
     * // Create a new ray starting at the position of this entity and pointing down
     * // the entity's negative Z axis
     * const ray = new pc.Ray(this.entity.getPosition(), this.entity.forward);
     */
    constructor(origin?: Vec3, direction?: Vec3);
    /**
     * The starting point of the ray.
     *
     * @readonly
     * @type {Vec3}
     */
    readonly origin: Vec3;
    /**
     * The direction of the ray.
     *
     * @readonly
     * @type {Vec3}
     */
    readonly direction: Vec3;
    /**
     * Sets origin and direction to the supplied vector values.
     *
     * @param {Vec3} origin - The starting point of the ray.
     * @param {Vec3} direction - The direction of the ray.
     * @returns {Ray} Self for chaining.
     */
    set(origin: Vec3, direction: Vec3): Ray;
    /**
     * Copies the contents of a source Ray.
     *
     * @param {Ray} src - The Ray to copy from.
     * @returns {Ray} Self for chaining.
     */
    copy(src: Ray): Ray;
    /**
     * Returns a clone of the Ray.
     *
     * @returns {this} A duplicate Ray.
     */
    clone(): this;
}

/**
 * A bounding sphere is a volume for facilitating fast intersection testing.
 *
 * @category Math
 */
declare class BoundingSphere {
    /**
     * Creates a new BoundingSphere instance.
     *
     * @param {Vec3} [center] - The world space coordinate marking the center of the sphere. The
     * constructor takes a reference of this parameter.
     * @param {number} [radius] - The radius of the bounding sphere. Defaults to 0.5.
     * @example
     * // Create a new bounding sphere centered on the origin with a radius of 0.5
     * const sphere = new pc.BoundingSphere();
     */
    constructor(center?: Vec3, radius?: number);
    /**
     * Center of sphere.
     *
     * @type {Vec3}
     */
    center: Vec3;
    /**
     * The radius of the bounding sphere.
     *
     * @type {number}
     */
    radius: number;
    containsPoint(point: any): boolean;
    /**
     * Test if a ray intersects with the sphere.
     *
     * @param {import('./ray.js').Ray} ray - Ray to test against (direction must be normalized).
     * @param {Vec3} [point] - If there is an intersection, the intersection point will be copied
     * into here.
     * @returns {boolean} True if there is an intersection.
     */
    intersectsRay(ray: Ray, point?: Vec3): boolean;
    /**
     * Test if a Bounding Sphere is overlapping, enveloping, or inside this Bounding Sphere.
     *
     * @param {BoundingSphere} sphere - Bounding Sphere to test.
     * @returns {boolean} True if the Bounding Sphere is overlapping, enveloping, or inside this Bounding Sphere and false otherwise.
     */
    intersectsBoundingSphere(sphere: BoundingSphere): boolean;
}

/**
 * A quaternion.
 *
 * @category Math
 */
declare class Quat {
    /**
     * A constant quaternion set to [0, 0, 0, 1] (the identity).
     *
     * @type {Quat}
     * @readonly
     */
    static readonly IDENTITY: Quat;
    /**
     * A constant quaternion set to [0, 0, 0, 0].
     *
     * @type {Quat}
     * @readonly
     */
    static readonly ZERO: Quat;
    /**
     * Create a new Quat instance.
     *
     * @param {number|number[]} [x] - The quaternion's x component. Defaults to 0. If x is an array
     * of length 4, the array will be used to populate all components.
     * @param {number} [y] - The quaternion's y component. Defaults to 0.
     * @param {number} [z] - The quaternion's z component. Defaults to 0.
     * @param {number} [w] - The quaternion's w component. Defaults to 1.
     */
    constructor(x?: number | number[], y?: number, z?: number, w?: number);
    /**
     * The x component of the quaternion.
     *
     * @type {number}
     */
    x: number;
    /**
     * The y component of the quaternion.
     *
     * @type {number}
     */
    y: number;
    /**
     * The z component of the quaternion.
     *
     * @type {number}
     */
    z: number;
    /**
     * The w component of the quaternion.
     *
     * @type {number}
     */
    w: number;
    /**
     * Returns an identical copy of the specified quaternion.
     *
     * @returns {this} A quaternion containing the result of the cloning.
     * @example
     * const q = new pc.Quat(-0.11, -0.15, -0.46, 0.87);
     * const qclone = q.clone();
     *
     * console.log("The result of the cloning is: " + q.toString());
     */
    clone(): this;
    conjugate(src?: this): this;
    /**
     * Copies the contents of a source quaternion to a destination quaternion.
     *
     * @param {Quat} rhs - The quaternion to be copied.
     * @returns {Quat} Self for chaining.
     * @example
     * const src = new pc.Quat();
     * const dst = new pc.Quat();
     * dst.copy(src, src);
     * console.log("The two quaternions are " + (src.equals(dst) ? "equal" : "different"));
     */
    copy(rhs: Quat): Quat;
    /**
     * Reports whether two quaternions are equal.
     *
     * @param {Quat} rhs - The quaternion to be compared against.
     * @returns {boolean} True if the quaternions are equal and false otherwise.
     * @example
     * const a = new pc.Quat();
     * const b = new pc.Quat();
     * console.log("The two quaternions are " + (a.equals(b) ? "equal" : "different"));
     */
    equals(rhs: Quat): boolean;
    /**
     * Reports whether two quaternions are equal using an absolute error tolerance.
     *
     * @param {Quat} rhs - The quaternion to be compared against.
     * @param {number} [epsilon] - The maximum difference between each component of the two
     * quaternions. Defaults to 1e-6.
     * @returns {boolean} True if the quaternions are equal and false otherwise.
     * @example
     * const a = new pc.Quat();
     * const b = new pc.Quat();
     * console.log("The two quaternions are approximately " + (a.equalsApprox(b, 1e-9) ? "equal" : "different"));
     */
    equalsApprox(rhs: Quat, epsilon?: number): boolean;
    /**
     * Gets the rotation axis and angle for a given quaternion. If a quaternion is created with
     * `setFromAxisAngle`, this method will return the same values as provided in the original
     * parameter list OR functionally equivalent values.
     *
     * @param {Vec3} axis - The 3-dimensional vector to receive the axis of rotation.
     * @returns {number} Angle, in degrees, of the rotation.
     * @example
     * const q = new pc.Quat();
     * q.setFromAxisAngle(new pc.Vec3(0, 1, 0), 90);
     * const v = new pc.Vec3();
     * const angle = q.getAxisAngle(v);
     * // Outputs 90
     * console.log(angle);
     * // Outputs [0, 1, 0]
     * console.log(v.toString());
     */
    getAxisAngle(axis: Vec3): number;
    /**
     * Converts the supplied quaternion to Euler angles.
     *
     * @param {Vec3} [eulers] - The 3-dimensional vector to receive the Euler angles.
     * @returns {Vec3} The 3-dimensional vector holding the Euler angles that
     * correspond to the supplied quaternion.
     */
    getEulerAngles(eulers?: Vec3): Vec3;
    /**
     * Generates the inverse of the specified quaternion.
     *
     * @param {Quat} [src] - The quaternion to invert. If not set, the operation is done in place.
     * @returns {Quat} Self for chaining.
     * @example
     * // Create a quaternion rotated 180 degrees around the y-axis
     * const rot = new pc.Quat().setFromEulerAngles(0, 180, 0);
     *
     * // Invert in place
     * rot.invert();
     */
    invert(src?: Quat): Quat;
    /**
     * Returns the magnitude of the specified quaternion.
     *
     * @returns {number} The magnitude of the specified quaternion.
     * @example
     * const q = new pc.Quat(0, 0, 0, 5);
     * const len = q.length();
     * // Outputs 5
     * console.log("The length of the quaternion is: " + len);
     */
    length(): number;
    /**
     * Returns the magnitude squared of the specified quaternion.
     *
     * @returns {number} The magnitude of the specified quaternion.
     * @example
     * const q = new pc.Quat(3, 4, 0);
     * const lenSq = q.lengthSq();
     * // Outputs 25
     * console.log("The length squared of the quaternion is: " + lenSq);
     */
    lengthSq(): number;
    /**
     * Returns the result of multiplying the specified quaternions together.
     *
     * @param {Quat} rhs - The quaternion used as the second multiplicand of the operation.
     * @returns {Quat} Self for chaining.
     * @example
     * const a = new pc.Quat().setFromEulerAngles(0, 30, 0);
     * const b = new pc.Quat().setFromEulerAngles(0, 60, 0);
     *
     * // a becomes a 90 degree rotation around the Y axis
     * // In other words, a = a * b
     * a.mul(b);
     *
     * console.log("The result of the multiplication is: " + a.toString());
     */
    mul(rhs: Quat): Quat;
    /**
     * Returns the result of multiplying the specified quaternions together.
     *
     * @param {Quat} lhs - The quaternion used as the first multiplicand of the operation.
     * @param {Quat} rhs - The quaternion used as the second multiplicand of the operation.
     * @returns {Quat} Self for chaining.
     * @example
     * const a = new pc.Quat().setFromEulerAngles(0, 30, 0);
     * const b = new pc.Quat().setFromEulerAngles(0, 60, 0);
     * const r = new pc.Quat();
     *
     * // r is set to a 90 degree rotation around the Y axis
     * // In other words, r = a * b
     * r.mul2(a, b);
     *
     * console.log("The result of the multiplication is: " + r.toString());
     */
    mul2(lhs: Quat, rhs: Quat): Quat;
    /**
     * Returns the specified quaternion converted in place to a unit quaternion.
     *
     * @param {Quat} [src] - The quaternion to normalize. If not set, the operation is done in place.
     * @returns {Quat} The result of the normalization.
     * @example
     * const v = new pc.Quat(0, 0, 0, 5);
     *
     * v.normalize();
     *
     * // Outputs 0, 0, 0, 1
     * console.log("The result of the vector normalization is: " + v.toString());
     */
    normalize(src?: Quat): Quat;
    /**
     * Sets the specified quaternion to the supplied numerical values.
     *
     * @param {number} x - The x component of the quaternion.
     * @param {number} y - The y component of the quaternion.
     * @param {number} z - The z component of the quaternion.
     * @param {number} w - The w component of the quaternion.
     * @returns {Quat} Self for chaining.
     * @example
     * const q = new pc.Quat();
     * q.set(1, 0, 0, 0);
     *
     * // Outputs 1, 0, 0, 0
     * console.log("The result of the vector set is: " + q.toString());
     */
    set(x: number, y: number, z: number, w: number): Quat;
    /**
     * Sets a quaternion from an angular rotation around an axis.
     *
     * @param {Vec3} axis - World space axis around which to rotate.
     * @param {number} angle - Angle to rotate around the given axis in degrees.
     * @returns {Quat} Self for chaining.
     * @example
     * const q = new pc.Quat();
     * q.setFromAxisAngle(pc.Vec3.UP, 90);
     */
    setFromAxisAngle(axis: Vec3, angle: number): Quat;
    /**
     * Sets a quaternion from Euler angles specified in XYZ order.
     *
     * @param {number|Vec3} ex - Angle to rotate around X axis in degrees. If ex is a Vec3, the
     * three angles will be read from it instead.
     * @param {number} [ey] - Angle to rotate around Y axis in degrees.
     * @param {number} [ez] - Angle to rotate around Z axis in degrees.
     * @returns {Quat} Self for chaining.
     * @example
     * // Create a quaternion from 3 euler angles
     * const q = new pc.Quat();
     * q.setFromEulerAngles(45, 90, 180);
     *
     * // Create the same quaternion from a vector containing the same 3 euler angles
     * const v = new pc.Vec3(45, 90, 180);
     * const r = new pc.Quat();
     * r.setFromEulerAngles(v);
     */
    setFromEulerAngles(ex: number | Vec3, ey?: number, ez?: number): Quat;
    /**
     * Converts the specified 4x4 matrix to a quaternion. Note that since a quaternion is purely a
     * representation for orientation, only the translational part of the matrix is lost.
     *
     * @param {import('./mat4.js').Mat4} m - The 4x4 matrix to convert.
     * @returns {Quat} Self for chaining.
     * @example
     * // Create a 4x4 rotation matrix of 180 degrees around the y-axis
     * const rot = new pc.Mat4().setFromAxisAngle(pc.Vec3.UP, 180);
     *
     * // Convert to a quaternion
     * const q = new pc.Quat().setFromMat4(rot);
     */
    setFromMat4(m: Mat4): Quat;
    /**
     * Set the quaternion that represents the shortest rotation from one direction to another.
     *
     * @param {Vec3} from - The direction to rotate from. It should be normalized.
     * @param {Vec3} to - The direction to rotate to. It should be normalized.
     * @returns {Quat} Self for chaining.
     *
     * {@link https://www.xarg.org/proof/quaternion-from-two-vectors/ Proof of correctness}
     */
    setFromDirections(from: Vec3, to: Vec3): Quat;
    /**
     * Performs a spherical interpolation between two quaternions. The result of the interpolation
     * is written to the quaternion calling the function.
     *
     * @param {Quat} lhs - The quaternion to interpolate from.
     * @param {Quat} rhs - The quaternion to interpolate to.
     * @param {number} alpha - The value controlling the interpolation in relation to the two input
     * quaternions. The value is in the range 0 to 1, 0 generating q1, 1 generating q2 and anything
     * in between generating a spherical interpolation between the two.
     * @returns {Quat} Self for chaining.
     * @example
     * const q1 = new pc.Quat(-0.11, -0.15, -0.46, 0.87);
     * const q2 = new pc.Quat(-0.21, -0.21, -0.67, 0.68);
     *
     * const result;
     * result = new pc.Quat().slerp(q1, q2, 0);   // Return q1
     * result = new pc.Quat().slerp(q1, q2, 0.5); // Return the midpoint interpolant
     * result = new pc.Quat().slerp(q1, q2, 1);   // Return q2
     */
    slerp(lhs: Quat, rhs: Quat, alpha: number): Quat;
    /**
     * Transforms a 3-dimensional vector by the specified quaternion.
     *
     * @param {Vec3} vec - The 3-dimensional vector to be transformed.
     * @param {Vec3} [res] - An optional 3-dimensional vector to receive the result of the transformation.
     * @returns {Vec3} The input vector v transformed by the current instance.
     * @example
     * // Create a 3-dimensional vector
     * const v = new pc.Vec3(1, 2, 3);
     *
     * // Create a 4x4 rotation matrix
     * const q = new pc.Quat().setFromEulerAngles(10, 20, 30);
     *
     * const tv = q.transformVector(v);
     */
    transformVector(vec: Vec3, res?: Vec3): Vec3;
    /**
     * Converts the quaternion to string form.
     *
     * @returns {string} The quaternion in string form.
     * @example
     * const v = new pc.Quat(0, 0, 0, 1);
     * // Outputs [0, 0, 0, 1]
     * console.log(v.toString());
     */
    toString(): string;
}

/**
 * A 4-dimensional vector.
 *
 * @category Math
 */
declare class Vec4 {
    /**
     * A constant vector set to [0, 0, 0, 0].
     *
     * @type {Vec4}
     * @readonly
     */
    static readonly ZERO: Vec4;
    /**
     * A constant vector set to [1, 1, 1, 1].
     *
     * @type {Vec4}
     * @readonly
     */
    static readonly ONE: Vec4;
    /**
     * Creates a new Vec4 object.
     *
     * @param {number|number[]} [x] - The x value. Defaults to 0. If x is an array of length 4, the
     * array will be used to populate all components.
     * @param {number} [y] - The y value. Defaults to 0.
     * @param {number} [z] - The z value. Defaults to 0.
     * @param {number} [w] - The w value. Defaults to 0.
     * @example
     * const v = new pc.Vec4(1, 2, 3, 4);
     */
    constructor(x?: number | number[], y?: number, z?: number, w?: number);
    /**
     * The first component of the vector.
     *
     * @type {number}
     */
    x: number;
    /**
     * The second component of the vector.
     *
     * @type {number}
     */
    y: number;
    /**
     * The third component of the vector.
     *
     * @type {number}
     */
    z: number;
    /**
     * The fourth component of the vector.
     *
     * @type {number}
     */
    w: number;
    /**
     * Adds a 4-dimensional vector to another in place.
     *
     * @param {Vec4} rhs - The vector to add to the specified vector.
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(10, 10, 10, 10);
     * const b = new pc.Vec4(20, 20, 20, 20);
     *
     * a.add(b);
     *
     * // Outputs [30, 30, 30]
     * console.log("The result of the addition is: " + a.toString());
     */
    add(rhs: Vec4): Vec4;
    /**
     * Adds two 4-dimensional vectors together and returns the result.
     *
     * @param {Vec4} lhs - The first vector operand for the addition.
     * @param {Vec4} rhs - The second vector operand for the addition.
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(10, 10, 10, 10);
     * const b = new pc.Vec4(20, 20, 20, 20);
     * const r = new pc.Vec4();
     *
     * r.add2(a, b);
     * // Outputs [30, 30, 30]
     *
     * console.log("The result of the addition is: " + r.toString());
     */
    add2(lhs: Vec4, rhs: Vec4): Vec4;
    /**
     * Adds a number to each element of a vector.
     *
     * @param {number} scalar - The number to add.
     * @returns {Vec4} Self for chaining.
     * @example
     * const vec = new pc.Vec4(3, 4, 5, 6);
     *
     * vec.addScalar(2);
     *
     * // Outputs [5, 6, 7, 8]
     * console.log("The result of the addition is: " + vec.toString());
     */
    addScalar(scalar: number): Vec4;
    /**
     * Adds a 4-dimensional vector scaled by scalar value. Does not modify the vector being added.
     *
     * @param {Vec4} rhs - The vector to add to the specified vector.
     * @param {number} scalar - The number to multiply the added vector with.
     * @returns {Vec4} Self for chaining.
     * @example
     * const vec = new pc.Vec4(1, 2, 3, 4);
     *
     * vec.addScaled(pc.Vec4.ONE, 2);
     *
     * // Outputs [3, 4, 5, 6]
     * console.log("The result of the addition is: " + vec.toString());
     */
    addScaled(rhs: Vec4, scalar: number): Vec4;
    /**
     * Returns an identical copy of the specified 4-dimensional vector.
     *
     * @returns {this} A 4-dimensional vector containing the result of the cloning.
     * @example
     * const v = new pc.Vec4(10, 20, 30, 40);
     * const vclone = v.clone();
     * console.log("The result of the cloning is: " + vclone.toString());
     */
    clone(): this;
    /**
     * Copies the contents of a source 4-dimensional vector to a destination 4-dimensional vector.
     *
     * @param {Vec4} rhs - A vector to copy to the specified vector.
     * @returns {Vec4} Self for chaining.
     * @example
     * const src = new pc.Vec4(10, 20, 30, 40);
     * const dst = new pc.Vec4();
     *
     * dst.copy(src);
     *
     * console.log("The two vectors are " + (dst.equals(src) ? "equal" : "different"));
     */
    copy(rhs: Vec4): Vec4;
    /**
     * Divides a 4-dimensional vector by another in place.
     *
     * @param {Vec4} rhs - The vector to divide the specified vector by.
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(4, 9, 16, 25);
     * const b = new pc.Vec4(2, 3, 4, 5);
     *
     * a.div(b);
     *
     * // Outputs [2, 3, 4, 5]
     * console.log("The result of the division is: " + a.toString());
     */
    div(rhs: Vec4): Vec4;
    /**
     * Divides one 4-dimensional vector by another and writes the result to the specified vector.
     *
     * @param {Vec4} lhs - The dividend vector (the vector being divided).
     * @param {Vec4} rhs - The divisor vector (the vector dividing the dividend).
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(4, 9, 16, 25);
     * const b = new pc.Vec4(2, 3, 4, 5);
     * const r = new pc.Vec4();
     *
     * r.div2(a, b);
     * // Outputs [2, 3, 4, 5]
     *
     * console.log("The result of the division is: " + r.toString());
     */
    div2(lhs: Vec4, rhs: Vec4): Vec4;
    /**
     * Divides each element of a vector by a number.
     *
     * @param {number} scalar - The number to divide by.
     * @returns {Vec4} Self for chaining.
     * @example
     * const vec = new pc.Vec4(3, 6, 9, 12);
     *
     * vec.divScalar(3);
     *
     * // Outputs [1, 2, 3, 4]
     * console.log("The result of the division is: " + vec.toString());
     */
    divScalar(scalar: number): Vec4;
    /**
     * Returns the result of a dot product operation performed on the two specified 4-dimensional
     * vectors.
     *
     * @param {Vec4} rhs - The second 4-dimensional vector operand of the dot product.
     * @returns {number} The result of the dot product operation.
     * @example
     * const v1 = new pc.Vec4(5, 10, 20, 40);
     * const v2 = new pc.Vec4(10, 20, 40, 80);
     * const v1dotv2 = v1.dot(v2);
     * console.log("The result of the dot product is: " + v1dotv2);
     */
    dot(rhs: Vec4): number;
    /**
     * Reports whether two vectors are equal.
     *
     * @param {Vec4} rhs - The vector to compare to the specified vector.
     * @returns {boolean} True if the vectors are equal and false otherwise.
     * @example
     * const a = new pc.Vec4(1, 2, 3, 4);
     * const b = new pc.Vec4(5, 6, 7, 8);
     * console.log("The two vectors are " + (a.equals(b) ? "equal" : "different"));
     */
    equals(rhs: Vec4): boolean;
    /**
     * Reports whether two vectors are equal using an absolute error tolerance.
     *
     * @param {Vec4} rhs - The vector to be compared against.
     * @param {number} [epsilon] - The maximum difference between each component of the two
     * vectors. Defaults to 1e-6.
     * @returns {boolean} True if the vectors are equal and false otherwise.
     * @example
     * const a = new pc.Vec4();
     * const b = new pc.Vec4();
     * console.log("The two vectors are approximately " + (a.equalsApprox(b, 1e-9) ? "equal" : "different"));
     */
    equalsApprox(rhs: Vec4, epsilon?: number): boolean;
    /**
     * Returns the magnitude of the specified 4-dimensional vector.
     *
     * @returns {number} The magnitude of the specified 4-dimensional vector.
     * @example
     * const vec = new pc.Vec4(3, 4, 0, 0);
     * const len = vec.length();
     * // Outputs 5
     * console.log("The length of the vector is: " + len);
     */
    length(): number;
    /**
     * Returns the magnitude squared of the specified 4-dimensional vector.
     *
     * @returns {number} The magnitude of the specified 4-dimensional vector.
     * @example
     * const vec = new pc.Vec4(3, 4, 0);
     * const len = vec.lengthSq();
     * // Outputs 25
     * console.log("The length squared of the vector is: " + len);
     */
    lengthSq(): number;
    /**
     * Returns the result of a linear interpolation between two specified 4-dimensional vectors.
     *
     * @param {Vec4} lhs - The 4-dimensional to interpolate from.
     * @param {Vec4} rhs - The 4-dimensional to interpolate to.
     * @param {number} alpha - The value controlling the point of interpolation. Between 0 and 1,
     * the linear interpolant will occur on a straight line between lhs and rhs. Outside of this
     * range, the linear interpolant will occur on a ray extrapolated from this line.
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(0, 0, 0, 0);
     * const b = new pc.Vec4(10, 10, 10, 10);
     * const r = new pc.Vec4();
     *
     * r.lerp(a, b, 0);   // r is equal to a
     * r.lerp(a, b, 0.5); // r is 5, 5, 5, 5
     * r.lerp(a, b, 1);   // r is equal to b
     */
    lerp(lhs: Vec4, rhs: Vec4, alpha: number): Vec4;
    /**
     * Multiplies a 4-dimensional vector to another in place.
     *
     * @param {Vec4} rhs - The 4-dimensional vector used as the second multiplicand of the operation.
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(2, 3, 4, 5);
     * const b = new pc.Vec4(4, 5, 6, 7);
     *
     * a.mul(b);
     *
     * // Outputs 8, 15, 24, 35
     * console.log("The result of the multiplication is: " + a.toString());
     */
    mul(rhs: Vec4): Vec4;
    /**
     * Returns the result of multiplying the specified 4-dimensional vectors together.
     *
     * @param {Vec4} lhs - The 4-dimensional vector used as the first multiplicand of the operation.
     * @param {Vec4} rhs - The 4-dimensional vector used as the second multiplicand of the operation.
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(2, 3, 4, 5);
     * const b = new pc.Vec4(4, 5, 6, 7);
     * const r = new pc.Vec4();
     *
     * r.mul2(a, b);
     *
     * // Outputs 8, 15, 24, 35
     * console.log("The result of the multiplication is: " + r.toString());
     */
    mul2(lhs: Vec4, rhs: Vec4): Vec4;
    /**
     * Multiplies each element of a vector by a number.
     *
     * @param {number} scalar - The number to multiply by.
     * @returns {Vec4} Self for chaining.
     * @example
     * const vec = new pc.Vec4(3, 6, 9, 12);
     *
     * vec.mulScalar(3);
     *
     * // Outputs [9, 18, 27, 36]
     * console.log("The result of the multiplication is: " + vec.toString());
     */
    mulScalar(scalar: number): Vec4;
    /**
     * Returns this 4-dimensional vector converted to a unit vector in place. If the vector has a
     * length of zero, the vector's elements will be set to zero.
     *
     * @param {Vec4} [src] - The vector to normalize. If not set, the operation is done in place.
     * @returns {Vec4} Self for chaining.
     * @example
     * const v = new pc.Vec4(25, 0, 0, 0);
     *
     * v.normalize();
     *
     * // Outputs 1, 0, 0, 0
     * console.log("The result of the vector normalization is: " + v.toString());
     */
    normalize(src?: Vec4): Vec4;
    /**
     * Each element is set to the largest integer less than or equal to its value.
     *
     * @param {Vec4} [src] - The vector to floor. If not set, the operation is done in place.
     * @returns {Vec4} Self for chaining.
     */
    floor(src?: Vec4): Vec4;
    /**
     * Each element is rounded up to the next largest integer.
     *
     * @param {Vec4} [src] - The vector to ceil. If not set, the operation is done in place.
     * @returns {Vec4} Self for chaining.
     */
    ceil(src?: Vec4): Vec4;
    /**
     * Each element is rounded up or down to the nearest integer.
     *
     * @param {Vec4} [src] - The vector to round. If not set, the operation is done in place.
     * @returns {Vec4} Self for chaining.
     */
    round(src?: Vec4): Vec4;
    /**
     * Each element is assigned a value from rhs parameter if it is smaller.
     *
     * @param {Vec4} rhs - The 4-dimensional vector used as the source of elements to compare to.
     * @returns {Vec4} Self for chaining.
     */
    min(rhs: Vec4): Vec4;
    /**
     * Each element is assigned a value from rhs parameter if it is larger.
     *
     * @param {Vec4} rhs - The 4-dimensional vector used as the source of elements to compare to.
     * @returns {Vec4} Self for chaining.
     */
    max(rhs: Vec4): Vec4;
    /**
     * Sets the specified 4-dimensional vector to the supplied numerical values.
     *
     * @param {number} x - The value to set on the first component of the vector.
     * @param {number} y - The value to set on the second component of the vector.
     * @param {number} z - The value to set on the third component of the vector.
     * @param {number} w - The value to set on the fourth component of the vector.
     * @returns {Vec4} Self for chaining.
     * @example
     * const v = new pc.Vec4();
     * v.set(5, 10, 20, 40);
     *
     * // Outputs 5, 10, 20, 40
     * console.log("The result of the vector set is: " + v.toString());
     */
    set(x: number, y: number, z: number, w: number): Vec4;
    /**
     * Subtracts a 4-dimensional vector from another in place.
     *
     * @param {Vec4} rhs - The vector to add to the specified vector.
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(10, 10, 10, 10);
     * const b = new pc.Vec4(20, 20, 20, 20);
     *
     * a.sub(b);
     *
     * // Outputs [-10, -10, -10, -10]
     * console.log("The result of the subtraction is: " + a.toString());
     */
    sub(rhs: Vec4): Vec4;
    /**
     * Subtracts two 4-dimensional vectors from one another and returns the result.
     *
     * @param {Vec4} lhs - The first vector operand for the subtraction.
     * @param {Vec4} rhs - The second vector operand for the subtraction.
     * @returns {Vec4} Self for chaining.
     * @example
     * const a = new pc.Vec4(10, 10, 10, 10);
     * const b = new pc.Vec4(20, 20, 20, 20);
     * const r = new pc.Vec4();
     *
     * r.sub2(a, b);
     *
     * // Outputs [-10, -10, -10, -10]
     * console.log("The result of the subtraction is: " + r.toString());
     */
    sub2(lhs: Vec4, rhs: Vec4): Vec4;
    /**
     * Subtracts a number from each element of a vector.
     *
     * @param {number} scalar - The number to subtract.
     * @returns {Vec4} Self for chaining.
     * @example
     * const vec = new pc.Vec4(3, 4, 5, 6);
     *
     * vec.subScalar(2);
     *
     * // Outputs [1, 2, 3, 4]
     * console.log("The result of the subtraction is: " + vec.toString());
     */
    subScalar(scalar: number): Vec4;
    /**
     * Converts the vector to string form.
     *
     * @returns {string} The vector in string form.
     * @example
     * const v = new pc.Vec4(20, 10, 5, 0);
     * // Outputs [20, 10, 5, 0]
     * console.log(v.toString());
     */
    toString(): string;
}

/**
 * A 4x4 matrix.
 *
 * @category Math
 */
declare class Mat4 {
    static _getPerspectiveHalfSize(halfSize: any, fov: any, aspect: any, znear: any, fovIsHorizontal: any): void;
    /**
     * A constant matrix set to the identity.
     *
     * @type {Mat4}
     * @readonly
     */
    static readonly IDENTITY: Mat4;
    /**
     * A constant matrix with all elements set to 0.
     *
     * @type {Mat4}
     * @readonly
     */
    static readonly ZERO: Mat4;
    /**
     * Matrix elements in the form of a flat array.
     *
     * @type {Float32Array}
     */
    data: Float32Array;
    /**
     * Adds the specified 4x4 matrices together and stores the result in the current instance.
     *
     * @param {Mat4} lhs - The 4x4 matrix used as the first operand of the addition.
     * @param {Mat4} rhs - The 4x4 matrix used as the second operand of the addition.
     * @returns {Mat4} Self for chaining.
     * @example
     * const m = new pc.Mat4();
     *
     * m.add2(pc.Mat4.IDENTITY, pc.Mat4.ONE);
     *
     * console.log("The result of the addition is: " + m.toString());
     */
    add2(lhs: Mat4, rhs: Mat4): Mat4;
    /**
     * Adds the specified 4x4 matrix to the current instance.
     *
     * @param {Mat4} rhs - The 4x4 matrix used as the second operand of the addition.
     * @returns {Mat4} Self for chaining.
     * @example
     * const m = new pc.Mat4();
     *
     * m.add(pc.Mat4.ONE);
     *
     * console.log("The result of the addition is: " + m.toString());
     */
    add(rhs: Mat4): Mat4;
    /**
     * Creates a duplicate of the specified matrix.
     *
     * @returns {this} A duplicate matrix.
     * @example
     * const src = new pc.Mat4().setFromEulerAngles(10, 20, 30);
     * const dst = src.clone();
     * console.log("The two matrices are " + (src.equals(dst) ? "equal" : "different"));
     */
    clone(): this;
    /**
     * Copies the contents of a source 4x4 matrix to a destination 4x4 matrix.
     *
     * @param {Mat4} rhs - A 4x4 matrix to be copied.
     * @returns {Mat4} Self for chaining.
     * @example
     * const src = new pc.Mat4().setFromEulerAngles(10, 20, 30);
     * const dst = new pc.Mat4();
     * dst.copy(src);
     * console.log("The two matrices are " + (src.equals(dst) ? "equal" : "different"));
     */
    copy(rhs: Mat4): Mat4;
    /**
     * Reports whether two matrices are equal.
     *
     * @param {Mat4} rhs - The other matrix.
     * @returns {boolean} True if the matrices are equal and false otherwise.
     * @example
     * const a = new pc.Mat4().setFromEulerAngles(10, 20, 30);
     * const b = new pc.Mat4();
     * console.log("The two matrices are " + (a.equals(b) ? "equal" : "different"));
     */
    equals(rhs: Mat4): boolean;
    /**
     * Reports whether the specified matrix is the identity matrix.
     *
     * @returns {boolean} True if the matrix is identity and false otherwise.
     * @example
     * const m = new pc.Mat4();
     * console.log("The matrix is " + (m.isIdentity() ? "identity" : "not identity"));
     */
    isIdentity(): boolean;
    /**
     * Multiplies the specified 4x4 matrices together and stores the result in the current
     * instance.
     *
     * @param {Mat4} lhs - The 4x4 matrix used as the first multiplicand of the operation.
     * @param {Mat4} rhs - The 4x4 matrix used as the second multiplicand of the operation.
     * @returns {Mat4} Self for chaining.
     * @example
     * const a = new pc.Mat4().setFromEulerAngles(10, 20, 30);
     * const b = new pc.Mat4().setFromAxisAngle(pc.Vec3.UP, 180);
     * const r = new pc.Mat4();
     *
     * // r = a * b
     * r.mul2(a, b);
     *
     * console.log("The result of the multiplication is: " + r.toString());
     */
    mul2(lhs: Mat4, rhs: Mat4): Mat4;
    /**
     * Multiplies the specified 4x4 matrices together and stores the result in the current
     * instance. This function assumes the matrices are affine transformation matrices, where the
     * upper left 3x3 elements are a rotation matrix, and the bottom left 3 elements are
     * translation. The rightmost column is assumed to be [0, 0, 0, 1]. The parameters are not
     * verified to be in the expected format. This function is faster than general
     * {@link Mat4#mul2}.
     *
     * @param {Mat4} lhs - The affine transformation 4x4 matrix used as the first multiplicand of
     * the operation.
     * @param {Mat4} rhs - The affine transformation 4x4 matrix used as the second multiplicand of
     * the operation.
     * @returns {Mat4} Self for chaining.
     */
    mulAffine2(lhs: Mat4, rhs: Mat4): Mat4;
    /**
     * Multiplies the current instance by the specified 4x4 matrix.
     *
     * @param {Mat4} rhs - The 4x4 matrix used as the second multiplicand of the operation.
     * @returns {Mat4} Self for chaining.
     * @example
     * const a = new pc.Mat4().setFromEulerAngles(10, 20, 30);
     * const b = new pc.Mat4().setFromAxisAngle(pc.Vec3.UP, 180);
     *
     * // a = a * b
     * a.mul(b);
     *
     * console.log("The result of the multiplication is: " + a.toString());
     */
    mul(rhs: Mat4): Mat4;
    /**
     * Transforms a 3-dimensional point by a 4x4 matrix.
     *
     * @param {Vec3} vec - The 3-dimensional point to be transformed.
     * @param {Vec3} [res] - An optional 3-dimensional point to receive the result of the
     * transformation.
     * @returns {Vec3} The input point v transformed by the current instance.
     * @example
     * // Create a 3-dimensional point
     * const v = new pc.Vec3(1, 2, 3);
     *
     * // Create a 4x4 rotation matrix
     * const m = new pc.Mat4().setFromEulerAngles(10, 20, 30);
     *
     * const tv = m.transformPoint(v);
     */
    transformPoint(vec: Vec3, res?: Vec3): Vec3;
    /**
     * Transforms a 3-dimensional vector by a 4x4 matrix.
     *
     * @param {Vec3} vec - The 3-dimensional vector to be transformed.
     * @param {Vec3} [res] - An optional 3-dimensional vector to receive the result of the
     * transformation.
     * @returns {Vec3} The input vector v transformed by the current instance.
     * @example
     * // Create a 3-dimensional vector
     * const v = new pc.Vec3(1, 2, 3);
     *
     * // Create a 4x4 rotation matrix
     * const m = new pc.Mat4().setFromEulerAngles(10, 20, 30);
     *
     * const tv = m.transformVector(v);
     */
    transformVector(vec: Vec3, res?: Vec3): Vec3;
    /**
     * Transforms a 4-dimensional vector by a 4x4 matrix.
     *
     * @param {Vec4} vec - The 4-dimensional vector to be transformed.
     * @param {Vec4} [res] - An optional 4-dimensional vector to receive the result of the
     * transformation.
     * @returns {Vec4} The input vector v transformed by the current instance.
     * @example
     * // Create an input 4-dimensional vector
     * const v = new pc.Vec4(1, 2, 3, 4);
     *
     * // Create an output 4-dimensional vector
     * const result = new pc.Vec4();
     *
     * // Create a 4x4 rotation matrix
     * const m = new pc.Mat4().setFromEulerAngles(10, 20, 30);
     *
     * m.transformVec4(v, result);
     */
    transformVec4(vec: Vec4, res?: Vec4): Vec4;
    /**
     * Sets the specified matrix to a viewing matrix derived from an eye point, a target point and
     * an up vector. The matrix maps the target point to the negative z-axis and the eye point to
     * the origin, so that when you use a typical projection matrix, the center of the scene maps
     * to the center of the viewport. Similarly, the direction described by the up vector projected
     * onto the viewing plane is mapped to the positive y-axis so that it points upward in the
     * viewport. The up vector must not be parallel to the line of sight from the eye to the
     * reference point.
     *
     * @param {Vec3} position - 3-d vector holding view position.
     * @param {Vec3} target - 3-d vector holding reference point.
     * @param {Vec3} up - 3-d vector holding the up direction.
     * @returns {Mat4} Self for chaining.
     * @example
     * const position = new pc.Vec3(10, 10, 10);
     * const target = new pc.Vec3(0, 0, 0);
     * const up = new pc.Vec3(0, 1, 0);
     * const m = new pc.Mat4().setLookAt(position, target, up);
     */
    setLookAt(position: Vec3, target: Vec3, up: Vec3): Mat4;
    /**
     * Sets the specified matrix to a perspective projection matrix. The function's parameters
     * define the shape of a frustum.
     *
     * @param {number} left - The x-coordinate for the left edge of the camera's projection plane
     * in eye space.
     * @param {number} right - The x-coordinate for the right edge of the camera's projection plane
     * in eye space.
     * @param {number} bottom - The y-coordinate for the bottom edge of the camera's projection
     * plane in eye space.
     * @param {number} top - The y-coordinate for the top edge of the camera's projection plane in
     * eye space.
     * @param {number} znear - The near clip plane in eye coordinates.
     * @param {number} zfar - The far clip plane in eye coordinates.
     * @returns {Mat4} Self for chaining.
     * @example
     * // Create a 4x4 perspective projection matrix
     * const f = pc.Mat4().setFrustum(-2, 2, -1, 1, 1, 1000);
     * @ignore
     */
    setFrustum(left: number, right: number, bottom: number, top: number, znear: number, zfar: number): Mat4;
    /**
     * Sets the specified matrix to a perspective projection matrix. The function's parameters
     * define the shape of a frustum.
     *
     * @param {number} fov - The frustum's field of view in degrees. The fovIsHorizontal parameter
     * controls whether this is a vertical or horizontal field of view. By default, it's a vertical
     * field of view.
     * @param {number} aspect - The aspect ratio of the frustum's projection plane
     * (width / height).
     * @param {number} znear - The near clip plane in eye coordinates.
     * @param {number} zfar - The far clip plane in eye coordinates.
     * @param {boolean} [fovIsHorizontal] - Set to true to treat the fov as horizontal (x-axis) and
     * false for vertical (y-axis). Defaults to false.
     * @returns {Mat4} Self for chaining.
     * @example
     * // Create a 4x4 perspective projection matrix
     * const persp = pc.Mat4().setPerspective(45, 16 / 9, 1, 1000);
     */
    setPerspective(fov: number, aspect: number, znear: number, zfar: number, fovIsHorizontal?: boolean): Mat4;
    /**
     * Sets the specified matrix to an orthographic projection matrix. The function's parameters
     * define the shape of a cuboid-shaped frustum.
     *
     * @param {number} left - The x-coordinate for the left edge of the camera's projection plane
     * in eye space.
     * @param {number} right - The x-coordinate for the right edge of the camera's projection plane
     * in eye space.
     * @param {number} bottom - The y-coordinate for the bottom edge of the camera's projection
     * plane in eye space.
     * @param {number} top - The y-coordinate for the top edge of the camera's projection plane in
     * eye space.
     * @param {number} near - The near clip plane in eye coordinates.
     * @param {number} far - The far clip plane in eye coordinates.
     * @returns {Mat4} Self for chaining.
     * @example
     * // Create a 4x4 orthographic projection matrix
     * const ortho = pc.Mat4().ortho(-2, 2, -2, 2, 1, 1000);
     */
    setOrtho(left: number, right: number, bottom: number, top: number, near: number, far: number): Mat4;
    /**
     * Sets the specified matrix to a rotation matrix equivalent to a rotation around an axis. The
     * axis must be normalized (unit length) and the angle must be specified in degrees.
     *
     * @param {Vec3} axis - The normalized axis vector around which to rotate.
     * @param {number} angle - The angle of rotation in degrees.
     * @returns {Mat4} Self for chaining.
     * @example
     * // Create a 4x4 rotation matrix
     * const rm = new pc.Mat4().setFromAxisAngle(pc.Vec3.UP, 90);
     */
    setFromAxisAngle(axis: Vec3, angle: number): Mat4;
    /**
     * Sets the specified matrix to a translation matrix.
     *
     * @param {number} x - The x-component of the translation.
     * @param {number} y - The y-component of the translation.
     * @param {number} z - The z-component of the translation.
     * @returns {Mat4} Self for chaining.
     * @example
     * // Create a 4x4 translation matrix
     * const tm = new pc.Mat4().setTranslate(10, 10, 10);
     * @ignore
     */
    setTranslate(x: number, y: number, z: number): Mat4;
    /**
     * Sets the specified matrix to a scale matrix.
     *
     * @param {number} x - The x-component of the scale.
     * @param {number} y - The y-component of the scale.
     * @param {number} z - The z-component of the scale.
     * @returns {Mat4} Self for chaining.
     * @example
     * // Create a 4x4 scale matrix
     * const sm = new pc.Mat4().setScale(10, 10, 10);
     * @ignore
     */
    setScale(x: number, y: number, z: number): Mat4;
    /**
     * Sets the specified matrix to a matrix transforming a normalized view volume (in range of
     * -1 .. 1) to their position inside a viewport (in range of 0 .. 1). This encapsulates a
     * scaling to the size of the viewport and a translation to the position of the viewport.
     *
     * @param {number} x - The x-component of the position of the viewport (in 0..1 range).
     * @param {number} y - The y-component of the position of the viewport (in 0..1 range).
     * @param {number} width - The width of the viewport (in 0..1 range).
     * @param {number} height - The height of the viewport (in 0..1 range).
     * @returns {Mat4} Self for chaining.
     * @example
     * // Create a 4x4 viewport matrix which scales normalized view volume to full texture viewport
     * const vm = new pc.Mat4().setViewport(0, 0, 1, 1);
     * @ignore
     */
    setViewport(x: number, y: number, width: number, height: number): Mat4;
    /**
     * Sets the matrix to a reflection matrix, which can be used as a mirror transformation by the
     * plane.
     *
     * @param {Vec3} normal - The normal of the plane to reflect by.
     * @param {number} distance - The distance of plane to reflect by.
     * @returns {Mat4} Self for chaining.
     */
    setReflection(normal: Vec3, distance: number): Mat4;
    /**
     * Sets the matrix to the inverse of a source matrix.
     *
     * @param {Mat4} [src] - The matrix to invert. If not set, the matrix is inverted in-place.
     * @returns {Mat4} Self for chaining.
     * @example
     * // Create a 4x4 rotation matrix of 180 degrees around the y-axis
     * const rot = new pc.Mat4().setFromAxisAngle(pc.Vec3.UP, 180);
     *
     * // Invert in place
     * rot.invert();
     */
    invert(src?: Mat4): Mat4;
    /**
     * Sets matrix data from an array.
     *
     * @param {number[]} src - Source array. Must have 16 values.
     * @returns {Mat4} Self for chaining.
     */
    set(src: number[]): Mat4;
    /**
     * Sets the specified matrix to the identity matrix.
     *
     * @returns {Mat4} Self for chaining.
     * @example
     * m.setIdentity();
     * console.log("The matrix is " + (m.isIdentity() ? "identity" : "not identity"));
     */
    setIdentity(): Mat4;
    /**
     * Sets the specified matrix to the concatenation of a translation, a quaternion rotation and a
     * scale.
     *
     * @param {Vec3} t - A 3-d vector translation.
     * @param {import('./quat.js').Quat} r - A quaternion rotation.
     * @param {Vec3} s - A 3-d vector scale.
     * @returns {Mat4} Self for chaining.
     * @example
     * const t = new pc.Vec3(10, 20, 30);
     * const r = new pc.Quat();
     * const s = new pc.Vec3(2, 2, 2);
     *
     * const m = new pc.Mat4();
     * m.setTRS(t, r, s);
     */
    setTRS(t: Vec3, r: Quat, s: Vec3): Mat4;
    /**
     * Sets the matrix to the transpose of a source matrix.
     *
     * @param {Mat4} [src] - The matrix to transpose. If not set, the matrix is transposed in-place.
     * @returns {Mat4} Self for chaining.
     * @example
     * const m = new pc.Mat4();
     *
     * // Transpose in place
     * m.transpose();
     */
    transpose(src?: Mat4): Mat4;
    /**
     * Extracts the translational component from the specified 4x4 matrix.
     *
     * @param {Vec3} [t] - The vector to receive the translation of the matrix.
     * @returns {Vec3} The translation of the specified 4x4 matrix.
     * @example
     * // Create a 4x4 matrix
     * const m = new pc.Mat4();
     *
     * // Query the translation component
     * const t = new pc.Vec3();
     * m.getTranslation(t);
     */
    getTranslation(t?: Vec3): Vec3;
    /**
     * Extracts the x-axis from the specified 4x4 matrix.
     *
     * @param {Vec3} [x] - The vector to receive the x axis of the matrix.
     * @returns {Vec3} The x-axis of the specified 4x4 matrix.
     * @example
     * // Create a 4x4 matrix
     * const m = new pc.Mat4();
     *
     * // Query the x-axis component
     * const x = new pc.Vec3();
     * m.getX(x);
     */
    getX(x?: Vec3): Vec3;
    /**
     * Extracts the y-axis from the specified 4x4 matrix.
     *
     * @param {Vec3} [y] - The vector to receive the y axis of the matrix.
     * @returns {Vec3} The y-axis of the specified 4x4 matrix.
     * @example
     * // Create a 4x4 matrix
     * const m = new pc.Mat4();
     *
     * // Query the y-axis component
     * const y = new pc.Vec3();
     * m.getY(y);
     */
    getY(y?: Vec3): Vec3;
    /**
     * Extracts the z-axis from the specified 4x4 matrix.
     *
     * @param {Vec3} [z] - The vector to receive the z axis of the matrix.
     * @returns {Vec3} The z-axis of the specified 4x4 matrix.
     * @example
     * // Create a 4x4 matrix
     * const m = new pc.Mat4();
     *
     * // Query the z-axis component
     * const z = new pc.Vec3();
     * m.getZ(z);
     */
    getZ(z?: Vec3): Vec3;
    /**
     * Extracts the scale component from the specified 4x4 matrix.
     *
     * @param {Vec3} [scale] - Vector to receive the scale.
     * @returns {Vec3} The scale in X, Y and Z of the specified 4x4 matrix.
     * @example
     * // Query the scale component
     * const scale = m.getScale();
     */
    getScale(scale?: Vec3): Vec3;
    /**
     * -1 if the the matrix has an odd number of negative scales (mirrored); 1 otherwise.
     *
     * @type {number}
     * @ignore
     */
    get scaleSign(): number;
    /**
     * Sets the specified matrix to a rotation matrix defined by Euler angles. The Euler angles are
     * specified in XYZ order and in degrees.
     *
     * @param {number} ex - Angle to rotate around X axis in degrees.
     * @param {number} ey - Angle to rotate around Y axis in degrees.
     * @param {number} ez - Angle to rotate around Z axis in degrees.
     * @returns {Mat4} Self for chaining.
     * @example
     * const m = new pc.Mat4();
     * m.setFromEulerAngles(45, 90, 180);
     */
    setFromEulerAngles(ex: number, ey: number, ez: number): Mat4;
    /**
     * Extracts the Euler angles equivalent to the rotational portion of the specified matrix. The
     * returned Euler angles are in XYZ order an in degrees.
     *
     * @param {Vec3} [eulers] - A 3-d vector to receive the Euler angles.
     * @returns {Vec3} A 3-d vector containing the Euler angles.
     * @example
     * // Create a 4x4 rotation matrix of 45 degrees around the y-axis
     * const m = new pc.Mat4().setFromAxisAngle(pc.Vec3.UP, 45);
     *
     * const eulers = m.getEulerAngles();
     */
    getEulerAngles(eulers?: Vec3): Vec3;
    /**
     * Converts the specified matrix to string form.
     *
     * @returns {string} The matrix in string form.
     * @example
     * const m = new pc.Mat4();
     * // Outputs [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]
     * console.log(m.toString());
     */
    toString(): string;
}

/**
 * Axis-Aligned Bounding Box.
 *
 * @category Math
 */
declare class BoundingBox {
    /**
     * Compute the min and max bounding values to encapsulate all specified vertices.
     *
     * @param {number[]|Float32Array} vertices - The vertices used to compute the new size for the
     * AABB.
     * @param {Vec3} min - Stored computed min value.
     * @param {Vec3} max - Stored computed max value.
     * @param {number} [numVerts] - Number of vertices to use from the beginning of vertices array.
     * All vertices are used if not specified.
     */
    static computeMinMax(vertices: number[] | Float32Array, min: Vec3, max: Vec3, numVerts?: number): void;
    /**
     * Create a new BoundingBox instance. The bounding box is axis-aligned.
     *
     * @param {Vec3} [center] - Center of box. The constructor takes a reference of this parameter.
     * @param {Vec3} [halfExtents] - Half the distance across the box in each axis. The constructor
     * takes a reference of this parameter. Defaults to 0.5 on each axis.
     */
    constructor(center?: Vec3, halfExtents?: Vec3);
    /**
     * Center of box.
     *
     * @type {Vec3}
     */
    center: Vec3;
    /**
     * Half the distance across the box in each axis.
     *
     * @type {Vec3}
     */
    halfExtents: Vec3;
    /**
     * @type {Vec3}
     * @private
     */
    private _min;
    /**
     * @type {Vec3}
     * @private
     */
    private _max;
    /**
     * Combines two bounding boxes into one, enclosing both.
     *
     * @param {BoundingBox} other - Bounding box to add.
     */
    add(other: BoundingBox): void;
    /**
     * Copies the contents of a source AABB.
     *
     * @param {BoundingBox} src - The AABB to copy from.
     */
    copy(src: BoundingBox): void;
    /**
     * Returns a clone of the AABB.
     *
     * @returns {BoundingBox} A duplicate AABB.
     */
    clone(): BoundingBox;
    /**
     * Test whether two axis-aligned bounding boxes intersect.
     *
     * @param {BoundingBox} other - Bounding box to test against.
     * @returns {boolean} True if there is an intersection.
     */
    intersects(other: BoundingBox): boolean;
    _intersectsRay(ray: any, point: any): boolean;
    _fastIntersectsRay(ray: any): boolean;
    /**
     * Test if a ray intersects with the AABB.
     *
     * @param {import('./ray.js').Ray} ray - Ray to test against (direction must be normalized).
     * @param {Vec3} [point] - If there is an intersection, the intersection point will be copied
     * into here.
     * @returns {boolean} True if there is an intersection.
     */
    intersectsRay(ray: Ray, point?: Vec3): boolean;
    /**
     * Sets the minimum and maximum corner of the AABB. Using this function is faster than
     * assigning min and max separately.
     *
     * @param {Vec3} min - The minimum corner of the AABB.
     * @param {Vec3} max - The maximum corner of the AABB.
     */
    setMinMax(min: Vec3, max: Vec3): void;
    /**
     * Return the minimum corner of the AABB.
     *
     * @returns {Vec3} Minimum corner.
     */
    getMin(): Vec3;
    /**
     * Return the maximum corner of the AABB.
     *
     * @returns {Vec3} Maximum corner.
     */
    getMax(): Vec3;
    /**
     * Test if a point is inside a AABB.
     *
     * @param {Vec3} point - Point to test.
     * @returns {boolean} True if the point is inside the AABB and false otherwise.
     */
    containsPoint(point: Vec3): boolean;
    /**
     * Set an AABB to enclose the specified AABB if it were to be transformed by the specified 4x4
     * matrix.
     *
     * @param {BoundingBox} aabb - Box to transform and enclose.
     * @param {import('../math/mat4.js').Mat4} m - Transformation matrix to apply to source AABB.
     * @param {boolean} ignoreScale - If true is specified, a scale from the matrix is ignored. Defaults to false.
     */
    setFromTransformedAabb(aabb: BoundingBox, m: Mat4, ignoreScale?: boolean): void;
    /**
     * Compute the size of the AABB to encapsulate all specified vertices.
     *
     * @param {number[]|Float32Array} vertices - The vertices used to compute the new size for the
     * AABB.
     * @param {number} [numVerts] - Number of vertices to use from the beginning of vertices array.
     * All vertices are used if not specified.
     */
    compute(vertices: number[] | Float32Array, numVerts?: number): void;
    /**
     * Test if a Bounding Sphere is overlapping, enveloping, or inside this AABB.
     *
     * @param {import('./bounding-sphere.js').BoundingSphere} sphere - Bounding Sphere to test.
     * @returns {boolean} True if the Bounding Sphere is overlapping, enveloping, or inside the
     * AABB and false otherwise.
     */
    intersectsBoundingSphere(sphere: BoundingSphere): boolean;
    _distanceToBoundingSphereSq(sphere: any): number;
    _expand(expandMin: any, expandMax: any): void;
}

/**
 * An infinite plane. Internally it's represented in a parametric equation form:
 * ax + by + cz + distance = 0.
 *
 * @category Math
 */
declare class Plane {
    /**
     * Create a new Plane instance.
     *
     * @param {Vec3} [normal] - Normal of the plane. The constructor copies this parameter. Defaults
     * to {@link Vec3.UP}.
     * @param {number} [distance] - The distance from the plane to the origin, along its normal.
     * Defaults to 0.
     */
    constructor(normal?: Vec3, distance?: number);
    /**
     * The normal of the plane.
     *
     * @readonly
     * @type {Vec3}
     */
    readonly normal: Vec3;
    /**
     * The distance from the plane to the origin, along its normal.
     *
     * @readonly
     * @type {number}
     */
    readonly distance: number;
    /**
     * Sets the plane based on a specified normal and a point on the plane.
     *
     * @param {Vec3} point - The point on the plane.
     * @param {Vec3} normal - The normal of the plane.
     * @returns {Plane} Self for chaining.
     */
    setFromPointNormal(point: Vec3, normal: Vec3): Plane;
    /**
     * Test if the plane intersects between two points.
     *
     * @param {Vec3} start - Start position of line.
     * @param {Vec3} end - End position of line.
     * @param {Vec3} [point] - If there is an intersection, the intersection point will be copied
     * into here.
     * @returns {boolean} True if there is an intersection.
     */
    intersectsLine(start: Vec3, end: Vec3, point?: Vec3): boolean;
    /**
     * Test if a ray intersects with the infinite plane.
     *
     * @param {import('./ray.js').Ray} ray - Ray to test against (direction must be normalized).
     * @param {Vec3} [point] - If there is an intersection, the intersection point will be copied
     * into here.
     * @returns {boolean} True if there is an intersection.
     */
    intersectsRay(ray: Ray, point?: Vec3): boolean;
    /**
     * Copies the contents of a source Plane.
     *
     * @param {Plane} src - The Plane to copy from.
     * @returns {Plane} Self for chaining.
     */
    copy(src: Plane): Plane;
    /**
     * Returns a clone of the Plane.
     *
     * @returns {this} A duplicate Plane.
     */
    clone(): this;
}

declare class ShaderGenerator {
    static begin(): string;
    static end(): string;
    static skinCode(device: any, chunks?: any): any;
    static fogCode(value: any, chunks?: any): any;
    static gammaCode(value: any, chunks?: any): any;
    static tonemapCode(value: any, chunks?: any): any;
}

/**
 * A vertex format is a descriptor that defines the layout of vertex data inside a
 * {@link VertexBuffer}.
 *
 * @property {object[]} elements The vertex attribute elements.
 * @property {string} elements[].name The meaning of the vertex element. This is used to link the
 * vertex data to a shader input. Can be:
 *
 * - {@link SEMANTIC_POSITION}
 * - {@link SEMANTIC_NORMAL}
 * - {@link SEMANTIC_TANGENT}
 * - {@link SEMANTIC_BLENDWEIGHT}
 * - {@link SEMANTIC_BLENDINDICES}
 * - {@link SEMANTIC_COLOR}
 * - {@link SEMANTIC_TEXCOORD0}
 * - {@link SEMANTIC_TEXCOORD1}
 * - {@link SEMANTIC_TEXCOORD2}
 * - {@link SEMANTIC_TEXCOORD3}
 * - {@link SEMANTIC_TEXCOORD4}
 * - {@link SEMANTIC_TEXCOORD5}
 * - {@link SEMANTIC_TEXCOORD6}
 * - {@link SEMANTIC_TEXCOORD7}
 *
 * If vertex data has a meaning other that one of those listed above, use the user-defined
 * semantics: {@link SEMANTIC_ATTR0} to {@link SEMANTIC_ATTR15}.
 * @property {number} elements[].numComponents The number of components of the vertex attribute.
 * Can be 1, 2, 3 or 4.
 * @property {number} elements[].dataType The data type of the attribute. Can be:
 *
 * - {@link TYPE_INT8}
 * - {@link TYPE_UINT8}
 * - {@link TYPE_INT16}
 * - {@link TYPE_UINT16}
 * - {@link TYPE_INT32}
 * - {@link TYPE_UINT32}
 * - {@link TYPE_FLOAT32}
 * - {@link TYPE_FLOAT16}
 * @property {boolean} elements[].normalize If true, vertex attribute data will be mapped from a 0
 * to 255 range down to 0 to 1 when fed to a shader. If false, vertex attribute data is left
 * unchanged. If this property is unspecified, false is assumed.
 * @property {number} elements[].offset The number of initial bytes at the start of a vertex that
 * are not relevant to this attribute.
 * @property {number} elements[].stride The number of total bytes that are between the start of one
 * vertex, and the start of the next.
 * @property {number} elements[].size The size of the attribute in bytes.
 * @category Graphics
 */
declare class VertexFormat {
    /**
     * The {@link VertexFormat} used to store matrices of type {@link Mat4} for hardware instancing.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to create this vertex format.
     *
     * @returns {VertexFormat} The default instancing vertex format.
     */
    static getDefaultInstancingFormat(graphicsDevice: GraphicsDevice): VertexFormat;
    static isElementValid(graphicsDevice: any, elementDesc: any): boolean;
    /**
     * Create a new VertexFormat instance.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this vertex format.
     * @param {object[]} description - An array of vertex attribute descriptions.
     * @param {string} description[].semantic - The meaning of the vertex element. This is used to
     * link the vertex data to a shader input. Can be:
     *
     * - {@link SEMANTIC_POSITION}
     * - {@link SEMANTIC_NORMAL}
     * - {@link SEMANTIC_TANGENT}
     * - {@link SEMANTIC_BLENDWEIGHT}
     * - {@link SEMANTIC_BLENDINDICES}
     * - {@link SEMANTIC_COLOR}
     * - {@link SEMANTIC_TEXCOORD0}
     * - {@link SEMANTIC_TEXCOORD1}
     * - {@link SEMANTIC_TEXCOORD2}
     * - {@link SEMANTIC_TEXCOORD3}
     * - {@link SEMANTIC_TEXCOORD4}
     * - {@link SEMANTIC_TEXCOORD5}
     * - {@link SEMANTIC_TEXCOORD6}
     * - {@link SEMANTIC_TEXCOORD7}
     *
     * If vertex data has a meaning other that one of those listed above, use the user-defined
     * semantics: {@link SEMANTIC_ATTR0} to {@link SEMANTIC_ATTR15}.
     * @param {number} description[].components - The number of components of the vertex attribute.
     * Can be 1, 2, 3 or 4.
     * @param {number} description[].type - The data type of the attribute. Can be:
     *
     * - {@link TYPE_INT8}
     * - {@link TYPE_UINT8}
     * - {@link TYPE_INT16}
     * - {@link TYPE_UINT16}
     * - {@link TYPE_INT32}
     * - {@link TYPE_UINT32}
     * - {@link TYPE_FLOAT16}
     * - {@link TYPE_FLOAT32}
     *
     * @param {boolean} [description[].normalize] - If true, vertex attribute data will be mapped
     * from a 0 to 255 range down to 0 to 1 when fed to a shader. If false, vertex attribute data
     * is left unchanged. If this property is unspecified, false is assumed. This property is
     * ignored when asInt is true.
     * @param {boolean} [description[].asInt] - If true, vertex attribute data will be accessible
     * as integer numbers in shader code. Defaults to false, which means that vertex attribute data
     * will be accessible as floating point numbers. Can be only used with INT and UINT data types.
     * @param {number} [vertexCount] - When specified, vertex format will be set up for
     * non-interleaved format with a specified number of vertices. (example: PPPPNNNNCCCC), where
     * arrays of individual attributes will be stored one right after the other (subject to
     * alignment requirements). Note that in this case, the format depends on the number of
     * vertices, and needs to change when the number of vertices changes. When not specified,
     * vertex format will be interleaved. (example: PNCPNCPNCPNC).
     * @example
     * // Specify 3-component positions (x, y, z)
     * const vertexFormat = new pc.VertexFormat(graphicsDevice, [
     *     { semantic: pc.SEMANTIC_POSITION, components: 3, type: pc.TYPE_FLOAT32 }
     * ]);
     * @example
     * // Specify 2-component positions (x, y), a texture coordinate (u, v) and a vertex color (r, g, b, a)
     * const vertexFormat = new pc.VertexFormat(graphicsDevice, [
     *     { semantic: pc.SEMANTIC_POSITION, components: 2, type: pc.TYPE_FLOAT32 },
     *     { semantic: pc.SEMANTIC_TEXCOORD0, components: 2, type: pc.TYPE_FLOAT32 },
     *     { semantic: pc.SEMANTIC_COLOR, components: 4, type: pc.TYPE_UINT8, normalize: true }
     * ]);
     */
    constructor(graphicsDevice: GraphicsDevice, description: {
        semantic: string;
        components: number;
        type: number;
        normalize?: boolean;
        asInt?: boolean;
    }[], vertexCount?: number);
    device: GraphicsDevice;
    _elements: {
        name: string;
        offset: any;
        stride: any;
        dataType: number;
        numComponents: number;
        normalize: boolean;
        size: number;
        asInt: boolean;
    }[];
    hasUv0: boolean;
    hasUv1: boolean;
    hasColor: boolean;
    hasTangents: boolean;
    verticesByteSize: number;
    vertexCount: number;
    interleaved: boolean;
    instancing: boolean;
    size: number;
    get elements(): {
        name: string;
        offset: any;
        stride: any;
        dataType: number;
        numComponents: number;
        normalize: boolean;
        size: number;
        asInt: boolean;
    }[];
    /**
     * Applies any changes made to the VertexFormat's properties.
     *
     * @private
     */
    private update;
    /**
     * Evaluates hash values for the format allowing fast compare of batching / rendering compatibility.
     *
     * @private
     */
    private _evaluateHash;
    batchingHash: number;
    shaderProcessingHashString: string;
    renderingHashString: string;
    renderingHash: number;
}

/**
 * A vertex buffer is the mechanism via which the application specifies vertex data to the graphics
 * hardware.
 *
 * @category Graphics
 */
declare class VertexBuffer {
    /**
     * Create a new VertexBuffer instance.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this vertex buffer.
     * @param {import('./vertex-format.js').VertexFormat} format - The vertex format of this vertex
     * buffer.
     * @param {number} numVertices - The number of vertices that this vertex buffer will hold.
     * @param {number} [usage] - The usage type of the vertex buffer (see BUFFER_*). Defaults to BUFFER_STATIC.
     * @param {ArrayBuffer} [initialData] - Initial data.
     */
    constructor(graphicsDevice: GraphicsDevice, format: VertexFormat, numVertices: number, usage?: number, initialData?: ArrayBuffer);
    device: GraphicsDevice;
    format: VertexFormat;
    numVertices: number;
    usage: number;
    id: number;
    impl: any;
    numBytes: number;
    storage: ArrayBuffer;
    /**
     * Frees resources associated with this vertex buffer.
     */
    destroy(): void;
    adjustVramSizeTracking(vram: any, size: any): void;
    /**
     * Called when the rendering context was lost. It releases all context related resources.
     *
     * @ignore
     */
    loseContext(): void;
    /**
     * Returns the data format of the specified vertex buffer.
     *
     * @returns {import('./vertex-format.js').VertexFormat} The data format of the specified vertex
     * buffer.
     */
    getFormat(): VertexFormat;
    /**
     * Returns the usage type of the specified vertex buffer. This indicates whether the buffer can
     * be modified once and used many times {@link BUFFER_STATIC}, modified repeatedly and used
     * many times {@link BUFFER_DYNAMIC} or modified once and used at most a few times
     * {@link BUFFER_STREAM}.
     *
     * @returns {number} The usage type of the vertex buffer (see BUFFER_*).
     */
    getUsage(): number;
    /**
     * Returns the number of vertices stored in the specified vertex buffer.
     *
     * @returns {number} The number of vertices stored in the vertex buffer.
     */
    getNumVertices(): number;
    /**
     * Returns a mapped memory block representing the content of the vertex buffer.
     *
     * @returns {ArrayBuffer} An array containing the byte data stored in the vertex buffer.
     */
    lock(): ArrayBuffer;
    /**
     * Notifies the graphics engine that the client side copy of the vertex buffer's memory can be
     * returned to the control of the graphics driver.
     */
    unlock(): void;
    /**
     * Copies data into vertex buffer's memory.
     *
     * @param {ArrayBuffer} [data] - Source data to copy.
     * @returns {boolean} True if function finished successfully, false otherwise.
     */
    setData(data?: ArrayBuffer): boolean;
}

/**
 * An index buffer stores index values into a {@link VertexBuffer}. Indexed graphical primitives
 * can normally utilize less memory that unindexed primitives (if vertices are shared).
 *
 * Typically, index buffers are set on {@link Mesh} objects.
 *
 * @category Graphics
 */
declare class IndexBuffer {
    /**
     * Create a new IndexBuffer instance.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this index buffer.
     * @param {number} format - The type of each index to be stored in the index buffer. Can be:
     *
     * - {@link INDEXFORMAT_UINT8}
     * - {@link INDEXFORMAT_UINT16}
     * - {@link INDEXFORMAT_UINT32}
     * @param {number} numIndices - The number of indices to be stored in the index buffer.
     * @param {number} [usage] - The usage type of the vertex buffer. Can be:
     *
     * - {@link BUFFER_DYNAMIC}
     * - {@link BUFFER_STATIC}
     * - {@link BUFFER_STREAM}
     *
     * Defaults to {@link BUFFER_STATIC}.
     * @param {ArrayBuffer} [initialData] - Initial data. If left unspecified, the index buffer
     * will be initialized to zeros.
     * @example
     * // Create an index buffer holding 3 16-bit indices. The buffer is marked as
     * // static, hinting that the buffer will never be modified.
     * const indices = new UInt16Array([0, 1, 2]);
     * const indexBuffer = new pc.IndexBuffer(graphicsDevice,
     *                                        pc.INDEXFORMAT_UINT16,
     *                                        3,
     *                                        pc.BUFFER_STATIC,
     *                                        indices);
     */
    constructor(graphicsDevice: GraphicsDevice, format: number, numIndices: number, usage?: number, initialData?: ArrayBuffer);
    device: GraphicsDevice;
    format: number;
    numIndices: number;
    usage: number;
    id: number;
    impl: any;
    bytesPerIndex: number;
    numBytes: number;
    storage: ArrayBuffer;
    /**
     * Frees resources associated with this index buffer.
     */
    destroy(): void;
    adjustVramSizeTracking(vram: any, size: any): void;
    /**
     * Called when the rendering context was lost. It releases all context related resources.
     *
     * @ignore
     */
    loseContext(): void;
    /**
     * Returns the data format of the specified index buffer.
     *
     * @returns {number} The data format of the specified index buffer. Can be:
     *
     * - {@link INDEXFORMAT_UINT8}
     * - {@link INDEXFORMAT_UINT16}
     * - {@link INDEXFORMAT_UINT32}
     */
    getFormat(): number;
    /**
     * Returns the number of indices stored in the specified index buffer.
     *
     * @returns {number} The number of indices stored in the specified index buffer.
     */
    getNumIndices(): number;
    /**
     * Gives access to the block of memory that stores the buffer's indices.
     *
     * @returns {ArrayBuffer} A contiguous block of memory where index data can be written to.
     */
    lock(): ArrayBuffer;
    /**
     * Signals that the block of memory returned by a call to the lock function is ready to be
     * given to the graphics hardware. Only unlocked index buffers can be set on the currently
     * active device.
     */
    unlock(): void;
    /**
     * Set preallocated data on the index buffer.
     *
     * @param {ArrayBuffer} data - The index data to set.
     * @returns {boolean} True if the data was set successfully, false otherwise.
     * @ignore
     */
    setData(data: ArrayBuffer): boolean;
    /**
     * Get the appropriate typed array from an index buffer.
     *
     * @returns {Uint8Array|Uint16Array|Uint32Array} The typed array containing the index data.
     * @private
     */
    private _lockTypedArray;
    /**
     * Copies the specified number of elements from data into index buffer. Optimized for
     * performance from both typed array as well as array.
     *
     * @param {Uint8Array|Uint16Array|Uint32Array|number[]} data - The data to write.
     * @param {number} count - The number of indices to write.
     * @ignore
     */
    writeData(data: Uint8Array | Uint16Array | Uint32Array | number[], count: number): void;
    /**
     * Copies index data from index buffer into provided data array.
     *
     * @param {Uint8Array|Uint16Array|Uint32Array|number[]} data - The data array to write to.
     * @returns {number} The number of indices read.
     * @ignore
     */
    readData(data: Uint8Array | Uint16Array | Uint32Array | number[]): number;
}

declare class Version {
    globalId: number;
    revision: number;
    equals(other: any): boolean;
    copy(other: any): void;
    reset(): void;
}

declare class VersionedObject {
    version: Version;
    increment(): void;
}

/**
 * The scope for a variable.
 *
 * @category Graphics
 */
declare class ScopeId {
    /**
     * Create a new ScopeId instance.
     *
     * @param {string} name - The variable name.
     */
    constructor(name: string);
    /**
     * The variable name.
     *
     * @type {string}
     */
    name: string;
    value: any;
    versionObject: VersionedObject;
    toJSON(key: any): any;
    /**
     * Set variable value.
     *
     * @param {*} value - The value.
     */
    setValue(value: any): void;
    /**
     * Get variable value.
     *
     * @returns {*} The value.
     */
    getValue(): any;
}

/**
 * Base class of a simple GPU profiler.
 *
 * @ignore
 */
declare class GpuProfiler {
    /**
     * Profiling slots allocated for the current frame, storing the names of the slots.
     *
     * @type {string[]}
     * @ignore
     */
    frameAllocations: string[];
    /**
     * Map of past frame allocations, indexed by renderVersion
     *
     * @type {Map<number, string[]>}
     * @ignore
     */
    pastFrameAllocations: Map<number, string[]>;
    /**
     * The if enabled in the current frame.
     * @ignore
     */
    _enabled: boolean;
    /**
     * The enable request for the next frame.
     * @ignore
     */
    _enableRequest: boolean;
    /**
     * The time it took to render the last frame on GPU, or 0 if the profiler is not enabled
     * @ignore
     */
    _frameTime: number;
    loseContext(): void;
    /**
     * True to enable the profiler.
     *
     * @type {boolean}
     */
    set enabled(arg: boolean);
    get enabled(): boolean;
    processEnableRequest(): void;
    request(renderVersion: any): void;
    report(renderVersion: any, timings: any): void;
    /**
     * Allocate a slot for GPU timing during the frame. This slot is valid only for the current
     * frame. This allows multiple timers to be used during the frame, each with a unique name.
     * @param {string} name - The name of the slot.
     * @returns {number} The assigned slot index.
     * @ignore
     */
    getSlot(name: string): number;
    /**
     * Number of slots allocated during the frame.
     *
     * @ignore
     */
    get slotCount(): number;
}

/**
 * A base class representing a single per platform buffer.
 *
 * @ignore
 */
declare class DynamicBuffer {
    constructor(device: any);
    /** @type {import('./graphics-device.js').GraphicsDevice} */
    device: GraphicsDevice;
}
/**
 * The DynamicBuffers class provides a dynamic memory allocation system for uniform buffer data,
 * particularly for non-persistent uniform buffers. This class utilizes a bump allocator to
 * efficiently allocate aligned memory space from a set of large buffers managed internally. To
 * utilize this system, the user writes data to CPU-accessible staging buffers. When submitting
 * command buffers that require these buffers, the system automatically uploads the data to the GPU
 * buffers. This approach ensures efficient memory management and smooth data transfer between the
 * CPU and GPU.
 *
 * @ignore
 */
declare class DynamicBuffers {
    /**
     * Create the system of dynamic buffers.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} device - The graphics device.
     * @param {number} bufferSize - The size of the underlying large buffers.
     * @param {number} bufferAlignment - Alignment of each allocation.
     */
    constructor(device: GraphicsDevice, bufferSize: number, bufferAlignment: number);
    /**
     * Allocation size of the underlying buffers.
     *
     * @type {number}
     */
    bufferSize: number;
    /**
     * Internally allocated gpu buffers.
     *
     * @type {DynamicBuffer[]}
     */
    gpuBuffers: DynamicBuffer[];
    /**
     * Internally allocated staging buffers (CPU writable)
     *
     * @type {DynamicBuffer[]}
     */
    stagingBuffers: DynamicBuffer[];
    /**
     * @type {UsedBuffer[]}
     */
    usedBuffers: UsedBuffer[];
    /**
     * @type {UsedBuffer}
     */
    activeBuffer: UsedBuffer;
    device: GraphicsDevice;
    bufferAlignment: number;
    /**
     * Destroy the system of dynamic buffers.
     */
    destroy(): void;
    /**
     * Allocate an aligned space of the given size from a dynamic buffer.
     *
     * @param {DynamicBufferAllocation} allocation - The allocation info to fill.
     * @param {number} size - The size of the allocation.
     */
    alloc(allocation: DynamicBufferAllocation, size: number): void;
    scheduleSubmit(): void;
    submit(): void;
}
/**
 * A container for storing the return values of an allocation function.
 *
 * @ignore
 */
declare class DynamicBufferAllocation {
    /**
     * The storage access to the allocated data in the staging buffer.
     *
     * @type {Int32Array}
     */
    storage: Int32Array;
    /**
     * The gpu buffer this allocation will be copied to.
     *
     * @type {DynamicBuffer}
     */
    gpuBuffer: DynamicBuffer;
    /**
     * Offset in the gpuBuffer where the data will be copied to.
     *
     * @type {number}
     */
    offset: number;
}
/**
 * A container for storing the used areas of a pair of staging and gpu buffers.
 *
 * @ignore
 */
declare class UsedBuffer {
    /** @type {DynamicBuffer} */
    gpuBuffer: DynamicBuffer;
    /** @type {DynamicBuffer} */
    stagingBuffer: DynamicBuffer;
    /**
     * The beginning position of the used area that needs to be copied from staging to to the GPU
     * buffer.
     *
     * @type {number}
     */
    offset: number;
    /**
     * Used byte size of the buffer, from the offset.
     *
     * @type {number}
     */
    size: number;
}

/**
 * A texture is a container for texel data that can be utilized in a fragment shader. Typically,
 * the texel data represents an image that is mapped over geometry.
 *
 * @category Graphics
 */
declare class Texture {
    /**
     * Create a new Texture instance.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this texture.
     * @param {object} [options] - Object for passing optional arguments.
     * @param {string} [options.name] - The name of the texture. Defaults to null.
     * @param {number} [options.width] - The width of the texture in pixels. Defaults to 4.
     * @param {number} [options.height] - The height of the texture in pixels. Defaults to 4.
     * @param {number} [options.depth] - The number of depth slices in a 3D texture (not supported by WebGl1).
     * @param {number} [options.format] - The pixel format of the texture. Can be:
     *
     * - {@link PIXELFORMAT_A8}
     * - {@link PIXELFORMAT_L8}
     * - {@link PIXELFORMAT_LA8}
     * - {@link PIXELFORMAT_RGB565}
     * - {@link PIXELFORMAT_RGBA5551}
     * - {@link PIXELFORMAT_RGBA4}
     * - {@link PIXELFORMAT_RGB8}
     * - {@link PIXELFORMAT_RGBA8}
     * - {@link PIXELFORMAT_DXT1}
     * - {@link PIXELFORMAT_DXT3}
     * - {@link PIXELFORMAT_DXT5}
     * - {@link PIXELFORMAT_RGB16F}
     * - {@link PIXELFORMAT_RGBA16F}
     * - {@link PIXELFORMAT_RGB32F}
     * - {@link PIXELFORMAT_RGBA32F}
     * - {@link PIXELFORMAT_ETC1}
     * - {@link PIXELFORMAT_PVRTC_2BPP_RGB_1}
     * - {@link PIXELFORMAT_PVRTC_2BPP_RGBA_1}
     * - {@link PIXELFORMAT_PVRTC_4BPP_RGB_1}
     * - {@link PIXELFORMAT_PVRTC_4BPP_RGBA_1}
     * - {@link PIXELFORMAT_111110F}
     * - {@link PIXELFORMAT_ASTC_4x4}
     * - {@link PIXELFORMAT_ATC_RGB}
     * - {@link PIXELFORMAT_ATC_RGBA}
     *
     * Defaults to {@link PIXELFORMAT_RGBA8}.
     * @param {string} [options.projection] - The projection type of the texture, used when the
     * texture represents an environment. Can be:
     *
     * - {@link TEXTUREPROJECTION_NONE}
     * - {@link TEXTUREPROJECTION_CUBE}
     * - {@link TEXTUREPROJECTION_EQUIRECT}
     * - {@link TEXTUREPROJECTION_OCTAHEDRAL}
     *
     * Defaults to {@link TEXTUREPROJECTION_CUBE} if options.cubemap is true, otherwise
     * {@link TEXTUREPROJECTION_NONE}.
     * @param {number} [options.minFilter] - The minification filter type to use. Defaults to
     * {@link FILTER_LINEAR_MIPMAP_LINEAR}.
     * @param {number} [options.magFilter] - The magnification filter type to use. Defaults to
     * {@link FILTER_LINEAR}.
     * @param {number} [options.anisotropy] - The level of anisotropic filtering to use. Defaults
     * to 1.
     * @param {number} [options.addressU] - The repeat mode to use in the U direction. Defaults to
     * {@link ADDRESS_REPEAT}.
     * @param {number} [options.addressV] - The repeat mode to use in the V direction. Defaults to
     * {@link ADDRESS_REPEAT}.
     * @param {number} [options.addressW] - The repeat mode to use in the W direction. Defaults to
     * {@link ADDRESS_REPEAT}.
     * @param {boolean} [options.mipmaps] - When enabled try to generate or use mipmaps for this
     * texture. Default is true.
     * @param {boolean} [options.cubemap] - Specifies whether the texture is to be a cubemap.
     * Defaults to false.
     * @param {number} [options.arrayLength] - Specifies whether the texture is to be a 2D texture array.
     * When passed in as undefined or < 1, this is not an array texture. If >= 1, this is an array texture.
     * (not supported by WebGL1). Defaults to undefined.
     * @param {boolean} [options.volume] - Specifies whether the texture is to be a 3D volume
     * (not supported by WebGL1). Defaults to false.
     * @param {string} [options.type] - Specifies the texture type.  Can be:
     *
     * - {@link TEXTURETYPE_DEFAULT}
     * - {@link TEXTURETYPE_RGBM}
     * - {@link TEXTURETYPE_RGBE}
     * - {@link TEXTURETYPE_RGBP}
     * - {@link TEXTURETYPE_SWIZZLEGGGR}
     *
     * Defaults to {@link TEXTURETYPE_DEFAULT}.
     * @param {boolean} [options.fixCubemapSeams] - Specifies whether this cubemap texture requires
     * special seam fixing shader code to look right. Defaults to false.
     * @param {boolean} [options.flipY] - Specifies whether the texture should be flipped in the
     * Y-direction. Only affects textures with a source that is an image, canvas or video element.
     * Does not affect cubemaps, compressed textures or textures set from raw pixel data. Defaults
     * to false.
     * @param {boolean} [options.premultiplyAlpha] - If true, the alpha channel of the texture (if
     * present) is multiplied into the color channels. Defaults to false.
     * @param {boolean} [options.compareOnRead] - When enabled, and if texture format is
     * {@link PIXELFORMAT_DEPTH} or {@link PIXELFORMAT_DEPTHSTENCIL}, hardware PCF is enabled for
     * this texture, and you can get filtered results of comparison using texture() in your shader
     * (not supported by WebGL1). Defaults to false.
     * @param {number} [options.compareFunc] - Comparison function when compareOnRead is enabled
     * (not supported by WebGL1). Can be:
     *
     * - {@link FUNC_LESS}
     * - {@link FUNC_LESSEQUAL}
     * - {@link FUNC_GREATER}
     * - {@link FUNC_GREATEREQUAL}
     * - {@link FUNC_EQUAL}
     * - {@link FUNC_NOTEQUAL}
     *
     * Defaults to {@link FUNC_LESS}.
     * @param {Uint8Array[]|HTMLCanvasElement[]|HTMLImageElement[]|HTMLVideoElement[]|Uint8Array[][]} [options.levels]
     * - Array of Uint8Array or other supported browser interface; or a two-dimensional array
     * of Uint8Array if options.arrayLength is defined and greater than zero.
     * @param {boolean} [options.storage] - Defines if texture can be used as a storage texture by
     * a compute shader. Defaults to false.
     * @example
     * // Create a 8x8x24-bit texture
     * const texture = new pc.Texture(graphicsDevice, {
     *     width: 8,
     *     height: 8,
     *     format: pc.PIXELFORMAT_RGB8
     * });
     *
     * // Fill the texture with a gradient
     * const pixels = texture.lock();
     * const count = 0;
     * for (let i = 0; i < 8; i++) {
     *     for (let j = 0; j < 8; j++) {
     *         pixels[count++] = i * 32;
     *         pixels[count++] = j * 32;
     *         pixels[count++] = 255;
     *     }
     * }
     * texture.unlock();
     */
    constructor(graphicsDevice: GraphicsDevice, options?: {
        name?: string;
        width?: number;
        height?: number;
        depth?: number;
        format?: number;
        projection?: string;
        minFilter?: number;
        magFilter?: number;
        anisotropy?: number;
        addressU?: number;
        addressV?: number;
        addressW?: number;
        mipmaps?: boolean;
        cubemap?: boolean;
        arrayLength?: number;
        volume?: boolean;
        type?: string;
        fixCubemapSeams?: boolean;
        flipY?: boolean;
        premultiplyAlpha?: boolean;
        compareOnRead?: boolean;
        compareFunc?: number;
        levels?: Uint8Array[] | HTMLCanvasElement[] | HTMLImageElement[] | HTMLVideoElement[] | Uint8Array[][];
        storage?: boolean;
    });
    /**
     * The name of the texture.
     *
     * @type {string}
     */
    name: string;
    /** @ignore */
    _gpuSize: number;
    /** @protected */
    protected id: number;
    /** @protected */
    protected _invalid: boolean;
    /** @protected */
    protected _lockedLevel: number;
    /** @protected */
    protected _lockedMode: number;
    /**
     * A render version used to track the last time the texture properties requiring bind group
     * to be updated were changed.
     *
     * @type {number}
     * @ignore
     */
    renderVersionDirty: number;
    /** @protected */
    protected _storage: boolean;
    device: GraphicsDevice;
    _width: number;
    _height: number;
    _format: number;
    _compressed: boolean;
    _integerFormat: boolean;
    _volume: boolean;
    _depth: number;
    _arrayLength: number;
    _cubemap: boolean;
    fixCubemapSeams: boolean;
    _flipY: boolean;
    _premultiplyAlpha: boolean;
    _mipmaps: any;
    _minFilter: number;
    _magFilter: number;
    _anisotropy: number;
    _addressU: number;
    _addressV: number;
    _addressW: number;
    _compareOnRead: boolean;
    _compareFunc: number;
    type: string;
    projection: string;
    impl: any;
    profilerHint: any;
    _levels: Uint8Array[] | HTMLCanvasElement[] | HTMLImageElement[] | HTMLVideoElement[] | Uint8Array[][];
    /**
     * Frees resources associated with this texture.
     */
    destroy(): void;
    /**
     * Resizes the texture. Only supported for render target textures, as it does not resize the
     * existing content of the texture, but only the allocated buffer for rendering into.
     *
     * @param {number} width - The new width of the texture.
     * @param {number} height - The new height of the texture.
     * @param {number} [depth] - The new depth of the texture. Defaults to 1.
     * @ignore
     */
    resize(width: number, height: number, depth?: number): void;
    /**
     * Called when the rendering context was lost. It releases all context related resources.
     *
     * @ignore
     */
    loseContext(): void;
    /**
     * Updates vram size tracking for the texture, size can be positive to add or negative to subtract
     *
     * @ignore
     */
    adjustVramSizeTracking(vram: any, size: any): void;
    propertyChanged(flag: any): void;
    /**
     * Returns number of required mip levels for the texture based on its dimensions and parameters.
     *
     * @ignore
     * @type {number}
     */
    get requiredMipLevels(): number;
    /**
     * Returns the current lock mode. One of:
     *
     * - {@link TEXTURELOCK_NONE}
     * - {@link TEXTURELOCK_READ}
     * - {@link TEXTURELOCK_WRITE}
     *
     * @ignore
     * @type {number}
     */
    get lockedMode(): number;
    /**
     * The minification filter to be applied to the texture. Can be:
     *
     * - {@link FILTER_NEAREST}
     * - {@link FILTER_LINEAR}
     * - {@link FILTER_NEAREST_MIPMAP_NEAREST}
     * - {@link FILTER_NEAREST_MIPMAP_LINEAR}
     * - {@link FILTER_LINEAR_MIPMAP_NEAREST}
     * - {@link FILTER_LINEAR_MIPMAP_LINEAR}
     *
     * @type {number}
     */
    set minFilter(arg: number);
    get minFilter(): number;
    /**
     * The magnification filter to be applied to the texture. Can be:
     *
     * - {@link FILTER_NEAREST}
     * - {@link FILTER_LINEAR}
     *
     * @type {number}
     */
    set magFilter(arg: number);
    get magFilter(): number;
    /**
     * The addressing mode to be applied to the texture horizontally. Can be:
     *
     * - {@link ADDRESS_REPEAT}
     * - {@link ADDRESS_CLAMP_TO_EDGE}
     * - {@link ADDRESS_MIRRORED_REPEAT}
     *
     * @type {number}
     */
    set addressU(arg: number);
    get addressU(): number;
    /**
     * The addressing mode to be applied to the texture vertically. Can be:
     *
     * - {@link ADDRESS_REPEAT}
     * - {@link ADDRESS_CLAMP_TO_EDGE}
     * - {@link ADDRESS_MIRRORED_REPEAT}
     *
     * @type {number}
     */
    set addressV(arg: number);
    get addressV(): number;
    /**
     * The addressing mode to be applied to the 3D texture depth (not supported on WebGL1). Can be:
     *
     * - {@link ADDRESS_REPEAT}
     * - {@link ADDRESS_CLAMP_TO_EDGE}
     * - {@link ADDRESS_MIRRORED_REPEAT}
     *
     * @type {number}
     */
    set addressW(arg: number);
    get addressW(): number;
    /**
     * When enabled, and if texture format is {@link PIXELFORMAT_DEPTH} or
     * {@link PIXELFORMAT_DEPTHSTENCIL}, hardware PCF is enabled for this texture, and you can get
     * filtered results of comparison using texture() in your shader (not supported on WebGL1).
     *
     * @type {boolean}
     */
    set compareOnRead(arg: boolean);
    get compareOnRead(): boolean;
    /**
     * Comparison function when compareOnRead is enabled (not supported on WebGL1). Possible values:
     *
     * - {@link FUNC_LESS}
     * - {@link FUNC_LESSEQUAL}
     * - {@link FUNC_GREATER}
     * - {@link FUNC_GREATEREQUAL}
     * - {@link FUNC_EQUAL}
     * - {@link FUNC_NOTEQUAL}
     *
     * @type {number}
     */
    set compareFunc(arg: number);
    get compareFunc(): number;
    /**
     * Integer value specifying the level of anisotropic to apply to the texture ranging from 1 (no
     * anisotropic filtering) to the {@link GraphicsDevice} property maxAnisotropy.
     *
     * @type {number}
     */
    set anisotropy(arg: number);
    get anisotropy(): number;
    /**
     * Defines if texture should generate/upload mipmaps if possible.
     *
     * @type {boolean}
     */
    set mipmaps(arg: any);
    get mipmaps(): any;
    _needsMipmapsUpload: any;
    /**
     * Defines if texture can be used as a storage texture by a compute shader.
     *
     * @type {boolean}
     */
    get storage(): boolean;
    /**
     * The width of the texture in pixels.
     *
     * @type {number}
     */
    get width(): number;
    /**
     * The height of the texture in pixels.
     *
     * @type {number}
     */
    get height(): number;
    /**
     * The number of depth slices in a 3D texture.
     *
     * @type {number}
     */
    get depth(): number;
    /**
     * The pixel format of the texture. Can be:
     *
     * - {@link PIXELFORMAT_A8}
     * - {@link PIXELFORMAT_L8}
     * - {@link PIXELFORMAT_LA8}
     * - {@link PIXELFORMAT_RGB565}
     * - {@link PIXELFORMAT_RGBA5551}
     * - {@link PIXELFORMAT_RGBA4}
     * - {@link PIXELFORMAT_RGB8}
     * - {@link PIXELFORMAT_RGBA8}
     * - {@link PIXELFORMAT_DXT1}
     * - {@link PIXELFORMAT_DXT3}
     * - {@link PIXELFORMAT_DXT5}
     * - {@link PIXELFORMAT_RGB16F}
     * - {@link PIXELFORMAT_RGBA16F}
     * - {@link PIXELFORMAT_RGB32F}
     * - {@link PIXELFORMAT_RGBA32F}
     * - {@link PIXELFORMAT_ETC1}
     * - {@link PIXELFORMAT_PVRTC_2BPP_RGB_1}
     * - {@link PIXELFORMAT_PVRTC_2BPP_RGBA_1}
     * - {@link PIXELFORMAT_PVRTC_4BPP_RGB_1}
     * - {@link PIXELFORMAT_PVRTC_4BPP_RGBA_1}
     * - {@link PIXELFORMAT_111110F}
     * - {@link PIXELFORMAT_ASTC_4x4}>/li>
     * - {@link PIXELFORMAT_ATC_RGB}
     * - {@link PIXELFORMAT_ATC_RGBA}
     *
     * @type {number}
     */
    get format(): number;
    /**
     * Returns true if this texture is a cube map and false otherwise.
     *
     * @type {boolean}
     */
    get cubemap(): boolean;
    get gpuSize(): number;
    /**
     * Returns true if this texture is a 2D texture array and false otherwise.
     *
     * @type {boolean}
     */
    get array(): boolean;
    /**
     * Returns the number of textures inside this texture if this is a 2D array texture or 0 otherwise.
     *
     * @type {number}
     */
    get arrayLength(): number;
    /**
     * Returns true if this texture is a 3D volume and false otherwise.
     *
     * @type {boolean}
     */
    get volume(): boolean;
    /**
     * Specifies whether the texture should be flipped in the Y-direction. Only affects textures
     * with a source that is an image, canvas or video element. Does not affect cubemaps,
     * compressed textures or textures set from raw pixel data. Defaults to true.
     *
     * @type {boolean}
     */
    set flipY(arg: boolean);
    get flipY(): boolean;
    _needsUpload: boolean;
    set premultiplyAlpha(arg: boolean);
    get premultiplyAlpha(): boolean;
    /**
     * Returns true if all dimensions of the texture are power of two, and false otherwise.
     *
     * @type {boolean}
     */
    get pot(): boolean;
    get encoding(): "srgb" | "linear" | "rgbm" | "rgbe" | "rgbp";
    dirtyAll(): void;
    _levelsUpdated: boolean[] | boolean[][];
    _mipmapsUploaded: boolean;
    /**
     * Locks a miplevel of the texture, returning a typed array to be filled with pixel data.
     *
     * @param {object} [options] - Optional options object. Valid properties are as follows:
     * @param {number} [options.level] - The mip level to lock with 0 being the top level. Defaults
     * to 0.
     * @param {number} [options.face] - If the texture is a cubemap, this is the index of the face
     * to lock.
     * @param {number} [options.mode] - The lock mode. Can be:
     * - {@link TEXTURELOCK_READ}
     * - {@link TEXTURELOCK_WRITE}
     * Defaults to {@link TEXTURELOCK_WRITE}.
     * @returns {Uint8Array|Uint16Array|Float32Array} A typed array containing the pixel data of
     * the locked mip level.
     */
    lock(options?: {
        level?: number;
        face?: number;
        mode?: number;
    }): Uint8Array | Uint16Array | Float32Array;
    /**
     * Set the pixel data of the texture from a canvas, image, video DOM element. If the texture is
     * a cubemap, the supplied source must be an array of 6 canvases, images or videos.
     *
     * @param {HTMLCanvasElement|HTMLImageElement|HTMLVideoElement|HTMLCanvasElement[]|HTMLImageElement[]|HTMLVideoElement[]} source - A
     * canvas, image or video element, or an array of 6 canvas, image or video elements.
     * @param {number} [mipLevel] - A non-negative integer specifying the image level of detail.
     * Defaults to 0, which represents the base image source. A level value of N, that is greater
     * than 0, represents the image source for the Nth mipmap reduction level.
     */
    setSource(source: HTMLCanvasElement | HTMLImageElement | HTMLVideoElement | HTMLCanvasElement[] | HTMLImageElement[] | HTMLVideoElement[], mipLevel?: number): void;
    /**
     * Get the pixel data of the texture. If this is a cubemap then an array of 6 images will be
     * returned otherwise a single image.
     *
     * @param {number} [mipLevel] - A non-negative integer specifying the image level of detail.
     * Defaults to 0, which represents the base image source. A level value of N, that is greater
     * than 0, represents the image source for the Nth mipmap reduction level.
     * @returns {HTMLImageElement} The source image of this texture. Can be null if source not
     * assigned for specific image level.
     */
    getSource(mipLevel?: number): HTMLImageElement;
    /**
     * Unlocks the currently locked mip level and uploads it to VRAM.
     */
    unlock(): void;
    /**
     * Forces a reupload of the textures pixel data to graphics memory. Ordinarily, this function
     * is called by internally by {@link Texture#setSource} and {@link Texture#unlock}. However, it
     * still needs to be called explicitly in the case where an HTMLVideoElement is set as the
     * source of the texture.  Normally, this is done once every frame before video textured
     * geometry is rendered.
     */
    upload(): void;
    /**
     * Download texture's top level data from graphics memory to local memory.
     *
     * @ignore
     */
    downloadAsync(): Promise<void>;
}

/**
 * @ignore
 */
declare class BindBufferFormat {
    constructor(name: any, visibility: any);
    /** @type {string} */
    name: string;
    visibility: any;
}
/**
 * @ignore
 */
declare class BindTextureFormat {
    constructor(name: any, visibility: any, textureDimension?: string, sampleType?: number);
    /** @type {import('./scope-id.js').ScopeId} */
    scopeId: ScopeId;
    /** @type {string} */
    name: string;
    visibility: any;
    textureDimension: string;
    sampleType: number;
}
/**
 * @ignore
 */
declare class BindGroupFormat {
    /**
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this vertex format.
     * @param {BindBufferFormat[]} [bufferFormats] - An array of bind buffer formats (uniform
     * buffers). Defaults to an empty array.
     * @param {BindTextureFormat[]} [textureFormats] - An array of bind texture formats (textures).
     * Defaults to an empty array.
     * @param {BindStorageTextureFormat[]} [storageTextureFormats] - An array of bind storage texture
     * formats (storage textures), used by the compute shader. Defaults to an empty array.
     * @param {object} [options] - Object for passing optional arguments.
     * @param {boolean} [options.compute] - If true, this bind group format is used by the compute
     * shader.
     */
    constructor(graphicsDevice: GraphicsDevice, bufferFormats?: BindBufferFormat[], textureFormats?: BindTextureFormat[], storageTextureFormats?: BindStorageTextureFormat[], options?: {
        compute?: boolean;
    });
    compute: boolean;
    id: number;
    /** @type {import('./graphics-device.js').GraphicsDevice} */
    device: GraphicsDevice;
    /** @type {BindBufferFormat[]} */
    bufferFormats: BindBufferFormat[];
    /** @type {Map<string, number>} */
    bufferFormatsMap: Map<string, number>;
    /** @type {BindTextureFormat[]} */
    textureFormats: BindTextureFormat[];
    /** @type {Map<string, number>} */
    textureFormatsMap: Map<string, number>;
    /** @type {BindStorageTextureFormat[]} */
    storageTextureFormats: BindStorageTextureFormat[];
    /** @type {Map<string, number>} */
    storageTextureFormatsMap: Map<string, number>;
    impl: any;
    /**
     * Frees resources associated with this bind group.
     */
    destroy(): void;
    /**
     * Returns format of texture with specified name.
     *
     * @param {string} name - The name of the texture slot.
     * @returns {BindTextureFormat|null} - The format.
     */
    getTexture(name: string): BindTextureFormat | null;
    /**
     * Returns format of storage texture with specified name.
     *
     * @param {string} name - The name of the texture slot.
     * @returns {BindStorageTextureFormat|null} - The format.
     */
    getStorageTexture(name: string): BindStorageTextureFormat | null;
    getShaderDeclarationTextures(bindGroup: any): string;
    loseContext(): void;
}
/**
 * @ignore
 */
declare class BindStorageTextureFormat {
    constructor(name: any, format?: number, textureDimension?: string);
    /** @type {import('./scope-id.js').ScopeId} */
    scopeId: ScopeId;
    /** @type {string} */
    name: string;
    format: number;
    textureDimension: string;
}

/**
 * The scope for variables.
 *
 * @category Graphics
 */
declare class ScopeSpace {
    /**
     * Create a new ScopeSpace instance.
     *
     * @param {string} name - The scope name.
     */
    constructor(name: string);
    /**
     * The scope name.
     *
     * @type {string}
     */
    name: string;
    variables: Map<any, any>;
    /**
     * Get (or create, if it doesn't already exist) a variable in the scope.
     *
     * @param {string} name - The variable name.
     * @returns {ScopeId} The variable instance.
     */
    resolve(name: string): ScopeId;
    /**
     * Clears value for any uniform with matching value (used to remove deleted textures).
     *
     * @param {*} value - The value to clear.
     * @ignore
     */
    removeValue(value: any): void;
}

/**
 * A class storing description of an individual uniform, stored inside a uniform buffer.
 *
 * @ignore
 */
declare class UniformFormat {
    constructor(name: any, type: any, count?: number);
    /** @type {string} */
    name: string;
    /** @type {number} */
    type: number;
    /** @type {number} */
    byteSize: number;
    /**
     * Index of the uniform in an array of 32bit values (Float32Array and similar)
     *
     * @type {number}
     */
    offset: number;
    /** @type {import('./scope-id.js').ScopeId} */
    scopeId: ScopeId;
    /**
     * Count of elements for arrays, otherwise 0.
     *
     * @type {number}
     */
    count: number;
    /**
     * Number of components in each element (e.g. vec2 has 2 components, mat4 has 16 components)
     *
     * @type {number}
     */
    numComponents: number;
    /**
     * True if this is an array of elements (i.e. count > 0)
     *
     * @type {number}
     */
    get isArrayType(): number;
    shortName: any;
    updateType: any;
    invalid: boolean;
    calculateOffset(offset: any): void;
}
/**
 * A descriptor that defines the layout of of data inside the {@link UniformBuffer}.
 *
 * @ignore
 */
declare class UniformBufferFormat {
    /**
     * Create a new UniformBufferFormat instance.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device.
     * @param {UniformFormat[]} uniforms - An array of uniforms to be stored in the buffer
     */
    constructor(graphicsDevice: GraphicsDevice, uniforms: UniformFormat[]);
    /** @type {number} */
    byteSize: number;
    /** @type {Map<string,UniformFormat>} */
    map: Map<string, UniformFormat>;
    scope: ScopeSpace;
    /** @type {UniformFormat[]} */
    uniforms: UniformFormat[];
    /**
     * Returns format of a uniform with specified name.
     *
     * @param {string} name - The name of the uniform.
     * @returns {UniformFormat} - The format of the uniform.
     */
    get(name: string): UniformFormat;
    getShaderDeclaration(bindGroup: any, bindIndex: any): string;
}

/**
 * A shader is a program that is responsible for rendering graphical primitives on a device's
 * graphics processor. The shader is generated from a shader definition. This shader definition
 * specifies the code for processing vertices and fragments processed by the GPU. The language of
 * the code is GLSL (or more specifically ESSL, the OpenGL ES Shading Language). The shader
 * definition also describes how the PlayCanvas engine should map vertex buffer elements onto the
 * attributes specified in the vertex shader code.
 *
 * @category Graphics
 */
declare class Shader {
    /**
     * Creates a new Shader instance.
     *
     * Consider {@link createShaderFromCode} as a simpler and more powerful way to create
     * a shader.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this shader.
     * @param {object} definition - The shader definition from which to build the shader.
     * @param {string} [definition.name] - The name of the shader.
     * @param {Object<string, string>} [definition.attributes] - Object detailing the mapping of
     * vertex shader attribute names to semantics SEMANTIC_*. This enables the engine to match
     * vertex buffer data as inputs to the shader. When not specified, rendering without
     * vertex buffer is assumed.
     * @param {string} [definition.vshader] - Vertex shader source (GLSL code). Optional when
     * compute shader is specified.
     * @param {string} [definition.fshader] - Fragment shader source (GLSL code). Optional when
     * useTransformFeedback or compute shader is specified.
     * @param {string} [definition.cshader] - Compute shader source (WGSL code). Only supported on
     * WebGPU platform.
     * @param {boolean} [definition.useTransformFeedback] - Specifies that this shader outputs
     * post-VS data to a buffer.
     * @param {string | string[]} [definition.fragmentOutputTypes] - Fragment shader output types,
     * which default to vec4. Passing a string will set the output type for all color attachments.
     * Passing an array will set the output type for each color attachment.
     * @param {string} [definition.shaderLanguage] - Specifies the shader language of vertex and
     * fragment shaders. Defaults to {@link SHADERLANGUAGE_GLSL}.
     * @example
     * // Create a shader that renders primitives with a solid red color
     *
     * // Vertex shader
     * const vshader = `
     * attribute vec3 aPosition;
     *
     * void main(void) {
     *     gl_Position = vec4(aPosition, 1.0);
     * }
     * `;
     *
     * // Fragment shader
     * const fshader = `
     * precision ${graphicsDevice.precision} float;
     *
     * void main(void) {
     *     gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
     * }
     * `;
     *
     * const shaderDefinition = {
     *     attributes: {
     *         aPosition: pc.SEMANTIC_POSITION
     *     },
     *     vshader,
     *     fshader
     * };
     *
     * const shader = new pc.Shader(graphicsDevice, shaderDefinition);
     */
    constructor(graphicsDevice: GraphicsDevice, definition: {
        name?: string;
        attributes?: {
            [x: string]: string;
        };
        vshader?: string;
        fshader?: string;
        cshader?: string;
        useTransformFeedback?: boolean;
        fragmentOutputTypes?: string | string[];
        shaderLanguage?: string;
    });
    /**
     * Format of the uniform buffer for mesh bind group.
     *
     * @type {import('./uniform-buffer-format.js').UniformBufferFormat}
     * @ignore
     */
    meshUniformBufferFormat: UniformBufferFormat;
    /**
     * Format of the bind group for the mesh bind group.
     *
     * @type {import('./bind-group-format.js').BindGroupFormat}
     * @ignore
     */
    meshBindGroupFormat: BindGroupFormat;
    id: number;
    device: GraphicsDevice;
    definition: {
        name?: string;
        attributes?: {
            [x: string]: string;
        };
        vshader?: string;
        fshader?: string;
        cshader?: string;
        useTransformFeedback?: boolean;
        fragmentOutputTypes?: string | string[];
        shaderLanguage?: string;
    };
    name: string;
    impl: any;
    /**
     * Initialize a shader back to its default state.
     *
     * @private
     */
    private init;
    ready: boolean;
    failed: boolean;
    /** @ignore */
    get label(): string;
    /**
     * Frees resources associated with this shader.
     */
    destroy(): void;
    /**
     * Called when the WebGL context was lost. It releases all context related resources.
     *
     * @ignore
     */
    loseContext(): void;
    /** @ignore */
    restoreContext(): void;
}

/**
 * A render target is a rectangular rendering surface.
 *
 * @category Graphics
 */
declare class RenderTarget {
    /**
     * Creates a new RenderTarget instance. A color buffer or a depth buffer must be set.
     *
     * @param {object} [options] - Object for passing optional arguments.
     * @param {boolean} [options.autoResolve] - If samples > 1, enables or disables automatic MSAA
     * resolve after rendering to this RT (see {@link RenderTarget#resolve}). Defaults to true.
     * @param {import('./texture.js').Texture} [options.colorBuffer] - The texture that this render
     * target will treat as a rendering surface.
     * @param {import('./texture.js').Texture[]} [options.colorBuffers] - The textures that this
     * render target will treat as a rendering surfaces. If this option is set, the colorBuffer
     * option is ignored. This option can be used only when {@link GraphicsDevice#supportsMrt} is
     * true.
     * @param {boolean} [options.depth] - If set to true, depth buffer will be created. Defaults to
     * true. Ignored if depthBuffer is defined.
     * @param {import('./texture.js').Texture} [options.depthBuffer] - The texture that this render
     * target will treat as a depth/stencil surface (WebGL2 only). If set, the 'depth' and
     * 'stencil' properties are ignored. Texture must have {@link PIXELFORMAT_DEPTH} or
     * {@link PIXELFORMAT_DEPTHSTENCIL} format.
     * @param {number} [options.face] - If the colorBuffer parameter is a cubemap, use this option
     * to specify the face of the cubemap to render to. Can be:
     *
     * - {@link CUBEFACE_POSX}
     * - {@link CUBEFACE_NEGX}
     * - {@link CUBEFACE_POSY}
     * - {@link CUBEFACE_NEGY}
     * - {@link CUBEFACE_POSZ}
     * - {@link CUBEFACE_NEGZ}
     *
     * Defaults to {@link CUBEFACE_POSX}.
     * @param {boolean} [options.flipY] - When set to true the image will be flipped in Y. Default
     * is false.
     * @param {string} [options.name] - The name of the render target.
     * @param {number} [options.samples] - Number of hardware anti-aliasing samples (not supported
     * on WebGL1). Default is 1.
     * @param {boolean} [options.stencil] - If set to true, depth buffer will include stencil.
     * Defaults to false. Ignored if depthBuffer is defined or depth is false.
     * @example
     * // Create a 512x512x24-bit render target with a depth buffer
     * const colorBuffer = new pc.Texture(graphicsDevice, {
     *     width: 512,
     *     height: 512,
     *     format: pc.PIXELFORMAT_RGB8
     * });
     * const renderTarget = new pc.RenderTarget({
     *     colorBuffer: colorBuffer,
     *     depth: true
     * });
     *
     * // Set the render target on a camera component
     * camera.renderTarget = renderTarget;
     *
     * // Destroy render target at a later stage. Note that the color buffer needs
     * // to be destroyed separately.
     * renderTarget.colorBuffer.destroy();
     * renderTarget.destroy();
     * camera.renderTarget = null;
     */
    constructor(options?: {
        autoResolve?: boolean;
        colorBuffer?: Texture;
        colorBuffers?: Texture[];
        depth?: boolean;
        depthBuffer?: Texture;
        face?: number;
        flipY?: boolean;
        name?: string;
        samples?: number;
        stencil?: boolean;
    }, ...args: any[]);
    /**
     * The name of the render target.
     *
     * @type {string}
     */
    name: string;
    /**
     * @type {import('./graphics-device.js').GraphicsDevice}
     * @private
     */
    private _device;
    /**
     * @type {import('./texture.js').Texture}
     * @private
     */
    private _colorBuffer;
    /**
     * @type {import('./texture.js').Texture[]}
     * @private
     */
    private _colorBuffers;
    /**
     * @type {import('./texture.js').Texture}
     * @private
     */
    private _depthBuffer;
    /**
     * @type {boolean}
     * @private
     */
    private _depth;
    /**
     * @type {boolean}
     * @private
     */
    private _stencil;
    /**
     * @type {number}
     * @private
     */
    private _samples;
    /** @type {boolean} */
    autoResolve: boolean;
    /**
     * @type {number}
     * @private
     */
    private _face;
    /** @type {boolean} */
    flipY: boolean;
    id: number;
    impl: any;
    /**
     * Frees resources associated with this render target.
     */
    destroy(): void;
    /**
     * Free device resources associated with this render target.
     *
     * @ignore
     */
    destroyFrameBuffers(): void;
    /**
     * Free textures associated with this render target.
     *
     * @ignore
     */
    destroyTextureBuffers(): void;
    /**
     * Resizes the render target to the specified width and height. Internally this resizes all the
     * assigned texture color and depth buffers.
     *
     * @param {number} width - The width of the render target in pixels.
     * @param {number} height - The height of the render target in pixels.
     */
    resize(width: number, height: number): void;
    validateMrt(): void;
    /**
     * Initializes the resources associated with this render target.
     *
     * @ignore
     */
    init(): void;
    /** @ignore */
    get initialized(): any;
    /** @ignore */
    get device(): GraphicsDevice;
    /**
     * Called when the device context was lost. It releases all context related resources.
     *
     * @ignore
     */
    loseContext(): void;
    /**
     * If samples > 1, resolves the anti-aliased render target (WebGL2 only). When you're rendering
     * to an anti-aliased render target, pixels aren't written directly to the readable texture.
     * Instead, they're first written to a MSAA buffer, where each sample for each pixel is stored
     * independently. In order to read the results, you first need to 'resolve' the buffer - to
     * average all samples and create a simple texture with one color per pixel. This function
     * performs this averaging and updates the colorBuffer and the depthBuffer. If autoResolve is
     * set to true, the resolve will happen after every rendering to this render target, otherwise
     * you can do it manually, during the app update or inside a {@link Command}.
     *
     * @param {boolean} [color] - Resolve color buffer. Defaults to true.
     * @param {boolean} [depth] - Resolve depth buffer. Defaults to true if the render target has a
     * depth buffer.
     */
    resolve(color?: boolean, depth?: boolean): void;
    /**
     * Copies color and/or depth contents of source render target to this one. Formats, sizes and
     * anti-aliasing samples must match. Depth buffer can only be copied on WebGL 2.0.
     *
     * @param {RenderTarget} source - Source render target to copy from.
     * @param {boolean} [color] - If true will copy the color buffer. Defaults to false.
     * @param {boolean} [depth] - If true will copy the depth buffer. Defaults to false.
     * @returns {boolean} True if the copy was successful, false otherwise.
     */
    copy(source: RenderTarget, color?: boolean, depth?: boolean): boolean;
    /**
     * Number of antialiasing samples the render target uses.
     *
     * @type {number}
     */
    get samples(): number;
    /**
     * True if the render target contains the depth attachment.
     *
     * @type {boolean}
     */
    get depth(): boolean;
    /**
     * True if the render target contains the stencil attachment.
     *
     * @type {boolean}
     */
    get stencil(): boolean;
    /**
     * Color buffer set up on the render target.
     *
     * @type {import('./texture.js').Texture}
     */
    get colorBuffer(): Texture;
    /**
     * Accessor for multiple render target color buffers.
     *
     * @param {*} index - Index of the color buffer to get.
     * @returns {import('./texture.js').Texture} - Color buffer at the specified index.
     */
    getColorBuffer(index: any): Texture;
    /**
     * Depth buffer set up on the render target. Only available, if depthBuffer was set in
     * constructor. Not available if depth property was used instead.
     *
     * @type {import('./texture.js').Texture}
     */
    get depthBuffer(): Texture;
    /**
     * If the render target is bound to a cubemap, this property specifies which face of the
     * cubemap is rendered to. Can be:
     *
     * - {@link CUBEFACE_POSX}
     * - {@link CUBEFACE_NEGX}
     * - {@link CUBEFACE_POSY}
     * - {@link CUBEFACE_NEGY}
     * - {@link CUBEFACE_POSZ}
     * - {@link CUBEFACE_NEGZ}
     *
     * @type {number}
     */
    get face(): number;
    /**
     * Width of the render target in pixels.
     *
     * @type {number}
     */
    get width(): number;
    /**
     * Height of the render target in pixels.
     *
     * @type {number}
     */
    get height(): number;
}

/**
 * Event Handle that is created by {@link EventHandler} and can be used for easier event removal and management.
 * @example
 * const evt = obj.on('test', (a, b) => {
 *     console.log(a + b);
 * });
 * obj.fire('test');
 *
 * evt.off(); // easy way to remove this event
 * obj.fire('test'); // this will not trigger an event
 * @example
 * // store an array of event handles
 * let events = [ ];
 *
 * events.push(objA.on('testA', () => { }));
 * events.push(objB.on('testB', () => { }));
 *
 * // when needed, remove all events
 * events.forEach((evt) => {
 *     evt.off();
 * });
 * events = [ ];
 */
declare class EventHandle {
    /**
     * @param {import('./event-handler.js').EventHandler} handler - source object of the event.
     * @param {string} name - Name of the event.
     * @param {import('./event-handler.js').HandleEventCallback} callback - Function that is called when event is fired.
     * @param {object} scope - Object that is used as `this` when event is fired.
     * @param {boolean} [once] - If this is a single event and will be removed after event is fired.
     */
    constructor(handler: EventHandler, name: string, callback: HandleEventCallback, scope: object, once?: boolean);
    /**
     * @type {import('./event-handler.js').EventHandler}
     * @private
     */
    private handler;
    /**
     * @type {string}
     * @private
     */
    private name;
    /**
     * @type {import('./event-handler.js').HandleEventCallback}
     * @ignore
     */
    callback: HandleEventCallback;
    /**
     * @type {object}
     * @ignore
     */
    scope: object;
    /**
     * @type {boolean}
     * @ignore
     */
    _once: boolean;
    /**
     * True if event has been removed.
     * @type {boolean}
     * @private
     */
    private _removed;
    /**
     * Remove this event from its handler.
     */
    off(): void;
    on(name: any, callback: any, scope?: this): EventHandle;
    once(name: any, callback: any, scope?: this): EventHandle;
    /**
     * Mark if event has been removed.
     * @type {boolean}
     * @ignore
     */
    set removed(arg: boolean);
    /**
     * True if event has been removed.
     * @type {boolean}
     */
    get removed(): boolean;
}

/**
 * Callback used by {@link EventHandler } functions. Note the callback is limited to 8 arguments.
 */
export type HandleEventCallback = (arg1?: any, arg2?: any, arg3?: any, arg4?: any, arg5?: any, arg6?: any, arg7?: any, arg8?: any) => any;
/**
 * Callback used by {@link EventHandler} functions. Note the callback is limited to 8 arguments.
 *
 * @callback HandleEventCallback
 * @param {*} [arg1] - First argument that is passed from caller.
 * @param {*} [arg2] - Second argument that is passed from caller.
 * @param {*} [arg3] - Third argument that is passed from caller.
 * @param {*} [arg4] - Fourth argument that is passed from caller.
 * @param {*} [arg5] - Fifth argument that is passed from caller.
 * @param {*} [arg6] - Sixth argument that is passed from caller.
 * @param {*} [arg7] - Seventh argument that is passed from caller.
 * @param {*} [arg8] - Eighth argument that is passed from caller.
 */
/**
 * Abstract base class that implements functionality for event handling.
 *
 * ```javascript
 * const obj = new EventHandlerSubclass();
 *
 * // subscribe to an event
 * obj.on('hello', function (str) {
 *     console.log('event hello is fired', str);
 * });
 *
 * // fire event
 * obj.fire('hello', 'world');
 * ```
 */
declare class EventHandler {
    /**
     * @type {Map<string,Array<EventHandle>>}
     * @private
     */
    private _callbacks;
    /**
     * @type {Map<string,Array<EventHandle>>}
     * @private
     */
    private _callbackActive;
    /**
     * Reinitialize the event handler.
     * @ignore
     */
    initEventHandler(): void;
    /**
     * Registers a new event handler.
     *
     * @param {string} name - Name of the event to bind the callback to.
     * @param {HandleEventCallback} callback - Function that is called when event is fired. Note
     * the callback is limited to 8 arguments.
     * @param {object} scope - Object to use as 'this' when the event is fired, defaults to
     * current this.
     * @param {boolean} once - If true, the callback will be unbound after being fired once.
     * @returns {EventHandle} Created {@link EventHandle}.
     * @ignore
     */
    _addCallback(name: string, callback: HandleEventCallback, scope: object, once: boolean): EventHandle;
    /**
     * Attach an event handler to an event.
     *
     * @param {string} name - Name of the event to bind the callback to.
     * @param {HandleEventCallback} callback - Function that is called when event is fired. Note
     * the callback is limited to 8 arguments.
     * @param {object} [scope] - Object to use as 'this' when the event is fired, defaults to
     * current this.
     * @returns {EventHandle} Can be used for removing event in the future.
     * @example
     * obj.on('test', function (a, b) {
     *     console.log(a + b);
     * });
     * obj.fire('test', 1, 2); // prints 3 to the console
     * @example
     * const evt = obj.on('test', function (a, b) {
     *     console.log(a + b);
     * });
     * // some time later
     * evt.off();
     */
    on(name: string, callback: HandleEventCallback, scope?: object): EventHandle;
    /**
     * Attach an event handler to an event. This handler will be removed after being fired once.
     *
     * @param {string} name - Name of the event to bind the callback to.
     * @param {HandleEventCallback} callback - Function that is called when event is fired. Note
     * the callback is limited to 8 arguments.
     * @param {object} [scope] - Object to use as 'this' when the event is fired, defaults to
     * current this.
     * @returns {EventHandle} - can be used for removing event in the future.
     * @example
     * obj.once('test', function (a, b) {
     *     console.log(a + b);
     * });
     * obj.fire('test', 1, 2); // prints 3 to the console
     * obj.fire('test', 1, 2); // not going to get handled
     */
    once(name: string, callback: HandleEventCallback, scope?: object): EventHandle;
    /**
     * Detach an event handler from an event. If callback is not provided then all callbacks are
     * unbound from the event, if scope is not provided then all events with the callback will be
     * unbound.
     *
     * @param {string} [name] - Name of the event to unbind.
     * @param {HandleEventCallback} [callback] - Function to be unbound.
     * @param {object} [scope] - Scope that was used as the this when the event is fired.
     * @returns {EventHandler} Self for chaining.
     * @example
     * const handler = function () {
     * };
     * obj.on('test', handler);
     *
     * obj.off(); // Removes all events
     * obj.off('test'); // Removes all events called 'test'
     * obj.off('test', handler); // Removes all handler functions, called 'test'
     * obj.off('test', handler, this); // Removes all handler functions, called 'test' with scope this
     */
    off(name?: string, callback?: HandleEventCallback, scope?: object): EventHandler;
    /**
     * Fire an event, all additional arguments are passed on to the event listener.
     *
     * @param {string} name - Name of event to fire.
     * @param {*} [arg1] - First argument that is passed to the event handler.
     * @param {*} [arg2] - Second argument that is passed to the event handler.
     * @param {*} [arg3] - Third argument that is passed to the event handler.
     * @param {*} [arg4] - Fourth argument that is passed to the event handler.
     * @param {*} [arg5] - Fifth argument that is passed to the event handler.
     * @param {*} [arg6] - Sixth argument that is passed to the event handler.
     * @param {*} [arg7] - Seventh argument that is passed to the event handler.
     * @param {*} [arg8] - Eighth argument that is passed to the event handler.
     * @returns {EventHandler} Self for chaining.
     * @example
     * obj.fire('test', 'This is the message');
     */
    fire(name: string, arg1?: any, arg2?: any, arg3?: any, arg4?: any, arg5?: any, arg6?: any, arg7?: any, arg8?: any): EventHandler;
    /**
     * Test if there are any handlers bound to an event name.
     *
     * @param {string} name - The name of the event to test.
     * @returns {boolean} True if the object has handlers bound to the specified event name.
     * @example
     * obj.on('test', function () { }); // bind an event to 'test'
     * obj.hasEvent('test'); // returns true
     * obj.hasEvent('hello'); // returns false
     */
    hasEvent(name: string): boolean;
}

/**
 * A 2-dimensional vector.
 *
 * @category Math
 */
declare class Vec2 {
    /**
     * Calculates the angle between two Vec2's in radians.
     *
     * @param {Vec2} lhs - The first vector operand for the calculation.
     * @param {Vec2} rhs - The second vector operand for the calculation.
     * @returns {number} The calculated angle in radians.
     * @ignore
     */
    static angleRad(lhs: Vec2, rhs: Vec2): number;
    /**
     * A constant vector set to [0, 0].
     *
     * @type {Vec2}
     * @readonly
     */
    static readonly ZERO: Vec2;
    /**
     * A constant vector set to [1, 1].
     *
     * @type {Vec2}
     * @readonly
     */
    static readonly ONE: Vec2;
    /**
     * A constant vector set to [0, 1].
     *
     * @type {Vec2}
     * @readonly
     */
    static readonly UP: Vec2;
    /**
     * A constant vector set to [0, -1].
     *
     * @type {Vec2}
     * @readonly
     */
    static readonly DOWN: Vec2;
    /**
     * A constant vector set to [1, 0].
     *
     * @type {Vec2}
     * @readonly
     */
    static readonly RIGHT: Vec2;
    /**
     * A constant vector set to [-1, 0].
     *
     * @type {Vec2}
     * @readonly
     */
    static readonly LEFT: Vec2;
    /**
     * Create a new Vec2 instance.
     *
     * @param {number|number[]} [x] - The x value. Defaults to 0. If x is an array of length 2, the
     * array will be used to populate all components.
     * @param {number} [y] - The y value. Defaults to 0.
     * @example
     * const v = new pc.Vec2(1, 2);
     */
    constructor(x?: number | number[], y?: number);
    /**
     * The first component of the vector.
     *
     * @type {number}
     */
    x: number;
    /**
     * The second component of the vector.
     *
     * @type {number}
     */
    y: number;
    /**
     * Adds a 2-dimensional vector to another in place.
     *
     * @param {Vec2} rhs - The vector to add to the specified vector.
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(10, 10);
     * const b = new pc.Vec2(20, 20);
     *
     * a.add(b);
     *
     * // Outputs [30, 30]
     * console.log("The result of the addition is: " + a.toString());
     */
    add(rhs: Vec2): Vec2;
    /**
     * Adds two 2-dimensional vectors together and returns the result.
     *
     * @param {Vec2} lhs - The first vector operand for the addition.
     * @param {Vec2} rhs - The second vector operand for the addition.
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(10, 10);
     * const b = new pc.Vec2(20, 20);
     * const r = new pc.Vec2();
     *
     * r.add2(a, b);
     * // Outputs [30, 30]
     *
     * console.log("The result of the addition is: " + r.toString());
     */
    add2(lhs: Vec2, rhs: Vec2): Vec2;
    /**
     * Adds a number to each element of a vector.
     *
     * @param {number} scalar - The number to add.
     * @returns {Vec2} Self for chaining.
     * @example
     * const vec = new pc.Vec2(3, 4);
     *
     * vec.addScalar(2);
     *
     * // Outputs [5, 6]
     * console.log("The result of the addition is: " + vec.toString());
     */
    addScalar(scalar: number): Vec2;
    /**
     * Adds a 2-dimensional vector scaled by scalar value. Does not modify the vector being added.
     *
     * @param {Vec2} rhs - The vector to add to the specified vector.
     * @param {number} scalar - The number to multiply the added vector with.
     * @returns {Vec2} Self for chaining.
     * @example
     * const vec = new pc.Vec2(1, 2);
     *
     * vec.addScaled(pc.Vec2.UP, 2);
     *
     * // Outputs [1, 4]
     * console.log("The result of the addition is: " + vec.toString());
     */
    addScaled(rhs: Vec2, scalar: number): Vec2;
    /**
     * Returns an identical copy of the specified 2-dimensional vector.
     *
     * @returns {this} A 2-dimensional vector containing the result of the cloning.
     * @example
     * const v = new pc.Vec2(10, 20);
     * const vclone = v.clone();
     * console.log("The result of the cloning is: " + vclone.toString());
     */
    clone(): this;
    /**
     * Copies the contents of a source 2-dimensional vector to a destination 2-dimensional vector.
     *
     * @param {Vec2} rhs - A vector to copy to the specified vector.
     * @returns {Vec2} Self for chaining.
     * @example
     * const src = new pc.Vec2(10, 20);
     * const dst = new pc.Vec2();
     *
     * dst.copy(src);
     *
     * console.log("The two vectors are " + (dst.equals(src) ? "equal" : "different"));
     */
    copy(rhs: Vec2): Vec2;
    /**
     * Returns the result of a cross product operation performed on the two specified 2-dimensional
     * vectors.
     *
     * @param {Vec2} rhs - The second 2-dimensional vector operand of the cross product.
     * @returns {number} The cross product of the two vectors.
     * @example
     * const right = new pc.Vec2(1, 0);
     * const up = new pc.Vec2(0, 1);
     * const crossProduct = right.cross(up);
     *
     * // Prints 1
     * console.log("The result of the cross product is: " + crossProduct);
     */
    cross(rhs: Vec2): number;
    /**
     * Returns the distance between the two specified 2-dimensional vectors.
     *
     * @param {Vec2} rhs - The second 2-dimensional vector to test.
     * @returns {number} The distance between the two vectors.
     * @example
     * const v1 = new pc.Vec2(5, 10);
     * const v2 = new pc.Vec2(10, 20);
     * const d = v1.distance(v2);
     * console.log("The distance between v1 and v2 is: " + d);
     */
    distance(rhs: Vec2): number;
    /**
     * Divides a 2-dimensional vector by another in place.
     *
     * @param {Vec2} rhs - The vector to divide the specified vector by.
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(4, 9);
     * const b = new pc.Vec2(2, 3);
     *
     * a.div(b);
     *
     * // Outputs [2, 3]
     * console.log("The result of the division is: " + a.toString());
     */
    div(rhs: Vec2): Vec2;
    /**
     * Divides one 2-dimensional vector by another and writes the result to the specified vector.
     *
     * @param {Vec2} lhs - The dividend vector (the vector being divided).
     * @param {Vec2} rhs - The divisor vector (the vector dividing the dividend).
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(4, 9);
     * const b = new pc.Vec2(2, 3);
     * const r = new pc.Vec2();
     *
     * r.div2(a, b);
     * // Outputs [2, 3]
     *
     * console.log("The result of the division is: " + r.toString());
     */
    div2(lhs: Vec2, rhs: Vec2): Vec2;
    /**
     * Divides each element of a vector by a number.
     *
     * @param {number} scalar - The number to divide by.
     * @returns {Vec2} Self for chaining.
     * @example
     * const vec = new pc.Vec2(3, 6);
     *
     * vec.divScalar(3);
     *
     * // Outputs [1, 2]
     * console.log("The result of the division is: " + vec.toString());
     */
    divScalar(scalar: number): Vec2;
    /**
     * Returns the result of a dot product operation performed on the two specified 2-dimensional
     * vectors.
     *
     * @param {Vec2} rhs - The second 2-dimensional vector operand of the dot product.
     * @returns {number} The result of the dot product operation.
     * @example
     * const v1 = new pc.Vec2(5, 10);
     * const v2 = new pc.Vec2(10, 20);
     * const v1dotv2 = v1.dot(v2);
     * console.log("The result of the dot product is: " + v1dotv2);
     */
    dot(rhs: Vec2): number;
    /**
     * Reports whether two vectors are equal.
     *
     * @param {Vec2} rhs - The vector to compare to the specified vector.
     * @returns {boolean} True if the vectors are equal and false otherwise.
     * @example
     * const a = new pc.Vec2(1, 2);
     * const b = new pc.Vec2(4, 5);
     * console.log("The two vectors are " + (a.equals(b) ? "equal" : "different"));
     */
    equals(rhs: Vec2): boolean;
    /**
     * Reports whether two vectors are equal using an absolute error tolerance.
     *
     * @param {Vec2} rhs - The vector to be compared against.
     * @param {number} [epsilon] - The maximum difference between each component of the two
     * vectors. Defaults to 1e-6.
     * @returns {boolean} True if the vectors are equal and false otherwise.
     * @example
     * const a = new pc.Vec2();
     * const b = new pc.Vec2();
     * console.log("The two vectors are approximately " + (a.equalsApprox(b, 1e-9) ? "equal" : "different"));
     */
    equalsApprox(rhs: Vec2, epsilon?: number): boolean;
    /**
     * Returns the magnitude of the specified 2-dimensional vector.
     *
     * @returns {number} The magnitude of the specified 2-dimensional vector.
     * @example
     * const vec = new pc.Vec2(3, 4);
     * const len = vec.length();
     * // Outputs 5
     * console.log("The length of the vector is: " + len);
     */
    length(): number;
    /**
     * Returns the magnitude squared of the specified 2-dimensional vector.
     *
     * @returns {number} The magnitude of the specified 2-dimensional vector.
     * @example
     * const vec = new pc.Vec2(3, 4);
     * const len = vec.lengthSq();
     * // Outputs 25
     * console.log("The length squared of the vector is: " + len);
     */
    lengthSq(): number;
    /**
     * Returns the result of a linear interpolation between two specified 2-dimensional vectors.
     *
     * @param {Vec2} lhs - The 2-dimensional to interpolate from.
     * @param {Vec2} rhs - The 2-dimensional to interpolate to.
     * @param {number} alpha - The value controlling the point of interpolation. Between 0 and 1,
     * the linear interpolant will occur on a straight line between lhs and rhs. Outside of this
     * range, the linear interpolant will occur on a ray extrapolated from this line.
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(0, 0);
     * const b = new pc.Vec2(10, 10);
     * const r = new pc.Vec2();
     *
     * r.lerp(a, b, 0);   // r is equal to a
     * r.lerp(a, b, 0.5); // r is 5, 5
     * r.lerp(a, b, 1);   // r is equal to b
     */
    lerp(lhs: Vec2, rhs: Vec2, alpha: number): Vec2;
    /**
     * Multiplies a 2-dimensional vector to another in place.
     *
     * @param {Vec2} rhs - The 2-dimensional vector used as the second multiplicand of the operation.
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(2, 3);
     * const b = new pc.Vec2(4, 5);
     *
     * a.mul(b);
     *
     * // Outputs 8, 15
     * console.log("The result of the multiplication is: " + a.toString());
     */
    mul(rhs: Vec2): Vec2;
    /**
     * Returns the result of multiplying the specified 2-dimensional vectors together.
     *
     * @param {Vec2} lhs - The 2-dimensional vector used as the first multiplicand of the operation.
     * @param {Vec2} rhs - The 2-dimensional vector used as the second multiplicand of the operation.
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(2, 3);
     * const b = new pc.Vec2(4, 5);
     * const r = new pc.Vec2();
     *
     * r.mul2(a, b);
     *
     * // Outputs 8, 15
     * console.log("The result of the multiplication is: " + r.toString());
     */
    mul2(lhs: Vec2, rhs: Vec2): Vec2;
    /**
     * Multiplies each element of a vector by a number.
     *
     * @param {number} scalar - The number to multiply by.
     * @returns {Vec2} Self for chaining.
     * @example
     * const vec = new pc.Vec2(3, 6);
     *
     * vec.mulScalar(3);
     *
     * // Outputs [9, 18]
     * console.log("The result of the multiplication is: " + vec.toString());
     */
    mulScalar(scalar: number): Vec2;
    /**
     * Returns this 2-dimensional vector converted to a unit vector in place. If the vector has a
     * length of zero, the vector's elements will be set to zero.
     *
     * @param {Vec2} [src] - The vector to normalize. If not set, the operation is done in place.
     * @returns {Vec2} Self for chaining.
     * @example
     * const v = new pc.Vec2(25, 0);
     *
     * v.normalize();
     *
     * // Outputs 1, 0
     * console.log("The result of the vector normalization is: " + v.toString());
     */
    normalize(src?: Vec2): Vec2;
    /**
     * Rotate a vector by an angle in degrees.
     *
     * @param {number} degrees - The number to degrees to rotate the vector by.
     * @returns {Vec2} Self for chaining.
     * @example
     * const v = new pc.Vec2(0, 10);
     *
     * v.rotate(45); // rotates by 45 degrees
     *
     * // Outputs [7.071068.., 7.071068..]
     * console.log("Vector after rotation is: " + v.toString());
     */
    rotate(degrees: number): Vec2;
    /**
     * Returns the angle in degrees of the specified 2-dimensional vector.
     *
     * @returns {number} The angle in degrees of the specified 2-dimensional vector.
     * @example
     * const v = new pc.Vec2(6, 0);
     * const angle = v.angle();
     * // Outputs 90..
     * console.log("The angle of the vector is: " + angle);
     */
    angle(): number;
    /**
     * Returns the shortest Euler angle between two 2-dimensional vectors.
     *
     * @param {Vec2} rhs - The 2-dimensional vector to calculate angle to.
     * @returns {number} The shortest angle in degrees between two 2-dimensional vectors.
     * @example
     * const a = new pc.Vec2(0, 10); // up
     * const b = new pc.Vec2(1, -1); // down-right
     * const angle = a.angleTo(b);
     * // Outputs 135..
     * console.log("The angle between vectors a and b: " + angle);
     */
    angleTo(rhs: Vec2): number;
    /**
     * Each element is set to the largest integer less than or equal to its value.
     *
     * @param {Vec2} [src] - The vector to floor. If not set, the operation is done in place.
     * @returns {Vec2} Self for chaining.
     */
    floor(src?: Vec2): Vec2;
    /**
     * Each element is rounded up to the next largest integer.
     *
     * @param {Vec2} [src] - The vector to ceil. If not set, the operation is done in place.
     * @returns {Vec2} Self for chaining.
     */
    ceil(src?: Vec2): Vec2;
    /**
     * Each element is rounded up or down to the nearest integer.
     *
     * @param {Vec2} [src] - The vector to round. If not set, the operation is done in place.
     * @returns {Vec2} Self for chaining.
     */
    round(src?: Vec2): Vec2;
    /**
     * Each element is assigned a value from rhs parameter if it is smaller.
     *
     * @param {Vec2} rhs - The 2-dimensional vector used as the source of elements to compare to.
     * @returns {Vec2} Self for chaining.
     */
    min(rhs: Vec2): Vec2;
    /**
     * Each element is assigned a value from rhs parameter if it is larger.
     *
     * @param {Vec2} rhs - The 2-dimensional vector used as the source of elements to compare to.
     * @returns {Vec2} Self for chaining.
     */
    max(rhs: Vec2): Vec2;
    /**
     * Sets the specified 2-dimensional vector to the supplied numerical values.
     *
     * @param {number} x - The value to set on the first component of the vector.
     * @param {number} y - The value to set on the second component of the vector.
     * @returns {Vec2} Self for chaining.
     * @example
     * const v = new pc.Vec2();
     * v.set(5, 10);
     *
     * // Outputs 5, 10
     * console.log("The result of the vector set is: " + v.toString());
     */
    set(x: number, y: number): Vec2;
    /**
     * Subtracts a 2-dimensional vector from another in place.
     *
     * @param {Vec2} rhs - The vector to subtract from the specified vector.
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(10, 10);
     * const b = new pc.Vec2(20, 20);
     *
     * a.sub(b);
     *
     * // Outputs [-10, -10]
     * console.log("The result of the subtraction is: " + a.toString());
     */
    sub(rhs: Vec2): Vec2;
    /**
     * Subtracts two 2-dimensional vectors from one another and returns the result.
     *
     * @param {Vec2} lhs - The first vector operand for the subtraction.
     * @param {Vec2} rhs - The second vector operand for the subtraction.
     * @returns {Vec2} Self for chaining.
     * @example
     * const a = new pc.Vec2(10, 10);
     * const b = new pc.Vec2(20, 20);
     * const r = new pc.Vec2();
     *
     * r.sub2(a, b);
     *
     * // Outputs [-10, -10]
     * console.log("The result of the subtraction is: " + r.toString());
     */
    sub2(lhs: Vec2, rhs: Vec2): Vec2;
    /**
     * Subtracts a number from each element of a vector.
     *
     * @param {number} scalar - The number to subtract.
     * @returns {Vec2} Self for chaining.
     * @example
     * const vec = new pc.Vec2(3, 4);
     *
     * vec.subScalar(2);
     *
     * // Outputs [1, 2]
     * console.log("The result of the subtraction is: " + vec.toString());
     */
    subScalar(scalar: number): Vec2;
    /**
     * Converts the vector to string form.
     *
     * @returns {string} The vector in string form.
     * @example
     * const v = new pc.Vec2(20, 10);
     * // Outputs [20, 10]
     * console.log(v.toString());
     */
    toString(): string;
}

/**
 * BlendState is a descriptor that defines how output of fragment shader is written and blended
 * into render target. A blend state can be set on a material using {@link Material#blendState},
 * or in some cases on the graphics device using {@link GraphicsDevice#setBlendState}.
 *
 * For the best performance, do not modify blend state after it has been created, but create
 * multiple blend states and assign them to the material or graphics device as needed.
 *
 * @category Graphics
 */
declare class BlendState {
    /**
     * A blend state that has blending disabled and writes to all color channels.
     *
     * @type {BlendState}
     * @readonly
     */
    static readonly NOBLEND: BlendState;
    /**
     * A blend state that does not write to color channels.
     *
     * @type {BlendState}
     * @readonly
     */
    static readonly NOWRITE: BlendState;
    /**
     * A blend state that does simple translucency using alpha channel.
     *
     * @type {BlendState}
     * @readonly
     */
    static readonly ALPHABLEND: BlendState;
    /**
     * A blend state that does simple additive blending.
     *
     * @type {BlendState}
     * @readonly
     */
    static readonly ADDBLEND: BlendState;
    /**
     * Create a new BlendState instance.
     *
     * All factor parameters can take the following values:
     *
     * - {@link BLENDMODE_ZERO}
     * - {@link BLENDMODE_ONE}
     * - {@link BLENDMODE_SRC_COLOR}
     * - {@link BLENDMODE_ONE_MINUS_SRC_COLOR}
     * - {@link BLENDMODE_DST_COLOR}
     * - {@link BLENDMODE_ONE_MINUS_DST_COLOR}
     * - {@link BLENDMODE_SRC_ALPHA}
     * - {@link BLENDMODE_SRC_ALPHA_SATURATE}
     * - {@link BLENDMODE_ONE_MINUS_SRC_ALPHA}
     * - {@link BLENDMODE_DST_ALPHA}
     * - {@link BLENDMODE_ONE_MINUS_DST_ALPHA}
     * - {@link BLENDMODE_CONSTANT}
     * - {@link BLENDMODE_ONE_MINUS_CONSTANT}
     *
     * All op parameters can take the following values:
     *
     * - {@link BLENDEQUATION_ADD}
     * - {@link BLENDEQUATION_SUBTRACT}
     * - {@link BLENDEQUATION_REVERSE_SUBTRACT}
     * - {@link BLENDEQUATION_MIN}
     * - {@link BLENDEQUATION_MAX}
     *
     * Note that MIN and MAX operations on WebGL platform require either EXT_blend_minmax or WebGL2
     * to work (check device.extBlendMinmax).
     *
     * @param {boolean} [blend] - Enables or disables blending. Defaults to false.
     * @param {number} [colorOp] - Configures color blending operation. Defaults to
     * {@link BLENDEQUATION_ADD}.
     * @param {number} [colorSrcFactor] - Configures source color blending factor. Defaults to
     * {@link BLENDMODE_ONE}.
     * @param {number} [colorDstFactor] - Configures destination color blending factor. Defaults to
     * {@link BLENDMODE_ZERO}.
     * @param {number} [alphaOp] - Configures alpha blending operation. Defaults to
     * {@link BLENDEQUATION_ADD}.
     * @param {number} [alphaSrcFactor] - Configures source alpha blending factor. Defaults to
     * {@link BLENDMODE_ONE}.
     * @param {number} [alphaDstFactor] - Configures destination alpha blending factor. Defaults to
     * {@link BLENDMODE_ZERO}.
     * @param {boolean} [redWrite] - True to enable writing of the red channel and false otherwise.
     * Defaults to true.
     * @param {boolean} [greenWrite] - True to enable writing of the green channel and false
     * otherwise. Defaults to true.
     * @param {boolean} [blueWrite] - True to enable writing of the blue channel and false otherwise.
     * Defaults to true.
     * @param {boolean} [alphaWrite] - True to enable writing of the alpha channel and false
     * otherwise. Defaults to true.
     */
    constructor(blend?: boolean, colorOp?: number, colorSrcFactor?: number, colorDstFactor?: number, alphaOp?: number, alphaSrcFactor?: number, alphaDstFactor?: number, redWrite?: boolean, greenWrite?: boolean, blueWrite?: boolean, alphaWrite?: boolean);
    /**
     * Bitfield representing the blend state for render target 0.
     *
     * @private
     */
    private target0;
    /**
     * Enables or disables blending.
     *
     * @type {boolean}
     */
    set blend(arg: boolean);
    get blend(): boolean;
    setColorBlend(op: any, srcFactor: any, dstFactor: any): void;
    setAlphaBlend(op: any, srcFactor: any, dstFactor: any): void;
    setColorWrite(redWrite: any, greenWrite: any, blueWrite: any, alphaWrite: any): void;
    set redWrite(arg: boolean);
    get redWrite(): boolean;
    set greenWrite(arg: boolean);
    get greenWrite(): boolean;
    set blueWrite(arg: boolean);
    get blueWrite(): boolean;
    set alphaWrite(arg: boolean);
    get alphaWrite(): boolean;
    get colorOp(): number;
    get colorSrcFactor(): number;
    get colorDstFactor(): number;
    get alphaOp(): number;
    get alphaSrcFactor(): number;
    get alphaDstFactor(): number;
    get allWrite(): number;
    /**
     * Copies the contents of a source blend state to this blend state.
     *
     * @param {BlendState} rhs - A blend state to copy from.
     * @returns {BlendState} Self for chaining.
     */
    copy(rhs: BlendState): BlendState;
    /**
     * Returns an identical copy of the specified blend state.
     *
     * @returns {this} The result of the cloning.
     */
    clone(): this;
    get key(): number;
    /**
     * Reports whether two BlendStates are equal.
     *
     * @param {BlendState} rhs - The blend state to compare to.
     * @returns {boolean} True if the blend states are equal and false otherwise.
     */
    equals(rhs: BlendState): boolean;
}

/**
 * DepthState is a descriptor that defines how the depth value of the fragment is used by the
 * rendering pipeline. A depth state can be set on a material using {@link Material#depthState},
 * or in some cases on the graphics device using {@link GraphicsDevice#setDepthState}.
 *
 * For the best performance, do not modify depth state after it has been created, but create
 * multiple depth states and assign them to the material or graphics device as needed.
 *
 * @category Graphics
 */
declare class DepthState {
    /**
     * A default depth state that has the depth testing function set to {@link FUNC_LESSEQUAL} and depth writes enabled.
     *
     * @type {DepthState}
     * @readonly
     */
    static readonly DEFAULT: DepthState;
    /**
     * A depth state that always passes the fragment but does not write depth to the depth buffer.
     *
     * @type {DepthState}
     * @readonly
     */
    static readonly NODEPTH: DepthState;
    /**
     * A depth state that always passes the fragment and writes depth to the depth buffer.
     *
     * @type {DepthState}
     * @readonly
     */
    static readonly WRITEDEPTH: DepthState;
    /**
     * Create a new Depth State instance.
     *
     * @param {number} func - Controls how the depth of the fragment is compared against the
     * current depth contained in the depth buffer. See {@link DepthState#func} for details.
     * Defaults to {@link FUNC_LESSEQUAL}.
     * @param {boolean} write - If true, depth values are written to the depth buffer of the
     * currently active render target. Defaults to true.
     */
    constructor(func?: number, write?: boolean);
    /**
     * Bitfield representing the depth state.
     *
     * @private
     */
    private data;
    _depthBias: number;
    _depthBiasSlope: number;
    /**
     * A unique number representing the depth state. You can use this number to quickly compare
     * two depth states for equality. The key is always maintained valid without a dirty flag,
     * to avoid condition check at runtime, considering these change rarely.
     *
     * @type {number}
     */
    key: number;
    /**
     * Controls how the depth of the fragment is compared against the current depth contained in
     * the depth buffer. Can be:
     *
     * - {@link FUNC_NEVER}: don't draw
     * - {@link FUNC_LESS}: draw if new depth < depth buffer
     * - {@link FUNC_EQUAL}: draw if new depth == depth buffer
     * - {@link FUNC_LESSEQUAL}: draw if new depth <= depth buffer
     * - {@link FUNC_GREATER}: draw if new depth > depth buffer
     * - {@link FUNC_NOTEQUAL}: draw if new depth != depth buffer
     * - {@link FUNC_GREATEREQUAL}: draw if new depth >= depth buffer
     * - {@link FUNC_ALWAYS}: always draw
     *
     * @type {number}
     */
    set func(arg: number);
    get func(): number;
    /**
     * If true, shader write a depth value to the depth buffer of the currently active render
     * target. If false, no depth value is written.
     *
     * @type {boolean}
     */
    set write(arg: boolean);
    get write(): boolean;
    /**
     * If true, a shader fragment is only written to the current render target if it passes the depth
     * test. If false, it is written regardless of what is in the depth buffer. Note that when depth
     * testing is disabled, writes to the depth buffer are also disabled. Defaults to true.
     *
     * @type {boolean}
     */
    set test(arg: boolean);
    get test(): boolean;
    /**
     * Constant depth bias added to each fragment's depth. Useful for decals to prevent z-fighting.
     * Typically a small negative value (-0.1) is used to render the mesh slightly closer to the
     * camera. Defaults to 0.
     *
     * @type {number}
     */
    set depthBias(arg: number);
    get depthBias(): number;
    /**
     * Depth bias that scales with the fragment’s slope. Defaults to 0.
     *
     * @type {number}
     */
    set depthBiasSlope(arg: number);
    get depthBiasSlope(): number;
    /**
     * Copies the contents of a source depth state to this depth state.
     *
     * @param {DepthState} rhs - A depth state to copy from.
     * @returns {DepthState} Self for chaining.
     */
    copy(rhs: DepthState): DepthState;
    /**
     * Returns an identical copy of the specified depth state.
     *
     * @returns {this} The result of the cloning.
     */
    clone(): this;
    updateKey(): void;
    /**
     * Reports whether two DepthStates are equal.
     *
     * @param {DepthState} rhs - The depth state to compare to.
     * @returns {boolean} True if the depth states are equal and false otherwise.
     */
    equals(rhs: DepthState): boolean;
}

/**
 * Holds stencil test settings.
 *
 * @category Graphics
 */
declare class StencilParameters {
    /**
     * A default stencil state.
     *
     * @type {StencilParameters}
     * @readonly
     */
    static readonly DEFAULT: StencilParameters;
    /**
     * Create a new StencilParameters instance.
     *
     * @param {object} [options] - Options object to configure the stencil parameters.
     */
    constructor(options?: object);
    /**
     * @type {number}
     * @private
     */
    private _func;
    /**
     * @type {number}
     * @private
     */
    private _ref;
    /**
     * @type {number}
     * @private
     */
    private _fail;
    /**
     * @type {number}
     * @private
     */
    private _zfail;
    /**
     * @type {number}
     * @private
     */
    private _zpass;
    /**
     * @type {number}
     * @private
     */
    private _readMask;
    /**
     * @type {number}
     * @private
     */
    private _writeMask;
    /**
     * @type {boolean}
     * @private
     */
    private _dirty;
    /**
     * @type {number}
     * @private
     */
    private _key;
    /**
     * A comparison function that decides if the pixel should be written, based on the current
     * stencil buffer value, reference value, and mask value. Can be:
     *
     * - {@link FUNC_NEVER}: never pass
     * - {@link FUNC_LESS}: pass if (ref & mask) < (stencil & mask)
     * - {@link FUNC_EQUAL}: pass if (ref & mask) == (stencil & mask)
     * - {@link FUNC_LESSEQUAL}: pass if (ref & mask) <= (stencil & mask)
     * - {@link FUNC_GREATER}: pass if (ref & mask) > (stencil & mask)
     * - {@link FUNC_NOTEQUAL}: pass if (ref & mask) != (stencil & mask)
     * - {@link FUNC_GREATEREQUAL}: pass if (ref & mask) >= (stencil & mask)
     * - {@link FUNC_ALWAYS}: always pass
     *
     * @type {number}
     */
    set func(arg: number);
    get func(): number;
    /**
     * Sets stencil test reference value used in comparisons.
     *
     * @type {number}
     */
    set ref(arg: number);
    get ref(): number;
    /**
     * Operation to perform if stencil test is failed. Can be:
     *
     * - {@link STENCILOP_KEEP}: don't change the stencil buffer value
     * - {@link STENCILOP_ZERO}: set value to zero
     * - {@link STENCILOP_REPLACE}: replace value with the reference value.
     * - {@link STENCILOP_INCREMENT}: increment the value
     * - {@link STENCILOP_INCREMENTWRAP}: increment the value, but wrap it to zero when it's larger
     * than a maximum representable value
     * - {@link STENCILOP_DECREMENT}: decrement the value
     * - {@link STENCILOP_DECREMENTWRAP}: decrement the value, but wrap it to a maximum
     * representable value, if the current value is 0
     * - {@link STENCILOP_INVERT}: invert the value bitwise
     *
     * @type {number}
     */
    set fail(arg: number);
    get fail(): number;
    /**
     * Operation to perform if depth test is failed. Accepts the same values as `fail`.
     *
     * @type {number}
     */
    set zfail(arg: number);
    get zfail(): number;
    /**
     * Operation to perform if both stencil and depth test are passed. Accepts the same values as
     * `fail`.
     *
     * @type {number}
     */
    set zpass(arg: number);
    get zpass(): number;
    /**
     * Mask applied to stencil buffer value and reference value before comparison.
     *
     * @type {number}
     */
    set readMask(arg: number);
    get readMask(): number;
    /**
     * A bit mask applied to the stencil value, when written.
     *
     * @type {number}
     */
    set writeMask(arg: number);
    get writeMask(): number;
    _evalKey(): void;
    get key(): number;
    /**
     * Copies the contents of a source stencil parameters to this stencil parameters.
     *
     * @param {StencilParameters} rhs - A stencil parameters to copy from.
     * @returns {StencilParameters} Self for chaining.
     */
    copy(rhs: StencilParameters): StencilParameters;
    /**
     * Clone the stencil parameters.
     *
     * @returns {StencilParameters} A cloned StencilParameters object.
     */
    clone(): StencilParameters;
}

/**
 * Representation of an RGBA color.
 *
 * @category Math
 */
declare class Color {
    /**
     * A constant color set to black [0, 0, 0, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly BLACK: Color;
    /**
     * A constant color set to blue [0, 0, 1, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly BLUE: Color;
    /**
     * A constant color set to cyan [0, 1, 1, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly CYAN: Color;
    /**
     * A constant color set to gray [0.5, 0.5, 0.5, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly GRAY: Color;
    /**
     * A constant color set to green [0, 1, 0, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly GREEN: Color;
    /**
     * A constant color set to magenta [1, 0, 1, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly MAGENTA: Color;
    /**
     * A constant color set to red [1, 0, 0, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly RED: Color;
    /**
     * A constant color set to white [1, 1, 1, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly WHITE: Color;
    /**
     * A constant color set to yellow [1, 1, 0, 1].
     *
     * @type {Color}
     * @readonly
     */
    static readonly YELLOW: Color;
    /**
     * Create a new Color object.
     *
     * @param {number|number[]} [r] - The value of the red component (0-1). Defaults to 0. If r is
     * an array of length 3 or 4, the array will be used to populate all components.
     * @param {number} [g] - The value of the green component (0-1). Defaults to 0.
     * @param {number} [b] - The value of the blue component (0-1). Defaults to 0.
     * @param {number} [a] - The value of the alpha component (0-1). Defaults to 1.
     */
    constructor(r?: number | number[], g?: number, b?: number, a?: number);
    /**
     * The red component of the color.
     *
     * @type {number}
     */
    r: number;
    /**
     * The green component of the color.
     *
     * @type {number}
     */
    g: number;
    /**
     * The blue component of the color.
     *
     * @type {number}
     */
    b: number;
    /**
     * The alpha component of the color.
     *
     * @type {number}
     */
    a: number;
    /**
     * Returns a clone of the specified color.
     *
     * @returns {this} A duplicate color object.
     */
    clone(): this;
    /**
     * Copies the contents of a source color to a destination color.
     *
     * @param {Color} rhs - A color to copy to the specified color.
     * @returns {Color} Self for chaining.
     * @example
     * const src = new pc.Color(1, 0, 0, 1);
     * const dst = new pc.Color();
     *
     * dst.copy(src);
     *
     * console.log("The two colors are " + (dst.equals(src) ? "equal" : "different"));
     */
    copy(rhs: Color): Color;
    /**
     * Reports whether two colors are equal.
     *
     * @param {Color} rhs - The color to compare to the specified color.
     * @returns {boolean} True if the colors are equal and false otherwise.
     * @example
     * const a = new pc.Color(1, 0, 0, 1);
     * const b = new pc.Color(1, 1, 0, 1);
     * console.log("The two colors are " + (a.equals(b) ? "equal" : "different"));
     */
    equals(rhs: Color): boolean;
    /**
     * Assign values to the color components, including alpha.
     *
     * @param {number} r - The value for red (0-1).
     * @param {number} g - The value for blue (0-1).
     * @param {number} b - The value for green (0-1).
     * @param {number} [a] - The value for the alpha (0-1), defaults to 1.
     * @returns {Color} Self for chaining.
     */
    set(r: number, g: number, b: number, a?: number): Color;
    /**
     * Returns the result of a linear interpolation between two specified colors.
     *
     * @param {Color} lhs - The color to interpolate from.
     * @param {Color} rhs - The color to interpolate to.
     * @param {number} alpha - The value controlling the point of interpolation. Between 0 and 1,
     * the linear interpolant will occur on a straight line between lhs and rhs. Outside of this
     * range, the linear interpolant will occur on a ray extrapolated from this line.
     * @returns {Color} Self for chaining.
     * @example
     * const a = new pc.Color(0, 0, 0);
     * const b = new pc.Color(1, 1, 0.5);
     * const r = new pc.Color();
     *
     * r.lerp(a, b, 0);   // r is equal to a
     * r.lerp(a, b, 0.5); // r is 0.5, 0.5, 0.25
     * r.lerp(a, b, 1);   // r is equal to b
     */
    lerp(lhs: Color, rhs: Color, alpha: number): Color;
    /**
     * Set the values of the color from a string representation '#11223344' or '#112233'.
     *
     * @param {string} hex - A string representation in the format '#RRGGBBAA' or '#RRGGBB'. Where
     * RR, GG, BB, AA are red, green, blue and alpha values. This is the same format used in
     * HTML/CSS.
     * @returns {Color} Self for chaining.
     */
    fromString(hex: string): Color;
    /**
     * Converts the color to string form. The format is '#RRGGBBAA', where RR, GG, BB, AA are the
     * red, green, blue and alpha values. When the alpha value is not included (the default), this
     * is the same format as used in HTML/CSS.
     *
     * @param {boolean} alpha - If true, the output string will include the alpha value.
     * @returns {string} The color in string form.
     * @example
     * const c = new pc.Color(1, 1, 1);
     * // Outputs #ffffffff
     * console.log(c.toString());
     */
    toString(alpha: boolean): string;
}

/**
 * The graphics device manages the underlying graphics context. It is responsible for submitting
 * render state changes and graphics primitives to the hardware. A graphics device is tied to a
 * specific canvas HTML element. It is valid to have more than one canvas element per page and
 * create a new graphics device against each.
 *
 * @augments EventHandler
 * @category Graphics
 */
declare class GraphicsDevice extends EventHandler {
    static EVENT_RESIZE: string;
    constructor(canvas: any, options: any);
    /**
     * Fired when the canvas is resized. The handler is passed the new width and height as number
     * parameters.
     *
     * @event
     * @example
     * graphicsDevice.on('resizecanvas', (width, height) => {
     *     console.log(`The canvas was resized to ${width}x${height}`);
     * });
     */
    /**
     * The canvas DOM element that provides the underlying WebGL context used by the graphics device.
     *
     * @type {HTMLCanvasElement}
     * @readonly
     */
    readonly canvas: HTMLCanvasElement;
    /**
     * The render target representing the main back-buffer.
     *
     * @type {import('./render-target.js').RenderTarget|null}
     * @ignore
     */
    backBuffer: RenderTarget | null;
    /**
     * The dimensions of the back buffer.
     *
     * @ignore
     */
    backBufferSize: Vec2;
    /**
     * The pixel format of the back buffer. Typically PIXELFORMAT_RGBA8, PIXELFORMAT_BGRA8 or
     * PIXELFORMAT_RGB8.
     *
     * @ignore
     */
    backBufferFormat: any;
    /**
     * True if the back buffer should use anti-aliasing.
     *
     * @type {boolean}
     */
    backBufferAntialias: boolean;
    /**
     * True if the deviceType is WebGPU
     *
     * @type {boolean}
     * @readonly
     */
    readonly isWebGPU: boolean;
    /**
     * True if the deviceType is WebGL1
     *
     * @type {boolean}
     * @readonly
     */
    readonly isWebGL1: boolean;
    /**
     * True if the deviceType is WebGL2
     *
     * @type {boolean}
     * @readonly
     */
    readonly isWebGL2: boolean;
    /**
     * The scope namespace for shader attributes and variables.
     *
     * @type {ScopeSpace}
     * @readonly
     */
    readonly scope: ScopeSpace;
    /**
     * The maximum number of supported bones using uniform buffers.
     *
     * @type {number}
     * @readonly
     */
    readonly boneLimit: number;
    /**
     * The maximum supported texture anisotropy setting.
     *
     * @type {number}
     * @readonly
     */
    readonly maxAnisotropy: number;
    /**
     * The maximum supported dimension of a cube map.
     *
     * @type {number}
     * @readonly
     */
    readonly maxCubeMapSize: number;
    /**
     * The maximum supported dimension of a texture.
     *
     * @type {number}
     * @readonly
     */
    readonly maxTextureSize: number;
    /**
     * The maximum supported dimension of a 3D texture (any axis).
     *
     * @type {number}
     * @readonly
     */
    readonly maxVolumeSize: number;
    /**
     * The maximum supported number of color buffers attached to a render target.
     *
     * @type {number}
     * @readonly
     */
    readonly maxColorAttachments: number;
    /**
     * The highest shader precision supported by this graphics device. Can be 'hiphp', 'mediump' or
     * 'lowp'.
     *
     * @type {string}
     * @readonly
     */
    readonly precision: string;
    /**
     * The number of hardware anti-aliasing samples used by the frame buffer.
     *
     * @readonly
     * @type {number}
     */
    readonly samples: number;
    /**
     * True if the main framebuffer contains stencil attachment.
     *
     * @ignore
     * @type {boolean}
     */
    supportsStencil: boolean;
    /**
     * True if Multiple Render Targets feature is supported. This refers to the ability to render to
     * multiple color textures with a single draw call.
     *
     * @readonly
     * @type {boolean}
     */
    readonly supportsMrt: boolean;
    /**
     * True if the device supports volume textures.
     *
     * @readonly
     * @type {boolean}
     */
    readonly supportsVolumeTextures: boolean;
    /**
     * True if the device supports compute shaders.
     *
     * @readonly
     * @type {boolean}
     */
    readonly supportsCompute: boolean;
    /**
     * Currently active render target.
     *
     * @type {import('./render-target.js').RenderTarget|null}
     * @ignore
     */
    renderTarget: RenderTarget | null;
    /**
     * Array of objects that need to be re-initialized after a context restore event
     *
     * @type {import('./shader.js').Shader[]}
     * @ignore
     */
    shaders: Shader[];
    /**
     * An array of currently created textures.
     *
     * @type {import('./texture.js').Texture[]}
     * @ignore
     */
    textures: Texture[];
    /**
     * A set of currently created render targets.
     *
     * @type {Set<import('./render-target.js').RenderTarget>}
     * @ignore
     */
    targets: Set<RenderTarget>;
    /**
     * A version number that is incremented every frame. This is used to detect if some object were
     * invalidated.
     *
     * @type {number}
     * @ignore
     */
    renderVersion: number;
    /**
     * Index of the currently active render pass.
     *
     * @type {number}
     * @ignore
     */
    renderPassIndex: number;
    /** @type {boolean} */
    insideRenderPass: boolean;
    /**
     * True if hardware instancing is supported.
     *
     * @type {boolean}
     * @readonly
     */
    readonly supportsInstancing: boolean;
    /**
     * True if the device supports uniform buffers.
     *
     * @type {boolean}
     * @ignore
     */
    supportsUniformBuffers: boolean;
    /**
     * True if 32-bit floating-point textures can be used as a frame buffer.
     *
     * @type {boolean}
     * @readonly
     */
    readonly textureFloatRenderable: boolean;
    /**
     * True if 16-bit floating-point textures can be used as a frame buffer.
     *
     * @type {boolean}
     * @readonly
     */
    readonly textureHalfFloatRenderable: boolean;
    /**
     * True if filtering can be applied when sampling float textures.
     *
     * @type {boolean}
     * @readonly
     */
    readonly textureFloatFilterable: boolean;
    /**
     * True if filtering can be applied when sampling 16-bit float textures.
     *
     * @type {boolean}
     * @readonly
     */
    readonly textureHalfFloatFilterable: boolean;
    /**
     * A vertex buffer representing a quad.
     *
     * @type {VertexBuffer}
     * @ignore
     */
    quadVertexBuffer: VertexBuffer;
    /**
     * An object representing current blend state
     *
     * @ignore
     */
    blendState: BlendState;
    /**
     * The current depth state.
     *
     * @ignore
     */
    depthState: DepthState;
    /**
     * True if stencil is enabled and stencilFront and stencilBack are used
     *
     * @ignore
     */
    stencilEnabled: boolean;
    /**
     * The current front stencil parameters.
     *
     * @ignore
     */
    stencilFront: StencilParameters;
    /**
     * The current back stencil parameters.
     *
     * @ignore
     */
    stencilBack: StencilParameters;
    /**
     * The dynamic buffer manager.
     *
     * @type {import('./dynamic-buffers.js').DynamicBuffers}
     * @ignore
     */
    dynamicBuffers: DynamicBuffers;
    /**
     * The GPU profiler.
     *
     * @type {import('./gpu-profiler.js').GpuProfiler}
     */
    gpuProfiler: GpuProfiler;
    defaultClearOptions: {
        color: number[];
        depth: number;
        stencil: number;
        flags: number;
    };
    initOptions: any;
    _maxPixelRatio: number;
    buffers: any[];
    _vram: {
        texShadow: number;
        texAsset: number;
        texLightmap: number;
        tex: number;
        vb: number;
        ib: number;
        ub: number;
    };
    _shaderStats: {
        vsCompiled: number;
        fsCompiled: number;
        linked: number;
        materialShaders: number;
        compileTime: number;
    };
    _drawCallsPerFrame: number;
    _shaderSwitchesPerFrame: number;
    _primsPerFrame: number[];
    _renderTargetCreationTime: number;
    textureBias: ScopeId;
    /**
     * Function that executes after the device has been created.
     */
    postInit(): void;
    /**
     * Destroy the graphics device.
     */
    destroy(): void;
    onDestroyShader(shader: any): void;
    postDestroy(): void;
    toJSON(key: any): any;
    initializeContextCaches(): void;
    indexBuffer: IndexBuffer;
    vertexBuffers: any[];
    shader: any;
    shaderValid: any;
    shaderAsyncCompile: boolean;
    initializeRenderState(): void;
    cullMode: number;
    vx: number;
    vy: number;
    vw: number;
    vh: number;
    sx: number;
    sy: number;
    sw: number;
    sh: number;
    blendColor: Color;
    /**
     * Sets the specified stencil state. If both stencilFront and stencilBack are null, stencil
     * operation is disabled.
     *
     * @param {StencilParameters} [stencilFront] - The front stencil parameters. Defaults to
     * {@link StencilParameters.DEFAULT} if not specified.
     * @param {StencilParameters} [stencilBack] - The back stencil parameters. Defaults to
     * {@link StencilParameters.DEFAULT} if not specified.
     */
    setStencilState(stencilFront?: StencilParameters, stencilBack?: StencilParameters): void;
    /**
     * Sets the specified blend state.
     *
     * @param {BlendState} blendState - New blend state.
     */
    setBlendState(blendState: BlendState): void;
    /**
     * Sets the constant blend color and alpha values used with {@link BLENDMODE_CONSTANT} and
     * {@link BLENDMODE_ONE_MINUS_CONSTANT} factors specified in {@link BlendState}. Defaults to
     * [0, 0, 0, 0].
     *
     * @param {number} r - The value for red.
     * @param {number} g - The value for green.
     * @param {number} b - The value for blue.
     * @param {number} a - The value for alpha.
     */
    setBlendColor(r: number, g: number, b: number, a: number): void;
    /**
     * Sets the specified depth state.
     *
     * @param {DepthState} depthState - New depth state.
     */
    setDepthState(depthState: DepthState): void;
    /**
     * Controls how triangles are culled based on their face direction. The default cull mode is
     * {@link CULLFACE_BACK}.
     *
     * @param {number} cullMode - The cull mode to set. Can be:
     *
     * - {@link CULLFACE_NONE}
     * - {@link CULLFACE_BACK}
     * - {@link CULLFACE_FRONT}
     */
    setCullMode(cullMode: number): void;
    /**
     * Sets the specified render target on the device. If null is passed as a parameter, the back
     * buffer becomes the current target for all rendering operations.
     *
     * @param {import('./render-target.js').RenderTarget|null} renderTarget - The render target to
     * activate.
     * @example
     * // Set a render target to receive all rendering output
     * device.setRenderTarget(renderTarget);
     *
     * // Set the back buffer to receive all rendering output
     * device.setRenderTarget(null);
     */
    setRenderTarget(renderTarget: RenderTarget | null): void;
    /**
     * Sets the current index buffer on the graphics device. On subsequent calls to
     * {@link GraphicsDevice#draw}, the specified index buffer will be used to provide index data
     * for any indexed primitives.
     *
     * @param {import('./index-buffer.js').IndexBuffer} indexBuffer - The index buffer to assign to
     * the device.
     */
    setIndexBuffer(indexBuffer: IndexBuffer): void;
    /**
     * Sets the current vertex buffer on the graphics device. On subsequent calls to
     * {@link GraphicsDevice#draw}, the specified vertex buffer(s) will be used to provide vertex
     * data for any primitives.
     *
     * @param {import('./vertex-buffer.js').VertexBuffer} vertexBuffer - The vertex buffer to
     * assign to the device.
     */
    setVertexBuffer(vertexBuffer: VertexBuffer): void;
    /**
     * Queries the currently set render target on the device.
     *
     * @returns {import('./render-target.js').RenderTarget} The current render target.
     * @example
     * // Get the current render target
     * const renderTarget = device.getRenderTarget();
     */
    getRenderTarget(): RenderTarget;
    /**
     * Initialize render target before it can be used.
     *
     * @param {import('./render-target.js').RenderTarget} target - The render target to be
     * initialized.
     * @ignore
     */
    initRenderTarget(target: RenderTarget): void;
    /**
     * Reports whether a texture source is a canvas, image, video or ImageBitmap.
     *
     * @param {*} texture - Texture source data.
     * @returns {boolean} True if the texture is a canvas, image, video or ImageBitmap and false
     * otherwise.
     * @ignore
     */
    _isBrowserInterface(texture: any): boolean;
    _isImageBrowserInterface(texture: any): boolean;
    _isImageCanvasInterface(texture: any): boolean;
    _isImageVideoInterface(texture: any): boolean;
    /**
     * Sets the width and height of the canvas, then fires the `resizecanvas` event. Note that the
     * specified width and height values will be multiplied by the value of
     * {@link GraphicsDevice#maxPixelRatio} to give the final resultant width and height for the
     * canvas.
     *
     * @param {number} width - The new width of the canvas.
     * @param {number} height - The new height of the canvas.
     * @ignore
     */
    resizeCanvas(width: number, height: number): void;
    /**
     * Sets the width and height of the canvas, then fires the `resizecanvas` event. Note that the
     * value of {@link GraphicsDevice#maxPixelRatio} is ignored.
     *
     * @param {number} width - The new width of the canvas.
     * @param {number} height - The new height of the canvas.
     * @ignore
     */
    setResolution(width: number, height: number): void;
    updateClientRect(): void;
    clientRect: DOMRect;
    /**
     * Width of the back buffer in pixels.
     *
     * @type {number}
     */
    get width(): number;
    /**
     * Height of the back buffer in pixels.
     *
     * @type {number}
     */
    get height(): number;
    /**
     * Fullscreen mode.
     *
     * @type {boolean}
     */
    set fullscreen(arg: boolean);
    get fullscreen(): boolean;
    /**
     * Maximum pixel ratio.
     *
     * @type {number}
     */
    set maxPixelRatio(arg: number);
    get maxPixelRatio(): number;
    /**
     * The type of the device. Can be one of pc.DEVICETYPE_WEBGL1, pc.DEVICETYPE_WEBGL2 or pc.DEVICETYPE_WEBGPU.
     *
     * @type {import('./constants.js').DEVICETYPE_WEBGL1 | import('./constants.js').DEVICETYPE_WEBGL2 | import('./constants.js').DEVICETYPE_WEBGPU}
     */
    get deviceType(): string;
    /**
     * Queries the maximum number of bones that can be referenced by a shader. The shader
     * generators (programlib) use this number to specify the matrix array size of the uniform
     * 'matrix_pose[0]'. The value is calculated based on the number of available uniform vectors
     * available after subtracting the number taken by a typical heavyweight shader. If a different
     * number is required, it can be tuned via {@link GraphicsDevice#setBoneLimit}.
     *
     * @returns {number} The maximum number of bones that can be supported by the host hardware.
     * @ignore
     */
    getBoneLimit(): number;
    /**
     * Specifies the maximum number of bones that the device can support on the current hardware.
     * This function allows the default calculated value based on available vector uniforms to be
     * overridden.
     *
     * @param {number} maxBones - The maximum number of bones supported by the host hardware.
     * @ignore
     */
    setBoneLimit(maxBones: number): void;
    startRenderPass(renderPass: any): void;
    endRenderPass(renderPass: any): void;
    startComputePass(): void;
    endComputePass(): void;
    /**
     * Function which executes at the start of the frame. This should not be called manually, as
     * it is handled by the AppBase instance.
     *
     * @ignore
     */
    frameStart(): void;
    /**
     * Function which executes at the end of the frame. This should not be called manually, as it is
     * handled by the AppBase instance.
     *
     * @ignore
     */
    frameEnd(): void;
    /**
     * Get a renderable HDR pixel format supported by the graphics device.
     *
     * @param {number[]} [formats] - An array of pixel formats to check for support. Can contain:
     *
     * - {@link PIXELFORMAT_111110F}
     * - {@link PIXELFORMAT_RGBA16F}
     * - {@link PIXELFORMAT_RGBA32F}
     *
     * @param {boolean} [filterable] - If true, the format also needs to be filterable. Defaults to
     * true.
     * @returns {number|undefined} The first supported renderable HDR format or undefined if none is
     * supported.
     */
    getRenderableHdrFormat(formats?: number[], filterable?: boolean): number | undefined;
}

/**
 * A class providing utility functions for shader creation.
 *
 * @ignore
 */
declare class ShaderUtils {
    /**
     * Creates a shader definition.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} device - The graphics device.
     * @param {object} options - Object for passing optional arguments.
     * @param {string} [options.name] - A name of the shader.
     * @param {object} [options.attributes] - Attributes. Will be extracted from the vertexCode if
     * not provided.
     * @param {string} options.vertexCode - The vertex shader code.
     * @param {string} [options.vertexDefines] - The vertex shader defines.
     * @param {string} [options.vertexExtensions] - The vertex shader extensions code.
     * @param {string} [options.fragmentCode] - The fragment shader code.
     * @param {string} [options.fragmentDefines] - The fragment shader defines.
     * @param {string} [options.fragmentExtensions] - The fragment shader extensions code.
     * @param {string} [options.fragmentPreamble] - The preamble string for the fragment shader.
     * @param {boolean} [options.useTransformFeedback] - Whether to use transform feedback. Defaults to false.
     * @param {string | string[]} [options.fragmentOutputTypes] - Fragment shader output types,
     * which default to vec4. Passing a string will set the output type for all color attachments.
     * Passing an array will set the output type for each color attachment.
     * @returns {object} Returns the created shader definition.
     */
    static createDefinition(device: GraphicsDevice, options: {
        name?: string;
        attributes?: object;
        vertexCode: string;
        vertexDefines?: string;
        vertexExtensions?: string;
        fragmentCode?: string;
        fragmentDefines?: string;
        fragmentExtensions?: string;
        fragmentPreamble?: string;
        useTransformFeedback?: boolean;
        fragmentOutputTypes?: string | string[];
    }): object;
    static getShaderNameCode(name: any): string;
    static gl1Extensions(device: any, options: any, isVertex: any): string;
    static dummyFragmentCode(): string;
    static versionCode(device: any): "" | "#version 450\n" | "#version 300 es\n";
    static precisionCode(device: any, forcePrecision: any): string;
    /**
     * Extract the attributes specified in a vertex shader.
     *
     * @param {string} vsCode - The vertex shader code.
     * @returns {Object<string, string>} The attribute name to semantic map.
     * @ignore
     */
    static collectAttributes(vsCode: string): {
        [x: string]: string;
    };
}

/**
 * Draws a screen-space quad using a specific shader.
 *
 * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The graphics device used to draw
 * the quad.
 * @param {import('../../platform/graphics/render-target.js').RenderTarget|null} target - The destination render
 * target. If undefined, target is the frame buffer.
 * @param {import('../../platform/graphics/shader.js').Shader} shader - The shader used for rendering the quad. Vertex
 * shader should contain `attribute vec2 vertex_position`.
 * @param {import('../../core/math/vec4.js').Vec4} [rect] - The viewport rectangle of the quad, in
 * pixels. Defaults to fullscreen (`0, 0, target.width, target.height`).
 * @param {import('../../core/math/vec4.js').Vec4} [scissorRect] - The scissor rectangle of the
 * quad, in pixels. Defaults to fullscreen (`0, 0, target.width, target.height`).
 * @category Graphics
 */
declare function drawQuadWithShader(device: GraphicsDevice, target: RenderTarget | null, shader: Shader, rect?: Vec4, scissorRect?: Vec4, ...args: any[]): void;
/**
 * Draws a texture in screen-space. Mostly used by post-effects.
 *
 * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The graphics device used to draw
 * the texture.
 * @param {import('../../platform/graphics/texture.js').Texture} texture - The source texture to be drawn. Accessible as
 * `uniform sampler2D * source` in shader.
 * @param {import('../../platform/graphics/render-target.js').RenderTarget} [target] - The destination render target.
 * Defaults to the frame buffer.
 * @param {import('../../platform/graphics/shader.js').Shader} [shader] - The optional custom shader used for rendering the texture.
 * @param {import('../../core/math/vec4.js').Vec4} [rect] - The viewport rectangle to use for the
 * texture, in pixels. Defaults to fullscreen (`0, 0, target.width, target.height`).
 * @param {import('../../core/math/vec4.js').Vec4} [scissorRect] - The scissor rectangle to use for
 * the texture, in pixels. Defaults to fullscreen (`0, 0, target.width, target.height`).
 * @category Graphics
 */
declare function drawTexture(device: GraphicsDevice, texture: Texture, target?: RenderTarget, shader?: Shader, rect?: Vec4, scissorRect?: Vec4, ...args: any[]): void;

/**
 * Object containing all default shader chunks used by shader generators.
 *
 * @type {object}
 * @category Graphics
 */
declare const shaderChunks: object;

/**
 * The lit shader options determines how the lit-shader gets generated. It specifies a set of
 * parameters which triggers different fragment and vertex shader generation in the backend.
 *
 * @category Graphics
 */
declare class LitShaderOptions {
    hasTangents: boolean;
    /**
     * Object containing custom shader chunks that will replace default ones.
     *
     * @type {Object<string, string>}
     */
    chunks: {
        [x: string]: string;
    };
    pass: number;
    /**
     * Enable alpha testing. See {@link Material#alphaTest}.
     *
     * @type {boolean}
     */
    alphaTest: boolean;
    /**
     * The value of {@link Material#blendType}.
     *
     * @type {number}
     */
    blendType: number;
    separateAmbient: boolean;
    screenSpace: boolean;
    skin: boolean;
    /**
     * If hardware instancing compatible shader should be generated. Transform is read from
     * per-instance {@link VertexBuffer} instead of shader's uniforms.
     *
     * @type {boolean}
     */
    useInstancing: boolean;
    /**
     * If morphing code should be generated to morph positions.
     *
     * @type {boolean}
     */
    useMorphPosition: boolean;
    /**
     * If morphing code should be generated to morph normals.
     *
     * @type {boolean}
     */
    useMorphNormal: boolean;
    useMorphTextureBased: boolean;
    nineSlicedMode: number;
    clusteredLightingEnabled: boolean;
    clusteredLightingCookiesEnabled: boolean;
    clusteredLightingShadowsEnabled: boolean;
    clusteredLightingShadowType: number;
    clusteredLightingAreaLightsEnabled: boolean;
    vertexColors: boolean;
    lightMapEnabled: boolean;
    dirLightMapEnabled: boolean;
    useHeights: boolean;
    useNormals: boolean;
    useClearCoatNormals: boolean;
    useAo: boolean;
    diffuseMapEnabled: boolean;
    useAmbientTint: boolean;
    /**
     * Replaced the whole fragment shader with this string.
     *
     * @type {string}
     */
    customFragmentShader: string;
    pixelSnap: boolean;
    /**
     * The value of {@link StandardMaterial#shadingModel}.
     *
     * @type {number}
     */
    shadingModel: number;
    /**
     * If ambient spherical harmonics are used. Ambient SH replace prefiltered cubemap ambient on
     * certain platforms (mostly Android) for performance reasons.
     *
     * @type {boolean}
     */
    ambientSH: boolean;
    /**
     * Use slightly cheaper normal mapping code (skip tangent space normalization). Can look buggy
     * sometimes.
     *
     * @type {boolean}
     */
    fastTbn: boolean;
    /**
     * The value of {@link StandardMaterial#twoSidedLighting}.
     *
     * @type {boolean}
     */
    twoSidedLighting: boolean;
    /**
     * The value of {@link StandardMaterial#occludeDirect}.
     *
     * @type {boolean}
     */
    occludeDirect: boolean;
    /**
     * The value of {@link StandardMaterial#occludeSpecular}.
     *
     * @type {number}
     */
    occludeSpecular: number;
    /**
     * Defines if {@link StandardMaterial#occludeSpecularIntensity} constant should affect specular
     * occlusion.
     *
     * @type {boolean}
     */
    occludeSpecularFloat: boolean;
    useMsdf: boolean;
    msdfTextAttribute: boolean;
    /**
     * Enable alpha to coverage. See {@link Material#alphaToCoverage}.
     *
     * @type {boolean}
     */
    alphaToCoverage: boolean;
    /**
     * Enable specular fade. See {@link StandardMaterial#opacityFadesSpecular}.
     *
     * @type {boolean}
     */
    opacityFadesSpecular: boolean;
    /**
     * Enable opacity dithering. See {@link StandardMaterial#opacityDither}.
     *
     * @type {string}
     */
    opacityDither: string;
    /**
     * Enable opacity shadow dithering. See {@link StandardMaterial#opacityShadowDither}.
     *
     * @type {string}
     */
    opacityShadowDither: string;
    /**
     * The value of {@link StandardMaterial#cubeMapProjection}.
     *
     * @type {number}
     */
    cubeMapProjection: number;
    /**
     * The value of {@link StandardMaterial#conserveEnergy}.
     *
     * @type {boolean}
     */
    conserveEnergy: boolean;
    /**
     * If any specular or reflections are needed at all.
     *
     * @type {boolean}
     */
    useSpecular: boolean;
    useSpecularityFactor: boolean;
    enableGGXSpecular: boolean;
    /**
     * The value of {@link StandardMaterial#fresnelModel}.
     *
     * @type {number}
     */
    fresnelModel: number;
    /**
     * If refraction is used.
     *
     * @type {boolean}
     */
    useRefraction: boolean;
    useClearCoat: boolean;
    useSheen: boolean;
    useIridescence: boolean;
    /**
     * The value of {@link StandardMaterial#useMetalness}.
     *
     * @type {boolean}
     */
    useMetalness: boolean;
    useDynamicRefraction: boolean;
    /**
     * The type of fog being applied in the shader. See {@link Scene#fog} for the list of possible
     * values.
     *
     * @type {string}
     */
    fog: string;
    /**
     * The type of gamma correction being applied in the shader. See {@link Scene#gammaCorrection}
     * for the list of possible values.
     *
     * @type {number}
     */
    gamma: number;
    /**
     * The type of tone mapping being applied in the shader. See {@link Scene#toneMapping} for the
     * list of possible values.
     *
     * @type {number}
     */
    toneMap: number;
    /**
     * If cubemaps require seam fixing (see the `fixCubemapSeams` property of the options object
     * passed to the {@link Texture} constructor).
     *
     * @type {boolean}
     */
    fixSeams: boolean;
    /**
     * One of "envAtlasHQ", "envAtlas", "cubeMap", "sphereMap".
     *
     * @type {string}
     */
    reflectionSource: string;
    reflectionEncoding: any;
    reflectionCubemapEncoding: any;
    /**
     * One of "ambientSH", "envAtlas", "constant".
     *
     * @type {string}
     */
    ambientSource: string;
    ambientEncoding: any;
    /**
     * Skybox intensity factor.
     *
     * @type {number}
     */
    skyboxIntensity: number;
    /**
     * If cube map rotation is enabled.
     *
     * @type {boolean}
     */
    useCubeMapRotation: boolean;
    lightMapWithoutAmbient: boolean;
    lights: any[];
    noShadow: boolean;
    lightMaskDynamic: number;
    /**
     * Object containing a map of user defined vertex attributes to attached shader semantics.
     *
     * @type {Object<string, string>}
     */
    userAttributes: {
        [x: string]: string;
    };
}

/**
 * The standard material options define a set of options used to control the shader frontend shader
 * generation, such as textures, tints and multipliers.
 *
 * @category Graphics
 */
declare class StandardMaterialOptions {
    /**
     * If UV1 (second set of texture coordinates) is required in the shader. Will be declared as
     * "vUv1" and passed to the fragment shader.
     *
     * @type {boolean}
     */
    forceUv1: boolean;
    /**
     * The value of {@link StandardMaterial#ambientTint}.
     *
     * @type {boolean}
     */
    ambientTint: boolean;
    /**
     * Defines if {@link StandardMaterial#diffuse} constant should affect diffuse color.
     *
     * @type {boolean}
     */
    diffuseTint: boolean;
    /**
     * Defines if {@link StandardMaterial#specular} constant should affect specular color.
     *
     * @type {boolean}
     */
    specularTint: boolean;
    /**
     * Defines if {@link StandardMaterial#metalness} constant should affect metalness value.
     *
     * @type {boolean}
     */
    metalnessTint: boolean;
    /**
     * Defines if {@link StandardMaterial#gloss} constant should affect glossiness value.
     *
     * @type {boolean}
     */
    glossTint: boolean;
    /**
     * Defines if {@link StandardMaterial#emissive} constant should affect emissive color.
     *
     * @type {boolean}
     */
    emissiveTint: boolean;
    /**
     * Defines if {@link StandardMaterial#opacity} constant should affect opacity value.
     *
     * @type {boolean}
     */
    opacityTint: boolean;
    emissiveEncoding: string;
    lightMapEncoding: string;
    /**
     * If normal map contains X in RGB, Y in Alpha, and Z must be reconstructed.
     *
     * @type {boolean}
     */
    packedNormal: boolean;
    /**
     * Invert the gloss channel.
     *
     * @type {boolean}
     */
    glossInvert: boolean;
    /**
     * Invert the sheen gloss channel.
     *
     * @type {boolean}
     */
    sheenGlossInvert: boolean;
    /**
     * Invert the clearcoat gloss channel.
     *
     * @type {boolean}
     */
    clearCoatGlossInvert: boolean;
    /**
     * Storage for the options for lit the shader and material.
     *
     * @type {LitShaderOptions}
     */
    litOptions: LitShaderOptions;
    get pass(): number;
}

/**
 * A class responsible for creation and caching of required shaders.
 * There is a two level cache. The first level generates the shader based on the provided options.
 * The second level processes this generated shader using processing options - in most cases
 * modifies it to support uniform buffers.
 *
 * @ignore
 */
declare class ProgramLibrary {
    constructor(device: any, standardMaterial: any);
    /**
     * A cache of shaders processed using processing options.
     *
     * @type {Map<string, Shader>}
     */
    processedCache: Map<string, Shader>;
    /**
     * A cache of shader definitions before processing.
     *
     * @type {Map<number, object>}
     */
    definitionsCache: Map<number, object>;
    /**
     * Named shader generators.
     *
     * @type {Map<string, import('./programs/shader-generator.js').ShaderGenerator>}
     */
    _generators: Map<string, ShaderGenerator>;
    _device: any;
    _isClearingCache: boolean;
    _precached: boolean;
    _programsCollection: any[];
    _defaultStdMatOption: StandardMaterialOptions;
    _defaultStdMatOptionMin: StandardMaterialOptions;
    destroy(): void;
    register(name: any, generator: any): void;
    unregister(name: any): void;
    isRegistered(name: any): boolean;
    /**
     * Returns a generated shader definition for the specified options. They key is used to cache the
     * shader definition.
     * @param {import('./programs/shader-generator.js').ShaderGenerator} generator - The generator
     * to use.
     * @param {string} name - The unique name of the shader generator.
     * @param {number} key - A unique key representing the shader options.
     * @param {object} options - The shader options.
     * @returns {object} - The shader definition.
     */
    generateShaderDefinition(generator: ShaderGenerator, name: string, key: number, options: object): object;
    getCachedShader(key: any): Shader;
    setCachedShader(key: any, shader: any): void;
    getProgram(name: any, options: any, processingOptions: any, userMaterialId: any): Shader;
    storeNewProgram(name: any, options: any): void;
    dumpPrograms(): void;
    clearCache(): void;
    /**
     * Remove shader from the cache. This function does not destroy it, that is the responsibility
     * of the caller.
     *
     * @param {Shader} shader - The shader to be removed.
     */
    removeFromCache(shader: Shader): void;
    _getDefaultStdMatOptions(pass: any): StandardMaterialOptions;
    precompile(cache: any): void;
}

/**
 * Representation of a shader uniform.
 *
 * @ignore
 */
declare class WebglShaderInput {
    /**
     * Create a new WebglShaderInput instance.
     *
     * @param {import('../graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this shader input.
     * @param {string} name - The name of the shader input.
     * @param {number} type - The type of the shader input.
     * @param {number | WebGLUniformLocation} locationId - The location id of the shader input.
     */
    constructor(graphicsDevice: GraphicsDevice, name: string, type: number, locationId: number | WebGLUniformLocation);
    locationId: number | WebGLUniformLocation;
    scopeId: ScopeId;
    version: Version;
    dataType: number;
    value: any[];
    array: any[];
}

/**
 * A vertex iterator simplifies the process of writing vertex data to a vertex buffer.
 *
 * @category Graphics
 */
declare class VertexIterator {
    /**
     * Create a new VertexIterator instance.
     *
     * @param {import('./vertex-buffer.js').VertexBuffer} vertexBuffer - The vertex buffer to be
     * iterated.
     */
    constructor(vertexBuffer: VertexBuffer);
    vertexBuffer: VertexBuffer;
    vertexFormatSize: number;
    buffer: ArrayBuffer;
    accessors: VertexIteratorAccessor[];
    /**
     * The vertex buffer elements.
     *
     * @type {Object<string, VertexIteratorAccessor>}
     */
    element: {
        [x: string]: VertexIteratorAccessor;
    };
    /**
     * Moves the vertex iterator on to the next vertex.
     *
     * @param {number} [count] - Optional number of steps to move on when calling next. Defaults to
     * 1.
     * @example
     * const iterator = new pc.VertexIterator(vertexBuffer);
     * iterator.element[pc.SEMANTIC_POSITION].set(-0.9, -0.9, 0.0);
     * iterator.element[pc.SEMANTIC_COLOR].set(255, 0, 0, 255);
     * iterator.next();
     * iterator.element[pc.SEMANTIC_POSITION].set(0.9, -0.9, 0.0);
     * iterator.element[pc.SEMANTIC_COLOR].set(0, 255, 0, 255);
     * iterator.next();
     * iterator.element[pc.SEMANTIC_POSITION].set(0.0, 0.9, 0.0);
     * iterator.element[pc.SEMANTIC_COLOR].set(0, 0, 255, 255);
     * iterator.end();
     */
    next(count?: number): void;
    /**
     * Notifies the vertex buffer being iterated that writes are complete. Internally the vertex
     * buffer is unlocked and vertex data is uploaded to video memory.
     *
     * @example
     * const iterator = new pc.VertexIterator(vertexBuffer);
     * iterator.element[pc.SEMANTIC_POSITION].set(-0.9, -0.9, 0.0);
     * iterator.element[pc.SEMANTIC_COLOR].set(255, 0, 0, 255);
     * iterator.next();
     * iterator.element[pc.SEMANTIC_POSITION].set(0.9, -0.9, 0.0);
     * iterator.element[pc.SEMANTIC_COLOR].set(0, 255, 0, 255);
     * iterator.next();
     * iterator.element[pc.SEMANTIC_POSITION].set(0.0, 0.9, 0.0);
     * iterator.element[pc.SEMANTIC_COLOR].set(0, 0, 255, 255);
     * iterator.end();
     */
    end(): void;
    /**
     * Copies data for specified semantic into vertex buffer. Works with both interleaved (slower)
     * and non-interleaved (fast) vertex buffers.
     *
     * @param {string} semantic - The semantic of the vertex element to set.
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} data - The data to set.
     * @param {number} numVertices - The number of vertices to write.
     * @ignore
     */
    writeData(semantic: string, data: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, numVertices: number): void;
    /**
     * Function to extract elements of a specified semantic from vertex buffer into flat array
     * (data). Works with both interleaved (slower) and non-interleaved (fast) vertex buffers.
     * Returns number of vertices. Note: when data is a typed array and is smaller than needed,
     * only part of the data gets copied out (typed arrays ignore read/write out of range).
     *
     * @param {string} semantic - The semantic of the vertex element to read.
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} data - The
     * array to receive the data.
     * @returns {number} The number of vertices read.
     * @ignore
     */
    readData(semantic: string, data: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array): number;
}
/**
 * Helps with accessing a specific vertex attribute.
 *
 * @category Graphics
 * @ignore
 */
declare class VertexIteratorAccessor {
    /**
     * Create a new VertexIteratorAccessor instance.
     *
     * @param {ArrayBuffer} buffer - The vertex buffer containing the attribute to be accessed.
     * @param {object} vertexElement - The vertex attribute to be accessed.
     * @param {string} vertexElement.name - The meaning of the vertex element. This is used to link
     * the vertex data to a shader input. Can be:
     *
     * - {@link SEMANTIC_POSITION}
     * - {@link SEMANTIC_NORMAL}
     * - {@link SEMANTIC_TANGENT}
     * - {@link SEMANTIC_BLENDWEIGHT}
     * - {@link SEMANTIC_BLENDINDICES}
     * - {@link SEMANTIC_COLOR}
     * - {@link SEMANTIC_TEXCOORD0}
     * - {@link SEMANTIC_TEXCOORD1}
     * - {@link SEMANTIC_TEXCOORD2}
     * - {@link SEMANTIC_TEXCOORD3}
     * - {@link SEMANTIC_TEXCOORD4}
     * - {@link SEMANTIC_TEXCOORD5}
     * - {@link SEMANTIC_TEXCOORD6}
     * - {@link SEMANTIC_TEXCOORD7}
     *
     * If vertex data has a meaning other that one of those listed above, use the user-defined
     * semantics: {@link SEMANTIC_ATTR0} to {@link SEMANTIC_ATTR15}.
     * @param {number} vertexElement.numComponents - The number of components of the vertex
     * attribute. Can be 1, 2, 3 or 4.
     * @param {number} vertexElement.dataType - The data type of the attribute. Can be:
     *
     * - {@link TYPE_INT8}
     * - {@link TYPE_UINT8}
     * - {@link TYPE_INT16}
     * - {@link TYPE_UINT16}
     * - {@link TYPE_INT32}
     * - {@link TYPE_UINT32}
     * - {@link TYPE_FLOAT32}
     * @param {boolean} vertexElement.normalize - If true, vertex attribute data will be mapped
     * from a 0 to 255 range down to 0 to 1 when fed to a shader. If false, vertex attribute data
     * is left unchanged. If this property is unspecified, false is assumed.
     * @param {number} vertexElement.offset - The number of initial bytes at the start of a vertex
     * that are not relevant to this attribute.
     * @param {number} vertexElement.stride - The number of total bytes that are between the start
     * of one vertex, and the start of the next.
     * @param {import('./scope-id.js').ScopeId} vertexElement.scopeId - The shader input variable
     * corresponding to the attribute.
     * @param {number} vertexElement.size - The size of the attribute in bytes.
     * @param {import('./vertex-format.js').VertexFormat} vertexFormat - A vertex format that
     * defines the layout of vertex data inside the buffer.
     */
    constructor(buffer: ArrayBuffer, vertexElement: {
        name: string;
        numComponents: number;
        dataType: number;
        normalize: boolean;
        offset: number;
        stride: number;
        scopeId: ScopeId;
        size: number;
    }, vertexFormat: VertexFormat);
    index: number;
    numComponents: number;
    array: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array;
    stride: number;
    /**
     * Set all the attribute components at the iterator's current index.
     *
     * @param {number} a - The first component value.
     * @param {number} [b] - The second component value (if applicable).
     * @param {number} [c] - The third component value (if applicable).
     * @param {number} [d] - The fourth component value (if applicable).
     */
    set(a: number, b?: number, c?: number, d?: number): void;
    /**
     * Read attribute components to an output array.
     *
     * @param {number} offset - The component offset at which to read data from the buffer. Will be
     * used instead of the iterator's current index.
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} outputArray - The output array to write data into.
     * @param {number} outputIndex - The output index at which to write into the output array.
     */
    getToArray(offset: number, outputArray: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, outputIndex: number): void;
    /**
     * Write attribute components from an input array.
     *
     * @param {number} index - The starting index at which to write data into the buffer. Will be
     * used instead of the iterator's current index.
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} inputArray - The input array to read data from.
     * @param {number} inputIndex - The input index at which to read from the input array.
     */
    setFromArray(index: number, inputArray: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, inputIndex: number): void;
    /**
     * Get a attribute component at the iterator's current index.
     *
     * @param {number} offset - The component offset. Should be either 0, 1, 2, or 3.
     * @returns {number} The value of a attribute component.
     */
    get(offset: number): number;
}

/**
 * Base class for all post effects. Post effects take a a render target as input apply effects to
 * it and then render the result to an output render target or the screen if no output is
 * specified.
 *
 * @category Graphics
 */
declare class PostEffect {
    /**
     * A simple vertex shader used to render a quad, which requires 'vec2 aPosition' in the vertex
     * buffer, and generates uv coordinates vUv0 for use in the fragment shader.
     *
     * @type {string}
     */
    static quadVertexShader: string;
    /**
     * Create a new PostEffect instance.
     *
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} graphicsDevice -
     * The graphics device of the application.
     */
    constructor(graphicsDevice: GraphicsDevice);
    /**
     * The graphics device of the application.
     *
     * @type {import('../../platform/graphics/graphics-device.js').GraphicsDevice}
     */
    device: GraphicsDevice;
    /**
     * The property that should to be set to `true` (by the custom post effect) if a depth map
     * is necessary (default is false).
     *
     * @type {boolean}
     */
    needsDepthBuffer: boolean;
    /**
     * Render the post effect using the specified inputTarget to the specified outputTarget.
     *
     * @param {import('../../platform/graphics/render-target.js').RenderTarget} inputTarget - The
     * input render target.
     * @param {import('../../platform/graphics/render-target.js').RenderTarget} outputTarget - The
     * output render target. If null then this will be the screen.
     * @param {import('../../core/math/vec4.js').Vec4} [rect] - The rect of the current camera. If
     * not specified, it will default to [0, 0, 1, 1].
     */
    render(inputTarget: RenderTarget, outputTarget: RenderTarget, rect?: Vec4): void;
    /**
     * Draw a screen-space rectangle in a render target, using a specified shader.
     *
     * @param {import('../../platform/graphics/render-target.js').RenderTarget|null} target - The
     * output render target.
     * @param {import('../../platform/graphics/shader.js').Shader} shader - The shader to be used
     * for drawing the rectangle.
     * @param {import('../../core/math/vec4.js').Vec4} [rect] - The normalized screen-space position
     * (rect.x, rect.y) and size (rect.z, rect.w) of the rectangle. Default is [0, 0, 1, 1].
     */
    drawQuad(target: RenderTarget | null, shader: Shader, rect?: Vec4): void;
}

/**
 * A skin contains data about the bones in a hierarchy that drive a skinned mesh animation.
 * Specifically, the skin stores the bone name and inverse bind matrix and for each bone. Inverse
 * bind matrices are instrumental in the mathematics of vertex skinning.
 *
 * @category Graphics
 */
declare class Skin {
    /**
     * Create a new Skin instance.
     *
     * @param {import('../platform/graphics/graphics-device.js').GraphicsDevice} graphicsDevice -
     * The graphics device used to manage this skin.
     * @param {import('../core/math/mat4.js').Mat4[]} ibp - The array of inverse bind matrices.
     * @param {string[]} boneNames - The array of bone names for the bones referenced by this skin.
     */
    constructor(graphicsDevice: GraphicsDevice, ibp: Mat4[], boneNames: string[]);
    device: GraphicsDevice;
    inverseBindPose: Mat4[];
    boneNames: string[];
}

/**
 * Base class that implements reference counting for objects.
 *
 * @ignore
 */
declare class RefCountedObject {
    /**
     * @type {number}
     * @private
     */
    private _refCount;
    /**
     * Increments the reference counter.
     */
    incRefCount(): void;
    /**
     * Decrements the reference counter.
     */
    decRefCount(): void;
    /**
     * The current reference count.
     *
     * @type {number}
     */
    get refCount(): number;
}

/**
 * A graphical primitive. The mesh is defined by a {@link VertexBuffer} and an optional
 * {@link IndexBuffer}. It also contains a primitive definition which controls the type of the
 * primitive and the portion of the vertex or index buffer to use.
 *
 * ## Mesh APIs
 * There are two ways a mesh can be generated or updated.
 *
 * ### Simple Mesh API
 * {@link Mesh} class provides interfaces such as {@link Mesh#setPositions} and {@link Mesh#setUvs}
 * that provide a simple way to provide vertex and index data for the Mesh, and hiding the
 * complexity of creating the {@link VertexFormat}. This is the recommended interface to use.
 *
 * A simple example which creates a Mesh with 3 vertices, containing position coordinates only, to
 * form a single triangle.
 *
 * ```javascript
 * const mesh = new pc.Mesh(device);
 * const positions = [
 *     0, 0, 0, // pos 0
 *     1, 0, 0, // pos 1
 *     1, 1, 0  // pos 2
 * ];
 * mesh.setPositions(positions);
 * mesh.update();
 * ```
 *
 * An example which creates a Mesh with 4 vertices, containing position and uv coordinates in
 * channel 0, and an index buffer to form two triangles. Float32Array is used for positions and uvs.
 *
 * ```javascript
 * const mesh = new pc.Mesh(device);
 * const positions = new Float32Array([
 *     0, 0, 0, // pos 0
 *     1, 0, 0, // pos 1
 *     1, 1, 0, // pos 2
 *     0, 1, 0  // pos 3
 * ]);
 * const uvs = new Float32Array([
 *     0, 0, // uv 0
 *     1, 0, // uv 1
 *     1, 1, // uv 2
 *     0, 1  // uv 3
 * ]);
 * const indices = [
 *     0, 1, 2, // triangle 0
 *     0, 2, 3  // triangle 1
 * ];
 * mesh.setPositions(positions);
 * mesh.setUvs(0, uvs);
 * mesh.setIndices(indices);
 * mesh.update();
 * ```
 *
 * This example demonstrates that vertex attributes such as position and normals, and also indices
 * can be provided using Arrays ([]) and also Typed Arrays (Float32Array and similar). Note that
 * typed arrays have higher performance, and are generally recommended for per-frame operations or
 * larger meshes, but their construction using new operator is costly operation. If you only need
 * to operate on a small number of vertices or indices, consider using Arrays to avoid the overhead
 * associated with allocating Typed Arrays.
 *
 * Follow these links for more complex examples showing the functionality.
 *
 * - {@link https://playcanvas.github.io/#graphics/mesh-decals}
 * - {@link https://playcanvas.github.io/#graphics/mesh-deformation}
 * - {@link https://playcanvas.github.io/#graphics/mesh-generation}
 * - {@link https://playcanvas.github.io/#graphics/point-cloud-simulation}
 *
 * ### Update Vertex and Index buffers
 * This allows greater flexibility, but is more complex to use. It allows more advanced setups, for
 * example sharing a Vertex or Index Buffer between multiple meshes. See {@link VertexBuffer},
 * {@link IndexBuffer} and {@link VertexFormat} for details.
 *
 * @category Graphics
 */
declare class Mesh extends RefCountedObject {
    /**
     * Create a new Mesh instance.
     *
     * @param {import('../platform/graphics/graphics-device.js').GraphicsDevice} graphicsDevice -
     * The graphics device used to manage this mesh.
     */
    constructor(graphicsDevice: GraphicsDevice);
    /**
     * Internal version of aabb, incremented when local aabb changes.
     *
     * @ignore
     */
    _aabbVer: number;
    /**
     * aabb representing object space bounds of the mesh.
     *
     * @type {BoundingBox}
     */
    _aabb: BoundingBox;
    id: number;
    device: GraphicsDevice;
    /**
     * The vertex buffer holding the vertex data of the mesh.
     *
     * @type {VertexBuffer}
     */
    vertexBuffer: VertexBuffer;
    /**
     * An array of index buffers. For unindexed meshes, this array can be empty. The first
     * index buffer in the array is used by {@link MeshInstance}s with a renderStyle property
     * set to {@link RENDERSTYLE_SOLID}. The second index buffer in the array is used if
     * renderStyle is set to {@link RENDERSTYLE_WIREFRAME}.
     *
     * @type {IndexBuffer[]}
     */
    indexBuffer: IndexBuffer[];
    /**
     * Array of primitive objects defining how vertex (and index) data in the mesh should be
     * interpreted by the graphics device.
     *
     * - `type` is the type of primitive to render. Can be:
     *
     *   - {@link PRIMITIVE_POINTS}
     *   - {@link PRIMITIVE_LINES}
     *   - {@link PRIMITIVE_LINELOOP}
     *   - {@link PRIMITIVE_LINESTRIP}
     *   - {@link PRIMITIVE_TRIANGLES}
     *   - {@link PRIMITIVE_TRISTRIP}
     *   - {@link PRIMITIVE_TRIFAN}
     *
     * - `base` is the offset of the first index or vertex to dispatch in the draw call.
     * - `count` is the number of indices or vertices to dispatch in the draw call.
     * - `indexed` specifies whether to interpret the primitive as indexed, thereby using the
     * currently set index buffer.
     *
     * @type {Array.<{type: number, base: number, count: number, indexed: boolean|undefined}>}
     */
    primitive: Array<{
        type: number;
        base: number;
        count: number;
        indexed: boolean | undefined;
    }>;
    /**
     * The skin data (if any) that drives skinned mesh animations for this mesh.
     *
     * @type {import('./skin.js').Skin|null}
     */
    skin: Skin | null;
    _morph: any;
    _geometryData: GeometryData;
    boneAabb: any[];
    /**
     * The morph data (if any) that drives morph target animations for this mesh.
     *
     * @type {import('./morph.js').Morph|null}
     */
    set morph(arg: any);
    get morph(): any;
    /**
     * The axis-aligned bounding box for the object space vertices of this mesh.
     *
     * @type {BoundingBox}
     */
    set aabb(arg: BoundingBox);
    get aabb(): BoundingBox;
    /**
     * Destroys {@link VertexBuffer} and {@link IndexBuffer} associate with the mesh. This is
     * normally called by {@link Model#destroy} and does not need to be called manually.
     */
    destroy(): void;
    _destroyIndexBuffer(index: any): void;
    _initBoneAabbs(morphTargets: any): void;
    boneUsed: any[];
    _initGeometryData(): void;
    /**
     * Clears the mesh of existing vertices and indices and resets the {@link VertexFormat}
     * associated with the mesh. This call is typically followed by calls to methods such as
     * {@link Mesh#setPositions}, {@link Mesh#setVertexStream} or {@link Mesh#setIndices} and
     * finally {@link Mesh#update} to rebuild the mesh, allowing different {@link VertexFormat}.
     *
     * @param {boolean} [verticesDynamic] - Indicates the {@link VertexBuffer} should be created
     * with {@link BUFFER_DYNAMIC} usage. If not specified, {@link BUFFER_STATIC} is used.
     * @param {boolean} [indicesDynamic] - Indicates the {@link IndexBuffer} should be created with
     * {@link BUFFER_DYNAMIC} usage. If not specified, {@link BUFFER_STATIC} is used.
     * @param {number} [maxVertices] - A {@link VertexBuffer} will be allocated with at least
     * maxVertices, allowing additional vertices to be added to it without the allocation. If no
     * value is provided, a size to fit the provided vertices will be allocated.
     * @param {number} [maxIndices] - An {@link IndexBuffer} will be allocated with at least
     * maxIndices, allowing additional indices to be added to it without the allocation. If no
     * value is provided, a size to fit the provided indices will be allocated.
     */
    clear(verticesDynamic?: boolean, indicesDynamic?: boolean, maxVertices?: number, maxIndices?: number): void;
    /**
     * Sets the vertex data for any supported semantic.
     *
     * @param {string} semantic - The meaning of the vertex element. For supported semantics, see
     * SEMANTIC_* in {@link VertexFormat}.
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} data - Vertex
     * data for the specified semantic.
     * @param {number} componentCount - The number of values that form a single Vertex element. For
     * example when setting a 3D position represented by 3 numbers per vertex, number 3 should be
     * specified.
     * @param {number} [numVertices] - The number of vertices to be used from data array. If not
     * provided, the whole data array is used. This allows to use only part of the data array.
     * @param {number} [dataType] - The format of data when stored in the {@link VertexBuffer}, see
     * TYPE_* in {@link VertexFormat}. When not specified, {@link TYPE_FLOAT32} is used.
     * @param {boolean} [dataTypeNormalize] - If true, vertex attribute data will be mapped from a
     * 0 to 255 range down to 0 to 1 when fed to a shader. If false, vertex attribute data is left
     * unchanged. If this property is unspecified, false is assumed.
     */
    setVertexStream(semantic: string, data: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, componentCount: number, numVertices?: number, dataType?: number, dataTypeNormalize?: boolean): void;
    /**
     * Gets the vertex data corresponding to a semantic.
     *
     * @param {string} semantic - The semantic of the vertex element to get. For supported
     * semantics, see SEMANTIC_* in {@link VertexFormat}.
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} data - An
     * array to populate with the vertex data. When typed array is supplied, enough space needs to
     * be reserved, otherwise only partial data is copied.
     * @returns {number} Returns the number of vertices populated.
     */
    getVertexStream(semantic: string, data: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array): number;
    /**
     * Sets the vertex positions array. Vertices are stored using {@link TYPE_FLOAT32} format.
     *
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} positions - Vertex
     * data containing positions.
     * @param {number} [componentCount] - The number of values that form a single position element.
     * Defaults to 3 if not specified, corresponding to x, y and z coordinates.
     * @param {number} [numVertices] - The number of vertices to be used from data array. If not
     * provided, the whole data array is used. This allows to use only part of the data array.
     */
    setPositions(positions: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, componentCount?: number, numVertices?: number): void;
    /**
     * Sets the vertex normals array. Normals are stored using {@link TYPE_FLOAT32} format.
     *
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} normals - Vertex
     * data containing normals.
     * @param {number} [componentCount] - The number of values that form a single normal element.
     * Defaults to 3 if not specified, corresponding to x, y and z direction.
     * @param {number} [numVertices] - The number of vertices to be used from data array. If not
     * provided, the whole data array is used. This allows to use only part of the data array.
     */
    setNormals(normals: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, componentCount?: number, numVertices?: number): void;
    /**
     * Sets the vertex uv array. Uvs are stored using {@link TYPE_FLOAT32} format.
     *
     * @param {number} channel - The uv channel in [0..7] range.
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} uvs - Vertex
     * data containing uv-coordinates.
     * @param {number} [componentCount] - The number of values that form a single uv element.
     * Defaults to 2 if not specified, corresponding to u and v coordinates.
     * @param {number} [numVertices] - The number of vertices to be used from data array. If not
     * provided, the whole data array is used. This allows to use only part of the data array.
     */
    setUvs(channel: number, uvs: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, componentCount?: number, numVertices?: number): void;
    /**
     * Sets the vertex color array. Colors are stored using {@link TYPE_FLOAT32} format, which is
     * useful for HDR colors.
     *
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} colors - Vertex
     * data containing colors.
     * @param {number} [componentCount] - The number of values that form a single color element.
     * Defaults to 4 if not specified, corresponding to r, g, b and a.
     * @param {number} [numVertices] - The number of vertices to be used from data array. If not
     * provided, the whole data array is used. This allows to use only part of the data array.
     */
    setColors(colors: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, componentCount?: number, numVertices?: number): void;
    /**
     * Sets the vertex color array. Colors are stored using {@link TYPE_UINT8} format, which is
     * useful for LDR colors. Values in the array are expected in [0..255] range, and are mapped to
     * [0..1] range in the shader.
     *
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} colors - Vertex
     * data containing colors. The array is expected to contain 4 components per vertex,
     * corresponding to r, g, b and a.
     * @param {number} [numVertices] - The number of vertices to be used from data array. If not
     * provided, the whole data array is used. This allows to use only part of the data array.
     */
    setColors32(colors: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array, numVertices?: number): void;
    /**
     * Sets the index array. Indices are stored using 16-bit format by default, unless more than
     * 65535 vertices are specified, in which case 32-bit format is used.
     *
     * @param {number[]|Uint8Array|Uint16Array|Uint32Array} indices - The array of indices that
     * define primitives (lines, triangles, etc.).
     * @param {number} [numIndices] - The number of indices to be used from data array. If not
     * provided, the whole data array is used. This allows to use only part of the data array.
     */
    setIndices(indices: number[] | Uint8Array | Uint16Array | Uint32Array, numIndices?: number): void;
    /**
     * Gets the vertex positions data.
     *
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} positions - An
     * array to populate with the vertex data. When typed array is supplied, enough space needs to
     * be reserved, otherwise only partial data is copied.
     * @returns {number} Returns the number of vertices populated.
     */
    getPositions(positions: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array): number;
    /**
     * Gets the vertex normals data.
     *
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} normals - An
     * array to populate with the vertex data. When typed array is supplied, enough space needs to
     * be reserved, otherwise only partial data is copied.
     * @returns {number} Returns the number of vertices populated.
     */
    getNormals(normals: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array): number;
    /**
     * Gets the vertex uv data.
     *
     * @param {number} channel - The uv channel in [0..7] range.
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} uvs - An
     * array to populate with the vertex data. When typed array is supplied, enough space needs to
     * be reserved, otherwise only partial data is copied.
     * @returns {number} Returns the number of vertices populated.
     */
    getUvs(channel: number, uvs: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array): number;
    /**
     * Gets the vertex color data.
     *
     * @param {number[]|Int8Array|Uint8Array|Uint8ClampedArray|Int16Array|Uint16Array|Int32Array|Uint32Array|Float32Array} colors - An
     * array to populate with the vertex data. When typed array is supplied, enough space needs to
     * be reserved, otherwise only partial data is copied.
     * @returns {number} Returns the number of vertices populated.
     */
    getColors(colors: number[] | Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array): number;
    /**
     * Gets the index data.
     *
     * @param {number[]|Uint8Array|Uint16Array|Uint32Array} indices - An array to populate with the
     * index data. When a typed array is supplied, enough space needs to be reserved, otherwise
     * only partial data is copied.
     * @returns {number} Returns the number of indices populated.
     */
    getIndices(indices: number[] | Uint8Array | Uint16Array | Uint32Array): number;
    /**
     * Applies any changes to vertex stream and indices to mesh. This allocates or reallocates
     * {@link vertexBuffer} or {@link IndexBuffer} to fit all provided vertices and indices, and
     * fills them with data.
     *
     * @param {number} [primitiveType] - The type of primitive to render.  Can be:
     *
     * - {@link PRIMITIVE_POINTS}
     * - {@link PRIMITIVE_LINES}
     * - {@link PRIMITIVE_LINELOOP}
     * - {@link PRIMITIVE_LINESTRIP}
     * - {@link PRIMITIVE_TRIANGLES}
     * - {@link PRIMITIVE_TRISTRIP}
     * - {@link PRIMITIVE_TRIFAN}
     *
     * Defaults to {@link PRIMITIVE_TRIANGLES} if unspecified.
     * @param {boolean} [updateBoundingBox] - True to update bounding box. Bounding box is updated
     * only if positions were set since last time update was called, and componentCount for
     * position was 3, otherwise bounding box is not updated. See {@link Mesh#setPositions}.
     * Defaults to true if unspecified. Set this to false to avoid update of the bounding box and
     * use aabb property to set it instead.
     */
    update(primitiveType?: number, updateBoundingBox?: boolean): void;
    _buildVertexFormat(vertexCount: any): VertexFormat;
    _updateVertexBuffer(): void;
    _updateIndexBuffer(): void;
    prepareRenderState(renderStyle: any): void;
    updateRenderStates(): void;
    generateWireframe(): void;
}

declare class GeometryData {
    static DEFAULT_COMPONENTS_POSITION: number;
    static DEFAULT_COMPONENTS_NORMAL: number;
    static DEFAULT_COMPONENTS_UV: number;
    static DEFAULT_COMPONENTS_COLORS: number;
    initDefaults(): void;
    recreate: boolean;
    verticesUsage: number;
    indicesUsage: number;
    maxVertices: number;
    maxIndices: number;
    vertexCount: any;
    indexCount: number;
    vertexStreamsUpdated: boolean;
    indexStreamUpdated: boolean;
    vertexStreamDictionary: {};
    indices: any;
    _changeVertexCount(count: any, semantic: any): void;
}

/**
 * A Morph Target (also known as Blend Shape) contains deformation data to apply to existing mesh.
 * Multiple morph targets can be blended together on a mesh. This is useful for effects that are
 * hard to achieve with conventional animation and skinning.
 *
 * @category Graphics
 */
declare class MorphTarget {
    /**
     * Create a new MorphTarget instance.
     *
     * @param {object} options - Object for passing optional arguments.
     * @param {ArrayBuffer} options.deltaPositions - An array of 3-dimensional vertex position
     * offsets.
     * @param {number} options.deltaPositionsType - A format to store position offsets inside
     * {@link VertexBuffer}. Defaults to {@link TYPE_FLOAT32} if not provided.
     * @param {ArrayBuffer} [options.deltaNormals] - An array of 3-dimensional vertex normal
     * offsets.
     * @param {number} options.deltaNormalsType - A format to store normal offsets inside
     * {@link VertexBuffer}. Defaults to {@link TYPE_FLOAT32} if not provided.
     * @param {string} [options.name] - Name.
     * @param {BoundingBox} [options.aabb] - Bounding box. Will be automatically generated, if
     * undefined.
     * @param {number} [options.defaultWeight] - Default blend weight to use for this morph target.
     * @param {boolean} [options.preserveData] - When true, the morph target keeps its data passed using the options,
     * allowing the clone operation.
     */
    constructor(options: {
        deltaPositions: ArrayBuffer;
        deltaPositionsType: number;
        deltaNormals?: ArrayBuffer;
        deltaNormalsType: number;
        name?: string;
        aabb?: BoundingBox;
        defaultWeight?: number;
        preserveData?: boolean;
    }, ...args: any[]);
    /**
     * A used flag. A morph target can be used / owned by the Morph class only one time.
     *
     * @type {boolean}
     */
    used: boolean;
    options: {
        deltaPositions: ArrayBuffer;
        deltaPositionsType: number;
        deltaNormals?: ArrayBuffer;
        deltaNormalsType: number;
        name?: string;
        aabb?: BoundingBox;
        defaultWeight?: number;
        preserveData?: boolean;
    };
    _name: string;
    _defaultWeight: number;
    _aabb: BoundingBox;
    deltaPositions: ArrayBuffer;
    destroy(): void;
    _vertexBufferPositions: VertexBuffer;
    _vertexBufferNormals: VertexBuffer;
    texturePositions: any;
    textureNormals: any;
    /**
     * The name of the morph target.
     *
     * @type {string}
     */
    get name(): string;
    /**
     * The default weight of the morph target.
     *
     * @type {number}
     */
    get defaultWeight(): number;
    get aabb(): BoundingBox;
    get morphPositions(): boolean;
    get morphNormals(): boolean;
    /**
     * Returns an identical copy of the specified morph target. This can only be used if the morph target
     * was created with options.preserveData set to true.
     *
     * @returns {MorphTarget} A morph target instance containing the result of the cloning.
     */
    clone(): MorphTarget;
    _postInit(): void;
    _initVertexBuffers(graphicsDevice: any): void;
    _createVertexBuffer(device: any, data: any, dataType?: number): VertexBuffer;
    _setTexture(name: any, texture: any): void;
}

/**
 * Contains a list of {@link MorphTarget}, a combined delta AABB and some associated data.
 *
 * @category Graphics
 */
declare class Morph extends RefCountedObject {
    /**
     * Create a new Morph instance.
     *
     * @param {import('./morph-target.js').MorphTarget[]} targets - A list of morph targets.
     * @param {import('../platform/graphics/graphics-device.js').GraphicsDevice} graphicsDevice -
     * The graphics device used to manage this morph target.
     * @param {object} [options] - Object for passing optional arguments.
     * @param {boolean} [options.preferHighPrecision] - True if high precision storage should be
     * prefered. This is faster to create and allows higher precision, but takes more memory and
     * might be slower to render. Defaults to false.
     */
    constructor(targets: MorphTarget[], graphicsDevice: GraphicsDevice, { preferHighPrecision }?: {
        preferHighPrecision?: boolean;
    });
    /**
     * @type {BoundingBox}
     * @private
     */
    private _aabb;
    /** @type {boolean} */
    preferHighPrecision: boolean;
    device: GraphicsDevice;
    _targets: MorphTarget[];
    _renderTextureFormat: number;
    _textureFormat: number;
    _useTextureMorph: boolean;
    get aabb(): BoundingBox;
    get morphPositions(): boolean;
    get morphNormals(): boolean;
    get maxActiveTargets(): number;
    get useTextureMorph(): boolean;
    _init(): void;
    _findSparseSet(deltaArrays: any, ids: any, usedDataIndices: any, floatRounding: any): number;
    _initTextureBased(): boolean;
    morphTextureWidth: number;
    morphTextureHeight: number;
    vertexBufferIds: VertexBuffer;
    /**
     * Frees video memory allocated by this object.
     */
    destroy(): void;
    /**
     * The array of morph targets.
     *
     * @type {import('./morph-target.js').MorphTarget[]}
     */
    get targets(): MorphTarget[];
    _updateMorphFlags(): void;
    _morphPositions: boolean;
    _morphNormals: boolean;
    _createTexture(name: any, format: any): Texture;
}

/**
 * An instance of {@link Morph}. Contains weights to assign to every {@link MorphTarget}, manages
 * selection of active morph targets.
 *
 * @category Graphics
 */
declare class MorphInstance {
    /**
     * Create a new MorphInstance instance.
     *
     * @param {import('./morph.js').Morph} morph - The {@link Morph} to instance.
     */
    constructor(morph: Morph);
    /**
     * The morph with its targets, which is being instanced.
     *
     * @type {import('./morph.js').Morph}
     */
    morph: Morph;
    device: GraphicsDevice;
    _weights: any[];
    _weightMap: Map<any, any>;
    _activeTargets: any[];
    shaderCache: {};
    maxSubmitCount: any;
    _shaderMorphWeights: Float32Array;
    rtPositions: RenderTarget;
    rtNormals: RenderTarget;
    _textureParams: Float32Array;
    morphFactor: ScopeId;
    zeroTextures: boolean;
    _shaderMorphWeightsA: Float32Array;
    _shaderMorphWeightsB: Float32Array;
    _activeVertexBuffers: any[];
    /**
     * Frees video memory allocated by this object.
     */
    destroy(): void;
    shader: any;
    texturePositions: any;
    textureNormals: any;
    /**
     * Clones a MorphInstance. The returned clone uses the same {@link Morph} and weights are set
     * to defaults.
     *
     * @returns {MorphInstance} A clone of the specified MorphInstance.
     */
    clone(): MorphInstance;
    _getWeightIndex(key: any): any;
    /**
     * Gets current weight of the specified morph target.
     *
     * @param {string|number} key - An identifier for the morph target. Either the weight index or
     * the weight name.
     * @returns {number} Weight.
     */
    getWeight(key: string | number): number;
    /**
     * Sets weight of the specified morph target.
     *
     * @param {string|number} key - An identifier for the morph target. Either the weight index or
     * the weight name.
     * @param {number} weight - Weight.
     */
    setWeight(key: string | number, weight: number): void;
    _dirty: boolean;
    /**
     * Generate fragment shader to blend a number of textures using specified weights.
     *
     * @param {number} numTextures - Number of textures to blend.
     * @returns {string} Fragment shader.
     * @private
     */
    private _getFragmentShader;
    /**
     * Create complete shader for texture based morphing.
     *
     * @param {number} count - Number of textures to blend.
     * @returns {import('../platform/graphics/shader.js').Shader} Shader.
     * @private
     */
    private _getShader;
    _updateTextureRenderTarget(renderTarget: any, srcTextureName: any): void;
    _updateTextureMorph(): void;
    _updateVertexMorph(): void;
    /**
     * Selects active morph targets and prepares morph for rendering. Called automatically by
     * renderer.
     */
    update(): void;
}

/**
 * Set of tag names. Tags are automatically available on {@link Entity} and {@link Asset} as `tags`
 * field.
 *
 * @augments EventHandler
 */
declare class Tags extends EventHandler {
    /**
     * Fired for each individual tag that is added.
     *
     * @event
     * @example
     * tags.on('add', (tag, parent) => {
     *    console.log(`${tag} added to ${parent.name}`);
     * });
     */
    static EVENT_ADD: string;
    /**
     * Fired for each individual tag that is removed.
     *
     * @event
     * @example
     * tags.on('remove', (tag, parent) => {
     *   console.log(`${tag} removed from ${parent.name}`);
     * });
     */
    static EVENT_REMOVE: string;
    /**
     * Fired when tags have been added or removed. It will fire once on bulk changes, while `add`
     * and `remove` will fire on each tag operation.
     *
     * @event
     * @example
     * tags.on('change', (parent) => {
     *    console.log(`Tags changed on ${parent.name}`);
     * });
     */
    static EVENT_CHANGE: string;
    /**
     * Create an instance of a Tags.
     *
     * @param {object} [parent] - Parent object who tags belong to.
     */
    constructor(parent?: object);
    /** @private */
    private _index;
    /** @private */
    private _list;
    _parent: any;
    /**
     * Add a tag, duplicates are ignored. Can be array or comma separated arguments for multiple tags.
     *
     * @param {...*} name - Name of a tag, or array of tags.
     * @returns {boolean} True if any tag were added.
     * @example
     * tags.add('level-1');
     * @example
     * tags.add('ui', 'settings');
     * @example
     * tags.add(['level-2', 'mob']);
     */
    add(...args: any[]): boolean;
    /**
     * Remove tag.
     *
     * @param {...*} name - Name of a tag or array of tags.
     * @returns {boolean} True if any tag were removed.
     * @example
     * tags.remove('level-1');
     * @example
     * tags.remove('ui', 'settings');
     * @example
     * tags.remove(['level-2', 'mob']);
     */
    remove(...args: any[]): boolean;
    /**
     * Remove all tags.
     *
     * @example
     * tags.clear();
     */
    clear(): void;
    /**
     * Check if tags satisfy filters. Filters can be provided by simple name of tag, as well as by
     * array of tags. When an array is provided it will check if tags contain each tag within the
     * array. If any of comma separated argument is satisfied, then it will return true. Any number
     * of combinations are valid, and order is irrelevant.
     *
     * @param {...*} query - Name of a tag or array of tags.
     * @returns {boolean} True if filters are satisfied.
     * @example
     * tags.has('player'); // player
     * @example
     * tags.has('mob', 'player'); // player OR mob
     * @example
     * tags.has(['level-1', 'mob']); // monster AND level-1
     * @example
     * tags.has(['ui', 'settings'], ['ui', 'levels']); // (ui AND settings) OR (ui AND levels)
     */
    has(...args: any[]): boolean;
    /**
     * @param {string[]|string[][]} tags - Array of tags.
     * @returns {boolean} True if the supplied tags are present.
     * @private
     */
    private _has;
    /**
     * Returns immutable array of tags.
     *
     * @returns {string[]} Copy of tags array.
     */
    list(): string[];
    /**
     * @param {IArguments} args - Arguments to process.
     * @param {boolean} [flat] - If true, will flatten array of tags. Defaults to false.
     * @returns {string[]|string[][]} Array of tags.
     * @private
     */
    private _processArguments;
    /**
     * Number of tags in set.
     *
     * @type {number}
     */
    get size(): number;
}

/**
 * A 3x3 matrix.
 *
 * @category Math
 */
declare class Mat3 {
    /**
     * A constant matrix set to the identity.
     *
     * @type {Mat3}
     * @readonly
     */
    static readonly IDENTITY: Mat3;
    /**
     * A constant matrix with all elements set to 0.
     *
     * @type {Mat3}
     * @readonly
     */
    static readonly ZERO: Mat3;
    /**
     * Matrix elements in the form of a flat array.
     *
     * @type {Float32Array}
     */
    data: Float32Array;
    /**
     * Creates a duplicate of the specified matrix.
     *
     * @returns {this} A duplicate matrix.
     * @example
     * const src = new pc.Mat3().translate(10, 20, 30);
     * const dst = src.clone();
     * console.log("The two matrices are " + (src.equals(dst) ? "equal" : "different"));
     */
    clone(): this;
    /**
     * Copies the contents of a source 3x3 matrix to a destination 3x3 matrix.
     *
     * @param {Mat3} rhs - A 3x3 matrix to be copied.
     * @returns {Mat3} Self for chaining.
     * @example
     * const src = new pc.Mat3().translate(10, 20, 30);
     * const dst = new pc.Mat3();
     * dst.copy(src);
     * console.log("The two matrices are " + (src.equals(dst) ? "equal" : "different"));
     */
    copy(rhs: Mat3): Mat3;
    /**
     * Copies the contents of a source array[9] to a destination 3x3 matrix.
     *
     * @param {number[]} src - An array[9] to be copied.
     * @returns {Mat3} Self for chaining.
     * @example
     * const dst = new pc.Mat3();
     * dst.set([0, 1, 2, 3, 4, 5, 6, 7, 8]);
     */
    set(src: number[]): Mat3;
    /**
     * Extracts the x-axis from the specified matrix.
     *
     * @param {Vec3} [x] - The vector to receive the x axis of the matrix.
     * @returns {Vec3} The x-axis of the specified matrix.
     */
    getX(x?: Vec3): Vec3;
    /**
     * Extracts the y-axis from the specified matrix.
     *
     * @param {Vec3} [y] - The vector to receive the y axis of the matrix.
     * @returns {Vec3} The y-axis of the specified matrix.
     */
    getY(y?: Vec3): Vec3;
    /**
     * Extracts the z-axis from the specified matrix.
     *
     * @param {Vec3} [z] - The vector to receive the z axis of the matrix.
     * @returns {Vec3} The z-axis of the specified matrix.
     */
    getZ(z?: Vec3): Vec3;
    /**
     * Reports whether two matrices are equal.
     *
     * @param {Mat3} rhs - The other matrix.
     * @returns {boolean} True if the matrices are equal and false otherwise.
     * @example
     * const a = new pc.Mat3().translate(10, 20, 30);
     * const b = new pc.Mat3();
     * console.log("The two matrices are " + (a.equals(b) ? "equal" : "different"));
     */
    equals(rhs: Mat3): boolean;
    /**
     * Reports whether the specified matrix is the identity matrix.
     *
     * @returns {boolean} True if the matrix is identity and false otherwise.
     * @example
     * const m = new pc.Mat3();
     * console.log("The matrix is " + (m.isIdentity() ? "identity" : "not identity"));
     */
    isIdentity(): boolean;
    /**
     * Sets the matrix to the identity matrix.
     *
     * @returns {Mat3} Self for chaining.
     * @example
     * m.setIdentity();
     * console.log("The matrix is " + (m.isIdentity() ? "identity" : "not identity"));
     */
    setIdentity(): Mat3;
    /**
     * Converts the matrix to string form.
     *
     * @returns {string} The matrix in string form.
     * @example
     * const m = new pc.Mat3();
     * // Outputs [1, 0, 0, 0, 1, 0, 0, 0, 1]
     * console.log(m.toString());
     */
    toString(): string;
    /**
     * Generates the transpose of the specified 3x3 matrix.
     *
     * @param {Mat3} [src] - The matrix to transpose. If not set, the matrix is transposed in-place.
     * @returns {Mat3} Self for chaining.
     * @example
     * const m = new pc.Mat3();
     *
     * // Transpose in place
     * m.transpose();
     */
    transpose(src?: Mat3): Mat3;
    /**
     * Converts the specified 4x4 matrix to a Mat3.
     *
     * @param {import('./mat4.js').Mat4} m - The 4x4 matrix to convert.
     * @returns {Mat3} Self for chaining.
     */
    setFromMat4(m: Mat4): Mat3;
    /**
     * Set the matrix to the inverse of the specified 4x4 matrix.
     *
     * @param {import('./mat4.js').Mat4} src - The 4x4 matrix to invert.
     * @returns {Mat3} Self for chaining.
     *
     * @ignore
     */
    invertMat4(src: Mat4): Mat3;
    /**
     * Transforms a 3-dimensional vector by a 3x3 matrix.
     *
     * @param {Vec3} vec - The 3-dimensional vector to be transformed.
     * @param {Vec3} [res] - An optional 3-dimensional vector to receive the result of the
     * transformation.
     * @returns {Vec3} The input vector v transformed by the current instance.
     */
    transformVector(vec: Vec3, res?: Vec3): Vec3;
}

/**
 * Callback used by {@link GraphNodefind } and {@link GraphNodefindOne } to search through a graph
 * node and all of its descendants.
 */
export type FindNodeCallback = (node: GraphNode) => boolean;
/**
 * Callback used by {@link GraphNodeforEach } to iterate through a graph node and all of its
 * descendants.
 */
export type ForEachNodeCallback = (node: GraphNode) => any;
/**
 * Callback used by {@link GraphNode#find} and {@link GraphNode#findOne} to search through a graph
 * node and all of its descendants.
 *
 * @callback FindNodeCallback
 * @param {GraphNode} node - The current graph node.
 * @returns {boolean} Returning `true` will result in that node being returned from
 * {@link GraphNode#find} or {@link GraphNode#findOne}.
 */
/**
 * Callback used by {@link GraphNode#forEach} to iterate through a graph node and all of its
 * descendants.
 *
 * @callback ForEachNodeCallback
 * @param {GraphNode} node - The current graph node.
 */
/**
 * A hierarchical scene node.
 *
 * @augments EventHandler
 */
declare class GraphNode extends EventHandler {
    /**
     * Create a new GraphNode instance.
     *
     * @param {string} [name] - The non-unique name of a graph node. Defaults to 'Untitled'.
     */
    constructor(name?: string);
    /**
     * The non-unique name of a graph node. Defaults to 'Untitled'.
     *
     * @type {string}
     */
    name: string;
    /**
     * Interface for tagging graph nodes. Tag based searches can be performed using the
     * {@link GraphNode#findByTag} function.
     *
     * @type {Tags}
     */
    tags: Tags;
    /** @private */
    private _labels;
    /**
     * @type {Vec3}
     * @private
     */
    private localPosition;
    /**
     * @type {Quat}
     * @private
     */
    private localRotation;
    /**
     * @type {Vec3}
     * @private
     */
    private localScale;
    /**
     * @type {Vec3}
     * @private
     */
    private localEulerAngles;
    /**
     * @type {Vec3}
     * @private
     */
    private position;
    /**
     * @type {Quat}
     * @private
     */
    private rotation;
    /**
     * @type {Vec3}
     * @private
     */
    private eulerAngles;
    /**
     * @type {Vec3|null}
     * @private
     */
    private _scale;
    /**
     * @type {Mat4}
     * @private
     */
    private localTransform;
    /**
     * @type {boolean}
     * @private
     */
    private _dirtyLocal;
    /**
     * @type {number}
     * @private
     */
    private _aabbVer;
    /**
     * Marks the node to ignore hierarchy sync entirely (including children nodes). The engine code
     * automatically freezes and unfreezes objects whenever required. Segregating dynamic and
     * stationary nodes into subhierarchies allows to reduce sync time significantly.
     *
     * @type {boolean}
     * @private
     */
    private _frozen;
    /**
     * @type {Mat4}
     * @private
     */
    private worldTransform;
    /**
     * @type {boolean}
     * @private
     */
    private _dirtyWorld;
    /**
     * Cached value representing the negatively scaled world transform. If the value is 0, this
     * marks this value as dirty and it needs to be recalculated. If the value is 1, the world
     * transform is not negatively scaled. If the value is -1, the world transform is negatively
     * scaled.
     *
     * @type {number}
     * @private
     */
    private _worldScaleSign;
    /**
     * @type {Mat3}
     * @private
     */
    private _normalMatrix;
    /**
     * @type {boolean}
     * @private
     */
    private _dirtyNormal;
    /**
     * @type {Vec3|null}
     * @private
     */
    private _right;
    /**
     * @type {Vec3|null}
     * @private
     */
    private _up;
    /**
     * @type {Vec3|null}
     * @private
     */
    private _forward;
    /**
     * @type {GraphNode|null}
     * @private
     */
    private _parent;
    /**
     * @type {GraphNode[]}
     * @private
     */
    private _children;
    /**
     * @type {number}
     * @private
     */
    private _graphDepth;
    /**
     * Represents enabled state of the entity. If the entity is disabled, the entity including all
     * children are excluded from updates.
     *
     * @type {boolean}
     * @private
     */
    private _enabled;
    /**
     * Represents enabled state of the entity in the hierarchy. It's true only if this entity and
     * all parent entities all the way to the scene's root are enabled.
     *
     * @type {boolean}
     * @private
     */
    private _enabledInHierarchy;
    /**
     * @type {boolean}
     * @ignore
     */
    scaleCompensation: boolean;
    /**
     * The normalized local space X-axis vector of the graph node in world space.
     *
     * @type {Vec3}
     */
    get right(): Vec3;
    /**
     * The normalized local space Y-axis vector of the graph node in world space.
     *
     * @type {Vec3}
     */
    get up(): Vec3;
    /**
     * The normalized local space negative Z-axis vector of the graph node in world space.
     *
     * @type {Vec3}
     */
    get forward(): Vec3;
    /**
     * A matrix used to transform the normal.
     *
     * @type  {Mat3}
     * @ignore
     */
    get normalMatrix(): Mat3;
    /**
     * Enable or disable a GraphNode. If one of the GraphNode's parents is disabled there will be
     * no other side effects. If all the parents are enabled then the new value will activate or
     * deactivate all the enabled children of the GraphNode.
     *
     * @type {boolean}
     */
    set enabled(arg: boolean);
    get enabled(): boolean;
    /**
     * A read-only property to get a parent graph node.
     *
     * @type {GraphNode|null}
     */
    get parent(): GraphNode;
    /**
     * A read-only property to get the path of the graph node relative to the root of the hierarchy.
     *
     * @type {string}
     */
    get path(): string;
    /**
     * A read-only property to get highest graph node from current node.
     *
     * @type {GraphNode}
     */
    get root(): GraphNode;
    /**
     * A read-only property to get the children of this graph node.
     *
     * @type {GraphNode[]}
     */
    get children(): GraphNode[];
    /**
     * A read-only property to get the depth of this child within the graph. Note that for
     * performance reasons this is only recalculated when a node is added to a new parent, i.e. It
     * is not recalculated when a node is simply removed from the graph.
     *
     * @type {number}
     */
    get graphDepth(): number;
    /**
     * @param {GraphNode} node - Graph node to update.
     * @param {boolean} enabled - True if enabled in the hierarchy, false if disabled.
     * @private
     */
    private _notifyHierarchyStateChanged;
    /**
     * Called when the enabled flag of the entity or one of its parents changes.
     *
     * @param {boolean} enabled - True if enabled in the hierarchy, false if disabled.
     * @private
     */
    private _onHierarchyStateChanged;
    /**
     * @param {this} clone - The cloned graph node to copy into.
     * @private
     */
    private _cloneInternal;
    /**
     * Clone a graph node.
     *
     * @returns {this} A clone of the specified graph node.
     */
    clone(): this;
    /**
     * Copy a graph node.
     *
     * @param {GraphNode} source - The graph node to copy.
     * @returns {GraphNode} The destination graph node.
     * @ignore
     */
    copy(source: GraphNode): GraphNode;
    /**
     * Detach a GraphNode from the hierarchy and recursively destroy all children.
     *
     * @example
     * const firstChild = this.entity.children[0];
     * firstChild.destroy(); // delete child, all components and remove from hierarchy
     */
    destroy(): void;
    /**
     * Search the graph node and all of its descendants for the nodes that satisfy some search
     * criteria.
     *
     * @param {FindNodeCallback|string} attr - This can either be a function or a string. If it's a
     * function, it is executed for each descendant node to test if node satisfies the search
     * logic. Returning true from the function will include the node into the results. If it's a
     * string then it represents the name of a field or a method of the node. If this is the name
     * of a field then the value passed as the second argument will be checked for equality. If
     * this is the name of a function then the return value of the function will be checked for
     * equality against the valued passed as the second argument to this function.
     * @param {object} [value] - If the first argument (attr) is a property name then this value
     * will be checked against the value of the property.
     * @returns {GraphNode[]} The array of graph nodes that match the search criteria.
     * @example
     * // Finds all nodes that have a model component and have 'door' in their lower-cased name
     * const doors = house.find(function (node) {
     *     return node.model && node.name.toLowerCase().indexOf('door') !== -1;
     * });
     * @example
     * // Finds all nodes that have the name property set to 'Test'
     * const entities = parent.find('name', 'Test');
     */
    find(attr: FindNodeCallback | string, value?: object): GraphNode[];
    /**
     * Search the graph node and all of its descendants for the first node that satisfies some
     * search criteria.
     *
     * @param {FindNodeCallback|string} attr - This can either be a function or a string. If it's a
     * function, it is executed for each descendant node to test if node satisfies the search
     * logic. Returning true from the function will result in that node being returned from
     * findOne. If it's a string then it represents the name of a field or a method of the node. If
     * this is the name of a field then the value passed as the second argument will be checked for
     * equality. If this is the name of a function then the return value of the function will be
     * checked for equality against the valued passed as the second argument to this function.
     * @param {object} [value] - If the first argument (attr) is a property name then this value
     * will be checked against the value of the property.
     * @returns {GraphNode|null} A graph node that match the search criteria. Returns null if no
     * node is found.
     * @example
     * // Find the first node that is called 'head' and has a model component
     * const head = player.findOne(function (node) {
     *     return node.model && node.name === 'head';
     * });
     * @example
     * // Finds the first node that has the name property set to 'Test'
     * const node = parent.findOne('name', 'Test');
     */
    findOne(attr: FindNodeCallback | string, value?: object): GraphNode | null;
    /**
     * Return all graph nodes that satisfy the search query. Query can be simply a string, or comma
     * separated strings, to have inclusive results of assets that match at least one query. A
     * query that consists of an array of tags can be used to match graph nodes that have each tag
     * of array.
     *
     * @param {...*} query - Name of a tag or array of tags.
     * @returns {GraphNode[]} A list of all graph nodes that match the query.
     * @example
     * // Return all graph nodes that tagged by `animal`
     * const animals = node.findByTag("animal");
     * @example
     * // Return all graph nodes that tagged by `bird` OR `mammal`
     * const birdsAndMammals = node.findByTag("bird", "mammal");
     * @example
     * // Return all assets that tagged by `carnivore` AND `mammal`
     * const meatEatingMammals = node.findByTag(["carnivore", "mammal"]);
     * @example
     * // Return all assets that tagged by (`carnivore` AND `mammal`) OR (`carnivore` AND `reptile`)
     * const meatEatingMammalsAndReptiles = node.findByTag(["carnivore", "mammal"], ["carnivore", "reptile"]);
     */
    findByTag(...args: any[]): GraphNode[];
    /**
     * Get the first node found in the graph with the name. The search is depth first.
     *
     * @param {string} name - The name of the graph.
     * @returns {GraphNode|null} The first node to be found matching the supplied name. Returns
     * null if no node is found.
     */
    findByName(name: string): GraphNode | null;
    /**
     * Get the first node found in the graph by its full path in the graph. The full path has this
     * form 'parent/child/sub-child'. The search is depth first.
     *
     * @param {string|string[]} path - The full path of the {@link GraphNode} as either a string or
     * array of {@link GraphNode} names.
     * @returns {GraphNode|null} The first node to be found matching the supplied path. Returns
     * null if no node is found.
     * @example
     * // String form
     * const grandchild = this.entity.findByPath('child/grandchild');
     * @example
     * // Array form
     * const grandchild = this.entity.findByPath(['child', 'grandchild']);
     */
    findByPath(path: string | string[]): GraphNode | null;
    /**
     * Executes a provided function once on this graph node and all of its descendants.
     *
     * @param {ForEachNodeCallback} callback - The function to execute on the graph node and each
     * descendant.
     * @param {object} [thisArg] - Optional value to use as this when executing callback function.
     * @example
     * // Log the path and name of each node in descendant tree starting with "parent"
     * parent.forEach(function (node) {
     *     console.log(node.path + "/" + node.name);
     * });
     */
    forEach(callback: ForEachNodeCallback, thisArg?: object): void;
    /**
     * Check if node is descendant of another node.
     *
     * @param {GraphNode} node - Potential ancestor of node.
     * @returns {boolean} If node is descendant of another node.
     * @example
     * if (roof.isDescendantOf(house)) {
     *     // roof is descendant of house entity
     * }
     */
    isDescendantOf(node: GraphNode): boolean;
    /**
     * Check if node is ancestor for another node.
     *
     * @param {GraphNode} node - Potential descendant of node.
     * @returns {boolean} If node is ancestor for another node.
     * @example
     * if (body.isAncestorOf(foot)) {
     *     // foot is within body's hierarchy
     * }
     */
    isAncestorOf(node: GraphNode): boolean;
    /**
     * Get the world space rotation for the specified GraphNode in Euler angle form. The rotation
     * is returned as euler angles in a {@link Vec3}. The value returned by this function should be
     * considered read-only. In order to set the world-space rotation of the graph node, use
     * {@link GraphNode#setEulerAngles}.
     *
     * @returns {Vec3} The world space rotation of the graph node in Euler angle form.
     * @example
     * const angles = this.entity.getEulerAngles();
     * angles.y = 180; // rotate the entity around Y by 180 degrees
     * this.entity.setEulerAngles(angles);
     */
    getEulerAngles(): Vec3;
    /**
     * Get the rotation in local space for the specified GraphNode. The rotation is returned as
     * euler angles in a {@link Vec3}. The returned vector should be considered read-only. To
     * update the local rotation, use {@link GraphNode#setLocalEulerAngles}.
     *
     * @returns {Vec3} The local space rotation of the graph node as euler angles in XYZ order.
     * @example
     * const angles = this.entity.getLocalEulerAngles();
     * angles.y = 180;
     * this.entity.setLocalEulerAngles(angles);
     */
    getLocalEulerAngles(): Vec3;
    /**
     * Get the position in local space for the specified GraphNode. The position is returned as a
     * {@link Vec3}. The returned vector should be considered read-only. To update the local
     * position, use {@link GraphNode#setLocalPosition}.
     *
     * @returns {Vec3} The local space position of the graph node.
     * @example
     * const position = this.entity.getLocalPosition();
     * position.x += 1; // move the entity 1 unit along x.
     * this.entity.setLocalPosition(position);
     */
    getLocalPosition(): Vec3;
    /**
     * Get the rotation in local space for the specified GraphNode. The rotation is returned as a
     * {@link Quat}. The returned quaternion should be considered read-only. To update the local
     * rotation, use {@link GraphNode#setLocalRotation}.
     *
     * @returns {Quat} The local space rotation of the graph node as a quaternion.
     * @example
     * const rotation = this.entity.getLocalRotation();
     */
    getLocalRotation(): Quat;
    /**
     * Get the scale in local space for the specified GraphNode. The scale is returned as a
     * {@link Vec3}. The returned vector should be considered read-only. To update the local scale,
     * use {@link GraphNode#setLocalScale}.
     *
     * @returns {Vec3} The local space scale of the graph node.
     * @example
     * const scale = this.entity.getLocalScale();
     * scale.x = 100;
     * this.entity.setLocalScale(scale);
     */
    getLocalScale(): Vec3;
    /**
     * Get the local transform matrix for this graph node. This matrix is the transform relative to
     * the node's parent's world transformation matrix.
     *
     * @returns {Mat4} The node's local transformation matrix.
     * @example
     * const transform = this.entity.getLocalTransform();
     */
    getLocalTransform(): Mat4;
    /**
     * Get the world space position for the specified GraphNode. The position is returned as a
     * {@link Vec3}. The value returned by this function should be considered read-only. In order
     * to set the world-space position of the graph node, use {@link GraphNode#setPosition}.
     *
     * @returns {Vec3} The world space position of the graph node.
     * @example
     * const position = this.entity.getPosition();
     * position.x = 10;
     * this.entity.setPosition(position);
     */
    getPosition(): Vec3;
    /**
     * Get the world space rotation for the specified GraphNode. The rotation is returned as a
     * {@link Quat}. The value returned by this function should be considered read-only. In order
     * to set the world-space rotation of the graph node, use {@link GraphNode#setRotation}.
     *
     * @returns {Quat} The world space rotation of the graph node as a quaternion.
     * @example
     * const rotation = this.entity.getRotation();
     */
    getRotation(): Quat;
    /**
     * Get the world space scale for the specified GraphNode. The returned value will only be
     * correct for graph nodes that have a non-skewed world transform (a skew can be introduced by
     * the compounding of rotations and scales higher in the graph node hierarchy). The scale is
     * returned as a {@link Vec3}. The value returned by this function should be considered
     * read-only. Note that it is not possible to set the world space scale of a graph node
     * directly.
     *
     * @returns {Vec3} The world space scale of the graph node.
     * @example
     * const scale = this.entity.getScale();
     * @ignore
     */
    getScale(): Vec3;
    /**
     * Get the world transformation matrix for this graph node.
     *
     * @returns {Mat4} The node's world transformation matrix.
     * @example
     * const transform = this.entity.getWorldTransform();
     */
    getWorldTransform(): Mat4;
    /**
     * Returns cached value of negative scale of the world transform.
     *
     * @returns {number} -1 if world transform has negative scale, 1 otherwise.
     * @ignore
     */
    get worldScaleSign(): number;
    /**
     * Remove graph node from current parent.
     */
    remove(): void;
    /**
     * Remove graph node from current parent and add as child to new parent.
     *
     * @param {GraphNode} parent - New parent to attach graph node to.
     * @param {number} [index] - The child index where the child node should be placed.
     */
    reparent(parent: GraphNode, index?: number): void;
    /**
     * Sets the local-space rotation of the specified graph node using euler angles. Eulers are
     * interpreted in XYZ order. Eulers must be specified in degrees. This function has two valid
     * signatures: you can either pass a 3D vector or 3 numbers to specify the local-space euler
     * rotation.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding eulers or rotation around local-space
     * x-axis in degrees.
     * @param {number} [y] - Rotation around local-space y-axis in degrees.
     * @param {number} [z] - Rotation around local-space z-axis in degrees.
     * @example
     * // Set rotation of 90 degrees around y-axis via 3 numbers
     * this.entity.setLocalEulerAngles(0, 90, 0);
     * @example
     * // Set rotation of 90 degrees around y-axis via a vector
     * const angles = new pc.Vec3(0, 90, 0);
     * this.entity.setLocalEulerAngles(angles);
     */
    setLocalEulerAngles(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Sets the local-space position of the specified graph node. This function has two valid
     * signatures: you can either pass a 3D vector or 3 numbers to specify the local-space
     * position.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding local-space position or
     * x-coordinate of local-space position.
     * @param {number} [y] - Y-coordinate of local-space position.
     * @param {number} [z] - Z-coordinate of local-space position.
     * @example
     * // Set via 3 numbers
     * this.entity.setLocalPosition(0, 10, 0);
     * @example
     * // Set via vector
     * const pos = new pc.Vec3(0, 10, 0);
     * this.entity.setLocalPosition(pos);
     */
    setLocalPosition(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Sets the local-space rotation of the specified graph node. This function has two valid
     * signatures: you can either pass a quaternion or 3 numbers to specify the local-space
     * rotation.
     *
     * @param {Quat|number} x - Quaternion holding local-space rotation or x-component of
     * local-space quaternion rotation.
     * @param {number} [y] - Y-component of local-space quaternion rotation.
     * @param {number} [z] - Z-component of local-space quaternion rotation.
     * @param {number} [w] - W-component of local-space quaternion rotation.
     * @example
     * // Set via 4 numbers
     * this.entity.setLocalRotation(0, 0, 0, 1);
     * @example
     * // Set via quaternion
     * const q = pc.Quat();
     * this.entity.setLocalRotation(q);
     */
    setLocalRotation(x: Quat | number, y?: number, z?: number, w?: number): void;
    /**
     * Sets the local-space scale factor of the specified graph node. This function has two valid
     * signatures: you can either pass a 3D vector or 3 numbers to specify the local-space scale.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding local-space scale or x-coordinate
     * of local-space scale.
     * @param {number} [y] - Y-coordinate of local-space scale.
     * @param {number} [z] - Z-coordinate of local-space scale.
     * @example
     * // Set via 3 numbers
     * this.entity.setLocalScale(10, 10, 10);
     * @example
     * // Set via vector
     * const scale = new pc.Vec3(10, 10, 10);
     * this.entity.setLocalScale(scale);
     */
    setLocalScale(x: Vec3 | number, y?: number, z?: number): void;
    /** @private */
    private _dirtifyLocal;
    /** @private */
    private _unfreezeParentToRoot;
    /** @private */
    private _dirtifyWorld;
    /** @private */
    private _dirtifyWorldInternal;
    /**
     * Sets the world-space position of the specified graph node. This function has two valid
     * signatures: you can either pass a 3D vector or 3 numbers to specify the world-space
     * position.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding world-space position or
     * x-coordinate of world-space position.
     * @param {number} [y] - Y-coordinate of world-space position.
     * @param {number} [z] - Z-coordinate of world-space position.
     * @example
     * // Set via 3 numbers
     * this.entity.setPosition(0, 10, 0);
     * @example
     * // Set via vector
     * const position = new pc.Vec3(0, 10, 0);
     * this.entity.setPosition(position);
     */
    setPosition(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Sets the world-space rotation of the specified graph node. This function has two valid
     * signatures: you can either pass a quaternion or 3 numbers to specify the world-space
     * rotation.
     *
     * @param {Quat|number} x - Quaternion holding world-space rotation or x-component of
     * world-space quaternion rotation.
     * @param {number} [y] - Y-component of world-space quaternion rotation.
     * @param {number} [z] - Z-component of world-space quaternion rotation.
     * @param {number} [w] - W-component of world-space quaternion rotation.
     * @example
     * // Set via 4 numbers
     * this.entity.setRotation(0, 0, 0, 1);
     * @example
     * // Set via quaternion
     * const q = pc.Quat();
     * this.entity.setRotation(q);
     */
    setRotation(x: Quat | number, y?: number, z?: number, w?: number): void;
    /**
     * Sets the world-space rotation of the specified graph node using euler angles. Eulers are
     * interpreted in XYZ order. Eulers must be specified in degrees. This function has two valid
     * signatures: you can either pass a 3D vector or 3 numbers to specify the world-space euler
     * rotation.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding eulers or rotation around world-space
     * x-axis in degrees.
     * @param {number} [y] - Rotation around world-space y-axis in degrees.
     * @param {number} [z] - Rotation around world-space z-axis in degrees.
     * @example
     * // Set rotation of 90 degrees around world-space y-axis via 3 numbers
     * this.entity.setEulerAngles(0, 90, 0);
     * @example
     * // Set rotation of 90 degrees around world-space y-axis via a vector
     * const angles = new pc.Vec3(0, 90, 0);
     * this.entity.setEulerAngles(angles);
     */
    setEulerAngles(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Add a new child to the child list and update the parent value of the child node.
     * If the node already had a parent, it is removed from its child list.
     *
     * @param {GraphNode} node - The new child to add.
     * @example
     * const e = new pc.Entity(app);
     * this.entity.addChild(e);
     */
    addChild(node: GraphNode): void;
    /**
     * Add a child to this node, maintaining the child's transform in world space.
     * If the node already had a parent, it is removed from its child list.
     *
     * @param {GraphNode} node - The child to add.
     * @example
     * const e = new pc.Entity(app);
     * this.entity.addChildAndSaveTransform(e);
     * @ignore
     */
    addChildAndSaveTransform(node: GraphNode): void;
    /**
     * Insert a new child to the child list at the specified index and update the parent value of
     * the child node. If the node already had a parent, it is removed from its child list.
     *
     * @param {GraphNode} node - The new child to insert.
     * @param {number} index - The index in the child list of the parent where the new node will be
     * inserted.
     * @example
     * const e = new pc.Entity(app);
     * this.entity.insertChild(e, 1);
     */
    insertChild(node: GraphNode, index: number): void;
    /**
     * Prepares node for being inserted to a parent node, and removes it from the previous parent.
     *
     * @param {GraphNode} node - The node being inserted.
     * @private
     */
    private _prepareInsertChild;
    /**
     * Fires an event on all children of the node. The event `name` is fired on the first (root)
     * node only. The event `nameHierarchy` is fired for all children.
     *
     * @param {string} name - The name of the event to fire on the root.
     * @param {string} nameHierarchy - The name of the event to fire for all descendants.
     * @param {GraphNode} parent - The parent of the node being added/removed from the hierarchy.
     * @private
     */
    private _fireOnHierarchy;
    /**
     * Called when a node is inserted into a node's child list.
     *
     * @param {GraphNode} node - The node that was inserted.
     * @private
     */
    private _onInsertChild;
    /**
     * Recurse the hierarchy and update the graph depth at each node.
     *
     * @private
     */
    private _updateGraphDepth;
    /**
     * Remove the node from the child list and update the parent value of the child.
     *
     * @param {GraphNode} child - The node to remove.
     * @example
     * const child = this.entity.children[0];
     * this.entity.removeChild(child);
     */
    removeChild(child: GraphNode): void;
    _sync(): void;
    /**
     * Updates the world transformation matrices at this node and all of its descendants.
     *
     * @ignore
     */
    syncHierarchy(): void;
    /**
     * Reorients the graph node so that the negative z-axis points towards the target. This
     * function has two valid signatures. Either pass 3D vectors for the look at coordinate and up
     * vector, or pass numbers to represent the vectors.
     *
     * @param {Vec3|number} x - If passing a 3D vector, this is the world-space coordinate to look at.
     * Otherwise, it is the x-component of the world-space coordinate to look at.
     * @param {Vec3|number} [y] - If passing a 3D vector, this is the world-space up vector for look at
     * transform. Otherwise, it is the y-component of the world-space coordinate to look at.
     * @param {number} [z] - Z-component of the world-space coordinate to look at.
     * @param {number} [ux] - X-component of the up vector for the look at transform. Defaults to 0.
     * @param {number} [uy] - Y-component of the up vector for the look at transform. Defaults to 1.
     * @param {number} [uz] - Z-component of the up vector for the look at transform. Defaults to 0.
     * @example
     * // Look at another entity, using the (default) positive y-axis for up
     * const position = otherEntity.getPosition();
     * this.entity.lookAt(position);
     * @example
     * // Look at another entity, using the negative world y-axis for up
     * const position = otherEntity.getPosition();
     * this.entity.lookAt(position, pc.Vec3.DOWN);
     * @example
     * // Look at the world space origin, using the (default) positive y-axis for up
     * this.entity.lookAt(0, 0, 0);
     * @example
     * // Look at world-space coordinate [10, 10, 10], using the negative world y-axis for up
     * this.entity.lookAt(10, 10, 10, 0, -1, 0);
     */
    lookAt(x: Vec3 | number, y?: Vec3 | number, z?: number, ux?: number, uy?: number, uz?: number): void;
    /**
     * Translates the graph node in world-space by the specified translation vector. This function
     * has two valid signatures: you can either pass a 3D vector or 3 numbers to specify the
     * world-space translation.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding world-space translation or
     * x-coordinate of world-space translation.
     * @param {number} [y] - Y-coordinate of world-space translation.
     * @param {number} [z] - Z-coordinate of world-space translation.
     * @example
     * // Translate via 3 numbers
     * this.entity.translate(10, 0, 0);
     * @example
     * // Translate via vector
     * const t = new pc.Vec3(10, 0, 0);
     * this.entity.translate(t);
     */
    translate(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Translates the graph node in local-space by the specified translation vector. This function
     * has two valid signatures: you can either pass a 3D vector or 3 numbers to specify the
     * local-space translation.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding local-space translation or
     * x-coordinate of local-space translation.
     * @param {number} [y] - Y-coordinate of local-space translation.
     * @param {number} [z] - Z-coordinate of local-space translation.
     * @example
     * // Translate via 3 numbers
     * this.entity.translateLocal(10, 0, 0);
     * @example
     * // Translate via vector
     * const t = new pc.Vec3(10, 0, 0);
     * this.entity.translateLocal(t);
     */
    translateLocal(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Rotates the graph node in world-space by the specified Euler angles. Eulers are specified in
     * degrees in XYZ order. This function has two valid signatures: you can either pass a 3D
     * vector or 3 numbers to specify the world-space rotation.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding world-space rotation or
     * rotation around world-space x-axis in degrees.
     * @param {number} [y] - Rotation around world-space y-axis in degrees.
     * @param {number} [z] - Rotation around world-space z-axis in degrees.
     * @example
     * // Rotate via 3 numbers
     * this.entity.rotate(0, 90, 0);
     * @example
     * // Rotate via vector
     * const r = new pc.Vec3(0, 90, 0);
     * this.entity.rotate(r);
     */
    rotate(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Rotates the graph node in local-space by the specified Euler angles. Eulers are specified in
     * degrees in XYZ order. This function has two valid signatures: you can either pass a 3D
     * vector or 3 numbers to specify the local-space rotation.
     *
     * @param {Vec3|number} x - 3-dimensional vector holding local-space rotation or
     * rotation around local-space x-axis in degrees.
     * @param {number} [y] - Rotation around local-space y-axis in degrees.
     * @param {number} [z] - Rotation around local-space z-axis in degrees.
     * @example
     * // Rotate via 3 numbers
     * this.entity.rotateLocal(0, 90, 0);
     * @example
     * // Rotate via vector
     * const r = new pc.Vec3(0, 90, 0);
     * this.entity.rotateLocal(r);
     */
    rotateLocal(x: Vec3 | number, y?: number, z?: number): void;
}

/**
 * A skin instance is responsible for generating the matrix palette that is used to skin vertices
 * from object space to world space.
 *
 * @category Graphics
 */
declare class SkinInstance {
    /**
     * Create a new SkinInstance instance.
     *
     * @param {import('./skin.js').Skin} skin - The skin that will provide the inverse bind pose
     * matrices to generate the final matrix palette.
     */
    constructor(skin: Skin);
    /**
     * An array of nodes representing each bone in this skin instance.
     *
     * @type {import('./graph-node.js').GraphNode[]}
     */
    bones: GraphNode[];
    boneTextureSize: any;
    _dirty: boolean;
    _rootBone: any;
    _skinUpdateIndex: number;
    _updateBeforeCull: boolean;
    set rootBone(arg: any);
    get rootBone(): any;
    init(device: any, numBones: any): void;
    boneTexture: Texture;
    matrixPalette: Uint8Array | Uint16Array | Float32Array;
    destroy(): void;
    resolve(rootBone: any, entity: any): void;
    initSkin(skin: any): void;
    skin: any;
    matrices: any[];
    uploadBones(device: any): void;
    _updateMatrices(rootNode: any, skinUpdateIndex: any): void;
    updateMatrices(rootNode: any, skinUpdateIndex: any): void;
    updateMatrixPalette(rootNode: any, skinUpdateIndex: any): void;
}

/**
 * Component Systems contain the logic and functionality to update all Components of a particular
 * type.
 *
 * @augments EventHandler
 */
declare class ComponentSystem extends EventHandler {
    /**
     * Create a new ComponentSystem instance.
     *
     * @param {import('../app-base.js').AppBase} app - The application managing this system.
     */
    constructor(app: AppBase);
    app: AppBase;
    store: {};
    schema: any[];
    /**
     * Create new {@link Component} and component data instances and attach them to the entity.
     *
     * @param {import('../entity.js').Entity} entity - The Entity to attach this component to.
     * @param {object} [data] - The source data with which to create the component.
     * @returns {import('./component.js').Component} Returns a Component of type defined by the
     * component system.
     * @example
     * const entity = new pc.Entity(app);
     * app.systems.model.addComponent(entity, { type: 'box' });
     * // entity.model is now set to a pc.ModelComponent
     * @ignore
     */
    addComponent(entity: Entity, data?: object): Component;
    /**
     * Remove the {@link Component} from the entity and delete the associated component data.
     *
     * @param {import('../entity.js').Entity} entity - The entity to remove the component from.
     * @example
     * app.systems.model.removeComponent(entity);
     * // entity.model === undefined
     * @ignore
     */
    removeComponent(entity: Entity): void;
    /**
     * Create a clone of component. This creates a copy of all component data variables.
     *
     * @param {import('../entity.js').Entity} entity - The entity to clone the component from.
     * @param {import('../entity.js').Entity} clone - The entity to clone the component into.
     * @returns {import('./component.js').Component} The newly cloned component.
     * @ignore
     */
    cloneComponent(entity: Entity, clone: Entity): Component;
    /**
     * Called during {@link ComponentSystem#addComponent} to initialize the component data in the
     * store. This can be overridden by derived Component Systems and either called by the derived
     * System or replaced entirely.
     *
     * @param {import('./component.js').Component} component - The component being initialized.
     * @param {object} data - The data block used to initialize the component.
     * @param {Array<string | {name: string, type: string}>} properties - The array of property
     * descriptors for the component. A descriptor can be either a plain property name, or an
     * object specifying the name and type.
     * @ignore
     */
    initializeComponentData(component: Component, data: object, properties: Array<string | {
        name: string;
        type: string;
    }>): void;
    /**
     * Searches the component schema for properties that match the specified type.
     *
     * @param {string} type - The type to search for.
     * @returns {string[]|object[]} An array of property descriptors matching the specified type.
     * @ignore
     */
    getPropertiesOfType(type: string): string[] | object[];
    destroy(): void;
}

/**
 * Components are used to attach functionality on a {@link Entity}. Components can receive update
 * events each frame, and expose properties to the PlayCanvas Editor.
 *
 * @property {boolean} enabled Enables or disables the component.
 * @augments EventHandler
 */
declare class Component extends EventHandler {
    /** @ignore */
    static _buildAccessors(obj: any, schema: any): void;
    /**
     * Base constructor for a Component.
     *
     * @param {import('./system.js').ComponentSystem} system - The ComponentSystem used to create
     * this Component.
     * @param {import('../entity.js').Entity} entity - The Entity that this Component is attached
     * to.
     */
    constructor(system: ComponentSystem, entity: Entity);

    set enabled(arg: boolean);
    get enabled(): boolean;

    /**
     * The ComponentSystem used to create this Component.
     *
     * @type {import('./system.js').ComponentSystem}
     */
    system: ComponentSystem;
    /**
     * The Entity that this Component is attached to.
     *
     * @type {import('../entity.js').Entity}
     */
    entity: Entity;
    /** @ignore */
    buildAccessors(schema: any): void;
    /** @ignore */
    onSetEnabled(name: any, oldValue: any, newValue: any): void;
    /** @ignore */
    onEnable(): void;
    /** @ignore */
    onDisable(): void;
    /** @ignore */
    onPostStateChange(): void;
    /**
     * Access the component data directly. Usually you should access the data properties via the
     * individual properties as modifying this data directly will not fire 'set' events.
     *
     * @type {*}
     * @ignore
     */
    get data(): any;
}

declare class LightComponentData {
}

/**
 * A Light Component is used to dynamically light the scene.
 *
 * @augments ComponentSystem
 * @category Graphics
 */
declare class LightComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof LightComponent;
    DataType: typeof LightComponentData;
    initializeComponentData(component: any, _data: any): void;
    _onRemoveComponent(entity: any, component: any): void;
    cloneComponent(entity: any, clone: any): Component;
    changeType(component: any, oldValue: any, newValue: any): void;
}

/**
 * The Light Component enables the Entity to light the scene. There are three types of light:
 * directional, omni and spot. Directional lights are global in that they are considered to be
 * infinitely far away and light the entire scene. Omni and spot lights are local in that they have
 * a position and a range. A spot light is a specialization of an omni light where light is emitted
 * in a cone rather than in all directions. Lights also have the ability to cast shadows to add
 * realism to your scenes.
 *
 * ```javascript
 * // Add a pc.LightComponent to an entity
 * const entity = new pc.Entity();
 * entity.addComponent('light', {
 *     type: "omni",
 *     color: new pc.Color(1, 0, 0),
 *     range: 10
 * });
 *
 * // Get the pc.LightComponent on an entity
 * const lightComponent = entity.light;
 *
 * // Update a property on a light component
 * entity.light.range = 20;
 * ```
 *
 * @property {string} type The type of light. Can be:
 *
 * - "directional": A light that is infinitely far away and lights the entire scene from one
 * direction.
 * - "omni": An omni-directional light that illuminates in all directions from the light source.
 * - "spot": An omni-directional light but is bounded by a cone.
 *
 * Defaults to "directional".
 * @property {Color} color The Color of the light. The alpha component of the color is ignored.
 * Defaults to white (1, 1, 1).
 * @property {number} intensity The brightness of the light. Defaults to 1.
 * @property {number} luminance The physically based luminance. Only used if scene.physicalUnits is true. Defaults to 0.
 * @property {number} shape The light source shape. Can be:
 *
 * - {@link LIGHTSHAPE_PUNCTUAL}: Infinitesimally small point.
 * - {@link LIGHTSHAPE_RECT}: Rectangle shape.
 * - {@link LIGHTSHAPE_DISK}: Disk shape.
 * - {@link LIGHTSHAPE_SPHERE}: Sphere shape.
 *
 * Defaults to pc.LIGHTSHAPE_PUNCTUAL.
 * @property {boolean} affectSpecularity If enabled, material specularity will be affected by this light.
 * Ignored for lights other than {@link LIGHTTYPE_DIRECTIONAL}. Defaults to true.
 * @property {boolean} castShadows If enabled the light will cast shadows. Defaults to false.
 * @property {number} shadowDistance The distance from the viewpoint beyond which shadows are no
 * longer rendered. Affects directional lights only. Defaults to 40.
 * @property {number} shadowIntensity The intensity of the shadow darkening, 1 being shadows are entirely black.
 * Defaults to 1.
 * @property {number} shadowResolution The size of the texture used for the shadow map. Valid sizes
 * are 64, 128, 256, 512, 1024, 2048. Defaults to 1024.
 * @property {number} shadowBias The depth bias for tuning the appearance of the shadow mapping
 * generated by this light. Valid range is 0 to 1. Defaults to 0.05.
 * @property {number} numCascades Number of shadow cascades. Can be 1, 2, 3 or 4. Defaults to 1,
 * representing no cascades.
 * @property {number} cascadeDistribution The distribution of subdivision of the camera frustum for
 * individual shadow cascades. Only used if {@link LightComponent#numCascades} is larger than 1.
 * Can be a value in range of 0 and 1. Value of 0 represents a linear distribution, value of 1
 * represents a logarithmic distribution. Defaults to 0.5. Larger value increases the resolution of
 * the shadows in the near distance.
 * @property {number} normalOffsetBias Normal offset depth bias. Valid range is 0 to 1. Defaults to
 * 0.
 * @property {number} range The range of the light. Affects omni and spot lights only. Defaults to
 * 10.
 * @property {number} innerConeAngle The angle at which the spotlight cone starts to fade off. The
 * angle is specified in degrees. Affects spot lights only. Defaults to 40.
 * @property {number} outerConeAngle The angle at which the spotlight cone has faded to nothing.
 * The angle is specified in degrees. Affects spot lights only. Defaults to 45.
 * @property {number} penumbraSize Size of penumbra for contact hardening shadows. For area lights
 * acts as a multiplier with the dimensions of the area light. For punctual and directional lights
 * it's the area size of the light. Defaults to 1.0.
 * @property {number} falloffMode Controls the rate at which a light attenuates from its position.
 * Can be:
 *
 * - {@link LIGHTFALLOFF_LINEAR}: Linear.
 * - {@link LIGHTFALLOFF_INVERSESQUARED}: Inverse squared.
 *
 * Affects omni and spot lights only. Defaults to {@link LIGHTFALLOFF_LINEAR}.
 * @property {number} mask Defines a mask to determine which {@link MeshInstance}s are lit by this
 * light. Defaults to 1.
 * @property {boolean} affectDynamic If enabled the light will affect non-lightmapped objects.
 * @property {boolean} affectLightmapped If enabled the light will affect lightmapped objects.
 * @property {boolean} bake If enabled the light will be rendered into lightmaps.
 * @property {number} bakeNumSamples If bake is true, this specifies the number of samples used to
 * bake this light into the lightmap. Defaults to 1. Maximum value is 255.
 * @property {number} bakeArea If bake is true and the light type is {@link LIGHTTYPE_DIRECTIONAL},
 * this specifies the penumbra angle in degrees, allowing a soft shadow boundary. Defaults to 0.
 * @property {boolean} bakeDir If enabled and bake=true, the light's direction will contribute to
 * directional lightmaps. Be aware, that directional lightmap is an approximation and can only hold
 * single direction per pixel. Intersecting multiple lights with bakeDir=true may lead to incorrect
 * look of specular/bump-mapping in the area of intersection. The error is not always visible
 * though, and highly scene-dependent.
 * @property {number} shadowUpdateMode Tells the renderer how often shadows must be updated for
 * this light. Can be:
 *
 * - {@link SHADOWUPDATE_NONE}: Don't render shadows.
 * - {@link SHADOWUPDATE_THISFRAME}: Render shadows only once (then automatically switches to
 * {@link SHADOWUPDATE_NONE}.
 * - {@link SHADOWUPDATE_REALTIME}: Render shadows every frame (default).
 * @property {number} shadowType Type of shadows being rendered by this light. Options:
 *
 * - {@link SHADOW_PCF3}: Render depth (color-packed on WebGL 1.0), can be used for PCF 3x3
 * sampling.
 * - {@link SHADOW_VSM8}: Render packed variance shadow map. All shadow receivers must also cast
 * shadows for this mode to work correctly.
 * - {@link SHADOW_VSM16}: Render 16-bit exponential variance shadow map. Requires
 * OES_texture_half_float extension. Falls back to {@link SHADOW_VSM8}, if not supported.
 * - {@link SHADOW_VSM32}: Render 32-bit exponential variance shadow map. Requires
 * OES_texture_float extension. Falls back to {@link SHADOW_VSM16}, if not supported.
 * - {@link SHADOW_PCF5}: Render depth buffer only, can be used for hardware-accelerated PCF 5x5
 * sampling. Requires WebGL2. Falls back to {@link SHADOW_PCF3} on WebGL 1.0.
 * - {@link SHADOW_PCSS}: Render depth as color, and use the software sampled PCSS method for shadows.
 * @property {number} vsmBlurMode Blurring mode for variance shadow maps. Can be:
 *
 * - {@link BLUR_BOX}: Box filter.
 * - {@link BLUR_GAUSSIAN}: Gaussian filter. May look smoother than box, but requires more samples.
 * @property {number} vsmBlurSize Number of samples used for blurring a variance shadow map. Only
 * uneven numbers work, even are incremented. Minimum value is 1, maximum is 25. Defaults to 11.
 * @property {number} cookieAsset Asset that has texture that will be assigned to cookie internally
 * once asset resource is available.
 * @property {Texture} cookie Projection texture. Must be 2D for spot and cubemap for omni light
 * (ignored if incorrect type is used).
 * @property {number} cookieIntensity Projection texture intensity (default is 1).
 * @property {boolean} cookieFalloff Toggle normal spotlight falloff when projection texture is
 * used. When set to false, spotlight will work like a pure texture projector (only fading with
 * distance). Default is false.
 * @property {string} cookieChannel Color channels of the projection texture to use. Can be "r",
 * "g", "b", "a", "rgb".
 * @property {number} cookieAngle Angle for spotlight cookie rotation.
 * @property {import('../../../core/math/vec2.js').Vec2} cookieScale Spotlight cookie scale.
 * @property {import('../../../core/math/vec2.js').Vec2} cookieOffset Spotlight cookie position
 * offset.
 * @property {boolean} isStatic Mark light as non-movable (optimization).
 * @property {number[]} layers An array of layer IDs ({@link Layer#id}) to which this light should
 * belong. Don't push/pop/splice or modify this array, if you want to change it - set a new one
 * instead.
 * @augments Component
 * @category Graphics
 */
declare class LightComponent extends Component {
    /**
     * Creates a new LightComponent instance.
     *
     * @param {import('./system.js').LightComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {import('../../entity.js').Entity} entity - The Entity that this Component is
     * attached to.
     */
    constructor(system: LightComponentSystem, entity: Entity);

    set affectDynamic(arg: boolean);
    get affectDynamic(): boolean;

    set affectLightmapped(arg: boolean);
    get affectLightmapped(): boolean;

    set bake(arg: boolean);
    get bake(): boolean;

    set bakeArea(arg: number);
    get bakeArea(): number;

    set bakeDir(arg: boolean);
    get bakeDir(): boolean;

    set bakeNumSamples(arg: number);
    get bakeNumSamples(): number;

    set cascadeDistribution(arg: number);
    get cascadeDistribution(): number;

    set castShadows(arg: boolean);
    get castShadows(): boolean;

    set color(arg: Color);
    get color(): Color;

    set cookieAngle(arg: number);
    get cookieAngle(): number;

    set cookieChannel(arg: string);
    get cookieChannel(): string;

    set cookieFalloff(arg: boolean);
    get cookieFalloff(): boolean;

    set cookieIntensity(arg: number);
    get cookieIntensity(): number;

    set cookieOffset(arg: Vec2);
    get cookieOffset(): Vec2;

    set cookieScale(arg: Vec2);
    get cookieScale(): Vec2;

    set falloffMode(arg: number);
    get falloffMode(): number;

    set innerConeAngle(arg: number);
    get innerConeAngle(): number;

    set intensity(arg: number);
    get intensity(): number;

    set luminance(arg: number);
    get luminance(): number;

    set isStatic(arg: boolean);
    get isStatic(): boolean;

    set layers(arg: number[]);
    get layers(): number[];

    set mask(arg: number);
    get mask(): number;

    set normalOffsetBias(arg: number);
    get normalOffsetBias(): number;

    set numCascades(arg: number);
    get numCascades(): number;

    set outerConeAngle(arg: number);
    get outerConeAngle(): number;

    set range(arg: number);
    get range(): number;

    set shadowBias(arg: number);
    get shadowBias(): number;

    set shadowDistance(arg: number);
    get shadowDistance(): number;

    set shadowIntensity(arg: number);
    get shadowIntensity(): number;

    set shadowResolution(arg: number);
    get shadowResolution(): number;

    set shadowType(arg: number);
    get shadowType(): number;

    set shadowUpdateMode(arg: number);
    get shadowUpdateMode(): number;

    set shape(arg: number);
    get shape(): number;

    set affectSpecularity(arg: boolean);
    get affectSpecularity(): boolean;

    set type(arg: string);
    get type(): string;

    set vsmBlurMode(arg: number);
    get vsmBlurMode(): number;

    set vsmBlurSize(arg: number);
    get vsmBlurSize(): number;

    _cookieAsset: any;
    _cookieAssetId: any;
    _cookieAssetAdd: boolean;
    _cookieMatrix: any;
    addLightToLayers(): void;
    removeLightFromLayers(): void;
    onLayersChanged(oldComp: any, newComp: any): void;
    onLayerAdded(layer: any): void;
    onLayerRemoved(layer: any): void;
    refreshProperties(): void;
    onCookieAssetSet(): void;
    onCookieAssetAdd(asset: any): void;
    onCookieAssetLoad(): void;
    cookie: any;
    onCookieAssetRemove(): void;
    onRemove(): void;
    cookieAsset: any;
    /**
     * Returns an array of SHADOWUPDATE_ settings per shadow cascade, or undefined if not used.
     *
     * @type {number[] | null}
     */
    set shadowUpdateOverrides(arg: any);
    get shadowUpdateOverrides(): any;
    set penumbraSize(arg: any);
    get penumbraSize(): any;
}

/**
 * A light.
 *
 * @ignore
 */
declare class Light {
    /**
     * Get conversion factor for luminance -> light specific light unit.
     *
     * @param {number} type - The type of light.
     * @param {number} [outerAngle] - The outer angle of a spot light.
     * @param {number} [innerAngle] - The inner angle of a spot light.
     * @returns {number} The scaling factor to multiply with the luminance value.
     */
    static getLightUnitConversion(type: number, outerAngle?: number, innerAngle?: number): number;
    constructor(graphicsDevice: any, clusteredLighting: any);
    /**
     * The Layers the light is on.
     *
     * @type {Set<import('./layer.js').Layer>}
     */
    layers: Set<Layer>;
    /**
     * True if the clustered lighting is enabled.
     *
     * @type {boolean}
     */
    clusteredLighting: boolean;
    /**
     * The depth state used when rendering the shadow map.
     *
     * @type {DepthState}
     */
    shadowDepthState: DepthState;
    device: any;
    id: number;
    _type: number;
    _color: Color;
    _intensity: number;
    _affectSpecularity: boolean;
    _luminance: number;
    _castShadows: boolean;
    _enabled: boolean;
    _mask: number;
    isStatic: boolean;
    key: number;
    bakeDir: boolean;
    bakeNumSamples: number;
    bakeArea: number;
    attenuationStart: number;
    attenuationEnd: number;
    _falloffMode: number;
    _shadowType: number;
    _vsmBlurSize: number;
    vsmBlurMode: number;
    vsmBias: number;
    _cookie: any;
    cookieIntensity: number;
    _cookieFalloff: boolean;
    _cookieChannel: string;
    _cookieTransform: any;
    _cookieTransformUniform: Float32Array;
    _cookieOffset: any;
    _cookieOffsetUniform: Float32Array;
    _cookieTransformSet: boolean;
    _cookieOffsetSet: boolean;
    _innerConeAngle: number;
    _outerConeAngle: number;
    cascades: any;
    _shadowMatrixPalette: Float32Array;
    _shadowCascadeDistances: Float32Array;
    set numCascades(arg: any);
    get numCascades(): any;
    cascadeDistribution: number;
    _shape: number;
    _finalColor: Float32Array;
    _linearFinalColor: Float32Array;
    _position: Vec3;
    _direction: Vec3;
    _innerConeAngleCos: number;
    _usePhysicalUnits: any;
    _shadowMap: any;
    _shadowRenderParams: any[];
    _shadowCameraParams: any[];
    shadowDistance: number;
    _shadowResolution: number;
    _shadowBias: number;
    shadowIntensity: number;
    _normalOffsetBias: number;
    shadowUpdateMode: number;
    shadowUpdateOverrides: any;
    _penumbraSize: number;
    _isVsm: boolean;
    _isPcf: boolean;
    _cookieMatrix: Mat4;
    _atlasViewport: Vec4;
    atlasViewportAllocated: boolean;
    atlasVersion: number;
    atlasSlotIndex: number;
    atlasSlotUpdated: boolean;
    _node: any;
    _renderData: any[];
    visibleThisFrame: boolean;
    maxScreenSize: number;
    destroy(): void;
    releaseRenderData(): void;
    addLayer(layer: any): void;
    removeLayer(layer: any): void;
    set shadowBias(arg: number);
    get shadowBias(): number;
    set shadowMap(arg: any);
    get shadowMap(): any;
    set mask(arg: number);
    get mask(): number;
    get numShadowFaces(): any;
    set type(arg: number);
    get type(): number;
    set shadowType(arg: number);
    get shadowType(): number;
    set shape(arg: number);
    get shape(): number;
    set usePhysicalUnits(arg: any);
    get usePhysicalUnits(): any;
    set enabled(arg: boolean);
    get enabled(): boolean;
    set castShadows(arg: boolean);
    get castShadows(): boolean;
    set shadowResolution(arg: number);
    get shadowResolution(): number;
    set vsmBlurSize(arg: number);
    get vsmBlurSize(): number;
    set normalOffsetBias(arg: number);
    get normalOffsetBias(): number;
    set falloffMode(arg: number);
    get falloffMode(): number;
    set innerConeAngle(arg: number);
    get innerConeAngle(): number;
    set outerConeAngle(arg: number);
    get outerConeAngle(): number;
    set penumbraSize(arg: number);
    get penumbraSize(): number;
    _updateOuterAngle(angle: any): void;
    _outerConeAngleCos: number;
    _outerConeAngleSin: number;
    set intensity(arg: number);
    get intensity(): number;
    set affectSpecularity(arg: boolean);
    get affectSpecularity(): boolean;
    set luminance(arg: number);
    get luminance(): number;
    get cookieMatrix(): Mat4;
    get atlasViewport(): Vec4;
    set cookie(arg: any);
    get cookie(): any;
    set cookieFalloff(arg: boolean);
    get cookieFalloff(): boolean;
    set cookieChannel(arg: string);
    get cookieChannel(): string;
    set cookieTransform(arg: any);
    get cookieTransform(): any;
    set cookieOffset(arg: any);
    get cookieOffset(): any;
    beginFrame(): void;
    _destroyShadowMap(): void;
    getRenderData(camera: any, face: any): any;
    /**
     * Duplicates a light node but does not 'deep copy' the hierarchy.
     *
     * @returns {Light} A cloned Light.
     */
    clone(): Light;
    _getUniformBiasValues(lightRenderData: any): {
        bias: number;
        normalBias: number;
    };
    getColor(): Color;
    getBoundingSphere(sphere: any): void;
    getBoundingBox(box: any): void;
    _updateShadowBias(): void;
    _updateFinalColor(): void;
    setColor(...args: any[]): void;
    layersDirty(): void;
    /**
     * Updates a integer key for the light. The key is used to identify all shader related features
     * of the light, and so needs to have all properties that modify the generated shader encoded.
     * Properties without an effect on the shader (color, shadow intensity) should not be encoded.
     */
    updateKey(): void;
}

/**
 * A render pass represents a node in the frame graph, and encapsulates a system which
 * renders to a render target using an execution callback.
 *
 * @ignore
 */
declare class RenderPass {
    /**
     * Creates an instance of the RenderPass.
     *
     * @param {import('../graphics/graphics-device.js').GraphicsDevice} graphicsDevice - The
     * graphics device.
     */
    constructor(graphicsDevice: GraphicsDevice);
    /** @type {string} */
    _name: string;
    /**
     * The graphics device.
     *
     * @type {import('../graphics/graphics-device.js').GraphicsDevice}
     */
    device: GraphicsDevice;
    /**
     * True if the render pass is enabled.
     *
     * @type {boolean}
     * @private
     */
    private _enabled;
    /**
     * True if the render pass is enabled and execute function will be called. Note that before and
     * after functions are called regardless of this flag.
     */
    executeEnabled: boolean;
    /**
     * The render target for this render pass:
     *  - `undefined`: render pass does not render to any render target
     *  - `null`: render pass renders to the backbuffer
     *  - Otherwise, renders to the provided RT.
     * @type {import('../graphics/render-target.js').RenderTarget|null|undefined}
     */
    renderTarget: RenderTarget | null | undefined;
    /**
     * The options specified when the render target was initialized.
     */
    _options: any;
    /**
     * Number of samples. 0 if no render target, otherwise number of samples from the render target,
     * or the main framebuffer if render target is null.
     *
     * @type {number}
     */
    samples: number;
    /**
     * Array of color attachment operations. The first element corresponds to the color attachment
     * 0, and so on.
     *
     * @type {Array<ColorAttachmentOps>}
     */
    colorArrayOps: Array<ColorAttachmentOps>;
    /**
     * Color attachment operations for the first color attachment.
     *
     * @type {ColorAttachmentOps}
     */
    get colorOps(): ColorAttachmentOps;
    /** @type {DepthStencilAttachmentOps} */
    depthStencilOps: DepthStencilAttachmentOps;
    /**
     * If true, this pass might use dynamically rendered cubemaps. Use for a case where rendering to cubemap
     * faces is interleaved with rendering to shadows, to avoid generating cubemap mipmaps. This will likely
     * be retired when render target dependency tracking gets implemented.
     *
     * @type {boolean}
     */
    requiresCubemaps: boolean;
    /**
     * True if the render pass uses the full viewport / scissor for rendering into the render target.
     *
     * @type {boolean}
     */
    fullSizeClearRect: boolean;
    /**
     * Render passes which need to be executed before this pass.
     *
     * @type {RenderPass[]}
     */
    beforePasses: RenderPass[];
    /**
     * Render passes which need to be executed after this pass.
     *
     * @type {RenderPass[]}
     */
    afterPasses: RenderPass[];
    set name(arg: string);
    get name(): string;
    set options(arg: any);
    get options(): any;
    /**
     * @param {import('../graphics/render-target.js').RenderTarget|null} [renderTarget] - The render
     * target to render into (output). This function should be called only for render passes which
     * use render target, or passes which render directly into the default framebuffer, in which
     * case a null or undefined render target is expected.
     */
    init(renderTarget?: RenderTarget | null, options?: any): void;
    destroy(): void;
    postInit(): void;
    frameUpdate(): void;
    before(): void;
    execute(): void;
    after(): void;
    onEnable(): void;
    onDisable(): void;
    set enabled(arg: boolean);
    get enabled(): boolean;
    /**
     * Mark render pass as clearing the full color buffer.
     *
     * @param {Color|undefined} color - The color to clear to, or undefined to preserve the existing
     * content.
     */
    setClearColor(color: Color | undefined): void;
    /**
     * Mark render pass as clearing the full depth buffer.
     *
     * @param {number|undefined} depthValue - The depth value to clear to, or undefined to preserve
     * the existing content.
     */
    setClearDepth(depthValue: number | undefined): void;
    /**
     * Mark render pass as clearing the full stencil buffer.
     *
     * @param {number|undefined} stencilValue - The stencil value to clear to, or undefined to preserve the
     * existing content.
     */
    setClearStencil(stencilValue: number | undefined): void;
    /**
     * Render the render pass
     */
    render(): void;
    log(device: any, index: any): void;
}
declare class ColorAttachmentOps {
    /**
     * A color used to clear the color attachment when the clear is enabled.
     */
    clearValue: Color;
    /**
     * True if the attachment should be cleared before rendering, false to preserve
     * the existing content.
     */
    clear: boolean;
    /**
     * True if the attachment needs to be stored after the render pass. False
     * if it can be discarded.
     * Note: This relates to the surface that is getting rendered to, and can be either
     * single or multi-sampled. Further, if a multi-sampled surface is used, the resolve
     * flag further specifies if this gets resolved to a single-sampled surface. This
     * behavior matches the WebGPU specification.
     *
     * @type {boolean}
     */
    store: boolean;
    /**
     * True if the attachment needs to be resolved.
     *
     * @type {boolean}
     */
    resolve: boolean;
    /**
     * True if the attachment needs to have mipmaps generated.
     *
     * @type {boolean}
     */
    mipmaps: boolean;
}
declare class DepthStencilAttachmentOps {
    /**
     * A depth value used to clear the depth attachment when the clear is enabled.
     */
    clearDepthValue: number;
    /**
     * A stencil value used to clear the stencil attachment when the clear is enabled.
     */
    clearStencilValue: number;
    /**
     * True if the depth attachment should be cleared before rendering, false to preserve
     * the existing content.
     */
    clearDepth: boolean;
    /**
     * True if the stencil attachment should be cleared before rendering, false to preserve
     * the existing content.
     */
    clearStencil: boolean;
    /**
     * True if the depth attachment needs to be stored after the render pass. False
     * if it can be discarded.
     *
     * @type {boolean}
     */
    storeDepth: boolean;
    /**
     * True if the stencil attachment needs to be stored after the render pass. False
     * if it can be discarded.
     *
     * @type {boolean}
     */
    storeStencil: boolean;
}

/**
 * Class responsible for management of shader passes, associated with a device.
 *
 * @ignore
 */
declare class ShaderPass {
    /**
     * Get access to the shader pass instance for the specified device.
     *
     * @param {import('../platform/graphics/graphics-device.js').GraphicsDevice} device - The
     * graphics device.
     * @returns { ShaderPass } The shader pass instance for the specified device.
     */
    static get(device: GraphicsDevice): ShaderPass;
    /**
     * Allocated shader passes, map of a shader pass name to info.
     *
     * @type {Map<string, ShaderPassInfo>}
     */
    passesNamed: Map<string, ShaderPassInfo>;
    /**
     * Allocated shader passes, indexed by their index.
     *
     * @type {Array<ShaderPassInfo>}
     */
    passesIndexed: Array<ShaderPassInfo>;
    /** Next available index */
    nextIndex: number;
    /**
     * Allocates a shader pass with the specified name and options.
     *
     * @param {string} name - A name of the shader pass.
     * @param {object} [options] - Options for the shader pass, which are added as properties to the
     * shader pass info.
     * @returns {ShaderPassInfo} The allocated shader pass info.
     */
    allocate(name: string, options?: object): ShaderPassInfo;
    /**
     * Return the shader pass info for the specified index.
     *
     * @param {number} index - The shader pass index.
     * @returns {ShaderPassInfo} - The shader pass info.
     */
    getByIndex(index: number): ShaderPassInfo;
    getByName(name: any): ShaderPassInfo;
}
/**
 * Info about a shader pass. Shader pass is represented by a unique index and a name, and the
 * index is used to access the shader required for the pass, from an array stored in the
 * material or mesh instance.
 *
 * @ignore
 */
declare class ShaderPassInfo {
    /**
     * @param {string} name - The name, for example 'depth'. Must contain only letters, numbers,
     * and underscores, and start with a letter.
     * @param {number} index - Index from ShaderPass#nextIndex.
     * @param {object} [options] - Options for additional configuration of the shader pass.
     * @param {boolean} [options.isForward] - Whether the pass is forward.
     * @param {boolean} [options.isShadow] - Whether the pass is shadow.
     * @param {boolean} [options.lightType] - Type of light, for example `pc.LIGHTTYPE_DIRECTIONAL`.
     * @param {boolean} [options.shadowType] - Type of shadow, for example `pc.SHADOW_PCF3`.
     */
    constructor(name: string, index: number, options?: {
        isForward?: boolean;
        isShadow?: boolean;
        lightType?: boolean;
        shadowType?: boolean;
    });
    /** @type {number} */
    index: number;
    /** @type {string} */
    name: string;
    /** @type {string} */
    shaderDefines: string;
    buildShaderDefines(): string;
}

/**
 * A render pass implementing grab of a color buffer.
 *
 * TODO: implement mipmapped color buffer support for WebGL 1 as well, which requires
 * the texture to be a power of two, by first downscaling the captured framebuffer
 * texture to smaller power of 2 texture, and then generate mipmaps and use it for rendering
 * TODO: or even better, implement blur filter to have smoother lower levels
 *
 * @ignore
 */
declare class RenderPassColorGrab extends RenderPass {
    colorRenderTarget: any;
    /**
     * The source render target to grab the color from.
     *
     * @type {RenderTarget|null}
     */
    source: RenderTarget | null;
    shouldReallocate(targetRT: any, sourceTexture: any, sourceFormat: any): boolean;
    allocateRenderTarget(renderTarget: any, sourceRenderTarget: any, device: any, format: any): any;
    releaseRenderTarget(rt: any): void;
}

/**
 * A frustum is a shape that defines the viewing space of a camera. It can be used to determine
 * visibility of points and bounding spheres. Typically, you would not create a Frustum shape
 * directly, but instead query {@link CameraComponent#frustum}.
 *
 * @category Math
 */
declare class Frustum {
    planes: any[];
    /**
     * Updates the frustum shape based on the supplied 4x4 matrix.
     *
     * @param {import('../math/mat4.js').Mat4} matrix - The matrix describing the shape of the
     * frustum.
     * @example
     * // Create a perspective projection matrix
     * const projMat = pc.Mat4();
     * projMat.setPerspective(45, 16 / 9, 1, 1000);
     *
     * // Create a frustum shape that is represented by the matrix
     * const frustum = new pc.Frustum();
     * frustum.setFromMat4(projMat);
     */
    setFromMat4(matrix: Mat4): void;
    /**
     * Tests whether a point is inside the frustum. Note that points lying in a frustum plane are
     * considered to be outside the frustum.
     *
     * @param {import('../math/vec3.js').Vec3} point - The point to test.
     * @returns {boolean} True if the point is inside the frustum, false otherwise.
     */
    containsPoint(point: Vec3): boolean;
    /**
     * Tests whether a bounding sphere intersects the frustum. If the sphere is outside the
     * frustum, zero is returned. If the sphere intersects the frustum, 1 is returned. If the
     * sphere is completely inside the frustum, 2 is returned. Note that a sphere touching a
     * frustum plane from the outside is considered to be outside the frustum.
     *
     * @param {import('./bounding-sphere.js').BoundingSphere} sphere - The sphere to test.
     * @returns {number} 0 if the bounding sphere is outside the frustum, 1 if it intersects the
     * frustum and 2 if it is contained by the frustum.
     */
    containsSphere(sphere: BoundingSphere): number;
}

/**
 * A camera.
 *
 * @ignore
 */
declare class Camera {
    /**
     * @type {import('./shader-pass.js').ShaderPassInfo|null}
     */
    shaderPassInfo: ShaderPassInfo | null;
    /**
     * @type {RenderPassColorGrab|null}
     */
    renderPassColorGrab: RenderPassColorGrab | null;
    /**
     * @type {import('../platform/graphics/render-pass.js').RenderPass|null}
     */
    renderPassDepthGrab: RenderPass | null;
    /**
     * Render passes used to render this camera. If empty, the camera will render using the default
     * render passes.
     *
     * @type {import('../platform/graphics/render-pass.js').RenderPass[]}
     */
    renderPasses: RenderPass[];
    /** @type {number} */
    jitter: number;
    _aspectRatio: number;
    _aspectRatioMode: number;
    _calculateProjection: any;
    _calculateTransform: any;
    _clearColor: Color;
    _clearColorBuffer: boolean;
    _clearDepth: number;
    _clearDepthBuffer: boolean;
    _clearStencil: number;
    _clearStencilBuffer: boolean;
    _cullFaces: boolean;
    _farClip: number;
    _flipFaces: boolean;
    _fov: number;
    _frustumCulling: boolean;
    _horizontalFov: boolean;
    _layers: number[];
    _layersSet: Set<number>;
    _nearClip: number;
    _node: any;
    _orthoHeight: number;
    _projection: number;
    _rect: Vec4;
    _renderTarget: any;
    _scissorRect: Vec4;
    _scissorRectClear: boolean;
    _aperture: number;
    _shutter: number;
    _sensitivity: number;
    _projMat: Mat4;
    _projMatDirty: boolean;
    _projMatSkybox: Mat4;
    _viewMat: Mat4;
    _viewMatDirty: boolean;
    _viewProjMat: Mat4;
    _viewProjMatDirty: boolean;
    _shaderMatricesVersion: number;
    _viewProjInverse: Mat4;
    _viewProjCurrent: any;
    _viewProjPrevious: Mat4;
    _jitters: number[];
    frustum: Frustum;
    _xr: any;
    _xrProperties: {
        horizontalFov: boolean;
        fov: number;
        aspectRatio: number;
        farClip: number;
        nearClip: number;
    };
    destroy(): void;
    /**
     * Store camera matrices required by TAA. Only update them once per frame.
     */
    _storeShaderMatrices(viewProjMat: any, jitterX: any, jitterY: any, renderVersion: any): void;
    /**
     * True if the camera clears the full render target. (viewport / scissor are full size)
     */
    get fullSizeClearRect(): boolean;
    set aspectRatio(arg: number);
    get aspectRatio(): number;
    set aspectRatioMode(arg: number);
    get aspectRatioMode(): number;
    set calculateProjection(arg: any);
    get calculateProjection(): any;
    set calculateTransform(arg: any);
    get calculateTransform(): any;
    set clearColor(arg: Color);
    get clearColor(): Color;
    set clearColorBuffer(arg: boolean);
    get clearColorBuffer(): boolean;
    set clearDepth(arg: number);
    get clearDepth(): number;
    set clearDepthBuffer(arg: boolean);
    get clearDepthBuffer(): boolean;
    set clearStencil(arg: number);
    get clearStencil(): number;
    set clearStencilBuffer(arg: boolean);
    get clearStencilBuffer(): boolean;
    set cullFaces(arg: boolean);
    get cullFaces(): boolean;
    set farClip(arg: number);
    get farClip(): number;
    set flipFaces(arg: boolean);
    get flipFaces(): boolean;
    set fov(arg: number);
    get fov(): number;
    set frustumCulling(arg: boolean);
    get frustumCulling(): boolean;
    set horizontalFov(arg: boolean);
    get horizontalFov(): boolean;
    set layers(arg: number[]);
    get layers(): number[];
    get layersSet(): Set<number>;
    set nearClip(arg: number);
    get nearClip(): number;
    set node(arg: any);
    get node(): any;
    set orthoHeight(arg: number);
    get orthoHeight(): number;
    set projection(arg: number);
    get projection(): number;
    get projectionMatrix(): Mat4;
    set rect(arg: Vec4);
    get rect(): Vec4;
    set renderTarget(arg: any);
    get renderTarget(): any;
    set scissorRect(arg: Vec4);
    get scissorRect(): Vec4;
    get viewMatrix(): Mat4;
    set aperture(arg: number);
    get aperture(): number;
    set sensitivity(arg: number);
    get sensitivity(): number;
    set shutter(arg: number);
    get shutter(): number;
    set xr(arg: any);
    get xr(): any;
    /**
     * Creates a duplicate of the camera.
     *
     * @returns {Camera} A cloned Camera.
     */
    clone(): Camera;
    /**
     * Copies one camera to another.
     *
     * @param {Camera} other - Camera to copy.
     * @returns {Camera} Self for chaining.
     */
    copy(other: Camera): Camera;
    _enableRenderPassColorGrab(device: any, enable: any): void;
    _enableRenderPassDepthGrab(device: any, renderer: any, enable: any): void;
    _updateViewProjMat(): void;
    /**
     * Convert a point from 3D world space to 2D canvas pixel space.
     *
     * @param {Vec3} worldCoord - The world space coordinate to transform.
     * @param {number} cw - The width of PlayCanvas' canvas element.
     * @param {number} ch - The height of PlayCanvas' canvas element.
     * @param {Vec3} [screenCoord] - 3D vector to receive screen coordinate result.
     * @returns {Vec3} The screen space coordinate.
     */
    worldToScreen(worldCoord: Vec3, cw: number, ch: number, screenCoord?: Vec3): Vec3;
    /**
     * Convert a point from 2D canvas pixel space to 3D world space.
     *
     * @param {number} x - X coordinate on PlayCanvas' canvas element.
     * @param {number} y - Y coordinate on PlayCanvas' canvas element.
     * @param {number} z - The distance from the camera in world space to create the new point.
     * @param {number} cw - The width of PlayCanvas' canvas element.
     * @param {number} ch - The height of PlayCanvas' canvas element.
     * @param {Vec3} [worldCoord] - 3D vector to receive world coordinate result.
     * @returns {Vec3} The world space coordinate.
     */
    screenToWorld(x: number, y: number, z: number, cw: number, ch: number, worldCoord?: Vec3): Vec3;
    _evaluateProjectionMatrix(): void;
    getProjectionMatrixSkybox(): Mat4;
    getExposure(): number;
    getScreenSize(sphere: any): number;
    /**
     * Returns an array of corners of the frustum of the camera in the local coordinate system of the camera.
     *
     * @param {number} [near] - Near distance for the frustum points. Defaults to the near clip distance of the camera.
     * @param {number} [far] - Far distance for the frustum points. Defaults to the far clip distance of the camera.
     * @returns {Vec3[]} - An array of corners, using a global storage space.
     */
    getFrustumCorners(near?: number, far?: number): Vec3[];
    /**
     * Sets XR camera properties that should be derived physical camera in {@link XrManager}.
     *
     * @param {object} [properties] - Properties object.
     * @param {number} [properties.aspectRatio] - Aspect ratio.
     * @param {number} [properties.farClip] - Far clip.
     * @param {number} [properties.fov] - Field of view.
     * @param {boolean} [properties.horizontalFov] - Enable horizontal field of view.
     * @param {number} [properties.nearClip] - Near clip.
     */
    setXrProperties(properties?: {
        aspectRatio?: number;
        farClip?: number;
        fov?: number;
        horizontalFov?: boolean;
        nearClip?: number;
    }): void;
}

/**
 * A Layer represents a renderable subset of the scene. It can contain a list of mesh instances,
 * lights and cameras, their render settings and also defines custom callbacks before, after or
 * during rendering. Layers are organized inside {@link LayerComposition} in a desired order.
 *
 * @category Graphics
 */
declare class Layer {
    /**
     * Create a new Layer instance.
     *
     * @param {object} options - Object for passing optional arguments. These arguments are the
     * same as properties of the Layer.
     */
    constructor(options?: object);
    /**
     * Mesh instances assigned to this layer.
     *
     * @type {import('./mesh-instance.js').MeshInstance[]}
     * @ignore
     */
    meshInstances: MeshInstance[];
    /**
     * Mesh instances assigned to this layer, stored in a set.
     *
     * @type {Set<import('./mesh-instance.js').MeshInstance>}
     * @ignore
     */
    meshInstancesSet: Set<MeshInstance>;
    /**
     * Shadow casting instances assigned to this layer.
     *
     * @type {import('./mesh-instance.js').MeshInstance[]}
     * @ignore
     */
    shadowCasters: MeshInstance[];
    /**
     * Shadow casting instances assigned to this layer, stored in a set.
     *
     * @type {Set<import('./mesh-instance.js').MeshInstance>}
     * @ignore
     */
    shadowCastersSet: Set<MeshInstance>;
    /**
     * Visible (culled) mesh instances assigned to this layer. Looked up by the Camera.
     *
     * @type {WeakMap<import('./camera.js').Camera, CulledInstances>}
     * @private
     */
    private _visibleInstances;
    /**
     * All lights assigned to a layer.
     *
     * @type {import('./light.js').Light[]}
     * @private
     */
    private _lights;
    /**
     * All lights assigned to a layer stored in a set.
     *
     * @type {Set<import('./light.js').Light>}
     * @private
     */
    private _lightsSet;
    /**
     * Set of light used by clustered lighting (omni and spot, but no directional).
     *
     * @type {Set<import('./light.js').Light>}
     * @private
     */
    private _clusteredLightsSet;
    /**
     * Lights separated by light type. Lights in the individual arrays are sorted by the key,
     * to match their order in _lightIdHash, so that their order matches the order expected by the
     * generated shader code.
     *
     * @type {import('./light.js').Light[][]}
     * @private
     */
    private _splitLights;
    /**
     * True if _splitLights needs to be updated, which means if lights were added or removed from
     * the layer, or their key changed.
     *
     * @type {boolean}
     * @private
     */
    private _splitLightsDirty;
    /**
     * True if the objects rendered on the layer require light cube (emitters with lighting do).
     *
     * @type {boolean}
     * @ignore
     */
    requiresLightCube: boolean;
    /**
     * @type {import('../framework/components/camera/component.js').CameraComponent[]}
     * @ignore
     */
    cameras: CameraComponent[];
    /**
     * @type {Set<import('./camera.js').Camera>}
     * @ignore
     */
    camerasSet: Set<Camera>;
    /**
     * True if the composition is invalidated.
     *
     * @ignore
     */
    _dirtyComposition: boolean;
    /**
     * A unique ID of the layer. Layer IDs are stored inside {@link ModelComponent#layers},
     * {@link RenderComponent#layers}, {@link CameraComponent#layers},
     * {@link LightComponent#layers} and {@link ElementComponent#layers} instead of names.
     * Can be used in {@link LayerComposition#getLayerById}.
     *
     * @type {number}
     */
    id: number;
    /**
     * Name of the layer. Can be used in {@link LayerComposition#getLayerByName}.
     *
     * @type {string}
     */
    name: string;
    /**
     * @type {boolean}
     * @private
     */
    private _enabled;
    /**
     * @type {number}
     * @private
     */
    private _refCounter;
    /**
     * Defines the method used for sorting opaque (that is, not semi-transparent) mesh
     * instances before rendering. Can be:
     *
     * - {@link SORTMODE_NONE}
     * - {@link SORTMODE_MANUAL}
     * - {@link SORTMODE_MATERIALMESH}
     * - {@link SORTMODE_BACK2FRONT}
     * - {@link SORTMODE_FRONT2BACK}
     *
     * Defaults to {@link SORTMODE_MATERIALMESH}.
     *
     * @type {number}
     */
    opaqueSortMode: number;
    /**
     * Defines the method used for sorting semi-transparent mesh instances before rendering. Can be:
     *
     * - {@link SORTMODE_NONE}
     * - {@link SORTMODE_MANUAL}
     * - {@link SORTMODE_MATERIALMESH}
     * - {@link SORTMODE_BACK2FRONT}
     * - {@link SORTMODE_FRONT2BACK}
     *
     * Defaults to {@link SORTMODE_BACK2FRONT}.
     *
     * @type {number}
     */
    transparentSortMode: number;
    renderTarget: any;
    /**
     * A type of shader to use during rendering. Possible values are:
     *
     * - {@link SHADER_FORWARD}
     * - {@link SHADER_FORWARDHDR}
     * - {@link SHADER_DEPTH}
     * - Your own custom value. Should be in 19 - 31 range. Use {@link StandardMaterial#onUpdateShader}
     * to apply shader modifications based on this value.
     *
     * Defaults to {@link SHADER_FORWARD}.
     *
     * @type {number}
     */
    shaderPass: number;
    /**
     * @type {boolean}
     * @private
     */
    private _clearColorBuffer;
    /**
     * @type {boolean}
     * @private
     */
    private _clearDepthBuffer;
    /**
     * @type {boolean}
     * @private
     */
    private _clearStencilBuffer;
    /**
     * Custom function that is called before visibility culling is performed for this layer.
     * Useful, for example, if you want to modify camera projection while still using the same
     * camera and make frustum culling work correctly with it (see
     * {@link CameraComponent#calculateTransform} and {@link CameraComponent#calculateProjection}).
     * This function will receive camera index as the only argument. You can get the actual
     * camera being used by looking up {@link LayerComposition#cameras} with this index.
     *
     * @type {Function}
     */
    onPreCull: Function;
    /**
     * Custom function that is called before this layer is rendered. Useful, for example, for
     * reacting on screen size changes. This function is called before the first occurrence of
     * this layer in {@link LayerComposition}. It will receive camera index as the only
     * argument. You can get the actual camera being used by looking up
     * {@link LayerComposition#cameras} with this index.
     *
     * @type {Function}
     */
    onPreRender: Function;
    /**
     * Custom function that is called before opaque mesh instances (not semi-transparent) in
     * this layer are rendered. This function will receive camera index as the only argument.
     * You can get the actual camera being used by looking up {@link LayerComposition#cameras}
     * with this index.
     *
     * @type {Function}
     */
    onPreRenderOpaque: Function;
    /**
     * Custom function that is called before semi-transparent mesh instances in this layer are
     * rendered. This function will receive camera index as the only argument. You can get the
     * actual camera being used by looking up {@link LayerComposition#cameras} with this index.
     *
     * @type {Function}
     */
    onPreRenderTransparent: Function;
    /**
     * Custom function that is called after visibility culling is performed for this layer.
     * Useful for reverting changes done in {@link Layer#onPreCull} and determining final mesh
     * instance visibility (see {@link MeshInstance#visibleThisFrame}). This function will
     * receive camera index as the only argument. You can get the actual camera being used by
     * looking up {@link LayerComposition#cameras} with this index.
     *
     * @type {Function}
     */
    onPostCull: Function;
    /**
     * Custom function that is called after this layer is rendered. Useful to revert changes
     * made in {@link Layer#onPreRender}. This function is called after the last occurrence of this
     * layer in {@link LayerComposition}. It will receive camera index as the only argument.
     * You can get the actual camera being used by looking up {@link LayerComposition#cameras}
     * with this index.
     *
     * @type {Function}
     */
    onPostRender: Function;
    /**
     * Custom function that is called after opaque mesh instances (not semi-transparent) in
     * this layer are rendered. This function will receive camera index as the only argument.
     * You can get the actual camera being used by looking up {@link LayerComposition#cameras}
     * with this index.
     *
     * @type {Function}
     */
    onPostRenderOpaque: Function;
    /**
     * Custom function that is called after semi-transparent mesh instances in this layer are
     * rendered. This function will receive camera index as the only argument. You can get the
     * actual camera being used by looking up {@link LayerComposition#cameras} with this index.
     *
     * @type {Function}
     */
    onPostRenderTransparent: Function;
    /**
     * Custom function that is called before every mesh instance in this layer is rendered. It
     * is not recommended to set this function when rendering many objects every frame due to
     * performance reasons.
     *
     * @type {Function}
     */
    onDrawCall: Function;
    /**
     * Custom function that is called after the layer has been enabled. This happens when:
     *
     * - The layer is created with {@link Layer#enabled} set to true (which is the default value).
     * - {@link Layer#enabled} was changed from false to true
     * - {@link Layer#incrementCounter} was called and incremented the counter above zero.
     *
     * Useful for allocating resources this layer will use (e.g. creating render targets).
     *
     * @type {Function}
     */
    onEnable: Function;
    /**
     * Custom function that is called after the layer has been disabled. This happens when:
     *
     * - {@link Layer#enabled} was changed from true to false
     * - {@link Layer#decrementCounter} was called and set the counter to zero.
     *
     * @type {Function}
     */
    onDisable: Function;
    /**
     * Make this layer render the same mesh instances that another layer does instead of having
     * its own mesh instance list. Both layers must share cameras. Frustum culling is only
     * performed for one layer. Useful for rendering multiple passes using different shaders.
     *
     * @type {Layer}
     */
    layerReference: Layer;
    /**
     * @type {Function|null}
     * @ignore
     */
    customSortCallback: Function | null;
    /**
     * @type {Function|null}
     * @ignore
     */
    customCalculateSortValues: Function | null;
    _lightHash: number;
    _lightHashDirty: boolean;
    _lightIdHash: number;
    _lightIdHashDirty: boolean;
    skipRenderAfter: number;
    _skipRenderCounter: number;
    _renderTime: number;
    _forwardDrawCalls: number;
    _shadowDrawCalls: number;
    _shaderVersion: number;
    /**
     * Enable the layer. Disabled layers are skipped. Defaults to true.
     *
     * @type {boolean}
     */
    set enabled(arg: boolean);
    get enabled(): boolean;
    /**
     * If true, the camera will clear the color buffer when it renders this layer.
     *
     * @type {boolean}
     */
    set clearColorBuffer(arg: boolean);
    get clearColorBuffer(): boolean;
    /**
     * If true, the camera will clear the depth buffer when it renders this layer.
     *
     * @type {boolean}
     */
    set clearDepthBuffer(arg: boolean);
    get clearDepthBuffer(): boolean;
    /**
     * If true, the camera will clear the stencil buffer when it renders this layer.
     *
     * @type {boolean}
     */
    set clearStencilBuffer(arg: boolean);
    get clearStencilBuffer(): boolean;
    /**
     * True if the layer contains omni or spot lights
     *
     * @type {boolean}
     * @ignore
     */
    get hasClusteredLights(): boolean;
    /**
     * Returns lights used by clustered lighting in a set.
     *
     * @type {Set<import('./light.js').Light>}
     * @ignore
     */
    get clusteredLightsSet(): Set<Light>;
    /**
     * Increments the usage counter of this layer. By default, layers are created with counter set
     * to 1 (if {@link Layer.enabled} is true) or 0 (if it was false). Incrementing the counter
     * from 0 to 1 will enable the layer and call {@link Layer.onEnable}. Use this function to
     * "subscribe" multiple effects to the same layer. For example, if the layer is used to render
     * a reflection texture which is used by 2 mirrors, then each mirror can call this function
     * when visible and {@link Layer.decrementCounter} if invisible. In such case the reflection
     * texture won't be updated, when there is nothing to use it, saving performance.
     *
     * @ignore
     */
    incrementCounter(): void;
    /**
     * Decrements the usage counter of this layer. Decrementing the counter from 1 to 0 will
     * disable the layer and call {@link Layer.onDisable}. See {@link Layer#incrementCounter} for
     * more details.
     *
     * @ignore
     */
    decrementCounter(): void;
    /**
     * Adds an array of mesh instances to this layer.
     *
     * @param {import('./mesh-instance.js').MeshInstance[]} meshInstances - Array of
     * {@link MeshInstance}.
     * @param {boolean} [skipShadowCasters] - Set it to true if you don't want these mesh instances
     * to cast shadows in this layer. Defaults to false.
     */
    addMeshInstances(meshInstances: MeshInstance[], skipShadowCasters?: boolean): void;
    /**
     * Removes multiple mesh instances from this layer.
     *
     * @param {import('./mesh-instance.js').MeshInstance[]} meshInstances - Array of
     * {@link MeshInstance}. If they were added to this layer, they will be removed.
     * @param {boolean} [skipShadowCasters] - Set it to true if you want to still cast shadows from
     * removed mesh instances or if they never did cast shadows before. Defaults to false.
     */
    removeMeshInstances(meshInstances: MeshInstance[], skipShadowCasters?: boolean): void;
    /**
     * Adds an array of mesh instances to this layer, but only as shadow casters (they will not be
     * rendered anywhere, but only cast shadows on other objects).
     *
     * @param {import('./mesh-instance.js').MeshInstance[]} meshInstances - Array of
     * {@link MeshInstance}.
     */
    addShadowCasters(meshInstances: MeshInstance[]): void;
    /**
     * Removes multiple mesh instances from the shadow casters list of this layer, meaning they
     * will stop casting shadows.
     *
     * @param {import('./mesh-instance.js').MeshInstance[]} meshInstances - Array of
     * {@link MeshInstance}. If they were added to this layer, they will be removed.
     */
    removeShadowCasters(meshInstances: MeshInstance[]): void;
    /**
     * Removes all mesh instances from this layer.
     *
     * @param {boolean} [skipShadowCasters] - Set it to true if you want to continue the existing mesh
     * instances to cast shadows. Defaults to false, which removes shadow casters as well.
     */
    clearMeshInstances(skipShadowCasters?: boolean): void;
    markLightsDirty(): void;
    /**
     * Adds a light to this layer.
     *
     * @param {import('../framework/components/light/component.js').LightComponent} light - A
     * {@link LightComponent}.
     */
    addLight(light: LightComponent): void;
    /**
     * Removes a light from this layer.
     *
     * @param {import('../framework/components/light/component.js').LightComponent} light - A
     * {@link LightComponent}.
     */
    removeLight(light: LightComponent): void;
    /**
     * Removes all lights from this layer.
     */
    clearLights(): void;
    get splitLights(): Light[][];
    evaluateLightHash(localLights: any, directionalLights: any, useIds: any): number;
    getLightHash(isClustered: any): number;
    getLightIdHash(): number;
    /**
     * Adds a camera to this layer.
     *
     * @param {import('../framework/components/camera/component.js').CameraComponent} camera - A
     * {@link CameraComponent}.
     */
    addCamera(camera: CameraComponent): void;
    /**
     * Removes a camera from this layer.
     *
     * @param {import('../framework/components/camera/component.js').CameraComponent} camera - A
     * {@link CameraComponent}.
     */
    removeCamera(camera: CameraComponent): void;
    /**
     * Removes all cameras from this layer.
     */
    clearCameras(): void;
    /**
     * @param {import('./mesh-instance.js').MeshInstance[]} drawCalls - Array of mesh instances.
     * @param {number} drawCallsCount - Number of mesh instances.
     * @param {import('../core/math/vec3.js').Vec3} camPos - Camera position.
     * @param {import('../core/math/vec3.js').Vec3} camFwd - Camera forward vector.
     * @private
     */
    private _calculateSortDistances;
    /**
     * Get access to culled mesh instances for the provided camera.
     *
     * @param {import('./camera.js').Camera} camera - The camera.
     * @returns {CulledInstances} The culled mesh instances.
     * @ignore
     */
    getCulledInstances(camera: Camera): CulledInstances;
    /**
     * @param {import('./camera.js').Camera} camera - The camera to sort the visible mesh instances
     * for.
     * @param {boolean} transparent - True if transparent sorting should be used.
     * @ignore
     */
    sortVisible(camera: Camera, transparent: boolean): void;
}
declare class CulledInstances {
    /**
     * Visible opaque mesh instances.
     *
     * @type {import('./mesh-instance.js').MeshInstance[]}
     */
    opaque: MeshInstance[];
    /**
     * Visible transparent mesh instances.
     *
     * @type {import('./mesh-instance.js').MeshInstance[]}
     */
    transparent: MeshInstance[];
}

/**
 * A uniform buffer represents a GPU memory buffer storing the uniforms.
 *
 * @ignore
 */
declare class UniformBuffer {
    /**
     * Create a new UniformBuffer instance.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this uniform buffer.
     * @param {import('./uniform-buffer-format.js').UniformBufferFormat} format - Format of the
     * uniform buffer.
     * @param {boolean} [persistent] - Whether the buffer is persistent. Defaults to true.
     */
    constructor(graphicsDevice: GraphicsDevice, format: UniformBufferFormat, persistent?: boolean);
    device: GraphicsDevice;
    /** @type {boolean} */
    persistent: boolean;
    /** @type {DynamicBufferAllocation} */
    allocation: DynamicBufferAllocation;
    /** @type {Float32Array} */
    storageFloat32: Float32Array;
    /** @type {Int32Array} */
    storageInt32: Int32Array;
    /** @type {Uint32Array} */
    storageUint32: Uint32Array;
    /**
     * A render version used to track the last time the properties requiring bind group to be
     * updated were changed.
     *
     * @type {number}
     */
    renderVersionDirty: number;
    format: UniformBufferFormat;
    impl: any;
    /**
     * Frees resources associated with this uniform buffer.
     */
    destroy(): void;
    get offset(): number;
    /**
     * Assign a storage to this uniform buffer.
     *
     * @param {Int32Array} storage - The storage to assign to this uniform buffer.
     */
    assignStorage(storage: Int32Array): void;
    /**
     * Called when the rendering context was lost. It releases all context related resources.
     *
     * @ignore
     */
    loseContext(): void;
    /**
     * Assign a value to the uniform specified by its format. This is the fast version of assigning
     * a value to a uniform, avoiding any lookups.
     *
     * @param {import('./uniform-buffer-format.js').UniformFormat} uniformFormat - The format of
     * the uniform.
     */
    setUniform(uniformFormat: UniformFormat): void;
    /**
     * Assign a value to the uniform specified by name.
     *
     * @param {string} name - The name of the uniform.
     */
    set(name: string): void;
    update(): void;
}

/**
 * A bind group represents an collection of {@link UniformBuffer} and {@link Texture} instance,
 * which can be bind on a GPU for rendering.
 *
 * @ignore
 */
declare class BindGroup {
    /**
     * Create a new Bind Group.
     *
     * @param {import('./graphics-device.js').GraphicsDevice} graphicsDevice - The graphics device
     * used to manage this uniform buffer.
     * @param {import('./bind-group-format.js').BindGroupFormat} format - Format of the bind group.
     * @param {import('./uniform-buffer.js').UniformBuffer} [defaultUniformBuffer] - The default
     * uniform buffer. Typically a bind group only has a single uniform buffer, and this allows
     * easier access.
     */
    constructor(graphicsDevice: GraphicsDevice, format: BindGroupFormat, defaultUniformBuffer?: UniformBuffer);
    /**
     * A render version the bind group was last updated on.
     *
     * @type {number}
     * @ignore
     */
    renderVersionUpdated: number;
    /** @type {import('./uniform-buffer.js').UniformBuffer[]} */
    uniformBuffers: UniformBuffer[];
    /**
     * An array of offsets for each uniform buffer in the bind group. This is the offset in the
     * buffer where the uniform buffer data starts.
     *
     * @type {number[]}
     */
    uniformBufferOffsets: number[];
    id: number;
    device: GraphicsDevice;
    format: BindGroupFormat;
    dirty: boolean;
    impl: any;
    textures: any[];
    storageTextures: any[];
    /** @type {import('./uniform-buffer.js').UniformBuffer} */
    defaultUniformBuffer: UniformBuffer;
    /**
     * Frees resources associated with this bind group.
     */
    destroy(): void;
    /**
     * Assign a uniform buffer to a slot.
     *
     * @param {string} name - The name of the uniform buffer slot
     * @param {import('./uniform-buffer.js').UniformBuffer} uniformBuffer - The Uniform buffer to
     * assign to the slot.
     */
    setUniformBuffer(name: string, uniformBuffer: UniformBuffer): void;
    /**
     * Assign a texture to a named slot.
     *
     * @param {string} name - The name of the texture slot.
     * @param {import('./texture.js').Texture} texture - Texture to assign to the slot.
     */
    setTexture(name: string, texture: Texture): void;
    /**
     * Assign a storage texture to a named slot.
     *
     * @param {string} name - The name of the texture slot.
     * @param {import('./texture.js').Texture} texture - Texture to assign to the slot.
     */
    setStorageTexture(name: string, texture: Texture): void;
    /**
     * Applies any changes made to the bind group's properties.
     */
    update(): void;
}

/**
 * Class representing an entry in the final order of rendering of cameras and layers in the engine
 * this is populated at runtime based on LayerComposition
 *
 * @ignore
 */
declare class RenderAction {
    /** @type {import('../layer.js').Layer|null} */
    layer: Layer | null;
    transparent: boolean;
    camera: any;
    /**
     * render target this render action renders to (taken from either camera or layer)
     *
     * @type {import('../../platform/graphics/render-target.js').RenderTarget|null}
     */
    renderTarget: RenderTarget | null;
    lightClusters: any;
    clearColor: boolean;
    clearDepth: boolean;
    clearStencil: boolean;
    triggerPostprocess: boolean;
    firstCameraUse: boolean;
    lastCameraUse: boolean;
    /** @type {import('../../platform/graphics/bind-group.js').BindGroup[]} */
    viewBindGroups: BindGroup[];
    useCameraPasses: boolean;
    destroy(): void;
    setupClears(camera: any, layer: any): void;
}

/**
 * Layer Composition is a collection of {@link Layer} that is fed to {@link Scene#layers} to define
 * rendering order.
 *
 * @augments EventHandler
 * @category Graphics
 */
declare class LayerComposition extends EventHandler {
    /**
     * Create a new layer composition.
     *
     * @param {string} [name] - Optional non-unique name of the layer composition. Defaults to
     * "Untitled" if not specified.
     */
    constructor(name?: string);
    /**
     * A read-only array of {@link Layer} sorted in the order they will be rendered.
     *
     * @type {import('../layer.js').Layer[]}
     */
    layerList: Layer[];
    /**
     * A mapping of {@link Layer#id} to {@link Layer}.
     *
     * @type {Map<number, import('../layer.js').Layer>}
     * @ignore
     */
    layerIdMap: Map<number, Layer>;
    /**
     * A mapping of {@link Layer#name} to {@link Layer}.
     *
     * @type {Map<string, import('../layer.js').Layer>}
     * @ignore
     */
    layerNameMap: Map<string, Layer>;
    /**
     * A mapping of {@link Layer} to its opaque index in {@link LayerComposition#layerList}.
     *
     * @type {Map<import('../layer.js').Layer, number>}
     * @ignore
     */
    layerOpaqueIndexMap: Map<Layer, number>;
    /**
     * A mapping of {@link Layer} to its transparent index in {@link LayerComposition#layerList}.
     *
     * @type {Map<import('../layer.js').Layer, number>}
     * @ignore
     */
    layerTransparentIndexMap: Map<Layer, number>;
    /**
     * A read-only array of boolean values, matching {@link LayerComposition#layerList}. True means only
     * semi-transparent objects are rendered, and false means opaque.
     *
     * @type {boolean[]}
     * @ignore
     */
    subLayerList: boolean[];
    /**
     * A read-only array of boolean values, matching {@link LayerComposition#layerList}. True means the
     * layer is rendered, false means it's skipped.
     *
     * @type {boolean[]}
     */
    subLayerEnabled: boolean[];
    /**
     * A read-only array of {@link CameraComponent} that can be used during rendering. e.g.
     * Inside {@link Layer#onPreCull}, {@link Layer#onPostCull}, {@link Layer#onPreRender},
     * {@link Layer#onPostRender}.
     *
     * @type {import('../../framework/components/camera/component.js').CameraComponent[]}
     */
    cameras: CameraComponent[];
    /**
     * A mapping of {@link CameraComponent} to its index in {@link LayerComposition#cameras}.
     *
     * @type {Map<import('../../framework/components/camera/component.js').CameraComponent, number>}
     * @ignore
     */
    camerasMap: Map<CameraComponent, number>;
    /**
     * The actual rendering sequence, generated based on layers and cameras
     *
     * @type {RenderAction[]}
     * @ignore
     */
    _renderActions: RenderAction[];
    /**
     * True if the composition needs to be updated before rendering.
     *
     * @ignore
     */
    _dirty: boolean;
    name: string;
    _opaqueOrder: {};
    _transparentOrder: {};
    destroy(): void;
    destroyRenderActions(): void;
    _update(): void;
    getNextRenderAction(renderActionIndex: any): RenderAction;
    addDummyRenderAction(renderActionIndex: any, camera: any): void;
    addRenderAction(renderActionIndex: any, layer: any, isTransparent: any, camera: any, cameraFirstRenderAction: any, postProcessMarked: any): RenderAction;
    propagateRenderTarget(startIndex: any, fromCamera: any): void;
    _logRenderActions(): void;
    _isLayerAdded(layer: any): boolean;
    _isSublayerAdded(layer: any, transparent: any): boolean;
    /**
     * Adds a layer (both opaque and semi-transparent parts) to the end of the {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to add.
     */
    push(layer: Layer): void;
    /**
     * Inserts a layer (both opaque and semi-transparent parts) at the chosen index in the
     * {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to add.
     * @param {number} index - Insertion position.
     */
    insert(layer: Layer, index: number): void;
    /**
     * Removes a layer (both opaque and semi-transparent parts) from {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to remove.
     */
    remove(layer: Layer): void;
    /**
     * Adds part of the layer with opaque (non semi-transparent) objects to the end of the
     * {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to add.
     */
    pushOpaque(layer: Layer): void;
    /**
     * Inserts an opaque part of the layer (non semi-transparent mesh instances) at the chosen
     * index in the {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to add.
     * @param {number} index - Insertion position.
     */
    insertOpaque(layer: Layer, index: number): void;
    /**
     * Removes an opaque part of the layer (non semi-transparent mesh instances) from
     * {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to remove.
     */
    removeOpaque(layer: Layer): void;
    /**
     * Adds part of the layer with semi-transparent objects to the end of the {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to add.
     */
    pushTransparent(layer: Layer): void;
    /**
     * Inserts a semi-transparent part of the layer at the chosen index in the {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to add.
     * @param {number} index - Insertion position.
     */
    insertTransparent(layer: Layer, index: number): void;
    /**
     * Removes a transparent part of the layer from {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to remove.
     */
    removeTransparent(layer: Layer): void;
    /**
     * Gets index of the opaque part of the supplied layer in the {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to find index of.
     * @returns {number} The index of the opaque part of the specified layer, or -1 if it is not
     * part of the composition.
     */
    getOpaqueIndex(layer: Layer): number;
    /**
     * Gets index of the semi-transparent part of the supplied layer in the {@link LayerComposition#layerList}.
     *
     * @param {import('../layer.js').Layer} layer - A {@link Layer} to find index of.
     * @returns {number} The index of the semi-transparent part of the specified layer, or -1 if it
     * is not part of the composition.
     */
    getTransparentIndex(layer: Layer): number;
    isEnabled(layer: any, transparent: any): boolean;
    /**
     * Update maps of layer IDs and names to match the layer list.
     *
     * @private
     */
    private _updateLayerMaps;
    /**
     * Finds a layer inside this composition by its ID. Null is returned, if nothing is found.
     *
     * @param {number} id - An ID of the layer to find.
     * @returns {import('../layer.js').Layer|null} The layer corresponding to the specified ID.
     * Returns null if layer is not found.
     */
    getLayerById(id: number): Layer | null;
    /**
     * Finds a layer inside this composition by its name. Null is returned, if nothing is found.
     *
     * @param {string} name - The name of the layer to find.
     * @returns {import('../layer.js').Layer|null} The layer corresponding to the specified name.
     * Returns null if layer is not found.
     */
    getLayerByName(name: string): Layer | null;
    _updateOpaqueOrder(startIndex: any, endIndex: any): void;
    _updateTransparentOrder(startIndex: any, endIndex: any): void;
    _sortLayersDescending(layersA: any, layersB: any, order: any): number;
    /**
     * Used to determine which array of layers has any transparent sublayer that is on top of all
     * the transparent sublayers in the other array.
     *
     * @param {number[]} layersA - IDs of layers.
     * @param {number[]} layersB - IDs of layers.
     * @returns {number} Returns a negative number if any of the transparent sublayers in layersA
     * is on top of all the transparent sublayers in layersB, or a positive number if any of the
     * transparent sublayers in layersB is on top of all the transparent sublayers in layersA, or 0
     * otherwise.
     * @private
     */
    private sortTransparentLayers;
    /**
     * Used to determine which array of layers has any opaque sublayer that is on top of all the
     * opaque sublayers in the other array.
     *
     * @param {number[]} layersA - IDs of layers.
     * @param {number[]} layersB - IDs of layers.
     * @returns {number} Returns a negative number if any of the opaque sublayers in layersA is on
     * top of all the opaque sublayers in layersB, or a positive number if any of the opaque
     * sublayers in layersB is on top of all the opaque sublayers in layersA, or 0 otherwise.
     * @private
     */
    private sortOpaqueLayers;
}

/**
 * Lighting parameters, allow configuration of the global lighting parameters. For details see
 * [Clustered Lighting](https://developer.playcanvas.com/user-manual/graphics/lighting/clustered-lighting/).
 *
 * @category Graphics
 */
declare class LightingParams {
    /**
     * Creates a new LightingParams object.
     *
     * @ignore
     */
    constructor(supportsAreaLights: any, maxTextureSize: any, dirtyLightsFnc: any);
    /** @private */
    private _areaLightsEnabled;
    /** @private */
    private _cells;
    /** @private */
    private _maxLightsPerCell;
    /** @private */
    private _shadowsEnabled;
    /** @private */
    private _shadowType;
    /** @private */
    private _shadowAtlasResolution;
    /** @private */
    private _cookiesEnabled;
    /** @private */
    private _cookieAtlasResolution;
    /**
     * Layer ID of a layer to contain the debug rendering of clustered lighting. Defaults to
     * undefined, which disables the debug rendering. Debug rendering is only included in the debug
     * version of the engine.
     *
     * @type {number}
     */
    debugLayer: number;
    /**
     * Atlas textures split description, which applies to both the shadow and cookie texture atlas.
     * Defaults to null, which enables to automatic split mode. For details see [Configuring Atlas
     * Split](https://developer.playcanvas.com/user-manual/graphics/lighting/clustered-lighting/#configuring-atlas).
     *
     * @type {number[]|null}
     */
    atlasSplit: number[] | null;
    _supportsAreaLights: any;
    _maxTextureSize: any;
    _dirtyLightsFnc: any;
    applySettings(render: any): void;
    /**
     * If set to true, the clustered lighting will support shadows.
     * Defaults to true.
     *
     * @type {boolean}
     */
    set shadowsEnabled(arg: boolean);
    get shadowsEnabled(): boolean;
    /**
     * If set to true, the clustered lighting will support cookie textures.
     * Defaults to false.
     *
     * @type {boolean}
     */
    set cookiesEnabled(arg: boolean);
    get cookiesEnabled(): boolean;
    /**
     * If set to true, the clustered lighting will support area lights.
     * Defaults to false.
     *
     * @type {boolean}
     */
    set areaLightsEnabled(arg: boolean);
    get areaLightsEnabled(): boolean;
    /**
     * Resolution of the atlas texture storing all non-directional shadow textures.
     * Defaults to 2048.
     *
     * @type {number}
     */
    set shadowAtlasResolution(arg: number);
    get shadowAtlasResolution(): number;
    /**
     * Resolution of the atlas texture storing all non-directional cookie textures.
     * Defaults to 2048.
     *
     * @type {number}
     */
    set cookieAtlasResolution(arg: number);
    get cookieAtlasResolution(): number;
    /**
     * Maximum number of lights a cell can store. Defaults to 255.
     *
     * @type {number}
     */
    set maxLightsPerCell(arg: number);
    get maxLightsPerCell(): number;
    /**
     * The type of shadow filtering used by all shadows. Can be:
     *
     * - {@link SHADOW_PCF1}: PCF 1x1 sampling.
     * - {@link SHADOW_PCF3}: PCF 3x3 sampling.
     * - {@link SHADOW_PCF5}: PCF 5x5 sampling. Falls back to {@link SHADOW_PCF3} on WebGL 1.0.
     *
     * Defaults to {@link SHADOW_PCF3}
     *
     * @type {number}
     */
    set shadowType(arg: number);
    get shadowType(): number;
    cell: Vec3;
    /**
     * Number of cells along each world-space axis the space containing lights
     * is subdivided into. Defaults to Vec(10, 3, 10).
     *
     * @type {Vec3}
     */
    set cells(arg: Vec3);
    get cells(): Vec3;
}

/**
 * A visual representation of the sky.
 *
 * @ignore
 */
declare class SkyMesh {
    /**
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The
     * graphics device.
     * @param {import('../scene.js').Scene} scene - The scene owning the sky.
     * @param {import('../../platform/graphics/texture.js').Texture} texture - The texture of the sky.
     * @param {string} type - The type of the sky. One of the SKYMESH_* constants.
     */
    constructor(device: GraphicsDevice, scene: Scene, node: any, texture: Texture, type: string);
    /**
     * Mesh instance representing the visuals of the sky.
     *
     * @type {MeshInstance|null}
     */
    meshInstance: MeshInstance | null;
    skyLayer: Layer;
    destroy(): void;
}

/**
 * Implementation of the sky.
 *
 * @category Graphics
 * @ignore
 */
declare class Sky {
    /**
     * Constructs a new sky.
     *
     * @param {import('../scene.js').Scene} scene - The scene owning the sky.
     * @hideconstructor
     */
    constructor(scene: Scene);
    /**
     * The type of the sky. One of the SKYMESH_* constants.
     *
     * @type {string}
     * @private
     */
    private _type;
    /**
     * The center of the sky.
     *
     * @type {Vec3}
     * @private
     */
    private _center;
    /**
     * The sky mesh of the scene.
     *
     * @type {SkyMesh|null}
     * @ignore
     */
    skyMesh: SkyMesh | null;
    /**
     * A graph node with a transform used to render the sky mesh. Adjust the position, rotation and
     * scale of this node to orient the sky mesh. Ignored for {@link SKYTYPE_INFINITE}.
     *
     * @type {GraphNode}
     * @readonly
     */
    readonly node: GraphNode;
    device: GraphicsDevice;
    scene: Scene;
    /**
     * The center of the sky. Ignored for {@link SKYTYPE_INFINITE}. Typically only the y-coordinate
     * is used, representing the tripod height. Defaults to (0, 1, 0).
     *
     * @type {Vec3}
     */
    set center(arg: Vec3);
    get center(): Vec3;
    centerArray: Float32Array;
    projectedSkydomeCenterId: ScopeId;
    applySettings(render: any): void;
    /**
     * The type of the sky. One of the SKYMESH_* constants. Defaults to {@link SKYTYPE_INFINITE}.
     * Can be:
     *
     * {@link SKYTYPE_INFINITE}
     * {@link SKYTYPE_BOX}
     * {@link SKYTYPE_DOME}
     *
     * @type {string}
     */
    set type(arg: string);
    get type(): string;
    updateSkyMesh(): void;
    resetSkyMesh(): void;
    update(): void;
}

/**
 * A material determines how a particular mesh instance is rendered. It specifies the shader and
 * render state that is set before the mesh instance is submitted to the graphics device.
 *
 * @category Graphics
 */
declare class Material {
    /**
     * A shader used to render the material. Note that this is used only by materials where the
     * user specifies the shader. Most material types generate multiple shader variants, and do not
     * set this.
     *
     * @type {import('../../platform/graphics/shader.js').Shader}
     * @private
     */
    private _shader;
    /**
     * The mesh instances referencing this material
     *
     * @type {import('../mesh-instance.js').MeshInstance[]}
     * @private
     */
    private meshInstances;
    /**
     * The name of the material.
     *
     * @type {string}
     */
    name: string;
    /**
     * A unique id the user can assign to the material. The engine internally does not use this for
     * anything, and the user can assign a value to this id for any purpose they like. Defaults to
     * an empty string.
     *
     * @type {string}
     */
    userId: string;
    id: number;
    /**
     * The cache of shader variants generated for this material. The key represents the unique
     * variant, the value is the shader.
     *
     * @type {Map<string, import('../../platform/graphics/shader.js').Shader>}
     * @ignore
     */
    variants: Map<string, Shader>;
    parameters: {};
    /**
     * The alpha test reference value to control which fragments are written to the currently
     * active render target based on alpha value. All fragments with an alpha value of less than
     * the alphaTest reference value will be discarded. alphaTest defaults to 0 (all fragments
     * pass).
     *
     * @type {number}
     */
    alphaTest: number;
    /**
     * Enables or disables alpha to coverage (WebGL2 only). When enabled, and if hardware
     * anti-aliasing is on, limited order-independent transparency can be achieved. Quality depends
     * on the number of MSAA samples of the current render target. It can nicely soften edges of
     * otherwise sharp alpha cutouts, but isn't recommended for large area semi-transparent
     * surfaces. Note, that you don't need to enable blending to make alpha to coverage work. It
     * will work without it, just like alphaTest.
     *
     * @type {boolean}
     */
    alphaToCoverage: boolean;
    /** @ignore */
    _blendState: BlendState;
    /** @ignore */
    _depthState: DepthState;
    /**
     * Controls how triangles are culled based on their face direction with respect to the
     * viewpoint. Can be:
     *
     * - {@link CULLFACE_NONE}: Do not cull triangles based on face direction.
     * - {@link CULLFACE_BACK}: Cull the back faces of triangles (do not render triangles facing
     * away from the view point).
     * - {@link CULLFACE_FRONT}: Cull the front faces of triangles (do not render triangles facing
     * towards the view point).
     *
     * Defaults to {@link CULLFACE_BACK}.
     *
     * @type {number}
     */
    cull: number;
    /**
     * Stencil parameters for front faces (default is null).
     *
     * @type {import('../../platform/graphics/stencil-parameters.js').StencilParameters|null}
     */
    stencilFront: StencilParameters | null;
    /**
     * Stencil parameters for back faces (default is null).
     *
     * @type {import('../../platform/graphics/stencil-parameters.js').StencilParameters|null}
     */
    stencilBack: StencilParameters | null;
    /**
     * Offsets the output depth buffer value. Useful for decals to prevent z-fighting. Typically
     * a small negative value (-0.1) is used to render the mesh slightly closer to the camera.
     *
     * @type {number}
     */
    set depthBias(arg: number);
    get depthBias(): number;
    /**
     * Same as {@link Material#depthBias}, but also depends on the slope of the triangle relative
     * to the camera.
     *
     * @type {number}
     */
    set slopeDepthBias(arg: number);
    get slopeDepthBias(): number;
    _shaderVersion: number;
    _scene: any;
    dirty: boolean;
    /**
     * If true, the red component of fragments generated by the shader of this material is written
     * to the color buffer of the currently active render target. If false, the red component will
     * not be written. Defaults to true.
     *
     * @type {boolean}
     */
    set redWrite(arg: boolean);
    get redWrite(): boolean;
    /**
     * If true, the green component of fragments generated by the shader of this material is
     * written to the color buffer of the currently active render target. If false, the green
     * component will not be written. Defaults to true.
     *
     * @type {boolean}
     */
    set greenWrite(arg: boolean);
    get greenWrite(): boolean;
    /**
     * If true, the blue component of fragments generated by the shader of this material is
     * written to the color buffer of the currently active render target. If false, the blue
     * component will not be written. Defaults to true.
     *
     * @type {boolean}
     */
    set blueWrite(arg: boolean);
    get blueWrite(): boolean;
    /**
     * If true, the alpha component of fragments generated by the shader of this material is
     * written to the color buffer of the currently active render target. If false, the alpha
     * component will not be written. Defaults to true.
     *
     * @type {boolean}
     */
    set alphaWrite(arg: boolean);
    get alphaWrite(): boolean;
    /**
     * The shader used by this material to render mesh instances (default is null).
     *
     * @type {import('../../platform/graphics/shader.js').Shader|null}
     */
    set shader(arg: Shader);
    get shader(): Shader;
    get transparent(): boolean;
    _updateTransparency(): void;
    /**
     * Controls how fragment shader outputs are blended when being written to the currently active
     * render target. This overwrites blending type set using {@link Material#blendType}, and
     * offers more control over blending.
     *
     * @type { BlendState }
     */
    set blendState(arg: BlendState);
    get blendState(): BlendState;
    /**
     * Controls how fragment shader outputs are blended when being written to the currently active
     * render target. Can be:
     *
     * - {@link BLEND_SUBTRACTIVE}: Subtract the color of the source fragment from the destination
     * fragment and write the result to the frame buffer.
     * - {@link BLEND_ADDITIVE}: Add the color of the source fragment to the destination fragment
     * and write the result to the frame buffer.
     * - {@link BLEND_NORMAL}: Enable simple translucency for materials such as glass. This is
     * equivalent to enabling a source blend mode of {@link BLENDMODE_SRC_ALPHA} and a destination
     * blend mode of {@link BLENDMODE_ONE_MINUS_SRC_ALPHA}.
     * - {@link BLEND_NONE}: Disable blending.
     * - {@link BLEND_PREMULTIPLIED}: Similar to {@link BLEND_NORMAL} expect the source fragment is
     * assumed to have already been multiplied by the source alpha value.
     * - {@link BLEND_MULTIPLICATIVE}: Multiply the color of the source fragment by the color of the
     * destination fragment and write the result to the frame buffer.
     * - {@link BLEND_ADDITIVEALPHA}: Same as {@link BLEND_ADDITIVE} except the source RGB is
     * multiplied by the source alpha.
     * - {@link BLEND_MULTIPLICATIVE2X}: Multiplies colors and doubles the result.
     * - {@link BLEND_SCREEN}: Softer version of additive.
     * - {@link BLEND_MIN}: Minimum color. Check app.graphicsDevice.extBlendMinmax for support.
     * - {@link BLEND_MAX}: Maximum color. Check app.graphicsDevice.extBlendMinmax for support.
     *
     * Defaults to {@link BLEND_NONE}.
     *
     * @type {number}
     */
    set blendType(arg: number);
    get blendType(): number;
    /**
     * Sets the depth state. Note that this can also be done by using {@link Material#depthTest},
     * {@link Material#depthFunc} and {@link Material#depthWrite}.
     *
     * @type { DepthState }
     */
    set depthState(arg: DepthState);
    get depthState(): DepthState;
    /**
     * If true, fragments generated by the shader of this material are only written to the current
     * render target if they pass the depth test. If false, fragments generated by the shader of
     * this material are written to the current render target regardless of what is in the depth
     * buffer. Defaults to true.
     *
     * @type {boolean}
     */
    set depthTest(arg: boolean);
    get depthTest(): boolean;
    /**
     * Controls how the depth of new fragments is compared against the current depth contained in
     * the depth buffer. Can be:
     *
     * - {@link FUNC_NEVER}: don't draw
     * - {@link FUNC_LESS}: draw if new depth < depth buffer
     * - {@link FUNC_EQUAL}: draw if new depth == depth buffer
     * - {@link FUNC_LESSEQUAL}: draw if new depth <= depth buffer
     * - {@link FUNC_GREATER}: draw if new depth > depth buffer
     * - {@link FUNC_NOTEQUAL}: draw if new depth != depth buffer
     * - {@link FUNC_GREATEREQUAL}: draw if new depth >= depth buffer
     * - {@link FUNC_ALWAYS}: always draw
     *
     * Defaults to {@link FUNC_LESSEQUAL}.
     *
     * @type {number}
     */
    set depthFunc(arg: number);
    get depthFunc(): number;
    /**
     * If true, fragments generated by the shader of this material write a depth value to the depth
     * buffer of the currently active render target. If false, no depth value is written. Defaults
     * to true.
     *
     * @type {boolean}
     */
    set depthWrite(arg: boolean);
    get depthWrite(): boolean;
    /**
     * Copy a material.
     *
     * @param {Material} source - The material to copy.
     * @returns {Material} The destination material.
     */
    copy(source: Material): Material;
    /**
     * Clone a material.
     *
     * @returns {this} A newly cloned material.
     */
    clone(): this;
    _updateMeshInstanceKeys(): void;
    updateUniforms(device: any, scene: any): void;
    getShaderVariant(device: any, scene: any, objDefs: any, unused: any, pass: any, sortedLights: any, viewUniformFormat: any, viewBindGroupFormat: any, vertexFormat: any): Shader;
    /**
     * Applies any changes made to the material's properties.
     */
    update(): void;
    clearParameters(): void;
    getParameters(): {};
    clearVariants(): void;
    /**
     * Retrieves the specified shader parameter from a material.
     *
     * @param {string} name - The name of the parameter to query.
     * @returns {object} The named parameter.
     */
    getParameter(name: string): object;
    /**
     * Sets a shader parameter on a material.
     *
     * @param {string} name - The name of the parameter to set.
     * @param {number|number[]|Float32Array|import('../../platform/graphics/texture.js').Texture} data -
     * The value for the specified parameter.
     */
    setParameter(name: string, data: number | number[] | Float32Array | Texture): void;
    /**
     * Deletes a shader parameter on a material.
     *
     * @param {string} name - The name of the parameter to delete.
     */
    deleteParameter(name: string): void;
    setParameters(device: any, names: any): void;
    /**
     * Removes this material from the scene and possibly frees up memory from its shaders (if there
     * are no other materials using it).
     */
    destroy(): void;
    /**
     * Registers mesh instance as referencing the material.
     *
     * @param {import('../mesh-instance.js').MeshInstance} meshInstance - The mesh instance to
     * register.
     * @ignore
     */
    addMeshInstanceRef(meshInstance: MeshInstance): void;
    /**
     * De-registers mesh instance as referencing the material.
     *
     * @param {import('../mesh-instance.js').MeshInstance} meshInstance - The mesh instance to
     * de-register.
     * @ignore
     */
    removeMeshInstanceRef(meshInstance: MeshInstance): void;
}

/**
 * A BasicMaterial is for rendering unlit geometry, either using a constant color or a color map
 * modulated with a color.
 *
 * ```javascript
 * // Create a new Basic material
 * const material = new pc.BasicMaterial();
 *
 * // Set the material to have a texture map that is multiplied by a red color
 * material.color.set(1, 0, 0);
 * material.colorMap = diffuseMap;
 *
 * // Notify the material that it has been modified
 * material.update();
 * ```
 *
 * @augments Material
 * @category Graphics
 */
declare class BasicMaterial extends Material {
    /**
     * The flat color of the material (RGBA, where each component is 0 to 1).
     *
     * @type {Color}
     */
    color: Color;
    /** @ignore */
    colorUniform: Float32Array;
    /**
     * The color map of the material (default is null). If specified, the color map is
     * modulated by the color property.
     *
     * @type {import('../../platform/graphics/texture.js').Texture|null}
     */
    colorMap: Texture | null;
    /** @ignore */
    vertexColors: boolean;
    /**
     * Copy a `BasicMaterial`.
     *
     * @param {BasicMaterial} source - The material to copy from.
     * @returns {BasicMaterial} The destination material.
     */
    copy(source: BasicMaterial): BasicMaterial;
    /**
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The graphics device.
     * @param {import('../scene.js').Scene} scene - The scene.
     * @ignore
     */
    updateUniforms(device: GraphicsDevice, scene: Scene): void;
}

declare class Immediate {
    constructor(device: any);
    device: any;
    quadMesh: Mesh;
    textureShader: any;
    depthTextureShader: any;
    cubeLocalPos: any;
    cubeWorldPos: any;
    batchesMap: Map<any, any>;
    allBatches: Set<any>;
    updatedLayers: Set<any>;
    _materialDepth: BasicMaterial;
    _materialNoDepth: BasicMaterial;
    layerMeshInstances: Map<any, any>;
    createMaterial(depthTest: any): BasicMaterial;
    get materialDepth(): BasicMaterial;
    get materialNoDepth(): BasicMaterial;
    getBatch(layer: any, depthTest: any): any;
    getShader(id: any, fragment: any): any;
    getTextureShader(): any;
    getUnfilterableTextureShader(): any;
    getDepthTextureShader(): any;
    getQuadMesh(): Mesh;
    drawMesh(material: any, matrix: any, mesh: any, meshInstance: any, layer: any): void;
    drawWireAlignedBox(min: any, max: any, color: any, depthTest: any, layer: any, mat: any): void;
    drawWireSphere(center: any, radius: any, color: any, numSegments: any, depthTest: any, layer: any): void;
    getGraphNode(matrix: any): GraphNode;
    onPreRenderLayer(layer: any, visibleList: any, transparent: any): void;
    onPostRender(): void;
}

/**
 * A scene is graphical representation of an environment. It manages the scene hierarchy, all
 * graphical objects, lights, and scene-wide properties.
 *
 * @augments EventHandler
 * @category Graphics
 */
declare class Scene extends EventHandler {
    /**
     * Fired when the layer composition is set. Use this event to add callbacks or advanced
     * properties to your layers. The handler is passed the old and the new
     * {@link LayerComposition}.
     *
     * @event
     * @example
     * app.scene.on('set:layers', (oldComp, newComp) => {
     *     const list = newComp.layerList;
     *     for (let i = 0; i < list.length; i++) {
     *         const layer = list[i];
     *         switch (layer.name) {
     *             case 'MyLayer':
     *                 layer.onEnable = myOnEnableFunction;
     *                 layer.onDisable = myOnDisableFunction;
     *                 break;
     *             case 'MyOtherLayer':
     *                 layer.shaderPass = myShaderPass;
     *                 break;
     *         }
     *     }
     * });
     */
    static EVENT_SETLAYERS: string;
    /**
     * Fired when the skybox is set. The handler is passed the {@link Texture} that is the
     * previously used skybox cubemap texture. The new skybox cubemap texture is in the
     * {@link Scene#skybox} property.
     *
     * @event
     * @example
     * app.scene.on('set:skybox', (oldSkybox) => {
     *     console.log(`Skybox changed from ${oldSkybox.name} to ${app.scene.skybox.name}`);
     * });
     */
    static EVENT_SETSKYBOX: string;
    /**
     * Create a new Scene instance.
     *
     * @param {import('../platform/graphics/graphics-device.js').GraphicsDevice} graphicsDevice -
     * The graphics device used to manage this scene.
     * @hideconstructor
     */
    constructor(graphicsDevice: GraphicsDevice);
    /**
     * If enabled, the ambient lighting will be baked into lightmaps. This will be either the
     * {@link Scene#skybox} if set up, otherwise {@link Scene#ambientLight}. Defaults to false.
     *
     * @type {boolean}
     */
    ambientBake: boolean;
    /**
     * If {@link Scene#ambientBake} is true, this specifies the brightness of ambient occlusion.
     * Typical range is -1 to 1. Defaults to 0, representing no change to brightness.
     *
     * @type {number}
     */
    ambientBakeOcclusionBrightness: number;
    /**
     * If {@link Scene#ambientBake} is true, this specifies the contrast of ambient occlusion.
     * Typical range is -1 to 1. Defaults to 0, representing no change to contrast.
     *
     * @type {number}
     */
    ambientBakeOcclusionContrast: number;
    /**
     * The color of the scene's ambient light. Defaults to black (0, 0, 0).
     *
     * @type {Color}
     */
    ambientLight: Color;
    /**
     * The luminosity of the scene's ambient light in lux (lm/m^2). Used if physicalUnits is true. Defaults to 0.
     *
     * @type {number}
     */
    ambientLuminance: number;
    /**
     * The exposure value tweaks the overall brightness of the scene. Ignored if physicalUnits is true. Defaults to 1.
     *
     * @type {number}
     */
    exposure: number;
    /**
     * The color of the fog (if enabled). Defaults to black (0, 0, 0).
     *
     * @type {Color}
     */
    fogColor: Color;
    /**
     * The density of the fog (if enabled). This property is only valid if the fog property is set
     * to {@link FOG_EXP} or {@link FOG_EXP2}. Defaults to 0.
     *
     * @type {number}
     */
    fogDensity: number;
    /**
     * The distance from the viewpoint where linear fog reaches its maximum. This property is only
     * valid if the fog property is set to {@link FOG_LINEAR}. Defaults to 1000.
     *
     * @type {number}
     */
    fogEnd: number;
    /**
     * The distance from the viewpoint where linear fog begins. This property is only valid if the
     * fog property is set to {@link FOG_LINEAR}. Defaults to 1.
     *
     * @type {number}
     */
    fogStart: number;
    /**
     * The lightmap resolution multiplier. Defaults to 1.
     *
     * @type {number}
     */
    lightmapSizeMultiplier: number;
    /**
     * The maximum lightmap resolution. Defaults to 2048.
     *
     * @type {number}
     */
    lightmapMaxResolution: number;
    /**
     * The lightmap baking mode. Can be:
     *
     * - {@link BAKE_COLOR}: single color lightmap
     * - {@link BAKE_COLORDIR}: single color lightmap + dominant light direction (used for bump or
     * specular). Only lights with bakeDir=true will be used for generating the dominant light
     * direction.
     *
     * Defaults to {@link BAKE_COLORDIR}.
     *
     * @type {number}
     */
    lightmapMode: number;
    /**
     * Enables bilateral filter on runtime baked color lightmaps, which removes the noise and
     * banding while preserving the edges. Defaults to false. Note that the filtering takes place
     * in the image space of the lightmap, and it does not filter across lightmap UV space seams,
     * often making the seams more visible. It's important to balance the strength of the filter
     * with number of samples used for lightmap baking to limit the visible artifacts.
     *
     * @type {boolean}
     */
    lightmapFilterEnabled: boolean;
    /**
     * Enables HDR lightmaps. This can result in smoother lightmaps especially when many samples
     * are used. Defaults to false.
     *
     * @type {boolean}
     */
    lightmapHDR: boolean;
    /**
     * The root entity of the scene, which is usually the only child to the {@link Application}
     * root entity.
     *
     * @type {import('../framework/entity.js').Entity}
     */
    root: Entity;
    /**
     * Use physically based units for cameras and lights. When used, the exposure value is ignored.
     *
     * @type {boolean}
     */
    physicalUnits: boolean;
    /**
     * Environment lighting atlas
     *
     * @type {import('../platform/graphics/texture.js').Texture|null}
     * @private
     */
    private _envAtlas;
    /**
     * The skybox cubemap as set by user (gets used when skyboxMip === 0)
     *
     * @type {import('../platform/graphics/texture.js').Texture|null}
     * @private
     */
    private _skyboxCubeMap;
    device: GraphicsDevice;
    _gravity: Vec3;
    /**
     * @type {import('./composition/layer-composition.js').LayerComposition}
     * @private
     */
    private _layers;
    _fog: string;
    _gammaCorrection: number;
    _toneMapping: number;
    /**
     * Array of 6 prefiltered lighting data cubemaps.
     *
     * @type {import('../platform/graphics/texture.js').Texture[]}
     * @private
     */
    private _prefilteredCubemaps;
    _internalEnvAtlas: any;
    _skyboxIntensity: number;
    _skyboxLuminance: number;
    _skyboxMip: number;
    _skyboxRotationShaderInclude: boolean;
    _skyboxRotation: Quat;
    _skyboxRotationMat3: Mat3;
    _skyboxRotationMat4: Mat4;
    _ambientBakeNumSamples: number;
    _ambientBakeSpherePart: number;
    _lightmapFilterRange: number;
    _lightmapFilterSmoothness: number;
    _clusteredLightingEnabled: boolean;
    _lightingParams: LightingParams;
    updateShaders: boolean;
    _sky: Sky;
    _stats: {
        meshInstances: number;
        lights: number;
        dynamicLights: number;
        bakedLights: number;
        updateShadersTime: number;
    };
    _shaderVersion: number;
    immediate: Immediate;
    /**
     * Returns the default layer used by the immediate drawing functions.
     *
     * @type {import('./layer.js').Layer}
     * @private
     */
    private get defaultDrawLayer();
    /**
     * If {@link Scene#ambientBake} is true, this specifies the number of samples used to bake the
     * ambient light into the lightmap. Defaults to 1. Maximum value is 255.
     *
     * @type {number}
     */
    set ambientBakeNumSamples(arg: number);
    get ambientBakeNumSamples(): number;
    /**
     * If {@link Scene#ambientBake} is true, this specifies a part of the sphere which represents
     * the source of ambient light. The valid range is 0..1, representing a part of the sphere from
     * top to the bottom. A value of 0.5 represents the upper hemisphere. A value of 1 represents a
     * full sphere. Defaults to 0.4, which is a smaller upper hemisphere as this requires fewer
     * samples to bake.
     *
     * @type {number}
     */
    set ambientBakeSpherePart(arg: number);
    get ambientBakeSpherePart(): number;
    /**
     * True if the clustered lighting is enabled. Set to false before the first frame is rendered
     * to use non-clustered lighting. Defaults to true.
     *
     * @type {boolean}
     */
    set clusteredLightingEnabled(arg: boolean);
    get clusteredLightingEnabled(): boolean;
    /**
     * The environment lighting atlas.
     *
     * @type {import('../platform/graphics/texture.js').Texture}
     */
    set envAtlas(arg: Texture);
    get envAtlas(): Texture;
    /**
     * The type of fog used by the scene. Can be:
     *
     * - {@link FOG_NONE}
     * - {@link FOG_LINEAR}
     * - {@link FOG_EXP}
     * - {@link FOG_EXP2}
     *
     * Defaults to {@link FOG_NONE}.
     *
     * @type {string}
     */
    set fog(arg: string);
    get fog(): string;
    /**
     * The gamma correction to apply when rendering the scene. Can be:
     *
     * - {@link GAMMA_NONE}
     * - {@link GAMMA_SRGB}
     *
     * Defaults to {@link GAMMA_SRGB}.
     *
     * @type {number}
     */
    set gammaCorrection(arg: number);
    get gammaCorrection(): number;
    /**
     * A {@link LayerComposition} that defines rendering order of this scene.
     *
     * @type {import('./composition/layer-composition.js').LayerComposition}
     */
    set layers(arg: LayerComposition);
    get layers(): LayerComposition;
    get sky(): Sky;
    /**
     * A {@link LightingParams} that defines lighting parameters.
     *
     * @type {LightingParams}
     */
    get lighting(): LightingParams;
    /**
     * A range parameter of the bilateral filter. It's used when {@link Scene#lightmapFilterEnabled}
     * is enabled. Larger value applies more widespread blur. This needs to be a positive non-zero
     * value. Defaults to 10.
     *
     * @type {number}
     */
    set lightmapFilterRange(arg: number);
    get lightmapFilterRange(): number;
    /**
     * A spatial parameter of the bilateral filter. It's used when {@link Scene#lightmapFilterEnabled}
     * is enabled. Larger value blurs less similar colors. This needs to be a positive non-zero
     * value. Defaults to 0.2.
     *
     * @type {number}
     */
    set lightmapFilterSmoothness(arg: number);
    get lightmapFilterSmoothness(): number;
    /**
     * Set of 6 prefiltered cubemaps.
     *
     * @type {import('../platform/graphics/texture.js').Texture[]}
     */
    set prefilteredCubemaps(arg: Texture[]);
    get prefilteredCubemaps(): Texture[];
    /**
     * The base cubemap texture used as the scene's skybox, if mip level is 0. Defaults to null.
     *
     * @type {import('../platform/graphics/texture.js').Texture}
     */
    set skybox(arg: Texture);
    get skybox(): Texture;
    /**
     * Multiplier for skybox intensity. Defaults to 1. Unused if physical units are used.
     *
     * @type {number}
     */
    set skyboxIntensity(arg: number);
    get skyboxIntensity(): number;
    /**
     * Luminance (in lm/m^2) of skybox. Defaults to 0. Only used if physical units are used.
     *
     * @type {number}
     */
    set skyboxLuminance(arg: number);
    get skyboxLuminance(): number;
    /**
     * The mip level of the skybox to be displayed. Only valid for prefiltered cubemap skyboxes.
     * Defaults to 0 (base level).
     *
     * @type {number}
     */
    set skyboxMip(arg: number);
    get skyboxMip(): number;
    /**
     * The rotation of the skybox to be displayed. Defaults to {@link Quat.IDENTITY}.
     *
     * @type {Quat}
     */
    set skyboxRotation(arg: Quat);
    get skyboxRotation(): Quat;
    /**
     * The tonemapping transform to apply when writing fragments to the frame buffer. Can be:
     *
     * - {@link TONEMAP_LINEAR}
     * - {@link TONEMAP_FILMIC}
     * - {@link TONEMAP_HEJL}
     * - {@link TONEMAP_ACES}
     * - {@link TONEMAP_ACES2}
     *
     * Defaults to {@link TONEMAP_LINEAR}.
     *
     * @type {number}
     */
    set toneMapping(arg: number);
    get toneMapping(): number;
    destroy(): void;
    drawLine(start: any, end: any, color?: Color, depthTest?: boolean, layer?: Layer): void;
    drawLines(positions: any, colors: any, depthTest?: boolean, layer?: Layer): void;
    drawLineArrays(positions: any, colors: any, depthTest?: boolean, layer?: Layer): void;
    applySettings(settings: any): void;
    _getSkyboxTex(): Texture;
    _updateSkyMesh(): void;
    _resetSkyMesh(): void;
    /**
     * Sets the cubemap for the scene skybox.
     *
     * @param {import('../platform/graphics/texture.js').Texture[]} [cubemaps] - An array of
     * cubemaps corresponding to the skybox at different mip levels. If undefined, scene will
     * remove skybox. Cubemap array should be of size 7, with the first element (index 0)
     * corresponding to the base cubemap (mip level 0) with original resolution. Each remaining
     * element (index 1-6) corresponds to a fixed prefiltered resolution (128x128, 64x64, 32x32,
     * 16x16, 8x8, 4x4).
     */
    setSkybox(cubemaps?: Texture[]): void;
    /**
     * The lightmap pixel format.
     *
     * @type {number}
     */
    get lightmapPixelFormat(): number;
}

/**
 * - The options.
 */
type SplatMaterialOptions = {
    /**
     * - Adds #define DEBUG_RENDER for shader.
     */
    debugRender?: boolean;
    /**
     * - Custom vertex shader, see SPLAT MANY example.
     */
    vertex?: string;
    /**
     * - Custom fragment shader, see SPLAT MANY example.
     */
    fragment?: string;
    /**
     * - Opacity dithering enum.
     */
    dither?: string;
};

/** @ignore */
declare class GSplat {
    /**
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The graphics device.
     * @param {number} numSplats - Number of splats.
     * @param {import('../../core/shape/bounding-box.js').BoundingBox} aabb - The bounding box.
     */
    constructor(device: GraphicsDevice, numSplats: number, aabb: BoundingBox);
    device: GraphicsDevice;
    numSplats: number;
    /** @type {VertexFormat} */
    vertexFormat: VertexFormat;
    /**
     * True if half format should be used, false is float format should be used or undefined if none
     * are available.
     *
     * @type {boolean|undefined}
     */
    halfFormat: boolean | undefined;
    /** @type {Texture} */
    colorTexture: Texture;
    /** @type {Texture} */
    transformATexture: Texture;
    /** @type {Texture} */
    transformBTexture: Texture;
    /** @type {Texture} */
    transformCTexture: Texture;
    /** @type {Float32Array} */
    centers: Float32Array;
    /** @type {import('../../core/shape/bounding-box.js').BoundingBox} */
    aabb: BoundingBox;
    destroy(): void;
    /**
     * @param {import('../materials/material.js').Material} material - The material to set up for
     * the splat rendering.
     */
    setupMaterial(material: Material): void;
    /**
     * Evaluates the texture size needed to store a given number of elements.
     * The function calculates a width and height that is close to a square
     * that can contain 'count' elements.
     *
     * @param {number} count - The number of elements to store in the texture.
     * @returns {Vec2} An instance of Vec2 representing the width and height of the texture.
     */
    evalTextureSize(count: number): Vec2;
    /**
     * Creates a new texture with the specified parameters.
     *
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The graphics device to use for the texture creation.
     * @param {string} name - The name of the texture to be created.
     * @param {number} format - The pixel format of the texture.
     * @param {Vec2} size - The size of the texture in a Vec2 object, containing width (x) and height (y).
     * @returns {Texture} The created texture instance.
     */
    createTexture(device: GraphicsDevice, name: string, format: number, size: Vec2): Texture;
    /**
     * Gets the most suitable texture format based on device capabilities.
     *
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The graphics device.
     * @param {boolean} preferHighPrecision - True to prefer high precision when available.
     * @returns {boolean|undefined} True if half format should be used, false is float format should
     * be used or undefined if none are available.
     */
    getTextureFormat(device: GraphicsDevice, preferHighPrecision: boolean): boolean | undefined;
    /**
     * Updates pixel data of this.colorTexture based on the supplied color components and opacity.
     * Assumes that the texture is using an RGBA format where RGB are color components influenced
     * by SH spherical harmonics and A is opacity after a sigmoid transformation.
     *
     * @param {Float32Array} c0 - The first color component SH coefficients.
     * @param {Float32Array} c1 - The second color component SH coefficients.
     * @param {Float32Array} c2 - The third color component SH coefficients.
     * @param {Float32Array} opacity - The opacity values to be transformed using a sigmoid function.
     */
    updateColorData(c0: Float32Array, c1: Float32Array, c2: Float32Array, opacity: Float32Array): void;
    /**
     * @param {Float32Array} x - The array containing the 'x' component of the center points.
     * @param {Float32Array} y - The array containing the 'y' component of the center points.
     * @param {Float32Array} z - The array containing the 'z' component of the center points.
     * @param {Float32Array} rot0 - The array containing the 'x' component of quaternion rotations.
     * @param {Float32Array} rot1 - The array containing the 'y' component of quaternion rotations.
     * @param {Float32Array} rot2 - The array containing the 'z' component of quaternion rotations.
     * @param {Float32Array} rot3 - The array containing the 'w' component of quaternion rotations.
     * @param {Float32Array} scale0 - The first scale component associated with the x-dimension.
     * @param {Float32Array} scale1 - The second scale component associated with the y-dimension.
     * @param {Float32Array} scale2 - The third scale component associated with the z-dimension.
     */
    updateTransformData(x: Float32Array, y: Float32Array, z: Float32Array, rot0: Float32Array, rot1: Float32Array, rot2: Float32Array, rot3: Float32Array, scale0: Float32Array, scale1: Float32Array, scale2: Float32Array): void;
    /**
     * Convert quaternion rotation stored in Vec3 to a rotation matrix.
     *
     * @param {Vec3} R - Rotation stored in Vec3.
     * @param {Mat3} mat - The output rotation matrix.
     */
    quatToMat3(R: Vec3, mat: Mat3): void;
    /**
     * Evaluate the covariance values based on the rotation and scale.
     *
     * @param {Mat3} rot - The rotation matrix.
     * @param {Vec3} scale - The scale.
     * @param {Vec3} covA - The first covariance vector.
     * @param {Vec3} covB - The second covariance vector.
     */
    computeCov3d(rot: Mat3, scale: Vec3, covA: Vec3, covB: Vec3): void;
}

declare class GSplatSorter extends EventHandler {
    worker: Worker;
    vertexBuffer: any;
    destroy(): void;
    init(vertexBuffer: any, centers: any, intIndices: any): void;
    setCamera(pos: any, dir: any): void;
}

/** @ignore */
declare class GSplatInstance {
    /**
     * @param {import('./gsplat.js').GSplat} splat - The splat instance.
     * @param {import('./gsplat-material.js').SplatMaterialOptions} options - The options.
     */
    constructor(splat: GSplat, options: SplatMaterialOptions);
    /** @type {import('./gsplat.js').GSplat} */
    splat: GSplat;
    /** @type {Mesh} */
    mesh: Mesh;
    /** @type {MeshInstance} */
    meshInstance: MeshInstance;
    /** @type {import('../materials/material.js').Material} */
    material: Material;
    /** @type {VertexBuffer} */
    vb: VertexBuffer;
    options: {};
    /** @type {GSplatSorter | null} */
    sorter: GSplatSorter | null;
    lastCameraPosition: Vec3;
    lastCameraDirection: Vec3;
    /**
     * List of cameras this instance is visible for. Updated every frame by the renderer.
     *
     * @type {import('../camera.js').Camera[]}
     * @ignore
     */
    cameras: Camera[];
    centers: Float32Array;
    destroy(): void;
    clone(): GSplatInstance;
    createMaterial(options: any): void;
    updateViewport(): void;
    /**
     * Sorts the GS vertices based on the given camera.
     * @param {import('../graph-node.js').GraphNode} cameraNode - The camera node used for sorting.
     */
    sort(cameraNode: GraphNode): void;
    update(): void;
}

/**
 * Callback used by {@link Layer} to calculate the "sort distance" for a {@link MeshInstance},
 * which determines its place in the render order.
 *
 * @callback CalculateSortDistanceCallback
 * @param {MeshInstance} meshInstance - The mesh instance.
 * @param {import('../core/math/vec3.js').Vec3} cameraPosition - The position of the camera.
 * @param {import('../core/math/vec3.js').Vec3} cameraForward - The forward vector of the camera.
 */
/**
 * An instance of a {@link Mesh}. A single mesh can be referenced by many mesh instances that can
 * have different transforms and materials.
 *
 * @category Graphics
 */
declare class MeshInstance {
    static lightmapParamNames: string[];
    static _prepareRenderStyleForArray(meshInstances: any, renderStyle: any): void;
    /**
     * Create a new MeshInstance instance.
     *
     * @param {import('./mesh.js').Mesh} mesh - The graphics mesh to instance.
     * @param {import('./materials/material.js').Material} material - The material to use for this
     * mesh instance.
     * @param {GraphNode} [node] - The graph node defining the transform for this instance. This
     * parameter is optional when used with {@link RenderComponent} and will use the node the
     * component is attached to.
     * @example
     * // Create a mesh instance pointing to a 1x1x1 'cube' mesh
     * const mesh = pc.createBox(graphicsDevice);
     * const material = new pc.StandardMaterial();
     *
     * const meshInstance = new pc.MeshInstance(mesh, material);
     *
     * const entity = new pc.Entity();
     * entity.addComponent('render', {
     *     meshInstances: [meshInstance]
     * });
     *
     * // Add the entity to the scene hierarchy
     * this.app.scene.root.addChild(entity);
     */
    constructor(mesh: Mesh, material: Material, node?: GraphNode);
    /**
     * Enable rendering for this mesh instance. Use visible property to enable/disable
     * rendering without overhead of removing from scene. But note that the mesh instance is
     * still in the hierarchy and still in the draw call list.
     *
     * @type {boolean}
     */
    visible: boolean;
    /**
     * Enable shadow casting for this mesh instance. Use this property to enable/disable
     * shadow casting without overhead of removing from scene. Note that this property does not
     * add the mesh instance to appropriate list of shadow casters on a {@link Layer}, but
     * allows mesh to be skipped from shadow casting while it is in the list already. Defaults to
     * false.
     *
     * @type {boolean}
     */
    castShadow: boolean;
    /**
     * True if the material of the mesh instance is transparent. Optimization to avoid accessing the
     * material. Updated by the material instance itself.
     *
     * @ignore
     */
    transparent: boolean;
    /**
     * @type {import('./materials/material.js').Material|null}
     * @private
     */
    private _material;
    /**
     * An array of shader cache entries, indexed by the shader pass constant (SHADER_FORWARD..). The
     * value stores all shaders and bind groups for the shader pass for various light combinations.
     *
     * @type {Array<ShaderCacheEntry|null>}
     * @private
     */
    private _shaderCache;
    /** @ignore */
    id: number;
    /**
     * True if the mesh instance is pickable by the {@link Picker}. Defaults to true.
     *
     * @type {boolean}
     * @ignore
     */
    pick: boolean;
    _key: number[];
    /**
     * The graph node defining the transform for this instance.
     *
     * @type {GraphNode}
     */
    node: GraphNode;
    _mesh: Mesh;
    /**
     * The material used by this mesh instance.
     *
     * @type {import('./materials/material.js').Material}
     */
    set material(arg: Material);
    get material(): Material;
    _shaderDefs: number;
    set layer(arg: any);
    get layer(): any;
    /** @private */
    private _renderStyle;
    _receiveShadow: boolean;
    _screenSpace: boolean;
    /**
     * Controls whether the mesh instance can be culled by frustum culling
     * ({@link CameraComponent#frustumCulling}). Defaults to true.
     *
     * @type {boolean}
     */
    cull: boolean;
    _updateAabb: boolean;
    _updateAabbFunc: any;
    _calculateSortDistance: any;
    /**
     * @type {import('./skin-instance.js').SkinInstance|null}
     * @private
     */
    private _skinInstance;
    /**
     * @type {import('./morph-instance.js').MorphInstance|null}
     * @private
     */
    private _morphInstance;
    /**
     * @type {import('./gsplat/gsplat-instance.js').GSplatInstance|null}
     * @ignore
     */
    gsplatInstance: GSplatInstance | null;
    instancingData: InstancingData;
    /**
     * @type {BoundingBox|null}
     * @private
     */
    private _customAabb;
    /**
     * The world space axis-aligned bounding box for this mesh instance.
     *
     * @type {BoundingBox}
     */
    set aabb(arg: any);
    get aabb(): any;
    _aabbVer: number;
    _aabbMeshVer: number;
    /**
     * Use this value to affect rendering order of mesh instances. Only used when mesh
     * instances are added to a {@link Layer} with {@link Layer#opaqueSortMode} or
     * {@link Layer#transparentSortMode} (depending on the material) set to
     * {@link SORTMODE_MANUAL}.
     *
     * @type {number}
     */
    drawOrder: number;
    /**
     * Read this value in {@link Layer#onPostCull} to determine if the object is actually going
     * to be rendered.
     *
     * @type {boolean}
     */
    visibleThisFrame: boolean;
    isVisibleFunc: any;
    parameters: {};
    stencilFront: any;
    stencilBack: any;
    flipFacesFactor: number;
    /**
     * The render style of the mesh instance. Can be:
     *
     * - {@link RENDERSTYLE_SOLID}
     * - {@link RENDERSTYLE_WIREFRAME}
     * - {@link RENDERSTYLE_POINTS}
     *
     * Defaults to {@link RENDERSTYLE_SOLID}.
     *
     * @type {number}
     */
    set renderStyle(arg: number);
    get renderStyle(): number;
    /**
     * The graphics mesh being instanced.
     *
     * @type {import('./mesh.js').Mesh}
     */
    set mesh(arg: Mesh);
    get mesh(): Mesh;
    _aabb: any;
    /**
     * Clear the internal shader cache.
     *
     * @ignore
     */
    clearShaders(): void;
    /**
     * Returns the shader instance for the specified shader pass and light hash that is compatible
     * with this mesh instance.
     *
     * @param {number} shaderPass - The shader pass index.
     * @param {number} lightHash - The hash value of the lights that are affecting this mesh instance.
     * @param {import('./scene.js').Scene} scene - The scene.
     * @param {import('../platform/graphics/uniform-buffer-format.js').UniformBufferFormat} [viewUniformFormat] - The
     * format of the view uniform buffer.
     * @param {import('../platform/graphics/bind-group-format.js').BindGroupFormat} [viewBindGroupFormat] - The
     * format of the view bind group.
     * @param {any} [sortedLights] - Array of arrays of lights.
     * @returns {ShaderInstance} - the shader instance.
     * @ignore
     */
    getShaderInstance(shaderPass: number, lightHash: number, scene: Scene, viewUniformFormat?: UniformBufferFormat, viewBindGroupFormat?: BindGroupFormat, sortedLights?: any): ShaderInstance;
    _layer: any;
    _updateShaderDefs(shaderDefs: any): void;
    /**
     * In some circumstances mesh instances are sorted by a distance calculation to determine their
     * rendering order. Set this callback to override the default distance calculation, which gives
     * the dot product of the camera forward vector and the vector between the camera position and
     * the center of the mesh instance's axis-aligned bounding box. This option can be particularly
     * useful for rendering transparent meshes in a better order than default.
     *
     * @type {CalculateSortDistanceCallback}
     */
    set calculateSortDistance(arg: any);
    get calculateSortDistance(): any;
    set receiveShadow(arg: boolean);
    get receiveShadow(): boolean;
    /**
     * The skin instance managing skinning of this mesh instance, or null if skinning is not used.
     *
     * @type {import('./skin-instance.js').SkinInstance}
     */
    set skinInstance(arg: SkinInstance);
    get skinInstance(): SkinInstance;
    /**
     * The morph instance managing morphing of this mesh instance, or null if morphing is not used.
     *
     * @type {import('./morph-instance.js').MorphInstance}
     */
    set morphInstance(arg: MorphInstance);
    get morphInstance(): MorphInstance;
    set screenSpace(arg: boolean);
    get screenSpace(): boolean;
    set key(arg: number);
    get key(): number;
    /**
     * Mask controlling which {@link LightComponent}s light this mesh instance, which
     * {@link CameraComponent} sees it and in which {@link Layer} it is rendered. Defaults to 1.
     *
     * @type {number}
     */
    set mask(arg: number);
    get mask(): number;
    /**
     * Number of instances when using hardware instancing to render the mesh.
     *
     * @type {number}
     */
    set instancingCount(arg: number);
    get instancingCount(): number;
    destroy(): void;
    _isVisible(camera: any): any;
    updateKey(): void;
    /**
     * Sets up {@link MeshInstance} to be rendered using Hardware Instancing.
     *
     * @param {import('../platform/graphics/vertex-buffer.js').VertexBuffer|null} vertexBuffer -
     * Vertex buffer to hold per-instance vertex data (usually world matrices). Pass null to turn
     * off hardware instancing.
     * @param {boolean} cull - Whether to perform frustum culling on this instance. If true, the whole
     * instance will be culled by the  camera frustum. This often involves setting
     * {@link RenderComponent#customAabb} containing all instances. Defaults to false, which means
     * the whole instance is always rendered.
     */
    setInstancing(vertexBuffer: VertexBuffer | null, cull?: boolean): void;
    ensureMaterial(device: any): void;
    clearParameters(): void;
    getParameters(): {};
    /**
     * Retrieves the specified shader parameter from a mesh instance.
     *
     * @param {string} name - The name of the parameter to query.
     * @returns {object} The named parameter.
     */
    getParameter(name: string): object;
    /**
     * Sets a shader parameter on a mesh instance. Note that this parameter will take precedence
     * over parameter of the same name if set on Material this mesh instance uses for rendering.
     *
     * @param {string} name - The name of the parameter to set.
     * @param {number|number[]|import('../platform/graphics/texture.js').Texture} data - The value
     * for the specified parameter.
     * @param {number} [passFlags] - Mask describing which passes the material should be included
     * in.
     */
    setParameter(name: string, data: number | number[] | Texture, passFlags?: number): void;
    setRealtimeLightmap(name: any, texture: any): void;
    /**
     * Deletes a shader parameter on a mesh instance.
     *
     * @param {string} name - The name of the parameter to delete.
     */
    deleteParameter(name: string): void;
    setParameters(device: any, passFlag: any): void;
    setLightmapped(value: any): void;
    setCustomAabb(aabb: any): void;
    _setupSkinUpdate(): void;
}

/**
 * Internal data structure used to store data used by hardware instancing.
 *
 * @ignore
 */
declare class InstancingData {
    /**
     * @param {number} numObjects - The number of objects instanced.
     */
    constructor(numObjects: number);
    /** @type {import('../platform/graphics/vertex-buffer.js').VertexBuffer|null} */
    vertexBuffer: VertexBuffer | null;
    count: number;
}
/**
 * Internal helper class for storing the shader and related mesh bind group in the shader cache.
 *
 * @ignore
 */
declare class ShaderInstance {
    /**
     * A shader.
     *
     * @type {import('../platform/graphics/shader.js').Shader|undefined}
     */
    shader: Shader | undefined;
    /**
     * A bind group storing mesh uniforms for the shader.
     *
     * @type {BindGroup|null}
     */
    bindGroup: BindGroup | null;
    /**
     * Returns the mesh bind group for the shader.
     *
     * @param {import('../platform/graphics/graphics-device.js').GraphicsDevice} device - The
     * graphics device.
     * @returns {BindGroup} - The mesh bind group.
     */
    getBindGroup(device: GraphicsDevice): BindGroup;
    destroy(): void;
}

/**
 * Holds mesh batching settings and a unique id. Created via {@link BatchManager#addGroup}.
 *
 * @category Graphics
 */
declare class BatchGroup {
    static MODEL: string;
    static ELEMENT: string;
    static SPRITE: string;
    static RENDER: string;
    /**
     * Create a new BatchGroup instance.
     *
     * @param {number} id - Unique id. Can be assigned to model, render and element components.
     * @param {string} name - The name of the group.
     * @param {boolean} dynamic - Whether objects within this batch group should support
     * transforming at runtime.
     * @param {number} maxAabbSize - Maximum size of any dimension of a bounding box around batched
     * objects. {@link BatchManager#prepare} will split objects into local groups based on this
     * size.
     * @param {number[]} [layers] - Layer ID array. Default is [{@link LAYERID_WORLD}]. The whole
     * batch group will belong to these layers. Layers of source models will be ignored.
     */
    constructor(id: number, name: string, dynamic: boolean, maxAabbSize: number, layers?: number[]);
    /** @private */
    private _ui;
    /** @private */
    private _sprite;
    /** @private */
    private _obj;
    /**
     * Unique id. Can be assigned to model, render and element components.
     *
     * @type {number}
     */
    id: number;
    /**
     * Name of the group.
     *
     * @type {string}
     */
    name: string;
    /**
     * Whether objects within this batch group should support transforming at runtime.
     *
     * @type {boolean}
     */
    dynamic: boolean;
    /**
     * Maximum size of any dimension of a bounding box around batched objects.
     * {@link BatchManager#prepare} will split objects into local groups based on this size.
     *
     * @type {number}
     */
    maxAabbSize: number;
    /**
     * Layer ID array. Default is [{@link LAYERID_WORLD}]. The whole batch group will belong to
     * these layers. Layers of source models will be ignored.
     *
     * @type {number[]}
     */
    layers: number[];
}

/**
 * Holds information about batched mesh instances. Created in {@link BatchManager#create}.
 *
 * @category Graphics
 */
declare class Batch {
    /**
     * Create a new Batch instance.
     *
     * @param {import('../mesh-instance.js').MeshInstance[]} meshInstances - The mesh instances to
     * be batched.
     * @param {boolean} dynamic - Whether this batch is dynamic (supports transforming mesh
     * instances at runtime).
     * @param {number} batchGroupId - Link this batch to a specific batch group. This is done
     * automatically with default batches.
     */
    constructor(meshInstances: MeshInstance[], dynamic: boolean, batchGroupId: number);
    /** @private */
    private _aabb;
    /**
     * An array of original mesh instances, from which this batch was generated.
     *
     * @type {import('../mesh-instance.js').MeshInstance[]}
     */
    origMeshInstances: MeshInstance[];
    /**
     * A single combined mesh instance, the result of batching.
     *
     * @type {import('../mesh-instance.js').MeshInstance}
     */
    meshInstance: MeshInstance;
    /**
     * Whether this batch is dynamic (supports transforming mesh instances at runtime).
     *
     * @type {boolean}
     */
    dynamic: boolean;
    /**
     * Link this batch to a specific batch group. This is done automatically with default batches.
     *
     * @type {number}
     */
    batchGroupId: number;
    destroy(scene: any, layers: any): void;
    addToLayers(scene: any, layers: any): void;
    removeFromLayers(scene: any, layers: any): void;
    updateBoundingBox(): void;
}

/**
 * Glues many mesh instances into a single one for better performance.
 *
 * @category Graphics
 */
declare class BatchManager {
    /**
     * Create a new BatchManager instance.
     *
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The
     * graphics device used by the batch manager.
     * @param {import('../../framework/entity.js').Entity} root - The entity under which batched
     * models are added.
     * @param {import('../scene.js').Scene} scene - The scene that the batch manager affects.
     */
    constructor(device: GraphicsDevice, root: Entity, scene: Scene);
    device: GraphicsDevice;
    rootNode: Entity;
    scene: Scene;
    _init: boolean;
    _batchGroups: {};
    _batchGroupCounter: number;
    _batchList: any[];
    _dirtyGroups: any[];
    _stats: {
        createTime: number;
        updateLastFrameTime: number;
    };
    destroy(): void;
    /**
     * Adds new global batch group.
     *
     * @param {string} name - Custom name.
     * @param {boolean} dynamic - Is this batch group dynamic? Will these objects move/rotate/scale
     * after being batched?
     * @param {number} maxAabbSize - Maximum size of any dimension of a bounding box around batched
     * objects.
     * {@link BatchManager#prepare} will split objects into local groups based on this size.
     * @param {number} [id] - Optional custom unique id for the group (will be generated
     * automatically otherwise).
     * @param {number[]} [layers] - Optional layer ID array. Default is [{@link LAYERID_WORLD}].
     * The whole batch group will belong to these layers. Layers of source models will be ignored.
     * @returns {BatchGroup} Group object.
     */
    addGroup(name: string, dynamic: boolean, maxAabbSize: number, id?: number, layers?: number[]): BatchGroup;
    /**
     * Remove global batch group by id. Note, this traverses the entire scene graph and clears the
     * batch group id from all components.
     *
     * @param {number} id - Batch Group ID.
     */
    removeGroup(id: number): void;
    /**
     * Mark a specific batch group as dirty. Dirty groups are re-batched before the next frame is
     * rendered. Note, re-batching a group is a potentially expensive operation.
     *
     * @param {number} id - Batch Group ID to mark as dirty.
     */
    markGroupDirty(id: number): void;
    /**
     * Retrieves a {@link BatchGroup} object with a corresponding name, if it exists, or null
     * otherwise.
     *
     * @param {string} name - Name.
     * @returns {BatchGroup|null} The batch group matching the name or null if not found.
     */
    getGroupByName(name: string): BatchGroup | null;
    /**
     * Return a list of all {@link Batch} objects that belong to the Batch Group supplied.
     *
     * @param {number} batchGroupId - The id of the batch group.
     * @returns {Batch[]} A list of batches that are used to render the batch group.
     * @private
     */
    private getBatches;
    _removeModelsFromBatchGroup(node: any, id: any): void;
    insert(type: any, groupId: any, node: any): void;
    remove(type: any, groupId: any, node: any): void;
    _extractRender(node: any, arr: any, group: any, groupMeshInstances: any): any;
    _extractModel(node: any, arr: any, group: any, groupMeshInstances: any): any;
    _extractElement(node: any, arr: any, group: any): void;
    _collectAndRemoveMeshInstances(groupMeshInstances: any, groupIds: any): void;
    /**
     * Destroys all batches and creates new based on scene models. Hides original models. Called by
     * engine automatically on app start, and if batchGroupIds on models are changed.
     *
     * @param {number[]} [groupIds] - Optional array of batch group IDs to update. Otherwise all
     * groups are updated.
     */
    generate(groupIds?: number[]): void;
    /**
     * Takes a list of mesh instances to be batched and sorts them into lists one for each draw
     * call. The input list will be split, if:
     *
     * - Mesh instances use different materials.
     * - Mesh instances have different parameters (e.g. lightmaps or static lights).
     * - Mesh instances have different shader defines (shadow receiving, being aligned to screen
     * space, etc).
     * - Too many vertices for a single batch (65535 is maximum).
     * - Too many instances for a single batch (hardware-dependent, expect 128 on low-end and 1024
     * on high-end).
     * - Bounding box of a batch is larger than maxAabbSize in any dimension.
     *
     * @param {MeshInstance[]} meshInstances - Input list of mesh instances
     * @param {boolean} dynamic - Are we preparing for a dynamic batch? Instance count will matter
     * then (otherwise not).
     * @param {number} maxAabbSize - Maximum size of any dimension of a bounding box around batched
     * objects.
     * @param {boolean} translucent - Are we batching UI elements or sprites
     * This is useful to keep a balance between the number of draw calls and the number of drawn
     * triangles, because smaller batches can be hidden when not visible in camera.
     * @returns {MeshInstance[][]} An array of arrays of mesh instances, each valid to pass to
     * {@link BatchManager#create}.
     */
    prepare(meshInstances: MeshInstance[], dynamic: boolean, maxAabbSize: number, translucent: boolean): MeshInstance[][];
    collectBatchedMeshData(meshInstances: any, dynamic: any): {
        streams: {};
        batchNumVerts: number;
        batchNumIndices: number;
        material: any;
    };
    /**
     * Takes a mesh instance list that has been prepared by {@link BatchManager#prepare}, and
     * returns a {@link Batch} object. This method assumes that all mesh instances provided can be
     * rendered in a single draw call.
     *
     * @param {MeshInstance[]} meshInstances - Input list of mesh instances.
     * @param {boolean} dynamic - Is it a static or dynamic batch? Will objects be transformed
     * after batching?
     * @param {number} [batchGroupId] - Link this batch to a specific batch group. This is done
     * automatically with default batches.
     * @returns {Batch} The resulting batch object.
     */
    create(meshInstances: MeshInstance[], dynamic: boolean, batchGroupId?: number): Batch;
    transformVS: string;
    skinTexVS: any;
    skinConstVS: any;
    vertexFormats: {};
    /**
     * Updates bounding boxes for all dynamic batches. Called automatically.
     *
     * @ignore
     */
    updateAll(): void;
    /**
     * Clones a batch. This method doesn't rebuild batch geometry, but only creates a new model and
     * batch objects, linked to different source mesh instances.
     *
     * @param {Batch} batch - A batch object.
     * @param {MeshInstance[]} clonedMeshInstances - New mesh instances.
     * @returns {Batch} New batch object.
     */
    clone(batch: Batch, clonedMeshInstances: MeshInstance[]): Batch;
    /**
     * Removes the batch model from all layers and destroys it.
     *
     * @param {Batch} batch - A batch object.
     * @private
     */
    private destroyBatch;
}

/**
 * Represents an audio listener - used internally.
 *
 * @ignore
 */
declare class Listener {
    /**
     * Create a new listener instance.
     *
     * @param {import('./manager.js').SoundManager} manager - The sound manager.
     */
    constructor(manager: SoundManager);
    /**
     * @type {import('./manager.js').SoundManager}
     * @private
     */
    private _manager;
    /**
     * @type {Vec3}
     * @private
     */
    private position;
    /**
     * @type {Vec3}
     * @private
     */
    private velocity;
    /**
     * @type {Mat4}
     * @private
     */
    private orientation;
    /**
     * Get the position of the listener.
     *
     * @returns {Vec3} The position of the listener.
     */
    getPosition(): Vec3;
    /**
     * Set the position of the listener.
     *
     * @param {Vec3} position - The new position of the listener.
     */
    setPosition(position: Vec3): void;
    /**
     * Get the velocity of the listener.
     *
     * @returns {Vec3} The velocity of the listener.
     * @deprecated
     */
    getVelocity(): Vec3;
    /**
     * Set the velocity of the listener.
     *
     * @param {Vec3} velocity - The new velocity of the listener.
     * @deprecated
     */
    setVelocity(velocity: Vec3): void;
    /**
     * Set the orientation matrix of the listener.
     *
     * @param {Mat4} orientation - The new orientation matrix of the listener.
     */
    setOrientation(orientation: Mat4): void;
    /**
     * Get the orientation matrix of the listener.
     *
     * @returns {Mat4} The orientation matrix of the listener.
     */
    getOrientation(): Mat4;
    /**
     * Get the listener.
     *
     * @type {AudioListener|null}
     */
    get listener(): AudioListener;
}

/**
 * The SoundManager is used to load and play audio. It also applies system-wide settings like
 * global volume, suspend and resume.
 *
 * @augments EventHandler
 * @category Sound
 */
declare class SoundManager extends EventHandler {
    /**
     * The underlying AudioContext, lazy loaded in the 'context' property.
     *
     * @type {AudioContext}
     * @private
     */
    private _context;
    AudioContext: any;
    _unlockHandlerFunc: any;
    _userSuspended: boolean;
    listener: Listener;
    _volume: number;
    /**
     * Global volume for the manager. All {@link SoundInstance}s will scale their volume with this
     * volume. Valid between [0, 1].
     *
     * @type {number}
     */
    set volume(arg: number);
    get volume(): number;
    get suspended(): boolean;
    /**
     * Get the Web Audio API context.
     *
     * @type {AudioContext}
     * @ignore
     */
    get context(): AudioContext;
    suspend(): void;
    resume(): void;
    destroy(): void;
    /**
     * Create a new {@link Channel} and begin playback of the sound.
     *
     * @param {import('./sound.js').Sound} sound - The Sound object to play.
     * @param {object} [options] - Optional options object.
     * @param {number} [options.volume] - The volume to playback at, between 0 and 1.
     * @param {boolean} [options.loop] - Whether to loop the sound when it reaches the end.
     * @returns {Channel} The channel playing the sound.
     * @private
     */
    private playSound;
    /**
     * Create a new {@link Channel3d} and begin playback of the sound at the position specified.
     *
     * @param {import('./sound.js').Sound} sound - The Sound object to play.
     * @param {import('../../core/math/vec3.js').Vec3} position - The position of the sound in 3D space.
     * @param {object} options - Optional options object.
     * @param {number} [options.volume] - The volume to playback at, between 0 and 1.
     * @param {boolean} [options.loop] - Whether to loop the sound when it reaches the end.
     * @returns {Channel3d} The 3D channel playing the sound.
     * @private
     */
    private playSound3d;
    _resume(): void;
    _suspend(): void;
    _unlockHandler(): void;
    _registerUnlockListeners(): void;
    _removeUnlockListeners(): void;
}

/**
 * Represents XR hit test source, which provides access to hit results of real world geometry from
 * AR session.
 *
 * ```javascript
 * // start a hit test from a viewer origin forward
 * app.xr.hitTest.start({
 *     spaceType: pc.XRSPACE_VIEWER,
 *     callback: function (err, hitTestSource) {
 *         if (err) return;
 *         // subscribe to hit test results
 *         hitTestSource.on('result', function (position, rotation, inputSource, hitTestResult) {
 *             // position and rotation of hit test result
 *         });
 *     }
 * });
 * ```
 * @augments EventHandler
 * @category XR
 */
declare class XrHitTestSource extends EventHandler {
    /**
     * Fired when {@link XrHitTestSource} is removed.
     *
     * @event
     * @example
     * hitTestSource.once('remove', () => {
     *     // hit test source has been removed
     * });
     */
    static EVENT_REMOVE: string;
    /**
     * Fired when the hit test source receives new results. It provides transform information that
     * tries to match real world geometry. Callback provides the {@link Vec3} position, the
     * {@link Quat} rotation, the {@link XrInputSource} (if it is a transient hit test source)
     * and the {@link XRHitTestResult} object that is created by WebXR API.
     *
     * @event
     * @example
     * hitTestSource.on('result', (position, rotation, inputSource, hitTestReult) => {
     *     target.setPosition(position);
     *     target.setRotation(rotation);
     * });
     */
    static EVENT_RESULT: string;
    /**
     * Create a new XrHitTestSource instance.
     *
     * @param {import('./xr-manager.js').XrManager} manager - WebXR Manager.
     * @param {*} xrHitTestSource - XRHitTestSource object that is created by WebXR API.
     * @param {boolean} transient - True if XRHitTestSource created for input source profile.
     * @param {null|import('./xr-input-source.js').XrInputSource} inputSource - Input Source for which hit test is created for, or null.
     * @hideconstructor
     */
    constructor(manager: XrManager, xrHitTestSource: any, transient: boolean, inputSource?: null | XrInputSource);
    /**
     * @type {import('./xr-manager.js').XrManager}
     * @private
     */
    private manager;
    /**
     * @type {XRHitTestSource}
     * @private
     */
    private _xrHitTestSource;
    /**
     * @type {boolean}
     * @private
     */
    private _transient;
    /**
     * @type {null|import('./xr-input-source.js').XrInputSource}
     * @private
     */
    private _inputSource;
    /**
     * Stop and remove hit test source.
     */
    remove(): void;
    /** @ignore */
    onStop(): void;
    /**
     * @param {*} frame - XRFrame from requestAnimationFrame callback.
     * @ignore
     */
    update(frame: any): void;
    /**
     * @param {XRTransientInputHitTestResult[]} results - Hit test results.
     * @param {null|import('./xr-input-source.js').XrInputSource} inputSource - Input source.
     * @private
     */
    private updateHitResults;
}

/**
 * Callback used by {@link XrHitTeststart } and {@link XrHitTeststartForInputSource }.
 */
export type XrHitTestStartCallback = (err: Error | null, hitTestSource: XrHitTestSource | null) => any;
/**
 * Callback used by {@link XrHitTest#start} and {@link XrHitTest#startForInputSource}.
 *
 * @callback XrHitTestStartCallback
 * @param {Error|null} err - The Error object if failed to create hit test source or null.
 * @param {XrHitTestSource|null} hitTestSource - Object that provides access to hit results against
 * real world geometry.
 */
/**
 * The Hit Test interface allows initiating hit testing against real-world geometry from various
 * sources: the view, input sources, or an arbitrary ray in space. Results reflect the underlying
 * AR system's understanding of the real world.
 *
 * @augments EventHandler
 * @category XR
 */
declare class XrHitTest extends EventHandler {
    /**
     * Fired when hit test becomes available.
     *
     * @event
     * @example
     * app.xr.hitTest.on('available', () => {
     *     console.log('Hit Testing is available');
     * });
     */
    static EVENT_AVAILABLE: string;
    /**
     * Fired when hit test becomes unavailable.
     *
     * @event
     * @example
     * app.xr.hitTest.on('unavailable', () => {
     *     console.log('Hit Testing is unavailable');
     * });
     */
    static EVENT_UNAVAILABLE: string;
    /**
     * Fired when new {@link XrHitTestSource} is added to the list. The handler is passed the
     * {@link XrHitTestSource} object that has been added.
     *
     * @event
     * @example
     * app.xr.hitTest.on('add', (hitTestSource) => {
     *     // new hit test source is added
     * });
     */
    static EVENT_ADD: string;
    /**
     * Fired when {@link XrHitTestSource} is removed to the list. The handler is passed the
     * {@link XrHitTestSource} object that has been removed.
     *
     * @event
     * @example
     * app.xr.hitTest.on('remove', (hitTestSource) => {
     *     // hit test source is removed
     * });
     */
    static EVENT_REMOVE: string;
    /**
     * Fired when hit test source receives new results. It provides transform information that
     * tries to match real world picked geometry. The handler is passed the {@link XrHitTestSource}
     * that produced the hit result, the {@link Vec3} position, the {@link Quat} rotation and the
     * {@link XrInputSource} (if it is a transient hit test source).
     *
     * @event
     * @example
     * app.xr.hitTest.on('result', (hitTestSource, position, rotation, inputSource) => {
     *     target.setPosition(position);
     *     target.setRotation(rotation);
     * });
     */
    static EVENT_RESULT: string;
    /**
     * Fired when failed create hit test source. The handler is passed the Error object.
     *
     * @event
     * @example
     * app.xr.hitTest.on('error', (err) => {
     *     console.error(err.message);
     * });
     */
    static EVENT_ERROR: string;
    /**
     * Create a new XrHitTest instance.
     *
     * @param {import('./xr-manager.js').XrManager} manager - WebXR Manager.
     * @hideconstructor
     */
    constructor(manager: XrManager);
    /**
     * @type {import('./xr-manager.js').XrManager}
     * @private
     */
    private manager;
    /**
     * @type {boolean}
     * @private
     */
    private _supported;
    /**
     * @type {boolean}
     * @private
     */
    private _available;
    /**
     * List of active {@link XrHitTestSource}.
     *
     * @type {XrHitTestSource[]}
     */
    sources: XrHitTestSource[];
    /** @private */
    private _onSessionStart;
    /** @private */
    private _onSessionEnd;
    /**
     * Attempts to start hit test with provided reference space.
     *
     * @param {object} [options] - Optional object for passing arguments.
     * @param {string} [options.spaceType] - Reference space type. Defaults to
     * {@link XRSPACE_VIEWER}. Can be one of the following:
     *
     * - {@link XRSPACE_VIEWER}: Viewer - hit test will be facing relative to viewers space.
     * - {@link XRSPACE_LOCAL}: Local - represents a tracking space with a native origin near the
     * viewer at the time of creation.
     * - {@link XRSPACE_LOCALFLOOR}: Local Floor - represents a tracking space with a native origin
     * at the floor in a safe position for the user to stand. The y axis equals 0 at floor level.
     * Floor level value might be estimated by the underlying platform.
     * - {@link XRSPACE_BOUNDEDFLOOR}: Bounded Floor - represents a tracking space with its native
     * origin at the floor, where the user is expected to move within a pre-established boundary.
     * - {@link XRSPACE_UNBOUNDED}: Unbounded - represents a tracking space where the user is
     * expected to move freely around their environment, potentially long distances from their
     * starting point.
     *
     * @param {string} [options.profile] - if hit test source meant to match input source instead
     * of reference space, then name of profile of the {@link XrInputSource} should be provided.
     * @param {string[]} [options.entityTypes] - Optional list of underlying entity types against
     * which hit tests will be performed. Defaults to [ {@link XRTRACKABLE_PLANE} ]. Can be any
     * combination of the following:
     *
     * - {@link XRTRACKABLE_POINT}: Point - indicates that the hit test results will be computed
     * based on the feature points detected by the underlying Augmented Reality system.
     * - {@link XRTRACKABLE_PLANE}: Plane - indicates that the hit test results will be computed
     * based on the planes detected by the underlying Augmented Reality system.
     * - {@link XRTRACKABLE_MESH}: Mesh - indicates that the hit test results will be computed
     * based on the meshes detected by the underlying Augmented Reality system.
     *
     * @param {import('../../core/shape/ray.js').Ray} [options.offsetRay] - Optional ray by which
     * hit test ray can be offset.
     * @param {XrHitTestStartCallback} [options.callback] - Optional callback function called once
     * hit test source is created or failed.
     * @example
     * // start hit testing from viewer position facing forwards
     * app.xr.hitTest.start({
     *     spaceType: pc.XRSPACE_VIEWER,
     *     callback: function (err, hitTestSource) {
     *         if (err) return;
     *         hitTestSource.on('result', function (position, rotation) {
     *             // position and rotation of hit test result
     *         });
     *     }
     * });
     * @example
     * // start hit testing using an arbitrary ray
     * const ray = new pc.Ray(new pc.Vec3(0, 0, 0), new pc.Vec3(0, -1, 0));
     * app.xr.hitTest.start({
     *     spaceType: pc.XRSPACE_LOCAL,
     *     offsetRay: ray,
     *     callback: function (err, hitTestSource) {
     *         // hit test source that will sample real world geometry straight down
     *         // from the position where AR session started
     *     }
     * });
     * @example
     * // start hit testing for touch screen taps
     * app.xr.hitTest.start({
     *     profile: 'generic-touchscreen',
     *     callback: function (err, hitTestSource) {
     *         if (err) return;
     *         hitTestSource.on('result', function (position, rotation, inputSource) {
     *             // position and rotation of hit test result
     *             // that will be created from touch on mobile devices
     *         });
     *     }
     * });
     */
    start(options?: {
        spaceType?: string;
        profile?: string;
        entityTypes?: string[];
        offsetRay?: Ray;
        callback?: XrHitTestStartCallback;
    }): void;
    /**
     * @param {XRHitTestSource} xrHitTestSource - Hit test source.
     * @param {boolean} transient - True if hit test source is created from transient input source.
     * @param {import('./xr-input-source.js').XrInputSource|null} inputSource - Input Source with which hit test source is associated with.
     * @param {Function} callback - Callback called once hit test source is created.
     * @private
     */
    private _onHitTestSource;
    /**
     * @param {*} frame - XRFrame from requestAnimationFrame callback.
     * @ignore
     */
    update(frame: any): void;
    /**
     * True if AR Hit Test is supported.
     *
     * @type {boolean}
     */
    get supported(): boolean;
    /**
     * True if Hit Test is available. This information is available only when the session has started.
     *
     * @type {boolean}
     */
    get available(): boolean;
}

/**
 * Represents finger with related joints and index.
 *
 * @category XR
 */
declare class XrFinger {
    /**
     * Create a new XrFinger instance.
     *
     * @param {number} index - Index of a finger.
     * @param {import('./xr-hand.js').XrHand} hand - Hand that finger relates to.
     * @hideconstructor
     */
    constructor(index: number, hand: XrHand);
    /**
     * @type {number}
     * @private
     */
    private _index;
    /**
     * @type {import('./xr-hand.js').XrHand}
     * @private
     */
    private _hand;
    /**
     * @type {import('./xr-joint.js').XrJoint[]}
     * @private
     */
    private _joints;
    /**
     * @type {import('./xr-joint.js').XrJoint|null}
     * @private
     */
    private _tip;
    /**
     * Index of a finger, numeration is: thumb, index, middle, ring, little.
     *
     * @type {number}
     */
    get index(): number;
    /**
     * Hand that finger relates to.
     *
     * @type {import('./xr-hand.js').XrHand}
     */
    get hand(): XrHand;
    /**
     * List of joints that relates to this finger, starting from joint closest to wrist all the way
     * to the tip of a finger.
     *
     * @type {import('./xr-joint.js').XrJoint[]}
     */
    get joints(): XrJoint[];
    /**
     * Tip of a finger, or null if not available.
     *
     * @type {import('./xr-joint.js').XrJoint|null}
     */
    get tip(): XrJoint;
}

/**
 * Represents the joint of a finger.
 *
 * @category XR
 */
declare class XrJoint {
    /**
     * Create an XrJoint instance.
     *
     * @param {number} index - Index of a joint within a finger.
     * @param {string} id - Id of a joint based on WebXR Hand Input Specs.
     * @param {import('./xr-hand.js').XrHand} hand - Hand that joint relates to.
     * @param {import('./xr-finger.js').XrFinger|null} finger - Finger that joint is related to.
     * Can be null in the case of the wrist joint.
     * @hideconstructor
     */
    constructor(index: number, id: string, hand: XrHand, finger?: XrFinger | null);
    /**
     * @type {number}
     * @private
     */
    private _index;
    /**
     * @type {string}
     * @private
     */
    private _id;
    /**
     * @type {import('./xr-hand.js').XrHand}
     * @private
     */
    private _hand;
    /**
     * @type {import('./xr-finger.js').XrFinger}
     * @private
     */
    private _finger;
    /**
     * @type {boolean}
     * @private
     */
    private _wrist;
    /**
     * @type {boolean}
     * @private
     */
    private _tip;
    /**
     * @type {number}
     * @private
     */
    private _radius;
    /**
     * @type {Mat4}
     * @private
     */
    private _localTransform;
    /**
     * @type {Mat4}
     * @private
     */
    private _worldTransform;
    /**
     * @type {Vec3}
     * @private
     */
    private _localPosition;
    /**
     * @type {Quat}
     * @private
     */
    private _localRotation;
    /**
     * @type {Vec3}
     * @private
     */
    private _position;
    /**
     * @type {Quat}
     * @private
     */
    private _rotation;
    /**
     * @type {boolean}
     * @private
     */
    private _dirtyLocal;
    /**
     * @param {*} pose - XRJointPose of this joint.
     * @ignore
     */
    update(pose: any): void;
    /** @private */
    private _updateTransforms;
    /**
     * Get the world space position of a joint.
     *
     * @returns {Vec3} The world space position of a joint.
     */
    getPosition(): Vec3;
    /**
     * Get the world space rotation of a joint.
     *
     * @returns {Quat} The world space rotation of a joint.
     */
    getRotation(): Quat;
    /**
     * Index of a joint within a finger, starting from 0 (root of a finger) all the way to tip of
     * the finger.
     *
     * @type {number}
     */
    get index(): number;
    /**
     * Hand that joint relates to.
     *
     * @type {import('./xr-hand.js').XrHand}
     */
    get hand(): XrHand;
    /**
     * Finger that joint relates to.
     *
     * @type {import('./xr-finger.js').XrFinger|null}
     */
    get finger(): XrFinger;
    /**
     * True if joint is a wrist.
     *
     * @type {boolean}
     */
    get wrist(): boolean;
    /**
     * True if joint is a tip of a finger.
     *
     * @type {boolean}
     */
    get tip(): boolean;
    /**
     * The radius of a joint, which is a distance from joint to the edge of a skin.
     *
     * @type {number}
     */
    get radius(): number;
}

/**
 * Represents a hand with fingers and joints.
 *
 * @augments EventHandler
 * @category XR
 */
declare class XrHand extends EventHandler {
    /**
     * Fired when tracking becomes available.
     *
     * @event
     * @example
     * hand.on('tracking', () => {
     *     console.log('Hand tracking is available');
     * });
     */
    static EVENT_TRACKING: string;
    /**
     * Fired when tracking is lost.
     *
     * @event
     * @example
     * hand.on('trackinglost', () => {
     *     console.log('Hand tracking is lost');
     * });
     */
    static EVENT_TRACKINGLOST: string;
    /**
     * Represents a hand with fingers and joints.
     *
     * @param {import('./xr-input-source.js').XrInputSource} inputSource - Input Source that hand
     * is related to.
     * @hideconstructor
     */
    constructor(inputSource: XrInputSource);
    /**
     * @type {import('./xr-manager.js').XrManager}
     * @private
     */
    private _manager;
    /**
     * @type {import('./xr-input-source.js').XrInputSource}
     * @private
     */
    private _inputSource;
    /**
     * @type {boolean}
     * @private
     */
    private _tracking;
    /**
     * @type {XrFinger[]}
     * @private
     */
    private _fingers;
    /**
     * @type {XrJoint[]}
     * @private
     */
    private _joints;
    /**
     * @type {Object<string, XrJoint>}
     * @private
     */
    private _jointsById;
    /**
     * @type {XrJoint[]}
     * @private
     */
    private _tips;
    /**
     * @type {XrJoint|null}
     * @private
     */
    private _wrist;
    /**
     * @param {*} frame - XRFrame from requestAnimationFrame callback.
     * @ignore
     */
    update(frame: any): void;
    /**
     * @param {number} index - Finger index.
     * @returns {boolean} True if finger is closed and false otherwise.
     * @private
     */
    private _fingerIsClosed;
    /**
     * Returns joint by its XRHand id.
     *
     * @param {string} id - Id of a joint based on specs ID's in XRHand: https://immersive-web.github.io/webxr-hand-input/#skeleton-joints-section.
     * @returns {XrJoint|null} Joint or null if not available.
     */
    getJointById(id: string): XrJoint | null;
    /**
     * List of fingers of a hand.
     *
     * @type {XrFinger[]}
     */
    get fingers(): XrFinger[];
    /**
     * List of joints of hand.
     *
     * @type {XrJoint[]}
     */
    get joints(): XrJoint[];
    /**
     * List of joints that are fingertips.
     *
     * @type {XrJoint[]}
     */
    get tips(): XrJoint[];
    /**
     * Wrist of a hand, or null if it is not available by WebXR underlying system.
     *
     * @type {XrJoint|null}
     */
    get wrist(): XrJoint;
    /**
     * True if tracking is available, otherwise tracking might be lost.
     *
     * @type {boolean}
     */
    get tracking(): boolean;
}

/**
 * Represents XR input source, which is any input mechanism which allows the user to perform
 * targeted actions in the same virtual space as the viewer. Example XR input sources include, but
 * are not limited to: handheld controllers, optically tracked hands, touch screen taps, and
 * gaze-based input methods that operate on the viewer's pose.
 *
 * @augments EventHandler
 * @category XR
 */
declare class XrInputSource extends EventHandler {
    /**
     * Fired when {@link XrInputSource} is removed.
     *
     * @event
     * @example
     * inputSource.once('remove', () => {
     *     // input source is not available anymore
     * });
     */
    static EVENT_REMOVE: string;
    /**
     * Fired when input source has triggered primary action. This could be pressing a trigger
     * button, or touching a screen. The handler is passed an {@link XRInputSourceEvent} object
     * from the WebXR API.
     *
     * @event
     * @example
     * const ray = new pc.Ray();
     * inputSource.on('select', (evt) => {
     *     ray.set(inputSource.getOrigin(), inputSource.getDirection());
     *     if (obj.intersectsRay(ray)) {
     *         // selected an object with input source
     *     }
     * });
     */
    static EVENT_SELECT: string;
    /**
     * Fired when input source has started to trigger primary action. The handler is passed an
     * {@link XRInputSourceEvent} object from the WebXR API.
     *
     * @event
     * @example
     * inputSource.on('selectstart', (evt) => {
     *     console.log('Select started');
     * });
     */
    static EVENT_SELECTSTART: string;
    /**
     * Fired when input source has ended triggering primary action. The handler is passed an
     * {@link XRInputSourceEvent} object from the WebXR API.
     *
     * @event
     * @example
     * inputSource.on('selectend', (evt) => {
     *     console.log('Select ended');
     * });
     */
    static EVENT_SELECTEND: string;
    /**
     * Fired when input source has triggered squeeze action. This is associated with "grabbing"
     * action on the controllers. The handler is passed an {@link XRInputSourceEvent} object from
     * the WebXR API.
     *
     * @event
     * @example
     * inputSource.on('squeeze', (evt) => {
     *     console.log('Squeeze');
     * });
     */
    static EVENT_SQUEEZE: string;
    /**
     * Fired when input source has started to trigger squeeze action. The handler is passed an
     * {@link XRInputSourceEvent} object from the WebXR API.
     *
     * @event
     * @example
     * inputSource.on('squeezestart', (evt) => {
     *     if (obj.containsPoint(inputSource.getPosition())) {
     *         // grabbed an object
     *     }
     * });
     */
    static EVENT_SQUEEZESTART: string;
    /**
     * Fired when input source has ended triggering squeeze action. The handler is passed an
     * {@link XRInputSourceEvent} object from the WebXR API.
     *
     * @event
     * @example
     * inputSource.on('squeezeend', (evt) => {
     *     console.log('Squeeze ended');
     * });
     */
    static EVENT_SQUEEZEEND: string;
    /**
     * Fired when new {@link XrHitTestSource} is added to the input source. The handler is passed
     * the {@link XrHitTestSource} object that has been added.
     *
     * @event
     * @example
     * inputSource.on('hittest:add', (hitTestSource) => {
     *     // new hit test source is added
     * });
     */
    static EVENT_HITTESTADD: string;
    /**
     * Fired when {@link XrHitTestSource} is removed to the the input source. The handler is passed
     * the {@link XrHitTestSource} object that has been removed.
     *
     * @event
     * @example
     * inputSource.on('remove', (hitTestSource) => {
     *     // hit test source is removed
     * });
     */
    static EVENT_HITTESTREMOVE: string;
    /**
     * Fired when hit test source receives new results. It provides transform information that
     * tries to match real world picked geometry. The handler is passed the {@link XrHitTestSource}
     * object that produced the hit result, the {@link Vec3} position, the {@link Quat}
     * rotation and the {@link XRHitTestResult} object that is created by the WebXR API.
     *
     * @event
     * @example
     * inputSource.on('hittest:result', (hitTestSource, position, rotation, hitTestResult) => {
     *     target.setPosition(position);
     *     target.setRotation(rotation);
     * });
     */
    static EVENT_HITTESTRESULT: string;
    /**
     * Create a new XrInputSource instance.
     *
     * @param {import('./xr-manager.js').XrManager} manager - WebXR Manager.
     * @param {*} xrInputSource - [XRInputSource](https://developer.mozilla.org/en-US/docs/Web/API/XRInputSource)
     * object that is created by WebXR API.
     * @hideconstructor
     */
    constructor(manager: XrManager, xrInputSource: any);
    /**
     * @type {number}
     * @private
     */
    private _id;
    /**
     * @type {import('./xr-manager.js').XrManager}
     * @private
     */
    private _manager;
    /**
     * @type {XRInputSource}
     * @private
     */
    private _xrInputSource;
    /**
     * @type {Ray}
     * @private
     */
    private _ray;
    /**
     * @type {Ray}
     * @private
     */
    private _rayLocal;
    /**
     * @type {boolean}
     * @private
     */
    private _grip;
    /**
     * @type {XrHand|null}
     * @private
     */
    private _hand;
    /**
     * @type {boolean}
     * @private
     */
    private _velocitiesAvailable;
    /**
     * @type {number}
     * @private
     */
    private _velocitiesTimestamp;
    /**
     * @type {Mat4|null}
     * @private
     */
    private _localTransform;
    /**
     * @type {Mat4|null}
     * @private
     */
    private _worldTransform;
    /**
     * @type {Vec3}
     * @private
     */
    private _position;
    /**
     * @type {Quat}
     * @private
     */
    private _rotation;
    /**
     * @type {Vec3|null}
     * @private
     */
    private _localPosition;
    /**
     * @type {Vec3|null}
     * @private
     */
    private _localPositionLast;
    /**
     * @type {Quat|null}
     * @private
     */
    private _localRotation;
    /**
     * @type {Vec3|null}
     * @private
     */
    private _linearVelocity;
    /**
     * @type {boolean}
     * @private
     */
    private _dirtyLocal;
    /**
     * @type {boolean}
     * @private
     */
    private _dirtyRay;
    /**
     * @type {boolean}
     * @private
     */
    private _selecting;
    /**
     * @type {boolean}
     * @private
     */
    private _squeezing;
    /**
     * @type {boolean}
     * @private
     */
    private _elementInput;
    /**
     * @type {import('../entity.js').Entity|null}
     * @private
     */
    private _elementEntity;
    /**
     * @type {import('./xr-hit-test-source.js').XrHitTestSource[]}
     * @private
     */
    private _hitTestSources;
    /**
     * Unique number associated with instance of input source. Same physical devices when
     * reconnected will not share this ID.
     *
     * @type {number}
     */
    get id(): number;
    /**
     * XRInputSource object that is associated with this input source.
     *
     * @type {object}
     */
    get inputSource(): any;
    /**
     * Type of ray Input Device is based on. Can be one of the following:
     *
     * - {@link XRTARGETRAY_GAZE}: Gaze - indicates the target ray will originate at the viewer and
     * follow the direction it is facing. This is commonly referred to as a "gaze input" device in
     * the context of head-mounted displays.
     * - {@link XRTARGETRAY_SCREEN}: Screen - indicates that the input source was an interaction
     * with the canvas element associated with an inline session's output context, such as a mouse
     * click or touch event.
     * - {@link XRTARGETRAY_POINTER}: Tracked Pointer - indicates that the target ray originates
     * from either a handheld device or other hand-tracking mechanism and represents that the user
     * is using their hands or the held device for pointing.
     *
     * @type {string}
     */
    get targetRayMode(): string;
    /**
     * Describes which hand input source is associated with. Can be one of the following:
     *
     * - {@link XRHAND_NONE}: None - input source is not meant to be held in hands.
     * - {@link XRHAND_LEFT}: Left - indicates that input source is meant to be held in left hand.
     * - {@link XRHAND_RIGHT}: Right - indicates that input source is meant to be held in right
     * hand.
     *
     * @type {string}
     */
    get handedness(): string;
    /**
     * List of input profile names indicating both the preferred visual representation and behavior
     * of the input source.
     *
     * @type {string[]}
     */
    get profiles(): string[];
    /**
     * If input source can be held, then it will have node with its world transformation, that can
     * be used to position and rotate visual object based on it.
     *
     * @type {boolean}
     */
    get grip(): boolean;
    /**
     * If input source is a tracked hand, then it will point to {@link XrHand} otherwise it is
     * null.
     *
     * @type {XrHand|null}
     */
    get hand(): XrHand;
    /**
     * If input source has buttons, triggers, thumbstick or touchpad, then this object provides
     * access to its states.
     *
     * @type {Gamepad|null}
     */
    get gamepad(): Gamepad;
    /**
     * True if input source is in active primary action between selectstart and selectend events.
     *
     * @type {boolean}
     */
    get selecting(): boolean;
    /**
     * True if input source is in active squeeze action between squeezestart and squeezeend events.
     *
     * @type {boolean}
     */
    get squeezing(): boolean;
    /**
     * Set to true to allow input source to interact with Element components. Defaults to true.
     *
     * @type {boolean}
     */
    set elementInput(arg: boolean);
    get elementInput(): boolean;
    /**
     * If {@link XrInputSource#elementInput} is true, this property will hold entity with Element
     * component at which this input source is hovering, or null if not hovering over any element.
     *
     * @type {import('../entity.js').Entity|null}
     */
    get elementEntity(): Entity;
    /**
     * List of active {@link XrHitTestSource} instances associated with this input source.
     *
     * @type {import('./xr-hit-test-source.js').XrHitTestSource[]}
     */
    get hitTestSources(): XrHitTestSource[];
    /**
     * @param {*} frame - XRFrame from requestAnimationFrame callback.
     * @ignore
     */
    update(frame: any): void;
    /** @private */
    private _updateTransforms;
    /** @private */
    private _updateRayTransforms;
    /**
     * Get the world space position of input source if it is handheld ({@link XrInputSource#grip}
     * is true). Otherwise it will return null.
     *
     * @returns {Vec3|null} The world space position of handheld input source.
     */
    getPosition(): Vec3 | null;
    /**
     * Get the local space position of input source if it is handheld ({@link XrInputSource#grip}
     * is true). Local space is relative to parent of the XR camera. Otherwise it will return null.
     *
     * @returns {Vec3|null} The world space position of handheld input source.
     */
    getLocalPosition(): Vec3 | null;
    /**
     * Get the world space rotation of input source if it is handheld ({@link XrInputSource#grip}
     * is true). Otherwise it will return null.
     *
     * @returns {Quat|null} The world space rotation of handheld input source.
     */
    getRotation(): Quat | null;
    /**
     * Get the local space rotation of input source if it is handheld ({@link XrInputSource#grip}
     * is true). Local space is relative to parent of the XR camera. Otherwise it will return null.
     *
     * @returns {Quat|null} The world space rotation of handheld input source.
     */
    getLocalRotation(): Quat | null;
    /**
     * Get the linear velocity (units per second) of the input source if it is handheld
     * ({@link XrInputSource#grip} is true). Otherwise it will return null.
     *
     * @returns {Vec3|null} The world space linear velocity of the handheld input source.
     */
    getLinearVelocity(): Vec3 | null;
    /**
     * Get the world space origin of input source ray.
     *
     * @returns {Vec3} The world space origin of input source ray.
     */
    getOrigin(): Vec3;
    /**
     * Get the world space direction of input source ray.
     *
     * @returns {Vec3} The world space direction of input source ray.
     */
    getDirection(): Vec3;
    /**
     * Attempts to start hit test source based on this input source.
     *
     * @param {object} [options] - Object for passing optional arguments.
     * @param {string[]} [options.entityTypes] - Optional list of underlying entity types against
     * which hit tests will be performed. Defaults to [ {@link XRTRACKABLE_PLANE} ]. Can be any
     * combination of the following:
     *
     * - {@link XRTRACKABLE_POINT}: Point - indicates that the hit test results will be computed
     * based on the feature points detected by the underlying Augmented Reality system.
     * - {@link XRTRACKABLE_PLANE}: Plane - indicates that the hit test results will be computed
     * based on the planes detected by the underlying Augmented Reality system.
     * - {@link XRTRACKABLE_MESH}: Mesh - indicates that the hit test results will be computed
     * based on the meshes detected by the underlying Augmented Reality system.
     *
     * @param {Ray} [options.offsetRay] - Optional ray by which hit test ray can be offset.
     * @param {import('./xr-hit-test.js').XrHitTestStartCallback} [options.callback] - Optional
     * callback function called once hit test source is created or failed.
     * @example
     * app.xr.input.on('add', function (inputSource) {
     *     inputSource.hitTestStart({
     *         callback: function (err, hitTestSource) {
     *             if (err) return;
     *             hitTestSource.on('result', function (position, rotation, inputSource, hitTestResult) {
     *                 // position and rotation of hit test result
     *                 // that will be created from touch on mobile devices
     *             });
     *         }
     *     });
     * });
     */
    hitTestStart(options?: {
        entityTypes?: string[];
        offsetRay?: Ray;
        callback?: XrHitTestStartCallback;
    }): void;
    /**
     * @param {import('./xr-hit-test-source.js').XrHitTestSource} hitTestSource - Hit test source
     * to be added.
     * @private
     */
    private onHitTestSourceAdd;
    /**
     * @param {import('./xr-hit-test-source.js').XrHitTestSource} hitTestSource - Hit test source
     * to be removed.
     * @private
     */
    private onHitTestSourceRemove;
}

declare class ElementComponentData {
    enabled: boolean;
}

declare class StandardMaterialOptionsBuilder {
    _mapXForms: any[];
    updateMinRef(options: any, scene: any, stdMat: any, objDefs: any, pass: any, sortedLights: any): void;
    updateRef(options: any, scene: any, stdMat: any, objDefs: any, pass: any, sortedLights: any): void;
    _updateSharedOptions(options: any, scene: any, stdMat: any, objDefs: any, pass: any): void;
    _updateUVOptions(options: any, stdMat: any, objDefs: any, minimalOptions: any): void;
    _updateTexOptions(options: any, stdMat: any, p: any, hasUv0: any, hasUv1: any, hasVcolor: any, minimalOptions: any, uniqueTextureMap: any): void;
    _updateMinOptions(options: any, stdMat: any): void;
    _updateMaterialOptions(options: any, stdMat: any): void;
    _updateEnvOptions(options: any, stdMat: any, scene: any): void;
    _updateLightOptions(options: any, scene: any, stdMat: any, objDefs: any, sortedLights: any): void;
    _getMapTransformID(xform: any, uv: any): any;
}

/**
 * Callback used by {@link StandardMaterialonUpdateShader }.
 */
export type UpdateShaderCallback = (options: StandardMaterialOptions) => StandardMaterialOptions;
/**
 * Callback used by {@link StandardMaterial#onUpdateShader}.
 *
 * @callback UpdateShaderCallback
 * @param {import('./standard-material-options.js').StandardMaterialOptions} options - An object with shader generator settings (based on current
 * material and scene properties), that you can change and then return. Properties of the object passed
 * into this function are documented in {@link StandardMaterial}. Also contains a member named litOptions
 * which holds some of the options only used by the lit shader backend {@link LitShaderOptions}.
 * @returns {import('./standard-material-options.js').StandardMaterialOptions} Returned settings will be used by the shader.
 */
/**
 * A Standard material is the main, general purpose material that is most often used for rendering.
 * It can approximate a wide variety of surface types and can simulate dynamic reflected light.
 * Most maps can use 3 types of input values in any combination: constant (color or number), mesh
 * vertex colors and a texture. All enabled inputs are multiplied together.
 *
 * @property {Color} ambient The ambient color of the material. This color value is 3-component
 * (RGB), where each component is between 0 and 1.
 * @property {Color} diffuse The diffuse color of the material. This color value is 3-component
 * (RGB), where each component is between 0 and 1. Defines basic surface color (aka albedo).
 * @property {boolean} diffuseTint Multiply main (primary) diffuse map and/or diffuse vertex color
 * by the constant diffuse value.
 * @property {import('../../platform/graphics/texture.js').Texture|null} diffuseMap The main
 * (primary) diffuse map of the material (default is null).
 * @property {number} diffuseMapUv Main (primary) diffuse map UV channel.
 * @property {Vec2} diffuseMapTiling Controls the 2D tiling of the main (primary) diffuse map.
 * @property {Vec2} diffuseMapOffset Controls the 2D offset of the main (primary) diffuse map. Each
 * component is between 0 and 1.
 * @property {number} diffuseMapRotation Controls the 2D rotation (in degrees) of the main
 * (primary) diffuse map.
 * @property {string} diffuseMapChannel Color channels of the main (primary) diffuse map to use.
 * Can be "r", "g", "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} diffuseVertexColor Use mesh vertex colors for diffuse. If diffuseMap or are
 * diffuseTint are set, they'll be multiplied by vertex colors.
 * @property {string} diffuseVertexColorChannel Vertex color channels to use for diffuse. Can be
 * "r", "g", "b", "a", "rgb" or any swizzled combination.
 * @property {import('../../platform/graphics/texture.js').Texture|null} diffuseDetailMap The
 * detail (secondary) diffuse map of the material (default is null). Will only be used if main
 * (primary) diffuse map is non-null.
 * @property {number} diffuseDetailMapUv Detail (secondary) diffuse map UV channel.
 * @property {Vec2} diffuseDetailMapTiling Controls the 2D tiling of the detail (secondary) diffuse
 * map.
 * @property {Vec2} diffuseDetailMapOffset Controls the 2D offset of the detail (secondary) diffuse
 * map. Each component is between 0 and 1.
 * @property {number} diffuseDetailMapRotation Controls the 2D rotation (in degrees) of the main
 * (secondary) diffuse map.
 * @property {string} diffuseDetailMapChannel Color channels of the detail (secondary) diffuse map
 * to use. Can be "r", "g", "b", "a", "rgb" or any swizzled combination.
 * @property {string} diffuseDetailMode Determines how the main (primary) and detail (secondary)
 * diffuse maps are blended together. Can be:
 *
 * - {@link DETAILMODE_MUL}: Multiply together the primary and secondary colors.
 * - {@link DETAILMODE_ADD}: Add together the primary and secondary colors.
 * - {@link DETAILMODE_SCREEN}: Softer version of {@link DETAILMODE_ADD}.
 * - {@link DETAILMODE_OVERLAY}: Multiplies or screens the colors, depending on the primary color.
 * - {@link DETAILMODE_MIN}: Select whichever of the primary and secondary colors is darker,
 * component-wise.
 * - {@link DETAILMODE_MAX}: Select whichever of the primary and secondary colors is lighter,
 * component-wise.
 *
 * Defaults to {@link DETAILMODE_MUL}.
 * @property {Color} specular The specular color of the material. This color value is 3-component
 * (RGB), where each component is between 0 and 1. Defines surface reflection/specular color.
 * Affects specular intensity and tint.
 * @property {boolean} specularTint Multiply specular map and/or specular vertex color by the
 * constant specular value.
 * @property {import('../../platform/graphics/texture.js').Texture|null} specularMap The specular
 * map of the material (default is null).
 * @property {number} specularMapUv Specular map UV channel.
 * @property {Vec2} specularMapTiling Controls the 2D tiling of the specular map.
 * @property {Vec2} specularMapOffset Controls the 2D offset of the specular map. Each component is
 * between 0 and 1.
 * @property {number} specularMapRotation Controls the 2D rotation (in degrees) of the specular map.
 * @property {string} specularMapChannel Color channels of the specular map to use. Can be "r", "g",
 * "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} specularVertexColor Use mesh vertex colors for specular. If specularMap or
 * are specularTint are set, they'll be multiplied by vertex colors.
 * @property {string} specularVertexColorChannel Vertex color channels to use for specular. Can be
 * @property {boolean} specularityFactorTint Multiply specularity factor map and/or specular vertex color by the
 * constant specular value.
 * "r", "g", "b", "a", "rgb" or any swizzled combination.
 * @property {number} specularityFactor The factor of specular intensity, used to weight the fresnel and specularity. Default is 1.0.
 * @property {import('../../platform/graphics/texture.js').Texture|null} specularityFactorMap The
 * factor of specularity as a texture (default is null).
 * @property {number} specularityFactorMapUv Specularity factor map UV channel.
 * @property {Vec2} specularityFactorMapTiling Controls the 2D tiling of the specularity factor map.
 * @property {Vec2} specularityFactorMapOffset Controls the 2D offset of the specularity factor map. Each component is
 * between 0 and 1.
 * @property {number} specularityFactorMapRotation Controls the 2D rotation (in degrees) of the specularity factor map.
 * @property {string} specularityFactorMapChannel The channel used by the specularity factor texture to sample from (default is 'a').
 * @property {boolean} specularityFactorVertexColor Use mesh vertex colors for specularity factor. If specularityFactorMap or
 * are specularityFactorTint are set, they'll be multiplied by vertex colors.
 * @property {string} specularityFactorVertexColorChannel Vertex color channels to use for specularity factor. Can be
 * "r", "g", "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} enableGGXSpecular Enables GGX specular. Also enables
 * {@link StandardMaterial#anisotropy}  parameter to set material anisotropy.
 * @property {number} anisotropy Defines amount of anisotropy. Requires
 * {@link StandardMaterial#enableGGXSpecular} is set to true.
 *
 * - When anisotropy == 0, specular is isotropic.
 * - When anisotropy < 0, anisotropy direction aligns with the tangent, and specular anisotropy
 * increases as the anisotropy value decreases to minimum of -1.
 * - When anisotropy > 0, anisotropy direction aligns with the bi-normal, and specular anisotropy
 * increases as anisotropy value increases to maximum of 1.
 *
 * @property {number} clearCoat Defines intensity of clearcoat layer from 0 to 1. Clearcoat layer
 * is disabled when clearCoat == 0. Default value is 0 (disabled).
 * @property {import('../../platform/graphics/texture.js').Texture|null} clearCoatMap Monochrome
 * clearcoat intensity map (default is null). If specified, will be multiplied by normalized
 * 'clearCoat' value and/or vertex colors.
 * @property {number} clearCoatMapUv Clearcoat intensity map UV channel.
 * @property {Vec2} clearCoatMapTiling Controls the 2D tiling of the clearcoat intensity map.
 * @property {Vec2} clearCoatMapOffset Controls the 2D offset of the clearcoat intensity map. Each
 * component is between 0 and 1.
 * @property {number} clearCoatMapRotation Controls the 2D rotation (in degrees) of the clearcoat
 * intensity map.
 * @property {string} clearCoatMapChannel Color channel of the clearcoat intensity map to use. Can
 * be "r", "g", "b" or "a".
 * @property {boolean} clearCoatVertexColor Use mesh vertex colors for clearcoat intensity. If
 * clearCoatMap is set, it'll be multiplied by vertex colors.
 * @property {string} clearCoatVertexColorChannel Vertex color channel to use for clearcoat
 * intensity. Can be "r", "g", "b" or "a".
 * @property {number} clearCoatGloss Defines the clearcoat glossiness of the clearcoat layer
 * from 0 (rough) to 1 (mirror).
 * @property {boolean} clearCoatGlossInvert Invert the clearcoat gloss component (default is false).
 * Enabling this flag results in material treating the clear coat gloss members as roughness.
 * @property {import('../../platform/graphics/texture.js').Texture|null} clearCoatGlossMap Monochrome
 * clearcoat glossiness map (default is null). If specified, will be multiplied by normalized
 * 'clearCoatGloss' value and/or vertex colors.
 * @property {number} clearCoatGlossMapUv Clearcoat gloss map UV channel.
 * @property {Vec2} clearCoatGlossMapTiling Controls the 2D tiling of the clearcoat gloss map.
 * @property {Vec2} clearCoatGlossMapOffset Controls the 2D offset of the clearcoat gloss map.
 * Each component is between 0 and 1.
 * @property {number} clearCoatGlossMapRotation Controls the 2D rotation (in degrees) of the clear
 * coat gloss map.
 * @property {string} clearCoatGlossMapChannel Color channel of the clearcoat gloss map to use.
 * Can be "r", "g", "b" or "a".
 * @property {boolean} clearCoatGlossVertexColor Use mesh vertex colors for clearcoat glossiness.
 * If clearCoatGlossMap is set, it'll be multiplied by vertex colors.
 * @property {string} clearCoatGlossVertexColorChannel Vertex color channel to use for clearcoat
 * glossiness. Can be "r", "g", "b" or "a".
 * @property {import('../../platform/graphics/texture.js').Texture|null} clearCoatNormalMap The
 * clearcoat normal map of the material (default is null). The texture must contains normalized,
 * tangent space normals.
 * @property {number} clearCoatNormalMapUv Clearcoat normal map UV channel.
 * @property {Vec2} clearCoatNormalMapTiling Controls the 2D tiling of the main clearcoat normal
 * map.
 * @property {Vec2} clearCoatNormalMapOffset Controls the 2D offset of the main clearcoat normal
 * map. Each component is between 0 and 1.
 * @property {number} clearCoatNormalMapRotation Controls the 2D rotation (in degrees) of the main
 * clearcoat map.
 * @property {number} clearCoatBumpiness The bumpiness of the clearcoat layer. This value scales
 * the assigned main clearcoat normal map. It should be normally between 0 (no bump mapping) and 1
 * (full bump mapping), but can be set to e.g. 2 to give even more pronounced bump effect.
 * @property {boolean} useIridescence Enable thin-film iridescence.
 * @property {import('../../platform/graphics/texture.js').Texture|null} iridescenceMap The
 * per-pixel iridescence intensity. Only used when useIridescence is enabled.
 * @property {number} iridescenceMapUv Iridescence map UV channel.
 * @property {Vec2} iridescenceMapTiling Controls the 2D tiling of the iridescence map.
 * @property {Vec2} iridescenceMapOffset Controls the 2D offset of the iridescence map. Each component is
 * between 0 and 1.
 * @property {number} iridescenceMapRotation Controls the 2D rotation (in degrees) of the iridescence
 * map.
 * @property {string} iridescenceMapChannel Color channels of the iridescence map to use. Can be "r",
 * "g", "b" or "a".
 * @property {import('../../platform/graphics/texture.js').Texture|null} iridescenceThicknessMap The
 * per-pixel iridescence thickness. Defines a gradient weight between iridescenceThicknessMin and
 * iridescenceThicknessMax. Only used when useIridescence is enabled.
 * @property {number} iridescenceThicknessMapUv Iridescence thickness map UV channel.
 * @property {Vec2} iridescenceThicknessMapTiling Controls the 2D tiling of the iridescence
 * thickness map.
 * @property {Vec2} iridescenceThicknessMapOffset Controls the 2D offset of the iridescence
 * thickness map. Each component is between 0 and 1.
 * @property {number} iridescenceThicknessMapRotation Controls the 2D rotation (in degrees)
 * of the iridescence map.
 * @property {string} iridescenceThicknessMapChannel Color channels of the iridescence thickness
 * map to use. Can be "r", "g", "b" or "a".
 * @property {number} iridescenceThicknessMin The minimum thickness for the iridescence layer.
 * Only used when an iridescence thickness map is used. The unit is in nm.
 * @property {number} iridescenceThicknessMax The maximum thickness for the iridescence layer.
 * Used as the 'base' thickness when no iridescence thickness map is defined. The unit is in nm.
 * @property {number} iridescenceRefractionIndex The index of refraction of the iridescent
 * thin-film. Affects the color phase shift as described here:
 * https://github.com/KhronosGroup/glTF/tree/main/extensions/2.0/Khronos/KHR_materials_iridescence
 * @property {boolean} useMetalness Use metalness properties instead of specular. When enabled,
 * diffuse colors also affect specular instead of the dedicated specular map. This can be used as
 * alternative to specular color to save space. With metalness == 0, the pixel is assumed to be
 * dielectric, and diffuse color is used as normal. With metalness == 1, the pixel is fully
 * metallic, and diffuse color is used as specular color instead.
 * @property {boolean} useMetalnessSpecularColor When metalness is enabled, use the
 * specular map to apply color tint to specular reflections.
 * at direct angles.
 * @property {number} metalness Defines how much the surface is metallic. From 0 (dielectric) to 1
 * (metal).
 * @property {import('../../platform/graphics/texture.js').Texture|null} metalnessMap Monochrome
 * metalness map (default is null).
 * @property {number} metalnessMapUv Metalness map UV channel.
 * @property {Vec2} metalnessMapTiling Controls the 2D tiling of the metalness map.
 * @property {Vec2} metalnessMapOffset Controls the 2D offset of the metalness map. Each component
 * is between 0 and 1.
 * @property {number} metalnessMapRotation Controls the 2D rotation (in degrees) of the metalness
 * map.
 * @property {string} metalnessMapChannel Color channel of the metalness map to use. Can be "r",
 * "g", "b" or "a".
 * @property {boolean} metalnessVertexColor Use mesh vertex colors for metalness. If metalnessMap
 * is set, it'll be multiplied by vertex colors.
 * @property {string} metalnessVertexColorChannel Vertex color channel to use for metalness. Can be
 * "r", "g", "b" or "a".
 * @property {number} gloss Defines the glossiness of the material from 0 (rough) to 1 (shiny).
 * @property {import('../../platform/graphics/texture.js').Texture|null} glossMap Gloss map
 * (default is null). If specified, will be multiplied by normalized gloss value and/or vertex
 * colors.
 * @property {boolean} glossInvert Invert the gloss component (default is false). Enabling this
 * flag results in material treating the gloss members as roughness.
 * @property {number} glossMapUv Gloss map UV channel.
 * @property {string} glossMapChannel Color channel of the gloss map to use. Can be "r", "g", "b"
 * or "a".
 * @property {Vec2} glossMapTiling Controls the 2D tiling of the gloss map.
 * @property {Vec2} glossMapOffset Controls the 2D offset of the gloss map. Each component is
 * between 0 and 1.
 * @property {number} glossMapRotation Controls the 2D rotation (in degrees) of the gloss map.
 * @property {boolean} glossVertexColor Use mesh vertex colors for glossiness. If glossMap is set,
 * it'll be multiplied by vertex colors.
 * @property {string} glossVertexColorChannel Vertex color channel to use for glossiness. Can be
 * "r", "g", "b" or "a".
 * @property {number} refraction Defines the visibility of refraction. Material can refract the
 * same cube map as used for reflections.
 * @property {import('../../platform/graphics/texture.js').Texture|null} refractionMap The map of
 * the refraction visibility.
 * @property {number} refractionMapUv Refraction map UV channel.
 * @property {Vec2} refractionMapTiling Controls the 2D tiling of the refraction map.
 * @property {Vec2} refractionMapOffset Controls the 2D offset of the refraction map. Each component
 * is between 0 and 1.
 * @property {number} refractionMapRotation Controls the 2D rotation (in degrees) of the emissive
 * map.
 * @property {string} refractionMapChannel Color channels of the refraction map to use. Can be "r",
 * "g", "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} refractionVertexColor Use mesh vertex colors for refraction. If
 * refraction map is set, it will be be multiplied by vertex colors.
 * @property {boolean} refractionVertexColorChannel Vertex color channel to use for refraction.
 * Can be "r", "g", "b" or "a".
 * @property {number} refractionIndex Defines the index of refraction, i.e. The amount of
 * distortion. The value is calculated as (outerIor / surfaceIor), where inputs are measured
 * indices of refraction, the one around the object and the one of its own surface. In most
 * situations outer medium is air, so outerIor will be approximately 1. Then you only need to do
 * (1.0 / surfaceIor).
 * @property {boolean} useDynamicRefraction Enables higher quality refractions using the grab pass
 * instead of pre-computed cube maps for refractions.
 * @property {number} thickness The thickness of the medium, only used when useDynamicRefraction
 * is enabled. The unit is in base units, and scales with the size of the object.
 * @property {import('../../platform/graphics/texture.js').Texture|null} thicknessMap The
 * per-pixel thickness of the medium, only used when useDynamicRefraction is enabled.
 * @property {number} thicknessMapUv Thickness map UV channel.
 * @property {Vec2} thicknessMapTiling Controls the 2D tiling of the thickness map.
 * @property {Vec2} thicknessMapOffset Controls the 2D offset of the thickness map. Each component is
 * between 0 and 1.
 * @property {number} thicknessMapRotation Controls the 2D rotation (in degrees) of the thickness
 * map.
 * @property {string} thicknessMapChannel Color channels of the thickness map to use. Can be "r",
 * "g", "b" or "a".
 * @property {boolean} thicknessVertexColor Use mesh vertex colors for thickness. If
 * thickness map is set, it will be be multiplied by vertex colors.
 * @property {Color} attenuation The attenuation color for refractive materials, only used when
 * useDynamicRefraction is enabled.
 * @property {number} attenuationDistance The distance defining the absorption rate of light
 * within the medium. Only used when useDynamicRefraction is enabled.
 * @property {Color} emissive The emissive color of the material. This color value is 3-component
 * (RGB), where each component is between 0 and 1.
 * @property {boolean} emissiveTint Multiply emissive map and/or emissive vertex color by the
 * constant emissive value.
 * @property {import('../../platform/graphics/texture.js').Texture|null} emissiveMap The emissive
 * map of the material (default is null). Can be HDR.
 * @property {number} emissiveIntensity Emissive color multiplier.
 * @property {number} emissiveMapUv Emissive map UV channel.
 * @property {Vec2} emissiveMapTiling Controls the 2D tiling of the emissive map.
 * @property {Vec2} emissiveMapOffset Controls the 2D offset of the emissive map. Each component is
 * between 0 and 1.
 * @property {number} emissiveMapRotation Controls the 2D rotation (in degrees) of the emissive
 * map.
 * @property {string} emissiveMapChannel Color channels of the emissive map to use. Can be "r",
 * "g", "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} emissiveVertexColor Use mesh vertex colors for emission. If emissiveMap or
 * emissiveTint are set, they'll be multiplied by vertex colors.
 * @property {string} emissiveVertexColorChannel Vertex color channels to use for emission. Can be
 * "r", "g", "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} useSheen Toggle sheen specular effect on/off.
 * @property {Color} sheen The specular color of the sheen (fabric) microfiber structure.
 * This color value is 3-component (RGB), where each component is between 0 and 1.
 * @property {boolean} sheenTint Multiply sheen map and/or sheen vertex color by the constant
 * sheen value.
 * @property {import('../../platform/graphics/texture.js').Texture|null} sheenMap The sheen
 * microstructure color map of the material (default is null).
 * @property {number} sheenMapUv Sheen map UV channel.
 * @property {Vec2} sheenMapTiling Controls the 2D tiling of the sheen map.
 * @property {Vec2} sheenMapOffset Controls the 2D offset of the sheen map. Each component is
 * between 0 and 1.
 * @property {number} sheenMapRotation Controls the 2D rotation (in degrees) of the sheen
 * map.
 * @property {string} sheenMapChannel Color channels of the sheen map to use. Can be "r",
 * "g", "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} sheenVertexColor Use mesh vertex colors for sheen. If sheen map or
 * sheen tint are set, they'll be multiplied by vertex colors.
 * @property {number} sheenGloss The glossiness of the sheen (fabric) microfiber structure.
 * This color value is a single value between 0 and 1.
 * @property {boolean} sheenGlossInvert Invert the sheen gloss component (default is false).
 * Enabling this flag results in material treating the sheen gloss members as roughness.
 * @property {boolean} sheenGlossTint Multiply sheen glossiness map and/or sheen glossiness vertex
 * value by the scalar sheen glossiness value.
 * @property {import('../../platform/graphics/texture.js').Texture|null} sheenGlossMap The sheen
 * glossiness microstructure color map of the material (default is null).
 * @property {number} sheenGlossMapUv Sheen map UV channel.
 * @property {Vec2} sheenGlossMapTiling Controls the 2D tiling of the sheen glossiness map.
 * @property {Vec2} sheenGlossMapOffset Controls the 2D offset of the sheen glossiness map.
 * Each component is between 0 and 1.
 * @property {number} sheenGlossMapRotation Controls the 2D rotation (in degrees) of the sheen
 * glossiness map.
 * @property {string} sheenGlossMapChannel Color channels of the sheen glossiness map to use.
 * Can be "r", "g", "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} sheenGlossVertexColor Use mesh vertex colors for sheen glossiness.
 * If sheen glossiness map or sheen glossiness tint are set, they'll be multiplied by vertex colors.
 * @property {string} sheenGlossVertexColorChannel Vertex color channels to use for sheen glossiness.
 * Can be "r", "g", "b" or "a".
 * @property {number} opacity The opacity of the material. This value can be between 0 and 1, where
 * 0 is fully transparent and 1 is fully opaque. If you want the material to be semi-transparent
 * you also need to set the {@link Material#blendType} to {@link BLEND_NORMAL},
 * {@link BLEND_ADDITIVE} or any other mode. Also note that for most semi-transparent objects you
 * want {@link Material#depthWrite} to be false, otherwise they can fully occlude objects behind
 * them.
 * @property {import('../../platform/graphics/texture.js').Texture|null} opacityMap The opacity map
 * of the material (default is null).
 * @property {number} opacityMapUv Opacity map UV channel.
 * @property {string} opacityMapChannel Color channel of the opacity map to use. Can be "r", "g",
 * "b" or "a".
 * @property {Vec2} opacityMapTiling Controls the 2D tiling of the opacity map.
 * @property {Vec2} opacityMapOffset Controls the 2D offset of the opacity map. Each component is
 * between 0 and 1.
 * @property {number} opacityMapRotation Controls the 2D rotation (in degrees) of the opacity map.
 * @property {boolean} opacityVertexColor Use mesh vertex colors for opacity. If opacityMap is set,
 * it'll be multiplied by vertex colors.
 * @property {string} opacityVertexColorChannel Vertex color channels to use for opacity. Can be
 * "r", "g", "b" or "a".
 * @property {boolean} opacityFadesSpecular Used to specify whether specular and reflections are
 * faded out using {@link StandardMaterial#opacity}. Default is true. When set to false use
 * {@link Material#alphaFade} to fade out materials.
 * @property {string} opacityDither Used to specify whether opacity is dithered, which allows
 * transparency without alpha blending. Can be:
 *
 * - {@link DITHER_NONE}: Opacity dithering is disabled.
 * - {@link DITHER_BAYER8}: Opacity is dithered using a Bayer 8 matrix.
 * - {@link DITHER_BLUENOISE}: Opacity is dithered using a blue noise texture.
 *
 * Defaults to {@link DITHER_NONE}.
 * @property {boolean} opacityShadowDither Used to specify whether shadow opacity is dithered, which
 * allows shadow transparency without alpha blending.  Can be:
 *
 * - {@link DITHER_NONE}: Opacity dithering is disabled.
 * - {@link DITHER_BAYER8}: Opacity is dithered using a Bayer 8 matrix.
 * - {@link DITHER_BLUENOISE}: Opacity is dithered using a blue noise texture.
 *
 * Defaults to {@link DITHER_NONE}.
 * @property {number} alphaFade Used to fade out materials when
 * {@link StandardMaterial#opacityFadesSpecular} is set to false.
 * @property {import('../../platform/graphics/texture.js').Texture|null} normalMap The main
 * (primary) normal map of the material (default is null). The texture must contains normalized,
 * tangent space normals.
 * @property {number} normalMapUv Main (primary) normal map UV channel.
 * @property {Vec2} normalMapTiling Controls the 2D tiling of the main (primary) normal map.
 * @property {Vec2} normalMapOffset Controls the 2D offset of the main (primary) normal map. Each
 * component is between 0 and 1.
 * @property {number} normalMapRotation Controls the 2D rotation (in degrees) of the main (primary)
 * normal map.
 * @property {number} bumpiness The bumpiness of the material. This value scales the assigned main
 * (primary) normal map. It should be normally between 0 (no bump mapping) and 1 (full bump
 * mapping), but can be set to e.g. 2 to give even more pronounced bump effect.
 * @property {import('../../platform/graphics/texture.js').Texture|null} normalDetailMap The detail
 * (secondary) normal map of the material (default is null). Will only be used if main (primary)
 * normal map is non-null.
 * @property {number} normalDetailMapUv Detail (secondary) normal map UV channel.
 * @property {Vec2} normalDetailMapTiling Controls the 2D tiling of the detail (secondary) normal
 * map.
 * @property {Vec2} normalDetailMapOffset Controls the 2D offset of the detail (secondary) normal
 * map. Each component is between 0 and 1.
 * @property {number} normalDetailMapRotation Controls the 2D rotation (in degrees) of the detail
 * (secondary) normal map.
 * @property {number} normalDetailMapBumpiness The bumpiness of the material. This value scales the
 * assigned detail (secondary) normal map. It should be normally between 0 (no bump mapping) and 1
 * (full bump mapping), but can be set to e.g. 2 to give even more pronounced bump effect.
 * @property {import('../../platform/graphics/texture.js').Texture|null} heightMap The height map
 * of the material (default is null). Used for a view-dependent parallax effect. The texture must
 * represent the height of the surface where darker pixels are lower and lighter pixels are higher.
 * It is recommended to use it together with a normal map.
 * @property {number} heightMapUv Height map UV channel.
 * @property {string} heightMapChannel Color channel of the height map to use. Can be "r", "g", "b"
 * or "a".
 * @property {Vec2} heightMapTiling Controls the 2D tiling of the height map.
 * @property {Vec2} heightMapOffset Controls the 2D offset of the height map. Each component is
 * between 0 and 1.
 * @property {number} heightMapRotation Controls the 2D rotation (in degrees) of the height map.
 * @property {number} heightMapFactor Height map multiplier. Affects the strength of the parallax
 * effect.
 * @property {import('../../platform/graphics/texture.js').Texture|null} envAtlas The prefiltered
 * environment lighting atlas (default is null). This setting overrides cubeMap and sphereMap and
 * will replace the scene lighting environment.
 * @property {import('../../platform/graphics/texture.js').Texture|null} cubeMap The cubic
 * environment map of the material (default is null). This setting overrides sphereMap and will
 * replace the scene lighting environment.
 * @property {import('../../platform/graphics/texture.js').Texture|null} sphereMap The spherical
 * environment map of the material (default is null). This will replace the scene lighting
 * environment.
 * @property {number} cubeMapProjection The type of projection applied to the cubeMap property:
 * - {@link CUBEPROJ_NONE}: The cube map is treated as if it is infinitely far away.
 * - {@link CUBEPROJ_BOX}: Box-projection based on a world space axis-aligned bounding box.
 * Defaults to {@link CUBEPROJ_NONE}.
 * @property {import('../../core/shape/bounding-box.js').BoundingBox} cubeMapProjectionBox The
 * world space axis-aligned bounding box defining the box-projection used for the cubeMap property.
 * Only used when cubeMapProjection is set to {@link CUBEPROJ_BOX}.
 * @property {number} reflectivity Environment map intensity.
 * @property {import('../../platform/graphics/texture.js').Texture|null} lightMap A custom lightmap
 * of the material (default is null). Lightmaps are textures that contain pre-rendered lighting.
 * Can be HDR.
 * @property {number} lightMapUv Lightmap UV channel
 * @property {string} lightMapChannel Color channels of the lightmap to use. Can be "r", "g", "b",
 * "a", "rgb" or any swizzled combination.
 * @property {Vec2} lightMapTiling Controls the 2D tiling of the lightmap.
 * @property {Vec2} lightMapOffset Controls the 2D offset of the lightmap. Each component is
 * between 0 and 1.
 * @property {number} lightMapRotation Controls the 2D rotation (in degrees) of the lightmap.
 * @property {boolean} lightVertexColor Use baked vertex lighting. If lightMap is set, it'll be
 * multiplied by vertex colors.
 * @property {string} lightVertexColorChannel Vertex color channels to use for baked lighting. Can
 * be "r", "g", "b", "a", "rgb" or any swizzled combination.
 * @property {boolean} ambientTint Enables scene ambient multiplication by material ambient color.
 * @property {import('../../platform/graphics/texture.js').Texture|null} aoMap The main (primary) baked ambient
 * occlusion (AO) map (default is null). Modulates ambient color.
 * @property {number} aoMapUv Main (primary) AO map UV channel
 * @property {string} aoMapChannel Color channel of the main (primary) AO map to use. Can be "r", "g", "b" or "a".
 * @property {Vec2} aoMapTiling Controls the 2D tiling of the main (primary) AO map.
 * @property {Vec2} aoMapOffset Controls the 2D offset of the main (primary) AO map. Each component is between 0
 * and 1.
 * @property {number} aoMapRotation Controls the 2D rotation (in degrees) of the main (primary) AO map.
 * @property {boolean} aoVertexColor Use mesh vertex colors for AO. If aoMap is set, it'll be
 * multiplied by vertex colors.
 * @property {string} aoVertexColorChannel Vertex color channels to use for AO. Can be "r", "g",
 * "b" or "a".
 * @property {import('../../platform/graphics/texture.js').Texture|null} aoDetailMap The
 * detail (secondary) baked ambient occlusion (AO) map of the material (default is null). Will only be used if main
 * (primary) ao map is non-null.
 * @property {number} aoDetailMapUv Detail (secondary) AO map UV channel.
 * @property {Vec2} aoDetailMapTiling Controls the 2D tiling of the detail (secondary) AO
 * map.
 * @property {Vec2} aoDetailMapOffset Controls the 2D offset of the detail (secondary) AO
 * map. Each component is between 0 and 1.
 * @property {number} aoDetailMapRotation Controls the 2D rotation (in degrees) of the detail
 * (secondary) AO map.
 * @property {string} aoDetailMapChannel Color channels of the detail (secondary) AO map
 * to use. Can be "r", "g", "b" or "a" (default is "g").
 * @property {string} aoDetailMode Determines how the main (primary) and detail (secondary)
 * AO maps are blended together. Can be:
 *
 * - {@link DETAILMODE_MUL}: Multiply together the primary and secondary colors.
 * - {@link DETAILMODE_ADD}: Add together the primary and secondary colors.
 * - {@link DETAILMODE_SCREEN}: Softer version of {@link DETAILMODE_ADD}.
 * - {@link DETAILMODE_OVERLAY}: Multiplies or screens the colors, depending on the primary color.
 * - {@link DETAILMODE_MIN}: Select whichever of the primary and secondary colors is darker,
 * component-wise.
 * - {@link DETAILMODE_MAX}: Select whichever of the primary and secondary colors is lighter,
 * component-wise.
 *
 * Defaults to {@link DETAILMODE_MUL}.
 * @property {number} occludeSpecular Uses ambient occlusion to darken specular/reflection. It's a
 * hack, because real specular occlusion is view-dependent. However, it can be better than nothing.
 *
 * - {@link SPECOCC_NONE}: No specular occlusion
 * - {@link SPECOCC_AO}: Use AO directly to occlude specular.
 * - {@link SPECOCC_GLOSSDEPENDENT}: Modify AO based on material glossiness/view angle to occlude
 * specular.
 *
 * @property {number} occludeSpecularIntensity Controls visibility of specular occlusion.
 * @property {boolean} occludeDirect Tells if AO should darken directional lighting. Defaults to
 * false.
 * @property {boolean} conserveEnergy Defines how diffuse and specular components are combined when
 * Fresnel is on. It is recommended that you leave this option enabled, although you may want to
 * disable it in case when all reflection comes only from a few light sources, and you don't use an
 * environment map, therefore having mostly black reflection.
 * @property {number} shadingModel Defines the shading model.
 * - {@link SPECULAR_PHONG}: Phong without energy conservation. You should only use it as a
 * backwards compatibility with older projects.
 * - {@link SPECULAR_BLINN}: Energy-conserving Blinn-Phong.
 * @property {number} fresnelModel Defines the formula used for Fresnel effect.
 * As a side-effect, enabling any Fresnel model changes the way diffuse and reflection components
 * are combined. When Fresnel is off, legacy non energy-conserving combining is used. When it is
 * on, combining behavior is defined by conserveEnergy parameter.
 *
 * - {@link FRESNEL_NONE}: No Fresnel.
 * - {@link FRESNEL_SCHLICK}: Schlick's approximation of Fresnel (recommended). Parameterized by
 * specular color.
 *
 * @property {boolean} useFog Apply fogging (as configured in scene settings)
 * @property {boolean} useLighting Apply lighting
 * @property {boolean} useSkybox Apply scene skybox as prefiltered environment map
 * @property {boolean} useGammaTonemap Apply gamma correction and tonemapping (as configured in
 * scene settings).
 * @property {boolean} pixelSnap Align vertices to pixel coordinates when rendering. Useful for
 * pixel perfect 2D graphics.
 * @property {boolean} twoSidedLighting Calculate proper normals (and therefore lighting) on
 * backfaces.
 * @property {UpdateShaderCallback} onUpdateShader A custom function that will be called after all
 * shader generator properties are collected and before shader code is generated. This function
 * will receive an object with shader generator settings (based on current material and scene
 * properties), that you can change and then return. Returned value will be used instead. This is
 * mostly useful when rendering the same set of objects, but with different shader variations based
 * on the same material. For example, you may wish to render a depth or normal pass using textures
 * assigned to the material, a reflection pass with simpler shaders and so on. These properties are
 * split into two sections, generic standard material options and lit options. Properties of the
 * standard material options are {@link StandardMaterialOptions} and the options for the lit options
 * are {@link LitShaderOptions}.
 * @augments Material
 * @category Graphics
 */
declare class StandardMaterial extends Material {
    static TEXTURE_PARAMETERS: any[];
    static CUBEMAP_PARAMETERS: any[];
    userAttributes: Map<any, any>;
    _dirtyShader: boolean;
    _assetReferences: {};
    _activeParams: Set<any>;
    _activeLightingParams: Set<any>;
    shaderOptBuilder: StandardMaterialOptionsBuilder;
    reset(): void;

    set alphaFade(arg: boolean);
    get alphaFade(): boolean;

    set ambient(arg: Color);
    get ambient(): Color;

    set ambientTint(arg: boolean);
    get ambientTint(): boolean;

    set anisotropy(arg: number);
    get anisotropy(): number;

    set aoMap(arg: Texture|null);
    get aoMap(): Texture|null;

    set aoMapChannel(arg: string);
    get aoMapChannel(): string;

    set aoMapOffset(arg: Vec2);
    get aoMapOffset(): Vec2;

    set aoMapRotation(arg: number);
    get aoMapRotation(): number;

    set aoMapTiling(arg: Vec2);
    get aoMapTiling(): Vec2;

    set aoMapUv(arg: number);
    get aoMapUv(): number;

    set aoDetailMap(arg: Texture|null);
    get aoDetailMap(): Texture|null;

    set aoDetailMapChannel(arg: string);
    get aoDetailMapChannel(): string;

    set aoDetailMapOffset(arg: Vec2);
    get aoDetailMapOffset(): Vec2;

    set aoDetailMapRotation(arg: number);
    get aoDetailMapRotation(): number;

    set aoDetailMapTiling(arg: Vec2);
    get aoDetailMapTiling(): Vec2;

    set aoDetailMapUv(arg: number);
    get aoDetailMapUv(): number;

    set aoDetailMode(arg: string);
    get aoDetailMode(): string;

    set aoVertexColor(arg: boolean);
    get aoVertexColor(): boolean;

    set aoVertexColorChannel(arg: string);
    get aoVertexColorChannel(): string;

    set bumpiness(arg: number);
    get bumpiness(): number;

    set clearCoat(arg: number);
    get clearCoat(): number;

    set clearCoatBumpiness(arg: number);
    get clearCoatBumpiness(): number;

    set clearCoatGlossInvert(arg: boolean);
    get clearCoatGlossInvert(): boolean;

    set clearCoatGlossMap(arg: Texture|null);
    get clearCoatGlossMap(): Texture|null;

    set clearCoatGlossMapChannel(arg: string);
    get clearCoatGlossMapChannel(): string;

    set clearCoatGlossMapOffset(arg: Vec2);
    get clearCoatGlossMapOffset(): Vec2;

    set clearCoatGlossMapRotation(arg: number);
    get clearCoatGlossMapRotation(): number;

    set clearCoatGlossMapTiling(arg: Vec2);
    get clearCoatGlossMapTiling(): Vec2;

    set clearCoatGlossMapUv(arg: number);
    get clearCoatGlossMapUv(): number;

    set clearCoatGlossVertexColor(arg: boolean);
    get clearCoatGlossVertexColor(): boolean;

    set clearCoatGlossVertexColorChannel(arg: string);
    get clearCoatGlossVertexColorChannel(): string;

    set clearCoatGloss(arg: number);
    get clearCoatGloss(): number;

    set clearCoatMap(arg: Texture|null);
    get clearCoatMap(): Texture|null;

    set clearCoatMapChannel(arg: string);
    get clearCoatMapChannel(): string;

    set clearCoatMapOffset(arg: Vec2);
    get clearCoatMapOffset(): Vec2;

    set clearCoatMapRotation(arg: number);
    get clearCoatMapRotation(): number;

    set clearCoatMapTiling(arg: Vec2);
    get clearCoatMapTiling(): Vec2;

    set clearCoatMapUv(arg: number);
    get clearCoatMapUv(): number;

    set clearCoatNormalMap(arg: Texture|null);
    get clearCoatNormalMap(): Texture|null;

    set clearCoatNormalMapOffset(arg: Vec2);
    get clearCoatNormalMapOffset(): Vec2;

    set clearCoatNormalMapRotation(arg: number);
    get clearCoatNormalMapRotation(): number;

    set clearCoatNormalMapTiling(arg: Vec2);
    get clearCoatNormalMapTiling(): Vec2;

    set clearCoatNormalMapUv(arg: number);
    get clearCoatNormalMapUv(): number;

    set clearCoatVertexColor(arg: boolean);
    get clearCoatVertexColor(): boolean;

    set clearCoatVertexColorChannel(arg: string);
    get clearCoatVertexColorChannel(): string;

    set conserveEnergy(arg: boolean);
    get conserveEnergy(): boolean;

    set cubeMap(arg: Texture|null);
    get cubeMap(): Texture|null;

    set cubeMapProjection(arg: number);
    get cubeMapProjection(): number;

    set cubeMapProjectionBox(arg: BoundingBox);
    get cubeMapProjectionBox(): BoundingBox;

    set diffuse(arg: Color);
    get diffuse(): Color;

    set diffuseDetailMap(arg: Texture|null);
    get diffuseDetailMap(): Texture|null;

    set diffuseDetailMapChannel(arg: string);
    get diffuseDetailMapChannel(): string;

    set diffuseDetailMapOffset(arg: Vec2);
    get diffuseDetailMapOffset(): Vec2;

    set diffuseDetailMapRotation(arg: number);
    get diffuseDetailMapRotation(): number;

    set diffuseDetailMapTiling(arg: Vec2);
    get diffuseDetailMapTiling(): Vec2;

    set diffuseDetailMapUv(arg: number);
    get diffuseDetailMapUv(): number;

    set diffuseDetailMode(arg: string);
    get diffuseDetailMode(): string;

    set diffuseMap(arg: Texture|null);
    get diffuseMap(): Texture|null;

    set diffuseMapChannel(arg: string);
    get diffuseMapChannel(): string;

    set diffuseMapOffset(arg: Vec2);
    get diffuseMapOffset(): Vec2;

    set diffuseMapRotation(arg: number);
    get diffuseMapRotation(): number;

    set diffuseMapTiling(arg: Vec2);
    get diffuseMapTiling(): Vec2;

    set diffuseMapUv(arg: number);
    get diffuseMapUv(): number;

    set diffuseTint(arg: boolean);
    get diffuseTint(): boolean;

    set diffuseVertexColor(arg: boolean);
    get diffuseVertexColor(): boolean;

    set diffuseVertexColorChannel(arg: string);
    get diffuseVertexColorChannel(): string;

    set emissive(arg: Color);
    get emissive(): Color;

    set emissiveIntensity(arg: number);
    get emissiveIntensity(): number;

    set emissiveMap(arg: Texture|null);
    get emissiveMap(): Texture|null;

    set emissiveMapChannel(arg: string);
    get emissiveMapChannel(): string;

    set emissiveMapOffset(arg: Vec2);
    get emissiveMapOffset(): Vec2;

    set emissiveMapRotation(arg: number);
    get emissiveMapRotation(): number;

    set emissiveMapTiling(arg: Vec2);
    get emissiveMapTiling(): Vec2;

    set emissiveMapUv(arg: number);
    get emissiveMapUv(): number;

    set emissiveTint(arg: boolean);
    get emissiveTint(): boolean;

    set emissiveVertexColor(arg: boolean);
    get emissiveVertexColor(): boolean;

    set emissiveVertexColorChannel(arg: string);
    get emissiveVertexColorChannel(): string;

    set enableGGXSpecular(arg: boolean);
    get enableGGXSpecular(): boolean;

    set envAtlas(arg: Texture|null);
    get envAtlas(): Texture|null;

    set fresnelModel(arg: number);
    get fresnelModel(): number;

    set gloss(arg: number);
    get gloss(): number;

    set glossInvert(arg: boolean);
    get glossInvert(): boolean;

    set glossMap(arg: Texture|null);
    get glossMap(): Texture|null;

    set glossMapChannel(arg: string);
    get glossMapChannel(): string;

    set glossMapOffset(arg: Vec2);
    get glossMapOffset(): Vec2;

    set glossMapRotation(arg: number);
    get glossMapRotation(): number;

    set glossMapTiling(arg: Vec2);
    get glossMapTiling(): Vec2;

    set glossMapUv(arg: number);
    get glossMapUv(): number;

    set glossVertexColor(arg: boolean);
    get glossVertexColor(): boolean;

    set glossVertexColorChannel(arg: string);
    get glossVertexColorChannel(): string;

    set heightMap(arg: Texture|null);
    get heightMap(): Texture|null;

    set heightMapChannel(arg: string);
    get heightMapChannel(): string;

    set heightMapFactor(arg: number);
    get heightMapFactor(): number;

    set heightMapOffset(arg: Vec2);
    get heightMapOffset(): Vec2;

    set heightMapRotation(arg: number);
    get heightMapRotation(): number;

    set heightMapTiling(arg: Vec2);
    get heightMapTiling(): Vec2;

    set heightMapUv(arg: number);
    get heightMapUv(): number;

    set lightMap(arg: Texture|null);
    get lightMap(): Texture|null;

    set lightMapChannel(arg: string);
    get lightMapChannel(): string;

    set lightMapOffset(arg: Vec2);
    get lightMapOffset(): Vec2;

    set lightMapRotation(arg: number);
    get lightMapRotation(): number;

    set lightMapTiling(arg: Vec2);
    get lightMapTiling(): Vec2;

    set lightMapUv(arg: number);
    get lightMapUv(): number;

    set lightVertexColor(arg: boolean);
    get lightVertexColor(): boolean;

    set lightVertexColorChannel(arg: string);
    get lightVertexColorChannel(): string;

    set metalness(arg: number);
    get metalness(): number;

    set metalnessMap(arg: Texture|null);
    get metalnessMap(): Texture|null;

    set metalnessMapChannel(arg: string);
    get metalnessMapChannel(): string;

    set metalnessMapOffset(arg: Vec2);
    get metalnessMapOffset(): Vec2;

    set metalnessMapRotation(arg: number);
    get metalnessMapRotation(): number;

    set metalnessMapTiling(arg: Vec2);
    get metalnessMapTiling(): Vec2;

    set metalnessMapUv(arg: number);
    get metalnessMapUv(): number;

    set metalnessVertexColor(arg: boolean);
    get metalnessVertexColor(): boolean;

    set metalnessVertexColorChannel(arg: string);
    get metalnessVertexColorChannel(): string;

    set normalDetailMap(arg: Texture|null);
    get normalDetailMap(): Texture|null;

    set normalDetailMapBumpiness(arg: number);
    get normalDetailMapBumpiness(): number;

    set normalDetailMapOffset(arg: Vec2);
    get normalDetailMapOffset(): Vec2;

    set normalDetailMapRotation(arg: number);
    get normalDetailMapRotation(): number;

    set normalDetailMapTiling(arg: Vec2);
    get normalDetailMapTiling(): Vec2;

    set normalDetailMapUv(arg: number);
    get normalDetailMapUv(): number;

    set normalMap(arg: Texture|null);
    get normalMap(): Texture|null;

    set normalMapOffset(arg: Vec2);
    get normalMapOffset(): Vec2;

    set normalMapRotation(arg: number);
    get normalMapRotation(): number;

    set normalMapTiling(arg: Vec2);
    get normalMapTiling(): Vec2;

    set normalMapUv(arg: number);
    get normalMapUv(): number;

    set occludeDirect(arg: number);
    get occludeDirect(): number;

    set occludeSpecular(arg: number);
    get occludeSpecular(): number;

    set occludeSpecularIntensity(arg: number);
    get occludeSpecularIntensity(): number;

    set onUpdateShader(arg: UpdateShaderCallback);
    get onUpdateShader(): UpdateShaderCallback;

    set opacity(arg: number);
    get opacity(): number;

    set opacityDither(arg: string);
    get opacityDither(): string;

    set opacityShadowDither(arg: string);
    get opacityShadowDither(): string;

    set opacityFadesSpecular(arg: boolean);
    get opacityFadesSpecular(): boolean;

    set opacityMap(arg: Texture|null);
    get opacityMap(): Texture|null;

    set opacityMapChannel(arg: string);
    get opacityMapChannel(): string;

    set opacityMapOffset(arg: Vec2);
    get opacityMapOffset(): Vec2;

    set opacityMapRotation(arg: number);
    get opacityMapRotation(): number;

    set opacityMapTiling(arg: Vec2);
    get opacityMapTiling(): Vec2;

    set opacityMapUv(arg: number);
    get opacityMapUv(): number;

    set opacityVertexColor(arg: boolean);
    get opacityVertexColor(): boolean;

    set opacityVertexColorChannel(arg: string);
    get opacityVertexColorChannel(): string;

    set pixelSnap(arg: boolean);
    get pixelSnap(): boolean;

    set reflectivity(arg: number);
    get reflectivity(): number;

    set refraction(arg: number);
    get refraction(): number;

    set refractionIndex(arg: number);
    get refractionIndex(): number;

    set shadingModel(arg: number);
    get shadingModel(): number;

    set specular(arg: Color);
    get specular(): Color;

    set specularMap(arg: Texture|null);
    get specularMap(): Texture|null;

    set specularMapChannel(arg: string);
    get specularMapChannel(): string;

    set specularMapOffset(arg: Vec2);
    get specularMapOffset(): Vec2;

    set specularMapRotation(arg: number);
    get specularMapRotation(): number;

    set specularMapTiling(arg: Vec2);
    get specularMapTiling(): Vec2;

    set specularMapUv(arg: number);
    get specularMapUv(): number;

    set specularTint(arg: boolean);
    get specularTint(): boolean;

    set specularVertexColor(arg: boolean);
    get specularVertexColor(): boolean;

    set specularVertexColorChannel(arg: string);
    get specularVertexColorChannel(): string;

    set specularityFactor(arg: number);
    get specularityFactor(): number;

    set specularityFactorMap(arg: Texture|null);
    get specularityFactorMap(): Texture|null;

    set specularityFactorMapChannel(arg: string);
    get specularityFactorMapChannel(): string;

    set specularityFactorMapOffset(arg: Vec2);
    get specularityFactorMapOffset(): Vec2;

    set specularityFactorMapRotation(arg: number);
    get specularityFactorMapRotation(): number;

    set specularityFactorMapTiling(arg: Vec2);
    get specularityFactorMapTiling(): Vec2;

    set specularityFactorMapUv(arg: number);
    get specularityFactorMapUv(): number;

    set useSheen(arg: boolean);
    get useSheen(): boolean;

    set sheen(arg: Color);
    get sheen(): Color;

    set sheenMap(arg: Texture|null);
    get sheenMap(): Texture|null;

    set sheenMapChannel(arg: string);
    get sheenMapChannel(): string;

    set sheenMapOffset(arg: Vec2);
    get sheenMapOffset(): Vec2;

    set sheenMapRotation(arg: number);
    get sheenMapRotation(): number;

    set sheenMapTiling(arg: Vec2);
    get sheenMapTiling(): Vec2;

    set sheenMapUv(arg: number);
    get sheenMapUv(): number;

    set sheenTint(arg: boolean);
    get sheenTint(): boolean;

    set sheenVertexColor(arg: boolean);
    get sheenVertexColor(): boolean;

    set sheenVertexColorChannel(arg: string);
    get sheenVertexColorChannel(): string;

    set sphereMap(arg: Texture|null);
    get sphereMap(): Texture|null;

    set twoSidedLighting(arg: boolean);
    get twoSidedLighting(): boolean;

    set useFog(arg: boolean);
    get useFog(): boolean;

    set useGammaTonemap(arg: boolean);
    get useGammaTonemap(): boolean;

    set useLighting(arg: boolean);
    get useLighting(): boolean;

    set useMetalness(arg: boolean);
    get useMetalness(): boolean;

    set useMetalnessSpecularColor(arg: boolean);
    get useMetalnessSpecularColor(): boolean;

    set useSkybox(arg: boolean);
    get useSkybox(): boolean;

    /**
     * @type {Object<string, string>}
     * @private
     */
    private _chunks;
    _uniformCache: {};
    set shader(arg: any);
    get shader(): any;
    /**
     * Object containing custom shader chunks that will replace default ones.
     *
     * @type {Object<string, string>}
     */
    set chunks(arg: {
        [x: string]: string;
    });
    get chunks(): {
        [x: string]: string;
    };
    /**
     * Copy a `StandardMaterial`.
     *
     * @param {StandardMaterial} source - The material to copy from.
     * @returns {StandardMaterial} The destination material.
     */
    copy(source: StandardMaterial): StandardMaterial;
    /**
     * Sets a vertex shader attribute on a material.
     *
     * @param {string} name - The name of the parameter to set.
     * @param {string} semantic - Semantic to map the vertex data. Must match with the semantic set on vertex stream
     * of the mesh.
     * @example
     * mesh.setVertexStream(pc.SEMANTIC_ATTR15, offset, 3);
     * material.setAttribute('offset', pc.SEMANTIC_ATTR15);
     */
    setAttribute(name: string, semantic: string): void;
    _setParameter(name: any, value: any): void;
    _setParameters(parameters: any): void;
    _processParameters(paramsName: any): void;
    _updateMap(p: any): void;
    _allocUniform(name: any, allocFunc: any): any;
    getUniform(name: any, device: any, scene: any): any;
    updateEnvUniforms(device: any, scene: any): void;
}

/**
 * Manages creation of {@link ElementComponent}s.
 *
 * @augments ComponentSystem
 * @category User Interface
 */
declare class ElementComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof ElementComponent;
    DataType: typeof ElementComponentData;
    schema: string[];
    _unicodeConverter: any;
    _rtlReorder: any;
    _defaultTexture: Texture;
    defaultImageMaterial: StandardMaterial;
    defaultImage9SlicedMaterial: StandardMaterial;
    defaultImage9TiledMaterial: StandardMaterial;
    defaultImageMaskMaterial: StandardMaterial;
    defaultImage9SlicedMaskMaterial: StandardMaterial;
    defaultImage9TiledMaskMaterial: StandardMaterial;
    defaultScreenSpaceImageMaterial: StandardMaterial;
    defaultScreenSpaceImage9SlicedMaterial: StandardMaterial;
    defaultScreenSpaceImage9TiledMaterial: StandardMaterial;
    defaultScreenSpaceImageMask9SlicedMaterial: StandardMaterial;
    defaultScreenSpaceImageMask9TiledMaterial: StandardMaterial;
    defaultScreenSpaceImageMaskMaterial: StandardMaterial;
    _defaultTextMaterials: {};
    defaultImageMaterials: any[];
    initializeComponentData(component: any, data: any, properties: any): void;
    onRemoveComponent(entity: any, component: any): void;
    cloneComponent(entity: any, clone: any): Component;
    getTextElementMaterial(screenSpace: any, msdf: any, textAttibutes: any): any;
    _createBaseImageMaterial(): StandardMaterial;
    getImageElementMaterial(screenSpace: any, mask: any, nineSliced: any, nineSliceTiled: any): StandardMaterial;
    registerUnicodeConverter(func: any): void;
    registerRtlReorder(func: any): void;
    getUnicodeConverter(): any;
    getRtlReorder(): any;
}

/**
 * A model is a graphical object that can be added to or removed from a scene. It contains a
 * hierarchy and any number of mesh instances.
 *
 * @category Graphics
 */
declare class Model {
    /**
     * The root node of the model's graph node hierarchy.
     *
     * @type {import('./graph-node.js').GraphNode|null}
     */
    graph: GraphNode | null;
    /**
     * An array of MeshInstances contained in this model.
     *
     * @type {MeshInstance[]}
     */
    meshInstances: MeshInstance[];
    /**
     * An array of SkinInstances contained in this model.
     *
     * @type {SkinInstance[]}
     */
    skinInstances: SkinInstance[];
    /**
     * An array of MorphInstances contained in this model.
     *
     * @type {MorphInstance[]}
     */
    morphInstances: MorphInstance[];
    cameras: any[];
    lights: any[];
    _shadersVersion: number;
    _immutable: boolean;
    getGraph(): GraphNode;
    setGraph(graph: any): void;
    getCameras(): any[];
    setCameras(cameras: any): void;
    getLights(): any[];
    setLights(lights: any): void;
    getMaterials(): Material[];
    /**
     * Clones a model. The returned model has a newly created hierarchy and mesh instances, but
     * meshes are shared between the clone and the specified model.
     *
     * @returns {Model} A clone of the specified model.
     * @example
     * const clonedModel = model.clone();
     */
    clone(): Model;
    /**
     * Destroys skinning texture and possibly deletes vertex/index buffers of a model. Mesh is
     * reference-counted, so buffers are only deleted if all models with referencing mesh instances
     * were deleted. That means all in-scene models + the "base" one (asset.resource) which is
     * created when the model is parsed. It is recommended to use asset.unload() instead, which
     * will also remove the model from the scene.
     */
    destroy(): void;
    /**
     * Generates the necessary internal data for a model to be renderable as wireframe. Once this
     * function has been called, any mesh instance in the model can have its renderStyle property
     * set to {@link RENDERSTYLE_WIREFRAME}.
     *
     * @example
     * model.generateWireframe();
     * for (let i = 0; i < model.meshInstances.length; i++) {
     *     model.meshInstances[i].renderStyle = pc.RENDERSTYLE_WIREFRAME;
     * }
     */
    generateWireframe(): void;
}

declare class ImageElement {
    constructor(element: any);
    _element: any;
    _entity: any;
    _system: any;
    _textureAsset: any;
    _texture: any;
    _materialAsset: any;
    _material: any;
    _spriteAsset: any;
    _sprite: any;
    _spriteFrame: number;
    _pixelsPerUnit: any;
    _targetAspectRatio: number;
    _rect: Vec4;
    _mask: boolean;
    _maskRef: number;
    _outerScale: Vec2;
    _outerScaleUniform: Float32Array;
    _innerOffset: Vec4;
    _innerOffsetUniform: Float32Array;
    _atlasRect: Vec4;
    _atlasRectUniform: Float32Array;
    _defaultMesh: Mesh;
    _renderable: ImageRenderable;
    _color: Color;
    _colorUniform: Float32Array;
    _updateAabbFunc: any;
    destroy(): void;
    set textureAsset(arg: any);
    get textureAsset(): any;
    set spriteAsset(arg: any);
    get spriteAsset(): any;
    set materialAsset(arg: any);
    get materialAsset(): any;
    _onResolutionChange(res: any): void;
    _onParentResizeOrPivotChange(): void;
    _onScreenSpaceChange(value: any): void;
    _onScreenChange(screen: any, previous: any): void;
    _onDrawOrderChange(order: any): void;
    _hasUserMaterial(): boolean;
    _use9Slicing(): boolean;
    _updateMaterial(screenSpace: any): void;
    _createMesh(): Mesh;
    _updateMesh(mesh: any): void;
    _meshDirty: boolean;
    _updateSprite(): void;
    set mesh(arg: any);
    get mesh(): any;
    refreshMesh(): void;
    _updateAabb(aabb: any): any;
    _toggleMask(): void;
    _onMaterialLoad(asset: any): void;
    set material(arg: any);
    get material(): any;
    _onMaterialAdded(asset: any): void;
    _bindMaterialAsset(asset: any): void;
    _unbindMaterialAsset(asset: any): void;
    _onMaterialChange(): void;
    _onMaterialRemove(): void;
    _onTextureAdded(asset: any): void;
    _bindTextureAsset(asset: any): void;
    _unbindTextureAsset(asset: any): void;
    _onTextureLoad(asset: any): void;
    set texture(arg: any);
    get texture(): any;
    _onTextureChange(asset: any): void;
    _onTextureRemove(asset: any): void;
    _onSpriteAssetAdded(asset: any): void;
    _bindSpriteAsset(asset: any): void;
    _unbindSpriteAsset(asset: any): void;
    _onSpriteAssetLoad(asset: any): void;
    set sprite(arg: any);
    get sprite(): any;
    _onSpriteAssetChange(asset: any): void;
    _onSpriteAssetRemove(asset: any): void;
    _bindSprite(sprite: any): void;
    _unbindSprite(sprite: any): void;
    _onSpriteMeshesChange(): void;
    _onSpritePpuChange(): void;
    _onAtlasTextureChange(): void;
    _onTextureAtlasLoad(atlasAsset: any): void;
    onEnable(): void;
    onDisable(): void;
    _setStencil(stencilParams: any): void;
    set color(arg: Color);
    get color(): Color;
    set opacity(arg: number);
    get opacity(): number;
    set rect(arg: Vec4);
    get rect(): Vec4;
    _removeMaterialAssetEvents(): void;
    set spriteFrame(arg: number);
    get spriteFrame(): number;
    set mask(arg: boolean);
    get mask(): boolean;
    set pixelsPerUnit(arg: any);
    get pixelsPerUnit(): any;
    get aabb(): any;
}

declare class ImageRenderable {
    constructor(entity: any, mesh: any, material: any);
    _entity: any;
    _element: any;
    model: Model;
    node: GraphNode;
    mesh: any;
    meshInstance: MeshInstance;
    _meshDirty: boolean;
    unmaskMeshInstance: MeshInstance;
    destroy(): void;
    setMesh(mesh: any): void;
    setMask(mask: any): void;
    setMaterial(material: any): void;
    setParameter(name: any, value: any): void;
    deleteParameter(name: any): void;
    setUnmaskDrawOrder(): void;
    setDrawOrder(drawOrder: any): void;
    setCull(cull: any): void;
    setScreenSpace(screenSpace: any): void;
    setLayer(layer: any): void;
    forceUpdateAabb(mask: any): void;
    setAabbFunc(fn: any): void;
}

declare class LocalizedAsset extends EventHandler {
    constructor(app: any);
    _app: any;
    _autoLoad: boolean;
    _disableLocalization: boolean;
    _defaultAsset: any;
    _localizedAsset: any;
    set defaultAsset(arg: any);
    get defaultAsset(): any;
    set localizedAsset(arg: any);
    get localizedAsset(): any;
    set autoLoad(arg: boolean);
    get autoLoad(): boolean;
    set disableLocalization(arg: boolean);
    get disableLocalization(): boolean;
    _bindDefaultAsset(): void;
    _unbindDefaultAsset(): void;
    _onDefaultAssetAdd(asset: any): void;
    _onDefaultAssetRemove(asset: any): void;
    _bindLocalizedAsset(): void;
    _unbindLocalizedAsset(): void;
    _onLocalizedAssetAdd(asset: any): void;
    _onLocalizedAssetLoad(asset: any): void;
    _onLocalizedAssetChange(asset: any, name: any, newValue: any, oldValue: any): void;
    _onLocalizedAssetRemove(asset: any): void;
    _onLocaleAdd(locale: any, assetId: any): void;
    _onLocaleRemove(locale: any, assetId: any): void;
    _onSetLocale(locale: any): void;
    destroy(): void;
}

declare class TextElement {
    constructor(element: any);
    _element: any;
    _system: any;
    _entity: any;
    _text: string;
    _symbols: any[];
    _colorPalette: any[];
    _outlinePalette: any[];
    _shadowPalette: any[];
    _symbolColors: any[];
    _symbolOutlineParams: any[];
    _symbolShadowParams: any[];
    _i18nKey: any;
    _fontAsset: LocalizedAsset;
    _font: any;
    _color: Color;
    _colorUniform: Float32Array;
    _spacing: number;
    _fontSize: number;
    _fontMinY: number;
    _fontMaxY: number;
    _originalFontSize: number;
    _maxFontSize: number;
    _minFontSize: number;
    _autoFitWidth: boolean;
    _autoFitHeight: boolean;
    _maxLines: number;
    _lineHeight: number;
    _scaledLineHeight: number;
    _wrapLines: boolean;
    _drawOrder: number;
    _alignment: Vec2;
    _autoWidth: boolean;
    _autoHeight: boolean;
    width: number;
    height: number;
    _node: GraphNode;
    _model: Model;
    _meshInfo: any[];
    _material: any;
    _aabbDirty: boolean;
    _aabb: BoundingBox;
    _noResize: boolean;
    _currentMaterialType: any;
    _maskedMaterialSrc: any;
    _rtlReorder: boolean;
    _unicodeConverter: boolean;
    _rtl: boolean;
    _outlineColor: Color;
    _outlineColorUniform: Float32Array;
    _outlineThicknessScale: number;
    _outlineThickness: number;
    _shadowColor: Color;
    _shadowColorUniform: Float32Array;
    _shadowOffsetScale: number;
    _shadowOffset: Vec2;
    _shadowOffsetUniform: Float32Array;
    _enableMarkup: boolean;
    _rangeStart: number;
    _rangeEnd: number;
    destroy(): void;
    set font(arg: any);
    get font(): any;
    _onParentResize(width: any, height: any): void;
    _onScreenChange(screen: any): void;
    _onScreenSpaceChange(value: any): void;
    _onDrawOrderChange(order: any): void;
    _onPivotChange(pivot: any): void;
    _onLocaleSet(locale: any): void;
    _onLocalizationData(locale: any, messages: any): void;
    _resetLocalizedText(): void;
    _setText(text: any): void;
    _updateText(text: any): void;
    _removeMeshInstance(meshInstance: any): void;
    _setMaterial(material: any): void;
    _updateMaterial(screenSpace: any): void;
    _updateMaterialEmissive(): void;
    _updateMaterialOutline(): void;
    _updateMaterialShadow(): void;
    _isWordBoundary(char: any): boolean;
    _isValidNextChar(nextchar: any): boolean;
    _isNextCJKBoundary(char: any, nextchar: any): boolean;
    _isNextCJKWholeWord(nextchar: any): boolean;
    _updateMeshes(): void;
    _lineWidths: any[];
    _lineContents: any[];
    set autoWidth(arg: boolean);
    get autoWidth(): boolean;
    set autoHeight(arg: boolean);
    get autoHeight(): boolean;
    _onFontRender(): void;
    _onFontLoad(asset: any): void;
    _onFontChange(asset: any, name: any, _new: any, _old: any): void;
    _onFontRemove(asset: any): void;
    _setTextureParams(mi: any, texture: any): void;
    _getPxRange(font: any): number;
    _getUv(char: any): any;
    onEnable(): void;
    onDisable(): void;
    _setStencil(stencilParams: any): void;
    _shouldAutoFitWidth(): boolean;
    _shouldAutoFitHeight(): boolean;
    _shouldAutoFit(): boolean;
    _calculateCharsPerTexture(symbolIndex: any): {};
    _updateRenderRange(): void;
    set text(arg: string);
    get text(): string;
    set key(arg: any);
    get key(): any;
    set color(arg: Color);
    get color(): Color;
    set opacity(arg: number);
    get opacity(): number;
    set lineHeight(arg: number);
    get lineHeight(): number;
    set wrapLines(arg: boolean);
    get wrapLines(): boolean;
    get lines(): any[];
    set spacing(arg: number);
    get spacing(): number;
    set fontSize(arg: number);
    get fontSize(): number;
    set fontAsset(arg: any);
    get fontAsset(): any;
    set alignment(arg: Vec2);
    get alignment(): Vec2;
    set rtlReorder(arg: boolean);
    get rtlReorder(): boolean;
    set unicodeConverter(arg: boolean);
    get unicodeConverter(): boolean;
    get aabb(): BoundingBox;
    set outlineColor(arg: Color);
    get outlineColor(): Color;
    set outlineThickness(arg: number);
    get outlineThickness(): number;
    set shadowColor(arg: Color);
    get shadowColor(): Color;
    set shadowOffset(arg: Vec2);
    get shadowOffset(): Vec2;
    set minFontSize(arg: number);
    get minFontSize(): number;
    set maxFontSize(arg: number);
    get maxFontSize(): number;
    set autoFitWidth(arg: boolean);
    get autoFitWidth(): boolean;
    set autoFitHeight(arg: boolean);
    get autoFitHeight(): boolean;
    set maxLines(arg: number);
    get maxLines(): number;
    set enableMarkup(arg: boolean);
    get enableMarkup(): boolean;
    get symbols(): any[];
    get symbolColors(): any[];
    get symbolOutlineParams(): any[];
    get symbolShadowParams(): any[];
    get rtl(): boolean;
    set rangeStart(arg: number);
    get rangeStart(): number;
    set rangeEnd(arg: number);
    get rangeEnd(): number;
}

/**
 * A TextureAtlas contains a number of frames from a texture. Each frame defines a region in a
 * texture. The TextureAtlas is referenced by {@link Sprite}s.
 *
 * @augments EventHandler
 * @category Graphics
 */
declare class TextureAtlas extends EventHandler {
    /**
     * @type {import('../platform/graphics/texture.js').Texture}
     * @private
     */
    private _texture;
    /**
     * @type {object}
     * @private
     */
    private _frames;
    /**
     * The texture used by the atlas.
     *
     * @type {import('../platform/graphics/texture.js').Texture}
     */
    set texture(arg: Texture);
    get texture(): Texture;
    /**
     * Contains frames which define portions of the texture atlas.
     *
     * @type {object}
     */
    set frames(arg: any);
    get frames(): any;
    /**
     * Set a new frame in the texture atlas.
     *
     * @param {string} key - The key of the frame.
     * @param {object} data - The properties of the frame.
     * @param {import('../core/math/vec4.js').Vec4} data.rect - The u, v, width, height properties
     * of the frame in pixels.
     * @param {import('../core/math/vec2.js').Vec2} data.pivot - The pivot of the frame - values
     * are between 0-1.
     * @param {import('../core/math/vec4.js').Vec4} data.border - The border of the frame for
     * 9-slicing. Values are ordered as follows: left, bottom, right, top border in pixels.
     * @example
     * atlas.setFrame('1', {
     *     rect: new pc.Vec4(0, 0, 128, 128),
     *     pivot: new pc.Vec2(0.5, 0.5),
     *     border: new pc.Vec4(5, 5, 5, 5)
     * });
     */
    setFrame(key: string, data: {
        rect: Vec4;
        pivot: Vec2;
        border: Vec4;
    }): void;
    /**
     * Removes a frame from the texture atlas.
     *
     * @param {string} key - The key of the frame.
     * @example
     * atlas.removeFrame('1');
     */
    removeFrame(key: string): void;
    /**
     * Free up the underlying texture owned by the atlas.
     */
    destroy(): void;
}

/**
 * A Sprite contains references to one or more frames of a {@link TextureAtlas}. It can be used by
 * the {@link SpriteComponent} or the {@link ElementComponent} to render a single frame or a sprite
 * animation.
 *
 * @augments EventHandler
 * @category Graphics
 */
declare class Sprite extends EventHandler {
    /**
     * Create a new Sprite instance.
     *
     * @param {import('../platform/graphics/graphics-device.js').GraphicsDevice} device - The
     * graphics device of the application.
     * @param {object} [options] - Options for creating the Sprite.
     * @param {number} [options.pixelsPerUnit] - The number of pixels that map to one PlayCanvas
     * unit. Defaults to 1.
     * @param {number} [options.renderMode] - The rendering mode of the sprite. Can be:
     *
     * - {@link SPRITE_RENDERMODE_SIMPLE}
     * - {@link SPRITE_RENDERMODE_SLICED}
     * - {@link SPRITE_RENDERMODE_TILED}
     *
     * Defaults to {@link SPRITE_RENDERMODE_SIMPLE}.
     * @param {import('./texture-atlas.js').TextureAtlas} [options.atlas] - The texture atlas.
     * Defaults to null.
     * @param {string[]} [options.frameKeys] - The keys of the frames in the sprite atlas that this
     * sprite is using. Defaults to null.
     */
    constructor(device: GraphicsDevice, options?: {
        pixelsPerUnit?: number;
        renderMode?: number;
        atlas?: TextureAtlas;
        frameKeys?: string[];
    });
    _device: GraphicsDevice;
    _pixelsPerUnit: number;
    _renderMode: number;
    _atlas: TextureAtlas;
    _frameKeys: string[];
    _meshes: any[];
    _updatingProperties: boolean;
    _meshesDirty: boolean;
    /**
     * The keys of the frames in the sprite atlas that this sprite is using.
     *
     * @type {string[]}
     */
    set frameKeys(arg: string[]);
    get frameKeys(): string[];
    /**
     * The texture atlas.
     *
     * @type {import('./texture-atlas.js').TextureAtlas}
     */
    set atlas(arg: TextureAtlas);
    get atlas(): TextureAtlas;
    /**
     * The number of pixels that map to one PlayCanvas unit.
     *
     * @type {number}
     */
    set pixelsPerUnit(arg: number);
    get pixelsPerUnit(): number;
    /**
     * The rendering mode of the sprite. Can be:
     *
     * - {@link SPRITE_RENDERMODE_SIMPLE}
     * - {@link SPRITE_RENDERMODE_SLICED}
     * - {@link SPRITE_RENDERMODE_TILED}
     *
     * @type {number}
     */
    set renderMode(arg: number);
    get renderMode(): number;
    /**
     * An array that contains a mesh for each frame.
     *
     * @type {import('./mesh.js').Mesh[]}
     */
    get meshes(): Mesh[];
    _createMeshes(): void;
    _createSimpleMesh(frame: any): Mesh;
    _create9SliceMesh(): Mesh;
    _onSetFrames(frames: any): void;
    _onFrameChanged(frameKey: any, frame: any): void;
    _onFrameRemoved(frameKey: any): void;
    startUpdate(): void;
    endUpdate(): void;
    /**
     * Free up the meshes created by the sprite.
     */
    destroy(): void;
}

/**
 * Represents the resource of a canvas font asset.
 *
 * @augments EventHandler
 * @ignore
 */
declare class CanvasFont extends EventHandler {
    /**
     * Create a new CanvasFont instance.
     *
     * @param {import('../app-base.js').AppBase} app - The application.
     * @param {object} options - The font options.
     * @param {string} [options.fontName] - The name of the font. CSS font names are supported.
     * Defaults to 'Arial'.
     * @param {string} [options.fontWeight] - The weight of the font, e.g. 'normal', 'bold'.
     * Defaults to 'normal'.
     * @param {number} [options.fontSize] - The font size in pixels. Defaults to 32.
     * @param {Color} [options.color] - The font color.Defaults to white.
     * @param {number} [options.width] - The width of each texture atlas. Defaults to 512.
     * @param {number} [options.height] - The height of each texture atlas. Defaults to 512.
     * @param {number} [options.padding] - Amount of glyph padding in pixels that is added to each
     * glyph in the atlas. Defaults to 0.
     */
    constructor(app: AppBase, options?: {
        fontName?: string;
        fontWeight?: string;
        fontSize?: number;
        color?: Color;
        width?: number;
        height?: number;
        padding?: number;
    });
    type: string;
    app: AppBase;
    intensity: number;
    fontWeight: string;
    fontSize: number;
    glyphSize: number;
    fontName: string;
    color: Color;
    padding: number;
    width: number;
    height: number;
    atlases: any[];
    chars: string;
    data: {};
    /**
     * Render the necessary textures for all characters in a string to be used for the canvas font.
     *
     * @param {string} text - The list of characters to render into the texture atlas.
     */
    createTextures(text: string): void;
    /**
     * Update the list of characters to include in the atlas to include those provided and
     * re-render the texture atlas to include all the characters that have been supplied so far.
     *
     * @param {string} text - The list of characters to add to the texture atlas.
     */
    updateTextures(text: string): void;
    /**
     * Destroys the font. This also destroys the textures owned by the font.
     */
    destroy(): void;
    /**
     * @param {Color} color - The color to covert.
     * @param {boolean} alpha - Whether to include the alpha channel.
     * @returns {string} The hex string for the color.
     * @private
     */
    private _colorToRgbString;
    /**
     * @param {CanvasRenderingContext2D} context - The canvas 2D context.
     * @param {string} char - The character to render.
     * @param {number} x - The x position to render the character at.
     * @param {number} y - The y position to render the character at.
     * @param {string} color - The color to render the character in.
     * @ignore
     */
    renderCharacter(context: CanvasRenderingContext2D, char: string, x: number, y: number, color: string): void;
    /**
     * Return the atlas at the specified index.
     *
     * @param {number} index - The atlas index
     * @private
     */
    private _getAtlas;
    /**
     * Renders an array of characters into one or more textures atlases.
     *
     * @param {string[]} charsArray - The list of characters to render.
     * @private
     */
    private _renderAtlas;
    /**
     * @param {string[]} chars - A list of characters.
     * @param {string} fontName - The font name.
     * @param {number} width - The width of the texture atlas.
     * @param {number} height - The height of the texture atlas.
     * @returns {object} The font JSON object.
     * @private
     */
    private _createJson;
    /**
     * @param {object} json - Font data.
     * @param {string} char - The character to add.
     * @param {number} charCode - The code point number of the character to add.
     * @param {number} x - The x position of the character.
     * @param {number} y - The y position of the character.
     * @param {number} w - The width of the character.
     * @param {number} h - The height of the character.
     * @param {number} xoffset - The x offset of the character.
     * @param {number} yoffset - The y offset of the character.
     * @param {number} xadvance - The x advance of the character.
     * @param {number} mapNum - The map number of the character.
     * @param {number} mapW - The width of the map.
     * @param {number} mapH - The height of the map.
     * @private
     */
    private _addChar;
    /**
     * Take a unicode string and produce the set of characters used to create that string.
     * e.g. "abcabcabc" -> ['a', 'b', 'c']
     *
     * @param {string} text - The unicode string to process.
     * @returns {string[]} The set of characters used to create the string.
     * @private
     */
    private _normalizeCharsSet;
    /**
     * Calculate some metrics that aren't available via the browser API, notably character height
     * and descent size.
     *
     * @param {string} text - The text to measure.
     * @returns {{ascent: number, descent: number, height: number}} The metrics of the text.
     * @private
     */
    private _getTextMetrics;
    get textures(): any[];
}

/**
 * Represents the resource of a font asset.
 *
 * @category User Interface
 */
declare class Font {
    /**
     * Create a new Font instance.
     *
     * @param {import('../../platform/graphics/texture.js').Texture[]} textures - The font
     * textures.
     * @param {object} data - The font data.
     */
    constructor(textures: Texture[], data: object);
    type: any;
    em: number;
    /**
     * The font textures.
     *
     * @type {import('../../platform/graphics/texture.js').Texture[]}
     */
    textures: Texture[];
    /**
     * The font intensity.
     *
     * @type {number}
     */
    intensity: number;
    _data: any;
    set data(arg: any);
    get data(): any;
}

/**
 * ElementComponents are used to construct user interfaces. An ElementComponent's [type](#type)
 * property can be configured in 3 main ways: as a text element, as an image element or as a group
 * element. If the ElementComponent has a {@link ScreenComponent} ancestor in the hierarchy, it
 * will be transformed with respect to the coordinate system of the screen. If there is no
 * {@link ScreenComponent} ancestor, the ElementComponent will be transformed like any other
 * entity.
 *
 * You should never need to use the ElementComponent constructor. To add an ElementComponent to a
 * {@link Entity}, use {@link Entity#addComponent}:
 *
 * ```javascript
 * // Add an element component to an entity with the default options
 * let entity = pc.Entity();
 * entity.addComponent("element"); // This defaults to a 'group' element
 * ```
 *
 * To create a simple text-based element:
 *
 * ```javascript
 * entity.addComponent("element", {
 *     anchor: new pc.Vec4(0.5, 0.5, 0.5, 0.5), // centered anchor
 *     fontAsset: fontAsset,
 *     fontSize: 128,
 *     pivot: new pc.Vec2(0.5, 0.5),            // centered pivot
 *     text: "Hello World!",
 *     type: pc.ELEMENTTYPE_TEXT
 * });
 * ```
 *
 * Once the ElementComponent is added to the entity, you can set and get any of its properties:
 *
 * ```javascript
 * entity.element.color = pc.Color.RED; // Set the element's color to red
 *
 * console.log(entity.element.color);   // Get the element's color and print it
 * ```
 *
 * Relevant 'Engine-only' examples:
 * - [Basic text rendering](https://playcanvas.github.io/#/user-interface/text)
 * - [Auto font sizing](https://playcanvas.github.io/#/user-interface/text-auto-font-size)
 * - [Emojis](https://playcanvas.github.io/#/user-interface/text-emojis)
 * - [Text localization](https://playcanvas.github.io/#/user-interface/text-localization)
 * - [Typewriter text](https://playcanvas.github.io/#/user-interface/text-typewriter)
 *
 * @property {import('../../../core/math/color.js').Color} color The color of the image for
 * {@link ELEMENTTYPE_IMAGE} types or the color of the text for {@link ELEMENTTYPE_TEXT} types.
 * @property {number} opacity The opacity of the image for {@link ELEMENTTYPE_IMAGE} types or the
 * text for {@link ELEMENTTYPE_TEXT} types.
 * @property {import('../../../core/math/color.js').Color} outlineColor The text outline effect
 * color and opacity. Only works for {@link ELEMENTTYPE_TEXT} types.
 * @property {number} outlineThickness The width of the text outline effect. Only works for
 * {@link ELEMENTTYPE_TEXT} types.
 * @property {import('../../../core/math/color.js').Color} shadowColor The text shadow effect color
 * and opacity. Only works for {@link ELEMENTTYPE_TEXT} types.
 * @property {Vec2} shadowOffset The text shadow effect shift amount from original text. Only works
 * for {@link ELEMENTTYPE_TEXT} types.
 * @property {boolean} autoWidth Automatically set the width of the component to be the same as the
 * textWidth. Only works for {@link ELEMENTTYPE_TEXT} types.
 * @property {boolean} autoHeight Automatically set the height of the component to be the same as
 * the textHeight. Only works for {@link ELEMENTTYPE_TEXT} types.
 * @property {string} fitMode Set how the content should be fitted and preserve the aspect ratio of
 * the source texture or sprite. Only works for {@link ELEMENTTYPE_IMAGE} types.
 * @property {number} fontAsset The id of the font asset used for rendering the text. Only works
 * for {@link ELEMENTTYPE_TEXT} types.
 * @property {import('../../font/font.js').Font} font The font used for rendering the text. Only
 * works for {@link ELEMENTTYPE_TEXT} types.
 * @property {number} fontSize The size of the font. Only works for {@link ELEMENTTYPE_TEXT} types.
 * @property {boolean} autoFitWidth When true the font size and line height will scale so that the
 * text fits inside the width of the Element. The font size will be scaled between minFontSize and
 * maxFontSize. The value of autoFitWidth will be ignored if autoWidth is true.
 * @property {boolean} autoFitHeight When true the font size and line height will scale so that the
 * text fits inside the height of the Element. The font size will be scaled between minFontSize and
 * maxFontSize. The value of autoFitHeight will be ignored if autoHeight is true.
 * @property {number} minFontSize The minimum size that the font can scale to when autoFitWidth or
 * autoFitHeight are true.
 * @property {number} maxFontSize The maximum size that the font can scale to when autoFitWidth or
 * autoFitHeight are true.
 * @property {number} spacing The spacing between the letters of the text. Only works for
 * {@link ELEMENTTYPE_TEXT} types.
 * @property {number} lineHeight The height of each line of text. Only works for
 * {@link ELEMENTTYPE_TEXT} types.
 * @property {boolean} wrapLines Whether to automatically wrap lines based on the element width.
 * Only works for {@link ELEMENTTYPE_TEXT} types, and when autoWidth is set to false.
 * @property {number} maxLines The maximum number of lines that the Element can wrap to. Any
 * leftover text will be appended to the last line. Set this to null to allow unlimited lines.
 * @property {Vec2} alignment The horizontal and vertical alignment of the text. Values range from
 * 0 to 1 where [0,0] is the bottom left and [1,1] is the top right.  Only works for
 * {@link ELEMENTTYPE_TEXT} types.
 * @property {string} text The text to render. Only works for {@link ELEMENTTYPE_TEXT} types. To
 * override certain text styling properties on a per-character basis, the text can optionally
 * include markup tags contained within square brackets. Supported tags are:
 *
 * 1. `color` - override the element's `color` property. Examples:
 * - `[color="#ff0000"]red text[/color]`
 * - `[color="#00ff00"]green text[/color]`
 * - `[color="#0000ff"]blue text[/color]`
 * 2. `outline` - override the element's `outlineColor` and `outlineThickness` properties. Example:
 * - `[outline color="#ffffff" thickness="0.5"]text[/outline]`
 * 3. `shadow` - override the element's `shadowColor` and `shadowOffset` properties. Examples:
 * - `[shadow color="#ffffff" offset="0.5"]text[/shadow]`
 * - `[shadow color="#000000" offsetX="0.1" offsetY="0.2"]text[/shadow]`
 *
 * Note that markup tags are only processed if the text element's `enableMarkup` property is set to
 * true.
 * @property {string} key The localization key to use to get the localized text from
 * {@link Application#i18n}. Only works for {@link ELEMENTTYPE_TEXT} types.
 * @property {number} textureAsset The id of the texture asset to render. Only works for
 * {@link ELEMENTTYPE_IMAGE} types.
 * @property {import('../../../platform/graphics/texture.js').Texture} texture The texture to
 * render. Only works for {@link ELEMENTTYPE_IMAGE} types.
 * @property {number} spriteAsset The id of the sprite asset to render. Only works for
 * {@link ELEMENTTYPE_IMAGE} types which can render either a texture or a sprite.
 * @property {import('../../../scene/sprite.js').Sprite} sprite The sprite to render. Only works
 * for {@link ELEMENTTYPE_IMAGE} types which can render either a texture or a sprite.
 * @property {number} spriteFrame The frame of the sprite to render. Only works for
 * {@link ELEMENTTYPE_IMAGE} types who have a sprite assigned.
 * @property {number} pixelsPerUnit The number of pixels that map to one PlayCanvas unit. Only
 * works for {@link ELEMENTTYPE_IMAGE} types who have a sliced sprite assigned.
 * @property {number} materialAsset The id of the material asset to use when rendering an image.
 * Only works for {@link ELEMENTTYPE_IMAGE} types.
 * @property {import('../../../scene/materials/material.js').Material} material The material to use
 * when rendering an image. Only works for {@link ELEMENTTYPE_IMAGE} types.
 * @property {Vec4} rect Specifies which region of the texture to use in order to render an image.
 * Values range from 0 to 1 and indicate u, v, width, height. Only works for
 * {@link ELEMENTTYPE_IMAGE} types.
 * @property {boolean} rtlReorder Reorder the text for RTL languages using a function registered
 * by `app.systems.element.registerUnicodeConverter`.
 * @property {boolean} unicodeConverter Convert unicode characters using a function registered by
 * `app.systems.element.registerUnicodeConverter`.
 * @property {boolean} enableMarkup Flag for enabling markup processing. Only works for
 * {@link ELEMENTTYPE_TEXT} types. Defaults to false.
 * @property {number} rangeStart Index of the first character to render. Only works for
 * {@link ELEMENTTYPE_TEXT} types.
 * @property {number} rangeEnd Index of the last character to render. Only works for
 * {@link ELEMENTTYPE_TEXT} types.
 * @property {boolean} mask Switch Image Element into a mask. Masks do not render into the scene,
 * but instead limit child elements to only be rendered where this element is rendered.
 * @augments Component
 * @category User Interface
 */
declare class ElementComponent extends Component {
    /**
     * Fired when the mouse is pressed while the cursor is on the component. Only fired when
     * useInput is true. The handler is passed an {@link ElementMouseEvent}.
     *
     * @event
     * @example
     * entity.element.on('mousedown', (event) => {
     *     console.log(`Mouse down event on entity ${entity.name}`);
     * });
     */
    static EVENT_MOUSEDOWN: string;
    /**
     * Fired when the mouse is released while the cursor is on the component. Only fired when
     * useInput is true. The handler is passed an {@link ElementMouseEvent}.
     *
     * @event
     * @example
     * entity.element.on('mouseup', (event) => {
     *     console.log(`Mouse up event on entity ${entity.name}`);
     * });
     */
    static EVENT_MOUSEUP: string;
    /**
     * Fired when the mouse cursor enters the component. Only fired when useInput is true. The
     * handler is passed an {@link ElementMouseEvent}.
     *
     * @event
     * @example
     * entity.element.on('mouseenter', (event) => {
     *     console.log(`Mouse enter event on entity ${entity.name}`);
     * });
     */
    static EVENT_MOUSEENTER: string;
    /**
     * Fired when the mouse cursor leaves the component. Only fired when useInput is true. The
     * handler is passed an {@link ElementMouseEvent}.
     *
     * @event
     * @example
     * entity.element.on('mouseleave', (event) => {
     *     console.log(`Mouse leave event on entity ${entity.name}`);
     * });
     */
    static EVENT_MOUSELEAVE: string;
    /**
     * Fired when the mouse cursor is moved on the component. Only fired when useInput is true. The
     * handler is passed an {@link ElementMouseEvent}.
     *
     * @event
     * @example
     * entity.element.on('mousemove', (event) => {
     *     console.log(`Mouse move event on entity ${entity.name}`);
     * });
     */
    static EVENT_MOUSEMOVE: string;
    /**
     * Fired when the mouse wheel is scrolled on the component. Only fired when useInput is true.
     * The handler is passed an {@link ElementMouseEvent}.
     *
     * @event
     * @example
     * entity.element.on('mousewheel', (event) => {
     *     console.log(`Mouse wheel event on entity ${entity.name}`);
     * });
     */
    static EVENT_MOUSEWHEEL: string;
    /**
     * Fired when the mouse is pressed and released on the component or when a touch starts and
     * ends on the component. Only fired when useInput is true. The handler is passed an
     * {@link ElementMouseEvent} or {@link ElementTouchEvent}.
     *
     * @event
     * @example
     * entity.element.on('click', (event) => {
     *     console.log(`Click event on entity ${entity.name}`);
     * });
     */
    static EVENT_CLICK: string;
    /**
     * Fired when a touch starts on the component. Only fired when useInput is true. The handler is
     * passed an {@link ElementTouchEvent}.
     *
     * @event
     * @example
     * entity.element.on('touchstart', (event) => {
     *     console.log(`Touch start event on entity ${entity.name}`);
     * });
     */
    static EVENT_TOUCHSTART: string;
    /**
     * Fired when a touch ends on the component. Only fired when useInput is true. The handler is
     * passed an {@link ElementTouchEvent}.
     *
     * @event
     * @example
     * entity.element.on('touchend', (event) => {
     *     console.log(`Touch end event on entity ${entity.name}`);
     * });
     */
    static EVENT_TOUCHEND: string;
    /**
     * Fired when a touch moves after it started touching the component. Only fired when useInput
     * is true. The handler is passed an {@link ElementTouchEvent}.
     *
     * @event
     * @example
     * entity.element.on('touchmove', (event) => {
     *     console.log(`Touch move event on entity ${entity.name}`);
     * });
     */
    static EVENT_TOUCHMOVE: string;
    /**
     * Fired when a touch is canceled on the component. Only fired when useInput is true. The
     * handler is passed an {@link ElementTouchEvent}.
     *
     * @event
     * @example
     * entity.element.on('touchcancel', (event) => {
     *     console.log(`Touch cancel event on entity ${entity.name}`);
     * });
     */
    static EVENT_TOUCHCANCEL: string;
    /**
     * Create a new ElementComponent instance.
     *
     * @param {import('./system.js').ElementComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {Entity} entity - The Entity that this Component is attached to.
     */
    constructor(system: ElementComponentSystem, entity: Entity);

    set alignment(arg: Vec2);
    get alignment(): Vec2;

    set autoFitHeight(arg: boolean);
    get autoFitHeight(): boolean;

    set autoFitWidth(arg: boolean);
    get autoFitWidth(): boolean;

    set autoHeight(arg: boolean);
    get autoHeight(): boolean;

    set autoWidth(arg: boolean);
    get autoWidth(): boolean;

    set color(arg: Color);
    get color(): Color;

    set enableMarkup(arg: boolean);
    get enableMarkup(): boolean;

    set font(arg: Font|CanvasFont);
    get font(): Font|CanvasFont;

    set fontAsset(arg: number);
    get fontAsset(): number;

    set fontSize(arg: number);
    get fontSize(): number;

    set key(arg: string);
    get key(): string;

    set lineHeight(arg: number);
    get lineHeight(): number;

    set mask(arg: boolean);
    get mask(): boolean;

    set material(arg: Material);
    get material(): Material;

    set materialAsset(arg: number);
    get materialAsset(): number;

    set maxFontSize(arg: number);
    get maxFontSize(): number;

    set maxLines(arg: number);
    get maxLines(): number;

    set minFontSize(arg: number);
    get minFontSize(): number;

    set opacity(arg: number);
    get opacity(): number;

    set outlineColor(arg: Color);
    get outlineColor(): Color;

    set outlineThickness(arg: number);
    get outlineThickness(): number;

    set pixelsPerUnit(arg: number);
    get pixelsPerUnit(): number;

    set rangeEnd(arg: number);
    get rangeEnd(): number;

    set rangeStart(arg: number);
    get rangeStart(): number;

    set rect(arg: Vec4);
    get rect(): Vec4;

    set rtlReorder(arg: boolean);
    get rtlReorder(): boolean;

    set shadowColor(arg: Color);
    get shadowColor(): Color;

    set shadowOffset(arg: number);
    get shadowOffset(): number;

    set spacing(arg: number);
    get spacing(): number;

    set sprite(arg: Sprite);
    get sprite(): Sprite;

    set spriteAsset(arg: number);
    get spriteAsset(): number;

    set spriteFrame(arg: number);
    get spriteFrame(): number;

    set text(arg: string);
    get text(): string;

    set texture(arg: Texture);
    get texture(): Texture;

    set textureAsset(arg: number);
    get textureAsset(): number;

    set unicodeConverter(arg: boolean);
    get unicodeConverter(): boolean;

    set wrapLines(arg: boolean);
    get wrapLines(): boolean;

    _beingInitialized: boolean;
    _anchor: Vec4;
    _localAnchor: Vec4;
    _pivot: Vec2;
    _width: number;
    _calculatedWidth: number;
    _height: number;
    _calculatedHeight: number;
    _margin: Vec4;
    _modelTransform: Mat4;
    _screenToWorld: Mat4;
    _anchorTransform: Mat4;
    _anchorDirty: boolean;
    _parentWorldTransform: Mat4;
    _screenTransform: Mat4;
    _screenCorners: Vec3[];
    _canvasCorners: Vec2[];
    _worldCorners: Vec3[];
    _cornersDirty: boolean;
    _canvasCornersDirty: boolean;
    _worldCornersDirty: boolean;
    /**
     * The Entity with a {@link ScreenComponent} that this component belongs to. This is
     * automatically set when the component is a child of a ScreenComponent.
     *
     * @type {Entity|null}
     */
    screen: Entity | null;
    _type: string;
    _image: ImageElement;
    _text: TextElement;
    _group: any;
    _drawOrder: number;
    _fitMode: string;
    _useInput: boolean;
    _layers: number[];
    _addedModels: any[];
    _batchGroupId: number;
    _batchGroup: any;
    _offsetReadAt: number;
    _maskOffset: number;
    _maskedBy: any;
    /**
     * @type {number}
     * @private
     */
    private get _absLeft();
    /**
     * @type {number}
     * @private
     */
    private get _absRight();
    /**
     * @type {number}
     * @private
     */
    private get _absTop();
    /**
     * @type {number}
     * @private
     */
    private get _absBottom();
    /**
     * @type {boolean}
     * @private
     */
    private get _hasSplitAnchorsX();
    /**
     * @type {boolean}
     * @private
     */
    private get _hasSplitAnchorsY();
    get aabb(): any;
    /**
     * Specifies where the left, bottom, right and top edges of the component are anchored relative
     * to its parent. Each value ranges from 0 to 1. e.g. a value of [0, 0, 0, 0] means that the
     * element will be anchored to the bottom left of its parent. A value of [1, 1, 1, 1] means it
     * will be anchored to the top right. A split anchor is when the left-right or top-bottom pairs
     * of the anchor are not equal. In that case the component will be resized to cover that entire
     * area. e.g. a value of [0, 0, 1, 1] will make the component resize exactly as its parent.
     *
     * @example
     * pc.app.root.findByName("Inventory").element.anchor = new pc.Vec4(Math.random() * 0.1, 0, 1, 0);
     * @example
     * pc.app.root.findByName("Inventory").element.anchor = [Math.random() * 0.1, 0, 1, 0];
     *
     * @type {Vec4 | number[]}
     */
    set anchor(arg: Vec4);
    get anchor(): Vec4;
    /**
     * Assign element to a specific batch group (see {@link BatchGroup}). Default is -1 (no group).
     *
     * @type {number}
     */
    set batchGroupId(arg: number);
    get batchGroupId(): number;
    /**
     * The distance from the bottom edge of the anchor. Can be used in combination with a split
     * anchor to make the component's top edge always be 'top' units away from the top.
     *
     * @type {number}
     */
    set bottom(arg: number);
    get bottom(): number;
    /**
     * The width at which the element will be rendered. In most cases this will be the same as
     * `width`. However, in some cases the engine may calculate a different width for the element,
     * such as when the element is under the control of a {@link LayoutGroupComponent}. In these
     * scenarios, `calculatedWidth` may be smaller or larger than the width that was set in the
     * editor.
     *
     * @type {number}
     */
    set calculatedWidth(arg: number);
    get calculatedWidth(): number;
    /**
     * The height at which the element will be rendered. In most cases this will be the same as
     * `height`. However, in some cases the engine may calculate a different height for the element,
     * such as when the element is under the control of a {@link LayoutGroupComponent}. In these
     * scenarios, `calculatedHeight` may be smaller or larger than the height that was set in the
     * editor.
     *
     * @type {number}
     */
    set calculatedHeight(arg: number);
    get calculatedHeight(): number;
    /**
     * An array of 4 {@link Vec2}s that represent the bottom left, bottom right, top right and top
     * left corners of the component in canvas pixels. Only works for screen space element
     * components.
     *
     * @type {Vec2[]}
     */
    get canvasCorners(): Vec2[];
    /**
     * The draw order of the component. A higher value means that the component will be rendered on
     * top of other components.
     *
     * @type {number}
     */
    set drawOrder(arg: number);
    get drawOrder(): number;
    /**
     * The height of the element as set in the editor. Note that in some cases this may not reflect
     * the true height at which the element is rendered, such as when the element is under the
     * control of a {@link LayoutGroupComponent}. See `calculatedHeight` in order to ensure you are
     * reading the true height at which the element will be rendered.
     *
     * @type {number}
     */
    set height(arg: number);
    get height(): number;
    /**
     * An array of layer IDs ({@link Layer#id}) to which this element should belong. Don't push,
     * pop, splice or modify this array, if you want to change it - set a new one instead.
     *
     * @type {number[]}
     */
    set layers(arg: number[]);
    get layers(): number[];
    /**
     * The distance from the left edge of the anchor. Can be used in combination with a split
     * anchor to make the component's left edge always be 'left' units away from the left.
     *
     * @type {number}
     */
    set left(arg: number);
    get left(): number;
    /**
     * The distance from the left, bottom, right and top edges of the anchor. For example if we are
     * using a split anchor like [0,0,1,1] and the margin is [0,0,0,0] then the component will be
     * the same width and height as its parent.
     *
     * @type {Vec4}
     */
    set margin(arg: Vec4);
    get margin(): Vec4;
    /**
     * Get the entity that is currently masking this element.
     *
     * @type {Entity}
     * @private
     */
    private get maskedBy();
    /**
     * The position of the pivot of the component relative to its anchor. Each value ranges from 0
     * to 1 where [0,0] is the bottom left and [1,1] is the top right.
     *
     * @example
     * pc.app.root.findByName("Inventory").element.pivot = [Math.random() * 0.1, Math.random() * 0.1];
     * @example
     * pc.app.root.findByName("Inventory").element.pivot = new pc.Vec2(Math.random() * 0.1, Math.random() * 0.1);
     *
     * @type {Vec2 | number[]}
     */
    set pivot(arg: Vec2);
    get pivot(): Vec2;
    /**
     * The distance from the right edge of the anchor. Can be used in combination with a split
     * anchor to make the component's right edge always be 'right' units away from the right.
     *
     * @type {number}
     */
    set right(arg: number);
    get right(): number;
    /**
     * An array of 4 {@link Vec3}s that represent the bottom left, bottom right, top right and top
     * left corners of the component relative to its parent {@link ScreenComponent}.
     *
     * @type {Vec3[]}
     */
    get screenCorners(): Vec3[];
    /**
     * The width of the text rendered by the component. Only works for {@link ELEMENTTYPE_TEXT} types.
     *
     * @type {number}
     */
    get textWidth(): number;
    /**
     * The height of the text rendered by the component. Only works for {@link ELEMENTTYPE_TEXT} types.
     *
     * @type {number}
     */
    get textHeight(): number;
    /**
     * The distance from the top edge of the anchor. Can be used in combination with a split anchor
     * to make the component's bottom edge always be 'bottom' units away from the bottom.
     *
     * @type {number}
     */
    set top(arg: number);
    get top(): number;
    /**
     * The type of the ElementComponent. Can be:
     *
     * - {@link ELEMENTTYPE_GROUP}: The component can be used as a layout mechanism to create groups of
     * ElementComponents e.g. panels.
     * - {@link ELEMENTTYPE_IMAGE}: The component will render an image
     * - {@link ELEMENTTYPE_TEXT}: The component will render text
     *
     * @type {string}
     */
    set type(arg: string);
    get type(): string;
    /**
     * If true then the component will receive Mouse or Touch input events.
     *
     * @type {boolean}
     */
    set useInput(arg: boolean);
    get useInput(): boolean;
    /**
     * Set how the content should be fitted and preserve the aspect ratio of the source texture or sprite.
     * Only works for {@link ELEMENTTYPE_IMAGE} types. Can be:
     *
     * - {@link FITMODE_STRETCH}: Fit the content exactly to Element's bounding box.
     * - {@link FITMODE_CONTAIN}: Fit the content within the Element's bounding box while preserving its Aspect Ratio.
     * - {@link FITMODE_COVER}: Fit the content to cover the entire Element's bounding box while preserving its Aspect Ratio.
     *
     * @type {string}
     */
    set fitMode(arg: string);
    get fitMode(): string;
    /**
     * The width of the element as set in the editor. Note that in some cases this may not reflect
     * the true width at which the element is rendered, such as when the element is under the
     * control of a {@link LayoutGroupComponent}. See `calculatedWidth` in order to ensure you are
     * reading the true width at which the element will be rendered.
     *
     * @type {number}
     */
    set width(arg: number);
    get width(): number;
    /**
     * An array of 4 {@link Vec3}s that represent the bottom left, bottom right, top right and top
     * left corners of the component in world space. Only works for 3D element components.
     *
     * @type {Vec3[]}
     */
    get worldCorners(): Vec3[];
    _patch(): void;
    _unpatch(): void;
    /**
     * Patched method for setting the position.
     *
     * @param {number|Vec3} x - The x coordinate or Vec3
     * @param {number} y - The y coordinate
     * @param {number} z - The z coordinate
     * @private
     */
    private _setPosition;
    /**
     * Patched method for setting the local position.
     *
     * @param {number|Vec3} x - The x coordinate or Vec3
     * @param {number} y - The y coordinate
     * @param {number} z - The z coordinate
     * @private
     */
    private _setLocalPosition;
    _sync(): void;
    _dirtyLocal: boolean;
    _dirtyWorld: boolean;
    _onInsert(parent: any): void;
    _dirtifyMask(): void;
    _onPrerender(): void;
    _bindScreen(screen: any): void;
    _unbindScreen(screen: any): void;
    _updateScreen(screen: any): void;
    syncMask(depth: any): void;
    _setMaskedBy(mask: any): void;
    _updateMask(currentMask: any, depth: any): void;
    _parseUpToScreen(): {
        screen: any;
        mask: any;
    };
    _onScreenResize(res: any): void;
    _onScreenSpaceChange(): void;
    _onScreenRemove(): void;
    _calculateLocalAnchors(): void;
    getOffsetPosition(x: any, y: any): Vec3;
    onLayersChanged(oldComp: any, newComp: any): void;
    onLayerAdded(layer: any): void;
    onLayerRemoved(layer: any): void;
    onRemove(): void;
    /**
     * Recalculates these properties:
     *   - `_localAnchor`
     *   - `width`
     *   - `height`
     *   - Local position is updated if anchors are split
     *
     * Assumes these properties are up to date:
     *   - `_margin`
     *
     * @param {boolean} propagateCalculatedWidth - If true, call `_setWidth` instead
     * of `_setCalculatedWidth`
     * @param {boolean} propagateCalculatedHeight - If true, call `_setHeight` instead
     * of `_setCalculatedHeight`
     * @private
     */
    private _calculateSize;
    _sizeDirty: boolean;
    /**
     * Internal set width without updating margin.
     *
     * @param {number} w - The new width.
     * @private
     */
    private _setWidth;
    /**
     * Internal set height without updating margin.
     *
     * @param {number} h - The new height.
     * @private
     */
    private _setHeight;
    /**
     * This method sets the calculated width value and optionally updates the margins.
     *
     * @param {number} value - The new calculated width.
     * @param {boolean} updateMargins - Update margins or not.
     * @private
     */
    private _setCalculatedWidth;
    /**
     * This method sets the calculated height value and optionally updates the margins.
     *
     * @param {number} value - The new calculated height.
     * @param {boolean} updateMargins - Update margins or not.
     * @private
     */
    private _setCalculatedHeight;
    _flagChildrenAsDirty(): void;
    addModelToLayers(model: any): void;
    removeModelFromLayers(model: any): void;
    getMaskOffset(): number;
    isVisibleForCamera(camera: any): boolean;
    _isScreenSpace(): boolean;
    _isScreenCulled(): boolean;
    _dirtyBatch(): void;
}

/**
 * Handles mouse and touch events for {@link ElementComponent}s. When input events occur on an
 * ElementComponent this fires the appropriate events on the ElementComponent.
 *
 * @category User Interface
 */
declare class ElementInput {
    static buildHitCorners(element: any, screenOrWorldCorners: any, scale: any): any;
    static calculateScaleToScreen(element: any): Vec3;
    static calculateScaleToWorld(element: any): Vec3;
    /**
     * Create a new ElementInput instance.
     *
     * @param {Element} domElement - The DOM element.
     * @param {object} [options] - Optional arguments.
     * @param {boolean} [options.useMouse] - Whether to allow mouse input. Defaults to true.
     * @param {boolean} [options.useTouch] - Whether to allow touch input. Defaults to true.
     * @param {boolean} [options.useXr] - Whether to allow XR input sources. Defaults to true.
     */
    constructor(domElement: Element, options?: {
        useMouse?: boolean;
        useTouch?: boolean;
        useXr?: boolean;
    });
    _app: any;
    _attached: boolean;
    _target: Element;
    _enabled: boolean;
    _lastX: number;
    _lastY: number;
    _upHandler: any;
    _downHandler: any;
    _moveHandler: any;
    _wheelHandler: any;
    _touchstartHandler: any;
    _touchendHandler: any;
    _touchcancelHandler: any;
    _touchmoveHandler: any;
    _sortHandler: any;
    _elements: any[];
    _hoveredElement: any;
    _pressedElement: any;
    _touchedElements: {};
    _touchesForWhichTouchLeaveHasFired: {};
    _selectedElements: {};
    _selectedPressedElements: {};
    _useMouse: boolean;
    _useTouch: boolean;
    _useXr: boolean;
    _selectEventsAttached: boolean;
    _clickedEntities: {};
    set enabled(arg: boolean);
    get enabled(): boolean;
    set app(arg: any);
    get app(): any;
    /**
     * Attach mouse and touch events to a DOM element.
     *
     * @param {Element} domElement - The DOM element.
     */
    attach(domElement: Element): void;
    attachSelectEvents(): void;
    /**
     * Remove mouse and touch events from the DOM element that it is attached to.
     */
    detach(): void;
    /**
     * Add a {@link ElementComponent} to the internal list of ElementComponents that are being
     * checked for input.
     *
     * @param {import('../components/element/component.js').ElementComponent} element - The
     * ElementComponent.
     */
    addElement(element: ElementComponent): void;
    /**
     * Remove a {@link ElementComponent} from the internal list of ElementComponents that are being
     * checked for input.
     *
     * @param {import('../components/element/component.js').ElementComponent} element - The
     * ElementComponent.
     */
    removeElement(element: ElementComponent): void;
    _handleUp(event: any): void;
    _handleDown(event: any): void;
    _handleMove(event: any): void;
    _handleWheel(event: any): void;
    _determineTouchedElements(event: any): {};
    _handleTouchStart(event: any): void;
    _handleTouchEnd(event: any): void;
    _handleTouchMove(event: any): void;
    _onElementMouseEvent(eventType: any, event: any): void;
    _onXrStart(): void;
    _onXrEnd(): void;
    _onXrUpdate(): void;
    _onXrInputRemove(inputSource: any): void;
    _onSelectStart(inputSource: any, event: any): void;
    _onSelectEnd(inputSource: any, event: any): void;
    _onElementSelectEvent(eventType: any, inputSource: any, event: any): void;
    _fireEvent(name: any, evt: any): void;
    _calcMouseCoords(event: any): void;
    _calcTouchCoords(touch: any): {
        x: number;
        y: number;
    };
    _sortElements(a: any, b: any): any;
    _getTargetElementByCoords(camera: any, x: any, y: any): any;
    _getTargetElementByRay(ray: any, camera: any): any;
    _getTargetElement(camera: any, rayScreen: any, ray3d: any): any;
    _calculateRayScreen(x: any, y: any, camera: any, ray: any): boolean;
    _calculateRay3d(x: any, y: any, camera: any, ray: any): boolean;
    _checkElement(ray: any, element: any, screen: any): number;
}
/**
 * Represents an input event fired on a {@link ElementComponent}. When an event is raised on an
 * ElementComponent it bubbles up to its parent ElementComponents unless we call stopPropagation().
 *
 * @category User Interface
 */
declare class ElementInputEvent {
    /**
     * Create a new ElementInputEvent instance.
     *
     * @param {MouseEvent|TouchEvent} event - The MouseEvent or TouchEvent that was originally
     * raised.
     * @param {import('../components/element/component.js').ElementComponent} element - The
     * ElementComponent that this event was originally raised on.
     * @param {import('../components/camera/component.js').CameraComponent} camera - The
     * CameraComponent that this event was originally raised via.
     */
    constructor(event: MouseEvent | TouchEvent, element: ElementComponent, camera: CameraComponent);
    /**
     * The MouseEvent or TouchEvent that was originally raised.
     *
     * @type {MouseEvent|TouchEvent}
     */
    event: MouseEvent | TouchEvent;
    /**
     * The ElementComponent that this event was originally raised on.
     *
     * @type {import('../components/element/component.js').ElementComponent}
     */
    element: ElementComponent;
    /**
     * The CameraComponent that this event was originally raised via.
     *
     * @type {import('../components/camera/component.js').CameraComponent}
     */
    camera: CameraComponent;
    _stopPropagation: boolean;
    /**
     * Stop propagation of the event to parent {@link ElementComponent}s. This also stops
     * propagation of the event to other event listeners of the original DOM Event.
     */
    stopPropagation(): void;
}
/**
 * Represents a Mouse event fired on a {@link ElementComponent}.
 *
 * @augments ElementInputEvent
 * @category User Interface
 */
declare class ElementMouseEvent extends ElementInputEvent {
    /**
     * Create an instance of an ElementMouseEvent.
     *
     * @param {MouseEvent} event - The MouseEvent that was originally raised.
     * @param {import('../components/element/component.js').ElementComponent} element - The
     * ElementComponent that this event was originally raised on.
     * @param {import('../components/camera/component.js').CameraComponent} camera - The
     * CameraComponent that this event was originally raised via.
     * @param {number} x - The x coordinate.
     * @param {number} y - The y coordinate.
     * @param {number} lastX - The last x coordinate.
     * @param {number} lastY - The last y coordinate.
     */
    constructor(event: MouseEvent, element: ElementComponent, camera: CameraComponent, x: number, y: number, lastX: number, lastY: number);
    x: number;
    y: number;
    /**
     * Whether the ctrl key was pressed.
     *
     * @type {boolean}
     */
    ctrlKey: boolean;
    /**
     * Whether the alt key was pressed.
     *
     * @type {boolean}
     */
    altKey: boolean;
    /**
     * Whether the shift key was pressed.
     *
     * @type {boolean}
     */
    shiftKey: boolean;
    /**
     * Whether the meta key was pressed.
     *
     * @type {boolean}
     */
    metaKey: boolean;
    /**
     * The mouse button.
     *
     * @type {number}
     */
    button: number;
    /**
     * The amount of horizontal movement of the cursor.
     *
     * @type {number}
     */
    dx: number;
    /**
     * The amount of vertical movement of the cursor.
     *
     * @type {number}
     */
    dy: number;
    /**
     * The amount of the wheel movement.
     *
     * @type {number}
     */
    wheelDelta: number;
}
/**
 * Represents a XRInputSourceEvent fired on a {@link ElementComponent}.
 *
 * @augments ElementInputEvent
 * @category User Interface
 */
declare class ElementSelectEvent extends ElementInputEvent {
    /**
     * Create an instance of a ElementSelectEvent.
     *
     * @param {object} event - The XRInputSourceEvent that was originally raised.
     * @param {import('../components/element/component.js').ElementComponent} element - The
     * ElementComponent that this event was originally raised on.
     * @param {import('../components/camera/component.js').CameraComponent} camera - The
     * CameraComponent that this event was originally raised via.
     * @param {import('../xr/xr-input-source.js').XrInputSource} inputSource - The XR input source
     * that this event was originally raised from.
     */
    constructor(event: object, element: ElementComponent, camera: CameraComponent, inputSource: XrInputSource);
    /**
     * The XR input source that this event was originally raised from.
     *
     * @type {import('../xr/xr-input-source.js').XrInputSource}
     */
    inputSource: XrInputSource;
}
/**
 * Represents a TouchEvent fired on a {@link ElementComponent}.
 *
 * @augments ElementInputEvent
 * @category User Interface
 */
declare class ElementTouchEvent extends ElementInputEvent {
    /**
     * Create an instance of an ElementTouchEvent.
     *
     * @param {TouchEvent} event - The TouchEvent that was originally raised.
     * @param {import('../components/element/component.js').ElementComponent} element - The
     * ElementComponent that this event was originally raised on.
     * @param {import('../components/camera/component.js').CameraComponent} camera - The
     * CameraComponent that this event was originally raised via.
     * @param {number} x - The x coordinate of the touch that triggered the event.
     * @param {number} y - The y coordinate of the touch that triggered the event.
     * @param {Touch} touch - The touch object that triggered the event.
     */
    constructor(event: TouchEvent, element: ElementComponent, camera: CameraComponent, x: number, y: number, touch: Touch);
    /**
     * The Touch objects representing all current points of contact with the surface,
     * regardless of target or changed status.
     *
     * @type {Touch[]}
     */
    touches: Touch[];
    /**
     * The Touch objects representing individual points of contact whose states changed between
     * the previous touch event and this one.
     *
     * @type {Touch[]}
     */
    changedTouches: Touch[];
    x: number;
    y: number;
    /**
     * The touch object that triggered the event.
     *
     * @type {Touch}
     */
    touch: Touch;
}

/**
 * Input handler for accessing GamePad input.
 *
 * @augments EventHandler
 * @category Input
 */
declare class GamePads extends EventHandler {
    /**
     * Fired when a gamepad is connected. The handler is passed the {@link GamePad} object that was
     * connected.
     *
     * @event
     * @example
     * const onPadConnected = (pad) => {
     *     if (!pad.mapping) {
     *         // Map the gamepad as the system could not find the proper map.
     *     } else {
     *         // Make the gamepad pulse.
     *     }
     * };
     *
     * app.keyboard.on("gamepadconnected", onPadConnected, this);
     */
    static EVENT_GAMEPADCONNECTED: string;
    /**
     * Fired when a gamepad is disconnected. The handler is passed the {@link GamePad} object that
     * was disconnected.
     *
     * @event
     * @example
     * const onPadDisconnected = (pad) => {
     *     // Pause the game.
     * };
     *
     * app.keyboard.on("gamepaddisconnected", onPadDisconnected, this);
     */
    static EVENT_GAMEPADDISCONNECTED: string;
    /**
     * Whether gamepads are supported by this device.
     *
     * @type {boolean}
     */
    gamepadsSupported: boolean;
    /**
     * The list of current gamepads.
     *
     * @type {GamePad[]}
     */
    current: GamePad[];
    /**
     * The list of previous buttons states
     *
     * @type {boolean[][]}
     * @ignore
     */
    _previous: boolean[][];
    _ongamepadconnectedHandler: any;
    _ongamepaddisconnectedHandler: any;
    /**
     * Threshold for axes to return values. Must be between 0 and 1.
     *
     * @type {number}
     * @ignore
     */
    set deadZone(arg: number);
    get deadZone(): number;
    /**
     * The list of previous buttons states.
     *
     * @type {boolean[][]}
     * @ignore
     */
    get previous(): boolean[][];
    /**
     * Callback function when a gamepad is connecting.
     *
     * @param {GamepadEvent} event - The event containing the connecting gamepad.
     * @private
     */
    private _ongamepadconnected;
    /**
     * Callback function when a gamepad is disconnecting.
     *
     * @param {GamepadEvent} event - The event containing the disconnecting gamepad.
     * @private
     */
    private _ongamepaddisconnected;
    /**
     * Update the previous state of the gamepads. This must be called every frame for
     * `wasPressed` and `wasTouched` to work.
     *
     * @ignore
     */
    update(): void;
    /**
     * Poll for the latest data from the gamepad API.
     *
     * @param {GamePad[]} [pads] - An optional array used to receive the gamepads mapping. This
     * array will be returned by this function.
     * @returns {GamePad[]} An array of gamepads and mappings for the model of gamepad that is
     * attached.
     * @example
     * const gamepads = new pc.GamePads();
     * const pads = gamepads.poll();
     */
    poll(pads?: GamePad[]): GamePad[];
    /**
     * Destroy the event listeners.
     *
     * @ignore
     */
    destroy(): void;
    /**
     * Retrieve the order for buttons and axes for given HTML5 Gamepad.
     *
     * @param {Gamepad} pad - The HTML5 Gamepad object.
     * @returns {object} Object defining the order of buttons and axes for given HTML5 Gamepad.
     */
    getMap(pad: Gamepad): object;
    /**
     * Returns true if the button on the pad requested is pressed.
     *
     * @param {number} orderIndex - The order index of the pad to check, use constants {@link PAD_1}, {@link PAD_2}, etc. For gamepad index call the function from the pad.
     * @param {number} button - The button to test, use constants {@link PAD_FACE_1}, etc.
     * @returns {boolean} True if the button is pressed.
     */
    isPressed(orderIndex: number, button: number): boolean;
    /**
     * Returns true if the button was pressed since the last frame.
     *
     * @param {number} orderIndex - The index of the pad to check, use constants {@link PAD_1}, {@link PAD_2}, etc. For gamepad index call the function from the pad.
     * @param {number} button - The button to test, use constants {@link PAD_FACE_1}, etc.
     * @returns {boolean} True if the button was pressed since the last frame.
     */
    wasPressed(orderIndex: number, button: number): boolean;
    /**
     * Returns true if the button was released since the last frame.
     *
     * @param {number} orderIndex - The index of the pad to check, use constants {@link PAD_1}, {@link PAD_2}, etc. For gamepad index call the function from the pad.
     * @param {number} button - The button to test, use constants {@link PAD_FACE_1}, etc.
     * @returns {boolean} True if the button was released since the last frame.
     */
    wasReleased(orderIndex: number, button: number): boolean;
    /**
     * Get the value of one of the analog axes of the pad.
     *
     * @param {number} orderIndex - The index of the pad to check, use constants {@link PAD_1}, {@link PAD_2}, etc. For gamepad index call the function from the pad.
     * @param {number} axis - The axis to get the value of, use constants {@link PAD_L_STICK_X}, etc.
     * @returns {number} The value of the axis between -1 and 1.
     */
    getAxis(orderIndex: number, axis: number): number;
    /**
     * Make the gamepad vibrate.
     *
     * @param {number} orderIndex - The index of the pad to check, use constants {@link PAD_1}, {@link PAD_2}, etc. For gamepad index call the function from the pad.
     * @param {number} intensity - Intensity for the vibration in the range 0 to 1.
     * @param {number} duration - Duration for the vibration in milliseconds.
     * @param {object} [options] - Options for special vibration pattern.
     * @param {number} [options.startDelay] - Delay before the pattern starts, in milliseconds. Defaults to 0.
     * @param {number} [options.strongMagnitude] - Intensity for strong actuators in the range 0 to 1. Defaults to intensity.
     * @param {number} [options.weakMagnitude] - Intensity for weak actuators in the range 0 to 1. Defaults to intensity.
     * @returns {Promise<boolean>} Return a Promise resulting in true if the pulse was successfully completed.
     */
    pulse(orderIndex: number, intensity: number, duration: number, options?: {
        startDelay?: number;
        strongMagnitude?: number;
        weakMagnitude?: number;
    }): Promise<boolean>;
    /**
     * Make all gamepads vibrate.
     *
     * @param {number} intensity - Intensity for the vibration in the range 0 to 1.
     * @param {number} duration - Duration for the vibration in milliseconds.
     * @param {object} [options] - Options for special vibration pattern.
     * @param {number} [options.startDelay] - Delay before the pattern starts, in milliseconds. Defaults to 0.
     * @param {number} [options.strongMagnitude] - Intensity for strong actuators in the range 0 to 1. Defaults to intensity.
     * @param {number} [options.weakMagnitude] - Intensity for weak actuators in the range 0 to 1. Defaults to intensity.
     * @returns {Promise<boolean[]>} Return a Promise resulting in an array of booleans defining if the pulse was successfully completed for every gamepads.
     */
    pulseAll(intensity: number, duration: number, options?: {
        startDelay?: number;
        strongMagnitude?: number;
        weakMagnitude?: number;
    }): Promise<boolean[]>;
    /**
     * Find a connected {@link GamePad} from its identifier.
     *
     * @param {string} id - The identifier to search for.
     * @returns {GamePad|null} The {@link GamePad} with the matching identifier or null if no gamepad is found or the gamepad is not connected.
     */
    findById(id: string): GamePad | null;
    /**
     * Find a connected {@link GamePad} from its device index.
     *
     * @param {number} index - The device index to search for.
     * @returns {GamePad|null} The {@link GamePad} with the matching device index or null if no gamepad is found or the gamepad is not connected.
     */
    findByIndex(index: number): GamePad | null;
}
/**
 * A GamePad stores information about a gamepad from the Gamepad API.
 *
 * @category Input
 */
declare class GamePad {
    /**
     * Create a new GamePad Instance.
     *
     * @param {Gamepad} gamepad - The original Gamepad API gamepad.
     * @param {object} map - The buttons and axes map.
     * @hideconstructor
     */
    constructor(gamepad: Gamepad, map: object);
    /**
     * The compiled mapping to reduce lookup delay when retrieving buttons
     *
     * @type {object}
     * @private
     */
    private _compiledMapping;
    /**
     * The identifier for the gamepad. Its structure depends on device.
     *
     * @type {string}
     */
    id: string;
    /**
     * The index for this controller. A gamepad that is disconnected and reconnected will retain the same index.
     *
     * @type {number}
     */
    index: number;
    /**
     * The buttons present on the GamePad. Order is provided by API, use GamePad#buttons instead.
     *
     * @type {GamePadButton[]}
     * @ignore
     */
    _buttons: GamePadButton[];
    /**
     * The axes values from the GamePad. Order is provided by API, use GamePad#axes instead.
     *
     * @type {number[]}
     * @ignore
     */
    _axes: number[];
    /**
     * Previous value for the analog axes present on the gamepad. Values are between -1 and 1.
     *
     * @type {number[]}
     * @ignore
     */
    _previousAxes: number[];
    /**
     * The gamepad mapping detected by the browser. Value is either "standard", "xr-standard", "" or "custom". When empty string, you may need to update the mapping yourself. "custom" means you updated the mapping.
     *
     * @type {string}
     */
    mapping: string;
    /**
     * The buttons and axes map.
     *
     * @type {object}
     */
    map: object;
    /**
     * The hand this gamepad is usually handled on. Only relevant for XR pads. Value is either "left", "right" or "none".
     *
     * @type {string}
     */
    hand: string;
    /**
     * The original Gamepad API gamepad.
     *
     * @type {Gamepad}
     * @ignore
     */
    pad: Gamepad;
    /**
     * Whether the gamepad is connected.
     *
     * @type {boolean}
     */
    get connected(): boolean;
    /**
     * Compile the buttons mapping to reduce lookup delay.
     *
     * @private
     */
    private _compileMapping;
    /**
     * Update the existing GamePad Instance.
     *
     * @param {Gamepad} gamepad - The original Gamepad API gamepad.
     * @ignore
     */
    update(gamepad: Gamepad): this;
    /**
     * Update the map for this gamepad.
     *
     * @param {object} map - The new mapping for this gamepad.
     * @param {string[]} map.buttons - Buttons mapping for this gamepad.
     * @param {string[]} map.axes - Axes mapping for this gamepad.
     * @param {object} [map.synthesizedButtons] - Information about buttons to pull from axes for this gamepad. Requires definition of axis index, min value and max value.
     * @param {"custom"} [map.mapping] - New mapping format. Will be forced into "custom".
     * @example
     * this.pad.updateMap({
     *     buttons: [[
     *         'PAD_FACE_1',
     *         'PAD_FACE_2',
     *         'PAD_FACE_3',
     *         'PAD_FACE_4',
     *         'PAD_L_SHOULDER_1',
     *         'PAD_R_SHOULDER_1',
     *         'PAD_L_SHOULDER_2',
     *         'PAD_R_SHOULDER_2',
     *         'PAD_SELECT',
     *         'PAD_START',
     *         'PAD_L_STICK_BUTTON',
     *         'PAD_R_STICK_BUTTON',
     *         'PAD_VENDOR'
     *     ],
     *     axes: [
     *         'PAD_L_STICK_X',
     *         'PAD_L_STICK_Y',
     *         'PAD_R_STICK_X',
     *         'PAD_R_STICK_Y'
     *     ],
     *     synthesizedButtons: {
     *         PAD_UP: { axis: 0, min: 0, max: 1 },
     *         PAD_DOWN: { axis: 0, min: -1, max: 0 },
     *         PAD_LEFT: { axis: 0, min: -1, max: 0 },
     *         PAD_RIGHT: { axis: 0, min: 0, max: 1 }
     *     }
     * });
     */
    updateMap(map: {
        buttons: string[];
        axes: string[];
        synthesizedButtons?: object;
        mapping?: "custom";
    }): void;
    /**
     * Reset gamepad mapping to default.
     */
    resetMap(): void;
    /**
     * The values from analog axes present on the GamePad. Values are between -1 and 1.
     *
     * @type {number[]}
     */
    get axes(): number[];
    /**
     * The buttons present on the GamePad.
     *
     * @type {GamePadButton[]}
     */
    get buttons(): GamePadButton[];
    /**
     * Make the gamepad vibrate.
     *
     * @param {number} intensity - Intensity for the vibration in the range 0 to 1.
     * @param {number} duration - Duration for the vibration in milliseconds.
     * @param {object} [options] - Options for special vibration pattern.
     * @param {number} [options.startDelay] - Delay before the pattern starts, in milliseconds. Defaults to 0.
     * @param {number} [options.strongMagnitude] - Intensity for strong actuators in the range 0 to 1. Defaults to intensity.
     * @param {number} [options.weakMagnitude] - Intensity for weak actuators in the range 0 to 1. Defaults to intensity.
     * @returns {Promise<boolean>} Return a Promise resulting in true if the pulse was successfully completed.
     */
    pulse(intensity: number, duration: number, options?: {
        startDelay?: number;
        strongMagnitude?: number;
        weakMagnitude?: number;
    }): Promise<boolean>;
    /**
     * Retrieve a button from its index.
     *
     * @param {number} index - The index to return the button for.
     * @returns {GamePadButton} The button for the searched index. May be a placeholder if none found.
     */
    getButton(index: number): GamePadButton;
    /**
     * Returns true if the button is pressed.
     *
     * @param {number} button - The button to test, use constants {@link PAD_FACE_1}, etc.
     * @returns {boolean} True if the button is pressed.
     */
    isPressed(button: number): boolean;
    /**
     * Return true if the button was pressed since the last update.
     *
     * @param {number} button - The button to test, use constants {@link PAD_FACE_1}, etc.
     * @returns {boolean} Return true if the button was pressed, false if not.
     */
    wasPressed(button: number): boolean;
    /**
     * Return true if the button was released since the last update.
     *
     * @param {number} button - The button to test, use constants {@link PAD_FACE_1}, etc.
     * @returns {boolean} Return true if the button was released, false if not.
     */
    wasReleased(button: number): boolean;
    /**
     * Returns true if the button is touched.
     *
     * @param {number} button - The button to test, use constants {@link PAD_FACE_1}, etc.
     * @returns {boolean} True if the button is touched.
     */
    isTouched(button: number): boolean;
    /**
     * Return true if the button was touched since the last update.
     *
     * @param {number} button - The button to test, use constants {@link PAD_FACE_1}, etc.
     * @returns {boolean} Return true if the button was touched, false if not.
     */
    wasTouched(button: number): boolean;
    /**
     * Returns the value of a button between 0 and 1, with 0 representing a button that is not pressed, and 1 representing a button that is fully pressed.
     *
     * @param {number} button - The button to retrieve, use constants {@link PAD_FACE_1}, etc.
     * @returns {number} The value of the button between 0 and 1.
     */
    getValue(button: number): number;
    /**
     * Get the value of one of the analog axes of the pad.
     *
     * @param {number} axis - The axis to get the value of, use constants {@link PAD_L_STICK_X}, etc.
     * @returns {number} The value of the axis between -1 and 1.
     */
    getAxis(axis: number): number;
}
/**
 * A GamePadButton stores information about a button from the Gamepad API.
 *
 * @category Input
 */
declare class GamePadButton {
    /**
     * Create a new GamePadButton instance.
     *
     * @param {number|GamepadButton} current - The original Gamepad API gamepad button.
     * @param {number|GamepadButton} [previous] - The previous Gamepad API gamepad button.
     * @hideconstructor
     */
    constructor(current: number | GamepadButton, previous?: number | GamepadButton);
    /**
     * The value for the button between 0 and 1, with 0 representing a button that is not pressed, and 1 representing a button that is fully pressed.
     *
     * @type {number}
     */
    value: number;
    /**
     * Whether the button is currently down.
     *
     * @type {boolean}
     */
    pressed: boolean;
    /**
     * Whether the button is currently touched.
     *
     * @type {boolean}
     */
    touched: boolean;
    /**
     * Whether the button was pressed.
     *
     * @type {boolean}
     */
    wasPressed: boolean;
    /**
     * Whether the button was released since the last update.
     *
     * @type {boolean}
     */
    wasReleased: boolean;
    /**
     * Whether the button was touched since the last update.
     *
     * @type {boolean}
     */
    wasTouched: boolean;
    /**
     * Update the existing GamePadButton Instance.
     *
     * @param {GamepadButton} button - The original Gamepad API gamepad button.
     * @ignore
     */
    update(button: GamepadButton): void;
}

/**
 * Attach a TouchDevice to an element and it will receive and fire events when the element is
 * touched. See also {@link Touch} and {@link TouchEvent}.
 *
 * @augments EventHandler
 * @category Input
 */
declare class TouchDevice extends EventHandler {
    /**
     * Create a new touch device and attach it to an element.
     *
     * @param {Element} element - The element to attach listen for events on.
     */
    constructor(element: Element);
    _element: Element;
    _startHandler: any;
    _endHandler: any;
    _moveHandler: any;
    _cancelHandler: any;
    /**
     * Attach a device to an element in the DOM. If the device is already attached to an element
     * this method will detach it first.
     *
     * @param {Element} element - The element to attach to.
     */
    attach(element: Element): void;
    /**
     * Detach a device from the element it is attached to.
     */
    detach(): void;
    _handleTouchStart(e: any): void;
    _handleTouchEnd(e: any): void;
    _handleTouchMove(e: any): void;
    _handleTouchCancel(e: any): void;
}

/**
 * Callback used by {@link MouseenablePointerLock } and {@link ApplicationdisablePointerLock }.
 */
export type LockMouseCallback = () => any;
/**
 * Callback used by {@link Mouse#enablePointerLock} and {@link Application#disablePointerLock}.
 *
 * @callback LockMouseCallback
 */
/**
 * A Mouse Device, bound to a DOM Element.
 *
 * @augments EventHandler
 * @category Input
 */
declare class Mouse extends EventHandler {
    /**
     * Fired when the mouse is moved. The handler is passed a {@link MouseEvent}.
     *
     * @event
     * @example
     * app.mouse.on('mousemove', (e) => {
     *     console.log(`Current mouse position is: ${e.x}, ${e.y}`);
     * });
     */
    static EVENT_MOUSEMOVE: string;
    /**
     * Fired when a mouse button is pressed. The handler is passed a {@link MouseEvent}.
     *
     * @event
     * @example
     * app.mouse.on('mousedown', (e) => {
     *     console.log(`The ${e.button} button was pressed at position: ${e.x}, ${e.y}`);
     * });
     */
    static EVENT_MOUSEDOWN: string;
    /**
     * Fired when a mouse button is released. The handler is passed a {@link MouseEvent}.
     *
     * @event
     * @example
     * app.mouse.on('mouseup', (e) => {
     *     console.log(`The ${e.button} button was released at position: ${e.x}, ${e.y}`);
     * });
     */
    static EVENT_MOUSEUP: string;
    /**
     * Fired when a mouse wheel is moved. The handler is passed a {@link MouseEvent}.
     *
     * @event
     * @example
     * app.mouse.on('mousewheel', (e) => {
     *     console.log(`The mouse wheel was moved by ${e.wheelDelta}`);
     * });
     */
    static EVENT_MOUSEWHEEL: string;
    /**
     * Check if the mouse pointer has been locked, using {@link Mouse#enablePointerLock}.
     *
     * @returns {boolean} True if locked.
     */
    static isPointerLocked(): boolean;
    /**
     * Create a new Mouse instance.
     *
     * @param {Element} [element] - The Element that the mouse events are attached to.
     */
    constructor(element?: Element);
    _lastX: number;
    _lastY: number;
    _buttons: boolean[];
    _lastbuttons: boolean[];
    _upHandler: any;
    _downHandler: any;
    _moveHandler: any;
    _wheelHandler: any;
    _contextMenuHandler: (event: any) => void;
    _target: Element;
    _attached: boolean;
    /**
     * Attach mouse events to an Element.
     *
     * @param {Element} element - The DOM element to attach the mouse to.
     */
    attach(element: Element): void;
    /**
     * Remove mouse events from the element that it is attached to.
     */
    detach(): void;
    /**
     * Disable the context menu usually activated with right-click.
     */
    disableContextMenu(): void;
    /**
     * Enable the context menu usually activated with right-click. This option is active by
     * default.
     */
    enableContextMenu(): void;
    /**
     * Request that the browser hides the mouse cursor and locks the mouse to the element. Allowing
     * raw access to mouse movement input without risking the mouse exiting the element. Notes:
     *
     * - In some browsers this will only work when the browser is running in fullscreen mode. See
     * {@link https://developer.mozilla.org/en-US/docs/Web/API/Fullscreen_API Fullscreen API} for
     * more details.
     * - Enabling pointer lock can only be initiated by a user action e.g. in the event handler for
     * a mouse or keyboard input.
     *
     * @param {LockMouseCallback} [success] - Function called if the request for mouse lock is
     * successful.
     * @param {LockMouseCallback} [error] - Function called if the request for mouse lock is
     * unsuccessful.
     */
    enablePointerLock(success?: LockMouseCallback, error?: LockMouseCallback): void;
    /**
     * Return control of the mouse cursor to the user.
     *
     * @param {LockMouseCallback} [success] - Function called when the mouse lock is disabled.
     */
    disablePointerLock(success?: LockMouseCallback): void;
    /**
     * Update method, should be called once per frame.
     */
    update(): void;
    /**
     * Returns true if the mouse button is currently pressed.
     *
     * @param {number} button - The mouse button to test. Can be:
     *
     * - {@link MOUSEBUTTON_LEFT}
     * - {@link MOUSEBUTTON_MIDDLE}
     * - {@link MOUSEBUTTON_RIGHT}
     *
     * @returns {boolean} True if the mouse button is current pressed.
     */
    isPressed(button: number): boolean;
    /**
     * Returns true if the mouse button was pressed this frame (since the last call to update).
     *
     * @param {number} button - The mouse button to test. Can be:
     *
     * - {@link MOUSEBUTTON_LEFT}
     * - {@link MOUSEBUTTON_MIDDLE}
     * - {@link MOUSEBUTTON_RIGHT}
     *
     * @returns {boolean} True if the mouse button was pressed since the last update.
     */
    wasPressed(button: number): boolean;
    /**
     * Returns true if the mouse button was released this frame (since the last call to update).
     *
     * @param {number} button - The mouse button to test. Can be:
     *
     * - {@link MOUSEBUTTON_LEFT}
     * - {@link MOUSEBUTTON_MIDDLE}
     * - {@link MOUSEBUTTON_RIGHT}
     *
     * @returns {boolean} True if the mouse button was released since the last update.
     */
    wasReleased(button: number): boolean;
    _handleUp(event: any): void;
    _handleDown(event: any): void;
    _handleMove(event: any): void;
    _handleWheel(event: any): void;
    _getTargetCoords(event: any): {
        x: number;
        y: number;
    };
}

/**
 * A Keyboard device bound to an Element. Allows you to detect the state of the key presses. Note
 * that the Keyboard object must be attached to an Element before it can detect any key presses.
 *
 * @augments EventHandler
 * @category Input
 */
declare class Keyboard extends EventHandler {
    /**
     * Fired when a key is pressed. The handler is passed a {@link KeyboardEvent}.
     *
     * @event
     * @example
     * const onKeyDown = (e) => {
     *     if (e.key === pc.KEY_SPACE) {
     *         // space key pressed
     *     }
     *     e.event.preventDefault(); // Use original browser event to prevent browser action.
     * };
     *
     * app.keyboard.on("keydown", onKeyDown, this);
     */
    static EVENT_KEYDOWN: string;
    /**
     * Fired when a key is released. The handler is passed a {@link KeyboardEvent}.
     *
     * @event
     * @example
     * const onKeyUp = (e) => {
     *     if (e.key === pc.KEY_SPACE) {
     *         // space key released
     *     }
     *     e.event.preventDefault(); // Use original browser event to prevent browser action.
     * };
     *
     * app.keyboard.on("keyup", onKeyUp, this);
     */
    static EVENT_KEYUP: string;
    /**
     * Create a new Keyboard instance.
     *
     * @param {Element|Window} [element] - Element to attach Keyboard to. Note that elements like
     * &lt;div&gt; can't accept focus by default. To use keyboard events on an element like this it
     * must have a value of 'tabindex' e.g. tabindex="0". See
     * [here](https://www.w3.org/WAI/GL/WCAG20/WD-WCAG20-TECHS/SCR29.html) for more details.
     * @param {object} [options] - Optional options object.
     * @param {boolean} [options.preventDefault] - Call preventDefault() in key event handlers.
     * This stops the default action of the event occurring. e.g. Ctrl+T will not open a new
     * browser tab.
     * @param {boolean} [options.stopPropagation] - Call stopPropagation() in key event handlers.
     * This stops the event bubbling up the DOM so no parent handlers will be notified of the
     * event.
     * @example
     * // attach keyboard listeners to the window
     * const keyboard = new pc.Keyboard(window);
     */
    constructor(element?: Element | Window, options?: {
        preventDefault?: boolean;
        stopPropagation?: boolean;
    });
    _element: Element | Window;
    _keyDownHandler: any;
    _keyUpHandler: any;
    _keyPressHandler: any;
    _visibilityChangeHandler: any;
    _windowBlurHandler: any;
    _keymap: {};
    _lastmap: {};
    preventDefault: boolean;
    stopPropagation: boolean;
    /**
     * Attach the keyboard event handlers to an Element.
     *
     * @param {Element|Window} element - The element to listen for keyboard events on.
     */
    attach(element: Element | Window): void;
    /**
     * Detach the keyboard event handlers from the element it is attached to.
     */
    detach(): void;
    /**
     * Convert a key code into a key identifier.
     *
     * @param {number} keyCode - The key code.
     * @returns {string} The key identifier.
     * @private
     */
    private toKeyIdentifier;
    /**
     * Process the browser keydown event.
     *
     * @param {globalThis.KeyboardEvent} event - The browser keyboard event.
     * @private
     */
    private _handleKeyDown;
    /**
     * Process the browser keyup event.
     *
     * @param {globalThis.KeyboardEvent} event - The browser keyboard event.
     * @private
     */
    private _handleKeyUp;
    /**
     * Process the browser keypress event.
     *
     * @param {globalThis.KeyboardEvent} event - The browser keyboard event.
     * @private
     */
    private _handleKeyPress;
    /**
     * Handle the browser visibilitychange event.
     *
     * @private
     */
    private _handleVisibilityChange;
    /**
     * Handle the browser blur event.
     *
     * @private
     */
    private _handleWindowBlur;
    /**
     * Called once per frame to update internal state.
     *
     * @ignore
     */
    update(): void;
    /**
     * Return true if the key is currently down.
     *
     * @param {number} key - The keyCode of the key to test. See the KEY_* constants.
     * @returns {boolean} True if the key was pressed, false if not.
     */
    isPressed(key: number): boolean;
    /**
     * Returns true if the key was pressed since the last update.
     *
     * @param {number} key - The keyCode of the key to test. See the KEY_* constants.
     * @returns {boolean} True if the key was pressed.
     */
    wasPressed(key: number): boolean;
    /**
     * Returns true if the key was released since the last update.
     *
     * @param {number} key - The keyCode of the key to test. See the KEY_* constants.
     * @returns {boolean} True if the key was pressed.
     */
    wasReleased(key: number): boolean;
}

declare class ShadowMapCache {
    cache: Map<any, any>;
    destroy(): void;
    clear(): void;
    getKey(light: any): string;
    get(device: any, light: any): any;
    add(light: any, shadowMap: any): void;
}

/**
 * Callback used by {@link ResourceHandlerload } when a resource is loaded (or an error occurs).
 */
export type ResourceHandlerCallback = (err: string | null, response?: any) => any;
/**
 * Callback used by {@link ResourceHandler#load} when a resource is loaded (or an error occurs).
 *
 * @callback ResourceHandlerCallback
 * @param {string|null} err - The error message in the case where the load fails.
 * @param {*} [response] - The raw data that has been successfully loaded.
 */
/**
 * Base class for ResourceHandlers used by {@link ResourceLoader}.
 */
declare class ResourceHandler {
    /**
     * @param {import('../app-base').AppBase} app - The running {@link AppBase}.
     * @param {string} handlerType - The type of the resource the handler handles.
     */
    constructor(app: AppBase, handlerType: string);
    /**
     * Type of the resource the handler handles.
     *
     * @type {string}
     */
    handlerType: string;
    /**
     * The running app instance.
     *
     * @type {import('../app-base').AppBase}
     */
    _app: AppBase;
    /** @private */
    private _maxRetries;
    /**
     * The number of times to retry a failed request for the resource.
     *
     * @type {number}
     */
    set maxRetries(arg: number);
    get maxRetries(): number;
    /**
     * Load a resource from a remote URL. The base implementation does nothing.
     *
     * @param {string|object} url - Either the URL of the resource to load or a structure
     * containing the load and original URL.
     * @param {string} [url.load] - The URL to be used for loading the resource.
     * @param {string} [url.original] - The original URL to be used for identifying the resource
     * format. This is necessary when loading, for example from blob.
     * @param {ResourceHandlerCallback} callback - The callback used when the resource is loaded or
     * an error occurs.
     * @param {import('../asset/asset.js').Asset} [asset] - Optional asset that is passed by
     * ResourceLoader.
     */
    load(url: string | object, callback: ResourceHandlerCallback, asset?: Asset): void;
    /**
     * The open function is passed the raw resource data. The handler can then process the data
     * into a format that can be used at runtime. The base implementation simply returns the data.
     *
     * @param {string} url - The URL of the resource to open.
     * @param {*} data - The raw resource data passed by callback from {@link ResourceHandler#load}.
     * @param {import('../asset/asset.js').Asset} [asset] - Optional asset that is passed by
     * ResourceLoader.
     * @returns {*} The parsed resource data.
     */
    open(url: string, data: any, asset?: Asset): any;
    /**
     * The patch function performs any operations on a resource that requires a dependency on its
     * asset data or any other asset data. The base implementation does nothing.
     *
     * @param {import('../asset/asset.js').Asset} asset - The asset to patch.
     * @param {import('../asset/asset-registry.js').AssetRegistry} assets - The asset registry.
     */
    patch(asset: Asset, assets: AssetRegistry): void;
}

/**
 * Callback used by {@link ResourceLoaderload } when a resource is loaded (or an error occurs).
 */
export type ResourceLoaderCallback = (err: string | null, resource?: any) => any;
/**
 * Callback used by {@link ResourceLoader#load} when a resource is loaded (or an error occurs).
 *
 * @callback ResourceLoaderCallback
 * @param {string|null} err - The error message in the case where the load fails.
 * @param {*} [resource] - The resource that has been successfully loaded.
 */
/**
 * Load resource data, potentially from remote sources. Caches resource on load to prevent multiple
 * requests. Add ResourceHandlers to handle different types of resources.
 */
declare class ResourceLoader {
    static makeKey(url: any, type: any): string;
    /**
     * Create a new ResourceLoader instance.
     *
     * @param {import('../app-base.js').AppBase} app - The application.
     */
    constructor(app: AppBase);
    _handlers: {};
    _requests: {};
    _cache: {};
    _app: AppBase;
    /**
     * Add a {@link ResourceHandler} for a resource type. Handler should support at least `load()`
     * and `open()`. Handlers can optionally support patch(asset, assets) to handle dependencies on
     * other assets.
     *
     * @param {string} type - The name of the resource type that the handler will be registered
     * with. Can be:
     *
     * - {@link ASSET_ANIMATION}
     * - {@link ASSET_AUDIO}
     * - {@link ASSET_IMAGE}
     * - {@link ASSET_JSON}
     * - {@link ASSET_MODEL}
     * - {@link ASSET_MATERIAL}
     * - {@link ASSET_TEXT}
     * - {@link ASSET_TEXTURE}
     * - {@link ASSET_CUBEMAP}
     * - {@link ASSET_SHADER}
     * - {@link ASSET_CSS}
     * - {@link ASSET_HTML}
     * - {@link ASSET_SCRIPT}
     * - {@link ASSET_CONTAINER}
     *
     * @param {import('./handler.js').ResourceHandler} handler - An instance of a resource handler
     * supporting at least `load()` and `open()`.
     * @example
     * const loader = new ResourceLoader();
     * loader.addHandler("json", new pc.JsonHandler());
     */
    addHandler(type: string, handler: ResourceHandler): void;
    /**
     * Remove a {@link ResourceHandler} for a resource type.
     *
     * @param {string} type - The name of the type that the handler will be removed.
     */
    removeHandler(type: string): void;
    /**
     * Get a {@link ResourceHandler} for a resource type.
     *
     * @param {string} type - The name of the resource type that the handler is registered with.
     * @returns {import('./handler.js').ResourceHandler|undefined} The registered handler, or
     * undefined if the requested handler is not registered.
     */
    getHandler(type: string): ResourceHandler | undefined;
    /**
     * Make a request for a resource from a remote URL. Parse the returned data using the handler
     * for the specified type. When loaded and parsed, use the callback to return an instance of
     * the resource.
     *
     * @param {string} url - The URL of the resource to load.
     * @param {string} type - The type of resource expected.
     * @param {ResourceLoaderCallback} callback - The callback used when the resource is loaded or
     * an error occurs. Passed (err, resource) where err is null if there are no errors.
     * @param {import('../asset/asset.js').Asset} [asset] - Optional asset that is passed into
     * handler.
     * @param {object} [options] - Additional options for loading.
     * @param {boolean} [options.bundlesIgnore] - If set to true, then asset will not try to load
     * from a bundle. Defaults to false.
     * @param {import('../asset/asset-registry.js').BundlesFilterCallback} [options.bundlesFilter] - A callback that will be called
     * when loading an asset that is contained in any of the bundles. It provides an array of
     * bundles and will ensure asset is loaded from bundle returned from a callback. By default
     * smallest filesize bundle is choosen.
     * @example
     * app.loader.load("../path/to/texture.png", "texture", function (err, texture) {
     *     // use texture here
     * });
     */
    load(url: string, type: string, callback: ResourceLoaderCallback, asset?: Asset, options?: {
        bundlesIgnore?: boolean;
        bundlesFilter?: BundlesFilterCallback;
    }): void;
    _loadNull(handler: any, callback: any, asset: any): void;
    _onSuccess(key: any, result: any, extra: any): void;
    _onFailure(key: any, err: any): void;
    /**
     * Convert raw resource data into a resource instance. E.g. Take 3D model format JSON and
     * return a {@link Model}.
     *
     * @param {string} type - The type of resource.
     * @param {*} data - The raw resource data.
     * @returns {*} The parsed resource data.
     */
    open(type: string, data: any): any;
    /**
     * Perform any operations on a resource, that requires a dependency on its asset data or any
     * other asset data.
     *
     * @param {import('../asset/asset.js').Asset} asset - The asset to patch.
     * @param {import('../asset/asset-registry.js').AssetRegistry} assets - The asset registry.
     */
    patch(asset: Asset, assets: AssetRegistry): void;
    /**
     * Remove resource from cache.
     *
     * @param {string} url - The URL of the resource.
     * @param {string} type - The type of resource.
     */
    clearCache(url: string, type: string): void;
    /**
     * Check cache for resource from a URL. If present, return the cached value.
     *
     * @param {string} url - The URL of the resource to get from the cache.
     * @param {string} type - The type of the resource.
     * @returns {*} The resource loaded from the cache.
     */
    getFromCache(url: string, type: string): any;
    /**
     * Enables retrying of failed requests when loading assets.
     *
     * @param {number} maxRetries - The maximum number of times to retry loading an asset. Defaults
     * to 5.
     * @ignore
     */
    enableRetry(maxRetries?: number): void;
    /**
     * Disables retrying of failed requests when loading assets.
     *
     * @ignore
     */
    disableRetry(): void;
    /**
     * Destroys the resource loader.
     */
    destroy(): void;
}

/**
 * Callback used by {@link Assetready } and called when an asset is ready.
 */
export type AssetReadyCallback = (asset: Asset) => any;
/**
 * Callback used by {@link Asset#ready} and called when an asset is ready.
 *
 * @callback AssetReadyCallback
 * @param {Asset} asset - The ready asset.
 */
/**
 * An asset record of a file or data resource that can be loaded by the engine. The asset contains
 * four important fields:
 *
 * - `file`: contains the details of a file (filename, url) which contains the resource data, e.g.
 * an image file for a texture asset.
 * - `data`: contains a JSON blob which contains either the resource data for the asset (e.g.
 * material data) or additional data for the file (e.g. material mappings for a model).
 * - `options`: contains a JSON blob with handler-specific load options.
 * - `resource`: contains the final resource when it is loaded. (e.g. a {@link StandardMaterial} or
 * a {@link Texture}).
 *
 * See the {@link AssetRegistry} for details on loading resources from assets.
 *
 * @augments EventHandler
 * @category Asset
 */
declare class Asset extends EventHandler {
    /**
     * Fired when the asset has completed loading.
     *
     * @event
     * @example
     * asset.on('load', (asset) => {
     *     console.log(`Asset loaded: ${asset.name}`);
     * });
     */
    static EVENT_LOAD: string;
    /**
     * Fired just before the asset unloads the resource. This allows for the opportunity to prepare
     * for an asset that will be unloaded. E.g. Changing the texture of a model to a default before
     * the one it was using is unloaded.
     *
     * @event
     * @example
     * asset.on('unload', (asset) => {
     *    console.log(`Asset about to unload: ${asset.name}`);
     * });
     */
    static EVENT_UNLOAD: string;
    /**
     * Fired when the asset is removed from the asset registry.
     *
     * @event
     * @example
     * asset.on('remove', (asset) => {
     *    console.log(`Asset removed: ${asset.name}`);
     * });
     */
    static EVENT_REMOVE: string;
    /**
     * Fired if the asset encounters an error while loading.
     *
     * @event
     * @example
     * asset.on('error', (err, asset) => {
     *    console.error(`Error loading asset ${asset.name}: ${err}`);
     * });
     */
    static EVENT_ERROR: string;
    /**
     * Fired when one of the asset properties `file`, `data`, `resource` or `resources` is changed.
     *
     * @event
     * @example
     * asset.on('change', (asset, property, newValue, oldValue) => {
     *    console.log(`Asset ${asset.name} has property ${property} changed from ${oldValue} to ${newValue}`);
     * });
     */
    static EVENT_CHANGE: string;
    /**
     * Fired when we add a new localized asset id to the asset.
     *
     * @event
     * @example
     * asset.on('add:localized', (locale, assetId) => {
     *    console.log(`Asset ${asset.name} has added localized asset ${assetId} for locale ${locale}`);
     * });
     */
    static EVENT_ADDLOCALIZED: string;
    /**
     * Fired when we remove a localized asset id from the asset.
     *
     * @event
     * @example
     * asset.on('remove:localized', (locale, assetId) => {
     *   console.log(`Asset ${asset.name} has removed localized asset ${assetId} for locale ${locale}`);
     * });
     */
    static EVENT_REMOVELOCALIZED: string;
    /**
     * Helper function to resolve asset file data and return the contents as an ArrayBuffer. If the
     * asset file contents are present, that is returned. Otherwise the file data is be downloaded
     * via http.
     *
     * @param {string} loadUrl - The URL as passed into the handler
     * @param {import('../handlers/loader.js').ResourceLoaderCallback} callback - The callback
     * function to receive results.
     * @param {Asset} [asset] - The asset
     * @param {number} maxRetries - Number of retries if http download is required
     * @ignore
     */
    static fetchArrayBuffer(loadUrl: string, callback: ResourceLoaderCallback, asset?: Asset, maxRetries?: number): void;
    /**
     * Create a new Asset record. Generally, Assets are created in the loading process and you
     * won't need to create them by hand.
     *
     * @param {string} name - A non-unique but human-readable name which can be later used to
     * retrieve the asset.
     * @param {string} type - Type of asset. One of ["animation", "audio", "binary", "bundle", "container",
     * "cubemap", "css", "font", "json", "html", "material", "model", "script", "shader", "sprite",
     * "template", text", "texture", "textureatlas"]
     * @param {object} [file] - Details about the file the asset is made from. At the least must
     * contain the 'url' field. For assets that don't contain file data use null.
     * @param {string} [file.url] - The URL of the resource file that contains the asset data.
     * @param {string} [file.filename] - The filename of the resource file or null if no filename
     * was set (e.g from using {@link AssetRegistry#loadFromUrl}).
     * @param {number} [file.size] - The size of the resource file or null if no size was set
     * (e.g. from using {@link AssetRegistry#loadFromUrl}).
     * @param {string} [file.hash] - The MD5 hash of the resource file data and the Asset data
     * field or null if hash was set (e.g from using {@link AssetRegistry#loadFromUrl}).
     * @param {ArrayBuffer} [file.contents] - Optional file contents. This is faster than wrapping
     * the data in a (base64 encoded) blob. Currently only used by container assets.
     * @param {object|string} [data] - JSON object or string with additional data about the asset.
     * (e.g. for texture and model assets) or contains the asset data itself (e.g. in the case of
     * materials).
     * @param {object} [options] - The asset handler options. For container options see
     * {@link ContainerHandler}.
     * @param {'anonymous'|'use-credentials'|null} [options.crossOrigin] - For use with texture assets
     * that are loaded using the browser. This setting overrides the default crossOrigin specifier.
     * For more details on crossOrigin and its use, see
     * https://developer.mozilla.org/en-US/docs/Web/API/HTMLImageElement/crossOrigin.
     * @example
     * const asset = new pc.Asset("a texture", "texture", {
     *     url: "http://example.com/my/assets/here/texture.png"
     * });
     */
    constructor(name: string, type: string, file?: {
        url?: string;
        filename?: string;
        size?: number;
        hash?: string;
        contents?: ArrayBuffer;
    }, data?: object | string, options?: {
        crossOrigin?: 'anonymous' | 'use-credentials' | null;
    });
    _id: number;
    _name: string;
    /**
     * The type of the asset. One of ["animation", "audio", "binary", "container", "cubemap",
     * "css", "font", "json", "html", "material", "model", "render", "script", "shader", "sprite",
     * "template", "text", "texture", "textureatlas"]
     *
     * @type {("animation"|"audio"|"binary"|"container"|"cubemap"|"css"|"font"|"json"|"html"|"material"|"model"|"render"|"script"|"shader"|"sprite"|"template"|"text"|"texture"|"textureatlas")}
     */
    type: ("animation" | "audio" | "binary" | "container" | "cubemap" | "css" | "font" | "json" | "html" | "material" | "model" | "render" | "script" | "shader" | "sprite" | "template" | "text" | "texture" | "textureatlas");
    /**
     * Asset tags. Enables finding of assets by tags using the {@link AssetRegistry#findByTag} method.
     *
     * @type {Tags}
     */
    tags: Tags;
    _preload: boolean;
    _file: any;
    _data: any;
    /**
     * Optional JSON data that contains the asset handler options.
     *
     * @type {object}
     */
    options: object;
    _resources: any[];
    urlObject: any;
    _i18n: {};
    /**
     * True if the asset has finished attempting to load the resource. It is not guaranteed
     * that the resources are available as there could have been a network error.
     *
     * @type {boolean}
     */
    loaded: boolean;
    /**
     * True if the resource is currently being loaded.
     *
     * @type {boolean}
     */
    loading: boolean;
    /**
     * The asset registry that this Asset belongs to.
     *
     * @type {import('./asset-registry.js').AssetRegistry|null}
     */
    registry: AssetRegistry | null;
    /**
     * The file details or null if no file.
     *
     * @type {object}
     */
    set file(arg: any);
    get file(): any;
    /**
     * The asset id.
     *
     * @type {number}
     */
    set id(arg: number);
    get id(): number;
    /**
     * The asset name.
     *
     * @type {string}
     */
    set name(arg: string);
    get name(): string;
    /**
     * Optional JSON data that contains either the complete resource data. (e.g. in the case of a
     * material) or additional data (e.g. in the case of a model it contains mappings from mesh to
     * material).
     *
     * @type {object}
     */
    set data(arg: any);
    get data(): any;
    /**
     * A reference to the resource when the asset is loaded. e.g. a {@link Texture} or a {@link Model}.
     *
     * @type {object}
     */
    set resource(arg: any);
    get resource(): any;
    /**
     * A reference to the resources of the asset when it's loaded. An asset can hold more runtime
     * resources than one e.g. cubemaps.
     *
     * @type {object[]}
     */
    set resources(arg: any[]);
    get resources(): any[];
    /**
     * If true the asset will be loaded during the preload phase of application set up.
     *
     * @type {boolean}
     */
    set preload(arg: boolean);
    get preload(): boolean;
    set loadFaces(arg: any);
    get loadFaces(): any;
    _loadFaces: any;
    /**
     * Return the URL required to fetch the file for this asset.
     *
     * @returns {string|null} The URL. Returns null if the asset has no associated file.
     * @example
     * const assets = app.assets.find("My Image", "texture");
     * const img = "&lt;img src='" + assets[0].getFileUrl() + "'&gt;";
     */
    getFileUrl(): string | null;
    /**
     * Construct an asset URL from this asset's location and a relative path. If the relativePath
     * is a blob or Base64 URI, then return that instead.
     *
     * @param {string} relativePath - The relative path to be concatenated to this asset's base url.
     * @returns {string} Resulting URL of the asset.
     * @ignore
     */
    getAbsoluteUrl(relativePath: string): string;
    /**
     * Returns the asset id of the asset that corresponds to the specified locale.
     *
     * @param {string} locale - The desired locale e.g. Ar-AR.
     * @returns {number} An asset id or null if there is no asset specified for the desired locale.
     * @ignore
     */
    getLocalizedAssetId(locale: string): number;
    /**
     * Adds a replacement asset id for the specified locale. When the locale in
     * {@link Application#i18n} changes then references to this asset will be replaced with the
     * specified asset id. (Currently only supported by the {@link ElementComponent}).
     *
     * @param {string} locale - The locale e.g. Ar-AR.
     * @param {number} assetId - The asset id.
     * @ignore
     */
    addLocalizedAssetId(locale: string, assetId: number): void;
    /**
     * Removes a localized asset.
     *
     * @param {string} locale - The locale e.g. Ar-AR.
     * @ignore
     */
    removeLocalizedAssetId(locale: string): void;
    /**
     * Take a callback which is called as soon as the asset is loaded. If the asset is already
     * loaded the callback is called straight away.
     *
     * @param {AssetReadyCallback} callback - The function called when the asset is ready. Passed
     * the (asset) arguments.
     * @param {object} [scope] - Scope object to use when calling the callback.
     * @example
     * const asset = app.assets.find("My Asset");
     * asset.ready(function (asset) {
     *   // asset loaded
     * });
     * app.assets.load(asset);
     */
    ready(callback: AssetReadyCallback, scope?: object): void;
    reload(): void;
    /**
     * Destroys the associated resource and marks asset as unloaded.
     *
     * @example
     * const asset = app.assets.find("My Asset");
     * asset.unload();
     * // asset.resource is null
     */
    unload(): void;
}

/**
 * Keeps track of which assets are in bundles and loads files from bundles.
 *
 * @ignore
 */
declare class BundleRegistry {
    /**
     * Create a new BundleRegistry instance.
     *
     * @param {import('../asset/asset-registry.js').AssetRegistry} assets - The asset registry.
     */
    constructor(assets: AssetRegistry);
    /**
     * Index of bundle assets.
     * @type {Map<number, import('../asset/asset.js').Asset>}
     * @private
     */
    private _idToBundle;
    /**
     * Index of asset id to set of bundle assets.
     * @type {Map<number, Set<import('../asset/asset.js').Asset>>}
     * @private
     */
    private _assetToBundles;
    /**
     * Index of file url to set of bundle assets.
     * @type {Map<string, Set<import('../asset/asset.js').Asset>>}
     * @private
     */
    private _urlsToBundles;
    /**
     * Index of file request to load callbacks.
     * @type {Map<string, function[]>}
     * @private
     */
    private _fileRequests;
    _assets: AssetRegistry;
    /**
     * Called when asset is added to AssetRegistry.
     *
     * @param {import('../asset/asset.js').Asset} asset - The asset that has been added.
     * @private
     */
    private _onAssetAdd;
    _unbindAssetEvents(id: any): void;
    _indexAssetInBundle(id: any, bundle: any): void;
    _indexAssetFileUrls(asset: any): void;
    _getAssetFileUrls(asset: any): any[];
    _onAssetRemove(asset: any): void;
    _onBundleLoadStart(asset: any): void;
    _onBundleLoad(asset: any): void;
    _onBundleError(err: any): void;
    _findLoadedOrLoadingBundleForUrl(url: any): any;
    /**
     * Lists all of the available bundles that reference the specified asset.
     *
     * @param {import('../asset/asset.js').Asset} asset - The asset to search by.
     * @returns {import('../asset/asset.js').Asset[]|null} An array of bundle assets or null if the
     * asset is not in any bundle.
     */
    listBundlesForAsset(asset: Asset): Asset[] | null;
    /**
     * Lists all bundle assets.
     *
     * @returns {import('../asset/asset.js').Asset[]} An array of bundle assets.
     */
    list(): Asset[];
    /**
     * Returns true if there is a bundle that contains the specified URL.
     *
     * @param {string} url - The url.
     * @returns {boolean} True or false.
     */
    hasUrl(url: string): boolean;
    /**
     * Returns true if there is a bundle that contains the specified URL and that bundle is either
     * loaded or currently being loaded.
     *
     * @param {string} url - The url.
     * @returns {boolean} True or false.
     */
    urlIsLoadedOrLoading(url: string): boolean;
    /**
     * Loads the specified file URL from a bundle that is either loaded or currently being loaded.
     *
     * @param {string} url - The URL. Make sure you are using a relative URL that does not contain
     * any query parameters.
     * @param {Function} callback - The callback is called when the file has been loaded or if an
     * error occurs. The callback expects the first argument to be the error message (if any) and
     * the second argument is the file blob URL.
     * @example
     * const url = asset.getFileUrl().split('?')[0]; // get normalized asset URL
     * this.app.bundles.loadFile(url, function (err, data) {
     *     // do something with the data
     * });
     */
    loadUrl(url: string, callback: Function): void;
    /**
     * Destroys the registry, and releases its resources. Does not unload bundle assets as these
     * should be unloaded by the {@link AssetRegistry}.
     */
    destroy(): void;
}

/**
 * Represents the resource of a Bundle Asset, which contains an index that maps URLs to DataViews.
 *
 * @ignore
 */
declare class Bundle extends EventHandler {
    /**
     * Fired when a file has been added to a Bundle.
     *
     * @event
     * @example
     * bundle.on("add", function (url, data) {
     *     console.log("file added: " + url);
     * });
     */
    static EVENT_ADD: string;
    /**
     * Fired when all files of a Bundle has been loaded.
     *
     * @event
     * @example
     * bundle.on("load", function () {
     *     console.log("All Bundle files has been loaded");
     * });
     */
    static EVENT_LOAD: string;
    /**
     * Index of file url to to DataView.
     * @type {Map<string, DataView>}
     * @private
     */
    private _index;
    /**
     * If Bundle has all files loaded.
     * @type {boolean}
     * @private
     */
    private _loaded;
    /**
     * Add file to a Bundle.
     *
     * @param {string} url - A url of a file.
     * @param {DataView} data - A DataView of a file.
     * @ignore
     */
    addFile(url: string, data: DataView): void;
    /**
     * Returns true if the specified URL exists in the loaded bundle.
     *
     * @param {string} url - The original file URL. Make sure you have called decodeURIComponent on
     * the URL first.
     * @returns {boolean} True of false.
     */
    has(url: string): boolean;
    /**
     * Returns a DataView for the specified URL.
     *
     * @param {string} url - The original file URL. Make sure you have called decodeURIComponent on
     * the URL first.
     * @returns {DataView|null} A DataView.
     */
    get(url: string): DataView | null;
    /**
     * Destroys the bundle.
     */
    destroy(): void;
    /**
     * True if all files of a Bundle are loaded.
     * @type {boolean}
     */
    set loaded(arg: boolean);
    get loaded(): boolean;
}

/**
 * Callback used by {@link AssetRegistryfilter } to filter assets.
 */
export type FilterAssetCallback = (asset: Asset) => boolean;
/**
 * Callback used by {@link AssetRegistryloadFromUrl } and called when an asset is loaded (or an
 * error occurs).
 */
export type LoadAssetCallback = (err: string | null, asset?: Asset) => any;
/**
 * Callback used by {@link ResourceLoaderload } and called when an asset is choosing a bundle
 * to load from. Return a single bundle to ensure asset is loaded from it.
 */
export type BundlesFilterCallback = (bundles: Bundle[]) => any;
/**
 * Callback used by {@link AssetRegistry#filter} to filter assets.
 *
 * @callback FilterAssetCallback
 * @param {Asset} asset - The current asset to filter.
 * @returns {boolean} Return `true` to include asset to result list.
 */
/**
 * Callback used by {@link AssetRegistry#loadFromUrl} and called when an asset is loaded (or an
 * error occurs).
 *
 * @callback LoadAssetCallback
 * @param {string|null} err - The error message is null if no errors were encountered.
 * @param {Asset} [asset] - The loaded asset if no errors were encountered.
 */
/**
 * Callback used by {@link ResourceLoader#load} and called when an asset is choosing a bundle
 * to load from. Return a single bundle to ensure asset is loaded from it.
 *
 * @callback BundlesFilterCallback
 * @param {import('../bundle/bundle.js').Bundle[]} bundles - List of bundles which contain the asset.
 */
/**
 * Container for all assets that are available to this application. Note that PlayCanvas scripts
 * are provided with an AssetRegistry instance as `app.assets`.
 *
 * @augments EventHandler
 * @category Asset
 */
declare class AssetRegistry extends EventHandler {
    /**
     * Fired when an asset completes loading. This event is available in three forms. They are as
     * follows:
     *
     * 1. `load` - Fired when any asset finishes loading.
     * 2. `load:[id]` - Fired when a specific asset has finished loading, where `[id]` is the
     * unique id of the asset.
     * 3. `load:url:[url]` - Fired when an asset finishes loading whose URL matches `[url]`, where
     * `[url]` is the URL of the asset.
     *
     * @event
     * @example
     * app.assets.on('load', (asset) => {
     *     console.log(`Asset loaded: ${asset.name}`);
     * });
     * @example
     * const id = 123456;
     * const asset = app.assets.get(id);
     * app.assets.on('load:' + id, (asset) => {
     *     console.log(`Asset loaded: ${asset.name}`);
     * });
     * app.assets.load(asset);
     * @example
     * const id = 123456;
     * const asset = app.assets.get(id);
     * app.assets.on('load:url:' + asset.file.url, (asset) => {
     *     console.log(`Asset loaded: ${asset.name}`);
     * });
     * app.assets.load(asset);
     */
    static EVENT_LOAD: string;
    /**
     * Fired when an asset is added to the registry. This event is available in three forms. They
     * are as follows:
     *
     * 1. `add` - Fired when any asset is added to the registry.
     * 2. `add:[id]` - Fired when an asset is added to the registry, where `[id]` is the unique id
     * of the asset.
     * 3. `add:url:[url]` - Fired when an asset is added to the registry and matches the URL
     * `[url]`, where `[url]` is the URL of the asset.
     *
     * @event
     * @example
     * app.assets.on('add', (asset) => {
     *    console.log(`Asset added: ${asset.name}`);
     * });
     * @example
     * const id = 123456;
     * app.assets.on('add:' + id, (asset) => {
     *    console.log(`Asset added: ${asset.name}`);
     * });
     * @example
     * const id = 123456;
     * const asset = app.assets.get(id);
     * app.assets.on('add:url:' + asset.file.url, (asset) => {
     *    console.log(`Asset added: ${asset.name}`);
     * });
     */
    static EVENT_ADD: string;
    /**
     * Fired when an asset is removed from the registry. This event is available in three forms.
     * They are as follows:
     *
     * 1. `remove` - Fired when any asset is removed from the registry.
     * 2. `remove:[id]` - Fired when an asset is removed from the registry, where `[id]` is the
     * unique id of the asset.
     * 3. `remove:url:[url]` - Fired when an asset is removed from the registry and matches the
     * URL `[url]`, where `[url]` is the URL of the asset.
     *
     * @event
     * @param {Asset} asset - The asset that was removed.
     * @example
     * app.assets.on('remove', (asset) => {
     *    console.log(`Asset removed: ${asset.name}`);
     * });
     * @example
     * const id = 123456;
     * app.assets.on('remove:' + id, (asset) => {
     *    console.log(`Asset removed: ${asset.name}`);
     * });
     * @example
     * const id = 123456;
     * const asset = app.assets.get(id);
     * app.assets.on('remove:url:' + asset.file.url, (asset) => {
     *    console.log(`Asset removed: ${asset.name}`);
     * });
     */
    static EVENT_REMOVE: string;
    /**
     * Fired when an error occurs during asset loading. This event is available in two forms. They
     * are as follows:
     *
     * 1. `error` - Fired when any asset reports an error in loading.
     * 2. `error:[id]` - Fired when an asset reports an error in loading, where `[id]` is the
     * unique id of the asset.
     *
     * @event
     * @example
     * const id = 123456;
     * const asset = app.assets.get(id);
     * app.assets.on('error', (err, asset) => {
     *     console.error(err);
     * });
     * app.assets.load(asset);
     * @example
     * const id = 123456;
     * const asset = app.assets.get(id);
     * app.assets.on('error:' + id, (err, asset) => {
     *     console.error(err);
     * });
     * app.assets.load(asset);
     */
    static EVENT_ERROR: string;
    /**
     * Create an instance of an AssetRegistry.
     *
     * @param {import('../handlers/loader.js').ResourceLoader} loader - The ResourceLoader used to
     * load the asset files.
     */
    constructor(loader: ResourceLoader);
    /**
     * @type {Set<Asset>}
     * @private
     */
    private _assets;
    /**
     * @type {Map<number, Asset>}
     * @private
     */
    private _idToAsset;
    /**
     * @type {Map<string, Asset>}
     * @private
     */
    private _urlToAsset;
    /**
     * @type {Map<string, Set<Asset>>}
     * @private
     */
    private _nameToAsset;
    /**
     * Index for looking up by tags.
     *
     * @private
     */
    private _tags;
    /**
     * A URL prefix that will be added to all asset loading requests.
     *
     * @type {string|null}
     */
    prefix: string | null;
    /**
     * BundleRegistry
     *
     * @type {import('../bundle/bundle-registry.js').BundleRegistry|null}
     */
    bundles: BundleRegistry | null;
    _loader: ResourceLoader;
    /**
     * Create a filtered list of assets from the registry.
     *
     * @param {object} filters - Properties to filter on, currently supports: 'preload: true|false'.
     * @returns {Asset[]} The filtered list of assets.
     */
    list(filters?: object): Asset[];
    /**
     * Add an asset to the registry.
     *
     * @param {Asset} asset - The asset to add.
     * @example
     * const asset = new pc.Asset("My Asset", "texture", {
     *     url: "../path/to/image.jpg"
     * });
     * app.assets.add(asset);
     */
    add(asset: Asset): void;
    /**
     * Remove an asset from the registry.
     *
     * @param {Asset} asset - The asset to remove.
     * @returns {boolean} True if the asset was successfully removed and false otherwise.
     * @example
     * const asset = app.assets.get(100);
     * app.assets.remove(asset);
     */
    remove(asset: Asset): boolean;
    /**
     * Retrieve an asset from the registry by its id field.
     *
     * @param {number} id - The id of the asset to get.
     * @returns {Asset|undefined} The asset.
     * @example
     * const asset = app.assets.get(100);
     */
    get(id: number): Asset | undefined;
    /**
     * Retrieve an asset from the registry by its file's URL field.
     *
     * @param {string} url - The url of the asset to get.
     * @returns {Asset|undefined} The asset.
     * @example
     * const asset = app.assets.getByUrl("../path/to/image.jpg");
     */
    getByUrl(url: string): Asset | undefined;
    /**
     * Load the asset's file from a remote source. Listen for "load" events on the asset to find
     * out when it is loaded.
     *
     * @param {Asset} asset - The asset to load.
     * @param {object} [options] - Options for asset loading.
     * @param {boolean} [options.bundlesIgnore] - If set to true, then asset will not try to load
     * from a bundle. Defaults to false.
     * @param {boolean} [options.force] - If set to true, then the check of asset being loaded or
     * is already loaded is bypassed, which forces loading of asset regardless.
     * @param {BundlesFilterCallback} [options.bundlesFilter] - A callback that will be called
     * when loading an asset that is contained in any of the bundles. It provides an array of
     * bundles and will ensure asset is loaded from bundle returned from a callback. By default
     * smallest filesize bundle is choosen.
     * @example
     * // load some assets
     * const assetsToLoad = [
     *     app.assets.find("My Asset"),
     *     app.assets.find("Another Asset")
     * ];
     * let count = 0;
     * assetsToLoad.forEach(function (assetToLoad) {
     *     assetToLoad.ready(function (asset) {
     *         count++;
     *         if (count === assetsToLoad.length) {
     *             // done
     *         }
     *     });
     *     app.assets.load(assetToLoad);
     * });
     */
    load(asset: Asset, options?: {
        bundlesIgnore?: boolean;
        force?: boolean;
        bundlesFilter?: BundlesFilterCallback;
    }): void;
    /**
     * Use this to load and create an asset if you don't have assets created. Usually you would
     * only use this if you are not integrated with the PlayCanvas Editor.
     *
     * @param {string} url - The url to load.
     * @param {string} type - The type of asset to load.
     * @param {LoadAssetCallback} callback - Function called when asset is loaded, passed (err,
     * asset), where err is null if no errors were encountered.
     * @example
     * app.assets.loadFromUrl("../path/to/texture.jpg", "texture", function (err, asset) {
     *     const texture = asset.resource;
     * });
     */
    loadFromUrl(url: string, type: string, callback: LoadAssetCallback): void;
    /**
     * Use this to load and create an asset when both the URL and filename are required. For
     * example, use this function when loading BLOB assets, where the URL does not adequately
     * identify the file.
     *
     * @param {string} url - The url to load.
     * @param {string} filename - The filename of the asset to load.
     * @param {string} type - The type of asset to load.
     * @param {LoadAssetCallback} callback - Function called when asset is loaded, passed (err,
     * asset), where err is null if no errors were encountered.
     * @example
     * const file = magicallyObtainAFile();
     * app.assets.loadFromUrlAndFilename(URL.createObjectURL(file), "texture.png", "texture", function (err, asset) {
     *     const texture = asset.resource;
     * });
     */
    loadFromUrlAndFilename(url: string, filename: string, type: string, callback: LoadAssetCallback): void;
    loadFromUrlError: any;
    _loadModel(modelAsset: any, continuation: any): void;
    _loadMaterials(modelAsset: any, mapping: any, callback: any): void;
    _loadTextures(materialAsset: any, callback: any): void;
    _onTagAdd(tag: any, asset: any): void;
    _onTagRemove(tag: any, asset: any): void;
    _onNameChange(asset: any, name: any, nameOld: any): void;
    /**
     * Return all Assets that satisfy the search query. Query can be simply a string, or comma
     * separated strings, to have inclusive results of assets that match at least one query. A
     * query that consists of an array of tags can be used to match assets that have each tag of
     * array.
     *
     * @param {...*} query - Name of a tag or array of tags.
     * @returns {Asset[]} A list of all Assets matched query.
     * @example
     * const assets = app.assets.findByTag("level-1");
     * // returns all assets that tagged by `level-1`
     * @example
     * const assets = app.assets.findByTag("level-1", "level-2");
     * // returns all assets that tagged by `level-1` OR `level-2`
     * @example
     * const assets = app.assets.findByTag(["level-1", "monster"]);
     * // returns all assets that tagged by `level-1` AND `monster`
     * @example
     * const assets = app.assets.findByTag(["level-1", "monster"], ["level-2", "monster"]);
     * // returns all assets that tagged by (`level-1` AND `monster`) OR (`level-2` AND `monster`)
     */
    findByTag(...args: any[]): Asset[];
    /**
     * Return all Assets that satisfy a filter callback.
     *
     * @param {FilterAssetCallback} callback - The callback function that is used to filter assets.
     * Return `true` to include an asset in the returned array.
     * @returns {Asset[]} A list of all Assets found.
     * @example
     * const assets = app.assets.filter(asset => asset.name.includes('monster'));
     * console.log(`Found ${assets.length} assets with a name containing 'monster'`);
     */
    filter(callback: FilterAssetCallback): Asset[];
    /**
     * Return the first Asset with the specified name and type found in the registry.
     *
     * @param {string} name - The name of the Asset to find.
     * @param {string} [type] - The type of the Asset to find.
     * @returns {Asset|null} A single Asset or null if no Asset is found.
     * @example
     * const asset = app.assets.find("myTextureAsset", "texture");
     */
    find(name: string, type?: string): Asset | null;
    /**
     * Return all Assets with the specified name and type found in the registry.
     *
     * @param {string} name - The name of the Assets to find.
     * @param {string} [type] - The type of the Assets to find.
     * @returns {Asset[]} A list of all Assets found.
     * @example
     * const assets = app.assets.findAll('brick', 'texture');
     * console.log(`Found ${assets.length} texture assets named 'brick'`);
     */
    findAll(name: string, type?: string): Asset[];
}

/**
 * A frame graph represents a single rendering frame as a sequence of render passes.
 *
 * @ignore
 */
declare class FrameGraph {
    /** @type {import('../platform/graphics/render-pass.js').RenderPass[]} */
    renderPasses: RenderPass[];
    /**
     * Map used during frame graph compilation. It maps a render target to its previous occurrence.
     *
     *  @type {Map<import('../platform/graphics/render-target.js').RenderTarget, import('../platform/graphics/render-pass.js').RenderPass>}
     */
    renderTargetMap: Map<RenderTarget, RenderPass>;
    /**
     * Add a render pass to the frame.
     *
     * @param {import('../platform/graphics/render-pass.js').RenderPass} renderPass - The render
     * pass to add.
     */
    addRenderPass(renderPass: RenderPass): void;
    reset(): void;
    compile(): void;
    render(device: any): void;
}

declare class LightsBuffer {
    static getLightTextureFormat(device: any): 0 | 1;
    static getShaderDefines(device: any): any;
    constructor(device: any);
    device: any;
    cookiesEnabled: boolean;
    shadowsEnabled: boolean;
    areaLightsEnabled: boolean;
    maxLights: number;
    lightTextureFormat: number;
    lights8: Uint8ClampedArray;
    lightsTexture8: Texture;
    _lightsTexture8Id: any;
    lightsFloat: Float32Array;
    lightsTextureFloat: Texture;
    _lightsTextureFloatId: any;
    _lightsTextureInvSizeId: any;
    _lightsTextureInvSizeData: Float32Array;
    invMaxColorValue: number;
    invMaxAttenuation: number;
    boundsMin: Vec3;
    boundsDelta: Vec3;
    destroy(): void;
    createTexture(device: any, width: any, height: any, format: any, name: any): Texture;
    setCompressionRanges(maxAttenuation: any, maxColorValue: any): void;
    setBounds(min: any, delta: any): void;
    uploadTextures(): void;
    updateUniforms(): void;
    getSpotDirection(direction: any, spot: any): void;
    getLightAreaSizes(light: any): Float32Array;
    addLightDataFlags(data8: any, index: any, light: any, isSpot: any, castShadows: any, shadowIntensity: any): void;
    addLightDataColor(data8: any, index: any, light: any, gammaCorrection: any, isCookie: any): void;
    addLightDataSpotAngles(data8: any, index: any, light: any): void;
    addLightDataShadowBias(data8: any, index: any, light: any): void;
    addLightDataPositionRange(data8: any, index: any, light: any, pos: any): void;
    addLightDataSpotDirection(data8: any, index: any, light: any): void;
    addLightDataLightProjMatrix(data8: any, index: any, lightProjectionMatrix: any): void;
    addLightDataCookies(data8: any, index: any, light: any): void;
    addLightAtlasViewport(data8: any, index: any, atlasViewport: any): void;
    addLightAreaSizes(data8: any, index: any, light: any): void;
    addLightData(light: any, lightIndex: any, gammaCorrection: any): void;
}

declare class WorldClusters {
    constructor(device: any);
    /** @type {import('../../platform/graphics/texture.js').Texture} */
    clusterTexture: Texture;
    device: any;
    name: string;
    reportCount: number;
    boundsMin: Vec3;
    boundsMax: Vec3;
    boundsDelta: Vec3;
    _cells: Vec3;
    _cellsLimit: Vec3;
    set cells(arg: Vec3);
    get cells(): Vec3;
    set maxCellLightCount(arg: any);
    get maxCellLightCount(): any;
    _maxAttenuation: number;
    _maxColorValue: number;
    _usedLights: ClusterLight[];
    lightsBuffer: LightsBuffer;
    _maxCellLightCount: any;
    _cellsDirty: boolean;
    destroy(): void;
    releaseClusterTexture(): void;
    registerUniforms(device: any): void;
    _clusterSkipId: any;
    _clusterMaxCellsId: any;
    _clusterWorldTextureId: any;
    _clusterTextureSizeId: any;
    _clusterTextureSizeData: Float32Array;
    _clusterBoundsMinId: any;
    _clusterBoundsMinData: Float32Array;
    _clusterBoundsDeltaId: any;
    _clusterBoundsDeltaData: Float32Array;
    _clusterCellsCountByBoundsSizeId: any;
    _clusterCellsCountByBoundsSizeData: Float32Array;
    _clusterCellsDotId: any;
    _clusterCellsDotData: Float32Array;
    _clusterCellsMaxId: any;
    _clusterCellsMaxData: Float32Array;
    _clusterCompressionLimit0Id: any;
    _clusterCompressionLimit0Data: Float32Array;
    updateParams(lightingParams: any): void;
    updateCells(): void;
    clusters: Uint8ClampedArray;
    counts: Int32Array;
    uploadTextures(): void;
    updateUniforms(): void;
    evalLightCellMinMax(clusteredLight: any, min: any, max: any): void;
    collectLights(lights: any): void;
    evaluateBounds(): void;
    evaluateCompressionLimits(gammaCorrection: any): void;
    updateClusters(gammaCorrection: any): void;
    update(lights: any, gammaCorrection: any, lightingParams: any): void;
    activate(): void;
}

declare class ClusterLight {
    light: any;
    min: Vec3;
    max: Vec3;
}

/**
 * A class managing instances of world clusters used by the renderer for layers with
 * unique sets of clustered lights.
 *
 * @ignore
 */
declare class WorldClustersAllocator {
    /**
     * Create a new instance.
     *
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} graphicsDevice -
     * The graphics device.
     */
    constructor(graphicsDevice: GraphicsDevice);
    /**
     * Empty cluster with no lights.
     *
     * @type {WorldClusters|null}
     */
    _empty: WorldClusters | null;
    /**
     * All allocated clusters
     *
     * @type {WorldClusters[]}
     */
    _allocated: WorldClusters[];
    /**
     * Render actions with all unique light clusters. The key is the hash of lights on a layer, the
     * value is a render action with unique light clusters.
     *
     * @type {Map<number, import('../composition/render-action.js').RenderAction>}
     */
    _clusters: Map<number, RenderAction>;
    device: GraphicsDevice;
    destroy(): void;
    get count(): number;
    get empty(): WorldClusters;
    assign(renderPasses: any): void;
    update(renderPasses: any, gammaCorrection: any, lighting: any): void;
}

/**
 * Blue noise based random numbers API.
 *
 * @ignore
 */
declare class BlueNoise {
    constructor(seed?: number);
    seed: number;
    _next(): void;
    value(): number;
    vec4(dest?: Vec4): Vec4;
}

declare class ShadowMap {
    static getShadowFormat(device: any, shadowType: any): number;
    static getShadowFiltering(device: any, shadowType: any): number;
    static create(device: any, light: any): ShadowMap;
    static createAtlas(device: any, resolution: any, shadowType: any): ShadowMap;
    static create2dMap(device: any, size: any, shadowType: any): ShadowMap;
    static createCubemap(device: any, size: any, shadowType: any): ShadowMap;
    constructor(texture: any, targets: any);
    texture: any;
    cached: boolean;
    renderTargets: any;
    destroy(): void;
}

declare class LightTextureAtlas {
    constructor(device: any);
    device: any;
    version: number;
    shadowAtlasResolution: number;
    shadowAtlas: ShadowMap;
    shadowEdgePixels: number;
    cookieAtlasResolution: number;
    cookieAtlas: Texture;
    cookieRenderTarget: RenderTarget;
    slots: any[];
    atlasSplit: any[];
    cubeSlotsOffsets: Vec2[];
    scissorVec: Vec4;
    destroy(): void;
    destroyShadowAtlas(): void;
    destroyCookieAtlas(): void;
    allocateShadowAtlas(resolution: any): void;
    allocateCookieAtlas(resolution: any): void;
    allocateUniforms(): void;
    _shadowAtlasTextureId: any;
    _shadowAtlasParamsId: any;
    _shadowAtlasParams: Float32Array;
    _cookieAtlasTextureId: any;
    updateUniforms(): void;
    subdivide(numLights: any, lightingParams: any): void;
    collectLights(localLights: any, lightingParams: any): any[];
    setupSlot(light: any, rect: any): void;
    assignSlot(light: any, slotIndex: any, slotReassigned: any): void;
    update(localLights: any, lightingParams: any): void;
}

/**
 * @ignore
 */
declare class ShadowRenderer {
    static createShadowCamera(device: any, shadowType: any, type: any, face: any): Camera;
    static setShadowCameraSettings(shadowCam: any, device: any, shadowType: any, type: any, isClustered: any): void;
    /**
     * @param {import('./renderer.js').Renderer} renderer - The renderer.
     * @param {import('../lighting/light-texture-atlas.js').LightTextureAtlas} lightTextureAtlas - The
     * shadow map atlas.
     */
    constructor(renderer: Renderer, lightTextureAtlas: LightTextureAtlas);
    /**
     * A cache of shadow passes. First index is looked up by light type, second by shadow type.
     *
     * @type {import('../shader-pass.js').ShaderPassInfo[][]}
     * @private
     */
    private shadowPassCache;
    device: GraphicsDevice;
    /** @type {import('./renderer.js').Renderer} */
    renderer: Renderer;
    /** @type {import('../lighting/light-texture-atlas.js').LightTextureAtlas} */
    lightTextureAtlas: LightTextureAtlas;
    polygonOffsetId: ScopeId;
    polygonOffset: Float32Array;
    sourceId: ScopeId;
    pixelOffsetId: ScopeId;
    weightId: ScopeId;
    blurVsmShaderCode: any[];
    blurPackedVsmShaderCode: string[];
    blurVsmShader: {}[];
    blurPackedVsmShader: {}[];
    blurVsmWeights: {};
    shadowMapLightRadiusId: ScopeId;
    viewUniformFormat: UniformBufferFormat;
    viewBindGroupFormat: BindGroupFormat;
    blendStateWrite: BlendState;
    blendStateNoWrite: BlendState;
    _cullShadowCastersInternal(meshInstances: any, visible: any, camera: any): void;
    /**
     * Culls the list of shadow casters used by the light by the camera, storing visible mesh
     * instances in the specified array.
     * @param {import('../composition/layer-composition.js').LayerComposition} comp - The layer
     * composition used as a source of shadow casters, if those are not provided directly.
     * @param {import('../light.js').Light} light - The light.
     * @param {import('../mesh-instance.js').MeshInstance[]} visible - The array to store visible
     * mesh instances in.
     * @param {import('../camera.js').Camera} camera - The camera.
     * @param {import('../mesh-instance.js').MeshInstance[]} [casters] - Optional array of mesh
     * instances to use as casters.
     * @ignore
     */
    cullShadowCasters(comp: LayerComposition, light: Light, visible: MeshInstance[], camera: Camera, casters?: MeshInstance[]): void;
    setupRenderState(device: any, light: any): void;
    dispatchUniforms(light: any, shadowCam: any, lightRenderData: any, face: any): void;
    /**
     * @param {import('../light.js').Light} light - The light.
     * @returns {number} Index of shadow pass info.
     */
    getShadowPass(light: Light): number;
    /**
     * @param {import('../mesh-instance.js').MeshInstance[]} visibleCasters - Visible mesh
     * instances.
     * @param {import('../light.js').Light} light - The light.
     */
    submitCasters(visibleCasters: MeshInstance[], light: Light): void;
    needsShadowRendering(light: any): any;
    getLightRenderData(light: any, camera: any, face: any): any;
    setupRenderPass(renderPass: any, shadowCamera: any, clearRenderTarget: any): void;
    prepareFace(light: any, camera: any, face: any): any;
    renderFace(light: any, camera: any, face: any, clear: any, insideRenderPass?: boolean): void;
    render(light: any, camera: any, insideRenderPass?: boolean): void;
    renderVsm(light: any, camera: any): void;
    getVsmBlurShader(isVsm8: any, blurMode: any, filterSize: any): any;
    applyVsmBlur(light: any, camera: any): void;
    initViewBindGroupFormat(): void;
    frameUpdate(): void;
}

/**
 * @ignore
 */
declare class ShadowRendererLocal {
    constructor(renderer: any, shadowRenderer: any);
    shadowLights: any[];
    /** @type {import('./renderer.js').Renderer} */
    renderer: Renderer;
    /** @type {import('./shadow-renderer.js').ShadowRenderer} */
    shadowRenderer: ShadowRenderer;
    /** @type {import('../../platform/graphics/graphics-device.js').GraphicsDevice} */
    device: GraphicsDevice;
    cull(light: any, comp: any, casters?: any): void;
    prepareLights(shadowLights: any, lights: any): any;
    /**
     * Prepare render passes for rendering of shadows for local non-clustered lights. Each shadow face
     * is a separate render pass as it renders to a separate render target.
     */
    buildNonClusteredRenderPasses(frameGraph: any, localLights: any): void;
}

/**
 * A render pass used to render directional shadows.
 *
 * @ignore
 */
declare class RenderPassShadowDirectional extends RenderPass {
    constructor(device: any, shadowRenderer: any, light: any, camera: any, allCascadesRendering: any);
    shadowRenderer: any;
    light: any;
    camera: any;
    allCascadesRendering: any;
}

/**
 * @ignore
 */
declare class ShadowRendererDirectional {
    constructor(renderer: any, shadowRenderer: any);
    /** @type {import('./renderer.js').Renderer} */
    renderer: Renderer;
    /** @type {import('./shadow-renderer.js').ShadowRenderer} */
    shadowRenderer: ShadowRenderer;
    /** @type {import('../../platform/graphics/graphics-device.js').GraphicsDevice} */
    device: GraphicsDevice;
    cull(light: any, comp: any, camera: any, casters?: any): void;
    generateSplitDistances(light: any, nearDist: any, farDist: any): void;
    /**
     * Create a render pass for directional light shadow rendering for a specified camera.
     *
     * @param {import('../light.js').Light} light - The directional light.
     * @param {import('../camera.js').Camera} camera - The camera.
     * @returns {RenderPassShadowDirectional|null} - The render pass if the shadow rendering is
     * required, or null otherwise.
     */
    getLightRenderPass(light: Light, camera: Camera): RenderPassShadowDirectional | null;
}

/**
 * An object that renders a quad using a {@link Shader}.
 *
 * Example:
 *
 * ```javascript
 * const shader = pc.createShaderFromCode(app.graphicsDevice, vertexShader, fragmentShader, `MyShader`);
 * const quad = new QuadRender(shader);
 * quad.render();
 * quad.destroy();
 * ```
 *
 * @category Graphics
 */
declare class QuadRender {
    /**
     * Create a new QuadRender instance.
     *
     * @param {import('../../platform/graphics/shader.js').Shader} shader - The shader to be used to render the quad.
     */
    constructor(shader: Shader);
    /**
     * @type {UniformBuffer}
     * @ignore
     */
    uniformBuffer: UniformBuffer;
    /**
     * @type {BindGroup}
     * @ignore
     */
    bindGroup: BindGroup;
    shader: Shader;
    /**
     * Destroys the resources associated with this instance.
     */
    destroy(): void;
    /**
     * Renders the quad. If the viewport is provided, the original viewport and scissor is restored
     * after the rendering.
     *
     * @param {import('../../core/math/vec4.js').Vec4} [viewport] - The viewport rectangle of the
     * quad, in pixels. The viewport is not changed if not provided.
     * @param {import('../../core/math/vec4.js').Vec4} [scissor] - The scissor rectangle of the
     * quad, in pixels. Used only if the viewport is provided.
     */
    render(viewport?: Vec4, scissor?: Vec4): void;
}

/**
 * A render pass used to render cookie textures (both 2D and Cubemap) into the texture atlas.
 *
 * @ignore
 */
declare class RenderPassCookieRenderer extends RenderPass {
    static create(renderTarget: any, cubeSlotsOffsets: any): RenderPassCookieRenderer;
    constructor(device: any, cubeSlotsOffsets: any);
    /** @type {QuadRender|null} */
    _quadRenderer2D: QuadRender | null;
    /** @type {QuadRender|null} */
    _quadRendererCube: QuadRender | null;
    _filteredLights: any[];
    _cubeSlotsOffsets: any;
    blitTextureId: any;
    invViewProjId: any;
    update(lights: any): void;
    filter(lights: any, filteredLights: any): void;
    initInvViewProjMatrices(): void;
    get quadRenderer2D(): QuadRender;
    get quadRendererCube(): QuadRender;
}

/**
 * A render pass used to render local clustered shadows. This is done inside a single render pass,
 * as all shadows are part of a single render target atlas.
 *
 * @ignore
 */
declare class RenderPassShadowLocalClustered extends RenderPass {
    constructor(device: any, shadowRenderer: any, shadowRendererLocal: any);
    shadowRenderer: any;
    shadowRendererLocal: any;
    update(localLights: any): void;
}

/**
 * A render pass used to update clustered lighting data - shadows, cookies, world clusters.
 *
 * @ignore
 */
declare class RenderPassUpdateClustered extends RenderPass {
    constructor(device: any, renderer: any, shadowRenderer: any, shadowRendererLocal: any, lightTextureAtlas: any);
    renderer: any;
    frameGraph: any;
    cookiesRenderPass: RenderPassCookieRenderer;
    shadowRenderPass: RenderPassShadowLocalClustered;
    update(frameGraph: any, shadowsEnabled: any, cookiesEnabled: any, lights: any, localLights: any): void;
}

/**
 * A lighting cube represented by 6 colors, one per cube direction. Use for simple lighting on the
 * particle system.
 *
 * @ignore
 */
declare class LightCube {
    colors: Float32Array;
    update(ambientLight: any, lights: any): void;
}

/**
 * The base renderer functionality to allow implementation of specialized renderers.
 *
 * @ignore
 */
declare class Renderer {
    /**
     * Create a new instance.
     *
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} graphicsDevice - The
     * graphics device used by the renderer.
     */
    constructor(graphicsDevice: GraphicsDevice);
    /** @type {boolean} */
    clustersDebugRendered: boolean;
    /**
     * A set of visible mesh instances which need further processing before being rendered, e.g.
     * skinning or morphing. Extracted during culling.
     *
     * @type {Set<import('../mesh-instance.js').MeshInstance>}
     * @private
     */
    private processingMeshInstances;
    /**
     * @type {WorldClustersAllocator}
     * @ignore
     */
    worldClustersAllocator: WorldClustersAllocator;
    /**
     * A list of all unique lights in the layer composition.
     *
     * @type {import('../light.js').Light[]}
     */
    lights: Light[];
    /**
     * A list of all unique local lights (spot & omni) in the layer composition.
     *
     * @type {import('../light.js').Light[]}
     */
    localLights: Light[];
    /**
     * A list of unique directional shadow casting lights for each enabled camera. This is generated
     * each frame during light culling.
     *
     * @type {Map<import('../camera.js').Camera, Array<import('../light.js').Light>>}
     */
    cameraDirShadowLights: Map<Camera, Array<Light>>;
    /**
     * A mapping of a directional light to a camera, for which the shadow is currently valid. This
     * is cleared each frame, and updated each time a directional light shadow is rendered for a
     * camera, and allows us to manually schedule shadow passes when a new camera needs a shadow.
     *
     * @type {Map<import('../light.js').Light, import('../camera.js').Camera>}
     */
    dirLightShadows: Map<Light, Camera>;
    blueNoise: BlueNoise;
    device: GraphicsDevice;
    /** @type {import('../scene.js').Scene|null} */
    scene: Scene | null;
    lightTextureAtlas: LightTextureAtlas;
    shadowMapCache: ShadowMapCache;
    shadowRenderer: ShadowRenderer;
    _shadowRendererLocal: ShadowRendererLocal;
    _shadowRendererDirectional: ShadowRendererDirectional;
    _renderPassUpdateClustered: RenderPassUpdateClustered;
    viewUniformFormat: UniformBufferFormat;
    viewBindGroupFormat: BindGroupFormat;
    _skinTime: number;
    _morphTime: number;
    _cullTime: number;
    _shadowMapTime: number;
    _lightClustersTime: number;
    _layerCompositionUpdateTime: number;
    _shadowDrawCalls: number;
    _skinDrawCalls: number;
    _instancedDrawCalls: number;
    _shadowMapUpdates: number;
    _numDrawCallsCulled: number;
    _camerasRendered: number;
    _lightClusters: number;
    boneTextureId: ScopeId;
    boneTextureSizeId: ScopeId;
    poseMatrixId: ScopeId;
    modelMatrixId: ScopeId;
    normalMatrixId: ScopeId;
    viewInvId: ScopeId;
    viewPos: Float32Array;
    viewPosId: ScopeId;
    projId: ScopeId;
    projSkyboxId: ScopeId;
    viewId: ScopeId;
    viewId3: ScopeId;
    viewProjId: ScopeId;
    flipYId: ScopeId;
    tbnBasis: ScopeId;
    nearClipId: ScopeId;
    farClipId: ScopeId;
    cameraParams: Float32Array;
    cameraParamsId: ScopeId;
    viewIndexId: ScopeId;
    blueNoiseJitterId: ScopeId;
    blueNoiseTextureId: ScopeId;
    alphaTestId: ScopeId;
    opacityMapId: ScopeId;
    exposureId: ScopeId;
    twoSidedLightingNegScaleFactorId: ScopeId;
    morphWeightsA: ScopeId;
    morphWeightsB: ScopeId;
    morphPositionTex: ScopeId;
    morphNormalTex: ScopeId;
    morphTexParams: ScopeId;
    lightCube: LightCube;
    constantLightCube: ScopeId;
    destroy(): void;
    sortCompare(drawCallA: any, drawCallB: any): number;
    sortCompareMesh(drawCallA: any, drawCallB: any): number;
    sortCompareDepth(drawCallA: any, drawCallB: any): number;
    /**
     * Set up the viewport and the scissor for camera rendering.
     *
     * @param {import('../camera.js').Camera} camera - The camera containing the viewport
     * information.
     * @param {import('../../platform/graphics/render-target.js').RenderTarget} [renderTarget] - The
     * render target. NULL for the default one.
     */
    setupViewport(camera: Camera, renderTarget?: RenderTarget): void;
    setCameraUniforms(camera: any, target: any): number;
    /**
     * Clears the active render target. If the viewport is already set up, only its area is cleared.
     *
     * @param {import('../camera.js').Camera} camera - The camera supplying the value to clear to.
     * @param {boolean} [clearColor] - True if the color buffer should be cleared. Uses the value
     * from the camera if not supplied.
     * @param {boolean} [clearDepth] - True if the depth buffer should be cleared. Uses the value
     * from the camera if not supplied.
     * @param {boolean} [clearStencil] - True if the stencil buffer should be cleared. Uses the
     * value from the camera if not supplied.
     */
    clear(camera: Camera, clearColor?: boolean, clearDepth?: boolean, clearStencil?: boolean): void;
    setCamera(camera: any, target: any, clear: any, renderAction?: any): void;
    clearView(camera: any, target: any, clear: any, forceWrite: any): void;
    setupCullMode(cullFaces: any, flipFactor: any, drawCall: any): void;
    updateCameraFrustum(camera: any): void;
    setBaseConstants(device: any, material: any): void;
    updateCpuSkinMatrices(drawCalls: any): void;
    /**
     * Update skin matrices ahead of rendering.
     *
     * @param {import('../mesh-instance.js').MeshInstance[]|Set<import('../mesh-instance.js').MeshInstance>} drawCalls - MeshInstances
     * containing skinInstance.
     * @ignore
     */
    updateGpuSkinMatrices(drawCalls: MeshInstance[] | Set<MeshInstance>): void;
    /**
     * Update morphing ahead of rendering.
     *
     * @param {import('../mesh-instance.js').MeshInstance[]|Set<import('../mesh-instance.js').MeshInstance>} drawCalls - MeshInstances
     * containing morphInstance.
     * @ignore
     */
    updateMorphing(drawCalls: MeshInstance[] | Set<MeshInstance>): void;
    /**
     * Update gsplats ahead of rendering.
     *
     * @param {import('../mesh-instance.js').MeshInstance[]|Set<import('../mesh-instance.js').MeshInstance>} drawCalls - MeshInstances
     * containing gsplatInstances.
     * @ignore
     */
    updateGSplats(drawCalls: MeshInstance[] | Set<MeshInstance>): void;
    /**
     * Update draw calls ahead of rendering.
     *
     * @param {import('../mesh-instance.js').MeshInstance[]|Set<import('../mesh-instance.js').MeshInstance>} drawCalls - MeshInstances
     * requiring updates.
     * @ignore
     */
    gpuUpdate(drawCalls: MeshInstance[] | Set<MeshInstance>): void;
    setVertexBuffers(device: any, mesh: any): void;
    setMorphing(device: any, morphInstance: any): void;
    setSkinning(device: any, meshInstance: any): void;
    dispatchViewPos(position: any): void;
    initViewBindGroupFormat(isClustered: any): void;
    setupViewUniformBuffers(viewBindGroups: any, viewUniformFormat: any, viewBindGroupFormat: any, viewCount: any): void;
    setupMeshUniformBuffers(shaderInstance: any, meshInstance: any): void;
    drawInstance(device: any, meshInstance: any, mesh: any, style: any, normal: any): void;
    drawInstance2(device: any, meshInstance: any, mesh: any, style: any): void;
    /**
     * @param {import('../camera.js').Camera} camera - The camera used for culling.
     * @param {import('../mesh-instance.js').MeshInstance[]} drawCalls - Draw calls to cull.
     * @param {import('../layer.js').CulledInstances} culledInstances - Stores culled instances.
     */
    cull(camera: Camera, drawCalls: MeshInstance[], culledInstances: CulledInstances): void;
    collectLights(comp: any): void;
    cullLights(camera: any, lights: any): void;
    /**
     * Shadow map culling for directional and visible local lights
     * visible meshInstances are collected into light._renderData, and are marked as visible
     * for directional lights also shadow camera matrix is set up
     *
     * @param {import('../composition/layer-composition.js').LayerComposition} comp - The layer
     * composition.
     */
    cullShadowmaps(comp: LayerComposition): void;
    /**
     * visibility culling of lights, meshInstances, shadows casters
     * Also applies meshInstance.visible
     *
     * @param {import('../composition/layer-composition.js').LayerComposition} comp - The layer
     * composition.
     */
    cullComposition(comp: LayerComposition): void;
    /**
     * @param {import('../mesh-instance.js').MeshInstance[]} drawCalls - Mesh instances.
     * @param {boolean} onlyLitShaders - Limits the update to shaders affected by lighting.
     */
    updateShaders(drawCalls: MeshInstance[], onlyLitShaders: boolean): void;
    updateFrameUniforms(): void;
    /**
     * @param {import('../composition/layer-composition.js').LayerComposition} comp - The layer
     * composition to update.
     */
    beginFrame(comp: LayerComposition): void;
    updateLightTextureAtlas(): void;
    /**
     * Updates the layer composition for rendering.
     *
     * @param {import('../composition/layer-composition.js').LayerComposition} comp - The layer
     * composition to update.
     */
    updateLayerComposition(comp: LayerComposition): void;
    frameUpdate(): void;
}

/**
 * The forward renderer renders {@link Scene}s.
 *
 * @ignore
 */
declare class ForwardRenderer extends Renderer {
    static skipRenderCamera: any;
    static _skipRenderCounter: number;
    static skipRenderAfter: number;
    _forwardDrawCalls: number;
    _materialSwitches: number;
    _depthMapTime: number;
    _forwardTime: number;
    _sortTime: number;
    fogColorId: ScopeId;
    fogStartId: ScopeId;
    fogEndId: ScopeId;
    fogDensityId: ScopeId;
    ambientId: ScopeId;
    skyboxIntensityId: ScopeId;
    cubeMapRotationMatrixId: ScopeId;
    pcssDiskSamplesId: ScopeId;
    pcssSphereSamplesId: ScopeId;
    lightColorId: any[];
    lightDir: any[];
    lightDirId: any[];
    lightShadowMapId: any[];
    lightShadowMatrixId: any[];
    lightShadowParamsId: any[];
    lightShadowIntensity: any[];
    lightRadiusId: any[];
    lightPos: any[];
    lightPosId: any[];
    lightWidth: any[];
    lightWidthId: any[];
    lightHeight: any[];
    lightHeightId: any[];
    lightInAngleId: any[];
    lightOutAngleId: any[];
    lightCookieId: any[];
    lightCookieIntId: any[];
    lightCookieMatrixId: any[];
    lightCookieOffsetId: any[];
    lightShadowSearchAreaId: any[];
    lightCameraParamsId: any[];
    shadowMatrixPaletteId: any[];
    shadowCascadeDistancesId: any[];
    shadowCascadeCountId: any[];
    screenSizeId: ScopeId;
    _screenSize: Float32Array;
    fogColor: Float32Array;
    ambientColor: Float32Array;
    pcssDiskSamples: number[];
    pcssSphereSamples: number[];
    /**
     * @param {import('../scene.js').Scene} scene - The scene.
     */
    dispatchGlobalLights(scene: Scene): void;
    _resolveLight(scope: any, i: any): void;
    setLTCDirectionalLight(wtm: any, cnt: any, dir: any, campos: any, far: any): void;
    dispatchDirectLights(dirs: any, scene: any, mask: any, camera: any): number;
    setLTCPositionalLight(wtm: any, cnt: any): void;
    dispatchOmniLight(scene: any, scope: any, omni: any, cnt: any): void;
    dispatchSpotLight(scene: any, scope: any, spot: any, cnt: any): void;
    dispatchLocalLights(sortedLights: any, scene: any, mask: any, usedDirLights: any): void;
    renderForwardPrepareMaterials(camera: any, drawCalls: any, sortedLights: any, layer: any, pass: any): {
        drawCalls: any[];
        shaderInstances: any[];
        isNewMaterial: any[];
        lightMaskChanged: any[];
        clear: () => void;
    };
    renderForwardInternal(camera: any, preparedCalls: any, sortedLights: any, pass: any, drawCallback: any, flipFaces: any): void;
    renderForward(camera: any, allDrawCalls: any, sortedLights: any, pass: any, drawCallback: any, layer: any, flipFaces: any): void;
    /**
     * Forward render mesh instances on a specified layer, using a camera and a render target.
     * Shaders used are based on the shaderPass provided, with optional clustered lighting support.
     *
     * @param {import('../camera.js').Camera} camera - The
     * camera.
     * @param {import('../../platform/graphics/render-target.js').RenderTarget} renderTarget - The
     * render target.
     * @param {import('../layer.js').Layer} layer - The layer.
     * @param {boolean} transparent - True if transparent sublayer should be rendered, opaque
     * otherwise.
     * @param {number} shaderPass - A type of shader to use during rendering.
     * @param {import('../../platform/graphics/bind-group.js').BindGroup[]} viewBindGroups - An array
     * storing the view level bing groups (can be empty array, and this function populates if per
     * view).
     * @param {object} [options] - Object for passing optional arguments.
     * @param {boolean} [options.clearColors] - True if the color buffer should be cleared.
     * @param {boolean} [options.clearDepth] - True if the depth buffer should be cleared.
     * @param {boolean} [options.clearStencil] - True if the stencil buffer should be cleared.
     * @param {import('../lighting/world-clusters.js').WorldClusters} [options.lightClusters] - The
     * world clusters object to be used for clustered lighting.
     * @param {import('../mesh-instance.js').MeshInstance[]} [options.meshInstances] - The mesh
     * instances to be rendered. Use when layer is not provided.
     * @param {object} [options.splitLights] - The split lights to be used for clustered lighting.
     */
    renderForwardLayer(camera: Camera, renderTarget: RenderTarget, layer: Layer, transparent: boolean, shaderPass: number, viewBindGroups: BindGroup[], options?: {
        clearColors?: boolean;
        clearDepth?: boolean;
        clearStencil?: boolean;
        lightClusters?: WorldClusters;
        meshInstances?: MeshInstance[];
        splitLights?: object;
    }): void;
    setSceneConstants(): void;
    /**
     * Builds a frame graph for the rendering of the whole frame.
     *
     * @param {import('../frame-graph.js').FrameGraph} frameGraph - The frame-graph that is built.
     * @param {import('../composition/layer-composition.js').LayerComposition} layerComposition - The
     * layer composition used to build the frame graph.
     * @ignore
     */
    buildFrameGraph(frameGraph: FrameGraph, layerComposition: LayerComposition): void;
    /**
     * @param {import('../frame-graph.js').FrameGraph} frameGraph - The frame graph.
     * @param {import('../composition/layer-composition.js').LayerComposition} layerComposition - The
     * layer composition.
     */
    addMainRenderPass(frameGraph: FrameGraph, layerComposition: LayerComposition, renderTarget: any, startIndex: any, endIndex: any): void;
    /**
     * @param {import('../composition/layer-composition.js').LayerComposition} comp - The layer
     * composition.
     */
    update(comp: LayerComposition): void;
}

declare class LightmapFilters {
    constructor(device: any);
    device: any;
    shaderDilate: Shader;
    constantTexSource: any;
    constantPixelOffset: any;
    pixelOffset: Float32Array;
    shaderDenoise: Shader;
    sigmas: Float32Array;
    constantSigmas: any;
    kernel: any;
    setSourceTexture(texture: any): void;
    prepare(textureWidth: any, textureHeight: any): void;
    prepareDenoise(filterRange: any, filterSmoothness: any): void;
    constantKernel: any;
    bZnorm: any;
    evaluateDenoiseUniforms(filterRange: any, filterSmoothness: any): void;
}

/**
 * The lightmapper is used to bake scene lights into textures.
 *
 * @category Graphics
 */
declare class Lightmapper {
    /**
     * Create a new Lightmapper instance.
     *
     * @param {import('../../platform/graphics/graphics-device.js').GraphicsDevice} device - The
     * graphics device used by the lightmapper.
     * @param {import('../entity.js').Entity} root - The root entity of the scene.
     * @param {import('../../scene/scene.js').Scene} scene - The scene to lightmap.
     * @param {import('../../scene/renderer/forward-renderer.js').ForwardRenderer} renderer - The
     * renderer.
     * @param {import('../asset/asset-registry.js').AssetRegistry} assets - Registry of assets to
     * lightmap.
     * @hideconstructor
     */
    constructor(device: GraphicsDevice, root: Entity, scene: Scene, renderer: ForwardRenderer, assets: AssetRegistry);
    device: GraphicsDevice;
    root: Entity;
    scene: Scene;
    renderer: ForwardRenderer;
    assets: AssetRegistry;
    shadowMapCache: ShadowMapCache;
    _tempSet: Set<any>;
    _initCalled: boolean;
    passMaterials: any[];
    ambientAOMaterial: StandardMaterial;
    fog: string;
    ambientLight: Color;
    renderTargets: Map<any, any>;
    stats: {
        renderPasses: number;
        lightmapCount: number;
        totalRenderTime: number;
        forwardTime: number;
        fboTime: number;
        shadowMapTime: number;
        compileTime: number;
        shadersLinked: number;
    };
    destroy(): void;
    blackTex: Texture;
    camera: Camera;
    initBake(device: any): void;
    lightmapFilters: LightmapFilters;
    constantBakeDir: any;
    materials: any[];
    lightingParams: LightingParams;
    worldClusters: WorldClusters;
    finishBake(bakeNodes: any): void;
    createMaterialForPass(device: any, scene: any, pass: any, addAmbient: any): StandardMaterial;
    createMaterials(device: any, scene: any, passCount: any): void;
    createTexture(size: any, name: any): Texture;
    collectModels(node: any, bakeNodes: any, allNodes: any): void;
    prepareShadowCasters(nodes: any): any[];
    updateTransforms(nodes: any): void;
    calculateLightmapSize(node: any): number;
    setLightmapping(nodes: any, value: any, passCount: any, shaderDefs: any): void;
    /**
     * Generates and applies the lightmaps.
     *
     * @param {import('../entity.js').Entity[]|null} nodes - An array of entities (with model or
     * render components) to render lightmaps for. If not supplied, the entire scene will be baked.
     * @param {number} [mode] - Baking mode. Can be:
     *
     * - {@link BAKE_COLOR}: single color lightmap
     * - {@link BAKE_COLORDIR}: single color lightmap + dominant light direction (used for
     * bump/specular)
     *
     * Only lights with bakeDir=true will be used for generating the dominant light direction.
     * Defaults to {@link BAKE_COLORDIR}.
     */
    bake(nodes: Entity[] | null, mode?: number): void;
    allocateTextures(bakeNodes: any, passCount: any): void;
    prepareLightsToBake(layerComposition: any, allLights: any, bakeLights: any): void;
    restoreLights(allLights: any): void;
    setupScene(): void;
    restoreScene(): void;
    computeNodeBounds(meshInstances: any): BoundingBox;
    computeNodesBounds(nodes: any): void;
    computeBounds(meshInstances: any): BoundingBox;
    backupMaterials(meshInstances: any): void;
    restoreMaterials(meshInstances: any): void;
    lightCameraPrepare(device: any, bakeLight: any): any;
    lightCameraPrepareAndCull(bakeLight: any, bakeNode: any, shadowCam: any, casterBounds: any): boolean;
    setupLightArray(lightArray: any, light: any): void;
    renderShadowMap(comp: any, shadowMapRendered: any, casters: any, bakeLight: any): boolean;
    postprocessTextures(device: any, bakeNodes: any, passCount: any): void;
    bakeInternal(passCount: any, bakeNodes: any, allNodes: any): void;
}

/**
 * AppOptions is an object that holds configuration settings utilized in the creation of AppBase. It
 * allows functionality to be included or excluded from the AppBase instance.
 */
declare class AppOptions {
    /**
     * Input handler for {@link ElementComponent}s.
     *
     * @type {import('./input/element-input.js').ElementInput}
     */
    elementInput: ElementInput;
    /**
     * Keyboard handler for input.
     *
     * @type {import('../platform/input/keyboard.js').Keyboard}
     */
    keyboard: Keyboard;
    /**
     * Mouse handler for input.
     *
     * @type {import('../platform/input/mouse.js').Mouse}
     */
    mouse: Mouse;
    /**
     * TouchDevice handler for input.
     *
     * @type {import('../platform/input/touch-device.js').TouchDevice}
     */
    touch: TouchDevice;
    /**
     * Gamepad handler for input.
     *
     * @type {import('../platform/input/game-pads.js').GamePads}
     */
    gamepads: GamePads;
    /**
     * Prefix to apply to script urls before loading.
     *
     * @type {string}
     */
    scriptPrefix: string;
    /**
     * Prefix to apply to asset urls before loading.
     *
     * @type {string}
     */
    assetPrefix: string;
    /**
     * Scripts in order of loading first.
     *
     * @type {string[]}
     */
    scriptsOrder: string[];
    /**
     * The sound manager
     *
     * @type {import('../platform/sound/manager.js').SoundManager}
     */
    soundManager: SoundManager;
    /**
     * The graphics device.
     *
     * @type {import('../platform/graphics/graphics-device.js').GraphicsDevice}
     */
    graphicsDevice: GraphicsDevice;
    /**
     * The lightmapper.
     *
     * @type {typeof import('./lightmapper/lightmapper.js').Lightmapper}
     */
    lightmapper: typeof Lightmapper;
    /**
     * The BatchManager.
     *
     * @type {typeof import('../scene/batching/batch-manager.js').BatchManager}
     */
    batchManager: typeof BatchManager;
    /**
     * The XrManager.
     *
     * @type {typeof import('./xr/xr-manager.js').XrManager}
     */
    xr: typeof XrManager;
    /**
     * The component systems the app requires.
     *
     * @type {typeof import('./components/system.js').ComponentSystem[]}
     */
    componentSystems: typeof ComponentSystem[];
    /**
     * The resource handlers the app requires.
     *
     * @type {typeof import('./handlers/handler.js').ResourceHandler[]}
     */
    resourceHandlers: typeof ResourceHandler[];
}

/**
 * Records performance-related statistics related to the application.
 *
 * @ignore
 */
declare class ApplicationStats {
    /**
     * Create a new ApplicationStats instance.
     *
     * @param {import('../platform/graphics/graphics-device.js').GraphicsDevice} device - The
     * graphics device.
     */
    constructor(device: GraphicsDevice);
    frame: {
        fps: number;
        ms: number;
        dt: number;
        updateStart: number;
        updateTime: number;
        renderStart: number;
        renderTime: number;
        physicsStart: number;
        physicsTime: number;
        cullTime: number;
        sortTime: number;
        skinTime: number;
        morphTime: number;
        instancingTime: number;
        triangles: number;
        otherPrimitives: number;
        shaders: number;
        materials: number;
        cameras: number;
        shadowMapUpdates: number;
        shadowMapTime: number;
        depthMapTime: number;
        forwardTime: number;
        lightClustersTime: number;
        lightClusters: number;
        _timeToCountFrames: number;
        _fpsAccum: number;
    };
    drawCalls: {
        forward: number;
        depth: number;
        shadow: number;
        immediate: number;
        misc: number;
        total: number;
        skinned: number;
        instanced: number;
        removedByInstancing: number;
    };
    misc: {
        renderTargetCreationTime: number;
    };
    particles: {
        updatesPerFrame: number;
        _updatesPerFrame: number;
        frameTime: number;
        _frameTime: number;
    };
    shaders: {
        vsCompiled: number;
        fsCompiled: number;
        linked: number;
        materialShaders: number;
        compileTime: number;
    };
    vram: {
        texShadow: number;
        texAsset: number;
        texLightmap: number;
        tex: number;
        vb: number;
        ib: number;
        ub: number;
    };
    get scene(): any;
    get lightmapper(): any;
    get batcher(): any;
}

/**
 * Container for all {@link ScriptType}s that are available to this application. Note that
 * PlayCanvas scripts can access the Script Registry from inside the application with
 * {@link AppBase#scripts}.
 *
 * @augments EventHandler
 * @category Script
 */
declare class ScriptRegistry extends EventHandler {
    /**
     * Create a new ScriptRegistry instance.
     *
     * @param {import('../app-base.js').AppBase} app - Application to attach registry to.
     */
    constructor(app: AppBase);
    app: AppBase;
    _scripts: {};
    _list: any[];
    destroy(): void;
    /**
     * Add {@link ScriptType} to registry. Note: when {@link createScript} is called, it will add
     * the {@link ScriptType} to the registry automatically. If a script already exists in
     * registry, and the new script has a `swap` method defined, it will perform code hot swapping
     * automatically in async manner.
     *
     * @param {typeof ScriptType} script - Script Type that is created
     * using {@link createScript}.
     * @returns {boolean} True if added for the first time or false if script already exists.
     * @example
     * var PlayerController = pc.createScript('playerController');
     * // playerController Script Type will be added to pc.ScriptRegistry automatically
     * console.log(app.scripts.has('playerController')); // outputs true
     */
    add(script: typeof ScriptType): boolean;
    /**
     * Remove {@link ScriptType}.
     *
     * @param {string|typeof ScriptType} nameOrType - The name or type
     * of {@link ScriptType}.
     * @returns {boolean} True if removed or False if already not in registry.
     * @example
     * app.scripts.remove('playerController');
     */
    remove(nameOrType: string | typeof ScriptType): boolean;
    /**
     * Get {@link ScriptType} by name.
     *
     * @param {string} name - Name of a {@link ScriptType}.
     * @returns {typeof ScriptType} The Script Type if it exists in the
     * registry or null otherwise.
     * @example
     * var PlayerController = app.scripts.get('playerController');
     */
    get(name: string): typeof ScriptType;
    /**
     * Check if a {@link ScriptType} with the specified name is in the registry.
     *
     * @param {string|typeof ScriptType} nameOrType - The name or type
     * of {@link ScriptType}.
     * @returns {boolean} True if {@link ScriptType} is in registry.
     * @example
     * if (app.scripts.has('playerController')) {
     *     // playerController is in pc.ScriptRegistry
     * }
     */
    has(nameOrType: string | typeof ScriptType): boolean;
    /**
     * Get list of all {@link ScriptType}s from registry.
     *
     * @returns {Array<typeof ScriptType>} list of all {@link ScriptType}s
     * in registry.
     * @example
     * // logs array of all Script Type names available in registry
     * console.log(app.scripts.list().map(function (o) {
     *     return o.name;
     * }));
     */
    list(): Array<typeof ScriptType>;
}

declare class I18nParser {
    _validate(data: any): void;
    parse(data: any): any;
}

/**
 * Handles localization. Responsible for loading localization assets and returning translations for
 * a certain key. Can also handle plural forms. To override its default behavior define a different
 * implementation for {@link I18n#getText} and {@link I18n#getPluralText}.
 *
 * @augments EventHandler
 */
declare class I18n extends EventHandler {
    /**
     * Returns the first available locale based on the desired locale specified. First tries to
     * find the desired locale and then tries to find an alternative locale based on the language.
     *
     * @param {string} desiredLocale - The desired locale e.g. en-US.
     * @param {object} availableLocales - A dictionary where each key is an available locale.
     * @returns {string} The locale found or if no locale is available returns the default en-US
     * locale.
     * @example
     * // With a defined dictionary of locales
     * const availableLocales = { en: 'en-US', fr: 'fr-FR' };
     * const locale = pc.I18n.getText('en-US', availableLocales);
     * // returns 'en'
     * @ignore
     */
    static findAvailableLocale(desiredLocale: string, availableLocales: object): string;
    /**
     * Create a new I18n instance.
     *
     * @param {import('../app-base.js').AppBase} app - The application.
     */
    constructor(app: AppBase);
    /**
     * The current locale for example "en-US". Changing the locale will raise an event which will
     * cause localized Text Elements to change language to the new locale.
     *
     * @type {string}
     */
    set locale(arg: any);
    get locale(): any;
    _translations: {};
    _availableLangs: {};
    _app: AppBase;
    _assets: any[];
    _parser: I18nParser;
    /**
     * An array of asset ids or assets that contain localization data in the expected format. I18n
     * will automatically load translations from these assets as the assets are loaded and it will
     * also automatically unload translations if the assets get removed or unloaded at runtime.
     *
     * @type {number[]|Asset[]}
     */
    set assets(arg: any[]);
    get assets(): any[];
    _locale: any;
    _lang: any;
    _pluralFn: any;
    /**
     * Returns the first available locale based on the desired locale specified. First tries to
     * find the desired locale in the loaded translations and then tries to find an alternative
     * locale based on the language.
     *
     * @param {string} desiredLocale - The desired locale e.g. en-US.
     * @returns {string} The locale found or if no locale is available returns the default en-US
     * locale.
     * @example
     * const locale = this.app.i18n.getText('en-US');
     */
    findAvailableLocale(desiredLocale: string): string;
    /**
     * Returns the translation for the specified key and locale. If the locale is not specified it
     * will use the current locale.
     *
     * @param {string} key - The localization key.
     * @param {string} [locale] - The desired locale.
     * @returns {string} The translated text. If no translations are found at all for the locale
     * then it will return the en-US translation. If no translation exists for that key then it will
     * return the localization key.
     * @example
     * const localized = this.app.i18n.getText('localization-key');
     * const localizedFrench = this.app.i18n.getText('localization-key', 'fr-FR');
     */
    getText(key: string, locale?: string): string;
    /**
     * Returns the pluralized translation for the specified key, number n and locale. If the locale
     * is not specified it will use the current locale.
     *
     * @param {string} key - The localization key.
     * @param {number} n - The number used to determine which plural form to use. E.g. For the
     * phrase "5 Apples" n equals 5.
     * @param {string} [locale] - The desired locale.
     * @returns {string} The translated text. If no translations are found at all for the locale
     * then it will return the en-US translation. If no translation exists for that key then it
     * will return the localization key.
     * @example
     * // manually replace {number} in the resulting translation with our number
     * const localized = this.app.i18n.getPluralText('{number} apples', number).replace("{number}", number);
     */
    getPluralText(key: string, n: number, locale?: string): string;
    /**
     * Adds localization data. If the locale and key for a translation already exists it will be
     * overwritten.
     *
     * @param {object} data - The localization data. See example for the expected format of the
     * data.
     * @example
     * this.app.i18n.addData({
     *     header: {
     *         version: 1
     *     },
     *     data: [{
     *         info: {
     *             locale: 'en-US'
     *         },
     *         messages: {
     *             "key": "translation",
     *             // The number of plural forms depends on the locale. See the manual for more information.
     *             "plural_key": ["one item", "more than one items"]
     *         }
     *     }, {
     *         info: {
     *             locale: 'fr-FR'
     *         },
     *         messages: {
     *             // ...
     *         }
     *     }]
     * });
     */
    addData(data: object): void;
    /**
     * Removes localization data.
     *
     * @param {object} data - The localization data. The data is expected to be in the same format
     * as {@link I18n#addData}.
     */
    removeData(data: object): void;
    /**
     * Frees up memory.
     */
    destroy(): void;
    _findFallbackLocale(locale: any, lang: any): any;
    _onAssetAdd(asset: any): void;
    _onAssetLoad(asset: any): void;
    _onAssetChange(asset: any): void;
    _onAssetRemove(asset: any): void;
    _onAssetUnload(asset: any): void;
}

/**
 * Item to be stored in the {@link SceneRegistry}.
 *
 * @category Graphics
 */
declare class SceneRegistryItem {
    /**
     * Creates a new SceneRegistryItem instance.
     *
     * @param {string} name - The name of the scene.
     * @param {string} url - The url of the scene file.
     */
    constructor(name: string, url: string);
    /**
     * The name of the scene.
     *
     * @type {string}
     */
    name: string;
    /**
     * The url of the scene file.
     *
     * @type {string}
     */
    url: string;
    /** @ignore */
    data: any;
    /** @private */
    private _loading;
    /** @private */
    private _onLoadedCallbacks;
    /**
     * Returns true if the scene data has loaded.
     *
     * @type {boolean}
     */
    get loaded(): boolean;
    /**
     * Returns true if the scene data is still being loaded.
     *
     * @type {boolean}
     */
    get loading(): boolean;
}

/**
 * Callback used by {@link SceneRegistryloadSceneHierarchy }.
 */
export type LoadHierarchyCallback = (err: string | null, entity?: Entity) => any;
/**
 * Callback used by {@link SceneRegistryloadSceneSettings }.
 */
export type LoadSettingsCallback = (err: string | null) => any;
/**
 * Callback used by {@link SceneRegistrychangeScene }.
 */
export type ChangeSceneCallback = (err: string | null, entity?: Entity) => any;
/**
 * Callback used by {@link SceneRegistryloadScene }.
 */
export type LoadSceneCallback = (err: string | null, entity?: Entity) => any;
/**
 * Callback used by {@link SceneRegistryloadSceneData }.
 */
export type LoadSceneDataCallback = (err: string | null, sceneItem?: SceneRegistryItem) => any;
/**
 * Callback used by {@link SceneRegistry#loadSceneHierarchy}.
 *
 * @callback LoadHierarchyCallback
 * @param {string|null} err - The error message in the case where the loading or parsing fails.
 * @param {import('./entity.js').Entity} [entity] - The loaded root entity if no errors were encountered.
 */
/**
 * Callback used by {@link SceneRegistry#loadSceneSettings}.
 *
 * @callback LoadSettingsCallback
 * @param {string|null} err - The error message in the case where the loading or parsing fails.
 */
/**
 * Callback used by {@link SceneRegistry#changeScene}.
 *
 * @callback ChangeSceneCallback
 * @param {string|null} err - The error message in the case where the loading or parsing fails.
 * @param {import('./entity.js').Entity} [entity] - The loaded root entity if no errors were encountered.
 */
/**
 * Callback used by {@link SceneRegistry#loadScene}.
 *
 * @callback LoadSceneCallback
 * @param {string|null} err - The error message in the case where the loading or parsing fails.
 * @param {import('./entity.js').Entity} [entity] - The loaded root entity if no errors were encountered.
 */
/**
 * Callback used by {@link SceneRegistry#loadSceneData}.
 *
 * @callback LoadSceneDataCallback
 * @param {string|null} err - The error message in the case where the loading or parsing fails.
 * @param {SceneRegistryItem} [sceneItem] - The scene registry item if no errors were encountered.
 */
/**
 * Container for storing and loading of scenes. An instance of the registry is created on the
 * {@link AppBase} object as {@link AppBase#scenes}.
 *
 * @category Graphics
 */
declare class SceneRegistry {
    /**
     * Create a new SceneRegistry instance.
     *
     * @param {import('./app-base.js').AppBase} app - The application.
     */
    constructor(app: AppBase);
    /**
     * @type {import('./app-base.js').AppBase}
     * @private
     */
    private _app;
    /**
     * @type {SceneRegistryItem[]}
     * @private
     */
    private _list;
    /** @private */
    private _index;
    /** @private */
    private _urlIndex;
    /** @ignore */
    destroy(): void;
    /**
     * Return the list of scene.
     *
     * @returns {SceneRegistryItem[]} All items in the registry.
     */
    list(): SceneRegistryItem[];
    /**
     * Add a new item to the scene registry.
     *
     * @param {string} name - The name of the scene.
     * @param {string} url - The url of the scene file.
     * @returns {boolean} Returns true if the scene was successfully added to the registry, false otherwise.
     */
    add(name: string, url: string): boolean;
    /**
     * Find a Scene by name and return the {@link SceneRegistryItem}.
     *
     * @param {string} name - The name of the scene.
     * @returns {SceneRegistryItem|null} The stored data about a scene or null if no scene with
     * that name exists.
     */
    find(name: string): SceneRegistryItem | null;
    /**
     * Find a scene by the URL and return the {@link SceneRegistryItem}.
     *
     * @param {string} url - The URL to search by.
     * @returns {SceneRegistryItem|null} The stored data about a scene or null if no scene with
     * that URL exists.
     */
    findByUrl(url: string): SceneRegistryItem | null;
    /**
     * Remove an item from the scene registry.
     *
     * @param {string} name - The name of the scene.
     */
    remove(name: string): void;
    /**
     * Private function to load scene data with the option to cache. This allows us to retain
     * expected behavior of loadSceneSettings and loadSceneHierarchy where they don't store loaded
     * data which may be undesired behavior with projects that have many scenes.
     *
     * @param {SceneRegistryItem | string} sceneItem - The scene item (which can be found with
     * {@link SceneRegistry#find}, URL of the scene file (e.g."scene_id.json") or name of the scene.
     * @param {boolean} storeInCache - Whether to store the loaded data in the scene item.
     * @param {LoadSceneDataCallback} callback - The function to call after loading,
     * passed (err, sceneItem) where err is null if no errors occurred.
     * @private
     */
    private _loadSceneData;
    /**
     * Loads and stores the scene data to reduce the number of the network requests when the same
     * scenes are loaded multiple times. Can also be used to load data before calling
     * {@link SceneRegistry#loadSceneHierarchy} and {@link SceneRegistry#loadSceneSettings} to make
     * scene loading quicker for the user.
     *
     * @param {SceneRegistryItem | string} sceneItem - The scene item (which can be found with
     * {@link SceneRegistry#find}, URL of the scene file (e.g."scene_id.json") or name of the scene.
     * @param {LoadSceneDataCallback} callback - The function to call after loading,
     * passed (err, sceneItem) where err is null if no errors occurred.
     * @example
     * const sceneItem = app.scenes.find("Scene Name");
     * app.scenes.loadSceneData(sceneItem, function (err, sceneItem) {
     *     if (err) {
     *         // error
     *     }
     * });
     */
    loadSceneData(sceneItem: SceneRegistryItem | string, callback: LoadSceneDataCallback): void;
    /**
     * Unloads scene data that has been loaded previously using {@link SceneRegistry#loadSceneData}.
     *
     * @param {SceneRegistryItem | string} sceneItem - The scene item (which can be found with
     * {@link SceneRegistry#find} or URL of the scene file. Usually this will be "scene_id.json".
     * @example
     * const sceneItem = app.scenes.find("Scene Name");
     * app.scenes.unloadSceneData(sceneItem);
     */
    unloadSceneData(sceneItem: SceneRegistryItem | string): void;
    _loadSceneHierarchy(sceneItem: any, onBeforeAddHierarchy: any, callback: any): void;
    /**
     * Load a scene file, create and initialize the Entity hierarchy and add the hierarchy to the
     * application root Entity.
     *
     * @param {SceneRegistryItem | string} sceneItem - The scene item (which can be found with
     * {@link SceneRegistry#find}, URL of the scene file (e.g."scene_id.json") or name of the scene.
     * @param {LoadHierarchyCallback} callback - The function to call after loading,
     * passed (err, entity) where err is null if no errors occurred.
     * @example
     * const sceneItem = app.scenes.find("Scene Name");
     * app.scenes.loadSceneHierarchy(sceneItem, function (err, entity) {
     *     if (!err) {
     *         const e = app.root.find("My New Entity");
     *     } else {
     *         // error
     *     }
     * });
     */
    loadSceneHierarchy(sceneItem: SceneRegistryItem | string, callback: LoadHierarchyCallback): void;
    /**
     * Load a scene file and apply the scene settings to the current scene.
     *
     * @param {SceneRegistryItem | string} sceneItem - The scene item (which can be found with
     * {@link SceneRegistry#find}, URL of the scene file (e.g."scene_id.json") or name of the scene.
     * @param {LoadSettingsCallback} callback - The function called after the settings
     * are applied. Passed (err) where err is null if no error occurred.
     * @example
     * const sceneItem = app.scenes.find("Scene Name");
     * app.scenes.loadSceneSettings(sceneItem, function (err) {
     *     if (!err) {
     *         // success
     *     } else {
     *         // error
     *     }
     * });
     */
    loadSceneSettings(sceneItem: SceneRegistryItem | string, callback: LoadSettingsCallback): void;
    /**
     * Change to a new scene. Calling this function will load the scene data, delete all
     * entities and graph nodes under `app.root` and load the scene settings and hierarchy.
     *
     * @param {SceneRegistryItem | string} sceneItem - The scene item (which can be found with
     * {@link SceneRegistry#find}, URL of the scene file (e.g."scene_id.json") or name of the scene.
     * @param {ChangeSceneCallback} [callback] - The function to call after loading,
     * passed (err, entity) where err is null if no errors occurred.
     * @example
     * app.scenes.changeScene("Scene Name", function (err, entity) {
     *     if (!err) {
     *         // success
     *     } else {
     *         // error
     *     }
     * });
     */
    changeScene(sceneItem: SceneRegistryItem | string, callback?: ChangeSceneCallback): void;
    /**
     * Load the scene hierarchy and scene settings. This is an internal method used by the
     * {@link AppBase}.
     *
     * @param {string} url - The URL of the scene file.
     * @param {LoadSceneCallback} callback - The function called after the settings are
     * applied. Passed (err, scene) where err is null if no error occurred and scene is the
     * {@link Scene}.
     */
    loadScene(url: string, callback: LoadSceneCallback): void;
}

/**
 * The ZoneComponent allows you to define an area in world space of certain size. This can be used
 * in various ways, such as affecting audio reverb when {@link AudioListenerComponent} is within
 * zone. Or create culling system with portals between zones to hide whole indoor sections for
 * performance reasons. And many other possible options. Zones are building blocks and meant to be
 * used in many different ways.
 *
 * @augments Component
 * @ignore
 */
declare class ZoneComponent extends Component {
    /**
     * Fired when the zone component is enabled. This event does not take into account the enabled
     * state of the entity or any of its ancestors.
     *
     * @event
     * @example
     * entity.zone.on('enable', () => {
     *     console.log(`Zone component of entity '${entity.name}' has been enabled`);
     * });
     */
    static EVENT_ENABLE: string;
    /**
     * Fired when the zone component is disabled. This event does not take into account the enabled
     * state of the entity or any of its ancestors.
     *
     * @event
     * @example
     * entity.zone.on('disable', () => {
     *     console.log(`Zone component of entity '${entity.name}' has been disabled`);
     * });
     */
    static EVENT_DISABLE: string;
    /**
     * Fired when the enabled state of the zone component changes. This event does not take into
     * account the enabled state of the entity or any of its ancestors.
     *
     * @event
     * @example
     * entity.zone.on('state', (enabled) => {
     *     console.log(`Zone component of entity '${entity.name}' has been ${enabled ? 'enabled' : 'disabled'}`);
     * });
     */
    static EVENT_STATE: string;
    /**
     * Fired when a zone component is removed from an entity.
     *
     * @event
     * @example
     * entity.zone.on('remove', () => {
     *     console.log(`Zone component removed from entity '${entity.name}'`);
     * });
     */
    static EVENT_REMOVE: string;
    /**
     * Create a new ZoneComponent instance.
     *
     * @param {import('./system.js').ZoneComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {import('../../entity.js').Entity} entity - The Entity that this Component is
     * attached to.
     */
    constructor(system: ZoneComponentSystem, entity: Entity);
    _oldState: boolean;
    _size: Vec3;
    /**
     * The size of the axis-aligned box of this ZoneComponent.
     *
     * @type {Vec3}
     */
    set size(arg: Vec3);
    get size(): Vec3;
    _onSetEnabled(prop: any, old: any, value: any): void;
    _checkState(): void;
    _onBeforeRemove(): void;
}

declare class ZoneComponentData {
    enabled: boolean;
}

/**
 * Creates and manages {@link ZoneComponent} instances.
 *
 * @augments ComponentSystem
 * @ignore
 */
declare class ZoneComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof ZoneComponent;
    DataType: typeof ZoneComponentData;
    schema: string[];
    initializeComponentData(component: any, data: any, properties: any): void;
    cloneComponent(entity: any, clone: any): Component;
    _onBeforeRemove(entity: any, component: any): void;
}

/**
 * Handles playing of sprite animations and loading of relevant sprite assets.
 *
 * @augments EventHandler
 * @category Graphics
 */
declare class SpriteAnimationClip extends EventHandler {
    /**
     * Fired when the clip starts playing.
     *
     * @event
     * @example
     * clip.on('play', () => {
     *     console.log('Clip started playing');
     * });
     */
    static EVENT_PLAY: string;
    /**
     * Fired when the clip is paused.
     *
     * @event
     * @example
     * clip.on('pause', () => {
     *     console.log('Clip paused');
     * });
     */
    static EVENT_PAUSE: string;
    /**
     * Fired when the clip is resumed.
     *
     * @event
     * @example
     * clip.on('resume', () => {
     *     console.log('Clip resumed');
     * });
     */
    static EVENT_RESUME: string;
    /**
     * Fired when the clip is stopped.
     *
     * @event
     * @example
     * clip.on('stop', () => {
     *     console.log('Clip stopped');
     * });
     */
    static EVENT_STOP: string;
    /**
     * Fired when the clip stops playing because it reached its end.
     *
     * @event
     * @example
     * clip.on('end', () => {
     *     console.log('Clip ended');
     * });
     */
    static EVENT_END: string;
    /**
     * Fired when the clip reached the end of its current loop.
     *
     * @event
     * @example
     * clip.on('loop', () => {
     *     console.log('Clip looped');
     * });
     */
    static EVENT_LOOP: string;
    /**
     * Create a new SpriteAnimationClip instance.
     *
     * @param {import('./component.js').SpriteComponent} component - The sprite component managing
     * this clip.
     * @param {object} data - Data for the new animation clip.
     * @param {number} [data.fps] - Frames per second for the animation clip.
     * @param {boolean} [data.loop] - Whether to loop the animation clip.
     * @param {string} [data.name] - The name of the new animation clip.
     * @param {number} [data.spriteAsset] - The id of the sprite asset that this clip will play.
     */
    constructor(component: SpriteComponent, data: {
        fps?: number;
        loop?: boolean;
        name?: string;
        spriteAsset?: number;
    });
    _component: SpriteComponent;
    _frame: number;
    _sprite: any;
    _spriteAsset: any;
    /**
     * The id of the sprite asset used to play the animation.
     *
     * @type {number}
     */
    set spriteAsset(arg: any);
    get spriteAsset(): any;
    name: string;
    fps: number;
    loop: boolean;
    _playing: boolean;
    _paused: boolean;
    _time: number;
    /**
     * The total duration of the animation in seconds.
     *
     * @type {number}
     */
    get duration(): number;
    /**
     * The index of the frame of the {@link Sprite} currently being rendered.
     *
     * @type {number}
     */
    set frame(arg: number);
    get frame(): number;
    /**
     * Whether the animation is currently paused.
     *
     * @type {boolean}
     */
    get isPaused(): boolean;
    /**
     * Whether the animation is currently playing.
     *
     * @type {boolean}
     */
    get isPlaying(): boolean;
    /**
     * The current sprite used to play the animation.
     *
     * @type {import('../../../scene/sprite.js').Sprite}
     */
    set sprite(arg: any);
    get sprite(): any;
    /**
     * The current time of the animation in seconds.
     *
     * @type {number}
     */
    set time(arg: number);
    get time(): number;
    _onSpriteAssetAdded(asset: any): void;
    _bindSpriteAsset(asset: any): void;
    _unbindSpriteAsset(asset: any): void;
    _onSpriteAssetLoad(asset: any): void;
    _onTextureAtlasLoad(atlasAsset: any): void;
    _onSpriteAssetRemove(asset: any): void;
    _onSpriteMeshesChange(): void;
    _onSpritePpuChanged(): void;
    /**
     * Advances the animation, looping if necessary.
     *
     * @param {number} dt - The delta time.
     * @private
     */
    private _update;
    _setTime(value: any): void;
    _setFrame(value: any): void;
    _destroy(): void;
    /**
     * Plays the animation. If it's already playing then this does nothing.
     */
    play(): void;
    /**
     * Pauses the animation.
     */
    pause(): void;
    /**
     * Resumes the paused animation.
     */
    resume(): void;
    /**
     * Stops the animation and resets the animation to the first frame.
     */
    stop(): void;
}

/**
 * Enables an Entity to render a simple static sprite or sprite animations.
 *
 * @augments Component
 * @category Graphics
 */
declare class SpriteComponent extends Component {
    /**
     * Fired when an animation clip starts playing. The handler is passed the
     * {@link SpriteAnimationClip} that started playing.
     *
     * @event
     * @example
     * entity.sprite.on('play', (clip) => {
     *     console.log(`Animation clip ${clip.name} started playing.`);
     * });
     */
    static EVENT_PLAY: string;
    /**
     * Fired when an animation clip is paused. The handler is passed the
     * {@link SpriteAnimationClip} that was paused.
     *
     * @event
     * @example
     * entity.sprite.on('pause', (clip) => {
     *     console.log(`Animation clip ${clip.name} paused.`);
     * });
     */
    static EVENT_PAUSE: string;
    /**
     * Fired when an animation clip is resumed. The handler is passed the
     * {@link SpriteAnimationClip} that was resumed.
     *
     * @event
     * @example
     * entity.sprite.on('resume', (clip) => {
     *     console.log(`Animation clip ${clip.name} resumed.`);
     * });
     */
    static EVENT_RESUME: string;
    /**
     * Fired when an animation clip is stopped. The handler is passed the
     * {@link SpriteAnimationClip} that was stopped.
     *
     * @event
     * @example
     * entity.sprite.on('stop', (clip) => {
     *     console.log(`Animation clip ${clip.name} stopped.`);
     * });
     */
    static EVENT_STOP: string;
    /**
     * Fired when an animation clip stops playing because it reached its end. The handler is passed
     * the {@link SpriteAnimationClip} that ended.
     *
     * @event
     * @example
     * entity.sprite.on('end', (clip) => {
     *     console.log(`Animation clip ${clip.name} ended.`);
     * });
     */
    static EVENT_END: string;
    /**
     * Fired when an animation clip reached the end of its current loop. The handler is passed the
     * {@link SpriteAnimationClip} that looped.
     *
     * @event
     * @example
     * entity.sprite.on('loop', (clip) => {
     *     console.log(`Animation clip ${clip.name} looped.`);
     * });
     */
    static EVENT_LOOP: string;
    /**
     * Create a new SpriteComponent instance.
     *
     * @param {import('./system.js').SpriteComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {import('../../entity.js').Entity} entity - The Entity that this Component is
     * attached to.
     */
    constructor(system: SpriteComponentSystem, entity: Entity);
    _type: string;
    _material: any;
    _color: Color;
    _colorUniform: Float32Array;
    _speed: number;
    _flipX: boolean;
    _flipY: boolean;
    _width: number;
    _height: number;
    _drawOrder: number;
    _layers: number[];
    _outerScale: Vec2;
    _outerScaleUniform: Float32Array;
    _innerOffset: Vec4;
    _innerOffsetUniform: Float32Array;
    _atlasRect: Vec4;
    _atlasRectUniform: Float32Array;
    _batchGroupId: number;
    _batchGroup: any;
    _node: GraphNode;
    _model: Model;
    _meshInstance: MeshInstance;
    _updateAabbFunc: any;
    _addedModel: boolean;
    _autoPlayClip: any;
    /**
     * Dictionary of sprite animation clips.
     *
     * @type {Object<string, SpriteAnimationClip>}
     * @private
     */
    private _clips;
    _defaultClip: SpriteAnimationClip;
    /**
     * The sprite animation clip currently playing.
     *
     * @type {SpriteAnimationClip}
     * @private
     */
    private _currentClip;
    /**
     * The type of the SpriteComponent. Can be:
     *
     * - {@link SPRITETYPE_SIMPLE}: The component renders a single frame from a sprite asset.
     * - {@link SPRITETYPE_ANIMATED}: The component can play sprite animation clips.
     *
     * Defaults to {@link SPRITETYPE_SIMPLE}.
     *
     * @type {string}
     */
    set type(arg: string);
    get type(): string;
    /**
     * The frame counter of the sprite. Specifies which frame from the current sprite asset to
     * render.
     *
     * @type {number}
     */
    set frame(arg: number);
    get frame(): number;
    /**
     * The asset id or the {@link Asset} of the sprite to render. Only works for
     * {@link SPRITETYPE_SIMPLE} sprites.
     *
     * @type {number|import('../../asset/asset.js').Asset}
     */
    set spriteAsset(arg: any);
    get spriteAsset(): any;
    /**
     * The current sprite.
     *
     * @type {import('../../../scene/sprite.js').Sprite}
     */
    set sprite(arg: any);
    get sprite(): any;
    set material(arg: any);
    get material(): any;
    /**
     * The color tint of the sprite.
     *
     * @type {Color}
     */
    set color(arg: Color);
    get color(): Color;
    /**
     * The opacity of the sprite.
     *
     * @type {number}
     */
    set opacity(arg: number);
    get opacity(): number;
    /**
     * A dictionary that contains {@link SpriteAnimationClip}s.
     *
     * @type {Object<string, SpriteAnimationClip>}
     */
    set clips(arg: {
        [x: string]: SpriteAnimationClip;
    });
    get clips(): {
        [x: string]: SpriteAnimationClip;
    };
    /**
     * The current clip being played.
     *
     * @type {SpriteAnimationClip}
     */
    get currentClip(): SpriteAnimationClip;
    /**
     * A global speed modifier used when playing sprite animation clips.
     *
     * @type {number}
     */
    set speed(arg: number);
    get speed(): number;
    /**
     * Flip the X axis when rendering a sprite.
     *
     * @type {boolean}
     */
    set flipX(arg: boolean);
    get flipX(): boolean;
    /**
     * Flip the Y axis when rendering a sprite.
     *
     * @type {boolean}
     */
    set flipY(arg: boolean);
    get flipY(): boolean;
    /**
     * The width of the sprite when rendering using 9-Slicing. The width and height are only used
     * when the render mode of the sprite asset is Sliced or Tiled.
     *
     * @type {number}
     */
    set width(arg: number);
    get width(): number;
    /**
     * The height of the sprite when rendering using 9-Slicing. The width and height are only used
     * when the render mode of the sprite asset is Sliced or Tiled.
     *
     * @type {number}
     */
    set height(arg: number);
    get height(): number;
    /**
     * Assign sprite to a specific batch group (see {@link BatchGroup}). Default is -1 (no group).
     *
     * @type {number}
     */
    set batchGroupId(arg: number);
    get batchGroupId(): number;
    /**
     * The name of the clip to play automatically when the component is enabled and the clip exists.
     *
     * @type {string}
     */
    set autoPlayClip(arg: any);
    get autoPlayClip(): any;
    /**
     * The draw order of the component. A higher value means that the component will be rendered on
     * top of other components in the same layer. This is not used unless the layer's sort order is
     * set to {@link SORTMODE_MANUAL}.
     *
     * @type {number}
     */
    set drawOrder(arg: number);
    get drawOrder(): number;
    /**
     * An array of layer IDs ({@link Layer#id}) to which this sprite should belong.
     *
     * @type {number[]}
     */
    set layers(arg: number[]);
    get layers(): number[];
    get aabb(): any;
    onDestroy(): void;
    _showModel(): void;
    _hideModel(): void;
    _showFrame(frame: any): void;
    _updateTransform(): void;
    _updateAabb(aabb: any): any;
    _tryAutoPlay(): void;
    _onLayersChanged(oldComp: any, newComp: any): void;
    _onLayerAdded(layer: any): void;
    _onLayerRemoved(layer: any): void;
    removeModelFromLayers(): void;
    /**
     * Creates and adds a new {@link SpriteAnimationClip} to the component's clips.
     *
     * @param {object} data - Data for the new animation clip.
     * @param {string} [data.name] - The name of the new animation clip.
     * @param {number} [data.fps] - Frames per second for the animation clip.
     * @param {boolean} [data.loop] - Whether to loop the animation clip.
     * @param {number|import('../../asset/asset.js').Asset} [data.spriteAsset] - The asset id or
     * the {@link Asset} of the sprite that this clip will play.
     * @returns {SpriteAnimationClip} The new clip that was added.
     */
    addClip(data: {
        name?: string;
        fps?: number;
        loop?: boolean;
        spriteAsset?: number | Asset;
    }): SpriteAnimationClip;
    /**
     * Removes a clip by name.
     *
     * @param {string} name - The name of the animation clip to remove.
     */
    removeClip(name: string): void;
    /**
     * Get an animation clip by name.
     *
     * @param {string} name - The name of the clip.
     * @returns {SpriteAnimationClip} The clip.
     */
    clip(name: string): SpriteAnimationClip;
    /**
     * Plays a sprite animation clip by name. If the animation clip is already playing then this
     * will do nothing.
     *
     * @param {string} name - The name of the clip to play.
     * @returns {SpriteAnimationClip} The clip that started playing.
     */
    play(name: string): SpriteAnimationClip;
    /**
     * Pauses the current animation clip.
     */
    pause(): void;
    /**
     * Resumes the current paused animation clip.
     */
    resume(): void;
    /**
     * Stops the current animation clip and resets it to the first frame.
     */
    stop(): void;
}

declare class SpriteComponentData {
    enabled: boolean;
}

/**
 * Manages creation of {@link SpriteComponent}s.
 *
 * @augments ComponentSystem
 * @category Graphics
 */
declare class SpriteComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof SpriteComponent;
    DataType: typeof SpriteComponentData;
    schema: string[];
    _defaultTexture: Texture;
    _defaultMaterial: any;
    _default9SlicedMaterialSlicedMode: any;
    _default9SlicedMaterialTiledMode: any;
    set defaultMaterial(arg: any);
    get defaultMaterial(): any;
    set default9SlicedMaterialSlicedMode(arg: any);
    get default9SlicedMaterialSlicedMode(): any;
    set default9SlicedMaterialTiledMode(arg: any);
    get default9SlicedMaterialTiledMode(): any;
    initializeComponentData(component: any, data: any, properties: any): void;
    cloneComponent(entity: any, clone: any): Component;
    onUpdate(dt: any): void;
    onBeforeRemove(entity: any, component: any): void;
}

/**
 * Represents the resource of an audio asset.
 *
 * @category Sound
 */
declare class Sound {
    /**
     * Create a new Sound instance.
     *
     * @param {HTMLAudioElement|AudioBuffer} resource - If the Web Audio API is supported, pass an
     * AudioBuffer object, otherwise an Audio object.
     */
    constructor(resource: HTMLAudioElement | AudioBuffer);
    /**
     * If the Web Audio API is not supported this contains the audio data.
     *
     * @type {HTMLAudioElement}
     */
    audio: HTMLAudioElement;
    /**
     * If the Web Audio API is supported this contains the audio data.
     *
     * @type {AudioBuffer}
     */
    buffer: AudioBuffer;
    /**
     * Gets the duration of the sound. If the sound is not loaded it returns 0.
     *
     * @type {number}
     */
    get duration(): number;
}

/**
 * A SoundInstance plays a {@link Sound}.
 *
 * @augments EventHandler
 * @category Sound
 */
declare class SoundInstance extends EventHandler {
    /**
     * Fired when the instance starts playing its source.
     *
     * @event
     * @example
     * instance.on('play', () => {
     *     console.log('Instance started playing');
     * });
     */
    static EVENT_PLAY: string;
    /**
     * Fired when the instance is paused.
     *
     * @event
     * @example
     * instance.on('pause', () => {
     *     console.log('Instance paused');
     * });
     */
    static EVENT_PAUSE: string;
    /**
     * Fired when the instance is resumed.
     *
     * @event
     * @example
     * instance.on('resume', () => {
     *     console.log('Instance resumed');
     * });
     */
    static EVENT_RESUME: string;
    /**
     * Fired when the instance is stopped.
     *
     * @event
     * @example
     * instance.on('stop', () => {
     *     console.log('Instance stopped');
     * });
     */
    static EVENT_STOP: string;
    /**
     * Fired when the sound currently played by the instance ends.
     *
     * @event
     * @example
     * instance.on('end', () => {
     *     console.log('Instance ended');
     * });
     */
    static EVENT_END: string;
    /**
     * Create a new SoundInstance instance.
     *
     * @param {import('./manager.js').SoundManager} manager - The sound manager.
     * @param {import('./sound.js').Sound} sound - The sound to play.
     * @param {object} options - Options for the instance.
     * @param {number} [options.volume] - The playback volume, between 0 and 1. Defaults to 1.
     * @param {number} [options.pitch] - The relative pitch. Defaults to 1 (plays at normal pitch).
     * @param {boolean} [options.loop] - Whether the sound should loop when it reaches the end or
     * not. Defaults to false.
     * @param {number} [options.startTime] - The time from which the playback will start in
     * seconds. Default is 0 to start at the beginning. Defaults to 0.
     * @param {number} [options.duration] - The total time after the startTime in seconds when
     * playback will stop or restart if loop is true. Defaults to 0.
     * @param {Function} [options.onPlay] - Function called when the instance starts playing.
     * @param {Function} [options.onPause] - Function called when the instance is paused.
     * @param {Function} [options.onResume] - Function called when the instance is resumed.
     * @param {Function} [options.onStop] - Function called when the instance is stopped.
     * @param {Function} [options.onEnd] - Function called when the instance ends.
     */
    constructor(manager: SoundManager, sound: Sound, options: {
        volume?: number;
        pitch?: number;
        loop?: boolean;
        startTime?: number;
        duration?: number;
        onPlay?: Function;
        onPause?: Function;
        onResume?: Function;
        onStop?: Function;
        onEnd?: Function;
    });
    /**
     * Gets the source that plays the sound resource. If the Web Audio API is not supported the
     * type of source is [Audio](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio).
     * Source is only available after calling play.
     *
     * @type {AudioBufferSourceNode}
     */
    source: AudioBufferSourceNode;
    /**
     * @type {import('./manager.js').SoundManager}
     * @private
     */
    private _manager;
    /**
     * @type {number}
     * @private
     */
    private _volume;
    /**
     * @type {number}
     * @private
     */
    private _pitch;
    /**
     * @type {boolean}
     * @private
     */
    private _loop;
    /**
     * @type {import('./sound.js').Sound}
     * @private
     */
    private _sound;
    /**
     * Start at 'stopped'.
     *
     * @type {number}
     * @private
     */
    private _state;
    /**
     * True if the manager was suspended.
     *
     * @type {boolean}
     * @private
     */
    private _suspended;
    /**
     * Greater than 0 if we want to suspend the event handled to the 'onended' event.
     * When an 'onended' event is suspended, this counter is decremented by 1.
     * When a future 'onended' event is to be suspended, this counter is incremented by 1.
     *
     * @type {number}
     * @private
     */
    private _suspendEndEvent;
    /**
     * True if we want to suspend firing instance events.
     *
     * @type {boolean}
     * @private
     */
    private _suspendInstanceEvents;
    /**
     * If true then the instance will start playing its source when its created.
     *
     * @type {boolean}
     * @private
     */
    private _playWhenLoaded;
    /**
     * @type {number}
     * @private
     */
    private _startTime;
    /**
     * @type {number}
     * @private
     */
    private _duration;
    /**
     * @type {number|null}
     * @private
     */
    private _startOffset;
    /** @private */
    private _onPlayCallback;
    /** @private */
    private _onPauseCallback;
    /** @private */
    private _onResumeCallback;
    /** @private */
    private _onStopCallback;
    /** @private */
    private _onEndCallback;
    /**
     * @type {number}
     * @private
     */
    private _startedAt;
    /**
     * Manually keep track of the playback position because the Web Audio API does not
     * provide a way to do this accurately if the playbackRate is not 1.
     *
     * @type {number}
     * @private
     */
    private _currentTime;
    /**
     * @type {number}
     * @private
     */
    private _currentOffset;
    /**
     * The input node is the one that is connected to the source.
     *
     * @type {AudioNode|null}
     * @private
     */
    private _inputNode;
    /**
     * The connected node is the one that is connected to the destination (speakers). Any
     * external nodes will be connected to this node.
     *
     * @type {AudioNode|null}
     * @private
     */
    private _connectorNode;
    /**
     * The first external node set by a user.
     *
     * @type {AudioNode|null}
     * @private
     */
    private _firstNode;
    /**
     * The last external node set by a user.
     *
     * @type {AudioNode|null}
     * @private
     */
    private _lastNode;
    /**
     * Set to true if a play() request was issued when the AudioContext was still suspended,
     * and will therefore wait until it is resumed to play the audio.
     *
     * @type {boolean}
     * @private
     */
    private _waitingContextSuspension;
    /** @private */
    private _endedHandler;
    /** @private */
    private _isReady;
    /** @private */
    private _loadedMetadataHandler;
    /** @private */
    private _timeUpdateHandler;
    /**
     * Gets or sets the current time of the sound that is playing. If the value provided is bigger
     * than the duration of the instance it will wrap from the beginning.
     *
     * @type {number}
     */
    set currentTime(arg: number);
    get currentTime(): number;
    /**
     * The duration of the sound that the instance will play starting from startTime.
     *
     * @type {number}
     */
    set duration(arg: number);
    get duration(): number;
    /**
     * Returns true if the instance is currently paused.
     *
     * @type {boolean}
     */
    get isPaused(): boolean;
    /**
     * Returns true if the instance is currently playing.
     *
     * @type {boolean}
     */
    get isPlaying(): boolean;
    /**
     * Returns true if the instance is currently stopped.
     *
     * @type {boolean}
     */
    get isStopped(): boolean;
    /**
     * Returns true if the instance is currently suspended because the window is not focused.
     *
     * @type {boolean}
     */
    get isSuspended(): boolean;
    /**
     * If true the instance will restart when it finishes playing.
     *
     * @type {boolean}
     */
    set loop(arg: boolean);
    get loop(): boolean;
    /**
     * The pitch modifier to play the sound with. Must be larger than 0.01.
     *
     * @type {number}
     */
    set pitch(arg: number);
    get pitch(): number;
    /**
     * The sound resource that the instance will play.
     *
     * @type {import('./sound.js').Sound}
     */
    set sound(arg: Sound);
    get sound(): Sound;
    /**
     * The start time from which the sound will start playing.
     *
     * @type {number}
     */
    set startTime(arg: number);
    get startTime(): number;
    /**
     * The volume modifier to play the sound with. In range 0-1.
     *
     * @type {number}
     */
    set volume(arg: number);
    get volume(): number;
    /** @private */
    private _onPlay;
    /** @private */
    private _onPause;
    /** @private */
    private _onResume;
    /** @private */
    private _onStop;
    /** @private */
    private _onEnded;
    /**
     * Handle the manager's 'volumechange' event.
     *
     * @private
     */
    private _onManagerVolumeChange;
    /**
     * Handle the manager's 'suspend' event.
     *
     * @private
     */
    private _onManagerSuspend;
    /**
     * Handle the manager's 'resume' event.
     *
     * @private
     */
    private _onManagerResume;
    /**
     * Creates internal audio nodes and connects them.
     *
     * @private
     */
    private _initializeNodes;
    gain: GainNode;
    /**
     * Attempt to begin playback the sound.
     * If the AudioContext is suspended, the audio will only start once it's resumed.
     * If the sound is already playing, this will restart the sound.
     *
     * @returns {boolean} True if the sound was started immediately.
     */
    play(): boolean;
    /**
     * Immediately play the sound.
     * This method assumes the AudioContext is ready (not suspended or locked).
     *
     * @private
     */
    private _playAudioImmediate;
    /**
     * Pauses playback of sound. Call resume() to resume playback from the same position.
     *
     * @returns {boolean} Returns true if the sound was paused.
     */
    pause(): boolean;
    /**
     * Resumes playback of the sound. Playback resumes at the point that the audio was paused.
     *
     * @returns {boolean} Returns true if the sound was resumed.
     */
    resume(): boolean;
    /**
     * Stops playback of sound. Calling play() again will restart playback from the beginning of
     * the sound.
     *
     * @returns {boolean} Returns true if the sound was stopped.
     */
    stop(): boolean;
    /**
     * Connects external Web Audio API nodes. You need to pass the first node of the node graph
     * that you created externally and the last node of that graph. The first node will be
     * connected to the audio source and the last node will be connected to the destination of the
     * AudioContext (e.g. speakers). Requires Web Audio API support.
     *
     * @param {AudioNode} firstNode - The first node that will be connected to the audio source of sound instances.
     * @param {AudioNode} [lastNode] - The last node that will be connected to the destination of the AudioContext.
     * If unspecified then the firstNode will be connected to the destination instead.
     * @example
     * const context = app.systems.sound.context;
     * const analyzer = context.createAnalyzer();
     * const distortion = context.createWaveShaper();
     * const filter = context.createBiquadFilter();
     * analyzer.connect(distortion);
     * distortion.connect(filter);
     * instance.setExternalNodes(analyzer, filter);
     */
    setExternalNodes(firstNode: AudioNode, lastNode?: AudioNode): void;
    /**
     * Clears any external nodes set by {@link SoundInstance#setExternalNodes}.
     */
    clearExternalNodes(): void;
    /**
     * Gets any external nodes set by {@link SoundInstance#setExternalNodes}.
     *
     * @returns {AudioNode[]} Returns an array that contains the two nodes set by
     * {@link SoundInstance#setExternalNodes}.
     */
    getExternalNodes(): AudioNode[];
    /**
     * Creates the source for the instance.
     *
     * @returns {AudioBufferSourceNode|null} Returns the created source or null if the sound
     * instance has no {@link Sound} associated with it.
     * @private
     */
    private _createSource;
    /**
     * Sets the current time taking into account the time the instance started playing, the current
     * pitch and the current time offset.
     *
     * @private
     */
    private _updateCurrentTime;
    /**
     * Handle the manager's 'destroy' event.
     *
     * @private
     */
    private _onManagerDestroy;
}

/**
 * The SoundSlot controls playback of an audio asset.
 *
 * @augments EventHandler
 * @category Sound
 */
declare class SoundSlot extends EventHandler {
    /**
     * Fired when a {@link SoundInstance} starts playing on a slot. The handler is passed the sound
     * instance that started playing.
     *
     * @event
     * @example
     * slot.on('play', (instance) => {
     *     console.log('Sound instance started playing');
     * });
     */
    static EVENT_PLAY: string;
    /**
     * Fired when a {@link SoundInstance} is paused on a slot. The handler is passed the sound
     * instance that is paused.
     *
     * @event
     * @example
     * slot.on('pause', (instance) => {
     *     console.log('Sound instance paused');
     * });
     */
    static EVENT_PAUSE: string;
    /**
     * Fired when a {@link SoundInstance} is resumed on a slot. The handler is passed the sound
     * instance that is resumed.
     *
     * @event
     * @example
     * slot.on('resume', (instance) => {
     *     console.log('Sound instance resumed');
     * });
     */
    static EVENT_RESUME: string;
    /**
     * Fired when a {@link SoundInstance} is stopped on a slot. The handler is passed the sound
     * instance that is stopped.
     *
     * @event
     * @example
     * slot.on('stop', (instance) => {
     *     console.log('Sound instance stopped');
     * });
     */
    static EVENT_STOP: string;
    /**
     * Fired when the sound {@link Asset} assigned to the slot is loaded. The handler is passed the
     * loaded {@link Sound} resource.
     *
     * @event
     * @example
     * slot.on('load', (sound) => {
     *     console.log('Sound resource loaded');
     * });
     */
    static EVENT_LOAD: string;
    /**
     * Create a new SoundSlot.
     *
     * @param {import('./component.js').SoundComponent} component - The Component that created this
     * slot.
     * @param {string} [name] - The name of the slot. Defaults to 'Untitled'.
     * @param {object} [options] - Settings for the slot.
     * @param {number} [options.volume] - The playback volume, between 0 and 1.
     * @param {number} [options.pitch] - The relative pitch, default of 1, plays at normal pitch.
     * @param {boolean} [options.loop] - If true the sound will restart when it reaches the end.
     * @param {number} [options.startTime] - The start time from which the sound will start
     * playing.
     * @param {number} [options.duration] - The duration of the sound that the slot will play
     * starting from startTime.
     * @param {boolean} [options.overlap] - If true then sounds played from slot will be played
     * independently of each other. Otherwise the slot will first stop the current sound before
     * starting the new one.
     * @param {boolean} [options.autoPlay] - If true the slot will start playing as soon as its
     * audio asset is loaded.
     * @param {number} [options.asset] - The asset id of the audio asset that is going to be played
     * by this slot.
     */
    constructor(component: SoundComponent, name?: string, options?: {
        volume?: number;
        pitch?: number;
        loop?: boolean;
        startTime?: number;
        duration?: number;
        overlap?: boolean;
        autoPlay?: boolean;
        asset?: number;
    });
    /**
     * The name of the slot.
     *
     * @type {string}
     */
    name: string;
    /**
     * An array that contains all the {@link SoundInstance}s currently being played by the slot.
     *
     * @type {SoundInstance[]}
     */
    instances: SoundInstance[];
    _component: SoundComponent;
    _assets: AssetRegistry;
    _manager: any;
    _volume: number;
    _pitch: number;
    _loop: boolean;
    _duration: number;
    _startTime: number;
    _overlap: boolean;
    _autoPlay: boolean;
    _firstNode: AudioNode;
    _lastNode: AudioNode;
    _asset: number;
    _onInstancePlayHandler: any;
    _onInstancePauseHandler: any;
    _onInstanceResumeHandler: any;
    _onInstanceStopHandler: any;
    _onInstanceEndHandler: any;
    /**
     * Plays a sound. If {@link SoundSlot#overlap} is true the new sound instance will be played
     * independently of any other instances already playing. Otherwise existing sound instances
     * will stop before playing the new sound.
     *
     * @returns {SoundInstance} The new sound instance.
     */
    play(): SoundInstance;
    /**
     * Pauses all sound instances. To continue playback call {@link SoundSlot#resume}.
     *
     * @returns {boolean} True if the sound instances paused successfully, false otherwise.
     */
    pause(): boolean;
    /**
     * Resumes playback of all paused sound instances.
     *
     * @returns {boolean} True if any instances were resumed.
     */
    resume(): boolean;
    /**
     * Stops playback of all sound instances.
     *
     * @returns {boolean} True if any instances were stopped.
     */
    stop(): boolean;
    /**
     * Loads the asset assigned to this slot.
     */
    load(): void;
    /**
     * Connect external Web Audio API nodes. Any sound played by this slot will automatically
     * attach the specified nodes to the source that plays the sound. You need to pass the first
     * node of the node graph that you created externally and the last node of that graph. The
     * first node will be connected to the audio source and the last node will be connected to the
     * destination of the AudioContext (e.g. speakers).
     *
     * @param {AudioNode} firstNode - The first node that will be connected to the audio source of
     * sound instances.
     * @param {AudioNode} [lastNode] - The last node that will be connected to the destination of
     * the AudioContext. If unspecified then the firstNode will be connected to the destination
     * instead.
     * @example
     * const context = app.systems.sound.context;
     * const analyzer = context.createAnalyzer();
     * const distortion = context.createWaveShaper();
     * const filter = context.createBiquadFilter();
     * analyzer.connect(distortion);
     * distortion.connect(filter);
     * slot.setExternalNodes(analyzer, filter);
     */
    setExternalNodes(firstNode: AudioNode, lastNode?: AudioNode): void;
    /**
     * Clears any external nodes set by {@link SoundSlot#setExternalNodes}.
     */
    clearExternalNodes(): void;
    /**
     * Gets an array that contains the two external nodes set by {@link SoundSlot#setExternalNodes}.
     *
     * @returns {AudioNode[]} An array of 2 elements that contains the first and last nodes set by
     * {@link SoundSlot#setExternalNodes}.
     */
    getExternalNodes(): AudioNode[];
    /**
     * Reports whether an asset is set on this slot.
     *
     * @returns {boolean} Returns true if the slot has an asset assigned.
     * @private
     */
    private _hasAsset;
    /**
     * Creates a new {@link SoundInstance} with the properties of the slot.
     *
     * @returns {SoundInstance} The new instance.
     * @private
     */
    private _createInstance;
    _onInstancePlay(instance: any): void;
    _onInstancePause(instance: any): void;
    _onInstanceResume(instance: any): void;
    _onInstanceStop(instance: any): void;
    _onInstanceEnd(instance: any): void;
    _onAssetAdd(asset: any): void;
    _onAssetLoad(asset: any): void;
    _onAssetRemoved(asset: any): void;
    updatePosition(position: any): void;
    /**
     * The asset id.
     *
     * @type {number|null}
     */
    set asset(arg: number);
    get asset(): number;
    /**
     * If true the slot will begin playing as soon as it is loaded.
     *
     * @type {boolean}
     */
    set autoPlay(arg: boolean);
    get autoPlay(): boolean;
    /**
     * The duration of the sound that the slot will play starting from startTime.
     *
     * @type {number}
     */
    set duration(arg: number);
    get duration(): number;
    /**
     * Returns true if the asset of the slot is loaded.
     *
     * @type {boolean}
     */
    get isLoaded(): boolean;
    /**
     * Returns true if the slot is currently paused.
     *
     * @type {boolean}
     */
    get isPaused(): boolean;
    /**
     * Returns true if the slot is currently playing.
     *
     * @type {boolean}
     */
    get isPlaying(): boolean;
    /**
     * Returns true if the slot is currently stopped.
     *
     * @type {boolean}
     */
    get isStopped(): boolean;
    /**
     * If true the slot will restart when it finishes playing.
     *
     * @type {boolean}
     */
    set loop(arg: boolean);
    get loop(): boolean;
    /**
     * If true then sounds played from slot will be played independently of each other. Otherwise
     * the slot will first stop the current sound before starting the new one.
     *
     * @type {boolean}
     */
    set overlap(arg: boolean);
    get overlap(): boolean;
    /**
     * The pitch modifier to play the sound with. Must be larger than 0.01.
     *
     * @type {number}
     */
    set pitch(arg: number);
    get pitch(): number;
    /**
     * The start time from which the sound will start playing.
     *
     * @type {number}
     */
    set startTime(arg: number);
    get startTime(): number;
    /**
     * The volume modifier to play the sound with. In range 0-1.
     *
     * @type {number}
     */
    set volume(arg: number);
    get volume(): number;
}

/**
 * The Sound Component controls playback of {@link Sound}s.
 *
 * @augments Component
 * @category Sound
 */
declare class SoundComponent extends Component {
    /**
     * Fired when a sound instance starts playing. The handler is passed the {@link SoundSlot} and
     * the {@link SoundInstance} that started playing.
     *
     * @event
     * @example
     * entity.sound.on('play', (slot, instance) => {
     *     console.log(`Sound ${slot.name} started playing`);
     * });
     */
    static EVENT_PLAY: string;
    /**
     * Fired when a sound instance is paused. The handler is passed the {@link SoundSlot} and the
     * {@link SoundInstance} that was paused.
     *
     * @event
     * @example
     * entity.sound.on('pause', (slot, instance) => {
     *     console.log(`Sound ${slot.name} paused`);
     * });
     */
    static EVENT_PAUSE: string;
    /**
     * Fired when a sound instance is resumed. The handler is passed the {@link SoundSlot} and the
     * {@link SoundInstance} that was resumed.
     *
     * @event
     * @example
     * entity.sound.on('resume', (slot, instance) => {
     *     console.log(`Sound ${slot.name} resumed`);
     * });
     */
    static EVENT_RESUME: string;
    /**
     * Fired when a sound instance is stopped. The handler is passed the {@link SoundSlot} and the
     * {@link SoundInstance} that was stopped.
     *
     * @event
     * @example
     * entity.sound.on('stop', (slot, instance) => {
     *     console.log(`Sound ${slot.name} stopped`);
     * });
     */
    static EVENT_STOP: string;
    /**
     * Fired when a sound instance stops playing because it reached its end. The handler is passed
     * the {@link SoundSlot} and the {@link SoundInstance} that ended.
     *
     * @event
     * @example
     * entity.sound.on('end', (slot, instance) => {
     *     console.log(`Sound ${slot.name} ended`);
     * });
     */
    static EVENT_END: string;
    /**
     * Create a new Sound Component.
     *
     * @param {import('./system.js').SoundComponentSystem} system - The ComponentSystem that
     * created this component.
     * @param {import('../../entity.js').Entity} entity - The entity that the Component is attached
     * to.
     */
    constructor(system: SoundComponentSystem, entity: Entity);
    /** @private */
    private _volume;
    /** @private */
    private _pitch;
    /** @private */
    private _positional;
    /** @private */
    private _refDistance;
    /** @private */
    private _maxDistance;
    /** @private */
    private _rollOffFactor;
    /** @private */
    private _distanceModel;
    /**
     * @type {Object<string, SoundSlot>}
     * @private
     */
    private _slots;
    /** @private */
    private _playingBeforeDisable;
    /**
     * Update the specified property on all sound instances.
     *
     * @param {string} property - The name of the SoundInstance property to update.
     * @param {string|number} value - The value to set the property to.
     * @param {boolean} isFactor - True if the value is a factor of the slot property or false
     * if it is an absolute value.
     * @private
     */
    private _updateSoundInstances;
    /**
     * Determines which algorithm to use to reduce the volume of the sound as it moves away from
     * the listener. Can be:
     *
     * - {@link DISTANCE_LINEAR}
     * - {@link DISTANCE_INVERSE}
     * - {@link DISTANCE_EXPONENTIAL}
     *
     * Defaults to {@link DISTANCE_LINEAR}.
     *
     * @type {string}
     */
    set distanceModel(arg: string);
    get distanceModel(): string;
    /**
     * The maximum distance from the listener at which audio falloff stops. Note the volume of the
     * audio is not 0 after this distance, but just doesn't fall off anymore. Defaults to 10000.
     *
     * @type {number}
     */
    set maxDistance(arg: number);
    get maxDistance(): number;
    /**
     * The reference distance for reducing volume as the sound source moves further from the
     * listener. Defaults to 1.
     *
     * @type {number}
     */
    set refDistance(arg: number);
    get refDistance(): number;
    /**
     * The factor used in the falloff equation. Defaults to 1.
     *
     * @type {number}
     */
    set rollOffFactor(arg: number);
    get rollOffFactor(): number;
    /**
     * The pitch modifier to play the audio with. Must be larger than 0.01. Defaults to 1.
     *
     * @type {number}
     */
    set pitch(arg: number);
    get pitch(): number;
    /**
     * The volume modifier to play the audio with. In range 0-1. Defaults to 1.
     *
     * @type {number}
     */
    set volume(arg: number);
    get volume(): number;
    /**
     * If true the audio will play back at the location of the Entity in space, so the audio will
     * be affected by the position of the {@link AudioListenerComponent}. Defaults to true.
     *
     * @type {boolean}
     */
    set positional(arg: boolean);
    get positional(): boolean;
    /**
     * A dictionary that contains the {@link SoundSlot}s managed by this SoundComponent.
     *
     * @type {Object<string, SoundSlot>}
     */
    set slots(arg: {
        [x: string]: SoundSlot;
    });
    get slots(): {
        [x: string]: SoundSlot;
    };
    onRemove(): void;
    /**
     * Creates a new {@link SoundSlot} with the specified name.
     *
     * @param {string} name - The name of the slot.
     * @param {object} [options] - Settings for the slot.
     * @param {number} [options.volume] - The playback volume, between 0 and 1. Defaults to 1.
     * @param {number} [options.pitch] - The relative pitch. Defaults to 1 (plays at normal pitch).
     * @param {boolean} [options.loop] - If true the sound will restart when it reaches the end.
     * Defaults to false.
     * @param {number} [options.startTime] - The start time from which the sound will start playing.
     * Defaults to 0 to start at the beginning.
     * @param {number} [options.duration] - The duration of the sound that the slot will play
     * starting from startTime. Defaults to `null` which means play to end of the sound.
     * @param {boolean} [options.overlap] - If true then sounds played from slot will be played
     * independently of each other. Otherwise the slot will first stop the current sound before
     * starting the new one. Defaults to false.
     * @param {boolean} [options.autoPlay] - If true the slot will start playing as soon as its
     * audio asset is loaded. Defaults to false.
     * @param {number} [options.asset] - The asset id of the audio asset that is going to be played
     * by this slot.
     * @returns {SoundSlot|null} The new slot or null if the slot already exists.
     * @example
     * // get an asset by id
     * const asset = app.assets.get(10);
     * // add a slot
     * this.entity.sound.addSlot('beep', {
     *     asset: asset
     * });
     * // play
     * this.entity.sound.play('beep');
     */
    addSlot(name: string, options?: {
        volume?: number;
        pitch?: number;
        loop?: boolean;
        startTime?: number;
        duration?: number;
        overlap?: boolean;
        autoPlay?: boolean;
        asset?: number;
    }): SoundSlot | null;
    /**
     * Removes the {@link SoundSlot} with the specified name.
     *
     * @param {string} name - The name of the slot.
     * @example
     * // remove a slot called 'beep'
     * this.entity.sound.removeSlot('beep');
     */
    removeSlot(name: string): void;
    /**
     * Returns the slot with the specified name.
     *
     * @param {string} name - The name of the slot.
     * @returns {SoundSlot|undefined} The slot.
     * @example
     * // get a slot and set its volume
     * this.entity.sound.slot('beep').volume = 0.5;
     *
     */
    slot(name: string): SoundSlot | undefined;
    /**
     * Return a property from the slot with the specified name.
     *
     * @param {string} name - The name of the {@link SoundSlot} to look for.
     * @param {string} property - The name of the property to look for.
     * @returns {*} The value from the looked property inside the slot with specified name. May be undefined if slot does not exist.
     * @private
     */
    private _getSlotProperty;
    /**
     * Returns true if the slot with the specified name is currently playing.
     *
     * @param {string} name - The name of the {@link SoundSlot} to look for.
     * @returns {boolean} True if the slot with the specified name exists and is currently playing.
     */
    isPlaying(name: string): boolean;
    /**
     * Returns true if the asset of the slot with the specified name is loaded..
     *
     * @param {string} name - The name of the {@link SoundSlot} to look for.
     * @returns {boolean} True if the slot with the specified name exists and its asset is loaded.
     */
    isLoaded(name: string): boolean;
    /**
     * Returns true if the slot with the specified name is currently paused.
     *
     * @param {string} name - The name of the {@link SoundSlot} to look for.
     * @returns {boolean} True if the slot with the specified name exists and is currently paused.
     */
    isPaused(name: string): boolean;
    /**
     * Returns true if the slot with the specified name is currently stopped.
     *
     * @param {string} name - The name of the {@link SoundSlot} to look for.
     * @returns {boolean} True if the slot with the specified name exists and is currently stopped.
     */
    isStopped(name: string): boolean;
    /**
     * Begins playing the sound slot with the specified name. The slot will restart playing if it
     * is already playing unless the overlap field is true in which case a new sound will be
     * created and played.
     *
     * @param {string} name - The name of the {@link SoundSlot} to play.
     * @returns {import('../../../platform/sound/instance.js').SoundInstance|null} The sound
     * instance that will be played. Returns null if the component or its parent entity is disabled
     * or if the SoundComponent has no slot with the specified name.
     * @example
     * // get asset by id
     * const asset = app.assets.get(10);
     * // create a slot and play it
     * this.entity.sound.addSlot('beep', {
     *     asset: asset
     * });
     * this.entity.sound.play('beep');
     */
    play(name: string): SoundInstance | null;
    /**
     * Pauses playback of the slot with the specified name. If the name is undefined then all slots
     * currently played will be paused. The slots can be resumed by calling {@link SoundComponent#resume}.
     *
     * @param {string} [name] - The name of the slot to pause. Leave undefined to pause everything.
     * @example
     * // pause all sounds
     * this.entity.sound.pause();
     * // pause a specific sound
     * this.entity.sound.pause('beep');
     */
    pause(name?: string): void;
    /**
     * Resumes playback of the sound slot with the specified name if it's paused. If no name is
     * specified all slots will be resumed.
     *
     * @param {string} [name] - The name of the slot to resume. Leave undefined to resume everything.
     * @example
     * // resume all sounds
     * this.entity.sound.resume();
     * // resume a specific sound
     * this.entity.sound.resume('beep');
     */
    resume(name?: string): void;
    /**
     * Stops playback of the sound slot with the specified name if it's paused. If no name is
     * specified all slots will be stopped.
     *
     * @param {string} [name] - The name of the slot to stop. Leave undefined to stop everything.
     * @example
     * // stop all sounds
     * this.entity.sound.stop();
     * // stop a specific sound
     * this.entity.sound.stop('beep');
     */
    stop(name?: string): void;
}

declare class SoundComponentData {
    enabled: boolean;
}

/**
 * Manages creation of {@link SoundComponent}s.
 *
 * @augments ComponentSystem
 * @category Sound
 */
declare class SoundComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof SoundComponent;
    DataType: typeof SoundComponentData;
    schema: string[];
    /**
     * Gets / sets the sound manager.
     *
     * @type {import('../../../platform/sound/manager.js').SoundManager}
     */
    manager: SoundManager;
    /**
     * Sets / gets the volume for the entire Sound system. All sounds will have their volume
     * multiplied by this value. Valid between [0, 1].
     *
     * @type {number}
     */
    set volume(arg: number);
    get volume(): number;
    /**
     * Gets the AudioContext currently used by the sound manager. Requires Web Audio API support.
     * Returns null if the device does not support the Web Audio API.
     *
     * @type {AudioContext|null}
     */
    get context(): AudioContext;
    initializeComponentData(component: any, data: any, properties: any): void;
    cloneComponent(entity: any, clone: any): Component;
    onUpdate(dt: any): void;
    onBeforeRemove(entity: any, component: any): void;
}

/**
 * An EntityReference can be used in scenarios where a component has one or more properties that
 * refer to entities in the scene graph. Using an EntityReference simplifies the job of dealing
 * with the presence or non-presence of the underlying entity and its components, especially when
 * it comes to dealing with the runtime addition or removal of components, and addition/removal of
 * associated event listeners.
 *
 * ## Usage Scenario ##
 *
 * Imagine that you're creating a Checkbox component, which has a reference to an entity
 * representing the checkmark/tickmark that is rendered in the Checkbox. The reference is modeled
 * as an entity guid property on the Checkbox component, called simply 'checkmark'. We have to
 * implement a basic piece of functionality whereby when the 'checkmark' entity reference is set,
 * the Checkbox component must toggle the tint of an ImageElementComponent present on the checkmark
 * entity to indicate whether the Checkbox is currently in the active or inactive state.
 *
 * Without using an EntityReference, the Checkbox component must implement some or all of the
 * following:
 *
 * - Listen for its 'checkmark' property being set to a valid guid, and retrieve a reference to the
 *   entity associated with this guid whenever it changes (i.e. via `app.root.findByGuid()`).
 * - Once a valid entity is received, check to see whether it has already has an
 *   ImageElementComponent or not:
 *   - If it has one, proceed to set the tint of the ImageElementComponent based on whether the
 *     Checkbox is currently active or inactive.
 *   - If it doesn't have one, add a listener to wait for the addition of an ImageElementComponent,
 *     and then apply the tint once one becomes present.
 * - If the checkmark entity is then reassigned (such as if the user reassigns the field in the
 *   editor, or if this is done at runtime via a script), a well-behaved Checkbox component must
 *   also undo the tinting so that no lasting effect is applied to the old entity.
 * - If the checkmark entity's ImageElementComponent is removed and then another
 *   ImageElementComponent is added, the Checkbox component must handle this in order to re-apply
 *   the tint.
 * - To prevent memory leaks, the Checkbox component must also make sure to correctly remove
 *   listeners in each of the following scenarios:
 *   - Destruction of the Checkbox component.
 *   - Reassignment of the checkmark entity.
 *   - Removal of the ImageElementComponent.
 * - It must also be careful not to double-add listeners in any of the above code paths, to avoid
 *   various forms of undesirable behavior.
 *
 * If the Checkbox component becomes more complicated and has multiple entity reference properties,
 * all of the above must be done correctly for each entity. Similarly, if it depends on multiple
 * different component types being present on the entities it has references to, it must correctly
 * handle the presence and non-presence of each of these components in the various possible
 * sequences of addition and removal. In addition to generating a lot of boilerplate, it's also
 * very easy for subtle mistakes to be made that lead to memory leaks, null reference errors or
 * visual bugs.
 *
 * By using an EntityReference, all of the above can be reduced to the following:
 *
 * ```javascript
 * function CheckboxComponent() {
 *    this._checkmarkReference = new pc.EntityReference(this, 'checkmark', {
 *        'element#gain': this._onCheckmarkImageElementGain,
 *        'element#lose': this._onCheckmarkImageElementLose
 *    });
 * }
 * ```
 *
 * Using the above code snippet, the `_onCheckmarkImageElementGain()` listener will be called
 * in either of the following scenarios:
 *
 * 1. A checkmark entity is assigned and already has an ElementComponent.
 * 2. A checkmark entity is assigned that does not have an ElementComponent, but one is added
 * later.
 *
 * Similarly, the `_onCheckmarkImageElementLose()` listener will be called in either of the
 * following scenarios:
 *
 * 1. An ElementComponent is removed from the checkmark entity.
 * 2. The checkmark entity is re-assigned (i.e. to another entity), or nullified. In this
 * scenario the callback will only be called if the entity actually had an ElementComponent.
 *
 * ## Event String Format ##
 *
 * The event string (i.e. "element#gain" in the above examples) is of the format
 * `sourceName#eventName`, and is defined as follows:
 *
 * - `sourceName`: May be any component name, or the special string "entity", which refers to the
 * entity itself.
 * - `eventName`: May be the name of any event dispatched by the relevant component or entity, as
 * well as the special strings "gain" or "lose".
 *
 * Some examples are as follows:
 *
 * ```javascript
 * "entity#destroy"    // Called when the entity managed by the entity reference is destroyed.
 * "element#set:width" // Called when the width of an ElementComponent is set.
 * ```
 *
 * When the entity reference changes to another entity (or null) the set:entity event is fired.
 *
 * ## Ownership and Destruction ##
 *
 * The lifetime of an ElementReference is tied to the parent component that instantiated it. This
 * coupling is indicated by the provision of the `this` keyword to the ElementReference's
 * constructor in the above examples (i.e. `new pc.EntityReference(this, ...`).
 *
 * Any event listeners managed by the ElementReference are automatically cleaned up when the parent
 * component is removed or the parent component's entity is destroyed – as such you should never
 * have to worry about dangling listeners.
 *
 * Additionally, any callbacks listed in the event config will automatically be called in the scope
 * of the parent component – you should never have to worry about manually calling
 * `Function.bind()`.
 *
 * @augments EventHandler
 * @ignore
 */
declare class EntityReference extends EventHandler {
    /**
     * Helper class used for managing component properties that represent entity references.
     *
     * @param {Component} parentComponent - A reference to the parent component that owns this
     * entity reference.
     * @param {string} entityPropertyName - The name of the component property that contains the
     * entity guid.
     * @param {Object<string, Function>} [eventConfig] - A map of event listener configurations.
     */
    constructor(parentComponent: Component, entityPropertyName: string, eventConfig?: {
        [x: string]: Function;
    });
    _parentComponent: Component;
    _entityPropertyName: string;
    _entity: Entity;
    _app: AppBase;
    _configureEventListeners(externalEventConfig: any, internalEventConfig: any): void;
    _eventListenerConfigs: {
        id: string;
        sourceName: string;
        eventName: string;
        callback: any;
        scope: any;
    }[];
    _listenerStatusFlags: {};
    _gainListeners: {};
    _loseListeners: {};
    _parseEventListenerConfig(eventConfig: any, prefix: any, scope: any): {
        id: string;
        sourceName: string;
        eventName: string;
        callback: any;
        scope: any;
    }[];
    _toggleLifecycleListeners(onOrOff: any): void;
    _onSetEntity(name: any, oldValue: any, newValue: any): void;
    /**
     * Must be called from the parent component's onEnable() method in order for entity references
     * to be correctly resolved when {@link Entity#clone} is called.
     *
     * @private
     */
    private onParentComponentEnable;
    _onSceneLoaded(): void;
    _updateEntityReference(): void;
    _onBeforeEntityChange(): void;
    _onAfterEntityChange(): void;
    _onComponentAdd(entity: any, component: any): void;
    _onComponentRemove(entity: any, component: any): void;
    _callAllGainOrLoseListeners(listenerMap: any): void;
    _callGainOrLoseListener(componentName: any, listenerMap: any): void;
    _toggleEntityListeners(onOrOff: any, isDestroying: any): void;
    _toggleComponentListeners(onOrOff: any, componentName: any, isDestroying: any): void;
    _safeToggleListener(onOrOff: any, config: any, isDestroying: any): void;
    _getEventSource(sourceName: any, isDestroying: any): any;
    _onEntityDestroy(entity: any): void;
    _onParentComponentRemove(entity: any, component: any): void;
    /**
     * Convenience method indicating whether the entity exists and has a component of the provided
     * type.
     *
     * @param {string} componentName - Name of the component.
     * @returns {boolean} True if the entity exists and has a component of the provided type.
     */
    hasComponent(componentName: string): boolean;
    /**
     * A reference to the entity, if present.
     *
     * @type {Entity}
     */
    get entity(): Entity;
}

/**
 * Helper class that makes it easy to create Elements that can be dragged by the mouse or touch.
 *
 * @augments EventHandler
 * @category User Interface
 */
declare class ElementDragHelper extends EventHandler {
    /**
     * Fired when a new drag operation starts.
     *
     * @event
     * @example
     * elementDragHelper.on('drag:start', () => {
     *     console.log('Drag started');
     * });
     */
    static EVENT_DRAGSTART: string;
    /**
     * Fired when the current new drag operation ends.
     *
     * @event
     * @example
     * elementDragHelper.on('drag:end', () => {
     *     console.log('Drag ended');
     * });
     */
    static EVENT_DRAGEND: string;
    /**
     * Fired whenever the position of the dragged element changes. The handler is passed the
     * current {@link Vec3} position of the dragged element.
     *
     * @event
     * @example
     * elementDragHelper.on('drag:move', (position) => {
     *     console.log(`Dragged element position is ${position}`);
     * });
     */
    static EVENT_DRAGMOVE: string;
    /**
     * Create a new ElementDragHelper instance.
     *
     * @param {ElementComponent} element - The Element that should become draggable.
     * @param {string} [axis] - Optional axis to constrain to, either 'x', 'y' or null.
     */
    constructor(element: ElementComponent, axis?: string);
    _element: ElementComponent;
    _app: AppBase;
    _axis: string;
    _enabled: boolean;
    _dragScale: Vec3;
    _dragStartMousePosition: Vec3;
    _dragStartHandlePosition: Vec3;
    _deltaMousePosition: Vec3;
    _deltaHandlePosition: Vec3;
    _isDragging: boolean;
    /**
     * @param {'on'|'off'} onOrOff - Either 'on' or 'off'.
     * @private
     */
    private _toggleLifecycleListeners;
    /**
     * @param {'on'|'off'} onOrOff - Either 'on' or 'off'.
     * @private
     */
    private _toggleDragListeners;
    _hasDragListeners: boolean;
    _onMouseDownOrTouchStart(event: any): void;
    _dragCamera: any;
    _onMouseUpOrTouchEnd(): void;
    /**
     * This method calculates the `Vec3` intersection point of plane/ray intersection based on
     * the mouse/touch input event. If there is no intersection, it returns `null`.
     *
     * @param {import('../../input/element-input').ElementTouchEvent | import('../../input/element-input').ElementMouseEvent | import('../../input/element-input').ElementSelectEvent} event - The event.
     * @returns {Vec3|null} The `Vec3` intersection point of plane/ray intersection, if there
     * is an intersection, otherwise `null`
     * @private
     */
    private _screenToLocal;
    _determineInputPosition(event: any): void;
    _chooseRayOriginAndDirection(): void;
    _calculateDragScale(): void;
    /**
     * This method is linked to `_element` events: `mousemove` and `touchmove`
     *
     * @param {import('../../input/element-input').ElementTouchEvent} event - The event.
     * @private
     */
    private _onMove;
    destroy(): void;
    set enabled(arg: boolean);
    get enabled(): boolean;
    get isDragging(): boolean;
}

/**
 * A ScrollViewComponent enables a group of entities to behave like a masked scrolling area, with
 * optional horizontal and vertical scroll bars.
 *
 * @property {boolean} horizontal Whether to enable horizontal scrolling.
 * @property {boolean} vertical Whether to enable vertical scrolling.
 * @property {number} scrollMode Specifies how the scroll view should behave when the user scrolls
 * past the end of the content. Modes are defined as follows:
 *
 * - {@link SCROLL_MODE_CLAMP}: Content does not scroll any further than its bounds.
 * - {@link SCROLL_MODE_BOUNCE}: Content scrolls past its bounds and then gently bounces back.
 * - {@link SCROLL_MODE_INFINITE}: Content can scroll forever.
 *
 * @property {number} bounceAmount Controls how far the content should move before bouncing back.
 * @property {number} friction Controls how freely the content should move if thrown, i.e. By
 * flicking on a phone or by flinging the scroll wheel on a mouse. A value of 1 means that content
 * will stop immediately; 0 means that content will continue moving forever (or until the bounds of
 * the content are reached, depending on the scrollMode).
 * @property {boolean} useMouseWheel Whether to use mouse wheel for scrolling (horizontally and
 * vertically).
 * @property {Vec2} mouseWheelSensitivity Mouse wheel horizontal and vertical sensitivity. Only
 * used if useMouseWheel is set. Setting a direction to 0 will disable mouse wheel scrolling in
 * that direction. 1 is a default sensitivity that is considered to feel good. The values can be
 * set higher or lower than 1 to tune the sensitivity. Defaults to [1, 1].
 * @property {number} horizontalScrollbarVisibility Controls whether the horizontal scrollbar
 * should be visible all the time, or only visible when the content exceeds the size of the
 * viewport.
 * @property {number} verticalScrollbarVisibility Controls whether the vertical scrollbar should be
 * visible all the time, or only visible when the content exceeds the size of the viewport.
 * @property {import('../../entity.js').Entity} viewportEntity The entity to be used as the masked
 * viewport area, within which the content will scroll. This entity must have an ElementGroup
 * component.
 * @property {import('../../entity.js').Entity} contentEntity The entity which contains the
 * scrolling content itself. This entity must have an Element component.
 * @property {import('../../entity.js').Entity} horizontalScrollbarEntity The entity to be used as
 * the vertical scrollbar. This entity must have a Scrollbar component.
 * @property {import('../../entity.js').Entity} verticalScrollbarEntity The entity to be used as
 * the vertical scrollbar. This entity must have a Scrollbar component.
 * @augments Component
 * @category User Interface
 */
declare class ScrollViewComponent extends Component {
    /**
     * Fired whenever the scroll position changes. The handler is passed a {@link Vec2} containing
     * the horizontal and vertical scroll values in the range 0..1.
     *
     * @event
     * @example
     * entity.scrollview.on('set:scroll', (scroll) => {
     *     console.log(`Horizontal scroll position: ${scroll.x}`);
     *     console.log(`Vertical scroll position: ${scroll.y}`);
     * });
     */
    static EVENT_SETSCROLL: string;
    /**
     * Create a new ScrollViewComponent.
     *
     * @param {import('./system.js').ScrollViewComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {import('../../entity.js').Entity} entity - The Entity that this Component is
     * attached to.
     */
    constructor(system: ScrollViewComponentSystem, entity: Entity);

    set bounceAmount(arg: number);
    get bounceAmount(): number;

    set contentEntity(arg: Entity);
    get contentEntity(): Entity;

    set friction(arg: number);
    get friction(): number;

    set horizontal(arg: boolean);
    get horizontal(): boolean;

    set horizontalScrollbarEntity(arg: Entity);
    get horizontalScrollbarEntity(): Entity;

    set horizontalScrollbarVisibility(arg: number);
    get horizontalScrollbarVisibility(): number;

    set mouseWheelSensitivity(arg: Vec2);
    get mouseWheelSensitivity(): Vec2;

    set scrollMode(arg: number);
    get scrollMode(): number;

    set useMouseWheel(arg: boolean);
    get useMouseWheel(): boolean;

    set vertical(arg: boolean);
    get vertical(): boolean;

    set verticalScrollbarEntity(arg: Entity);
    get verticalScrollbarEntity(): Entity;

    set verticalScrollbarVisibility(arg: number);
    get verticalScrollbarVisibility(): number;

    set viewportEntity(arg: Entity);
    get viewportEntity(): Entity;

    _viewportReference: EntityReference;
    _contentReference: EntityReference;
    _scrollbarUpdateFlags: {};
    _scrollbarReferences: {};
    _prevContentSizes: {};
    _scroll: Vec2;
    _velocity: Vec3;
    _dragStartPosition: Vec3;
    _disabledContentInput: boolean;
    _disabledContentInputEntities: any[];
    /**
     * @param {string} onOrOff - 'on' or 'off'.
     * @param {import('./system.js').ScrollViewComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @private
     */
    private _toggleLifecycleListeners;
    /**
     * @param {string} onOrOff - 'on' or 'off'.
     * @private
     */
    private _toggleElementListeners;
    _hasElementListeners: boolean;
    _onElementComponentAdd(entity: any): void;
    _onElementComponentRemove(entity: any): void;
    _onViewportElementGain(): void;
    _onContentElementGain(): void;
    _contentDragHelper: ElementDragHelper;
    _onContentElementLose(): void;
    _onContentDragStart(): void;
    _onContentDragEnd(): void;
    _prevContentDragPosition: any;
    _onContentDragMove(position: any): void;
    _wasDragged: boolean;
    _onSetContentOrViewportSize(): void;
    _onSetHorizontalScrollbarValue(scrollValueX: any): void;
    _onSetVerticalScrollbarValue(scrollValueY: any): void;
    _onSetHorizontalScrollingEnabled(): void;
    _onSetVerticalScrollingEnabled(): void;
    _onHorizontalScrollbarGain(): void;
    _onVerticalScrollbarGain(): void;
    _onSetScroll(x: any, y: any, resetVelocity: any): void;
    _updateAxis(scrollValue: any, axis: any, orientation: any): boolean;
    _determineNewScrollValue(scrollValue: any, axis: any, orientation: any): any;
    _syncAll(): void;
    _syncContentPosition(orientation: any): void;
    _syncScrollbarPosition(orientation: any): void;
    _syncScrollbarEnabledState(orientation: any): void;
    _contentIsLargerThanViewport(orientation: any): boolean;
    _contentPositionToScrollValue(contentPosition: any): Vec2;
    _getMaxOffset(orientation: any, contentSize: any): number;
    _getMaxScrollValue(orientation: any): 0 | 1;
    _getScrollbarHandleSize(axis: any, orientation: any): number;
    _getViewportSize(orientation: any): any;
    _getContentSize(orientation: any): any;
    _getSize(orientation: any, entityReference: any): any;
    _getScrollingEnabled(orientation: any): any;
    _getScrollbarVisibility(orientation: any): any;
    _getSign(orientation: any): 1 | -1;
    _getAxis(orientation: any): "x" | "y";
    _getCalculatedDimension(orientation: any): "calculatedWidth" | "calculatedHeight";
    _destroyDragHelper(): void;
    onUpdate(): void;
    _updateVelocity(): void;
    _hasOvershoot(axis: any, orientation: any): boolean;
    _toOvershoot(scrollValue: any, orientation: any): any;
    _setVelocityFromOvershoot(scrollValue: any, axis: any, orientation: any): void;
    _setVelocityFromContentPositionDelta(position: any): void;
    _setScrollFromContentPosition(position: any): void;
    _applyScrollValueTension(scrollValue: any): any;
    _isDragging(): boolean;
    _setScrollbarComponentsEnabled(enabled: any): void;
    _setContentDraggingEnabled(enabled: any): void;
    _onMouseWheel(event: any): void;
    set scroll(arg: Vec2);
    get scroll(): Vec2;
    _enableContentInput(): void;
    _disableContentInput(): void;
    onRemove(): void;
}

declare class ScrollViewComponentData {
    enabled: boolean;
}

/**
 * Manages creation of {@link ScrollViewComponent}s.
 *
 * @augments ComponentSystem
 * @category User Interface
 */
declare class ScrollViewComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof ScrollViewComponent;
    DataType: typeof ScrollViewComponentData;
    schema: {
        name: string;
        type: string;
    }[];
    initializeComponentData(component: any, data: any, properties: any): void;
    onUpdate(dt: any): void;
    _onRemoveComponent(entity: any, component: any): void;
}

/**
 * A ScrollbarComponent enables a group of entities to behave like a draggable scrollbar.
 *
 * @property {number} orientation Whether the scrollbar moves horizontally or vertically. Can be:
 *
 * - {@link ORIENTATION_HORIZONTAL}: The scrollbar animates in the horizontal axis.
 * - {@link ORIENTATION_VERTICAL}: The scrollbar animates in the vertical axis.
 *
 * Defaults to {@link ORIENTATION_HORIZONTAL}.
 * @property {number} value The current position value of the scrollbar, in the range 0 to 1.
 * Defaults to 0.
 * @property {number} handleSize The size of the handle relative to the size of the track, in the
 * range 0 to 1. For a vertical scrollbar, a value of 1 means that the handle will take up the full
 * height of the track.
 * @property {import('../../entity.js').Entity} handleEntity The entity to be used as the scrollbar
 * handle. This entity must have a Scrollbar component.
 * @augments Component
 * @category User Interface
 */
declare class ScrollbarComponent extends Component {
    /**
     * Fired whenever the scroll value changes. The handler is passed a number representing the
     * current scroll value.
     *
     * @event
     * @example
     * entity.scrollbar.on('set:value', (value) => {
     *     console.log(`Scroll value is now ${value}`);
     * });
     */
    static EVENT_SETVALUE: string;
    /**
     * Create a new ScrollbarComponent.
     *
     * @param {import('./system.js').ScrollbarComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {import('../../entity.js').Entity} entity - The Entity that this Component is
     * attached to.
     */
    constructor(system: ScrollbarComponentSystem, entity: Entity);

    set handleEntity(arg: Entity);
    get handleEntity(): Entity;

    set handleSize(arg: number);
    get handleSize(): number;

    set orientation(arg: number);
    get orientation(): number;

    _handleReference: EntityReference;
    /**
     * @param {string} onOrOff - 'on' or 'off'.
     * @private
     */
    private _toggleLifecycleListeners;
    _onHandleElementGain(): void;
    _handleDragHelper: ElementDragHelper;
    _onHandleElementLose(): void;
    _onHandleDrag(position: any): void;
    value: number;
    _onSetValue(name: any, oldValue: any, newValue: any): void;
    _onSetHandleSize(name: any, oldValue: any, newValue: any): void;
    _onSetHandleAlignment(): void;
    _onSetOrientation(name: any, oldValue: any, newValue: any): void;
    _updateHandlePositionAndSize(): void;
    _handlePositionToScrollValue(handlePosition: any): number;
    _scrollValueToHandlePosition(value: any): number;
    _getUsableTrackLength(): number;
    _getTrackLength(): number;
    _getHandleLength(): number;
    _getHandlePosition(): number;
    _getSign(): 1 | -1;
    _getAxis(): "x" | "y";
    _getDimension(): "height" | "width";
    _getOppositeDimension(): "height" | "width";
    _destroyDragHelper(): void;
    _setHandleDraggingEnabled(enabled: any): void;
    onRemove(): void;
}

declare class ScrollbarComponentData {
    enabled: boolean;
}

/**
 * Manages creation of {@link ScrollbarComponent}s.
 *
 * @augments ComponentSystem
 * @category User Interface
 */
declare class ScrollbarComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof ScrollbarComponent;
    DataType: typeof ScrollbarComponentData;
    schema: {
        name: string;
        type: string;
    }[];
    initializeComponentData(component: any, data: any, properties: any): void;
    _onRemoveComponent(entity: any, component: any): void;
}

/**
 * Helper class used to hold an array of items in a specific order. This array is safe to modify
 * while we loop through it. The class assumes that it holds objects that need to be sorted based
 * on one of their fields.
 *
 * @ignore
 */
declare class SortedLoopArray {
    /**
     * Create a new SortedLoopArray instance.
     *
     * @param {object} args - Arguments.
     * @param {string} args.sortBy - The name of the field that each element in the array is going
     * to be sorted by.
     * @example
     * const array = new pc.SortedLoopArray({ sortBy: 'priority' });
     * array.insert(item); // adds item to the right slot based on item.priority
     * array.append(item); // adds item to the end of the array
     * array.remove(item); // removes item from array
     * for (array.loopIndex = 0; array.loopIndex < array.length; array.loopIndex++) {
     *   // do things with array elements
     *   // safe to remove and add elements into the array while looping
     * }
     */
    constructor(args: {
        sortBy: string;
    });
    /**
     * The internal array that holds the actual array elements.
     *
     * @type {object[]}
     */
    items: object[];
    /**
     * The number of elements in the array.
     *
     * @type {number}
     */
    length: number;
    /**
     * The current index used to loop through the array. This gets modified if we add or remove
     * elements from the array while looping. See the example to see how to loop through this
     * array.
     *
     * @type {number}
     */
    loopIndex: number;
    /** @private */
    private _sortBy;
    /** @private */
    private _sortHandler;
    /**
     * Searches for the right spot to insert the specified item.
     *
     * @param {object} item - The item.
     * @returns {number} The index where to insert the item.
     * @private
     */
    private _binarySearch;
    _doSort(a: any, b: any): number;
    /**
     * Inserts the specified item into the array at the right index based on the 'sortBy' field
     * passed into the constructor. This also adjusts the loopIndex accordingly.
     *
     * @param {object} item - The item to insert.
     */
    insert(item: object): void;
    /**
     * Appends the specified item to the end of the array. Faster than insert() as it does not
     * binary search for the right index. This also adjusts the loopIndex accordingly.
     *
     * @param {object} item - The item to append.
     */
    append(item: object): void;
    /**
     * Removes the specified item from the array.
     *
     * @param {object} item - The item to remove.
     */
    remove(item: object): void;
    /**
     * Sorts elements in the array based on the 'sortBy' field passed into the constructor. This
     * also updates the loopIndex if we are currently looping.
     *
     * WARNING: Be careful if you are sorting while iterating because if after sorting the array
     * element that you are currently processing is moved behind other elements then you might end
     * up iterating over elements more than once!
     */
    sort(): void;
}

/**
 * The ScriptComponent allows you to extend the functionality of an Entity by attaching your own
 * Script Types defined in JavaScript files to be executed with access to the Entity. For more
 * details on scripting see [Scripting](https://developer.playcanvas.com/user-manual/scripting/).
 *
 * @augments Component
 * @category Script
 */
declare class ScriptComponent extends Component {
    /**
     * Fired when a {@link ScriptType} instance is created and attached to the script component.
     * This event is available in two forms. They are as follows:
     *
     * 1. `create` - Fired when a script instance is created. The name of the script type and the
     * script type instance are passed as arguments.
     * 2. `create:[name]` - Fired when a script instance is created that has the specified script
     * type name. The script instance is passed as an argument to the handler.
     *
     * @event
     * @example
     * entity.script.on('create', (name, scriptInstance) => {
     *     console.log(`Instance of script '${name}' created`);
     * });
     * @example
     * entity.script.on('create:player', (scriptInstance) => {
     *     console.log(`Instance of script 'player' created`);
     * });
     */
    static EVENT_CREATE: string;
    /**
     * Fired when a {@link ScriptType} instance is destroyed and removed from the script component.
     * This event is available in two forms. They are as follows:
     *
     * 1. `destroy` - Fired when a script instance is destroyed. The name of the script type and
     * the script type instance are passed as arguments.
     * 2. `destroy:[name]` - Fired when a script instance is destroyed that has the specified
     * script type name. The script instance is passed as an argument.
     *
     * @event
     * @example
     * entity.script.on('destroy', (name, scriptInstance) => {
     *     console.log(`Instance of script '${name}' destroyed`);
     * });
     * @example
     * entity.script.on('destroy:player', (scriptInstance) => {
     *     console.log(`Instance of script 'player' destroyed`);
     * });
     */
    static EVENT_DESTROY: string;
    /**
     * Fired when the script component becomes enabled. This event does not take into account the
     * enabled state of the entity or any of its ancestors.
     *
     * @event
     * @example
     * entity.script.on('enable', () => {
     *     console.log(`Script component of entity '${entity.name}' has been enabled`);
     * });
     */
    static EVENT_ENABLE: string;
    /**
     * Fired when the script component becomes disabled. This event does not take into account the
     * enabled state of the entity or any of its ancestors.
     *
     * @event
     * @example
     * entity.script.on('disable', () => {
     *     console.log(`Script component of entity '${entity.name}' has been disabled`);
     * });
     */
    static EVENT_DISABLE: string;
    /**
     * Fired when the script component has been removed from its entity.
     *
     * @event
     * @example
     * entity.script.on('remove', () => {
     *     console.log(`Script component removed from entity '${entity.name}'`);
     * });
     */
    static EVENT_REMOVE: string;
    /**
     * Fired when the script component changes state to enabled or disabled. The handler is passed
     * the new boolean enabled state of the script component. This event does not take into account
     * the enabled state of the entity or any of its ancestors.
     *
     * @event
     * @example
     * entity.script.on('state', (enabled) => {
     *     console.log(`Script component of entity '${entity.name}' changed state to '${enabled}'`);
     * });
     */
    static EVENT_STATE: string;
    /**
     * Fired when the index of a {@link ScriptType} instance is changed in the script component.
     * This event is available in two forms. They are as follows:
     *
     * 1. `move` - Fired when a script instance is moved. The name of the script type, the script
     * type instance, the new index and the old index are passed as arguments.
     * 2. `move:[name]` - Fired when a specifically named script instance is moved. The script
     * instance, the new index and the old index are passed as arguments.
     *
     * @event
     * @example
     * entity.script.on('move', (name, scriptInstance, newIndex, oldIndex) => {
     *     console.log(`Script '${name}' moved from index '${oldIndex}' to '${newIndex}'`);
     * });
     * @example
     * entity.script.on('move:player', (scriptInstance, newIndex, oldIndex) => {
     *     console.log(`Script 'player' moved from index '${oldIndex}' to '${newIndex}'`);
     * });
     */
    static EVENT_MOVE: string;
    /**
     * Fired when a {@link ScriptType} instance had an exception. The handler is passed the script
     * instance, the exception and the method name that the exception originated from.
     *
     * @event
     * @example
     * entity.script.on('error', (scriptInstance, exception, methodName) => {
     *     console.log(`Script error: ${exception} in method '${methodName}'`);
     * });
     */
    static EVENT_ERROR: string;
    /**
     * Create a new ScriptComponent instance.
     *
     * @param {import('./system.js').ScriptComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {Entity} entity - The Entity that this Component is attached to.
     */
    constructor(system: ScriptComponentSystem, entity: Entity);
    /**
     * Holds all script instances for this component.
     *
     * @type {import('../../script/script-type.js').ScriptType[]}
     * @private
     */
    private _scripts;
    _updateList: SortedLoopArray;
    _postUpdateList: SortedLoopArray;
    _scriptsIndex: {};
    _destroyedScripts: any[];
    _destroyed: boolean;
    _scriptsData: ScriptType[];
    _oldState: boolean;
    _enabled: boolean;
    _beingEnabled: boolean;
    _isLoopingThroughScripts: boolean;
    _executionOrder: number;
    /**
     * An array of all script instances attached to an entity. This array is read-only and should
     * not be modified by developer.
     *
     * @type {import('../../script/script-type.js').ScriptType[]}
     */
    set scripts(arg: ScriptType[]);
    get scripts(): ScriptType[];
    set enabled(arg: boolean);
    get enabled(): boolean;
    _beginLooping(): boolean;
    _endLooping(wasLoopingBefore: any): void;
    _onSetEnabled(prop: any, old: any, value: any): void;
    _checkState(): void;
    _onBeforeRemove(): void;
    _removeDestroyedScripts(): void;
    _onInitializeAttributes(): void;
    _scriptMethod(script: any, method: any, arg: any): void;
    _onInitialize(): void;
    _onPostInitialize(): void;
    _onUpdate(dt: any): void;
    _onPostUpdate(dt: any): void;
    /**
     * Inserts script instance into the scripts array at the specified index. Also inserts the
     * script into the update list if it has an update method and the post update list if it has a
     * postUpdate method.
     *
     * @param {object} scriptInstance - The script instance.
     * @param {number} index - The index where to insert the script at. If -1, append it at the end.
     * @param {number} scriptsLength - The length of the scripts array.
     * @private
     */
    private _insertScriptInstance;
    _removeScriptInstance(scriptInstance: any): number;
    _resetExecutionOrder(startIndex: any, scriptsLength: any): void;
    _resolveEntityScriptAttribute(attribute: any, attributeName: any, oldValue: any, useGuid: any, newAttributes: any, duplicatedIdsMap: any): void;
    /**
     * Detect if script is attached to an entity.
     *
     * @param {string|typeof ScriptType} nameOrType - The
     * name or type of {@link ScriptType}.
     * @returns {boolean} If script is attached to an entity.
     * @example
     * if (entity.script.has('playerController')) {
     *     // entity has script
     * }
     */
    has(nameOrType: string | typeof ScriptType): boolean;
    /**
     * Get a script instance (if attached).
     *
     * @param {string|typeof ScriptType} nameOrType - The
     * name or type of {@link ScriptType}.
     * @returns {import('../../script/script-type.js').ScriptType|null} If script is attached, the
     * instance is returned. Otherwise null is returned.
     * @example
     * const controller = entity.script.get('playerController');
     */
    get(nameOrType: string | typeof ScriptType): ScriptType | null;
    /**
     * Create a script instance and attach to an entity script component.
     *
     * @param {string|typeof ScriptType} nameOrType - The
     * name or type of {@link ScriptType}.
     * @param {object} [args] - Object with arguments for a script.
     * @param {boolean} [args.enabled] - If script instance is enabled after creation. Defaults to
     * true.
     * @param {object} [args.attributes] - Object with values for attributes (if any), where key is
     * name of an attribute.
     * @param {boolean} [args.preloading] - If script instance is created during preload. If true,
     * script and attributes must be initialized manually. Defaults to false.
     * @param {number} [args.ind] - The index where to insert the script instance at. Defaults to
     * -1, which means append it at the end.
     * @returns {import('../../script/script-type.js').ScriptType|null} Returns an instance of a
     * {@link ScriptType} if successfully attached to an entity, or null if it failed because a
     * script with a same name has already been added or if the {@link ScriptType} cannot be found
     * by name in the {@link ScriptRegistry}.
     * @example
     * entity.script.create('playerController', {
     *     attributes: {
     *         speed: 4
     *     }
     * });
     */
    create(nameOrType: string | typeof ScriptType, args?: {
        enabled?: boolean;
        attributes?: object;
        preloading?: boolean;
        ind?: number;
    }): ScriptType | null;
    /**
     * Destroy the script instance that is attached to an entity.
     *
     * @param {string|typeof ScriptType} nameOrType - The
     * name or type of {@link ScriptType}.
     * @returns {boolean} If it was successfully destroyed.
     * @example
     * entity.script.destroy('playerController');
     */
    destroy(nameOrType: string | typeof ScriptType): boolean;
    /**
     * Swap the script instance.
     *
     * @param {string|typeof ScriptType} nameOrType - The
     * name or type of {@link ScriptType}.
     * @returns {boolean} If it was successfully swapped.
     * @private
     */
    private swap;
    /**
     * When an entity is cloned and it has entity script attributes that point to other entities in
     * the same subtree that is cloned, then we want the new script attributes to point at the
     * cloned entities. This method remaps the script attributes for this entity and it assumes
     * that this entity is the result of the clone operation.
     *
     * @param {ScriptComponent} oldScriptComponent - The source script component that belongs to
     * the entity that was being cloned.
     * @param {object} duplicatedIdsMap - A dictionary with guid-entity values that contains the
     * entities that were cloned.
     * @private
     */
    private resolveDuplicatedEntityReferenceProperties;
    /**
     * Move script instance to different position to alter update order of scripts within entity.
     *
     * @param {string|typeof ScriptType} nameOrType - The
     * name or type of {@link ScriptType}.
     * @param {number} ind - New position index.
     * @returns {boolean} If it was successfully moved.
     * @example
     * entity.script.move('playerController', 0);
     */
    move(nameOrType: string | typeof ScriptType, ind: number): boolean;
}

declare class ScriptComponentData {
    enabled: boolean;
}

/**
 * Allows scripts to be attached to an Entity and executed.
 *
 * @augments ComponentSystem
 * @category Script
 */
declare class ScriptComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof ScriptComponent;
    DataType: typeof ScriptComponentData;
    _components: SortedLoopArray;
    _enabledComponents: SortedLoopArray;
    preloading: boolean;
    initializeComponentData(component: any, data: any): void;
    cloneComponent(entity: any, clone: any): Component;
    _resetExecutionOrder(): void;
    _callComponentMethod(components: any, name: any, dt: any): void;
    _onInitialize(): void;
    _onPostInitialize(): void;
    _onUpdate(dt: any): void;
    _onPostUpdate(dt: any): void;
    _addComponentToEnabled(component: any): void;
    _removeComponentFromEnabled(component: any): void;
    _onBeforeRemove(entity: any, component: any): void;
}

/**
 * A ScreenComponent enables the Entity to render child {@link ElementComponent}s using anchors and
 * positions in the ScreenComponent's space.
 *
 * @augments Component
 * @category User Interface
 */
declare class ScreenComponent extends Component {
    /**
     * Create a new ScreenComponent.
     *
     * @param {import('./system.js').ScreenComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {Entity} entity - The Entity that this Component is attached to.
     */
    constructor(system: ScreenComponentSystem, entity: Entity);
    _resolution: Vec2;
    _referenceResolution: Vec2;
    _scaleMode: string;
    scale: number;
    _scaleBlend: number;
    _priority: number;
    _screenSpace: boolean;
    /**
     * If true then elements inside this screen will be not be rendered when outside of the
     * screen (only valid when screenSpace is true).
     *
     * @type {boolean}
     */
    cull: boolean;
    _screenMatrix: Mat4;
    _elements: Set<any>;
    /**
     * Set the drawOrder of each child {@link ElementComponent} so that ElementComponents which are
     * last in the hierarchy are rendered on top. Draw Order sync is queued and will be updated by
     * the next update loop.
     */
    syncDrawOrder(): void;
    _recurseDrawOrderSync(e: any, i: any): any;
    _processDrawOrderSync(): void;
    _calcProjectionMatrix(): void;
    _updateScale(): void;
    _calcScale(resolution: any, referenceResolution: any): number;
    _onResize(width: any, height: any): void;
    /**
     * The width and height of the ScreenComponent. When screenSpace is true the resolution will
     * always be equal to {@link GraphicsDevice#width} x {@link GraphicsDevice#height}.
     *
     * @type {Vec2}
     */
    set resolution(arg: Vec2);
    get resolution(): Vec2;
    _bindElement(element: any): void;
    _unbindElement(element: any): void;
    onRemove(): void;
    /**
     * The resolution that the ScreenComponent is designed for. This is only taken into account
     * when screenSpace is true and scaleMode is {@link SCALEMODE_BLEND}. If the actual resolution
     * is different then the ScreenComponent will be scaled according to the scaleBlend value.
     *
     * @type {Vec2}
     */
    set referenceResolution(arg: Vec2);
    get referenceResolution(): Vec2;
    /**
     * If true then the ScreenComponent will render its child {@link ElementComponent}s in screen
     * space instead of world space. Enable this to create 2D user interfaces.
     *
     * @type {boolean}
     */
    set screenSpace(arg: boolean);
    get screenSpace(): boolean;
    /**
     * Can either be {@link SCALEMODE_NONE} or {@link SCALEMODE_BLEND}. See the description of
     * referenceResolution for more information.
     *
     * @type {string}
     */
    set scaleMode(arg: string);
    get scaleMode(): string;
    /**
     * A value between 0 and 1 that is used when scaleMode is equal to {@link SCALEMODE_BLEND}.
     * Scales the ScreenComponent with width as a reference (when value is 0), the height as a
     * reference (when value is 1) or anything in between.
     *
     * @type {number}
     */
    set scaleBlend(arg: number);
    get scaleBlend(): number;
    /**
     * Priority determines the order in which Screen components in the same layer are rendered.
     * Number must be an integer between 0 and 255. Priority is set into the top 8 bits of the
     * drawOrder property in an element.
     *
     * @type {number}
     */
    set priority(arg: number);
    get priority(): number;
}

declare class ScreenComponentData {
    enabled: boolean;
}

/**
 * A ordered list-type data structure that can provide item look up by key and can also return a list.
 *
 * @ignore
 */
declare class IndexedList {
    /**
     * @type {object[]}
     * @private
     */
    private _list;
    /**
     * @type {Object<string, number>}
     * @private
     */
    private _index;
    /**
     * Add a new item into the list with a index key.
     *
     * @param {string} key - Key used to look up item in index.
     * @param {object} item - Item to be stored.
     */
    push(key: string, item: object): void;
    /**
     * Test whether a key has been added to the index.
     *
     * @param {string} key - The key to test.
     * @returns {boolean} Returns true if key is in the index, false if not.
     */
    has(key: string): boolean;
    /**
     * Return the item indexed by a key.
     *
     * @param {string} key - The key of the item to retrieve.
     * @returns {object|null} The item stored at key. Returns null if key is not in the index.
     */
    get(key: string): object | null;
    /**
     * Remove the item indexed by key from the list.
     *
     * @param {string} key - The key at which to remove the item.
     * @returns {boolean} Returns true if the key exists and an item was removed, returns false if
     * no item was removed.
     */
    remove(key: string): boolean;
    /**
     * Returns the list of items.
     *
     * @returns {object[]} The list of items.
     */
    list(): object[];
    /**
     * Remove all items from the list.
     */
    clear(): void;
}

/**
 * Manages creation of {@link ScreenComponent}s.
 *
 * @augments ComponentSystem
 * @category User Interface
 */
declare class ScreenComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof ScreenComponent;
    DataType: typeof ScreenComponentData;
    schema: string[];
    windowResolution: Vec2;
    _drawOrderSyncQueue: IndexedList;
    initializeComponentData(component: any, data: any, properties: any): void;
    _onUpdate(dt: any): void;
    _onResize(width: any, height: any): void;
    cloneComponent(entity: any, clone: any): Component;
    onRemoveComponent(entity: any, component: any): void;
    processDrawOrderSyncQueue(): void;
    queueDrawOrderSync(id: any, fn: any, scope: any): void;
}

/**
 * The rigidbody component, when combined with a {@link CollisionComponent}, allows your entities
 * to be simulated using realistic physics. A rigidbody component will fall under gravity and
 * collide with other rigid bodies. Using scripts, you can apply forces and impulses to rigid
 * bodies.
 *
 * You should never need to use the RigidBodyComponent constructor. To add an RigidBodyComponent to
 * a {@link Entity}, use {@link Entity#addComponent}:
 *
 * ```javascript
 * // Create a static 1x1x1 box-shaped rigid body
 * const entity = pc.Entity();
 * entity.addComponent("rigidbody"); // Without options, this defaults to a 'static' body
 * entity.addComponent("collision"); // Without options, this defaults to a 1x1x1 box shape
 * ```
 *
 * To create a dynamic sphere with mass of 10, do:
 *
 * ```javascript
 * const entity = pc.Entity();
 * entity.addComponent("rigidbody", {
 *     type: pc.BODYTYPE_DYNAMIC,
 *     mass: 10
 * });
 * entity.addComponent("collision", {
 *     type: "sphere"
 * });
 * ```
 *
 * Relevant 'Engine-only' examples:
 *
 * - [Falling shapes](https://playcanvas.github.io/#/physics/falling-shapes)
 * - [Vehicle physics](https://playcanvas.github.io/#/physics/vehicle)
 *
 * @augments Component
 * @category Physics
 */
declare class RigidBodyComponent extends Component {
    /**
     * Fired when a contact occurs between two rigid bodies. The handler is passed a
     * {@link ContactResult} object containing details of the contact between the two rigid bodies.
     *
     * @event
     * @example
     * entity.rigidbody.on('contact', (result) => {
     *    console.log(`Contact between ${entity.name} and ${result.other.name}`);
     * });
     */
    static EVENT_CONTACT: string;
    /**
     * Fired when two rigid bodies start touching. The handler is passed a {@link ContactResult}
     * object containing details of the contact between the two rigid bodies.
     *
     * @event
     * @example
     * entity.rigidbody.on('collisionstart', (result) => {
     *     console.log(`Collision started between ${entity.name} and ${result.other.name}`);
     * });
     */
    static EVENT_COLLISIONSTART: string;
    /**
     * Fired when two rigid bodies stop touching. The handler is passed a {@link ContactResult}
     * object containing details of the contact between the two rigid bodies.
     *
     * @event
     * @example
     * entity.rigidbody.on('collisionend', (result) => {
     *     console.log(`Collision ended between ${entity.name} and ${result.other.name}`);
     * });
     */
    static EVENT_COLLISIONEND: string;
    /**
     * Fired when a rigid body enters a trigger volume. The handler is passed an {@link Entity}
     * representing the trigger volume that this rigid body entered.
     *
     * @event
     * @example
     * entity.rigidbody.on('triggerenter', (trigger) => {
     *     console.log(`Entity ${entity.name} entered trigger volume ${trigger.name}`);
     * });
     */
    static EVENT_TRIGGERENTER: string;
    /**
     * Fired when a rigid body exits a trigger volume. The handler is passed an {@link Entity}
     * representing the trigger volume that this rigid body exited.
     *
     * @event
     * @example
     * entity.rigidbody.on('triggerleave', (trigger) => {
     *     console.log(`Entity ${entity.name} exited trigger volume ${trigger.name}`);
     * });
     */
    static EVENT_TRIGGERLEAVE: string;
    /** @ignore */
    static onLibraryLoaded(): void;
    /**
     * Create a new RigidBodyComponent instance.
     *
     * @param {import('./system.js').RigidBodyComponentSystem} system - The ComponentSystem that
     * created this component.
     * @param {import('../../entity.js').Entity} entity - The entity this component is attached to.
     */
    constructor(system: RigidBodyComponentSystem, entity: Entity);
    /** @private */
    private _angularDamping;
    /** @private */
    private _angularFactor;
    /** @private */
    private _angularVelocity;
    /** @private */
    private _body;
    /** @private */
    private _friction;
    /** @private */
    private _group;
    /** @private */
    private _linearDamping;
    /** @private */
    private _linearFactor;
    /** @private */
    private _linearVelocity;
    /** @private */
    private _mask;
    /** @private */
    private _mass;
    /** @private */
    private _restitution;
    /** @private */
    private _rollingFriction;
    /** @private */
    private _simulationEnabled;
    /** @private */
    private _type;
    /**
     * Controls the rate at which a body loses angular velocity over time.
     *
     * @type {number}
     */
    set angularDamping(arg: number);
    get angularDamping(): number;
    /**
     * Scaling factor for angular movement of the body in each axis. Only valid for rigid bodies of
     * type {@link BODYTYPE_DYNAMIC}. Defaults to 1 in all axes (body can freely rotate).
     *
     * @type {Vec3}
     */
    set angularFactor(arg: Vec3);
    get angularFactor(): Vec3;
    /**
     * Defines the rotational speed of the body around each world axis.
     *
     * @type {Vec3}
     */
    set angularVelocity(arg: Vec3);
    get angularVelocity(): Vec3;
    set body(arg: any);
    get body(): any;
    /**
     * The friction value used when contacts occur between two bodies. A higher value indicates
     * more friction. Should be set in the range 0 to 1. Defaults to 0.5.
     *
     * @type {number}
     */
    set friction(arg: number);
    get friction(): number;
    /**
     * The collision group this body belongs to. Combine the group and the mask to prevent bodies
     * colliding with each other. Defaults to 1.
     *
     * @type {number}
     */
    set group(arg: number);
    get group(): number;
    /**
     * Controls the rate at which a body loses linear velocity over time. Defaults to 0.
     *
     * @type {number}
     */
    set linearDamping(arg: number);
    get linearDamping(): number;
    /**
     * Scaling factor for linear movement of the body in each axis. Only valid for rigid bodies of
     * type {@link BODYTYPE_DYNAMIC}. Defaults to 1 in all axes (body can freely move).
     *
     * @type {Vec3}
     */
    set linearFactor(arg: Vec3);
    get linearFactor(): Vec3;
    /**
     * Defines the speed of the body in a given direction.
     *
     * @type {Vec3}
     */
    set linearVelocity(arg: Vec3);
    get linearVelocity(): Vec3;
    /**
     * The collision mask sets which groups this body collides with. It is a bitfield of 16 bits,
     * the first 8 bits are reserved for engine use. Defaults to 65535.
     *
     * @type {number}
     */
    set mask(arg: number);
    get mask(): number;
    /**
     * The mass of the body. This is only relevant for {@link BODYTYPE_DYNAMIC} bodies, other types
     * have infinite mass. Defaults to 1.
     *
     * @type {number}
     */
    set mass(arg: number);
    get mass(): number;
    /**
     * Influences the amount of energy lost when two rigid bodies collide. The calculation
     * multiplies the restitution values for both colliding bodies. A multiplied value of 0 means
     * that all energy is lost in the collision while a value of 1 means that no energy is lost.
     * Should be set in the range 0 to 1. Defaults to 0.
     *
     * @type {number}
     */
    set restitution(arg: number);
    get restitution(): number;
    /**
     * Sets a torsional friction orthogonal to the contact point. Defaults to 0.
     *
     * @type {number}
     */
    set rollingFriction(arg: number);
    get rollingFriction(): number;
    /**
     * The rigid body type determines how the body is simulated. Can be:
     *
     * - {@link BODYTYPE_STATIC}: infinite mass and cannot move.
     * - {@link BODYTYPE_DYNAMIC}: simulated according to applied forces.
     * - {@link BODYTYPE_KINEMATIC}: infinite mass and does not respond to forces (can only be
     * moved by setting the position and rotation of component's {@link Entity}).
     *
     * Defaults to {@link BODYTYPE_STATIC}.
     *
     * @type {string}
     */
    set type(arg: string);
    get type(): string;
    /**
     * If the Entity has a Collision shape attached then create a rigid body using this shape. This
     * method destroys the existing body.
     *
     * @private
     */
    private createBody;
    /**
     * Returns true if the rigid body is currently actively being simulated. I.e. Not 'sleeping'.
     *
     * @returns {boolean} True if the body is active.
     */
    isActive(): boolean;
    /**
     * Forcibly activate the rigid body simulation. Only affects rigid bodies of type
     * {@link BODYTYPE_DYNAMIC}.
     */
    activate(): void;
    /**
     * Add a body to the simulation.
     *
     * @ignore
     */
    enableSimulation(): void;
    /**
     * Remove a body from the simulation.
     *
     * @ignore
     */
    disableSimulation(): void;
    /**
     * Apply an force to the body at a point. By default, the force is applied at the origin of the
     * body. However, the force can be applied at an offset this point by specifying a world space
     * vector from the body's origin to the point of application. This function has two valid
     * signatures. You can either specify the force (and optional relative point) via 3D-vector or
     * numbers.
     *
     * @param {Vec3|number} x - A 3-dimensional vector representing the force in world-space or
     * the x-component of the force in world-space.
     * @param {Vec3|number} [y] - An optional 3-dimensional vector representing the relative point
     * at which to apply the impulse in world-space or the y-component of the force in world-space.
     * @param {number} [z] - The z-component of the force in world-space.
     * @param {number} [px] - The x-component of a world-space offset from the body's position
     * where the force is applied.
     * @param {number} [py] - The y-component of a world-space offset from the body's position
     * where the force is applied.
     * @param {number} [pz] - The z-component of a world-space offset from the body's position
     * where the force is applied.
     * @example
     * // Apply an approximation of gravity at the body's center
     * this.entity.rigidbody.applyForce(0, -10, 0);
     * @example
     * // Apply an approximation of gravity at 1 unit down the world Z from the center of the body
     * this.entity.rigidbody.applyForce(0, -10, 0, 0, 0, 1);
     * @example
     * // Apply a force at the body's center
     * // Calculate a force vector pointing in the world space direction of the entity
     * const force = this.entity.forward.clone().mulScalar(100);
     *
     * // Apply the force
     * this.entity.rigidbody.applyForce(force);
     * @example
     * // Apply a force at some relative offset from the body's center
     * // Calculate a force vector pointing in the world space direction of the entity
     * const force = this.entity.forward.clone().mulScalar(100);
     *
     * // Calculate the world space relative offset
     * const relativePos = new pc.Vec3();
     * const childEntity = this.entity.findByName('Engine');
     * relativePos.sub2(childEntity.getPosition(), this.entity.getPosition());
     *
     * // Apply the force
     * this.entity.rigidbody.applyForce(force, relativePos);
     */
    applyForce(x: Vec3 | number, y?: Vec3 | number, z?: number, px?: number, py?: number, pz?: number): void;
    /**
     * Apply torque (rotational force) to the body. This function has two valid signatures. You can
     * either specify the torque force with a 3D-vector or with 3 numbers.
     *
     * @param {Vec3|number} x - A 3-dimensional vector representing the torque force in world-space
     * or the x-component of the torque force in world-space.
     * @param {number} [y] - The y-component of the torque force in world-space.
     * @param {number} [z] - The z-component of the torque force in world-space.
     * @example
     * // Apply via vector
     * const torque = new pc.Vec3(0, 10, 0);
     * entity.rigidbody.applyTorque(torque);
     * @example
     * // Apply via numbers
     * entity.rigidbody.applyTorque(0, 10, 0);
     */
    applyTorque(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Apply an impulse (instantaneous change of velocity) to the body at a point. This function
     * has two valid signatures. You can either specify the impulse (and optional relative point)
     * via 3D-vector or numbers.
     *
     * @param {Vec3|number} x - A 3-dimensional vector representing the impulse in world-space or
     * the x-component of the impulse in world-space.
     * @param {Vec3|number} [y] - An optional 3-dimensional vector representing the relative point
     * at which to apply the impulse in the local-space of the entity or the y-component of the
     * impulse to apply in world-space.
     * @param {number} [z] - The z-component of the impulse to apply in world-space.
     * @param {number} [px] - The x-component of the point at which to apply the impulse in the
     * local-space of the entity.
     * @param {number} [py] - The y-component of the point at which to apply the impulse in the
     * local-space of the entity.
     * @param {number} [pz] - The z-component of the point at which to apply the impulse in the
     * local-space of the entity.
     * @example
     * // Apply an impulse along the world-space positive y-axis at the entity's position.
     * const impulse = new pc.Vec3(0, 10, 0);
     * entity.rigidbody.applyImpulse(impulse);
     * @example
     * // Apply an impulse along the world-space positive y-axis at 1 unit down the positive
     * // z-axis of the entity's local-space.
     * const impulse = new pc.Vec3(0, 10, 0);
     * const relativePoint = new pc.Vec3(0, 0, 1);
     * entity.rigidbody.applyImpulse(impulse, relativePoint);
     * @example
     * // Apply an impulse along the world-space positive y-axis at the entity's position.
     * entity.rigidbody.applyImpulse(0, 10, 0);
     * @example
     * // Apply an impulse along the world-space positive y-axis at 1 unit down the positive
     * // z-axis of the entity's local-space.
     * entity.rigidbody.applyImpulse(0, 10, 0, 0, 0, 1);
     */
    applyImpulse(x: Vec3 | number, y?: Vec3 | number, z?: number, px?: number, py?: number, pz?: number): void;
    /**
     * Apply a torque impulse (rotational force applied instantaneously) to the body. This function
     * has two valid signatures. You can either specify the torque force with a 3D-vector or with 3
     * numbers.
     *
     * @param {Vec3|number} x - A 3-dimensional vector representing the torque impulse in
     * world-space or the x-component of the torque impulse in world-space.
     * @param {number} [y] - The y-component of the torque impulse in world-space.
     * @param {number} [z] - The z-component of the torque impulse in world-space.
     * @example
     * // Apply via vector
     * const torque = new pc.Vec3(0, 10, 0);
     * entity.rigidbody.applyTorqueImpulse(torque);
     * @example
     * // Apply via numbers
     * entity.rigidbody.applyTorqueImpulse(0, 10, 0);
     */
    applyTorqueImpulse(x: Vec3 | number, y?: number, z?: number): void;
    /**
     * Returns true if the rigid body is of type {@link BODYTYPE_STATIC}.
     *
     * @returns {boolean} True if static.
     */
    isStatic(): boolean;
    /**
     * Returns true if the rigid body is of type {@link BODYTYPE_STATIC} or {@link BODYTYPE_KINEMATIC}.
     *
     * @returns {boolean} True if static or kinematic.
     */
    isStaticOrKinematic(): boolean;
    /**
     * Returns true if the rigid body is of type {@link BODYTYPE_KINEMATIC}.
     *
     * @returns {boolean} True if kinematic.
     */
    isKinematic(): boolean;
    /**
     * Writes an entity transform into an Ammo.btTransform but ignoring scale.
     *
     * @param {object} transform - The ammo transform to write the entity transform to.
     * @private
     */
    private _getEntityTransform;
    /**
     * Set the rigid body transform to be the same as the Entity transform. This must be called
     * after any Entity transformation functions (e.g. {@link Entity#setPosition}) are called in
     * order to update the rigid body to match the Entity.
     *
     * @private
     */
    private syncEntityToBody;
    /**
     * Sets an entity's transform to match that of the world transformation matrix of a dynamic
     * rigid body's motion state.
     *
     * @private
     */
    private _updateDynamic;
    /**
     * Writes the entity's world transformation matrix into the motion state of a kinematic body.
     *
     * @private
     */
    private _updateKinematic;
    /**
     * Teleport an entity to a new world-space position, optionally setting orientation. This
     * function should only be called for rigid bodies that are dynamic. This function has three
     * valid signatures. The first takes a 3-dimensional vector for the position and an optional
     * 3-dimensional vector for Euler rotation. The second takes a 3-dimensional vector for the
     * position and an optional quaternion for rotation. The third takes 3 numbers for the position
     * and an optional 3 numbers for Euler rotation.
     *
     * @param {Vec3|number} x - A 3-dimensional vector holding the new position or the new position
     * x-coordinate.
     * @param {Quat|Vec3|number} [y] - A 3-dimensional vector or quaternion holding the new
     * rotation or the new position y-coordinate.
     * @param {number} [z] - The new position z-coordinate.
     * @param {number} [rx] - The new Euler x-angle value.
     * @param {number} [ry] - The new Euler y-angle value.
     * @param {number} [rz] - The new Euler z-angle value.
     * @example
     * // Teleport the entity to the origin
     * entity.rigidbody.teleport(pc.Vec3.ZERO);
     * @example
     * // Teleport the entity to the origin
     * entity.rigidbody.teleport(0, 0, 0);
     * @example
     * // Teleport the entity to world-space coordinate [1, 2, 3] and reset orientation
     * const position = new pc.Vec3(1, 2, 3);
     * entity.rigidbody.teleport(position, pc.Vec3.ZERO);
     * @example
     * // Teleport the entity to world-space coordinate [1, 2, 3] and reset orientation
     * entity.rigidbody.teleport(1, 2, 3, 0, 0, 0);
     */
    teleport(x: Vec3 | number, y?: Quat | Vec3 | number, z?: number, rx?: number, ry?: number, rz?: number): void;
}

declare class RigidBodyComponentData {
    enabled: boolean;
}

/**
 * A pool of reusable objects of the same type. Designed to promote reuse of objects to reduce
 * garbage collection.
 *
 * @ignore
 */
declare class ObjectPool {
    /**
     * @param {Function} constructorFunc - The constructor function for the objects in the pool.
     * @param {number} size - The initial number of object instances to allocate.
     */
    constructor(constructorFunc: Function, size: number);
    /**
     * Array of object instances.
     *
     * @type {object[]}
     * @private
     */
    private _pool;
    /**
     * The number of object instances that are currently allocated.
     *
     * @type {number}
     * @private
     */
    private _count;
    _constructor: Function;
    /**
     * @param {number} size - The number of object instances to allocate.
     * @private
     */
    private _resize;
    /**
     * Returns an object instance from the pool. If no instances are available, the pool will be
     * doubled in size and a new instance will be returned.
     *
     * @returns {object} An object instance from the pool.
     */
    allocate(): object;
    /**
     * All object instances in the pool will be available again. The pool itself will not be
     * resized.
     */
    freeAll(): void;
}

/**
 * Object holding the result of a contact between two Entities.
 *
 * @category Physics
 */
declare class ContactPoint {
    /**
     * Create a new ContactPoint instance.
     *
     * @param {Vec3} [localPoint] - The point on the entity where the contact occurred, relative to
     * the entity.
     * @param {Vec3} [localPointOther] - The point on the other entity where the contact occurred,
     * relative to the other entity.
     * @param {Vec3} [point] - The point on the entity where the contact occurred, in world space.
     * @param {Vec3} [pointOther] - The point on the other entity where the contact occurred, in
     * world space.
     * @param {Vec3} [normal] - The normal vector of the contact on the other entity, in world
     * space.
     * @param {number} [impulse] - The total accumulated impulse applied by the constraint solver
     * during the last sub-step. Describes how hard two objects collide. Defaults to 0.
     * @hideconstructor
     */
    constructor(localPoint?: Vec3, localPointOther?: Vec3, point?: Vec3, pointOther?: Vec3, normal?: Vec3, impulse?: number);
    /**
     * The point on the entity where the contact occurred, relative to the entity.
     *
     * @type {Vec3}
     */
    localPoint: Vec3;
    /**
     * The point on the other entity where the contact occurred, relative to the other entity.
     *
     * @type {Vec3}
     */
    localPointOther: Vec3;
    /**
     * The point on the entity where the contact occurred, in world space.
     *
     * @type {Vec3}
     */
    point: Vec3;
    /**
     * The point on the other entity where the contact occurred, in world space.
     *
     * @type {Vec3}
     */
    pointOther: Vec3;
    /**
     * The normal vector of the contact on the other entity, in world space.
     *
     * @type {Vec3}
     */
    normal: Vec3;
    /**
     * The total accumulated impulse applied by the constraint solver during the last sub-step.
     * Describes how hard two objects collide.
     *
     * @type {number}
     */
    impulse: number;
}
/**
 * Object holding the result of a contact between two Entities.
 *
 * @category Physics
 */
declare class ContactResult {
    /**
     * Create a new ContactResult instance.
     *
     * @param {import('../../entity.js').Entity} other - The entity that was involved in the
     * contact with this entity.
     * @param {ContactPoint[]} contacts - An array of ContactPoints with the other entity.
     * @hideconstructor
     */
    constructor(other: Entity, contacts: ContactPoint[]);
    /**
     * The entity that was involved in the contact with this entity.
     *
     * @type {import('../../entity.js').Entity}
     */
    other: Entity;
    /**
     * An array of ContactPoints with the other entity.
     *
     * @type {ContactPoint[]}
     */
    contacts: ContactPoint[];
}
/**
 * Object holding the result of a successful raycast hit.
 *
 * @category Physics
 */
declare class RaycastResult {
    /**
     * Create a new RaycastResult instance.
     *
     * @param {import('../../entity.js').Entity} entity - The entity that was hit.
     * @param {Vec3} point - The point at which the ray hit the entity in world space.
     * @param {Vec3} normal - The normal vector of the surface where the ray hit in world space.
     * @param {number} hitFraction - The normalized distance (between 0 and 1) at which the ray hit
     * occurred from the starting point.
     * @hideconstructor
     */
    constructor(entity: Entity, point: Vec3, normal: Vec3, hitFraction: number);
    /**
     * The entity that was hit.
     *
     * @type {import('../../entity.js').Entity}
     */
    entity: Entity;
    /**
     * The point at which the ray hit the entity in world space.
     *
     * @type {Vec3}
     */
    point: Vec3;
    /**
     * The normal vector of the surface where the ray hit in world space.
     *
     * @type {Vec3}
     */
    normal: Vec3;
    /**
     * The normalized distance (between 0 and 1) at which the ray hit occurred from the
     * starting point.
     *
     * @type {number}
     */
    hitFraction: number;
}
/**
 * The RigidBodyComponentSystem maintains the dynamics world for simulating rigid bodies, it also
 * controls global values for the world such as gravity. Note: The RigidBodyComponentSystem is only
 * valid if 3D Physics is enabled in your application. You can enable this in the application
 * settings for your project.
 *
 * @augments ComponentSystem
 * @category Physics
 */
declare class RigidBodyComponentSystem extends ComponentSystem {
    /**
     * Fired when a contact occurs between two rigid bodies. The handler is passed a
     * {@link SingleContactResult} object containing details of the contact between the two bodies.
     *
     * @event
     * @example
     * app.systems.rigidbody.on('contact', (result) => {
     *     console.log(`Contact between ${result.a.name} and ${result.b.name}`);
     * });
     */
    static EVENT_CONTACT: string;
    /**
     * @type {number}
     * @ignore
     */
    maxSubSteps: number;
    /**
     * @type {number}
     * @ignore
     */
    fixedTimeStep: number;
    /**
     * The world space vector representing global gravity in the physics simulation. Defaults to
     * [0, -9.81, 0] which is an approximation of the gravitational force on Earth.
     *
     * @type {Vec3}
     */
    gravity: Vec3;
    /**
     * @type {Float32Array}
     * @private
     */
    private _gravityFloat32;
    /**
     * @type {RigidBodyComponent[]}
     * @private
     */
    private _dynamic;
    /**
     * @type {RigidBodyComponent[]}
     * @private
     */
    private _kinematic;
    /**
     * @type {RigidBodyComponent[]}
     * @private
     */
    private _triggers;
    /**
     * @type {RigidBodyComponent[]}
     * @private
     */
    private _compounds;
    id: string;
    _stats: {
        fps: number;
        ms: number;
        dt: number;
        updateStart: number;
        updateTime: number;
        renderStart: number;
        renderTime: number;
        physicsStart: number;
        physicsTime: number;
        cullTime: number;
        sortTime: number;
        skinTime: number;
        morphTime: number;
        instancingTime: number;
        triangles: number;
        otherPrimitives: number;
        shaders: number;
        materials: number;
        cameras: number;
        shadowMapUpdates: number;
        shadowMapTime: number;
        depthMapTime: number;
        forwardTime: number;
        lightClustersTime: number;
        lightClusters: number;
        _timeToCountFrames: number;
        _fpsAccum: number; /**
         * The entity that was hit.
         *
         * @type {import('../../entity.js').Entity}
         */
    };
    ComponentType: typeof RigidBodyComponent;
    DataType: typeof RigidBodyComponentData;
    contactPointPool: ObjectPool;
    contactResultPool: ObjectPool;
    singleContactResultPool: ObjectPool;
    schema: string[];
    collisions: {};
    frameCollisions: {};
    /**
     * Called once Ammo has been loaded. Responsible for creating the physics world.
     *
     * @ignore
     */
    onLibraryLoaded(): void;
    collisionConfiguration: any;
    dispatcher: any;
    overlappingPairCache: any;
    solver: any;
    dynamicsWorld: any;
    initializeComponentData(component: any, data: any, properties: any): void;
    cloneComponent(entity: any, clone: any): Component;
    onBeforeRemove(entity: any, component: any): void;
    addBody(body: any, group: any, mask: any): void;
    removeBody(body: any): void;
    createBody(mass: any, shape: any, transform: any): any;
    destroyBody(body: any): void;
    /**
     * Raycast the world and return the first entity the ray hits. Fire a ray into the world from
     * start to end, if the ray hits an entity with a collision component, it returns a
     * {@link RaycastResult}, otherwise returns null.
     *
     * @param {Vec3} start - The world space point where the ray starts.
     * @param {Vec3} end - The world space point where the ray ends.
     * @param {object} [options] - The additional options for the raycasting.
     * @param {number} [options.filterCollisionGroup] - Collision group to apply to the raycast.
     * @param {number} [options.filterCollisionMask] - Collision mask to apply to the raycast.
     * @param {any[]} [options.filterTags] - Tags filters. Defined the same way as a {@link Tags#has}
     * query but within an array.
     * @param {Function} [options.filterCallback] - Custom function to use to filter entities.
     * Must return true to proceed with result. Takes one argument: the entity to evaluate.
     *
     * @returns {RaycastResult|null} The result of the raycasting or null if there was no hit.
     */
    raycastFirst(start: Vec3, end: Vec3, options?: {
        filterCollisionGroup?: number;
        filterCollisionMask?: number;
        filterTags?: any[];
        filterCallback?: Function;
    }): RaycastResult | null;
    /**
     * Raycast the world and return all entities the ray hits. It returns an array of
     * {@link RaycastResult}, one for each hit. If no hits are detected, the returned array will be
     * of length 0. Results are sorted by distance with closest first.
     *
     * @param {Vec3} start - The world space point where the ray starts.
     * @param {Vec3} end - The world space point where the ray ends.
     * @param {object} [options] - The additional options for the raycasting.
     * @param {boolean} [options.sort] - Whether to sort raycast results based on distance with closest
     * first. Defaults to false.
     * @param {number} [options.filterCollisionGroup] - Collision group to apply to the raycast.
     * @param {number} [options.filterCollisionMask] - Collision mask to apply to the raycast.
     * @param {any[]} [options.filterTags] - Tags filters. Defined the same way as a {@link Tags#has}
     * query but within an array.
     * @param {Function} [options.filterCallback] - Custom function to use to filter entities.
     * Must return true to proceed with result. Takes the entity to evaluate as argument.
     *
     * @returns {RaycastResult[]} An array of raycast hit results (0 length if there were no hits).
     *
     * @example
     * // Return all results of a raycast between 0, 2, 2 and 0, -2, -2
     * const hits = this.app.systems.rigidbody.raycastAll(new Vec3(0, 2, 2), new Vec3(0, -2, -2));
     * @example
     * // Return all results of a raycast between 0, 2, 2 and 0, -2, -2
     * // where hit entity is tagged with `bird` OR `mammal`
     * const hits = this.app.systems.rigidbody.raycastAll(new Vec3(0, 2, 2), new Vec3(0, -2, -2), {
     *     filterTags: [ "bird", "mammal" ]
     * });
     * @example
     * // Return all results of a raycast between 0, 2, 2 and 0, -2, -2
     * // where hit entity has a `camera` component
     * const hits = this.app.systems.rigidbody.raycastAll(new Vec3(0, 2, 2), new Vec3(0, -2, -2), {
     *     filterCallback: (entity) => entity && entity.camera
     * });
     * @example
     * // Return all results of a raycast between 0, 2, 2 and 0, -2, -2
     * // where hit entity is tagged with (`carnivore` AND `mammal`) OR (`carnivore` AND `reptile`)
     * // and the entity has an `anim` component
     * const hits = this.app.systems.rigidbody.raycastAll(new Vec3(0, 2, 2), new Vec3(0, -2, -2), {
     *     filterTags: [
     *         [ "carnivore", "mammal" ],
     *         [ "carnivore", "reptile" ]
     *     ],
     *     filterCallback: (entity) => entity && entity.anim
     * });
     */
    raycastAll(start: Vec3, end: Vec3, options?: {
        sort?: boolean;
        filterCollisionGroup?: number;
        filterCollisionMask?: number;
        filterTags?: any[];
        filterCallback?: Function;
    }): RaycastResult[];
    /**
     * Stores a collision between the entity and other in the contacts map and returns true if it
     * is a new collision.
     *
     * @param {import('../../entity.js').Entity} entity - The entity.
     * @param {import('../../entity.js').Entity} other - The entity that collides with the first
     * entity.
     * @returns {boolean} True if this is a new collision, false otherwise.
     * @private
     */
    private _storeCollision;
    _createContactPointFromAmmo(contactPoint: any): any;
    _createReverseContactPointFromAmmo(contactPoint: any): any;
    _createSingleContactResult(a: any, b: any, contactPoint: any): any;
    _createContactResult(other: any, contacts: any): any;
    /**
     * Removes collisions that no longer exist from the collisions list and fires collisionend
     * events to the related entities.
     *
     * @private
     */
    private _cleanOldCollisions;
    /**
     * Returns true if the entity has a contact event attached and false otherwise.
     *
     * @param {import('../../entity.js').Entity} entity - Entity to test.
     * @returns {boolean} True if the entity has a contact and false otherwise.
     * @private
     */
    private _hasContactEvent;
    /**
     * Checks for collisions and fires collision events.
     *
     * @param {number} world - The pointer to the dynamics world that invoked this callback.
     * @param {number} timeStep - The amount of simulation time processed in the last simulation tick.
     * @private
     */
    private _checkForCollisions;
    onUpdate(dt: any): void;
}
/**
 * Object holding the result of a contact between two rigid bodies.
 *
 * @category Physics
 */
declare class SingleContactResult {
    /**
     * Create a new SingleContactResult instance.
     *
     * @param {import('../../entity.js').Entity} a - The first entity involved in the contact.
     * @param {import('../../entity.js').Entity} b - The second entity involved in the contact.
     * @param {ContactPoint} contactPoint - The contact point between the two entities.
     * @hideconstructor
     */
    constructor(a: Entity, b: Entity, contactPoint: ContactPoint, ...args: any[]);
    /**
     * The first entity involved in the contact.
     *
     * @type {import('../../entity.js').Entity}
     */
    a: Entity;
    /**
     * The second entity involved in the contact.
     *
     * @type {import('../../entity.js').Entity}
     */
    b: Entity;
    /**
     * The total accumulated impulse applied by the constraint solver during the last
     * sub-step. Describes how hard two bodies collided.
     *
     * @type {number}
     */
    impulse: number;
    /**
     * The point on Entity A where the contact occurred, relative to A.
     *
     * @type {Vec3}
     */
    localPointA: Vec3;
    /**
     * The point on Entity B where the contact occurred, relative to B.
     *
     * @type {Vec3}
     */
    localPointB: Vec3;
    /**
     * The point on Entity A where the contact occurred, in world space.
     *
     * @type {Vec3}
     */
    pointA: Vec3;
    /**
     * The point on Entity B where the contact occurred, in world space.
     *
     * @type {Vec3}
     */
    pointB: Vec3;
    /**
     * The normal vector of the contact on Entity B, in world space.
     *
     * @type {Vec3}
     */
    normal: Vec3;
}

/**
 * Enables an Entity to render a {@link Mesh} or a primitive shape. This component attaches
 * {@link MeshInstance} geometry to the Entity.
 *
 * @property {import('../../entity.js').Entity} rootBone A reference to the entity to be used as
 * the root bone for any skinned meshes that are rendered by this component.
 * @augments Component
 * @category Graphics
 */
declare class RenderComponent extends Component {
    /**
     * Create a new RenderComponent.
     *
     * @param {import('./system.js').RenderComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {import('../../entity.js').Entity} entity - The Entity that this Component is
     * attached to.
     */
    constructor(system: RenderComponentSystem, entity: Entity);
    /** @private */
    private _type;
    /** @private */
    private _castShadows;
    /** @private */
    private _receiveShadows;
    /** @private */
    private _castShadowsLightmap;
    /** @private */
    private _lightmapped;
    /** @private */
    private _lightmapSizeMultiplier;
    /**
     * Mark meshes as non-movable (optimization).
     *
     * @type {boolean}
     */
    isStatic: boolean;
    /** @private */
    private _batchGroupId;
    /** @private */
    private _layers;
    /** @private */
    private _renderStyle;
    /**
     * @type {MeshInstance[]}
     * @private
     */
    private _meshInstances;
    /**
     * @type {import('../../../core/shape/bounding-box.js').BoundingBox|null}
     * @private
     */
    private _customAabb;
    /**
     * Used by lightmapper.
     *
     * @type {{x: number, y: number, z: number, uv: number}|null}
     * @ignore
     */
    _area: {
        x: number;
        y: number;
        z: number;
        uv: number;
    } | null;
    /**
     * @type {AssetReference}
     * @private
     */
    private _assetReference;
    /**
     * @type {AssetReference[]}
     * @private
     */
    private _materialReferences;
    /**
     * Material used to render meshes other than asset type. It gets priority when set to
     * something else than defaultMaterial, otherwise materialASsets[0] is used.
     *
     * @type {import('../../../scene/materials/material.js').Material}
     * @private
     */
    private _material;
    /**
     * @type {EntityReference}
     * @private
     */
    private _rootBone;
    /**
     * Set rendering of all {@link MeshInstance}s to the specified render style. Can be:
     *
     * - {@link RENDERSTYLE_SOLID}
     * - {@link RENDERSTYLE_WIREFRAME}
     * - {@link RENDERSTYLE_POINTS}
     *
     * Defaults to {@link RENDERSTYLE_SOLID}.
     *
     * @type {number}
     */
    set renderStyle(arg: number);
    get renderStyle(): number;
    /**
     * If set, the object space bounding box is used as a bounding box for visibility culling of
     * attached mesh instances. This is an optimization, allowing oversized bounding box to be
     * specified for skinned characters in order to avoid per frame bounding box computations based
     * on bone positions.
     *
     * @type {import('../../../core/shape/bounding-box.js').BoundingBox}
     */
    set customAabb(arg: BoundingBox);
    get customAabb(): BoundingBox;
    /**
     * The type of the render. Can be one of the following:
     *
     * - "asset": The component will render a render asset
     * - "box": The component will render a box (1 unit in each dimension)
     * - "capsule": The component will render a capsule (radius 0.5, height 2)
     * - "cone": The component will render a cone (radius 0.5, height 1)
     * - "cylinder": The component will render a cylinder (radius 0.5, height 1)
     * - "plane": The component will render a plane (1 unit in each dimension)
     * - "sphere": The component will render a sphere (radius 0.5)
     * - "torus": The component will render a torus (tubeRadius: 0.2, ringRadius: 0.3)
     *
     * @type {string}
     */
    set type(arg: string);
    get type(): string;
    /**
     * An array of meshInstances contained in the component. If meshes are not set or loaded for
     * component it will return null.
     *
     * @type {MeshInstance[]}
     */
    set meshInstances(arg: MeshInstance[]);
    get meshInstances(): MeshInstance[];
    /**
     * If true, the meshes will be lightmapped after using lightmapper.bake().
     *
     * @type {boolean}
     */
    set lightmapped(arg: boolean);
    get lightmapped(): boolean;
    /**
     * If true, attached meshes will cast shadows for lights that have shadow casting enabled.
     *
     * @type {boolean}
     */
    set castShadows(arg: boolean);
    get castShadows(): boolean;
    /**
     * If true, shadows will be cast on attached meshes.
     *
     * @type {boolean}
     */
    set receiveShadows(arg: boolean);
    get receiveShadows(): boolean;
    /**
     * If true, the meshes will cast shadows when rendering lightmaps.
     *
     * @type {boolean}
     */
    set castShadowsLightmap(arg: boolean);
    get castShadowsLightmap(): boolean;
    /**
     * Lightmap resolution multiplier.
     *
     * @type {number}
     */
    set lightmapSizeMultiplier(arg: number);
    get lightmapSizeMultiplier(): number;
    /**
     * An array of layer IDs ({@link Layer#id}) to which the meshes should belong. Don't push, pop,
     * splice or modify this array, if you want to change it - set a new one instead.
     *
     * @type {number[]}
     */
    set layers(arg: number[]);
    get layers(): number[];
    /**
     * Assign meshes to a specific batch group (see {@link BatchGroup}). Default is -1 (no group).
     *
     * @type {number}
     */
    set batchGroupId(arg: number);
    get batchGroupId(): number;
    /**
     * The material {@link Material} that will be used to render the meshes (not used on renders of
     * type 'asset').
     *
     * @type {import('../../../scene/materials/material.js').Material}
     */
    set material(arg: Material);
    get material(): Material;
    /**
     * The material assets that will be used to render the meshes. Each material corresponds to the
     * respective mesh instance.
     *
     * @type {Asset[]|number[]}
     */
    set materialAssets(arg: any[]);
    get materialAssets(): any[];
    /**
     * The render asset for the render component (only applies to type 'asset') - can also be an
     * asset id.
     *
     * @type {Asset|number}
     */
    set asset(arg: any);
    get asset(): any;
    /**
     * Assign asset id to the component, without updating the component with the new asset.
     * This can be used to assign the asset id to already fully created component.
     *
     * @param {Asset|number} asset - The render asset or asset id to assign.
     * @ignore
     */
    assignAsset(asset: Asset | number): void;
    /**
     * @param {import('../../entity.js').Entity} entity - The entity set as the root bone.
     * @private
     */
    private _onSetRootBone;
    /** @private */
    private _onRootBoneChanged;
    /** @private */
    private destroyMeshInstances;
    /** @private */
    private addToLayers;
    removeFromLayers(): void;
    /** @private */
    private onRemoveChild;
    /** @private */
    private onInsertChild;
    onRemove(): void;
    materialAsset: any;
    onLayersChanged(oldComp: any, newComp: any): void;
    onLayerAdded(layer: any): void;
    onLayerRemoved(layer: any): void;
    /**
     * Stop rendering {@link MeshInstance}s without removing them from the scene hierarchy. This
     * method sets the {@link MeshInstance#visible} property of every MeshInstance to false. Note,
     * this does not remove the mesh instances from the scene hierarchy or draw call list. So the
     * render component still incurs some CPU overhead.
     */
    hide(): void;
    /**
     * Enable rendering of the component's {@link MeshInstance}s if hidden using
     * {@link RenderComponent#hide}. This method sets the {@link MeshInstance#visible} property on
     * all mesh instances to true.
     */
    show(): void;
    _onRenderAssetAdded(): void;
    _onRenderAssetLoad(): void;
    _onSetMeshes(meshes: any): void;
    _clearSkinInstances(): void;
    _cloneSkinInstances(): void;
    _cloneMeshes(meshes: any): void;
    _onRenderAssetUnload(): void;
    _onRenderAssetRemove(): void;
    _onMaterialAdded(index: any, component: any, asset: any): void;
    _updateMainMaterial(index: any, material: any): void;
    _onMaterialLoad(index: any, component: any, asset: any): void;
    _onMaterialRemove(index: any, component: any, asset: any): void;
    _onMaterialUnload(index: any, component: any, asset: any): void;
    resolveDuplicatedEntityReferenceProperties(oldRender: any, duplicatedIdsMap: any): void;
    rootBone: any;
}

declare class RenderComponentData {
    enabled: boolean;
    rootBone: any;
}

/**
 * Allows an Entity to render a mesh or a primitive shape like a box, capsule, sphere, cylinder,
 * cone etc.
 *
 * @augments ComponentSystem
 * @category Graphics
 */
declare class RenderComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof RenderComponent;
    DataType: typeof RenderComponentData;
    schema: (string | {
        name: string;
        type: string;
    })[];
    defaultMaterial: StandardMaterial;
    initializeComponentData(component: any, _data: any, properties: any): void;
    cloneComponent(entity: any, clone: any): Component;
    onRemove(entity: any, component: any): void;
}

declare class ParticleGPUUpdater {
    constructor(emitter: any, gd: any);
    _emitter: any;
    frameRandomUniform: Float32Array;
    emitterPosUniform: Float32Array;
    emitterScaleUniform: Float32Array;
    worldBoundsMulUniform: Float32Array;
    worldBoundsAddUniform: Float32Array;
    inBoundsSizeUniform: Float32Array;
    inBoundsCenterUniform: Float32Array;
    constantParticleTexIN: any;
    constantParticleTexOUT: any;
    constantEmitterPos: any;
    constantEmitterScale: any;
    constantSpawnBounds: any;
    constantSpawnPosInnerRatio: any;
    constantSpawnBoundsSphere: any;
    constantSpawnBoundsSphereInnerRatio: any;
    constantInitialVelocity: any;
    constantFrameRandom: any;
    constantDelta: any;
    constantRate: any;
    constantRateDiv: any;
    constantLifetime: any;
    constantGraphSampleSize: any;
    constantGraphNumSamples: any;
    constantInternalTex0: any;
    constantInternalTex1: any;
    constantInternalTex2: any;
    constantInternalTex3: any;
    constantEmitterMatrix: any;
    constantEmitterMatrixInv: any;
    constantNumParticles: any;
    constantNumParticlesPot: any;
    constantLocalVelocityDivMult: any;
    constantVelocityDivMult: any;
    constantRotSpeedDivMult: any;
    constantSeed: any;
    constantStartAngle: any;
    constantStartAngle2: any;
    constantOutBoundsMul: any;
    constantOutBoundsAdd: any;
    constantInBoundsSize: any;
    constantInBoundsCenter: any;
    constantMaxVel: any;
    constantFaceTangent: any;
    constantFaceBinorm: any;
    _setInputBounds(): void;
    randomize(): void;
    update(device: any, spawnMatrix: any, extentsInnerRatioUniform: any, delta: any, isOnStop: any): void;
}

declare class ParticleCPUUpdater {
    constructor(emitter: any);
    _emitter: any;
    calcSpawnPosition(particleTex: any, spawnMatrix: any, extentsInnerRatioUniform: any, emitterPos: any, i: any): void;
    update(data: any, vbToSort: any, particleTex: any, spawnMatrix: any, extentsInnerRatioUniform: any, emitterPos: any, delta: any, isOnStop: any): void;
}

declare class ParticleEmitter {
    constructor(graphicsDevice: any, options: any);
    graphicsDevice: any;
    precision: number;
    _addTimeTime: number;
    numParticles: any;
    _gpuUpdater: ParticleGPUUpdater;
    _cpuUpdater: ParticleCPUUpdater;
    emitterPosUniform: Float32Array;
    wrapBoundsUniform: Float32Array;
    emitterScaleUniform: Float32Array;
    animTilesParams: Float32Array;
    animParams: Float32Array;
    animIndexParams: Float32Array;
    internalTex0: Texture;
    internalTex1: Texture;
    internalTex2: Texture;
    colorParam: Texture;
    vbToSort: any[];
    vbOld: Float32Array;
    particleDistance: Float32Array;
    camera: any;
    swapTex: boolean;
    useMesh: boolean;
    useCpu: boolean;
    pack8: boolean;
    localBounds: BoundingBox;
    worldBoundsNoTrail: BoundingBox;
    worldBoundsTrail: BoundingBox[];
    worldBounds: BoundingBox;
    worldBoundsSize: Vec3;
    prevWorldBoundsSize: Vec3;
    prevWorldBoundsCenter: Vec3;
    prevEmitterExtents: any;
    prevEmitterRadius: any;
    worldBoundsMul: Vec3;
    worldBoundsAdd: Vec3;
    timeToSwitchBounds: number;
    shaderParticleUpdateRespawn: Shader;
    shaderParticleUpdateNoRespawn: Shader;
    shaderParticleUpdateOnStop: Shader;
    numParticleVerts: number;
    numParticleIndices: number;
    material: Material;
    meshInstance: MeshInstance;
    drawOrder: number;
    seed: number;
    fixedTimeStep: number;
    maxSubSteps: number;
    simTime: number;
    simTimeTotal: number;
    beenReset: boolean;
    _layer: any;
    get defaultParamTexture(): any;
    onChangeCamera(): void;
    calculateBoundsMad(): void;
    calculateWorldBounds(): void;
    resetWorldBounds(): void;
    calculateLocalBounds(): void;
    rebuild(): void;
    colorMap: any;
    spawnBounds: any;
    numParticlesPot: number;
    particleTex: Float32Array;
    particleTexStart: any;
    particleTexIN: Texture;
    particleTexOUT: Texture;
    rtParticleTexIN: RenderTarget;
    rtParticleTexOUT: RenderTarget;
    _isAnimated(): any;
    rebuildGraphs(): void;
    qLocalVelocity: any;
    qVelocity: any;
    qColor: any;
    qRotSpeed: any;
    qScale: any;
    qAlpha: any;
    qRadialSpeed: any;
    qLocalVelocity2: any;
    qVelocity2: any;
    qColor2: any;
    qRotSpeed2: any;
    qScale2: any;
    qAlpha2: any;
    qRadialSpeed2: any;
    localVelocityUMax: Float32Array;
    velocityUMax: Float32Array;
    colorUMax: Float32Array;
    rotSpeedUMax: number[];
    scaleUMax: number[];
    alphaUMax: number[];
    radialSpeedUMax: number[];
    qLocalVelocityDiv: Float32Array;
    qVelocityDiv: Float32Array;
    qColorDiv: Float32Array;
    qRotSpeedDiv: Float32Array;
    qScaleDiv: Float32Array;
    qAlphaDiv: Float32Array;
    qRadialSpeedDiv: Float32Array;
    maxVel: number;
    internalTex3: Texture;
    _initializeTextures(): void;
    regenShader(): void;
    normalOption: number;
    resetMaterial(): void;
    _compParticleFaceParams(): void;
    _allocate(numParticles: any): void;
    vertexBuffer: VertexBuffer;
    indexBuffer: IndexBuffer;
    vbCPU: Float32Array;
    reset(): void;
    loop: any;
    prewarm(time: any): void;
    resetTime(): void;
    endTime: number;
    finishFrame(): void;
    addTime(delta: any, isOnStop: any): void;
    _destroyResources(): void;
    destroy(): void;
}

/**
 * A curve is a collection of keys (time/value pairs). The shape of the curve is defined by its
 * type that specifies an interpolation scheme for the keys.
 *
 * @category Math
 */
declare class Curve {
    /**
     * Creates a new Curve instance.
     *
     * @param {number[]} [data] - An array of keys (pairs of numbers with the time first and value
     * second).
     * @example
     * const curve = new pc.Curve([
     *     0, 0,        // At 0 time, value of 0
     *     0.33, 2,     // At 0.33 time, value of 2
     *     0.66, 2.6,   // At 0.66 time, value of 2.6
     *     1, 3         // At 1 time, value of 3
     * ]);
     */
    constructor(data?: number[]);
    keys: any[];
    /**
     * The curve interpolation scheme. Can be:
     *
     * - {@link CURVE_LINEAR}
     * - {@link CURVE_SMOOTHSTEP}
     * - {@link CURVE_SPLINE}
     * - {@link CURVE_STEP}
     *
     * Defaults to {@link CURVE_SMOOTHSTEP}.
     *
     * @type {number}
     */
    type: number;
    /**
     * Controls how {@link CURVE_SPLINE} tangents are calculated. Valid range is between 0 and 1
     * where 0 results in a non-smooth curve (equivalent to linear interpolation) and 1 results in
     * a very smooth curve. Use 0.5 for a Catmull-rom spline.
     *
     * @type {number}
     */
    tension: number;
    /**
     * @type {CurveEvaluator}
     * @private
     */
    private _eval;
    /**
     * Get the number of keys in the curve.
     *
     * @type {number}
     */
    get length(): number;
    /**
     * Add a new key to the curve.
     *
     * @param {number} time - Time to add new key.
     * @param {number} value - Value of new key.
     * @returns {number[]} [time, value] pair.
     */
    add(time: number, value: number): number[];
    /**
     * Return a specific key.
     *
     * @param {number} index - The index of the key to return.
     * @returns {number[]} The key at the specified index.
     */
    get(index: number): number[];
    /**
     * Sort keys by time.
     */
    sort(): void;
    /**
     * Returns the interpolated value of the curve at specified time.
     *
     * @param {number} time - The time at which to calculate the value.
     * @returns {number} The interpolated value.
     */
    value(time: number): number;
    closest(time: any): any;
    /**
     * Returns a clone of the specified curve object.
     *
     * @returns {this} A clone of the specified curve.
     */
    clone(): this;
    /**
     * Sample the curve at regular intervals over the range [0..1].
     *
     * @param {number} precision - The number of samples to return.
     * @returns {Float32Array} The set of quantized values.
     * @ignore
     */
    quantize(precision: number): Float32Array;
    /**
     * Sample the curve at regular intervals over the range [0..1] and clamp the resulting samples
     * to [min..max].
     *
     * @param {number} precision - The number of samples to return.
     * @param {number} min - The minimum output value.
     * @param {number} max - The maximum output value.
     * @returns {Float32Array} The set of quantized values.
     * @ignore
     */
    quantizeClamped(precision: number, min: number, max: number): Float32Array;
}

/**
 * A curve set is a collection of curves.
 *
 * @category Math
 */
declare class CurveSet {
    /**
     * Creates a new CurveSet instance.
     *
     * @param {Array<number[]>} curveKeys - An array of arrays of keys (pairs of numbers with the
     * time first and value second).
     * @example
     * const curveSet = new pc.CurveSet([
     *     [
     *         0, 0,        // At 0 time, value of 0
     *         0.33, 2,     // At 0.33 time, value of 2
     *         0.66, 2.6,   // At 0.66 time, value of 2.6
     *         1, 3         // At 1 time, value of 3
     *     ],
     *     [
     *         0, 34,
     *         0.33, 35,
     *         0.66, 36,
     *         1, 37
     *     ]
     * ]);
     */
    constructor(...args: any[]);
    curves: any[];
    /**
     * @type {number}
     * @private
     */
    private _type;
    /**
     * The number of curves in the curve set.
     *
     * @type {number}
     */
    get length(): number;
    /**
     * The interpolation scheme applied to all curves in the curve set. Can be:
     *
     * - {@link CURVE_LINEAR}
     * - {@link CURVE_SMOOTHSTEP}
     * - {@link CURVE_SPLINE}
     * - {@link CURVE_STEP}
     *
     * Defaults to {@link CURVE_SMOOTHSTEP}.
     *
     * @type {number}
     */
    set type(arg: number);
    get type(): number;
    /**
     * Return a specific curve in the curve set.
     *
     * @param {number} index - The index of the curve to return.
     * @returns {Curve} The curve at the specified index.
     */
    get(index: number): Curve;
    /**
     * Returns the interpolated value of all curves in the curve set at the specified time.
     *
     * @param {number} time - The time at which to calculate the value.
     * @param {number[]} [result] - The interpolated curve values at the specified time. If this
     * parameter is not supplied, the function allocates a new array internally to return the
     * result.
     * @returns {number[]} The interpolated curve values at the specified time.
     */
    value(time: number, result?: number[]): number[];
    /**
     * Returns a clone of the specified curve set object.
     *
     * @returns {this} A clone of the specified curve set.
     */
    clone(): this;
    /**
     * Sample the curveset at regular intervals over the range [0..1].
     *
     * @param {number} precision - The number of samples to return.
     * @returns {Float32Array} The set of quantized values.
     * @ignore
     */
    quantize(precision: number): Float32Array;
    /**
     * Sample the curveset at regular intervals over the range [0..1] and clamp the result to min
     * and max.
     *
     * @param {number} precision - The number of samples to return.
     * @param {number} min - The minimum output value.
     * @param {number} max - The maximum output value.
     * @returns {Float32Array} The set of quantized values.
     * @ignore
     */
    quantizeClamped(precision: number, min: number, max: number): Float32Array;
}

/**
 * Used to simulate particles and produce renderable particle mesh on either CPU or GPU. GPU
 * simulation is generally much faster than its CPU counterpart, because it avoids slow CPU-GPU
 * synchronization and takes advantage of many GPU cores. However, it requires client to support
 * reasonable uniform count, reading from multiple textures in vertex shader and OES_texture_float
 * extension, including rendering into float textures. Most mobile devices fail to satisfy these
 * requirements, so it's not recommended to simulate thousands of particles on them. GPU version
 * also can't sort particles, so enabling sorting forces CPU mode too. Particle rotation is
 * specified by a single angle parameter: default billboard particles rotate around camera facing
 * axis, while mesh particles rotate around 2 different view-independent axes. Most of the
 * simulation parameters are specified with {@link Curve} or {@link CurveSet}. Curves are
 * interpolated based on each particle's lifetime, therefore parameters are able to change over
 * time. Most of the curve parameters can also be specified by 2 minimum/maximum curves, this way
 * each particle will pick a random value in-between.
 *
 * @property {boolean} autoPlay Controls whether the particle system plays automatically on
 * creation. If set to false, it is necessary to call {@link ParticleSystemComponent#play} for the
 * particle system to play. Defaults to true.
 * @property {boolean} loop Enables or disables respawning of particles.
 * @property {boolean} preWarm If enabled, the particle system will be initialized as though it had
 * already completed a full cycle. This only works with looping particle systems.
 * @property {boolean} lighting If enabled, particles will be lit by ambient and directional
 * lights.
 * @property {boolean} halfLambert Enabling Half Lambert lighting avoids particles looking too flat
 * in shadowed areas. It is a completely non-physical lighting model but can give more pleasing
 * visual results.
 * @property {boolean} alignToMotion Orient particles in their direction of motion.
 * @property {boolean} depthWrite If enabled, the particles will write to the depth buffer. If
 * disabled, the depth buffer is left unchanged and particles will be guaranteed to overwrite one
 * another in the order in which they are rendered.
 * @property {boolean} noFog Disable fogging.
 * @property {boolean} localSpace Binds particles to emitter transformation rather then world
 * space.
 * @property {boolean} screenSpace Renders particles in 2D screen space. This needs to be set when
 * particle system is part of hierarchy with {@link ScreenComponent} as its ancestor, and allows
 * particle system to integrate with the rendering of {@link ElementComponent}s. Note that an
 * entity with ParticleSystem component cannot be parented directly to {@link ScreenComponent}, but
 * has to be a child of a {@link ElementComponent}, for example {@link LayoutGroupComponent}.
 * @property {number} numParticles Maximum number of simulated particles.
 * @property {number} rate Minimal interval in seconds between particle births.
 * @property {number} rate2 Maximal interval in seconds between particle births.
 * @property {number} startAngle Minimal initial Euler angle of a particle.
 * @property {number} startAngle2 Maximal initial Euler angle of a particle.
 * @property {number} lifetime The length of time in seconds between a particle's birth and its
 * death.
 * @property {number} stretch A value in world units that controls the amount by which particles
 * are stretched based on their velocity. Particles are stretched from their center towards their
 * previous position.
 * @property {number} intensity Color multiplier.
 * @property {boolean} animLoop Controls whether the sprite sheet animation plays once or loops
 * continuously.
 * @property {number} animTilesX Number of horizontal tiles in the sprite sheet.
 * @property {number} animTilesY Number of vertical tiles in the sprite sheet.
 * @property {number} animNumAnimations Number of sprite sheet animations contained within the
 * current sprite sheet. The number of animations multiplied by number of frames should be a value
 * less than animTilesX multiplied by animTilesY.
 * @property {number} animNumFrames Number of sprite sheet frames in the current sprite sheet
 * animation. The number of animations multiplied by number of frames should be a value less than
 * animTilesX multiplied by animTilesY.
 * @property {number} animStartFrame The sprite sheet frame that the animation should begin playing
 * from. Indexed from the start of the current animation.
 * @property {number} animIndex When animNumAnimations is greater than 1, the sprite sheet
 * animation index determines which animation the particle system should play.
 * @property {number} randomizeAnimIndex Each particle emitted by the system will play a random
 * animation from the sprite sheet, up to animNumAnimations.
 * @property {number} animSpeed Sprite sheet animation speed. 1 = particle lifetime, 2 = twice
 * during lifetime etc...
 * @property {number} depthSoftening Controls fading of particles near their intersections with
 * scene geometry. This effect, when it's non-zero, requires scene depth map to be rendered.
 * Multiple depth-dependent effects can share the same map, but if you only use it for particles,
 * bear in mind that it can double engine draw calls.
 * @property {number} initialVelocity Defines magnitude of the initial emitter velocity. Direction
 * is given by emitter shape.
 * @property {import('../../../core/math/vec3.js').Vec3} emitterExtents (Only for EMITTERSHAPE_BOX)
 * The extents of a local space bounding box within which particles are spawned at random positions.
 * @property {import('../../../core/math/vec3.js').Vec3} emitterExtentsInner (Only for
 * EMITTERSHAPE_BOX) The exception of extents of a local space bounding box within which particles
 * are not spawned. Aligned to the center of EmitterExtents.
 * @property {number} emitterRadius (Only for EMITTERSHAPE_SPHERE) The radius within which
 * particles are spawned at random positions.
 * @property {number} emitterRadiusInner (Only for EMITTERSHAPE_SPHERE) The inner radius within
 * which particles are not spawned.
 * @property {import('../../../core/math/vec3.js').Vec3} wrapBounds The half extents of a world
 * space box volume centered on the owner entity's position. If a particle crosses the boundary of
 * one side of the volume, it teleports to the opposite side.
 * @property {Asset} colorMapAsset The {@link Asset} used to set the colorMap.
 * @property {Asset} normalMapAsset The {@link Asset} used to set the normalMap.
 * @property {Asset} meshAsset The {@link Asset} used to set the mesh.
 * @property {Asset} renderAsset The Render {@link Asset} used to set the mesh.
 * @property {Texture} colorMap The color map texture to apply to all particles in the system. If
 * no texture is assigned, a default spot texture is used.
 * @property {Texture} normalMap The normal map texture to apply to all particles in the system. If
 * no texture is assigned, an approximate spherical normal is calculated for each vertex.
 * @property {number} emitterShape Shape of the emitter. Defines the bounds inside which particles
 * are spawned. Also affects the direction of initial velocity.
 *
 * - {@link EMITTERSHAPE_BOX}: Box shape parameterized by emitterExtents. Initial velocity is
 * directed towards local Z axis.
 * - {@link EMITTERSHAPE_SPHERE}: Sphere shape parameterized by emitterRadius. Initial velocity is
 * directed outwards from the center.
 *
 * @property {number} sort Sorting mode. Forces CPU simulation, so be careful.
 *
 * - {@link PARTICLESORT_NONE}: No sorting, particles are drawn in arbitrary order. Can be
 * simulated on GPU.
 * - {@link PARTICLESORT_DISTANCE}: Sorting based on distance to the camera. CPU only.
 * - {@link PARTICLESORT_NEWER_FIRST}: Newer particles are drawn first. CPU only.
 * - {@link PARTICLESORT_OLDER_FIRST}: Older particles are drawn first. CPU only.
 *
 * @property {Mesh} mesh Triangular mesh to be used as a particle. Only first vertex/index buffer
 * is used. Vertex buffer must contain local position at first 3 floats of each vertex.
 * @property {number} blendType Controls how particles are blended when being written to the currently
 * active render target. Can be:
 *
 * - {@link BLEND_SUBTRACTIVE}: Subtract the color of the source fragment from the destination
 * fragment and write the result to the frame buffer.
 * - {@link BLEND_ADDITIVE}: Add the color of the source fragment to the destination fragment and
 * write the result to the frame buffer.
 * - {@link BLEND_NORMAL}: Enable simple translucency for materials such as glass. This is
 * equivalent to enabling a source blend mode of {@link BLENDMODE_SRC_ALPHA} and a destination
 * blend mode of {@link BLENDMODE_ONE_MINUS_SRC_ALPHA}.
 * - {@link BLEND_NONE}: Disable blending.
 * - {@link BLEND_PREMULTIPLIED}: Similar to {@link BLEND_NORMAL} expect the source fragment is
 * assumed to have already been multiplied by the source alpha value.
 * - {@link BLEND_MULTIPLICATIVE}: Multiply the color of the source fragment by the color of the
 * destination fragment and write the result to the frame buffer.
 * - {@link BLEND_ADDITIVEALPHA}: Same as {@link BLEND_ADDITIVE} except the source RGB is
 * multiplied by the source alpha.
 *
 * @property {number} orientation Sorting mode. Forces CPU simulation, so be careful.
 *
 * - {@link PARTICLEORIENTATION_SCREEN}: Particles are facing camera.
 * - {@link PARTICLEORIENTATION_WORLD}: User defines world space normal (particleNormal) to set
 * planes orientation.
 * - {@link PARTICLEORIENTATION_EMITTER}: Similar to previous, but the normal is affected by
 * emitter (entity) transformation.
 *
 * @property {import('../../../core/math/vec3.js').Vec3} particleNormal (Only for
 * PARTICLEORIENTATION_WORLD and PARTICLEORIENTATION_EMITTER) The exception of extents of a local
 * space bounding box within which particles are not spawned. Aligned to the center of
 * EmitterExtents.
 * @property {import('../../../core/math/curve-set.js').CurveSet} localVelocityGraph Velocity
 * relative to emitter over lifetime.
 * @property {import('../../../core/math/curve-set.js').CurveSet} localVelocityGraph2 If not null,
 * particles pick random values between localVelocityGraph and localVelocityGraph2.
 * @property {import('../../../core/math/curve-set.js').CurveSet} velocityGraph World-space
 * velocity over lifetime.
 * @property {import('../../../core/math/curve-set.js').CurveSet} velocityGraph2 If not null,
 * particles pick random values between velocityGraph and velocityGraph2.
 * @property {import('../../../core/math/curve-set.js').CurveSet} colorGraph Color over lifetime.
 * @property {import('../../../core/math/curve.js').Curve} rotationSpeedGraph Rotation speed over
 * lifetime.
 * @property {import('../../../core/math/curve.js').Curve} rotationSpeedGraph2 If not null,
 * particles pick random values between rotationSpeedGraph and rotationSpeedGraph2.
 * @property {import('../../../core/math/curve.js').Curve} radialSpeedGraph Radial speed over
 * lifetime, velocity vector points from emitter origin to particle pos.
 * @property {import('../../../core/math/curve.js').Curve} radialSpeedGraph2 If not null, particles
 * pick random values between radialSpeedGraph and radialSpeedGraph2.
 * @property {import('../../../core/math/curve.js').Curve} scaleGraph Scale over lifetime.
 * @property {import('../../../core/math/curve.js').Curve} scaleGraph2 If not null, particles pick
 * random values between scaleGraph and scaleGraph2.
 * @property {import('../../../core/math/curve.js').Curve} alphaGraph Alpha over lifetime.
 * @property {import('../../../core/math/curve.js').Curve} alphaGraph2 If not null, particles pick
 * random values between alphaGraph and alphaGraph2.
 * @property {number[]} layers An array of layer IDs ({@link Layer#id}) to which this particle
 * system should belong. Don't push/pop/splice or modify this array, if you want to change it - set
 * a new one instead.
 * @augments Component
 * @category Graphics
 */
declare class ParticleSystemComponent extends Component {
    /**
     * Create a new ParticleSystemComponent.
     *
     * @param {import('./system.js').ParticleSystemComponentSystem} system - The ComponentSystem
     * that created this Component.
     * @param {import('../../entity.js').Entity} entity - The Entity this Component is attached to.
     */
    constructor(system: ParticleSystemComponentSystem, entity: Entity);

    set alignToMotion(arg: boolean);
    get alignToMotion(): boolean;

    set alphaGraph(arg: Curve);
    get alphaGraph(): Curve;

    set alphaGraph2(arg: Curve);
    get alphaGraph2(): Curve;

    set animIndex(arg: number);
    get animIndex(): number;

    set animLoop(arg: boolean);
    get animLoop(): boolean;

    set animNumAnimations(arg: number);
    get animNumAnimations(): number;

    set animNumFrames(arg: number);
    get animNumFrames(): number;

    set animSpeed(arg: number);
    get animSpeed(): number;

    set animStartFrame(arg: number);
    get animStartFrame(): number;

    set animTilesX(arg: number);
    get animTilesX(): number;

    set animTilesY(arg: number);
    get animTilesY(): number;

    set autoPlay(arg: boolean);
    get autoPlay(): boolean;

    set blend(arg: number);
    get blend(): number;

    set colorGraph(arg: CurveSet);
    get colorGraph(): CurveSet;

    set colorMapAsset(arg: Asset);
    get colorMapAsset(): Asset;

    set depthSoftening(arg: number);
    get depthSoftening(): number;

    set depthWrite(arg: boolean);
    get depthWrite(): boolean;

    set emitterExtents(arg: Vec3);
    get emitterExtents(): Vec3;

    set emitterExtentsInner(arg: Vec3);
    get emitterExtentsInner(): Vec3;

    set emitterRadius(arg: number);
    get emitterRadius(): number;

    set emitterRadiusInner(arg: number);
    get emitterRadiusInner(): number;

    set emitterShape(arg: number);
    get emitterShape(): number;

    set halfLambert(arg: boolean);
    get halfLambert(): boolean;

    set initialVelocity(arg: number);
    get initialVelocity(): number;

    set intensity(arg: number);
    get intensity(): number;

    set layers(arg: number[]);
    get layers(): number[];

    set lifetime(arg: number);
    get lifetime(): number;

    set lighting(arg: boolean);
    get lighting(): boolean;

    set localSpace(arg: boolean);
    get localSpace(): boolean;

    set localVelocityGraph(arg: CurveSet);
    get localVelocityGraph(): CurveSet;

    set localVelocityGraph2(arg: CurveSet);
    get localVelocityGraph2(): CurveSet;

    set loop(arg: boolean);
    get loop(): boolean;

    set noFog(arg: boolean);
    get noFog(): boolean;

    set normalMapAsset(arg: Asset);
    get normalMapAsset(): Asset;

    set numParticles(arg: number);
    get numParticles(): number;

    set orientation(arg: number);
    get orientation(): number;

    set particleNormal(arg: Vec3);
    get particleNormal(): Vec3;

    set preWarm(arg: boolean);
    get preWarm(): boolean;

    set radialSpeedGraph(arg: Curve);
    get radialSpeedGraph(): Curve;

    set radialSpeedGraph2(arg: Curve);
    get radialSpeedGraph2(): Curve;

    set randomizeAnimIndex(arg: number);
    get randomizeAnimIndex(): number;

    set rate(arg: number);
    get rate(): number;

    set rate2(arg: number);
    get rate2(): number;

    set renderAsset(arg: Asset);
    get renderAsset(): Asset;

    set rotationSpeedGraph(arg: Curve);
    get rotationSpeedGraph(): Curve;

    set rotationSpeedGraph2(arg: Curve);
    get rotationSpeedGraph2(): Curve;

    set scaleGraph(arg: Curve);
    get scaleGraph(): Curve;

    set scaleGraph2(arg: Curve);
    get scaleGraph2(): Curve;

    set screenSpace(arg: boolean);
    get screenSpace(): boolean;

    set sort(arg: number);
    get sort(): number;

    set startAngle(arg: number);
    get startAngle(): number;

    set startAngle2(arg: number);
    get startAngle2(): number;

    set stretch(arg: number);
    get stretch(): number;

    set velocityGraph(arg: CurveSet);
    get velocityGraph(): CurveSet;

    set velocityGraph2(arg: CurveSet);
    get velocityGraph2(): CurveSet;

    set wrapBounds(arg: Vec3);
    get wrapBounds(): Vec3;

    /** @private */
    private _requestedDepth;
    /** @private */
    private _drawOrder;
    set drawOrder(arg: number);
    get drawOrder(): number;
    addMeshInstanceToLayers(): void;
    removeMeshInstanceFromLayers(): void;
    onSetLayers(name: any, oldValue: any, newValue: any): void;
    onLayersChanged(oldComp: any, newComp: any): void;
    onLayerAdded(layer: any): void;
    onLayerRemoved(layer: any): void;
    _bindColorMapAsset(asset: any): void;
    _unbindColorMapAsset(asset: any): void;
    _onColorMapAssetLoad(asset: any): void;
    colorMap: any;
    _onColorMapAssetUnload(asset: any): void;
    _onColorMapAssetRemove(asset: any): void;
    _onColorMapAssetChange(asset: any): void;
    onSetColorMapAsset(name: any, oldValue: any, newValue: any): void;
    _bindNormalMapAsset(asset: any): void;
    _unbindNormalMapAsset(asset: any): void;
    _onNormalMapAssetLoad(asset: any): void;
    normalMap: any;
    _onNormalMapAssetUnload(asset: any): void;
    _onNormalMapAssetRemove(asset: any): void;
    _onNormalMapAssetChange(asset: any): void;
    onSetNormalMapAsset(name: any, oldValue: any, newValue: any): void;
    _bindMeshAsset(asset: any): void;
    _unbindMeshAsset(asset: any): void;
    _onMeshAssetLoad(asset: any): void;
    _onMeshAssetUnload(asset: any): void;
    mesh: any;
    _onMeshAssetRemove(asset: any): void;
    _onMeshAssetChange(asset: any): void;
    onSetMeshAsset(name: any, oldValue: any, newValue: any): void;
    onSetMesh(name: any, oldValue: any, newValue: any): void;
    meshAsset: any;
    _onMeshChanged(mesh: any): void;
    onSetRenderAsset(name: any, oldValue: any, newValue: any): void;
    _bindRenderAsset(asset: any): void;
    _unbindRenderAsset(asset: any): void;
    _onRenderAssetLoad(asset: any): void;
    _onRenderAssetUnload(asset: any): void;
    _onRenderAssetRemove(asset: any): void;
    _onRenderChanged(render: any): void;
    _onRenderSetMeshes(meshes: any): void;
    onSetLoop(name: any, oldValue: any, newValue: any): void;
    onSetBlendType(name: any, oldValue: any, newValue: any): void;
    _requestDepth(): void;
    _releaseDepth(): void;
    onSetDepthSoftening(name: any, oldValue: any, newValue: any): void;
    onSetSimpleProperty(name: any, oldValue: any, newValue: any): void;
    onSetComplexProperty(name: any, oldValue: any, newValue: any): void;
    onSetGraphProperty(name: any, oldValue: any, newValue: any): void;
    emitter: ParticleEmitter;
    onBeforeRemove(): void;
    
    /**
     * Resets particle state, doesn't affect playing.
     */
    reset(): void;
    /**
     * Disables the emission of new particles, lets existing to finish their simulation.
     */
    stop(): void;
    /**
     * Freezes the simulation.
     */
    pause(): void;
    /**
     * Unfreezes the simulation.
     */
    unpause(): void;
    /**
     * Enables/unfreezes the simulation.
     */
    play(): void;
    /**
     * Checks if simulation is in progress.
     *
     * @returns {boolean} True if the particle system is currently playing and false otherwise.
     */
    isPlaying(): boolean;
    /**
     * Rebuilds all data used by this particle system.
     *
     * @private
     */
    private rebuild;
}

declare class ParticleSystemComponentData {
    numParticles: number;
    rate: number;
    rate2: any;
    startAngle: number;
    startAngle2: any;
    lifetime: number;
    emitterExtents: Vec3;
    emitterExtentsInner: Vec3;
    emitterRadius: number;
    emitterRadiusInner: number;
    emitterShape: number;
    initialVelocity: number;
    wrapBounds: Vec3;
    localSpace: boolean;
    screenSpace: boolean;
    colorMap: any;
    colorMapAsset: any;
    normalMap: any;
    normalMapAsset: any;
    loop: boolean;
    preWarm: boolean;
    sort: number;
    mode: number;
    scene: any;
    lighting: boolean;
    halfLambert: boolean;
    intensity: number;
    stretch: number;
    alignToMotion: boolean;
    depthSoftening: number;
    meshAsset: any;
    mesh: any;
    depthWrite: boolean;
    noFog: boolean;
    orientation: number;
    particleNormal: Vec3;
    animTilesX: number;
    animTilesY: number;
    animStartFrame: number;
    animNumFrames: number;
    animNumAnimations: number;
    animIndex: number;
    randomizeAnimIndex: boolean;
    animSpeed: number;
    animLoop: boolean;
    scaleGraph: any;
    scaleGraph2: any;
    colorGraph: any;
    colorGraph2: any;
    alphaGraph: any;
    alphaGraph2: any;
    localVelocityGraph: any;
    localVelocityGraph2: any;
    velocityGraph: any;
    velocityGraph2: any;
    rotationSpeedGraph: any;
    rotationSpeedGraph2: any;
    radialSpeedGraph: any;
    radialSpeedGraph2: any;
    blendType: number;
    enabled: boolean;
    paused: boolean;
    autoPlay: boolean;
    layers: number[];
}

/**
 * Allows an Entity to render a particle system.
 *
 * @augments ComponentSystem
 * @category Graphics
 */
declare class ParticleSystemComponentSystem extends ComponentSystem {
    id: string;
    ComponentType: typeof ParticleSystemComponent;
    DataType: typeof ParticleSystemComponentData;
    schema: string[];
    propertyTypes: {
        emitterExtents: string;
        emitterExtentsInner: string;
        particleNormal: string;
        wrapBounds: string;
        localVelocityGraph: string;
        localVelocityGraph2: string;
        velocityGraph: string;
        velocityGraph2: string;
        colorGraph: string;
        colorGraph2: string;
        alphaGraph: string;
        alphaGraph2: string;
        rotationSpeedGraph: string;
        rotationSpeedGraph2: string;
        radialSpeedGraph: string;
        radialSpeedGraph2: string;
        scaleGraph: string;
        scaleGraph2: string;
    };
    initializeComponentData(component: any, _data: any, properties: any): void;
    cloneComponent(entity: any, clone: any): Component;
    onUpdate(dt: any): void;
    onBeforeRemove(entity: any, component: any): void;
}

/**
 * Enables an Entity to render a model or a primitive shape. This Component attaches additional
 * model geometry in to the scene graph below the Entity.
 *
 * @augments Component
 * @category Graphics
 */
declare class ModelComponent extends Component {
    /**
     * Create a new ModelComponent instance.
     *
     * @param {import('./system.js').ModelComponentSystem} system - The ComponentSystem that
     * created this Component.
     * @param {import('../../entity.js').Entity} entity - The Entity that this Component is
     * attached to.
     */
    constructor(system: ModelComponentSystem, entity: Entity);
    /**
     * @type {string}
     * @private
     */
    private _type;
    /**
     * @type {Asset|number|null}
     * @private
     */
    private _asset;
    /**
     * @type {Model|null}
     * @private
     */
    private _model;
    /**
     * @type {Object<string, number>}
     * @private
     */
    private _mapping;
    /**
     * @type {boolean}
     * @private
     */
    private _castShadows;
    /**
     * @type {boolean}
     * @private
     */
    private _receiveShadows;
    /**
     * @type {Asset|number|null}
     * @private
     */
    private _materialAsset;
    /**
     * @type {import('../../../scene/materials/material.js').Material}
     * @private
     */
    private _material;
    /**
     * @type {boolean}
     * @private
     */
    private _castShadowsLightmap;
    /**
     * @type {boolean}
     * @private
     */
    private _lightmapped;
    /**
     * @type {number}
     * @private
     */
    private _lightmapSizeMultiplier;
    /**
     * Mark meshes as non-movable (optimization).
     *
     * @type {boolean}
     */
    isStatic: boolean;
    /**
     * @type {number[]}
     * @private
     */
    private _layers;
    /**
     * @type {number}
     * @private
     */
    private _batchGroupId;
    /**
     * @type {import('../../../core/shape/bounding-box.js').BoundingBox|null}
     * @private
     */
    private _customAabb;
    _area: any;
    _materialEvents: any;
    /**
     * @type {boolean}
     * @private
     */
    private _clonedModel;
    _batchGroup: any;
    /**
     * An array of meshInstances contained in the component's model. If model is not set or loaded
     * for component it will return null.
     *
     * @type {MeshInstance[]|null}
     */
    set meshInstances(arg: MeshInstance[]);
    get meshInstances(): MeshInstance[];
    /**
     * If set, the object space bounding box is used as a bounding box for visibility culling of
     * attached mesh instances. This is an optimization, allowing oversized bounding box to be
     * specified for skinned characters in order to avoid per frame bounding box computations based
     * on bone positions.
     *
     * @type {import('../../../core/shape/bounding-box.js').BoundingBox|null}
     */
    set customAabb(arg: BoundingBox);
    get customAabb(): BoundingBox;
    /**
     * The type of the model. Can be:
     *
     * - "asset": The component will render a model asset
     * - "box": The component will render a box (1 unit in each dimension)
     * - "capsule": The component will render a capsule (radius 0.5, height 2)
     * - "cone": The component will render a cone (radius 0.5, height 1)
     * - "cylinder": The component will render a cylinder (radius 0.5, height 1)
     * - "plane": The component will render a plane (1 unit in each dimension)
     * - "sphere": The component will render a sphere (radius 0.5)
     * - "torus": The component will render a torus (tubeRadius: 0.2, ringRadius: 0.3)
     *
     * @type {string}
     */
    set type(arg: string);
    get type(): string;
    /**
     * The model that is added to the scene graph. It can be not set or loaded, so will return null.
     *
     * @type {Model}
     */
    set model(arg: Model);
    get model(): Model;
    /**
     * The asset for the model (only applies to models of type 'asset') can also be an asset id.
     *
     * @type {Asset|number|null}
     */
    set asset(arg: number | Asset);
    get asset(): number | Asset;
    /**
     * If true, this model will be lightmapped after using lightmapper.bake().
     *
     * @type {boolean}
     */
    set lightmapped(arg: boolean);
    get lightmapped(): boolean;
    /**
     * A dictionary that holds material overrides for each mesh instance. Only applies to model
     * components of type 'asset'. The mapping contains pairs of mesh instance index - material
     * asset id.
     *
     * @type {Object<string, number>}
     */
    set mapping(arg: {
        [x: string]: number;
    });
    get mapping(): {
        [x: string]: number;
    };
    /**
     * If true, this model will cast shadows for lights that have shadow casting enabled.
     *
     * @type {boolean}
     */
    set castShadows(arg: boolean);
    get castShadows(): boolean;
    /**
     * If true, shadows will be cast on this model.
     *
     * @type {boolean}
     */
    set receiveShadows(arg: boolean);
    get receiveShadows(): boolean;
    /**
     * If true, this model will cast shadows when rendering lightmaps.
   