/**
* plotly.js v3.0.0
* Copyright 2012-2025, Plotly, Inc.
* All rights reserved.
* Licensed under the MIT license
*/
(
 function(root, factory) {
  if (typeof module === "object" && module.exports) {
   module.exports = factory();
  } else {
   root.moduleName = factory();
  }
} (typeof self !== "undefined" ? self : this, () => {
"use strict";
var Plotly = (() => {
  var __defProp = Object.defineProperty;
  var __defProps = Object.defineProperties;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getOwnPropSymbols = Object.getOwnPropertySymbols;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __propIsEnum = Object.prototype.propertyIsEnumerable;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __spreadValues = (a, b) => {
    for (var prop in b || (b = {}))
      if (__hasOwnProp.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    if (__getOwnPropSymbols)
      for (var prop of __getOwnPropSymbols(b)) {
        if (__propIsEnum.call(b, prop))
          __defNormalProp(a, prop, b[prop]);
      }
    return a;
  };
  var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
  };
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    for (var name2 in all)
      __defProp(target, name2, { get: all[name2], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

  // src/version.js
  var require_version = __commonJS({
    "src/version.js"(exports) {
      "use strict";
      exports.version = "3.0.0";
    }
  });

  // node_modules/native-promise-only/lib/npo.src.js
  var require_npo_src = __commonJS({
    "node_modules/native-promise-only/lib/npo.src.js"(exports, module) {
      (function UMD(name2, context, definition) {
        context[name2] = context[name2] || definition();
        if (typeof module != "undefined" && module.exports) {
          module.exports = context[name2];
        } else if (typeof define == "function" && define.amd) {
          define(function $AMD$() {
            return context[name2];
          });
        }
      })("Promise", typeof window != "undefined" ? window : exports, function DEF() {
        "use strict";
        var builtInProp, cycle, scheduling_queue, ToString = Object.prototype.toString, timer = typeof setImmediate != "undefined" ? function timer2(fn) {
          return setImmediate(fn);
        } : setTimeout;
        try {
          Object.defineProperty({}, "x", {});
          builtInProp = function builtInProp2(obj, name2, val, config) {
            return Object.defineProperty(obj, name2, {
              value: val,
              writable: true,
              configurable: config !== false
            });
          };
        } catch (err) {
          builtInProp = function builtInProp2(obj, name2, val) {
            obj[name2] = val;
            return obj;
          };
        }
        scheduling_queue = /* @__PURE__ */ function Queue() {
          var first, last, item;
          function Item(fn, self2) {
            this.fn = fn;
            this.self = self2;
            this.next = void 0;
          }
          return {
            add: function add(fn, self2) {
              item = new Item(fn, self2);
              if (last) {
                last.next = item;
              } else {
                first = item;
              }
              last = item;
              item = void 0;
            },
            drain: function drain() {
              var f = first;
              first = last = cycle = void 0;
              while (f) {
                f.fn.call(f.self);
                f = f.next;
              }
            }
          };
        }();
        function schedule(fn, self2) {
          scheduling_queue.add(fn, self2);
          if (!cycle) {
            cycle = timer(scheduling_queue.drain);
          }
        }
        function isThenable(o) {
          var _then, o_type = typeof o;
          if (o != null && (o_type == "object" || o_type == "function")) {
            _then = o.then;
          }
          return typeof _then == "function" ? _then : false;
        }
        function notify() {
          for (var i = 0; i < this.chain.length; i++) {
            notifyIsolated(
              this,
              this.state === 1 ? this.chain[i].success : this.chain[i].failure,
              this.chain[i]
            );
          }
          this.chain.length = 0;
        }
        function notifyIsolated(self2, cb, chain) {
          var ret, _then;
          try {
            if (cb === false) {
              chain.reject(self2.msg);
            } else {
              if (cb === true) {
                ret = self2.msg;
              } else {
                ret = cb.call(void 0, self2.msg);
              }
              if (ret === chain.promise) {
                chain.reject(TypeError("Promise-chain cycle"));
              } else if (_then = isThenable(ret)) {
                _then.call(ret, chain.resolve, chain.reject);
              } else {
                chain.resolve(ret);
              }
            }
          } catch (err) {
            chain.reject(err);
          }
        }
        function resolve(msg) {
          var _then, self2 = this;
          if (self2.triggered) {
            return;
          }
          self2.triggered = true;
          if (self2.def) {
            self2 = self2.def;
          }
          try {
            if (_then = isThenable(msg)) {
              schedule(function() {
                var def_wrapper = new MakeDefWrapper(self2);
                try {
                  _then.call(
                    msg,
                    function $resolve$() {
                      resolve.apply(def_wrapper, arguments);
                    },
                    function $reject$() {
                      reject.apply(def_wrapper, arguments);
                    }
                  );
                } catch (err) {
                  reject.call(def_wrapper, err);
                }
              });
            } else {
              self2.msg = msg;
              self2.state = 1;
              if (self2.chain.length > 0) {
                schedule(notify, self2);
              }
            }
          } catch (err) {
            reject.call(new MakeDefWrapper(self2), err);
          }
        }
        function reject(msg) {
          var self2 = this;
          if (self2.triggered) {
            return;
          }
          self2.triggered = true;
          if (self2.def) {
            self2 = self2.def;
          }
          self2.msg = msg;
          self2.state = 2;
          if (self2.chain.length > 0) {
            schedule(notify, self2);
          }
        }
        function iteratePromises(Constructor, arr, resolver, rejecter) {
          for (var idx = 0; idx < arr.length; idx++) {
            (function IIFE(idx2) {
              Constructor.resolve(arr[idx2]).then(
                function $resolver$(msg) {
                  resolver(idx2, msg);
                },
                rejecter
              );
            })(idx);
          }
        }
        function MakeDefWrapper(self2) {
          this.def = self2;
          this.triggered = false;
        }
        function MakeDef(self2) {
          this.promise = self2;
          this.state = 0;
          this.triggered = false;
          this.chain = [];
          this.msg = void 0;
        }
        function Promise2(executor) {
          if (typeof executor != "function") {
            throw TypeError("Not a function");
          }
          if (this.__NPO__ !== 0) {
            throw TypeError("Not a promise");
          }
          this.__NPO__ = 1;
          var def = new MakeDef(this);
          this["then"] = function then(success, failure) {
            var o = {
              success: typeof success == "function" ? success : true,
              failure: typeof failure == "function" ? failure : false
            };
            o.promise = new this.constructor(function extractChain(resolve2, reject2) {
              if (typeof resolve2 != "function" || typeof reject2 != "function") {
                throw TypeError("Not a function");
              }
              o.resolve = resolve2;
              o.reject = reject2;
            });
            def.chain.push(o);
            if (def.state !== 0) {
              schedule(notify, def);
            }
            return o.promise;
          };
          this["catch"] = function $catch$(failure) {
            return this.then(void 0, failure);
          };
          try {
            executor.call(
              void 0,
              function publicResolve(msg) {
                resolve.call(def, msg);
              },
              function publicReject(msg) {
                reject.call(def, msg);
              }
            );
          } catch (err) {
            reject.call(def, err);
          }
        }
        var PromisePrototype = builtInProp(
          {},
          "constructor",
          Promise2,
          /*configurable=*/
          false
        );
        Promise2.prototype = PromisePrototype;
        builtInProp(
          PromisePrototype,
          "__NPO__",
          0,
          /*configurable=*/
          false
        );
        builtInProp(Promise2, "resolve", function Promise$resolve(msg) {
          var Constructor = this;
          if (msg && typeof msg == "object" && msg.__NPO__ === 1) {
            return msg;
          }
          return new Constructor(function executor(resolve2, reject2) {
            if (typeof resolve2 != "function" || typeof reject2 != "function") {
              throw TypeError("Not a function");
            }
            resolve2(msg);
          });
        });
        builtInProp(Promise2, "reject", function Promise$reject(msg) {
          return new this(function executor(resolve2, reject2) {
            if (typeof resolve2 != "function" || typeof reject2 != "function") {
              throw TypeError("Not a function");
            }
            reject2(msg);
          });
        });
        builtInProp(Promise2, "all", function Promise$all(arr) {
          var Constructor = this;
          if (ToString.call(arr) != "[object Array]") {
            return Constructor.reject(TypeError("Not an array"));
          }
          if (arr.length === 0) {
            return Constructor.resolve([]);
          }
          return new Constructor(function executor(resolve2, reject2) {
            if (typeof resolve2 != "function" || typeof reject2 != "function") {
              throw TypeError("Not a function");
            }
            var len = arr.length, msgs = Array(len), count = 0;
            iteratePromises(Constructor, arr, function resolver(idx, msg) {
              msgs[idx] = msg;
              if (++count === len) {
                resolve2(msgs);
              }
            }, reject2);
          });
        });
        builtInProp(Promise2, "race", function Promise$race(arr) {
          var Constructor = this;
          if (ToString.call(arr) != "[object Array]") {
            return Constructor.reject(TypeError("Not an array"));
          }
          return new Constructor(function executor(resolve2, reject2) {
            if (typeof resolve2 != "function" || typeof reject2 != "function") {
              throw TypeError("Not a function");
            }
            iteratePromises(Constructor, arr, function resolver(idx, msg) {
              resolve2(msg);
            }, reject2);
          });
        });
        return Promise2;
      });
    }
  });

  // node_modules/@plotly/d3/d3.js
  var require_d3 = __commonJS({
    "node_modules/@plotly/d3/d3.js"(exports, module) {
      !function() {
        var d3 = {
          version: "3.8.2"
        };
        var d3_arraySlice = [].slice, d3_array = function(list) {
          return d3_arraySlice.call(list);
        };
        var d3_document = self.document;
        function d3_documentElement(node) {
          return node && (node.ownerDocument || node.document || node).documentElement;
        }
        function d3_window(node) {
          return node && (node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView);
        }
        if (d3_document) {
          try {
            d3_array(d3_document.documentElement.childNodes)[0].nodeType;
          } catch (e) {
            d3_array = function(list) {
              var i = list.length, array = new Array(i);
              while (i--) array[i] = list[i];
              return array;
            };
          }
        }
        if (!Date.now) Date.now = function() {
          return +/* @__PURE__ */ new Date();
        };
        if (d3_document) {
          try {
            d3_document.createElement("DIV").style.setProperty("opacity", 0, "");
          } catch (error) {
            var d3_element_prototype = this.Element.prototype, d3_element_setAttribute = d3_element_prototype.setAttribute, d3_element_setAttributeNS = d3_element_prototype.setAttributeNS, d3_style_prototype = this.CSSStyleDeclaration.prototype, d3_style_setProperty = d3_style_prototype.setProperty;
            d3_element_prototype.setAttribute = function(name2, value) {
              d3_element_setAttribute.call(this, name2, value + "");
            };
            d3_element_prototype.setAttributeNS = function(space, local, value) {
              d3_element_setAttributeNS.call(this, space, local, value + "");
            };
            d3_style_prototype.setProperty = function(name2, value, priority) {
              d3_style_setProperty.call(this, name2, value + "", priority);
            };
          }
        }
        d3.ascending = d3_ascending;
        function d3_ascending(a, b) {
          return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
        }
        d3.descending = function(a, b) {
          return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
        };
        d3.min = function(array, f) {
          var i = -1, n = array.length, a, b;
          if (arguments.length === 1) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null && a > b) a = b;
          } else {
            while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = f.call(array, array[i], i)) != null && a > b) a = b;
          }
          return a;
        };
        d3.max = function(array, f) {
          var i = -1, n = array.length, a, b;
          if (arguments.length === 1) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null && b > a) a = b;
          } else {
            while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = f.call(array, array[i], i)) != null && b > a) a = b;
          }
          return a;
        };
        d3.extent = function(array, f) {
          var i = -1, n = array.length, a, b, c;
          if (arguments.length === 1) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = c = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null) {
              if (a > b) a = b;
              if (c < b) c = b;
            }
          } else {
            while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
              a = c = b;
              break;
            }
            while (++i < n) if ((b = f.call(array, array[i], i)) != null) {
              if (a > b) a = b;
              if (c < b) c = b;
            }
          }
          return [a, c];
        };
        function d3_number(x) {
          return x === null ? NaN : +x;
        }
        function d3_numeric(x) {
          return !isNaN(x);
        }
        d3.sum = function(array, f) {
          var s = 0, n = array.length, a, i = -1;
          if (arguments.length === 1) {
            while (++i < n) if (d3_numeric(a = +array[i])) s += a;
          } else {
            while (++i < n) if (d3_numeric(a = +f.call(array, array[i], i))) s += a;
          }
          return s;
        };
        d3.mean = function(array, f) {
          var s = 0, n = array.length, a, i = -1, j = n;
          if (arguments.length === 1) {
            while (++i < n) if (d3_numeric(a = d3_number(array[i]))) s += a;
            else --j;
          } else {
            while (++i < n) if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) s += a;
            else --j;
          }
          if (j) return s / j;
        };
        d3.quantile = function(values, p) {
          var H = (values.length - 1) * p + 1, h = Math.floor(H), v = +values[h - 1], e = H - h;
          return e ? v + e * (values[h] - v) : v;
        };
        d3.median = function(array, f) {
          var numbers = [], n = array.length, a, i = -1;
          if (arguments.length === 1) {
            while (++i < n) if (d3_numeric(a = d3_number(array[i]))) numbers.push(a);
          } else {
            while (++i < n) if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) numbers.push(a);
          }
          if (numbers.length) return d3.quantile(numbers.sort(d3_ascending), 0.5);
        };
        d3.variance = function(array, f) {
          var n = array.length, m = 0, a, d, s = 0, i = -1, j = 0;
          if (arguments.length === 1) {
            while (++i < n) {
              if (d3_numeric(a = d3_number(array[i]))) {
                d = a - m;
                m += d / ++j;
                s += d * (a - m);
              }
            }
          } else {
            while (++i < n) {
              if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) {
                d = a - m;
                m += d / ++j;
                s += d * (a - m);
              }
            }
          }
          if (j > 1) return s / (j - 1);
        };
        d3.deviation = function() {
          var v = d3.variance.apply(this, arguments);
          return v ? Math.sqrt(v) : v;
        };
        function d3_bisector(compare) {
          return {
            left: function(a, x, lo, hi) {
              if (arguments.length < 3) lo = 0;
              if (arguments.length < 4) hi = a.length;
              while (lo < hi) {
                var mid = lo + hi >>> 1;
                if (compare(a[mid], x) < 0) lo = mid + 1;
                else hi = mid;
              }
              return lo;
            },
            right: function(a, x, lo, hi) {
              if (arguments.length < 3) lo = 0;
              if (arguments.length < 4) hi = a.length;
              while (lo < hi) {
                var mid = lo + hi >>> 1;
                if (compare(a[mid], x) > 0) hi = mid;
                else lo = mid + 1;
              }
              return lo;
            }
          };
        }
        var d3_bisect = d3_bisector(d3_ascending);
        d3.bisectLeft = d3_bisect.left;
        d3.bisect = d3.bisectRight = d3_bisect.right;
        d3.bisector = function(f) {
          return d3_bisector(f.length === 1 ? function(d, x) {
            return d3_ascending(f(d), x);
          } : f);
        };
        d3.shuffle = function(array, i0, i1) {
          if ((m = arguments.length) < 3) {
            i1 = array.length;
            if (m < 2) i0 = 0;
          }
          var m = i1 - i0, t, i;
          while (m) {
            i = Math.random() * m-- | 0;
            t = array[m + i0], array[m + i0] = array[i + i0], array[i + i0] = t;
          }
          return array;
        };
        d3.permute = function(array, indexes) {
          var i = indexes.length, permutes = new Array(i);
          while (i--) permutes[i] = array[indexes[i]];
          return permutes;
        };
        d3.pairs = function(array) {
          var i = 0, n = array.length - 1, p0, p1 = array[0], pairs = new Array(n < 0 ? 0 : n);
          while (i < n) pairs[i] = [p0 = p1, p1 = array[++i]];
          return pairs;
        };
        d3.transpose = function(matrix) {
          if (!(n = matrix.length)) return [];
          for (var i = -1, m = d3.min(matrix, d3_transposeLength), transpose = new Array(m); ++i < m; ) {
            for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n; ) {
              row[j] = matrix[j][i];
            }
          }
          return transpose;
        };
        function d3_transposeLength(d) {
          return d.length;
        }
        d3.zip = function() {
          return d3.transpose(arguments);
        };
        d3.keys = function(map) {
          var keys = [];
          for (var key in map) keys.push(key);
          return keys;
        };
        d3.values = function(map) {
          var values = [];
          for (var key in map) values.push(map[key]);
          return values;
        };
        d3.entries = function(map) {
          var entries = [];
          for (var key in map) entries.push({
            key,
            value: map[key]
          });
          return entries;
        };
        d3.merge = function(arrays) {
          var n = arrays.length, m, i = -1, j = 0, merged, array;
          while (++i < n) j += arrays[i].length;
          merged = new Array(j);
          while (--n >= 0) {
            array = arrays[n];
            m = array.length;
            while (--m >= 0) {
              merged[--j] = array[m];
            }
          }
          return merged;
        };
        var abs = Math.abs;
        d3.range = function(start, stop, step) {
          if (arguments.length < 3) {
            step = 1;
            if (arguments.length < 2) {
              stop = start;
              start = 0;
            }
          }
          if ((stop - start) / step === Infinity) throw new Error("infinite range");
          var range = [], k = d3_range_integerScale(abs(step)), i = -1, j;
          start *= k, stop *= k, step *= k;
          if (step < 0) while ((j = start + step * ++i) > stop) range.push(j / k);
          else while ((j = start + step * ++i) < stop) range.push(j / k);
          return range;
        };
        function d3_range_integerScale(x) {
          var k = 1;
          while (x * k % 1) k *= 10;
          return k;
        }
        function d3_class(ctor, properties) {
          for (var key in properties) {
            Object.defineProperty(ctor.prototype, key, {
              value: properties[key],
              enumerable: false
            });
          }
        }
        d3.map = function(object, f) {
          var map = new d3_Map();
          if (object instanceof d3_Map) {
            object.forEach(function(key2, value) {
              map.set(key2, value);
            });
          } else if (Array.isArray(object)) {
            var i = -1, n = object.length, o;
            if (arguments.length === 1) while (++i < n) map.set(i, object[i]);
            else while (++i < n) map.set(f.call(object, o = object[i], i), o);
          } else {
            for (var key in object) map.set(key, object[key]);
          }
          return map;
        };
        function d3_Map() {
          this._ = /* @__PURE__ */ Object.create(null);
        }
        var d3_map_proto = "__proto__", d3_map_zero = "\0";
        d3_class(d3_Map, {
          has: d3_map_has,
          get: function(key) {
            return this._[d3_map_escape(key)];
          },
          set: function(key, value) {
            return this._[d3_map_escape(key)] = value;
          },
          remove: d3_map_remove,
          keys: d3_map_keys,
          values: function() {
            var values = [];
            for (var key in this._) values.push(this._[key]);
            return values;
          },
          entries: function() {
            var entries = [];
            for (var key in this._) entries.push({
              key: d3_map_unescape(key),
              value: this._[key]
            });
            return entries;
          },
          size: d3_map_size,
          empty: d3_map_empty,
          forEach: function(f) {
            for (var key in this._) f.call(this, d3_map_unescape(key), this._[key]);
          }
        });
        function d3_map_escape(key) {
          return (key += "") === d3_map_proto || key[0] === d3_map_zero ? d3_map_zero + key : key;
        }
        function d3_map_unescape(key) {
          return (key += "")[0] === d3_map_zero ? key.slice(1) : key;
        }
        function d3_map_has(key) {
          return d3_map_escape(key) in this._;
        }
        function d3_map_remove(key) {
          return (key = d3_map_escape(key)) in this._ && delete this._[key];
        }
        function d3_map_keys() {
          var keys = [];
          for (var key in this._) keys.push(d3_map_unescape(key));
          return keys;
        }
        function d3_map_size() {
          var size = 0;
          for (var key in this._) ++size;
          return size;
        }
        function d3_map_empty() {
          for (var key in this._) return false;
          return true;
        }
        d3.nest = function() {
          var nest = {}, keys = [], sortKeys = [], sortValues, rollup;
          function map(mapType, array, depth) {
            if (depth >= keys.length) return rollup ? rollup.call(nest, array) : sortValues ? array.sort(sortValues) : array;
            var i = -1, n = array.length, key = keys[depth++], keyValue, object, setter, valuesByKey = new d3_Map(), values;
            while (++i < n) {
              if (values = valuesByKey.get(keyValue = key(object = array[i]))) {
                values.push(object);
              } else {
                valuesByKey.set(keyValue, [object]);
              }
            }
            if (mapType) {
              object = mapType();
              setter = function(keyValue2, values2) {
                object.set(keyValue2, map(mapType, values2, depth));
              };
            } else {
              object = {};
              setter = function(keyValue2, values2) {
                object[keyValue2] = map(mapType, values2, depth);
              };
            }
            valuesByKey.forEach(setter);
            return object;
          }
          function entries(map2, depth) {
            if (depth >= keys.length) return map2;
            var array = [], sortKey = sortKeys[depth++];
            map2.forEach(function(key, keyMap) {
              array.push({
                key,
                values: entries(keyMap, depth)
              });
            });
            return sortKey ? array.sort(function(a, b) {
              return sortKey(a.key, b.key);
            }) : array;
          }
          nest.map = function(array, mapType) {
            return map(mapType, array, 0);
          };
          nest.entries = function(array) {
            return entries(map(d3.map, array, 0), 0);
          };
          nest.key = function(d) {
            keys.push(d);
            return nest;
          };
          nest.sortKeys = function(order) {
            sortKeys[keys.length - 1] = order;
            return nest;
          };
          nest.sortValues = function(order) {
            sortValues = order;
            return nest;
          };
          nest.rollup = function(f) {
            rollup = f;
            return nest;
          };
          return nest;
        };
        d3.set = function(array) {
          var set = new d3_Set();
          if (array) for (var i = 0, n = array.length; i < n; ++i) set.add(array[i]);
          return set;
        };
        function d3_Set() {
          this._ = /* @__PURE__ */ Object.create(null);
        }
        d3_class(d3_Set, {
          has: d3_map_has,
          add: function(key) {
            this._[d3_map_escape(key += "")] = true;
            return key;
          },
          remove: d3_map_remove,
          values: d3_map_keys,
          size: d3_map_size,
          empty: d3_map_empty,
          forEach: function(f) {
            for (var key in this._) f.call(this, d3_map_unescape(key));
          }
        });
        d3.behavior = {};
        function d3_identity(d) {
          return d;
        }
        d3.rebind = function(target, source) {
          var i = 1, n = arguments.length, method;
          while (++i < n) target[method = arguments[i]] = d3_rebind(target, source, source[method]);
          return target;
        };
        function d3_rebind(target, source, method) {
          return function() {
            var value = method.apply(source, arguments);
            return value === source ? target : value;
          };
        }
        function d3_vendorSymbol(object, name2) {
          if (name2 in object) return name2;
          name2 = name2.charAt(0).toUpperCase() + name2.slice(1);
          for (var i = 0, n = d3_vendorPrefixes.length; i < n; ++i) {
            var prefixName = d3_vendorPrefixes[i] + name2;
            if (prefixName in object) return prefixName;
          }
        }
        var d3_vendorPrefixes = ["webkit", "ms", "moz", "Moz", "o", "O"];
        function d3_noop() {
        }
        d3.dispatch = function() {
          var dispatch = new d3_dispatch(), i = -1, n = arguments.length;
          while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);
          return dispatch;
        };
        function d3_dispatch() {
        }
        d3_dispatch.prototype.on = function(type, listener) {
          var i = type.indexOf("."), name2 = "";
          if (i >= 0) {
            name2 = type.slice(i + 1);
            type = type.slice(0, i);
          }
          if (type) return arguments.length < 2 ? this[type].on(name2) : this[type].on(name2, listener);
          if (arguments.length === 2) {
            if (listener == null) for (type in this) {
              if (this.hasOwnProperty(type)) this[type].on(name2, null);
            }
            return this;
          }
        };
        function d3_dispatch_event(dispatch) {
          var listeners = [], listenerByName = new d3_Map();
          function event() {
            var z = listeners, i = -1, n = z.length, l;
            while (++i < n) if (l = z[i].on) l.apply(this, arguments);
            return dispatch;
          }
          event.on = function(name2, listener) {
            var l = listenerByName.get(name2), i;
            if (arguments.length < 2) return l && l.on;
            if (l) {
              l.on = null;
              listeners = listeners.slice(0, i = listeners.indexOf(l)).concat(listeners.slice(i + 1));
              listenerByName.remove(name2);
            }
            if (listener) listeners.push(listenerByName.set(name2, {
              on: listener
            }));
            return dispatch;
          };
          return event;
        }
        d3.event = null;
        function d3_eventPreventDefault() {
          d3.event.preventDefault();
        }
        function d3_eventSource() {
          var e = d3.event, s;
          while (s = e.sourceEvent) e = s;
          return e;
        }
        function d3_eventDispatch(target) {
          var dispatch = new d3_dispatch(), i = 0, n = arguments.length;
          while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);
          dispatch.of = function(thiz, argumentz) {
            return function(e1) {
              try {
                var e0 = e1.sourceEvent = d3.event;
                e1.target = target;
                d3.event = e1;
                dispatch[e1.type].apply(thiz, argumentz);
              } finally {
                d3.event = e0;
              }
            };
          };
          return dispatch;
        }
        d3.requote = function(s) {
          return s.replace(d3_requote_re, "\\$&");
        };
        var d3_requote_re = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
        var d3_subclass = {}.__proto__ ? function(object, prototype) {
          object.__proto__ = prototype;
        } : function(object, prototype) {
          for (var property in prototype) object[property] = prototype[property];
        };
        function d3_selection(groups) {
          d3_subclass(groups, d3_selectionPrototype);
          return groups;
        }
        var d3_select = function(s, n) {
          return n.querySelector(s);
        }, d3_selectAll = function(s, n) {
          return n.querySelectorAll(s);
        }, d3_selectMatches = function(n, s) {
          var d3_selectMatcher = n.matches || n[d3_vendorSymbol(n, "matchesSelector")];
          d3_selectMatches = function(n2, s2) {
            return d3_selectMatcher.call(n2, s2);
          };
          return d3_selectMatches(n, s);
        };
        if (typeof Sizzle === "function") {
          d3_select = function(s, n) {
            return Sizzle(s, n)[0] || null;
          };
          d3_selectAll = Sizzle;
          d3_selectMatches = Sizzle.matchesSelector;
        }
        d3.selection = function() {
          return d3.select(d3_document.documentElement);
        };
        var d3_selectionPrototype = d3.selection.prototype = [];
        d3_selectionPrototype.select = function(selector) {
          var subgroups = [], subgroup, subnode, group, node;
          selector = d3_selection_selector(selector);
          for (var j = -1, m = this.length; ++j < m; ) {
            subgroups.push(subgroup = []);
            subgroup.parentNode = (group = this[j]).parentNode;
            for (var i = -1, n = group.length; ++i < n; ) {
              if (node = group[i]) {
                subgroup.push(subnode = selector.call(node, node.__data__, i, j));
                if (subnode && "__data__" in node) subnode.__data__ = node.__data__;
              } else {
                subgroup.push(null);
              }
            }
          }
          return d3_selection(subgroups);
        };
        function d3_selection_selector(selector) {
          return typeof selector === "function" ? selector : function() {
            return d3_select(selector, this);
          };
        }
        d3_selectionPrototype.selectAll = function(selector) {
          var subgroups = [], subgroup, node;
          selector = d3_selection_selectorAll(selector);
          for (var j = -1, m = this.length; ++j < m; ) {
            for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
              if (node = group[i]) {
                subgroups.push(subgroup = d3_array(selector.call(node, node.__data__, i, j)));
                subgroup.parentNode = node;
              }
            }
          }
          return d3_selection(subgroups);
        };
        function d3_selection_selectorAll(selector) {
          return typeof selector === "function" ? selector : function() {
            return d3_selectAll(selector, this);
          };
        }
        var d3_nsXhtml = "http://www.w3.org/1999/xhtml";
        var d3_nsPrefix = {
          svg: "http://www.w3.org/2000/svg",
          xhtml: d3_nsXhtml,
          xlink: "http://www.w3.org/1999/xlink",
          xml: "http://www.w3.org/XML/1998/namespace",
          xmlns: "http://www.w3.org/2000/xmlns/"
        };
        d3.ns = {
          prefix: d3_nsPrefix,
          qualify: function(name2) {
            var i = name2.indexOf(":"), prefix = name2;
            if (i >= 0 && (prefix = name2.slice(0, i)) !== "xmlns") name2 = name2.slice(i + 1);
            return d3_nsPrefix.hasOwnProperty(prefix) ? {
              space: d3_nsPrefix[prefix],
              local: name2
            } : name2;
          }
        };
        d3_selectionPrototype.attr = function(name2, value) {
          if (arguments.length < 2) {
            if (typeof name2 === "string") {
              var node = this.node();
              name2 = d3.ns.qualify(name2);
              return name2.local ? node.getAttributeNS(name2.space, name2.local) : node.getAttribute(name2);
            }
            for (value in name2) this.each(d3_selection_attr(value, name2[value]));
            return this;
          }
          return this.each(d3_selection_attr(name2, value));
        };
        function d3_selection_attr(name2, value) {
          name2 = d3.ns.qualify(name2);
          function attrNull() {
            this.removeAttribute(name2);
          }
          function attrNullNS() {
            this.removeAttributeNS(name2.space, name2.local);
          }
          function attrConstant() {
            this.setAttribute(name2, value);
          }
          function attrConstantNS() {
            this.setAttributeNS(name2.space, name2.local, value);
          }
          function attrFunction() {
            var x = value.apply(this, arguments);
            if (x == null) this.removeAttribute(name2);
            else this.setAttribute(name2, x);
          }
          function attrFunctionNS() {
            var x = value.apply(this, arguments);
            if (x == null) this.removeAttributeNS(name2.space, name2.local);
            else this.setAttributeNS(name2.space, name2.local, x);
          }
          return value == null ? name2.local ? attrNullNS : attrNull : typeof value === "function" ? name2.local ? attrFunctionNS : attrFunction : name2.local ? attrConstantNS : attrConstant;
        }
        function d3_collapse(s) {
          return s.trim().replace(/\s+/g, " ");
        }
        d3_selectionPrototype.classed = function(name2, value) {
          if (arguments.length < 2) {
            if (typeof name2 === "string") {
              var node = this.node(), n = (name2 = d3_selection_classes(name2)).length, i = -1;
              if (value = node.classList) {
                while (++i < n) if (!value.contains(name2[i])) return false;
              } else {
                value = node.getAttribute("class");
                while (++i < n) if (!d3_selection_classedRe(name2[i]).test(value)) return false;
              }
              return true;
            }
            for (value in name2) this.each(d3_selection_classed(value, name2[value]));
            return this;
          }
          return this.each(d3_selection_classed(name2, value));
        };
        function d3_selection_classedRe(name2) {
          return new RegExp("(?:^|\\s+)" + d3.requote(name2) + "(?:\\s+|$)", "g");
        }
        function d3_selection_classes(name2) {
          return (name2 + "").trim().split(/^|\s+/);
        }
        function d3_selection_classed(name2, value) {
          name2 = d3_selection_classes(name2).map(d3_selection_classedName);
          var n = name2.length;
          function classedConstant() {
            var i = -1;
            while (++i < n) name2[i](this, value);
          }
          function classedFunction() {
            var i = -1, x = value.apply(this, arguments);
            while (++i < n) name2[i](this, x);
          }
          return typeof value === "function" ? classedFunction : classedConstant;
        }
        function d3_selection_classedName(name2) {
          var re = d3_selection_classedRe(name2);
          return function(node, value) {
            if (c = node.classList) return value ? c.add(name2) : c.remove(name2);
            var c = node.getAttribute("class") || "";
            if (value) {
              re.lastIndex = 0;
              if (!re.test(c)) node.setAttribute("class", d3_collapse(c + " " + name2));
            } else {
              node.setAttribute("class", d3_collapse(c.replace(re, " ")));
            }
          };
        }
        d3_selectionPrototype.style = function(name2, value, priority) {
          var n = arguments.length;
          if (n < 3) {
            if (typeof name2 !== "string") {
              if (n < 2) value = "";
              for (priority in name2) this.each(d3_selection_style(priority, name2[priority], value));
              return this;
            }
            if (n < 2) {
              var node = this.node();
              return d3_window(node).getComputedStyle(node, null).getPropertyValue(name2);
            }
            priority = "";
          }
          return this.each(d3_selection_style(name2, value, priority));
        };
        function d3_selection_style(name2, value, priority) {
          function styleNull() {
            this.style.removeProperty(name2);
          }
          function styleConstant() {
            this.style.setProperty(name2, value, priority);
          }
          function styleFunction() {
            var x = value.apply(this, arguments);
            if (x == null) this.style.removeProperty(name2);
            else this.style.setProperty(name2, x, priority);
          }
          return value == null ? styleNull : typeof value === "function" ? styleFunction : styleConstant;
        }
        d3_selectionPrototype.property = function(name2, value) {
          if (arguments.length < 2) {
            if (typeof name2 === "string") return this.node()[name2];
            for (value in name2) this.each(d3_selection_property(value, name2[value]));
            return this;
          }
          return this.each(d3_selection_property(name2, value));
        };
        function d3_selection_property(name2, value) {
          function propertyNull() {
            delete this[name2];
          }
          function propertyConstant() {
            this[name2] = value;
          }
          function propertyFunction() {
            var x = value.apply(this, arguments);
            if (x == null) delete this[name2];
            else this[name2] = x;
          }
          return value == null ? propertyNull : typeof value === "function" ? propertyFunction : propertyConstant;
        }
        d3_selectionPrototype.text = function(value) {
          return arguments.length ? this.each(typeof value === "function" ? function() {
            var v = value.apply(this, arguments);
            this.textContent = v == null ? "" : v;
          } : value == null ? function() {
            this.textContent = "";
          } : function() {
            this.textContent = value;
          }) : this.node().textContent;
        };
        d3_selectionPrototype.html = function(value) {
          return arguments.length ? this.each(typeof value === "function" ? function() {
            var v = value.apply(this, arguments);
            this.innerHTML = v == null ? "" : v;
          } : value == null ? function() {
            this.innerHTML = "";
          } : function() {
            this.innerHTML = value;
          }) : this.node().innerHTML;
        };
        d3_selectionPrototype.append = function(name2) {
          name2 = d3_selection_creator(name2);
          return this.select(function() {
            return this.appendChild(name2.apply(this, arguments));
          });
        };
        function d3_selection_creator(name2) {
          function create() {
            var document2 = this.ownerDocument, namespace = this.namespaceURI;
            return namespace === d3_nsXhtml && document2.documentElement.namespaceURI === d3_nsXhtml ? document2.createElement(name2) : document2.createElementNS(namespace, name2);
          }
          function createNS() {
            return this.ownerDocument.createElementNS(name2.space, name2.local);
          }
          return typeof name2 === "function" ? name2 : (name2 = d3.ns.qualify(name2)).local ? createNS : create;
        }
        d3_selectionPrototype.insert = function(name2, before) {
          name2 = d3_selection_creator(name2);
          before = d3_selection_selector(before);
          return this.select(function() {
            return this.insertBefore(name2.apply(this, arguments), before.apply(this, arguments) || null);
          });
        };
        d3_selectionPrototype.remove = function() {
          return this.each(d3_selectionRemove);
        };
        function d3_selectionRemove() {
          var parent = this.parentNode;
          if (parent) parent.removeChild(this);
        }
        d3_selectionPrototype.data = function(value, key) {
          var i = -1, n = this.length, group, node;
          if (!arguments.length) {
            value = new Array(n = (group = this[0]).length);
            while (++i < n) {
              if (node = group[i]) {
                value[i] = node.__data__;
              }
            }
            return value;
          }
          function bind(group2, groupData) {
            var i2, n2 = group2.length, m = groupData.length, n0 = Math.min(n2, m), updateNodes = new Array(m), enterNodes = new Array(m), exitNodes = new Array(n2), node2, nodeData;
            if (key) {
              var nodeByKeyValue = new d3_Map(), keyValues = new Array(n2), keyValue;
              for (i2 = -1; ++i2 < n2; ) {
                if (node2 = group2[i2]) {
                  if (nodeByKeyValue.has(keyValue = key.call(node2, node2.__data__, i2))) {
                    exitNodes[i2] = node2;
                  } else {
                    nodeByKeyValue.set(keyValue, node2);
                  }
                  keyValues[i2] = keyValue;
                }
              }
              for (i2 = -1; ++i2 < m; ) {
                if (!(node2 = nodeByKeyValue.get(keyValue = key.call(groupData, nodeData = groupData[i2], i2)))) {
                  enterNodes[i2] = d3_selection_dataNode(nodeData);
                } else if (node2 !== true) {
                  updateNodes[i2] = node2;
                  node2.__data__ = nodeData;
                }
                nodeByKeyValue.set(keyValue, true);
              }
              for (i2 = -1; ++i2 < n2; ) {
                if (i2 in keyValues && nodeByKeyValue.get(keyValues[i2]) !== true) {
                  exitNodes[i2] = group2[i2];
                }
              }
            } else {
              for (i2 = -1; ++i2 < n0; ) {
                node2 = group2[i2];
                nodeData = groupData[i2];
                if (node2) {
                  node2.__data__ = nodeData;
                  updateNodes[i2] = node2;
                } else {
                  enterNodes[i2] = d3_selection_dataNode(nodeData);
                }
              }
              for (; i2 < m; ++i2) {
                enterNodes[i2] = d3_selection_dataNode(groupData[i2]);
              }
              for (; i2 < n2; ++i2) {
                exitNodes[i2] = group2[i2];
              }
            }
            enterNodes.update = updateNodes;
            enterNodes.parentNode = updateNodes.parentNode = exitNodes.parentNode = group2.parentNode;
            enter.push(enterNodes);
            update.push(updateNodes);
            exit.push(exitNodes);
          }
          var enter = d3_selection_enter([]), update = d3_selection([]), exit = d3_selection([]);
          if (typeof value === "function") {
            while (++i < n) {
              bind(group = this[i], value.call(group, group.parentNode.__data__, i));
            }
          } else {
            while (++i < n) {
              bind(group = this[i], value);
            }
          }
          update.enter = function() {
            return enter;
          };
          update.exit = function() {
            return exit;
          };
          return update;
        };
        function d3_selection_dataNode(data) {
          return {
            __data__: data
          };
        }
        d3_selectionPrototype.datum = function(value) {
          return arguments.length ? this.property("__data__", value) : this.property("__data__");
        };
        d3_selectionPrototype.filter = function(filter) {
          var subgroups = [], subgroup, group, node;
          if (typeof filter !== "function") filter = d3_selection_filter(filter);
          for (var j = 0, m = this.length; j < m; j++) {
            subgroups.push(subgroup = []);
            subgroup.parentNode = (group = this[j]).parentNode;
            for (var i = 0, n = group.length; i < n; i++) {
              if ((node = group[i]) && filter.call(node, node.__data__, i, j)) {
                subgroup.push(node);
              }
            }
          }
          return d3_selection(subgroups);
        };
        function d3_selection_filter(selector) {
          return function() {
            return d3_selectMatches(this, selector);
          };
        }
        d3_selectionPrototype.order = function() {
          for (var j = -1, m = this.length; ++j < m; ) {
            for (var group = this[j], i = group.length - 1, next = group[i], node; --i >= 0; ) {
              if (node = group[i]) {
                if (next && next !== node.nextSibling) next.parentNode.insertBefore(node, next);
                next = node;
              }
            }
          }
          return this;
        };
        d3_selectionPrototype.sort = function(comparator) {
          comparator = d3_selection_sortComparator.apply(this, arguments);
          for (var j = -1, m = this.length; ++j < m; ) this[j].sort(comparator);
          return this.order();
        };
        function d3_selection_sortComparator(comparator) {
          if (!arguments.length) comparator = d3_ascending;
          return function(a, b) {
            return a && b ? comparator(a.__data__, b.__data__) : !a - !b;
          };
        }
        d3_selectionPrototype.each = function(callback) {
          return d3_selection_each(this, function(node, i, j) {
            callback.call(node, node.__data__, i, j);
          });
        };
        function d3_selection_each(groups, callback) {
          for (var j = 0, m = groups.length; j < m; j++) {
            for (var group = groups[j], i = 0, n = group.length, node; i < n; i++) {
              if (node = group[i]) callback(node, i, j);
            }
          }
          return groups;
        }
        d3_selectionPrototype.call = function(callback) {
          var args = d3_array(arguments);
          callback.apply(args[0] = this, args);
          return this;
        };
        d3_selectionPrototype.empty = function() {
          return !this.node();
        };
        d3_selectionPrototype.node = function() {
          for (var j = 0, m = this.length; j < m; j++) {
            for (var group = this[j], i = 0, n = group.length; i < n; i++) {
              var node = group[i];
              if (node) return node;
            }
          }
          return null;
        };
        d3_selectionPrototype.size = function() {
          var n = 0;
          d3_selection_each(this, function() {
            ++n;
          });
          return n;
        };
        function d3_selection_enter(selection) {
          d3_subclass(selection, d3_selection_enterPrototype);
          return selection;
        }
        var d3_selection_enterPrototype = [];
        d3.selection.enter = d3_selection_enter;
        d3.selection.enter.prototype = d3_selection_enterPrototype;
        d3_selection_enterPrototype.append = d3_selectionPrototype.append;
        d3_selection_enterPrototype.empty = d3_selectionPrototype.empty;
        d3_selection_enterPrototype.node = d3_selectionPrototype.node;
        d3_selection_enterPrototype.call = d3_selectionPrototype.call;
        d3_selection_enterPrototype.size = d3_selectionPrototype.size;
        d3_selection_enterPrototype.select = function(selector) {
          var subgroups = [], subgroup, subnode, upgroup, group, node;
          for (var j = -1, m = this.length; ++j < m; ) {
            upgroup = (group = this[j]).update;
            subgroups.push(subgroup = []);
            subgroup.parentNode = group.parentNode;
            for (var i = -1, n = group.length; ++i < n; ) {
              if (node = group[i]) {
                subgroup.push(upgroup[i] = subnode = selector.call(group.parentNode, node.__data__, i, j));
                subnode.__data__ = node.__data__;
              } else {
                subgroup.push(null);
              }
            }
          }
          return d3_selection(subgroups);
        };
        d3_selection_enterPrototype.insert = function(name2, before) {
          if (arguments.length < 2) before = d3_selection_enterInsertBefore(this);
          return d3_selectionPrototype.insert.call(this, name2, before);
        };
        function d3_selection_enterInsertBefore(enter) {
          var i0, j0;
          return function(d, i, j) {
            var group = enter[j].update, n = group.length, node;
            if (j != j0) j0 = j, i0 = 0;
            if (i >= i0) i0 = i + 1;
            while (!(node = group[i0]) && ++i0 < n) ;
            return node;
          };
        }
        d3.select = function(node) {
          var group;
          if (typeof node === "string") {
            group = [d3_select(node, d3_document)];
            group.parentNode = d3_document.documentElement;
          } else {
            group = [node];
            group.parentNode = d3_documentElement(node);
          }
          return d3_selection([group]);
        };
        d3.selectAll = function(nodes) {
          var group;
          if (typeof nodes === "string") {
            group = d3_array(d3_selectAll(nodes, d3_document));
            group.parentNode = d3_document.documentElement;
          } else {
            group = d3_array(nodes);
            group.parentNode = null;
          }
          return d3_selection([group]);
        };
        d3_selectionPrototype.on = function(type, listener, capture) {
          var n = arguments.length;
          if (n < 3) {
            if (typeof type !== "string") {
              if (n < 2) listener = false;
              for (capture in type) this.each(d3_selection_on(capture, type[capture], listener));
              return this;
            }
            if (n < 2) return (n = this.node()["__on" + type]) && n._;
            capture = false;
          }
          return this.each(d3_selection_on(type, listener, capture));
        };
        function d3_selection_on(type, listener, capture) {
          var name2 = "__on" + type, i = type.indexOf("."), wrap = d3_selection_onListener;
          if (i > 0) type = type.slice(0, i);
          var filter = d3_selection_onFilters.get(type);
          if (filter) type = filter, wrap = d3_selection_onFilter;
          function onRemove() {
            var l = this[name2];
            if (l) {
              this.removeEventListener(type, l, l.$);
              delete this[name2];
            }
          }
          function onAdd() {
            var l = wrap(listener, d3_array(arguments));
            onRemove.call(this);
            this.addEventListener(type, this[name2] = l, l.$ = capture);
            l._ = listener;
          }
          function removeAll() {
            var re = new RegExp("^__on([^.]+)" + d3.requote(type) + "$"), match;
            for (var name3 in this) {
              if (match = name3.match(re)) {
                var l = this[name3];
                this.removeEventListener(match[1], l, l.$);
                delete this[name3];
              }
            }
          }
          return i ? listener ? onAdd : onRemove : listener ? d3_noop : removeAll;
        }
        var d3_selection_onFilters = d3.map({
          mouseenter: "mouseover",
          mouseleave: "mouseout"
        });
        if (d3_document) {
          d3_selection_onFilters.forEach(function(k) {
            if ("on" + k in d3_document) d3_selection_onFilters.remove(k);
          });
        }
        function d3_selection_onListener(listener, argumentz) {
          return function(e) {
            var o = d3.event;
            d3.event = e;
            argumentz[0] = this.__data__;
            try {
              listener.apply(this, argumentz);
            } finally {
              d3.event = o;
            }
          };
        }
        function d3_selection_onFilter(listener, argumentz) {
          var l = d3_selection_onListener(listener, argumentz);
          return function(e) {
            var target = this, related = e.relatedTarget;
            if (!related || related !== target && !(related.compareDocumentPosition(target) & 8)) {
              l.call(target, e);
            }
          };
        }
        var d3_event_dragSelect, d3_event_dragId = 0;
        function d3_event_dragSuppress(node) {
          var name2 = ".dragsuppress-" + ++d3_event_dragId, click = "click" + name2, w = d3.select(d3_window(node)).on("touchmove" + name2, d3_eventPreventDefault).on("dragstart" + name2, d3_eventPreventDefault).on("selectstart" + name2, d3_eventPreventDefault);
          if (d3_event_dragSelect == null) {
            d3_event_dragSelect = "onselectstart" in node ? false : d3_vendorSymbol(node.style, "userSelect");
          }
          if (d3_event_dragSelect) {
            var style = d3_documentElement(node).style, select = style[d3_event_dragSelect];
            style[d3_event_dragSelect] = "none";
          }
          return function(suppressClick) {
            w.on(name2, null);
            if (d3_event_dragSelect) style[d3_event_dragSelect] = select;
            if (suppressClick) {
              var off = function() {
                w.on(click, null);
              };
              w.on(click, function() {
                d3_eventPreventDefault();
                off();
              }, true);
              setTimeout(off, 0);
            }
          };
        }
        d3.mouse = function(container) {
          return d3_mousePoint(container, d3_eventSource());
        };
        var d3_mouse_bug44083 = this.navigator && /WebKit/.test(this.navigator.userAgent) ? -1 : 0;
        function d3_mousePoint(container, e) {
          if (e.changedTouches) e = e.changedTouches[0];
          var svg = container.ownerSVGElement || container;
          if (svg.createSVGPoint) {
            var point = svg.createSVGPoint();
            if (d3_mouse_bug44083 < 0) {
              var window2 = d3_window(container);
              if (window2.scrollX || window2.scrollY) {
                svg = d3.select("body").append("svg").style({
                  position: "absolute",
                  top: 0,
                  left: 0,
                  margin: 0,
                  padding: 0,
                  border: "none"
                }, "important");
                var ctm = svg[0][0].getScreenCTM();
                d3_mouse_bug44083 = !(ctm.f || ctm.e);
                svg.remove();
              }
            }
            if (d3_mouse_bug44083) point.x = e.pageX, point.y = e.pageY;
            else point.x = e.clientX, point.y = e.clientY;
            point = point.matrixTransform(container.getScreenCTM().inverse());
            return [point.x, point.y];
          }
          var rect = container.getBoundingClientRect();
          return [e.clientX - rect.left - container.clientLeft, e.clientY - rect.top - container.clientTop];
        }
        d3.touch = function(container, touches, identifier) {
          if (arguments.length < 3) identifier = touches, touches = d3_eventSource().changedTouches;
          if (touches) for (var i = 0, n = touches.length, touch; i < n; ++i) {
            if ((touch = touches[i]).identifier === identifier) {
              return d3_mousePoint(container, touch);
            }
          }
        };
        d3.behavior.drag = function() {
          var event = d3_eventDispatch(drag, "drag", "dragstart", "dragend"), origin = null, mousedown = dragstart(d3_noop, d3.mouse, d3_window, "mousemove", "mouseup"), touchstart = dragstart(d3_behavior_dragTouchId, d3.touch, d3_identity, "touchmove", "touchend");
          function drag() {
            this.on("mousedown.drag", mousedown).on("touchstart.drag", touchstart);
          }
          function dragstart(id, position, subject, move, end) {
            return function() {
              var that = this, target = d3.event.target.correspondingElement || d3.event.target, parent = that.parentNode, dispatch = event.of(that, arguments), dragged = 0, dragId = id(), dragName = ".drag" + (dragId == null ? "" : "-" + dragId), dragOffset, dragSubject = d3.select(subject(target)).on(move + dragName, moved).on(end + dragName, ended), dragRestore = d3_event_dragSuppress(target), position0 = position(parent, dragId);
              if (origin) {
                dragOffset = origin.apply(that, arguments);
                dragOffset = [dragOffset.x - position0[0], dragOffset.y - position0[1]];
              } else {
                dragOffset = [0, 0];
              }
              dispatch({
                type: "dragstart"
              });
              function moved() {
                var position1 = position(parent, dragId), dx, dy;
                if (!position1) return;
                dx = position1[0] - position0[0];
                dy = position1[1] - position0[1];
                dragged |= dx | dy;
                position0 = position1;
                dispatch({
                  type: "drag",
                  x: position1[0] + dragOffset[0],
                  y: position1[1] + dragOffset[1],
                  dx,
                  dy
                });
              }
              function ended() {
                if (!position(parent, dragId)) return;
                dragSubject.on(move + dragName, null).on(end + dragName, null);
                dragRestore(dragged);
                dispatch({
                  type: "dragend"
                });
              }
            };
          }
          drag.origin = function(x) {
            if (!arguments.length) return origin;
            origin = x;
            return drag;
          };
          return d3.rebind(drag, event, "on");
        };
        function d3_behavior_dragTouchId() {
          return d3.event.changedTouches[0].identifier;
        }
        d3.touches = function(container, touches) {
          if (arguments.length < 2) touches = d3_eventSource().touches;
          return touches ? d3_array(touches).map(function(touch) {
            var point = d3_mousePoint(container, touch);
            point.identifier = touch.identifier;
            return point;
          }) : [];
        };
        var \u03B5 = 1e-6, \u03B52 = \u03B5 * \u03B5, \u03C0 = Math.PI, \u03C4 = 2 * \u03C0, \u03C4\u03B5 = \u03C4 - \u03B5, half\u03C0 = \u03C0 / 2, d3_radians = \u03C0 / 180, d3_degrees = 180 / \u03C0;
        function d3_sgn(x) {
          return x > 0 ? 1 : x < 0 ? -1 : 0;
        }
        function d3_cross2d(a, b, c) {
          return (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
        }
        function d3_acos(x) {
          return x > 1 ? 0 : x < -1 ? \u03C0 : Math.acos(x);
        }
        function d3_asin(x) {
          return x > 1 ? half\u03C0 : x < -1 ? -half\u03C0 : Math.asin(x);
        }
        function d3_sinh(x) {
          return ((x = Math.exp(x)) - 1 / x) / 2;
        }
        function d3_cosh(x) {
          return ((x = Math.exp(x)) + 1 / x) / 2;
        }
        function d3_tanh(x) {
          return ((x = Math.exp(2 * x)) - 1) / (x + 1);
        }
        function d3_haversin(x) {
          return (x = Math.sin(x / 2)) * x;
        }
        var \u03C1 = Math.SQRT2, \u03C12 = 2, \u03C14 = 4;
        d3.interpolateZoom = function(p0, p1) {
          var ux0 = p0[0], uy0 = p0[1], w0 = p0[2], ux1 = p1[0], uy1 = p1[1], w1 = p1[2], dx = ux1 - ux0, dy = uy1 - uy0, d2 = dx * dx + dy * dy, i, S;
          if (d2 < \u03B52) {
            S = Math.log(w1 / w0) / \u03C1;
            i = function(t) {
              return [ux0 + t * dx, uy0 + t * dy, w0 * Math.exp(\u03C1 * t * S)];
            };
          } else {
            var d1 = Math.sqrt(d2), b0 = (w1 * w1 - w0 * w0 + \u03C14 * d2) / (2 * w0 * \u03C12 * d1), b1 = (w1 * w1 - w0 * w0 - \u03C14 * d2) / (2 * w1 * \u03C12 * d1), r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0), r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
            S = (r1 - r0) / \u03C1;
            i = function(t) {
              var s = t * S, coshr0 = d3_cosh(r0), u = w0 / (\u03C12 * d1) * (coshr0 * d3_tanh(\u03C1 * s + r0) - d3_sinh(r0));
              return [ux0 + u * dx, uy0 + u * dy, w0 * coshr0 / d3_cosh(\u03C1 * s + r0)];
            };
          }
          i.duration = S * 1e3;
          return i;
        };
        d3.behavior.zoom = function() {
          var view = {
            x: 0,
            y: 0,
            k: 1
          }, translate0, center0, center, size = [960, 500], scaleExtent = d3_behavior_zoomInfinity, duration = 250, zooming = 0, mousedown = "mousedown.zoom", mousemove = "mousemove.zoom", mouseup = "mouseup.zoom", mousewheelTimer, touchstart = "touchstart.zoom", touchtime, event = d3_eventDispatch(zoom, "zoomstart", "zoom", "zoomend"), x0, x1, y0, y1;
          if (!d3_behavior_zoomWheel) {
            d3_behavior_zoomWheel = "onwheel" in d3_document ? (d3_behavior_zoomDelta = function() {
              return -d3.event.deltaY * (d3.event.deltaMode ? 120 : 1);
            }, "wheel") : "onmousewheel" in d3_document ? (d3_behavior_zoomDelta = function() {
              return d3.event.wheelDelta;
            }, "mousewheel") : (d3_behavior_zoomDelta = function() {
              return -d3.event.detail;
            }, "MozMousePixelScroll");
          }
          function zoom(g) {
            g.on(mousedown, mousedowned).on(d3_behavior_zoomWheel + ".zoom", mousewheeled).on("dblclick.zoom", dblclicked).on(touchstart, touchstarted);
          }
          zoom.event = function(g) {
            g.each(function() {
              var dispatch = event.of(this, arguments), view1 = view;
              if (d3_transitionInheritId) {
                d3.select(this).transition().each("start.zoom", function() {
                  view = this.__chart__ || {
                    x: 0,
                    y: 0,
                    k: 1
                  };
                  zoomstarted(dispatch);
                }).tween("zoom:zoom", function() {
                  var dx = size[0], dy = size[1], cx = center0 ? center0[0] : dx / 2, cy = center0 ? center0[1] : dy / 2, i = d3.interpolateZoom([(cx - view.x) / view.k, (cy - view.y) / view.k, dx / view.k], [(cx - view1.x) / view1.k, (cy - view1.y) / view1.k, dx / view1.k]);
                  return function(t) {
                    var l = i(t), k = dx / l[2];
                    this.__chart__ = view = {
                      x: cx - l[0] * k,
                      y: cy - l[1] * k,
                      k
                    };
                    zoomed(dispatch);
                  };
                }).each("interrupt.zoom", function() {
                  zoomended(dispatch);
                }).each("end.zoom", function() {
                  zoomended(dispatch);
                });
              } else {
                this.__chart__ = view;
                zoomstarted(dispatch);
                zoomed(dispatch);
                zoomended(dispatch);
              }
            });
          };
          zoom.translate = function(_) {
            if (!arguments.length) return [view.x, view.y];
            view = {
              x: +_[0],
              y: +_[1],
              k: view.k
            };
            rescale();
            return zoom;
          };
          zoom.scale = function(_) {
            if (!arguments.length) return view.k;
            view = {
              x: view.x,
              y: view.y,
              k: null
            };
            scaleTo(+_);
            rescale();
            return zoom;
          };
          zoom.scaleExtent = function(_) {
            if (!arguments.length) return scaleExtent;
            scaleExtent = _ == null ? d3_behavior_zoomInfinity : [+_[0], +_[1]];
            return zoom;
          };
          zoom.center = function(_) {
            if (!arguments.length) return center;
            center = _ && [+_[0], +_[1]];
            return zoom;
          };
          zoom.size = function(_) {
            if (!arguments.length) return size;
            size = _ && [+_[0], +_[1]];
            return zoom;
          };
          zoom.duration = function(_) {
            if (!arguments.length) return duration;
            duration = +_;
            return zoom;
          };
          zoom.x = function(z) {
            if (!arguments.length) return x1;
            x1 = z;
            x0 = z.copy();
            view = {
              x: 0,
              y: 0,
              k: 1
            };
            return zoom;
          };
          zoom.y = function(z) {
            if (!arguments.length) return y1;
            y1 = z;
            y0 = z.copy();
            view = {
              x: 0,
              y: 0,
              k: 1
            };
            return zoom;
          };
          function location2(p) {
            return [(p[0] - view.x) / view.k, (p[1] - view.y) / view.k];
          }
          function point(l) {
            return [l[0] * view.k + view.x, l[1] * view.k + view.y];
          }
          function scaleTo(s) {
            view.k = Math.max(scaleExtent[0], Math.min(scaleExtent[1], s));
          }
          function translateTo(p, l) {
            l = point(l);
            view.x += p[0] - l[0];
            view.y += p[1] - l[1];
          }
          function zoomTo(that, p, l, k) {
            that.__chart__ = {
              x: view.x,
              y: view.y,
              k: view.k
            };
            scaleTo(Math.pow(2, k));
            translateTo(center0 = p, l);
            that = d3.select(that);
            if (duration > 0) that = that.transition().duration(duration);
            that.call(zoom.event);
          }
          function rescale() {
            if (x1) x1.domain(x0.range().map(function(x) {
              return (x - view.x) / view.k;
            }).map(x0.invert));
            if (y1) y1.domain(y0.range().map(function(y) {
              return (y - view.y) / view.k;
            }).map(y0.invert));
          }
          function zoomstarted(dispatch) {
            if (!zooming++) dispatch({
              type: "zoomstart"
            });
          }
          function zoomed(dispatch) {
            rescale();
            dispatch({
              type: "zoom",
              scale: view.k,
              translate: [view.x, view.y]
            });
          }
          function zoomended(dispatch) {
            if (!--zooming) dispatch({
              type: "zoomend"
            }), center0 = null;
          }
          function mousedowned() {
            var that = this, dispatch = event.of(that, arguments), dragged = 0, subject = d3.select(d3_window(that)).on(mousemove, moved).on(mouseup, ended), location0 = location2(d3.mouse(that)), dragRestore = d3_event_dragSuppress(that);
            d3_selection_interrupt.call(that);
            zoomstarted(dispatch);
            function moved() {
              dragged = 1;
              translateTo(d3.mouse(that), location0);
              zoomed(dispatch);
            }
            function ended() {
              subject.on(mousemove, null).on(mouseup, null);
              dragRestore(dragged);
              zoomended(dispatch);
            }
          }
          function touchstarted() {
            var that = this, dispatch = event.of(that, arguments), locations0 = {}, distance0 = 0, scale0, zoomName = ".zoom-" + d3.event.changedTouches[0].identifier, touchmove = "touchmove" + zoomName, touchend = "touchend" + zoomName, targets = [], subject = d3.select(that), dragRestore = d3_event_dragSuppress(that);
            started();
            zoomstarted(dispatch);
            subject.on(mousedown, null).on(touchstart, started);
            function relocate() {
              var touches = d3.touches(that);
              scale0 = view.k;
              touches.forEach(function(t) {
                if (t.identifier in locations0) locations0[t.identifier] = location2(t);
              });
              return touches;
            }
            function started() {
              var target = d3.event.target;
              d3.select(target).on(touchmove, moved).on(touchend, ended);
              targets.push(target);
              var changed = d3.event.changedTouches;
              for (var i = 0, n = changed.length; i < n; ++i) {
                locations0[changed[i].identifier] = null;
              }
              var touches = relocate(), now = Date.now();
              if (touches.length === 1) {
                if (now - touchtime < 500) {
                  var p = touches[0];
                  zoomTo(that, p, locations0[p.identifier], Math.floor(Math.log(view.k) / Math.LN2) + 1);
                  d3_eventPreventDefault();
                }
                touchtime = now;
              } else if (touches.length > 1) {
                var p = touches[0], q = touches[1], dx = p[0] - q[0], dy = p[1] - q[1];
                distance0 = dx * dx + dy * dy;
              }
            }
            function moved() {
              var touches = d3.touches(that), p0, l0, p1, l1;
              d3_selection_interrupt.call(that);
              for (var i = 0, n = touches.length; i < n; ++i, l1 = null) {
                p1 = touches[i];
                if (l1 = locations0[p1.identifier]) {
                  if (l0) break;
                  p0 = p1, l0 = l1;
                }
              }
              if (l1) {
                var distance1 = (distance1 = p1[0] - p0[0]) * distance1 + (distance1 = p1[1] - p0[1]) * distance1, scale1 = distance0 && Math.sqrt(distance1 / distance0);
                p0 = [(p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2];
                l0 = [(l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2];
                scaleTo(scale1 * scale0);
              }
              touchtime = null;
              translateTo(p0, l0);
              zoomed(dispatch);
            }
            function ended() {
              if (d3.event.touches.length) {
                var changed = d3.event.changedTouches;
                for (var i = 0, n = changed.length; i < n; ++i) {
                  delete locations0[changed[i].identifier];
                }
                for (var identifier in locations0) {
                  return void relocate();
                }
              }
              d3.selectAll(targets).on(zoomName, null);
              subject.on(mousedown, mousedowned).on(touchstart, touchstarted);
              dragRestore();
              zoomended(dispatch);
            }
          }
          function mousewheeled() {
            var dispatch = event.of(this, arguments);
            if (mousewheelTimer) clearTimeout(mousewheelTimer);
            else d3_selection_interrupt.call(this), translate0 = location2(center0 = center || d3.mouse(this)), zoomstarted(dispatch);
            mousewheelTimer = setTimeout(function() {
              mousewheelTimer = null;
              zoomended(dispatch);
            }, 50);
            d3_eventPreventDefault();
            scaleTo(Math.pow(2, d3_behavior_zoomDelta() * 2e-3) * view.k);
            translateTo(center0, translate0);
            zoomed(dispatch);
          }
          function dblclicked() {
            var p = d3.mouse(this), k = Math.log(view.k) / Math.LN2;
            zoomTo(this, p, location2(p), d3.event.shiftKey ? Math.ceil(k) - 1 : Math.floor(k) + 1);
          }
          return d3.rebind(zoom, event, "on");
        };
        var d3_behavior_zoomInfinity = [0, Infinity], d3_behavior_zoomDelta, d3_behavior_zoomWheel;
        d3.color = d3_color;
        function d3_color() {
        }
        d3_color.prototype.toString = function() {
          return this.rgb() + "";
        };
        d3.hsl = d3_hsl;
        function d3_hsl(h, s, l) {
          return this instanceof d3_hsl ? void (this.h = +h, this.s = +s, this.l = +l) : arguments.length < 2 ? h instanceof d3_hsl ? new d3_hsl(h.h, h.s, h.l) : d3_rgb_parse("" + h, d3_rgb_hsl, d3_hsl) : new d3_hsl(h, s, l);
        }
        var d3_hslPrototype = d3_hsl.prototype = new d3_color();
        d3_hslPrototype.brighter = function(k) {
          k = Math.pow(0.7, arguments.length ? k : 1);
          return new d3_hsl(this.h, this.s, this.l / k);
        };
        d3_hslPrototype.darker = function(k) {
          k = Math.pow(0.7, arguments.length ? k : 1);
          return new d3_hsl(this.h, this.s, k * this.l);
        };
        d3_hslPrototype.rgb = function() {
          return d3_hsl_rgb(this.h, this.s, this.l);
        };
        function d3_hsl_rgb(h, s, l) {
          var m1, m2;
          h = isNaN(h) ? 0 : (h %= 360) < 0 ? h + 360 : h;
          s = isNaN(s) ? 0 : s < 0 ? 0 : s > 1 ? 1 : s;
          l = l < 0 ? 0 : l > 1 ? 1 : l;
          m2 = l <= 0.5 ? l * (1 + s) : l + s - l * s;
          m1 = 2 * l - m2;
          function v(h2) {
            if (h2 > 360) h2 -= 360;
            else if (h2 < 0) h2 += 360;
            if (h2 < 60) return m1 + (m2 - m1) * h2 / 60;
            if (h2 < 180) return m2;
            if (h2 < 240) return m1 + (m2 - m1) * (240 - h2) / 60;
            return m1;
          }
          function vv(h2) {
            return Math.round(v(h2) * 255);
          }
          return new d3_rgb(vv(h + 120), vv(h), vv(h - 120));
        }
        d3.hcl = d3_hcl;
        function d3_hcl(h, c, l) {
          return this instanceof d3_hcl ? void (this.h = +h, this.c = +c, this.l = +l) : arguments.length < 2 ? h instanceof d3_hcl ? new d3_hcl(h.h, h.c, h.l) : h instanceof d3_lab ? d3_lab_hcl(h.l, h.a, h.b) : d3_lab_hcl((h = d3_rgb_lab((h = d3.rgb(h)).r, h.g, h.b)).l, h.a, h.b) : new d3_hcl(h, c, l);
        }
        var d3_hclPrototype = d3_hcl.prototype = new d3_color();
        d3_hclPrototype.brighter = function(k) {
          return new d3_hcl(this.h, this.c, Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)));
        };
        d3_hclPrototype.darker = function(k) {
          return new d3_hcl(this.h, this.c, Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)));
        };
        d3_hclPrototype.rgb = function() {
          return d3_hcl_lab(this.h, this.c, this.l).rgb();
        };
        function d3_hcl_lab(h, c, l) {
          if (isNaN(h)) h = 0;
          if (isNaN(c)) c = 0;
          return new d3_lab(l, Math.cos(h *= d3_radians) * c, Math.sin(h) * c);
        }
        d3.lab = d3_lab;
        function d3_lab(l, a, b) {
          return this instanceof d3_lab ? void (this.l = +l, this.a = +a, this.b = +b) : arguments.length < 2 ? l instanceof d3_lab ? new d3_lab(l.l, l.a, l.b) : l instanceof d3_hcl ? d3_hcl_lab(l.h, l.c, l.l) : d3_rgb_lab((l = d3_rgb(l)).r, l.g, l.b) : new d3_lab(l, a, b);
        }
        var d3_lab_K = 18;
        var d3_lab_X = 0.95047, d3_lab_Y = 1, d3_lab_Z = 1.08883;
        var d3_labPrototype = d3_lab.prototype = new d3_color();
        d3_labPrototype.brighter = function(k) {
          return new d3_lab(Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);
        };
        d3_labPrototype.darker = function(k) {
          return new d3_lab(Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);
        };
        d3_labPrototype.rgb = function() {
          return d3_lab_rgb(this.l, this.a, this.b);
        };
        function d3_lab_rgb(l, a, b) {
          var y = (l + 16) / 116, x = y + a / 500, z = y - b / 200;
          x = d3_lab_xyz(x) * d3_lab_X;
          y = d3_lab_xyz(y) * d3_lab_Y;
          z = d3_lab_xyz(z) * d3_lab_Z;
          return new d3_rgb(d3_xyz_rgb(3.2404542 * x - 1.5371385 * y - 0.4985314 * z), d3_xyz_rgb(-0.969266 * x + 1.8760108 * y + 0.041556 * z), d3_xyz_rgb(0.0556434 * x - 0.2040259 * y + 1.0572252 * z));
        }
        function d3_lab_hcl(l, a, b) {
          return l > 0 ? new d3_hcl(Math.atan2(b, a) * d3_degrees, Math.sqrt(a * a + b * b), l) : new d3_hcl(NaN, NaN, l);
        }
        function d3_lab_xyz(x) {
          return x > 0.206893034 ? x * x * x : (x - 4 / 29) / 7.787037;
        }
        function d3_xyz_lab(x) {
          return x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787037 * x + 4 / 29;
        }
        function d3_xyz_rgb(r) {
          return Math.round(255 * (r <= 304e-5 ? 12.92 * r : 1.055 * Math.pow(r, 1 / 2.4) - 0.055));
        }
        d3.rgb = d3_rgb;
        function d3_rgb(r, g, b) {
          return this instanceof d3_rgb ? void (this.r = ~~r, this.g = ~~g, this.b = ~~b) : arguments.length < 2 ? r instanceof d3_rgb ? new d3_rgb(r.r, r.g, r.b) : d3_rgb_parse("" + r, d3_rgb, d3_hsl_rgb) : new d3_rgb(r, g, b);
        }
        function d3_rgbNumber(value) {
          return new d3_rgb(value >> 16, value >> 8 & 255, value & 255);
        }
        function d3_rgbString(value) {
          return d3_rgbNumber(value) + "";
        }
        var d3_rgbPrototype = d3_rgb.prototype = new d3_color();
        d3_rgbPrototype.brighter = function(k) {
          k = Math.pow(0.7, arguments.length ? k : 1);
          var r = this.r, g = this.g, b = this.b, i = 30;
          if (!r && !g && !b) return new d3_rgb(i, i, i);
          if (r && r < i) r = i;
          if (g && g < i) g = i;
          if (b && b < i) b = i;
          return new d3_rgb(Math.min(255, r / k), Math.min(255, g / k), Math.min(255, b / k));
        };
        d3_rgbPrototype.darker = function(k) {
          k = Math.pow(0.7, arguments.length ? k : 1);
          return new d3_rgb(k * this.r, k * this.g, k * this.b);
        };
        d3_rgbPrototype.hsl = function() {
          return d3_rgb_hsl(this.r, this.g, this.b);
        };
        d3_rgbPrototype.toString = function() {
          return "#" + d3_rgb_hex(this.r) + d3_rgb_hex(this.g) + d3_rgb_hex(this.b);
        };
        function d3_rgb_hex(v) {
          return v < 16 ? "0" + Math.max(0, v).toString(16) : Math.min(255, v).toString(16);
        }
        function d3_rgb_parse(format, rgb2, hsl3) {
          var r = 0, g = 0, b = 0, m1, m2, color2;
          m1 = /([a-z]+)\((.*)\)/.exec(format = format.toLowerCase());
          if (m1) {
            m2 = m1[2].split(",");
            switch (m1[1]) {
              case "hsl": {
                return hsl3(parseFloat(m2[0]), parseFloat(m2[1]) / 100, parseFloat(m2[2]) / 100);
              }
              case "rgb": {
                return rgb2(d3_rgb_parseNumber(m2[0]), d3_rgb_parseNumber(m2[1]), d3_rgb_parseNumber(m2[2]));
              }
            }
          }
          if (color2 = d3_rgb_names.get(format)) {
            return rgb2(color2.r, color2.g, color2.b);
          }
          if (format != null && format.charAt(0) === "#" && !isNaN(color2 = parseInt(format.slice(1), 16))) {
            if (format.length === 4) {
              r = (color2 & 3840) >> 4;
              r = r >> 4 | r;
              g = color2 & 240;
              g = g >> 4 | g;
              b = color2 & 15;
              b = b << 4 | b;
            } else if (format.length === 7) {
              r = (color2 & 16711680) >> 16;
              g = (color2 & 65280) >> 8;
              b = color2 & 255;
            }
          }
          return rgb2(r, g, b);
        }
        function d3_rgb_hsl(r, g, b) {
          var min = Math.min(r /= 255, g /= 255, b /= 255), max = Math.max(r, g, b), d = max - min, h, s, l = (max + min) / 2;
          if (d) {
            s = l < 0.5 ? d / (max + min) : d / (2 - max - min);
            if (r == max) h = (g - b) / d + (g < b ? 6 : 0);
            else if (g == max) h = (b - r) / d + 2;
            else h = (r - g) / d + 4;
            h *= 60;
          } else {
            h = NaN;
            s = l > 0 && l < 1 ? 0 : h;
          }
          return new d3_hsl(h, s, l);
        }
        function d3_rgb_lab(r, g, b) {
          r = d3_rgb_xyz(r);
          g = d3_rgb_xyz(g);
          b = d3_rgb_xyz(b);
          var x = d3_xyz_lab((0.4124564 * r + 0.3575761 * g + 0.1804375 * b) / d3_lab_X), y = d3_xyz_lab((0.2126729 * r + 0.7151522 * g + 0.072175 * b) / d3_lab_Y), z = d3_xyz_lab((0.0193339 * r + 0.119192 * g + 0.9503041 * b) / d3_lab_Z);
          return d3_lab(116 * y - 16, 500 * (x - y), 200 * (y - z));
        }
        function d3_rgb_xyz(r) {
          return (r /= 255) <= 0.04045 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        }
        function d3_rgb_parseNumber(c) {
          var f = parseFloat(c);
          return c.charAt(c.length - 1) === "%" ? Math.round(f * 2.55) : f;
        }
        var d3_rgb_names = d3.map({
          aliceblue: 15792383,
          antiquewhite: 16444375,
          aqua: 65535,
          aquamarine: 8388564,
          azure: 15794175,
          beige: 16119260,
          bisque: 16770244,
          black: 0,
          blanchedalmond: 16772045,
          blue: 255,
          blueviolet: 9055202,
          brown: 10824234,
          burlywood: 14596231,
          cadetblue: 6266528,
          chartreuse: 8388352,
          chocolate: 13789470,
          coral: 16744272,
          cornflowerblue: 6591981,
          cornsilk: 16775388,
          crimson: 14423100,
          cyan: 65535,
          darkblue: 139,
          darkcyan: 35723,
          darkgoldenrod: 12092939,
          darkgray: 11119017,
          darkgreen: 25600,
          darkgrey: 11119017,
          darkkhaki: 12433259,
          darkmagenta: 9109643,
          darkolivegreen: 5597999,
          darkorange: 16747520,
          darkorchid: 10040012,
          darkred: 9109504,
          darksalmon: 15308410,
          darkseagreen: 9419919,
          darkslateblue: 4734347,
          darkslategray: 3100495,
          darkslategrey: 3100495,
          darkturquoise: 52945,
          darkviolet: 9699539,
          deeppink: 16716947,
          deepskyblue: 49151,
          dimgray: 6908265,
          dimgrey: 6908265,
          dodgerblue: 2003199,
          firebrick: 11674146,
          floralwhite: 16775920,
          forestgreen: 2263842,
          fuchsia: 16711935,
          gainsboro: 14474460,
          ghostwhite: 16316671,
          gold: 16766720,
          goldenrod: 14329120,
          gray: 8421504,
          green: 32768,
          greenyellow: 11403055,
          grey: 8421504,
          honeydew: 15794160,
          hotpink: 16738740,
          indianred: 13458524,
          indigo: 4915330,
          ivory: 16777200,
          khaki: 15787660,
          lavender: 15132410,
          lavenderblush: 16773365,
          lawngreen: 8190976,
          lemonchiffon: 16775885,
          lightblue: 11393254,
          lightcoral: 15761536,
          lightcyan: 14745599,
          lightgoldenrodyellow: 16448210,
          lightgray: 13882323,
          lightgreen: 9498256,
          lightgrey: 13882323,
          lightpink: 16758465,
          lightsalmon: 16752762,
          lightseagreen: 2142890,
          lightskyblue: 8900346,
          lightslategray: 7833753,
          lightslategrey: 7833753,
          lightsteelblue: 11584734,
          lightyellow: 16777184,
          lime: 65280,
          limegreen: 3329330,
          linen: 16445670,
          magenta: 16711935,
          maroon: 8388608,
          mediumaquamarine: 6737322,
          mediumblue: 205,
          mediumorchid: 12211667,
          mediumpurple: 9662683,
          mediumseagreen: 3978097,
          mediumslateblue: 8087790,
          mediumspringgreen: 64154,
          mediumturquoise: 4772300,
          mediumvioletred: 13047173,
          midnightblue: 1644912,
          mintcream: 16121850,
          mistyrose: 16770273,
          moccasin: 16770229,
          navajowhite: 16768685,
          navy: 128,
          oldlace: 16643558,
          olive: 8421376,
          olivedrab: 7048739,
          orange: 16753920,
          orangered: 16729344,
          orchid: 14315734,
          palegoldenrod: 15657130,
          palegreen: 10025880,
          paleturquoise: 11529966,
          palevioletred: 14381203,
          papayawhip: 16773077,
          peachpuff: 16767673,
          peru: 13468991,
          pink: 16761035,
          plum: 14524637,
          powderblue: 11591910,
          purple: 8388736,
          rebeccapurple: 6697881,
          red: 16711680,
          rosybrown: 12357519,
          royalblue: 4286945,
          saddlebrown: 9127187,
          salmon: 16416882,
          sandybrown: 16032864,
          seagreen: 3050327,
          seashell: 16774638,
          sienna: 10506797,
          silver: 12632256,
          skyblue: 8900331,
          slateblue: 6970061,
          slategray: 7372944,
          slategrey: 7372944,
          snow: 16775930,
          springgreen: 65407,
          steelblue: 4620980,
          tan: 13808780,
          teal: 32896,
          thistle: 14204888,
          tomato: 16737095,
          turquoise: 4251856,
          violet: 15631086,
          wheat: 16113331,
          white: 16777215,
          whitesmoke: 16119285,
          yellow: 16776960,
          yellowgreen: 10145074
        });
        d3_rgb_names.forEach(function(key, value) {
          d3_rgb_names.set(key, d3_rgbNumber(value));
        });
        function d3_functor(v) {
          return typeof v === "function" ? v : function() {
            return v;
          };
        }
        d3.functor = d3_functor;
        d3.xhr = d3_xhrType(d3_identity);
        function d3_xhrType(response) {
          return function(url, mimeType, callback) {
            if (arguments.length === 2 && typeof mimeType === "function") callback = mimeType, mimeType = null;
            return d3_xhr(url, mimeType, response, callback);
          };
        }
        function d3_xhr(url, mimeType, response, callback) {
          var xhr = {}, dispatch = d3.dispatch("beforesend", "progress", "load", "error"), headers = {}, request = new XMLHttpRequest(), responseType = null;
          if (self.XDomainRequest && !("withCredentials" in request) && /^(http(s)?:)?\/\//.test(url)) request = new XDomainRequest();
          "onload" in request ? request.onload = request.onerror = respond : request.onreadystatechange = function() {
            request.readyState > 3 && respond();
          };
          function respond() {
            var status = request.status, result;
            if (!status && d3_xhrHasResponse(request) || status >= 200 && status < 300 || status === 304) {
              try {
                result = response.call(xhr, request);
              } catch (e) {
                dispatch.error.call(xhr, e);
                return;
              }
              dispatch.load.call(xhr, result);
            } else {
              dispatch.error.call(xhr, request);
            }
          }
          request.onprogress = function(event) {
            var o = d3.event;
            d3.event = event;
            try {
              dispatch.progress.call(xhr, request);
            } finally {
              d3.event = o;
            }
          };
          xhr.header = function(name2, value) {
            name2 = (name2 + "").toLowerCase();
            if (arguments.length < 2) return headers[name2];
            if (value == null) delete headers[name2];
            else headers[name2] = value + "";
            return xhr;
          };
          xhr.mimeType = function(value) {
            if (!arguments.length) return mimeType;
            mimeType = value == null ? null : value + "";
            return xhr;
          };
          xhr.responseType = function(value) {
            if (!arguments.length) return responseType;
            responseType = value;
            return xhr;
          };
          xhr.response = function(value) {
            response = value;
            return xhr;
          };
          ["get", "post"].forEach(function(method) {
            xhr[method] = function() {
              return xhr.send.apply(xhr, [method].concat(d3_array(arguments)));
            };
          });
          xhr.send = function(method, data, callback2) {
            if (arguments.length === 2 && typeof data === "function") callback2 = data, data = null;
            request.open(method, url, true);
            if (mimeType != null && !("accept" in headers)) headers["accept"] = mimeType + ",*/*";
            if (request.setRequestHeader) for (var name2 in headers) request.setRequestHeader(name2, headers[name2]);
            if (mimeType != null && request.overrideMimeType) request.overrideMimeType(mimeType);
            if (responseType != null) request.responseType = responseType;
            if (callback2 != null) xhr.on("error", callback2).on("load", function(request2) {
              callback2(null, request2);
            });
            dispatch.beforesend.call(xhr, request);
            request.send(data == null ? null : data);
            return xhr;
          };
          xhr.abort = function() {
            request.abort();
            return xhr;
          };
          d3.rebind(xhr, dispatch, "on");
          return callback == null ? xhr : xhr.get(d3_xhr_fixCallback(callback));
        }
        function d3_xhr_fixCallback(callback) {
          return callback.length === 1 ? function(error, request) {
            callback(error == null ? request : null);
          } : callback;
        }
        function d3_xhrHasResponse(request) {
          var type = request.responseType;
          return type && type !== "text" ? request.response : request.responseText;
        }
        d3.dsv = function(delimiter, mimeType) {
          var reFormat = new RegExp('["' + delimiter + "\n]"), delimiterCode = delimiter.charCodeAt(0);
          function dsv(url, row, callback) {
            if (arguments.length < 3) callback = row, row = null;
            var xhr = d3_xhr(url, mimeType, row == null ? response : typedResponse(row), callback);
            xhr.row = function(_) {
              return arguments.length ? xhr.response((row = _) == null ? response : typedResponse(_)) : row;
            };
            return xhr;
          }
          function response(request) {
            return dsv.parse(request.responseText);
          }
          function typedResponse(f) {
            return function(request) {
              return dsv.parse(request.responseText, f);
            };
          }
          dsv.parse = function(text, f) {
            var o;
            return dsv.parseRows(text, function(row, i) {
              if (o) return o(row, i - 1);
              var a = function(d) {
                var obj = {};
                var len = row.length;
                for (var k = 0; k < len; ++k) {
                  obj[row[k]] = d[k];
                }
                return obj;
              };
              o = f ? function(row2, i2) {
                return f(a(row2), i2);
              } : a;
            });
          };
          dsv.parseRows = function(text, f) {
            var EOL = {}, EOF = {}, rows = [], N = text.length, I = 0, n = 0, t, eol;
            function token() {
              if (I >= N) return EOF;
              if (eol) return eol = false, EOL;
              var j = I;
              if (text.charCodeAt(j) === 34) {
                var i = j;
                while (i++ < N) {
                  if (text.charCodeAt(i) === 34) {
                    if (text.charCodeAt(i + 1) !== 34) break;
                    ++i;
                  }
                }
                I = i + 2;
                var c = text.charCodeAt(i + 1);
                if (c === 13) {
                  eol = true;
                  if (text.charCodeAt(i + 2) === 10) ++I;
                } else if (c === 10) {
                  eol = true;
                }
                return text.slice(j + 1, i).replace(/""/g, '"');
              }
              while (I < N) {
                var c = text.charCodeAt(I++), k = 1;
                if (c === 10) eol = true;
                else if (c === 13) {
                  eol = true;
                  if (text.charCodeAt(I) === 10) ++I, ++k;
                } else if (c !== delimiterCode) continue;
                return text.slice(j, I - k);
              }
              return text.slice(j);
            }
            while ((t = token()) !== EOF) {
              var a = [];
              while (t !== EOL && t !== EOF) {
                a.push(t);
                t = token();
              }
              if (f && (a = f(a, n++)) == null) continue;
              rows.push(a);
            }
            return rows;
          };
          dsv.format = function(rows) {
            if (Array.isArray(rows[0])) return dsv.formatRows(rows);
            var fieldSet = new d3_Set(), fields = [];
            rows.forEach(function(row) {
              for (var field in row) {
                if (!fieldSet.has(field)) {
                  fields.push(fieldSet.add(field));
                }
              }
            });
            return [fields.map(formatValue).join(delimiter)].concat(rows.map(function(row) {
              return fields.map(function(field) {
                return formatValue(row[field]);
              }).join(delimiter);
            })).join("\n");
          };
          dsv.formatRows = function(rows) {
            return rows.map(formatRow).join("\n");
          };
          function formatRow(row) {
            return row.map(formatValue).join(delimiter);
          }
          function formatValue(text) {
            return reFormat.test(text) ? '"' + text.replace(/\"/g, '""') + '"' : text;
          }
          return dsv;
        };
        d3.csv = d3.dsv(",", "text/csv");
        d3.tsv = d3.dsv("	", "text/tab-separated-values");
        var d3_timer_queueHead, d3_timer_queueTail, d3_timer_interval, d3_timer_timeout, d3_timer_frame = this[d3_vendorSymbol(this, "requestAnimationFrame")] || function(callback) {
          setTimeout(callback, 17);
        };
        d3.timer = function() {
          d3_timer.apply(this, arguments);
        };
        function d3_timer(callback, delay, then) {
          var n = arguments.length;
          if (n < 2) delay = 0;
          if (n < 3) then = Date.now();
          var time = then + delay, timer = {
            c: callback,
            t: time,
            n: null
          };
          if (d3_timer_queueTail) d3_timer_queueTail.n = timer;
          else d3_timer_queueHead = timer;
          d3_timer_queueTail = timer;
          if (!d3_timer_interval) {
            d3_timer_timeout = clearTimeout(d3_timer_timeout);
            d3_timer_interval = 1;
            d3_timer_frame(d3_timer_step);
          }
          return timer;
        }
        function d3_timer_step() {
          var now = d3_timer_mark(), delay = d3_timer_sweep() - now;
          if (delay > 24) {
            if (isFinite(delay)) {
              clearTimeout(d3_timer_timeout);
              d3_timer_timeout = setTimeout(d3_timer_step, delay);
            }
            d3_timer_interval = 0;
          } else {
            d3_timer_interval = 1;
            d3_timer_frame(d3_timer_step);
          }
        }
        d3.timer.flush = function() {
          d3_timer_mark();
          d3_timer_sweep();
        };
        function d3_timer_mark() {
          var now = Date.now(), timer = d3_timer_queueHead;
          while (timer) {
            if (now >= timer.t && timer.c(now - timer.t)) timer.c = null;
            timer = timer.n;
          }
          return now;
        }
        function d3_timer_sweep() {
          var t02, t12 = d3_timer_queueHead, time = Infinity;
          while (t12) {
            if (t12.c) {
              if (t12.t < time) time = t12.t;
              t12 = (t02 = t12).n;
            } else {
              t12 = t02 ? t02.n = t12.n : d3_timer_queueHead = t12.n;
            }
          }
          d3_timer_queueTail = t02;
          return time;
        }
        d3.round = function(x, n) {
          return n ? Math.round(x * (n = Math.pow(10, n))) / n : Math.round(x);
        };
        d3.geom = {};
        function d3_geom_pointX(d) {
          return d[0];
        }
        function d3_geom_pointY(d) {
          return d[1];
        }
        d3.geom.hull = function(vertices) {
          var x = d3_geom_pointX, y = d3_geom_pointY;
          if (arguments.length) return hull(vertices);
          function hull(data) {
            if (data.length < 3) return [];
            var fx = d3_functor(x), fy = d3_functor(y), i, n = data.length, points = [], flippedPoints = [];
            for (i = 0; i < n; i++) {
              points.push([+fx.call(this, data[i], i), +fy.call(this, data[i], i), i]);
            }
            points.sort(d3_geom_hullOrder);
            for (i = 0; i < n; i++) flippedPoints.push([points[i][0], -points[i][1]]);
            var upper = d3_geom_hullUpper(points), lower = d3_geom_hullUpper(flippedPoints);
            var skipLeft = lower[0] === upper[0], skipRight = lower[lower.length - 1] === upper[upper.length - 1], polygon = [];
            for (i = upper.length - 1; i >= 0; --i) polygon.push(data[points[upper[i]][2]]);
            for (i = +skipLeft; i < lower.length - skipRight; ++i) polygon.push(data[points[lower[i]][2]]);
            return polygon;
          }
          hull.x = function(_) {
            return arguments.length ? (x = _, hull) : x;
          };
          hull.y = function(_) {
            return arguments.length ? (y = _, hull) : y;
          };
          return hull;
        };
        function d3_geom_hullUpper(points) {
          var n = points.length, hull = [0, 1], hs = 2;
          for (var i = 2; i < n; i++) {
            while (hs > 1 && d3_cross2d(points[hull[hs - 2]], points[hull[hs - 1]], points[i]) <= 0) --hs;
            hull[hs++] = i;
          }
          return hull.slice(0, hs);
        }
        function d3_geom_hullOrder(a, b) {
          return a[0] - b[0] || a[1] - b[1];
        }
        d3.geom.polygon = function(coordinates) {
          d3_subclass(coordinates, d3_geom_polygonPrototype);
          return coordinates;
        };
        var d3_geom_polygonPrototype = d3.geom.polygon.prototype = [];
        d3_geom_polygonPrototype.area = function() {
          var i = -1, n = this.length, a, b = this[n - 1], area = 0;
          while (++i < n) {
            a = b;
            b = this[i];
            area += a[1] * b[0] - a[0] * b[1];
          }
          return area * 0.5;
        };
        d3_geom_polygonPrototype.centroid = function(k) {
          var i = -1, n = this.length, x = 0, y = 0, a, b = this[n - 1], c;
          if (!arguments.length) k = -1 / (6 * this.area());
          while (++i < n) {
            a = b;
            b = this[i];
            c = a[0] * b[1] - b[0] * a[1];
            x += (a[0] + b[0]) * c;
            y += (a[1] + b[1]) * c;
          }
          return [x * k, y * k];
        };
        d3_geom_polygonPrototype.clip = function(subject) {
          var input, closed = d3_geom_polygonClosed(subject), i = -1, n = this.length - d3_geom_polygonClosed(this), j, m, a = this[n - 1], b, c, d;
          while (++i < n) {
            input = subject.slice();
            subject.length = 0;
            b = this[i];
            c = input[(m = input.length - closed) - 1];
            j = -1;
            while (++j < m) {
              d = input[j];
              if (d3_geom_polygonInside(d, a, b)) {
                if (!d3_geom_polygonInside(c, a, b)) {
                  subject.push(d3_geom_polygonIntersect(c, d, a, b));
                }
                subject.push(d);
              } else if (d3_geom_polygonInside(c, a, b)) {
                subject.push(d3_geom_polygonIntersect(c, d, a, b));
              }
              c = d;
            }
            if (closed) subject.push(subject[0]);
            a = b;
          }
          return subject;
        };
        function d3_geom_polygonInside(p, a, b) {
          return (b[0] - a[0]) * (p[1] - a[1]) < (b[1] - a[1]) * (p[0] - a[0]);
        }
        function d3_geom_polygonIntersect(c, d, a, b) {
          var x1 = c[0], x3 = a[0], x21 = d[0] - x1, x43 = b[0] - x3, y1 = c[1], y3 = a[1], y21 = d[1] - y1, y43 = b[1] - y3, ua = (x43 * (y1 - y3) - y43 * (x1 - x3)) / (y43 * x21 - x43 * y21);
          return [x1 + ua * x21, y1 + ua * y21];
        }
        function d3_geom_polygonClosed(coordinates) {
          var a = coordinates[0], b = coordinates[coordinates.length - 1];
          return !(a[0] - b[0] || a[1] - b[1]);
        }
        var d3_geom_voronoiEdges, d3_geom_voronoiCells, d3_geom_voronoiBeaches, d3_geom_voronoiBeachPool = [], d3_geom_voronoiFirstCircle, d3_geom_voronoiCircles, d3_geom_voronoiCirclePool = [];
        function d3_geom_voronoiBeach() {
          d3_geom_voronoiRedBlackNode(this);
          this.edge = this.site = this.circle = null;
        }
        function d3_geom_voronoiCreateBeach(site) {
          var beach = d3_geom_voronoiBeachPool.pop() || new d3_geom_voronoiBeach();
          beach.site = site;
          return beach;
        }
        function d3_geom_voronoiDetachBeach(beach) {
          d3_geom_voronoiDetachCircle(beach);
          d3_geom_voronoiBeaches.remove(beach);
          d3_geom_voronoiBeachPool.push(beach);
          d3_geom_voronoiRedBlackNode(beach);
        }
        function d3_geom_voronoiRemoveBeach(beach) {
          var circle = beach.circle, x = circle.x, y = circle.cy, vertex = {
            x,
            y
          }, previous = beach.P, next = beach.N, disappearing = [beach];
          d3_geom_voronoiDetachBeach(beach);
          var lArc = previous;
          while (lArc.circle && abs(x - lArc.circle.x) < \u03B5 && abs(y - lArc.circle.cy) < \u03B5) {
            previous = lArc.P;
            disappearing.unshift(lArc);
            d3_geom_voronoiDetachBeach(lArc);
            lArc = previous;
          }
          disappearing.unshift(lArc);
          d3_geom_voronoiDetachCircle(lArc);
          var rArc = next;
          while (rArc.circle && abs(x - rArc.circle.x) < \u03B5 && abs(y - rArc.circle.cy) < \u03B5) {
            next = rArc.N;
            disappearing.push(rArc);
            d3_geom_voronoiDetachBeach(rArc);
            rArc = next;
          }
          disappearing.push(rArc);
          d3_geom_voronoiDetachCircle(rArc);
          var nArcs = disappearing.length, iArc;
          for (iArc = 1; iArc < nArcs; ++iArc) {
            rArc = disappearing[iArc];
            lArc = disappearing[iArc - 1];
            d3_geom_voronoiSetEdgeEnd(rArc.edge, lArc.site, rArc.site, vertex);
          }
          lArc = disappearing[0];
          rArc = disappearing[nArcs - 1];
          rArc.edge = d3_geom_voronoiCreateEdge(lArc.site, rArc.site, null, vertex);
          d3_geom_voronoiAttachCircle(lArc);
          d3_geom_voronoiAttachCircle(rArc);
        }
        function d3_geom_voronoiAddBeach(site) {
          var x = site.x, directrix = site.y, lArc, rArc, dxl, dxr, node = d3_geom_voronoiBeaches._;
          while (node) {
            dxl = d3_geom_voronoiLeftBreakPoint(node, directrix) - x;
            if (dxl > \u03B5) node = node.L;
            else {
              dxr = x - d3_geom_voronoiRightBreakPoint(node, directrix);
              if (dxr > \u03B5) {
                if (!node.R) {
                  lArc = node;
                  break;
                }
                node = node.R;
              } else {
                if (dxl > -\u03B5) {
                  lArc = node.P;
                  rArc = node;
                } else if (dxr > -\u03B5) {
                  lArc = node;
                  rArc = node.N;
                } else {
                  lArc = rArc = node;
                }
                break;
              }
            }
          }
          var newArc = d3_geom_voronoiCreateBeach(site);
          d3_geom_voronoiBeaches.insert(lArc, newArc);
          if (!lArc && !rArc) return;
          if (lArc === rArc) {
            d3_geom_voronoiDetachCircle(lArc);
            rArc = d3_geom_voronoiCreateBeach(lArc.site);
            d3_geom_voronoiBeaches.insert(newArc, rArc);
            newArc.edge = rArc.edge = d3_geom_voronoiCreateEdge(lArc.site, newArc.site);
            d3_geom_voronoiAttachCircle(lArc);
            d3_geom_voronoiAttachCircle(rArc);
            return;
          }
          if (!rArc) {
            newArc.edge = d3_geom_voronoiCreateEdge(lArc.site, newArc.site);
            return;
          }
          d3_geom_voronoiDetachCircle(lArc);
          d3_geom_voronoiDetachCircle(rArc);
          var lSite = lArc.site, ax = lSite.x, ay = lSite.y, bx = site.x - ax, by = site.y - ay, rSite = rArc.site, cx = rSite.x - ax, cy = rSite.y - ay, d = 2 * (bx * cy - by * cx), hb = bx * bx + by * by, hc = cx * cx + cy * cy, vertex = {
            x: (cy * hb - by * hc) / d + ax,
            y: (bx * hc - cx * hb) / d + ay
          };
          d3_geom_voronoiSetEdgeEnd(rArc.edge, lSite, rSite, vertex);
          newArc.edge = d3_geom_voronoiCreateEdge(lSite, site, null, vertex);
          rArc.edge = d3_geom_voronoiCreateEdge(site, rSite, null, vertex);
          d3_geom_voronoiAttachCircle(lArc);
          d3_geom_voronoiAttachCircle(rArc);
        }
        function d3_geom_voronoiLeftBreakPoint(arc, directrix) {
          var site = arc.site, rfocx = site.x, rfocy = site.y, pby2 = rfocy - directrix;
          if (!pby2) return rfocx;
          var lArc = arc.P;
          if (!lArc) return -Infinity;
          site = lArc.site;
          var lfocx = site.x, lfocy = site.y, plby2 = lfocy - directrix;
          if (!plby2) return lfocx;
          var hl = lfocx - rfocx, aby2 = 1 / pby2 - 1 / plby2, b = hl / plby2;
          if (aby2) return (-b + Math.sqrt(b * b - 2 * aby2 * (hl * hl / (-2 * plby2) - lfocy + plby2 / 2 + rfocy - pby2 / 2))) / aby2 + rfocx;
          return (rfocx + lfocx) / 2;
        }
        function d3_geom_voronoiRightBreakPoint(arc, directrix) {
          var rArc = arc.N;
          if (rArc) return d3_geom_voronoiLeftBreakPoint(rArc, directrix);
          var site = arc.site;
          return site.y === directrix ? site.x : Infinity;
        }
        function d3_geom_voronoiCell(site) {
          this.site = site;
          this.edges = [];
        }
        d3_geom_voronoiCell.prototype.prepare = function() {
          var halfEdges = this.edges, iHalfEdge = halfEdges.length, edge;
          while (iHalfEdge--) {
            edge = halfEdges[iHalfEdge].edge;
            if (!edge.b || !edge.a) halfEdges.splice(iHalfEdge, 1);
          }
          halfEdges.sort(d3_geom_voronoiHalfEdgeOrder);
          return halfEdges.length;
        };
        function d3_geom_voronoiCloseCells(extent) {
          var x0 = extent[0][0], x1 = extent[1][0], y0 = extent[0][1], y1 = extent[1][1], x2, y2, x3, y3, cells = d3_geom_voronoiCells, iCell = cells.length, cell, iHalfEdge, halfEdges, nHalfEdges, start, end;
          while (iCell--) {
            cell = cells[iCell];
            if (!cell || !cell.prepare()) continue;
            halfEdges = cell.edges;
            nHalfEdges = halfEdges.length;
            iHalfEdge = 0;
            while (iHalfEdge < nHalfEdges) {
              end = halfEdges[iHalfEdge].end(), x3 = end.x, y3 = end.y;
              start = halfEdges[++iHalfEdge % nHalfEdges].start(), x2 = start.x, y2 = start.y;
              if (abs(x3 - x2) > \u03B5 || abs(y3 - y2) > \u03B5) {
                halfEdges.splice(iHalfEdge, 0, new d3_geom_voronoiHalfEdge(d3_geom_voronoiCreateBorderEdge(cell.site, end, abs(x3 - x0) < \u03B5 && y1 - y3 > \u03B5 ? {
                  x: x0,
                  y: abs(x2 - x0) < \u03B5 ? y2 : y1
                } : abs(y3 - y1) < \u03B5 && x1 - x3 > \u03B5 ? {
                  x: abs(y2 - y1) < \u03B5 ? x2 : x1,
                  y: y1
                } : abs(x3 - x1) < \u03B5 && y3 - y0 > \u03B5 ? {
                  x: x1,
                  y: abs(x2 - x1) < \u03B5 ? y2 : y0
                } : abs(y3 - y0) < \u03B5 && x3 - x0 > \u03B5 ? {
                  x: abs(y2 - y0) < \u03B5 ? x2 : x0,
                  y: y0
                } : null), cell.site, null));
                ++nHalfEdges;
              }
            }
          }
        }
        function d3_geom_voronoiHalfEdgeOrder(a, b) {
          return b.angle - a.angle;
        }
        function d3_geom_voronoiCircle() {
          d3_geom_voronoiRedBlackNode(this);
          this.x = this.y = this.arc = this.site = this.cy = null;
        }
        function d3_geom_voronoiAttachCircle(arc) {
          var lArc = arc.P, rArc = arc.N;
          if (!lArc || !rArc) return;
          var lSite = lArc.site, cSite = arc.site, rSite = rArc.site;
          if (lSite === rSite) return;
          var bx = cSite.x, by = cSite.y, ax = lSite.x - bx, ay = lSite.y - by, cx = rSite.x - bx, cy = rSite.y - by;
          var d = 2 * (ax * cy - ay * cx);
          if (d >= -\u03B52) return;
          var ha = ax * ax + ay * ay, hc = cx * cx + cy * cy, x = (cy * ha - ay * hc) / d, y = (ax * hc - cx * ha) / d, cy = y + by;
          var circle = d3_geom_voronoiCirclePool.pop() || new d3_geom_voronoiCircle();
          circle.arc = arc;
          circle.site = cSite;
          circle.x = x + bx;
          circle.y = cy + Math.sqrt(x * x + y * y);
          circle.cy = cy;
          arc.circle = circle;
          var before = null, node = d3_geom_voronoiCircles._;
          while (node) {
            if (circle.y < node.y || circle.y === node.y && circle.x <= node.x) {
              if (node.L) node = node.L;
              else {
                before = node.P;
                break;
              }
            } else {
              if (node.R) node = node.R;
              else {
                before = node;
                break;
              }
            }
          }
          d3_geom_voronoiCircles.insert(before, circle);
          if (!before) d3_geom_voronoiFirstCircle = circle;
        }
        function d3_geom_voronoiDetachCircle(arc) {
          var circle = arc.circle;
          if (circle) {
            if (!circle.P) d3_geom_voronoiFirstCircle = circle.N;
            d3_geom_voronoiCircles.remove(circle);
            d3_geom_voronoiCirclePool.push(circle);
            d3_geom_voronoiRedBlackNode(circle);
            arc.circle = null;
          }
        }
        function d3_geom_clipLine(x0, y0, x1, y1) {
          return function(line) {
            var a = line.a, b = line.b, ax = a.x, ay = a.y, bx = b.x, by = b.y, t02 = 0, t12 = 1, dx = bx - ax, dy = by - ay, r;
            r = x0 - ax;
            if (!dx && r > 0) return;
            r /= dx;
            if (dx < 0) {
              if (r < t02) return;
              if (r < t12) t12 = r;
            } else if (dx > 0) {
              if (r > t12) return;
              if (r > t02) t02 = r;
            }
            r = x1 - ax;
            if (!dx && r < 0) return;
            r /= dx;
            if (dx < 0) {
              if (r > t12) return;
              if (r > t02) t02 = r;
            } else if (dx > 0) {
              if (r < t02) return;
              if (r < t12) t12 = r;
            }
            r = y0 - ay;
            if (!dy && r > 0) return;
            r /= dy;
            if (dy < 0) {
              if (r < t02) return;
              if (r < t12) t12 = r;
            } else if (dy > 0) {
              if (r > t12) return;
              if (r > t02) t02 = r;
            }
            r = y1 - ay;
            if (!dy && r < 0) return;
            r /= dy;
            if (dy < 0) {
              if (r > t12) return;
              if (r > t02) t02 = r;
            } else if (dy > 0) {
              if (r < t02) return;
              if (r < t12) t12 = r;
            }
            if (t02 > 0) line.a = {
              x: ax + t02 * dx,
              y: ay + t02 * dy
            };
            if (t12 < 1) line.b = {
              x: ax + t12 * dx,
              y: ay + t12 * dy
            };
            return line;
          };
        }
        function d3_geom_voronoiClipEdges(extent) {
          var edges = d3_geom_voronoiEdges, clip = d3_geom_clipLine(extent[0][0], extent[0][1], extent[1][0], extent[1][1]), i = edges.length, e;
          while (i--) {
            e = edges[i];
            if (!d3_geom_voronoiConnectEdge(e, extent) || !clip(e) || abs(e.a.x - e.b.x) < \u03B5 && abs(e.a.y - e.b.y) < \u03B5) {
              e.a = e.b = null;
              edges.splice(i, 1);
            }
          }
        }
        function d3_geom_voronoiConnectEdge(edge, extent) {
          var vb = edge.b;
          if (vb) return true;
          var va = edge.a, x0 = extent[0][0], x1 = extent[1][0], y0 = extent[0][1], y1 = extent[1][1], lSite = edge.l, rSite = edge.r, lx = lSite.x, ly = lSite.y, rx = rSite.x, ry = rSite.y, fx = (lx + rx) / 2, fy = (ly + ry) / 2, fm, fb;
          if (ry === ly) {
            if (fx < x0 || fx >= x1) return;
            if (lx > rx) {
              if (!va) va = {
                x: fx,
                y: y0
              };
              else if (va.y >= y1) return;
              vb = {
                x: fx,
                y: y1
              };
            } else {
              if (!va) va = {
                x: fx,
                y: y1
              };
              else if (va.y < y0) return;
              vb = {
                x: fx,
                y: y0
              };
            }
          } else {
            fm = (lx - rx) / (ry - ly);
            fb = fy - fm * fx;
            if (fm < -1 || fm > 1) {
              if (lx > rx) {
                if (!va) va = {
                  x: (y0 - fb) / fm,
                  y: y0
                };
                else if (va.y >= y1) return;
                vb = {
                  x: (y1 - fb) / fm,
                  y: y1
                };
              } else {
                if (!va) va = {
                  x: (y1 - fb) / fm,
                  y: y1
                };
                else if (va.y < y0) return;
                vb = {
                  x: (y0 - fb) / fm,
                  y: y0
                };
              }
            } else {
              if (ly < ry) {
                if (!va) va = {
                  x: x0,
                  y: fm * x0 + fb
                };
                else if (va.x >= x1) return;
                vb = {
                  x: x1,
                  y: fm * x1 + fb
                };
              } else {
                if (!va) va = {
                  x: x1,
                  y: fm * x1 + fb
                };
                else if (va.x < x0) return;
                vb = {
                  x: x0,
                  y: fm * x0 + fb
                };
              }
            }
          }
          edge.a = va;
          edge.b = vb;
          return true;
        }
        function d3_geom_voronoiEdge(lSite, rSite) {
          this.l = lSite;
          this.r = rSite;
          this.a = this.b = null;
        }
        function d3_geom_voronoiCreateEdge(lSite, rSite, va, vb) {
          var edge = new d3_geom_voronoiEdge(lSite, rSite);
          d3_geom_voronoiEdges.push(edge);
          if (va) d3_geom_voronoiSetEdgeEnd(edge, lSite, rSite, va);
          if (vb) d3_geom_voronoiSetEdgeEnd(edge, rSite, lSite, vb);
          d3_geom_voronoiCells[lSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge, lSite, rSite));
          d3_geom_voronoiCells[rSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge, rSite, lSite));
          return edge;
        }
        function d3_geom_voronoiCreateBorderEdge(lSite, va, vb) {
          var edge = new d3_geom_voronoiEdge(lSite, null);
          edge.a = va;
          edge.b = vb;
          d3_geom_voronoiEdges.push(edge);
          return edge;
        }
        function d3_geom_voronoiSetEdgeEnd(edge, lSite, rSite, vertex) {
          if (!edge.a && !edge.b) {
            edge.a = vertex;
            edge.l = lSite;
            edge.r = rSite;
          } else if (edge.l === rSite) {
            edge.b = vertex;
          } else {
            edge.a = vertex;
          }
        }
        function d3_geom_voronoiHalfEdge(edge, lSite, rSite) {
          var va = edge.a, vb = edge.b;
          this.edge = edge;
          this.site = lSite;
          this.angle = rSite ? Math.atan2(rSite.y - lSite.y, rSite.x - lSite.x) : edge.l === lSite ? Math.atan2(vb.x - va.x, va.y - vb.y) : Math.atan2(va.x - vb.x, vb.y - va.y);
        }
        d3_geom_voronoiHalfEdge.prototype = {
          start: function() {
            return this.edge.l === this.site ? this.edge.a : this.edge.b;
          },
          end: function() {
            return this.edge.l === this.site ? this.edge.b : this.edge.a;
          }
        };
        function d3_geom_voronoiRedBlackTree() {
          this._ = null;
        }
        function d3_geom_voronoiRedBlackNode(node) {
          node.U = node.C = node.L = node.R = node.P = node.N = null;
        }
        d3_geom_voronoiRedBlackTree.prototype = {
          insert: function(after, node) {
            var parent, grandpa, uncle;
            if (after) {
              node.P = after;
              node.N = after.N;
              if (after.N) after.N.P = node;
              after.N = node;
              if (after.R) {
                after = after.R;
                while (after.L) after = after.L;
                after.L = node;
              } else {
                after.R = node;
              }
              parent = after;
            } else if (this._) {
              after = d3_geom_voronoiRedBlackFirst(this._);
              node.P = null;
              node.N = after;
              after.P = after.L = node;
              parent = after;
            } else {
              node.P = node.N = null;
              this._ = node;
              parent = null;
            }
            node.L = node.R = null;
            node.U = parent;
            node.C = true;
            after = node;
            while (parent && parent.C) {
              grandpa = parent.U;
              if (parent === grandpa.L) {
                uncle = grandpa.R;
                if (uncle && uncle.C) {
                  parent.C = uncle.C = false;
                  grandpa.C = true;
                  after = grandpa;
                } else {
                  if (after === parent.R) {
                    d3_geom_voronoiRedBlackRotateLeft(this, parent);
                    after = parent;
                    parent = after.U;
                  }
                  parent.C = false;
                  grandpa.C = true;
                  d3_geom_voronoiRedBlackRotateRight(this, grandpa);
                }
              } else {
                uncle = grandpa.L;
                if (uncle && uncle.C) {
                  parent.C = uncle.C = false;
                  grandpa.C = true;
                  after = grandpa;
                } else {
                  if (after === parent.L) {
                    d3_geom_voronoiRedBlackRotateRight(this, parent);
                    after = parent;
                    parent = after.U;
                  }
                  parent.C = false;
                  grandpa.C = true;
                  d3_geom_voronoiRedBlackRotateLeft(this, grandpa);
                }
              }
              parent = after.U;
            }
            this._.C = false;
          },
          remove: function(node) {
            if (node.N) node.N.P = node.P;
            if (node.P) node.P.N = node.N;
            node.N = node.P = null;
            var parent = node.U, sibling, left = node.L, right = node.R, next, red;
            if (!left) next = right;
            else if (!right) next = left;
            else next = d3_geom_voronoiRedBlackFirst(right);
            if (parent) {
              if (parent.L === node) parent.L = next;
              else parent.R = next;
            } else {
              this._ = next;
            }
            if (left && right) {
              red = next.C;
              next.C = node.C;
              next.L = left;
              left.U = next;
              if (next !== right) {
                parent = next.U;
                next.U = node.U;
                node = next.R;
                parent.L = node;
                next.R = right;
                right.U = next;
              } else {
                next.U = parent;
                parent = next;
                node = next.R;
              }
            } else {
              red = node.C;
              node = next;
            }
            if (node) node.U = parent;
            if (red) return;
            if (node && node.C) {
              node.C = false;
              return;
            }
            do {
              if (node === this._) break;
              if (node === parent.L) {
                sibling = parent.R;
                if (sibling.C) {
                  sibling.C = false;
                  parent.C = true;
                  d3_geom_voronoiRedBlackRotateLeft(this, parent);
                  sibling = parent.R;
                }
                if (sibling.L && sibling.L.C || sibling.R && sibling.R.C) {
                  if (!sibling.R || !sibling.R.C) {
                    sibling.L.C = false;
                    sibling.C = true;
                    d3_geom_voronoiRedBlackRotateRight(this, sibling);
                    sibling = parent.R;
                  }
                  sibling.C = parent.C;
                  parent.C = sibling.R.C = false;
                  d3_geom_voronoiRedBlackRotateLeft(this, parent);
                  node = this._;
                  break;
                }
              } else {
                sibling = parent.L;
                if (sibling.C) {
                  sibling.C = false;
                  parent.C = true;
                  d3_geom_voronoiRedBlackRotateRight(this, parent);
                  sibling = parent.L;
                }
                if (sibling.L && sibling.L.C || sibling.R && sibling.R.C) {
                  if (!sibling.L || !sibling.L.C) {
                    sibling.R.C = false;
                    sibling.C = true;
                    d3_geom_voronoiRedBlackRotateLeft(this, sibling);
                    sibling = parent.L;
                  }
                  sibling.C = parent.C;
                  parent.C = sibling.L.C = false;
                  d3_geom_voronoiRedBlackRotateRight(this, parent);
                  node = this._;
                  break;
                }
              }
              sibling.C = true;
              node = parent;
              parent = parent.U;
            } while (!node.C);
            if (node) node.C = false;
          }
        };
        function d3_geom_voronoiRedBlackRotateLeft(tree, node) {
          var p = node, q = node.R, parent = p.U;
          if (parent) {
            if (parent.L === p) parent.L = q;
            else parent.R = q;
          } else {
            tree._ = q;
          }
          q.U = parent;
          p.U = q;
          p.R = q.L;
          if (p.R) p.R.U = p;
          q.L = p;
        }
        function d3_geom_voronoiRedBlackRotateRight(tree, node) {
          var p = node, q = node.L, parent = p.U;
          if (parent) {
            if (parent.L === p) parent.L = q;
            else parent.R = q;
          } else {
            tree._ = q;
          }
          q.U = parent;
          p.U = q;
          p.L = q.R;
          if (p.L) p.L.U = p;
          q.R = p;
        }
        function d3_geom_voronoiRedBlackFirst(node) {
          while (node.L) node = node.L;
          return node;
        }
        function d3_geom_voronoi(sites, bbox) {
          var site = sites.sort(d3_geom_voronoiVertexOrder).pop(), x0, y0, circle;
          d3_geom_voronoiEdges = [];
          d3_geom_voronoiCells = new Array(sites.length);
          d3_geom_voronoiBeaches = new d3_geom_voronoiRedBlackTree();
          d3_geom_voronoiCircles = new d3_geom_voronoiRedBlackTree();
          while (true) {
            circle = d3_geom_voronoiFirstCircle;
            if (site && (!circle || site.y < circle.y || site.y === circle.y && site.x < circle.x)) {
              if (site.x !== x0 || site.y !== y0) {
                d3_geom_voronoiCells[site.i] = new d3_geom_voronoiCell(site);
                d3_geom_voronoiAddBeach(site);
                x0 = site.x, y0 = site.y;
              }
              site = sites.pop();
            } else if (circle) {
              d3_geom_voronoiRemoveBeach(circle.arc);
            } else {
              break;
            }
          }
          if (bbox) d3_geom_voronoiClipEdges(bbox), d3_geom_voronoiCloseCells(bbox);
          var diagram = {
            cells: d3_geom_voronoiCells,
            edges: d3_geom_voronoiEdges
          };
          d3_geom_voronoiBeaches = d3_geom_voronoiCircles = d3_geom_voronoiEdges = d3_geom_voronoiCells = null;
          return diagram;
        }
        function d3_geom_voronoiVertexOrder(a, b) {
          return b.y - a.y || b.x - a.x;
        }
        d3.geom.voronoi = function(points) {
          var x = d3_geom_pointX, y = d3_geom_pointY, fx = x, fy = y, clipExtent = d3_geom_voronoiClipExtent;
          if (points) return voronoi(points);
          function voronoi(data) {
            var polygons = new Array(data.length), x0 = clipExtent[0][0], y0 = clipExtent[0][1], x1 = clipExtent[1][0], y1 = clipExtent[1][1];
            d3_geom_voronoi(sites(data), clipExtent).cells.forEach(function(cell, i) {
              var edges = cell.edges, site = cell.site, polygon = polygons[i] = edges.length ? edges.map(function(e) {
                var s = e.start();
                return [s.x, s.y];
              }) : site.x >= x0 && site.x <= x1 && site.y >= y0 && site.y <= y1 ? [[x0, y1], [x1, y1], [x1, y0], [x0, y0]] : [];
              polygon.point = data[i];
            });
            return polygons;
          }
          function sites(data) {
            return data.map(function(d, i) {
              return {
                x: Math.round(fx(d, i) / \u03B5) * \u03B5,
                y: Math.round(fy(d, i) / \u03B5) * \u03B5,
                i
              };
            });
          }
          voronoi.links = function(data) {
            return d3_geom_voronoi(sites(data)).edges.filter(function(edge) {
              return edge.l && edge.r;
            }).map(function(edge) {
              return {
                source: data[edge.l.i],
                target: data[edge.r.i]
              };
            });
          };
          voronoi.triangles = function(data) {
            var triangles = [];
            d3_geom_voronoi(sites(data)).cells.forEach(function(cell, i) {
              var site = cell.site, edges = cell.edges.sort(d3_geom_voronoiHalfEdgeOrder), j = -1, m = edges.length, e0, s0, e1 = edges[m - 1].edge, s1 = e1.l === site ? e1.r : e1.l;
              while (++j < m) {
                e0 = e1;
                s0 = s1;
                e1 = edges[j].edge;
                s1 = e1.l === site ? e1.r : e1.l;
                if (i < s0.i && i < s1.i && d3_geom_voronoiTriangleArea(site, s0, s1) < 0) {
                  triangles.push([data[i], data[s0.i], data[s1.i]]);
                }
              }
            });
            return triangles;
          };
          voronoi.x = function(_) {
            return arguments.length ? (fx = d3_functor(x = _), voronoi) : x;
          };
          voronoi.y = function(_) {
            return arguments.length ? (fy = d3_functor(y = _), voronoi) : y;
          };
          voronoi.clipExtent = function(_) {
            if (!arguments.length) return clipExtent === d3_geom_voronoiClipExtent ? null : clipExtent;
            clipExtent = _ == null ? d3_geom_voronoiClipExtent : _;
            return voronoi;
          };
          voronoi.size = function(_) {
            if (!arguments.length) return clipExtent === d3_geom_voronoiClipExtent ? null : clipExtent && clipExtent[1];
            return voronoi.clipExtent(_ && [[0, 0], _]);
          };
          return voronoi;
        };
        var d3_geom_voronoiClipExtent = [[-1e6, -1e6], [1e6, 1e6]];
        function d3_geom_voronoiTriangleArea(a, b, c) {
          return (a.x - c.x) * (b.y - a.y) - (a.x - b.x) * (c.y - a.y);
        }
        d3.geom.delaunay = function(vertices) {
          return d3.geom.voronoi().triangles(vertices);
        };
        d3.geom.quadtree = function(points, x1, y1, x2, y2) {
          var x = d3_geom_pointX, y = d3_geom_pointY, compat;
          if (compat = arguments.length) {
            x = d3_geom_quadtreeCompatX;
            y = d3_geom_quadtreeCompatY;
            if (compat === 3) {
              y2 = y1;
              x2 = x1;
              y1 = x1 = 0;
            }
            return quadtree(points);
          }
          function quadtree(data) {
            var d, fx = d3_functor(x), fy = d3_functor(y), xs, ys, i, n, x1_, y1_, x2_, y2_;
            if (x1 != null) {
              x1_ = x1, y1_ = y1, x2_ = x2, y2_ = y2;
            } else {
              x2_ = y2_ = -(x1_ = y1_ = Infinity);
              xs = [], ys = [];
              n = data.length;
              if (compat) for (i = 0; i < n; ++i) {
                d = data[i];
                if (d.x < x1_) x1_ = d.x;
                if (d.y < y1_) y1_ = d.y;
                if (d.x > x2_) x2_ = d.x;
                if (d.y > y2_) y2_ = d.y;
                xs.push(d.x);
                ys.push(d.y);
              }
              else for (i = 0; i < n; ++i) {
                var x_ = +fx(d = data[i], i), y_ = +fy(d, i);
                if (x_ < x1_) x1_ = x_;
                if (y_ < y1_) y1_ = y_;
                if (x_ > x2_) x2_ = x_;
                if (y_ > y2_) y2_ = y_;
                xs.push(x_);
                ys.push(y_);
              }
            }
            var dx = x2_ - x1_, dy = y2_ - y1_;
            if (dx > dy) y2_ = y1_ + dx;
            else x2_ = x1_ + dy;
            function insert(n2, d2, x3, y3, x12, y12, x22, y22) {
              if (isNaN(x3) || isNaN(y3)) return;
              if (n2.leaf) {
                var nx = n2.x, ny = n2.y;
                if (nx != null) {
                  if (abs(nx - x3) + abs(ny - y3) < 0.01) {
                    insertChild(n2, d2, x3, y3, x12, y12, x22, y22);
                  } else {
                    var nPoint = n2.point;
                    n2.x = n2.y = n2.point = null;
                    insertChild(n2, nPoint, nx, ny, x12, y12, x22, y22);
                    insertChild(n2, d2, x3, y3, x12, y12, x22, y22);
                  }
                } else {
                  n2.x = x3, n2.y = y3, n2.point = d2;
                }
              } else {
                insertChild(n2, d2, x3, y3, x12, y12, x22, y22);
              }
            }
            function insertChild(n2, d2, x3, y3, x12, y12, x22, y22) {
              var xm = (x12 + x22) * 0.5, ym = (y12 + y22) * 0.5, right = x3 >= xm, below = y3 >= ym, i2 = below << 1 | right;
              n2.leaf = false;
              n2 = n2.nodes[i2] || (n2.nodes[i2] = d3_geom_quadtreeNode());
              if (right) x12 = xm;
              else x22 = xm;
              if (below) y12 = ym;
              else y22 = ym;
              insert(n2, d2, x3, y3, x12, y12, x22, y22);
            }
            var root = d3_geom_quadtreeNode();
            root.add = function(d2) {
              insert(root, d2, +fx(d2, ++i), +fy(d2, i), x1_, y1_, x2_, y2_);
            };
            root.visit = function(f) {
              d3_geom_quadtreeVisit(f, root, x1_, y1_, x2_, y2_);
            };
            root.find = function(point) {
              return d3_geom_quadtreeFind(root, point[0], point[1], x1_, y1_, x2_, y2_);
            };
            i = -1;
            if (x1 == null) {
              while (++i < n) {
                insert(root, data[i], xs[i], ys[i], x1_, y1_, x2_, y2_);
              }
              --i;
            } else data.forEach(root.add);
            xs = ys = data = d = null;
            return root;
          }
          quadtree.x = function(_) {
            return arguments.length ? (x = _, quadtree) : x;
          };
          quadtree.y = function(_) {
            return arguments.length ? (y = _, quadtree) : y;
          };
          quadtree.extent = function(_) {
            if (!arguments.length) return x1 == null ? null : [[x1, y1], [x2, y2]];
            if (_ == null) x1 = y1 = x2 = y2 = null;
            else x1 = +_[0][0], y1 = +_[0][1], x2 = +_[1][0], y2 = +_[1][1];
            return quadtree;
          };
          quadtree.size = function(_) {
            if (!arguments.length) return x1 == null ? null : [x2 - x1, y2 - y1];
            if (_ == null) x1 = y1 = x2 = y2 = null;
            else x1 = y1 = 0, x2 = +_[0], y2 = +_[1];
            return quadtree;
          };
          return quadtree;
        };
        function d3_geom_quadtreeCompatX(d) {
          return d.x;
        }
        function d3_geom_quadtreeCompatY(d) {
          return d.y;
        }
        function d3_geom_quadtreeNode() {
          return {
            leaf: true,
            nodes: [],
            point: null,
            x: null,
            y: null
          };
        }
        function d3_geom_quadtreeVisit(f, node, x1, y1, x2, y2) {
          if (!f(node, x1, y1, x2, y2)) {
            var sx = (x1 + x2) * 0.5, sy = (y1 + y2) * 0.5, children = node.nodes;
            if (children[0]) d3_geom_quadtreeVisit(f, children[0], x1, y1, sx, sy);
            if (children[1]) d3_geom_quadtreeVisit(f, children[1], sx, y1, x2, sy);
            if (children[2]) d3_geom_quadtreeVisit(f, children[2], x1, sy, sx, y2);
            if (children[3]) d3_geom_quadtreeVisit(f, children[3], sx, sy, x2, y2);
          }
        }
        function d3_geom_quadtreeFind(root, x, y, x0, y0, x3, y3) {
          var minDistance2 = Infinity, closestPoint;
          (function find(node, x1, y1, x2, y2) {
            if (x1 > x3 || y1 > y3 || x2 < x0 || y2 < y0) return;
            if (point = node.point) {
              var point, dx = x - node.x, dy = y - node.y, distance2 = dx * dx + dy * dy;
              if (distance2 < minDistance2) {
                var distance = Math.sqrt(minDistance2 = distance2);
                x0 = x - distance, y0 = y - distance;
                x3 = x + distance, y3 = y + distance;
                closestPoint = point;
              }
            }
            var children = node.nodes, xm = (x1 + x2) * 0.5, ym = (y1 + y2) * 0.5, right = x >= xm, below = y >= ym;
            for (var i = below << 1 | right, j = i + 4; i < j; ++i) {
              if (node = children[i & 3]) switch (i & 3) {
                case 0:
                  find(node, x1, y1, xm, ym);
                  break;
                case 1:
                  find(node, xm, y1, x2, ym);
                  break;
                case 2:
                  find(node, x1, ym, xm, y2);
                  break;
                case 3:
                  find(node, xm, ym, x2, y2);
                  break;
              }
            }
          })(root, x0, y0, x3, y3);
          return closestPoint;
        }
        d3.interpolateRgb = d3_interpolateRgb;
        function d3_interpolateRgb(a, b) {
          a = d3.rgb(a);
          b = d3.rgb(b);
          var ar = a.r, ag = a.g, ab = a.b, br = b.r - ar, bg = b.g - ag, bb = b.b - ab;
          return function(t) {
            return "#" + d3_rgb_hex(Math.round(ar + br * t)) + d3_rgb_hex(Math.round(ag + bg * t)) + d3_rgb_hex(Math.round(ab + bb * t));
          };
        }
        d3.interpolateObject = d3_interpolateObject;
        function d3_interpolateObject(a, b) {
          var i = {}, c = {}, k;
          for (k in a) {
            if (k in b) {
              i[k] = d3_interpolate(a[k], b[k]);
            } else {
              c[k] = a[k];
            }
          }
          for (k in b) {
            if (!(k in a)) {
              c[k] = b[k];
            }
          }
          return function(t) {
            for (k in i) c[k] = i[k](t);
            return c;
          };
        }
        d3.interpolateNumber = d3_interpolateNumber;
        function d3_interpolateNumber(a, b) {
          a = +a, b = +b;
          return function(t) {
            return a * (1 - t) + b * t;
          };
        }
        d3.interpolateString = d3_interpolateString;
        function d3_interpolateString(a, b) {
          var bi = d3_interpolate_numberA.lastIndex = d3_interpolate_numberB.lastIndex = 0, am, bm, bs, i = -1, s = [], q = [];
          a = a + "", b = b + "";
          while ((am = d3_interpolate_numberA.exec(a)) && (bm = d3_interpolate_numberB.exec(b))) {
            if ((bs = bm.index) > bi) {
              bs = b.slice(bi, bs);
              if (s[i]) s[i] += bs;
              else s[++i] = bs;
            }
            if ((am = am[0]) === (bm = bm[0])) {
              if (s[i]) s[i] += bm;
              else s[++i] = bm;
            } else {
              s[++i] = null;
              q.push({
                i,
                x: d3_interpolateNumber(am, bm)
              });
            }
            bi = d3_interpolate_numberB.lastIndex;
          }
          if (bi < b.length) {
            bs = b.slice(bi);
            if (s[i]) s[i] += bs;
            else s[++i] = bs;
          }
          return s.length < 2 ? q[0] ? (b = q[0].x, function(t) {
            return b(t) + "";
          }) : function() {
            return b;
          } : (b = q.length, function(t) {
            for (var i2 = 0, o; i2 < b; ++i2) s[(o = q[i2]).i] = o.x(t);
            return s.join("");
          });
        }
        var d3_interpolate_numberA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, d3_interpolate_numberB = new RegExp(d3_interpolate_numberA.source, "g");
        d3.interpolate = d3_interpolate;
        function d3_interpolate(a, b) {
          var i = d3.interpolators.length, f;
          while (--i >= 0 && !(f = d3.interpolators[i](a, b))) ;
          return f;
        }
        d3.interpolators = [function(a, b) {
          var t = typeof b;
          return (t === "string" ? d3_rgb_names.has(b.toLowerCase()) || /^(#|rgb\(|hsl\()/i.test(b) ? d3_interpolateRgb : d3_interpolateString : b instanceof d3_color ? d3_interpolateRgb : Array.isArray(b) ? d3_interpolateArray : t === "object" && isNaN(b) ? d3_interpolateObject : d3_interpolateNumber)(a, b);
        }];
        d3.interpolateArray = d3_interpolateArray;
        function d3_interpolateArray(a, b) {
          var x = [], c = [], na = a.length, nb = b.length, n0 = Math.min(a.length, b.length), i;
          for (i = 0; i < n0; ++i) x.push(d3_interpolate(a[i], b[i]));
          for (; i < na; ++i) c[i] = a[i];
          for (; i < nb; ++i) c[i] = b[i];
          return function(t) {
            for (i = 0; i < n0; ++i) c[i] = x[i](t);
            return c;
          };
        }
        var d3_ease_default = function() {
          return d3_identity;
        };
        var d3_ease = d3.map({
          linear: d3_ease_default,
          poly: d3_ease_poly,
          quad: function() {
            return d3_ease_quad;
          },
          cubic: function() {
            return d3_ease_cubic;
          },
          sin: function() {
            return d3_ease_sin;
          },
          exp: function() {
            return d3_ease_exp;
          },
          circle: function() {
            return d3_ease_circle;
          },
          elastic: d3_ease_elastic,
          back: d3_ease_back,
          bounce: function() {
            return d3_ease_bounce;
          }
        });
        var d3_ease_mode = d3.map({
          "in": d3_identity,
          out: d3_ease_reverse,
          "in-out": d3_ease_reflect,
          "out-in": function(f) {
            return d3_ease_reflect(d3_ease_reverse(f));
          }
        });
        d3.ease = function(name2) {
          var i = name2.indexOf("-"), t = i >= 0 ? name2.slice(0, i) : name2, m = i >= 0 ? name2.slice(i + 1) : "in";
          t = d3_ease.get(t) || d3_ease_default;
          m = d3_ease_mode.get(m) || d3_identity;
          return d3_ease_clamp(m(t.apply(null, d3_arraySlice.call(arguments, 1))));
        };
        function d3_ease_clamp(f) {
          return function(t) {
            return t <= 0 ? 0 : t >= 1 ? 1 : f(t);
          };
        }
        function d3_ease_reverse(f) {
          return function(t) {
            return 1 - f(1 - t);
          };
        }
        function d3_ease_reflect(f) {
          return function(t) {
            return 0.5 * (t < 0.5 ? f(2 * t) : 2 - f(2 - 2 * t));
          };
        }
        function d3_ease_quad(t) {
          return t * t;
        }
        function d3_ease_cubic(t) {
          return t * t * t;
        }
        function d3_ease_cubicInOut(t) {
          if (t <= 0) return 0;
          if (t >= 1) return 1;
          var t22 = t * t, t32 = t22 * t;
          return 4 * (t < 0.5 ? t32 : 3 * (t - t22) + t32 - 0.75);
        }
        function d3_ease_poly(e) {
          return function(t) {
            return Math.pow(t, e);
          };
        }
        function d3_ease_sin(t) {
          return 1 - Math.cos(t * half\u03C0);
        }
        function d3_ease_exp(t) {
          return Math.pow(2, 10 * (t - 1));
        }
        function d3_ease_circle(t) {
          return 1 - Math.sqrt(1 - t * t);
        }
        function d3_ease_elastic(a, p) {
          var s;
          if (arguments.length < 2) p = 0.45;
          if (arguments.length) s = p / \u03C4 * Math.asin(1 / a);
          else a = 1, s = p / 4;
          return function(t) {
            return 1 + a * Math.pow(2, -10 * t) * Math.sin((t - s) * \u03C4 / p);
          };
        }
        function d3_ease_back(s) {
          if (!s) s = 1.70158;
          return function(t) {
            return t * t * ((s + 1) * t - s);
          };
        }
        function d3_ease_bounce(t) {
          return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + 0.75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + 0.9375 : 7.5625 * (t -= 2.625 / 2.75) * t + 0.984375;
        }
        d3.interpolateHcl = d3_interpolateHcl;
        function d3_interpolateHcl(a, b) {
          a = d3.hcl(a);
          b = d3.hcl(b);
          var ah = a.h, ac = a.c, al = a.l, bh = b.h - ah, bc = b.c - ac, bl = b.l - al;
          if (isNaN(bc)) bc = 0, ac = isNaN(ac) ? b.c : ac;
          if (isNaN(bh)) bh = 0, ah = isNaN(ah) ? b.h : ah;
          else if (bh > 180) bh -= 360;
          else if (bh < -180) bh += 360;
          return function(t) {
            return d3_hcl_lab(ah + bh * t, ac + bc * t, al + bl * t) + "";
          };
        }
        d3.interpolateHsl = d3_interpolateHsl;
        function d3_interpolateHsl(a, b) {
          a = d3.hsl(a);
          b = d3.hsl(b);
          var ah = a.h, as = a.s, al = a.l, bh = b.h - ah, bs = b.s - as, bl = b.l - al;
          if (isNaN(bs)) bs = 0, as = isNaN(as) ? b.s : as;
          if (isNaN(bh)) bh = 0, ah = isNaN(ah) ? b.h : ah;
          else if (bh > 180) bh -= 360;
          else if (bh < -180) bh += 360;
          return function(t) {
            return d3_hsl_rgb(ah + bh * t, as + bs * t, al + bl * t) + "";
          };
        }
        d3.interpolateLab = d3_interpolateLab;
        function d3_interpolateLab(a, b) {
          a = d3.lab(a);
          b = d3.lab(b);
          var al = a.l, aa = a.a, ab = a.b, bl = b.l - al, ba = b.a - aa, bb = b.b - ab;
          return function(t) {
            return d3_lab_rgb(al + bl * t, aa + ba * t, ab + bb * t) + "";
          };
        }
        d3.interpolateRound = d3_interpolateRound;
        function d3_interpolateRound(a, b) {
          b -= a;
          return function(t) {
            return Math.round(a + b * t);
          };
        }
        d3.transform = function(string) {
          var g = d3_document.createElementNS(d3.ns.prefix.svg, "g");
          return (d3.transform = function(string2) {
            if (string2 != null) {
              g.setAttribute("transform", string2);
              var t = g.transform.baseVal.consolidate();
            }
            return new d3_transform(t ? t.matrix : d3_transformIdentity);
          })(string);
        };
        function d3_transform(m) {
          var r0 = [m.a, m.b], r1 = [m.c, m.d], kx = d3_transformNormalize(r0), kz = d3_transformDot(r0, r1), ky = d3_transformNormalize(d3_transformCombine(r1, r0, -kz)) || 0;
          if (r0[0] * r1[1] < r1[0] * r0[1]) {
            r0[0] *= -1;
            r0[1] *= -1;
            kx *= -1;
            kz *= -1;
          }
          this.rotate = (kx ? Math.atan2(r0[1], r0[0]) : Math.atan2(-r1[0], r1[1])) * d3_degrees;
          this.translate = [m.e, m.f];
          this.scale = [kx, ky];
          this.skew = ky ? Math.atan2(kz, ky) * d3_degrees : 0;
        }
        d3_transform.prototype.toString = function() {
          return "translate(" + this.translate + ")rotate(" + this.rotate + ")skewX(" + this.skew + ")scale(" + this.scale + ")";
        };
        function d3_transformDot(a, b) {
          return a[0] * b[0] + a[1] * b[1];
        }
        function d3_transformNormalize(a) {
          var k = Math.sqrt(d3_transformDot(a, a));
          if (k) {
            a[0] /= k;
            a[1] /= k;
          }
          return k;
        }
        function d3_transformCombine(a, b, k) {
          a[0] += k * b[0];
          a[1] += k * b[1];
          return a;
        }
        var d3_transformIdentity = {
          a: 1,
          b: 0,
          c: 0,
          d: 1,
          e: 0,
          f: 0
        };
        d3.interpolateTransform = d3_interpolateTransform;
        function d3_interpolateTransformPop(s) {
          return s.length ? s.pop() + "," : "";
        }
        function d3_interpolateTranslate(ta, tb, s, q) {
          if (ta[0] !== tb[0] || ta[1] !== tb[1]) {
            var i = s.push("translate(", null, ",", null, ")");
            q.push({
              i: i - 4,
              x: d3_interpolateNumber(ta[0], tb[0])
            }, {
              i: i - 2,
              x: d3_interpolateNumber(ta[1], tb[1])
            });
          } else if (tb[0] || tb[1]) {
            s.push("translate(" + tb + ")");
          }
        }
        function d3_interpolateRotate(ra, rb, s, q) {
          if (ra !== rb) {
            if (ra - rb > 180) rb += 360;
            else if (rb - ra > 180) ra += 360;
            q.push({
              i: s.push(d3_interpolateTransformPop(s) + "rotate(", null, ")") - 2,
              x: d3_interpolateNumber(ra, rb)
            });
          } else if (rb) {
            s.push(d3_interpolateTransformPop(s) + "rotate(" + rb + ")");
          }
        }
        function d3_interpolateSkew(wa, wb, s, q) {
          if (wa !== wb) {
            q.push({
              i: s.push(d3_interpolateTransformPop(s) + "skewX(", null, ")") - 2,
              x: d3_interpolateNumber(wa, wb)
            });
          } else if (wb) {
            s.push(d3_interpolateTransformPop(s) + "skewX(" + wb + ")");
          }
        }
        function d3_interpolateScale(ka, kb, s, q) {
          if (ka[0] !== kb[0] || ka[1] !== kb[1]) {
            var i = s.push(d3_interpolateTransformPop(s) + "scale(", null, ",", null, ")");
            q.push({
              i: i - 4,
              x: d3_interpolateNumber(ka[0], kb[0])
            }, {
              i: i - 2,
              x: d3_interpolateNumber(ka[1], kb[1])
            });
          } else if (kb[0] !== 1 || kb[1] !== 1) {
            s.push(d3_interpolateTransformPop(s) + "scale(" + kb + ")");
          }
        }
        function d3_interpolateTransform(a, b) {
          var s = [], q = [];
          a = d3.transform(a), b = d3.transform(b);
          d3_interpolateTranslate(a.translate, b.translate, s, q);
          d3_interpolateRotate(a.rotate, b.rotate, s, q);
          d3_interpolateSkew(a.skew, b.skew, s, q);
          d3_interpolateScale(a.scale, b.scale, s, q);
          a = b = null;
          return function(t) {
            var i = -1, n = q.length, o;
            while (++i < n) s[(o = q[i]).i] = o.x(t);
            return s.join("");
          };
        }
        function d3_uninterpolateNumber(a, b) {
          b = (b -= a = +a) || 1 / b;
          return function(x) {
            return (x - a) / b;
          };
        }
        function d3_uninterpolateClamp(a, b) {
          b = (b -= a = +a) || 1 / b;
          return function(x) {
            return Math.max(0, Math.min(1, (x - a) / b));
          };
        }
        d3.layout = {};
        d3.layout.bundle = function() {
          return function(links) {
            var paths = [], i = -1, n = links.length;
            while (++i < n) paths.push(d3_layout_bundlePath(links[i]));
            return paths;
          };
        };
        function d3_layout_bundlePath(link) {
          var start = link.source, end = link.target, lca = d3_layout_bundleLeastCommonAncestor(start, end), points = [start];
          while (start !== lca) {
            start = start.parent;
            points.push(start);
          }
          var k = points.length;
          while (end !== lca) {
            points.splice(k, 0, end);
            end = end.parent;
          }
          return points;
        }
        function d3_layout_bundleAncestors(node) {
          var ancestors = [], parent = node.parent;
          while (parent != null) {
            ancestors.push(node);
            node = parent;
            parent = parent.parent;
          }
          ancestors.push(node);
          return ancestors;
        }
        function d3_layout_bundleLeastCommonAncestor(a, b) {
          if (a === b) return a;
          var aNodes = d3_layout_bundleAncestors(a), bNodes = d3_layout_bundleAncestors(b), aNode = aNodes.pop(), bNode = bNodes.pop(), sharedNode = null;
          while (aNode === bNode) {
            sharedNode = aNode;
            aNode = aNodes.pop();
            bNode = bNodes.pop();
          }
          return sharedNode;
        }
        d3.layout.chord = function() {
          var chord = {}, chords, groups, matrix, n, padding = 0, sortGroups, sortSubgroups, sortChords;
          function relayout() {
            var subgroups = {}, groupSums = [], groupIndex = d3.range(n), subgroupIndex = [], k, x, x0, i, j;
            chords = [];
            groups = [];
            k = 0, i = -1;
            while (++i < n) {
              x = 0, j = -1;
              while (++j < n) {
                x += matrix[i][j];
              }
              groupSums.push(x);
              subgroupIndex.push(d3.range(n));
              k += x;
            }
            if (sortGroups) {
              groupIndex.sort(function(a, b) {
                return sortGroups(groupSums[a], groupSums[b]);
              });
            }
            if (sortSubgroups) {
              subgroupIndex.forEach(function(d, i2) {
                d.sort(function(a, b) {
                  return sortSubgroups(matrix[i2][a], matrix[i2][b]);
                });
              });
            }
            k = (\u03C4 - padding * n) / k;
            x = 0, i = -1;
            while (++i < n) {
              x0 = x, j = -1;
              while (++j < n) {
                var di = groupIndex[i], dj = subgroupIndex[di][j], v = matrix[di][dj], a0 = x, a1 = x += v * k;
                subgroups[di + "-" + dj] = {
                  index: di,
                  subindex: dj,
                  startAngle: a0,
                  endAngle: a1,
                  value: v
                };
              }
              groups[di] = {
                index: di,
                startAngle: x0,
                endAngle: x,
                value: groupSums[di]
              };
              x += padding;
            }
            i = -1;
            while (++i < n) {
              j = i - 1;
              while (++j < n) {
                var source = subgroups[i + "-" + j], target = subgroups[j + "-" + i];
                if (source.value || target.value) {
                  chords.push(source.value < target.value ? {
                    source: target,
                    target: source
                  } : {
                    source,
                    target
                  });
                }
              }
            }
            if (sortChords) resort();
          }
          function resort() {
            chords.sort(function(a, b) {
              return sortChords((a.source.value + a.target.value) / 2, (b.source.value + b.target.value) / 2);
            });
          }
          chord.matrix = function(x) {
            if (!arguments.length) return matrix;
            n = (matrix = x) && matrix.length;
            chords = groups = null;
            return chord;
          };
          chord.padding = function(x) {
            if (!arguments.length) return padding;
            padding = x;
            chords = groups = null;
            return chord;
          };
          chord.sortGroups = function(x) {
            if (!arguments.length) return sortGroups;
            sortGroups = x;
            chords = groups = null;
            return chord;
          };
          chord.sortSubgroups = function(x) {
            if (!arguments.length) return sortSubgroups;
            sortSubgroups = x;
            chords = null;
            return chord;
          };
          chord.sortChords = function(x) {
            if (!arguments.length) return sortChords;
            sortChords = x;
            if (chords) resort();
            return chord;
          };
          chord.chords = function() {
            if (!chords) relayout();
            return chords;
          };
          chord.groups = function() {
            if (!groups) relayout();
            return groups;
          };
          return chord;
        };
        d3.layout.force = function() {
          var force = {}, event = d3.dispatch("start", "tick", "end"), timer, size = [1, 1], drag, alpha, friction = 0.9, linkDistance = d3_layout_forceLinkDistance, linkStrength = d3_layout_forceLinkStrength, charge = -30, chargeDistance2 = d3_layout_forceChargeDistance2, gravity = 0.1, theta2 = 0.64, nodes = [], links = [], distances, strengths, charges;
          function repulse(node) {
            return function(quad, x1, _, x2) {
              if (quad.point !== node) {
                var dx = quad.cx - node.x, dy = quad.cy - node.y, dw = x2 - x1, dn = dx * dx + dy * dy;
                if (dw * dw / theta2 < dn) {
                  if (dn < chargeDistance2) {
                    var k = quad.charge / dn;
                    node.px -= dx * k;
                    node.py -= dy * k;
                  }
                  return true;
                }
                if (quad.point && dn && dn < chargeDistance2) {
                  var k = quad.pointCharge / dn;
                  node.px -= dx * k;
                  node.py -= dy * k;
                }
              }
              return !quad.charge;
            };
          }
          force.tick = function() {
            if ((alpha *= 0.99) < 5e-3) {
              timer = null;
              event.end({
                type: "end",
                alpha: alpha = 0
              });
              return true;
            }
            var n = nodes.length, m = links.length, q, i, o, s, t, l, k, x, y;
            for (i = 0; i < m; ++i) {
              o = links[i];
              s = o.source;
              t = o.target;
              x = t.x - s.x;
              y = t.y - s.y;
              if (l = x * x + y * y) {
                l = alpha * strengths[i] * ((l = Math.sqrt(l)) - distances[i]) / l;
                x *= l;
                y *= l;
                t.x -= x * (k = s.weight + t.weight ? s.weight / (s.weight + t.weight) : 0.5);
                t.y -= y * k;
                s.x += x * (k = 1 - k);
                s.y += y * k;
              }
            }
            if (k = alpha * gravity) {
              x = size[0] / 2;
              y = size[1] / 2;
              i = -1;
              if (k) while (++i < n) {
                o = nodes[i];
                o.x += (x - o.x) * k;
                o.y += (y - o.y) * k;
              }
            }
            if (charge) {
              d3_layout_forceAccumulate(q = d3.geom.quadtree(nodes), alpha, charges);
              i = -1;
              while (++i < n) {
                if (!(o = nodes[i]).fixed) {
                  q.visit(repulse(o));
                }
              }
            }
            i = -1;
            while (++i < n) {
              o = nodes[i];
              if (o.fixed) {
                o.x = o.px;
                o.y = o.py;
              } else {
                o.x -= (o.px - (o.px = o.x)) * friction;
                o.y -= (o.py - (o.py = o.y)) * friction;
              }
            }
            event.tick({
              type: "tick",
              alpha
            });
          };
          force.nodes = function(x) {
            if (!arguments.length) return nodes;
            nodes = x;
            return force;
          };
          force.links = function(x) {
            if (!arguments.length) return links;
            links = x;
            return force;
          };
          force.size = function(x) {
            if (!arguments.length) return size;
            size = x;
            return force;
          };
          force.linkDistance = function(x) {
            if (!arguments.length) return linkDistance;
            linkDistance = typeof x === "function" ? x : +x;
            return force;
          };
          force.distance = force.linkDistance;
          force.linkStrength = function(x) {
            if (!arguments.length) return linkStrength;
            linkStrength = typeof x === "function" ? x : +x;
            return force;
          };
          force.friction = function(x) {
            if (!arguments.length) return friction;
            friction = +x;
            return force;
          };
          force.charge = function(x) {
            if (!arguments.length) return charge;
            charge = typeof x === "function" ? x : +x;
            return force;
          };
          force.chargeDistance = function(x) {
            if (!arguments.length) return Math.sqrt(chargeDistance2);
            chargeDistance2 = x * x;
            return force;
          };
          force.gravity = function(x) {
            if (!arguments.length) return gravity;
            gravity = +x;
            return force;
          };
          force.theta = function(x) {
            if (!arguments.length) return Math.sqrt(theta2);
            theta2 = x * x;
            return force;
          };
          force.alpha = function(x) {
            if (!arguments.length) return alpha;
            x = +x;
            if (alpha) {
              if (x > 0) {
                alpha = x;
              } else {
                timer.c = null, timer.t = NaN, timer = null;
                event.end({
                  type: "end",
                  alpha: alpha = 0
                });
              }
            } else if (x > 0) {
              event.start({
                type: "start",
                alpha: alpha = x
              });
              timer = d3_timer(force.tick);
            }
            return force;
          };
          force.start = function() {
            var i, n = nodes.length, m = links.length, w = size[0], h = size[1], neighbors, o;
            for (i = 0; i < n; ++i) {
              (o = nodes[i]).index = i;
              o.weight = 0;
            }
            for (i = 0; i < m; ++i) {
              o = links[i];
              if (typeof o.source == "number") o.source = nodes[o.source];
              if (typeof o.target == "number") o.target = nodes[o.target];
              ++o.source.weight;
              ++o.target.weight;
            }
            for (i = 0; i < n; ++i) {
              o = nodes[i];
              if (isNaN(o.x)) o.x = position("x", w);
              if (isNaN(o.y)) o.y = position("y", h);
              if (isNaN(o.px)) o.px = o.x;
              if (isNaN(o.py)) o.py = o.y;
            }
            distances = [];
            if (typeof linkDistance === "function") for (i = 0; i < m; ++i) distances[i] = +linkDistance.call(this, links[i], i);
            else for (i = 0; i < m; ++i) distances[i] = linkDistance;
            strengths = [];
            if (typeof linkStrength === "function") for (i = 0; i < m; ++i) strengths[i] = +linkStrength.call(this, links[i], i);
            else for (i = 0; i < m; ++i) strengths[i] = linkStrength;
            charges = [];
            if (typeof charge === "function") for (i = 0; i < n; ++i) charges[i] = +charge.call(this, nodes[i], i);
            else for (i = 0; i < n; ++i) charges[i] = charge;
            function position(dimension, size2) {
              if (!neighbors) {
                neighbors = new Array(n);
                for (j = 0; j < n; ++j) {
                  neighbors[j] = [];
                }
                for (j = 0; j < m; ++j) {
                  var o2 = links[j];
                  neighbors[o2.source.index].push(o2.target);
                  neighbors[o2.target.index].push(o2.source);
                }
              }
              var candidates = neighbors[i], j = -1, l = candidates.length, x;
              while (++j < l) if (!isNaN(x = candidates[j][dimension])) return x;
              return Math.random() * size2;
            }
            return force.resume();
          };
          force.resume = function() {
            return force.alpha(0.1);
          };
          force.stop = function() {
            return force.alpha(0);
          };
          force.drag = function() {
            if (!drag) drag = d3.behavior.drag().origin(d3_identity).on("dragstart.force", d3_layout_forceDragstart).on("drag.force", dragmove).on("dragend.force", d3_layout_forceDragend);
            if (!arguments.length) return drag;
            this.on("mouseover.force", d3_layout_forceMouseover).on("mouseout.force", d3_layout_forceMouseout).call(drag);
          };
          function dragmove(d) {
            d.px = d3.event.x, d.py = d3.event.y;
            force.resume();
          }
          return d3.rebind(force, event, "on");
        };
        function d3_layout_forceDragstart(d) {
          d.fixed |= 2;
        }
        function d3_layout_forceDragend(d) {
          d.fixed &= ~6;
        }
        function d3_layout_forceMouseover(d) {
          d.fixed |= 4;
          d.px = d.x, d.py = d.y;
        }
        function d3_layout_forceMouseout(d) {
          d.fixed &= ~4;
        }
        function d3_layout_forceAccumulate(quad, alpha, charges) {
          var cx = 0, cy = 0;
          quad.charge = 0;
          if (!quad.leaf) {
            var nodes = quad.nodes, n = nodes.length, i = -1, c;
            while (++i < n) {
              c = nodes[i];
              if (c == null) continue;
              d3_layout_forceAccumulate(c, alpha, charges);
              quad.charge += c.charge;
              cx += c.charge * c.cx;
              cy += c.charge * c.cy;
            }
          }
          if (quad.point) {
            if (!quad.leaf) {
              quad.point.x += Math.random() - 0.5;
              quad.point.y += Math.random() - 0.5;
            }
            var k = alpha * charges[quad.point.index];
            quad.charge += quad.pointCharge = k;
            cx += k * quad.point.x;
            cy += k * quad.point.y;
          }
          quad.cx = cx / quad.charge;
          quad.cy = cy / quad.charge;
        }
        var d3_layout_forceLinkDistance = 20, d3_layout_forceLinkStrength = 1, d3_layout_forceChargeDistance2 = Infinity;
        d3.layout.hierarchy = function() {
          var sort = d3_layout_hierarchySort, children = d3_layout_hierarchyChildren, value = d3_layout_hierarchyValue;
          function hierarchy(root) {
            var stack = [root], nodes = [], node;
            root.depth = 0;
            while ((node = stack.pop()) != null) {
              nodes.push(node);
              if ((childs = children.call(hierarchy, node, node.depth)) && (n = childs.length)) {
                var n, childs, child;
                while (--n >= 0) {
                  stack.push(child = childs[n]);
                  child.parent = node;
                  child.depth = node.depth + 1;
                }
                if (value) node.value = 0;
                node.children = childs;
              } else {
                if (value) node.value = +value.call(hierarchy, node, node.depth) || 0;
                delete node.children;
              }
            }
            d3_layout_hierarchyVisitAfter(root, function(node2) {
              var childs2, parent;
              if (sort && (childs2 = node2.children)) childs2.sort(sort);
              if (value && (parent = node2.parent)) parent.value += node2.value;
            });
            return nodes;
          }
          hierarchy.sort = function(x) {
            if (!arguments.length) return sort;
            sort = x;
            return hierarchy;
          };
          hierarchy.children = function(x) {
            if (!arguments.length) return children;
            children = x;
            return hierarchy;
          };
          hierarchy.value = function(x) {
            if (!arguments.length) return value;
            value = x;
            return hierarchy;
          };
          hierarchy.revalue = function(root) {
            if (value) {
              d3_layout_hierarchyVisitBefore(root, function(node) {
                if (node.children) node.value = 0;
              });
              d3_layout_hierarchyVisitAfter(root, function(node) {
                var parent;
                if (!node.children) node.value = +value.call(hierarchy, node, node.depth) || 0;
                if (parent = node.parent) parent.value += node.value;
              });
            }
            return root;
          };
          return hierarchy;
        };
        function d3_layout_hierarchyRebind(object, hierarchy) {
          d3.rebind(object, hierarchy, "sort", "children", "value");
          object.nodes = object;
          object.links = d3_layout_hierarchyLinks;
          return object;
        }
        function d3_layout_hierarchyVisitBefore(node, callback) {
          var nodes = [node];
          while ((node = nodes.pop()) != null) {
            callback(node);
            if ((children = node.children) && (n = children.length)) {
              var n, children;
              while (--n >= 0) nodes.push(children[n]);
            }
          }
        }
        function d3_layout_hierarchyVisitAfter(node, callback) {
          var nodes = [node], nodes2 = [];
          while ((node = nodes.pop()) != null) {
            nodes2.push(node);
            if ((children = node.children) && (n = children.length)) {
              var i = -1, n, children;
              while (++i < n) nodes.push(children[i]);
            }
          }
          while ((node = nodes2.pop()) != null) {
            callback(node);
          }
        }
        function d3_layout_hierarchyChildren(d) {
          return d.children;
        }
        function d3_layout_hierarchyValue(d) {
          return d.value;
        }
        function d3_layout_hierarchySort(a, b) {
          return b.value - a.value;
        }
        function d3_layout_hierarchyLinks(nodes) {
          return d3.merge(nodes.map(function(parent) {
            return (parent.children || []).map(function(child) {
              return {
                source: parent,
                target: child
              };
            });
          }));
        }
        d3.layout.partition = function() {
          var hierarchy = d3.layout.hierarchy(), size = [1, 1];
          function position(node, x, dx, dy) {
            var children = node.children;
            node.x = x;
            node.y = node.depth * dy;
            node.dx = dx;
            node.dy = dy;
            if (children && (n = children.length)) {
              var i = -1, n, c, d;
              dx = node.value ? dx / node.value : 0;
              while (++i < n) {
                position(c = children[i], x, d = c.value * dx, dy);
                x += d;
              }
            }
          }
          function depth(node) {
            var children = node.children, d = 0;
            if (children && (n = children.length)) {
              var i = -1, n;
              while (++i < n) d = Math.max(d, depth(children[i]));
            }
            return 1 + d;
          }
          function partition(d, i) {
            var nodes = hierarchy.call(this, d, i);
            position(nodes[0], 0, size[0], size[1] / depth(nodes[0]));
            return nodes;
          }
          partition.size = function(x) {
            if (!arguments.length) return size;
            size = x;
            return partition;
          };
          return d3_layout_hierarchyRebind(partition, hierarchy);
        };
        d3.layout.pie = function() {
          var value = Number, sort = d3_layout_pieSortByValue, startAngle = 0, endAngle = \u03C4, padAngle = 0;
          function pie(data) {
            var n = data.length, values = data.map(function(d, i) {
              return +value.call(pie, d, i);
            }), a = +(typeof startAngle === "function" ? startAngle.apply(this, arguments) : startAngle), da = (typeof endAngle === "function" ? endAngle.apply(this, arguments) : endAngle) - a, p = Math.min(Math.abs(da) / n, +(typeof padAngle === "function" ? padAngle.apply(this, arguments) : padAngle)), pa = p * (da < 0 ? -1 : 1), sum = d3.sum(values), k = sum ? (da - n * pa) / sum : 0, index = d3.range(n), arcs = [], v;
            if (sort != null) index.sort(sort === d3_layout_pieSortByValue ? function(i, j) {
              return values[j] - values[i];
            } : function(i, j) {
              return sort(data[i], data[j]);
            });
            index.forEach(function(i) {
              arcs[i] = {
                data: data[i],
                value: v = values[i],
                startAngle: a,
                endAngle: a += v * k + pa,
                padAngle: p
              };
            });
            return arcs;
          }
          pie.value = function(_) {
            if (!arguments.length) return value;
            value = _;
            return pie;
          };
          pie.sort = function(_) {
            if (!arguments.length) return sort;
            sort = _;
            return pie;
          };
          pie.startAngle = function(_) {
            if (!arguments.length) return startAngle;
            startAngle = _;
            return pie;
          };
          pie.endAngle = function(_) {
            if (!arguments.length) return endAngle;
            endAngle = _;
            return pie;
          };
          pie.padAngle = function(_) {
            if (!arguments.length) return padAngle;
            padAngle = _;
            return pie;
          };
          return pie;
        };
        var d3_layout_pieSortByValue = {};
        d3.layout.stack = function() {
          var values = d3_identity, order = d3_layout_stackOrderDefault, offset = d3_layout_stackOffsetZero, out = d3_layout_stackOut, x = d3_layout_stackX, y = d3_layout_stackY;
          function stack(data, index) {
            if (!(n = data.length)) return data;
            var series = data.map(function(d, i2) {
              return values.call(stack, d, i2);
            });
            var points = series.map(function(d) {
              return d.map(function(v, i2) {
                return [x.call(stack, v, i2), y.call(stack, v, i2)];
              });
            });
            var orders = order.call(stack, points, index);
            series = d3.permute(series, orders);
            points = d3.permute(points, orders);
            var offsets = offset.call(stack, points, index);
            var m = series[0].length, n, i, j, o;
            for (j = 0; j < m; ++j) {
              out.call(stack, series[0][j], o = offsets[j], points[0][j][1]);
              for (i = 1; i < n; ++i) {
                out.call(stack, series[i][j], o += points[i - 1][j][1], points[i][j][1]);
              }
            }
            return data;
          }
          stack.values = function(x2) {
            if (!arguments.length) return values;
            values = x2;
            return stack;
          };
          stack.order = function(x2) {
            if (!arguments.length) return order;
            order = typeof x2 === "function" ? x2 : d3_layout_stackOrders.get(x2) || d3_layout_stackOrderDefault;
            return stack;
          };
          stack.offset = function(x2) {
            if (!arguments.length) return offset;
            offset = typeof x2 === "function" ? x2 : d3_layout_stackOffsets.get(x2) || d3_layout_stackOffsetZero;
            return stack;
          };
          stack.x = function(z) {
            if (!arguments.length) return x;
            x = z;
            return stack;
          };
          stack.y = function(z) {
            if (!arguments.length) return y;
            y = z;
            return stack;
          };
          stack.out = function(z) {
            if (!arguments.length) return out;
            out = z;
            return stack;
          };
          return stack;
        };
        function d3_layout_stackX(d) {
          return d.x;
        }
        function d3_layout_stackY(d) {
          return d.y;
        }
        function d3_layout_stackOut(d, y0, y) {
          d.y0 = y0;
          d.y = y;
        }
        var d3_layout_stackOrders = d3.map({
          "inside-out": function(data) {
            var n = data.length, i, j, max = data.map(d3_layout_stackMaxIndex), sums = data.map(d3_layout_stackReduceSum), index = d3.range(n).sort(function(a, b) {
              return max[a] - max[b];
            }), top = 0, bottom = 0, tops = [], bottoms = [];
            for (i = 0; i < n; ++i) {
              j = index[i];
              if (top < bottom) {
                top += sums[j];
                tops.push(j);
              } else {
                bottom += sums[j];
                bottoms.push(j);
              }
            }
            return bottoms.reverse().concat(tops);
          },
          reverse: function(data) {
            return d3.range(data.length).reverse();
          },
          "default": d3_layout_stackOrderDefault
        });
        var d3_layout_stackOffsets = d3.map({
          silhouette: function(data) {
            var n = data.length, m = data[0].length, sums = [], max = 0, i, j, o, y0 = [];
            for (j = 0; j < m; ++j) {
              for (i = 0, o = 0; i < n; i++) o += data[i][j][1];
              if (o > max) max = o;
              sums.push(o);
            }
            for (j = 0; j < m; ++j) {
              y0[j] = (max - sums[j]) / 2;
            }
            return y0;
          },
          wiggle: function(data) {
            var n = data.length, x = data[0], m = x.length, i, j, k, s1, s2, s3, dx, o, o0, y0 = [];
            y0[0] = o = o0 = 0;
            for (j = 1; j < m; ++j) {
              for (i = 0, s1 = 0; i < n; ++i) s1 += data[i][j][1];
              for (i = 0, s2 = 0, dx = x[j][0] - x[j - 1][0]; i < n; ++i) {
                for (k = 0, s3 = (data[i][j][1] - data[i][j - 1][1]) / (2 * dx); k < i; ++k) {
                  s3 += (data[k][j][1] - data[k][j - 1][1]) / dx;
                }
                s2 += s3 * data[i][j][1];
              }
              y0[j] = o -= s1 ? s2 / s1 * dx : 0;
              if (o < o0) o0 = o;
            }
            for (j = 0; j < m; ++j) y0[j] -= o0;
            return y0;
          },
          expand: function(data) {
            var n = data.length, m = data[0].length, k = 1 / n, i, j, o, y0 = [];
            for (j = 0; j < m; ++j) {
              for (i = 0, o = 0; i < n; i++) o += data[i][j][1];
              if (o) for (i = 0; i < n; i++) data[i][j][1] /= o;
              else for (i = 0; i < n; i++) data[i][j][1] = k;
            }
            for (j = 0; j < m; ++j) y0[j] = 0;
            return y0;
          },
          zero: d3_layout_stackOffsetZero
        });
        function d3_layout_stackOrderDefault(data) {
          return d3.range(data.length);
        }
        function d3_layout_stackOffsetZero(data) {
          var j = -1, m = data[0].length, y0 = [];
          while (++j < m) y0[j] = 0;
          return y0;
        }
        function d3_layout_stackMaxIndex(array) {
          var i = 1, j = 0, v = array[0][1], k, n = array.length;
          for (; i < n; ++i) {
            if ((k = array[i][1]) > v) {
              j = i;
              v = k;
            }
          }
          return j;
        }
        function d3_layout_stackReduceSum(d) {
          return d.reduce(d3_layout_stackSum, 0);
        }
        function d3_layout_stackSum(p, d) {
          return p + d[1];
        }
        d3.layout.histogram = function() {
          var frequency = true, valuer = Number, ranger = d3_layout_histogramRange, binner = d3_layout_histogramBinSturges;
          function histogram(data, i) {
            var bins = [], values = data.map(valuer, this), range = ranger.call(this, values, i), thresholds = binner.call(this, range, values, i), bin, i = -1, n = values.length, m = thresholds.length - 1, k = frequency ? 1 : 1 / n, x;
            while (++i < m) {
              bin = bins[i] = [];
              bin.dx = thresholds[i + 1] - (bin.x = thresholds[i]);
              bin.y = 0;
            }
            if (m > 0) {
              i = -1;
              while (++i < n) {
                x = values[i];
                if (x >= range[0] && x <= range[1]) {
                  bin = bins[d3.bisect(thresholds, x, 1, m) - 1];
                  bin.y += k;
                  bin.push(data[i]);
                }
              }
            }
            return bins;
          }
          histogram.value = function(x) {
            if (!arguments.length) return valuer;
            valuer = x;
            return histogram;
          };
          histogram.range = function(x) {
            if (!arguments.length) return ranger;
            ranger = d3_functor(x);
            return histogram;
          };
          histogram.bins = function(x) {
            if (!arguments.length) return binner;
            binner = typeof x === "number" ? function(range) {
              return d3_layout_histogramBinFixed(range, x);
            } : d3_functor(x);
            return histogram;
          };
          histogram.frequency = function(x) {
            if (!arguments.length) return frequency;
            frequency = !!x;
            return histogram;
          };
          return histogram;
        };
        function d3_layout_histogramBinSturges(range, values) {
          return d3_layout_histogramBinFixed(range, Math.ceil(Math.log(values.length) / Math.LN2 + 1));
        }
        function d3_layout_histogramBinFixed(range, n) {
          var x = -1, b = +range[0], m = (range[1] - b) / n, f = [];
          while (++x <= n) f[x] = m * x + b;
          return f;
        }
        function d3_layout_histogramRange(values) {
          return [d3.min(values), d3.max(values)];
        }
        d3.layout.pack = function() {
          var hierarchy = d3.layout.hierarchy().sort(d3_layout_packSort), padding = 0, size = [1, 1], radius;
          function pack(d, i) {
            var nodes = hierarchy.call(this, d, i), root = nodes[0], w = size[0], h = size[1], r = radius == null ? Math.sqrt : typeof radius === "function" ? radius : function() {
              return radius;
            };
            root.x = root.y = 0;
            d3_layout_hierarchyVisitAfter(root, function(d2) {
              d2.r = +r(d2.value);
            });
            d3_layout_hierarchyVisitAfter(root, d3_layout_packSiblings);
            if (padding) {
              var dr = padding * (radius ? 1 : Math.max(2 * root.r / w, 2 * root.r / h)) / 2;
              d3_layout_hierarchyVisitAfter(root, function(d2) {
                d2.r += dr;
              });
              d3_layout_hierarchyVisitAfter(root, d3_layout_packSiblings);
              d3_layout_hierarchyVisitAfter(root, function(d2) {
                d2.r -= dr;
              });
            }
            d3_layout_packTransform(root, w / 2, h / 2, radius ? 1 : 1 / Math.max(2 * root.r / w, 2 * root.r / h));
            return nodes;
          }
          pack.size = function(_) {
            if (!arguments.length) return size;
            size = _;
            return pack;
          };
          pack.radius = function(_) {
            if (!arguments.length) return radius;
            radius = _ == null || typeof _ === "function" ? _ : +_;
            return pack;
          };
          pack.padding = function(_) {
            if (!arguments.length) return padding;
            padding = +_;
            return pack;
          };
          return d3_layout_hierarchyRebind(pack, hierarchy);
        };
        function d3_layout_packSort(a, b) {
          return a.value - b.value;
        }
        function d3_layout_packInsert(a, b) {
          var c = a._pack_next;
          a._pack_next = b;
          b._pack_prev = a;
          b._pack_next = c;
          c._pack_prev = b;
        }
        function d3_layout_packSplice(a, b) {
          a._pack_next = b;
          b._pack_prev = a;
        }
        function d3_layout_packIntersects(a, b) {
          var dx = b.x - a.x, dy = b.y - a.y, dr = a.r + b.r;
          return 0.999 * dr * dr > dx * dx + dy * dy;
        }
        function d3_layout_packSiblings(node) {
          if (!(nodes = node.children) || !(n = nodes.length)) return;
          var nodes, xMin = Infinity, xMax = -Infinity, yMin = Infinity, yMax = -Infinity, a, b, c, i, j, k, n;
          function bound(node2) {
            xMin = Math.min(node2.x - node2.r, xMin);
            xMax = Math.max(node2.x + node2.r, xMax);
            yMin = Math.min(node2.y - node2.r, yMin);
            yMax = Math.max(node2.y + node2.r, yMax);
          }
          nodes.forEach(d3_layout_packLink);
          a = nodes[0];
          a.x = -a.r;
          a.y = 0;
          bound(a);
          if (n > 1) {
            b = nodes[1];
            b.x = b.r;
            b.y = 0;
            bound(b);
            if (n > 2) {
              c = nodes[2];
              d3_layout_packPlace(a, b, c);
              bound(c);
              d3_layout_packInsert(a, c);
              a._pack_prev = c;
              d3_layout_packInsert(c, b);
              b = a._pack_next;
              for (i = 3; i < n; i++) {
                d3_layout_packPlace(a, b, c = nodes[i]);
                var isect = 0, s1 = 1, s2 = 1;
                for (j = b._pack_next; j !== b; j = j._pack_next, s1++) {
                  if (d3_layout_packIntersects(j, c)) {
                    isect = 1;
                    break;
                  }
                }
                if (isect == 1) {
                  for (k = a._pack_prev; k !== j._pack_prev; k = k._pack_prev, s2++) {
                    if (d3_layout_packIntersects(k, c)) {
                      break;
                    }
                  }
                }
                if (isect) {
                  if (s1 < s2 || s1 == s2 && b.r < a.r) d3_layout_packSplice(a, b = j);
                  else d3_layout_packSplice(a = k, b);
                  i--;
                } else {
                  d3_layout_packInsert(a, c);
                  b = c;
                  bound(c);
                }
              }
            }
          }
          var cx = (xMin + xMax) / 2, cy = (yMin + yMax) / 2, cr = 0;
          for (i = 0; i < n; i++) {
            c = nodes[i];
            c.x -= cx;
            c.y -= cy;
            cr = Math.max(cr, c.r + Math.sqrt(c.x * c.x + c.y * c.y));
          }
          node.r = cr;
          nodes.forEach(d3_layout_packUnlink);
        }
        function d3_layout_packLink(node) {
          node._pack_next = node._pack_prev = node;
        }
        function d3_layout_packUnlink(node) {
          delete node._pack_next;
          delete node._pack_prev;
        }
        function d3_layout_packTransform(node, x, y, k) {
          var children = node.children;
          node.x = x += k * node.x;
          node.y = y += k * node.y;
          node.r *= k;
          if (children) {
            var i = -1, n = children.length;
            while (++i < n) d3_layout_packTransform(children[i], x, y, k);
          }
        }
        function d3_layout_packPlace(a, b, c) {
          var db = a.r + c.r, dx = b.x - a.x, dy = b.y - a.y;
          if (db && (dx || dy)) {
            var da = b.r + c.r, dc = dx * dx + dy * dy;
            da *= da;
            db *= db;
            var x = 0.5 + (db - da) / (2 * dc), y = Math.sqrt(Math.max(0, 2 * da * (db + dc) - (db -= dc) * db - da * da)) / (2 * dc);
            c.x = a.x + x * dx + y * dy;
            c.y = a.y + x * dy - y * dx;
          } else {
            c.x = a.x + db;
            c.y = a.y;
          }
        }
        d3.layout.tree = function() {
          var hierarchy = d3.layout.hierarchy().sort(null).value(null), separation = d3_layout_treeSeparation, size = [1, 1], nodeSize = null;
          function tree(d, i) {
            var nodes = hierarchy.call(this, d, i), root0 = nodes[0], root1 = wrapTree(root0);
            d3_layout_hierarchyVisitAfter(root1, firstWalk), root1.parent.m = -root1.z;
            d3_layout_hierarchyVisitBefore(root1, secondWalk);
            if (nodeSize) d3_layout_hierarchyVisitBefore(root0, sizeNode);
            else {
              var left = root0, right = root0, bottom = root0;
              d3_layout_hierarchyVisitBefore(root0, function(node) {
                if (node.x < left.x) left = node;
                if (node.x > right.x) right = node;
                if (node.depth > bottom.depth) bottom = node;
              });
              var tx = separation(left, right) / 2 - left.x, kx = size[0] / (right.x + separation(right, left) / 2 + tx), ky = size[1] / (bottom.depth || 1);
              d3_layout_hierarchyVisitBefore(root0, function(node) {
                node.x = (node.x + tx) * kx;
                node.y = node.depth * ky;
              });
            }
            return nodes;
          }
          function wrapTree(root0) {
            var root1 = {
              A: null,
              children: [root0]
            }, queue = [root1], node1;
            while ((node1 = queue.pop()) != null) {
              for (var children = node1.children, child, i = 0, n = children.length; i < n; ++i) {
                queue.push((children[i] = child = {
                  _: children[i],
                  parent: node1,
                  children: (child = children[i].children) && child.slice() || [],
                  A: null,
                  a: null,
                  z: 0,
                  m: 0,
                  c: 0,
                  s: 0,
                  t: null,
                  i
                }).a = child);
              }
            }
            return root1.children[0];
          }
          function firstWalk(v) {
            var children = v.children, siblings = v.parent.children, w = v.i ? siblings[v.i - 1] : null;
            if (children.length) {
              d3_layout_treeShift(v);
              var midpoint = (children[0].z + children[children.length - 1].z) / 2;
              if (w) {
                v.z = w.z + separation(v._, w._);
                v.m = v.z - midpoint;
              } else {
                v.z = midpoint;
              }
            } else if (w) {
              v.z = w.z + separation(v._, w._);
            }
            v.parent.A = apportion(v, w, v.parent.A || siblings[0]);
          }
          function secondWalk(v) {
            v._.x = v.z + v.parent.m;
            v.m += v.parent.m;
          }
          function apportion(v, w, ancestor) {
            if (w) {
              var vip = v, vop = v, vim = w, vom = vip.parent.children[0], sip = vip.m, sop = vop.m, sim = vim.m, som = vom.m, shift;
              while (vim = d3_layout_treeRight(vim), vip = d3_layout_treeLeft(vip), vim && vip) {
                vom = d3_layout_treeLeft(vom);
                vop = d3_layout_treeRight(vop);
                vop.a = v;
                shift = vim.z + sim - vip.z - sip + separation(vim._, vip._);
                if (shift > 0) {
                  d3_layout_treeMove(d3_layout_treeAncestor(vim, v, ancestor), v, shift);
                  sip += shift;
                  sop += shift;
                }
                sim += vim.m;
                sip += vip.m;
                som += vom.m;
                sop += vop.m;
              }
              if (vim && !d3_layout_treeRight(vop)) {
                vop.t = vim;
                vop.m += sim - sop;
              }
              if (vip && !d3_layout_treeLeft(vom)) {
                vom.t = vip;
                vom.m += sip - som;
                ancestor = v;
              }
            }
            return ancestor;
          }
          function sizeNode(node) {
            node.x *= size[0];
            node.y = node.depth * size[1];
          }
          tree.separation = function(x) {
            if (!arguments.length) return separation;
            separation = x;
            return tree;
          };
          tree.size = function(x) {
            if (!arguments.length) return nodeSize ? null : size;
            nodeSize = (size = x) == null ? sizeNode : null;
            return tree;
          };
          tree.nodeSize = function(x) {
            if (!arguments.length) return nodeSize ? size : null;
            nodeSize = (size = x) == null ? null : sizeNode;
            return tree;
          };
          return d3_layout_hierarchyRebind(tree, hierarchy);
        };
        function d3_layout_treeSeparation(a, b) {
          return a.parent == b.parent ? 1 : 2;
        }
        function d3_layout_treeLeft(v) {
          var children = v.children;
          return children.length ? children[0] : v.t;
        }
        function d3_layout_treeRight(v) {
          var children = v.children, n;
          return (n = children.length) ? children[n - 1] : v.t;
        }
        function d3_layout_treeMove(wm, wp, shift) {
          var change = shift / (wp.i - wm.i);
          wp.c -= change;
          wp.s += shift;
          wm.c += change;
          wp.z += shift;
          wp.m += shift;
        }
        function d3_layout_treeShift(v) {
          var shift = 0, change = 0, children = v.children, i = children.length, w;
          while (--i >= 0) {
            w = children[i];
            w.z += shift;
            w.m += shift;
            shift += w.s + (change += w.c);
          }
        }
        function d3_layout_treeAncestor(vim, v, ancestor) {
          return vim.a.parent === v.parent ? vim.a : ancestor;
        }
        d3.layout.cluster = function() {
          var hierarchy = d3.layout.hierarchy().sort(null).value(null), separation = d3_layout_treeSeparation, size = [1, 1], nodeSize = false;
          function cluster(d, i) {
            var nodes = hierarchy.call(this, d, i), root = nodes[0], previousNode, x = 0;
            d3_layout_hierarchyVisitAfter(root, function(node) {
              var children = node.children;
              if (children && children.length) {
                node.x = d3_layout_clusterX(children);
                node.y = d3_layout_clusterY(children);
              } else {
                node.x = previousNode ? x += separation(node, previousNode) : 0;
                node.y = 0;
                previousNode = node;
              }
            });
            var left = d3_layout_clusterLeft(root), right = d3_layout_clusterRight(root), x0 = left.x - separation(left, right) / 2, x1 = right.x + separation(right, left) / 2;
            d3_layout_hierarchyVisitAfter(root, nodeSize ? function(node) {
              node.x = (node.x - root.x) * size[0];
              node.y = (root.y - node.y) * size[1];
            } : function(node) {
              node.x = (node.x - x0) / (x1 - x0) * size[0];
              node.y = (1 - (root.y ? node.y / root.y : 1)) * size[1];
            });
            return nodes;
          }
          cluster.separation = function(x) {
            if (!arguments.length) return separation;
            separation = x;
            return cluster;
          };
          cluster.size = function(x) {
            if (!arguments.length) return nodeSize ? null : size;
            nodeSize = (size = x) == null;
            return cluster;
          };
          cluster.nodeSize = function(x) {
            if (!arguments.length) return nodeSize ? size : null;
            nodeSize = (size = x) != null;
            return cluster;
          };
          return d3_layout_hierarchyRebind(cluster, hierarchy);
        };
        function d3_layout_clusterY(children) {
          return 1 + d3.max(children, function(child) {
            return child.y;
          });
        }
        function d3_layout_clusterX(children) {
          return children.reduce(function(x, child) {
            return x + child.x;
          }, 0) / children.length;
        }
        function d3_layout_clusterLeft(node) {
          var children = node.children;
          return children && children.length ? d3_layout_clusterLeft(children[0]) : node;
        }
        function d3_layout_clusterRight(node) {
          var children = node.children, n;
          return children && (n = children.length) ? d3_layout_clusterRight(children[n - 1]) : node;
        }
        d3.layout.treemap = function() {
          var hierarchy = d3.layout.hierarchy(), round = Math.round, size = [1, 1], padding = null, pad = d3_layout_treemapPadNull, sticky = false, stickies, mode = "squarify", ratio = 0.5 * (1 + Math.sqrt(5));
          function scale(children, k) {
            var i = -1, n = children.length, child, area;
            while (++i < n) {
              area = (child = children[i]).value * (k < 0 ? 0 : k);
              child.area = isNaN(area) || area <= 0 ? 0 : area;
            }
          }
          function squarify(node) {
            var children = node.children;
            if (children && children.length) {
              var rect = pad(node), row = [], remaining = children.slice(), child, best = Infinity, score, u = mode === "slice" ? rect.dx : mode === "dice" ? rect.dy : mode === "slice-dice" ? node.depth & 1 ? rect.dy : rect.dx : Math.min(rect.dx, rect.dy), n;
              scale(remaining, rect.dx * rect.dy / node.value);
              row.area = 0;
              while ((n = remaining.length) > 0) {
                row.push(child = remaining[n - 1]);
                row.area += child.area;
                if (mode !== "squarify" || (score = worst(row, u)) <= best) {
                  remaining.pop();
                  best = score;
                } else {
                  row.area -= row.pop().area;
                  position(row, u, rect, false);
                  u = Math.min(rect.dx, rect.dy);
                  row.length = row.area = 0;
                  best = Infinity;
                }
              }
              if (row.length) {
                position(row, u, rect, true);
                row.length = row.area = 0;
              }
              children.forEach(squarify);
            }
          }
          function stickify(node) {
            var children = node.children;
            if (children && children.length) {
              var rect = pad(node), remaining = children.slice(), child, row = [];
              scale(remaining, rect.dx * rect.dy / node.value);
              row.area = 0;
              while (child = remaining.pop()) {
                row.push(child);
                row.area += child.area;
                if (child.z != null) {
                  position(row, child.z ? rect.dx : rect.dy, rect, !remaining.length);
                  row.length = row.area = 0;
                }
              }
              children.forEach(stickify);
            }
          }
          function worst(row, u) {
            var s = row.area, r, rmax = 0, rmin = Infinity, i = -1, n = row.length;
            while (++i < n) {
              if (!(r = row[i].area)) continue;
              if (r < rmin) rmin = r;
              if (r > rmax) rmax = r;
            }
            s *= s;
            u *= u;
            return s ? Math.max(u * rmax * ratio / s, s / (u * rmin * ratio)) : Infinity;
          }
          function position(row, u, rect, flush) {
            var i = -1, n = row.length, x = rect.x, y = rect.y, v = u ? round(row.area / u) : 0, o;
            if (u == rect.dx) {
              if (flush || v > rect.dy) v = rect.dy;
              while (++i < n) {
                o = row[i];
                o.x = x;
                o.y = y;
                o.dy = v;
                x += o.dx = Math.min(rect.x + rect.dx - x, v ? round(o.area / v) : 0);
              }
              o.z = true;
              o.dx += rect.x + rect.dx - x;
              rect.y += v;
              rect.dy -= v;
            } else {
              if (flush || v > rect.dx) v = rect.dx;
              while (++i < n) {
                o = row[i];
                o.x = x;
                o.y = y;
                o.dx = v;
                y += o.dy = Math.min(rect.y + rect.dy - y, v ? round(o.area / v) : 0);
              }
              o.z = false;
              o.dy += rect.y + rect.dy - y;
              rect.x += v;
              rect.dx -= v;
            }
          }
          function treemap(d) {
            var nodes = stickies || hierarchy(d), root = nodes[0];
            root.x = root.y = 0;
            if (root.value) root.dx = size[0], root.dy = size[1];
            else root.dx = root.dy = 0;
            if (stickies) hierarchy.revalue(root);
            scale([root], root.dx * root.dy / root.value);
            (stickies ? stickify : squarify)(root);
            if (sticky) stickies = nodes;
            return nodes;
          }
          treemap.size = function(x) {
            if (!arguments.length) return size;
            size = x;
            return treemap;
          };
          treemap.padding = function(x) {
            if (!arguments.length) return padding;
            function padFunction(node) {
              var p = x.call(treemap, node, node.depth);
              return p == null ? d3_layout_treemapPadNull(node) : d3_layout_treemapPad(node, typeof p === "number" ? [p, p, p, p] : p);
            }
            function padConstant(node) {
              return d3_layout_treemapPad(node, x);
            }
            var type;
            pad = (padding = x) == null ? d3_layout_treemapPadNull : (type = typeof x) === "function" ? padFunction : type === "number" ? (x = [x, x, x, x], padConstant) : padConstant;
            return treemap;
          };
          treemap.round = function(x) {
            if (!arguments.length) return round != Number;
            round = x ? Math.round : Number;
            return treemap;
          };
          treemap.sticky = function(x) {
            if (!arguments.length) return sticky;
            sticky = x;
            stickies = null;
            return treemap;
          };
          treemap.ratio = function(x) {
            if (!arguments.length) return ratio;
            ratio = x;
            return treemap;
          };
          treemap.mode = function(x) {
            if (!arguments.length) return mode;
            mode = x + "";
            return treemap;
          };
          return d3_layout_hierarchyRebind(treemap, hierarchy);
        };
        function d3_layout_treemapPadNull(node) {
          return {
            x: node.x,
            y: node.y,
            dx: node.dx,
            dy: node.dy
          };
        }
        function d3_layout_treemapPad(node, padding) {
          var x = node.x + padding[3], y = node.y + padding[0], dx = node.dx - padding[1] - padding[3], dy = node.dy - padding[0] - padding[2];
          if (dx < 0) {
            x += dx / 2;
            dx = 0;
          }
          if (dy < 0) {
            y += dy / 2;
            dy = 0;
          }
          return {
            x,
            y,
            dx,
            dy
          };
        }
        d3.random = {
          normal: function(mu, sigma) {
            var n = arguments.length;
            if (n < 2) sigma = 1;
            if (n < 1) mu = 0;
            return function() {
              var x, y, r;
              do {
                x = Math.random() * 2 - 1;
                y = Math.random() * 2 - 1;
                r = x * x + y * y;
              } while (!r || r > 1);
              return mu + sigma * x * Math.sqrt(-2 * Math.log(r) / r);
            };
          },
          logNormal: function() {
            var random = d3.random.normal.apply(d3, arguments);
            return function() {
              return Math.exp(random());
            };
          },
          bates: function(m) {
            var random = d3.random.irwinHall(m);
            return function() {
              return random() / m;
            };
          },
          irwinHall: function(m) {
            return function() {
              for (var s = 0, j = 0; j < m; j++) s += Math.random();
              return s;
            };
          }
        };
        d3.scale = {};
        function d3_scaleExtent(domain) {
          var start = domain[0], stop = domain[domain.length - 1];
          return start < stop ? [start, stop] : [stop, start];
        }
        function d3_scaleRange(scale) {
          return scale.rangeExtent ? scale.rangeExtent() : d3_scaleExtent(scale.range());
        }
        function d3_scale_bilinear(domain, range, uninterpolate, interpolate) {
          var u = uninterpolate(domain[0], domain[1]), i = interpolate(range[0], range[1]);
          return function(x) {
            return i(u(x));
          };
        }
        function d3_scale_nice(domain, nice) {
          var i0 = 0, i1 = domain.length - 1, x0 = domain[i0], x1 = domain[i1], dx;
          if (x1 < x0) {
            dx = i0, i0 = i1, i1 = dx;
            dx = x0, x0 = x1, x1 = dx;
          }
          domain[i0] = nice.floor(x0);
          domain[i1] = nice.ceil(x1);
          return domain;
        }
        function d3_scale_niceStep(step) {
          return step ? {
            floor: function(x) {
              return Math.floor(x / step) * step;
            },
            ceil: function(x) {
              return Math.ceil(x / step) * step;
            }
          } : d3_scale_niceIdentity;
        }
        var d3_scale_niceIdentity = {
          floor: d3_identity,
          ceil: d3_identity
        };
        function d3_scale_polylinear(domain, range, uninterpolate, interpolate) {
          var u = [], i = [], j = 0, k = Math.min(domain.length, range.length) - 1;
          if (domain[k] < domain[0]) {
            domain = domain.slice().reverse();
            range = range.slice().reverse();
          }
          while (++j <= k) {
            u.push(uninterpolate(domain[j - 1], domain[j]));
            i.push(interpolate(range[j - 1], range[j]));
          }
          return function(x) {
            var j2 = d3.bisect(domain, x, 1, k) - 1;
            return i[j2](u[j2](x));
          };
        }
        d3.scale.linear = function() {
          return d3_scale_linear([0, 1], [0, 1], d3_interpolate, false);
        };
        function d3_scale_linear(domain, range, interpolate, clamp) {
          var output, input;
          function rescale() {
            var linear2 = Math.min(domain.length, range.length) > 2 ? d3_scale_polylinear : d3_scale_bilinear, uninterpolate = clamp ? d3_uninterpolateClamp : d3_uninterpolateNumber;
            output = linear2(domain, range, uninterpolate, interpolate);
            input = linear2(range, domain, uninterpolate, d3_interpolate);
            return scale;
          }
          function scale(x) {
            return output(x);
          }
          scale.invert = function(y) {
            return input(y);
          };
          scale.domain = function(x) {
            if (!arguments.length) return domain;
            domain = x.map(Number);
            return rescale();
          };
          scale.range = function(x) {
            if (!arguments.length) return range;
            range = x;
            return rescale();
          };
          scale.rangeRound = function(x) {
            return scale.range(x).interpolate(d3_interpolateRound);
          };
          scale.clamp = function(x) {
            if (!arguments.length) return clamp;
            clamp = x;
            return rescale();
          };
          scale.interpolate = function(x) {
            if (!arguments.length) return interpolate;
            interpolate = x;
            return rescale();
          };
          scale.ticks = function(m) {
            return d3_scale_linearTicks(domain, m);
          };
          scale.tickFormat = function(m, format) {
            return d3_scale_linearTickFormat(domain, m, format);
          };
          scale.nice = function(m) {
            d3_scale_linearNice(domain, m);
            return rescale();
          };
          scale.copy = function() {
            return d3_scale_linear(domain, range, interpolate, clamp);
          };
          return rescale();
        }
        function d3_scale_linearRebind(scale, linear2) {
          return d3.rebind(scale, linear2, "range", "rangeRound", "interpolate", "clamp");
        }
        function d3_scale_linearNice(domain, m) {
          d3_scale_nice(domain, d3_scale_niceStep(d3_scale_linearTickRange(domain, m)[2]));
          d3_scale_nice(domain, d3_scale_niceStep(d3_scale_linearTickRange(domain, m)[2]));
          return domain;
        }
        function d3_scale_linearTickRange(domain, m) {
          if (m == null) m = 10;
          var extent = d3_scaleExtent(domain), span = extent[1] - extent[0], step = Math.pow(10, Math.floor(Math.log(span / m) / Math.LN10)), err = m / span * step;
          if (err <= 0.15) step *= 10;
          else if (err <= 0.35) step *= 5;
          else if (err <= 0.75) step *= 2;
          extent[0] = Math.ceil(extent[0] / step) * step;
          extent[1] = Math.floor(extent[1] / step) * step + step * 0.5;
          extent[2] = step;
          return extent;
        }
        function d3_scale_linearTicks(domain, m) {
          return d3.range.apply(d3, d3_scale_linearTickRange(domain, m));
        }
        var d3_scale_linearFormatSignificant = {
          s: 1,
          g: 1,
          p: 1,
          r: 1,
          e: 1
        };
        function d3_scale_linearPrecision(value) {
          return -Math.floor(Math.log(value) / Math.LN10 + 0.01);
        }
        function d3_scale_linearFormatPrecision(type, range) {
          var p = d3_scale_linearPrecision(range[2]);
          return type in d3_scale_linearFormatSignificant ? Math.abs(p - d3_scale_linearPrecision(Math.max(abs(range[0]), abs(range[1])))) + +(type !== "e") : p - (type === "%") * 2;
        }
        d3.scale.log = function() {
          return d3_scale_log(d3.scale.linear().domain([0, 1]), 10, true, [1, 10]);
        };
        function d3_scale_log(linear2, base, positive, domain) {
          function log(x) {
            return (positive ? Math.log(x < 0 ? 0 : x) : -Math.log(x > 0 ? 0 : -x)) / Math.log(base);
          }
          function pow(x) {
            return positive ? Math.pow(base, x) : -Math.pow(base, -x);
          }
          function scale(x) {
            return linear2(log(x));
          }
          scale.invert = function(x) {
            return pow(linear2.invert(x));
          };
          scale.domain = function(x) {
            if (!arguments.length) return domain;
            positive = x[0] >= 0;
            linear2.domain((domain = x.map(Number)).map(log));
            return scale;
          };
          scale.base = function(_) {
            if (!arguments.length) return base;
            base = +_;
            linear2.domain(domain.map(log));
            return scale;
          };
          scale.nice = function() {
            var niced = d3_scale_nice(domain.map(log), positive ? Math : d3_scale_logNiceNegative);
            linear2.domain(niced);
            domain = niced.map(pow);
            return scale;
          };
          scale.ticks = function() {
            var extent = d3_scaleExtent(domain), ticks = [], u = extent[0], v = extent[1], i = Math.floor(log(u)), j = Math.ceil(log(v)), n = base % 1 ? 2 : base;
            if (isFinite(j - i)) {
              if (positive) {
                for (; i < j; i++) for (var k = 1; k < n; k++) ticks.push(pow(i) * k);
                ticks.push(pow(i));
              } else {
                ticks.push(pow(i));
                for (; i++ < j; ) for (var k = n - 1; k > 0; k--) ticks.push(pow(i) * k);
              }
              for (i = 0; ticks[i] < u; i++) {
              }
              for (j = ticks.length; ticks[j - 1] > v; j--) {
              }
              ticks = ticks.slice(i, j);
            }
            return ticks;
          };
          scale.copy = function() {
            return d3_scale_log(linear2.copy(), base, positive, domain);
          };
          return d3_scale_linearRebind(scale, linear2);
        }
        var d3_scale_logNiceNegative = {
          floor: function(x) {
            return -Math.ceil(-x);
          },
          ceil: function(x) {
            return -Math.floor(-x);
          }
        };
        d3.scale.pow = function() {
          return d3_scale_pow(d3.scale.linear(), 1, [0, 1]);
        };
        function d3_scale_pow(linear2, exponent, domain) {
          var powp = d3_scale_powPow(exponent), powb = d3_scale_powPow(1 / exponent);
          function scale(x) {
            return linear2(powp(x));
          }
          scale.invert = function(x) {
            return powb(linear2.invert(x));
          };
          scale.domain = function(x) {
            if (!arguments.length) return domain;
            linear2.domain((domain = x.map(Number)).map(powp));
            return scale;
          };
          scale.ticks = function(m) {
            return d3_scale_linearTicks(domain, m);
          };
          scale.tickFormat = function(m, format) {
            return d3_scale_linearTickFormat(domain, m, format);
          };
          scale.nice = function(m) {
            return scale.domain(d3_scale_linearNice(domain, m));
          };
          scale.exponent = function(x) {
            if (!arguments.length) return exponent;
            powp = d3_scale_powPow(exponent = x);
            powb = d3_scale_powPow(1 / exponent);
            linear2.domain(domain.map(powp));
            return scale;
          };
          scale.copy = function() {
            return d3_scale_pow(linear2.copy(), exponent, domain);
          };
          return d3_scale_linearRebind(scale, linear2);
        }
        function d3_scale_powPow(e) {
          return function(x) {
            return x < 0 ? -Math.pow(-x, e) : Math.pow(x, e);
          };
        }
        d3.scale.sqrt = function() {
          return d3.scale.pow().exponent(0.5);
        };
        d3.scale.ordinal = function() {
          return d3_scale_ordinal([], {
            t: "range",
            a: [[]]
          });
        };
        function d3_scale_ordinal(domain, ranger) {
          var index, range, rangeBand;
          function scale(x) {
            return range[((index.get(x) || (ranger.t === "range" ? index.set(x, domain.push(x)) : NaN)) - 1) % range.length];
          }
          function steps(start, step) {
            return d3.range(domain.length).map(function(i) {
              return start + step * i;
            });
          }
          scale.domain = function(x) {
            if (!arguments.length) return domain;
            domain = [];
            index = new d3_Map();
            var i = -1, n = x.length, xi;
            while (++i < n) if (!index.has(xi = x[i])) index.set(xi, domain.push(xi));
            return scale[ranger.t].apply(scale, ranger.a);
          };
          scale.range = function(x) {
            if (!arguments.length) return range;
            range = x;
            rangeBand = 0;
            ranger = {
              t: "range",
              a: arguments
            };
            return scale;
          };
          scale.rangePoints = function(x, padding) {
            if (arguments.length < 2) padding = 0;
            var start = x[0], stop = x[1], step = domain.length < 2 ? (start = (start + stop) / 2, 0) : (stop - start) / (domain.length - 1 + padding);
            range = steps(start + step * padding / 2, step);
            rangeBand = 0;
            ranger = {
              t: "rangePoints",
              a: arguments
            };
            return scale;
          };
          scale.rangeRoundPoints = function(x, padding) {
            if (arguments.length < 2) padding = 0;
            var start = x[0], stop = x[1], step = domain.length < 2 ? (start = stop = Math.round((start + stop) / 2), 0) : (stop - start) / (domain.length - 1 + padding) | 0;
            range = steps(start + Math.round(step * padding / 2 + (stop - start - (domain.length - 1 + padding) * step) / 2), step);
            rangeBand = 0;
            ranger = {
              t: "rangeRoundPoints",
              a: arguments
            };
            return scale;
          };
          scale.rangeBands = function(x, padding, outerPadding) {
            if (arguments.length < 2) padding = 0;
            if (arguments.length < 3) outerPadding = padding;
            var reverse = x[1] < x[0], start = x[reverse - 0], stop = x[1 - reverse], step = (stop - start) / (domain.length - padding + 2 * outerPadding);
            range = steps(start + step * outerPadding, step);
            if (reverse) range.reverse();
            rangeBand = step * (1 - padding);
            ranger = {
              t: "rangeBands",
              a: arguments
            };
            return scale;
          };
          scale.rangeRoundBands = function(x, padding, outerPadding) {
            if (arguments.length < 2) padding = 0;
            if (arguments.length < 3) outerPadding = padding;
            var reverse = x[1] < x[0], start = x[reverse - 0], stop = x[1 - reverse], step = Math.floor((stop - start) / (domain.length - padding + 2 * outerPadding));
            range = steps(start + Math.round((stop - start - (domain.length - padding) * step) / 2), step);
            if (reverse) range.reverse();
            rangeBand = Math.round(step * (1 - padding));
            ranger = {
              t: "rangeRoundBands",
              a: arguments
            };
            return scale;
          };
          scale.rangeBand = function() {
            return rangeBand;
          };
          scale.rangeExtent = function() {
            return d3_scaleExtent(ranger.a[0]);
          };
          scale.copy = function() {
            return d3_scale_ordinal(domain, ranger);
          };
          return scale.domain(domain);
        }
        d3.scale.category10 = function() {
          return d3.scale.ordinal().range(d3_category10);
        };
        d3.scale.category20 = function() {
          return d3.scale.ordinal().range(d3_category20);
        };
        d3.scale.category20b = function() {
          return d3.scale.ordinal().range(d3_category20b);
        };
        d3.scale.category20c = function() {
          return d3.scale.ordinal().range(d3_category20c);
        };
        var d3_category10 = [2062260, 16744206, 2924588, 14034728, 9725885, 9197131, 14907330, 8355711, 12369186, 1556175].map(d3_rgbString);
        var d3_category20 = [2062260, 11454440, 16744206, 16759672, 2924588, 10018698, 14034728, 16750742, 9725885, 12955861, 9197131, 12885140, 14907330, 16234194, 8355711, 13092807, 12369186, 14408589, 1556175, 10410725].map(d3_rgbString);
        var d3_category20b = [3750777, 5395619, 7040719, 10264286, 6519097, 9216594, 11915115, 13556636, 9202993, 12426809, 15186514, 15190932, 8666169, 11356490, 14049643, 15177372, 8077683, 10834324, 13528509, 14589654].map(d3_rgbString);
        var d3_category20c = [3244733, 7057110, 10406625, 13032431, 15095053, 16616764, 16625259, 16634018, 3253076, 7652470, 10607003, 13101504, 7695281, 10394312, 12369372, 14342891, 6513507, 9868950, 12434877, 14277081].map(d3_rgbString);
        d3.scale.quantile = function() {
          return d3_scale_quantile([], []);
        };
        function d3_scale_quantile(domain, range) {
          var thresholds;
          function rescale() {
            var k = 0, q = range.length;
            thresholds = [];
            while (++k < q) thresholds[k - 1] = d3.quantile(domain, k / q);
            return scale;
          }
          function scale(x) {
            if (!isNaN(x = +x)) return range[d3.bisect(thresholds, x)];
          }
          scale.domain = function(x) {
            if (!arguments.length) return domain;
            domain = x.map(d3_number).filter(d3_numeric).sort(d3_ascending);
            return rescale();
          };
          scale.range = function(x) {
            if (!arguments.length) return range;
            range = x;
            return rescale();
          };
          scale.quantiles = function() {
            return thresholds;
          };
          scale.invertExtent = function(y) {
            y = range.indexOf(y);
            return y < 0 ? [NaN, NaN] : [y > 0 ? thresholds[y - 1] : domain[0], y < thresholds.length ? thresholds[y] : domain[domain.length - 1]];
          };
          scale.copy = function() {
            return d3_scale_quantile(domain, range);
          };
          return rescale();
        }
        d3.scale.quantize = function() {
          return d3_scale_quantize(0, 1, [0, 1]);
        };
        function d3_scale_quantize(x0, x1, range) {
          var kx, i;
          function scale(x) {
            return range[Math.max(0, Math.min(i, Math.floor(kx * (x - x0))))];
          }
          function rescale() {
            kx = range.length / (x1 - x0);
            i = range.length - 1;
            return scale;
          }
          scale.domain = function(x) {
            if (!arguments.length) return [x0, x1];
            x0 = +x[0];
            x1 = +x[x.length - 1];
            return rescale();
          };
          scale.range = function(x) {
            if (!arguments.length) return range;
            range = x;
            return rescale();
          };
          scale.invertExtent = function(y) {
            y = range.indexOf(y);
            y = y < 0 ? NaN : y / kx + x0;
            return [y, y + 1 / kx];
          };
          scale.copy = function() {
            return d3_scale_quantize(x0, x1, range);
          };
          return rescale();
        }
        d3.scale.threshold = function() {
          return d3_scale_threshold([0.5], [0, 1]);
        };
        function d3_scale_threshold(domain, range) {
          function scale(x) {
            if (x <= x) return range[d3.bisect(domain, x)];
          }
          scale.domain = function(_) {
            if (!arguments.length) return domain;
            domain = _;
            return scale;
          };
          scale.range = function(_) {
            if (!arguments.length) return range;
            range = _;
            return scale;
          };
          scale.invertExtent = function(y) {
            y = range.indexOf(y);
            return [domain[y - 1], domain[y]];
          };
          scale.copy = function() {
            return d3_scale_threshold(domain, range);
          };
          return scale;
        }
        d3.scale.identity = function() {
          return d3_scale_identity([0, 1]);
        };
        function d3_scale_identity(domain) {
          function identity2(x) {
            return +x;
          }
          identity2.invert = identity2;
          identity2.domain = identity2.range = function(x) {
            if (!arguments.length) return domain;
            domain = x.map(identity2);
            return identity2;
          };
          identity2.ticks = function(m) {
            return d3_scale_linearTicks(domain, m);
          };
          identity2.tickFormat = function(m, format) {
            return d3_scale_linearTickFormat(domain, m, format);
          };
          identity2.copy = function() {
            return d3_scale_identity(domain);
          };
          return identity2;
        }
        d3.svg = {};
        function d3_zero() {
          return 0;
        }
        d3.svg.arc = function() {
          var innerRadius = d3_svg_arcInnerRadius, outerRadius = d3_svg_arcOuterRadius, cornerRadius = d3_zero, padRadius = d3_svg_arcAuto, startAngle = d3_svg_arcStartAngle, endAngle = d3_svg_arcEndAngle, padAngle = d3_svg_arcPadAngle;
          function arc() {
            var r0 = Math.max(0, +innerRadius.apply(this, arguments)), r1 = Math.max(0, +outerRadius.apply(this, arguments)), a0 = startAngle.apply(this, arguments) - half\u03C0, a1 = endAngle.apply(this, arguments) - half\u03C0, da = Math.abs(a1 - a0), cw = a0 > a1 ? 0 : 1;
            if (r1 < r0) rc = r1, r1 = r0, r0 = rc;
            if (da >= \u03C4\u03B5) return circleSegment(r1, cw) + (r0 ? circleSegment(r0, 1 - cw) : "") + "Z";
            var rc, cr, rp, ap, p0 = 0, p1 = 0, x0, y0, x1, y1, x2, y2, x3, y3, path = [];
            if (ap = (+padAngle.apply(this, arguments) || 0) / 2) {
              rp = padRadius === d3_svg_arcAuto ? Math.sqrt(r0 * r0 + r1 * r1) : +padRadius.apply(this, arguments);
              if (!cw) p1 *= -1;
              if (r1) p1 = d3_asin(rp / r1 * Math.sin(ap));
              if (r0) p0 = d3_asin(rp / r0 * Math.sin(ap));
            }
            if (r1) {
              x0 = r1 * Math.cos(a0 + p1);
              y0 = r1 * Math.sin(a0 + p1);
              x1 = r1 * Math.cos(a1 - p1);
              y1 = r1 * Math.sin(a1 - p1);
              var l1 = Math.abs(a1 - a0 - 2 * p1) <= \u03C0 ? 0 : 1;
              if (p1 && d3_svg_arcSweep(x0, y0, x1, y1) === cw ^ l1) {
                var h1 = (a0 + a1) / 2;
                x0 = r1 * Math.cos(h1);
                y0 = r1 * Math.sin(h1);
                x1 = y1 = null;
              }
            } else {
              x0 = y0 = 0;
            }
            if (r0) {
              x2 = r0 * Math.cos(a1 - p0);
              y2 = r0 * Math.sin(a1 - p0);
              x3 = r0 * Math.cos(a0 + p0);
              y3 = r0 * Math.sin(a0 + p0);
              var l0 = Math.abs(a0 - a1 + 2 * p0) <= \u03C0 ? 0 : 1;
              if (p0 && d3_svg_arcSweep(x2, y2, x3, y3) === 1 - cw ^ l0) {
                var h0 = (a0 + a1) / 2;
                x2 = r0 * Math.cos(h0);
                y2 = r0 * Math.sin(h0);
                x3 = y3 = null;
              }
            } else {
              x2 = y2 = 0;
            }
            if (da > \u03B5 && (rc = Math.min(Math.abs(r1 - r0) / 2, +cornerRadius.apply(this, arguments))) > 1e-3) {
              cr = r0 < r1 ^ cw ? 0 : 1;
              var rc1 = rc, rc0 = rc;
              if (da < \u03C0) {
                var oc = x3 == null ? [x2, y2] : x1 == null ? [x0, y0] : d3_geom_polygonIntersect([x0, y0], [x3, y3], [x1, y1], [x2, y2]), ax = x0 - oc[0], ay = y0 - oc[1], bx = x1 - oc[0], by = y1 - oc[1], kc = 1 / Math.sin(Math.acos((ax * bx + ay * by) / (Math.sqrt(ax * ax + ay * ay) * Math.sqrt(bx * bx + by * by))) / 2), lc = Math.sqrt(oc[0] * oc[0] + oc[1] * oc[1]);
                rc0 = Math.min(rc, (r0 - lc) / (kc - 1));
                rc1 = Math.min(rc, (r1 - lc) / (kc + 1));
              }
              if (x1 != null) {
                var t30 = d3_svg_arcCornerTangents(x3 == null ? [x2, y2] : [x3, y3], [x0, y0], r1, rc1, cw), t12 = d3_svg_arcCornerTangents([x1, y1], [x2, y2], r1, rc1, cw);
                if (rc === rc1) {
                  path.push("M", t30[0], "A", rc1, ",", rc1, " 0 0,", cr, " ", t30[1], "A", r1, ",", r1, " 0 ", 1 - cw ^ d3_svg_arcSweep(t30[1][0], t30[1][1], t12[1][0], t12[1][1]), ",", cw, " ", t12[1], "A", rc1, ",", rc1, " 0 0,", cr, " ", t12[0]);
                } else {
                  path.push("M", t30[0], "A", rc1, ",", rc1, " 0 1,", cr, " ", t12[0]);
                }
              } else {
                path.push("M", x0, ",", y0);
              }
              if (x3 != null) {
                var t03 = d3_svg_arcCornerTangents([x0, y0], [x3, y3], r0, -rc0, cw), t21 = d3_svg_arcCornerTangents([x2, y2], x1 == null ? [x0, y0] : [x1, y1], r0, -rc0, cw);
                if (rc === rc0) {
                  path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr, " ", t21[1], "A", r0, ",", r0, " 0 ", cw ^ d3_svg_arcSweep(t21[1][0], t21[1][1], t03[1][0], t03[1][1]), ",", 1 - cw, " ", t03[1], "A", rc0, ",", rc0, " 0 0,", cr, " ", t03[0]);
                } else {
                  path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr, " ", t03[0]);
                }
              } else {
                path.push("L", x2, ",", y2);
              }
            } else {
              path.push("M", x0, ",", y0);
              if (x1 != null) path.push("A", r1, ",", r1, " 0 ", l1, ",", cw, " ", x1, ",", y1);
              path.push("L", x2, ",", y2);
              if (x3 != null) path.push("A", r0, ",", r0, " 0 ", l0, ",", 1 - cw, " ", x3, ",", y3);
            }
            path.push("Z");
            return path.join("");
          }
          function circleSegment(r1, cw) {
            return "M0," + r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + -r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + r1;
          }
          arc.innerRadius = function(v) {
            if (!arguments.length) return innerRadius;
            innerRadius = d3_functor(v);
            return arc;
          };
          arc.outerRadius = function(v) {
            if (!arguments.length) return outerRadius;
            outerRadius = d3_functor(v);
            return arc;
          };
          arc.cornerRadius = function(v) {
            if (!arguments.length) return cornerRadius;
            cornerRadius = d3_functor(v);
            return arc;
          };
          arc.padRadius = function(v) {
            if (!arguments.length) return padRadius;
            padRadius = v == d3_svg_arcAuto ? d3_svg_arcAuto : d3_functor(v);
            return arc;
          };
          arc.startAngle = function(v) {
            if (!arguments.length) return startAngle;
            startAngle = d3_functor(v);
            return arc;
          };
          arc.endAngle = function(v) {
            if (!arguments.length) return endAngle;
            endAngle = d3_functor(v);
            return arc;
          };
          arc.padAngle = function(v) {
            if (!arguments.length) return padAngle;
            padAngle = d3_functor(v);
            return arc;
          };
          arc.centroid = function() {
            var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - half\u03C0;
            return [Math.cos(a) * r, Math.sin(a) * r];
          };
          return arc;
        };
        var d3_svg_arcAuto = "auto";
        function d3_svg_arcInnerRadius(d) {
          return d.innerRadius;
        }
        function d3_svg_arcOuterRadius(d) {
          return d.outerRadius;
        }
        function d3_svg_arcStartAngle(d) {
          return d.startAngle;
        }
        function d3_svg_arcEndAngle(d) {
          return d.endAngle;
        }
        function d3_svg_arcPadAngle(d) {
          return d && d.padAngle;
        }
        function d3_svg_arcSweep(x0, y0, x1, y1) {
          return (x0 - x1) * y0 - (y0 - y1) * x0 > 0 ? 0 : 1;
        }
        function d3_svg_arcCornerTangents(p0, p1, r1, rc, cw) {
          var x01 = p0[0] - p1[0], y01 = p0[1] - p1[1], lo = (cw ? rc : -rc) / Math.sqrt(x01 * x01 + y01 * y01), ox = lo * y01, oy = -lo * x01, x1 = p0[0] + ox, y1 = p0[1] + oy, x2 = p1[0] + ox, y2 = p1[1] + oy, x3 = (x1 + x2) / 2, y3 = (y1 + y2) / 2, dx = x2 - x1, dy = y2 - y1, d2 = dx * dx + dy * dy, r = r1 - rc, D2 = x1 * y2 - x2 * y1, d = (dy < 0 ? -1 : 1) * Math.sqrt(Math.max(0, r * r * d2 - D2 * D2)), cx0 = (D2 * dy - dx * d) / d2, cy0 = (-D2 * dx - dy * d) / d2, cx1 = (D2 * dy + dx * d) / d2, cy1 = (-D2 * dx + dy * d) / d2, dx0 = cx0 - x3, dy0 = cy0 - y3, dx1 = cx1 - x3, dy1 = cy1 - y3;
          if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;
          return [[cx0 - ox, cy0 - oy], [cx0 * r1 / r, cy0 * r1 / r]];
        }
        function d3_true() {
          return true;
        }
        function d3_svg_line(projection) {
          var x = d3_geom_pointX, y = d3_geom_pointY, defined = d3_true, interpolate = d3_svg_lineLinear, interpolateKey = interpolate.key, tension = 0.7;
          function line(data) {
            var segments = [], points = [], i = -1, n = data.length, d, fx = d3_functor(x), fy = d3_functor(y);
            function segment() {
              segments.push("M", interpolate(projection(points), tension));
            }
            while (++i < n) {
              if (defined.call(this, d = data[i], i)) {
                points.push([+fx.call(this, d, i), +fy.call(this, d, i)]);
              } else if (points.length) {
                segment();
                points = [];
              }
            }
            if (points.length) segment();
            return segments.length ? segments.join("") : null;
          }
          line.x = function(_) {
            if (!arguments.length) return x;
            x = _;
            return line;
          };
          line.y = function(_) {
            if (!arguments.length) return y;
            y = _;
            return line;
          };
          line.defined = function(_) {
            if (!arguments.length) return defined;
            defined = _;
            return line;
          };
          line.interpolate = function(_) {
            if (!arguments.length) return interpolateKey;
            if (typeof _ === "function") interpolateKey = interpolate = _;
            else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
            return line;
          };
          line.tension = function(_) {
            if (!arguments.length) return tension;
            tension = _;
            return line;
          };
          return line;
        }
        d3.svg.line = function() {
          return d3_svg_line(d3_identity);
        };
        var d3_svg_lineInterpolators = d3.map({
          linear: d3_svg_lineLinear,
          "linear-closed": d3_svg_lineLinearClosed,
          step: d3_svg_lineStep,
          "step-before": d3_svg_lineStepBefore,
          "step-after": d3_svg_lineStepAfter,
          basis: d3_svg_lineBasis,
          "basis-open": d3_svg_lineBasisOpen,
          "basis-closed": d3_svg_lineBasisClosed,
          bundle: d3_svg_lineBundle,
          cardinal: d3_svg_lineCardinal,
          "cardinal-open": d3_svg_lineCardinalOpen,
          "cardinal-closed": d3_svg_lineCardinalClosed,
          monotone: d3_svg_lineMonotone
        });
        d3_svg_lineInterpolators.forEach(function(key, value) {
          value.key = key;
          value.closed = /-closed$/.test(key);
        });
        function d3_svg_lineLinear(points) {
          return points.length > 1 ? points.join("L") : points + "Z";
        }
        function d3_svg_lineLinearClosed(points) {
          return points.join("L") + "Z";
        }
        function d3_svg_lineStep(points) {
          var i = 0, n = points.length, p = points[0], path = [p[0], ",", p[1]];
          while (++i < n) path.push("H", (p[0] + (p = points[i])[0]) / 2, "V", p[1]);
          if (n > 1) path.push("H", p[0]);
          return path.join("");
        }
        function d3_svg_lineStepBefore(points) {
          var i = 0, n = points.length, p = points[0], path = [p[0], ",", p[1]];
          while (++i < n) path.push("V", (p = points[i])[1], "H", p[0]);
          return path.join("");
        }
        function d3_svg_lineStepAfter(points) {
          var i = 0, n = points.length, p = points[0], path = [p[0], ",", p[1]];
          while (++i < n) path.push("H", (p = points[i])[0], "V", p[1]);
          return path.join("");
        }
        function d3_svg_lineCardinalOpen(points, tension) {
          return points.length < 4 ? d3_svg_lineLinear(points) : points[1] + d3_svg_lineHermite(points.slice(1, -1), d3_svg_lineCardinalTangents(points, tension));
        }
        function d3_svg_lineCardinalClosed(points, tension) {
          return points.length < 3 ? d3_svg_lineLinearClosed(points) : points[0] + d3_svg_lineHermite((points.push(points[0]), points), d3_svg_lineCardinalTangents([points[points.length - 2]].concat(points, [points[1]]), tension));
        }
        function d3_svg_lineCardinal(points, tension) {
          return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineCardinalTangents(points, tension));
        }
        function d3_svg_lineHermite(points, tangents) {
          if (tangents.length < 1 || points.length != tangents.length && points.length != tangents.length + 2) {
            return d3_svg_lineLinear(points);
          }
          var quad = points.length != tangents.length, path = "", p0 = points[0], p = points[1], t02 = tangents[0], t = t02, pi = 1;
          if (quad) {
            path += "Q" + (p[0] - t02[0] * 2 / 3) + "," + (p[1] - t02[1] * 2 / 3) + "," + p[0] + "," + p[1];
            p0 = points[1];
            pi = 2;
          }
          if (tangents.length > 1) {
            t = tangents[1];
            p = points[pi];
            pi++;
            path += "C" + (p0[0] + t02[0]) + "," + (p0[1] + t02[1]) + "," + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
            for (var i = 2; i < tangents.length; i++, pi++) {
              p = points[pi];
              t = tangents[i];
              path += "S" + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
            }
          }
          if (quad) {
            var lp = points[pi];
            path += "Q" + (p[0] + t[0] * 2 / 3) + "," + (p[1] + t[1] * 2 / 3) + "," + lp[0] + "," + lp[1];
          }
          return path;
        }
        function d3_svg_lineCardinalTangents(points, tension) {
          var tangents = [], a = (1 - tension) / 2, p0, p1 = points[0], p2 = points[1], i = 1, n = points.length;
          while (++i < n) {
            p0 = p1;
            p1 = p2;
            p2 = points[i];
            tangents.push([a * (p2[0] - p0[0]), a * (p2[1] - p0[1])]);
          }
          return tangents;
        }
        function d3_svg_lineBasis(points) {
          if (points.length < 3) return d3_svg_lineLinear(points);
          var i = 1, n = points.length, pi = points[0], x0 = pi[0], y0 = pi[1], px = [x0, x0, x0, (pi = points[1])[0]], py = [y0, y0, y0, pi[1]], path = [x0, ",", y0, "L", d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)];
          points.push(points[n - 1]);
          while (++i <= n) {
            pi = points[i];
            px.shift();
            px.push(pi[0]);
            py.shift();
            py.push(pi[1]);
            d3_svg_lineBasisBezier(path, px, py);
          }
          points.pop();
          path.push("L", pi);
          return path.join("");
        }
        function d3_svg_lineBasisOpen(points) {
          if (points.length < 4) return d3_svg_lineLinear(points);
          var path = [], i = -1, n = points.length, pi, px = [0], py = [0];
          while (++i < 3) {
            pi = points[i];
            px.push(pi[0]);
            py.push(pi[1]);
          }
          path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3, px) + "," + d3_svg_lineDot4(d3_svg_lineBasisBezier3, py));
          --i;
          while (++i < n) {
            pi = points[i];
            px.shift();
            px.push(pi[0]);
            py.shift();
            py.push(pi[1]);
            d3_svg_lineBasisBezier(path, px, py);
          }
          return path.join("");
        }
        function d3_svg_lineBasisClosed(points) {
          var path, i = -1, n = points.length, m = n + 4, pi, px = [], py = [];
          while (++i < 4) {
            pi = points[i % n];
            px.push(pi[0]);
            py.push(pi[1]);
          }
          path = [d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)];
          --i;
          while (++i < m) {
            pi = points[i % n];
            px.shift();
            px.push(pi[0]);
            py.shift();
            py.push(pi[1]);
            d3_svg_lineBasisBezier(path, px, py);
          }
          return path.join("");
        }
        function d3_svg_lineBundle(points, tension) {
          var n = points.length - 1;
          if (n) {
            var x0 = points[0][0], y0 = points[0][1], dx = points[n][0] - x0, dy = points[n][1] - y0, i = -1, p, t;
            while (++i <= n) {
              p = points[i];
              t = i / n;
              p[0] = tension * p[0] + (1 - tension) * (x0 + t * dx);
              p[1] = tension * p[1] + (1 - tension) * (y0 + t * dy);
            }
          }
          return d3_svg_lineBasis(points);
        }
        function d3_svg_lineDot4(a, b) {
          return a[0] * b[0] + a[1] * b[1] + a[2] * b[2] + a[3] * b[3];
        }
        var d3_svg_lineBasisBezier1 = [0, 2 / 3, 1 / 3, 0], d3_svg_lineBasisBezier2 = [0, 1 / 3, 2 / 3, 0], d3_svg_lineBasisBezier3 = [0, 1 / 6, 2 / 3, 1 / 6];
        function d3_svg_lineBasisBezier(path, x, y) {
          path.push("C", d3_svg_lineDot4(d3_svg_lineBasisBezier1, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier1, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, y));
        }
        function d3_svg_lineSlope(p0, p1) {
          return (p1[1] - p0[1]) / (p1[0] - p0[0]);
        }
        function d3_svg_lineFiniteDifferences(points) {
          var i = 0, j = points.length - 1, m = [], p0 = points[0], p1 = points[1], d = m[0] = d3_svg_lineSlope(p0, p1);
          while (++i < j) {
            m[i] = (d + (d = d3_svg_lineSlope(p0 = p1, p1 = points[i + 1]))) / 2;
          }
          m[i] = d;
          return m;
        }
        function d3_svg_lineMonotoneTangents(points) {
          var tangents = [], d, a, b, s, m = d3_svg_lineFiniteDifferences(points), i = -1, j = points.length - 1;
          while (++i < j) {
            d = d3_svg_lineSlope(points[i], points[i + 1]);
            if (abs(d) < \u03B5) {
              m[i] = m[i + 1] = 0;
            } else {
              a = m[i] / d;
              b = m[i + 1] / d;
              s = a * a + b * b;
              if (s > 9) {
                s = d * 3 / Math.sqrt(s);
                m[i] = s * a;
                m[i + 1] = s * b;
              }
            }
          }
          i = -1;
          while (++i <= j) {
            s = (points[Math.min(j, i + 1)][0] - points[Math.max(0, i - 1)][0]) / (6 * (1 + m[i] * m[i]));
            tangents.push([s || 0, m[i] * s || 0]);
          }
          return tangents;
        }
        function d3_svg_lineMonotone(points) {
          return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineMonotoneTangents(points));
        }
        d3.svg.line.radial = function() {
          var line = d3_svg_line(d3_svg_lineRadial);
          line.radius = line.x, delete line.x;
          line.angle = line.y, delete line.y;
          return line;
        };
        function d3_svg_lineRadial(points) {
          var point, i = -1, n = points.length, r, a;
          while (++i < n) {
            point = points[i];
            r = point[0];
            a = point[1] - half\u03C0;
            point[0] = r * Math.cos(a);
            point[1] = r * Math.sin(a);
          }
          return points;
        }
        function d3_svg_area(projection) {
          var x0 = d3_geom_pointX, x1 = d3_geom_pointX, y0 = 0, y1 = d3_geom_pointY, defined = d3_true, interpolate = d3_svg_lineLinear, interpolateKey = interpolate.key, interpolateReverse = interpolate, L = "L", tension = 0.7;
          function area(data) {
            var segments = [], points0 = [], points1 = [], i = -1, n = data.length, d, fx0 = d3_functor(x0), fy0 = d3_functor(y0), fx1 = x0 === x1 ? function() {
              return x;
            } : d3_functor(x1), fy1 = y0 === y1 ? function() {
              return y;
            } : d3_functor(y1), x, y;
            function segment() {
              segments.push("M", interpolate(projection(points1), tension), L, interpolateReverse(projection(points0.reverse()), tension), "Z");
            }
            while (++i < n) {
              if (defined.call(this, d = data[i], i)) {
                points0.push([x = +fx0.call(this, d, i), y = +fy0.call(this, d, i)]);
                points1.push([+fx1.call(this, d, i), +fy1.call(this, d, i)]);
              } else if (points0.length) {
                segment();
                points0 = [];
                points1 = [];
              }
            }
            if (points0.length) segment();
            return segments.length ? segments.join("") : null;
          }
          area.x = function(_) {
            if (!arguments.length) return x1;
            x0 = x1 = _;
            return area;
          };
          area.x0 = function(_) {
            if (!arguments.length) return x0;
            x0 = _;
            return area;
          };
          area.x1 = function(_) {
            if (!arguments.length) return x1;
            x1 = _;
            return area;
          };
          area.y = function(_) {
            if (!arguments.length) return y1;
            y0 = y1 = _;
            return area;
          };
          area.y0 = function(_) {
            if (!arguments.length) return y0;
            y0 = _;
            return area;
          };
          area.y1 = function(_) {
            if (!arguments.length) return y1;
            y1 = _;
            return area;
          };
          area.defined = function(_) {
            if (!arguments.length) return defined;
            defined = _;
            return area;
          };
          area.interpolate = function(_) {
            if (!arguments.length) return interpolateKey;
            if (typeof _ === "function") interpolateKey = interpolate = _;
            else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
            interpolateReverse = interpolate.reverse || interpolate;
            L = interpolate.closed ? "M" : "L";
            return area;
          };
          area.tension = function(_) {
            if (!arguments.length) return tension;
            tension = _;
            return area;
          };
          return area;
        }
        d3_svg_lineStepBefore.reverse = d3_svg_lineStepAfter;
        d3_svg_lineStepAfter.reverse = d3_svg_lineStepBefore;
        d3.svg.area = function() {
          return d3_svg_area(d3_identity);
        };
        d3.svg.area.radial = function() {
          var area = d3_svg_area(d3_svg_lineRadial);
          area.radius = area.x, delete area.x;
          area.innerRadius = area.x0, delete area.x0;
          area.outerRadius = area.x1, delete area.x1;
          area.angle = area.y, delete area.y;
          area.startAngle = area.y0, delete area.y0;
          area.endAngle = area.y1, delete area.y1;
          return area;
        };
        function d3_source(d) {
          return d.source;
        }
        function d3_target(d) {
          return d.target;
        }
        d3.svg.chord = function() {
          var source = d3_source, target = d3_target, radius = d3_svg_chordRadius, startAngle = d3_svg_arcStartAngle, endAngle = d3_svg_arcEndAngle;
          function chord(d, i) {
            var s = subgroup(this, source, d, i), t = subgroup(this, target, d, i);
            return "M" + s.p0 + arc(s.r, s.p1, s.a1 - s.a0) + (equals(s, t) ? curve(s.r, s.p1, s.r, s.p0) : curve(s.r, s.p1, t.r, t.p0) + arc(t.r, t.p1, t.a1 - t.a0) + curve(t.r, t.p1, s.r, s.p0)) + "Z";
          }
          function subgroup(self2, f, d, i) {
            var subgroup2 = f.call(self2, d, i), r = radius.call(self2, subgroup2, i), a0 = startAngle.call(self2, subgroup2, i) - half\u03C0, a1 = endAngle.call(self2, subgroup2, i) - half\u03C0;
            return {
              r,
              a0,
              a1,
              p0: [r * Math.cos(a0), r * Math.sin(a0)],
              p1: [r * Math.cos(a1), r * Math.sin(a1)]
            };
          }
          function equals(a, b) {
            return a.a0 == b.a0 && a.a1 == b.a1;
          }
          function arc(r, p, a) {
            return "A" + r + "," + r + " 0 " + +(a > \u03C0) + ",1 " + p;
          }
          function curve(r0, p0, r1, p1) {
            return "Q 0,0 " + p1;
          }
          chord.radius = function(v) {
            if (!arguments.length) return radius;
            radius = d3_functor(v);
            return chord;
          };
          chord.source = function(v) {
            if (!arguments.length) return source;
            source = d3_functor(v);
            return chord;
          };
          chord.target = function(v) {
            if (!arguments.length) return target;
            target = d3_functor(v);
            return chord;
          };
          chord.startAngle = function(v) {
            if (!arguments.length) return startAngle;
            startAngle = d3_functor(v);
            return chord;
          };
          chord.endAngle = function(v) {
            if (!arguments.length) return endAngle;
            endAngle = d3_functor(v);
            return chord;
          };
          return chord;
        };
        function d3_svg_chordRadius(d) {
          return d.radius;
        }
        d3.svg.diagonal = function() {
          var source = d3_source, target = d3_target, projection = d3_svg_diagonalProjection;
          function diagonal(d, i) {
            var p0 = source.call(this, d, i), p3 = target.call(this, d, i), m = (p0.y + p3.y) / 2, p = [p0, {
              x: p0.x,
              y: m
            }, {
              x: p3.x,
              y: m
            }, p3];
            p = p.map(projection);
            return "M" + p[0] + "C" + p[1] + " " + p[2] + " " + p[3];
          }
          diagonal.source = function(x) {
            if (!arguments.length) return source;
            source = d3_functor(x);
            return diagonal;
          };
          diagonal.target = function(x) {
            if (!arguments.length) return target;
            target = d3_functor(x);
            return diagonal;
          };
          diagonal.projection = function(x) {
            if (!arguments.length) return projection;
            projection = x;
            return diagonal;
          };
          return diagonal;
        };
        function d3_svg_diagonalProjection(d) {
          return [d.x, d.y];
        }
        d3.svg.diagonal.radial = function() {
          var diagonal = d3.svg.diagonal(), projection = d3_svg_diagonalProjection, projection_ = diagonal.projection;
          diagonal.projection = function(x) {
            return arguments.length ? projection_(d3_svg_diagonalRadialProjection(projection = x)) : projection;
          };
          return diagonal;
        };
        function d3_svg_diagonalRadialProjection(projection) {
          return function() {
            var d = projection.apply(this, arguments), r = d[0], a = d[1] - half\u03C0;
            return [r * Math.cos(a), r * Math.sin(a)];
          };
        }
        d3.svg.symbol = function() {
          var type = d3_svg_symbolType, size = d3_svg_symbolSize;
          function symbol(d, i) {
            return (d3_svg_symbols.get(type.call(this, d, i)) || d3_svg_symbolCircle)(size.call(this, d, i));
          }
          symbol.type = function(x) {
            if (!arguments.length) return type;
            type = d3_functor(x);
            return symbol;
          };
          symbol.size = function(x) {
            if (!arguments.length) return size;
            size = d3_functor(x);
            return symbol;
          };
          return symbol;
        };
        function d3_svg_symbolSize() {
          return 64;
        }
        function d3_svg_symbolType() {
          return "circle";
        }
        function d3_svg_symbolCircle(size) {
          var r = Math.sqrt(size / \u03C0);
          return "M0," + r + "A" + r + "," + r + " 0 1,1 0," + -r + "A" + r + "," + r + " 0 1,1 0," + r + "Z";
        }
        var d3_svg_symbols = d3.map({
          circle: d3_svg_symbolCircle,
          cross: function(size) {
            var r = Math.sqrt(size / 5) / 2;
            return "M" + -3 * r + "," + -r + "H" + -r + "V" + -3 * r + "H" + r + "V" + -r + "H" + 3 * r + "V" + r + "H" + r + "V" + 3 * r + "H" + -r + "V" + r + "H" + -3 * r + "Z";
          },
          diamond: function(size) {
            var ry = Math.sqrt(size / (2 * d3_svg_symbolTan30)), rx = ry * d3_svg_symbolTan30;
            return "M0," + -ry + "L" + rx + ",0 0," + ry + " " + -rx + ",0Z";
          },
          square: function(size) {
            var r = Math.sqrt(size) / 2;
            return "M" + -r + "," + -r + "L" + r + "," + -r + " " + r + "," + r + " " + -r + "," + r + "Z";
          },
          "triangle-down": function(size) {
            var rx = Math.sqrt(size / d3_svg_symbolSqrt3), ry = rx * d3_svg_symbolSqrt3 / 2;
            return "M0," + ry + "L" + rx + "," + -ry + " " + -rx + "," + -ry + "Z";
          },
          "triangle-up": function(size) {
            var rx = Math.sqrt(size / d3_svg_symbolSqrt3), ry = rx * d3_svg_symbolSqrt3 / 2;
            return "M0," + -ry + "L" + rx + "," + ry + " " + -rx + "," + ry + "Z";
          }
        });
        d3.svg.symbolTypes = d3_svg_symbols.keys();
        var d3_svg_symbolSqrt3 = Math.sqrt(3), d3_svg_symbolTan30 = Math.tan(30 * d3_radians);
        d3_selectionPrototype.transition = function(name2) {
          var id = d3_transitionInheritId || ++d3_transitionId, ns = d3_transitionNamespace(name2), subgroups = [], subgroup, node, transition = d3_transitionInherit || {
            time: Date.now(),
            ease: d3_ease_cubicInOut,
            delay: 0,
            duration: 250
          };
          for (var j = -1, m = this.length; ++j < m; ) {
            subgroups.push(subgroup = []);
            for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
              if (node = group[i]) d3_transitionNode(node, i, ns, id, transition);
              subgroup.push(node);
            }
          }
          return d3_transition(subgroups, ns, id);
        };
        d3_selectionPrototype.interrupt = function(name2) {
          return this.each(name2 == null ? d3_selection_interrupt : d3_selection_interruptNS(d3_transitionNamespace(name2)));
        };
        var d3_selection_interrupt = d3_selection_interruptNS(d3_transitionNamespace());
        function d3_selection_interruptNS(ns) {
          return function() {
            var lock, activeId, active;
            if ((lock = this[ns]) && (active = lock[activeId = lock.active])) {
              active.timer.c = null;
              active.timer.t = NaN;
              if (--lock.count) delete lock[activeId];
              else delete this[ns];
              lock.active += 0.5;
              active.event && active.event.interrupt.call(this, this.__data__, active.index);
            }
          };
        }
        function d3_transition(groups, ns, id) {
          d3_subclass(groups, d3_transitionPrototype);
          groups.namespace = ns;
          groups.id = id;
          return groups;
        }
        var d3_transitionPrototype = [], d3_transitionId = 0, d3_transitionInheritId, d3_transitionInherit;
        d3_transitionPrototype.call = d3_selectionPrototype.call;
        d3_transitionPrototype.empty = d3_selectionPrototype.empty;
        d3_transitionPrototype.node = d3_selectionPrototype.node;
        d3_transitionPrototype.size = d3_selectionPrototype.size;
        d3.transition = function(selection, name2) {
          return selection && selection.transition ? d3_transitionInheritId ? selection.transition(name2) : selection : d3.selection().transition(selection);
        };
        d3.transition.prototype = d3_transitionPrototype;
        d3_transitionPrototype.select = function(selector) {
          var id = this.id, ns = this.namespace, subgroups = [], subgroup, subnode, node;
          selector = d3_selection_selector(selector);
          for (var j = -1, m = this.length; ++j < m; ) {
            subgroups.push(subgroup = []);
            for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
              if ((node = group[i]) && (subnode = selector.call(node, node.__data__, i, j))) {
                if ("__data__" in node) subnode.__data__ = node.__data__;
                d3_transitionNode(subnode, i, ns, id, node[ns][id]);
                subgroup.push(subnode);
              } else {
                subgroup.push(null);
              }
            }
          }
          return d3_transition(subgroups, ns, id);
        };
        d3_transitionPrototype.selectAll = function(selector) {
          var id = this.id, ns = this.namespace, subgroups = [], subgroup, subnodes, node, subnode, transition;
          selector = d3_selection_selectorAll(selector);
          for (var j = -1, m = this.length; ++j < m; ) {
            for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
              if (node = group[i]) {
                transition = node[ns][id];
                subnodes = selector.call(node, node.__data__, i, j);
                subgroups.push(subgroup = []);
                for (var k = -1, o = subnodes.length; ++k < o; ) {
                  if (subnode = subnodes[k]) d3_transitionNode(subnode, k, ns, id, transition);
                  subgroup.push(subnode);
                }
              }
            }
          }
          return d3_transition(subgroups, ns, id);
        };
        d3_transitionPrototype.filter = function(filter) {
          var subgroups = [], subgroup, group, node;
          if (typeof filter !== "function") filter = d3_selection_filter(filter);
          for (var j = 0, m = this.length; j < m; j++) {
            subgroups.push(subgroup = []);
            for (var group = this[j], i = 0, n = group.length; i < n; i++) {
              if ((node = group[i]) && filter.call(node, node.__data__, i, j)) {
                subgroup.push(node);
              }
            }
          }
          return d3_transition(subgroups, this.namespace, this.id);
        };
        d3_transitionPrototype.tween = function(name2, tween) {
          var id = this.id, ns = this.namespace;
          if (arguments.length < 2) return this.node()[ns][id].tween.get(name2);
          return d3_selection_each(this, tween == null ? function(node) {
            node[ns][id].tween.remove(name2);
          } : function(node) {
            node[ns][id].tween.set(name2, tween);
          });
        };
        function d3_transition_tween(groups, name2, value, tween) {
          var id = groups.id, ns = groups.namespace;
          return d3_selection_each(groups, typeof value === "function" ? function(node, i, j) {
            node[ns][id].tween.set(name2, tween(value.call(node, node.__data__, i, j)));
          } : (value = tween(value), function(node) {
            node[ns][id].tween.set(name2, value);
          }));
        }
        d3_transitionPrototype.attr = function(nameNS, value) {
          if (arguments.length < 2) {
            for (value in nameNS) this.attr(value, nameNS[value]);
            return this;
          }
          var interpolate = nameNS == "transform" ? d3_interpolateTransform : d3_interpolate, name2 = d3.ns.qualify(nameNS);
          function attrNull() {
            this.removeAttribute(name2);
          }
          function attrNullNS() {
            this.removeAttributeNS(name2.space, name2.local);
          }
          function attrTween(b) {
            return b == null ? attrNull : (b += "", function() {
              var a = this.getAttribute(name2), i;
              return a !== b && (i = interpolate(a, b), function(t) {
                this.setAttribute(name2, i(t));
              });
            });
          }
          function attrTweenNS(b) {
            return b == null ? attrNullNS : (b += "", function() {
              var a = this.getAttributeNS(name2.space, name2.local), i;
              return a !== b && (i = interpolate(a, b), function(t) {
                this.setAttributeNS(name2.space, name2.local, i(t));
              });
            });
          }
          return d3_transition_tween(this, "attr." + nameNS, value, name2.local ? attrTweenNS : attrTween);
        };
        d3_transitionPrototype.attrTween = function(nameNS, tween) {
          var name2 = d3.ns.qualify(nameNS);
          function attrTween(d, i) {
            var f = tween.call(this, d, i, this.getAttribute(name2));
            return f && function(t) {
              this.setAttribute(name2, f(t));
            };
          }
          function attrTweenNS(d, i) {
            var f = tween.call(this, d, i, this.getAttributeNS(name2.space, name2.local));
            return f && function(t) {
              this.setAttributeNS(name2.space, name2.local, f(t));
            };
          }
          return this.tween("attr." + nameNS, name2.local ? attrTweenNS : attrTween);
        };
        d3_transitionPrototype.style = function(name2, value, priority) {
          var n = arguments.length;
          if (n < 3) {
            if (typeof name2 !== "string") {
              if (n < 2) value = "";
              for (priority in name2) this.style(priority, name2[priority], value);
              return this;
            }
            priority = "";
          }
          function styleNull() {
            this.style.removeProperty(name2);
          }
          function styleString(b) {
            return b == null ? styleNull : (b += "", function() {
              var a = d3_window(this).getComputedStyle(this, null).getPropertyValue(name2), i;
              return a !== b && (i = d3_interpolate(a, b), function(t) {
                this.style.setProperty(name2, i(t), priority);
              });
            });
          }
          return d3_transition_tween(this, "style." + name2, value, styleString);
        };
        d3_transitionPrototype.styleTween = function(name2, tween, priority) {
          if (arguments.length < 3) priority = "";
          function styleTween(d, i) {
            var f = tween.call(this, d, i, d3_window(this).getComputedStyle(this, null).getPropertyValue(name2));
            return f && function(t) {
              this.style.setProperty(name2, f(t), priority);
            };
          }
          return this.tween("style." + name2, styleTween);
        };
        d3_transitionPrototype.text = function(value) {
          return d3_transition_tween(this, "text", value, d3_transition_text);
        };
        function d3_transition_text(b) {
          if (b == null) b = "";
          return function() {
            this.textContent = b;
          };
        }
        d3_transitionPrototype.remove = function() {
          var ns = this.namespace;
          return this.each("end.transition", function() {
            var p;
            if (this[ns].count < 2 && (p = this.parentNode)) p.removeChild(this);
          });
        };
        d3_transitionPrototype.ease = function(value) {
          var id = this.id, ns = this.namespace;
          if (arguments.length < 1) return this.node()[ns][id].ease;
          if (typeof value !== "function") value = d3.ease.apply(d3, arguments);
          return d3_selection_each(this, function(node) {
            node[ns][id].ease = value;
          });
        };
        d3_transitionPrototype.delay = function(value) {
          var id = this.id, ns = this.namespace;
          if (arguments.length < 1) return this.node()[ns][id].delay;
          return d3_selection_each(this, typeof value === "function" ? function(node, i, j) {
            node[ns][id].delay = +value.call(node, node.__data__, i, j);
          } : (value = +value, function(node) {
            node[ns][id].delay = value;
          }));
        };
        d3_transitionPrototype.duration = function(value) {
          var id = this.id, ns = this.namespace;
          if (arguments.length < 1) return this.node()[ns][id].duration;
          return d3_selection_each(this, typeof value === "function" ? function(node, i, j) {
            node[ns][id].duration = Math.max(1, value.call(node, node.__data__, i, j));
          } : (value = Math.max(1, value), function(node) {
            node[ns][id].duration = value;
          }));
        };
        d3_transitionPrototype.each = function(type, listener) {
          var id = this.id, ns = this.namespace;
          if (arguments.length < 2) {
            var inherit = d3_transitionInherit, inheritId = d3_transitionInheritId;
            try {
              d3_transitionInheritId = id;
              d3_selection_each(this, function(node, i, j) {
                d3_transitionInherit = node[ns][id];
                type.call(node, node.__data__, i, j);
              });
            } finally {
              d3_transitionInherit = inherit;
              d3_transitionInheritId = inheritId;
            }
          } else {
            d3_selection_each(this, function(node) {
              var transition = node[ns][id];
              (transition.event || (transition.event = d3.dispatch("start", "end", "interrupt"))).on(type, listener);
            });
          }
          return this;
        };
        d3_transitionPrototype.transition = function() {
          var id0 = this.id, id1 = ++d3_transitionId, ns = this.namespace, subgroups = [], subgroup, group, node, transition;
          for (var j = 0, m = this.length; j < m; j++) {
            subgroups.push(subgroup = []);
            for (var group = this[j], i = 0, n = group.length; i < n; i++) {
              if (node = group[i]) {
                transition = node[ns][id0];
                d3_transitionNode(node, i, ns, id1, {
                  time: transition.time,
                  ease: transition.ease,
                  delay: transition.delay + transition.duration,
                  duration: transition.duration
                });
              }
              subgroup.push(node);
            }
          }
          return d3_transition(subgroups, ns, id1);
        };
        function d3_transitionNamespace(name2) {
          return name2 == null ? "__transition__" : "__transition_" + name2 + "__";
        }
        function d3_transitionNode(node, i, ns, id, inherit) {
          var lock = node[ns] || (node[ns] = {
            active: 0,
            count: 0
          }), transition = lock[id], time, timer, duration, ease, tweens;
          function schedule(elapsed) {
            var delay = transition.delay;
            timer.t = delay + time;
            if (delay <= elapsed) return start(elapsed - delay);
            timer.c = start;
          }
          function start(elapsed) {
            var activeId = lock.active, active = lock[activeId];
            if (active) {
              active.timer.c = null;
              active.timer.t = NaN;
              --lock.count;
              delete lock[activeId];
              active.event && active.event.interrupt.call(node, node.__data__, active.index);
            }
            for (var cancelId in lock) {
              if (+cancelId < id) {
                var cancel = lock[cancelId];
                cancel.timer.c = null;
                cancel.timer.t = NaN;
                --lock.count;
                delete lock[cancelId];
              }
            }
            timer.c = tick;
            d3_timer(function() {
              if (timer.c && tick(elapsed || 1)) {
                timer.c = null;
                timer.t = NaN;
              }
              return 1;
            }, 0, time);
            lock.active = id;
            transition.event && transition.event.start.call(node, node.__data__, i);
            tweens = [];
            transition.tween.forEach(function(key, value) {
              if (value = value.call(node, node.__data__, i)) {
                tweens.push(value);
              }
            });
            ease = transition.ease;
            duration = transition.duration;
          }
          function tick(elapsed) {
            var t = elapsed / duration, e = ease(t), n = tweens.length;
            while (n > 0) {
              tweens[--n].call(node, e);
            }
            if (t >= 1) {
              transition.event && transition.event.end.call(node, node.__data__, i);
              if (--lock.count) delete lock[id];
              else delete node[ns];
              return 1;
            }
          }
          if (!transition) {
            time = inherit.time;
            timer = d3_timer(schedule, 0, time);
            transition = lock[id] = {
              tween: new d3_Map(),
              time,
              timer,
              delay: inherit.delay,
              duration: inherit.duration,
              ease: inherit.ease,
              index: i
            };
            inherit = null;
            ++lock.count;
          }
        }
        d3.svg.axis = function() {
          var scale = d3.scale.linear(), orient = d3_svg_axisDefaultOrient, innerTickSize = 6, outerTickSize = 6, tickPadding = 3, tickArguments_ = [10], tickValues = null, tickFormat_;
          function axis(g) {
            g.each(function() {
              var g2 = d3.select(this);
              var scale0 = this.__chart__ || scale, scale1 = this.__chart__ = scale.copy();
              var ticks = tickValues == null ? scale1.ticks ? scale1.ticks.apply(scale1, tickArguments_) : scale1.domain() : tickValues, tickFormat = tickFormat_ == null ? scale1.tickFormat ? scale1.tickFormat.apply(scale1, tickArguments_) : d3_identity : tickFormat_, tick = g2.selectAll(".tick").data(ticks, scale1), tickEnter = tick.enter().insert("g", ".domain").attr("class", "tick").style("opacity", \u03B5), tickExit = d3.transition(tick.exit()).style("opacity", \u03B5).remove(), tickUpdate = d3.transition(tick.order()).style("opacity", 1), tickSpacing = Math.max(innerTickSize, 0) + tickPadding, tickTransform;
              var range = d3_scaleRange(scale1), path = g2.selectAll(".domain").data([0]), pathUpdate = (path.enter().append("path").attr("class", "domain"), d3.transition(path));
              tickEnter.append("line");
              tickEnter.append("text");
              var lineEnter = tickEnter.select("line"), lineUpdate = tickUpdate.select("line"), text = tick.select("text").text(tickFormat), textEnter = tickEnter.select("text"), textUpdate = tickUpdate.select("text"), sign = orient === "top" || orient === "left" ? -1 : 1, x1, x2, y1, y2;
              if (orient === "bottom" || orient === "top") {
                tickTransform = d3_svg_axisX, x1 = "x", y1 = "y", x2 = "x2", y2 = "y2";
                text.attr("dy", sign < 0 ? "0em" : ".71em").style("text-anchor", "middle");
                pathUpdate.attr("d", "M" + range[0] + "," + sign * outerTickSize + "V0H" + range[1] + "V" + sign * outerTickSize);
              } else {
                tickTransform = d3_svg_axisY, x1 = "y", y1 = "x", x2 = "y2", y2 = "x2";
                text.attr("dy", ".32em").style("text-anchor", sign < 0 ? "end" : "start");
                pathUpdate.attr("d", "M" + sign * outerTickSize + "," + range[0] + "H0V" + range[1] + "H" + sign * outerTickSize);
              }
              lineEnter.attr(y2, sign * innerTickSize);
              textEnter.attr(y1, sign * tickSpacing);
              lineUpdate.attr(x2, 0).attr(y2, sign * innerTickSize);
              textUpdate.attr(x1, 0).attr(y1, sign * tickSpacing);
              if (scale1.rangeBand) {
                var x = scale1, dx = x.rangeBand() / 2;
                scale0 = scale1 = function(d) {
                  return x(d) + dx;
                };
              } else if (scale0.rangeBand) {
                scale0 = scale1;
              } else {
                tickExit.call(tickTransform, scale1, scale0);
              }
              tickEnter.call(tickTransform, scale0, scale1);
              tickUpdate.call(tickTransform, scale1, scale1);
            });
          }
          axis.scale = function(x) {
            if (!arguments.length) return scale;
            scale = x;
            return axis;
          };
          axis.orient = function(x) {
            if (!arguments.length) return orient;
            orient = x in d3_svg_axisOrients ? x + "" : d3_svg_axisDefaultOrient;
            return axis;
          };
          axis.ticks = function() {
            if (!arguments.length) return tickArguments_;
            tickArguments_ = d3_array(arguments);
            return axis;
          };
          axis.tickValues = function(x) {
            if (!arguments.length) return tickValues;
            tickValues = x;
            return axis;
          };
          axis.tickFormat = function(x) {
            if (!arguments.length) return tickFormat_;
            tickFormat_ = x;
            return axis;
          };
          axis.tickSize = function(x) {
            var n = arguments.length;
            if (!n) return innerTickSize;
            innerTickSize = +x;
            outerTickSize = +arguments[n - 1];
            return axis;
          };
          axis.innerTickSize = function(x) {
            if (!arguments.length) return innerTickSize;
            innerTickSize = +x;
            return axis;
          };
          axis.outerTickSize = function(x) {
            if (!arguments.length) return outerTickSize;
            outerTickSize = +x;
            return axis;
          };
          axis.tickPadding = function(x) {
            if (!arguments.length) return tickPadding;
            tickPadding = +x;
            return axis;
          };
          axis.tickSubdivide = function() {
            return arguments.length && axis;
          };
          return axis;
        };
        var d3_svg_axisDefaultOrient = "bottom", d3_svg_axisOrients = {
          top: 1,
          right: 1,
          bottom: 1,
          left: 1
        };
        function d3_svg_axisX(selection, x0, x1) {
          selection.attr("transform", function(d) {
            var v0 = x0(d);
            return "translate(" + (isFinite(v0) ? v0 : x1(d)) + ",0)";
          });
        }
        function d3_svg_axisY(selection, y0, y1) {
          selection.attr("transform", function(d) {
            var v0 = y0(d);
            return "translate(0," + (isFinite(v0) ? v0 : y1(d)) + ")";
          });
        }
        d3.svg.brush = function() {
          var event = d3_eventDispatch(brush, "brushstart", "brush", "brushend"), x = null, y = null, xExtent = [0, 0], yExtent = [0, 0], xExtentDomain, yExtentDomain, xClamp = true, yClamp = true, resizes = d3_svg_brushResizes[0];
          function brush(g) {
            g.each(function() {
              var g2 = d3.select(this).style("pointer-events", "all").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)").on("mousedown.brush", brushstart).on("touchstart.brush", brushstart);
              var background = g2.selectAll(".background").data([0]);
              background.enter().append("rect").attr("class", "background").style("visibility", "hidden").style("cursor", "crosshair");
              g2.selectAll(".extent").data([0]).enter().append("rect").attr("class", "extent").style("cursor", "move");
              var resize = g2.selectAll(".resize").data(resizes, d3_identity);
              resize.exit().remove();
              resize.enter().append("g").attr("class", function(d) {
                return "resize " + d;
              }).style("cursor", function(d) {
                return d3_svg_brushCursor[d];
              }).append("rect").attr("x", function(d) {
                return /[ew]$/.test(d) ? -3 : null;
              }).attr("y", function(d) {
                return /^[ns]/.test(d) ? -3 : null;
              }).attr("width", 6).attr("height", 6).style("visibility", "hidden");
              resize.style("display", brush.empty() ? "none" : null);
              var gUpdate = d3.transition(g2), backgroundUpdate = d3.transition(background), range;
              if (x) {
                range = d3_scaleRange(x);
                backgroundUpdate.attr("x", range[0]).attr("width", range[1] - range[0]);
                redrawX(gUpdate);
              }
              if (y) {
                range = d3_scaleRange(y);
                backgroundUpdate.attr("y", range[0]).attr("height", range[1] - range[0]);
                redrawY(gUpdate);
              }
              redraw(gUpdate);
            });
          }
          brush.event = function(g) {
            g.each(function() {
              var event_ = event.of(this, arguments), extent1 = {
                x: xExtent,
                y: yExtent,
                i: xExtentDomain,
                j: yExtentDomain
              }, extent0 = this.__chart__ || extent1;
              this.__chart__ = extent1;
              if (d3_transitionInheritId) {
                d3.select(this).transition().each("start.brush", function() {
                  xExtentDomain = extent0.i;
                  yExtentDomain = extent0.j;
                  xExtent = extent0.x;
                  yExtent = extent0.y;
                  event_({
                    type: "brushstart"
                  });
                }).tween("brush:brush", function() {
                  var xi = d3_interpolateArray(xExtent, extent1.x), yi = d3_interpolateArray(yExtent, extent1.y);
                  xExtentDomain = yExtentDomain = null;
                  return function(t) {
                    xExtent = extent1.x = xi(t);
                    yExtent = extent1.y = yi(t);
                    event_({
                      type: "brush",
                      mode: "resize"
                    });
                  };
                }).each("end.brush", function() {
                  xExtentDomain = extent1.i;
                  yExtentDomain = extent1.j;
                  event_({
                    type: "brush",
                    mode: "resize"
                  });
                  event_({
                    type: "brushend"
                  });
                });
              } else {
                event_({
                  type: "brushstart"
                });
                event_({
                  type: "brush",
                  mode: "resize"
                });
                event_({
                  type: "brushend"
                });
              }
            });
          };
          function redraw(g) {
            g.selectAll(".resize").attr("transform", function(d) {
              return "translate(" + xExtent[+/e$/.test(d)] + "," + yExtent[+/^s/.test(d)] + ")";
            });
          }
          function redrawX(g) {
            g.select(".extent").attr("x", xExtent[0]);
            g.selectAll(".extent,.n>rect,.s>rect").attr("width", xExtent[1] - xExtent[0]);
          }
          function redrawY(g) {
            g.select(".extent").attr("y", yExtent[0]);
            g.selectAll(".extent,.e>rect,.w>rect").attr("height", yExtent[1] - yExtent[0]);
          }
          function brushstart() {
            var target = this, eventTarget = d3.select(d3.event.target), event_ = event.of(target, arguments), g = d3.select(target), resizing = eventTarget.datum(), resizingX = !/^(n|s)$/.test(resizing) && x, resizingY = !/^(e|w)$/.test(resizing) && y, dragging = eventTarget.classed("extent"), dragRestore = d3_event_dragSuppress(target), center, origin = d3.mouse(target), offset;
            var w = d3.select(d3_window(target)).on("keydown.brush", keydown).on("keyup.brush", keyup);
            if (d3.event.changedTouches) {
              w.on("touchmove.brush", brushmove).on("touchend.brush", brushend);
            } else {
              w.on("mousemove.brush", brushmove).on("mouseup.brush", brushend);
            }
            g.interrupt().selectAll("*").interrupt();
            if (dragging) {
              origin[0] = xExtent[0] - origin[0];
              origin[1] = yExtent[0] - origin[1];
            } else if (resizing) {
              var ex = +/w$/.test(resizing), ey = +/^n/.test(resizing);
              offset = [xExtent[1 - ex] - origin[0], yExtent[1 - ey] - origin[1]];
              origin[0] = xExtent[ex];
              origin[1] = yExtent[ey];
            } else if (d3.event.altKey) center = origin.slice();
            g.style("pointer-events", "none").selectAll(".resize").style("display", null);
            d3.select("body").style("cursor", eventTarget.style("cursor"));
            event_({
              type: "brushstart"
            });
            brushmove();
            function keydown() {
              if (d3.event.keyCode == 32) {
                if (!dragging) {
                  center = null;
                  origin[0] -= xExtent[1];
                  origin[1] -= yExtent[1];
                  dragging = 2;
                }
                d3_eventPreventDefault();
              }
            }
            function keyup() {
              if (d3.event.keyCode == 32 && dragging == 2) {
                origin[0] += xExtent[1];
                origin[1] += yExtent[1];
                dragging = 0;
                d3_eventPreventDefault();
              }
            }
            function brushmove() {
              var point = d3.mouse(target), moved = false;
              if (offset) {
                point[0] += offset[0];
                point[1] += offset[1];
              }
              if (!dragging) {
                if (d3.event.altKey) {
                  if (!center) center = [(xExtent[0] + xExtent[1]) / 2, (yExtent[0] + yExtent[1]) / 2];
                  origin[0] = xExtent[+(point[0] < center[0])];
                  origin[1] = yExtent[+(point[1] < center[1])];
                } else center = null;
              }
              if (resizingX && move1(point, x, 0)) {
                redrawX(g);
                moved = true;
              }
              if (resizingY && move1(point, y, 1)) {
                redrawY(g);
                moved = true;
              }
              if (moved) {
                redraw(g);
                event_({
                  type: "brush",
                  mode: dragging ? "move" : "resize"
                });
              }
            }
            function move1(point, scale, i) {
              var range = d3_scaleRange(scale), r0 = range[0], r1 = range[1], position = origin[i], extent = i ? yExtent : xExtent, size = extent[1] - extent[0], min, max;
              if (dragging) {
                r0 -= position;
                r1 -= size + position;
              }
              min = (i ? yClamp : xClamp) ? Math.max(r0, Math.min(r1, point[i])) : point[i];
              if (dragging) {
                max = (min += position) + size;
              } else {
                if (center) position = Math.max(r0, Math.min(r1, 2 * center[i] - min));
                if (position < min) {
                  max = min;
                  min = position;
                } else {
                  max = position;
                }
              }
              if (extent[0] != min || extent[1] != max) {
                if (i) yExtentDomain = null;
                else xExtentDomain = null;
                extent[0] = min;
                extent[1] = max;
                return true;
              }
            }
            function brushend() {
              brushmove();
              g.style("pointer-events", "all").selectAll(".resize").style("display", brush.empty() ? "none" : null);
              d3.select("body").style("cursor", null);
              w.on("mousemove.brush", null).on("mouseup.brush", null).on("touchmove.brush", null).on("touchend.brush", null).on("keydown.brush", null).on("keyup.brush", null);
              dragRestore();
              event_({
                type: "brushend"
              });
            }
          }
          brush.x = function(z) {
            if (!arguments.length) return x;
            x = z;
            resizes = d3_svg_brushResizes[!x << 1 | !y];
            return brush;
          };
          brush.y = function(z) {
            if (!arguments.length) return y;
            y = z;
            resizes = d3_svg_brushResizes[!x << 1 | !y];
            return brush;
          };
          brush.clamp = function(z) {
            if (!arguments.length) return x && y ? [xClamp, yClamp] : x ? xClamp : y ? yClamp : null;
            if (x && y) xClamp = !!z[0], yClamp = !!z[1];
            else if (x) xClamp = !!z;
            else if (y) yClamp = !!z;
            return brush;
          };
          brush.extent = function(z) {
            var x0, x1, y0, y1, t;
            if (!arguments.length) {
              if (x) {
                if (xExtentDomain) {
                  x0 = xExtentDomain[0], x1 = xExtentDomain[1];
                } else {
                  x0 = xExtent[0], x1 = xExtent[1];
                  if (x.invert) x0 = x.invert(x0), x1 = x.invert(x1);
                  if (x1 < x0) t = x0, x0 = x1, x1 = t;
                }
              }
              if (y) {
                if (yExtentDomain) {
                  y0 = yExtentDomain[0], y1 = yExtentDomain[1];
                } else {
                  y0 = yExtent[0], y1 = yExtent[1];
                  if (y.invert) y0 = y.invert(y0), y1 = y.invert(y1);
                  if (y1 < y0) t = y0, y0 = y1, y1 = t;
                }
              }
              return x && y ? [[x0, y0], [x1, y1]] : x ? [x0, x1] : y && [y0, y1];
            }
            if (x) {
              x0 = z[0], x1 = z[1];
              if (y) x0 = x0[0], x1 = x1[0];
              xExtentDomain = [x0, x1];
              if (x.invert) x0 = x(x0), x1 = x(x1);
              if (x1 < x0) t = x0, x0 = x1, x1 = t;
              if (x0 != xExtent[0] || x1 != xExtent[1]) xExtent = [x0, x1];
            }
            if (y) {
              y0 = z[0], y1 = z[1];
              if (x) y0 = y0[1], y1 = y1[1];
              yExtentDomain = [y0, y1];
              if (y.invert) y0 = y(y0), y1 = y(y1);
              if (y1 < y0) t = y0, y0 = y1, y1 = t;
              if (y0 != yExtent[0] || y1 != yExtent[1]) yExtent = [y0, y1];
            }
            return brush;
          };
          brush.clear = function() {
            if (!brush.empty()) {
              xExtent = [0, 0], yExtent = [0, 0];
              xExtentDomain = yExtentDomain = null;
            }
            return brush;
          };
          brush.empty = function() {
            return !!x && xExtent[0] == xExtent[1] || !!y && yExtent[0] == yExtent[1];
          };
          return d3.rebind(brush, event, "on");
        };
        var d3_svg_brushCursor = {
          n: "ns-resize",
          e: "ew-resize",
          s: "ns-resize",
          w: "ew-resize",
          nw: "nwse-resize",
          ne: "nesw-resize",
          se: "nwse-resize",
          sw: "nesw-resize"
        };
        var d3_svg_brushResizes = [["n", "e", "s", "w", "nw", "ne", "se", "sw"], ["e", "w"], ["n", "s"], []];
        d3.text = d3_xhrType(function(request) {
          return request.responseText;
        });
        d3.json = function(url, callback) {
          return d3_xhr(url, "application/json", d3_json, callback);
        };
        function d3_json(request) {
          return JSON.parse(request.responseText);
        }
        d3.html = function(url, callback) {
          return d3_xhr(url, "text/html", d3_html, callback);
        };
        function d3_html(request) {
          var range = d3_document.createRange();
          range.selectNode(d3_document.body);
          return range.createContextualFragment(request.responseText);
        }
        d3.xml = d3_xhrType(function(request) {
          return request.responseXML;
        });
        if (typeof define === "function" && define.amd) define(d3);
        else if (typeof module === "object" && module.exports) module.exports = d3;
        else this.d3 = d3;
      }.apply(self);
    }
  });

  // node_modules/d3-time/dist/d3-time.js
  var require_d3_time = __commonJS({
    "node_modules/d3-time/dist/d3-time.js"(exports, module) {
      (function(global2, factory) {
        typeof exports === "object" && typeof module !== "undefined" ? factory(exports) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = global2 || self, factory(global2.d3 = global2.d3 || {}));
      })(exports, function(exports2) {
        "use strict";
        var t02 = /* @__PURE__ */ new Date(), t12 = /* @__PURE__ */ new Date();
        function newInterval(floori, offseti, count, field) {
          function interval(date) {
            return floori(date = arguments.length === 0 ? /* @__PURE__ */ new Date() : /* @__PURE__ */ new Date(+date)), date;
          }
          interval.floor = function(date) {
            return floori(date = /* @__PURE__ */ new Date(+date)), date;
          };
          interval.ceil = function(date) {
            return floori(date = new Date(date - 1)), offseti(date, 1), floori(date), date;
          };
          interval.round = function(date) {
            var d0 = interval(date), d1 = interval.ceil(date);
            return date - d0 < d1 - date ? d0 : d1;
          };
          interval.offset = function(date, step) {
            return offseti(date = /* @__PURE__ */ new Date(+date), step == null ? 1 : Math.floor(step)), date;
          };
          interval.range = function(start, stop, step) {
            var range = [], previous;
            start = interval.ceil(start);
            step = step == null ? 1 : Math.floor(step);
            if (!(start < stop) || !(step > 0)) return range;
            do
              range.push(previous = /* @__PURE__ */ new Date(+start)), offseti(start, step), floori(start);
            while (previous < start && start < stop);
            return range;
          };
          interval.filter = function(test) {
            return newInterval(function(date) {
              if (date >= date) while (floori(date), !test(date)) date.setTime(date - 1);
            }, function(date, step) {
              if (date >= date) {
                if (step < 0) while (++step <= 0) {
                  while (offseti(date, -1), !test(date)) {
                  }
                }
                else while (--step >= 0) {
                  while (offseti(date, 1), !test(date)) {
                  }
                }
              }
            });
          };
          if (count) {
            interval.count = function(start, end) {
              t02.setTime(+start), t12.setTime(+end);
              floori(t02), floori(t12);
              return Math.floor(count(t02, t12));
            };
            interval.every = function(step) {
              step = Math.floor(step);
              return !isFinite(step) || !(step > 0) ? null : !(step > 1) ? interval : interval.filter(field ? function(d) {
                return field(d) % step === 0;
              } : function(d) {
                return interval.count(0, d) % step === 0;
              });
            };
          }
          return interval;
        }
        var millisecond = newInterval(function() {
        }, function(date, step) {
          date.setTime(+date + step);
        }, function(start, end) {
          return end - start;
        });
        millisecond.every = function(k) {
          k = Math.floor(k);
          if (!isFinite(k) || !(k > 0)) return null;
          if (!(k > 1)) return millisecond;
          return newInterval(function(date) {
            date.setTime(Math.floor(date / k) * k);
          }, function(date, step) {
            date.setTime(+date + step * k);
          }, function(start, end) {
            return (end - start) / k;
          });
        };
        var milliseconds = millisecond.range;
        var durationSecond = 1e3;
        var durationMinute = 6e4;
        var durationHour = 36e5;
        var durationDay = 864e5;
        var durationWeek = 6048e5;
        var second = newInterval(function(date) {
          date.setTime(date - date.getMilliseconds());
        }, function(date, step) {
          date.setTime(+date + step * durationSecond);
        }, function(start, end) {
          return (end - start) / durationSecond;
        }, function(date) {
          return date.getUTCSeconds();
        });
        var seconds = second.range;
        var minute = newInterval(function(date) {
          date.setTime(date - date.getMilliseconds() - date.getSeconds() * durationSecond);
        }, function(date, step) {
          date.setTime(+date + step * durationMinute);
        }, function(start, end) {
          return (end - start) / durationMinute;
        }, function(date) {
          return date.getMinutes();
        });
        var minutes = minute.range;
        var hour = newInterval(function(date) {
          date.setTime(date - date.getMilliseconds() - date.getSeconds() * durationSecond - date.getMinutes() * durationMinute);
        }, function(date, step) {
          date.setTime(+date + step * durationHour);
        }, function(start, end) {
          return (end - start) / durationHour;
        }, function(date) {
          return date.getHours();
        });
        var hours = hour.range;
        var day = newInterval(function(date) {
          date.setHours(0, 0, 0, 0);
        }, function(date, step) {
          date.setDate(date.getDate() + step);
        }, function(start, end) {
          return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute) / durationDay;
        }, function(date) {
          return date.getDate() - 1;
        });
        var days = day.range;
        function weekday(i) {
          return newInterval(function(date) {
            date.setDate(date.getDate() - (date.getDay() + 7 - i) % 7);
            date.setHours(0, 0, 0, 0);
          }, function(date, step) {
            date.setDate(date.getDate() + step * 7);
          }, function(start, end) {
            return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute) / durationWeek;
          });
        }
        var sunday = weekday(0);
        var monday = weekday(1);
        var tuesday = weekday(2);
        var wednesday = weekday(3);
        var thursday = weekday(4);
        var friday = weekday(5);
        var saturday = weekday(6);
        var sundays = sunday.range;
        var mondays = monday.range;
        var tuesdays = tuesday.range;
        var wednesdays = wednesday.range;
        var thursdays = thursday.range;
        var fridays = friday.range;
        var saturdays = saturday.range;
        var month = newInterval(function(date) {
          date.setDate(1);
          date.setHours(0, 0, 0, 0);
        }, function(date, step) {
          date.setMonth(date.getMonth() + step);
        }, function(start, end) {
          return end.getMonth() - start.getMonth() + (end.getFullYear() - start.getFullYear()) * 12;
        }, function(date) {
          return date.getMonth();
        });
        var months = month.range;
        var year = newInterval(function(date) {
          date.setMonth(0, 1);
          date.setHours(0, 0, 0, 0);
        }, function(date, step) {
          date.setFullYear(date.getFullYear() + step);
        }, function(start, end) {
          return end.getFullYear() - start.getFullYear();
        }, function(date) {
          return date.getFullYear();
        });
        year.every = function(k) {
          return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date) {
            date.setFullYear(Math.floor(date.getFullYear() / k) * k);
            date.setMonth(0, 1);
            date.setHours(0, 0, 0, 0);
          }, function(date, step) {
            date.setFullYear(date.getFullYear() + step * k);
          });
        };
        var years = year.range;
        var utcMinute = newInterval(function(date) {
          date.setUTCSeconds(0, 0);
        }, function(date, step) {
          date.setTime(+date + step * durationMinute);
        }, function(start, end) {
          return (end - start) / durationMinute;
        }, function(date) {
          return date.getUTCMinutes();
        });
        var utcMinutes = utcMinute.range;
        var utcHour = newInterval(function(date) {
          date.setUTCMinutes(0, 0, 0);
        }, function(date, step) {
          date.setTime(+date + step * durationHour);
        }, function(start, end) {
          return (end - start) / durationHour;
        }, function(date) {
          return date.getUTCHours();
        });
        var utcHours = utcHour.range;
        var utcDay = newInterval(function(date) {
          date.setUTCHours(0, 0, 0, 0);
        }, function(date, step) {
          date.setUTCDate(date.getUTCDate() + step);
        }, function(start, end) {
          return (end - start) / durationDay;
        }, function(date) {
          return date.getUTCDate() - 1;
        });
        var utcDays = utcDay.range;
        function utcWeekday(i) {
          return newInterval(function(date) {
            date.setUTCDate(date.getUTCDate() - (date.getUTCDay() + 7 - i) % 7);
            date.setUTCHours(0, 0, 0, 0);
          }, function(date, step) {
            date.setUTCDate(date.getUTCDate() + step * 7);
          }, function(start, end) {
            return (end - start) / durationWeek;
          });
        }
        var utcSunday = utcWeekday(0);
        var utcMonday = utcWeekday(1);
        var utcTuesday = utcWeekday(2);
        var utcWednesday = utcWeekday(3);
        var utcThursday = utcWeekday(4);
        var utcFriday = utcWeekday(5);
        var utcSaturday = utcWeekday(6);
        var utcSundays = utcSunday.range;
        var utcMondays = utcMonday.range;
        var utcTuesdays = utcTuesday.range;
        var utcWednesdays = utcWednesday.range;
        var utcThursdays = utcThursday.range;
        var utcFridays = utcFriday.range;
        var utcSaturdays = utcSaturday.range;
        var utcMonth = newInterval(function(date) {
          date.setUTCDate(1);
          date.setUTCHours(0, 0, 0, 0);
        }, function(date, step) {
          date.setUTCMonth(date.getUTCMonth() + step);
        }, function(start, end) {
          return end.getUTCMonth() - start.getUTCMonth() + (end.getUTCFullYear() - start.getUTCFullYear()) * 12;
        }, function(date) {
          return date.getUTCMonth();
        });
        var utcMonths = utcMonth.range;
        var utcYear = newInterval(function(date) {
          date.setUTCMonth(0, 1);
          date.setUTCHours(0, 0, 0, 0);
        }, function(date, step) {
          date.setUTCFullYear(date.getUTCFullYear() + step);
        }, function(start, end) {
          return end.getUTCFullYear() - start.getUTCFullYear();
        }, function(date) {
          return date.getUTCFullYear();
        });
        utcYear.every = function(k) {
          return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date) {
            date.setUTCFullYear(Math.floor(date.getUTCFullYear() / k) * k);
            date.setUTCMonth(0, 1);
            date.setUTCHours(0, 0, 0, 0);
          }, function(date, step) {
            date.setUTCFullYear(date.getUTCFullYear() + step * k);
          });
        };
        var utcYears = utcYear.range;
        exports2.timeDay = day;
        exports2.timeDays = days;
        exports2.timeFriday = friday;
        exports2.timeFridays = fridays;
        exports2.timeHour = hour;
        exports2.timeHours = hours;
        exports2.timeInterval = newInterval;
        exports2.timeMillisecond = millisecond;
        exports2.timeMilliseconds = milliseconds;
        exports2.timeMinute = minute;
        exports2.timeMinutes = minutes;
        exports2.timeMonday = monday;
        exports2.timeMondays = mondays;
        exports2.timeMonth = month;
        exports2.timeMonths = months;
        exports2.timeSaturday = saturday;
        exports2.timeSaturdays = saturdays;
        exports2.timeSecond = second;
        exports2.timeSeconds = seconds;
        exports2.timeSunday = sunday;
        exports2.timeSundays = sundays;
        exports2.timeThursday = thursday;
        exports2.timeThursdays = thursdays;
        exports2.timeTuesday = tuesday;
        exports2.timeTuesdays = tuesdays;
        exports2.timeWednesday = wednesday;
        exports2.timeWednesdays = wednesdays;
        exports2.timeWeek = sunday;
        exports2.timeWeeks = sundays;
        exports2.timeYear = year;
        exports2.timeYears = years;
        exports2.utcDay = utcDay;
        exports2.utcDays = utcDays;
        exports2.utcFriday = utcFriday;
        exports2.utcFridays = utcFridays;
        exports2.utcHour = utcHour;
        exports2.utcHours = utcHours;
        exports2.utcMillisecond = millisecond;
        exports2.utcMilliseconds = milliseconds;
        exports2.utcMinute = utcMinute;
        exports2.utcMinutes = utcMinutes;
        exports2.utcMonday = utcMonday;
        exports2.utcMondays = utcMondays;
        exports2.utcMonth = utcMonth;
        exports2.utcMonths = utcMonths;
        exports2.utcSaturday = utcSaturday;
        exports2.utcSaturdays = utcSaturdays;
        exports2.utcSecond = second;
        exports2.utcSeconds = seconds;
        exports2.utcSunday = utcSunday;
        exports2.utcSundays = utcSundays;
        exports2.utcThursday = utcThursday;
        exports2.utcThursdays = utcThursdays;
        exports2.utcTuesday = utcTuesday;
        exports2.utcTuesdays = utcTuesdays;
        exports2.utcWednesday = utcWednesday;
        exports2.utcWednesdays = utcWednesdays;
        exports2.utcWeek = utcSunday;
        exports2.utcWeeks = utcSundays;
        exports2.utcYear = utcYear;
        exports2.utcYears = utcYears;
        Object.defineProperty(exports2, "__esModule", { value: true });
      });
    }
  });

  // node_modules/d3-time-format/dist/d3-time-format.js
  var require_d3_time_format = __commonJS({
    "node_modules/d3-time-format/dist/d3-time-format.js"(exports, module) {
      (function(global2, factory) {
        typeof exports === "object" && typeof module !== "undefined" ? factory(exports, require_d3_time()) : typeof define === "function" && define.amd ? define(["exports", "d3-time"], factory) : (global2 = global2 || self, factory(global2.d3 = global2.d3 || {}, global2.d3));
      })(exports, function(exports2, d3Time) {
        "use strict";
        function localDate(d) {
          if (0 <= d.y && d.y < 100) {
            var date = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
            date.setFullYear(d.y);
            return date;
          }
          return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
        }
        function utcDate(d) {
          if (0 <= d.y && d.y < 100) {
            var date = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
            date.setUTCFullYear(d.y);
            return date;
          }
          return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
        }
        function newDate(y, m, d) {
          return { y, m, d, H: 0, M: 0, S: 0, L: 0 };
        }
        function formatLocale(locale2) {
          var locale_dateTime = locale2.dateTime, locale_date = locale2.date, locale_time = locale2.time, locale_periods = locale2.periods, locale_weekdays = locale2.days, locale_shortWeekdays = locale2.shortDays, locale_months = locale2.months, locale_shortMonths = locale2.shortMonths;
          var periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths);
          var formats = {
            "a": formatShortWeekday,
            "A": formatWeekday,
            "b": formatShortMonth,
            "B": formatMonth,
            "c": null,
            "d": formatDayOfMonth,
            "e": formatDayOfMonth,
            "f": formatMicroseconds,
            "H": formatHour24,
            "I": formatHour12,
            "j": formatDayOfYear,
            "L": formatMilliseconds,
            "m": formatMonthNumber,
            "M": formatMinutes,
            "p": formatPeriod,
            "q": formatQuarter,
            "Q": formatUnixTimestamp,
            "s": formatUnixTimestampSeconds,
            "S": formatSeconds,
            "u": formatWeekdayNumberMonday,
            "U": formatWeekNumberSunday,
            "V": formatWeekNumberISO,
            "w": formatWeekdayNumberSunday,
            "W": formatWeekNumberMonday,
            "x": null,
            "X": null,
            "y": formatYear,
            "Y": formatFullYear,
            "Z": formatZone,
            "%": formatLiteralPercent
          };
          var utcFormats = {
            "a": formatUTCShortWeekday,
            "A": formatUTCWeekday,
            "b": formatUTCShortMonth,
            "B": formatUTCMonth,
            "c": null,
            "d": formatUTCDayOfMonth,
            "e": formatUTCDayOfMonth,
            "f": formatUTCMicroseconds,
            "H": formatUTCHour24,
            "I": formatUTCHour12,
            "j": formatUTCDayOfYear,
            "L": formatUTCMilliseconds,
            "m": formatUTCMonthNumber,
            "M": formatUTCMinutes,
            "p": formatUTCPeriod,
            "q": formatUTCQuarter,
            "Q": formatUnixTimestamp,
            "s": formatUnixTimestampSeconds,
            "S": formatUTCSeconds,
            "u": formatUTCWeekdayNumberMonday,
            "U": formatUTCWeekNumberSunday,
            "V": formatUTCWeekNumberISO,
            "w": formatUTCWeekdayNumberSunday,
            "W": formatUTCWeekNumberMonday,
            "x": null,
            "X": null,
            "y": formatUTCYear,
            "Y": formatUTCFullYear,
            "Z": formatUTCZone,
            "%": formatLiteralPercent
          };
          var parses = {
            "a": parseShortWeekday,
            "A": parseWeekday,
            "b": parseShortMonth,
            "B": parseMonth,
            "c": parseLocaleDateTime,
            "d": parseDayOfMonth,
            "e": parseDayOfMonth,
            "f": parseMicroseconds,
            "H": parseHour24,
            "I": parseHour24,
            "j": parseDayOfYear,
            "L": parseMilliseconds,
            "m": parseMonthNumber,
            "M": parseMinutes,
            "p": parsePeriod,
            "q": parseQuarter,
            "Q": parseUnixTimestamp,
            "s": parseUnixTimestampSeconds,
            "S": parseSeconds,
            "u": parseWeekdayNumberMonday,
            "U": parseWeekNumberSunday,
            "V": parseWeekNumberISO,
            "w": parseWeekdayNumberSunday,
            "W": parseWeekNumberMonday,
            "x": parseLocaleDate,
            "X": parseLocaleTime,
            "y": parseYear,
            "Y": parseFullYear,
            "Z": parseZone,
            "%": parseLiteralPercent
          };
          formats.x = newFormat(locale_date, formats);
          formats.X = newFormat(locale_time, formats);
          formats.c = newFormat(locale_dateTime, formats);
          utcFormats.x = newFormat(locale_date, utcFormats);
          utcFormats.X = newFormat(locale_time, utcFormats);
          utcFormats.c = newFormat(locale_dateTime, utcFormats);
          function newFormat(specifier, formats2) {
            return function(date) {
              var string = [], i = -1, j = 0, n = specifier.length, c, pad2, format;
              if (!(date instanceof Date)) date = /* @__PURE__ */ new Date(+date);
              while (++i < n) {
                if (specifier.charCodeAt(i) === 37) {
                  string.push(specifier.slice(j, i));
                  if ((pad2 = pads[c = specifier.charAt(++i)]) != null) c = specifier.charAt(++i);
                  else pad2 = c === "e" ? " " : "0";
                  if (format = formats2[c]) c = format(date, pad2);
                  string.push(c);
                  j = i + 1;
                }
              }
              string.push(specifier.slice(j, i));
              return string.join("");
            };
          }
          function newParse(specifier, Z) {
            return function(string) {
              var d = newDate(1900, void 0, 1), i = parseSpecifier(d, specifier, string += "", 0), week, day;
              if (i != string.length) return null;
              if ("Q" in d) return new Date(d.Q);
              if ("s" in d) return new Date(d.s * 1e3 + ("L" in d ? d.L : 0));
              if (Z && !("Z" in d)) d.Z = 0;
              if ("p" in d) d.H = d.H % 12 + d.p * 12;
              if (d.m === void 0) d.m = "q" in d ? d.q : 0;
              if ("V" in d) {
                if (d.V < 1 || d.V > 53) return null;
                if (!("w" in d)) d.w = 1;
                if ("Z" in d) {
                  week = utcDate(newDate(d.y, 0, 1)), day = week.getUTCDay();
                  week = day > 4 || day === 0 ? d3Time.utcMonday.ceil(week) : d3Time.utcMonday(week);
                  week = d3Time.utcDay.offset(week, (d.V - 1) * 7);
                  d.y = week.getUTCFullYear();
                  d.m = week.getUTCMonth();
                  d.d = week.getUTCDate() + (d.w + 6) % 7;
                } else {
                  week = localDate(newDate(d.y, 0, 1)), day = week.getDay();
                  week = day > 4 || day === 0 ? d3Time.timeMonday.ceil(week) : d3Time.timeMonday(week);
                  week = d3Time.timeDay.offset(week, (d.V - 1) * 7);
                  d.y = week.getFullYear();
                  d.m = week.getMonth();
                  d.d = week.getDate() + (d.w + 6) % 7;
                }
              } else if ("W" in d || "U" in d) {
                if (!("w" in d)) d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
                day = "Z" in d ? utcDate(newDate(d.y, 0, 1)).getUTCDay() : localDate(newDate(d.y, 0, 1)).getDay();
                d.m = 0;
                d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day + 5) % 7 : d.w + d.U * 7 - (day + 6) % 7;
              }
              if ("Z" in d) {
                d.H += d.Z / 100 | 0;
                d.M += d.Z % 100;
                return utcDate(d);
              }
              return localDate(d);
            };
          }
          function parseSpecifier(d, specifier, string, j) {
            var i = 0, n = specifier.length, m = string.length, c, parse;
            while (i < n) {
              if (j >= m) return -1;
              c = specifier.charCodeAt(i++);
              if (c === 37) {
                c = specifier.charAt(i++);
                parse = parses[c in pads ? specifier.charAt(i++) : c];
                if (!parse || (j = parse(d, string, j)) < 0) return -1;
              } else if (c != string.charCodeAt(j++)) {
                return -1;
              }
            }
            return j;
          }
          function parsePeriod(d, string, i) {
            var n = periodRe.exec(string.slice(i));
            return n ? (d.p = periodLookup[n[0].toLowerCase()], i + n[0].length) : -1;
          }
          function parseShortWeekday(d, string, i) {
            var n = shortWeekdayRe.exec(string.slice(i));
            return n ? (d.w = shortWeekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
          }
          function parseWeekday(d, string, i) {
            var n = weekdayRe.exec(string.slice(i));
            return n ? (d.w = weekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
          }
          function parseShortMonth(d, string, i) {
            var n = shortMonthRe.exec(string.slice(i));
            return n ? (d.m = shortMonthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
          }
          function parseMonth(d, string, i) {
            var n = monthRe.exec(string.slice(i));
            return n ? (d.m = monthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
          }
          function parseLocaleDateTime(d, string, i) {
            return parseSpecifier(d, locale_dateTime, string, i);
          }
          function parseLocaleDate(d, string, i) {
            return parseSpecifier(d, locale_date, string, i);
          }
          function parseLocaleTime(d, string, i) {
            return parseSpecifier(d, locale_time, string, i);
          }
          function formatShortWeekday(d) {
            return locale_shortWeekdays[d.getDay()];
          }
          function formatWeekday(d) {
            return locale_weekdays[d.getDay()];
          }
          function formatShortMonth(d) {
            return locale_shortMonths[d.getMonth()];
          }
          function formatMonth(d) {
            return locale_months[d.getMonth()];
          }
          function formatPeriod(d) {
            return locale_periods[+(d.getHours() >= 12)];
          }
          function formatQuarter(d) {
            return 1 + ~~(d.getMonth() / 3);
          }
          function formatUTCShortWeekday(d) {
            return locale_shortWeekdays[d.getUTCDay()];
          }
          function formatUTCWeekday(d) {
            return locale_weekdays[d.getUTCDay()];
          }
          function formatUTCShortMonth(d) {
            return locale_shortMonths[d.getUTCMonth()];
          }
          function formatUTCMonth(d) {
            return locale_months[d.getUTCMonth()];
          }
          function formatUTCPeriod(d) {
            return locale_periods[+(d.getUTCHours() >= 12)];
          }
          function formatUTCQuarter(d) {
            return 1 + ~~(d.getUTCMonth() / 3);
          }
          return {
            format: function(specifier) {
              var f = newFormat(specifier += "", formats);
              f.toString = function() {
                return specifier;
              };
              return f;
            },
            parse: function(specifier) {
              var p = newParse(specifier += "", false);
              p.toString = function() {
                return specifier;
              };
              return p;
            },
            utcFormat: function(specifier) {
              var f = newFormat(specifier += "", utcFormats);
              f.toString = function() {
                return specifier;
              };
              return f;
            },
            utcParse: function(specifier) {
              var p = newParse(specifier += "", true);
              p.toString = function() {
                return specifier;
              };
              return p;
            }
          };
        }
        var pads = { "-": "", "_": " ", "0": "0" }, numberRe = /^\s*\d+/, percentRe = /^%/, requoteRe = /[\\^$*+?|[\]().{}]/g;
        function pad(value, fill, width) {
          var sign = value < 0 ? "-" : "", string = (sign ? -value : value) + "", length = string.length;
          return sign + (length < width ? new Array(width - length + 1).join(fill) + string : string);
        }
        function requote(s) {
          return s.replace(requoteRe, "\\$&");
        }
        function formatRe(names) {
          return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
        }
        function formatLookup(names) {
          var map = {}, i = -1, n = names.length;
          while (++i < n) map[names[i].toLowerCase()] = i;
          return map;
        }
        function parseWeekdayNumberSunday(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 1));
          return n ? (d.w = +n[0], i + n[0].length) : -1;
        }
        function parseWeekdayNumberMonday(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 1));
          return n ? (d.u = +n[0], i + n[0].length) : -1;
        }
        function parseWeekNumberSunday(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.U = +n[0], i + n[0].length) : -1;
        }
        function parseWeekNumberISO(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.V = +n[0], i + n[0].length) : -1;
        }
        function parseWeekNumberMonday(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.W = +n[0], i + n[0].length) : -1;
        }
        function parseFullYear(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 4));
          return n ? (d.y = +n[0], i + n[0].length) : -1;
        }
        function parseYear(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i + n[0].length) : -1;
        }
        function parseZone(d, string, i) {
          var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i, i + 6));
          return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i + n[0].length) : -1;
        }
        function parseQuarter(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 1));
          return n ? (d.q = n[0] * 3 - 3, i + n[0].length) : -1;
        }
        function parseMonthNumber(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.m = n[0] - 1, i + n[0].length) : -1;
        }
        function parseDayOfMonth(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.d = +n[0], i + n[0].length) : -1;
        }
        function parseDayOfYear(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 3));
          return n ? (d.m = 0, d.d = +n[0], i + n[0].length) : -1;
        }
        function parseHour24(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.H = +n[0], i + n[0].length) : -1;
        }
        function parseMinutes(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.M = +n[0], i + n[0].length) : -1;
        }
        function parseSeconds(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 2));
          return n ? (d.S = +n[0], i + n[0].length) : -1;
        }
        function parseMilliseconds(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 3));
          return n ? (d.L = +n[0], i + n[0].length) : -1;
        }
        function parseMicroseconds(d, string, i) {
          var n = numberRe.exec(string.slice(i, i + 6));
          return n ? (d.L = Math.floor(n[0] / 1e3), i + n[0].length) : -1;
        }
        function parseLiteralPercent(d, string, i) {
          var n = percentRe.exec(string.slice(i, i + 1));
          return n ? i + n[0].length : -1;
        }
        function parseUnixTimestamp(d, string, i) {
          var n = numberRe.exec(string.slice(i));
          return n ? (d.Q = +n[0], i + n[0].length) : -1;
        }
        function parseUnixTimestampSeconds(d, string, i) {
          var n = numberRe.exec(string.slice(i));
          return n ? (d.s = +n[0], i + n[0].length) : -1;
        }
        function formatDayOfMonth(d, p) {
          return pad(d.getDate(), p, 2);
        }
        function formatHour24(d, p) {
          return pad(d.getHours(), p, 2);
        }
        function formatHour12(d, p) {
          return pad(d.getHours() % 12 || 12, p, 2);
        }
        function formatDayOfYear(d, p) {
          return pad(1 + d3Time.timeDay.count(d3Time.timeYear(d), d), p, 3);
        }
        function formatMilliseconds(d, p) {
          return pad(d.getMilliseconds(), p, 3);
        }
        function formatMicroseconds(d, p) {
          return formatMilliseconds(d, p) + "000";
        }
        function formatMonthNumber(d, p) {
          return pad(d.getMonth() + 1, p, 2);
        }
        function formatMinutes(d, p) {
          return pad(d.getMinutes(), p, 2);
        }
        function formatSeconds(d, p) {
          return pad(d.getSeconds(), p, 2);
        }
        function formatWeekdayNumberMonday(d) {
          var day = d.getDay();
          return day === 0 ? 7 : day;
        }
        function formatWeekNumberSunday(d, p) {
          return pad(d3Time.timeSunday.count(d3Time.timeYear(d) - 1, d), p, 2);
        }
        function formatWeekNumberISO(d, p) {
          var day = d.getDay();
          d = day >= 4 || day === 0 ? d3Time.timeThursday(d) : d3Time.timeThursday.ceil(d);
          return pad(d3Time.timeThursday.count(d3Time.timeYear(d), d) + (d3Time.timeYear(d).getDay() === 4), p, 2);
        }
        function formatWeekdayNumberSunday(d) {
          return d.getDay();
        }
        function formatWeekNumberMonday(d, p) {
          return pad(d3Time.timeMonday.count(d3Time.timeYear(d) - 1, d), p, 2);
        }
        function formatYear(d, p) {
          return pad(d.getFullYear() % 100, p, 2);
        }
        function formatFullYear(d, p) {
          return pad(d.getFullYear() % 1e4, p, 4);
        }
        function formatZone(d) {
          var z = d.getTimezoneOffset();
          return (z > 0 ? "-" : (z *= -1, "+")) + pad(z / 60 | 0, "0", 2) + pad(z % 60, "0", 2);
        }
        function formatUTCDayOfMonth(d, p) {
          return pad(d.getUTCDate(), p, 2);
        }
        function formatUTCHour24(d, p) {
          return pad(d.getUTCHours(), p, 2);
        }
        function formatUTCHour12(d, p) {
          return pad(d.getUTCHours() % 12 || 12, p, 2);
        }
        function formatUTCDayOfYear(d, p) {
          return pad(1 + d3Time.utcDay.count(d3Time.utcYear(d), d), p, 3);
        }
        function formatUTCMilliseconds(d, p) {
          return pad(d.getUTCMilliseconds(), p, 3);
        }
        function formatUTCMicroseconds(d, p) {
          return formatUTCMilliseconds(d, p) + "000";
        }
        function formatUTCMonthNumber(d, p) {
          return pad(d.getUTCMonth() + 1, p, 2);
        }
        function formatUTCMinutes(d, p) {
          return pad(d.getUTCMinutes(), p, 2);
        }
        function formatUTCSeconds(d, p) {
          return pad(d.getUTCSeconds(), p, 2);
        }
        function formatUTCWeekdayNumberMonday(d) {
          var dow = d.getUTCDay();
          return dow === 0 ? 7 : dow;
        }
        function formatUTCWeekNumberSunday(d, p) {
          return pad(d3Time.utcSunday.count(d3Time.utcYear(d) - 1, d), p, 2);
        }
        function formatUTCWeekNumberISO(d, p) {
          var day = d.getUTCDay();
          d = day >= 4 || day === 0 ? d3Time.utcThursday(d) : d3Time.utcThursday.ceil(d);
          return pad(d3Time.utcThursday.count(d3Time.utcYear(d), d) + (d3Time.utcYear(d).getUTCDay() === 4), p, 2);
        }
        function formatUTCWeekdayNumberSunday(d) {
          return d.getUTCDay();
        }
        function formatUTCWeekNumberMonday(d, p) {
          return pad(d3Time.utcMonday.count(d3Time.utcYear(d) - 1, d), p, 2);
        }
        function formatUTCYear(d, p) {
          return pad(d.getUTCFullYear() % 100, p, 2);
        }
        function formatUTCFullYear(d, p) {
          return pad(d.getUTCFullYear() % 1e4, p, 4);
        }
        function formatUTCZone() {
          return "+0000";
        }
        function formatLiteralPercent() {
          return "%";
        }
        function formatUnixTimestamp(d) {
          return +d;
        }
        function formatUnixTimestampSeconds(d) {
          return Math.floor(+d / 1e3);
        }
        var locale;
        defaultLocale({
          dateTime: "%x, %X",
          date: "%-m/%-d/%Y",
          time: "%-I:%M:%S %p",
          periods: ["AM", "PM"],
          days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
          shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
          months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
          shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
        });
        function defaultLocale(definition) {
          locale = formatLocale(definition);
          exports2.timeFormat = locale.format;
          exports2.timeParse = locale.parse;
          exports2.utcFormat = locale.utcFormat;
          exports2.utcParse = locale.utcParse;
          return locale;
        }
        var isoSpecifier = "%Y-%m-%dT%H:%M:%S.%LZ";
        function formatIsoNative(date) {
          return date.toISOString();
        }
        var formatIso = Date.prototype.toISOString ? formatIsoNative : exports2.utcFormat(isoSpecifier);
        function parseIsoNative(string) {
          var date = new Date(string);
          return isNaN(date) ? null : date;
        }
        var parseIso = +/* @__PURE__ */ new Date("2000-01-01T00:00:00.000Z") ? parseIsoNative : exports2.utcParse(isoSpecifier);
        exports2.isoFormat = formatIso;
        exports2.isoParse = parseIso;
        exports2.timeFormatDefaultLocale = defaultLocale;
        exports2.timeFormatLocale = formatLocale;
        Object.defineProperty(exports2, "__esModule", { value: true });
      });
    }
  });

  // node_modules/d3-format/dist/d3-format.js
  var require_d3_format = __commonJS({
    "node_modules/d3-format/dist/d3-format.js"(exports, module) {
      (function(global2, factory) {
        typeof exports === "object" && typeof module !== "undefined" ? factory(exports) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.d3 = global2.d3 || {}));
      })(exports, function(exports2) {
        "use strict";
        function formatDecimal(x) {
          return Math.abs(x = Math.round(x)) >= 1e21 ? x.toLocaleString("en").replace(/,/g, "") : x.toString(10);
        }
        function formatDecimalParts(x, p) {
          if ((i = (x = p ? x.toExponential(p - 1) : x.toExponential()).indexOf("e")) < 0) return null;
          var i, coefficient = x.slice(0, i);
          return [
            coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
            +x.slice(i + 1)
          ];
        }
        function exponent(x) {
          return x = formatDecimalParts(Math.abs(x)), x ? x[1] : NaN;
        }
        function formatGroup(grouping, thousands) {
          return function(value, width) {
            var i = value.length, t = [], j = 0, g = grouping[0], length = 0;
            while (i > 0 && g > 0) {
              if (length + g + 1 > width) g = Math.max(1, width - length);
              t.push(value.substring(i -= g, i + g));
              if ((length += g + 1) > width) break;
              g = grouping[j = (j + 1) % grouping.length];
            }
            return t.reverse().join(thousands);
          };
        }
        function formatNumerals(numerals) {
          return function(value) {
            return value.replace(/[0-9]/g, function(i) {
              return numerals[+i];
            });
          };
        }
        var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
        function formatSpecifier(specifier) {
          if (!(match = re.exec(specifier))) throw new Error("invalid format: " + specifier);
          var match;
          return new FormatSpecifier({
            fill: match[1],
            align: match[2],
            sign: match[3],
            symbol: match[4],
            zero: match[5],
            width: match[6],
            comma: match[7],
            precision: match[8] && match[8].slice(1),
            trim: match[9],
            type: match[10]
          });
        }
        formatSpecifier.prototype = FormatSpecifier.prototype;
        function FormatSpecifier(specifier) {
          this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
          this.align = specifier.align === void 0 ? ">" : specifier.align + "";
          this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
          this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
          this.zero = !!specifier.zero;
          this.width = specifier.width === void 0 ? void 0 : +specifier.width;
          this.comma = !!specifier.comma;
          this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
          this.trim = !!specifier.trim;
          this.type = specifier.type === void 0 ? "" : specifier.type + "";
        }
        FormatSpecifier.prototype.toString = function() {
          return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
        };
        function formatTrim(s) {
          out: for (var n = s.length, i = 1, i0 = -1, i1; i < n; ++i) {
            switch (s[i]) {
              case ".":
                i0 = i1 = i;
                break;
              case "0":
                if (i0 === 0) i0 = i;
                i1 = i;
                break;
              default:
                if (!+s[i]) break out;
                if (i0 > 0) i0 = 0;
                break;
            }
          }
          return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
        }
        var prefixExponent;
        function formatPrefixAuto(x, p) {
          var d = formatDecimalParts(x, p);
          if (!d) return x + "";
          var coefficient = d[0], exponent2 = d[1], i = exponent2 - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent2 / 3))) * 3) + 1, n = coefficient.length;
          return i === n ? coefficient : i > n ? coefficient + new Array(i - n + 1).join("0") : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i) : "0." + new Array(1 - i).join("0") + formatDecimalParts(x, Math.max(0, p + i - 1))[0];
        }
        function formatRounded(x, p) {
          var d = formatDecimalParts(x, p);
          if (!d) return x + "";
          var coefficient = d[0], exponent2 = d[1];
          return exponent2 < 0 ? "0." + new Array(-exponent2).join("0") + coefficient : coefficient.length > exponent2 + 1 ? coefficient.slice(0, exponent2 + 1) + "." + coefficient.slice(exponent2 + 1) : coefficient + new Array(exponent2 - coefficient.length + 2).join("0");
        }
        var formatTypes = {
          "%": function(x, p) {
            return (x * 100).toFixed(p);
          },
          "b": function(x) {
            return Math.round(x).toString(2);
          },
          "c": function(x) {
            return x + "";
          },
          "d": formatDecimal,
          "e": function(x, p) {
            return x.toExponential(p);
          },
          "f": function(x, p) {
            return x.toFixed(p);
          },
          "g": function(x, p) {
            return x.toPrecision(p);
          },
          "o": function(x) {
            return Math.round(x).toString(8);
          },
          "p": function(x, p) {
            return formatRounded(x * 100, p);
          },
          "r": formatRounded,
          "s": formatPrefixAuto,
          "X": function(x) {
            return Math.round(x).toString(16).toUpperCase();
          },
          "x": function(x) {
            return Math.round(x).toString(16);
          }
        };
        function identity2(x) {
          return x;
        }
        var map = Array.prototype.map, prefixes = ["y", "z", "a", "f", "p", "n", "\xB5", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
        function formatLocale(locale2) {
          var group = locale2.grouping === void 0 || locale2.thousands === void 0 ? identity2 : formatGroup(map.call(locale2.grouping, Number), locale2.thousands + ""), currencyPrefix = locale2.currency === void 0 ? "" : locale2.currency[0] + "", currencySuffix = locale2.currency === void 0 ? "" : locale2.currency[1] + "", decimal = locale2.decimal === void 0 ? "." : locale2.decimal + "", numerals = locale2.numerals === void 0 ? identity2 : formatNumerals(map.call(locale2.numerals, String)), percent = locale2.percent === void 0 ? "%" : locale2.percent + "", minus = locale2.minus === void 0 ? "-" : locale2.minus + "", nan = locale2.nan === void 0 ? "NaN" : locale2.nan + "";
          function newFormat(specifier) {
            specifier = formatSpecifier(specifier);
            var fill = specifier.fill, align = specifier.align, sign = specifier.sign, symbol = specifier.symbol, zero2 = specifier.zero, width = specifier.width, comma = specifier.comma, precision = specifier.precision, trim = specifier.trim, type = specifier.type;
            if (type === "n") comma = true, type = "g";
            else if (!formatTypes[type]) precision === void 0 && (precision = 12), trim = true, type = "g";
            if (zero2 || fill === "0" && align === "=") zero2 = true, fill = "0", align = "=";
            var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type) ? "0" + type.toLowerCase() : "", suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type) ? percent : "";
            var formatType = formatTypes[type], maybeSuffix = /[defgprs%]/.test(type);
            precision = precision === void 0 ? 6 : /[gprs]/.test(type) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
            function format(value) {
              var valuePrefix = prefix, valueSuffix = suffix, i, n, c;
              if (type === "c") {
                valueSuffix = formatType(value) + valueSuffix;
                value = "";
              } else {
                value = +value;
                var valueNegative = value < 0 || 1 / value < 0;
                value = isNaN(value) ? nan : formatType(Math.abs(value), precision);
                if (trim) value = formatTrim(value);
                if (valueNegative && +value === 0 && sign !== "+") valueNegative = false;
                valuePrefix = (valueNegative ? sign === "(" ? sign : minus : sign === "-" || sign === "(" ? "" : sign) + valuePrefix;
                valueSuffix = (type === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign === "(" ? ")" : "");
                if (maybeSuffix) {
                  i = -1, n = value.length;
                  while (++i < n) {
                    if (c = value.charCodeAt(i), 48 > c || c > 57) {
                      valueSuffix = (c === 46 ? decimal + value.slice(i + 1) : value.slice(i)) + valueSuffix;
                      value = value.slice(0, i);
                      break;
                    }
                  }
                }
              }
              if (comma && !zero2) value = group(value, Infinity);
              var length = valuePrefix.length + value.length + valueSuffix.length, padding = length < width ? new Array(width - length + 1).join(fill) : "";
              if (comma && zero2) value = group(padding + value, padding.length ? width - valueSuffix.length : Infinity), padding = "";
              switch (align) {
                case "<":
                  value = valuePrefix + value + valueSuffix + padding;
                  break;
                case "=":
                  value = valuePrefix + padding + value + valueSuffix;
                  break;
                case "^":
                  value = padding.slice(0, length = padding.length >> 1) + valuePrefix + value + valueSuffix + padding.slice(length);
                  break;
                default:
                  value = padding + valuePrefix + value + valueSuffix;
                  break;
              }
              return numerals(value);
            }
            format.toString = function() {
              return specifier + "";
            };
            return format;
          }
          function formatPrefix(specifier, value) {
            var f = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3, k = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
            return function(value2) {
              return f(k * value2) + prefix;
            };
          }
          return {
            format: newFormat,
            formatPrefix
          };
        }
        var locale;
        defaultLocale({
          decimal: ".",
          thousands: ",",
          grouping: [3],
          currency: ["$", ""],
          minus: "-"
        });
        function defaultLocale(definition) {
          locale = formatLocale(definition);
          exports2.format = locale.format;
          exports2.formatPrefix = locale.formatPrefix;
          return locale;
        }
        function precisionFixed(step) {
          return Math.max(0, -exponent(Math.abs(step)));
        }
        function precisionPrefix(step, value) {
          return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3 - exponent(Math.abs(step)));
        }
        function precisionRound(step, max) {
          step = Math.abs(step), max = Math.abs(max) - step;
          return Math.max(0, exponent(max) - exponent(step)) + 1;
        }
        exports2.FormatSpecifier = FormatSpecifier;
        exports2.formatDefaultLocale = defaultLocale;
        exports2.formatLocale = formatLocale;
        exports2.formatSpecifier = formatSpecifier;
        exports2.precisionFixed = precisionFixed;
        exports2.precisionPrefix = precisionPrefix;
        exports2.precisionRound = precisionRound;
        Object.defineProperty(exports2, "__esModule", { value: true });
      });
    }
  });

  // node_modules/is-string-blank/index.js
  var require_is_string_blank = __commonJS({
    "node_modules/is-string-blank/index.js"(exports, module) {
      "use strict";
      module.exports = function(str) {
        var l = str.length, a;
        for (var i = 0; i < l; i++) {
          a = str.charCodeAt(i);
          if ((a < 9 || a > 13) && a !== 32 && a !== 133 && a !== 160 && a !== 5760 && a !== 6158 && (a < 8192 || a > 8205) && a !== 8232 && a !== 8233 && a !== 8239 && a !== 8287 && a !== 8288 && a !== 12288 && a !== 65279) {
            return false;
          }
        }
        return true;
      };
    }
  });

  // node_modules/fast-isnumeric/index.js
  var require_fast_isnumeric = __commonJS({
    "node_modules/fast-isnumeric/index.js"(exports, module) {
      "use strict";
      var allBlankCharCodes = require_is_string_blank();
      module.exports = function(n) {
        var type = typeof n;
        if (type === "string") {
          var original = n;
          n = +n;
          if (n === 0 && allBlankCharCodes(original)) return false;
        } else if (type !== "number") return false;
        return n - n < 1;
      };
    }
  });

  // src/constants/numerical.js
  var require_numerical = __commonJS({
    "src/constants/numerical.js"(exports, module) {
      "use strict";
      module.exports = {
        /**
         * Standardize all missing data in calcdata to use undefined
         * never null or NaN.
         * That way we can use !==undefined, or !== BADNUM,
         * to test for real data
         */
        BADNUM: void 0,
        /*
         * Limit certain operations to well below floating point max value
         * to avoid glitches: Make sure that even when you multiply it by the
         * number of pixels on a giant screen it still works
         */
        FP_SAFE: Number.MAX_VALUE * 1e-4,
        /*
         * conversion of date units to milliseconds
         * year and month constants are marked "AVG"
         * to remind us that not all years and months
         * have the same length
         */
        ONEMAXYEAR: 316224e5,
        // 366 * ONEDAY
        ONEAVGYEAR: 315576e5,
        // 365.25 days
        ONEMINYEAR: 31536e6,
        // 365 * ONEDAY
        ONEMAXQUARTER: 79488e5,
        // 92 * ONEDAY
        ONEAVGQUARTER: 78894e5,
        // 1/4 of ONEAVGYEAR
        ONEMINQUARTER: 76896e5,
        // 89 * ONEDAY
        ONEMAXMONTH: 26784e5,
        // 31 * ONEDAY
        ONEAVGMONTH: 26298e5,
        // 1/12 of ONEAVGYEAR
        ONEMINMONTH: 24192e5,
        // 28 * ONEDAY
        ONEWEEK: 6048e5,
        // 7 * ONEDAY
        ONEDAY: 864e5,
        // 24 * ONEHOUR
        ONEHOUR: 36e5,
        ONEMIN: 6e4,
        ONESEC: 1e3,
        ONEMILLI: 1,
        ONEMICROSEC: 1e-3,
        /*
         * For fast conversion btwn world calendars and epoch ms, the Julian Day Number
         * of the unix epoch. From calendars.instance().newDate(1970, 1, 1).toJD()
         */
        EPOCHJD: 24405875e-1,
        /*
         * Are two values nearly equal? Compare to 1PPM
         */
        ALMOST_EQUAL: 1 - 1e-6,
        /*
         * If we're asked to clip a non-positive log value, how far off-screen
         * do we put it?
         */
        LOG_CLIP: 10,
        /*
         * not a number, but for displaying numbers: the "minus sign" symbol is
         * wider than the regular ascii dash "-"
         */
        MINUS_SIGN: "\u2212"
      };
    }
  });

  // node_modules/base64-arraybuffer/dist/base64-arraybuffer.umd.js
  var require_base64_arraybuffer_umd = __commonJS({
    "node_modules/base64-arraybuffer/dist/base64-arraybuffer.umd.js"(exports, module) {
      (function(global2, factory) {
        typeof exports === "object" && typeof module !== "undefined" ? factory(exports) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2["base64-arraybuffer"] = {}));
      })(exports, function(exports2) {
        "use strict";
        var chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        var lookup = typeof Uint8Array === "undefined" ? [] : new Uint8Array(256);
        for (var i = 0; i < chars.length; i++) {
          lookup[chars.charCodeAt(i)] = i;
        }
        var encode = function(arraybuffer) {
          var bytes = new Uint8Array(arraybuffer), i2, len = bytes.length, base64 = "";
          for (i2 = 0; i2 < len; i2 += 3) {
            base64 += chars[bytes[i2] >> 2];
            base64 += chars[(bytes[i2] & 3) << 4 | bytes[i2 + 1] >> 4];
            base64 += chars[(bytes[i2 + 1] & 15) << 2 | bytes[i2 + 2] >> 6];
            base64 += chars[bytes[i2 + 2] & 63];
          }
          if (len % 3 === 2) {
            base64 = base64.substring(0, base64.length - 1) + "=";
          } else if (len % 3 === 1) {
            base64 = base64.substring(0, base64.length - 2) + "==";
          }
          return base64;
        };
        var decode = function(base64) {
          var bufferLength = base64.length * 0.75, len = base64.length, i2, p = 0, encoded1, encoded2, encoded3, encoded4;
          if (base64[base64.length - 1] === "=") {
            bufferLength--;
            if (base64[base64.length - 2] === "=") {
              bufferLength--;
            }
          }
          var arraybuffer = new ArrayBuffer(bufferLength), bytes = new Uint8Array(arraybuffer);
          for (i2 = 0; i2 < len; i2 += 4) {
            encoded1 = lookup[base64.charCodeAt(i2)];
            encoded2 = lookup[base64.charCodeAt(i2 + 1)];
            encoded3 = lookup[base64.charCodeAt(i2 + 2)];
            encoded4 = lookup[base64.charCodeAt(i2 + 3)];
            bytes[p++] = encoded1 << 2 | encoded2 >> 4;
            bytes[p++] = (encoded2 & 15) << 4 | encoded3 >> 2;
            bytes[p++] = (encoded3 & 3) << 6 | encoded4 & 63;
          }
          return arraybuffer;
        };
        exports2.decode = decode;
        exports2.encode = encode;
        Object.defineProperty(exports2, "__esModule", { value: true });
      });
    }
  });

  // src/lib/is_plain_object.js
  var require_is_plain_object = __commonJS({
    "src/lib/is_plain_object.js"(exports, module) {
      "use strict";
      module.exports = function isPlainObject(obj) {
        if (window && window.process && window.process.versions) {
          return Object.prototype.toString.call(obj) === "[object Object]";
        }
        return Object.prototype.toString.call(obj) === "[object Object]" && Object.getPrototypeOf(obj).hasOwnProperty("hasOwnProperty");
      };
    }
  });

  // src/lib/array.js
  var require_array = __commonJS({
    "src/lib/array.js"(exports) {
      "use strict";
      var b64decode = require_base64_arraybuffer_umd().decode;
      var isPlainObject = require_is_plain_object();
      var isArray = Array.isArray;
      var ab = ArrayBuffer;
      var dv = DataView;
      function isTypedArray(a) {
        return ab.isView(a) && !(a instanceof dv);
      }
      exports.isTypedArray = isTypedArray;
      function isArrayOrTypedArray(a) {
        return isArray(a) || isTypedArray(a);
      }
      exports.isArrayOrTypedArray = isArrayOrTypedArray;
      function isArray1D(a) {
        return !isArrayOrTypedArray(a[0]);
      }
      exports.isArray1D = isArray1D;
      exports.ensureArray = function(out, n) {
        if (!isArray(out)) out = [];
        out.length = n;
        return out;
      };
      var typedArrays = {
        u1c: typeof Uint8ClampedArray === "undefined" ? void 0 : Uint8ClampedArray,
        // not supported in numpy?
        i1: typeof Int8Array === "undefined" ? void 0 : Int8Array,
        u1: typeof Uint8Array === "undefined" ? void 0 : Uint8Array,
        i2: typeof Int16Array === "undefined" ? void 0 : Int16Array,
        u2: typeof Uint16Array === "undefined" ? void 0 : Uint16Array,
        i4: typeof Int32Array === "undefined" ? void 0 : Int32Array,
        u4: typeof Uint32Array === "undefined" ? void 0 : Uint32Array,
        f4: typeof Float32Array === "undefined" ? void 0 : Float32Array,
        f8: typeof Float64Array === "undefined" ? void 0 : Float64Array
        /* TODO: potentially add Big Int
        
            i8: typeof BigInt64Array === 'undefined' ? undefined :
                       BigInt64Array,
        
            u8: typeof BigUint64Array === 'undefined' ? undefined :
                       BigUint64Array,
            */
      };
      typedArrays.uint8c = typedArrays.u1c;
      typedArrays.uint8 = typedArrays.u1;
      typedArrays.int8 = typedArrays.i1;
      typedArrays.uint16 = typedArrays.u2;
      typedArrays.int16 = typedArrays.i2;
      typedArrays.uint32 = typedArrays.u4;
      typedArrays.int32 = typedArrays.i4;
      typedArrays.float32 = typedArrays.f4;
      typedArrays.float64 = typedArrays.f8;
      function isArrayBuffer(a) {
        return a.constructor === ArrayBuffer;
      }
      exports.isArrayBuffer = isArrayBuffer;
      exports.decodeTypedArraySpec = function(vIn) {
        var out = [];
        var v = coerceTypedArraySpec(vIn);
        var dtype = v.dtype;
        var T = typedArrays[dtype];
        if (!T) throw new Error('Error in dtype: "' + dtype + '"');
        var BYTES_PER_ELEMENT = T.BYTES_PER_ELEMENT;
        var buffer = v.bdata;
        if (!isArrayBuffer(buffer)) {
          buffer = b64decode(buffer);
        }
        var shape = v.shape === void 0 ? (
          // detect 1-d length
          [buffer.byteLength / BYTES_PER_ELEMENT]
        ) : (
          // convert number to string and split to array
          ("" + v.shape).split(",")
        );
        shape.reverse();
        var ndim = shape.length;
        var nj, j;
        var ni = +shape[0];
        var rowBytes = BYTES_PER_ELEMENT * ni;
        var pos = 0;
        if (ndim === 1) {
          out = new T(buffer);
        } else if (ndim === 2) {
          nj = +shape[1];
          for (j = 0; j < nj; j++) {
            out[j] = new T(buffer, pos, ni);
            pos += rowBytes;
          }
        } else if (ndim === 3) {
          nj = +shape[1];
          var nk = +shape[2];
          for (var k = 0; k < nk; k++) {
            out[k] = [];
            for (j = 0; j < nj; j++) {
              out[k][j] = new T(buffer, pos, ni);
              pos += rowBytes;
            }
          }
        } else {
          throw new Error("ndim: " + ndim + 'is not supported with the shape:"' + v.shape + '"');
        }
        out.bdata = v.bdata;
        out.dtype = v.dtype;
        out.shape = shape.reverse().join(",");
        vIn._inputArray = out;
        return out;
      };
      exports.isTypedArraySpec = function(v) {
        return isPlainObject(v) && v.hasOwnProperty("dtype") && typeof v.dtype === "string" && v.hasOwnProperty("bdata") && (typeof v.bdata === "string" || isArrayBuffer(v.bdata)) && (v.shape === void 0 || v.hasOwnProperty("shape") && (typeof v.shape === "string" || typeof v.shape === "number"));
      };
      function coerceTypedArraySpec(v) {
        return {
          bdata: v.bdata,
          dtype: v.dtype,
          shape: v.shape
        };
      }
      exports.concat = function() {
        var args = [];
        var allArray = true;
        var totalLen = 0;
        var _constructor, arg0, i, argi, posi, leni, out, j;
        for (i = 0; i < arguments.length; i++) {
          argi = arguments[i];
          leni = argi.length;
          if (leni) {
            if (arg0) args.push(argi);
            else {
              arg0 = argi;
              posi = leni;
            }
            if (isArray(argi)) {
              _constructor = false;
            } else {
              allArray = false;
              if (!totalLen) {
                _constructor = argi.constructor;
              } else if (_constructor !== argi.constructor) {
                _constructor = false;
              }
            }
            totalLen += leni;
          }
        }
        if (!totalLen) return [];
        if (!args.length) return arg0;
        if (allArray) return arg0.concat.apply(arg0, args);
        if (_constructor) {
          out = new _constructor(totalLen);
          out.set(arg0);
          for (i = 0; i < args.length; i++) {
            argi = args[i];
            out.set(argi, posi);
            posi += argi.length;
          }
          return out;
        }
        out = new Array(totalLen);
        for (j = 0; j < arg0.length; j++) out[j] = arg0[j];
        for (i = 0; i < args.length; i++) {
          argi = args[i];
          for (j = 0; j < argi.length; j++) out[posi + j] = argi[j];
          posi += j;
        }
        return out;
      };
      exports.maxRowLength = function(z) {
        return _rowLength(z, Math.max, 0);
      };
      exports.minRowLength = function(z) {
        return _rowLength(z, Math.min, Infinity);
      };
      function _rowLength(z, fn, len0) {
        if (isArrayOrTypedArray(z)) {
          if (isArrayOrTypedArray(z[0])) {
            var len = len0;
            for (var i = 0; i < z.length; i++) {
              len = fn(len, z[i].length);
            }
            return len;
          } else {
            return z.length;
          }
        }
        return 0;
      }
    }
  });

  // src/lib/nested_property.js
  var require_nested_property = __commonJS({
    "src/lib/nested_property.js"(exports, module) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var isArrayOrTypedArray = require_array().isArrayOrTypedArray;
      module.exports = function nestedProperty(container, propStr) {
        if (isNumeric(propStr)) propStr = String(propStr);
        else if (typeof propStr !== "string" || propStr.substr(propStr.length - 4) === "[-1]") {
          throw "bad property string";
        }
        var propParts = propStr.split(".");
        var indexed;
        var indices;
        var i, j;
        for (j = 0; j < propParts.length; j++) {
          if (String(propParts[j]).slice(0, 2) === "__") {
            throw "bad property string";
          }
        }
        j = 0;
        while (j < propParts.length) {
          indexed = String(propParts[j]).match(/^([^\[\]]*)((\[\-?[0-9]*\])+)$/);
          if (indexed) {
            if (indexed[1]) propParts[j] = indexed[1];
            else if (j === 0) propParts.splice(0, 1);
            else throw "bad property string";
            indices = indexed[2].substr(1, indexed[2].length - 2).split("][");
            for (i = 0; i < indices.length; i++) {
              j++;
              propParts.splice(j, 0, Number(indices[i]));
            }
          }
          j++;
        }
        if (typeof container !== "object") {
          return badContainer(container, propStr, propParts);
        }
        return {
          set: npSet(container, propParts, propStr),
          get: npGet(container, propParts),
          astr: propStr,
          parts: propParts,
          obj: container
        };
      };
      function npGet(cont, parts) {
        return function() {
          var curCont = cont;
          var curPart;
          var allSame;
          var out;
          var i;
          var j;
          for (i = 0; i < parts.length - 1; i++) {
            curPart = parts[i];
            if (curPart === -1) {
              allSame = true;
              out = [];
              for (j = 0; j < curCont.length; j++) {
                out[j] = npGet(curCont[j], parts.slice(i + 1))();
                if (out[j] !== out[0]) allSame = false;
              }
              return allSame ? out[0] : out;
            }
            if (typeof curPart === "number" && !isArrayOrTypedArray(curCont)) {
              return void 0;
            }
            curCont = curCont[curPart];
            if (typeof curCont !== "object" || curCont === null) {
              return void 0;
            }
          }
          if (typeof curCont !== "object" || curCont === null) return void 0;
          out = curCont[parts[i]];
          if (out === null) return void 0;
          return out;
        };
      }
      var ARGS_PATTERN = /(^|\.)args\[/;
      function isDeletable(val, propStr) {
        return val === void 0 || val === null && !propStr.match(ARGS_PATTERN);
      }
      function npSet(cont, parts, propStr) {
        return function(val) {
          var curCont = cont;
          var propPart = "";
          var containerLevels = [[cont, propPart]];
          var toDelete = isDeletable(val, propStr);
          var curPart;
          var i;
          for (i = 0; i < parts.length - 1; i++) {
            curPart = parts[i];
            if (typeof curPart === "number" && !isArrayOrTypedArray(curCont)) {
              throw "array index but container is not an array";
            }
            if (curPart === -1) {
              toDelete = !setArrayAll(curCont, parts.slice(i + 1), val, propStr);
              if (toDelete) break;
              else return;
            }
            if (!checkNewContainer(curCont, curPart, parts[i + 1], toDelete)) {
              break;
            }
            curCont = curCont[curPart];
            if (typeof curCont !== "object" || curCont === null) {
              throw "container is not an object";
            }
            propPart = joinPropStr(propPart, curPart);
            containerLevels.push([curCont, propPart]);
          }
          if (toDelete) {
            if (i === parts.length - 1) {
              delete curCont[parts[i]];
              if (Array.isArray(curCont) && +parts[i] === curCont.length - 1) {
                while (curCont.length && curCont[curCont.length - 1] === void 0) {
                  curCont.pop();
                }
              }
            }
          } else curCont[parts[i]] = val;
        };
      }
      function joinPropStr(propStr, newPart) {
        var toAdd = newPart;
        if (isNumeric(newPart)) toAdd = "[" + newPart + "]";
        else if (propStr) toAdd = "." + newPart;
        return propStr + toAdd;
      }
      function setArrayAll(containerArray, innerParts, val, propStr) {
        var arrayVal = isArrayOrTypedArray(val);
        var allSet = true;
        var thisVal = val;
        var thisPropStr = propStr.replace("-1", 0);
        var deleteThis = arrayVal ? false : isDeletable(val, thisPropStr);
        var firstPart = innerParts[0];
        var i;
        for (i = 0; i < containerArray.length; i++) {
          thisPropStr = propStr.replace("-1", i);
          if (arrayVal) {
            thisVal = val[i % val.length];
            deleteThis = isDeletable(thisVal, thisPropStr);
          }
          if (deleteThis) allSet = false;
          if (!checkNewContainer(containerArray, i, firstPart, deleteThis)) {
            continue;
          }
          npSet(containerArray[i], innerParts, propStr.replace("-1", i))(thisVal);
        }
        return allSet;
      }
      function checkNewContainer(container, part, nextPart, toDelete) {
        if (container[part] === void 0) {
          if (toDelete) return false;
          if (typeof nextPart === "number") container[part] = [];
          else container[part] = {};
        }
        return true;
      }
      function badContainer(container, propStr, propParts) {
        return {
          set: function() {
            throw "bad container";
          },
          get: function() {
          },
          astr: propStr,
          parts: propParts,
          obj: container
        };
      }
    }
  });

  // src/lib/keyed_container.js
  var require_keyed_container = __commonJS({
    "src/lib/keyed_container.js"(exports, module) {
      "use strict";
      var nestedProperty = require_nested_property();
      var SIMPLE_PROPERTY_REGEX = /^\w*$/;
      var NONE = 0;
      var NAME = 1;
      var VALUE = 2;
      var BOTH = 3;
      var UNSET = 4;
      module.exports = function keyedContainer(baseObj, path, keyName, valueName) {
        keyName = keyName || "name";
        valueName = valueName || "value";
        var i, arr, baseProp;
        var changeTypes = {};
        if (path && path.length) {
          baseProp = nestedProperty(baseObj, path);
          arr = baseProp.get();
        } else {
          arr = baseObj;
        }
        path = path || "";
        var indexLookup = {};
        if (arr) {
          for (i = 0; i < arr.length; i++) {
            indexLookup[arr[i][keyName]] = i;
          }
        }
        var isSimpleValueProp = SIMPLE_PROPERTY_REGEX.test(valueName);
        var obj = {
          set: function(name2, value) {
            var changeType = value === null ? UNSET : NONE;
            if (!arr) {
              if (!baseProp || changeType === UNSET) return;
              arr = [];
              baseProp.set(arr);
            }
            var idx = indexLookup[name2];
            if (idx === void 0) {
              if (changeType === UNSET) return;
              changeType = changeType | BOTH;
              idx = arr.length;
              indexLookup[name2] = idx;
            } else if (value !== (isSimpleValueProp ? arr[idx][valueName] : nestedProperty(arr[idx], valueName).get())) {
              changeType = changeType | VALUE;
            }
            var newValue = arr[idx] = arr[idx] || {};
            newValue[keyName] = name2;
            if (isSimpleValueProp) {
              newValue[valueName] = value;
            } else {
              nestedProperty(newValue, valueName).set(value);
            }
            if (value !== null) {
              changeType = changeType & ~UNSET;
            }
            changeTypes[idx] = changeTypes[idx] | changeType;
            return obj;
          },
          get: function(name2) {
            if (!arr) return;
            var idx = indexLookup[name2];
            if (idx === void 0) {
              return void 0;
            } else if (isSimpleValueProp) {
              return arr[idx][valueName];
            } else {
              return nestedProperty(arr[idx], valueName).get();
            }
          },
          rename: function(name2, newName) {
            var idx = indexLookup[name2];
            if (idx === void 0) return obj;
            changeTypes[idx] = changeTypes[idx] | NAME;
            indexLookup[newName] = idx;
            delete indexLookup[name2];
            arr[idx][keyName] = newName;
            return obj;
          },
          remove: function(name2) {
            var idx = indexLookup[name2];
            if (idx === void 0) return obj;
            var object = arr[idx];
            if (Object.keys(object).length > 2) {
              changeTypes[idx] = changeTypes[idx] | VALUE;
              return obj.set(name2, null);
            }
            if (isSimpleValueProp) {
              for (i = idx; i < arr.length; i++) {
                changeTypes[i] = changeTypes[i] | BOTH;
              }
              for (i = idx; i < arr.length; i++) {
                indexLookup[arr[i][keyName]]--;
              }
              arr.splice(idx, 1);
              delete indexLookup[name2];
            } else {
              nestedProperty(object, valueName).set(null);
              changeTypes[idx] = changeTypes[idx] | VALUE | UNSET;
            }
            return obj;
          },
          constructUpdate: function() {
            var astr, idx;
            var update = {};
            var changed = Object.keys(changeTypes);
            for (var i2 = 0; i2 < changed.length; i2++) {
              idx = changed[i2];
              astr = path + "[" + idx + "]";
              if (arr[idx]) {
                if (changeTypes[idx] & NAME) {
                  update[astr + "." + keyName] = arr[idx][keyName];
                }
                if (changeTypes[idx] & VALUE) {
                  if (isSimpleValueProp) {
                    update[astr + "." + valueName] = changeTypes[idx] & UNSET ? null : arr[idx][valueName];
                  } else {
                    update[astr + "." + valueName] = changeTypes[idx] & UNSET ? null : nestedProperty(arr[idx], valueName).get();
                  }
                }
              } else {
                update[astr] = null;
              }
            }
            return update;
          }
        };
        return obj;
      };
    }
  });

  // src/lib/relative_attr.js
  var require_relative_attr = __commonJS({
    "src/lib/relative_attr.js"(exports, module) {
      "use strict";
      var ASCEND = /^(.*)(\.[^\.\[\]]+|\[\d\])$/;
      var SIMPLEATTR = /^[^\.\[\]]+$/;
      module.exports = function(baseAttr, relativeAttr) {
        while (relativeAttr) {
          var match = baseAttr.match(ASCEND);
          if (match) baseAttr = match[1];
          else if (baseAttr.match(SIMPLEATTR)) baseAttr = "";
          else throw new Error("bad relativeAttr call:" + [baseAttr, relativeAttr]);
          if (relativeAttr.charAt(0) === "^") relativeAttr = relativeAttr.slice(1);
          else break;
        }
        if (baseAttr && relativeAttr.charAt(0) !== "[") {
          return baseAttr + "." + relativeAttr;
        }
        return baseAttr + relativeAttr;
      };
    }
  });

  // src/lib/to_log_range.js
  var require_to_log_range = __commonJS({
    "src/lib/to_log_range.js"(exports, module) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      module.exports = function toLogRange(val, range) {
        if (val > 0) return Math.log(val) / Math.LN10;
        var newVal = Math.log(Math.min(range[0], range[1])) / Math.LN10;
        if (!isNumeric(newVal)) newVal = Math.log(Math.max(range[0], range[1])) / Math.LN10 - 6;
        return newVal;
      };
    }
  });

  // src/lib/relink_private.js
  var require_relink_private = __commonJS({
    "src/lib/relink_private.js"(exports, module) {
      "use strict";
      var isArrayOrTypedArray = require_array().isArrayOrTypedArray;
      var isPlainObject = require_is_plain_object();
      module.exports = function relinkPrivateKeys(toContainer, fromContainer) {
        for (var k in fromContainer) {
          var fromVal = fromContainer[k];
          var toVal = toContainer[k];
          if (toVal === fromVal) continue;
          if (k.charAt(0) === "_" || typeof fromVal === "function") {
            if (k in toContainer) continue;
            toContainer[k] = fromVal;
          } else if (isArrayOrTypedArray(fromVal) && isArrayOrTypedArray(toVal) && isPlainObject(fromVal[0])) {
            if (k === "customdata" || k === "ids") continue;
            var minLen = Math.min(fromVal.length, toVal.length);
            for (var j = 0; j < minLen; j++) {
              if (toVal[j] !== fromVal[j] && isPlainObject(fromVal[j]) && isPlainObject(toVal[j])) {
                relinkPrivateKeys(toVal[j], fromVal[j]);
              }
            }
          } else if (isPlainObject(fromVal) && isPlainObject(toVal)) {
            relinkPrivateKeys(toVal, fromVal);
            if (!Object.keys(toVal).length) delete toContainer[k];
          }
        }
      };
    }
  });

  // src/lib/mod.js
  var require_mod = __commonJS({
    "src/lib/mod.js"(exports, module) {
      "use strict";
      function mod(v, d) {
        var out = v % d;
        return out < 0 ? out + d : out;
      }
      function modHalf(v, d) {
        return Math.abs(v) > d / 2 ? v - Math.round(v / d) * d : v;
      }
      module.exports = {
        mod,
        modHalf
      };
    }
  });

  // node_modules/tinycolor2/tinycolor.js
  var require_tinycolor = __commonJS({
    "node_modules/tinycolor2/tinycolor.js"(exports, module) {
      (function(Math2) {
        var trimLeft = /^\s+/, trimRight = /\s+$/, tinyCounter = 0, mathRound = Math2.round, mathMin = Math2.min, mathMax = Math2.max, mathRandom = Math2.random;
        function tinycolor(color2, opts) {
          color2 = color2 ? color2 : "";
          opts = opts || {};
          if (color2 instanceof tinycolor) {
            return color2;
          }
          if (!(this instanceof tinycolor)) {
            return new tinycolor(color2, opts);
          }
          var rgb2 = inputToRGB(color2);
          this._originalInput = color2, this._r = rgb2.r, this._g = rgb2.g, this._b = rgb2.b, this._a = rgb2.a, this._roundA = mathRound(100 * this._a) / 100, this._format = opts.format || rgb2.format;
          this._gradientType = opts.gradientType;
          if (this._r < 1) {
            this._r = mathRound(this._r);
          }
          if (this._g < 1) {
            this._g = mathRound(this._g);
          }
          if (this._b < 1) {
            this._b = mathRound(this._b);
          }
          this._ok = rgb2.ok;
          this._tc_id = tinyCounter++;
        }
        tinycolor.prototype = {
          isDark: function() {
            return this.getBrightness() < 128;
          },
          isLight: function() {
            return !this.isDark();
          },
          isValid: function() {
            return this._ok;
          },
          getOriginalInput: function() {
            return this._originalInput;
          },
          getFormat: function() {
            return this._format;
          },
          getAlpha: function() {
            return this._a;
          },
          getBrightness: function() {
            var rgb2 = this.toRgb();
            return (rgb2.r * 299 + rgb2.g * 587 + rgb2.b * 114) / 1e3;
          },
          getLuminance: function() {
            var rgb2 = this.toRgb();
            var RsRGB, GsRGB, BsRGB, R, G, B2;
            RsRGB = rgb2.r / 255;
            GsRGB = rgb2.g / 255;
            BsRGB = rgb2.b / 255;
            if (RsRGB <= 0.03928) {
              R = RsRGB / 12.92;
            } else {
              R = Math2.pow((RsRGB + 0.055) / 1.055, 2.4);
            }
            if (GsRGB <= 0.03928) {
              G = GsRGB / 12.92;
            } else {
              G = Math2.pow((GsRGB + 0.055) / 1.055, 2.4);
            }
            if (BsRGB <= 0.03928) {
              B2 = BsRGB / 12.92;
            } else {
              B2 = Math2.pow((BsRGB + 0.055) / 1.055, 2.4);
            }
            return 0.2126 * R + 0.7152 * G + 0.0722 * B2;
          },
          setAlpha: function(value) {
            this._a = boundAlpha(value);
            this._roundA = mathRound(100 * this._a) / 100;
            return this;
          },
          toHsv: function() {
            var hsv = rgbToHsv(this._r, this._g, this._b);
            return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };
          },
          toHsvString: function() {
            var hsv = rgbToHsv(this._r, this._g, this._b);
            var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);
            return this._a == 1 ? "hsv(" + h + ", " + s + "%, " + v + "%)" : "hsva(" + h + ", " + s + "%, " + v + "%, " + this._roundA + ")";
          },
          toHsl: function() {
            var hsl3 = rgbToHsl(this._r, this._g, this._b);
            return { h: hsl3.h * 360, s: hsl3.s, l: hsl3.l, a: this._a };
          },
          toHslString: function() {
            var hsl3 = rgbToHsl(this._r, this._g, this._b);
            var h = mathRound(hsl3.h * 360), s = mathRound(hsl3.s * 100), l = mathRound(hsl3.l * 100);
            return this._a == 1 ? "hsl(" + h + ", " + s + "%, " + l + "%)" : "hsla(" + h + ", " + s + "%, " + l + "%, " + this._roundA + ")";
          },
          toHex: function(allow3Char) {
            return rgbToHex(this._r, this._g, this._b, allow3Char);
          },
          toHexString: function(allow3Char) {
            return "#" + this.toHex(allow3Char);
          },
          toHex8: function(allow4Char) {
            return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);
          },
          toHex8String: function(allow4Char) {
            return "#" + this.toHex8(allow4Char);
          },
          toRgb: function() {
            return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };
          },
          toRgbString: function() {
            return this._a == 1 ? "rgb(" + mathRound(this._r) + ", " + mathRound(this._g) + ", " + mathRound(this._b) + ")" : "rgba(" + mathRound(this._r) + ", " + mathRound(this._g) + ", " + mathRound(this._b) + ", " + this._roundA + ")";
          },
          toPercentageRgb: function() {
            return { r: mathRound(bound01(this._r, 255) * 100) + "%", g: mathRound(bound01(this._g, 255) * 100) + "%", b: mathRound(bound01(this._b, 255) * 100) + "%", a: this._a };
          },
          toPercentageRgbString: function() {
            return this._a == 1 ? "rgb(" + mathRound(bound01(this._r, 255) * 100) + "%, " + mathRound(bound01(this._g, 255) * 100) + "%, " + mathRound(bound01(this._b, 255) * 100) + "%)" : "rgba(" + mathRound(bound01(this._r, 255) * 100) + "%, " + mathRound(bound01(this._g, 255) * 100) + "%, " + mathRound(bound01(this._b, 255) * 100) + "%, " + this._roundA + ")";
          },
          toName: function() {
            if (this._a === 0) {
              return "transparent";
            }
            if (this._a < 1) {
              return false;
            }
            return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;
          },
          toFilter: function(secondColor) {
            var hex8String = "#" + rgbaToArgbHex(this._r, this._g, this._b, this._a);
            var secondHex8String = hex8String;
            var gradientType = this._gradientType ? "GradientType = 1, " : "";
            if (secondColor) {
              var s = tinycolor(secondColor);
              secondHex8String = "#" + rgbaToArgbHex(s._r, s._g, s._b, s._a);
            }
            return "progid:DXImageTransform.Microsoft.gradient(" + gradientType + "startColorstr=" + hex8String + ",endColorstr=" + secondHex8String + ")";
          },
          toString: function(format) {
            var formatSet = !!format;
            format = format || this._format;
            var formattedString = false;
            var hasAlpha = this._a < 1 && this._a >= 0;
            var needsAlphaFormat = !formatSet && hasAlpha && (format === "hex" || format === "hex6" || format === "hex3" || format === "hex4" || format === "hex8" || format === "name");
            if (needsAlphaFormat) {
              if (format === "name" && this._a === 0) {
                return this.toName();
              }
              return this.toRgbString();
            }
            if (format === "rgb") {
              formattedString = this.toRgbString();
            }
            if (format === "prgb") {
              formattedString = this.toPercentageRgbString();
            }
            if (format === "hex" || format === "hex6") {
              formattedString = this.toHexString();
            }
            if (format === "hex3") {
              formattedString = this.toHexString(true);
            }
            if (format === "hex4") {
              formattedString = this.toHex8String(true);
            }
            if (format === "hex8") {
              formattedString = this.toHex8String();
            }
            if (format === "name") {
              formattedString = this.toName();
            }
            if (format === "hsl") {
              formattedString = this.toHslString();
            }
            if (format === "hsv") {
              formattedString = this.toHsvString();
            }
            return formattedString || this.toHexString();
          },
          clone: function() {
            return tinycolor(this.toString());
          },
          _applyModification: function(fn, args) {
            var color2 = fn.apply(null, [this].concat([].slice.call(args)));
            this._r = color2._r;
            this._g = color2._g;
            this._b = color2._b;
            this.setAlpha(color2._a);
            return this;
          },
          lighten: function() {
            return this._applyModification(lighten, arguments);
          },
          brighten: function() {
            return this._applyModification(brighten, arguments);
          },
          darken: function() {
            return this._applyModification(darken, arguments);
          },
          desaturate: function() {
            return this._applyModification(desaturate, arguments);
          },
          saturate: function() {
            return this._applyModification(saturate, arguments);
          },
          greyscale: function() {
            return this._applyModification(greyscale, arguments);
          },
          spin: function() {
            return this._applyModification(spin, arguments);
          },
          _applyCombination: function(fn, args) {
            return fn.apply(null, [this].concat([].slice.call(args)));
          },
          analogous: function() {
            return this._applyCombination(analogous, arguments);
          },
          complement: function() {
            return this._applyCombination(complement, arguments);
          },
          monochromatic: function() {
            return this._applyCombination(monochromatic, arguments);
          },
          splitcomplement: function() {
            return this._applyCombination(splitcomplement, arguments);
          },
          triad: function() {
            return this._applyCombination(triad, arguments);
          },
          tetrad: function() {
            return this._applyCombination(tetrad, arguments);
          }
        };
        tinycolor.fromRatio = function(color2, opts) {
          if (typeof color2 == "object") {
            var newColor = {};
            for (var i in color2) {
              if (color2.hasOwnProperty(i)) {
                if (i === "a") {
                  newColor[i] = color2[i];
                } else {
                  newColor[i] = convertToPercentage(color2[i]);
                }
              }
            }
            color2 = newColor;
          }
          return tinycolor(color2, opts);
        };
        function inputToRGB(color2) {
          var rgb2 = { r: 0, g: 0, b: 0 };
          var a = 1;
          var s = null;
          var v = null;
          var l = null;
          var ok = false;
          var format = false;
          if (typeof color2 == "string") {
            color2 = stringInputToObject(color2);
          }
          if (typeof color2 == "object") {
            if (isValidCSSUnit(color2.r) && isValidCSSUnit(color2.g) && isValidCSSUnit(color2.b)) {
              rgb2 = rgbToRgb(color2.r, color2.g, color2.b);
              ok = true;
              format = String(color2.r).substr(-1) === "%" ? "prgb" : "rgb";
            } else if (isValidCSSUnit(color2.h) && isValidCSSUnit(color2.s) && isValidCSSUnit(color2.v)) {
              s = convertToPercentage(color2.s);
              v = convertToPercentage(color2.v);
              rgb2 = hsvToRgb(color2.h, s, v);
              ok = true;
              format = "hsv";
            } else if (isValidCSSUnit(color2.h) && isValidCSSUnit(color2.s) && isValidCSSUnit(color2.l)) {
              s = convertToPercentage(color2.s);
              l = convertToPercentage(color2.l);
              rgb2 = hslToRgb(color2.h, s, l);
              ok = true;
              format = "hsl";
            }
            if (color2.hasOwnProperty("a")) {
              a = color2.a;
            }
          }
          a = boundAlpha(a);
          return {
            ok,
            format: color2.format || format,
            r: mathMin(255, mathMax(rgb2.r, 0)),
            g: mathMin(255, mathMax(rgb2.g, 0)),
            b: mathMin(255, mathMax(rgb2.b, 0)),
            a
          };
        }
        function rgbToRgb(r, g, b) {
          return {
            r: bound01(r, 255) * 255,
            g: bound01(g, 255) * 255,
            b: bound01(b, 255) * 255
          };
        }
        function rgbToHsl(r, g, b) {
          r = bound01(r, 255);
          g = bound01(g, 255);
          b = bound01(b, 255);
          var max = mathMax(r, g, b), min = mathMin(r, g, b);
          var h, s, l = (max + min) / 2;
          if (max == min) {
            h = s = 0;
          } else {
            var d = max - min;
            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
            switch (max) {
              case r:
                h = (g - b) / d + (g < b ? 6 : 0);
                break;
              case g:
                h = (b - r) / d + 2;
                break;
              case b:
                h = (r - g) / d + 4;
                break;
            }
            h /= 6;
          }
          return { h, s, l };
        }
        function hslToRgb(h, s, l) {
          var r, g, b;
          h = bound01(h, 360);
          s = bound01(s, 100);
          l = bound01(l, 100);
          function hue2rgb(p2, q2, t) {
            if (t < 0) t += 1;
            if (t > 1) t -= 1;
            if (t < 1 / 6) return p2 + (q2 - p2) * 6 * t;
            if (t < 1 / 2) return q2;
            if (t < 2 / 3) return p2 + (q2 - p2) * (2 / 3 - t) * 6;
            return p2;
          }
          if (s === 0) {
            r = g = b = l;
          } else {
            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
            var p = 2 * l - q;
            r = hue2rgb(p, q, h + 1 / 3);
            g = hue2rgb(p, q, h);
            b = hue2rgb(p, q, h - 1 / 3);
          }
          return { r: r * 255, g: g * 255, b: b * 255 };
        }
        function rgbToHsv(r, g, b) {
          r = bound01(r, 255);
          g = bound01(g, 255);
          b = bound01(b, 255);
          var max = mathMax(r, g, b), min = mathMin(r, g, b);
          var h, s, v = max;
          var d = max - min;
          s = max === 0 ? 0 : d / max;
          if (max == min) {
            h = 0;
          } else {
            switch (max) {
              case r:
                h = (g - b) / d + (g < b ? 6 : 0);
                break;
              case g:
                h = (b - r) / d + 2;
                break;
              case b:
                h = (r - g) / d + 4;
                break;
            }
            h /= 6;
          }
          return { h, s, v };
        }
        function hsvToRgb(h, s, v) {
          h = bound01(h, 360) * 6;
          s = bound01(s, 100);
          v = bound01(v, 100);
          var i = Math2.floor(h), f = h - i, p = v * (1 - s), q = v * (1 - f * s), t = v * (1 - (1 - f) * s), mod = i % 6, r = [v, q, p, p, t, v][mod], g = [t, v, v, q, p, p][mod], b = [p, p, t, v, v, q][mod];
          return { r: r * 255, g: g * 255, b: b * 255 };
        }
        function rgbToHex(r, g, b, allow3Char) {
          var hex2 = [
            pad2(mathRound(r).toString(16)),
            pad2(mathRound(g).toString(16)),
            pad2(mathRound(b).toString(16))
          ];
          if (allow3Char && hex2[0].charAt(0) == hex2[0].charAt(1) && hex2[1].charAt(0) == hex2[1].charAt(1) && hex2[2].charAt(0) == hex2[2].charAt(1)) {
            return hex2[0].charAt(0) + hex2[1].charAt(0) + hex2[2].charAt(0);
          }
          return hex2.join("");
        }
        function rgbaToHex(r, g, b, a, allow4Char) {
          var hex2 = [
            pad2(mathRound(r).toString(16)),
            pad2(mathRound(g).toString(16)),
            pad2(mathRound(b).toString(16)),
            pad2(convertDecimalToHex(a))
          ];
          if (allow4Char && hex2[0].charAt(0) == hex2[0].charAt(1) && hex2[1].charAt(0) == hex2[1].charAt(1) && hex2[2].charAt(0) == hex2[2].charAt(1) && hex2[3].charAt(0) == hex2[3].charAt(1)) {
            return hex2[0].charAt(0) + hex2[1].charAt(0) + hex2[2].charAt(0) + hex2[3].charAt(0);
          }
          return hex2.join("");
        }
        function rgbaToArgbHex(r, g, b, a) {
          var hex2 = [
            pad2(convertDecimalToHex(a)),
            pad2(mathRound(r).toString(16)),
            pad2(mathRound(g).toString(16)),
            pad2(mathRound(b).toString(16))
          ];
          return hex2.join("");
        }
        tinycolor.equals = function(color1, color2) {
          if (!color1 || !color2) {
            return false;
          }
          return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();
        };
        tinycolor.random = function() {
          return tinycolor.fromRatio({
            r: mathRandom(),
            g: mathRandom(),
            b: mathRandom()
          });
        };
        function desaturate(color2, amount) {
          amount = amount === 0 ? 0 : amount || 10;
          var hsl3 = tinycolor(color2).toHsl();
          hsl3.s -= amount / 100;
          hsl3.s = clamp01(hsl3.s);
          return tinycolor(hsl3);
        }
        function saturate(color2, amount) {
          amount = amount === 0 ? 0 : amount || 10;
          var hsl3 = tinycolor(color2).toHsl();
          hsl3.s += amount / 100;
          hsl3.s = clamp01(hsl3.s);
          return tinycolor(hsl3);
        }
        function greyscale(color2) {
          return tinycolor(color2).desaturate(100);
        }
        function lighten(color2, amount) {
          amount = amount === 0 ? 0 : amount || 10;
          var hsl3 = tinycolor(color2).toHsl();
          hsl3.l += amount / 100;
          hsl3.l = clamp01(hsl3.l);
          return tinycolor(hsl3);
        }
        function brighten(color2, amount) {
          amount = amount === 0 ? 0 : amount || 10;
          var rgb2 = tinycolor(color2).toRgb();
          rgb2.r = mathMax(0, mathMin(255, rgb2.r - mathRound(255 * -(amount / 100))));
          rgb2.g = mathMax(0, mathMin(255, rgb2.g - mathRound(255 * -(amount / 100))));
          rgb2.b = mathMax(0, mathMin(255, rgb2.b - mathRound(255 * -(amount / 100))));
          return tinycolor(rgb2);
        }
        function darken(color2, amount) {
          amount = amount === 0 ? 0 : amount || 10;
          var hsl3 = tinycolor(color2).toHsl();
          hsl3.l -= amount / 100;
          hsl3.l = clamp01(hsl3.l);
          return tinycolor(hsl3);
        }
        function spin(color2, amount) {
          var hsl3 = tinycolor(color2).toHsl();
          var hue2 = (hsl3.h + amount) % 360;
          hsl3.h = hue2 < 0 ? 360 + hue2 : hue2;
          return tinycolor(hsl3);
        }
        function complement(color2) {
          var hsl3 = tinycolor(color2).toHsl();
          hsl3.h = (hsl3.h + 180) % 360;
          return tinycolor(hsl3);
        }
        function triad(color2) {
          var hsl3 = tinycolor(color2).toHsl();
          var h = hsl3.h;
          return [
            tinycolor(color2),
            tinycolor({ h: (h + 120) % 360, s: hsl3.s, l: hsl3.l }),
            tinycolor({ h: (h + 240) % 360, s: hsl3.s, l: hsl3.l })
          ];
        }
        function tetrad(color2) {
          var hsl3 = tinycolor(color2).toHsl();
          var h = hsl3.h;
          return [
            tinycolor(color2),
            tinycolor({ h: (h + 90) % 360, s: hsl3.s, l: hsl3.l }),
            tinycolor({ h: (h + 180) % 360, s: hsl3.s, l: hsl3.l }),
            tinycolor({ h: (h + 270) % 360, s: hsl3.s, l: hsl3.l })
          ];
        }
        function splitcomplement(color2) {
          var hsl3 = tinycolor(color2).toHsl();
          var h = hsl3.h;
          return [
            tinycolor(color2),
            tinycolor({ h: (h + 72) % 360, s: hsl3.s, l: hsl3.l }),
            tinycolor({ h: (h + 216) % 360, s: hsl3.s, l: hsl3.l })
          ];
        }
        function analogous(color2, results, slices) {
          results = results || 6;
          slices = slices || 30;
          var hsl3 = tinycolor(color2).toHsl();
          var part = 360 / slices;
          var ret = [tinycolor(color2)];
          for (hsl3.h = (hsl3.h - (part * results >> 1) + 720) % 360; --results; ) {
            hsl3.h = (hsl3.h + part) % 360;
            ret.push(tinycolor(hsl3));
          }
          return ret;
        }
        function monochromatic(color2, results) {
          results = results || 6;
          var hsv = tinycolor(color2).toHsv();
          var h = hsv.h, s = hsv.s, v = hsv.v;
          var ret = [];
          var modification = 1 / results;
          while (results--) {
            ret.push(tinycolor({ h, s, v }));
            v = (v + modification) % 1;
          }
          return ret;
        }
        tinycolor.mix = function(color1, color2, amount) {
          amount = amount === 0 ? 0 : amount || 50;
          var rgb1 = tinycolor(color1).toRgb();
          var rgb2 = tinycolor(color2).toRgb();
          var p = amount / 100;
          var rgba2 = {
            r: (rgb2.r - rgb1.r) * p + rgb1.r,
            g: (rgb2.g - rgb1.g) * p + rgb1.g,
            b: (rgb2.b - rgb1.b) * p + rgb1.b,
            a: (rgb2.a - rgb1.a) * p + rgb1.a
          };
          return tinycolor(rgba2);
        };
        tinycolor.readability = function(color1, color2) {
          var c1 = tinycolor(color1);
          var c2 = tinycolor(color2);
          return (Math2.max(c1.getLuminance(), c2.getLuminance()) + 0.05) / (Math2.min(c1.getLuminance(), c2.getLuminance()) + 0.05);
        };
        tinycolor.isReadable = function(color1, color2, wcag2) {
          var readability = tinycolor.readability(color1, color2);
          var wcag2Parms, out;
          out = false;
          wcag2Parms = validateWCAG2Parms(wcag2);
          switch (wcag2Parms.level + wcag2Parms.size) {
            case "AAsmall":
            case "AAAlarge":
              out = readability >= 4.5;
              break;
            case "AAlarge":
              out = readability >= 3;
              break;
            case "AAAsmall":
              out = readability >= 7;
              break;
          }
          return out;
        };
        tinycolor.mostReadable = function(baseColor, colorList, args) {
          var bestColor = null;
          var bestScore = 0;
          var readability;
          var includeFallbackColors, level, size;
          args = args || {};
          includeFallbackColors = args.includeFallbackColors;
          level = args.level;
          size = args.size;
          for (var i = 0; i < colorList.length; i++) {
            readability = tinycolor.readability(baseColor, colorList[i]);
            if (readability > bestScore) {
              bestScore = readability;
              bestColor = tinycolor(colorList[i]);
            }
          }
          if (tinycolor.isReadable(baseColor, bestColor, { "level": level, "size": size }) || !includeFallbackColors) {
            return bestColor;
          } else {
            args.includeFallbackColors = false;
            return tinycolor.mostReadable(baseColor, ["#fff", "#000"], args);
          }
        };
        var names = tinycolor.names = {
          aliceblue: "f0f8ff",
          antiquewhite: "faebd7",
          aqua: "0ff",
          aquamarine: "7fffd4",
          azure: "f0ffff",
          beige: "f5f5dc",
          bisque: "ffe4c4",
          black: "000",
          blanchedalmond: "ffebcd",
          blue: "00f",
          blueviolet: "8a2be2",
          brown: "a52a2a",
          burlywood: "deb887",
          burntsienna: "ea7e5d",
          cadetblue: "5f9ea0",
          chartreuse: "7fff00",
          chocolate: "d2691e",
          coral: "ff7f50",
          cornflowerblue: "6495ed",
          cornsilk: "fff8dc",
          crimson: "dc143c",
          cyan: "0ff",
          darkblue: "00008b",
          darkcyan: "008b8b",
          darkgoldenrod: "b8860b",
          darkgray: "a9a9a9",
          darkgreen: "006400",
          darkgrey: "a9a9a9",
          darkkhaki: "bdb76b",
          darkmagenta: "8b008b",
          darkolivegreen: "556b2f",
          darkorange: "ff8c00",
          darkorchid: "9932cc",
          darkred: "8b0000",
          darksalmon: "e9967a",
          darkseagreen: "8fbc8f",
          darkslateblue: "483d8b",
          darkslategray: "2f4f4f",
          darkslategrey: "2f4f4f",
          darkturquoise: "00ced1",
          darkviolet: "9400d3",
          deeppink: "ff1493",
          deepskyblue: "00bfff",
          dimgray: "696969",
          dimgrey: "696969",
          dodgerblue: "1e90ff",
          firebrick: "b22222",
          floralwhite: "fffaf0",
          forestgreen: "228b22",
          fuchsia: "f0f",
          gainsboro: "dcdcdc",
          ghostwhite: "f8f8ff",
          gold: "ffd700",
          goldenrod: "daa520",
          gray: "808080",
          green: "008000",
          greenyellow: "adff2f",
          grey: "808080",
          honeydew: "f0fff0",
          hotpink: "ff69b4",
          indianred: "cd5c5c",
          indigo: "4b0082",
          ivory: "fffff0",
          khaki: "f0e68c",
          lavender: "e6e6fa",
          lavenderblush: "fff0f5",
          lawngreen: "7cfc00",
          lemonchiffon: "fffacd",
          lightblue: "add8e6",
          lightcoral: "f08080",
          lightcyan: "e0ffff",
          lightgoldenrodyellow: "fafad2",
          lightgray: "d3d3d3",
          lightgreen: "90ee90",
          lightgrey: "d3d3d3",
          lightpink: "ffb6c1",
          lightsalmon: "ffa07a",
          lightseagreen: "20b2aa",
          lightskyblue: "87cefa",
          lightslategray: "789",
          lightslategrey: "789",
          lightsteelblue: "b0c4de",
          lightyellow: "ffffe0",
          lime: "0f0",
          limegreen: "32cd32",
          linen: "faf0e6",
          magenta: "f0f",
          maroon: "800000",
          mediumaquamarine: "66cdaa",
          mediumblue: "0000cd",
          mediumorchid: "ba55d3",
          mediumpurple: "9370db",
          mediumseagreen: "3cb371",
          mediumslateblue: "7b68ee",
          mediumspringgreen: "00fa9a",
          mediumturquoise: "48d1cc",
          mediumvioletred: "c71585",
          midnightblue: "191970",
          mintcream: "f5fffa",
          mistyrose: "ffe4e1",
          moccasin: "ffe4b5",
          navajowhite: "ffdead",
          navy: "000080",
          oldlace: "fdf5e6",
          olive: "808000",
          olivedrab: "6b8e23",
          orange: "ffa500",
          orangered: "ff4500",
          orchid: "da70d6",
          palegoldenrod: "eee8aa",
          palegreen: "98fb98",
          paleturquoise: "afeeee",
          palevioletred: "db7093",
          papayawhip: "ffefd5",
          peachpuff: "ffdab9",
          peru: "cd853f",
          pink: "ffc0cb",
          plum: "dda0dd",
          powderblue: "b0e0e6",
          purple: "800080",
          rebeccapurple: "663399",
          red: "f00",
          rosybrown: "bc8f8f",
          royalblue: "4169e1",
          saddlebrown: "8b4513",
          salmon: "fa8072",
          sandybrown: "f4a460",
          seagreen: "2e8b57",
          seashell: "fff5ee",
          sienna: "a0522d",
          silver: "c0c0c0",
          skyblue: "87ceeb",
          slateblue: "6a5acd",
          slategray: "708090",
          slategrey: "708090",
          snow: "fffafa",
          springgreen: "00ff7f",
          steelblue: "4682b4",
          tan: "d2b48c",
          teal: "008080",
          thistle: "d8bfd8",
          tomato: "ff6347",
          turquoise: "40e0d0",
          violet: "ee82ee",
          wheat: "f5deb3",
          white: "fff",
          whitesmoke: "f5f5f5",
          yellow: "ff0",
          yellowgreen: "9acd32"
        };
        var hexNames = tinycolor.hexNames = flip(names);
        function flip(o) {
          var flipped = {};
          for (var i in o) {
            if (o.hasOwnProperty(i)) {
              flipped[o[i]] = i;
            }
          }
          return flipped;
        }
        function boundAlpha(a) {
          a = parseFloat(a);
          if (isNaN(a) || a < 0 || a > 1) {
            a = 1;
          }
          return a;
        }
        function bound01(n, max) {
          if (isOnePointZero(n)) {
            n = "100%";
          }
          var processPercent = isPercentage(n);
          n = mathMin(max, mathMax(0, parseFloat(n)));
          if (processPercent) {
            n = parseInt(n * max, 10) / 100;
          }
          if (Math2.abs(n - max) < 1e-6) {
            return 1;
          }
          return n % max / parseFloat(max);
        }
        function clamp01(val) {
          return mathMin(1, mathMax(0, val));
        }
        function parseIntFromHex(val) {
          return parseInt(val, 16);
        }
        function isOnePointZero(n) {
          return typeof n == "string" && n.indexOf(".") != -1 && parseFloat(n) === 1;
        }
        function isPercentage(n) {
          return typeof n === "string" && n.indexOf("%") != -1;
        }
        function pad2(c) {
          return c.length == 1 ? "0" + c : "" + c;
        }
        function convertToPercentage(n) {
          if (n <= 1) {
            n = n * 100 + "%";
          }
          return n;
        }
        function convertDecimalToHex(d) {
          return Math2.round(parseFloat(d) * 255).toString(16);
        }
        function convertHexToDecimal(h) {
          return parseIntFromHex(h) / 255;
        }
        var matchers = function() {
          var CSS_INTEGER = "[-\\+]?\\d+%?";
          var CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";
          var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";
          var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
          var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
          return {
            CSS_UNIT: new RegExp(CSS_UNIT),
            rgb: new RegExp("rgb" + PERMISSIVE_MATCH3),
            rgba: new RegExp("rgba" + PERMISSIVE_MATCH4),
            hsl: new RegExp("hsl" + PERMISSIVE_MATCH3),
            hsla: new RegExp("hsla" + PERMISSIVE_MATCH4),
            hsv: new RegExp("hsv" + PERMISSIVE_MATCH3),
            hsva: new RegExp("hsva" + PERMISSIVE_MATCH4),
            hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
            hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
            hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
            hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
          };
        }();
        function isValidCSSUnit(color2) {
          return !!matchers.CSS_UNIT.exec(color2);
        }
        function stringInputToObject(color2) {
          color2 = color2.replace(trimLeft, "").replace(trimRight, "").toLowerCase();
          var named2 = false;
          if (names[color2]) {
            color2 = names[color2];
            named2 = true;
          } else if (color2 == "transparent") {
            return { r: 0, g: 0, b: 0, a: 0, format: "name" };
          }
          var match;
          if (match = matchers.rgb.exec(color2)) {
            return { r: match[1], g: match[2], b: match[3] };
          }
          if (match = matchers.rgba.exec(color2)) {
            return { r: match[1], g: match[2], b: match[3], a: match[4] };
          }
          if (match = matchers.hsl.exec(color2)) {
            return { h: match[1], s: match[2], l: match[3] };
          }
          if (match = matchers.hsla.exec(color2)) {
            return { h: match[1], s: match[2], l: match[3], a: match[4] };
          }
          if (match = matchers.hsv.exec(color2)) {
            return { h: match[1], s: match[2], v: match[3] };
          }
          if (match = matchers.hsva.exec(color2)) {
            return { h: match[1], s: match[2], v: match[3], a: match[4] };
          }
          if (match = matchers.hex8.exec(color2)) {
            return {
              r: parseIntFromHex(match[1]),
              g: parseIntFromHex(match[2]),
              b: parseIntFromHex(match[3]),
              a: convertHexToDecimal(match[4]),
              format: named2 ? "name" : "hex8"
            };
          }
          if (match = matchers.hex6.exec(color2)) {
            return {
              r: parseIntFromHex(match[1]),
              g: parseIntFromHex(match[2]),
              b: parseIntFromHex(match[3]),
              format: named2 ? "name" : "hex"
            };
          }
          if (match = matchers.hex4.exec(color2)) {
            return {
              r: parseIntFromHex(match[1] + "" + match[1]),
              g: parseIntFromHex(match[2] + "" + match[2]),
              b: parseIntFromHex(match[3] + "" + match[3]),
              a: convertHexToDecimal(match[4] + "" + match[4]),
              format: named2 ? "name" : "hex8"
            };
          }
          if (match = matchers.hex3.exec(color2)) {
            return {
              r: parseIntFromHex(match[1] + "" + match[1]),
              g: parseIntFromHex(match[2] + "" + match[2]),
              b: parseIntFromHex(match[3] + "" + match[3]),
              format: named2 ? "name" : "hex"
            };
          }
          return false;
        }
        function validateWCAG2Parms(parms) {
          var level, size;
          parms = parms || { "level": "AA", "size": "small" };
          level = (parms.level || "AA").toUpperCase();
          size = (parms.size || "small").toLowerCase();
          if (level !== "AA" && level !== "AAA") {
            level = "AA";
          }
          if (size !== "small" && size !== "large") {
            size = "small";
          }
          return { "level": level, "size": size };
        }
        if (typeof module !== "undefined" && module.exports) {
          module.exports = tinycolor;
        } else if (typeof define === "function" && define.amd) {
          define(function() {
            return tinycolor;
          });
        } else {
          window.tinycolor = tinycolor;
        }
      })(Math);
    }
  });

  // src/lib/extend.js
  var require_extend = __commonJS({
    "src/lib/extend.js"(exports) {
      "use strict";
      var isPlainObject = require_is_plain_object();
      var isArray = Array.isArray;
      function primitivesLoopSplice(source, target) {
        var i, value;
        for (i = 0; i < source.length; i++) {
          value = source[i];
          if (value !== null && typeof value === "object") {
            return false;
          }
          if (value !== void 0) {
            target[i] = value;
          }
        }
        return true;
      }
      exports.extendFlat = function() {
        return _extend(arguments, false, false, false);
      };
      exports.extendDeep = function() {
        return _extend(arguments, true, false, false);
      };
      exports.extendDeepAll = function() {
        return _extend(arguments, true, true, false);
      };
      exports.extendDeepNoArrays = function() {
        return _extend(arguments, true, false, true);
      };
      function _extend(inputs, isDeep, keepAllKeys, noArrayCopies) {
        var target = inputs[0];
        var length = inputs.length;
        var input, key, src, copy, copyIsArray, clone, allPrimitives;
        if (length === 2 && isArray(target) && isArray(inputs[1]) && target.length === 0) {
          allPrimitives = primitivesLoopSplice(inputs[1], target);
          if (allPrimitives) {
            return target;
          } else {
            target.splice(0, target.length);
          }
        }
        for (var i = 1; i < length; i++) {
          input = inputs[i];
          for (key in input) {
            src = target[key];
            copy = input[key];
            if (noArrayCopies && isArray(copy)) {
              target[key] = copy;
            } else if (isDeep && copy && (isPlainObject(copy) || (copyIsArray = isArray(copy)))) {
              if (copyIsArray) {
                copyIsArray = false;
                clone = src && isArray(src) ? src : [];
              } else {
                clone = src && isPlainObject(src) ? src : {};
              }
              target[key] = _extend([clone, copy], isDeep, keepAllKeys, noArrayCopies);
            } else if (typeof copy !== "undefined" || keepAllKeys) {
              target[key] = copy;
            }
          }
        }
        return target;
      }
    }
  });

  // src/plots/font_attributes.js
  var require_font_attributes = __commonJS({
    "src/plots/font_attributes.js"(exports, module) {
      "use strict";
      module.exports = function(opts) {
        var variantValues = opts.variantValues;
        var editType = opts.editType;
        var colorEditType = opts.colorEditType;
        if (colorEditType === void 0) colorEditType = editType;
        var weight = {
          editType,
          valType: "integer",
          min: 1,
          max: 1e3,
          extras: ["normal", "bold"],
          dflt: "normal"
        };
        if (opts.noNumericWeightValues) {
          weight.valType = "enumerated";
          weight.values = weight.extras;
          weight.extras = void 0;
          weight.min = void 0;
          weight.max = void 0;
        }
        var attrs = {
          family: {
            valType: "string",
            noBlank: true,
            strict: true,
            editType
          },
          size: {
            valType: "number",
            min: 1,
            editType
          },
          color: {
            valType: "color",
            editType: colorEditType
          },
          weight,
          style: {
            editType,
            valType: "enumerated",
            values: ["normal", "italic"],
            dflt: "normal"
          },
          variant: opts.noFontVariant ? void 0 : {
            editType,
            valType: "enumerated",
            values: variantValues || [
              "normal",
              "small-caps",
              "all-small-caps",
              "all-petite-caps",
              "petite-caps",
              "unicase"
            ],
            dflt: "normal"
          },
          textcase: opts.noFontTextcase ? void 0 : {
            editType,
            valType: "enumerated",
            values: ["normal", "word caps", "upper", "lower"],
            dflt: "normal"
          },
          lineposition: opts.noFontLineposition ? void 0 : {
            editType,
            valType: "flaglist",
            flags: ["under", "over", "through"],
            extras: ["none"],
            dflt: "none"
          },
          shadow: opts.noFontShadow ? void 0 : {
            editType,
            valType: "string",
            dflt: opts.autoShadowDflt ? "auto" : "none"
          },
          editType
          // blank strings so compress_attributes can remove
          // TODO - that's uber hacky... better solution?
        };
        if (opts.autoSize) attrs.size.dflt = "auto";
        if (opts.autoColor) attrs.color.dflt = "auto";
        if (opts.arrayOk) {
          attrs.family.arrayOk = true;
          attrs.weight.arrayOk = true;
          attrs.style.arrayOk = true;
          if (!opts.noFontVariant) {
            attrs.variant.arrayOk = true;
          }
          if (!opts.noFontTextcase) {
            attrs.textcase.arrayOk = true;
          }
          if (!opts.noFontLineposition) {
            attrs.lineposition.arrayOk = true;
          }
          if (!opts.noFontShadow) {
            attrs.shadow.arrayOk = true;
          }
          attrs.size.arrayOk = true;
          attrs.color.arrayOk = true;
        }
        return attrs;
      };
    }
  });

  // src/components/fx/constants.js
  var require_constants = __commonJS({
    "src/components/fx/constants.js"(exports, module) {
      "use strict";
      module.exports = {
        // hover labels for multiple horizontal bars get tilted by this angle
        YANGLE: 60,
        // size and display constants for hover text
        // pixel size of hover arrows
        HOVERARROWSIZE: 6,
        // pixels padding around text
        HOVERTEXTPAD: 3,
        // hover font
        HOVERFONTSIZE: 13,
        HOVERFONT: "Arial, sans-serif",
        // minimum time (msec) between hover calls
        HOVERMINTIME: 50,
        // ID suffix (with fullLayout._uid) for hover events in the throttle cache
        HOVERID: "-hover"
      };
    }
  });

  // src/components/fx/layout_attributes.js
  var require_layout_attributes = __commonJS({
    "src/components/fx/layout_attributes.js"(exports, module) {
      "use strict";
      var constants = require_constants();
      var fontAttrs = require_font_attributes();
      var font = fontAttrs({
        editType: "none"
      });
      font.family.dflt = constants.HOVERFONT;
      font.size.dflt = constants.HOVERFONTSIZE;
      module.exports = {
        clickmode: {
          valType: "flaglist",
          flags: ["event", "select"],
          dflt: "event",
          editType: "plot",
          extras: ["none"]
        },
        dragmode: {
          valType: "enumerated",
          values: [
            "zoom",
            "pan",
            "select",
            "lasso",
            "drawclosedpath",
            "drawopenpath",
            "drawline",
            "drawrect",
            "drawcircle",
            "orbit",
            "turntable",
            false
          ],
          dflt: "zoom",
          editType: "modebar"
        },
        hovermode: {
          valType: "enumerated",
          values: ["x", "y", "closest", false, "x unified", "y unified"],
          dflt: "closest",
          editType: "modebar"
        },
        hoversubplots: {
          valType: "enumerated",
          values: ["single", "overlaying", "axis"],
          dflt: "overlaying",
          editType: "none"
        },
        hoverdistance: {
          valType: "integer",
          min: -1,
          dflt: 20,
          editType: "none"
        },
        spikedistance: {
          valType: "integer",
          min: -1,
          dflt: -1,
          editType: "none"
        },
        hoverlabel: {
          bgcolor: {
            valType: "color",
            editType: "none"
          },
          bordercolor: {
            valType: "color",
            editType: "none"
          },
          font,
          grouptitlefont: fontAttrs({
            editType: "none"
          }),
          align: {
            valType: "enumerated",
            values: ["left", "right", "auto"],
            dflt: "auto",
            editType: "none"
          },
          namelength: {
            valType: "integer",
            min: -1,
            dflt: 15,
            editType: "none"
          },
          editType: "none"
        },
        selectdirection: {
          valType: "enumerated",
          values: ["h", "v", "d", "any"],
          dflt: "any",
          editType: "none"
        }
      };
    }
  });

  // src/components/fx/attributes.js
  var require_attributes = __commonJS({
    "src/components/fx/attributes.js"(exports, module) {
      "use strict";
      var fontAttrs = require_font_attributes();
      var hoverLabelAttrs = require_layout_attributes().hoverlabel;
      var extendFlat = require_extend().extendFlat;
      module.exports = {
        hoverlabel: {
          bgcolor: extendFlat({}, hoverLabelAttrs.bgcolor, {
            arrayOk: true
          }),
          bordercolor: extendFlat({}, hoverLabelAttrs.bordercolor, {
            arrayOk: true
          }),
          font: fontAttrs({
            arrayOk: true,
            editType: "none"
          }),
          align: extendFlat({}, hoverLabelAttrs.align, { arrayOk: true }),
          namelength: extendFlat({}, hoverLabelAttrs.namelength, { arrayOk: true }),
          editType: "none"
        }
      };
    }
  });

  // src/plots/attributes.js
  var require_attributes2 = __commonJS({
    "src/plots/attributes.js"(exports, module) {
      "use strict";
      var fontAttrs = require_font_attributes();
      var fxAttrs = require_attributes();
      module.exports = {
        type: {
          valType: "enumerated",
          values: [],
          // listed dynamically
          dflt: "scatter",
          editType: "calc+clearAxisTypes",
          _noTemplating: true
          // we handle this at a higher level
        },
        visible: {
          valType: "enumerated",
          values: [true, false, "legendonly"],
          dflt: true,
          editType: "calc"
        },
        showlegend: {
          valType: "boolean",
          dflt: true,
          editType: "style"
        },
        legend: {
          valType: "subplotid",
          dflt: "legend",
          editType: "style"
        },
        legendgroup: {
          valType: "string",
          dflt: "",
          editType: "style"
        },
        legendgrouptitle: {
          text: {
            valType: "string",
            dflt: "",
            editType: "style"
          },
          font: fontAttrs({
            editType: "style"
          }),
          editType: "style"
        },
        legendrank: {
          valType: "number",
          dflt: 1e3,
          editType: "style"
        },
        legendwidth: {
          valType: "number",
          min: 0,
          editType: "style"
        },
        opacity: {
          valType: "number",
          min: 0,
          max: 1,
          dflt: 1,
          editType: "style"
        },
        name: {
          valType: "string",
          editType: "style"
        },
        uid: {
          valType: "string",
          editType: "plot",
          anim: true
        },
        ids: {
          valType: "data_array",
          editType: "calc",
          anim: true
        },
        customdata: {
          valType: "data_array",
          editType: "calc"
        },
        meta: {
          valType: "any",
          arrayOk: true,
          editType: "plot"
        },
        // N.B. these cannot be 'data_array' as they do not have the same length as
        // other data arrays and arrayOk attributes in general
        //
        // Maybe add another valType:
        // https://github.com/plotly/plotly.js/issues/1894
        selectedpoints: {
          valType: "any",
          editType: "calc"
        },
        hoverinfo: {
          valType: "flaglist",
          flags: ["x", "y", "z", "text", "name"],
          extras: ["all", "none", "skip"],
          arrayOk: true,
          dflt: "all",
          editType: "none"
        },
        hoverlabel: fxAttrs.hoverlabel,
        stream: {
          token: {
            valType: "string",
            noBlank: true,
            strict: true,
            editType: "calc"
          },
          maxpoints: {
            valType: "number",
            min: 0,
            max: 1e4,
            dflt: 500,
            editType: "calc"
          },
          editType: "calc"
        },
        uirevision: {
          valType: "any",
          editType: "none"
        }
      };
    }
  });

  // src/components/colorscale/scales.js
  var require_scales = __commonJS({
    "src/components/colorscale/scales.js"(exports, module) {
      "use strict";
      var tinycolor = require_tinycolor();
      var scales = {
        Greys: [
          [0, "rgb(0,0,0)"],
          [1, "rgb(255,255,255)"]
        ],
        YlGnBu: [
          [0, "rgb(8,29,88)"],
          [0.125, "rgb(37,52,148)"],
          [0.25, "rgb(34,94,168)"],
          [0.375, "rgb(29,145,192)"],
          [0.5, "rgb(65,182,196)"],
          [0.625, "rgb(127,205,187)"],
          [0.75, "rgb(199,233,180)"],
          [0.875, "rgb(237,248,217)"],
          [1, "rgb(255,255,217)"]
        ],
        Greens: [
          [0, "rgb(0,68,27)"],
          [0.125, "rgb(0,109,44)"],
          [0.25, "rgb(35,139,69)"],
          [0.375, "rgb(65,171,93)"],
          [0.5, "rgb(116,196,118)"],
          [0.625, "rgb(161,217,155)"],
          [0.75, "rgb(199,233,192)"],
          [0.875, "rgb(229,245,224)"],
          [1, "rgb(247,252,245)"]
        ],
        YlOrRd: [
          [0, "rgb(128,0,38)"],
          [0.125, "rgb(189,0,38)"],
          [0.25, "rgb(227,26,28)"],
          [0.375, "rgb(252,78,42)"],
          [0.5, "rgb(253,141,60)"],
          [0.625, "rgb(254,178,76)"],
          [0.75, "rgb(254,217,118)"],
          [0.875, "rgb(255,237,160)"],
          [1, "rgb(255,255,204)"]
        ],
        Bluered: [
          [0, "rgb(0,0,255)"],
          [1, "rgb(255,0,0)"]
        ],
        // modified RdBu based on
        // http://www.kennethmoreland.com/color-maps/
        RdBu: [
          [0, "rgb(5,10,172)"],
          [0.35, "rgb(106,137,247)"],
          [0.5, "rgb(190,190,190)"],
          [0.6, "rgb(220,170,132)"],
          [0.7, "rgb(230,145,90)"],
          [1, "rgb(178,10,28)"]
        ],
        // Scale for non-negative numeric values
        Reds: [
          [0, "rgb(220,220,220)"],
          [0.2, "rgb(245,195,157)"],
          [0.4, "rgb(245,160,105)"],
          [1, "rgb(178,10,28)"]
        ],
        // Scale for non-positive numeric values
        Blues: [
          [0, "rgb(5,10,172)"],
          [0.35, "rgb(40,60,190)"],
          [0.5, "rgb(70,100,245)"],
          [0.6, "rgb(90,120,245)"],
          [0.7, "rgb(106,137,247)"],
          [1, "rgb(220,220,220)"]
        ],
        Picnic: [
          [0, "rgb(0,0,255)"],
          [0.1, "rgb(51,153,255)"],
          [0.2, "rgb(102,204,255)"],
          [0.3, "rgb(153,204,255)"],
          [0.4, "rgb(204,204,255)"],
          [0.5, "rgb(255,255,255)"],
          [0.6, "rgb(255,204,255)"],
          [0.7, "rgb(255,153,255)"],
          [0.8, "rgb(255,102,204)"],
          [0.9, "rgb(255,102,102)"],
          [1, "rgb(255,0,0)"]
        ],
        Rainbow: [
          [0, "rgb(150,0,90)"],
          [0.125, "rgb(0,0,200)"],
          [0.25, "rgb(0,25,255)"],
          [0.375, "rgb(0,152,255)"],
          [0.5, "rgb(44,255,150)"],
          [0.625, "rgb(151,255,0)"],
          [0.75, "rgb(255,234,0)"],
          [0.875, "rgb(255,111,0)"],
          [1, "rgb(255,0,0)"]
        ],
        Portland: [
          [0, "rgb(12,51,131)"],
          [0.25, "rgb(10,136,186)"],
          [0.5, "rgb(242,211,56)"],
          [0.75, "rgb(242,143,56)"],
          [1, "rgb(217,30,30)"]
        ],
        Jet: [
          [0, "rgb(0,0,131)"],
          [0.125, "rgb(0,60,170)"],
          [0.375, "rgb(5,255,255)"],
          [0.625, "rgb(255,255,0)"],
          [0.875, "rgb(250,0,0)"],
          [1, "rgb(128,0,0)"]
        ],
        Hot: [
          [0, "rgb(0,0,0)"],
          [0.3, "rgb(230,0,0)"],
          [0.6, "rgb(255,210,0)"],
          [1, "rgb(255,255,255)"]
        ],
        Blackbody: [
          [0, "rgb(0,0,0)"],
          [0.2, "rgb(230,0,0)"],
          [0.4, "rgb(230,210,0)"],
          [0.7, "rgb(255,255,255)"],
          [1, "rgb(160,200,255)"]
        ],
        Earth: [
          [0, "rgb(0,0,130)"],
          [0.1, "rgb(0,180,180)"],
          [0.2, "rgb(40,210,40)"],
          [0.4, "rgb(230,230,50)"],
          [0.6, "rgb(120,70,20)"],
          [1, "rgb(255,255,255)"]
        ],
        Electric: [
          [0, "rgb(0,0,0)"],
          [0.15, "rgb(30,0,100)"],
          [0.4, "rgb(120,0,100)"],
          [0.6, "rgb(160,90,0)"],
          [0.8, "rgb(230,200,0)"],
          [1, "rgb(255,250,220)"]
        ],
        Viridis: [
          [0, "#440154"],
          [0.06274509803921569, "#48186a"],
          [0.12549019607843137, "#472d7b"],
          [0.18823529411764706, "#424086"],
          [0.25098039215686274, "#3b528b"],
          [0.3137254901960784, "#33638d"],
          [0.3764705882352941, "#2c728e"],
          [0.4392156862745098, "#26828e"],
          [0.5019607843137255, "#21918c"],
          [0.5647058823529412, "#1fa088"],
          [0.6274509803921569, "#28ae80"],
          [0.6901960784313725, "#3fbc73"],
          [0.7529411764705882, "#5ec962"],
          [0.8156862745098039, "#84d44b"],
          [0.8784313725490196, "#addc30"],
          [0.9411764705882353, "#d8e219"],
          [1, "#fde725"]
        ],
        Cividis: [
          [0, "rgb(0,32,76)"],
          [0.058824, "rgb(0,42,102)"],
          [0.117647, "rgb(0,52,110)"],
          [0.176471, "rgb(39,63,108)"],
          [0.235294, "rgb(60,74,107)"],
          [0.294118, "rgb(76,85,107)"],
          [0.352941, "rgb(91,95,109)"],
          [0.411765, "rgb(104,106,112)"],
          [0.470588, "rgb(117,117,117)"],
          [0.529412, "rgb(131,129,120)"],
          [0.588235, "rgb(146,140,120)"],
          [0.647059, "rgb(161,152,118)"],
          [0.705882, "rgb(176,165,114)"],
          [0.764706, "rgb(192,177,109)"],
          [0.823529, "rgb(209,191,102)"],
          [0.882353, "rgb(225,204,92)"],
          [0.941176, "rgb(243,219,79)"],
          [1, "rgb(255,233,69)"]
        ]
      };
      var defaultScale = scales.RdBu;
      function getScale(scl, dflt) {
        if (!dflt) dflt = defaultScale;
        if (!scl) return dflt;
        function parseScale() {
          try {
            scl = scales[scl] || JSON.parse(scl);
          } catch (e) {
            scl = dflt;
          }
        }
        if (typeof scl === "string") {
          parseScale();
          if (typeof scl === "string") parseScale();
        }
        if (!isValidScaleArray(scl)) return dflt;
        return scl;
      }
      function isValidScaleArray(scl) {
        var highestVal = 0;
        if (!Array.isArray(scl) || scl.length < 2) return false;
        if (!scl[0] || !scl[scl.length - 1]) return false;
        if (+scl[0][0] !== 0 || +scl[scl.length - 1][0] !== 1) return false;
        for (var i = 0; i < scl.length; i++) {
          var si = scl[i];
          if (si.length !== 2 || +si[0] < highestVal || !tinycolor(si[1]).isValid()) {
            return false;
          }
          highestVal = +si[0];
        }
        return true;
      }
      function isValidScale(scl) {
        if (scales[scl] !== void 0) return true;
        else return isValidScaleArray(scl);
      }
      module.exports = {
        scales,
        defaultScale,
        get: getScale,
        isValid: isValidScale
      };
    }
  });

  // src/components/color/attributes.js
  var require_attributes3 = __commonJS({
    "src/components/color/attributes.js"(exports) {
      "use strict";
      exports.defaults = [
        "#1f77b4",
        // muted blue
        "#ff7f0e",
        // safety orange
        "#2ca02c",
        // cooked asparagus green
        "#d62728",
        // brick red
        "#9467bd",
        // muted purple
        "#8c564b",
        // chestnut brown
        "#e377c2",
        // raspberry yogurt pink
        "#7f7f7f",
        // middle gray
        "#bcbd22",
        // curry yellow-green
        "#17becf"
        // blue-teal
      ];
      exports.defaultLine = "#444";
      exports.lightLine = "#eee";
      exports.background = "#fff";
      exports.borderLine = "#BEC8D9";
      exports.lightFraction = 100 * (14 - 4) / (15 - 4);
    }
  });

  // src/components/color/index.js
  var require_color = __commonJS({
    "src/components/color/index.js"(exports, module) {
      "use strict";
      var tinycolor = require_tinycolor();
      var isNumeric = require_fast_isnumeric();
      var isTypedArray = require_array().isTypedArray;
      var color2 = module.exports = {};
      var colorAttrs = require_attributes3();
      color2.defaults = colorAttrs.defaults;
      var defaultLine = color2.defaultLine = colorAttrs.defaultLine;
      color2.lightLine = colorAttrs.lightLine;
      var background = color2.background = colorAttrs.background;
      color2.tinyRGB = function(tc) {
        var c = tc.toRgb();
        return "rgb(" + Math.round(c.r) + ", " + Math.round(c.g) + ", " + Math.round(c.b) + ")";
      };
      color2.rgb = function(cstr) {
        return color2.tinyRGB(tinycolor(cstr));
      };
      color2.opacity = function(cstr) {
        return cstr ? tinycolor(cstr).getAlpha() : 0;
      };
      color2.addOpacity = function(cstr, op) {
        var c = tinycolor(cstr).toRgb();
        return "rgba(" + Math.round(c.r) + ", " + Math.round(c.g) + ", " + Math.round(c.b) + ", " + op + ")";
      };
      color2.combine = function(front, back) {
        var fc = tinycolor(front).toRgb();
        if (fc.a === 1) return tinycolor(front).toRgbString();
        var bc = tinycolor(back || background).toRgb();
        var bcflat = bc.a === 1 ? bc : {
          r: 255 * (1 - bc.a) + bc.r * bc.a,
          g: 255 * (1 - bc.a) + bc.g * bc.a,
          b: 255 * (1 - bc.a) + bc.b * bc.a
        };
        var fcflat = {
          r: bcflat.r * (1 - fc.a) + fc.r * fc.a,
          g: bcflat.g * (1 - fc.a) + fc.g * fc.a,
          b: bcflat.b * (1 - fc.a) + fc.b * fc.a
        };
        return tinycolor(fcflat).toRgbString();
      };
      color2.interpolate = function(first, second, factor) {
        var fc = tinycolor(first).toRgb();
        var sc = tinycolor(second).toRgb();
        var ic = {
          r: factor * fc.r + (1 - factor) * sc.r,
          g: factor * fc.g + (1 - factor) * sc.g,
          b: factor * fc.b + (1 - factor) * sc.b
        };
        return tinycolor(ic).toRgbString();
      };
      color2.contrast = function(cstr, lightAmount, darkAmount) {
        var tc = tinycolor(cstr);
        if (tc.getAlpha() !== 1) tc = tinycolor(color2.combine(cstr, background));
        var newColor = tc.isDark() ? lightAmount ? tc.lighten(lightAmount) : background : darkAmount ? tc.darken(darkAmount) : defaultLine;
        return newColor.toString();
      };
      color2.stroke = function(s, c) {
        var tc = tinycolor(c);
        s.style({ stroke: color2.tinyRGB(tc), "stroke-opacity": tc.getAlpha() });
      };
      color2.fill = function(s, c) {
        var tc = tinycolor(c);
        s.style({
          fill: color2.tinyRGB(tc),
          "fill-opacity": tc.getAlpha()
        });
      };
      color2.clean = function(container) {
        if (!container || typeof container !== "object") return;
        var keys = Object.keys(container);
        var i, j, key, val;
        for (i = 0; i < keys.length; i++) {
          key = keys[i];
          val = container[key];
          if (key.substr(key.length - 5) === "color") {
            if (Array.isArray(val)) {
              for (j = 0; j < val.length; j++) val[j] = cleanOne(val[j]);
            } else container[key] = cleanOne(val);
          } else if (key.substr(key.length - 10) === "colorscale" && Array.isArray(val)) {
            for (j = 0; j < val.length; j++) {
              if (Array.isArray(val[j])) val[j][1] = cleanOne(val[j][1]);
            }
          } else if (Array.isArray(val)) {
            var el0 = val[0];
            if (!Array.isArray(el0) && el0 && typeof el0 === "object") {
              for (j = 0; j < val.length; j++) color2.clean(val[j]);
            }
          } else if (val && typeof val === "object" && !isTypedArray(val)) color2.clean(val);
        }
      };
      function cleanOne(val) {
        if (isNumeric(val) || typeof val !== "string") return val;
        var valTrim = val.trim();
        if (valTrim.substr(0, 3) !== "rgb") return val;
        var match = valTrim.match(/^rgba?\s*\(([^()]*)\)$/);
        if (!match) return val;
        var parts = match[1].trim().split(/\s*[\s,]\s*/);
        var rgba2 = valTrim.charAt(3) === "a" && parts.length === 4;
        if (!rgba2 && parts.length !== 3) return val;
        for (var i = 0; i < parts.length; i++) {
          if (!parts[i].length) return val;
          parts[i] = Number(parts[i]);
          if (!(parts[i] >= 0)) {
            return val;
          }
          if (i === 3) {
            if (parts[i] > 1) parts[i] = 1;
          } else if (parts[i] >= 1) {
            return val;
          }
        }
        var rgbStr = Math.round(parts[0] * 255) + ", " + Math.round(parts[1] * 255) + ", " + Math.round(parts[2] * 255);
        if (rgba2) return "rgba(" + rgbStr + ", " + parts[3] + ")";
        return "rgb(" + rgbStr + ")";
      }
    }
  });

  // src/constants/interactions.js
  var require_interactions = __commonJS({
    "src/constants/interactions.js"(exports, module) {
      "use strict";
      module.exports = {
        /**
         * Timing information for interactive elements
         */
        SHOW_PLACEHOLDER: 100,
        HIDE_PLACEHOLDER: 1e3,
        // opacity dimming fraction for points that are not in selection
        DESELECTDIM: 0.2
      };
    }
  });

  // src/lib/regex.js
  var require_regex = __commonJS({
    "src/lib/regex.js"(exports) {
      "use strict";
      exports.counter = function(head, tail, openEnded, matchBeginning) {
        var fullTail = (tail || "") + (openEnded ? "" : "$");
        var startWithPrefix = matchBeginning === false ? "" : "^";
        if (head === "xy") {
          return new RegExp(startWithPrefix + "x([2-9]|[1-9][0-9]+)?y([2-9]|[1-9][0-9]+)?" + fullTail);
        }
        return new RegExp(startWithPrefix + head + "([2-9]|[1-9][0-9]+)?" + fullTail);
      };
    }
  });

  // src/lib/coerce.js
  var require_coerce = __commonJS({
    "src/lib/coerce.js"(exports) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var tinycolor = require_tinycolor();
      var extendFlat = require_extend().extendFlat;
      var baseTraceAttrs = require_attributes2();
      var colorscales = require_scales();
      var Color2 = require_color();
      var DESELECTDIM = require_interactions().DESELECTDIM;
      var nestedProperty = require_nested_property();
      var counterRegex = require_regex().counter;
      var modHalf = require_mod().modHalf;
      var isArrayOrTypedArray = require_array().isArrayOrTypedArray;
      var isTypedArraySpec = require_array().isTypedArraySpec;
      var decodeTypedArraySpec = require_array().decodeTypedArraySpec;
      exports.valObjectMeta = {
        data_array: {
          // You can use *dflt=[] to force said array to exist though.
          coerceFunction: function(v, propOut, dflt) {
            propOut.set(
              isArrayOrTypedArray(v) ? v : isTypedArraySpec(v) ? decodeTypedArraySpec(v) : dflt
            );
          }
        },
        enumerated: {
          coerceFunction: function(v, propOut, dflt, opts) {
            if (opts.coerceNumber) v = +v;
            if (opts.values.indexOf(v) === -1) propOut.set(dflt);
            else propOut.set(v);
          },
          validateFunction: function(v, opts) {
            if (opts.coerceNumber) v = +v;
            var values = opts.values;
            for (var i = 0; i < values.length; i++) {
              var k = String(values[i]);
              if (k.charAt(0) === "/" && k.charAt(k.length - 1) === "/") {
                var regex = new RegExp(k.substr(1, k.length - 2));
                if (regex.test(v)) return true;
              } else if (v === values[i]) return true;
            }
            return false;
          }
        },
        boolean: {
          coerceFunction: function(v, propOut, dflt) {
            if (v === true || v === false) propOut.set(v);
            else propOut.set(dflt);
          }
        },
        number: {
          coerceFunction: function(v, propOut, dflt, opts) {
            if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
            if (!isNumeric(v) || opts.min !== void 0 && v < opts.min || opts.max !== void 0 && v > opts.max) {
              propOut.set(dflt);
            } else propOut.set(+v);
          }
        },
        integer: {
          coerceFunction: function(v, propOut, dflt, opts) {
            if ((opts.extras || []).indexOf(v) !== -1) {
              propOut.set(v);
              return;
            }
            if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
            if (v % 1 || !isNumeric(v) || opts.min !== void 0 && v < opts.min || opts.max !== void 0 && v > opts.max) {
              propOut.set(dflt);
            } else propOut.set(+v);
          }
        },
        string: {
          // TODO 'values shouldn't be in there (edge case: 'dash' in Scatter)
          coerceFunction: function(v, propOut, dflt, opts) {
            if (typeof v !== "string") {
              var okToCoerce = typeof v === "number";
              if (opts.strict === true || !okToCoerce) propOut.set(dflt);
              else propOut.set(String(v));
            } else if (opts.noBlank && !v) propOut.set(dflt);
            else propOut.set(v);
          }
        },
        color: {
          coerceFunction: function(v, propOut, dflt) {
            if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
            if (tinycolor(v).isValid()) propOut.set(v);
            else propOut.set(dflt);
          }
        },
        colorlist: {
          coerceFunction: function(v, propOut, dflt) {
            function isColor(color2) {
              return tinycolor(color2).isValid();
            }
            if (!Array.isArray(v) || !v.length) propOut.set(dflt);
            else if (v.every(isColor)) propOut.set(v);
            else propOut.set(dflt);
          }
        },
        colorscale: {
          coerceFunction: function(v, propOut, dflt) {
            propOut.set(colorscales.get(v, dflt));
          }
        },
        angle: {
          coerceFunction: function(v, propOut, dflt) {
            if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
            if (v === "auto") propOut.set("auto");
            else if (!isNumeric(v)) propOut.set(dflt);
            else propOut.set(modHalf(+v, 360));
          }
        },
        subplotid: {
          coerceFunction: function(v, propOut, dflt, opts) {
            var regex = opts.regex || counterRegex(dflt);
            if (typeof v === "string" && regex.test(v)) {
              propOut.set(v);
              return;
            }
            propOut.set(dflt);
          },
          validateFunction: function(v, opts) {
            var dflt = opts.dflt;
            if (v === dflt) return true;
            if (typeof v !== "string") return false;
            if (counterRegex(dflt).test(v)) return true;
            return false;
          }
        },
        flaglist: {
          coerceFunction: function(v, propOut, dflt, opts) {
            if ((opts.extras || []).indexOf(v) !== -1) {
              propOut.set(v);
              return;
            }
            if (typeof v !== "string") {
              propOut.set(dflt);
              return;
            }
            var vParts = v.split("+");
            var i = 0;
            while (i < vParts.length) {
              var vi = vParts[i];
              if (opts.flags.indexOf(vi) === -1 || vParts.indexOf(vi) < i) {
                vParts.splice(i, 1);
              } else i++;
            }
            if (!vParts.length) propOut.set(dflt);
            else propOut.set(vParts.join("+"));
          }
        },
        any: {
          coerceFunction: function(v, propOut, dflt) {
            if (v === void 0) {
              propOut.set(dflt);
            } else {
              propOut.set(
                isTypedArraySpec(v) ? decodeTypedArraySpec(v) : v
              );
            }
          }
        },
        info_array: {
          // set `dimensions=2` for a 2D array or '1-2' for either
          // `items` may be a single object instead of an array, in which case
          // `freeLength` must be true.
          // if `dimensions='1-2'` and items is a 1D array, then the value can
          // either be a matching 1D array or an array of such matching 1D arrays
          coerceFunction: function(v, propOut, dflt, opts) {
            function coercePart(v2, opts2, dflt2) {
              var out;
              var propPart = { set: function(v3) {
                out = v3;
              } };
              if (dflt2 === void 0) dflt2 = opts2.dflt;
              exports.valObjectMeta[opts2.valType].coerceFunction(v2, propPart, dflt2, opts2);
              return out;
            }
            if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
            if (!isArrayOrTypedArray(v)) {
              propOut.set(dflt);
              return;
            }
            var twoD = opts.dimensions === 2 || opts.dimensions === "1-2" && Array.isArray(v) && isArrayOrTypedArray(v[0]);
            var items = opts.items;
            var vOut = [];
            var arrayItems = Array.isArray(items);
            var arrayItems2D = arrayItems && twoD && isArrayOrTypedArray(items[0]);
            var innerItemsOnly = twoD && arrayItems && !arrayItems2D;
            var len = arrayItems && !innerItemsOnly ? items.length : v.length;
            var i, j, row, item, len2, vNew;
            dflt = Array.isArray(dflt) ? dflt : [];
            if (twoD) {
              for (i = 0; i < len; i++) {
                vOut[i] = [];
                row = isArrayOrTypedArray(v[i]) ? v[i] : [];
                if (innerItemsOnly) len2 = items.length;
                else if (arrayItems) len2 = items[i].length;
                else len2 = row.length;
                for (j = 0; j < len2; j++) {
                  if (innerItemsOnly) item = items[j];
                  else if (arrayItems) item = items[i][j];
                  else item = items;
                  vNew = coercePart(row[j], item, (dflt[i] || [])[j]);
                  if (vNew !== void 0) vOut[i][j] = vNew;
                }
              }
            } else {
              for (i = 0; i < len; i++) {
                vNew = coercePart(v[i], arrayItems ? items[i] : items, dflt[i]);
                if (vNew !== void 0) vOut[i] = vNew;
              }
            }
            propOut.set(vOut);
          },
          validateFunction: function(v, opts) {
            if (!isArrayOrTypedArray(v)) return false;
            var items = opts.items;
            var arrayItems = Array.isArray(items);
            var twoD = opts.dimensions === 2;
            if (!opts.freeLength && v.length !== items.length) return false;
            for (var i = 0; i < v.length; i++) {
              if (twoD) {
                if (!isArrayOrTypedArray(v[i]) || !opts.freeLength && v[i].length !== items[i].length) {
                  return false;
                }
                for (var j = 0; j < v[i].length; j++) {
                  if (!validate(v[i][j], arrayItems ? items[i][j] : items)) {
                    return false;
                  }
                }
              } else if (!validate(v[i], arrayItems ? items[i] : items)) return false;
            }
            return true;
          }
        }
      };
      exports.coerce = function(containerIn, containerOut, attributes, attribute, dflt) {
        var opts = nestedProperty(attributes, attribute).get();
        var propIn = nestedProperty(containerIn, attribute);
        var propOut = nestedProperty(containerOut, attribute);
        var v = propIn.get();
        var template = containerOut._template;
        if (v === void 0 && template) {
          v = nestedProperty(template, attribute).get();
          template = 0;
        }
        if (dflt === void 0) dflt = opts.dflt;
        if (opts.arrayOk) {
          if (isArrayOrTypedArray(v)) {
            propOut.set(v);
            return v;
          } else {
            if (isTypedArraySpec(v)) {
              v = decodeTypedArraySpec(v);
              propOut.set(v);
              return v;
            }
          }
        }
        var coerceFunction = exports.valObjectMeta[opts.valType].coerceFunction;
        coerceFunction(v, propOut, dflt, opts);
        var out = propOut.get();
        if (template && out === dflt && !validate(v, opts)) {
          v = nestedProperty(template, attribute).get();
          coerceFunction(v, propOut, dflt, opts);
          out = propOut.get();
        }
        return out;
      };
      exports.coerce2 = function(containerIn, containerOut, attributes, attribute, dflt) {
        var propIn = nestedProperty(containerIn, attribute);
        var propOut = exports.coerce(containerIn, containerOut, attributes, attribute, dflt);
        var valIn = propIn.get();
        return valIn !== void 0 && valIn !== null ? propOut : false;
      };
      exports.coerceFont = function(coerce, attr, dfltObj, opts) {
        if (!opts) opts = {};
        dfltObj = extendFlat({}, dfltObj);
        dfltObj = extendFlat(dfltObj, opts.overrideDflt || {});
        var out = {
          family: coerce(attr + ".family", dfltObj.family),
          size: coerce(attr + ".size", dfltObj.size),
          color: coerce(attr + ".color", dfltObj.color),
          weight: coerce(attr + ".weight", dfltObj.weight),
          style: coerce(attr + ".style", dfltObj.style)
        };
        if (!opts.noFontVariant) out.variant = coerce(attr + ".variant", dfltObj.variant);
        if (!opts.noFontLineposition) out.lineposition = coerce(attr + ".lineposition", dfltObj.lineposition);
        if (!opts.noFontTextcase) out.textcase = coerce(attr + ".textcase", dfltObj.textcase);
        if (!opts.noFontShadow) {
          var dfltShadow = dfltObj.shadow;
          if (dfltShadow === "none" && opts.autoShadowDflt) {
            dfltShadow = "auto";
          }
          out.shadow = coerce(attr + ".shadow", dfltShadow);
        }
        return out;
      };
      exports.coercePattern = function(coerce, attr, markerColor, hasMarkerColorscale) {
        var shape = coerce(attr + ".shape");
        if (shape) {
          coerce(attr + ".solidity");
          coerce(attr + ".size");
          var fillmode = coerce(attr + ".fillmode");
          var isOverlay = fillmode === "overlay";
          if (!hasMarkerColorscale) {
            var bgcolor = coerce(
              attr + ".bgcolor",
              isOverlay ? markerColor : void 0
            );
            coerce(
              attr + ".fgcolor",
              isOverlay ? Color2.contrast(bgcolor) : markerColor
            );
          }
          coerce(
            attr + ".fgopacity",
            isOverlay ? 0.5 : 1
          );
        }
      };
      exports.coerceHoverinfo = function(traceIn, traceOut, layoutOut) {
        var moduleAttrs = traceOut._module.attributes;
        var attrs = moduleAttrs.hoverinfo ? moduleAttrs : baseTraceAttrs;
        var valObj = attrs.hoverinfo;
        var dflt;
        if (layoutOut._dataLength === 1) {
          var flags = valObj.dflt === "all" ? valObj.flags.slice() : valObj.dflt.split("+");
          flags.splice(flags.indexOf("name"), 1);
          dflt = flags.join("+");
        }
        return exports.coerce(traceIn, traceOut, attrs, "hoverinfo", dflt);
      };
      exports.coerceSelectionMarkerOpacity = function(traceOut, coerce) {
        if (!traceOut.marker) return;
        var mo = traceOut.marker.opacity;
        if (mo === void 0) return;
        var smoDflt;
        var usmoDflt;
        if (!isArrayOrTypedArray(mo) && !traceOut.selected && !traceOut.unselected) {
          smoDflt = mo;
          usmoDflt = DESELECTDIM * mo;
        }
        coerce("selected.marker.opacity", smoDflt);
        coerce("unselected.marker.opacity", usmoDflt);
      };
      function validate(value, opts) {
        var valObjectDef = exports.valObjectMeta[opts.valType];
        if (opts.arrayOk && isArrayOrTypedArray(value)) return true;
        if (valObjectDef.validateFunction) {
          return valObjectDef.validateFunction(value, opts);
        }
        var failed = {};
        var out = failed;
        var propMock = { set: function(v) {
          out = v;
        } };
        valObjectDef.coerceFunction(value, propMock, failed, opts);
        return out !== failed;
      }
      exports.validate = validate;
    }
  });

  // src/plot_api/plot_config.js
  var require_plot_config = __commonJS({
    "src/plot_api/plot_config.js"(exports, module) {
      "use strict";
      var configAttributes = {
        staticPlot: {
          valType: "boolean",
          dflt: false
        },
        typesetMath: {
          valType: "boolean",
          dflt: true
        },
        plotlyServerURL: {
          valType: "string",
          dflt: ""
        },
        editable: {
          valType: "boolean",
          dflt: false
        },
        edits: {
          annotationPosition: {
            valType: "boolean",
            dflt: false
          },
          annotationTail: {
            valType: "boolean",
            dflt: false
          },
          annotationText: {
            valType: "boolean",
            dflt: false
          },
          axisTitleText: {
            valType: "boolean",
            dflt: false
          },
          colorbarPosition: {
            valType: "boolean",
            dflt: false
          },
          colorbarTitleText: {
            valType: "boolean",
            dflt: false
          },
          legendPosition: {
            valType: "boolean",
            dflt: false
          },
          legendText: {
            valType: "boolean",
            dflt: false
          },
          shapePosition: {
            valType: "boolean",
            dflt: false
          },
          titleText: {
            valType: "boolean",
            dflt: false
          }
        },
        editSelection: {
          valType: "boolean",
          dflt: true
        },
        autosizable: {
          valType: "boolean",
          dflt: false
        },
        responsive: {
          valType: "boolean",
          dflt: false
        },
        fillFrame: {
          valType: "boolean",
          dflt: false
        },
        frameMargins: {
          valType: "number",
          dflt: 0,
          min: 0,
          max: 0.5
        },
        scrollZoom: {
          valType: "flaglist",
          flags: ["cartesian", "gl3d", "geo", "mapbox", "map"],
          extras: [true, false],
          dflt: "gl3d+geo+map"
        },
        doubleClick: {
          valType: "enumerated",
          values: [false, "reset", "autosize", "reset+autosize"],
          dflt: "reset+autosize"
        },
        doubleClickDelay: {
          valType: "number",
          dflt: 300,
          min: 0
        },
        showAxisDragHandles: {
          valType: "boolean",
          dflt: true
        },
        showAxisRangeEntryBoxes: {
          valType: "boolean",
          dflt: true
        },
        showTips: {
          valType: "boolean",
          dflt: true
        },
        showLink: {
          valType: "boolean",
          dflt: false
        },
        linkText: {
          valType: "string",
          dflt: "Edit chart",
          noBlank: true
        },
        sendData: {
          valType: "boolean",
          dflt: true
        },
        showSources: {
          valType: "any",
          dflt: false
        },
        displayModeBar: {
          valType: "enumerated",
          values: ["hover", true, false],
          dflt: "hover"
        },
        showSendToCloud: {
          valType: "boolean",
          dflt: false
        },
        showEditInChartStudio: {
          valType: "boolean",
          dflt: false
        },
        modeBarButtonsToRemove: {
          valType: "any",
          dflt: []
        },
        modeBarButtonsToAdd: {
          valType: "any",
          dflt: []
        },
        modeBarButtons: {
          valType: "any",
          dflt: false
        },
        toImageButtonOptions: {
          valType: "any",
          dflt: {}
        },
        displaylogo: {
          valType: "boolean",
          dflt: true
        },
        watermark: {
          valType: "boolean",
          dflt: false
        },
        plotGlPixelRatio: {
          valType: "number",
          dflt: 2,
          min: 1,
          max: 4
        },
        setBackground: {
          valType: "any",
          dflt: "transparent"
        },
        topojsonURL: {
          valType: "string",
          noBlank: true,
          dflt: "https://cdn.plot.ly/"
        },
        mapboxAccessToken: {
          valType: "string",
          dflt: null
        },
        logging: {
          valType: "integer",
          min: 0,
          max: 2,
          dflt: 1
        },
        notifyOnLogging: {
          valType: "integer",
          min: 0,
          max: 2,
          dflt: 0
        },
        queueLength: {
          valType: "integer",
          min: 0,
          dflt: 0
        },
        locale: {
          valType: "string",
          dflt: "en-US"
        },
        locales: {
          valType: "any",
          dflt: {}
        }
      };
      var dfltConfig = {};
      function crawl(src, target) {
        for (var k in src) {
          var obj = src[k];
          if (obj.valType) {
            target[k] = obj.dflt;
          } else {
            if (!target[k]) {
              target[k] = {};
            }
            crawl(obj, target[k]);
          }
        }
      }
      crawl(configAttributes, dfltConfig);
      module.exports = {
        configAttributes,
        dfltConfig
      };
    }
  });

  // src/lib/notifier.js
  var require_notifier = __commonJS({
    "src/lib/notifier.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var isNumeric = require_fast_isnumeric();
      var NOTEDATA = [];
      module.exports = function(text, displayLength) {
        if (NOTEDATA.indexOf(text) !== -1) return;
        NOTEDATA.push(text);
        var ts = 1e3;
        if (isNumeric(displayLength)) ts = displayLength;
        else if (displayLength === "long") ts = 3e3;
        var notifierContainer = d3.select("body").selectAll(".plotly-notifier").data([0]);
        notifierContainer.enter().append("div").classed("plotly-notifier", true);
        var notes = notifierContainer.selectAll(".notifier-note").data(NOTEDATA);
        function killNote(transition) {
          transition.duration(700).style("opacity", 0).each("end", function(thisText) {
            var thisIndex = NOTEDATA.indexOf(thisText);
            if (thisIndex !== -1) NOTEDATA.splice(thisIndex, 1);
            d3.select(this).remove();
          });
        }
        notes.enter().append("div").classed("notifier-note", true).style("opacity", 0).each(function(thisText) {
          var note = d3.select(this);
          note.append("button").classed("notifier-close", true).html("&times;").on("click", function() {
            note.transition().call(killNote);
          });
          var p = note.append("p");
          var lines = thisText.split(/<br\s*\/?>/g);
          for (var i = 0; i < lines.length; i++) {
            if (i) p.append("br");
            p.append("span").text(lines[i]);
          }
          if (displayLength === "stick") {
            note.transition().duration(350).style("opacity", 1);
          } else {
            note.transition().duration(700).style("opacity", 1).transition().delay(ts).call(killNote);
          }
        });
      };
    }
  });

  // src/lib/loggers.js
  var require_loggers = __commonJS({
    "src/lib/loggers.js"(exports, module) {
      "use strict";
      var dfltConfig = require_plot_config().dfltConfig;
      var notifier = require_notifier();
      var loggers = module.exports = {};
      loggers.log = function() {
        var i;
        if (dfltConfig.logging > 1) {
          var messages = ["LOG:"];
          for (i = 0; i < arguments.length; i++) {
            messages.push(arguments[i]);
          }
          console.trace.apply(console, messages);
        }
        if (dfltConfig.notifyOnLogging > 1) {
          var lines = [];
          for (i = 0; i < arguments.length; i++) {
            lines.push(arguments[i]);
          }
          notifier(lines.join("<br>"), "long");
        }
      };
      loggers.warn = function() {
        var i;
        if (dfltConfig.logging > 0) {
          var messages = ["WARN:"];
          for (i = 0; i < arguments.length; i++) {
            messages.push(arguments[i]);
          }
          console.trace.apply(console, messages);
        }
        if (dfltConfig.notifyOnLogging > 0) {
          var lines = [];
          for (i = 0; i < arguments.length; i++) {
            lines.push(arguments[i]);
          }
          notifier(lines.join("<br>"), "stick");
        }
      };
      loggers.error = function() {
        var i;
        if (dfltConfig.logging > 0) {
          var messages = ["ERROR:"];
          for (i = 0; i < arguments.length; i++) {
            messages.push(arguments[i]);
          }
          console.error.apply(console, messages);
        }
        if (dfltConfig.notifyOnLogging > 0) {
          var lines = [];
          for (i = 0; i < arguments.length; i++) {
            lines.push(arguments[i]);
          }
          notifier(lines.join("<br>"), "stick");
        }
      };
    }
  });

  // src/lib/noop.js
  var require_noop = __commonJS({
    "src/lib/noop.js"(exports, module) {
      "use strict";
      module.exports = function noop() {
      };
    }
  });

  // src/lib/push_unique.js
  var require_push_unique = __commonJS({
    "src/lib/push_unique.js"(exports, module) {
      "use strict";
      module.exports = function pushUnique(array, item) {
        if (item instanceof RegExp) {
          var itemStr = item.toString();
          for (var i = 0; i < array.length; i++) {
            if (array[i] instanceof RegExp && array[i].toString() === itemStr) {
              return array;
            }
          }
          array.push(item);
        } else if ((item || item === 0) && array.indexOf(item) === -1) array.push(item);
        return array;
      };
    }
  });

  // node_modules/gl-mat4/create.js
  var require_create = __commonJS({
    "node_modules/gl-mat4/create.js"(exports, module) {
      module.exports = create;
      function create() {
        var out = new Float32Array(16);
        out[0] = 1;
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = 1;
        out[6] = 0;
        out[7] = 0;
        out[8] = 0;
        out[9] = 0;
        out[10] = 1;
        out[11] = 0;
        out[12] = 0;
        out[13] = 0;
        out[14] = 0;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/clone.js
  var require_clone = __commonJS({
    "node_modules/gl-mat4/clone.js"(exports, module) {
      module.exports = clone;
      function clone(a) {
        var out = new Float32Array(16);
        out[0] = a[0];
        out[1] = a[1];
        out[2] = a[2];
        out[3] = a[3];
        out[4] = a[4];
        out[5] = a[5];
        out[6] = a[6];
        out[7] = a[7];
        out[8] = a[8];
        out[9] = a[9];
        out[10] = a[10];
        out[11] = a[11];
        out[12] = a[12];
        out[13] = a[13];
        out[14] = a[14];
        out[15] = a[15];
        return out;
      }
    }
  });

  // node_modules/gl-mat4/copy.js
  var require_copy = __commonJS({
    "node_modules/gl-mat4/copy.js"(exports, module) {
      module.exports = copy;
      function copy(out, a) {
        out[0] = a[0];
        out[1] = a[1];
        out[2] = a[2];
        out[3] = a[3];
        out[4] = a[4];
        out[5] = a[5];
        out[6] = a[6];
        out[7] = a[7];
        out[8] = a[8];
        out[9] = a[9];
        out[10] = a[10];
        out[11] = a[11];
        out[12] = a[12];
        out[13] = a[13];
        out[14] = a[14];
        out[15] = a[15];
        return out;
      }
    }
  });

  // node_modules/gl-mat4/identity.js
  var require_identity = __commonJS({
    "node_modules/gl-mat4/identity.js"(exports, module) {
      module.exports = identity2;
      function identity2(out) {
        out[0] = 1;
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = 1;
        out[6] = 0;
        out[7] = 0;
        out[8] = 0;
        out[9] = 0;
        out[10] = 1;
        out[11] = 0;
        out[12] = 0;
        out[13] = 0;
        out[14] = 0;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/transpose.js
  var require_transpose = __commonJS({
    "node_modules/gl-mat4/transpose.js"(exports, module) {
      module.exports = transpose;
      function transpose(out, a) {
        if (out === a) {
          var a01 = a[1], a02 = a[2], a03 = a[3], a12 = a[6], a13 = a[7], a23 = a[11];
          out[1] = a[4];
          out[2] = a[8];
          out[3] = a[12];
          out[4] = a01;
          out[6] = a[9];
          out[7] = a[13];
          out[8] = a02;
          out[9] = a12;
          out[11] = a[14];
          out[12] = a03;
          out[13] = a13;
          out[14] = a23;
        } else {
          out[0] = a[0];
          out[1] = a[4];
          out[2] = a[8];
          out[3] = a[12];
          out[4] = a[1];
          out[5] = a[5];
          out[6] = a[9];
          out[7] = a[13];
          out[8] = a[2];
          out[9] = a[6];
          out[10] = a[10];
          out[11] = a[14];
          out[12] = a[3];
          out[13] = a[7];
          out[14] = a[11];
          out[15] = a[15];
        }
        return out;
      }
    }
  });

  // node_modules/gl-mat4/invert.js
  var require_invert = __commonJS({
    "node_modules/gl-mat4/invert.js"(exports, module) {
      module.exports = invert;
      function invert(out, a) {
        var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11], a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15], b00 = a00 * a11 - a01 * a10, b01 = a00 * a12 - a02 * a10, b02 = a00 * a13 - a03 * a10, b03 = a01 * a12 - a02 * a11, b04 = a01 * a13 - a03 * a11, b05 = a02 * a13 - a03 * a12, b06 = a20 * a31 - a21 * a30, b07 = a20 * a32 - a22 * a30, b08 = a20 * a33 - a23 * a30, b09 = a21 * a32 - a22 * a31, b10 = a21 * a33 - a23 * a31, b11 = a22 * a33 - a23 * a32, det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
        if (!det) {
          return null;
        }
        det = 1 / det;
        out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
        out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
        out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
        out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
        out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
        out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
        out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
        out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
        out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
        out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
        out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
        out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
        out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
        out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
        out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
        out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/adjoint.js
  var require_adjoint = __commonJS({
    "node_modules/gl-mat4/adjoint.js"(exports, module) {
      module.exports = adjoint;
      function adjoint(out, a) {
        var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11], a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
        out[0] = a11 * (a22 * a33 - a23 * a32) - a21 * (a12 * a33 - a13 * a32) + a31 * (a12 * a23 - a13 * a22);
        out[1] = -(a01 * (a22 * a33 - a23 * a32) - a21 * (a02 * a33 - a03 * a32) + a31 * (a02 * a23 - a03 * a22));
        out[2] = a01 * (a12 * a33 - a13 * a32) - a11 * (a02 * a33 - a03 * a32) + a31 * (a02 * a13 - a03 * a12);
        out[3] = -(a01 * (a12 * a23 - a13 * a22) - a11 * (a02 * a23 - a03 * a22) + a21 * (a02 * a13 - a03 * a12));
        out[4] = -(a10 * (a22 * a33 - a23 * a32) - a20 * (a12 * a33 - a13 * a32) + a30 * (a12 * a23 - a13 * a22));
        out[5] = a00 * (a22 * a33 - a23 * a32) - a20 * (a02 * a33 - a03 * a32) + a30 * (a02 * a23 - a03 * a22);
        out[6] = -(a00 * (a12 * a33 - a13 * a32) - a10 * (a02 * a33 - a03 * a32) + a30 * (a02 * a13 - a03 * a12));
        out[7] = a00 * (a12 * a23 - a13 * a22) - a10 * (a02 * a23 - a03 * a22) + a20 * (a02 * a13 - a03 * a12);
        out[8] = a10 * (a21 * a33 - a23 * a31) - a20 * (a11 * a33 - a13 * a31) + a30 * (a11 * a23 - a13 * a21);
        out[9] = -(a00 * (a21 * a33 - a23 * a31) - a20 * (a01 * a33 - a03 * a31) + a30 * (a01 * a23 - a03 * a21));
        out[10] = a00 * (a11 * a33 - a13 * a31) - a10 * (a01 * a33 - a03 * a31) + a30 * (a01 * a13 - a03 * a11);
        out[11] = -(a00 * (a11 * a23 - a13 * a21) - a10 * (a01 * a23 - a03 * a21) + a20 * (a01 * a13 - a03 * a11));
        out[12] = -(a10 * (a21 * a32 - a22 * a31) - a20 * (a11 * a32 - a12 * a31) + a30 * (a11 * a22 - a12 * a21));
        out[13] = a00 * (a21 * a32 - a22 * a31) - a20 * (a01 * a32 - a02 * a31) + a30 * (a01 * a22 - a02 * a21);
        out[14] = -(a00 * (a11 * a32 - a12 * a31) - a10 * (a01 * a32 - a02 * a31) + a30 * (a01 * a12 - a02 * a11));
        out[15] = a00 * (a11 * a22 - a12 * a21) - a10 * (a01 * a22 - a02 * a21) + a20 * (a01 * a12 - a02 * a11);
        return out;
      }
    }
  });

  // node_modules/gl-mat4/determinant.js
  var require_determinant = __commonJS({
    "node_modules/gl-mat4/determinant.js"(exports, module) {
      module.exports = determinant;
      function determinant(a) {
        var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11], a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15], b00 = a00 * a11 - a01 * a10, b01 = a00 * a12 - a02 * a10, b02 = a00 * a13 - a03 * a10, b03 = a01 * a12 - a02 * a11, b04 = a01 * a13 - a03 * a11, b05 = a02 * a13 - a03 * a12, b06 = a20 * a31 - a21 * a30, b07 = a20 * a32 - a22 * a30, b08 = a20 * a33 - a23 * a30, b09 = a21 * a32 - a22 * a31, b10 = a21 * a33 - a23 * a31, b11 = a22 * a33 - a23 * a32;
        return b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
      }
    }
  });

  // node_modules/gl-mat4/multiply.js
  var require_multiply = __commonJS({
    "node_modules/gl-mat4/multiply.js"(exports, module) {
      module.exports = multiply;
      function multiply(out, a, b) {
        var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11], a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
        var b0 = b[0], b1 = b[1], b2 = b[2], b3 = b[3];
        out[0] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
        out[1] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
        out[2] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
        out[3] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
        b0 = b[4];
        b1 = b[5];
        b2 = b[6];
        b3 = b[7];
        out[4] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
        out[5] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
        out[6] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
        out[7] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
        b0 = b[8];
        b1 = b[9];
        b2 = b[10];
        b3 = b[11];
        out[8] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
        out[9] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
        out[10] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
        out[11] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
        b0 = b[12];
        b1 = b[13];
        b2 = b[14];
        b3 = b[15];
        out[12] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
        out[13] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
        out[14] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
        out[15] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/translate.js
  var require_translate = __commonJS({
    "node_modules/gl-mat4/translate.js"(exports, module) {
      module.exports = translate;
      function translate(out, a, v) {
        var x = v[0], y = v[1], z = v[2], a00, a01, a02, a03, a10, a11, a12, a13, a20, a21, a22, a23;
        if (a === out) {
          out[12] = a[0] * x + a[4] * y + a[8] * z + a[12];
          out[13] = a[1] * x + a[5] * y + a[9] * z + a[13];
          out[14] = a[2] * x + a[6] * y + a[10] * z + a[14];
          out[15] = a[3] * x + a[7] * y + a[11] * z + a[15];
        } else {
          a00 = a[0];
          a01 = a[1];
          a02 = a[2];
          a03 = a[3];
          a10 = a[4];
          a11 = a[5];
          a12 = a[6];
          a13 = a[7];
          a20 = a[8];
          a21 = a[9];
          a22 = a[10];
          a23 = a[11];
          out[0] = a00;
          out[1] = a01;
          out[2] = a02;
          out[3] = a03;
          out[4] = a10;
          out[5] = a11;
          out[6] = a12;
          out[7] = a13;
          out[8] = a20;
          out[9] = a21;
          out[10] = a22;
          out[11] = a23;
          out[12] = a00 * x + a10 * y + a20 * z + a[12];
          out[13] = a01 * x + a11 * y + a21 * z + a[13];
          out[14] = a02 * x + a12 * y + a22 * z + a[14];
          out[15] = a03 * x + a13 * y + a23 * z + a[15];
        }
        return out;
      }
    }
  });

  // node_modules/gl-mat4/scale.js
  var require_scale = __commonJS({
    "node_modules/gl-mat4/scale.js"(exports, module) {
      module.exports = scale;
      function scale(out, a, v) {
        var x = v[0], y = v[1], z = v[2];
        out[0] = a[0] * x;
        out[1] = a[1] * x;
        out[2] = a[2] * x;
        out[3] = a[3] * x;
        out[4] = a[4] * y;
        out[5] = a[5] * y;
        out[6] = a[6] * y;
        out[7] = a[7] * y;
        out[8] = a[8] * z;
        out[9] = a[9] * z;
        out[10] = a[10] * z;
        out[11] = a[11] * z;
        out[12] = a[12];
        out[13] = a[13];
        out[14] = a[14];
        out[15] = a[15];
        return out;
      }
    }
  });

  // node_modules/gl-mat4/rotate.js
  var require_rotate = __commonJS({
    "node_modules/gl-mat4/rotate.js"(exports, module) {
      module.exports = rotate;
      function rotate(out, a, rad, axis) {
        var x = axis[0], y = axis[1], z = axis[2], len = Math.sqrt(x * x + y * y + z * z), s, c, t, a00, a01, a02, a03, a10, a11, a12, a13, a20, a21, a22, a23, b00, b01, b02, b10, b11, b12, b20, b21, b22;
        if (Math.abs(len) < 1e-6) {
          return null;
        }
        len = 1 / len;
        x *= len;
        y *= len;
        z *= len;
        s = Math.sin(rad);
        c = Math.cos(rad);
        t = 1 - c;
        a00 = a[0];
        a01 = a[1];
        a02 = a[2];
        a03 = a[3];
        a10 = a[4];
        a11 = a[5];
        a12 = a[6];
        a13 = a[7];
        a20 = a[8];
        a21 = a[9];
        a22 = a[10];
        a23 = a[11];
        b00 = x * x * t + c;
        b01 = y * x * t + z * s;
        b02 = z * x * t - y * s;
        b10 = x * y * t - z * s;
        b11 = y * y * t + c;
        b12 = z * y * t + x * s;
        b20 = x * z * t + y * s;
        b21 = y * z * t - x * s;
        b22 = z * z * t + c;
        out[0] = a00 * b00 + a10 * b01 + a20 * b02;
        out[1] = a01 * b00 + a11 * b01 + a21 * b02;
        out[2] = a02 * b00 + a12 * b01 + a22 * b02;
        out[3] = a03 * b00 + a13 * b01 + a23 * b02;
        out[4] = a00 * b10 + a10 * b11 + a20 * b12;
        out[5] = a01 * b10 + a11 * b11 + a21 * b12;
        out[6] = a02 * b10 + a12 * b11 + a22 * b12;
        out[7] = a03 * b10 + a13 * b11 + a23 * b12;
        out[8] = a00 * b20 + a10 * b21 + a20 * b22;
        out[9] = a01 * b20 + a11 * b21 + a21 * b22;
        out[10] = a02 * b20 + a12 * b21 + a22 * b22;
        out[11] = a03 * b20 + a13 * b21 + a23 * b22;
        if (a !== out) {
          out[12] = a[12];
          out[13] = a[13];
          out[14] = a[14];
          out[15] = a[15];
        }
        return out;
      }
    }
  });

  // node_modules/gl-mat4/rotateX.js
  var require_rotateX = __commonJS({
    "node_modules/gl-mat4/rotateX.js"(exports, module) {
      module.exports = rotateX;
      function rotateX(out, a, rad) {
        var s = Math.sin(rad), c = Math.cos(rad), a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
        if (a !== out) {
          out[0] = a[0];
          out[1] = a[1];
          out[2] = a[2];
          out[3] = a[3];
          out[12] = a[12];
          out[13] = a[13];
          out[14] = a[14];
          out[15] = a[15];
        }
        out[4] = a10 * c + a20 * s;
        out[5] = a11 * c + a21 * s;
        out[6] = a12 * c + a22 * s;
        out[7] = a13 * c + a23 * s;
        out[8] = a20 * c - a10 * s;
        out[9] = a21 * c - a11 * s;
        out[10] = a22 * c - a12 * s;
        out[11] = a23 * c - a13 * s;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/rotateY.js
  var require_rotateY = __commonJS({
    "node_modules/gl-mat4/rotateY.js"(exports, module) {
      module.exports = rotateY;
      function rotateY(out, a, rad) {
        var s = Math.sin(rad), c = Math.cos(rad), a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
        if (a !== out) {
          out[4] = a[4];
          out[5] = a[5];
          out[6] = a[6];
          out[7] = a[7];
          out[12] = a[12];
          out[13] = a[13];
          out[14] = a[14];
          out[15] = a[15];
        }
        out[0] = a00 * c - a20 * s;
        out[1] = a01 * c - a21 * s;
        out[2] = a02 * c - a22 * s;
        out[3] = a03 * c - a23 * s;
        out[8] = a00 * s + a20 * c;
        out[9] = a01 * s + a21 * c;
        out[10] = a02 * s + a22 * c;
        out[11] = a03 * s + a23 * c;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/rotateZ.js
  var require_rotateZ = __commonJS({
    "node_modules/gl-mat4/rotateZ.js"(exports, module) {
      module.exports = rotateZ;
      function rotateZ(out, a, rad) {
        var s = Math.sin(rad), c = Math.cos(rad), a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3], a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7];
        if (a !== out) {
          out[8] = a[8];
          out[9] = a[9];
          out[10] = a[10];
          out[11] = a[11];
          out[12] = a[12];
          out[13] = a[13];
          out[14] = a[14];
          out[15] = a[15];
        }
        out[0] = a00 * c + a10 * s;
        out[1] = a01 * c + a11 * s;
        out[2] = a02 * c + a12 * s;
        out[3] = a03 * c + a13 * s;
        out[4] = a10 * c - a00 * s;
        out[5] = a11 * c - a01 * s;
        out[6] = a12 * c - a02 * s;
        out[7] = a13 * c - a03 * s;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/fromRotation.js
  var require_fromRotation = __commonJS({
    "node_modules/gl-mat4/fromRotation.js"(exports, module) {
      module.exports = fromRotation;
      function fromRotation(out, rad, axis) {
        var s, c, t;
        var x = axis[0];
        var y = axis[1];
        var z = axis[2];
        var len = Math.sqrt(x * x + y * y + z * z);
        if (Math.abs(len) < 1e-6) {
          return null;
        }
        len = 1 / len;
        x *= len;
        y *= len;
        z *= len;
        s = Math.sin(rad);
        c = Math.cos(rad);
        t = 1 - c;
        out[0] = x * x * t + c;
        out[1] = y * x * t + z * s;
        out[2] = z * x * t - y * s;
        out[3] = 0;
        out[4] = x * y * t - z * s;
        out[5] = y * y * t + c;
        out[6] = z * y * t + x * s;
        out[7] = 0;
        out[8] = x * z * t + y * s;
        out[9] = y * z * t - x * s;
        out[10] = z * z * t + c;
        out[11] = 0;
        out[12] = 0;
        out[13] = 0;
        out[14] = 0;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/fromRotationTranslation.js
  var require_fromRotationTranslation = __commonJS({
    "node_modules/gl-mat4/fromRotationTranslation.js"(exports, module) {
      module.exports = fromRotationTranslation;
      function fromRotationTranslation(out, q, v) {
        var x = q[0], y = q[1], z = q[2], w = q[3], x2 = x + x, y2 = y + y, z2 = z + z, xx = x * x2, xy = x * y2, xz = x * z2, yy = y * y2, yz = y * z2, zz = z * z2, wx = w * x2, wy = w * y2, wz = w * z2;
        out[0] = 1 - (yy + zz);
        out[1] = xy + wz;
        out[2] = xz - wy;
        out[3] = 0;
        out[4] = xy - wz;
        out[5] = 1 - (xx + zz);
        out[6] = yz + wx;
        out[7] = 0;
        out[8] = xz + wy;
        out[9] = yz - wx;
        out[10] = 1 - (xx + yy);
        out[11] = 0;
        out[12] = v[0];
        out[13] = v[1];
        out[14] = v[2];
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/fromScaling.js
  var require_fromScaling = __commonJS({
    "node_modules/gl-mat4/fromScaling.js"(exports, module) {
      module.exports = fromScaling;
      function fromScaling(out, v) {
        out[0] = v[0];
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = v[1];
        out[6] = 0;
        out[7] = 0;
        out[8] = 0;
        out[9] = 0;
        out[10] = v[2];
        out[11] = 0;
        out[12] = 0;
        out[13] = 0;
        out[14] = 0;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/fromTranslation.js
  var require_fromTranslation = __commonJS({
    "node_modules/gl-mat4/fromTranslation.js"(exports, module) {
      module.exports = fromTranslation;
      function fromTranslation(out, v) {
        out[0] = 1;
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = 1;
        out[6] = 0;
        out[7] = 0;
        out[8] = 0;
        out[9] = 0;
        out[10] = 1;
        out[11] = 0;
        out[12] = v[0];
        out[13] = v[1];
        out[14] = v[2];
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/fromXRotation.js
  var require_fromXRotation = __commonJS({
    "node_modules/gl-mat4/fromXRotation.js"(exports, module) {
      module.exports = fromXRotation;
      function fromXRotation(out, rad) {
        var s = Math.sin(rad), c = Math.cos(rad);
        out[0] = 1;
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = c;
        out[6] = s;
        out[7] = 0;
        out[8] = 0;
        out[9] = -s;
        out[10] = c;
        out[11] = 0;
        out[12] = 0;
        out[13] = 0;
        out[14] = 0;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/fromYRotation.js
  var require_fromYRotation = __commonJS({
    "node_modules/gl-mat4/fromYRotation.js"(exports, module) {
      module.exports = fromYRotation;
      function fromYRotation(out, rad) {
        var s = Math.sin(rad), c = Math.cos(rad);
        out[0] = c;
        out[1] = 0;
        out[2] = -s;
        out[3] = 0;
        out[4] = 0;
        out[5] = 1;
        out[6] = 0;
        out[7] = 0;
        out[8] = s;
        out[9] = 0;
        out[10] = c;
        out[11] = 0;
        out[12] = 0;
        out[13] = 0;
        out[14] = 0;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/fromZRotation.js
  var require_fromZRotation = __commonJS({
    "node_modules/gl-mat4/fromZRotation.js"(exports, module) {
      module.exports = fromZRotation;
      function fromZRotation(out, rad) {
        var s = Math.sin(rad), c = Math.cos(rad);
        out[0] = c;
        out[1] = s;
        out[2] = 0;
        out[3] = 0;
        out[4] = -s;
        out[5] = c;
        out[6] = 0;
        out[7] = 0;
        out[8] = 0;
        out[9] = 0;
        out[10] = 1;
        out[11] = 0;
        out[12] = 0;
        out[13] = 0;
        out[14] = 0;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/fromQuat.js
  var require_fromQuat = __commonJS({
    "node_modules/gl-mat4/fromQuat.js"(exports, module) {
      module.exports = fromQuat;
      function fromQuat(out, q) {
        var x = q[0], y = q[1], z = q[2], w = q[3], x2 = x + x, y2 = y + y, z2 = z + z, xx = x * x2, yx = y * x2, yy = y * y2, zx = z * x2, zy = z * y2, zz = z * z2, wx = w * x2, wy = w * y2, wz = w * z2;
        out[0] = 1 - yy - zz;
        out[1] = yx + wz;
        out[2] = zx - wy;
        out[3] = 0;
        out[4] = yx - wz;
        out[5] = 1 - xx - zz;
        out[6] = zy + wx;
        out[7] = 0;
        out[8] = zx + wy;
        out[9] = zy - wx;
        out[10] = 1 - xx - yy;
        out[11] = 0;
        out[12] = 0;
        out[13] = 0;
        out[14] = 0;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/frustum.js
  var require_frustum = __commonJS({
    "node_modules/gl-mat4/frustum.js"(exports, module) {
      module.exports = frustum;
      function frustum(out, left, right, bottom, top, near, far) {
        var rl = 1 / (right - left), tb = 1 / (top - bottom), nf = 1 / (near - far);
        out[0] = near * 2 * rl;
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = near * 2 * tb;
        out[6] = 0;
        out[7] = 0;
        out[8] = (right + left) * rl;
        out[9] = (top + bottom) * tb;
        out[10] = (far + near) * nf;
        out[11] = -1;
        out[12] = 0;
        out[13] = 0;
        out[14] = far * near * 2 * nf;
        out[15] = 0;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/perspective.js
  var require_perspective = __commonJS({
    "node_modules/gl-mat4/perspective.js"(exports, module) {
      module.exports = perspective;
      function perspective(out, fovy, aspect, near, far) {
        var f = 1 / Math.tan(fovy / 2), nf = 1 / (near - far);
        out[0] = f / aspect;
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = f;
        out[6] = 0;
        out[7] = 0;
        out[8] = 0;
        out[9] = 0;
        out[10] = (far + near) * nf;
        out[11] = -1;
        out[12] = 0;
        out[13] = 0;
        out[14] = 2 * far * near * nf;
        out[15] = 0;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/perspectiveFromFieldOfView.js
  var require_perspectiveFromFieldOfView = __commonJS({
    "node_modules/gl-mat4/perspectiveFromFieldOfView.js"(exports, module) {
      module.exports = perspectiveFromFieldOfView;
      function perspectiveFromFieldOfView(out, fov, near, far) {
        var upTan = Math.tan(fov.upDegrees * Math.PI / 180), downTan = Math.tan(fov.downDegrees * Math.PI / 180), leftTan = Math.tan(fov.leftDegrees * Math.PI / 180), rightTan = Math.tan(fov.rightDegrees * Math.PI / 180), xScale = 2 / (leftTan + rightTan), yScale = 2 / (upTan + downTan);
        out[0] = xScale;
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = yScale;
        out[6] = 0;
        out[7] = 0;
        out[8] = -((leftTan - rightTan) * xScale * 0.5);
        out[9] = (upTan - downTan) * yScale * 0.5;
        out[10] = far / (near - far);
        out[11] = -1;
        out[12] = 0;
        out[13] = 0;
        out[14] = far * near / (near - far);
        out[15] = 0;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/ortho.js
  var require_ortho = __commonJS({
    "node_modules/gl-mat4/ortho.js"(exports, module) {
      module.exports = ortho;
      function ortho(out, left, right, bottom, top, near, far) {
        var lr = 1 / (left - right), bt = 1 / (bottom - top), nf = 1 / (near - far);
        out[0] = -2 * lr;
        out[1] = 0;
        out[2] = 0;
        out[3] = 0;
        out[4] = 0;
        out[5] = -2 * bt;
        out[6] = 0;
        out[7] = 0;
        out[8] = 0;
        out[9] = 0;
        out[10] = 2 * nf;
        out[11] = 0;
        out[12] = (left + right) * lr;
        out[13] = (top + bottom) * bt;
        out[14] = (far + near) * nf;
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/lookAt.js
  var require_lookAt = __commonJS({
    "node_modules/gl-mat4/lookAt.js"(exports, module) {
      var identity2 = require_identity();
      module.exports = lookAt;
      function lookAt(out, eye, center, up) {
        var x0, x1, x2, y0, y1, y2, z0, z1, z2, len, eyex = eye[0], eyey = eye[1], eyez = eye[2], upx = up[0], upy = up[1], upz = up[2], centerx = center[0], centery = center[1], centerz = center[2];
        if (Math.abs(eyex - centerx) < 1e-6 && Math.abs(eyey - centery) < 1e-6 && Math.abs(eyez - centerz) < 1e-6) {
          return identity2(out);
        }
        z0 = eyex - centerx;
        z1 = eyey - centery;
        z2 = eyez - centerz;
        len = 1 / Math.sqrt(z0 * z0 + z1 * z1 + z2 * z2);
        z0 *= len;
        z1 *= len;
        z2 *= len;
        x0 = upy * z2 - upz * z1;
        x1 = upz * z0 - upx * z2;
        x2 = upx * z1 - upy * z0;
        len = Math.sqrt(x0 * x0 + x1 * x1 + x2 * x2);
        if (!len) {
          x0 = 0;
          x1 = 0;
          x2 = 0;
        } else {
          len = 1 / len;
          x0 *= len;
          x1 *= len;
          x2 *= len;
        }
        y0 = z1 * x2 - z2 * x1;
        y1 = z2 * x0 - z0 * x2;
        y2 = z0 * x1 - z1 * x0;
        len = Math.sqrt(y0 * y0 + y1 * y1 + y2 * y2);
        if (!len) {
          y0 = 0;
          y1 = 0;
          y2 = 0;
        } else {
          len = 1 / len;
          y0 *= len;
          y1 *= len;
          y2 *= len;
        }
        out[0] = x0;
        out[1] = y0;
        out[2] = z0;
        out[3] = 0;
        out[4] = x1;
        out[5] = y1;
        out[6] = z1;
        out[7] = 0;
        out[8] = x2;
        out[9] = y2;
        out[10] = z2;
        out[11] = 0;
        out[12] = -(x0 * eyex + x1 * eyey + x2 * eyez);
        out[13] = -(y0 * eyex + y1 * eyey + y2 * eyez);
        out[14] = -(z0 * eyex + z1 * eyey + z2 * eyez);
        out[15] = 1;
        return out;
      }
    }
  });

  // node_modules/gl-mat4/str.js
  var require_str = __commonJS({
    "node_modules/gl-mat4/str.js"(exports, module) {
      module.exports = str;
      function str(a) {
        return "mat4(" + a[0] + ", " + a[1] + ", " + a[2] + ", " + a[3] + ", " + a[4] + ", " + a[5] + ", " + a[6] + ", " + a[7] + ", " + a[8] + ", " + a[9] + ", " + a[10] + ", " + a[11] + ", " + a[12] + ", " + a[13] + ", " + a[14] + ", " + a[15] + ")";
      }
    }
  });

  // node_modules/gl-mat4/index.js
  var require_gl_mat4 = __commonJS({
    "node_modules/gl-mat4/index.js"(exports, module) {
      module.exports = {
        create: require_create(),
        clone: require_clone(),
        copy: require_copy(),
        identity: require_identity(),
        transpose: require_transpose(),
        invert: require_invert(),
        adjoint: require_adjoint(),
        determinant: require_determinant(),
        multiply: require_multiply(),
        translate: require_translate(),
        scale: require_scale(),
        rotate: require_rotate(),
        rotateX: require_rotateX(),
        rotateY: require_rotateY(),
        rotateZ: require_rotateZ(),
        fromRotation: require_fromRotation(),
        fromRotationTranslation: require_fromRotationTranslation(),
        fromScaling: require_fromScaling(),
        fromTranslation: require_fromTranslation(),
        fromXRotation: require_fromXRotation(),
        fromYRotation: require_fromYRotation(),
        fromZRotation: require_fromZRotation(),
        fromQuat: require_fromQuat(),
        frustum: require_frustum(),
        perspective: require_perspective(),
        perspectiveFromFieldOfView: require_perspectiveFromFieldOfView(),
        ortho: require_ortho(),
        lookAt: require_lookAt(),
        str: require_str()
      };
    }
  });

  // src/lib/matrix.js
  var require_matrix = __commonJS({
    "src/lib/matrix.js"(exports) {
      "use strict";
      var mat4X4 = require_gl_mat4();
      exports.init2dArray = function(rowLength, colLength) {
        var array = new Array(rowLength);
        for (var i = 0; i < rowLength; i++) array[i] = new Array(colLength);
        return array;
      };
      exports.transposeRagged = function(z) {
        var maxlen = 0;
        var zlen = z.length;
        var i, j;
        for (i = 0; i < zlen; i++) maxlen = Math.max(maxlen, z[i].length);
        var t = new Array(maxlen);
        for (i = 0; i < maxlen; i++) {
          t[i] = new Array(zlen);
          for (j = 0; j < zlen; j++) t[i][j] = z[j][i];
        }
        return t;
      };
      exports.dot = function(x, y) {
        if (!(x.length && y.length) || x.length !== y.length) return null;
        var len = x.length;
        var out;
        var i;
        if (x[0].length) {
          out = new Array(len);
          for (i = 0; i < len; i++) out[i] = exports.dot(x[i], y);
        } else if (y[0].length) {
          var yTranspose = exports.transposeRagged(y);
          out = new Array(yTranspose.length);
          for (i = 0; i < yTranspose.length; i++) out[i] = exports.dot(x, yTranspose[i]);
        } else {
          out = 0;
          for (i = 0; i < len; i++) out += x[i] * y[i];
        }
        return out;
      };
      exports.translationMatrix = function(x, y) {
        return [[1, 0, x], [0, 1, y], [0, 0, 1]];
      };
      exports.rotationMatrix = function(alpha) {
        var a = alpha * Math.PI / 180;
        return [
          [Math.cos(a), -Math.sin(a), 0],
          [Math.sin(a), Math.cos(a), 0],
          [0, 0, 1]
        ];
      };
      exports.rotationXYMatrix = function(a, x, y) {
        return exports.dot(
          exports.dot(
            exports.translationMatrix(x, y),
            exports.rotationMatrix(a)
          ),
          exports.translationMatrix(-x, -y)
        );
      };
      exports.apply3DTransform = function(transform) {
        return function() {
          var args = arguments;
          var xyz = arguments.length === 1 ? args[0] : [args[0], args[1], args[2] || 0];
          return exports.dot(transform, [xyz[0], xyz[1], xyz[2], 1]).slice(0, 3);
        };
      };
      exports.apply2DTransform = function(transform) {
        return function() {
          var args = arguments;
          if (args.length === 3) {
            args = args[0];
          }
          var xy = arguments.length === 1 ? args[0] : [args[0], args[1]];
          return exports.dot(transform, [xy[0], xy[1], 1]).slice(0, 2);
        };
      };
      exports.apply2DTransform2 = function(transform) {
        var at = exports.apply2DTransform(transform);
        return function(xys) {
          return at(xys.slice(0, 2)).concat(at(xys.slice(2, 4)));
        };
      };
      exports.convertCssMatrix = function(m) {
        if (m) {
          var len = m.length;
          if (len === 16) return m;
          if (len === 6) {
            return [
              m[0],
              m[1],
              0,
              0,
              m[2],
              m[3],
              0,
              0,
              0,
              0,
              1,
              0,
              m[4],
              m[5],
              0,
              1
            ];
          }
        }
        return [
          1,
          0,
          0,
          0,
          0,
          1,
          0,
          0,
          0,
          0,
          1,
          0,
          0,
          0,
          0,
          1
        ];
      };
      exports.inverseTransformMatrix = function(m) {
        var out = [];
        mat4X4.invert(out, m);
        return [
          [out[0], out[1], out[2], out[3]],
          [out[4], out[5], out[6], out[7]],
          [out[8], out[9], out[10], out[11]],
          [out[12], out[13], out[14], out[15]]
        ];
      };
    }
  });

  // src/lib/dom.js
  var require_dom = __commonJS({
    "src/lib/dom.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var loggers = require_loggers();
      var matrix = require_matrix();
      var mat4X4 = require_gl_mat4();
      function getGraphDiv(gd) {
        var gdElement;
        if (typeof gd === "string") {
          gdElement = document.getElementById(gd);
          if (gdElement === null) {
            throw new Error("No DOM element with id '" + gd + "' exists on the page.");
          }
          return gdElement;
        } else if (gd === null || gd === void 0) {
          throw new Error("DOM element provided is null or undefined");
        }
        return gd;
      }
      function isPlotDiv(el) {
        var el3 = d3.select(el);
        return el3.node() instanceof HTMLElement && el3.size() && el3.classed("js-plotly-plot");
      }
      function removeElement(el) {
        var elParent = el && el.parentNode;
        if (elParent) elParent.removeChild(el);
      }
      function addStyleRule(selector, styleString) {
        addRelatedStyleRule("global", selector, styleString);
      }
      function addRelatedStyleRule(uid, selector, styleString) {
        var id = "plotly.js-style-" + uid;
        var style = document.getElementById(id);
        if (style && style.matches(".no-inline-styles")) {
          return;
        }
        if (!style) {
          style = document.createElement("style");
          style.setAttribute("id", id);
          style.appendChild(document.createTextNode(""));
          document.head.appendChild(style);
        }
        var styleSheet = style.sheet;
        if (!styleSheet) {
          loggers.warn("Cannot addRelatedStyleRule, probably due to strict CSP...");
        } else if (styleSheet.insertRule) {
          styleSheet.insertRule(selector + "{" + styleString + "}", 0);
        } else if (styleSheet.addRule) {
          styleSheet.addRule(selector, styleString, 0);
        } else loggers.warn("addStyleRule failed");
      }
      function deleteRelatedStyleRule(uid) {
        var id = "plotly.js-style-" + uid;
        var style = document.getElementById(id);
        if (style) removeElement(style);
      }
      function setStyleOnHover(selector, activeSelector, childSelector, activeStyle, inactiveStyle, element) {
        var activeStyleParts = activeStyle.split(":");
        var inactiveStyleParts = inactiveStyle.split(":");
        var eventAddedAttrName = "data-btn-style-event-added";
        if (!element) {
          element = document;
        }
        element.querySelectorAll(selector).forEach(function(el) {
          if (!el.getAttribute(eventAddedAttrName)) {
            el.addEventListener("mouseenter", function() {
              var childEl = this.querySelector(childSelector);
              if (childEl) {
                childEl.style[activeStyleParts[0]] = activeStyleParts[1];
              }
            });
            el.addEventListener("mouseleave", function() {
              var childEl = this.querySelector(childSelector);
              if (childEl) {
                if (activeSelector && this.matches(activeSelector)) {
                  childEl.style[activeStyleParts[0]] = activeStyleParts[1];
                } else {
                  childEl.style[inactiveStyleParts[0]] = inactiveStyleParts[1];
                }
              }
            });
            el.setAttribute(eventAddedAttrName, true);
          }
        });
      }
      function getFullTransformMatrix(element) {
        var allElements = getElementAndAncestors(element);
        var out = [
          1,
          0,
          0,
          0,
          0,
          1,
          0,
          0,
          0,
          0,
          1,
          0,
          0,
          0,
          0,
          1
        ];
        allElements.forEach(function(e) {
          var t = getElementTransformMatrix(e);
          if (t) {
            var m = matrix.convertCssMatrix(t);
            out = mat4X4.multiply(out, out, m);
          }
        });
        return out;
      }
      function getElementTransformMatrix(element) {
        var style = window.getComputedStyle(element, null);
        var transform = style.getPropertyValue("-webkit-transform") || style.getPropertyValue("-moz-transform") || style.getPropertyValue("-ms-transform") || style.getPropertyValue("-o-transform") || style.getPropertyValue("transform");
        if (transform === "none") return null;
        return transform.replace("matrix", "").replace("3d", "").slice(1, -1).split(",").map(function(n) {
          return +n;
        });
      }
      function getElementAndAncestors(element) {
        var allElements = [];
        while (isTransformableElement(element)) {
          allElements.push(element);
          element = element.parentNode;
          if (typeof ShadowRoot === "function" && element instanceof ShadowRoot) {
            element = element.host;
          }
        }
        return allElements;
      }
      function isTransformableElement(element) {
        return element && (element instanceof Element || element instanceof HTMLElement);
      }
      function equalDomRects(a, b) {
        return a && b && a.top === b.top && a.left === b.left && a.right === b.right && a.bottom === b.bottom;
      }
      module.exports = {
        getGraphDiv,
        isPlotDiv,
        removeElement,
        addStyleRule,
        addRelatedStyleRule,
        deleteRelatedStyleRule,
        setStyleOnHover,
        getFullTransformMatrix,
        getElementTransformMatrix,
        getElementAndAncestors,
        equalDomRects
      };
    }
  });

  // src/plots/animation_attributes.js
  var require_animation_attributes = __commonJS({
    "src/plots/animation_attributes.js"(exports, module) {
      "use strict";
      module.exports = {
        mode: {
          valType: "enumerated",
          dflt: "afterall",
          values: ["immediate", "next", "afterall"]
        },
        direction: {
          valType: "enumerated",
          values: ["forward", "reverse"],
          dflt: "forward"
        },
        fromcurrent: {
          valType: "boolean",
          dflt: false
        },
        frame: {
          duration: {
            valType: "number",
            min: 0,
            dflt: 500
          },
          redraw: {
            valType: "boolean",
            dflt: true
          }
        },
        transition: {
          duration: {
            valType: "number",
            min: 0,
            dflt: 500,
            editType: "none"
          },
          easing: {
            valType: "enumerated",
            dflt: "cubic-in-out",
            values: [
              "linear",
              "quad",
              "cubic",
              "sin",
              "exp",
              "circle",
              "elastic",
              "back",
              "bounce",
              "linear-in",
              "quad-in",
              "cubic-in",
              "sin-in",
              "exp-in",
              "circle-in",
              "elastic-in",
              "back-in",
              "bounce-in",
              "linear-out",
              "quad-out",
              "cubic-out",
              "sin-out",
              "exp-out",
              "circle-out",
              "elastic-out",
              "back-out",
              "bounce-out",
              "linear-in-out",
              "quad-in-out",
              "cubic-in-out",
              "sin-in-out",
              "exp-in-out",
              "circle-in-out",
              "elastic-in-out",
              "back-in-out",
              "bounce-in-out"
            ],
            editType: "none"
          },
          ordering: {
            valType: "enumerated",
            values: ["layout first", "traces first"],
            dflt: "layout first",
            editType: "none"
          }
        }
      };
    }
  });

  // src/plot_api/edit_types.js
  var require_edit_types = __commonJS({
    "src/plot_api/edit_types.js"(exports, module) {
      "use strict";
      var extendFlat = require_extend().extendFlat;
      var isPlainObject = require_is_plain_object();
      var traceOpts = {
        valType: "flaglist",
        extras: ["none"],
        flags: ["calc", "clearAxisTypes", "plot", "style", "markerSize", "colorbars"]
      };
      var layoutOpts = {
        valType: "flaglist",
        extras: ["none"],
        flags: [
          "calc",
          "plot",
          "legend",
          "ticks",
          "axrange",
          "layoutstyle",
          "modebar",
          "camera",
          "arraydraw",
          "colorbars"
        ]
      };
      var traceEditTypeFlags = traceOpts.flags.slice().concat(["fullReplot"]);
      var layoutEditTypeFlags = layoutOpts.flags.slice().concat("layoutReplot");
      module.exports = {
        traces: traceOpts,
        layout: layoutOpts,
        /*
         * default (all false) edit flags for restyle (traces)
         * creates a new object each call, so the caller can mutate freely
         */
        traceFlags: function() {
          return falseObj(traceEditTypeFlags);
        },
        /*
         * default (all false) edit flags for relayout
         * creates a new object each call, so the caller can mutate freely
         */
        layoutFlags: function() {
          return falseObj(layoutEditTypeFlags);
        },
        /*
         * update `flags` with the `editType` values found in `attr`
         */
        update: function(flags, attr) {
          var editType = attr.editType;
          if (editType && editType !== "none") {
            var editTypeParts = editType.split("+");
            for (var i = 0; i < editTypeParts.length; i++) {
              flags[editTypeParts[i]] = true;
            }
          }
        },
        overrideAll
      };
      function falseObj(keys) {
        var out = {};
        for (var i = 0; i < keys.length; i++) out[keys[i]] = false;
        return out;
      }
      function overrideAll(attrs, editTypeOverride, overrideContainers) {
        var out = extendFlat({}, attrs);
        for (var key in out) {
          var attr = out[key];
          if (isPlainObject(attr)) {
            out[key] = overrideOne(attr, editTypeOverride, overrideContainers, key);
          }
        }
        if (overrideContainers === "from-root") out.editType = editTypeOverride;
        return out;
      }
      function overrideOne(attr, editTypeOverride, overrideContainers, key) {
        if (attr.valType) {
          var out = extendFlat({}, attr);
          out.editType = editTypeOverride;
          if (Array.isArray(attr.items)) {
            out.items = new Array(attr.items.length);
            for (var i = 0; i < attr.items.length; i++) {
              out.items[i] = overrideOne(attr.items[i], editTypeOverride, "from-root");
            }
          }
          return out;
        } else {
          return overrideAll(
            attr,
            editTypeOverride,
            key.charAt(0) === "_" ? "nested" : "from-root"
          );
        }
      }
    }
  });

  // src/components/drawing/attributes.js
  var require_attributes4 = __commonJS({
    "src/components/drawing/attributes.js"(exports) {
      "use strict";
      exports.dash = {
        valType: "string",
        // string type usually doesn't take values... this one should really be
        // a special type or at least a special coercion function, from the GUI
        // you only get these values but elsewhere the user can supply a list of
        // dash lengths in px, and it will be honored
        values: ["solid", "dot", "dash", "longdash", "dashdot", "longdashdot"],
        dflt: "solid",
        editType: "style"
      };
      exports.pattern = {
        shape: {
          valType: "enumerated",
          values: ["", "/", "\\", "x", "-", "|", "+", "."],
          dflt: "",
          arrayOk: true,
          editType: "style"
        },
        fillmode: {
          valType: "enumerated",
          values: ["replace", "overlay"],
          dflt: "replace",
          editType: "style"
        },
        bgcolor: {
          valType: "color",
          arrayOk: true,
          editType: "style"
        },
        fgcolor: {
          valType: "color",
          arrayOk: true,
          editType: "style"
        },
        fgopacity: {
          valType: "number",
          editType: "style",
          min: 0,
          max: 1
        },
        size: {
          valType: "number",
          min: 0,
          dflt: 8,
          arrayOk: true,
          editType: "style"
        },
        solidity: {
          valType: "number",
          min: 0,
          max: 1,
          dflt: 0.3,
          arrayOk: true,
          editType: "style"
        },
        editType: "style"
      };
    }
  });

  // src/constants/docs.js
  var require_docs = __commonJS({
    "src/constants/docs.js"(exports, module) {
      "use strict";
      module.exports = {
        FORMAT_LINK: "https://github.com/d3/d3-format/tree/v1.4.5#d3-format",
        DATE_FORMAT_LINK: "https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format"
      };
    }
  });

  // src/plots/template_attributes.js
  var require_template_attributes = __commonJS({
    "src/plots/template_attributes.js"(exports) {
      "use strict";
      var docs = require_docs();
      var FORMAT_LINK = docs.FORMAT_LINK;
      var DATE_FORMAT_LINK = docs.DATE_FORMAT_LINK;
      function describeVariables(extra) {
        var descPart = extra.description ? " " + extra.description : "";
        var keys = extra.keys || [];
        if (keys.length > 0) {
          var quotedKeys = [];
          for (var i = 0; i < keys.length; i++) {
            quotedKeys[i] = "`" + keys[i] + "`";
          }
          descPart = descPart + "Finally, the template string has access to ";
          if (keys.length === 1) {
            descPart = descPart + "variable " + quotedKeys[0];
          } else {
            descPart = descPart + "variables " + quotedKeys.slice(0, -1).join(", ") + " and " + quotedKeys.slice(-1) + ".";
          }
        }
        return descPart;
      }
      exports.hovertemplateAttrs = function(opts, extra) {
        opts = opts || {};
        extra = extra || {};
        var descPart = describeVariables(extra);
        var hovertemplate = {
          valType: "string",
          dflt: "",
          editType: opts.editType || "none"
        };
        if (opts.arrayOk !== false) {
          hovertemplate.arrayOk = true;
        }
        return hovertemplate;
      };
      exports.texttemplateAttrs = function(opts, extra) {
        opts = opts || {};
        extra = extra || {};
        var descPart = describeVariables(extra);
        var texttemplate = {
          valType: "string",
          dflt: "",
          editType: opts.editType || "calc"
        };
        if (opts.arrayOk !== false) {
          texttemplate.arrayOk = true;
        }
        return texttemplate;
      };
      exports.shapeTexttemplateAttrs = function(opts, extra) {
        opts = opts || {};
        extra = extra || {};
        var newStr = opts.newshape ? "new " : "";
        var descPart = describeVariables(extra);
        var texttemplate = {
          valType: "string",
          dflt: "",
          editType: opts.editType || "arraydraw"
        };
        return texttemplate;
      };
    }
  });

  // src/components/shapes/label_texttemplate.js
  var require_label_texttemplate = __commonJS({
    "src/components/shapes/label_texttemplate.js"(exports, module) {
      "use strict";
      function d2l(v, axis) {
        return axis ? axis.d2l(v) : v;
      }
      function l2d(v, axis) {
        return axis ? axis.l2d(v) : v;
      }
      function x0Fn(shape) {
        return shape.x0;
      }
      function x1Fn(shape) {
        return shape.x1;
      }
      function y0Fn(shape) {
        return shape.y0;
      }
      function y1Fn(shape) {
        return shape.y1;
      }
      function x0shiftFn(shape) {
        return shape.x0shift || 0;
      }
      function x1shiftFn(shape) {
        return shape.x1shift || 0;
      }
      function y0shiftFn(shape) {
        return shape.y0shift || 0;
      }
      function y1shiftFn(shape) {
        return shape.y1shift || 0;
      }
      function dxFn(shape, xa) {
        return d2l(shape.x1, xa) + x1shiftFn(shape) - d2l(shape.x0, xa) - x0shiftFn(shape);
      }
      function dyFn(shape, xa, ya) {
        return d2l(shape.y1, ya) + y1shiftFn(shape) - d2l(shape.y0, ya) - y0shiftFn(shape);
      }
      function widthFn(shape, xa) {
        return Math.abs(dxFn(shape, xa));
      }
      function heightFn(shape, xa, ya) {
        return Math.abs(dyFn(shape, xa, ya));
      }
      function lengthFn(shape, xa, ya) {
        return shape.type !== "line" ? void 0 : Math.sqrt(
          Math.pow(dxFn(shape, xa), 2) + Math.pow(dyFn(shape, xa, ya), 2)
        );
      }
      function xcenterFn(shape, xa) {
        return l2d((d2l(shape.x1, xa) + x1shiftFn(shape) + d2l(shape.x0, xa) + x0shiftFn(shape)) / 2, xa);
      }
      function ycenterFn(shape, xa, ya) {
        return l2d((d2l(shape.y1, ya) + y1shiftFn(shape) + d2l(shape.y0, ya) + y0shiftFn(shape)) / 2, ya);
      }
      function slopeFn(shape, xa, ya) {
        return shape.type !== "line" ? void 0 : dyFn(shape, xa, ya) / dxFn(shape, xa);
      }
      module.exports = {
        x0: x0Fn,
        x1: x1Fn,
        y0: y0Fn,
        y1: y1Fn,
        slope: slopeFn,
        dx: dxFn,
        dy: dyFn,
        width: widthFn,
        height: heightFn,
        length: lengthFn,
        xcenter: xcenterFn,
        ycenter: ycenterFn
      };
    }
  });

  // src/components/shapes/draw_newshape/attributes.js
  var require_attributes5 = __commonJS({
    "src/components/shapes/draw_newshape/attributes.js"(exports, module) {
      "use strict";
      var overrideAll = require_edit_types().overrideAll;
      var basePlotAttributes = require_attributes2();
      var fontAttrs = require_font_attributes();
      var dash = require_attributes4().dash;
      var extendFlat = require_extend().extendFlat;
      var shapeTexttemplateAttrs = require_template_attributes().shapeTexttemplateAttrs;
      var shapeLabelTexttemplateVars = require_label_texttemplate();
      module.exports = overrideAll({
        newshape: {
          visible: extendFlat({}, basePlotAttributes.visible, {}),
          showlegend: {
            valType: "boolean",
            dflt: false
          },
          legend: extendFlat({}, basePlotAttributes.legend, {}),
          legendgroup: extendFlat({}, basePlotAttributes.legendgroup, {}),
          legendgrouptitle: {
            text: extendFlat({}, basePlotAttributes.legendgrouptitle.text, {}),
            font: fontAttrs({})
          },
          legendrank: extendFlat({}, basePlotAttributes.legendrank, {}),
          legendwidth: extendFlat({}, basePlotAttributes.legendwidth, {}),
          line: {
            color: {
              valType: "color"
            },
            width: {
              valType: "number",
              min: 0,
              dflt: 4
            },
            dash: extendFlat({}, dash, {
              dflt: "solid"
            })
          },
          fillcolor: {
            valType: "color",
            dflt: "rgba(0,0,0,0)"
          },
          fillrule: {
            valType: "enumerated",
            values: ["evenodd", "nonzero"],
            dflt: "evenodd"
          },
          opacity: {
            valType: "number",
            min: 0,
            max: 1,
            dflt: 1
          },
          layer: {
            valType: "enumerated",
            values: ["below", "above", "between"],
            dflt: "above"
          },
          drawdirection: {
            valType: "enumerated",
            values: ["ortho", "horizontal", "vertical", "diagonal"],
            dflt: "diagonal"
          },
          name: extendFlat({}, basePlotAttributes.name, {}),
          label: {
            text: {
              valType: "string",
              dflt: ""
            },
            texttemplate: shapeTexttemplateAttrs({ newshape: true }, { keys: Object.keys(shapeLabelTexttemplateVars) }),
            font: fontAttrs({}),
            textposition: {
              valType: "enumerated",
              values: [
                "top left",
                "top center",
                "top right",
                "middle left",
                "middle center",
                "middle right",
                "bottom left",
                "bottom center",
                "bottom right",
                "start",
                "middle",
                "end"
              ]
            },
            textangle: {
              valType: "angle",
              dflt: "auto"
            },
            xanchor: {
              valType: "enumerated",
              values: ["auto", "left", "center", "right"],
              dflt: "auto"
            },
            yanchor: {
              valType: "enumerated",
              values: ["top", "middle", "bottom"]
            },
            padding: {
              valType: "number",
              dflt: 3,
              min: 0
            }
          }
        },
        activeshape: {
          fillcolor: {
            valType: "color",
            dflt: "rgb(255,0,255)"
          },
          opacity: {
            valType: "number",
            min: 0,
            max: 1,
            dflt: 0.5
          }
        }
      }, "none", "from-root");
    }
  });

  // src/components/selections/draw_newselection/attributes.js
  var require_attributes6 = __commonJS({
    "src/components/selections/draw_newselection/attributes.js"(exports, module) {
      "use strict";
      var dash = require_attributes4().dash;
      var extendFlat = require_extend().extendFlat;
      module.exports = {
        newselection: {
          mode: {
            valType: "enumerated",
            values: ["immediate", "gradual"],
            dflt: "immediate",
            editType: "none"
          },
          line: {
            color: {
              valType: "color",
              editType: "none"
            },
            width: {
              valType: "number",
              min: 1,
              dflt: 1,
              editType: "none"
            },
            dash: extendFlat({}, dash, {
              dflt: "dot",
              editType: "none"
            }),
            editType: "none"
          },
          // no drawdirection here noting that layout.selectdirection is used instead.
          editType: "none"
        },
        activeselection: {
          fillcolor: {
            valType: "color",
            dflt: "rgba(0,0,0,0)",
            editType: "none"
          },
          opacity: {
            valType: "number",
            min: 0,
            max: 1,
            dflt: 0.5,
            editType: "none"
          },
          editType: "none"
        }
      };
    }
  });

  // src/plots/pad_attributes.js
  var require_pad_attributes = __commonJS({
    "src/plots/pad_attributes.js"(exports, module) {
      "use strict";
      module.exports = function(opts) {
        var editType = opts.editType;
        return {
          t: {
            valType: "number",
            dflt: 0,
            editType
          },
          r: {
            valType: "number",
            dflt: 0,
            editType
          },
          b: {
            valType: "number",
            dflt: 0,
            editType
          },
          l: {
            valType: "number",
            dflt: 0,
            editType
          },
          editType
        };
      };
    }
  });

  // src/plots/layout_attributes.js
  var require_layout_attributes2 = __commonJS({
    "src/plots/layout_attributes.js"(exports, module) {
      "use strict";
      var fontAttrs = require_font_attributes();
      var animationAttrs = require_animation_attributes();
      var colorAttrs = require_attributes3();
      var drawNewShapeAttrs = require_attributes5();
      var drawNewSelectionAttrs = require_attributes6();
      var padAttrs = require_pad_attributes();
      var extendFlat = require_extend().extendFlat;
      var globalFont = fontAttrs({
        editType: "calc"
      });
      globalFont.family.dflt = '"Open Sans", verdana, arial, sans-serif';
      globalFont.size.dflt = 12;
      globalFont.color.dflt = colorAttrs.defaultLine;
      module.exports = {
        font: globalFont,
        title: {
          text: {
            valType: "string",
            editType: "layoutstyle"
          },
          font: fontAttrs({
            editType: "layoutstyle"
          }),
          subtitle: {
            text: {
              valType: "string",
              editType: "layoutstyle"
            },
            font: fontAttrs({
              editType: "layoutstyle"
            }),
            editType: "layoutstyle"
          },
          xref: {
            valType: "enumerated",
            dflt: "container",
            values: ["container", "paper"],
            editType: "layoutstyle"
          },
          yref: {
            valType: "enumerated",
            dflt: "container",
            values: ["container", "paper"],
            editType: "layoutstyle"
          },
          x: {
            valType: "number",
            min: 0,
            max: 1,
            dflt: 0.5,
            editType: "layoutstyle"
          },
          y: {
            valType: "number",
            min: 0,
            max: 1,
            dflt: "auto",
            editType: "layoutstyle"
          },
          xanchor: {
            valType: "enumerated",
            dflt: "auto",
            values: ["auto", "left", "center", "right"],
            editType: "layoutstyle"
          },
          yanchor: {
            valType: "enumerated",
            dflt: "auto",
            values: ["auto", "top", "middle", "bottom"],
            editType: "layoutstyle"
          },
          pad: extendFlat(padAttrs({ editType: "layoutstyle" }), {}),
          automargin: {
            valType: "boolean",
            dflt: false,
            editType: "plot"
          },
          editType: "layoutstyle"
        },
        uniformtext: {
          mode: {
            valType: "enumerated",
            values: [false, "hide", "show"],
            dflt: false,
            editType: "plot"
          },
          minsize: {
            valType: "number",
            min: 0,
            dflt: 0,
            editType: "plot"
          },
          editType: "plot"
        },
        autosize: {
          valType: "boolean",
          dflt: false,
          // autosize, width, and height get special editType treatment in _relayout
          // so we can handle noop resizes more efficiently
          editType: "none"
        },
        width: {
          valType: "number",
          min: 10,
          dflt: 700,
          editType: "plot"
        },
        height: {
          valType: "number",
          min: 10,
          dflt: 450,
          editType: "plot"
        },
        minreducedwidth: {
          valType: "number",
          min: 2,
          dflt: 64,
          editType: "plot"
        },
        minreducedheight: {
          valType: "number",
          min: 2,
          dflt: 64,
          editType: "plot"
        },
        margin: {
          l: {
            valType: "number",
            min: 0,
            dflt: 80,
            editType: "plot"
          },
          r: {
            valType: "number",
            min: 0,
            dflt: 80,
            editType: "plot"
          },
          t: {
            valType: "number",
            min: 0,
            dflt: 100,
            editType: "plot"
          },
          b: {
            valType: "number",
            min: 0,
            dflt: 80,
            editType: "plot"
          },
          pad: {
            valType: "number",
            min: 0,
            dflt: 0,
            editType: "plot"
          },
          autoexpand: {
            valType: "boolean",
            dflt: true,
            editType: "plot"
          },
          editType: "plot"
        },
        computed: {
          valType: "any",
          editType: "none"
        },
        paper_bgcolor: {
          valType: "color",
          dflt: colorAttrs.background,
          editType: "plot"
        },
        plot_bgcolor: {
          // defined here, but set in cartesian.supplyLayoutDefaults
          // because it needs to know if there are (2D) axes or not
          valType: "color",
          dflt: colorAttrs.background,
          editType: "layoutstyle"
        },
        autotypenumbers: {
          valType: "enumerated",
          values: ["convert types", "strict"],
          dflt: "convert types",
          editType: "calc"
        },
        separators: {
          valType: "string",
          editType: "plot"
        },
        hidesources: {
          valType: "boolean",
          dflt: false,
          editType: "plot"
        },
        showlegend: {
          // handled in legend.supplyLayoutDefaults
          // but included here because it's not in the legend object
          valType: "boolean",
          editType: "legend"
        },
        colorway: {
          valType: "colorlist",
          dflt: colorAttrs.defaults,
          editType: "calc"
        },
        datarevision: {
          valType: "any",
          editType: "calc"
        },
        uirevision: {
          valType: "any",
          editType: "none"
        },
        editrevision: {
          valType: "any",
          editType: "none"
        },
        selectionrevision: {
          valType: "any",
          editType: "none"
        },
        template: {
          valType: "any",
          editType: "calc"
        },
        newshape: drawNewShapeAttrs.newshape,
        activeshape: drawNewShapeAttrs.activeshape,
        newselection: drawNewSelectionAttrs.newselection,
        activeselection: drawNewSelectionAttrs.activeselection,
        meta: {
          valType: "any",
          arrayOk: true,
          editType: "plot"
        },
        transition: extendFlat({}, animationAttrs.transition, {
          editType: "none"
        })
      };
    }
  });

  // temp_stylePlugin:node_modules/maplibre-gl/dist/maplibre-gl.css
  var init_maplibre_gl = __esm({
    "temp_stylePlugin:node_modules/maplibre-gl/dist/maplibre-gl.css"() {
    }
  });

  // stylePlugin:/Users/alex/plotly/plotly.js/node_modules/maplibre-gl/dist/maplibre-gl.css
  var maplibre_gl_exports = {};
  var init_maplibre_gl2 = __esm({
    "stylePlugin:/Users/alex/plotly/plotly.js/node_modules/maplibre-gl/dist/maplibre-gl.css"() {
      init_maplibre_gl();
    }
  });

  // src/registry.js
  var require_registry = __commonJS({
    "src/registry.js"(exports) {
      "use strict";
      var Loggers = require_loggers();
      var noop = require_noop();
      var pushUnique = require_push_unique();
      var isPlainObject = require_is_plain_object();
      var addStyleRule = require_dom().addStyleRule;
      var ExtendModule = require_extend();
      var basePlotAttributes = require_attributes2();
      var baseLayoutAttributes = require_layout_attributes2();
      var extendFlat = ExtendModule.extendFlat;
      var extendDeepAll = ExtendModule.extendDeepAll;
      exports.modules = {};
      exports.allCategories = {};
      exports.allTypes = [];
      exports.subplotsRegistry = {};
      exports.componentsRegistry = {};
      exports.layoutArrayContainers = [];
      exports.layoutArrayRegexes = [];
      exports.traceLayoutAttributes = {};
      exports.localeRegistry = {};
      exports.apiMethodRegistry = {};
      exports.collectableSubplotTypes = null;
      exports.register = function register(_modules) {
        exports.collectableSubplotTypes = null;
        if (!_modules) {
          throw new Error("No argument passed to Plotly.register.");
        } else if (_modules && !Array.isArray(_modules)) {
          _modules = [_modules];
        }
        for (var i = 0; i < _modules.length; i++) {
          var newModule = _modules[i];
          if (!newModule) {
            throw new Error("Invalid module was attempted to be registered!");
          }
          switch (newModule.moduleType) {
            case "trace":
              registerTraceModule(newModule);
              break;
            case "transform":
              registerTransformModule(newModule);
              break;
            case "component":
              registerComponentModule(newModule);
              break;
            case "locale":
              registerLocale(newModule);
              break;
            case "apiMethod":
              var name2 = newModule.name;
              exports.apiMethodRegistry[name2] = newModule.fn;
              break;
            default:
              throw new Error("Invalid module was attempted to be registered!");
          }
        }
      };
      exports.getModule = function(trace) {
        var _module = exports.modules[getTraceType(trace)];
        if (!_module) return false;
        return _module._module;
      };
      exports.traceIs = function(traceType, category) {
        traceType = getTraceType(traceType);
        if (traceType === "various") return false;
        var _module = exports.modules[traceType];
        if (!_module) {
          if (traceType) {
            Loggers.log("Unrecognized trace type " + traceType + ".");
          }
          _module = exports.modules[basePlotAttributes.type.dflt];
        }
        return !!_module.categories[category];
      };
      exports.getComponentMethod = function(name2, method) {
        var _module = exports.componentsRegistry[name2];
        if (!_module) return noop;
        return _module[method] || noop;
      };
      exports.call = function() {
        var name2 = arguments[0];
        var args = [].slice.call(arguments, 1);
        return exports.apiMethodRegistry[name2].apply(null, args);
      };
      function registerTraceModule(_module) {
        var thisType = _module.name;
        var categoriesIn = _module.categories;
        var meta = _module.meta;
        if (exports.modules[thisType]) {
          Loggers.log("Type " + thisType + " already registered");
          return;
        }
        if (!exports.subplotsRegistry[_module.basePlotModule.name]) {
          registerSubplot(_module.basePlotModule);
        }
        var categoryObj = {};
        for (var i = 0; i < categoriesIn.length; i++) {
          categoryObj[categoriesIn[i]] = true;
          exports.allCategories[categoriesIn[i]] = true;
        }
        exports.modules[thisType] = {
          _module,
          categories: categoryObj
        };
        if (meta && Object.keys(meta).length) {
          exports.modules[thisType].meta = meta;
        }
        exports.allTypes.push(thisType);
        for (var componentName in exports.componentsRegistry) {
          mergeComponentAttrsToTrace(componentName, thisType);
        }
        if (_module.layoutAttributes) {
          extendFlat(exports.traceLayoutAttributes, _module.layoutAttributes);
        }
        var basePlotModule = _module.basePlotModule;
        var bpmName = basePlotModule.name;
        if (bpmName === "mapbox") {
          var styleRules = basePlotModule.constants.styleRules;
          for (var k in styleRules) {
            addStyleRule(".js-plotly-plot .plotly .mapboxgl-" + k, styleRules[k]);
          }
        }
        if (bpmName === "map") {
          init_maplibre_gl2();
        }
        if ((bpmName === "geo" || bpmName === "mapbox" || bpmName === "map") && window.PlotlyGeoAssets === void 0) {
          window.PlotlyGeoAssets = { topojson: {} };
        }
      }
      function registerSubplot(_module) {
        var plotType = _module.name;
        if (exports.subplotsRegistry[plotType]) {
          Loggers.log("Plot type " + plotType + " already registered.");
          return;
        }
        findArrayRegexps(_module);
        exports.subplotsRegistry[plotType] = _module;
        for (var componentName in exports.componentsRegistry) {
          mergeComponentAttrsToSubplot(componentName, _module.name);
        }
      }
      function registerComponentModule(_module) {
        if (typeof _module.name !== "string") {
          throw new Error("Component module *name* must be a string.");
        }
        var name2 = _module.name;
        exports.componentsRegistry[name2] = _module;
        if (_module.layoutAttributes) {
          if (_module.layoutAttributes._isLinkedToArray) {
            pushUnique(exports.layoutArrayContainers, name2);
          }
          findArrayRegexps(_module);
        }
        for (var traceType in exports.modules) {
          mergeComponentAttrsToTrace(name2, traceType);
        }
        for (var subplotName in exports.subplotsRegistry) {
          mergeComponentAttrsToSubplot(name2, subplotName);
        }
        if (_module.schema && _module.schema.layout) {
          extendDeepAll(baseLayoutAttributes, _module.schema.layout);
        }
      }
      function registerTransformModule(_module) {
        if (typeof _module.name !== "string") {
          throw new Error("Transform module *name* must be a string.");
        }
        var prefix = "Transform module " + _module.name;
        var hasTransform = typeof _module.transform === "function";
        var hasCalcTransform = typeof _module.calcTransform === "function";
        if (!hasTransform && !hasCalcTransform) {
          throw new Error(prefix + " is missing a *transform* or *calcTransform* method.");
        }
        if (hasTransform && hasCalcTransform) {
          Loggers.log([
            prefix + " has both a *transform* and *calcTransform* methods.",
            "Please note that all *transform* methods are executed",
            "before all *calcTransform* methods."
          ].join(" "));
        }
        if (!isPlainObject(_module.attributes)) {
          Loggers.log(prefix + " registered without an *attributes* object.");
        }
        if (typeof _module.supplyDefaults !== "function") {
          Loggers.log(prefix + " registered without a *supplyDefaults* method.");
        }
      }
      function registerLocale(_module) {
        var locale = _module.name;
        var baseLocale = locale.split("-")[0];
        var newDict = _module.dictionary;
        var newFormat = _module.format;
        var hasDict = newDict && Object.keys(newDict).length;
        var hasFormat = newFormat && Object.keys(newFormat).length;
        var locales = exports.localeRegistry;
        var localeObj = locales[locale];
        if (!localeObj) locales[locale] = localeObj = {};
        if (baseLocale !== locale) {
          var baseLocaleObj = locales[baseLocale];
          if (!baseLocaleObj) locales[baseLocale] = baseLocaleObj = {};
          if (hasDict && baseLocaleObj.dictionary === localeObj.dictionary) {
            baseLocaleObj.dictionary = newDict;
          }
          if (hasFormat && baseLocaleObj.format === localeObj.format) {
            baseLocaleObj.format = newFormat;
          }
        }
        if (hasDict) localeObj.dictionary = newDict;
        if (hasFormat) localeObj.format = newFormat;
      }
      function findArrayRegexps(_module) {
        if (_module.layoutAttributes) {
          var arrayAttrRegexps = _module.layoutAttributes._arrayAttrRegexps;
          if (arrayAttrRegexps) {
            for (var i = 0; i < arrayAttrRegexps.length; i++) {
              pushUnique(exports.layoutArrayRegexes, arrayAttrRegexps[i]);
            }
          }
        }
      }
      function mergeComponentAttrsToTrace(componentName, traceType) {
        var componentSchema = exports.componentsRegistry[componentName].schema;
        if (!componentSchema || !componentSchema.traces) return;
        var traceAttrs = componentSchema.traces[traceType];
        if (traceAttrs) {
          extendDeepAll(exports.modules[traceType]._module.attributes, traceAttrs);
        }
      }
      function mergeComponentAttrsToSubplot(componentName, subplotName) {
        var componentSchema = exports.componentsRegistry[componentName].schema;
        if (!componentSchema || !componentSchema.subplots) return;
        var subplotModule = exports.subplotsRegistry[subplotName];
        var subplotAttrs = subplotModule.layoutAttributes;
        var subplotAttr = subplotModule.attr === "subplot" ? subplotModule.name : subplotModule.attr;
        if (Array.isArray(subplotAttr)) subplotAttr = subplotAttr[0];
        var componentLayoutAttrs = componentSchema.subplots[subplotAttr];
        if (subplotAttrs && componentLayoutAttrs) {
          extendDeepAll(subplotAttrs, componentLayoutAttrs);
        }
      }
      function getTraceType(traceType) {
        if (typeof traceType === "object") traceType = traceType.type;
        return traceType;
      }
    }
  });

  // src/lib/dates.js
  var require_dates = __commonJS({
    "src/lib/dates.js"(exports) {
      "use strict";
      var timeFormat = require_d3_time_format().timeFormat;
      var isNumeric = require_fast_isnumeric();
      var Loggers = require_loggers();
      var mod = require_mod().mod;
      var constants = require_numerical();
      var BADNUM = constants.BADNUM;
      var ONEDAY = constants.ONEDAY;
      var ONEHOUR = constants.ONEHOUR;
      var ONEMIN = constants.ONEMIN;
      var ONESEC = constants.ONESEC;
      var EPOCHJD = constants.EPOCHJD;
      var Registry = require_registry();
      var utcFormat = require_d3_time_format().utcFormat;
      var DATETIME_REGEXP = /^\s*(-?\d\d\d\d|\d\d)(-(\d?\d)(-(\d?\d)([ Tt]([01]?\d|2[0-3])(:([0-5]\d)(:([0-5]\d(\.\d+)?))?(Z|z|[+\-]\d\d(:?\d\d)?)?)?)?)?)?\s*$/m;
      var DATETIME_REGEXP_CN = /^\s*(-?\d\d\d\d|\d\d)(-(\d?\di?)(-(\d?\d)([ Tt]([01]?\d|2[0-3])(:([0-5]\d)(:([0-5]\d(\.\d+)?))?(Z|z|[+\-]\d\d(:?\d\d)?)?)?)?)?)?\s*$/m;
      var YFIRST = (/* @__PURE__ */ new Date()).getFullYear() - 70;
      function isWorldCalendar(calendar) {
        return calendar && Registry.componentsRegistry.calendars && typeof calendar === "string" && calendar !== "gregorian";
      }
      exports.dateTick0 = function(calendar, dayOfWeek) {
        var tick0 = _dateTick0(calendar, !!dayOfWeek);
        if (dayOfWeek < 2) return tick0;
        var v = exports.dateTime2ms(tick0, calendar);
        v += ONEDAY * (dayOfWeek - 1);
        return exports.ms2DateTime(v, 0, calendar);
      };
      function _dateTick0(calendar, sunday) {
        if (isWorldCalendar(calendar)) {
          return sunday ? Registry.getComponentMethod("calendars", "CANONICAL_SUNDAY")[calendar] : Registry.getComponentMethod("calendars", "CANONICAL_TICK")[calendar];
        } else {
          return sunday ? "2000-01-02" : "2000-01-01";
        }
      }
      exports.dfltRange = function(calendar) {
        if (isWorldCalendar(calendar)) {
          return Registry.getComponentMethod("calendars", "DFLTRANGE")[calendar];
        } else {
          return ["2000-01-01", "2001-01-01"];
        }
      };
      exports.isJSDate = function(v) {
        return typeof v === "object" && v !== null && typeof v.getTime === "function";
      };
      var MIN_MS;
      var MAX_MS;
      exports.dateTime2ms = function(s, calendar) {
        if (exports.isJSDate(s)) {
          var tzOffset = s.getTimezoneOffset() * ONEMIN;
          var offsetTweak = (s.getUTCMinutes() - s.getMinutes()) * ONEMIN + (s.getUTCSeconds() - s.getSeconds()) * ONESEC + (s.getUTCMilliseconds() - s.getMilliseconds());
          if (offsetTweak) {
            var comb = 3 * ONEMIN;
            tzOffset = tzOffset - comb / 2 + mod(offsetTweak - tzOffset + comb / 2, comb);
          }
          s = Number(s) - tzOffset;
          if (s >= MIN_MS && s <= MAX_MS) return s;
          return BADNUM;
        }
        if (typeof s !== "string" && typeof s !== "number") return BADNUM;
        s = String(s);
        var isWorld = isWorldCalendar(calendar);
        var s0 = s.charAt(0);
        if (isWorld && (s0 === "G" || s0 === "g")) {
          s = s.substr(1);
          calendar = "";
        }
        var isChinese = isWorld && calendar.substr(0, 7) === "chinese";
        var match = s.match(isChinese ? DATETIME_REGEXP_CN : DATETIME_REGEXP);
        if (!match) return BADNUM;
        var y = match[1];
        var m = match[3] || "1";
        var d = Number(match[5] || 1);
        var H = Number(match[7] || 0);
        var M = Number(match[9] || 0);
        var S = Number(match[11] || 0);
        if (isWorld) {
          if (y.length === 2) return BADNUM;
          y = Number(y);
          var cDate;
          try {
            var calInstance = Registry.getComponentMethod("calendars", "getCal")(calendar);
            if (isChinese) {
              var isIntercalary = m.charAt(m.length - 1) === "i";
              m = parseInt(m, 10);
              cDate = calInstance.newDate(y, calInstance.toMonthIndex(y, m, isIntercalary), d);
            } else {
              cDate = calInstance.newDate(y, Number(m), d);
            }
          } catch (e) {
            return BADNUM;
          }
          if (!cDate) return BADNUM;
          return (cDate.toJD() - EPOCHJD) * ONEDAY + H * ONEHOUR + M * ONEMIN + S * ONESEC;
        }
        if (y.length === 2) {
          y = (Number(y) + 2e3 - YFIRST) % 100 + YFIRST;
        } else y = Number(y);
        m -= 1;
        var date = new Date(Date.UTC(2e3, m, d, H, M));
        date.setUTCFullYear(y);
        if (date.getUTCMonth() !== m) return BADNUM;
        if (date.getUTCDate() !== d) return BADNUM;
        return date.getTime() + S * ONESEC;
      };
      MIN_MS = exports.MIN_MS = exports.dateTime2ms("-9999");
      MAX_MS = exports.MAX_MS = exports.dateTime2ms("9999-12-31 23:59:59.9999");
      exports.isDateTime = function(s, calendar) {
        return exports.dateTime2ms(s, calendar) !== BADNUM;
      };
      function lpad(val, digits) {
        return String(val + Math.pow(10, digits)).substr(1);
      }
      var NINETYDAYS = 90 * ONEDAY;
      var THREEHOURS = 3 * ONEHOUR;
      var FIVEMIN = 5 * ONEMIN;
      exports.ms2DateTime = function(ms, r, calendar) {
        if (typeof ms !== "number" || !(ms >= MIN_MS && ms <= MAX_MS)) return BADNUM;
        if (!r) r = 0;
        var msecTenths = Math.floor(mod(ms + 0.05, 1) * 10);
        var msRounded = Math.round(ms - msecTenths / 10);
        var dateStr, h, m, s, msec10, d;
        if (isWorldCalendar(calendar)) {
          var dateJD = Math.floor(msRounded / ONEDAY) + EPOCHJD;
          var timeMs = Math.floor(mod(ms, ONEDAY));
          try {
            dateStr = Registry.getComponentMethod("calendars", "getCal")(calendar).fromJD(dateJD).formatDate("yyyy-mm-dd");
          } catch (e) {
            dateStr = utcFormat("G%Y-%m-%d")(new Date(msRounded));
          }
          if (dateStr.charAt(0) === "-") {
            while (dateStr.length < 11) dateStr = "-0" + dateStr.substr(1);
          } else {
            while (dateStr.length < 10) dateStr = "0" + dateStr;
          }
          h = r < NINETYDAYS ? Math.floor(timeMs / ONEHOUR) : 0;
          m = r < NINETYDAYS ? Math.floor(timeMs % ONEHOUR / ONEMIN) : 0;
          s = r < THREEHOURS ? Math.floor(timeMs % ONEMIN / ONESEC) : 0;
          msec10 = r < FIVEMIN ? timeMs % ONESEC * 10 + msecTenths : 0;
        } else {
          d = new Date(msRounded);
          dateStr = utcFormat("%Y-%m-%d")(d);
          h = r < NINETYDAYS ? d.getUTCHours() : 0;
          m = r < NINETYDAYS ? d.getUTCMinutes() : 0;
          s = r < THREEHOURS ? d.getUTCSeconds() : 0;
          msec10 = r < FIVEMIN ? d.getUTCMilliseconds() * 10 + msecTenths : 0;
        }
        return includeTime(dateStr, h, m, s, msec10);
      };
      exports.ms2DateTimeLocal = function(ms) {
        if (!(ms >= MIN_MS + ONEDAY && ms <= MAX_MS - ONEDAY)) return BADNUM;
        var msecTenths = Math.floor(mod(ms + 0.05, 1) * 10);
        var d = new Date(Math.round(ms - msecTenths / 10));
        var dateStr = timeFormat("%Y-%m-%d")(d);
        var h = d.getHours();
        var m = d.getMinutes();
        var s = d.getSeconds();
        var msec10 = d.getUTCMilliseconds() * 10 + msecTenths;
        return includeTime(dateStr, h, m, s, msec10);
      };
      function includeTime(dateStr, h, m, s, msec10) {
        if (h || m || s || msec10) {
          dateStr += " " + lpad(h, 2) + ":" + lpad(m, 2);
          if (s || msec10) {
            dateStr += ":" + lpad(s, 2);
            if (msec10) {
              var digits = 4;
              while (msec10 % 10 === 0) {
                digits -= 1;
                msec10 /= 10;
              }
              dateStr += "." + lpad(msec10, digits);
            }
          }
        }
        return dateStr;
      }
      exports.cleanDate = function(v, dflt, calendar) {
        if (v === BADNUM) return dflt;
        if (exports.isJSDate(v) || typeof v === "number" && isFinite(v)) {
          if (isWorldCalendar(calendar)) {
            Loggers.error("JS Dates and milliseconds are incompatible with world calendars", v);
            return dflt;
          }
          v = exports.ms2DateTimeLocal(+v);
          if (!v && dflt !== void 0) return dflt;
        } else if (!exports.isDateTime(v, calendar)) {
          Loggers.error("unrecognized date", v);
          return dflt;
        }
        return v;
      };
      var fracMatch = /%\d?f/g;
      var halfYearMatch = /%h/g;
      var quarterToHalfYear = {
        1: "1",
        2: "1",
        3: "2",
        4: "2"
      };
      function modDateFormat(fmt, x, formatter, calendar) {
        fmt = fmt.replace(fracMatch, function(match) {
          var digits = Math.min(+match.charAt(1) || 6, 6);
          var fracSecs = (x / 1e3 % 1 + 2).toFixed(digits).substr(2).replace(/0+$/, "") || "0";
          return fracSecs;
        });
        var d = new Date(Math.floor(x + 0.05));
        fmt = fmt.replace(halfYearMatch, function() {
          return quarterToHalfYear[formatter("%q")(d)];
        });
        if (isWorldCalendar(calendar)) {
          try {
            fmt = Registry.getComponentMethod("calendars", "worldCalFmt")(fmt, x, calendar);
          } catch (e) {
            return "Invalid";
          }
        }
        return formatter(fmt)(d);
      }
      var MAXSECONDS = [59, 59.9, 59.99, 59.999, 59.9999];
      function formatTime(x, tr) {
        var timePart = mod(x + 0.05, ONEDAY);
        var timeStr = lpad(Math.floor(timePart / ONEHOUR), 2) + ":" + lpad(mod(Math.floor(timePart / ONEMIN), 60), 2);
        if (tr !== "M") {
          if (!isNumeric(tr)) tr = 0;
          var sec = Math.min(mod(x / ONESEC, 60), MAXSECONDS[tr]);
          var secStr = (100 + sec).toFixed(tr).substr(1);
          if (tr > 0) {
            secStr = secStr.replace(/0+$/, "").replace(/[\.]$/, "");
          }
          timeStr += ":" + secStr;
        }
        return timeStr;
      }
      exports.formatDate = function(x, fmt, tr, formatter, calendar, extraFormat) {
        calendar = isWorldCalendar(calendar) && calendar;
        if (!fmt) {
          if (tr === "y") fmt = extraFormat.year;
          else if (tr === "m") fmt = extraFormat.month;
          else if (tr === "d") {
            fmt = extraFormat.dayMonth + "\n" + extraFormat.year;
          } else {
            return formatTime(x, tr) + "\n" + modDateFormat(extraFormat.dayMonthYear, x, formatter, calendar);
          }
        }
        return modDateFormat(fmt, x, formatter, calendar);
      };
      var THREEDAYS = 3 * ONEDAY;
      exports.incrementMonth = function(ms, dMonth, calendar) {
        calendar = isWorldCalendar(calendar) && calendar;
        var timeMs = mod(ms, ONEDAY);
        ms = Math.round(ms - timeMs);
        if (calendar) {
          try {
            var dateJD = Math.round(ms / ONEDAY) + EPOCHJD;
            var calInstance = Registry.getComponentMethod("calendars", "getCal")(calendar);
            var cDate = calInstance.fromJD(dateJD);
            if (dMonth % 12) calInstance.add(cDate, dMonth, "m");
            else calInstance.add(cDate, dMonth / 12, "y");
            return (cDate.toJD() - EPOCHJD) * ONEDAY + timeMs;
          } catch (e) {
            Loggers.error("invalid ms " + ms + " in calendar " + calendar);
          }
        }
        var y = new Date(ms + THREEDAYS);
        return y.setUTCMonth(y.getUTCMonth() + dMonth) + timeMs - THREEDAYS;
      };
      exports.findExactDates = function(data, calendar) {
        var exactYears = 0;
        var exactMonths = 0;
        var exactDays = 0;
        var blankCount = 0;
        var d;
        var di;
        var calInstance = isWorldCalendar(calendar) && Registry.getComponentMethod("calendars", "getCal")(calendar);
        for (var i = 0; i < data.length; i++) {
          di = data[i];
          if (!isNumeric(di)) {
            blankCount++;
            continue;
          }
          if (di % ONEDAY) continue;
          if (calInstance) {
            try {
              d = calInstance.fromJD(di / ONEDAY + EPOCHJD);
              if (d.day() === 1) {
                if (d.month() === 1) exactYears++;
                else exactMonths++;
              } else exactDays++;
            } catch (e) {
            }
          } else {
            d = new Date(di);
            if (d.getUTCDate() === 1) {
              if (d.getUTCMonth() === 0) exactYears++;
              else exactMonths++;
            } else exactDays++;
          }
        }
        exactMonths += exactYears;
        exactDays += exactMonths;
        var dataCount = data.length - blankCount;
        return {
          exactYears: exactYears / dataCount,
          exactMonths: exactMonths / dataCount,
          exactDays: exactDays / dataCount
        };
      };
    }
  });

  // src/lib/identity.js
  var require_identity2 = __commonJS({
    "src/lib/identity.js"(exports, module) {
      "use strict";
      module.exports = function identity2(d) {
        return d;
      };
    }
  });

  // src/lib/search.js
  var require_search = __commonJS({
    "src/lib/search.js"(exports) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var loggers = require_loggers();
      var identity2 = require_identity2();
      var BADNUM = require_numerical().BADNUM;
      var roundingError = 1e-9;
      exports.findBin = function(val, bins, linelow) {
        if (isNumeric(bins.start)) {
          return linelow ? Math.ceil((val - bins.start) / bins.size - roundingError) - 1 : Math.floor((val - bins.start) / bins.size + roundingError);
        } else {
          var n1 = 0;
          var n2 = bins.length;
          var c = 0;
          var binSize = n2 > 1 ? (bins[n2 - 1] - bins[0]) / (n2 - 1) : 1;
          var n, test;
          if (binSize >= 0) {
            test = linelow ? lessThan : lessOrEqual;
          } else {
            test = linelow ? greaterOrEqual : greaterThan;
          }
          val += binSize * roundingError * (linelow ? -1 : 1) * (binSize >= 0 ? 1 : -1);
          while (n1 < n2 && c++ < 100) {
            n = Math.floor((n1 + n2) / 2);
            if (test(bins[n], val)) n1 = n + 1;
            else n2 = n;
          }
          if (c > 90) loggers.log("Long binary search...");
          return n1 - 1;
        }
      };
      function lessThan(a, b) {
        return a < b;
      }
      function lessOrEqual(a, b) {
        return a <= b;
      }
      function greaterThan(a, b) {
        return a > b;
      }
      function greaterOrEqual(a, b) {
        return a >= b;
      }
      exports.sorterAsc = function(a, b) {
        return a - b;
      };
      exports.sorterDes = function(a, b) {
        return b - a;
      };
      exports.distinctVals = function(valsIn) {
        var vals = valsIn.slice();
        vals.sort(exports.sorterAsc);
        var last;
        for (last = vals.length - 1; last > -1; last--) {
          if (vals[last] !== BADNUM) break;
        }
        var minDiff = vals[last] - vals[0] || 1;
        var errDiff = minDiff / (last || 1) / 1e4;
        var newVals = [];
        var preV;
        for (var i = 0; i <= last; i++) {
          var v = vals[i];
          var diff = v - preV;
          if (preV === void 0) {
            newVals.push(v);
            preV = v;
          } else if (diff > errDiff) {
            minDiff = Math.min(minDiff, diff);
            newVals.push(v);
            preV = v;
          }
        }
        return { vals: newVals, minDiff };
      };
      exports.roundUp = function(val, arrayIn, reverse) {
        var low = 0;
        var high = arrayIn.length - 1;
        var mid;
        var c = 0;
        var dlow = reverse ? 0 : 1;
        var dhigh = reverse ? 1 : 0;
        var rounded = reverse ? Math.ceil : Math.floor;
        while (low < high && c++ < 100) {
          mid = rounded((low + high) / 2);
          if (arrayIn[mid] <= val) low = mid + dlow;
          else high = mid - dhigh;
        }
        return arrayIn[low];
      };
      exports.sort = function(array, sortFn) {
        var notOrdered = 0;
        var notReversed = 0;
        for (var i = 1; i < array.length; i++) {
          var pairOrder = sortFn(array[i], array[i - 1]);
          if (pairOrder < 0) notOrdered = 1;
          else if (pairOrder > 0) notReversed = 1;
          if (notOrdered && notReversed) return array.sort(sortFn);
        }
        return notReversed ? array : array.reverse();
      };
      exports.findIndexOfMin = function(arr, fn) {
        fn = fn || identity2;
        var min = Infinity;
        var ind;
        for (var i = 0; i < arr.length; i++) {
          var v = fn(arr[i]);
          if (v < min) {
            min = v;
            ind = i;
          }
        }
        return ind;
      };
    }
  });

  // src/lib/sort_object_keys.js
  var require_sort_object_keys = __commonJS({
    "src/lib/sort_object_keys.js"(exports, module) {
      "use strict";
      module.exports = function sortObjectKeys(obj) {
        return Object.keys(obj).sort();
      };
    }
  });

  // src/lib/stats.js
  var require_stats = __commonJS({
    "src/lib/stats.js"(exports) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var isArrayOrTypedArray = require_array().isArrayOrTypedArray;
      exports.aggNums = function(f, v, a, len) {
        var i, b;
        if (!len || len > a.length) len = a.length;
        if (!isNumeric(v)) v = false;
        if (isArrayOrTypedArray(a[0])) {
          b = new Array(len);
          for (i = 0; i < len; i++) b[i] = exports.aggNums(f, v, a[i]);
          a = b;
        }
        for (i = 0; i < len; i++) {
          if (!isNumeric(v)) v = a[i];
          else if (isNumeric(a[i])) v = f(+v, +a[i]);
        }
        return v;
      };
      exports.len = function(data) {
        return exports.aggNums(function(a) {
          return a + 1;
        }, 0, data);
      };
      exports.mean = function(data, len) {
        if (!len) len = exports.len(data);
        return exports.aggNums(function(a, b) {
          return a + b;
        }, 0, data) / len;
      };
      exports.geometricMean = function(data, len) {
        if (!len) len = exports.len(data);
        return Math.pow(exports.aggNums(function(a, b) {
          return a * b;
        }, 1, data), 1 / len);
      };
      exports.midRange = function(numArr) {
        if (numArr === void 0 || numArr.length === 0) return void 0;
        return (exports.aggNums(Math.max, null, numArr) + exports.aggNums(Math.min, null, numArr)) / 2;
      };
      exports.variance = function(data, len, mean) {
        if (!len) len = exports.len(data);
        if (!isNumeric(mean)) mean = exports.mean(data, len);
        return exports.aggNums(function(a, b) {
          return a + Math.pow(b - mean, 2);
        }, 0, data) / len;
      };
      exports.stdev = function(data, len, mean) {
        return Math.sqrt(exports.variance(data, len, mean));
      };
      exports.median = function(data) {
        var b = data.slice().sort();
        return exports.interp(b, 0.5);
      };
      exports.interp = function(arr, n) {
        if (!isNumeric(n)) throw "n should be a finite number";
        n = n * arr.length - 0.5;
        if (n < 0) return arr[0];
        if (n > arr.length - 1) return arr[arr.length - 1];
        var frac = n % 1;
        return frac * arr[Math.ceil(n)] + (1 - frac) * arr[Math.floor(n)];
      };
    }
  });

  // src/lib/angles.js
  var require_angles = __commonJS({
    "src/lib/angles.js"(exports, module) {
      "use strict";
      var modModule = require_mod();
      var mod = modModule.mod;
      var modHalf = modModule.modHalf;
      var PI = Math.PI;
      var twoPI = 2 * PI;
      function deg2rad(deg) {
        return deg / 180 * PI;
      }
      function rad2deg(rad) {
        return rad / PI * 180;
      }
      function isFullCircle(aBnds) {
        return Math.abs(aBnds[1] - aBnds[0]) > twoPI - 1e-14;
      }
      function angleDelta(a, b) {
        return modHalf(b - a, twoPI);
      }
      function angleDist(a, b) {
        return Math.abs(angleDelta(a, b));
      }
      function isAngleInsideSector(a, aBnds) {
        if (isFullCircle(aBnds)) return true;
        var s0, s1;
        if (aBnds[0] < aBnds[1]) {
          s0 = aBnds[0];
          s1 = aBnds[1];
        } else {
          s0 = aBnds[1];
          s1 = aBnds[0];
        }
        s0 = mod(s0, twoPI);
        s1 = mod(s1, twoPI);
        if (s0 > s1) s1 += twoPI;
        var a0 = mod(a, twoPI);
        var a1 = a0 + twoPI;
        return a0 >= s0 && a0 <= s1 || a1 >= s0 && a1 <= s1;
      }
      function isPtInsideSector(r, a, rBnds, aBnds) {
        if (!isAngleInsideSector(a, aBnds)) return false;
        var r0, r1;
        if (rBnds[0] < rBnds[1]) {
          r0 = rBnds[0];
          r1 = rBnds[1];
        } else {
          r0 = rBnds[1];
          r1 = rBnds[0];
        }
        return r >= r0 && r <= r1;
      }
      function _path(r0, r1, a0, a1, cx, cy, isClosed) {
        cx = cx || 0;
        cy = cy || 0;
        var isCircle = isFullCircle([a0, a1]);
        var aStart, aMid, aEnd;
        var rStart, rEnd;
        if (isCircle) {
          aStart = 0;
          aMid = PI;
          aEnd = twoPI;
        } else {
          if (a0 < a1) {
            aStart = a0;
            aEnd = a1;
          } else {
            aStart = a1;
            aEnd = a0;
          }
        }
        if (r0 < r1) {
          rStart = r0;
          rEnd = r1;
        } else {
          rStart = r1;
          rEnd = r0;
        }
        function pt(r, a) {
          return [r * Math.cos(a) + cx, cy - r * Math.sin(a)];
        }
        var largeArc = Math.abs(aEnd - aStart) <= PI ? 0 : 1;
        function arc(r, a, cw) {
          return "A" + [r, r] + " " + [0, largeArc, cw] + " " + pt(r, a);
        }
        var p;
        if (isCircle) {
          if (rStart === null) {
            p = "M" + pt(rEnd, aStart) + arc(rEnd, aMid, 0) + arc(rEnd, aEnd, 0) + "Z";
          } else {
            p = "M" + pt(rStart, aStart) + arc(rStart, aMid, 0) + arc(rStart, aEnd, 0) + "ZM" + pt(rEnd, aStart) + arc(rEnd, aMid, 1) + arc(rEnd, aEnd, 1) + "Z";
          }
        } else {
          if (rStart === null) {
            p = "M" + pt(rEnd, aStart) + arc(rEnd, aEnd, 0);
            if (isClosed) p += "L0,0Z";
          } else {
            p = "M" + pt(rStart, aStart) + "L" + pt(rEnd, aStart) + arc(rEnd, aEnd, 0) + "L" + pt(rStart, aEnd) + arc(rStart, aStart, 1) + "Z";
          }
        }
        return p;
      }
      function pathArc(r, a0, a1, cx, cy) {
        return _path(null, r, a0, a1, cx, cy, 0);
      }
      function pathSector(r, a0, a1, cx, cy) {
        return _path(null, r, a0, a1, cx, cy, 1);
      }
      function pathAnnulus(r0, r1, a0, a1, cx, cy) {
        return _path(r0, r1, a0, a1, cx, cy, 1);
      }
      module.exports = {
        deg2rad,
        rad2deg,
        angleDelta,
        angleDist,
        isFullCircle,
        isAngleInsideSector,
        isPtInsideSector,
        pathArc,
        pathSector,
        pathAnnulus
      };
    }
  });

  // src/lib/anchor_utils.js
  var require_anchor_utils = __commonJS({
    "src/lib/anchor_utils.js"(exports) {
      "use strict";
      exports.isLeftAnchor = function isLeftAnchor(opts) {
        return opts.xanchor === "left" || opts.xanchor === "auto" && opts.x <= 1 / 3;
      };
      exports.isCenterAnchor = function isCenterAnchor(opts) {
        return opts.xanchor === "center" || opts.xanchor === "auto" && opts.x > 1 / 3 && opts.x < 2 / 3;
      };
      exports.isRightAnchor = function isRightAnchor(opts) {
        return opts.xanchor === "right" || opts.xanchor === "auto" && opts.x >= 2 / 3;
      };
      exports.isTopAnchor = function isTopAnchor(opts) {
        return opts.yanchor === "top" || opts.yanchor === "auto" && opts.y >= 2 / 3;
      };
      exports.isMiddleAnchor = function isMiddleAnchor(opts) {
        return opts.yanchor === "middle" || opts.yanchor === "auto" && opts.y > 1 / 3 && opts.y < 2 / 3;
      };
      exports.isBottomAnchor = function isBottomAnchor(opts) {
        return opts.yanchor === "bottom" || opts.yanchor === "auto" && opts.y <= 1 / 3;
      };
    }
  });

  // src/lib/geometry2d.js
  var require_geometry2d = __commonJS({
    "src/lib/geometry2d.js"(exports) {
      "use strict";
      var mod = require_mod().mod;
      exports.segmentsIntersect = segmentsIntersect;
      function segmentsIntersect(x1, y1, x2, y2, x3, y3, x4, y4) {
        var a = x2 - x1;
        var b = x3 - x1;
        var c = x4 - x3;
        var d = y2 - y1;
        var e = y3 - y1;
        var f = y4 - y3;
        var det = a * f - c * d;
        if (det === 0) return null;
        var t = (b * f - c * e) / det;
        var u = (b * d - a * e) / det;
        if (u < 0 || u > 1 || t < 0 || t > 1) return null;
        return { x: x1 + a * t, y: y1 + d * t };
      }
      exports.segmentDistance = function segmentDistance(x1, y1, x2, y2, x3, y3, x4, y4) {
        if (segmentsIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) return 0;
        var x12 = x2 - x1;
        var y12 = y2 - y1;
        var x34 = x4 - x3;
        var y34 = y4 - y3;
        var ll12 = x12 * x12 + y12 * y12;
        var ll34 = x34 * x34 + y34 * y34;
        var dist2 = Math.min(
          perpDistance2(x12, y12, ll12, x3 - x1, y3 - y1),
          perpDistance2(x12, y12, ll12, x4 - x1, y4 - y1),
          perpDistance2(x34, y34, ll34, x1 - x3, y1 - y3),
          perpDistance2(x34, y34, ll34, x2 - x3, y2 - y3)
        );
        return Math.sqrt(dist2);
      };
      function perpDistance2(xab, yab, llab, xac, yac) {
        var fcAB = xac * xab + yac * yab;
        if (fcAB < 0) {
          return xac * xac + yac * yac;
        } else if (fcAB > llab) {
          var xbc = xac - xab;
          var ybc = yac - yab;
          return xbc * xbc + ybc * ybc;
        } else {
          var crossProduct = xac * yab - yac * xab;
          return crossProduct * crossProduct / llab;
        }
      }
      var locationCache;
      var workingPath;
      var workingTextWidth;
      exports.getTextLocation = function getTextLocation(path, totalPathLen, positionOnPath, textWidth) {
        if (path !== workingPath || textWidth !== workingTextWidth) {
          locationCache = {};
          workingPath = path;
          workingTextWidth = textWidth;
        }
        if (locationCache[positionOnPath]) {
          return locationCache[positionOnPath];
        }
        var p0 = path.getPointAtLength(mod(positionOnPath - textWidth / 2, totalPathLen));
        var p1 = path.getPointAtLength(mod(positionOnPath + textWidth / 2, totalPathLen));
        var theta = Math.atan((p1.y - p0.y) / (p1.x - p0.x));
        var pCenter = path.getPointAtLength(mod(positionOnPath, totalPathLen));
        var x = (pCenter.x * 4 + p0.x + p1.x) / 6;
        var y = (pCenter.y * 4 + p0.y + p1.y) / 6;
        var out = { x, y, theta };
        locationCache[positionOnPath] = out;
        return out;
      };
      exports.clearLocationCache = function() {
        workingPath = null;
      };
      exports.getVisibleSegment = function getVisibleSegment(path, bounds, buffer) {
        var left = bounds.left;
        var right = bounds.right;
        var top = bounds.top;
        var bottom = bounds.bottom;
        var pMin = 0;
        var pTotal = path.getTotalLength();
        var pMax = pTotal;
        var pt0, ptTotal;
        function getDistToPlot(len) {
          var pt = path.getPointAtLength(len);
          if (len === 0) pt0 = pt;
          else if (len === pTotal) ptTotal = pt;
          var dx = pt.x < left ? left - pt.x : pt.x > right ? pt.x - right : 0;
          var dy = pt.y < top ? top - pt.y : pt.y > bottom ? pt.y - bottom : 0;
          return Math.sqrt(dx * dx + dy * dy);
        }
        var distToPlot = getDistToPlot(pMin);
        while (distToPlot) {
          pMin += distToPlot + buffer;
          if (pMin > pMax) return;
          distToPlot = getDistToPlot(pMin);
        }
        distToPlot = getDistToPlot(pMax);
        while (distToPlot) {
          pMax -= distToPlot + buffer;
          if (pMin > pMax) return;
          distToPlot = getDistToPlot(pMax);
        }
        return {
          min: pMin,
          max: pMax,
          len: pMax - pMin,
          total: pTotal,
          isClosed: pMin === 0 && pMax === pTotal && Math.abs(pt0.x - ptTotal.x) < 0.1 && Math.abs(pt0.y - ptTotal.y) < 0.1
        };
      };
      exports.findPointOnPath = function findPointOnPath(path, val, coord, opts) {
        opts = opts || {};
        var pathLength = opts.pathLength || path.getTotalLength();
        var tolerance = opts.tolerance || 1e-3;
        var iterationLimit = opts.iterationLimit || 30;
        var mul = path.getPointAtLength(0)[coord] > path.getPointAtLength(pathLength)[coord] ? -1 : 1;
        var i = 0;
        var b0 = 0;
        var b1 = pathLength;
        var mid;
        var pt;
        var diff;
        while (i < iterationLimit) {
          mid = (b0 + b1) / 2;
          pt = path.getPointAtLength(mid);
          diff = pt[coord] - val;
          if (Math.abs(diff) < tolerance) {
            return pt;
          } else {
            if (mul * diff > 0) {
              b1 = mid;
            } else {
              b0 = mid;
            }
            i++;
          }
        }
        return pt;
      };
    }
  });

  // src/lib/throttle.js
  var require_throttle = __commonJS({
    "src/lib/throttle.js"(exports) {
      "use strict";
      var timerCache = {};
      exports.throttle = function throttle(id, minInterval, callback) {
        var cache = timerCache[id];
        var now = Date.now();
        if (!cache) {
          for (var idi in timerCache) {
            if (timerCache[idi].ts < now - 6e4) {
              delete timerCache[idi];
            }
          }
          cache = timerCache[id] = { ts: 0, timer: null };
        }
        _clearTimeout(cache);
        function exec() {
          callback();
          cache.ts = Date.now();
          if (cache.onDone) {
            cache.onDone();
            cache.onDone = null;
          }
        }
        if (now > cache.ts + minInterval) {
          exec();
          return;
        }
        cache.timer = setTimeout(function() {
          exec();
          cache.timer = null;
        }, minInterval);
      };
      exports.done = function(id) {
        var cache = timerCache[id];
        if (!cache || !cache.timer) return Promise.resolve();
        return new Promise(function(resolve) {
          var previousOnDone = cache.onDone;
          cache.onDone = function onDone() {
            if (previousOnDone) previousOnDone();
            resolve();
            cache.onDone = null;
          };
        });
      };
      exports.clear = function(id) {
        if (id) {
          _clearTimeout(timerCache[id]);
          delete timerCache[id];
        } else {
          for (var idi in timerCache) exports.clear(idi);
        }
      };
      function _clearTimeout(cache) {
        if (cache && cache.timer !== null) {
          clearTimeout(cache.timer);
          cache.timer = null;
        }
      }
    }
  });

  // src/lib/clear_responsive.js
  var require_clear_responsive = __commonJS({
    "src/lib/clear_responsive.js"(exports, module) {
      "use strict";
      module.exports = function clearResponsive(gd) {
        if (gd._responsiveChartHandler) {
          window.removeEventListener("resize", gd._responsiveChartHandler);
          delete gd._responsiveChartHandler;
        }
      };
    }
  });

  // node_modules/is-mobile/index.js
  var require_is_mobile = __commonJS({
    "node_modules/is-mobile/index.js"(exports, module) {
      "use strict";
      module.exports = isMobile;
      module.exports.isMobile = isMobile;
      module.exports.default = isMobile;
      var mobileRE = /(android|bb\d+|meego).+mobile|armv7l|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series[46]0|samsungbrowser.*mobile|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i;
      var notMobileRE = /CrOS/;
      var tabletRE = /android|ipad|playbook|silk/i;
      function isMobile(opts) {
        if (!opts) opts = {};
        let ua = opts.ua;
        if (!ua && typeof navigator !== "undefined") ua = navigator.userAgent;
        if (ua && ua.headers && typeof ua.headers["user-agent"] === "string") {
          ua = ua.headers["user-agent"];
        }
        if (typeof ua !== "string") return false;
        let result = mobileRE.test(ua) && !notMobileRE.test(ua) || !!opts.tablet && tabletRE.test(ua);
        if (!result && opts.tablet && opts.featureDetect && navigator && navigator.maxTouchPoints > 1 && ua.indexOf("Macintosh") !== -1 && ua.indexOf("Safari") !== -1) {
          result = true;
        }
        return result;
      }
    }
  });

  // src/lib/preserve_drawing_buffer.js
  var require_preserve_drawing_buffer = __commonJS({
    "src/lib/preserve_drawing_buffer.js"(exports, module) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var isMobileOrTablet = require_is_mobile();
      module.exports = function preserveDrawingBuffer(opts) {
        var ua;
        if (opts && opts.hasOwnProperty("userAgent")) {
          ua = opts.userAgent;
        } else {
          ua = getUserAgent();
        }
        if (typeof ua !== "string") return true;
        var enable = isMobileOrTablet({
          ua: { headers: { "user-agent": ua } },
          tablet: true,
          featureDetect: false
        });
        if (!enable) {
          var allParts = ua.split(" ");
          for (var i = 1; i < allParts.length; i++) {
            var part = allParts[i];
            if (part.indexOf("Safari") !== -1) {
              for (var k = i - 1; k > -1; k--) {
                var prevPart = allParts[k];
                if (prevPart.substr(0, 8) === "Version/") {
                  var v = prevPart.substr(8).split(".")[0];
                  if (isNumeric(v)) v = +v;
                  if (v >= 13) return true;
                }
              }
            }
          }
        }
        return enable;
      };
      function getUserAgent() {
        var ua;
        if (typeof navigator !== "undefined") {
          ua = navigator.userAgent;
        }
        if (ua && ua.headers && typeof ua.headers["user-agent"] === "string") {
          ua = ua.headers["user-agent"];
        }
        return ua;
      }
    }
  });

  // src/lib/make_trace_groups.js
  var require_make_trace_groups = __commonJS({
    "src/lib/make_trace_groups.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      module.exports = function makeTraceGroups(traceLayer, cdModule, cls) {
        var traces = traceLayer.selectAll("g." + cls.replace(/\s/g, ".")).data(cdModule, function(cd) {
          return cd[0].trace.uid;
        });
        traces.exit().remove();
        traces.enter().append("g").attr("class", cls);
        traces.order();
        var k = traceLayer.classed("rangeplot") ? "nodeRangePlot3" : "node3";
        traces.each(function(cd) {
          cd[0][k] = d3.select(this);
        });
        return traces;
      };
    }
  });

  // src/lib/localize.js
  var require_localize = __commonJS({
    "src/lib/localize.js"(exports, module) {
      "use strict";
      var Registry = require_registry();
      module.exports = function localize(gd, s) {
        var locale = gd._context.locale;
        for (var i = 0; i < 2; i++) {
          var locales = gd._context.locales;
          for (var j = 0; j < 2; j++) {
            var dict = (locales[locale] || {}).dictionary;
            if (dict) {
              var out = dict[s];
              if (out) return out;
            }
            locales = Registry.localeRegistry;
          }
          var baseLocale = locale.split("-")[0];
          if (baseLocale === locale) break;
          locale = baseLocale;
        }
        return s;
      };
    }
  });

  // src/lib/filter_unique.js
  var require_filter_unique = __commonJS({
    "src/lib/filter_unique.js"(exports, module) {
      "use strict";
      module.exports = function filterUnique(array) {
        var seen = {};
        var out = [];
        var j = 0;
        for (var i = 0; i < array.length; i++) {
          var item = array[i];
          if (seen[item] !== 1) {
            seen[item] = 1;
            out[j++] = item;
          }
        }
        return out;
      };
    }
  });

  // src/lib/filter_visible.js
  var require_filter_visible = __commonJS({
    "src/lib/filter_visible.js"(exports, module) {
      "use strict";
      module.exports = function filterVisible(container) {
        var filterFn = isCalcData(container) ? calcDataFilter : baseFilter;
        var out = [];
        for (var i = 0; i < container.length; i++) {
          var item = container[i];
          if (filterFn(item)) out.push(item);
        }
        return out;
      };
      function baseFilter(item) {
        return item.visible === true;
      }
      function calcDataFilter(item) {
        var trace = item[0].trace;
        return trace.visible === true && trace._length !== 0;
      }
      function isCalcData(cont) {
        return Array.isArray(cont) && Array.isArray(cont[0]) && cont[0][0] && cont[0][0].trace;
      }
    }
  });

  // src/lib/increment.js
  var require_increment = __commonJS({
    "src/lib/increment.js"(exports, module) {
      "use strict";
      module.exports = function incrementNumeric(x, delta) {
        if (!delta) return x;
        var scale = 1 / Math.abs(delta);
        var newX = scale > 1 ? (scale * x + scale * delta) / scale : x + delta;
        var lenX1 = String(newX).length;
        if (lenX1 > 16) {
          var lenDt = String(delta).length;
          var lenX0 = String(x).length;
          if (lenX1 >= lenX0 + lenDt) {
            var s = parseFloat(newX).toPrecision(12);
            if (s.indexOf("e+") === -1) newX = +s;
          }
        }
        return newX;
      };
    }
  });

  // src/lib/clean_number.js
  var require_clean_number = __commonJS({
    "src/lib/clean_number.js"(exports, module) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var BADNUM = require_numerical().BADNUM;
      var JUNK = /^['"%,$#\s']+|[, ]|['"%,$#\s']+$/g;
      module.exports = function cleanNumber(v) {
        if (typeof v === "string") {
          v = v.replace(JUNK, "");
        }
        if (isNumeric(v)) return Number(v);
        return BADNUM;
      };
    }
  });

  // src/lib/index.js
  var require_lib = __commonJS({
    "src/lib/index.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var utcFormat = require_d3_time_format().utcFormat;
      var d3Format = require_d3_format().format;
      var isNumeric = require_fast_isnumeric();
      var numConstants = require_numerical();
      var MAX_SAFE = numConstants.FP_SAFE;
      var MIN_SAFE = -MAX_SAFE;
      var BADNUM = numConstants.BADNUM;
      var lib = module.exports = {};
      lib.adjustFormat = function adjustFormat(formatStr) {
        if (!formatStr || /^\d[.]\df/.test(formatStr) || /[.]\d%/.test(formatStr)) return formatStr;
        if (formatStr === "0.f") return "~f";
        if (/^\d%/.test(formatStr)) return "~%";
        if (/^\ds/.test(formatStr)) return "~s";
        if (!/^[~,.0$]/.test(formatStr) && /[&fps]/.test(formatStr)) return "~" + formatStr;
        return formatStr;
      };
      var seenBadFormats = {};
      lib.warnBadFormat = function(f) {
        var key = String(f);
        if (!seenBadFormats[key]) {
          seenBadFormats[key] = 1;
          lib.warn('encountered bad format: "' + key + '"');
        }
      };
      lib.noFormat = function(value) {
        return String(value);
      };
      lib.numberFormat = function(formatStr) {
        var fn;
        try {
          fn = d3Format(lib.adjustFormat(formatStr));
        } catch (e) {
          lib.warnBadFormat(formatStr);
          return lib.noFormat;
        }
        return fn;
      };
      lib.nestedProperty = require_nested_property();
      lib.keyedContainer = require_keyed_container();
      lib.relativeAttr = require_relative_attr();
      lib.isPlainObject = require_is_plain_object();
      lib.toLogRange = require_to_log_range();
      lib.relinkPrivateKeys = require_relink_private();
      var arrayModule = require_array();
      lib.isArrayBuffer = arrayModule.isArrayBuffer;
      lib.isTypedArray = arrayModule.isTypedArray;
      lib.isArrayOrTypedArray = arrayModule.isArrayOrTypedArray;
      lib.isArray1D = arrayModule.isArray1D;
      lib.ensureArray = arrayModule.ensureArray;
      lib.concat = arrayModule.concat;
      lib.maxRowLength = arrayModule.maxRowLength;
      lib.minRowLength = arrayModule.minRowLength;
      var modModule = require_mod();
      lib.mod = modModule.mod;
      lib.modHalf = modModule.modHalf;
      var coerceModule = require_coerce();
      lib.valObjectMeta = coerceModule.valObjectMeta;
      lib.coerce = coerceModule.coerce;
      lib.coerce2 = coerceModule.coerce2;
      lib.coerceFont = coerceModule.coerceFont;
      lib.coercePattern = coerceModule.coercePattern;
      lib.coerceHoverinfo = coerceModule.coerceHoverinfo;
      lib.coerceSelectionMarkerOpacity = coerceModule.coerceSelectionMarkerOpacity;
      lib.validate = coerceModule.validate;
      var datesModule = require_dates();
      lib.dateTime2ms = datesModule.dateTime2ms;
      lib.isDateTime = datesModule.isDateTime;
      lib.ms2DateTime = datesModule.ms2DateTime;
      lib.ms2DateTimeLocal = datesModule.ms2DateTimeLocal;
      lib.cleanDate = datesModule.cleanDate;
      lib.isJSDate = datesModule.isJSDate;
      lib.formatDate = datesModule.formatDate;
      lib.incrementMonth = datesModule.incrementMonth;
      lib.dateTick0 = datesModule.dateTick0;
      lib.dfltRange = datesModule.dfltRange;
      lib.findExactDates = datesModule.findExactDates;
      lib.MIN_MS = datesModule.MIN_MS;
      lib.MAX_MS = datesModule.MAX_MS;
      var searchModule = require_search();
      lib.findBin = searchModule.findBin;
      lib.sorterAsc = searchModule.sorterAsc;
      lib.sorterDes = searchModule.sorterDes;
      lib.distinctVals = searchModule.distinctVals;
      lib.roundUp = searchModule.roundUp;
      lib.sort = searchModule.sort;
      lib.findIndexOfMin = searchModule.findIndexOfMin;
      lib.sortObjectKeys = require_sort_object_keys();
      var statsModule = require_stats();
      lib.aggNums = statsModule.aggNums;
      lib.len = statsModule.len;
      lib.mean = statsModule.mean;
      lib.geometricMean = statsModule.geometricMean;
      lib.median = statsModule.median;
      lib.midRange = statsModule.midRange;
      lib.variance = statsModule.variance;
      lib.stdev = statsModule.stdev;
      lib.interp = statsModule.interp;
      var matrixModule = require_matrix();
      lib.init2dArray = matrixModule.init2dArray;
      lib.transposeRagged = matrixModule.transposeRagged;
      lib.dot = matrixModule.dot;
      lib.translationMatrix = matrixModule.translationMatrix;
      lib.rotationMatrix = matrixModule.rotationMatrix;
      lib.rotationXYMatrix = matrixModule.rotationXYMatrix;
      lib.apply3DTransform = matrixModule.apply3DTransform;
      lib.apply2DTransform = matrixModule.apply2DTransform;
      lib.apply2DTransform2 = matrixModule.apply2DTransform2;
      lib.convertCssMatrix = matrixModule.convertCssMatrix;
      lib.inverseTransformMatrix = matrixModule.inverseTransformMatrix;
      var anglesModule = require_angles();
      lib.deg2rad = anglesModule.deg2rad;
      lib.rad2deg = anglesModule.rad2deg;
      lib.angleDelta = anglesModule.angleDelta;
      lib.angleDist = anglesModule.angleDist;
      lib.isFullCircle = anglesModule.isFullCircle;
      lib.isAngleInsideSector = anglesModule.isAngleInsideSector;
      lib.isPtInsideSector = anglesModule.isPtInsideSector;
      lib.pathArc = anglesModule.pathArc;
      lib.pathSector = anglesModule.pathSector;
      lib.pathAnnulus = anglesModule.pathAnnulus;
      var anchorUtils = require_anchor_utils();
      lib.isLeftAnchor = anchorUtils.isLeftAnchor;
      lib.isCenterAnchor = anchorUtils.isCenterAnchor;
      lib.isRightAnchor = anchorUtils.isRightAnchor;
      lib.isTopAnchor = anchorUtils.isTopAnchor;
      lib.isMiddleAnchor = anchorUtils.isMiddleAnchor;
      lib.isBottomAnchor = anchorUtils.isBottomAnchor;
      var geom2dModule = require_geometry2d();
      lib.segmentsIntersect = geom2dModule.segmentsIntersect;
      lib.segmentDistance = geom2dModule.segmentDistance;
      lib.getTextLocation = geom2dModule.getTextLocation;
      lib.clearLocationCache = geom2dModule.clearLocationCache;
      lib.getVisibleSegment = geom2dModule.getVisibleSegment;
      lib.findPointOnPath = geom2dModule.findPointOnPath;
      var extendModule = require_extend();
      lib.extendFlat = extendModule.extendFlat;
      lib.extendDeep = extendModule.extendDeep;
      lib.extendDeepAll = extendModule.extendDeepAll;
      lib.extendDeepNoArrays = extendModule.extendDeepNoArrays;
      var loggersModule = require_loggers();
      lib.log = loggersModule.log;
      lib.warn = loggersModule.warn;
      lib.error = loggersModule.error;
      var regexModule = require_regex();
      lib.counterRegex = regexModule.counter;
      var throttleModule = require_throttle();
      lib.throttle = throttleModule.throttle;
      lib.throttleDone = throttleModule.done;
      lib.clearThrottle = throttleModule.clear;
      var domModule = require_dom();
      lib.getGraphDiv = domModule.getGraphDiv;
      lib.isPlotDiv = domModule.isPlotDiv;
      lib.removeElement = domModule.removeElement;
      lib.addStyleRule = domModule.addStyleRule;
      lib.addRelatedStyleRule = domModule.addRelatedStyleRule;
      lib.deleteRelatedStyleRule = domModule.deleteRelatedStyleRule;
      lib.setStyleOnHover = domModule.setStyleOnHover;
      lib.getFullTransformMatrix = domModule.getFullTransformMatrix;
      lib.getElementTransformMatrix = domModule.getElementTransformMatrix;
      lib.getElementAndAncestors = domModule.getElementAndAncestors;
      lib.equalDomRects = domModule.equalDomRects;
      lib.clearResponsive = require_clear_responsive();
      lib.preserveDrawingBuffer = require_preserve_drawing_buffer();
      lib.makeTraceGroups = require_make_trace_groups();
      lib._ = require_localize();
      lib.notifier = require_notifier();
      lib.filterUnique = require_filter_unique();
      lib.filterVisible = require_filter_visible();
      lib.pushUnique = require_push_unique();
      lib.increment = require_increment();
      lib.cleanNumber = require_clean_number();
      lib.ensureNumber = function ensureNumber(v) {
        if (!isNumeric(v)) return BADNUM;
        v = Number(v);
        return v > MAX_SAFE || v < MIN_SAFE ? BADNUM : v;
      };
      lib.isIndex = function(v, len) {
        if (len !== void 0 && v >= len) return false;
        return isNumeric(v) && v >= 0 && v % 1 === 0;
      };
      lib.noop = require_noop();
      lib.identity = require_identity2();
      lib.repeat = function(v, cnt) {
        var out = new Array(cnt);
        for (var i = 0; i < cnt; i++) {
          out[i] = v;
        }
        return out;
      };
      lib.swapAttrs = function(cont, attrList, part1, part2) {
        if (!part1) part1 = "x";
        if (!part2) part2 = "y";
        for (var i = 0; i < attrList.length; i++) {
          var attr = attrList[i];
          var xp = lib.nestedProperty(cont, attr.replace("?", part1));
          var yp = lib.nestedProperty(cont, attr.replace("?", part2));
          var temp = xp.get();
          xp.set(yp.get());
          yp.set(temp);
        }
      };
      lib.raiseToTop = function raiseToTop(elem) {
        elem.parentNode.appendChild(elem);
      };
      lib.cancelTransition = function(selection) {
        return selection.transition().duration(0);
      };
      lib.constrain = function(v, v0, v1) {
        if (v0 > v1) return Math.max(v1, Math.min(v0, v));
        return Math.max(v0, Math.min(v1, v));
      };
      lib.bBoxIntersect = function(a, b, pad) {
        pad = pad || 0;
        return a.left <= b.right + pad && b.left <= a.right + pad && a.top <= b.bottom + pad && b.top <= a.bottom + pad;
      };
      lib.simpleMap = function(array, func, x1, x2, opts) {
        var len = array.length;
        var out = new Array(len);
        for (var i = 0; i < len; i++) out[i] = func(array[i], x1, x2, opts);
        return out;
      };
      lib.randstr = function randstr(existing, bits, base, _recursion) {
        if (!base) base = 16;
        if (bits === void 0) bits = 24;
        if (bits <= 0) return "0";
        var digits = Math.log(Math.pow(2, bits)) / Math.log(base);
        var res = "";
        var i, b, x;
        for (i = 2; digits === Infinity; i *= 2) {
          digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;
        }
        var rem = digits - Math.floor(digits);
        for (i = 0; i < Math.floor(digits); i++) {
          x = Math.floor(Math.random() * base).toString(base);
          res = x + res;
        }
        if (rem) {
          b = Math.pow(base, rem);
          x = Math.floor(Math.random() * b).toString(base);
          res = x + res;
        }
        var parsed = parseInt(res, base);
        if (existing && existing[res] || parsed !== Infinity && parsed >= Math.pow(2, bits)) {
          if (_recursion > 10) {
            lib.warn("randstr failed uniqueness");
            return res;
          }
          return randstr(existing, bits, base, (_recursion || 0) + 1);
        } else return res;
      };
      lib.OptionControl = function(opt, optname) {
        if (!opt) opt = {};
        if (!optname) optname = "opt";
        var self2 = {};
        self2.optionList = [];
        self2._newoption = function(optObj) {
          optObj[optname] = opt;
          self2[optObj.name] = optObj;
          self2.optionList.push(optObj);
        };
        self2["_" + optname] = opt;
        return self2;
      };
      lib.smooth = function(arrayIn, FWHM) {
        FWHM = Math.round(FWHM) || 0;
        if (FWHM < 2) return arrayIn;
        var alen = arrayIn.length;
        var alen2 = 2 * alen;
        var wlen = 2 * FWHM - 1;
        var w = new Array(wlen);
        var arrayOut = new Array(alen);
        var i;
        var j;
        var k;
        var v;
        for (i = 0; i < wlen; i++) {
          w[i] = (1 - Math.cos(Math.PI * (i + 1) / FWHM)) / (2 * FWHM);
        }
        for (i = 0; i < alen; i++) {
          v = 0;
          for (j = 0; j < wlen; j++) {
            k = i + j + 1 - FWHM;
            if (k < -alen) k -= alen2 * Math.round(k / alen2);
            else if (k >= alen2) k -= alen2 * Math.floor(k / alen2);
            if (k < 0) k = -1 - k;
            else if (k >= alen) k = alen2 - 1 - k;
            v += arrayIn[k] * w[j];
          }
          arrayOut[i] = v;
        }
        return arrayOut;
      };
      lib.syncOrAsync = function(sequence, arg, finalStep) {
        var ret, fni;
        function continueAsync() {
          return lib.syncOrAsync(sequence, arg, finalStep);
        }
        while (sequence.length) {
          fni = sequence.splice(0, 1)[0];
          ret = fni(arg);
          if (ret && ret.then) {
            return ret.then(continueAsync);
          }
        }
        return finalStep && finalStep(arg);
      };
      lib.stripTrailingSlash = function(str) {
        if (str.substr(-1) === "/") return str.substr(0, str.length - 1);
        return str;
      };
      lib.noneOrAll = function(containerIn, containerOut, attrList) {
        if (!containerIn) return;
        var hasAny = false;
        var hasAll = true;
        var i;
        var val;
        for (i = 0; i < attrList.length; i++) {
          val = containerIn[attrList[i]];
          if (val !== void 0 && val !== null) hasAny = true;
          else hasAll = false;
        }
        if (hasAny && !hasAll) {
          for (i = 0; i < attrList.length; i++) {
            containerIn[attrList[i]] = containerOut[attrList[i]];
          }
        }
      };
      lib.mergeArray = function(traceAttr, cd, cdAttr, fn) {
        var hasFn = typeof fn === "function";
        if (lib.isArrayOrTypedArray(traceAttr)) {
          var imax = Math.min(traceAttr.length, cd.length);
          for (var i = 0; i < imax; i++) {
            var v = traceAttr[i];
            cd[i][cdAttr] = hasFn ? fn(v) : v;
          }
        }
      };
      lib.mergeArrayCastPositive = function(traceAttr, cd, cdAttr) {
        return lib.mergeArray(traceAttr, cd, cdAttr, function(v) {
          var w = +v;
          return !isFinite(w) ? 0 : w > 0 ? w : 0;
        });
      };
      lib.fillArray = function(traceAttr, cd, cdAttr, fn) {
        fn = fn || lib.identity;
        if (lib.isArrayOrTypedArray(traceAttr)) {
          for (var i = 0; i < cd.length; i++) {
            cd[i][cdAttr] = fn(traceAttr[i]);
          }
        }
      };
      lib.castOption = function(trace, ptNumber, astr, fn) {
        fn = fn || lib.identity;
        var val = lib.nestedProperty(trace, astr).get();
        if (lib.isArrayOrTypedArray(val)) {
          if (Array.isArray(ptNumber) && lib.isArrayOrTypedArray(val[ptNumber[0]])) {
            return fn(val[ptNumber[0]][ptNumber[1]]);
          } else {
            return fn(val[ptNumber]);
          }
        } else {
          return val;
        }
      };
      lib.extractOption = function(calcPt, trace, calcKey, traceKey) {
        if (calcKey in calcPt) return calcPt[calcKey];
        var traceVal = lib.nestedProperty(trace, traceKey).get();
        if (!Array.isArray(traceVal)) return traceVal;
      };
      function makePtIndex2PtNumber(indexToPoints) {
        var ptIndex2ptNumber = {};
        for (var k in indexToPoints) {
          var pts = indexToPoints[k];
          for (var j = 0; j < pts.length; j++) {
            ptIndex2ptNumber[pts[j]] = +k;
          }
        }
        return ptIndex2ptNumber;
      }
      lib.tagSelected = function(calcTrace, trace, ptNumber2cdIndex) {
        var selectedpoints = trace.selectedpoints;
        var indexToPoints = trace._indexToPoints;
        var ptIndex2ptNumber;
        if (indexToPoints) {
          ptIndex2ptNumber = makePtIndex2PtNumber(indexToPoints);
        }
        function isCdIndexValid(v) {
          return v !== void 0 && v < calcTrace.length;
        }
        for (var i = 0; i < selectedpoints.length; i++) {
          var ptIndex = selectedpoints[i];
          if (lib.isIndex(ptIndex) || lib.isArrayOrTypedArray(ptIndex) && lib.isIndex(ptIndex[0]) && lib.isIndex(ptIndex[1])) {
            var ptNumber = ptIndex2ptNumber ? ptIndex2ptNumber[ptIndex] : ptIndex;
            var cdIndex = ptNumber2cdIndex ? ptNumber2cdIndex[ptNumber] : ptNumber;
            if (isCdIndexValid(cdIndex)) {
              calcTrace[cdIndex].selected = 1;
            }
          }
        }
      };
      lib.selIndices2selPoints = function(trace) {
        var selectedpoints = trace.selectedpoints;
        var indexToPoints = trace._indexToPoints;
        if (indexToPoints) {
          var ptIndex2ptNumber = makePtIndex2PtNumber(indexToPoints);
          var out = [];
          for (var i = 0; i < selectedpoints.length; i++) {
            var ptIndex = selectedpoints[i];
            if (lib.isIndex(ptIndex)) {
              var ptNumber = ptIndex2ptNumber[ptIndex];
              if (lib.isIndex(ptNumber)) {
                out.push(ptNumber);
              }
            }
          }
          return out;
        } else {
          return selectedpoints;
        }
      };
      lib.getTargetArray = function(trace, transformOpts) {
        var target = transformOpts.target;
        if (typeof target === "string" && target) {
          var array = lib.nestedProperty(trace, target).get();
          return lib.isArrayOrTypedArray(array) ? array : false;
        } else if (lib.isArrayOrTypedArray(target)) {
          return target;
        }
        return false;
      };
      function minExtend(obj1, obj2, opt) {
        var objOut = {};
        if (typeof obj2 !== "object") obj2 = {};
        var arrayLen = opt === "pieLike" ? -1 : 3;
        var keys = Object.keys(obj1);
        var i, k, v;
        for (i = 0; i < keys.length; i++) {
          k = keys[i];
          v = obj1[k];
          if (k.charAt(0) === "_" || typeof v === "function") continue;
          else if (k === "module") objOut[k] = v;
          else if (Array.isArray(v)) {
            if (k === "colorscale" || arrayLen === -1) {
              objOut[k] = v.slice();
            } else {
              objOut[k] = v.slice(0, arrayLen);
            }
          } else if (lib.isTypedArray(v)) {
            if (arrayLen === -1) {
              objOut[k] = v.subarray();
            } else {
              objOut[k] = v.subarray(0, arrayLen);
            }
          } else if (v && typeof v === "object") objOut[k] = minExtend(obj1[k], obj2[k], opt);
          else objOut[k] = v;
        }
        keys = Object.keys(obj2);
        for (i = 0; i < keys.length; i++) {
          k = keys[i];
          v = obj2[k];
          if (typeof v !== "object" || !(k in objOut) || typeof objOut[k] !== "object") {
            objOut[k] = v;
          }
        }
        return objOut;
      }
      lib.minExtend = minExtend;
      lib.titleCase = function(s) {
        return s.charAt(0).toUpperCase() + s.substr(1);
      };
      lib.containsAny = function(s, fragments) {
        for (var i = 0; i < fragments.length; i++) {
          if (s.indexOf(fragments[i]) !== -1) return true;
        }
        return false;
      };
      var IS_SAFARI_REGEX = /Version\/[\d\.]+.*Safari/;
      lib.isSafari = function() {
        return IS_SAFARI_REGEX.test(window.navigator.userAgent);
      };
      var IS_IOS_REGEX = /iPad|iPhone|iPod/;
      lib.isIOS = function() {
        return IS_IOS_REGEX.test(window.navigator.userAgent);
      };
      var FIREFOX_VERSION_REGEX = /Firefox\/(\d+)\.\d+/;
      lib.getFirefoxVersion = function() {
        var match = FIREFOX_VERSION_REGEX.exec(window.navigator.userAgent);
        if (match && match.length === 2) {
          var versionInt = parseInt(match[1]);
          if (!isNaN(versionInt)) {
            return versionInt;
          }
        }
        return null;
      };
      lib.isD3Selection = function(obj) {
        return obj instanceof d3.selection;
      };
      lib.ensureSingle = function(parent, nodeType, className, enterFn) {
        var sel = parent.select(nodeType + (className ? "." + className : ""));
        if (sel.size()) return sel;
        var layer = parent.append(nodeType);
        if (className) layer.classed(className, true);
        if (enterFn) layer.call(enterFn);
        return layer;
      };
      lib.ensureSingleById = function(parent, nodeType, id, enterFn) {
        var sel = parent.select(nodeType + "#" + id);
        if (sel.size()) return sel;
        var layer = parent.append(nodeType).attr("id", id);
        if (enterFn) layer.call(enterFn);
        return layer;
      };
      lib.objectFromPath = function(path, value) {
        var keys = path.split(".");
        var tmpObj;
        var obj = tmpObj = {};
        for (var i = 0; i < keys.length; i++) {
          var key = keys[i];
          var el = null;
          var parts = keys[i].match(/(.*)\[([0-9]+)\]/);
          if (parts) {
            key = parts[1];
            el = parts[2];
            tmpObj = tmpObj[key] = [];
            if (i === keys.length - 1) {
              tmpObj[el] = value;
            } else {
              tmpObj[el] = {};
            }
            tmpObj = tmpObj[el];
          } else {
            if (i === keys.length - 1) {
              tmpObj[key] = value;
            } else {
              tmpObj[key] = {};
            }
            tmpObj = tmpObj[key];
          }
        }
        return obj;
      };
      var dottedPropertyRegex = /^([^\[\.]+)\.(.+)?/;
      var indexedPropertyRegex = /^([^\.]+)\[([0-9]+)\](\.)?(.+)?/;
      function notValid(prop) {
        return prop.slice(0, 2) === "__";
      }
      lib.expandObjectPaths = function(data) {
        var match, key, prop, datum, idx, dest, trailingPath;
        if (typeof data === "object" && !Array.isArray(data)) {
          for (key in data) {
            if (data.hasOwnProperty(key)) {
              if (match = key.match(dottedPropertyRegex)) {
                datum = data[key];
                prop = match[1];
                if (notValid(prop)) continue;
                delete data[key];
                data[prop] = lib.extendDeepNoArrays(data[prop] || {}, lib.objectFromPath(key, lib.expandObjectPaths(datum))[prop]);
              } else if (match = key.match(indexedPropertyRegex)) {
                datum = data[key];
                prop = match[1];
                if (notValid(prop)) continue;
                idx = parseInt(match[2]);
                delete data[key];
                data[prop] = data[prop] || [];
                if (match[3] === ".") {
                  trailingPath = match[4];
                  dest = data[prop][idx] = data[prop][idx] || {};
                  lib.extendDeepNoArrays(dest, lib.objectFromPath(trailingPath, lib.expandObjectPaths(datum)));
                } else {
                  if (notValid(prop)) continue;
                  data[prop][idx] = lib.expandObjectPaths(datum);
                }
              } else {
                if (notValid(key)) continue;
                data[key] = lib.expandObjectPaths(data[key]);
              }
            }
          }
        }
        return data;
      };
      lib.numSeparate = function(value, separators, separatethousands) {
        if (!separatethousands) separatethousands = false;
        if (typeof separators !== "string" || separators.length === 0) {
          throw new Error("Separator string required for formatting!");
        }
        if (typeof value === "number") {
          value = String(value);
        }
        var thousandsRe = /(\d+)(\d{3})/;
        var decimalSep = separators.charAt(0);
        var thouSep = separators.charAt(1);
        var x = value.split(".");
        var x1 = x[0];
        var x2 = x.length > 1 ? decimalSep + x[1] : "";
        if (thouSep && (x.length > 1 || x1.length > 4 || separatethousands)) {
          while (thousandsRe.test(x1)) {
            x1 = x1.replace(thousandsRe, "$1" + thouSep + "$2");
          }
        }
        return x1 + x2;
      };
      lib.TEMPLATE_STRING_REGEX = /%{([^\s%{}:]*)([:|\|][^}]*)?}/g;
      var SIMPLE_PROPERTY_REGEX = /^\w*$/;
      lib.templateString = function(string, obj) {
        var getterCache = {};
        return string.replace(lib.TEMPLATE_STRING_REGEX, function(dummy, key) {
          var v;
          if (SIMPLE_PROPERTY_REGEX.test(key)) {
            v = obj[key];
          } else {
            getterCache[key] = getterCache[key] || lib.nestedProperty(obj, key).get;
            v = getterCache[key]();
          }
          return lib.isValidTextValue(v) ? v : "";
        });
      };
      var hovertemplateWarnings = {
        max: 10,
        count: 0,
        name: "hovertemplate"
      };
      lib.hovertemplateString = function() {
        return templateFormatString.apply(hovertemplateWarnings, arguments);
      };
      var texttemplateWarnings = {
        max: 10,
        count: 0,
        name: "texttemplate"
      };
      lib.texttemplateString = function() {
        return templateFormatString.apply(texttemplateWarnings, arguments);
      };
      var MULT_DIV_REGEX = /^(\S+)([\*\/])(-?\d+(\.\d+)?)$/;
      function multDivParser(inputStr) {
        var match = inputStr.match(MULT_DIV_REGEX);
        if (match) return { key: match[1], op: match[2], number: Number(match[3]) };
        return { key: inputStr, op: null, number: null };
      }
      var texttemplateWarningsForShapes = {
        max: 10,
        count: 0,
        name: "texttemplate",
        parseMultDiv: true
      };
      lib.texttemplateStringForShapes = function() {
        return templateFormatString.apply(texttemplateWarningsForShapes, arguments);
      };
      var TEMPLATE_STRING_FORMAT_SEPARATOR = /^[:|\|]/;
      function templateFormatString(string, labels, d3locale) {
        var opts = this;
        var args = arguments;
        if (!labels) labels = {};
        var getterCache = {};
        return string.replace(lib.TEMPLATE_STRING_REGEX, function(match, rawKey, format) {
          var isOther = rawKey === "xother" || rawKey === "yother";
          var isSpaceOther = rawKey === "_xother" || rawKey === "_yother";
          var isSpaceOtherSpace = rawKey === "_xother_" || rawKey === "_yother_";
          var isOtherSpace = rawKey === "xother_" || rawKey === "yother_";
          var hasOther = isOther || isSpaceOther || isOtherSpace || isSpaceOtherSpace;
          var key = rawKey;
          if (isSpaceOther || isSpaceOtherSpace) key = key.substring(1);
          if (isOtherSpace || isSpaceOtherSpace) key = key.substring(0, key.length - 1);
          var parsedOp = null;
          var parsedNumber = null;
          if (opts.parseMultDiv) {
            var _match = multDivParser(key);
            key = _match.key;
            parsedOp = _match.op;
            parsedNumber = _match.number;
          }
          var value;
          if (hasOther) {
            value = labels[key];
            if (value === void 0) return "";
          } else {
            var obj, i;
            for (i = 3; i < args.length; i++) {
              obj = args[i];
              if (!obj) continue;
              if (obj.hasOwnProperty(key)) {
                value = obj[key];
                break;
              }
              if (!SIMPLE_PROPERTY_REGEX.test(key)) {
                value = lib.nestedProperty(obj, key).get();
                value = getterCache[key] || lib.nestedProperty(obj, key).get();
                if (value) getterCache[key] = value;
              }
              if (value !== void 0) break;
            }
          }
          if (value !== void 0) {
            if (parsedOp === "*") value *= parsedNumber;
            if (parsedOp === "/") value /= parsedNumber;
          }
          if (value === void 0 && opts) {
            if (opts.count < opts.max) {
              lib.warn("Variable '" + key + "' in " + opts.name + " could not be found!");
              value = match;
            }
            if (opts.count === opts.max) {
              lib.warn("Too many " + opts.name + " warnings - additional warnings will be suppressed");
            }
            opts.count++;
            return match;
          }
          if (format) {
            var fmt;
            if (format[0] === ":") {
              fmt = d3locale ? d3locale.numberFormat : lib.numberFormat;
              if (value !== "") {
                value = fmt(format.replace(TEMPLATE_STRING_FORMAT_SEPARATOR, ""))(value);
              }
            }
            if (format[0] === "|") {
              fmt = d3locale ? d3locale.timeFormat : utcFormat;
              var ms = lib.dateTime2ms(value);
              value = lib.formatDate(ms, format.replace(TEMPLATE_STRING_FORMAT_SEPARATOR, ""), false, fmt);
            }
          } else {
            var keyLabel = key + "Label";
            if (labels.hasOwnProperty(keyLabel)) value = labels[keyLabel];
          }
          if (hasOther) {
            value = "(" + value + ")";
            if (isSpaceOther || isSpaceOtherSpace) value = " " + value;
            if (isOtherSpace || isSpaceOtherSpace) value = value + " ";
          }
          return value;
        });
      }
      var char0 = 48;
      var char9 = 57;
      lib.subplotSort = function(a, b) {
        var l = Math.min(a.length, b.length) + 1;
        var numA = 0;
        var numB = 0;
        for (var i = 0; i < l; i++) {
          var charA = a.charCodeAt(i) || 0;
          var charB = b.charCodeAt(i) || 0;
          var isNumA = charA >= char0 && charA <= char9;
          var isNumB = charB >= char0 && charB <= char9;
          if (isNumA) numA = 10 * numA + charA - char0;
          if (isNumB) numB = 10 * numB + charB - char0;
          if (!isNumA || !isNumB) {
            if (numA !== numB) return numA - numB;
            if (charA !== charB) return charA - charB;
          }
        }
        return numB - numA;
      };
      var randSeed = 2e9;
      lib.seedPseudoRandom = function() {
        randSeed = 2e9;
      };
      lib.pseudoRandom = function() {
        var lastVal = randSeed;
        randSeed = (69069 * randSeed + 1) % 4294967296;
        if (Math.abs(randSeed - lastVal) < 429496729) return lib.pseudoRandom();
        return randSeed / 4294967296;
      };
      lib.fillText = function(calcPt, trace, contOut) {
        var fill = Array.isArray(contOut) ? function(v) {
          contOut.push(v);
        } : function(v) {
          contOut.text = v;
        };
        var htx = lib.extractOption(calcPt, trace, "htx", "hovertext");
        if (lib.isValidTextValue(htx)) return fill(htx);
        var tx = lib.extractOption(calcPt, trace, "tx", "text");
        if (lib.isValidTextValue(tx)) return fill(tx);
      };
      lib.isValidTextValue = function(v) {
        return v || v === 0;
      };
      lib.formatPercent = function(ratio, n) {
        n = n || 0;
        var str = (Math.round(100 * ratio * Math.pow(10, n)) * Math.pow(0.1, n)).toFixed(n) + "%";
        for (var i = 0; i < n; i++) {
          if (str.indexOf(".") !== -1) {
            str = str.replace("0%", "%");
            str = str.replace(".%", "%");
          }
        }
        return str;
      };
      lib.isHidden = function(gd) {
        var display = window.getComputedStyle(gd).display;
        return !display || display === "none";
      };
      lib.strTranslate = function(x, y) {
        return x || y ? "translate(" + x + "," + y + ")" : "";
      };
      lib.strRotate = function(a) {
        return a ? "rotate(" + a + ")" : "";
      };
      lib.strScale = function(s) {
        return s !== 1 ? "scale(" + s + ")" : "";
      };
      lib.getTextTransform = function(transform) {
        var noCenter = transform.noCenter;
        var textX = transform.textX;
        var textY = transform.textY;
        var targetX = transform.targetX;
        var targetY = transform.targetY;
        var anchorX = transform.anchorX || 0;
        var anchorY = transform.anchorY || 0;
        var rotate = transform.rotate;
        var scale = transform.scale;
        if (!scale) scale = 0;
        else if (scale > 1) scale = 1;
        return lib.strTranslate(
          targetX - scale * (textX + anchorX),
          targetY - scale * (textY + anchorY)
        ) + lib.strScale(scale) + (rotate ? "rotate(" + rotate + (noCenter ? "" : " " + textX + " " + textY) + ")" : "");
      };
      lib.setTransormAndDisplay = function(s, transform) {
        s.attr("transform", lib.getTextTransform(transform));
        s.style("display", transform.scale ? null : "none");
      };
      lib.ensureUniformFontSize = function(gd, baseFont) {
        var out = lib.extendFlat({}, baseFont);
        out.size = Math.max(
          baseFont.size,
          gd._fullLayout.uniformtext.minsize || 0
        );
        return out;
      };
      lib.join2 = function(arr, mainSeparator, lastSeparator) {
        var len = arr.length;
        if (len > 1) {
          return arr.slice(0, -1).join(mainSeparator) + lastSeparator + arr[len - 1];
        }
        return arr.join(mainSeparator);
      };
      lib.bigFont = function(size) {
        return Math.round(1.2 * size);
      };
      var firefoxVersion = lib.getFirefoxVersion();
      var isProblematicFirefox = firefoxVersion !== null && firefoxVersion < 86;
      lib.getPositionFromD3Event = function() {
        if (isProblematicFirefox) {
          return [
            d3.event.layerX,
            d3.event.layerY
          ];
        } else {
          return [
            d3.event.offsetX,
            d3.event.offsetY
          ];
        }
      };
    }
  });

  // build/plotcss.js
  var require_plotcss = __commonJS({
    "build/plotcss.js"() {
      "use strict";
      var Lib = require_lib();
      var rules = {
        "X,X div": 'direction:ltr;font-family:"Open Sans",verdana,arial,sans-serif;margin:0;padding:0;',
        "X input,X button": 'font-family:"Open Sans",verdana,arial,sans-serif;',
        "X input:focus,X button:focus": "outline:none;",
        "X a": "text-decoration:none;",
        "X a:hover": "text-decoration:none;",
        "X .crisp": "shape-rendering:crispEdges;",
        "X .user-select-none": "-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;-o-user-select:none;user-select:none;",
        "X svg a": "fill:#447adb;",
        "X svg a:hover": "fill:#3c6dc5;",
        "X .main-svg": "position:absolute;top:0;left:0;pointer-events:none;",
        "X .main-svg .draglayer": "pointer-events:all;",
        "X .cursor-default": "cursor:default;",
        "X .cursor-pointer": "cursor:pointer;",
        "X .cursor-crosshair": "cursor:crosshair;",
        "X .cursor-move": "cursor:move;",
        "X .cursor-col-resize": "cursor:col-resize;",
        "X .cursor-row-resize": "cursor:row-resize;",
        "X .cursor-ns-resize": "cursor:ns-resize;",
        "X .cursor-ew-resize": "cursor:ew-resize;",
        "X .cursor-sw-resize": "cursor:sw-resize;",
        "X .cursor-s-resize": "cursor:s-resize;",
        "X .cursor-se-resize": "cursor:se-resize;",
        "X .cursor-w-resize": "cursor:w-resize;",
        "X .cursor-e-resize": "cursor:e-resize;",
        "X .cursor-nw-resize": "cursor:nw-resize;",
        "X .cursor-n-resize": "cursor:n-resize;",
        "X .cursor-ne-resize": "cursor:ne-resize;",
        "X .cursor-grab": "cursor:-webkit-grab;cursor:grab;",
        "X .modebar": "position:absolute;top:2px;right:2px;",
        "X .ease-bg": "-webkit-transition:background-color .3s ease 0s;-moz-transition:background-color .3s ease 0s;-ms-transition:background-color .3s ease 0s;-o-transition:background-color .3s ease 0s;transition:background-color .3s ease 0s;",
        "X .modebar--hover>:not(.watermark)": "opacity:0;-webkit-transition:opacity .3s ease 0s;-moz-transition:opacity .3s ease 0s;-ms-transition:opacity .3s ease 0s;-o-transition:opacity .3s ease 0s;transition:opacity .3s ease 0s;",
        "X:hover .modebar--hover .modebar-group": "opacity:1;",
        "X .modebar-group": "float:left;display:inline-block;box-sizing:border-box;padding-left:8px;position:relative;vertical-align:middle;white-space:nowrap;",
        "X .modebar-btn": "position:relative;font-size:16px;padding:3px 4px;height:22px;cursor:pointer;line-height:normal;box-sizing:border-box;",
        "X .modebar-btn svg": "position:relative;top:2px;",
        "X .modebar.vertical": "display:flex;flex-direction:column;flex-wrap:wrap;align-content:flex-end;max-height:100%;",
        "X .modebar.vertical svg": "top:-1px;",
        "X .modebar.vertical .modebar-group": "display:block;float:none;padding-left:0px;padding-bottom:8px;",
        "X .modebar.vertical .modebar-group .modebar-btn": "display:block;text-align:center;",
        "X [data-title]:before,X [data-title]:after": "position:absolute;-webkit-transform:translate3d(0, 0, 0);-moz-transform:translate3d(0, 0, 0);-ms-transform:translate3d(0, 0, 0);-o-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);display:none;opacity:0;z-index:1001;pointer-events:none;top:110%;right:50%;",
        "X [data-title]:hover:before,X [data-title]:hover:after": "display:block;opacity:1;",
        "X [data-title]:before": 'content:"";position:absolute;background:rgba(0,0,0,0);border:6px solid rgba(0,0,0,0);z-index:1002;margin-top:-12px;border-bottom-color:#69738a;margin-right:-6px;',
        "X [data-title]:after": "content:attr(data-title);background:#69738a;color:#fff;padding:8px 10px;font-size:12px;line-height:12px;white-space:nowrap;margin-right:-18px;border-radius:2px;",
        "X .vertical [data-title]:before,X .vertical [data-title]:after": "top:0%;right:200%;",
        "X .vertical [data-title]:before": "border:6px solid rgba(0,0,0,0);border-left-color:#69738a;margin-top:8px;margin-right:-30px;",
        Y: 'font-family:"Open Sans",verdana,arial,sans-serif;position:fixed;top:50px;right:20px;z-index:10000;font-size:10pt;max-width:180px;',
        "Y p": "margin:0;",
        "Y .notifier-note": "min-width:180px;max-width:250px;border:1px solid #fff;z-index:3000;margin:0;background-color:#8c97af;background-color:rgba(140,151,175,.9);color:#fff;padding:10px;overflow-wrap:break-word;word-wrap:break-word;-ms-hyphens:auto;-webkit-hyphens:auto;hyphens:auto;",
        "Y .notifier-close": "color:#fff;opacity:.8;float:right;padding:0 5px;background:none;border:none;font-size:20px;font-weight:bold;line-height:20px;",
        "Y .notifier-close:hover": "color:#444;text-decoration:none;cursor:pointer;"
      };
      for (selector in rules) {
        fullSelector = selector.replace(/^,/, " ,").replace(/X/g, ".js-plotly-plot .plotly").replace(/Y/g, ".plotly-notifier");
        Lib.addStyleRule(fullSelector, rules[selector]);
      }
      var fullSelector;
      var selector;
    }
  });

  // node_modules/is-browser/client.js
  var require_client = __commonJS({
    "node_modules/is-browser/client.js"(exports, module) {
      module.exports = true;
    }
  });

  // node_modules/has-hover/index.js
  var require_has_hover = __commonJS({
    "node_modules/has-hover/index.js"(exports, module) {
      "use strict";
      var isBrowser = require_client();
      var hasHover;
      if (typeof window.matchMedia === "function") {
        hasHover = !window.matchMedia("(hover: none)").matches;
      } else {
        hasHover = isBrowser;
      }
      module.exports = hasHover;
    }
  });

  // node_modules/events/events.js
  var require_events = __commonJS({
    "node_modules/events/events.js"(exports, module) {
      "use strict";
      var R = typeof Reflect === "object" ? Reflect : null;
      var ReflectApply = R && typeof R.apply === "function" ? R.apply : function ReflectApply2(target, receiver, args) {
        return Function.prototype.apply.call(target, receiver, args);
      };
      var ReflectOwnKeys;
      if (R && typeof R.ownKeys === "function") {
        ReflectOwnKeys = R.ownKeys;
      } else if (Object.getOwnPropertySymbols) {
        ReflectOwnKeys = function ReflectOwnKeys2(target) {
          return Object.getOwnPropertyNames(target).concat(Object.getOwnPropertySymbols(target));
        };
      } else {
        ReflectOwnKeys = function ReflectOwnKeys2(target) {
          return Object.getOwnPropertyNames(target);
        };
      }
      function ProcessEmitWarning(warning) {
        if (console && console.warn) console.warn(warning);
      }
      var NumberIsNaN = Number.isNaN || function NumberIsNaN2(value) {
        return value !== value;
      };
      function EventEmitter() {
        EventEmitter.init.call(this);
      }
      module.exports = EventEmitter;
      module.exports.once = once;
      EventEmitter.EventEmitter = EventEmitter;
      EventEmitter.prototype._events = void 0;
      EventEmitter.prototype._eventsCount = 0;
      EventEmitter.prototype._maxListeners = void 0;
      var defaultMaxListeners = 10;
      function checkListener(listener) {
        if (typeof listener !== "function") {
          throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
        }
      }
      Object.defineProperty(EventEmitter, "defaultMaxListeners", {
        enumerable: true,
        get: function() {
          return defaultMaxListeners;
        },
        set: function(arg) {
          if (typeof arg !== "number" || arg < 0 || NumberIsNaN(arg)) {
            throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + ".");
          }
          defaultMaxListeners = arg;
        }
      });
      EventEmitter.init = function() {
        if (this._events === void 0 || this._events === Object.getPrototypeOf(this)._events) {
          this._events = /* @__PURE__ */ Object.create(null);
          this._eventsCount = 0;
        }
        this._maxListeners = this._maxListeners || void 0;
      };
      EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
        if (typeof n !== "number" || n < 0 || NumberIsNaN(n)) {
          throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + ".");
        }
        this._maxListeners = n;
        return this;
      };
      function _getMaxListeners(that) {
        if (that._maxListeners === void 0)
          return EventEmitter.defaultMaxListeners;
        return that._maxListeners;
      }
      EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
        return _getMaxListeners(this);
      };
      EventEmitter.prototype.emit = function emit(type) {
        var args = [];
        for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
        var doError = type === "error";
        var events = this._events;
        if (events !== void 0)
          doError = doError && events.error === void 0;
        else if (!doError)
          return false;
        if (doError) {
          var er;
          if (args.length > 0)
            er = args[0];
          if (er instanceof Error) {
            throw er;
          }
          var err = new Error("Unhandled error." + (er ? " (" + er.message + ")" : ""));
          err.context = er;
          throw err;
        }
        var handler = events[type];
        if (handler === void 0)
          return false;
        if (typeof handler === "function") {
          ReflectApply(handler, this, args);
        } else {
          var len = handler.length;
          var listeners = arrayClone(handler, len);
          for (var i = 0; i < len; ++i)
            ReflectApply(listeners[i], this, args);
        }
        return true;
      };
      function _addListener(target, type, listener, prepend) {
        var m;
        var events;
        var existing;
        checkListener(listener);
        events = target._events;
        if (events === void 0) {
          events = target._events = /* @__PURE__ */ Object.create(null);
          target._eventsCount = 0;
        } else {
          if (events.newListener !== void 0) {
            target.emit(
              "newListener",
              type,
              listener.listener ? listener.listener : listener
            );
            events = target._events;
          }
          existing = events[type];
        }
        if (existing === void 0) {
          existing = events[type] = listener;
          ++target._eventsCount;
        } else {
          if (typeof existing === "function") {
            existing = events[type] = prepend ? [listener, existing] : [existing, listener];
          } else if (prepend) {
            existing.unshift(listener);
          } else {
            existing.push(listener);
          }
          m = _getMaxListeners(target);
          if (m > 0 && existing.length > m && !existing.warned) {
            existing.warned = true;
            var w = new Error("Possible EventEmitter memory leak detected. " + existing.length + " " + String(type) + " listeners added. Use emitter.setMaxListeners() to increase limit");
            w.name = "MaxListenersExceededWarning";
            w.emitter = target;
            w.type = type;
            w.count = existing.length;
            ProcessEmitWarning(w);
          }
        }
        return target;
      }
      EventEmitter.prototype.addListener = function addListener(type, listener) {
        return _addListener(this, type, listener, false);
      };
      EventEmitter.prototype.on = EventEmitter.prototype.addListener;
      EventEmitter.prototype.prependListener = function prependListener(type, listener) {
        return _addListener(this, type, listener, true);
      };
      function onceWrapper() {
        if (!this.fired) {
          this.target.removeListener(this.type, this.wrapFn);
          this.fired = true;
          if (arguments.length === 0)
            return this.listener.call(this.target);
          return this.listener.apply(this.target, arguments);
        }
      }
      function _onceWrap(target, type, listener) {
        var state = { fired: false, wrapFn: void 0, target, type, listener };
        var wrapped = onceWrapper.bind(state);
        wrapped.listener = listener;
        state.wrapFn = wrapped;
        return wrapped;
      }
      EventEmitter.prototype.once = function once2(type, listener) {
        checkListener(listener);
        this.on(type, _onceWrap(this, type, listener));
        return this;
      };
      EventEmitter.prototype.prependOnceListener = function prependOnceListener(type, listener) {
        checkListener(listener);
        this.prependListener(type, _onceWrap(this, type, listener));
        return this;
      };
      EventEmitter.prototype.removeListener = function removeListener(type, listener) {
        var list, events, position, i, originalListener;
        checkListener(listener);
        events = this._events;
        if (events === void 0)
          return this;
        list = events[type];
        if (list === void 0)
          return this;
        if (list === listener || list.listener === listener) {
          if (--this._eventsCount === 0)
            this._events = /* @__PURE__ */ Object.create(null);
          else {
            delete events[type];
            if (events.removeListener)
              this.emit("removeListener", type, list.listener || listener);
          }
        } else if (typeof list !== "function") {
          position = -1;
          for (i = list.length - 1; i >= 0; i--) {
            if (list[i] === listener || list[i].listener === listener) {
              originalListener = list[i].listener;
              position = i;
              break;
            }
          }
          if (position < 0)
            return this;
          if (position === 0)
            list.shift();
          else {
            spliceOne(list, position);
          }
          if (list.length === 1)
            events[type] = list[0];
          if (events.removeListener !== void 0)
            this.emit("removeListener", type, originalListener || listener);
        }
        return this;
      };
      EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
      EventEmitter.prototype.removeAllListeners = function removeAllListeners(type) {
        var listeners, events, i;
        events = this._events;
        if (events === void 0)
          return this;
        if (events.removeListener === void 0) {
          if (arguments.length === 0) {
            this._events = /* @__PURE__ */ Object.create(null);
            this._eventsCount = 0;
          } else if (events[type] !== void 0) {
            if (--this._eventsCount === 0)
              this._events = /* @__PURE__ */ Object.create(null);
            else
              delete events[type];
          }
          return this;
        }
        if (arguments.length === 0) {
          var keys = Object.keys(events);
          var key;
          for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (key === "removeListener") continue;
            this.removeAllListeners(key);
          }
          this.removeAllListeners("removeListener");
          this._events = /* @__PURE__ */ Object.create(null);
          this._eventsCount = 0;
          return this;
        }
        listeners = events[type];
        if (typeof listeners === "function") {
          this.removeListener(type, listeners);
        } else if (listeners !== void 0) {
          for (i = listeners.length - 1; i >= 0; i--) {
            this.removeListener(type, listeners[i]);
          }
        }
        return this;
      };
      function _listeners(target, type, unwrap) {
        var events = target._events;
        if (events === void 0)
          return [];
        var evlistener = events[type];
        if (evlistener === void 0)
          return [];
        if (typeof evlistener === "function")
          return unwrap ? [evlistener.listener || evlistener] : [evlistener];
        return unwrap ? unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
      }
      EventEmitter.prototype.listeners = function listeners(type) {
        return _listeners(this, type, true);
      };
      EventEmitter.prototype.rawListeners = function rawListeners(type) {
        return _listeners(this, type, false);
      };
      EventEmitter.listenerCount = function(emitter, type) {
        if (typeof emitter.listenerCount === "function") {
          return emitter.listenerCount(type);
        } else {
          return listenerCount.call(emitter, type);
        }
      };
      EventEmitter.prototype.listenerCount = listenerCount;
      function listenerCount(type) {
        var events = this._events;
        if (events !== void 0) {
          var evlistener = events[type];
          if (typeof evlistener === "function") {
            return 1;
          } else if (evlistener !== void 0) {
            return evlistener.length;
          }
        }
        return 0;
      }
      EventEmitter.prototype.eventNames = function eventNames() {
        return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
      };
      function arrayClone(arr, n) {
        var copy = new Array(n);
        for (var i = 0; i < n; ++i)
          copy[i] = arr[i];
        return copy;
      }
      function spliceOne(list, index) {
        for (; index + 1 < list.length; index++)
          list[index] = list[index + 1];
        list.pop();
      }
      function unwrapListeners(arr) {
        var ret = new Array(arr.length);
        for (var i = 0; i < ret.length; ++i) {
          ret[i] = arr[i].listener || arr[i];
        }
        return ret;
      }
      function once(emitter, name2) {
        return new Promise(function(resolve, reject) {
          function errorListener(err) {
            emitter.removeListener(name2, resolver);
            reject(err);
          }
          function resolver() {
            if (typeof emitter.removeListener === "function") {
              emitter.removeListener("error", errorListener);
            }
            resolve([].slice.call(arguments));
          }
          ;
          eventTargetAgnosticAddListener(emitter, name2, resolver, { once: true });
          if (name2 !== "error") {
            addErrorHandlerIfEventEmitter(emitter, errorListener, { once: true });
          }
        });
      }
      function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
        if (typeof emitter.on === "function") {
          eventTargetAgnosticAddListener(emitter, "error", handler, flags);
        }
      }
      function eventTargetAgnosticAddListener(emitter, name2, listener, flags) {
        if (typeof emitter.on === "function") {
          if (flags.once) {
            emitter.once(name2, listener);
          } else {
            emitter.on(name2, listener);
          }
        } else if (typeof emitter.addEventListener === "function") {
          emitter.addEventListener(name2, function wrapListener(arg) {
            if (flags.once) {
              emitter.removeEventListener(name2, wrapListener);
            }
            listener(arg);
          });
        } else {
          throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof emitter);
        }
      }
    }
  });

  // src/lib/events.js
  var require_events2 = __commonJS({
    "src/lib/events.js"(exports, module) {
      "use strict";
      var EventEmitter = require_events().EventEmitter;
      var Events = {
        init: function(plotObj) {
          if (plotObj._ev instanceof EventEmitter) return plotObj;
          var ev = new EventEmitter();
          var internalEv = new EventEmitter();
          plotObj._ev = ev;
          plotObj._internalEv = internalEv;
          plotObj.on = ev.on.bind(ev);
          plotObj.once = ev.once.bind(ev);
          plotObj.removeListener = ev.removeListener.bind(ev);
          plotObj.removeAllListeners = ev.removeAllListeners.bind(ev);
          plotObj._internalOn = internalEv.on.bind(internalEv);
          plotObj._internalOnce = internalEv.once.bind(internalEv);
          plotObj._removeInternalListener = internalEv.removeListener.bind(internalEv);
          plotObj._removeAllInternalListeners = internalEv.removeAllListeners.bind(internalEv);
          plotObj.emit = function(event, data) {
            ev.emit(event, data);
            internalEv.emit(event, data);
          };
          return plotObj;
        },
        /*
         * This function behaves like jQuery's triggerHandler. It calls
         * all handlers for a particular event and returns the return value
         * of the LAST handler.
         */
        triggerHandler: function(plotObj, event, data) {
          var nodeEventHandlerValue;
          var ev = plotObj._ev;
          if (!ev) return;
          var handlers = ev._events[event];
          if (!handlers) return;
          function apply(handler) {
            if (handler.listener) {
              ev.removeListener(event, handler.listener);
              if (!handler.fired) {
                handler.fired = true;
                return handler.listener.apply(ev, [data]);
              }
            } else {
              return handler.apply(ev, [data]);
            }
          }
          handlers = Array.isArray(handlers) ? handlers : [handlers];
          var i;
          for (i = 0; i < handlers.length - 1; i++) {
            apply(handlers[i]);
          }
          nodeEventHandlerValue = apply(handlers[i]);
          return nodeEventHandlerValue;
        },
        purge: function(plotObj) {
          delete plotObj._ev;
          delete plotObj.on;
          delete plotObj.once;
          delete plotObj.removeListener;
          delete plotObj.removeAllListeners;
          delete plotObj.emit;
          delete plotObj._ev;
          delete plotObj._internalEv;
          delete plotObj._internalOn;
          delete plotObj._internalOnce;
          delete plotObj._removeInternalListener;
          delete plotObj._removeAllInternalListeners;
          return plotObj;
        }
      };
      module.exports = Events;
    }
  });

  // src/lib/queue.js
  var require_queue = __commonJS({
    "src/lib/queue.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      var dfltConfig = require_plot_config().dfltConfig;
      function copyArgArray(gd, args) {
        var copy = [];
        var arg;
        for (var i = 0; i < args.length; i++) {
          arg = args[i];
          if (arg === gd) copy[i] = arg;
          else if (typeof arg === "object") {
            copy[i] = Array.isArray(arg) ? Lib.extendDeep([], arg) : Lib.extendDeepAll({}, arg);
          } else copy[i] = arg;
        }
        return copy;
      }
      var queue = {};
      queue.add = function(gd, undoFunc, undoArgs, redoFunc, redoArgs) {
        var queueObj, queueIndex;
        gd.undoQueue = gd.undoQueue || { index: 0, queue: [], sequence: false };
        queueIndex = gd.undoQueue.index;
        if (gd.autoplay) {
          if (!gd.undoQueue.inSequence) gd.autoplay = false;
          return;
        }
        if (!gd.undoQueue.sequence || gd.undoQueue.beginSequence) {
          queueObj = { undo: { calls: [], args: [] }, redo: { calls: [], args: [] } };
          gd.undoQueue.queue.splice(queueIndex, gd.undoQueue.queue.length - queueIndex, queueObj);
          gd.undoQueue.index += 1;
        } else {
          queueObj = gd.undoQueue.queue[queueIndex - 1];
        }
        gd.undoQueue.beginSequence = false;
        if (queueObj) {
          queueObj.undo.calls.unshift(undoFunc);
          queueObj.undo.args.unshift(undoArgs);
          queueObj.redo.calls.push(redoFunc);
          queueObj.redo.args.push(redoArgs);
        }
        if (gd.undoQueue.queue.length > dfltConfig.queueLength) {
          gd.undoQueue.queue.shift();
          gd.undoQueue.index--;
        }
      };
      queue.startSequence = function(gd) {
        gd.undoQueue = gd.undoQueue || { index: 0, queue: [], sequence: false };
        gd.undoQueue.sequence = true;
        gd.undoQueue.beginSequence = true;
      };
      queue.stopSequence = function(gd) {
        gd.undoQueue = gd.undoQueue || { index: 0, queue: [], sequence: false };
        gd.undoQueue.sequence = false;
        gd.undoQueue.beginSequence = false;
      };
      queue.undo = function undo(gd) {
        var queueObj, i;
        if (gd.undoQueue === void 0 || isNaN(gd.undoQueue.index) || gd.undoQueue.index <= 0) {
          return;
        }
        gd.undoQueue.index--;
        queueObj = gd.undoQueue.queue[gd.undoQueue.index];
        gd.undoQueue.inSequence = true;
        for (i = 0; i < queueObj.undo.calls.length; i++) {
          queue.plotDo(gd, queueObj.undo.calls[i], queueObj.undo.args[i]);
        }
        gd.undoQueue.inSequence = false;
        gd.autoplay = false;
      };
      queue.redo = function redo(gd) {
        var queueObj, i;
        if (gd.undoQueue === void 0 || isNaN(gd.undoQueue.index) || gd.undoQueue.index >= gd.undoQueue.queue.length) {
          return;
        }
        queueObj = gd.undoQueue.queue[gd.undoQueue.index];
        gd.undoQueue.inSequence = true;
        for (i = 0; i < queueObj.redo.calls.length; i++) {
          queue.plotDo(gd, queueObj.redo.calls[i], queueObj.redo.args[i]);
        }
        gd.undoQueue.inSequence = false;
        gd.autoplay = false;
        gd.undoQueue.index++;
      };
      queue.plotDo = function(gd, func, args) {
        gd.autoplay = true;
        args = copyArgArray(gd, args);
        func.apply(null, args);
      };
      module.exports = queue;
    }
  });

  // src/plots/frame_attributes.js
  var require_frame_attributes = __commonJS({
    "src/plots/frame_attributes.js"(exports, module) {
      "use strict";
      module.exports = {
        _isLinkedToArray: "frames_entry",
        group: {
          valType: "string"
        },
        name: {
          valType: "string"
        },
        traces: {
          valType: "any"
        },
        baseframe: {
          valType: "string"
        },
        data: {
          valType: "any"
        },
        layout: {
          valType: "any"
        }
      };
    }
  });

  // src/plot_api/plot_schema.js
  var require_plot_schema = __commonJS({
    "src/plot_api/plot_schema.js"(exports) {
      "use strict";
      var Registry = require_registry();
      var Lib = require_lib();
      var baseAttributes = require_attributes2();
      var baseLayoutAttributes = require_layout_attributes2();
      var frameAttributes = require_frame_attributes();
      var animationAttributes = require_animation_attributes();
      var configAttributes = require_plot_config().configAttributes;
      var editTypes = require_edit_types();
      var extendDeepAll = Lib.extendDeepAll;
      var isPlainObject = Lib.isPlainObject;
      var isArrayOrTypedArray = Lib.isArrayOrTypedArray;
      var nestedProperty = Lib.nestedProperty;
      var valObjectMeta = Lib.valObjectMeta;
      var IS_SUBPLOT_OBJ = "_isSubplotObj";
      var IS_LINKED_TO_ARRAY = "_isLinkedToArray";
      var ARRAY_ATTR_REGEXPS = "_arrayAttrRegexps";
      var DEPRECATED = "_deprecated";
      var UNDERSCORE_ATTRS = [IS_SUBPLOT_OBJ, IS_LINKED_TO_ARRAY, ARRAY_ATTR_REGEXPS, DEPRECATED];
      exports.IS_SUBPLOT_OBJ = IS_SUBPLOT_OBJ;
      exports.IS_LINKED_TO_ARRAY = IS_LINKED_TO_ARRAY;
      exports.DEPRECATED = DEPRECATED;
      exports.UNDERSCORE_ATTRS = UNDERSCORE_ATTRS;
      exports.get = function() {
        var traces = {};
        Registry.allTypes.forEach(function(type) {
          traces[type] = getTraceAttributes(type);
        });
        return {
          defs: {
            valObjects: valObjectMeta,
            metaKeys: UNDERSCORE_ATTRS.concat(["description", "role", "editType", "impliedEdits"]),
            editType: {
              traces: editTypes.traces,
              layout: editTypes.layout
            },
            impliedEdits: {}
          },
          traces,
          layout: getLayoutAttributes(),
          frames: getFramesAttributes(),
          animation: formatAttributes(animationAttributes),
          config: formatAttributes(configAttributes)
        };
      };
      exports.crawl = function(attrs, callback, specifiedLevel, attrString) {
        var level = specifiedLevel || 0;
        attrString = attrString || "";
        Object.keys(attrs).forEach(function(attrName) {
          var attr = attrs[attrName];
          if (UNDERSCORE_ATTRS.indexOf(attrName) !== -1) return;
          var fullAttrString = (attrString ? attrString + "." : "") + attrName;
          callback(attr, attrName, attrs, level, fullAttrString);
          if (exports.isValObject(attr)) return;
          if (isPlainObject(attr) && attrName !== "impliedEdits") {
            exports.crawl(attr, callback, level + 1, fullAttrString);
          }
        });
      };
      exports.isValObject = function(obj) {
        return obj && obj.valType !== void 0;
      };
      exports.findArrayAttributes = function(trace) {
        var arrayAttributes = [];
        var stack = [];
        var isArrayStack = [];
        var baseContainer, baseAttrName;
        function callback(attr, attrName, attrs, level) {
          stack = stack.slice(0, level).concat([attrName]);
          isArrayStack = isArrayStack.slice(0, level).concat([attr && attr._isLinkedToArray]);
          var splittableAttr = attr && (attr.valType === "data_array" || attr.arrayOk === true) && !(stack[level - 1] === "colorbar" && (attrName === "ticktext" || attrName === "tickvals"));
          if (!splittableAttr) return;
          crawlIntoTrace(baseContainer, 0, "");
        }
        function crawlIntoTrace(container, i, astrPartial) {
          var item = container[stack[i]];
          var newAstrPartial = astrPartial + stack[i];
          if (i === stack.length - 1) {
            if (isArrayOrTypedArray(item)) {
              arrayAttributes.push(baseAttrName + newAstrPartial);
            }
          } else {
            if (isArrayStack[i]) {
              if (Array.isArray(item)) {
                for (var j = 0; j < item.length; j++) {
                  if (isPlainObject(item[j])) {
                    crawlIntoTrace(item[j], i + 1, newAstrPartial + "[" + j + "].");
                  }
                }
              }
            } else if (isPlainObject(item)) {
              crawlIntoTrace(item, i + 1, newAstrPartial + ".");
            }
          }
        }
        baseContainer = trace;
        baseAttrName = "";
        exports.crawl(baseAttributes, callback);
        if (trace._module && trace._module.attributes) {
          exports.crawl(trace._module.attributes, callback);
        }
        return arrayAttributes;
      };
      exports.getTraceValObject = function(trace, parts) {
        var head = parts[0];
        var i = 1;
        var moduleAttrs, valObject;
        var _module = trace._module;
        if (!_module) _module = (Registry.modules[trace.type || baseAttributes.type.dflt] || {})._module;
        if (!_module) return false;
        moduleAttrs = _module.attributes;
        valObject = moduleAttrs && moduleAttrs[head];
        if (!valObject) {
          var subplotModule = _module.basePlotModule;
          if (subplotModule && subplotModule.attributes) {
            valObject = subplotModule.attributes[head];
          }
        }
        if (!valObject) valObject = baseAttributes[head];
        return recurseIntoValObject(valObject, parts, i);
      };
      exports.getLayoutValObject = function(fullLayout, parts) {
        var valObject = layoutHeadAttr(fullLayout, parts[0]);
        return recurseIntoValObject(valObject, parts, 1);
      };
      function layoutHeadAttr(fullLayout, head) {
        var i, key, _module, attributes;
        var basePlotModules = fullLayout._basePlotModules;
        if (basePlotModules) {
          var out;
          for (i = 0; i < basePlotModules.length; i++) {
            _module = basePlotModules[i];
            if (_module.attrRegex && _module.attrRegex.test(head)) {
              if (_module.layoutAttrOverrides) return _module.layoutAttrOverrides;
              if (!out && _module.layoutAttributes) out = _module.layoutAttributes;
            }
            var baseOverrides = _module.baseLayoutAttrOverrides;
            if (baseOverrides && head in baseOverrides) return baseOverrides[head];
          }
          if (out) return out;
        }
        var modules = fullLayout._modules;
        if (modules) {
          for (i = 0; i < modules.length; i++) {
            attributes = modules[i].layoutAttributes;
            if (attributes && head in attributes) {
              return attributes[head];
            }
          }
        }
        for (key in Registry.componentsRegistry) {
          _module = Registry.componentsRegistry[key];
          if (_module.name === "colorscale" && head.indexOf("coloraxis") === 0) {
            return _module.layoutAttributes[head];
          } else if (!_module.schema && head === _module.name) {
            return _module.layoutAttributes;
          }
        }
        if (head in baseLayoutAttributes) return baseLayoutAttributes[head];
        return false;
      }
      function recurseIntoValObject(valObject, parts, i) {
        if (!valObject) return false;
        if (valObject._isLinkedToArray) {
          if (isIndex(parts[i])) i++;
          else if (i < parts.length) return false;
        }
        for (; i < parts.length; i++) {
          var newValObject = valObject[parts[i]];
          if (isPlainObject(newValObject)) valObject = newValObject;
          else break;
          if (i === parts.length - 1) break;
          if (valObject._isLinkedToArray) {
            i++;
            if (!isIndex(parts[i])) return false;
          } else if (valObject.valType === "info_array") {
            i++;
            var index = parts[i];
            if (!isIndex(index)) return false;
            var items = valObject.items;
            if (Array.isArray(items)) {
              if (index >= items.length) return false;
              if (valObject.dimensions === 2) {
                i++;
                if (parts.length === i) return valObject;
                var index2 = parts[i];
                if (!isIndex(index2)) return false;
                valObject = items[index][index2];
              } else valObject = items[index];
            } else {
              valObject = items;
            }
          }
        }
        return valObject;
      }
      function isIndex(val) {
        return val === Math.round(val) && val >= 0;
      }
      function getTraceAttributes(type) {
        var _module, basePlotModule;
        _module = Registry.modules[type]._module, basePlotModule = _module.basePlotModule;
        var attributes = {};
        attributes.type = null;
        var copyBaseAttributes = extendDeepAll({}, baseAttributes);
        var copyModuleAttributes = extendDeepAll({}, _module.attributes);
        exports.crawl(copyModuleAttributes, function(attr, attrName, attrs, level, fullAttrString) {
          nestedProperty(copyBaseAttributes, fullAttrString).set(void 0);
          if (attr === void 0) nestedProperty(copyModuleAttributes, fullAttrString).set(void 0);
        });
        extendDeepAll(attributes, copyBaseAttributes);
        if (Registry.traceIs(type, "noOpacity")) {
          delete attributes.opacity;
        }
        if (!Registry.traceIs(type, "showLegend")) {
          delete attributes.showlegend;
          delete attributes.legendgroup;
        }
        if (Registry.traceIs(type, "noHover")) {
          delete attributes.hoverinfo;
          delete attributes.hoverlabel;
        }
        if (!_module.selectPoints) {
          delete attributes.selectedpoints;
        }
        extendDeepAll(attributes, copyModuleAttributes);
        if (basePlotModule.attributes) {
          extendDeepAll(attributes, basePlotModule.attributes);
        }
        attributes.type = type;
        var out = {
          meta: _module.meta || {},
          categories: _module.categories || {},
          animatable: Boolean(_module.animatable),
          type,
          attributes: formatAttributes(attributes)
        };
        if (_module.layoutAttributes) {
          var layoutAttributes = {};
          extendDeepAll(layoutAttributes, _module.layoutAttributes);
          out.layoutAttributes = formatAttributes(layoutAttributes);
        }
        if (!_module.animatable) {
          exports.crawl(out, function(attr) {
            if (exports.isValObject(attr) && "anim" in attr) {
              delete attr.anim;
            }
          });
        }
        return out;
      }
      function getLayoutAttributes() {
        var layoutAttributes = {};
        var key, _module;
        extendDeepAll(layoutAttributes, baseLayoutAttributes);
        for (key in Registry.subplotsRegistry) {
          _module = Registry.subplotsRegistry[key];
          if (!_module.layoutAttributes) continue;
          if (Array.isArray(_module.attr)) {
            for (var i = 0; i < _module.attr.length; i++) {
              handleBasePlotModule(layoutAttributes, _module, _module.attr[i]);
            }
          } else {
            var astr = _module.attr === "subplot" ? _module.name : _module.attr;
            handleBasePlotModule(layoutAttributes, _module, astr);
          }
        }
        for (key in Registry.componentsRegistry) {
          _module = Registry.componentsRegistry[key];
          var schema = _module.schema;
          if (schema && (schema.subplots || schema.layout)) {
            var subplots = schema.subplots;
            if (subplots && subplots.xaxis && !subplots.yaxis) {
              for (var xkey in subplots.xaxis) {
                delete layoutAttributes.yaxis[xkey];
              }
            }
            delete layoutAttributes.xaxis.shift;
            delete layoutAttributes.xaxis.autoshift;
          } else if (_module.name === "colorscale") {
            extendDeepAll(layoutAttributes, _module.layoutAttributes);
          } else if (_module.layoutAttributes) {
            insertAttrs(layoutAttributes, _module.layoutAttributes, _module.name);
          }
        }
        return {
          layoutAttributes: formatAttributes(layoutAttributes)
        };
      }
      function getFramesAttributes() {
        var attrs = {
          frames: extendDeepAll({}, frameAttributes)
        };
        formatAttributes(attrs);
        return attrs.frames;
      }
      function formatAttributes(attrs) {
        mergeValTypeAndRole(attrs);
        formatArrayContainers(attrs);
        stringify(attrs);
        return attrs;
      }
      function mergeValTypeAndRole(attrs) {
        function makeSrcAttr(attrName) {
          return {
            valType: "string",
            editType: "none"
          };
        }
        function callback(attr, attrName, attrs2) {
          if (exports.isValObject(attr)) {
            if (attr.arrayOk === true || attr.valType === "data_array") {
              attrs2[attrName + "src"] = makeSrcAttr(attrName);
            }
          } else if (isPlainObject(attr)) {
            attr.role = "object";
          }
        }
        exports.crawl(attrs, callback);
      }
      function formatArrayContainers(attrs) {
        function callback(attr, attrName, attrs2) {
          if (!attr) return;
          var itemName = attr[IS_LINKED_TO_ARRAY];
          if (!itemName) return;
          delete attr[IS_LINKED_TO_ARRAY];
          attrs2[attrName] = { items: {} };
          attrs2[attrName].items[itemName] = attr;
          attrs2[attrName].role = "object";
        }
        exports.crawl(attrs, callback);
      }
      function stringify(attrs) {
        function walk(attr) {
          for (var k in attr) {
            if (isPlainObject(attr[k])) {
              walk(attr[k]);
            } else if (Array.isArray(attr[k])) {
              for (var i = 0; i < attr[k].length; i++) {
                walk(attr[k][i]);
              }
            } else {
              if (attr[k] instanceof RegExp) {
                attr[k] = attr[k].toString();
              }
            }
          }
        }
        walk(attrs);
      }
      function handleBasePlotModule(layoutAttributes, _module, astr) {
        var np = nestedProperty(layoutAttributes, astr);
        var attrs = extendDeepAll({}, _module.layoutAttributes);
        attrs[IS_SUBPLOT_OBJ] = true;
        np.set(attrs);
      }
      function insertAttrs(baseAttrs, newAttrs, astr) {
        var np = nestedProperty(baseAttrs, astr);
        np.set(extendDeepAll(np.get() || {}, newAttrs));
      }
    }
  });

  // src/plot_api/plot_template.js
  var require_plot_template = __commonJS({
    "src/plot_api/plot_template.js"(exports) {
      "use strict";
      var Lib = require_lib();
      var plotAttributes = require_attributes2();
      var TEMPLATEITEMNAME = "templateitemname";
      var templateAttrs = {
        name: {
          valType: "string",
          editType: "none"
        }
      };
      templateAttrs[TEMPLATEITEMNAME] = {
        valType: "string",
        editType: "calc"
      };
      exports.templatedArray = function(name2, attrs) {
        attrs._isLinkedToArray = name2;
        attrs.name = templateAttrs.name;
        attrs[TEMPLATEITEMNAME] = templateAttrs[TEMPLATEITEMNAME];
        return attrs;
      };
      exports.traceTemplater = function(dataTemplate) {
        var traceCounts = {};
        var traceType, typeTemplates;
        for (traceType in dataTemplate) {
          typeTemplates = dataTemplate[traceType];
          if (Array.isArray(typeTemplates) && typeTemplates.length) {
            traceCounts[traceType] = 0;
          }
        }
        function newTrace(traceIn) {
          traceType = Lib.coerce(traceIn, {}, plotAttributes, "type");
          var traceOut = { type: traceType, _template: null };
          if (traceType in traceCounts) {
            typeTemplates = dataTemplate[traceType];
            var typei = traceCounts[traceType] % typeTemplates.length;
            traceCounts[traceType]++;
            traceOut._template = typeTemplates[typei];
          } else {
          }
          return traceOut;
        }
        return {
          newTrace
          // TODO: function to figure out what's left & what didn't work
        };
      };
      exports.newContainer = function(container, name2, baseName) {
        var template = container._template;
        var part = template && (template[name2] || baseName && template[baseName]);
        if (!Lib.isPlainObject(part)) part = null;
        var out = container[name2] = { _template: part };
        return out;
      };
      exports.arrayTemplater = function(container, name2, inclusionAttr) {
        var template = container._template;
        var defaultsTemplate = template && template[arrayDefaultKey(name2)];
        var templateItems = template && template[name2];
        if (!Array.isArray(templateItems) || !templateItems.length) {
          templateItems = [];
        }
        var usedNames = {};
        function newItem(itemIn) {
          var out = { name: itemIn.name, _input: itemIn };
          var templateItemName = out[TEMPLATEITEMNAME] = itemIn[TEMPLATEITEMNAME];
          if (!validItemName(templateItemName)) {
            out._template = defaultsTemplate;
            return out;
          }
          for (var i = 0; i < templateItems.length; i++) {
            var templateItem = templateItems[i];
            if (templateItem.name === templateItemName) {
              usedNames[templateItemName] = 1;
              out._template = templateItem;
              return out;
            }
          }
          out[inclusionAttr] = itemIn[inclusionAttr] || false;
          out._template = false;
          return out;
        }
        function defaultItems() {
          var out = [];
          for (var i = 0; i < templateItems.length; i++) {
            var templateItem = templateItems[i];
            var name3 = templateItem.name;
            if (validItemName(name3) && !usedNames[name3]) {
              var outi = {
                _template: templateItem,
                name: name3,
                _input: { _templateitemname: name3 }
              };
              outi[TEMPLATEITEMNAME] = templateItem[TEMPLATEITEMNAME];
              out.push(outi);
              usedNames[name3] = 1;
            }
          }
          return out;
        }
        return {
          newItem,
          defaultItems
        };
      };
      function validItemName(name2) {
        return name2 && typeof name2 === "string";
      }
      function arrayDefaultKey(name2) {
        var lastChar = name2.length - 1;
        if (name2.charAt(lastChar) !== "s") {
          Lib.warn("bad argument to arrayDefaultKey: " + name2);
        }
        return name2.substr(0, name2.length - 1) + "defaults";
      }
      exports.arrayDefaultKey = arrayDefaultKey;
      exports.arrayEditor = function(parentIn, containerStr, itemOut) {
        var lengthIn = (Lib.nestedProperty(parentIn, containerStr).get() || []).length;
        var index = itemOut._index;
        var templateItemName = index >= lengthIn && (itemOut._input || {})._templateitemname;
        if (templateItemName) index = lengthIn;
        var itemStr = containerStr + "[" + index + "]";
        var update;
        function resetUpdate() {
          update = {};
          if (templateItemName) {
            update[itemStr] = {};
            update[itemStr][TEMPLATEITEMNAME] = templateItemName;
          }
        }
        resetUpdate();
        function modifyBase(attr, value) {
          update[attr] = value;
        }
        function modifyItem(attr, value) {
          if (templateItemName) {
            Lib.nestedProperty(update[itemStr], attr).set(value);
          } else {
            update[itemStr + "." + attr] = value;
          }
        }
        function getUpdateObj() {
          var updateOut = update;
          resetUpdate();
          return updateOut;
        }
        function applyUpdate(attr, value) {
          if (attr) modifyItem(attr, value);
          var updateToApply = getUpdateObj();
          for (var key in updateToApply) {
            Lib.nestedProperty(parentIn, key).set(updateToApply[key]);
          }
        }
        return {
          modifyBase,
          modifyItem,
          getUpdateObj,
          applyUpdate
        };
      };
    }
  });

  // src/plots/cartesian/constants.js
  var require_constants2 = __commonJS({
    "src/plots/cartesian/constants.js"(exports, module) {
      "use strict";
      var counterRegex = require_regex().counter;
      module.exports = {
        idRegex: {
          x: counterRegex("x", "( domain)?"),
          y: counterRegex("y", "( domain)?")
        },
        attrRegex: counterRegex("[xy]axis"),
        // axis match regular expression
        xAxisMatch: counterRegex("xaxis"),
        yAxisMatch: counterRegex("yaxis"),
        // pattern matching axis ids and names
        // note that this is more permissive than counterRegex, as
        // id2name, name2id, and cleanId accept "x1" etc
        AX_ID_PATTERN: /^[xyz][0-9]*( domain)?$/,
        AX_NAME_PATTERN: /^[xyz]axis[0-9]*$/,
        // and for 2D subplots
        SUBPLOT_PATTERN: /^x([0-9]*)y([0-9]*)$/,
        HOUR_PATTERN: "hour",
        WEEKDAY_PATTERN: "day of week",
        // pixels to move mouse before you stop clamping to starting point
        MINDRAG: 8,
        // smallest dimension allowed for a zoombox
        MINZOOM: 20,
        // width of axis drag regions
        DRAGGERSIZE: 20,
        // delay before a redraw (relayout) after smooth panning and zooming
        REDRAWDELAY: 50,
        // last resort axis ranges for x and y axes if we have no data
        DFLTRANGEX: [-1, 6],
        DFLTRANGEY: [-1, 4],
        // Layers to keep trace types in the right order
        // N.B. each  'unique' plot method must have its own layer
        traceLayerClasses: [
          "imagelayer",
          "heatmaplayer",
          "contourcarpetlayer",
          "contourlayer",
          "funnellayer",
          "waterfalllayer",
          "barlayer",
          "carpetlayer",
          "violinlayer",
          "boxlayer",
          "ohlclayer",
          "scattercarpetlayer",
          "scatterlayer"
        ],
        clipOnAxisFalseQuery: [
          ".scatterlayer",
          ".barlayer",
          ".funnellayer",
          ".waterfalllayer"
        ],
        layerValue2layerClass: {
          "above traces": "above",
          "below traces": "below"
        },
        zindexSeparator: "z"
        // used for zindex of cartesian subplots e.g. xy, xyz2, xyz3, etc.
      };
    }
  });

  // src/plots/cartesian/axis_ids.js
  var require_axis_ids = __commonJS({
    "src/plots/cartesian/axis_ids.js"(exports) {
      "use strict";
      var Registry = require_registry();
      var constants = require_constants2();
      exports.id2name = function id2name(id) {
        if (typeof id !== "string" || !id.match(constants.AX_ID_PATTERN)) return;
        var axNum = id.split(" ")[0].substr(1);
        if (axNum === "1") axNum = "";
        return id.charAt(0) + "axis" + axNum;
      };
      exports.name2id = function name2id(name2) {
        if (!name2.match(constants.AX_NAME_PATTERN)) return;
        var axNum = name2.substr(5);
        if (axNum === "1") axNum = "";
        return name2.charAt(0) + axNum;
      };
      exports.cleanId = function cleanId(id, axLetter, domainId) {
        var domainTest = /( domain)$/.test(id);
        if (typeof id !== "string" || !id.match(constants.AX_ID_PATTERN)) return;
        if (axLetter && id.charAt(0) !== axLetter) return;
        if (domainTest && !domainId) return;
        var axNum = id.split(" ")[0].substr(1).replace(/^0+/, "");
        if (axNum === "1") axNum = "";
        return id.charAt(0) + axNum + (domainTest && domainId ? " domain" : "");
      };
      exports.list = function(gd, axLetter, only2d) {
        var fullLayout = gd._fullLayout;
        if (!fullLayout) return [];
        var idList = exports.listIds(gd, axLetter);
        var out = new Array(idList.length);
        var i;
        for (i = 0; i < idList.length; i++) {
          var idi = idList[i];
          out[i] = fullLayout[idi.charAt(0) + "axis" + idi.substr(1)];
        }
        if (!only2d) {
          var sceneIds3D = fullLayout._subplots.gl3d || [];
          for (i = 0; i < sceneIds3D.length; i++) {
            var scene = fullLayout[sceneIds3D[i]];
            if (axLetter) out.push(scene[axLetter + "axis"]);
            else out.push(scene.xaxis, scene.yaxis, scene.zaxis);
          }
        }
        return out;
      };
      exports.listIds = function(gd, axLetter) {
        var fullLayout = gd._fullLayout;
        if (!fullLayout) return [];
        var subplotLists = fullLayout._subplots;
        if (axLetter) return subplotLists[axLetter + "axis"];
        return subplotLists.xaxis.concat(subplotLists.yaxis);
      };
      exports.getFromId = function(gd, id, type) {
        var fullLayout = gd._fullLayout;
        id = id === void 0 || typeof id !== "string" ? id : id.replace(" domain", "");
        if (type === "x") id = id.replace(/y[0-9]*/, "");
        else if (type === "y") id = id.replace(/x[0-9]*/, "");
        return fullLayout[exports.id2name(id)];
      };
      exports.getFromTrace = function(gd, fullTrace, type) {
        var fullLayout = gd._fullLayout;
        var ax = null;
        if (Registry.traceIs(fullTrace, "gl3d")) {
          var scene = fullTrace.scene;
          if (scene.substr(0, 5) === "scene") {
            ax = fullLayout[scene][type + "axis"];
          }
        } else {
          ax = exports.getFromId(gd, fullTrace[type + "axis"] || type);
        }
        return ax;
      };
      exports.idSort = function(id1, id2) {
        var letter1 = id1.charAt(0);
        var letter2 = id2.charAt(0);
        if (letter1 !== letter2) return letter1 > letter2 ? 1 : -1;
        return +(id1.substr(1) || 1) - +(id2.substr(1) || 1);
      };
      exports.ref2id = function(ar) {
        return /^[xyz]/.test(ar) ? ar.split(" ")[0] : false;
      };
      function isFound(axId, list) {
        if (list && list.length) {
          for (var i = 0; i < list.length; i++) {
            if (list[i][axId]) return true;
          }
        }
        return false;
      }
      exports.isLinked = function(fullLayout, axId) {
        return isFound(axId, fullLayout._axisMatchGroups) || isFound(axId, fullLayout._axisConstraintGroups);
      };
    }
  });

  // src/components/shapes/handle_outline.js
  var require_handle_outline = __commonJS({
    "src/components/shapes/handle_outline.js"(exports, module) {
      "use strict";
      function clearOutlineControllers(gd) {
        var zoomLayer = gd._fullLayout._zoomlayer;
        if (zoomLayer) {
          zoomLayer.selectAll(".outline-controllers").remove();
        }
      }
      function clearOutline(gd) {
        var zoomLayer = gd._fullLayout._zoomlayer;
        if (zoomLayer) {
          zoomLayer.selectAll(".select-outline").remove();
        }
        gd._fullLayout._outlining = false;
      }
      module.exports = {
        clearOutlineControllers,
        clearOutline
      };
    }
  });

  // src/traces/scatter/layout_attributes.js
  var require_layout_attributes3 = __commonJS({
    "src/traces/scatter/layout_attributes.js"(exports, module) {
      "use strict";
      module.exports = {
        scattermode: {
          valType: "enumerated",
          values: ["group", "overlay"],
          dflt: "overlay",
          editType: "calc"
        },
        scattergap: {
          valType: "number",
          min: 0,
          max: 1,
          editType: "calc"
        }
      };
    }
  });

  // src/plots/get_data.js
  var require_get_data = __commonJS({
    "src/plots/get_data.js"(exports) {
      "use strict";
      var Registry = require_registry();
      var SUBPLOT_PATTERN = require_constants2().SUBPLOT_PATTERN;
      exports.getSubplotCalcData = function(calcData, type, subplotId) {
        var basePlotModule = Registry.subplotsRegistry[type];
        if (!basePlotModule) return [];
        var attr = basePlotModule.attr;
        var subplotCalcData = [];
        for (var i = 0; i < calcData.length; i++) {
          var calcTrace = calcData[i];
          var trace = calcTrace[0].trace;
          if (trace[attr] === subplotId) subplotCalcData.push(calcTrace);
        }
        return subplotCalcData;
      };
      exports.getModuleCalcData = function(calcdata, arg1, arg2) {
        var moduleCalcData = [];
        var remainingCalcData = [];
        var plotMethod;
        if (typeof arg1 === "string") {
          plotMethod = Registry.getModule(arg1).plot;
        } else if (typeof arg1 === "function") {
          plotMethod = arg1;
        } else {
          plotMethod = arg1.plot;
        }
        if (!plotMethod) {
          return [moduleCalcData, calcdata];
        }
        var zorder = arg2;
        for (var i = 0; i < calcdata.length; i++) {
          var cd = calcdata[i];
          var trace = cd[0].trace;
          var filterByZ = trace.zorder !== void 0;
          if (trace.visible !== true || trace._length === 0) continue;
          if (trace._module && trace._module.plot === plotMethod && (!filterByZ || trace.zorder === zorder)) {
            moduleCalcData.push(cd);
          } else {
            remainingCalcData.push(cd);
          }
        }
        return [moduleCalcData, remainingCalcData];
      };
      exports.getSubplotData = function getSubplotData(data, type, subplotId) {
        if (!Registry.subplotsRegistry[type]) return [];
        var attr = Registry.subplotsRegistry[type].attr;
        var subplotData = [];
        var trace, subplotX, subplotY;
        for (var i = 0; i < data.length; i++) {
          trace = data[i];
          if (trace[attr] === subplotId) subplotData.push(trace);
        }
        return subplotData;
      };
    }
  });

  // src/plots/command.js
  var require_command = __commonJS({
    "src/plots/command.js"(exports) {
      "use strict";
      var Registry = require_registry();
      var Lib = require_lib();
      exports.manageCommandObserver = function(gd, container, commandList, onchange) {
        var ret = {};
        var enabled = true;
        if (container && container._commandObserver) {
          ret = container._commandObserver;
        }
        if (!ret.cache) {
          ret.cache = {};
        }
        ret.lookupTable = {};
        var binding = exports.hasSimpleAPICommandBindings(gd, commandList, ret.lookupTable);
        if (container && container._commandObserver) {
          if (!binding) {
            if (container._commandObserver.remove) {
              container._commandObserver.remove();
              container._commandObserver = null;
              return ret;
            }
          } else {
            return ret;
          }
        }
        if (binding) {
          bindingValueHasChanged(gd, binding, ret.cache);
          ret.check = function check() {
            if (!enabled) return;
            var update = bindingValueHasChanged(gd, binding, ret.cache);
            if (update.changed && onchange) {
              if (ret.lookupTable[update.value] !== void 0) {
                ret.disable();
                Promise.resolve(onchange({
                  value: update.value,
                  type: binding.type,
                  prop: binding.prop,
                  traces: binding.traces,
                  index: ret.lookupTable[update.value]
                })).then(ret.enable, ret.enable);
              }
            }
            return update.changed;
          };
          var checkEvents = [
            "plotly_relayout",
            "plotly_redraw",
            "plotly_restyle",
            "plotly_update",
            "plotly_animatingframe",
            "plotly_afterplot"
          ];
          for (var i = 0; i < checkEvents.length; i++) {
            gd._internalOn(checkEvents[i], ret.check);
          }
          ret.remove = function() {
            for (var i2 = 0; i2 < checkEvents.length; i2++) {
              gd._removeInternalListener(checkEvents[i2], ret.check);
            }
          };
        } else {
          Lib.log("Unable to automatically bind plot updates to API command");
          ret.lookupTable = {};
          ret.remove = function() {
          };
        }
        ret.disable = function disable() {
          enabled = false;
        };
        ret.enable = function enable() {
          enabled = true;
        };
        if (container) {
          container._commandObserver = ret;
        }
        return ret;
      };
      exports.hasSimpleAPICommandBindings = function(gd, commandList, bindingsByValue) {
        var i;
        var n = commandList.length;
        var refBinding;
        for (i = 0; i < n; i++) {
          var binding;
          var command = commandList[i];
          var method = command.method;
          var args = command.args;
          if (!Array.isArray(args)) args = [];
          if (!method) {
            return false;
          }
          var bindings = exports.computeAPICommandBindings(gd, method, args);
          if (bindings.length !== 1) {
            return false;
          }
          if (!refBinding) {
            refBinding = bindings[0];
            if (Array.isArray(refBinding.traces)) {
              refBinding.traces.sort();
            }
          } else {
            binding = bindings[0];
            if (binding.type !== refBinding.type) {
              return false;
            }
            if (binding.prop !== refBinding.prop) {
              return false;
            }
            if (Array.isArray(refBinding.traces)) {
              if (Array.isArray(binding.traces)) {
                binding.traces.sort();
                for (var j = 0; j < refBinding.traces.length; j++) {
                  if (refBinding.traces[j] !== binding.traces[j]) {
                    return false;
                  }
                }
              } else {
                return false;
              }
            } else {
              if (binding.prop !== refBinding.prop) {
                return false;
              }
            }
          }
          binding = bindings[0];
          var value = binding.value;
          if (Array.isArray(value)) {
            if (value.length === 1) {
              value = value[0];
            } else {
              return false;
            }
          }
          if (bindingsByValue) {
            bindingsByValue[value] = i;
          }
        }
        return refBinding;
      };
      function bindingValueHasChanged(gd, binding, cache) {
        var container, value, obj;
        var changed = false;
        if (binding.type === "data") {
          container = gd._fullData[binding.traces !== null ? binding.traces[0] : 0];
        } else if (binding.type === "layout") {
          container = gd._fullLayout;
        } else {
          return false;
        }
        value = Lib.nestedProperty(container, binding.prop).get();
        obj = cache[binding.type] = cache[binding.type] || {};
        if (obj.hasOwnProperty(binding.prop)) {
          if (obj[binding.prop] !== value) {
            changed = true;
          }
        }
        obj[binding.prop] = value;
        return {
          changed,
          value
        };
      }
      exports.executeAPICommand = function(gd, method, args) {
        if (method === "skip") return Promise.resolve();
        var _method = Registry.apiMethodRegistry[method];
        var allArgs = [gd];
        if (!Array.isArray(args)) args = [];
        for (var i = 0; i < args.length; i++) {
          allArgs.push(args[i]);
        }
        return _method.apply(null, allArgs).catch(function(err) {
          Lib.warn("API call to Plotly." + method + " rejected.", err);
          return Promise.reject(err);
        });
      };
      exports.computeAPICommandBindings = function(gd, method, args) {
        var bindings;
        if (!Array.isArray(args)) args = [];
        switch (method) {
          case "restyle":
            bindings = computeDataBindings(gd, args);
            break;
          case "relayout":
            bindings = computeLayoutBindings(gd, args);
            break;
          case "update":
            bindings = computeDataBindings(gd, [args[0], args[2]]).concat(computeLayoutBindings(gd, [args[1]]));
            break;
          case "animate":
            bindings = computeAnimateBindings(gd, args);
            break;
          default:
            bindings = [];
        }
        return bindings;
      };
      function computeAnimateBindings(gd, args) {
        if (Array.isArray(args[0]) && args[0].length === 1 && ["string", "number"].indexOf(typeof args[0][0]) !== -1) {
          return [{ type: "layout", prop: "_currentFrame", value: args[0][0].toString() }];
        } else {
          return [];
        }
      }
      function computeLayoutBindings(gd, args) {
        var bindings = [];
        var astr = args[0];
        var aobj = {};
        if (typeof astr === "string") {
          aobj[astr] = args[1];
        } else if (Lib.isPlainObject(astr)) {
          aobj = astr;
        } else {
          return bindings;
        }
        crawl(aobj, function(path, attrName, attr) {
          bindings.push({ type: "layout", prop: path, value: attr });
        }, "", 0);
        return bindings;
      }
      function computeDataBindings(gd, args) {
        var traces, astr, val, aobj;
        var bindings = [];
        astr = args[0];
        val = args[1];
        traces = args[2];
        aobj = {};
        if (typeof astr === "string") {
          aobj[astr] = val;
        } else if (Lib.isPlainObject(astr)) {
          aobj = astr;
          if (traces === void 0) {
            traces = val;
          }
        } else {
          return bindings;
        }
        if (traces === void 0) {
          traces = null;
        }
        crawl(aobj, function(path, attrName, _attr) {
          var thisTraces;
          var attr;
          if (Array.isArray(_attr)) {
            attr = _attr.slice();
            var nAttr = Math.min(attr.length, gd.data.length);
            if (traces) {
              nAttr = Math.min(nAttr, traces.length);
            }
            thisTraces = [];
            for (var j = 0; j < nAttr; j++) {
              thisTraces[j] = traces ? traces[j] : j;
            }
          } else {
            attr = _attr;
            thisTraces = traces ? traces.slice() : null;
          }
          if (thisTraces === null) {
            if (Array.isArray(attr)) {
              attr = attr[0];
            }
          } else if (Array.isArray(thisTraces)) {
            if (!Array.isArray(attr)) {
              var tmp = attr;
              attr = [];
              for (var i = 0; i < thisTraces.length; i++) {
                attr[i] = tmp;
              }
            }
            attr.length = Math.min(thisTraces.length, attr.length);
          }
          bindings.push({
            type: "data",
            prop: path,
            traces: thisTraces,
            value: attr
          });
        }, "", 0);
        return bindings;
      }
      function crawl(attrs, callback, path, depth) {
        Object.keys(attrs).forEach(function(attrName) {
          var attr = attrs[attrName];
          if (attrName[0] === "_") return;
          var thisPath = path + (depth > 0 ? "." : "") + attrName;
          if (Lib.isPlainObject(attr)) {
            crawl(attr, callback, thisPath, depth + 1);
          } else {
            callback(thisPath, attrName, attr);
          }
        });
      }
    }
  });

  // src/plots/plots.js
  var require_plots = __commonJS({
    "src/plots/plots.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var timeFormatLocale = require_d3_time_format().timeFormatLocale;
      var formatLocale = require_d3_format().formatLocale;
      var isNumeric = require_fast_isnumeric();
      var b64encode = require_base64_arraybuffer_umd();
      var Registry = require_registry();
      var PlotSchema = require_plot_schema();
      var Template = require_plot_template();
      var Lib = require_lib();
      var Color2 = require_color();
      var BADNUM = require_numerical().BADNUM;
      var axisIDs = require_axis_ids();
      var clearOutline = require_handle_outline().clearOutline;
      var scatterAttrs = require_layout_attributes3();
      var animationAttrs = require_animation_attributes();
      var frameAttrs = require_frame_attributes();
      var getModuleCalcData = require_get_data().getModuleCalcData;
      var relinkPrivateKeys = Lib.relinkPrivateKeys;
      var _ = Lib._;
      var plots = module.exports = {};
      Lib.extendFlat(plots, Registry);
      plots.attributes = require_attributes2();
      plots.attributes.type.values = plots.allTypes;
      plots.fontAttrs = require_font_attributes();
      plots.layoutAttributes = require_layout_attributes2();
      var commandModule = require_command();
      plots.executeAPICommand = commandModule.executeAPICommand;
      plots.computeAPICommandBindings = commandModule.computeAPICommandBindings;
      plots.manageCommandObserver = commandModule.manageCommandObserver;
      plots.hasSimpleAPICommandBindings = commandModule.hasSimpleAPICommandBindings;
      plots.redrawText = function(gd) {
        gd = Lib.getGraphDiv(gd);
        return new Promise(function(resolve) {
          setTimeout(function() {
            if (!gd._fullLayout) return;
            Registry.getComponentMethod("annotations", "draw")(gd);
            Registry.getComponentMethod("legend", "draw")(gd);
            Registry.getComponentMethod("colorbar", "draw")(gd);
            resolve(plots.previousPromises(gd));
          }, 300);
        });
      };
      plots.resize = function(gd) {
        gd = Lib.getGraphDiv(gd);
        var resolveLastResize;
        var p = new Promise(function(resolve, reject) {
          if (!gd || Lib.isHidden(gd)) {
            reject(new Error("Resize must be passed a displayed plot div element."));
          }
          if (gd._redrawTimer) clearTimeout(gd._redrawTimer);
          if (gd._resolveResize) resolveLastResize = gd._resolveResize;
          gd._resolveResize = resolve;
          gd._redrawTimer = setTimeout(function() {
            if (!gd.layout || gd.layout.width && gd.layout.height || Lib.isHidden(gd)) {
              resolve(gd);
              return;
            }
            delete gd.layout.width;
            delete gd.layout.height;
            var oldchanged = gd.changed;
            gd.autoplay = true;
            Registry.call("relayout", gd, { autosize: true }).then(function() {
              gd.changed = oldchanged;
              if (gd._resolveResize === resolve) {
                delete gd._resolveResize;
                resolve(gd);
              }
            });
          }, 100);
        });
        if (resolveLastResize) resolveLastResize(p);
        return p;
      };
      plots.previousPromises = function(gd) {
        if ((gd._promises || []).length) {
          return Promise.all(gd._promises).then(function() {
            gd._promises = [];
          });
        }
      };
      plots.addLinks = function(gd) {
        if (!gd._context.showLink && !gd._context.showSources) return;
        var fullLayout = gd._fullLayout;
        var linkContainer = Lib.ensureSingle(fullLayout._paper, "text", "js-plot-link-container", function(s) {
          s.style({
            "font-family": '"Open Sans", Arial, sans-serif',
            "font-size": "12px",
            fill: Color2.defaultLine,
            "pointer-events": "all"
          }).each(function() {
            var links = d3.select(this);
            links.append("tspan").classed("js-link-to-tool", true);
            links.append("tspan").classed("js-link-spacer", true);
            links.append("tspan").classed("js-sourcelinks", true);
          });
        });
        var text = linkContainer.node();
        var attrs = { y: fullLayout._paper.attr("height") - 9 };
        if (document.body.contains(text) && text.getComputedTextLength() >= fullLayout.width - 20) {
          attrs["text-anchor"] = "start";
          attrs.x = 5;
        } else {
          attrs["text-anchor"] = "end";
          attrs.x = fullLayout._paper.attr("width") - 7;
        }
        linkContainer.attr(attrs);
        var toolspan = linkContainer.select(".js-link-to-tool");
        var spacespan = linkContainer.select(".js-link-spacer");
        var sourcespan = linkContainer.select(".js-sourcelinks");
        if (gd._context.showSources) gd._context.showSources(gd);
        if (gd._context.showLink) positionPlayWithData(gd, toolspan);
        spacespan.text(toolspan.text() && sourcespan.text() ? " - " : "");
      };
      function positionPlayWithData(gd, container) {
        container.text("");
        var link = container.append("a").attr({
          "xlink:xlink:href": "#",
          class: "link--impt link--embedview",
          "font-weight": "bold"
        }).text(gd._context.linkText + " " + String.fromCharCode(187));
        if (gd._context.sendData) {
          link.on("click", function() {
            plots.sendDataToCloud(gd);
          });
        } else {
          var path = window.location.pathname.split("/");
          var query = window.location.search;
          link.attr({
            "xlink:xlink:show": "new",
            "xlink:xlink:href": "/" + path[2].split(".")[0] + "/" + path[1] + query
          });
        }
      }
      plots.sendDataToCloud = function(gd) {
        var baseUrl = (window.PLOTLYENV || {}).BASE_URL || gd._context.plotlyServerURL;
        if (!baseUrl) return;
        gd.emit("plotly_beforeexport");
        var hiddenformDiv = d3.select(gd).append("div").attr("id", "hiddenform").style("display", "none");
        var hiddenform = hiddenformDiv.append("form").attr({
          action: baseUrl + "/external",
          method: "post",
          target: "_blank"
        });
        var hiddenformInput = hiddenform.append("input").attr({
          type: "text",
          name: "data"
        });
        hiddenformInput.node().value = plots.graphJson(gd, false, "keepdata");
        hiddenform.node().submit();
        hiddenformDiv.remove();
        gd.emit("plotly_afterexport");
        return false;
      };
      var d3FormatKeys = [
        "days",
        "shortDays",
        "months",
        "shortMonths",
        "periods",
        "dateTime",
        "date",
        "time",
        "decimal",
        "thousands",
        "grouping",
        "currency"
      ];
      var extraFormatKeys = [
        "year",
        "month",
        "dayMonth",
        "dayMonthYear"
      ];
      plots.supplyDefaults = function(gd, opts) {
        var skipUpdateCalc = opts && opts.skipUpdateCalc;
        var oldFullLayout = gd._fullLayout || {};
        if (oldFullLayout._skipDefaults) {
          delete oldFullLayout._skipDefaults;
          return;
        }
        var newFullLayout = gd._fullLayout = {};
        var newLayout = gd.layout || {};
        var oldFullData = gd._fullData || [];
        var newFullData = gd._fullData = [];
        var newData = gd.data || [];
        var oldCalcdata = gd.calcdata || [];
        var context = gd._context || {};
        var i;
        if (!gd._transitionData) plots.createTransitionData(gd);
        newFullLayout._dfltTitle = {
          plot: _(gd, "Click to enter Plot title"),
          subtitle: _(gd, "Click to enter Plot subtitle"),
          x: _(gd, "Click to enter X axis title"),
          y: _(gd, "Click to enter Y axis title"),
          colorbar: _(gd, "Click to enter Colorscale title"),
          annotation: _(gd, "new text")
        };
        newFullLayout._traceWord = _(gd, "trace");
        var formatObj = getFormatObj(gd, d3FormatKeys);
        newFullLayout._mapboxAccessToken = context.mapboxAccessToken;
        if (oldFullLayout._initialAutoSizeIsDone) {
          var oldWidth = oldFullLayout.width;
          var oldHeight = oldFullLayout.height;
          plots.supplyLayoutGlobalDefaults(newLayout, newFullLayout, formatObj);
          if (!newLayout.width) newFullLayout.width = oldWidth;
          if (!newLayout.height) newFullLayout.height = oldHeight;
          plots.sanitizeMargins(newFullLayout);
        } else {
          plots.supplyLayoutGlobalDefaults(newLayout, newFullLayout, formatObj);
          var missingWidthOrHeight = !newLayout.width || !newLayout.height;
          var autosize = newFullLayout.autosize;
          var autosizable = context.autosizable;
          var initialAutoSize = missingWidthOrHeight && (autosize || autosizable);
          if (initialAutoSize) plots.plotAutoSize(gd, newLayout, newFullLayout);
          else if (missingWidthOrHeight) plots.sanitizeMargins(newFullLayout);
          if (!autosize && missingWidthOrHeight) {
            newLayout.width = newFullLayout.width;
            newLayout.height = newFullLayout.height;
          }
        }
        newFullLayout._d3locale = getFormatter(formatObj, newFullLayout.separators);
        newFullLayout._extraFormat = getFormatObj(gd, extraFormatKeys);
        newFullLayout._initialAutoSizeIsDone = true;
        newFullLayout._dataLength = newData.length;
        newFullLayout._modules = [];
        newFullLayout._visibleModules = [];
        newFullLayout._basePlotModules = [];
        var subplots = newFullLayout._subplots = emptySubplotLists();
        var splomAxes = newFullLayout._splomAxes = { x: {}, y: {} };
        var splomSubplots = newFullLayout._splomSubplots = {};
        newFullLayout._splomGridDflt = {};
        newFullLayout._scatterStackOpts = {};
        newFullLayout._firstScatter = {};
        newFullLayout._alignmentOpts = {};
        newFullLayout._colorAxes = {};
        newFullLayout._requestRangeslider = {};
        newFullLayout._traceUids = getTraceUids(oldFullData, newData);
        plots.supplyDataDefaults(newData, newFullData, newLayout, newFullLayout);
        var splomXa = Object.keys(splomAxes.x);
        var splomYa = Object.keys(splomAxes.y);
        if (splomXa.length > 1 && splomYa.length > 1) {
          Registry.getComponentMethod("grid", "sizeDefaults")(newLayout, newFullLayout);
          for (i = 0; i < splomXa.length; i++) {
            Lib.pushUnique(subplots.xaxis, splomXa[i]);
          }
          for (i = 0; i < splomYa.length; i++) {
            Lib.pushUnique(subplots.yaxis, splomYa[i]);
          }
          for (var k in splomSubplots) {
            Lib.pushUnique(subplots.cartesian, k);
          }
        }
        newFullLayout._has = plots._hasPlotType.bind(newFullLayout);
        if (oldFullData.length === newFullData.length) {
          for (i = 0; i < newFullData.length; i++) {
            relinkPrivateKeys(newFullData[i], oldFullData[i]);
          }
        }
        plots.supplyLayoutModuleDefaults(newLayout, newFullLayout, newFullData, gd._transitionData);
        var _modules = newFullLayout._visibleModules;
        var crossTraceDefaultsFuncs = [];
        for (i = 0; i < _modules.length; i++) {
          var funci = _modules[i].crossTraceDefaults;
          if (funci) Lib.pushUnique(crossTraceDefaultsFuncs, funci);
        }
        for (i = 0; i < crossTraceDefaultsFuncs.length; i++) {
          crossTraceDefaultsFuncs[i](newFullData, newFullLayout);
        }
        newFullLayout._hasOnlyLargeSploms = newFullLayout._basePlotModules.length === 1 && newFullLayout._basePlotModules[0].name === "splom" && splomXa.length > 15 && splomYa.length > 15 && newFullLayout.shapes.length === 0 && newFullLayout.images.length === 0;
        plots.linkSubplots(newFullData, newFullLayout, oldFullData, oldFullLayout);
        plots.cleanPlot(newFullData, newFullLayout, oldFullData, oldFullLayout);
        var hadCartesian = !!(oldFullLayout._has && oldFullLayout._has("cartesian"));
        var hasCartesian = !!(newFullLayout._has && newFullLayout._has("cartesian"));
        var hadBgLayer = hadCartesian;
        var hasBgLayer = hasCartesian;
        if (hadBgLayer && !hasBgLayer) {
          oldFullLayout._bgLayer.remove();
        } else if (hasBgLayer && !hadBgLayer) {
          newFullLayout._shouldCreateBgLayer = true;
        }
        if (oldFullLayout._zoomlayer && !gd._dragging) {
          clearOutline({
            // mock old gd
            _fullLayout: oldFullLayout
          });
        }
        fillMetaTextHelpers(newFullData, newFullLayout);
        relinkPrivateKeys(newFullLayout, oldFullLayout);
        Registry.getComponentMethod("colorscale", "crossTraceDefaults")(newFullData, newFullLayout);
        if (!newFullLayout._preGUI) newFullLayout._preGUI = {};
        if (!newFullLayout._tracePreGUI) newFullLayout._tracePreGUI = {};
        var tracePreGUI = newFullLayout._tracePreGUI;
        var uids = {};
        var uid;
        for (uid in tracePreGUI) uids[uid] = "old";
        for (i = 0; i < newFullData.length; i++) {
          uid = newFullData[i]._fullInput.uid;
          if (!uids[uid]) tracePreGUI[uid] = {};
          uids[uid] = "new";
        }
        for (uid in uids) {
          if (uids[uid] === "old") delete tracePreGUI[uid];
        }
        initMargins(newFullLayout);
        Registry.getComponentMethod("rangeslider", "makeData")(newFullLayout);
        if (!skipUpdateCalc && oldCalcdata.length === newFullData.length) {
          plots.supplyDefaultsUpdateCalc(oldCalcdata, newFullData);
        }
      };
      plots.supplyDefaultsUpdateCalc = function(oldCalcdata, newFullData) {
        for (var i = 0; i < newFullData.length; i++) {
          var newTrace = newFullData[i];
          var cd0 = (oldCalcdata[i] || [])[0];
          if (cd0 && cd0.trace) {
            var oldTrace = cd0.trace;
            if (oldTrace._hasCalcTransform) {
              var arrayAttrs = oldTrace._arrayAttrs;
              var j, astr, oldArrayVal;
              for (j = 0; j < arrayAttrs.length; j++) {
                astr = arrayAttrs[j];
                oldArrayVal = Lib.nestedProperty(oldTrace, astr).get().slice();
                Lib.nestedProperty(newTrace, astr).set(oldArrayVal);
              }
            }
            cd0.trace = newTrace;
          }
        }
      };
      function getTraceUids(oldFullData, newData) {
        var len = newData.length;
        var oldFullInput = [];
        var i, prevFullInput;
        for (i = 0; i < oldFullData.length; i++) {
          var thisFullInput = oldFullData[i]._fullInput;
          if (thisFullInput !== prevFullInput) oldFullInput.push(thisFullInput);
          prevFullInput = thisFullInput;
        }
        var oldLen = oldFullInput.length;
        var out = new Array(len);
        var seenUids = {};
        function setUid(uid, i2) {
          out[i2] = uid;
          seenUids[uid] = 1;
        }
        function tryUid(uid, i2) {
          if (uid && typeof uid === "string" && !seenUids[uid]) {
            setUid(uid, i2);
            return true;
          }
        }
        for (i = 0; i < len; i++) {
          var newUid = newData[i].uid;
          if (typeof newUid === "number") newUid = String(newUid);
          if (tryUid(newUid, i)) continue;
          if (i < oldLen && tryUid(oldFullInput[i].uid, i)) continue;
          setUid(Lib.randstr(seenUids), i);
        }
        return out;
      }
      function emptySubplotLists() {
        var collectableSubplotTypes = Registry.collectableSubplotTypes;
        var out = {};
        var i, j;
        if (!collectableSubplotTypes) {
          collectableSubplotTypes = [];
          var subplotsRegistry = Registry.subplotsRegistry;
          for (var subplotType in subplotsRegistry) {
            var subplotModule = subplotsRegistry[subplotType];
            var subplotAttr = subplotModule.attr;
            if (subplotAttr) {
              collectableSubplotTypes.push(subplotType);
              if (Array.isArray(subplotAttr)) {
                for (j = 0; j < subplotAttr.length; j++) {
                  Lib.pushUnique(collectableSubplotTypes, subplotAttr[j]);
                }
              }
            }
          }
        }
        for (i = 0; i < collectableSubplotTypes.length; i++) {
          out[collectableSubplotTypes[i]] = [];
        }
        return out;
      }
      function getFormatObj(gd, formatKeys) {
        var locale = gd._context.locale;
        if (!locale) locale = "en-US";
        var formatDone = false;
        var formatObj = {};
        function includeFormat(newFormat) {
          var formatFinished = true;
          for (var i2 = 0; i2 < formatKeys.length; i2++) {
            var formatKey = formatKeys[i2];
            if (!formatObj[formatKey]) {
              if (newFormat[formatKey]) {
                formatObj[formatKey] = newFormat[formatKey];
              } else formatFinished = false;
            }
          }
          if (formatFinished) formatDone = true;
        }
        for (var i = 0; i < 2; i++) {
          var locales = gd._context.locales;
          for (var j = 0; j < 2; j++) {
            var formatj = (locales[locale] || {}).format;
            if (formatj) {
              includeFormat(formatj);
              if (formatDone) break;
            }
            locales = Registry.localeRegistry;
          }
          var baseLocale = locale.split("-")[0];
          if (formatDone || baseLocale === locale) break;
          locale = baseLocale;
        }
        if (!formatDone) includeFormat(Registry.localeRegistry.en.format);
        return formatObj;
      }
      function getFormatter(formatObj, separators) {
        formatObj.decimal = separators.charAt(0);
        formatObj.thousands = separators.charAt(1);
        return {
          numberFormat: function(formatStr) {
            try {
              formatStr = formatLocale(formatObj).format(
                Lib.adjustFormat(formatStr)
              );
            } catch (e) {
              Lib.warnBadFormat(formatStr);
              return Lib.noFormat;
            }
            return formatStr;
          },
          timeFormat: timeFormatLocale(formatObj).utcFormat
        };
      }
      function fillMetaTextHelpers(newFullData, newFullLayout) {
        var _meta;
        var meta4data = [];
        if (newFullLayout.meta) {
          _meta = newFullLayout._meta = {
            meta: newFullLayout.meta,
            layout: { meta: newFullLayout.meta }
          };
        }
        for (var i = 0; i < newFullData.length; i++) {
          var trace = newFullData[i];
          if (trace.meta) {
            meta4data[trace.index] = trace._meta = { meta: trace.meta };
          } else if (newFullLayout.meta) {
            trace._meta = { meta: newFullLayout.meta };
          }
          if (newFullLayout.meta) {
            trace._meta.layout = { meta: newFullLayout.meta };
          }
        }
        if (meta4data.length) {
          if (!_meta) {
            _meta = newFullLayout._meta = {};
          }
          _meta.data = meta4data;
        }
      }
      plots.createTransitionData = function(gd) {
        if (!gd._transitionData) {
          gd._transitionData = {};
        }
        if (!gd._transitionData._frames) {
          gd._transitionData._frames = [];
        }
        if (!gd._transitionData._frameHash) {
          gd._transitionData._frameHash = {};
        }
        if (!gd._transitionData._counter) {
          gd._transitionData._counter = 0;
        }
        if (!gd._transitionData._interruptCallbacks) {
          gd._transitionData._interruptCallbacks = [];
        }
      };
      plots._hasPlotType = function(category) {
        var i;
        var basePlotModules = this._basePlotModules || [];
        for (i = 0; i < basePlotModules.length; i++) {
          if (basePlotModules[i].name === category) return true;
        }
        var modules = this._modules || [];
        for (i = 0; i < modules.length; i++) {
          var name2 = modules[i].name;
          if (name2 === category) return true;
          var _module = Registry.modules[name2];
          if (_module && _module.categories[category]) return true;
        }
        return false;
      };
      plots.cleanPlot = function(newFullData, newFullLayout, oldFullData, oldFullLayout) {
        var i, j;
        var basePlotModules = oldFullLayout._basePlotModules || [];
        for (i = 0; i < basePlotModules.length; i++) {
          var _module = basePlotModules[i];
          if (_module.clean) {
            _module.clean(newFullData, newFullLayout, oldFullData, oldFullLayout);
          }
        }
        var hadGl = oldFullLayout._has && oldFullLayout._has("gl");
        var hasGl = newFullLayout._has && newFullLayout._has("gl");
        if (hadGl && !hasGl) {
          if (oldFullLayout._glcontainer !== void 0) {
            oldFullLayout._glcontainer.selectAll(".gl-canvas").remove();
            oldFullLayout._glcontainer.selectAll(".no-webgl").remove();
            oldFullLayout._glcanvas = null;
          }
        }
        var hasInfoLayer = !!oldFullLayout._infolayer;
        oldLoop:
          for (i = 0; i < oldFullData.length; i++) {
            var oldTrace = oldFullData[i];
            var oldUid = oldTrace.uid;
            for (j = 0; j < newFullData.length; j++) {
              var newTrace = newFullData[j];
              if (oldUid === newTrace.uid) continue oldLoop;
            }
            if (hasInfoLayer) {
              oldFullLayout._infolayer.select(".cb" + oldUid).remove();
            }
          }
      };
      plots.linkSubplots = function(newFullData, newFullLayout, oldFullData, oldFullLayout) {
        var i, j;
        var oldSubplots = oldFullLayout._plots || {};
        var newSubplots = newFullLayout._plots = {};
        var newSubplotList = newFullLayout._subplots;
        var mockGd = {
          _fullData: newFullData,
          _fullLayout: newFullLayout
        };
        var ids = newSubplotList.cartesian || [];
        for (i = 0; i < ids.length; i++) {
          var id = ids[i];
          var oldSubplot = oldSubplots[id];
          var xaxis = axisIDs.getFromId(mockGd, id, "x");
          var yaxis = axisIDs.getFromId(mockGd, id, "y");
          var plotinfo;
          if (oldSubplot) {
            plotinfo = newSubplots[id] = oldSubplot;
          } else {
            plotinfo = newSubplots[id] = {};
            plotinfo.id = id;
          }
          xaxis._counterAxes.push(yaxis._id);
          yaxis._counterAxes.push(xaxis._id);
          xaxis._subplotsWith.push(id);
          yaxis._subplotsWith.push(id);
          plotinfo.xaxis = xaxis;
          plotinfo.yaxis = yaxis;
          plotinfo._hasClipOnAxisFalse = false;
          for (j = 0; j < newFullData.length; j++) {
            var trace = newFullData[j];
            if (trace.xaxis === plotinfo.xaxis._id && trace.yaxis === plotinfo.yaxis._id && trace.cliponaxis === false) {
              plotinfo._hasClipOnAxisFalse = true;
              break;
            }
          }
        }
        var axList = axisIDs.list(mockGd, null, true);
        var ax;
        for (i = 0; i < axList.length; i++) {
          ax = axList[i];
          var mainAx = null;
          if (ax.overlaying) {
            mainAx = axisIDs.getFromId(mockGd, ax.overlaying);
            if (mainAx && mainAx.overlaying) {
              ax.overlaying = false;
              mainAx = null;
            }
          }
          ax._mainAxis = mainAx || ax;
          if (mainAx) ax.domain = mainAx.domain.slice();
          ax._anchorAxis = ax.anchor === "free" ? null : axisIDs.getFromId(mockGd, ax.anchor);
        }
        for (i = 0; i < axList.length; i++) {
          ax = axList[i];
          ax._counterAxes.sort(axisIDs.idSort);
          ax._subplotsWith.sort(Lib.subplotSort);
          ax._mainSubplot = findMainSubplot(ax, newFullLayout);
          if (ax._counterAxes.length && (ax.spikemode && ax.spikemode.indexOf("across") !== -1 || ax.automargin && ax.mirror && ax.anchor !== "free" || Registry.getComponentMethod("rangeslider", "isVisible")(ax))) {
            var min = 1;
            var max = 0;
            for (j = 0; j < ax._counterAxes.length; j++) {
              var ax2 = axisIDs.getFromId(mockGd, ax._counterAxes[j]);
              min = Math.min(min, ax2.domain[0]);
              max = Math.max(max, ax2.domain[1]);
            }
            if (min < max) {
              ax._counterDomainMin = min;
              ax._counterDomainMax = max;
            }
          }
        }
      };
      function findMainSubplot(ax, fullLayout) {
        var mockGd = { _fullLayout: fullLayout };
        var isX = ax._id.charAt(0) === "x";
        var anchorAx = ax._mainAxis._anchorAxis;
        var mainSubplotID = "";
        var nextBestMainSubplotID = "";
        var anchorID = "";
        if (anchorAx) {
          anchorID = anchorAx._mainAxis._id;
          mainSubplotID = isX ? ax._id + anchorID : anchorID + ax._id;
        }
        if (!mainSubplotID || !fullLayout._plots[mainSubplotID]) {
          mainSubplotID = "";
          var counterIDs = ax._counterAxes;
          for (var j = 0; j < counterIDs.length; j++) {
            var counterPart = counterIDs[j];
            var id = isX ? ax._id + counterPart : counterPart + ax._id;
            if (!nextBestMainSubplotID) nextBestMainSubplotID = id;
            var counterAx = axisIDs.getFromId(mockGd, counterPart);
            if (anchorID && counterAx.overlaying === anchorID) {
              mainSubplotID = id;
              break;
            }
          }
        }
        return mainSubplotID || nextBestMainSubplotID;
      }
      plots.clearExpandedTraceDefaultColors = function(trace) {
        var colorAttrs, path, i;
        function locateColorAttrs(attr, attrName, attrs, level) {
          path[level] = attrName;
          path.length = level + 1;
          if (attr.valType === "color" && attr.dflt === void 0) {
            colorAttrs.push(path.join("."));
          }
        }
        path = [];
        colorAttrs = trace._module._colorAttrs;
        if (!colorAttrs) {
          trace._module._colorAttrs = colorAttrs = [];
          PlotSchema.crawl(
            trace._module.attributes,
            locateColorAttrs
          );
        }
        for (i = 0; i < colorAttrs.length; i++) {
          var origprop = Lib.nestedProperty(trace, "_input." + colorAttrs[i]);
          if (!origprop.get()) {
            Lib.nestedProperty(trace, colorAttrs[i]).set(null);
          }
        }
      };
      plots.supplyDataDefaults = function(dataIn, dataOut, layout, fullLayout) {
        var modules = fullLayout._modules;
        var visibleModules = fullLayout._visibleModules;
        var basePlotModules = fullLayout._basePlotModules;
        var cnt = 0;
        var colorCnt = 0;
        var i, fullTrace, trace;
        fullLayout._transformModules = [];
        function pushModule(fullTrace2) {
          dataOut.push(fullTrace2);
          var _module = fullTrace2._module;
          if (!_module) return;
          Lib.pushUnique(modules, _module);
          if (fullTrace2.visible === true) Lib.pushUnique(visibleModules, _module);
          Lib.pushUnique(basePlotModules, fullTrace2._module.basePlotModule);
          cnt++;
          if (fullTrace2._input.visible !== false) colorCnt++;
        }
        var carpetIndex = {};
        var carpetDependents = [];
        var dataTemplate = (layout.template || {}).data || {};
        var templater = Template.traceTemplater(dataTemplate);
        for (i = 0; i < dataIn.length; i++) {
          trace = dataIn[i];
          fullTrace = templater.newTrace(trace);
          fullTrace.uid = fullLayout._traceUids[i];
          plots.supplyTraceDefaults(trace, fullTrace, colorCnt, fullLayout, i);
          fullTrace.index = i;
          fullTrace._input = trace;
          fullTrace._fullInput = fullTrace;
          pushModule(fullTrace);
          if (Registry.traceIs(fullTrace, "carpetAxis")) {
            carpetIndex[fullTrace.carpet] = fullTrace;
          }
          if (Registry.traceIs(fullTrace, "carpetDependent")) {
            carpetDependents.push(i);
          }
        }
        for (i = 0; i < carpetDependents.length; i++) {
          fullTrace = dataOut[carpetDependents[i]];
          if (!fullTrace.visible) continue;
          var carpetAxis = carpetIndex[fullTrace.carpet];
          fullTrace._carpet = carpetAxis;
          if (!carpetAxis || !carpetAxis.visible) {
            fullTrace.visible = false;
            continue;
          }
          fullTrace.xaxis = carpetAxis.xaxis;
          fullTrace.yaxis = carpetAxis.yaxis;
        }
      };
      plots.supplyAnimationDefaults = function(opts) {
        opts = opts || {};
        var i;
        var optsOut = {};
        function coerce(attr, dflt) {
          return Lib.coerce(opts || {}, optsOut, animationAttrs, attr, dflt);
        }
        coerce("mode");
        coerce("direction");
        coerce("fromcurrent");
        if (Array.isArray(opts.frame)) {
          optsOut.frame = [];
          for (i = 0; i < opts.frame.length; i++) {
            optsOut.frame[i] = plots.supplyAnimationFrameDefaults(opts.frame[i] || {});
          }
        } else {
          optsOut.frame = plots.supplyAnimationFrameDefaults(opts.frame || {});
        }
        if (Array.isArray(opts.transition)) {
          optsOut.transition = [];
          for (i = 0; i < opts.transition.length; i++) {
            optsOut.transition[i] = plots.supplyAnimationTransitionDefaults(opts.transition[i] || {});
          }
        } else {
          optsOut.transition = plots.supplyAnimationTransitionDefaults(opts.transition || {});
        }
        return optsOut;
      };
      plots.supplyAnimationFrameDefaults = function(opts) {
        var optsOut = {};
        function coerce(attr, dflt) {
          return Lib.coerce(opts || {}, optsOut, animationAttrs.frame, attr, dflt);
        }
        coerce("duration");
        coerce("redraw");
        return optsOut;
      };
      plots.supplyAnimationTransitionDefaults = function(opts) {
        var optsOut = {};
        function coerce(attr, dflt) {
          return Lib.coerce(opts || {}, optsOut, animationAttrs.transition, attr, dflt);
        }
        coerce("duration");
        coerce("easing");
        return optsOut;
      };
      plots.supplyFrameDefaults = function(frameIn) {
        var frameOut = {};
        function coerce(attr, dflt) {
          return Lib.coerce(frameIn, frameOut, frameAttrs, attr, dflt);
        }
        coerce("group");
        coerce("name");
        coerce("traces");
        coerce("baseframe");
        coerce("data");
        coerce("layout");
        return frameOut;
      };
      plots.supplyTraceDefaults = function(traceIn, traceOut, colorIndex, layout, traceInIndex) {
        var colorway = layout.colorway || Color2.defaults;
        var defaultColor = colorway[colorIndex % colorway.length];
        var i;
        function coerce(attr, dflt) {
          return Lib.coerce(traceIn, traceOut, plots.attributes, attr, dflt);
        }
        var visible = coerce("visible");
        coerce("type");
        coerce("name", layout._traceWord + " " + traceInIndex);
        coerce("uirevision", layout.uirevision);
        var _module = plots.getModule(traceOut);
        traceOut._module = _module;
        if (_module) {
          var basePlotModule = _module.basePlotModule;
          var subplotAttr = basePlotModule.attr;
          var subplotAttrs = basePlotModule.attributes;
          if (subplotAttr && subplotAttrs) {
            var subplots = layout._subplots;
            var subplotId = "";
            if (Array.isArray(subplotAttr)) {
              for (i = 0; i < subplotAttr.length; i++) {
                var attri = subplotAttr[i];
                var vali = Lib.coerce(traceIn, traceOut, subplotAttrs, attri);
                if (subplots[attri]) Lib.pushUnique(subplots[attri], vali);
                subplotId += vali;
              }
            } else {
              subplotId = Lib.coerce(traceIn, traceOut, subplotAttrs, subplotAttr);
            }
            if (subplots[basePlotModule.name]) {
              Lib.pushUnique(subplots[basePlotModule.name], subplotId);
            }
          }
        }
        if (visible) {
          coerce("customdata");
          coerce("ids");
          coerce("meta");
          if (Registry.traceIs(traceOut, "showLegend")) {
            Lib.coerce(
              traceIn,
              traceOut,
              _module.attributes.showlegend ? _module.attributes : plots.attributes,
              "showlegend"
            );
            coerce("legend");
            coerce("legendwidth");
            coerce("legendgroup");
            coerce("legendgrouptitle.text");
            coerce("legendrank");
            traceOut._dfltShowLegend = true;
          } else {
            traceOut._dfltShowLegend = false;
          }
          if (_module) {
            _module.supplyDefaults(traceIn, traceOut, defaultColor, layout);
          }
          if (!Registry.traceIs(traceOut, "noOpacity")) {
            coerce("opacity");
          }
          if (Registry.traceIs(traceOut, "notLegendIsolatable")) {
            traceOut.visible = !!traceOut.visible;
          }
          if (!Registry.traceIs(traceOut, "noHover")) {
            if (!traceOut.hovertemplate) Lib.coerceHoverinfo(traceIn, traceOut, layout);
            if (traceOut.type !== "parcats") {
              Registry.getComponentMethod("fx", "supplyDefaults")(traceIn, traceOut, defaultColor, layout);
            }
          }
          if (_module && _module.selectPoints) {
            var selectedpoints = coerce("selectedpoints");
            if (Lib.isTypedArray(selectedpoints)) {
              traceOut.selectedpoints = Array.from(selectedpoints);
            }
          }
        }
        return traceOut;
      };
      plots.supplyLayoutGlobalDefaults = function(layoutIn, layoutOut, formatObj) {
        function coerce(attr, dflt) {
          return Lib.coerce(layoutIn, layoutOut, plots.layoutAttributes, attr, dflt);
        }
        var template = layoutIn.template;
        if (Lib.isPlainObject(template)) {
          layoutOut.template = template;
          layoutOut._template = template.layout;
          layoutOut._dataTemplate = template.data;
        }
        coerce("autotypenumbers");
        var font = Lib.coerceFont(coerce, "font");
        var fontSize = font.size;
        Lib.coerceFont(coerce, "title.font", font, { overrideDflt: {
          size: Math.round(fontSize * 1.4)
        } });
        coerce("title.text", layoutOut._dfltTitle.plot);
        coerce("title.xref");
        var titleYref = coerce("title.yref");
        coerce("title.pad.t");
        coerce("title.pad.r");
        coerce("title.pad.b");
        coerce("title.pad.l");
        var titleAutomargin = coerce("title.automargin");
        coerce("title.x");
        coerce("title.xanchor");
        coerce("title.y");
        coerce("title.yanchor");
        coerce("title.subtitle.text", layoutOut._dfltTitle.subtitle);
        Lib.coerceFont(coerce, "title.subtitle.font", font, {
          overrideDflt: {
            size: Math.round(layoutOut.title.font.size * 0.7)
          }
        });
        if (titleAutomargin) {
          if (titleYref === "paper") {
            if (layoutOut.title.y !== 0) layoutOut.title.y = 1;
            if (layoutOut.title.yanchor === "auto") {
              layoutOut.title.yanchor = layoutOut.title.y === 0 ? "top" : "bottom";
            }
          }
          if (titleYref === "container") {
            if (layoutOut.title.y === "auto") layoutOut.title.y = 1;
            if (layoutOut.title.yanchor === "auto") {
              layoutOut.title.yanchor = layoutOut.title.y < 0.5 ? "bottom" : "top";
            }
          }
        }
        var uniformtextMode = coerce("uniformtext.mode");
        if (uniformtextMode) {
          coerce("uniformtext.minsize");
        }
        coerce("autosize", !(layoutIn.width && layoutIn.height));
        coerce("width");
        coerce("height");
        coerce("minreducedwidth");
        coerce("minreducedheight");
        coerce("margin.l");
        coerce("margin.r");
        coerce("margin.t");
        coerce("margin.b");
        coerce("margin.pad");
        coerce("margin.autoexpand");
        if (layoutIn.width && layoutIn.height) plots.sanitizeMargins(layoutOut);
        Registry.getComponentMethod("grid", "sizeDefaults")(layoutIn, layoutOut);
        coerce("paper_bgcolor");
        coerce("separators", formatObj.decimal + formatObj.thousands);
        coerce("hidesources");
        coerce("colorway");
        coerce("datarevision");
        var uirevision = coerce("uirevision");
        coerce("editrevision", uirevision);
        coerce("selectionrevision", uirevision);
        Registry.getComponentMethod(
          "modebar",
          "supplyLayoutDefaults"
        )(layoutIn, layoutOut);
        Registry.getComponentMethod(
          "shapes",
          "supplyDrawNewShapeDefaults"
        )(layoutIn, layoutOut, coerce);
        Registry.getComponentMethod(
          "selections",
          "supplyDrawNewSelectionDefaults"
        )(layoutIn, layoutOut, coerce);
        coerce("meta");
        if (Lib.isPlainObject(layoutIn.transition)) {
          coerce("transition.duration");
          coerce("transition.easing");
          coerce("transition.ordering");
        }
        Registry.getComponentMethod(
          "calendars",
          "handleDefaults"
        )(layoutIn, layoutOut, "calendar");
        Registry.getComponentMethod(
          "fx",
          "supplyLayoutGlobalDefaults"
        )(layoutIn, layoutOut, coerce);
        Lib.coerce(layoutIn, layoutOut, scatterAttrs, "scattermode");
      };
      function getComputedSize(attr) {
        return typeof attr === "string" && attr.substr(attr.length - 2) === "px" && parseFloat(attr);
      }
      plots.plotAutoSize = function plotAutoSize(gd, layout, fullLayout) {
        var context = gd._context || {};
        var frameMargins = context.frameMargins;
        var newWidth;
        var newHeight;
        var isPlotDiv = Lib.isPlotDiv(gd);
        if (isPlotDiv) gd.emit("plotly_autosize");
        if (context.fillFrame) {
          newWidth = window.innerWidth;
          newHeight = window.innerHeight;
          document.body.style.overflow = "hidden";
        } else {
          var computedStyle = isPlotDiv ? window.getComputedStyle(gd) : {};
          newWidth = getComputedSize(computedStyle.width) || getComputedSize(computedStyle.maxWidth) || fullLayout.width;
          newHeight = getComputedSize(computedStyle.height) || getComputedSize(computedStyle.maxHeight) || fullLayout.height;
          if (isNumeric(frameMargins) && frameMargins > 0) {
            var factor = 1 - 2 * frameMargins;
            newWidth = Math.round(factor * newWidth);
            newHeight = Math.round(factor * newHeight);
          }
        }
        var minWidth = plots.layoutAttributes.width.min;
        var minHeight = plots.layoutAttributes.height.min;
        if (newWidth < minWidth) newWidth = minWidth;
        if (newHeight < minHeight) newHeight = minHeight;
        var widthHasChanged = !layout.width && Math.abs(fullLayout.width - newWidth) > 1;
        var heightHasChanged = !layout.height && Math.abs(fullLayout.height - newHeight) > 1;
        if (heightHasChanged || widthHasChanged) {
          if (widthHasChanged) fullLayout.width = newWidth;
          if (heightHasChanged) fullLayout.height = newHeight;
        }
        if (!gd._initialAutoSize) {
          gd._initialAutoSize = { width: newWidth, height: newHeight };
        }
        plots.sanitizeMargins(fullLayout);
      };
      plots.supplyLayoutModuleDefaults = function(layoutIn, layoutOut, fullData, transitionData) {
        var componentsRegistry = Registry.componentsRegistry;
        var basePlotModules = layoutOut._basePlotModules;
        var component, i, _module;
        var Cartesian = Registry.subplotsRegistry.cartesian;
        for (component in componentsRegistry) {
          _module = componentsRegistry[component];
          if (_module.includeBasePlot) {
            _module.includeBasePlot(layoutIn, layoutOut);
          }
        }
        if (!basePlotModules.length) {
          basePlotModules.push(Cartesian);
        }
        if (layoutOut._has("cartesian")) {
          Registry.getComponentMethod("grid", "contentDefaults")(layoutIn, layoutOut);
          Cartesian.finalizeSubplots(layoutIn, layoutOut);
        }
        for (var subplotType in layoutOut._subplots) {
          layoutOut._subplots[subplotType].sort(Lib.subplotSort);
        }
        for (i = 0; i < basePlotModules.length; i++) {
          _module = basePlotModules[i];
          if (_module.supplyLayoutDefaults) {
            _module.supplyLayoutDefaults(layoutIn, layoutOut, fullData);
          }
        }
        var modules = layoutOut._modules;
        for (i = 0; i < modules.length; i++) {
          _module = modules[i];
          if (_module.supplyLayoutDefaults) {
            _module.supplyLayoutDefaults(layoutIn, layoutOut, fullData);
          }
        }
        var transformModules = layoutOut._transformModules;
        for (i = 0; i < transformModules.length; i++) {
          _module = transformModules[i];
          if (_module.supplyLayoutDefaults) {
            _module.supplyLayoutDefaults(layoutIn, layoutOut, fullData, transitionData);
          }
        }
        for (component in componentsRegistry) {
          _module = componentsRegistry[component];
          if (_module.supplyLayoutDefaults) {
            _module.supplyLayoutDefaults(layoutIn, layoutOut, fullData);
          }
        }
      };
      plots.purge = function(gd) {
        var fullLayout = gd._fullLayout || {};
        if (fullLayout._glcontainer !== void 0) {
          fullLayout._glcontainer.selectAll(".gl-canvas").remove();
          fullLayout._glcontainer.remove();
          fullLayout._glcanvas = null;
        }
        if (fullLayout._modeBar) fullLayout._modeBar.destroy();
        if (gd._transitionData) {
          if (gd._transitionData._interruptCallbacks) {
            gd._transitionData._interruptCallbacks.length = 0;
          }
          if (gd._transitionData._animationRaf) {
            window.cancelAnimationFrame(gd._transitionData._animationRaf);
          }
        }
        Lib.clearThrottle();
        Lib.clearResponsive(gd);
        delete gd.data;
        delete gd.layout;
        delete gd._fullData;
        delete gd._fullLayout;
        delete gd.calcdata;
        delete gd.empty;
        delete gd.fid;
        delete gd.undoqueue;
        delete gd.undonum;
        delete gd.autoplay;
        delete gd.changed;
        delete gd._promises;
        delete gd._redrawTimer;
        delete gd._hmlumcount;
        delete gd._hmpixcount;
        delete gd._transitionData;
        delete gd._transitioning;
        delete gd._initialAutoSize;
        delete gd._transitioningWithDuration;
        delete gd._dragging;
        delete gd._dragged;
        delete gd._dragdata;
        delete gd._hoverdata;
        delete gd._snapshotInProgress;
        delete gd._editing;
        delete gd._mouseDownTime;
        delete gd._legendMouseDownTime;
        if (gd.removeAllListeners) gd.removeAllListeners();
      };
      plots.style = function(gd) {
        var _modules = gd._fullLayout._visibleModules;
        var styleModules = [];
        var i;
        for (i = 0; i < _modules.length; i++) {
          var _module = _modules[i];
          if (_module.style) {
            Lib.pushUnique(styleModules, _module.style);
          }
        }
        for (i = 0; i < styleModules.length; i++) {
          styleModules[i](gd);
        }
      };
      plots.sanitizeMargins = function(fullLayout) {
        if (!fullLayout || !fullLayout.margin) return;
        var width = fullLayout.width;
        var height = fullLayout.height;
        var margin = fullLayout.margin;
        var plotWidth = width - (margin.l + margin.r);
        var plotHeight = height - (margin.t + margin.b);
        var correction;
        if (plotWidth < 0) {
          correction = (width - 1) / (margin.l + margin.r);
          margin.l = Math.floor(correction * margin.l);
          margin.r = Math.floor(correction * margin.r);
        }
        if (plotHeight < 0) {
          correction = (height - 1) / (margin.t + margin.b);
          margin.t = Math.floor(correction * margin.t);
          margin.b = Math.floor(correction * margin.b);
        }
      };
      plots.clearAutoMarginIds = function(gd) {
        gd._fullLayout._pushmarginIds = {};
      };
      plots.allowAutoMargin = function(gd, id) {
        gd._fullLayout._pushmarginIds[id] = 1;
      };
      function initMargins(fullLayout) {
        var margin = fullLayout.margin;
        if (!fullLayout._size) {
          var gs = fullLayout._size = {
            l: Math.round(margin.l),
            r: Math.round(margin.r),
            t: Math.round(margin.t),
            b: Math.round(margin.b),
            p: Math.round(margin.pad)
          };
          gs.w = Math.round(fullLayout.width) - gs.l - gs.r;
          gs.h = Math.round(fullLayout.height) - gs.t - gs.b;
        }
        if (!fullLayout._pushmargin) fullLayout._pushmargin = {};
        if (!fullLayout._pushmarginIds) fullLayout._pushmarginIds = {};
        if (!fullLayout._reservedMargin) fullLayout._reservedMargin = {};
      }
      var MIN_SPECIFIED_WIDTH = 2;
      var MIN_SPECIFIED_HEIGHT = 2;
      plots.autoMargin = function(gd, id, o) {
        var fullLayout = gd._fullLayout;
        var width = fullLayout.width;
        var height = fullLayout.height;
        var margin = fullLayout.margin;
        var minreducedwidth = fullLayout.minreducedwidth;
        var minreducedheight = fullLayout.minreducedheight;
        var minFinalWidth = Lib.constrain(
          width - margin.l - margin.r,
          MIN_SPECIFIED_WIDTH,
          minreducedwidth
        );
        var minFinalHeight = Lib.constrain(
          height - margin.t - margin.b,
          MIN_SPECIFIED_HEIGHT,
          minreducedheight
        );
        var maxSpaceW = Math.max(0, width - minFinalWidth);
        var maxSpaceH = Math.max(0, height - minFinalHeight);
        var pushMargin = fullLayout._pushmargin;
        var pushMarginIds = fullLayout._pushmarginIds;
        if (margin.autoexpand !== false) {
          if (!o) {
            delete pushMargin[id];
            delete pushMarginIds[id];
          } else {
            var pad = o.pad;
            if (pad === void 0) {
              pad = Math.min(12, margin.l, margin.r, margin.t, margin.b);
            }
            if (maxSpaceW) {
              var rW = (o.l + o.r) / maxSpaceW;
              if (rW > 1) {
                o.l /= rW;
                o.r /= rW;
              }
            }
            if (maxSpaceH) {
              var rH = (o.t + o.b) / maxSpaceH;
              if (rH > 1) {
                o.t /= rH;
                o.b /= rH;
              }
            }
            var xl = o.xl !== void 0 ? o.xl : o.x;
            var xr = o.xr !== void 0 ? o.xr : o.x;
            var yt = o.yt !== void 0 ? o.yt : o.y;
            var yb = o.yb !== void 0 ? o.yb : o.y;
            pushMargin[id] = {
              l: { val: xl, size: o.l + pad },
              r: { val: xr, size: o.r + pad },
              b: { val: yb, size: o.b + pad },
              t: { val: yt, size: o.t + pad }
            };
            pushMarginIds[id] = 1;
          }
          if (!fullLayout._replotting) {
            return plots.doAutoMargin(gd);
          }
        }
      };
      function needsRedrawForShift(gd) {
        if ("_redrawFromAutoMarginCount" in gd._fullLayout) {
          return false;
        }
        var axList = axisIDs.list(gd, "", true);
        for (var ax in axList) {
          if (axList[ax].autoshift || axList[ax].shift) return true;
        }
        return false;
      }
      plots.doAutoMargin = function(gd) {
        var fullLayout = gd._fullLayout;
        var width = fullLayout.width;
        var height = fullLayout.height;
        if (!fullLayout._size) fullLayout._size = {};
        initMargins(fullLayout);
        var gs = fullLayout._size;
        var margin = fullLayout.margin;
        var reservedMargins = { t: 0, b: 0, l: 0, r: 0 };
        var oldMargins = Lib.extendFlat({}, gs);
        var ml = margin.l;
        var mr = margin.r;
        var mt = margin.t;
        var mb = margin.b;
        var pushMargin = fullLayout._pushmargin;
        var pushMarginIds = fullLayout._pushmarginIds;
        var minreducedwidth = fullLayout.minreducedwidth;
        var minreducedheight = fullLayout.minreducedheight;
        if (margin.autoexpand !== false) {
          for (var k in pushMargin) {
            if (!pushMarginIds[k]) delete pushMargin[k];
          }
          var margins = gd._fullLayout._reservedMargin;
          for (var key in margins) {
            for (var side in margins[key]) {
              var val = margins[key][side];
              reservedMargins[side] = Math.max(reservedMargins[side], val);
            }
          }
          pushMargin.base = {
            l: { val: 0, size: ml },
            r: { val: 1, size: mr },
            t: { val: 1, size: mt },
            b: { val: 0, size: mb }
          };
          for (var s in reservedMargins) {
            var autoMarginPush = 0;
            for (var m in pushMargin) {
              if (m !== "base") {
                if (isNumeric(pushMargin[m][s].size)) {
                  autoMarginPush = pushMargin[m][s].size > autoMarginPush ? pushMargin[m][s].size : autoMarginPush;
                }
              }
            }
            var extraMargin = Math.max(0, margin[s] - autoMarginPush);
            reservedMargins[s] = Math.max(0, reservedMargins[s] - extraMargin);
          }
          for (var k1 in pushMargin) {
            var pushleft = pushMargin[k1].l || {};
            var pushbottom = pushMargin[k1].b || {};
            var fl = pushleft.val;
            var pl = pushleft.size;
            var fb = pushbottom.val;
            var pb = pushbottom.size;
            var availableWidth = width - reservedMargins.r - reservedMargins.l;
            var availableHeight = height - reservedMargins.t - reservedMargins.b;
            for (var k2 in pushMargin) {
              if (isNumeric(pl) && pushMargin[k2].r) {
                var fr = pushMargin[k2].r.val;
                var pr = pushMargin[k2].r.size;
                if (fr > fl) {
                  var newL = (pl * fr + (pr - availableWidth) * fl) / (fr - fl);
                  var newR = (pr * (1 - fl) + (pl - availableWidth) * (1 - fr)) / (fr - fl);
                  if (newL + newR > ml + mr) {
                    ml = newL;
                    mr = newR;
                  }
                }
              }
              if (isNumeric(pb) && pushMargin[k2].t) {
                var ft = pushMargin[k2].t.val;
                var pt = pushMargin[k2].t.size;
                if (ft > fb) {
                  var newB = (pb * ft + (pt - availableHeight) * fb) / (ft - fb);
                  var newT = (pt * (1 - fb) + (pb - availableHeight) * (1 - ft)) / (ft - fb);
                  if (newB + newT > mb + mt) {
                    mb = newB;
                    mt = newT;
                  }
                }
              }
            }
          }
        }
        var minFinalWidth = Lib.constrain(
          width - margin.l - margin.r,
          MIN_SPECIFIED_WIDTH,
          minreducedwidth
        );
        var minFinalHeight = Lib.constrain(
          height - margin.t - margin.b,
          MIN_SPECIFIED_HEIGHT,
          minreducedheight
        );
        var maxSpaceW = Math.max(0, width - minFinalWidth);
        var maxSpaceH = Math.max(0, height - minFinalHeight);
        if (maxSpaceW) {
          var rW = (ml + mr) / maxSpaceW;
          if (rW > 1) {
            ml /= rW;
            mr /= rW;
          }
        }
        if (maxSpaceH) {
          var rH = (mb + mt) / maxSpaceH;
          if (rH > 1) {
            mb /= rH;
            mt /= rH;
          }
        }
        gs.l = Math.round(ml) + reservedMargins.l;
        gs.r = Math.round(mr) + reservedMargins.r;
        gs.t = Math.round(mt) + reservedMargins.t;
        gs.b = Math.round(mb) + reservedMargins.b;
        gs.p = Math.round(margin.pad);
        gs.w = Math.round(width) - gs.l - gs.r;
        gs.h = Math.round(height) - gs.t - gs.b;
        if (!fullLayout._replotting && (plots.didMarginChange(oldMargins, gs) || needsRedrawForShift(gd))) {
          if ("_redrawFromAutoMarginCount" in fullLayout) {
            fullLayout._redrawFromAutoMarginCount++;
          } else {
            fullLayout._redrawFromAutoMarginCount = 1;
          }
          var maxNumberOfRedraws = 3 * (1 + Object.keys(pushMarginIds).length);
          if (fullLayout._redrawFromAutoMarginCount < maxNumberOfRedraws) {
            return Registry.call("_doPlot", gd);
          } else {
            fullLayout._size = oldMargins;
            Lib.warn("Too many auto-margin redraws.");
          }
        }
        refineTicks(gd);
      };
      function refineTicks(gd) {
        var axList = axisIDs.list(gd, "", true);
        [
          "_adjustTickLabelsOverflow",
          "_hideCounterAxisInsideTickLabels"
        ].forEach(function(k) {
          for (var i = 0; i < axList.length; i++) {
            var hideFn = axList[i][k];
            if (hideFn) hideFn();
          }
        });
      }
      var marginKeys = ["l", "r", "t", "b", "p", "w", "h"];
      plots.didMarginChange = function(margin0, margin1) {
        for (var i = 0; i < marginKeys.length; i++) {
          var k = marginKeys[i];
          var m0 = margin0[k];
          var m1 = margin1[k];
          if (!isNumeric(m0) || Math.abs(m1 - m0) > 1) {
            return true;
          }
        }
        return false;
      };
      plots.graphJson = function(gd, dataonly, mode, output, useDefaults, includeConfig) {
        if (useDefaults && dataonly && !gd._fullData || useDefaults && !dataonly && !gd._fullLayout) {
          plots.supplyDefaults(gd);
        }
        var data = useDefaults ? gd._fullData : gd.data;
        var layout = useDefaults ? gd._fullLayout : gd.layout;
        var frames = (gd._transitionData || {})._frames;
        function stripObj(d, keepFunction) {
          if (typeof d === "function") {
            return keepFunction ? "_function_" : null;
          }
          if (Lib.isPlainObject(d)) {
            var o = {};
            var src;
            Object.keys(d).sort().forEach(function(v) {
              if (["_", "["].indexOf(v.charAt(0)) !== -1) return;
              if (typeof d[v] === "function") {
                if (keepFunction) o[v] = "_function";
                return;
              }
              if (mode === "keepdata") {
                if (v.substr(v.length - 3) === "src") {
                  return;
                }
              } else if (mode === "keepstream") {
                src = d[v + "src"];
                if (typeof src === "string" && src.indexOf(":") > 0) {
                  if (!Lib.isPlainObject(d.stream)) {
                    return;
                  }
                }
              } else if (mode !== "keepall") {
                src = d[v + "src"];
                if (typeof src === "string" && src.indexOf(":") > 0) {
                  return;
                }
              }
              o[v] = stripObj(d[v], keepFunction);
            });
            return o;
          }
          var dIsArray = Array.isArray(d);
          var dIsTypedArray = Lib.isTypedArray(d);
          if ((dIsArray || dIsTypedArray) && d.dtype && d.shape) {
            var bdata = d.bdata;
            return stripObj({
              dtype: d.dtype,
              shape: d.shape,
              bdata: (
                // case of ArrayBuffer
                Lib.isArrayBuffer(bdata) ? b64encode.encode(bdata) : (
                  // case of b64 string
                  bdata
                )
              )
            }, keepFunction);
          }
          if (dIsArray) {
            return d.map(function(x) {
              return stripObj(x, keepFunction);
            });
          }
          if (dIsTypedArray) {
            return Lib.simpleMap(d, Lib.identity);
          }
          if (Lib.isJSDate(d)) return Lib.ms2DateTimeLocal(+d);
          return d;
        }
        var obj = {
          data: (data || []).map(function(v) {
            var d = stripObj(v);
            if (dataonly) {
              delete d.fit;
            }
            return d;
          })
        };
        if (!dataonly) {
          obj.layout = stripObj(layout);
          if (useDefaults) {
            var gs = layout._size;
            obj.layout.computed = {
              margin: {
                b: gs.b,
                l: gs.l,
                r: gs.r,
                t: gs.t
              }
            };
          }
        }
        if (frames) obj.frames = stripObj(frames);
        if (includeConfig) obj.config = stripObj(gd._context, true);
        return output === "object" ? obj : JSON.stringify(obj);
      };
      plots.modifyFrames = function(gd, operations) {
        var i, op, frame;
        var _frames = gd._transitionData._frames;
        var _frameHash = gd._transitionData._frameHash;
        for (i = 0; i < operations.length; i++) {
          op = operations[i];
          switch (op.type) {
            // No reason this couldn't exist, but is currently unused/untested:
            /* case 'rename':
                frame = _frames[op.index];
                delete _frameHash[frame.name];
                _frameHash[op.name] = frame;
                frame.name = op.name;
                break;*/
            case "replace":
              frame = op.value;
              var oldName = (_frames[op.index] || {}).name;
              var newName = frame.name;
              _frames[op.index] = _frameHash[newName] = frame;
              if (newName !== oldName) {
                delete _frameHash[oldName];
                _frameHash[newName] = frame;
              }
              break;
            case "insert":
              frame = op.value;
              _frameHash[frame.name] = frame;
              _frames.splice(op.index, 0, frame);
              break;
            case "delete":
              frame = _frames[op.index];
              delete _frameHash[frame.name];
              _frames.splice(op.index, 1);
              break;
          }
        }
        return Promise.resolve();
      };
      plots.computeFrame = function(gd, frameName) {
        var frameLookup = gd._transitionData._frameHash;
        var i, traceIndices, traceIndex, destIndex;
        if (!frameName) {
          throw new Error("computeFrame must be given a string frame name");
        }
        var framePtr = frameLookup[frameName.toString()];
        if (!framePtr) {
          return false;
        }
        var frameStack = [framePtr];
        var frameNameStack = [framePtr.name];
        while (framePtr.baseframe && (framePtr = frameLookup[framePtr.baseframe.toString()])) {
          if (frameNameStack.indexOf(framePtr.name) !== -1) break;
          frameStack.push(framePtr);
          frameNameStack.push(framePtr.name);
        }
        var result = {};
        while (framePtr = frameStack.pop()) {
          if (framePtr.layout) {
            result.layout = plots.extendLayout(result.layout, framePtr.layout);
          }
          if (framePtr.data) {
            if (!result.data) {
              result.data = [];
            }
            traceIndices = framePtr.traces;
            if (!traceIndices) {
              traceIndices = [];
              for (i = 0; i < framePtr.data.length; i++) {
                traceIndices[i] = i;
              }
            }
            if (!result.traces) {
              result.traces = [];
            }
            for (i = 0; i < framePtr.data.length; i++) {
              traceIndex = traceIndices[i];
              if (traceIndex === void 0 || traceIndex === null) {
                continue;
              }
              destIndex = result.traces.indexOf(traceIndex);
              if (destIndex === -1) {
                destIndex = result.data.length;
                result.traces[destIndex] = traceIndex;
              }
              result.data[destIndex] = plots.extendTrace(result.data[destIndex], framePtr.data[i]);
            }
          }
        }
        return result;
      };
      plots.recomputeFrameHash = function(gd) {
        var hash = gd._transitionData._frameHash = {};
        var frames = gd._transitionData._frames;
        for (var i = 0; i < frames.length; i++) {
          var frame = frames[i];
          if (frame && frame.name) {
            hash[frame.name] = frame;
          }
        }
      };
      plots.extendObjectWithContainers = function(dest, src, containerPaths) {
        var containerProp, containerVal, i, j, srcProp, destProp, srcContainer, destContainer;
        var copy = Lib.extendDeepNoArrays({}, src || {});
        var expandedObj = Lib.expandObjectPaths(copy);
        var containerObj = {};
        if (containerPaths && containerPaths.length) {
          for (i = 0; i < containerPaths.length; i++) {
            containerProp = Lib.nestedProperty(expandedObj, containerPaths[i]);
            containerVal = containerProp.get();
            if (containerVal === void 0) {
              Lib.nestedProperty(containerObj, containerPaths[i]).set(null);
            } else {
              containerProp.set(null);
              Lib.nestedProperty(containerObj, containerPaths[i]).set(containerVal);
            }
          }
        }
        dest = Lib.extendDeepNoArrays(dest || {}, expandedObj);
        if (containerPaths && containerPaths.length) {
          for (i = 0; i < containerPaths.length; i++) {
            srcProp = Lib.nestedProperty(containerObj, containerPaths[i]);
            srcContainer = srcProp.get();
            if (!srcContainer) continue;
            destProp = Lib.nestedProperty(dest, containerPaths[i]);
            destContainer = destProp.get();
            if (!Array.isArray(destContainer)) {
              destContainer = [];
              destProp.set(destContainer);
            }
            for (j = 0; j < srcContainer.length; j++) {
              var srcObj = srcContainer[j];
              if (srcObj === null) destContainer[j] = null;
              else {
                destContainer[j] = plots.extendObjectWithContainers(destContainer[j], srcObj);
              }
            }
            destProp.set(destContainer);
          }
        }
        return dest;
      };
      plots.dataArrayContainers = ["transforms", "dimensions"];
      plots.layoutArrayContainers = Registry.layoutArrayContainers;
      plots.extendTrace = function(destTrace, srcTrace) {
        return plots.extendObjectWithContainers(destTrace, srcTrace, plots.dataArrayContainers);
      };
      plots.extendLayout = function(destLayout, srcLayout) {
        return plots.extendObjectWithContainers(destLayout, srcLayout, plots.layoutArrayContainers);
      };
      plots.transition = function(gd, data, layout, traces, frameOpts, transitionOpts) {
        var opts = { redraw: frameOpts.redraw };
        var transitionedTraces = {};
        var axEdits = [];
        opts.prepareFn = function() {
          var dataLength = Array.isArray(data) ? data.length : 0;
          var traceIndices = traces.slice(0, dataLength);
          for (var i = 0; i < traceIndices.length; i++) {
            var traceIdx = traceIndices[i];
            var trace = gd._fullData[traceIdx];
            var _module = trace._module;
            if (!_module) continue;
            if (_module.animatable) {
              var n = _module.basePlotModule.name;
              if (!transitionedTraces[n]) transitionedTraces[n] = [];
              transitionedTraces[n].push(traceIdx);
            }
            gd.data[traceIndices[i]] = plots.extendTrace(gd.data[traceIndices[i]], data[i]);
          }
          var layoutUpdate = Lib.expandObjectPaths(Lib.extendDeepNoArrays({}, layout));
          var axisAttrRe = /^[xy]axis[0-9]*$/;
          for (var attr in layoutUpdate) {
            if (!axisAttrRe.test(attr)) continue;
            delete layoutUpdate[attr].range;
          }
          plots.extendLayout(gd.layout, layoutUpdate);
          delete gd.calcdata;
          plots.supplyDefaults(gd);
          plots.doCalcdata(gd);
          var newLayout = Lib.expandObjectPaths(layout);
          if (newLayout) {
            var subplots = gd._fullLayout._plots;
            for (var k in subplots) {
              var plotinfo = subplots[k];
              var xa = plotinfo.xaxis;
              var ya = plotinfo.yaxis;
              var xr0 = xa.range.slice();
              var yr0 = ya.range.slice();
              var xr1 = null;
              var yr1 = null;
              var editX = null;
              var editY = null;
              if (Array.isArray(newLayout[xa._name + ".range"])) {
                xr1 = newLayout[xa._name + ".range"].slice();
              } else if (Array.isArray((newLayout[xa._name] || {}).range)) {
                xr1 = newLayout[xa._name].range.slice();
              }
              if (Array.isArray(newLayout[ya._name + ".range"])) {
                yr1 = newLayout[ya._name + ".range"].slice();
              } else if (Array.isArray((newLayout[ya._name] || {}).range)) {
                yr1 = newLayout[ya._name].range.slice();
              }
              if (xr0 && xr1 && (xa.r2l(xr0[0]) !== xa.r2l(xr1[0]) || xa.r2l(xr0[1]) !== xa.r2l(xr1[1]))) {
                editX = { xr0, xr1 };
              }
              if (yr0 && yr1 && (ya.r2l(yr0[0]) !== ya.r2l(yr1[0]) || ya.r2l(yr0[1]) !== ya.r2l(yr1[1]))) {
                editY = { yr0, yr1 };
              }
              if (editX || editY) {
                axEdits.push(Lib.extendFlat({ plotinfo }, editX, editY));
              }
            }
          }
          return Promise.resolve();
        };
        opts.runFn = function(makeCallback) {
          var traceTransitionOpts;
          var basePlotModules = gd._fullLayout._basePlotModules;
          var hasAxisTransition = axEdits.length;
          var i;
          if (layout) {
            for (i = 0; i < basePlotModules.length; i++) {
              if (basePlotModules[i].transitionAxes) {
                basePlotModules[i].transitionAxes(gd, axEdits, transitionOpts, makeCallback);
              }
            }
          }
          if (hasAxisTransition) {
            traceTransitionOpts = Lib.extendFlat({}, transitionOpts);
            traceTransitionOpts.duration = 0;
            delete transitionedTraces.cartesian;
          } else {
            traceTransitionOpts = transitionOpts;
          }
          for (var n in transitionedTraces) {
            var traceIndices = transitionedTraces[n];
            var _module = gd._fullData[traceIndices[0]]._module;
            _module.basePlotModule.plot(gd, traceIndices, traceTransitionOpts, makeCallback);
          }
        };
        return _transition(gd, transitionOpts, opts);
      };
      plots.transitionFromReact = function(gd, restyleFlags, relayoutFlags, oldFullLayout) {
        var fullLayout = gd._fullLayout;
        var transitionOpts = fullLayout.transition;
        var opts = {};
        var axEdits = [];
        opts.prepareFn = function() {
          var subplots = fullLayout._plots;
          opts.redraw = false;
          if (restyleFlags.anim === "some") opts.redraw = true;
          if (relayoutFlags.anim === "some") opts.redraw = true;
          for (var k in subplots) {
            var plotinfo = subplots[k];
            var xa = plotinfo.xaxis;
            var ya = plotinfo.yaxis;
            var xr0 = oldFullLayout[xa._name].range.slice();
            var yr0 = oldFullLayout[ya._name].range.slice();
            var xr1 = xa.range.slice();
            var yr1 = ya.range.slice();
            xa.setScale();
            ya.setScale();
            var editX = null;
            var editY = null;
            if (xa.r2l(xr0[0]) !== xa.r2l(xr1[0]) || xa.r2l(xr0[1]) !== xa.r2l(xr1[1])) {
              editX = { xr0, xr1 };
            }
            if (ya.r2l(yr0[0]) !== ya.r2l(yr1[0]) || ya.r2l(yr0[1]) !== ya.r2l(yr1[1])) {
              editY = { yr0, yr1 };
            }
            if (editX || editY) {
              axEdits.push(Lib.extendFlat({ plotinfo }, editX, editY));
            }
          }
          return Promise.resolve();
        };
        opts.runFn = function(makeCallback) {
          var fullData = gd._fullData;
          var fullLayout2 = gd._fullLayout;
          var basePlotModules = fullLayout2._basePlotModules;
          var axisTransitionOpts;
          var traceTransitionOpts;
          var transitionedTraces;
          var allTraceIndices = [];
          for (var i = 0; i < fullData.length; i++) {
            allTraceIndices.push(i);
          }
          function transitionAxes() {
            if (!gd._fullLayout) return;
            for (var j = 0; j < basePlotModules.length; j++) {
              if (basePlotModules[j].transitionAxes) {
                basePlotModules[j].transitionAxes(gd, axEdits, axisTransitionOpts, makeCallback);
              }
            }
          }
          function transitionTraces() {
            if (!gd._fullLayout) return;
            for (var j = 0; j < basePlotModules.length; j++) {
              basePlotModules[j].plot(gd, transitionedTraces, traceTransitionOpts, makeCallback);
            }
          }
          if (axEdits.length && restyleFlags.anim) {
            if (transitionOpts.ordering === "traces first") {
              axisTransitionOpts = Lib.extendFlat({}, transitionOpts, { duration: 0 });
              transitionedTraces = allTraceIndices;
              traceTransitionOpts = transitionOpts;
              setTimeout(transitionAxes, transitionOpts.duration);
              transitionTraces();
            } else {
              axisTransitionOpts = transitionOpts;
              transitionedTraces = null;
              traceTransitionOpts = Lib.extendFlat({}, transitionOpts, { duration: 0 });
              setTimeout(transitionTraces, axisTransitionOpts.duration);
              transitionAxes();
            }
          } else if (axEdits.length) {
            axisTransitionOpts = transitionOpts;
            transitionAxes();
          } else if (restyleFlags.anim) {
            transitionedTraces = allTraceIndices;
            traceTransitionOpts = transitionOpts;
            transitionTraces();
          }
        };
        return _transition(gd, transitionOpts, opts);
      };
      function _transition(gd, transitionOpts, opts) {
        var aborted = false;
        function executeCallbacks(list) {
          var p = Promise.resolve();
          if (!list) return p;
          while (list.length) {
            p = p.then(list.shift());
          }
          return p;
        }
        function flushCallbacks(list) {
          if (!list) return;
          while (list.length) {
            list.shift();
          }
        }
        function executeTransitions() {
          gd.emit("plotly_transitioning", []);
          return new Promise(function(resolve) {
            gd._transitioning = true;
            if (transitionOpts.duration > 0) {
              gd._transitioningWithDuration = true;
            }
            gd._transitionData._interruptCallbacks.push(function() {
              aborted = true;
            });
            if (opts.redraw) {
              gd._transitionData._interruptCallbacks.push(function() {
                return Registry.call("redraw", gd);
              });
            }
            gd._transitionData._interruptCallbacks.push(function() {
              gd.emit("plotly_transitioninterrupted", []);
            });
            var numCallbacks = 0;
            var numCompleted = 0;
            function makeCallback() {
              numCallbacks++;
              return function() {
                numCompleted++;
                if (!aborted && numCompleted === numCallbacks) {
                  completeTransition(resolve);
                }
              };
            }
            opts.runFn(makeCallback);
            setTimeout(makeCallback());
          });
        }
        function completeTransition(callback) {
          if (!gd._transitionData) return;
          flushCallbacks(gd._transitionData._interruptCallbacks);
          return Promise.resolve().then(function() {
            if (opts.redraw) {
              return Registry.call("redraw", gd);
            }
          }).then(function() {
            gd._transitioning = false;
            gd._transitioningWithDuration = false;
            gd.emit("plotly_transitioned", []);
          }).then(callback);
        }
        function interruptPreviousTransitions() {
          if (!gd._transitionData) return;
          gd._transitioning = false;
          return executeCallbacks(gd._transitionData._interruptCallbacks);
        }
        var seq = [
          plots.previousPromises,
          interruptPreviousTransitions,
          opts.prepareFn,
          plots.rehover,
          plots.reselect,
          executeTransitions
        ];
        var transitionStarting = Lib.syncOrAsync(seq, gd);
        if (!transitionStarting || !transitionStarting.then) {
          transitionStarting = Promise.resolve();
        }
        return transitionStarting.then(function() {
          return gd;
        });
      }
      plots.doCalcdata = function(gd, traces) {
        var axList = axisIDs.list(gd);
        var fullData = gd._fullData;
        var fullLayout = gd._fullLayout;
        var trace, _module, i, j;
        var calcdata = new Array(fullData.length);
        var oldCalcdata = (gd.calcdata || []).slice();
        gd.calcdata = calcdata;
        fullLayout._numBoxes = 0;
        fullLayout._numViolins = 0;
        fullLayout._violinScaleGroupStats = {};
        gd._hmpixcount = 0;
        gd._hmlumcount = 0;
        fullLayout._piecolormap = {};
        fullLayout._sunburstcolormap = {};
        fullLayout._treemapcolormap = {};
        fullLayout._iciclecolormap = {};
        fullLayout._funnelareacolormap = {};
        for (i = 0; i < fullData.length; i++) {
          if (Array.isArray(traces) && traces.indexOf(i) === -1) {
            calcdata[i] = oldCalcdata[i];
            continue;
          }
        }
        for (i = 0; i < fullData.length; i++) {
          trace = fullData[i];
          trace._arrayAttrs = PlotSchema.findArrayAttributes(trace);
          trace._extremes = {};
        }
        var polarIds = fullLayout._subplots.polar || [];
        for (i = 0; i < polarIds.length; i++) {
          axList.push(
            fullLayout[polarIds[i]].radialaxis,
            fullLayout[polarIds[i]].angularaxis
          );
        }
        for (var k in fullLayout._colorAxes) {
          var cOpts = fullLayout[k];
          if (cOpts.cauto !== false) {
            delete cOpts.cmin;
            delete cOpts.cmax;
          }
        }
        var hasCalcTransform = false;
        function transformCalci(i2) {
          trace = fullData[i2];
          _module = trace._module;
          if (trace.visible === true && trace.transforms) {
            if (_module && _module.calc) {
              var cdi = _module.calc(gd, trace);
              if (cdi[0] && cdi[0].t && cdi[0].t._scene) {
                delete cdi[0].t._scene.dirty;
              }
            }
            for (j = 0; j < trace.transforms.length; j++) {
              var transform = trace.transforms[j];
              _module = transformsRegistry[transform.type];
              if (_module && _module.calcTransform) {
                trace._hasCalcTransform = true;
                hasCalcTransform = true;
                _module.calcTransform(gd, trace, transform);
              }
            }
          }
        }
        function calci(i2, isContainer) {
          trace = fullData[i2];
          _module = trace._module;
          if (!!_module.isContainer !== isContainer) return;
          var cd = [];
          if (trace.visible === true && trace._length !== 0) {
            delete trace._indexToPoints;
            var transforms = trace.transforms || [];
            for (j = transforms.length - 1; j >= 0; j--) {
              if (transforms[j].enabled) {
                trace._indexToPoints = transforms[j]._indexToPoints;
                break;
              }
            }
            if (_module && _module.calc) {
              cd = _module.calc(gd, trace);
            }
          }
          if (!Array.isArray(cd) || !cd[0]) {
            cd = [{ x: BADNUM, y: BADNUM }];
          }
          if (!cd[0].t) cd[0].t = {};
          cd[0].trace = trace;
          calcdata[i2] = cd;
        }
        setupAxisCategories(axList, fullData, fullLayout);
        for (i = 0; i < fullData.length; i++) calci(i, true);
        for (i = 0; i < fullData.length; i++) transformCalci(i);
        if (hasCalcTransform) setupAxisCategories(axList, fullData, fullLayout);
        for (i = 0; i < fullData.length; i++) calci(i, true);
        for (i = 0; i < fullData.length; i++) calci(i, false);
        doCrossTraceCalc(gd);
        var sorted = sortAxisCategoriesByValue(axList, gd);
        if (sorted.length) {
          fullLayout._numBoxes = 0;
          fullLayout._numViolins = 0;
          for (i = 0; i < sorted.length; i++) calci(sorted[i], true);
          for (i = 0; i < sorted.length; i++) calci(sorted[i], false);
          doCrossTraceCalc(gd);
        }
        Registry.getComponentMethod("fx", "calc")(gd);
        Registry.getComponentMethod("errorbars", "calc")(gd);
      };
      var sortAxisCategoriesByValueRegex = /(total|sum|min|max|mean|geometric mean|median) (ascending|descending)/;
      function sortAxisCategoriesByValue(axList, gd) {
        var affectedTraces = [];
        var i, j, k, l, o;
        function zMapCategory(type2, ax2, value2) {
          var axLetter2 = ax2._id.charAt(0);
          if (type2 === "histogram2dcontour") {
            var counterAxLetter = ax2._counterAxes[0];
            var counterAx = axisIDs.getFromId(gd, counterAxLetter);
            var xCategorical = axLetter2 === "x" || counterAxLetter === "x" && counterAx.type === "category";
            var yCategorical = axLetter2 === "y" || counterAxLetter === "y" && counterAx.type === "category";
            return function(o2, l2) {
              if (o2 === 0 || l2 === 0) return -1;
              if (xCategorical && o2 === value2[l2].length - 1) return -1;
              if (yCategorical && l2 === value2.length - 1) return -1;
              return (axLetter2 === "y" ? l2 : o2) - 1;
            };
          } else {
            return function(o2, l2) {
              return axLetter2 === "y" ? l2 : o2;
            };
          }
        }
        var aggFn = {
          min: function(values) {
            return Lib.aggNums(Math.min, null, values);
          },
          max: function(values) {
            return Lib.aggNums(Math.max, null, values);
          },
          sum: function(values) {
            return Lib.aggNums(function(a, b) {
              return a + b;
            }, null, values);
          },
          total: function(values) {
            return Lib.aggNums(function(a, b) {
              return a + b;
            }, null, values);
          },
          mean: function(values) {
            return Lib.mean(values);
          },
          "geometric mean": function(values) {
            return Lib.geometricMean(values);
          },
          median: function(values) {
            return Lib.median(values);
          }
        };
        function sortAscending(a, b) {
          return a[1] - b[1];
        }
        function sortDescending(a, b) {
          return b[1] - a[1];
        }
        for (i = 0; i < axList.length; i++) {
          var ax = axList[i];
          if (ax.type !== "category") continue;
          var match = ax.categoryorder.match(sortAxisCategoriesByValueRegex);
          if (match) {
            var aggregator = match[1];
            var order = match[2];
            var axLetter = ax._id.charAt(0);
            var isX = axLetter === "x";
            var categoriesValue = [];
            for (j = 0; j < ax._categories.length; j++) {
              categoriesValue.push([ax._categories[j], []]);
            }
            for (j = 0; j < ax._traceIndices.length; j++) {
              var traceIndex = ax._traceIndices[j];
              var fullTrace = gd._fullData[traceIndex];
              if (fullTrace.visible !== true) continue;
              var type = fullTrace.type;
              if (Registry.traceIs(fullTrace, "histogram")) {
                delete fullTrace._xautoBinFinished;
                delete fullTrace._yautoBinFinished;
              }
              var isSplom = type === "splom";
              var isScattergl = type === "scattergl";
              var cd = gd.calcdata[traceIndex];
              for (k = 0; k < cd.length; k++) {
                var cdi = cd[k];
                var catIndex, value;
                if (isSplom) {
                  var currentDimensionIndex = fullTrace._axesDim[ax._id];
                  if (!isX) {
                    var associatedXAxisID = fullTrace._diag[currentDimensionIndex][0];
                    if (associatedXAxisID) ax = gd._fullLayout[axisIDs.id2name(associatedXAxisID)];
                  }
                  var categories = cdi.trace.dimensions[currentDimensionIndex].values;
                  for (l = 0; l < categories.length; l++) {
                    catIndex = ax._categoriesMap[categories[l]];
                    for (o = 0; o < cdi.trace.dimensions.length; o++) {
                      if (o === currentDimensionIndex) continue;
                      var dimension = cdi.trace.dimensions[o];
                      categoriesValue[catIndex][1].push(dimension.values[l]);
                    }
                  }
                } else if (isScattergl) {
                  for (l = 0; l < cdi.t.x.length; l++) {
                    if (isX) {
                      catIndex = cdi.t.x[l];
                      value = cdi.t.y[l];
                    } else {
                      catIndex = cdi.t.y[l];
                      value = cdi.t.x[l];
                    }
                    categoriesValue[catIndex][1].push(value);
                  }
                  if (cdi.t && cdi.t._scene) {
                    delete cdi.t._scene.dirty;
                  }
                } else if (cdi.hasOwnProperty("z")) {
                  value = cdi.z;
                  var mapping = zMapCategory(fullTrace.type, ax, value);
                  for (l = 0; l < value.length; l++) {
                    for (o = 0; o < value[l].length; o++) {
                      catIndex = mapping(o, l);
                      if (catIndex + 1) categoriesValue[catIndex][1].push(value[l][o]);
                    }
                  }
                } else {
                  catIndex = cdi.p;
                  if (catIndex === void 0) catIndex = cdi[axLetter];
                  value = cdi.s;
                  if (value === void 0) value = cdi.v;
                  if (value === void 0) value = isX ? cdi.y : cdi.x;
                  if (!Array.isArray(value)) {
                    if (value === void 0) value = [];
                    else value = [value];
                  }
                  for (l = 0; l < value.length; l++) {
                    categoriesValue[catIndex][1].push(value[l]);
                  }
                }
              }
            }
            ax._categoriesValue = categoriesValue;
            var categoriesAggregatedValue = [];
            for (j = 0; j < categoriesValue.length; j++) {
              categoriesAggregatedValue.push([
                categoriesValue[j][0],
                aggFn[aggregator](categoriesValue[j][1])
              ]);
            }
            categoriesAggregatedValue.sort(order === "descending" ? sortDescending : sortAscending);
            ax._categoriesAggregatedValue = categoriesAggregatedValue;
            ax._initialCategories = categoriesAggregatedValue.map(function(c) {
              return c[0];
            });
            affectedTraces = affectedTraces.concat(ax.sortByInitialCategories());
          }
        }
        return affectedTraces;
      }
      function setupAxisCategories(axList, fullData, fullLayout) {
        var axLookup = {};
        function setupOne(ax) {
          ax.clearCalc();
          if (ax.type === "multicategory") {
            ax.setupMultiCategory(fullData);
          }
          axLookup[ax._id] = 1;
        }
        Lib.simpleMap(axList, setupOne);
        var matchGroups = fullLayout._axisMatchGroups || [];
        for (var i = 0; i < matchGroups.length; i++) {
          for (var axId in matchGroups[i]) {
            if (!axLookup[axId]) {
              setupOne(fullLayout[axisIDs.id2name(axId)]);
            }
          }
        }
      }
      function doCrossTraceCalc(gd) {
        var fullLayout = gd._fullLayout;
        var modules = fullLayout._visibleModules;
        var hash = {};
        var i, j, k;
        for (j = 0; j < modules.length; j++) {
          var _module = modules[j];
          var fn = _module.crossTraceCalc;
          if (fn) {
            var spType = _module.basePlotModule.name;
            if (hash[spType]) {
              Lib.pushUnique(hash[spType], fn);
            } else {
              hash[spType] = [fn];
            }
          }
        }
        for (k in hash) {
          var methods = hash[k];
          var subplots = fullLayout._subplots[k];
          if (Array.isArray(subplots)) {
            for (i = 0; i < subplots.length; i++) {
              var sp = subplots[i];
              var spInfo = k === "cartesian" ? fullLayout._plots[sp] : fullLayout[sp];
              for (j = 0; j < methods.length; j++) {
                methods[j](gd, spInfo, sp);
              }
            }
          } else {
            for (j = 0; j < methods.length; j++) {
              methods[j](gd);
            }
          }
        }
      }
      plots.rehover = function(gd) {
        if (gd._fullLayout._rehover) {
          gd._fullLayout._rehover();
        }
      };
      plots.redrag = function(gd) {
        if (gd._fullLayout._redrag) {
          gd._fullLayout._redrag();
        }
      };
      plots.reselect = function(gd) {
        var fullLayout = gd._fullLayout;
        var A2 = (gd.layout || {}).selections;
        var B2 = fullLayout._previousSelections;
        fullLayout._previousSelections = A2;
        var mayEmitSelected = fullLayout._reselect || JSON.stringify(A2) !== JSON.stringify(B2);
        Registry.getComponentMethod("selections", "reselect")(gd, mayEmitSelected);
      };
      plots.generalUpdatePerTraceModule = function(gd, subplot, subplotCalcData, subplotLayout) {
        var traceHashOld = subplot.traceHash;
        var traceHash = {};
        var i;
        for (i = 0; i < subplotCalcData.length; i++) {
          var calcTraces = subplotCalcData[i];
          var trace = calcTraces[0].trace;
          if (trace.visible) {
            traceHash[trace.type] = traceHash[trace.type] || [];
            traceHash[trace.type].push(calcTraces);
          }
        }
        for (var moduleNameOld in traceHashOld) {
          if (!traceHash[moduleNameOld]) {
            var fakeCalcTrace = traceHashOld[moduleNameOld][0];
            var fakeTrace = fakeCalcTrace[0].trace;
            fakeTrace.visible = false;
            traceHash[moduleNameOld] = [fakeCalcTrace];
          }
        }
        for (var moduleName in traceHash) {
          var moduleCalcData = traceHash[moduleName];
          var _module = moduleCalcData[0][0].trace._module;
          _module.plot(gd, subplot, Lib.filterVisible(moduleCalcData), subplotLayout);
        }
        subplot.traceHash = traceHash;
      };
      plots.plotBasePlot = function(desiredType, gd, traces, transitionOpts, makeOnCompleteCallback) {
        var _module = Registry.getModule(desiredType);
        var cdmodule = getModuleCalcData(gd.calcdata, _module)[0];
        _module.plot(gd, cdmodule, transitionOpts, makeOnCompleteCallback);
      };
      plots.cleanBasePlot = function(desiredType, newFullData, newFullLayout, oldFullData, oldFullLayout) {
        var had = oldFullLayout._has && oldFullLayout._has(desiredType);
        var has = newFullLayout._has && newFullLayout._has(desiredType);
        if (had && !has) {
          oldFullLayout["_" + desiredType + "layer"].selectAll("g.trace").remove();
        }
      };
    }
  });

  // src/constants/xmlns_namespaces.js
  var require_xmlns_namespaces = __commonJS({
    "src/constants/xmlns_namespaces.js"(exports) {
      "use strict";
      exports.xmlns = "http://www.w3.org/2000/xmlns/";
      exports.svg = "http://www.w3.org/2000/svg";
      exports.xlink = "http://www.w3.org/1999/xlink";
      exports.svgAttrs = {
        xmlns: exports.svg,
        "xmlns:xlink": exports.xlink
      };
    }
  });

  // src/constants/alignment.js
  var require_alignment = __commonJS({
    "src/constants/alignment.js"(exports, module) {
      "use strict";
      module.exports = {
        // from bottom left: this is the origin of our paper-reference
        // positioning system
        FROM_BL: {
          left: 0,
          center: 0.5,
          right: 1,
          bottom: 0,
          middle: 0.5,
          top: 1
        },
        // from top left: this is the screen pixel positioning origin
        FROM_TL: {
          left: 0,
          center: 0.5,
          right: 1,
          bottom: 1,
          middle: 0.5,
          top: 0
        },
        // from bottom right: sometimes you just need the opposite of ^^
        FROM_BR: {
          left: 1,
          center: 0.5,
          right: 0,
          bottom: 0,
          middle: 0.5,
          top: 1
        },
        // multiple of fontSize to get the vertical offset between lines
        LINE_SPACING: 1.3,
        // multiple of fontSize to shift from the baseline
        // to the cap (captical letter) line
        // (to use when we don't calculate this shift from Drawing.bBox)
        // This is an approximation since in reality cap height can differ
        // from font to font. However, according to Wikipedia
        //   an "average" font might have a cap height of 70% of the em
        // https://en.wikipedia.org/wiki/Em_(typography)#History
        CAP_SHIFT: 0.7,
        // half the cap height (distance between baseline and cap line)
        // of an "average" font (for more info see above).
        MID_SHIFT: 0.35,
        OPPOSITE_SIDE: {
          left: "right",
          right: "left",
          top: "bottom",
          bottom: "top"
        }
      };
    }
  });

  // src/lib/svg_text_utils.js
  var require_svg_text_utils = __commonJS({
    "src/lib/svg_text_utils.js"(exports) {
      "use strict";
      var d3 = require_d3();
      var Lib = require_lib();
      var strTranslate = Lib.strTranslate;
      var xmlnsNamespaces = require_xmlns_namespaces();
      var LINE_SPACING = require_alignment().LINE_SPACING;
      var FIND_TEX = /([^$]*)([$]+[^$]*[$]+)([^$]*)/;
      exports.convertToTspans = function(_context, gd, _callback) {
        var str = _context.text();
        var tex = !_context.attr("data-notex") && gd && gd._context.typesetMath && typeof MathJax !== "undefined" && str.match(FIND_TEX);
        var parent = d3.select(_context.node().parentNode);
        if (parent.empty()) return;
        var svgClass = _context.attr("class") ? _context.attr("class").split(" ")[0] : "text";
        svgClass += "-math";
        parent.selectAll("svg." + svgClass).remove();
        parent.selectAll("g." + svgClass + "-group").remove();
        _context.style("display", null).attr({
          // some callers use data-unformatted *from the <text> element* in 'cancel'
          // so we need it here even if we're going to turn it into math
          // these two (plus style and text-anchor attributes) form the key we're
          // going to use for Drawing.bBox
          "data-unformatted": str,
          "data-math": "N"
        });
        function showText() {
          if (!parent.empty()) {
            svgClass = _context.attr("class") + "-math";
            parent.select("svg." + svgClass).remove();
          }
          _context.text("").style("white-space", "pre");
          var hasLink = buildSVGText(_context.node(), str);
          if (hasLink) {
            _context.style("pointer-events", "all");
          }
          exports.positionText(_context);
          if (_callback) _callback.call(_context);
        }
        if (tex) {
          (gd && gd._promises || []).push(new Promise(function(resolve) {
            _context.style("display", "none");
            var fontSize = parseInt(_context.node().style.fontSize, 10);
            var config = { fontSize };
            texToSVG(tex[2], config, function(_svgEl, _glyphDefs, _svgBBox) {
              parent.selectAll("svg." + svgClass).remove();
              parent.selectAll("g." + svgClass + "-group").remove();
              var newSvg = _svgEl && _svgEl.select("svg");
              if (!newSvg || !newSvg.node()) {
                showText();
                resolve();
                return;
              }
              var mathjaxGroup = parent.append("g").classed(svgClass + "-group", true).attr({
                "pointer-events": "none",
                "data-unformatted": str,
                "data-math": "Y"
              });
              mathjaxGroup.node().appendChild(newSvg.node());
              if (_glyphDefs && _glyphDefs.node()) {
                newSvg.node().insertBefore(
                  _glyphDefs.node().cloneNode(true),
                  newSvg.node().firstChild
                );
              }
              var w0 = _svgBBox.width;
              var h0 = _svgBBox.height;
              newSvg.attr({
                class: svgClass,
                height: h0,
                preserveAspectRatio: "xMinYMin meet"
              }).style({ overflow: "visible", "pointer-events": "none" });
              var fill = _context.node().style.fill || "black";
              var g = newSvg.select("g");
              g.attr({ fill, stroke: fill });
              var bb = g.node().getBoundingClientRect();
              var w = bb.width;
              var h = bb.height;
              if (w > w0 || h > h0) {
                newSvg.style("overflow", "hidden");
                bb = newSvg.node().getBoundingClientRect();
                w = bb.width;
                h = bb.height;
              }
              var x = +_context.attr("x");
              var y = +_context.attr("y");
              var textHeight = fontSize || _context.node().getBoundingClientRect().height;
              var dy = -textHeight / 4;
              if (svgClass[0] === "y") {
                mathjaxGroup.attr({
                  transform: "rotate(" + [-90, x, y] + ")" + strTranslate(-w / 2, dy - h / 2)
                });
              } else if (svgClass[0] === "l") {
                y = dy - h / 2;
              } else if (svgClass[0] === "a" && svgClass.indexOf("atitle") !== 0) {
                x = 0;
                y = dy;
              } else {
                var anchor = _context.attr("text-anchor");
                x = x - w * (anchor === "middle" ? 0.5 : anchor === "end" ? 1 : 0);
                y = y + dy - h / 2;
              }
              newSvg.attr({
                x,
                y
              });
              if (_callback) _callback.call(_context, mathjaxGroup);
              resolve(mathjaxGroup);
            });
          }));
        } else showText();
        return _context;
      };
      var LT_MATCH = /(<|&lt;|&#60;)/g;
      var GT_MATCH = /(>|&gt;|&#62;)/g;
      function cleanEscapesForTex(s) {
        return s.replace(LT_MATCH, "\\lt ").replace(GT_MATCH, "\\gt ");
      }
      var inlineMath = [["$", "$"], ["\\(", "\\)"]];
      function texToSVG(_texString, _config, _callback) {
        var MathJaxVersion = parseInt(
          (MathJax.version || "").split(".")[0]
        );
        if (MathJaxVersion !== 2 && MathJaxVersion !== 3) {
          Lib.warn("No MathJax version:", MathJax.version);
          return;
        }
        var originalRenderer, originalConfig, originalProcessSectionDelay, tmpDiv;
        var setConfig2 = function() {
          originalConfig = Lib.extendDeepAll({}, MathJax.Hub.config);
          originalProcessSectionDelay = MathJax.Hub.processSectionDelay;
          if (MathJax.Hub.processSectionDelay !== void 0) {
            MathJax.Hub.processSectionDelay = 0;
          }
          return MathJax.Hub.Config({
            messageStyle: "none",
            tex2jax: {
              inlineMath
            },
            displayAlign: "left"
          });
        };
        var setConfig3 = function() {
          originalConfig = Lib.extendDeepAll({}, MathJax.config);
          if (!MathJax.config.tex) {
            MathJax.config.tex = {};
          }
          MathJax.config.tex.inlineMath = inlineMath;
        };
        var setRenderer2 = function() {
          originalRenderer = MathJax.Hub.config.menuSettings.renderer;
          if (originalRenderer !== "SVG") {
            return MathJax.Hub.setRenderer("SVG");
          }
        };
        var setRenderer3 = function() {
          originalRenderer = MathJax.config.startup.output;
          if (originalRenderer !== "svg") {
            MathJax.config.startup.output = "svg";
          }
        };
        var initiateMathJax = function() {
          var randomID = "math-output-" + Lib.randstr({}, 64);
          tmpDiv = d3.select("body").append("div").attr({ id: randomID }).style({
            visibility: "hidden",
            position: "absolute",
            "font-size": _config.fontSize + "px"
          }).text(cleanEscapesForTex(_texString));
          var tmpNode = tmpDiv.node();
          return MathJaxVersion === 2 ? MathJax.Hub.Typeset(tmpNode) : MathJax.typeset([tmpNode]);
        };
        var finalizeMathJax = function() {
          var sel = tmpDiv.select(
            MathJaxVersion === 2 ? ".MathJax_SVG" : ".MathJax"
          );
          var node = !sel.empty() && tmpDiv.select("svg").node();
          if (!node) {
            Lib.log("There was an error in the tex syntax.", _texString);
            _callback();
          } else {
            var nodeBBox = node.getBoundingClientRect();
            var glyphDefs;
            if (MathJaxVersion === 2) {
              glyphDefs = d3.select("body").select("#MathJax_SVG_glyphs");
            } else {
              glyphDefs = sel.select("defs");
            }
            _callback(sel, glyphDefs, nodeBBox);
          }
          tmpDiv.remove();
        };
        var resetRenderer2 = function() {
          if (originalRenderer !== "SVG") {
            return MathJax.Hub.setRenderer(originalRenderer);
          }
        };
        var resetRenderer3 = function() {
          if (originalRenderer !== "svg") {
            MathJax.config.startup.output = originalRenderer;
          }
        };
        var resetConfig2 = function() {
          if (originalProcessSectionDelay !== void 0) {
            MathJax.Hub.processSectionDelay = originalProcessSectionDelay;
          }
          return MathJax.Hub.Config(originalConfig);
        };
        var resetConfig3 = function() {
          MathJax.config = originalConfig;
        };
        if (MathJaxVersion === 2) {
          MathJax.Hub.Queue(
            setConfig2,
            setRenderer2,
            initiateMathJax,
            finalizeMathJax,
            resetRenderer2,
            resetConfig2
          );
        } else if (MathJaxVersion === 3) {
          setConfig3();
          setRenderer3();
          MathJax.startup.defaultReady();
          MathJax.startup.promise.then(function() {
            initiateMathJax();
            finalizeMathJax();
            resetRenderer3();
            resetConfig3();
          });
        }
      }
      var TAG_STYLES = {
        // would like to use baseline-shift for sub/sup but FF doesn't support it
        // so we need to use dy along with the uber hacky shift-back-to
        // baseline below
        sup: "font-size:70%",
        sub: "font-size:70%",
        s: "text-decoration:line-through",
        u: "text-decoration:underline",
        b: "font-weight:bold",
        i: "font-style:italic",
        a: "cursor:pointer",
        span: "",
        em: "font-style:italic;font-weight:bold"
      };
      var SHIFT_DY = {
        sub: "0.3em",
        sup: "-0.6em"
      };
      var RESET_DY = {
        sub: "-0.21em",
        sup: "0.42em"
      };
      var ZERO_WIDTH_SPACE = "\u200B";
      var PROTOCOLS = ["http:", "https:", "mailto:", "", void 0, ":"];
      var NEWLINES = exports.NEWLINES = /(\r\n?|\n)/g;
      var SPLIT_TAGS = /(<[^<>]*>)/;
      var ONE_TAG = /<(\/?)([^ >]*)(\s+(.*))?>/i;
      var BR_TAG = /<br(\s+.*)?>/i;
      exports.BR_TAG_ALL = /<br(\s+.*)?>/gi;
      var STYLEMATCH = /(^|[\s"'])style\s*=\s*("([^"]*);?"|'([^']*);?')/i;
      var HREFMATCH = /(^|[\s"'])href\s*=\s*("([^"]*)"|'([^']*)')/i;
      var TARGETMATCH = /(^|[\s"'])target\s*=\s*("([^"\s]*)"|'([^'\s]*)')/i;
      var POPUPMATCH = /(^|[\s"'])popup\s*=\s*("([\w=,]*)"|'([\w=,]*)')/i;
      function getQuotedMatch(_str, re) {
        if (!_str) return null;
        var match = _str.match(re);
        var result = match && (match[3] || match[4]);
        return result && convertEntities(result);
      }
      var COLORMATCH = /(^|;)\s*color:/;
      exports.plainText = function(_str, opts) {
        opts = opts || {};
        var len = opts.len !== void 0 && opts.len !== -1 ? opts.len : Infinity;
        var allowedTags = opts.allowedTags !== void 0 ? opts.allowedTags : ["br"];
        var ellipsis = "...";
        var eLen = ellipsis.length;
        var oldParts = _str.split(SPLIT_TAGS);
        var newParts = [];
        var prevTag = "";
        var l = 0;
        for (var i = 0; i < oldParts.length; i++) {
          var p = oldParts[i];
          var match = p.match(ONE_TAG);
          var tagType = match && match[2].toLowerCase();
          if (tagType) {
            if (allowedTags.indexOf(tagType) !== -1) {
              newParts.push(p);
              prevTag = tagType;
            }
          } else {
            var pLen = p.length;
            if (l + pLen < len) {
              newParts.push(p);
              l += pLen;
            } else if (l < len) {
              var pLen2 = len - l;
              if (prevTag && (prevTag !== "br" || pLen2 <= eLen || pLen <= eLen)) {
                newParts.pop();
              }
              if (len > eLen) {
                newParts.push(p.substr(0, pLen2 - eLen) + ellipsis);
              } else {
                newParts.push(p.substr(0, pLen2));
              }
              break;
            }
            prevTag = "";
          }
        }
        return newParts.join("");
      };
      var entityToUnicode = {
        mu: "\u03BC",
        amp: "&",
        lt: "<",
        gt: ">",
        nbsp: "\xA0",
        times: "\xD7",
        plusmn: "\xB1",
        deg: "\xB0"
      };
      var ENTITY_MATCH = /&(#\d+|#x[\da-fA-F]+|[a-z]+);/g;
      function convertEntities(_str) {
        return _str.replace(ENTITY_MATCH, function(fullMatch, innerMatch) {
          var outChar;
          if (innerMatch.charAt(0) === "#") {
            outChar = fromCodePoint(
              innerMatch.charAt(1) === "x" ? parseInt(innerMatch.substr(2), 16) : parseInt(innerMatch.substr(1), 10)
            );
          } else outChar = entityToUnicode[innerMatch];
          return outChar || fullMatch;
        });
      }
      exports.convertEntities = convertEntities;
      function fromCodePoint(code) {
        if (code > 1114111) return;
        var stringFromCodePoint = String.fromCodePoint;
        if (stringFromCodePoint) return stringFromCodePoint(code);
        var stringFromCharCode = String.fromCharCode;
        if (code <= 65535) return stringFromCharCode(code);
        return stringFromCharCode(
          (code >> 10) + 55232,
          code % 1024 + 56320
        );
      }
      function buildSVGText(containerNode, str) {
        str = str.replace(NEWLINES, " ");
        var hasLink = false;
        var nodeStack = [];
        var currentNode;
        var currentLine = -1;
        function newLine() {
          currentLine++;
          var lineNode = document.createElementNS(xmlnsNamespaces.svg, "tspan");
          d3.select(lineNode).attr({
            class: "line",
            dy: currentLine * LINE_SPACING + "em"
          });
          containerNode.appendChild(lineNode);
          currentNode = lineNode;
          var oldNodeStack = nodeStack;
          nodeStack = [{ node: lineNode }];
          if (oldNodeStack.length > 1) {
            for (var i2 = 1; i2 < oldNodeStack.length; i2++) {
              enterNode(oldNodeStack[i2]);
            }
          }
        }
        function enterNode(nodeSpec2) {
          var type = nodeSpec2.type;
          var nodeAttrs = {};
          var nodeType;
          if (type === "a") {
            nodeType = "a";
            var target = nodeSpec2.target;
            var href2 = nodeSpec2.href;
            var popup = nodeSpec2.popup;
            if (href2) {
              nodeAttrs = {
                "xlink:xlink:show": target === "_blank" || target.charAt(0) !== "_" ? "new" : "replace",
                target,
                "xlink:xlink:href": href2
              };
              if (popup) {
                nodeAttrs.onclick = 'window.open(this.href.baseVal,this.target.baseVal,"' + popup + '");return false;';
              }
            }
          } else nodeType = "tspan";
          if (nodeSpec2.style) nodeAttrs.style = nodeSpec2.style;
          var newNode = document.createElementNS(xmlnsNamespaces.svg, nodeType);
          if (type === "sup" || type === "sub") {
            addTextNode(currentNode, ZERO_WIDTH_SPACE);
            currentNode.appendChild(newNode);
            var resetter = document.createElementNS(xmlnsNamespaces.svg, "tspan");
            addTextNode(resetter, ZERO_WIDTH_SPACE);
            d3.select(resetter).attr("dy", RESET_DY[type]);
            nodeAttrs.dy = SHIFT_DY[type];
            currentNode.appendChild(newNode);
            currentNode.appendChild(resetter);
          } else {
            currentNode.appendChild(newNode);
          }
          d3.select(newNode).attr(nodeAttrs);
          currentNode = nodeSpec2.node = newNode;
          nodeStack.push(nodeSpec2);
        }
        function addTextNode(node, text) {
          node.appendChild(document.createTextNode(text));
        }
        function exitNode(type) {
          if (nodeStack.length === 1) {
            Lib.log("Ignoring unexpected end tag </" + type + ">.", str);
            return;
          }
          var innerNode = nodeStack.pop();
          if (type !== innerNode.type) {
            Lib.log("Start tag <" + innerNode.type + "> doesnt match end tag <" + type + ">. Pretending it did match.", str);
          }
          currentNode = nodeStack[nodeStack.length - 1].node;
        }
        var hasLines = BR_TAG.test(str);
        if (hasLines) newLine();
        else {
          currentNode = containerNode;
          nodeStack = [{ node: containerNode }];
        }
        var parts = str.split(SPLIT_TAGS);
        for (var i = 0; i < parts.length; i++) {
          var parti = parts[i];
          var match = parti.match(ONE_TAG);
          var tagType = match && match[2].toLowerCase();
          var tagStyle = TAG_STYLES[tagType];
          if (tagType === "br") {
            newLine();
          } else if (tagStyle === void 0) {
            addTextNode(currentNode, convertEntities(parti));
          } else {
            if (match[1]) {
              exitNode(tagType);
            } else {
              var extra = match[4];
              var nodeSpec = { type: tagType };
              var css = getQuotedMatch(extra, STYLEMATCH);
              if (css) {
                css = css.replace(COLORMATCH, "$1 fill:");
                if (tagStyle) css += ";" + tagStyle;
              } else if (tagStyle) css = tagStyle;
              if (css) nodeSpec.style = css;
              if (tagType === "a") {
                hasLink = true;
                var href = getQuotedMatch(extra, HREFMATCH);
                if (href) {
                  var safeHref = sanitizeHref(href);
                  if (safeHref) {
                    nodeSpec.href = safeHref;
                    nodeSpec.target = getQuotedMatch(extra, TARGETMATCH) || "_blank";
                    nodeSpec.popup = getQuotedMatch(extra, POPUPMATCH);
                  }
                }
              }
              enterNode(nodeSpec);
            }
          }
        }
        return hasLink;
      }
      function sanitizeHref(href) {
        var decodedHref = encodeURI(decodeURI(href));
        var dummyAnchor1 = document.createElement("a");
        var dummyAnchor2 = document.createElement("a");
        dummyAnchor1.href = href;
        dummyAnchor2.href = decodedHref;
        var p1 = dummyAnchor1.protocol;
        var p2 = dummyAnchor2.protocol;
        if (PROTOCOLS.indexOf(p1) !== -1 && PROTOCOLS.indexOf(p2) !== -1) {
          return decodedHref;
        } else {
          return "";
        }
      }
      exports.sanitizeHTML = function sanitizeHTML(str) {
        str = str.replace(NEWLINES, " ");
        var rootNode = document.createElement("p");
        var currentNode = rootNode;
        var nodeStack = [];
        var parts = str.split(SPLIT_TAGS);
        for (var i = 0; i < parts.length; i++) {
          var parti = parts[i];
          var match = parti.match(ONE_TAG);
          var tagType = match && match[2].toLowerCase();
          if (tagType in TAG_STYLES) {
            if (match[1]) {
              if (nodeStack.length) {
                currentNode = nodeStack.pop();
              }
            } else {
              var extra = match[4];
              var css = getQuotedMatch(extra, STYLEMATCH);
              var nodeAttrs = css ? { style: css } : {};
              if (tagType === "a") {
                var href = getQuotedMatch(extra, HREFMATCH);
                if (href) {
                  var safeHref = sanitizeHref(href);
                  if (safeHref) {
                    nodeAttrs.href = safeHref;
                    var target = getQuotedMatch(extra, TARGETMATCH);
                    if (target) {
                      nodeAttrs.target = target;
                    }
                  }
                }
              }
              var newNode = document.createElement(tagType);
              currentNode.appendChild(newNode);
              d3.select(newNode).attr(nodeAttrs);
              currentNode = newNode;
              nodeStack.push(newNode);
            }
          } else {
            currentNode.appendChild(
              document.createTextNode(convertEntities(parti))
            );
          }
        }
        var key = "innerHTML";
        return rootNode[key];
      };
      exports.lineCount = function lineCount(s) {
        return s.selectAll("tspan.line").size() || 1;
      };
      exports.positionText = function positionText(s, x, y) {
        return s.each(function() {
          var text = d3.select(this);
          function setOrGet(attr, val) {
            if (val === void 0) {
              val = text.attr(attr);
              if (val === null) {
                text.attr(attr, 0);
                val = 0;
              }
            } else text.attr(attr, val);
            return val;
          }
          var thisX = setOrGet("x", x);
          var thisY = setOrGet("y", y);
          if (this.nodeName === "text") {
            text.selectAll("tspan.line").attr({ x: thisX, y: thisY });
          }
        });
      };
      function alignHTMLWith(_base, container, options) {
        var alignH = options.horizontalAlign;
        var alignV = options.verticalAlign || "top";
        var bRect = _base.node().getBoundingClientRect();
        var cRect = container.node().getBoundingClientRect();
        var thisRect;
        var getTop;
        var getLeft;
        if (alignV === "bottom") {
          getTop = function() {
            return bRect.bottom - thisRect.height;
          };
        } else if (alignV === "middle") {
          getTop = function() {
            return bRect.top + (bRect.height - thisRect.height) / 2;
          };
        } else {
          getTop = function() {
            return bRect.top;
          };
        }
        if (alignH === "right") {
          getLeft = function() {
            return bRect.right - thisRect.width;
          };
        } else if (alignH === "center") {
          getLeft = function() {
            return bRect.left + (bRect.width - thisRect.width) / 2;
          };
        } else {
          getLeft = function() {
            return bRect.left;
          };
        }
        return function() {
          thisRect = this.node().getBoundingClientRect();
          var x0 = getLeft() - cRect.left;
          var y0 = getTop() - cRect.top;
          var gd = options.gd || {};
          if (options.gd) {
            gd._fullLayout._calcInverseTransform(gd);
            var transformedCoords = Lib.apply3DTransform(gd._fullLayout._invTransform)(x0, y0);
            x0 = transformedCoords[0];
            y0 = transformedCoords[1];
          }
          this.style({
            top: y0 + "px",
            left: x0 + "px",
            "z-index": 1e3
          });
          return this;
        };
      }
      var onePx = "1px ";
      exports.makeTextShadow = function(color2) {
        var x = onePx;
        var y = onePx;
        var b = onePx;
        return x + y + b + color2 + ", -" + x + "-" + y + b + color2 + ", " + x + "-" + y + b + color2 + ", -" + x + y + b + color2;
      };
      exports.makeEditable = function(context, options) {
        var gd = options.gd;
        var _delegate = options.delegate;
        var dispatch = d3.dispatch("edit", "input", "cancel");
        var handlerElement = _delegate || context;
        context.style({ "pointer-events": _delegate ? "none" : "all" });
        if (context.size() !== 1) throw new Error("boo");
        function handleClick() {
          appendEditable();
          context.style({ opacity: 0 });
          var svgClass = handlerElement.attr("class");
          var mathjaxClass;
          if (svgClass) mathjaxClass = "." + svgClass.split(" ")[0] + "-math-group";
          else mathjaxClass = "[class*=-math-group]";
          if (mathjaxClass) {
            d3.select(context.node().parentNode).select(mathjaxClass).style({ opacity: 0 });
          }
        }
        function selectElementContents(_el) {
          var el = _el.node();
          var range = document.createRange();
          range.selectNodeContents(el);
          var sel = window.getSelection();
          sel.removeAllRanges();
          sel.addRange(range);
          el.focus();
        }
        function appendEditable() {
          var plotDiv = d3.select(gd);
          var container = plotDiv.select(".svg-container");
          var div = container.append("div");
          var cStyle = context.node().style;
          var fontSize = parseFloat(cStyle.fontSize || 12);
          var initialText = options.text;
          if (initialText === void 0) initialText = context.attr("data-unformatted");
          div.classed("plugin-editable editable", true).style({
            position: "absolute",
            "font-family": cStyle.fontFamily || "Arial",
            "font-size": fontSize,
            color: options.fill || cStyle.fill || "black",
            opacity: 1,
            "background-color": options.background || "transparent",
            outline: "#ffffff33 1px solid",
            margin: [-fontSize / 8 + 1, 0, 0, -1].join("px ") + "px",
            padding: "0",
            "box-sizing": "border-box"
          }).attr({ contenteditable: true }).text(initialText).call(alignHTMLWith(context, container, options)).on("blur", function() {
            gd._editing = false;
            context.text(this.textContent).style({ opacity: 1 });
            var svgClass = d3.select(this).attr("class");
            var mathjaxClass;
            if (svgClass) mathjaxClass = "." + svgClass.split(" ")[0] + "-math-group";
            else mathjaxClass = "[class*=-math-group]";
            if (mathjaxClass) {
              d3.select(context.node().parentNode).select(mathjaxClass).style({ opacity: 0 });
            }
            var text = this.textContent;
            d3.select(this).transition().duration(0).remove();
            d3.select(document).on("mouseup", null);
            dispatch.edit.call(context, text);
          }).on("focus", function() {
            var editDiv = this;
            gd._editing = true;
            d3.select(document).on("mouseup", function() {
              if (d3.event.target === editDiv) return false;
              if (document.activeElement === div.node()) div.node().blur();
            });
          }).on("keyup", function() {
            if (d3.event.which === 27) {
              gd._editing = false;
              context.style({ opacity: 1 });
              d3.select(this).style({ opacity: 0 }).on("blur", function() {
                return false;
              }).transition().remove();
              dispatch.cancel.call(context, this.textContent);
            } else {
              dispatch.input.call(context, this.textContent);
              d3.select(this).call(alignHTMLWith(context, container, options));
            }
          }).on("keydown", function() {
            if (d3.event.which === 13) this.blur();
          }).call(selectElementContents);
        }
        if (options.immediate) handleClick();
        else handlerElement.on("click", handleClick);
        return d3.rebind(context, dispatch, "on");
      };
    }
  });

  // src/components/colorscale/helpers.js
  var require_helpers = __commonJS({
    "src/components/colorscale/helpers.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var tinycolor = require_tinycolor();
      var isNumeric = require_fast_isnumeric();
      var Lib = require_lib();
      var Color2 = require_color();
      var isValidScale = require_scales().isValid;
      function hasColorscale(trace, containerStr, colorKey) {
        var container = containerStr ? Lib.nestedProperty(trace, containerStr).get() || {} : trace;
        var color2 = container[colorKey || "color"];
        if (color2 && color2._inputArray) color2 = color2._inputArray;
        var isArrayWithOneNumber = false;
        if (Lib.isArrayOrTypedArray(color2)) {
          for (var i = 0; i < color2.length; i++) {
            if (isNumeric(color2[i])) {
              isArrayWithOneNumber = true;
              break;
            }
          }
        }
        return Lib.isPlainObject(container) && (isArrayWithOneNumber || container.showscale === true || isNumeric(container.cmin) && isNumeric(container.cmax) || isValidScale(container.colorscale) || Lib.isPlainObject(container.colorbar));
      }
      var constantAttrs = ["showscale", "autocolorscale", "colorscale", "reversescale", "colorbar"];
      var letterAttrs = ["min", "max", "mid", "auto"];
      function extractOpts(cont) {
        var colorAx = cont._colorAx;
        var cont2 = colorAx ? colorAx : cont;
        var out = {};
        var cLetter;
        var i, k;
        for (i = 0; i < constantAttrs.length; i++) {
          k = constantAttrs[i];
          out[k] = cont2[k];
        }
        if (colorAx) {
          cLetter = "c";
          for (i = 0; i < letterAttrs.length; i++) {
            k = letterAttrs[i];
            out[k] = cont2["c" + k];
          }
        } else {
          var k2;
          for (i = 0; i < letterAttrs.length; i++) {
            k = letterAttrs[i];
            k2 = "c" + k;
            if (k2 in cont2) {
              out[k] = cont2[k2];
              continue;
            }
            k2 = "z" + k;
            if (k2 in cont2) {
              out[k] = cont2[k2];
            }
          }
          cLetter = k2.charAt(0);
        }
        out._sync = function(k3, v) {
          var k22 = letterAttrs.indexOf(k3) !== -1 ? cLetter + k3 : k3;
          cont2[k22] = cont2["_" + k22] = v;
        };
        return out;
      }
      function extractScale(cont) {
        var cOpts = extractOpts(cont);
        var cmin = cOpts.min;
        var cmax = cOpts.max;
        var scl = cOpts.reversescale ? flipScale(cOpts.colorscale) : cOpts.colorscale;
        var N = scl.length;
        var domain = new Array(N);
        var range = new Array(N);
        for (var i = 0; i < N; i++) {
          var si = scl[i];
          domain[i] = cmin + si[0] * (cmax - cmin);
          range[i] = si[1];
        }
        return { domain, range };
      }
      function flipScale(scl) {
        var N = scl.length;
        var sclNew = new Array(N);
        for (var i = N - 1, j = 0; i >= 0; i--, j++) {
          var si = scl[i];
          sclNew[j] = [1 - si[0], si[1]];
        }
        return sclNew;
      }
      function makeColorScaleFunc(specs, opts) {
        opts = opts || {};
        var domain = specs.domain;
        var range = specs.range;
        var N = range.length;
        var _range = new Array(N);
        for (var i = 0; i < N; i++) {
          var rgba2 = tinycolor(range[i]).toRgb();
          _range[i] = [rgba2.r, rgba2.g, rgba2.b, rgba2.a];
        }
        var _sclFunc = d3.scale.linear().domain(domain).range(_range).clamp(true);
        var noNumericCheck = opts.noNumericCheck;
        var returnArray = opts.returnArray;
        var sclFunc;
        if (noNumericCheck && returnArray) {
          sclFunc = _sclFunc;
        } else if (noNumericCheck) {
          sclFunc = function(v) {
            return colorArray2rbga(_sclFunc(v));
          };
        } else if (returnArray) {
          sclFunc = function(v) {
            if (isNumeric(v)) return _sclFunc(v);
            else if (tinycolor(v).isValid()) return v;
            else return Color2.defaultLine;
          };
        } else {
          sclFunc = function(v) {
            if (isNumeric(v)) return colorArray2rbga(_sclFunc(v));
            else if (tinycolor(v).isValid()) return v;
            else return Color2.defaultLine;
          };
        }
        sclFunc.domain = _sclFunc.domain;
        sclFunc.range = function() {
          return range;
        };
        return sclFunc;
      }
      function makeColorScaleFuncFromTrace(trace, opts) {
        return makeColorScaleFunc(extractScale(trace), opts);
      }
      function colorArray2rbga(colorArray) {
        var colorObj = {
          r: colorArray[0],
          g: colorArray[1],
          b: colorArray[2],
          a: colorArray[3]
        };
        return tinycolor(colorObj).toRgbString();
      }
      module.exports = {
        hasColorscale,
        extractOpts,
        extractScale,
        flipScale,
        makeColorScaleFunc,
        makeColorScaleFuncFromTrace
      };
    }
  });

  // src/plots/cartesian/axis_format_attributes.js
  var require_axis_format_attributes = __commonJS({
    "src/plots/cartesian/axis_format_attributes.js"(exports, module) {
      "use strict";
      var docs = require_docs();
      var FORMAT_LINK = docs.FORMAT_LINK;
      var DATE_FORMAT_LINK = docs.DATE_FORMAT_LINK;
      function axisHoverFormat(x, noDates) {
        return {
          valType: "string",
          dflt: "",
          editType: "none",
          description: (noDates ? descriptionOnlyNumbers : descriptionWithDates)("hover text", x) + [
            "By default the values are formatted using " + (noDates ? "generic number format" : "`" + x + "axis.hoverformat`") + "."
          ].join(" ")
        };
      }
      function descriptionOnlyNumbers(label, x) {
        return [
          "Sets the " + label + " formatting rule" + (x ? "for `" + x + "` " : ""),
          "using d3 formatting mini-languages",
          "which are very similar to those in Python. For numbers, see: " + FORMAT_LINK + "."
        ].join(" ");
      }
      function descriptionWithDates(label, x) {
        return descriptionOnlyNumbers(label, x) + [
          " And for dates see: " + DATE_FORMAT_LINK + ".",
          "We add two items to d3's date formatter:",
          "*%h* for half of the year as a decimal number as well as",
          "*%{n}f* for fractional seconds",
          "with n digits. For example, *2016-10-13 09:15:23.456* with tickformat",
          "*%H~%M~%S.%2f* would display *09~15~23.46*"
        ].join(" ");
      }
      module.exports = {
        axisHoverFormat,
        descriptionOnlyNumbers,
        descriptionWithDates
      };
    }
  });

  // src/plots/cartesian/layout_attributes.js
  var require_layout_attributes4 = __commonJS({
    "src/plots/cartesian/layout_attributes.js"(exports, module) {
      "use strict";
      var fontAttrs = require_font_attributes();
      var colorAttrs = require_attributes3();
      var dash = require_attributes4().dash;
      var extendFlat = require_extend().extendFlat;
      var templatedArray = require_plot_template().templatedArray;
      var descriptionWithDates = require_axis_format_attributes().descriptionWithDates;
      var ONEDAY = require_numerical().ONEDAY;
      var constants = require_constants2();
      var HOUR = constants.HOUR_PATTERN;
      var DAY_OF_WEEK = constants.WEEKDAY_PATTERN;
      var minorTickmode = {
        valType: "enumerated",
        values: ["auto", "linear", "array"],
        editType: "ticks",
        impliedEdits: { tick0: void 0, dtick: void 0 }
      };
      var tickmode = extendFlat({}, minorTickmode, {
        values: minorTickmode.values.slice().concat(["sync"])
      });
      function makeNticks(minor) {
        return {
          valType: "integer",
          min: 0,
          dflt: minor ? 5 : 0,
          editType: "ticks"
        };
      }
      var tick0 = {
        valType: "any",
        editType: "ticks",
        impliedEdits: { tickmode: "linear" }
      };
      var dtick = {
        valType: "any",
        editType: "ticks",
        impliedEdits: { tickmode: "linear" }
      };
      var tickvals = {
        valType: "data_array",
        editType: "ticks"
      };
      var ticks = {
        valType: "enumerated",
        values: ["outside", "inside", ""],
        editType: "ticks"
      };
      function makeTicklen(minor) {
        var obj = {
          valType: "number",
          min: 0,
          editType: "ticks"
        };
        if (!minor) obj.dflt = 5;
        return obj;
      }
      function makeTickwidth(minor) {
        var obj = {
          valType: "number",
          min: 0,
          editType: "ticks"
        };
        if (!minor) obj.dflt = 1;
        return obj;
      }
      var tickcolor = {
        valType: "color",
        dflt: colorAttrs.defaultLine,
        editType: "ticks"
      };
      var gridcolor = {
        valType: "color",
        dflt: colorAttrs.lightLine,
        editType: "ticks"
      };
      function makeGridwidth(minor) {
        var obj = {
          valType: "number",
          min: 0,
          editType: "ticks"
        };
        if (!minor) obj.dflt = 1;
        return obj;
      }
      var griddash = extendFlat({}, dash, { editType: "ticks" });
      var showgrid = {
        valType: "boolean",
        editType: "ticks"
      };
      module.exports = {
        visible: {
          valType: "boolean",
          editType: "plot"
        },
        color: {
          valType: "color",
          dflt: colorAttrs.defaultLine,
          editType: "ticks"
        },
        title: {
          text: {
            valType: "string",
            editType: "ticks"
          },
          font: fontAttrs({
            editType: "ticks"
          }),
          standoff: {
            valType: "number",
            min: 0,
            editType: "ticks"
          },
          editType: "ticks"
        },
        type: {
          valType: "enumerated",
          // '-' means we haven't yet run autotype or couldn't find any data
          // it gets turned into linear in gd._fullLayout but not copied back
          // to gd.data like the others are.
          values: ["-", "linear", "log", "date", "category", "multicategory"],
          dflt: "-",
          editType: "calc",
          // we forget when an axis has been autotyped, just writing the auto
          // value back to the input - so it doesn't make sense to template this.
          // Note: we do NOT prohibit this in `coerce`, so if someone enters a
          // type in the template explicitly it will be honored as the default.
          _noTemplating: true
        },
        autotypenumbers: {
          valType: "enumerated",
          values: ["convert types", "strict"],
          dflt: "convert types",
          editType: "calc"
        },
        autorange: {
          valType: "enumerated",
          values: [true, false, "reversed", "min reversed", "max reversed", "min", "max"],
          dflt: true,
          editType: "axrange",
          impliedEdits: { "range[0]": void 0, "range[1]": void 0 }
        },
        autorangeoptions: {
          minallowed: {
            valType: "any",
            editType: "plot",
            impliedEdits: { "range[0]": void 0, "range[1]": void 0 }
          },
          maxallowed: {
            valType: "any",
            editType: "plot",
            impliedEdits: { "range[0]": void 0, "range[1]": void 0 }
          },
          clipmin: {
            valType: "any",
            editType: "plot",
            impliedEdits: { "range[0]": void 0, "range[1]": void 0 }
          },
          clipmax: {
            valType: "any",
            editType: "plot",
            impliedEdits: { "range[0]": void 0, "range[1]": void 0 }
          },
          include: {
            valType: "any",
            arrayOk: true,
            editType: "plot",
            impliedEdits: { "range[0]": void 0, "range[1]": void 0 }
          },
          editType: "plot"
        },
        rangemode: {
          valType: "enumerated",
          values: ["normal", "tozero", "nonnegative"],
          dflt: "normal",
          editType: "plot"
        },
        range: {
          valType: "info_array",
          items: [
            { valType: "any", editType: "axrange", impliedEdits: { "^autorange": false }, anim: true },
            { valType: "any", editType: "axrange", impliedEdits: { "^autorange": false }, anim: true }
          ],
          editType: "axrange",
          impliedEdits: { autorange: false },
          anim: true
        },
        minallowed: {
          valType: "any",
          editType: "plot",
          impliedEdits: { "^autorange": false }
        },
        maxallowed: {
          valType: "any",
          editType: "plot",
          impliedEdits: { "^autorange": false }
        },
        fixedrange: {
          valType: "boolean",
          dflt: false,
          editType: "calc"
        },
        insiderange: {
          valType: "info_array",
          items: [
            { valType: "any", editType: "plot" },
            { valType: "any", editType: "plot" }
          ],
          editType: "plot"
        },
        // scaleanchor: not used directly, just put here for reference
        // values are any opposite-letter axis id, or `false`.
        scaleanchor: {
          valType: "enumerated",
          values: [
            constants.idRegex.x.toString(),
            constants.idRegex.y.toString(),
            false
          ],
          editType: "plot"
        },
        scaleratio: {
          valType: "number",
          min: 0,
          dflt: 1,
          editType: "plot"
        },
        constrain: {
          valType: "enumerated",
          values: ["range", "domain"],
          editType: "plot"
        },
        // constraintoward: not used directly, just put here for reference
        constraintoward: {
          valType: "enumerated",
          values: ["left", "center", "right", "top", "middle", "bottom"],
          editType: "plot"
        },
        matches: {
          valType: "enumerated",
          values: [
            constants.idRegex.x.toString(),
            constants.idRegex.y.toString()
          ],
          editType: "calc"
        },
        rangebreaks: templatedArray("rangebreak", {
          enabled: {
            valType: "boolean",
            dflt: true,
            editType: "calc"
          },
          bounds: {
            valType: "info_array",
            items: [
              { valType: "any", editType: "calc" },
              { valType: "any", editType: "calc" }
            ],
            editType: "calc"
          },
          pattern: {
            valType: "enumerated",
            values: [DAY_OF_WEEK, HOUR, ""],
            editType: "calc"
          },
          values: {
            valType: "info_array",
            freeLength: true,
            editType: "calc",
            items: {
              valType: "any",
              editType: "calc"
            }
          },
          dvalue: {
            // TODO could become 'any' to add support for 'months', 'years'
            valType: "number",
            editType: "calc",
            min: 0,
            dflt: ONEDAY
          },
          /*
          gap: {
              valType: 'number',
              min: 0,
              dflt: 0, // for *date* axes, maybe something else for *linear*
              editType: 'calc',
          },
          gapmode: {
              valType: 'enumerated',
              values: ['pixels', 'fraction'],
              dflt: 'pixels',
              editType: 'calc',
          },
          */
          // To complete https://github.com/plotly/plotly.js/issues/4210
          // we additionally need `gap` and make this work on *linear*, and
          // possibly all other cartesian axis types. We possibly would also need
          // some style attributes controlling the zig-zag on the corresponding
          // axis.
          editType: "calc"
        }),
        // ticks
        tickmode,
        nticks: makeNticks(),
        tick0,
        dtick,
        ticklabelstep: {
          valType: "integer",
          min: 1,
          dflt: 1,
          editType: "ticks"
        },
        tickvals,
        ticktext: {
          valType: "data_array",
          editType: "ticks"
        },
        ticks,
        tickson: {
          valType: "enumerated",
          values: ["labels", "boundaries"],
          dflt: "labels",
          editType: "ticks"
        },
        ticklabelmode: {
          valType: "enumerated",
          values: ["instant", "period"],
          dflt: "instant",
          editType: "ticks"
        },
        // ticklabelposition: not used directly, as values depend on direction (similar to side)
        // left/right options are for x axes, and top/bottom options are for y axes
        ticklabelposition: {
          valType: "enumerated",
          values: [
            "outside",
            "inside",
            "outside top",
            "inside top",
            "outside left",
            "inside left",
            "outside right",
            "inside right",
            "outside bottom",
            "inside bottom"
          ],
          dflt: "outside",
          editType: "calc"
        },
        ticklabeloverflow: {
          valType: "enumerated",
          values: [
            "allow",
            "hide past div",
            "hide past domain"
          ],
          editType: "calc"
        },
        ticklabelshift: {
          valType: "integer",
          dflt: 0,
          editType: "ticks"
        },
        ticklabelstandoff: {
          valType: "integer",
          dflt: 0,
          editType: "ticks"
        },
        ticklabelindex: {
          // in the future maybe add `extras: ['all', 'minor']` to allow showing labels for all ticks
          // or for all minor ticks.
          valType: "integer",
          arrayOk: true,
          editType: "calc"
        },
        mirror: {
          valType: "enumerated",
          values: [true, "ticks", false, "all", "allticks"],
          dflt: false,
          editType: "ticks+layoutstyle"
        },
        ticklen: makeTicklen(),
        tickwidth: makeTickwidth(),
        tickcolor,
        showticklabels: {
          valType: "boolean",
          dflt: true,
          editType: "ticks"
        },
        labelalias: {
          valType: "any",
          dflt: false,
          editType: "ticks"
        },
        automargin: {
          valType: "flaglist",
          flags: ["height", "width", "left", "right", "top", "bottom"],
          extras: [true, false],
          dflt: false,
          editType: "ticks"
        },
        showspikes: {
          valType: "boolean",
          dflt: false,
          editType: "modebar"
        },
        spikecolor: {
          valType: "color",
          dflt: null,
          editType: "none"
        },
        spikethickness: {
          valType: "number",
          dflt: 3,
          editType: "none"
        },
        spikedash: extendFlat({}, dash, { dflt: "dash", editType: "none" }),
        spikemode: {
          valType: "flaglist",
          flags: ["toaxis", "across", "marker"],
          dflt: "toaxis",
          editType: "none"
        },
        spikesnap: {
          valType: "enumerated",
          values: ["data", "cursor", "hovered data"],
          dflt: "hovered data",
          editType: "none"
        },
        tickfont: fontAttrs({
          editType: "ticks"
        }),
        tickangle: {
          valType: "angle",
          dflt: "auto",
          editType: "ticks"
        },
        autotickangles: {
          valType: "info_array",
          freeLength: true,
          items: {
            valType: "angle"
          },
          dflt: [0, 30, 90],
          editType: "ticks"
        },
        tickprefix: {
          valType: "string",
          dflt: "",
          editType: "ticks"
        },
        showtickprefix: {
          valType: "enumerated",
          values: ["all", "first", "last", "none"],
          dflt: "all",
          editType: "ticks"
        },
        ticksuffix: {
          valType: "string",
          dflt: "",
          editType: "ticks"
        },
        showticksuffix: {
          valType: "enumerated",
          values: ["all", "first", "last", "none"],
          dflt: "all",
          editType: "ticks"
        },
        showexponent: {
          valType: "enumerated",
          values: ["all", "first", "last", "none"],
          dflt: "all",
          editType: "ticks"
        },
        exponentformat: {
          valType: "enumerated",
          values: ["none", "e", "E", "power", "SI", "B"],
          dflt: "B",
          editType: "ticks"
        },
        minexponent: {
          valType: "number",
          dflt: 3,
          min: 0,
          editType: "ticks"
        },
        separatethousands: {
          valType: "boolean",
          dflt: false,
          editType: "ticks"
        },
        tickformat: {
          valType: "string",
          dflt: "",
          editType: "ticks",
          description: descriptionWithDates("tick label")
        },
        tickformatstops: templatedArray("tickformatstop", {
          enabled: {
            valType: "boolean",
            dflt: true,
            editType: "ticks"
          },
          dtickrange: {
            valType: "info_array",
            items: [
              { valType: "any", editType: "ticks" },
              { valType: "any", editType: "ticks" }
            ],
            editType: "ticks"
          },
          value: {
            valType: "string",
            dflt: "",
            editType: "ticks"
          },
          editType: "ticks"
        }),
        hoverformat: {
          valType: "string",
          dflt: "",
          editType: "none",
          description: descriptionWithDates("hover text")
        },
        // lines and grids
        showline: {
          valType: "boolean",
          dflt: false,
          editType: "ticks+layoutstyle"
        },
        linecolor: {
          valType: "color",
          dflt: colorAttrs.defaultLine,
          editType: "layoutstyle"
        },
        linewidth: {
          valType: "number",
          min: 0,
          dflt: 1,
          editType: "ticks+layoutstyle"
        },
        showgrid,
        gridcolor,
        gridwidth: makeGridwidth(),
        griddash,
        zeroline: {
          valType: "boolean",
          editType: "ticks"
        },
        zerolinecolor: {
          valType: "color",
          dflt: colorAttrs.defaultLine,
          editType: "ticks"
        },
        zerolinewidth: {
          valType: "number",
          dflt: 1,
          editType: "ticks"
        },
        showdividers: {
          valType: "boolean",
          dflt: true,
          editType: "ticks"
        },
        dividercolor: {
          valType: "color",
          dflt: colorAttrs.defaultLine,
          editType: "ticks"
        },
        dividerwidth: {
          valType: "number",
          dflt: 1,
          editType: "ticks"
        },
        // TODO dividerlen: that would override "to label base" length?
        // positioning attributes
        // anchor: not used directly, just put here for reference
        // values are any opposite-letter axis id
        anchor: {
          valType: "enumerated",
          values: [
            "free",
            constants.idRegex.x.toString(),
            constants.idRegex.y.toString()
          ],
          editType: "plot"
        },
        // side: not used directly, as values depend on direction
        // values are top, bottom for x axes, and left, right for y
        side: {
          valType: "enumerated",
          values: ["top", "bottom", "left", "right"],
          editType: "plot"
        },
        // overlaying: not used directly, just put here for reference
        // values are false and any other same-letter axis id that's not
        // itself overlaying anything
        overlaying: {
          valType: "enumerated",
          values: [
            "free",
            constants.idRegex.x.toString(),
            constants.idRegex.y.toString()
          ],
          editType: "plot"
        },
        minor: {
          tickmode: minorTickmode,
          nticks: makeNticks("minor"),
          tick0,
          dtick,
          tickvals,
          ticks,
          ticklen: makeTicklen("minor"),
          tickwidth: makeTickwidth("minor"),
          tickcolor,
          gridcolor,
          gridwidth: makeGridwidth("minor"),
          griddash,
          showgrid,
          editType: "ticks"
        },
        layer: {
          valType: "enumerated",
          values: ["above traces", "below traces"],
          dflt: "above traces",
          editType: "plot"
        },
        domain: {
          valType: "info_array",
          items: [
            { valType: "number", min: 0, max: 1, editType: "plot" },
            { valType: "number", min: 0, max: 1, editType: "plot" }
          ],
          dflt: [0, 1],
          editType: "plot"
        },
        position: {
          valType: "number",
          min: 0,
          max: 1,
          dflt: 0,
          editType: "plot"
        },
        autoshift: {
          valType: "boolean",
          dflt: false,
          editType: "plot"
        },
        shift: {
          valType: "number",
          editType: "plot"
        },
        categoryorder: {
          valType: "enumerated",
          values: [
            "trace",
            "category ascending",
            "category descending",
            "array",
            "total ascending",
            "total descending",
            "min ascending",
            "min descending",
            "max ascending",
            "max descending",
            "sum ascending",
            "sum descending",
            "mean ascending",
            "mean descending",
            "geometric mean ascending",
            "geometric mean descending",
            "median ascending",
            "median descending"
          ],
          dflt: "trace",
          editType: "calc"
        },
        categoryarray: {
          valType: "data_array",
          editType: "calc"
        },
        uirevision: {
          valType: "any",
          editType: "none"
        },
        editType: "calc"
      };
    }
  });

  // src/components/colorbar/attributes.js
  var require_attributes7 = __commonJS({
    "src/components/colorbar/attributes.js"(exports, module) {
      "use strict";
      var axesAttrs = require_layout_attributes4();
      var fontAttrs = require_font_attributes();
      var extendFlat = require_extend().extendFlat;
      var overrideAll = require_edit_types().overrideAll;
      module.exports = overrideAll({
        orientation: {
          valType: "enumerated",
          values: ["h", "v"],
          dflt: "v"
        },
        thicknessmode: {
          valType: "enumerated",
          values: ["fraction", "pixels"],
          dflt: "pixels"
        },
        thickness: {
          valType: "number",
          min: 0,
          dflt: 30
        },
        lenmode: {
          valType: "enumerated",
          values: ["fraction", "pixels"],
          dflt: "fraction"
        },
        len: {
          valType: "number",
          min: 0,
          dflt: 1
        },
        x: {
          valType: "number"
        },
        xref: {
          valType: "enumerated",
          dflt: "paper",
          values: ["container", "paper"],
          editType: "layoutstyle"
        },
        xanchor: {
          valType: "enumerated",
          values: ["left", "center", "right"]
        },
        xpad: {
          valType: "number",
          min: 0,
          dflt: 10
        },
        y: {
          valType: "number"
        },
        yref: {
          valType: "enumerated",
          dflt: "paper",
          values: ["container", "paper"],
          editType: "layoutstyle"
        },
        yanchor: {
          valType: "enumerated",
          values: ["top", "middle", "bottom"]
        },
        ypad: {
          valType: "number",
          min: 0,
          dflt: 10
        },
        // a possible line around the bar itself
        outlinecolor: axesAttrs.linecolor,
        outlinewidth: axesAttrs.linewidth,
        // Should outlinewidth have {dflt: 0} ?
        // another possible line outside the padding and tick labels
        bordercolor: axesAttrs.linecolor,
        borderwidth: {
          valType: "number",
          min: 0,
          dflt: 0
        },
        bgcolor: {
          valType: "color",
          dflt: "rgba(0,0,0,0)"
        },
        // tick and title properties named and function exactly as in axes
        tickmode: axesAttrs.minor.tickmode,
        nticks: axesAttrs.nticks,
        tick0: axesAttrs.tick0,
        dtick: axesAttrs.dtick,
        tickvals: axesAttrs.tickvals,
        ticktext: axesAttrs.ticktext,
        ticks: extendFlat({}, axesAttrs.ticks, { dflt: "" }),
        ticklabeloverflow: extendFlat({}, axesAttrs.ticklabeloverflow, {}),
        // ticklabelposition: not used directly, as values depend on orientation
        // left/right options are for x axes, and top/bottom options are for y axes
        ticklabelposition: {
          valType: "enumerated",
          values: [
            "outside",
            "inside",
            "outside top",
            "inside top",
            "outside left",
            "inside left",
            "outside right",
            "inside right",
            "outside bottom",
            "inside bottom"
          ],
          dflt: "outside"
        },
        ticklen: axesAttrs.ticklen,
        tickwidth: axesAttrs.tickwidth,
        tickcolor: axesAttrs.tickcolor,
        ticklabelstep: axesAttrs.ticklabelstep,
        showticklabels: axesAttrs.showticklabels,
        labelalias: axesAttrs.labelalias,
        tickfont: fontAttrs({}),
        tickangle: axesAttrs.tickangle,
        tickformat: axesAttrs.tickformat,
        tickformatstops: axesAttrs.tickformatstops,
        tickprefix: axesAttrs.tickprefix,
        showtickprefix: axesAttrs.showtickprefix,
        ticksuffix: axesAttrs.ticksuffix,
        showticksuffix: axesAttrs.showticksuffix,
        separatethousands: axesAttrs.separatethousands,
        exponentformat: axesAttrs.exponentformat,
        minexponent: axesAttrs.minexponent,
        showexponent: axesAttrs.showexponent,
        title: {
          text: {
            valType: "string"
          },
          font: fontAttrs({}),
          side: {
            valType: "enumerated",
            values: ["right", "top", "bottom"]
          }
        }
      }, "colorbars", "from-root");
    }
  });

  // src/components/colorscale/attributes.js
  var require_attributes8 = __commonJS({
    "src/components/colorscale/attributes.js"(exports, module) {
      "use strict";
      var colorbarAttrs = require_attributes7();
      var counterRegex = require_regex().counter;
      var sortObjectKeys = require_sort_object_keys();
      var palettes = require_scales().scales;
      var paletteStr = sortObjectKeys(palettes);
      function code(s) {
        return "`" + s + "`";
      }
      module.exports = function colorScaleAttrs(context, opts) {
        context = context || "";
        opts = opts || {};
        var cLetter = opts.cLetter || "c";
        var onlyIfNumerical = "onlyIfNumerical" in opts ? opts.onlyIfNumerical : Boolean(context);
        var noScale = "noScale" in opts ? opts.noScale : context === "marker.line";
        var showScaleDflt = "showScaleDflt" in opts ? opts.showScaleDflt : cLetter === "z";
        var colorscaleDflt = typeof opts.colorscaleDflt === "string" ? palettes[opts.colorscaleDflt] : null;
        var editTypeOverride = opts.editTypeOverride || "";
        var contextHead = context ? context + "." : "";
        var colorAttr, colorAttrFull;
        if ("colorAttr" in opts) {
          colorAttr = opts.colorAttr;
          colorAttrFull = opts.colorAttr;
        } else {
          colorAttr = { z: "z", c: "color" }[cLetter];
          colorAttrFull = "in " + code(contextHead + colorAttr);
        }
        var effectDesc = onlyIfNumerical ? " Has an effect only if " + colorAttrFull + " is set to a numerical array." : "";
        var auto = cLetter + "auto";
        var min = cLetter + "min";
        var max = cLetter + "max";
        var mid = cLetter + "mid";
        var autoFull = code(contextHead + auto);
        var minFull = code(contextHead + min);
        var maxFull = code(contextHead + max);
        var minmaxFull = minFull + " and " + maxFull;
        var autoImpliedEdits = {};
        autoImpliedEdits[min] = autoImpliedEdits[max] = void 0;
        var minmaxImpliedEdits = {};
        minmaxImpliedEdits[auto] = false;
        var attrs = {};
        if (colorAttr === "color") {
          attrs.color = {
            valType: "color",
            arrayOk: true,
            editType: editTypeOverride || "style"
          };
          if (opts.anim) {
            attrs.color.anim = true;
          }
        }
        attrs[auto] = {
          valType: "boolean",
          dflt: true,
          editType: "calc",
          impliedEdits: autoImpliedEdits
        };
        attrs[min] = {
          valType: "number",
          dflt: null,
          editType: editTypeOverride || "plot",
          impliedEdits: minmaxImpliedEdits
        };
        attrs[max] = {
          valType: "number",
          dflt: null,
          editType: editTypeOverride || "plot",
          impliedEdits: minmaxImpliedEdits
        };
        attrs[mid] = {
          valType: "number",
          dflt: null,
          editType: "calc",
          impliedEdits: autoImpliedEdits
        };
        attrs.colorscale = {
          valType: "colorscale",
          editType: "calc",
          dflt: colorscaleDflt,
          impliedEdits: { autocolorscale: false }
        };
        attrs.autocolorscale = {
          valType: "boolean",
          // gets overrode in 'heatmap' & 'surface' for backwards comp.
          dflt: opts.autoColorDflt === false ? false : true,
          editType: "calc",
          impliedEdits: { colorscale: void 0 }
        };
        attrs.reversescale = {
          valType: "boolean",
          dflt: false,
          editType: "plot"
        };
        if (!noScale) {
          attrs.showscale = {
            valType: "boolean",
            dflt: showScaleDflt,
            editType: "calc"
          };
          attrs.colorbar = colorbarAttrs;
        }
        if (!opts.noColorAxis) {
          attrs.coloraxis = {
            valType: "subplotid",
            regex: counterRegex("coloraxis"),
            dflt: null,
            editType: "calc"
          };
        }
        return attrs;
      };
    }
  });

  // src/components/colorscale/layout_attributes.js
  var require_layout_attributes5 = __commonJS({
    "src/components/colorscale/layout_attributes.js"(exports, module) {
      "use strict";
      var extendFlat = require_extend().extendFlat;
      var colorScaleAttrs = require_attributes8();
      var scales = require_scales().scales;
      module.exports = {
        editType: "calc",
        colorscale: {
          editType: "calc",
          sequential: {
            valType: "colorscale",
            dflt: scales.Reds,
            editType: "calc"
          },
          sequentialminus: {
            valType: "colorscale",
            dflt: scales.Blues,
            editType: "calc"
          },
          diverging: {
            valType: "colorscale",
            dflt: scales.RdBu,
            editType: "calc"
          }
        },
        coloraxis: extendFlat({
          // not really a 'subplot' attribute container,
          // but this is the flag we use to denote attributes that
          // support yaxis, yaxis2, yaxis3, ... counters
          _isSubplotObj: true,
          editType: "calc"
        }, colorScaleAttrs("", {
          colorAttr: "corresponding trace color array(s)",
          noColorAxis: true,
          showScaleDflt: true
        }))
      };
    }
  });

  // src/components/colorbar/has_colorbar.js
  var require_has_colorbar = __commonJS({
    "src/components/colorbar/has_colorbar.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      module.exports = function hasColorbar(container) {
        return Lib.isPlainObject(container.colorbar);
      };
    }
  });

  // src/plots/cartesian/clean_ticks.js
  var require_clean_ticks = __commonJS({
    "src/plots/cartesian/clean_ticks.js"(exports) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var Lib = require_lib();
      var constants = require_numerical();
      var ONEDAY = constants.ONEDAY;
      var ONEWEEK = constants.ONEWEEK;
      exports.dtick = function(dtick, axType) {
        var isLog = axType === "log";
        var isDate = axType === "date";
        var isCat = axType === "category";
        var dtickDflt = isDate ? ONEDAY : 1;
        if (!dtick) return dtickDflt;
        if (isNumeric(dtick)) {
          dtick = Number(dtick);
          if (dtick <= 0) return dtickDflt;
          if (isCat) {
            return Math.max(1, Math.round(dtick));
          }
          if (isDate) {
            return Math.max(0.1, dtick);
          }
          return dtick;
        }
        if (typeof dtick !== "string" || !(isDate || isLog)) {
          return dtickDflt;
        }
        var prefix = dtick.charAt(0);
        var dtickNum = dtick.substr(1);
        dtickNum = isNumeric(dtickNum) ? Number(dtickNum) : 0;
        if (dtickNum <= 0 || !// "M<n>" gives ticks every (integer) n months
        (isDate && prefix === "M" && dtickNum === Math.round(dtickNum) || // "L<f>" gives ticks linearly spaced in data (not in position) every (float) f
        isLog && prefix === "L" || // "D1" gives powers of 10 with all small digits between, "D2" gives only 2 and 5
        isLog && prefix === "D" && (dtickNum === 1 || dtickNum === 2))) {
          return dtickDflt;
        }
        return dtick;
      };
      exports.tick0 = function(tick0, axType, calendar, dtick) {
        if (axType === "date") {
          return Lib.cleanDate(
            tick0,
            Lib.dateTick0(calendar, dtick % ONEWEEK === 0 ? 1 : 0)
          );
        }
        if (dtick === "D1" || dtick === "D2") {
          return void 0;
        }
        return isNumeric(tick0) ? Number(tick0) : 0;
      };
    }
  });

  // src/plots/cartesian/tick_value_defaults.js
  var require_tick_value_defaults = __commonJS({
    "src/plots/cartesian/tick_value_defaults.js"(exports, module) {
      "use strict";
      var cleanTicks = require_clean_ticks();
      var isArrayOrTypedArray = require_lib().isArrayOrTypedArray;
      var isTypedArraySpec = require_array().isTypedArraySpec;
      var decodeTypedArraySpec = require_array().decodeTypedArraySpec;
      module.exports = function handleTickValueDefaults(containerIn, containerOut, coerce, axType, opts) {
        if (!opts) opts = {};
        var isMinor = opts.isMinor;
        var cIn = isMinor ? containerIn.minor || {} : containerIn;
        var cOut = isMinor ? containerOut.minor : containerOut;
        var prefix = isMinor ? "minor." : "";
        function readInput(attr) {
          var v = cIn[attr];
          if (isTypedArraySpec(v)) v = decodeTypedArraySpec(v);
          return v !== void 0 ? v : (cOut._template || {})[attr];
        }
        var _tick0 = readInput("tick0");
        var _dtick = readInput("dtick");
        var _tickvals = readInput("tickvals");
        var tickmodeDefault = isArrayOrTypedArray(_tickvals) ? "array" : _dtick ? "linear" : "auto";
        var tickmode = coerce(prefix + "tickmode", tickmodeDefault);
        if (tickmode === "auto" || tickmode === "sync") {
          coerce(prefix + "nticks");
        } else if (tickmode === "linear") {
          var dtick = cOut.dtick = cleanTicks.dtick(
            _dtick,
            axType
          );
          cOut.tick0 = cleanTicks.tick0(
            _tick0,
            axType,
            containerOut.calendar,
            dtick
          );
        } else if (axType !== "multicategory") {
          var tickvals = coerce(prefix + "tickvals");
          if (tickvals === void 0) cOut.tickmode = "auto";
          else if (!isMinor) coerce("ticktext");
        }
      };
    }
  });

  // src/plots/cartesian/tick_mark_defaults.js
  var require_tick_mark_defaults = __commonJS({
    "src/plots/cartesian/tick_mark_defaults.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      var layoutAttributes = require_layout_attributes4();
      module.exports = function handleTickMarkDefaults(containerIn, containerOut, coerce, options) {
        var isMinor = options.isMinor;
        var cIn = isMinor ? containerIn.minor || {} : containerIn;
        var cOut = isMinor ? containerOut.minor : containerOut;
        var lAttr = isMinor ? layoutAttributes.minor : layoutAttributes;
        var prefix = isMinor ? "minor." : "";
        var tickLen = Lib.coerce2(cIn, cOut, lAttr, "ticklen", isMinor ? (containerOut.ticklen || 5) * 0.6 : void 0);
        var tickWidth = Lib.coerce2(cIn, cOut, lAttr, "tickwidth", isMinor ? containerOut.tickwidth || 1 : void 0);
        var tickColor = Lib.coerce2(cIn, cOut, lAttr, "tickcolor", (isMinor ? containerOut.tickcolor : void 0) || cOut.color);
        var showTicks = coerce(prefix + "ticks", !isMinor && options.outerTicks || tickLen || tickWidth || tickColor ? "outside" : "");
        if (!showTicks) {
          delete cOut.ticklen;
          delete cOut.tickwidth;
          delete cOut.tickcolor;
        }
      };
    }
  });

  // src/plots/cartesian/show_dflt.js
  var require_show_dflt = __commonJS({
    "src/plots/cartesian/show_dflt.js"(exports, module) {
      "use strict";
      module.exports = function getShowAttrDflt(containerIn) {
        var showAttrsAll = ["showexponent", "showtickprefix", "showticksuffix"];
        var showAttrs = showAttrsAll.filter(function(a) {
          return containerIn[a] !== void 0;
        });
        var sameVal = function(a) {
          return containerIn[a] === containerIn[showAttrs[0]];
        };
        if (showAttrs.every(sameVal) || showAttrs.length === 1) {
          return containerIn[showAttrs[0]];
        }
      };
    }
  });

  // src/plots/array_container_defaults.js
  var require_array_container_defaults = __commonJS({
    "src/plots/array_container_defaults.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      var Template = require_plot_template();
      module.exports = function handleArrayContainerDefaults(parentObjIn, parentObjOut, opts) {
        var name2 = opts.name;
        var inclusionAttr = opts.inclusionAttr || "visible";
        var previousContOut = parentObjOut[name2];
        var contIn = Lib.isArrayOrTypedArray(parentObjIn[name2]) ? parentObjIn[name2] : [];
        var contOut = parentObjOut[name2] = [];
        var templater = Template.arrayTemplater(parentObjOut, name2, inclusionAttr);
        var i, itemOut;
        for (i = 0; i < contIn.length; i++) {
          var itemIn = contIn[i];
          if (!Lib.isPlainObject(itemIn)) {
            itemOut = templater.newItem({});
            itemOut[inclusionAttr] = false;
          } else {
            itemOut = templater.newItem(itemIn);
          }
          itemOut._index = i;
          if (itemOut[inclusionAttr] !== false) {
            opts.handleItemDefaults(itemIn, itemOut, parentObjOut, opts);
          }
          contOut.push(itemOut);
        }
        var defaultItems = templater.defaultItems();
        for (i = 0; i < defaultItems.length; i++) {
          itemOut = defaultItems[i];
          itemOut._index = contOut.length;
          opts.handleItemDefaults({}, itemOut, parentObjOut, opts, {});
          contOut.push(itemOut);
        }
        if (Lib.isArrayOrTypedArray(previousContOut)) {
          var len = Math.min(previousContOut.length, contOut.length);
          for (i = 0; i < len; i++) {
            Lib.relinkPrivateKeys(contOut[i], previousContOut[i]);
          }
        }
        return contOut;
      };
    }
  });

  // src/plots/cartesian/tick_label_defaults.js
  var require_tick_label_defaults = __commonJS({
    "src/plots/cartesian/tick_label_defaults.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      var contrast = require_color().contrast;
      var layoutAttributes = require_layout_attributes4();
      var getShowAttrDflt = require_show_dflt();
      var handleArrayContainerDefaults = require_array_container_defaults();
      module.exports = function handleTickLabelDefaults(containerIn, containerOut, coerce, axType, options) {
        if (!options) options = {};
        var labelalias = coerce("labelalias");
        if (!Lib.isPlainObject(labelalias)) delete containerOut.labelalias;
        var showAttrDflt = getShowAttrDflt(containerIn);
        var showTickLabels = coerce("showticklabels");
        if (showTickLabels) {
          if (!options.noTicklabelshift) {
            coerce("ticklabelshift");
          }
          if (!options.noTicklabelstandoff) {
            coerce("ticklabelstandoff");
          }
          var font = options.font || {};
          var contColor = containerOut.color;
          var position = containerOut.ticklabelposition || "";
          var dfltFontColor = position.indexOf("inside") !== -1 ? contrast(options.bgColor) : (
            // as with title.font.color, inherit axis.color only if one was
            // explicitly provided
            contColor && contColor !== layoutAttributes.color.dflt ? contColor : font.color
          );
          Lib.coerceFont(coerce, "tickfont", font, { overrideDflt: {
            color: dfltFontColor
          } });
          if (!options.noTicklabelstep && axType !== "multicategory" && axType !== "log") {
            coerce("ticklabelstep");
          }
          if (!options.noAng) {
            var tickAngle = coerce("tickangle");
            if (!options.noAutotickangles && tickAngle === "auto") {
              coerce("autotickangles");
            }
          }
          if (axType !== "category") {
            var tickFormat = coerce("tickformat");
            handleArrayContainerDefaults(containerIn, containerOut, {
              name: "tickformatstops",
              inclusionAttr: "enabled",
              handleItemDefaults: tickformatstopDefaults
            });
            if (!containerOut.tickformatstops.length) {
              delete containerOut.tickformatstops;
            }
            if (!options.noExp && !tickFormat && axType !== "date") {
              coerce("showexponent", showAttrDflt);
              coerce("exponentformat");
              coerce("minexponent");
              coerce("separatethousands");
            }
          }
        }
      };
      function tickformatstopDefaults(valueIn, valueOut) {
        function coerce(attr, dflt) {
          return Lib.coerce(valueIn, valueOut, layoutAttributes.tickformatstops, attr, dflt);
        }
        var enabled = coerce("enabled");
        if (enabled) {
          coerce("dtickrange");
          coerce("value");
        }
      }
    }
  });

  // src/plots/cartesian/prefix_suffix_defaults.js
  var require_prefix_suffix_defaults = __commonJS({
    "src/plots/cartesian/prefix_suffix_defaults.js"(exports, module) {
      "use strict";
      var getShowAttrDflt = require_show_dflt();
      module.exports = function handlePrefixSuffixDefaults(containerIn, containerOut, coerce, axType, options) {
        if (!options) options = {};
        var tickSuffixDflt = options.tickSuffixDflt;
        var showAttrDflt = getShowAttrDflt(containerIn);
        var tickPrefix = coerce("tickprefix");
        if (tickPrefix) coerce("showtickprefix", showAttrDflt);
        var tickSuffix = coerce("ticksuffix", tickSuffixDflt);
        if (tickSuffix) coerce("showticksuffix", showAttrDflt);
      };
    }
  });

  // src/components/colorbar/defaults.js
  var require_defaults = __commonJS({
    "src/components/colorbar/defaults.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      var Template = require_plot_template();
      var handleTickValueDefaults = require_tick_value_defaults();
      var handleTickMarkDefaults = require_tick_mark_defaults();
      var handleTickLabelDefaults = require_tick_label_defaults();
      var handlePrefixSuffixDefaults = require_prefix_suffix_defaults();
      var attributes = require_attributes7();
      module.exports = function colorbarDefaults(containerIn, containerOut, layout) {
        var colorbarOut = Template.newContainer(containerOut, "colorbar");
        var colorbarIn = containerIn.colorbar || {};
        function coerce(attr, dflt) {
          return Lib.coerce(colorbarIn, colorbarOut, attributes, attr, dflt);
        }
        var margin = layout.margin || { t: 0, b: 0, l: 0, r: 0 };
        var w = layout.width - margin.l - margin.r;
        var h = layout.height - margin.t - margin.b;
        var orientation = coerce("orientation");
        var isVertical = orientation === "v";
        var thicknessmode = coerce("thicknessmode");
        coerce(
          "thickness",
          thicknessmode === "fraction" ? 30 / (isVertical ? w : h) : 30
        );
        var lenmode = coerce("lenmode");
        coerce(
          "len",
          lenmode === "fraction" ? 1 : isVertical ? h : w
        );
        var yref = coerce("yref");
        var xref = coerce("xref");
        var isPaperY = yref === "paper";
        var isPaperX = xref === "paper";
        var defaultX, defaultY, defaultYAnchor;
        var defaultXAnchor = "left";
        if (isVertical) {
          defaultYAnchor = "middle";
          defaultXAnchor = isPaperX ? "left" : "right";
          defaultX = isPaperX ? 1.02 : 1;
          defaultY = 0.5;
        } else {
          defaultYAnchor = isPaperY ? "bottom" : "top";
          defaultXAnchor = "center";
          defaultX = 0.5;
          defaultY = isPaperY ? 1.02 : 1;
        }
        Lib.coerce(colorbarIn, colorbarOut, {
          x: {
            valType: "number",
            min: isPaperX ? -2 : 0,
            max: isPaperX ? 3 : 1,
            dflt: defaultX
          }
        }, "x");
        Lib.coerce(colorbarIn, colorbarOut, {
          y: {
            valType: "number",
            min: isPaperY ? -2 : 0,
            max: isPaperY ? 3 : 1,
            dflt: defaultY
          }
        }, "y");
        coerce("xanchor", defaultXAnchor);
        coerce("xpad");
        coerce("yanchor", defaultYAnchor);
        coerce("ypad");
        Lib.noneOrAll(colorbarIn, colorbarOut, ["x", "y"]);
        coerce("outlinecolor");
        coerce("outlinewidth");
        coerce("bordercolor");
        coerce("borderwidth");
        coerce("bgcolor");
        var ticklabelposition = Lib.coerce(colorbarIn, colorbarOut, {
          ticklabelposition: {
            valType: "enumerated",
            dflt: "outside",
            values: isVertical ? [
              "outside",
              "inside",
              "outside top",
              "inside top",
              "outside bottom",
              "inside bottom"
            ] : [
              "outside",
              "inside",
              "outside left",
              "inside left",
              "outside right",
              "inside right"
            ]
          }
        }, "ticklabelposition");
        coerce("ticklabeloverflow", ticklabelposition.indexOf("inside") !== -1 ? "hide past domain" : "hide past div");
        handleTickValueDefaults(colorbarIn, colorbarOut, coerce, "linear");
        var font = layout.font;
        var opts = {
          noAutotickangles: true,
          noTicklabelshift: true,
          noTicklabelstandoff: true,
          outerTicks: false,
          font
        };
        if (ticklabelposition.indexOf("inside") !== -1) {
          opts.bgColor = "black";
        }
        handlePrefixSuffixDefaults(colorbarIn, colorbarOut, coerce, "linear", opts);
        handleTickLabelDefaults(colorbarIn, colorbarOut, coerce, "linear", opts);
        handleTickMarkDefaults(colorbarIn, colorbarOut, coerce, "linear", opts);
        coerce("title.text", layout._dfltTitle.colorbar);
        var tickFont = colorbarOut.showticklabels ? colorbarOut.tickfont : font;
        var dfltTitleFont = Lib.extendFlat({}, font, {
          family: tickFont.family,
          size: Lib.bigFont(tickFont.size)
        });
        Lib.coerceFont(coerce, "title.font", dfltTitleFont);
        coerce("title.side", isVertical ? "top" : "right");
      };
    }
  });

  // src/components/colorscale/defaults.js
  var require_defaults2 = __commonJS({
    "src/components/colorscale/defaults.js"(exports, module) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var Lib = require_lib();
      var hasColorbar = require_has_colorbar();
      var colorbarDefaults = require_defaults();
      var isValidScale = require_scales().isValid;
      var traceIs = require_registry().traceIs;
      function npMaybe(parentCont, prefix) {
        var containerStr = prefix.slice(0, prefix.length - 1);
        return prefix ? Lib.nestedProperty(parentCont, containerStr).get() || {} : parentCont;
      }
      module.exports = function colorScaleDefaults(parentContIn, parentContOut, layout, coerce, opts) {
        var prefix = opts.prefix;
        var cLetter = opts.cLetter;
        var inTrace = "_module" in parentContOut;
        var containerIn = npMaybe(parentContIn, prefix);
        var containerOut = npMaybe(parentContOut, prefix);
        var template = npMaybe(parentContOut._template || {}, prefix) || {};
        var thisFn = function() {
          delete parentContIn.coloraxis;
          delete parentContOut.coloraxis;
          return colorScaleDefaults(parentContIn, parentContOut, layout, coerce, opts);
        };
        if (inTrace) {
          var colorAxes = layout._colorAxes || {};
          var colorAx = coerce(prefix + "coloraxis");
          if (colorAx) {
            var colorbarVisuals = traceIs(parentContOut, "contour") && Lib.nestedProperty(parentContOut, "contours.coloring").get() || "heatmap";
            var stash = colorAxes[colorAx];
            if (stash) {
              stash[2].push(thisFn);
              if (stash[0] !== colorbarVisuals) {
                stash[0] = false;
                Lib.warn([
                  "Ignoring coloraxis:",
                  colorAx,
                  "setting",
                  "as it is linked to incompatible colorscales."
                ].join(" "));
              }
            } else {
              colorAxes[colorAx] = [colorbarVisuals, parentContOut, [thisFn]];
            }
            return;
          }
        }
        var minIn = containerIn[cLetter + "min"];
        var maxIn = containerIn[cLetter + "max"];
        var validMinMax = isNumeric(minIn) && isNumeric(maxIn) && minIn < maxIn;
        var auto = coerce(prefix + cLetter + "auto", !validMinMax);
        if (auto) {
          coerce(prefix + cLetter + "mid");
        } else {
          coerce(prefix + cLetter + "min");
          coerce(prefix + cLetter + "max");
        }
        var sclIn = containerIn.colorscale;
        var sclTemplate = template.colorscale;
        var autoColorscaleDflt;
        if (sclIn !== void 0) autoColorscaleDflt = !isValidScale(sclIn);
        if (sclTemplate !== void 0) autoColorscaleDflt = !isValidScale(sclTemplate);
        coerce(prefix + "autocolorscale", autoColorscaleDflt);
        coerce(prefix + "colorscale");
        coerce(prefix + "reversescale");
        if (prefix !== "marker.line.") {
          var showScaleDflt;
          if (prefix && inTrace) showScaleDflt = hasColorbar(containerIn);
          var showScale = coerce(prefix + "showscale", showScaleDflt);
          if (showScale) {
            if (prefix && template) containerOut._template = template;
            colorbarDefaults(containerIn, containerOut, layout);
          }
        }
      };
    }
  });

  // src/components/colorscale/layout_defaults.js
  var require_layout_defaults = __commonJS({
    "src/components/colorscale/layout_defaults.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      var Template = require_plot_template();
      var colorScaleAttrs = require_layout_attributes5();
      var colorScaleDefaults = require_defaults2();
      module.exports = function supplyLayoutDefaults(layoutIn, layoutOut) {
        function coerce(attr, dflt) {
          return Lib.coerce(layoutIn, layoutOut, colorScaleAttrs, attr, dflt);
        }
        coerce("colorscale.sequential");
        coerce("colorscale.sequentialminus");
        coerce("colorscale.diverging");
        var colorAxes = layoutOut._colorAxes;
        var colorAxIn, colorAxOut;
        function coerceAx(attr, dflt) {
          return Lib.coerce(colorAxIn, colorAxOut, colorScaleAttrs.coloraxis, attr, dflt);
        }
        for (var k in colorAxes) {
          var stash = colorAxes[k];
          if (stash[0]) {
            colorAxIn = layoutIn[k] || {};
            colorAxOut = Template.newContainer(layoutOut, k, "coloraxis");
            colorAxOut._name = k;
            colorScaleDefaults(colorAxIn, colorAxOut, layoutOut, coerceAx, { prefix: "", cLetter: "c" });
          } else {
            for (var i = 0; i < stash[2].length; i++) {
              stash[2][i]();
            }
            delete layoutOut._colorAxes[k];
          }
        }
      };
    }
  });

  // src/components/colorscale/cross_trace_defaults.js
  var require_cross_trace_defaults = __commonJS({
    "src/components/colorscale/cross_trace_defaults.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      var hasColorscale = require_helpers().hasColorscale;
      var extractOpts = require_helpers().extractOpts;
      module.exports = function crossTraceDefaults(fullData, fullLayout) {
        function replace(cont, k2) {
          var val = cont["_" + k2];
          if (val !== void 0) {
            cont[k2] = val;
          }
        }
        function relinkColorAttrs(outerCont, cbOpt) {
          var cont = cbOpt.container ? Lib.nestedProperty(outerCont, cbOpt.container).get() : outerCont;
          if (cont) {
            if (cont.coloraxis) {
              cont._colorAx = fullLayout[cont.coloraxis];
            } else {
              var cOpts = extractOpts(cont);
              var isAuto = cOpts.auto;
              if (isAuto || cOpts.min === void 0) {
                replace(cont, cbOpt.min);
              }
              if (isAuto || cOpts.max === void 0) {
                replace(cont, cbOpt.max);
              }
              if (cOpts.autocolorscale) {
                replace(cont, "colorscale");
              }
            }
          }
        }
        for (var i = 0; i < fullData.length; i++) {
          var trace = fullData[i];
          var cbOpts = trace._module.colorbar;
          if (cbOpts) {
            if (Array.isArray(cbOpts)) {
              for (var j = 0; j < cbOpts.length; j++) {
                relinkColorAttrs(trace, cbOpts[j]);
              }
            } else {
              relinkColorAttrs(trace, cbOpts);
            }
          }
          if (hasColorscale(trace, "marker.line")) {
            relinkColorAttrs(trace, {
              container: "marker.line",
              min: "cmin",
              max: "cmax"
            });
          }
        }
        for (var k in fullLayout._colorAxes) {
          relinkColorAttrs(fullLayout[k], { min: "cmin", max: "cmax" });
        }
      };
    }
  });

  // src/components/colorscale/calc.js
  var require_calc = __commonJS({
    "src/components/colorscale/calc.js"(exports, module) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var Lib = require_lib();
      var extractOpts = require_helpers().extractOpts;
      module.exports = function calc(gd, trace, opts) {
        var fullLayout = gd._fullLayout;
        var vals = opts.vals;
        var containerStr = opts.containerStr;
        var container = containerStr ? Lib.nestedProperty(trace, containerStr).get() : trace;
        var cOpts = extractOpts(container);
        var auto = cOpts.auto !== false;
        var min = cOpts.min;
        var max = cOpts.max;
        var mid = cOpts.mid;
        var minVal = function() {
          return Lib.aggNums(Math.min, null, vals);
        };
        var maxVal = function() {
          return Lib.aggNums(Math.max, null, vals);
        };
        if (min === void 0) {
          min = minVal();
        } else if (auto) {
          if (container._colorAx && isNumeric(min)) {
            min = Math.min(min, minVal());
          } else {
            min = minVal();
          }
        }
        if (max === void 0) {
          max = maxVal();
        } else if (auto) {
          if (container._colorAx && isNumeric(max)) {
            max = Math.max(max, maxVal());
          } else {
            max = maxVal();
          }
        }
        if (auto && mid !== void 0) {
          if (max - mid > mid - min) {
            min = mid - (max - mid);
          } else if (max - mid < mid - min) {
            max = mid + (mid - min);
          }
        }
        if (min === max) {
          min -= 0.5;
          max += 0.5;
        }
        cOpts._sync("min", min);
        cOpts._sync("max", max);
        if (cOpts.autocolorscale) {
          var scl;
          if (min * max < 0) scl = fullLayout.colorscale.diverging;
          else if (min >= 0) scl = fullLayout.colorscale.sequential;
          else scl = fullLayout.colorscale.sequentialminus;
          cOpts._sync("colorscale", scl);
        }
      };
    }
  });

  // src/components/colorscale/index.js
  var require_colorscale = __commonJS({
    "src/components/colorscale/index.js"(exports, module) {
      "use strict";
      var scales = require_scales();
      var helpers = require_helpers();
      module.exports = {
        moduleType: "component",
        name: "colorscale",
        attributes: require_attributes8(),
        layoutAttributes: require_layout_attributes5(),
        supplyLayoutDefaults: require_layout_defaults(),
        handleDefaults: require_defaults2(),
        crossTraceDefaults: require_cross_trace_defaults(),
        calc: require_calc(),
        // ./scales.js is required in lib/coerce.js ;
        // it needs to be a separate module to avoid a circular dependency
        scales: scales.scales,
        defaultScale: scales.defaultScale,
        getScale: scales.get,
        isValidScale: scales.isValid,
        hasColorscale: helpers.hasColorscale,
        extractOpts: helpers.extractOpts,
        extractScale: helpers.extractScale,
        flipScale: helpers.flipScale,
        makeColorScaleFunc: helpers.makeColorScaleFunc,
        makeColorScaleFuncFromTrace: helpers.makeColorScaleFuncFromTrace
      };
    }
  });

  // src/traces/scatter/subtypes.js
  var require_subtypes = __commonJS({
    "src/traces/scatter/subtypes.js"(exports, module) {
      "use strict";
      var Lib = require_lib();
      var isTypedArraySpec = require_array().isTypedArraySpec;
      module.exports = {
        hasLines: function(trace) {
          return trace.visible && trace.mode && trace.mode.indexOf("lines") !== -1;
        },
        hasMarkers: function(trace) {
          return trace.visible && (trace.mode && trace.mode.indexOf("markers") !== -1 || // until splom implements 'mode'
          trace.type === "splom");
        },
        hasText: function(trace) {
          return trace.visible && trace.mode && trace.mode.indexOf("text") !== -1;
        },
        isBubble: function(trace) {
          var marker = trace.marker;
          return Lib.isPlainObject(marker) && (Lib.isArrayOrTypedArray(marker.size) || isTypedArraySpec(marker.size));
        }
      };
    }
  });

  // src/traces/scatter/make_bubble_size_func.js
  var require_make_bubble_size_func = __commonJS({
    "src/traces/scatter/make_bubble_size_func.js"(exports, module) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      module.exports = function makeBubbleSizeFn(trace, factor) {
        if (!factor) {
          factor = 2;
        }
        var marker = trace.marker;
        var sizeRef = marker.sizeref || 1;
        var sizeMin = marker.sizemin || 0;
        var baseFn = marker.sizemode === "area" ? function(v) {
          return Math.sqrt(v / sizeRef);
        } : function(v) {
          return v / sizeRef;
        };
        return function(v) {
          var baseSize = baseFn(v / factor);
          return isNumeric(baseSize) && baseSize > 0 ? Math.max(baseSize, sizeMin) : 0;
        };
      };
    }
  });

  // src/components/fx/helpers.js
  var require_helpers2 = __commonJS({
    "src/components/fx/helpers.js"(exports) {
      "use strict";
      var Lib = require_lib();
      exports.getSubplot = function(trace) {
        return trace.subplot || trace.xaxis + trace.yaxis || trace.geo;
      };
      exports.isTraceInSubplots = function(trace, subplots) {
        if (trace.type === "splom") {
          var xaxes = trace.xaxes || [];
          var yaxes = trace.yaxes || [];
          for (var i = 0; i < xaxes.length; i++) {
            for (var j = 0; j < yaxes.length; j++) {
              if (subplots.indexOf(xaxes[i] + yaxes[j]) !== -1) {
                return true;
              }
            }
          }
          return false;
        }
        return subplots.indexOf(exports.getSubplot(trace)) !== -1;
      };
      exports.flat = function(subplots, v) {
        var out = new Array(subplots.length);
        for (var i = 0; i < subplots.length; i++) {
          out[i] = v;
        }
        return out;
      };
      exports.p2c = function(axArray, v) {
        var out = new Array(axArray.length);
        for (var i = 0; i < axArray.length; i++) {
          out[i] = axArray[i].p2c(v);
        }
        return out;
      };
      exports.getDistanceFunction = function(mode, dx, dy, dxy) {
        if (mode === "closest") return dxy || exports.quadrature(dx, dy);
        return mode.charAt(0) === "x" ? dx : dy;
      };
      exports.getClosest = function(cd, distfn, pointData) {
        if (pointData.index !== false) {
          if (pointData.index >= 0 && pointData.index < cd.length) {
            pointData.distance = 0;
          } else pointData.index = false;
        } else {
          var newDistance = Infinity;
          var len = cd.length;
          for (var i = 0; i < len; i++) {
            newDistance = distfn(cd[i]);
            if (newDistance <= pointData.distance) {
              pointData.index = i;
              pointData.distance = newDistance;
            }
          }
        }
        return pointData;
      };
      exports.inbox = function(v0, v1, passVal) {
        return v0 * v1 < 0 || v0 === 0 ? passVal : Infinity;
      };
      exports.quadrature = function(dx, dy) {
        return function(di) {
          var x = dx(di);
          var y = dy(di);
          return Math.sqrt(x * x + y * y);
        };
      };
      exports.makeEventData = function(pt, trace, cd) {
        var pointNumber = "index" in pt ? pt.index : pt.pointNumber;
        var out = {
          data: trace._input,
          fullData: trace,
          curveNumber: trace.index,
          pointNumber
        };
        if (trace._indexToPoints) {
          var pointIndices = trace._indexToPoints[pointNumber];
          if (pointIndices.length === 1) {
            out.pointIndex = pointIndices[0];
          } else {
            out.pointIndices = pointIndices;
          }
        } else {
          out.pointIndex = pointNumber;
        }
        if (trace._module.eventData) {
          out = trace._module.eventData(out, pt, trace, cd, pointNumber);
        } else {
          if ("xVal" in pt) out.x = pt.xVal;
          else if ("x" in pt) out.x = pt.x;
          if ("yVal" in pt) out.y = pt.yVal;
          else if ("y" in pt) out.y = pt.y;
          if (pt.xa) out.xaxis = pt.xa;
          if (pt.ya) out.yaxis = pt.ya;
          if (pt.zLabelVal !== void 0) out.z = pt.zLabelVal;
        }
        exports.appendArrayPointValue(out, trace, pointNumber);
        return out;
      };
      exports.appendArrayPointValue = function(pointData, trace, pointNumber) {
        var arrayAttrs = trace._arrayAttrs;
        if (!arrayAttrs) {
          return;
        }
        for (var i = 0; i < arrayAttrs.length; i++) {
          var astr = arrayAttrs[i];
          var key = getPointKey(astr);
          if (pointData[key] === void 0) {
            var val = Lib.nestedProperty(trace, astr).get();
            var pointVal = getPointData(val, pointNumber);
            if (pointVal !== void 0) pointData[key] = pointVal;
          }
        }
      };
      exports.appendArrayMultiPointValues = function(pointData, trace, pointNumbers) {
        var arrayAttrs = trace._arrayAttrs;
        if (!arrayAttrs) {
          return;
        }
        for (var i = 0; i < arrayAttrs.length; i++) {
          var astr = arrayAttrs[i];
          var key = getPointKey(astr);
          if (pointData[key] === void 0) {
            var val = Lib.nestedProperty(trace, astr).get();
            var keyVal = new Array(pointNumbers.length);
            for (var j = 0; j < pointNumbers.length; j++) {
              keyVal[j] = getPointData(val, pointNumbers[j]);
            }
            pointData[key] = keyVal;
          }
        }
      };
      var pointKeyMap = {
        ids: "id",
        locations: "location",
        labels: "label",
        values: "value",
        "marker.colors": "color",
        parents: "parent"
      };
      function getPointKey(astr) {
        return pointKeyMap[astr] || astr;
      }
      function getPointData(val, pointNumber) {
        if (Array.isArray(pointNumber)) {
          if (Array.isArray(val) && Array.isArray(val[pointNumber[0]])) {
            return val[pointNumber[0]][pointNumber[1]];
          }
        } else {
          return val[pointNumber];
        }
      }
      var xyHoverMode = {
        x: true,
        y: true
      };
      var unifiedHoverMode = {
        "x unified": true,
        "y unified": true
      };
      exports.isUnifiedHover = function(hovermode) {
        if (typeof hovermode !== "string") return false;
        return !!unifiedHoverMode[hovermode];
      };
      exports.isXYhover = function(hovermode) {
        if (typeof hovermode !== "string") return false;
        return !!xyHoverMode[hovermode];
      };
    }
  });

  // node_modules/parse-svg-path/index.js
  var require_parse_svg_path = __commonJS({
    "node_modules/parse-svg-path/index.js"(exports, module) {
      module.exports = parse;
      var length = { a: 7, c: 6, h: 1, l: 2, m: 2, q: 4, s: 4, t: 2, v: 1, z: 0 };
      var segment = /([astvzqmhlc])([^astvzqmhlc]*)/ig;
      function parse(path) {
        var data = [];
        path.replace(segment, function(_, command, args) {
          var type = command.toLowerCase();
          args = parseValues(args);
          if (type == "m" && args.length > 2) {
            data.push([command].concat(args.splice(0, 2)));
            type = "l";
            command = command == "m" ? "l" : "L";
          }
          while (true) {
            if (args.length == length[type]) {
              args.unshift(command);
              return data.push(args);
            }
            if (args.length < length[type]) throw new Error("malformed path data");
            data.push([command].concat(args.splice(0, length[type])));
          }
        });
        return data;
      }
      var number = /-?[0-9]*\.?[0-9]+(?:e[-+]?\d+)?/ig;
      function parseValues(args) {
        var numbers = args.match(number);
        return numbers ? numbers.map(Number) : [];
      }
    }
  });

  // src/components/drawing/symbol_defs.js
  var require_symbol_defs = __commonJS({
    "src/components/drawing/symbol_defs.js"(exports, module) {
      "use strict";
      var parseSvgPath = require_parse_svg_path();
      var round = (
        // require('@plotly/d3').round;
        function(x, n) {
          return n ? Math.round(x * (n = Math.pow(10, n))) / n : Math.round(x);
        }
      );
      var emptyPath = "M0,0Z";
      var sqrt2 = Math.sqrt(2);
      var sqrt3 = Math.sqrt(3);
      var PI = Math.PI;
      var cos = Math.cos;
      var sin = Math.sin;
      module.exports = {
        circle: {
          n: 0,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = round(r, 2);
            var circle = "M" + rs + ",0A" + rs + "," + rs + " 0 1,1 0,-" + rs + "A" + rs + "," + rs + " 0 0,1 " + rs + ",0Z";
            return standoff ? align(angle, standoff, circle) : circle;
          }
        },
        square: {
          n: 1,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = round(r, 2);
            return align(angle, standoff, "M" + rs + "," + rs + "H-" + rs + "V-" + rs + "H" + rs + "Z");
          }
        },
        diamond: {
          n: 2,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rd = round(r * 1.3, 2);
            return align(angle, standoff, "M" + rd + ",0L0," + rd + "L-" + rd + ",0L0,-" + rd + "Z");
          }
        },
        cross: {
          n: 3,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rc = round(r * 0.4, 2);
            var rc2 = round(r * 1.2, 2);
            return align(angle, standoff, "M" + rc2 + "," + rc + "H" + rc + "V" + rc2 + "H-" + rc + "V" + rc + "H-" + rc2 + "V-" + rc + "H-" + rc + "V-" + rc2 + "H" + rc + "V-" + rc + "H" + rc2 + "Z");
          }
        },
        x: {
          n: 4,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r * 0.8 / sqrt2, 2);
            var ne = "l" + rx + "," + rx;
            var se = "l" + rx + ",-" + rx;
            var sw = "l-" + rx + ",-" + rx;
            var nw = "l-" + rx + "," + rx;
            return align(angle, standoff, "M0," + rx + ne + se + sw + se + sw + nw + sw + nw + ne + nw + ne + "Z");
          }
        },
        "triangle-up": {
          n: 5,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rt = round(r * 2 / sqrt3, 2);
            var r2 = round(r / 2, 2);
            var rs = round(r, 2);
            return align(angle, standoff, "M-" + rt + "," + r2 + "H" + rt + "L0,-" + rs + "Z");
          }
        },
        "triangle-down": {
          n: 6,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rt = round(r * 2 / sqrt3, 2);
            var r2 = round(r / 2, 2);
            var rs = round(r, 2);
            return align(angle, standoff, "M-" + rt + ",-" + r2 + "H" + rt + "L0," + rs + "Z");
          }
        },
        "triangle-left": {
          n: 7,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rt = round(r * 2 / sqrt3, 2);
            var r2 = round(r / 2, 2);
            var rs = round(r, 2);
            return align(angle, standoff, "M" + r2 + ",-" + rt + "V" + rt + "L-" + rs + ",0Z");
          }
        },
        "triangle-right": {
          n: 8,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rt = round(r * 2 / sqrt3, 2);
            var r2 = round(r / 2, 2);
            var rs = round(r, 2);
            return align(angle, standoff, "M-" + r2 + ",-" + rt + "V" + rt + "L" + rs + ",0Z");
          }
        },
        "triangle-ne": {
          n: 9,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var r1 = round(r * 0.6, 2);
            var r2 = round(r * 1.2, 2);
            return align(angle, standoff, "M-" + r2 + ",-" + r1 + "H" + r1 + "V" + r2 + "Z");
          }
        },
        "triangle-se": {
          n: 10,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var r1 = round(r * 0.6, 2);
            var r2 = round(r * 1.2, 2);
            return align(angle, standoff, "M" + r1 + ",-" + r2 + "V" + r1 + "H-" + r2 + "Z");
          }
        },
        "triangle-sw": {
          n: 11,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var r1 = round(r * 0.6, 2);
            var r2 = round(r * 1.2, 2);
            return align(angle, standoff, "M" + r2 + "," + r1 + "H-" + r1 + "V-" + r2 + "Z");
          }
        },
        "triangle-nw": {
          n: 12,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var r1 = round(r * 0.6, 2);
            var r2 = round(r * 1.2, 2);
            return align(angle, standoff, "M-" + r1 + "," + r2 + "V-" + r1 + "H" + r2 + "Z");
          }
        },
        pentagon: {
          n: 13,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var x1 = round(r * 0.951, 2);
            var x2 = round(r * 0.588, 2);
            var y0 = round(-r, 2);
            var y1 = round(r * -0.309, 2);
            var y2 = round(r * 0.809, 2);
            return align(angle, standoff, "M" + x1 + "," + y1 + "L" + x2 + "," + y2 + "H-" + x2 + "L-" + x1 + "," + y1 + "L0," + y0 + "Z");
          }
        },
        hexagon: {
          n: 14,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var y0 = round(r, 2);
            var y1 = round(r / 2, 2);
            var x = round(r * sqrt3 / 2, 2);
            return align(angle, standoff, "M" + x + ",-" + y1 + "V" + y1 + "L0," + y0 + "L-" + x + "," + y1 + "V-" + y1 + "L0,-" + y0 + "Z");
          }
        },
        hexagon2: {
          n: 15,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var x0 = round(r, 2);
            var x1 = round(r / 2, 2);
            var y = round(r * sqrt3 / 2, 2);
            return align(angle, standoff, "M-" + x1 + "," + y + "H" + x1 + "L" + x0 + ",0L" + x1 + ",-" + y + "H-" + x1 + "L-" + x0 + ",0Z");
          }
        },
        octagon: {
          n: 16,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var a = round(r * 0.924, 2);
            var b = round(r * 0.383, 2);
            return align(angle, standoff, "M-" + b + ",-" + a + "H" + b + "L" + a + ",-" + b + "V" + b + "L" + b + "," + a + "H-" + b + "L-" + a + "," + b + "V-" + b + "Z");
          }
        },
        star: {
          n: 17,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = r * 1.4;
            var x1 = round(rs * 0.225, 2);
            var x2 = round(rs * 0.951, 2);
            var x3 = round(rs * 0.363, 2);
            var x4 = round(rs * 0.588, 2);
            var y0 = round(-rs, 2);
            var y1 = round(rs * -0.309, 2);
            var y3 = round(rs * 0.118, 2);
            var y4 = round(rs * 0.809, 2);
            var y5 = round(rs * 0.382, 2);
            return align(angle, standoff, "M" + x1 + "," + y1 + "H" + x2 + "L" + x3 + "," + y3 + "L" + x4 + "," + y4 + "L0," + y5 + "L-" + x4 + "," + y4 + "L-" + x3 + "," + y3 + "L-" + x2 + "," + y1 + "H-" + x1 + "L0," + y0 + "Z");
          }
        },
        hexagram: {
          n: 18,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var y = round(r * 0.66, 2);
            var x1 = round(r * 0.38, 2);
            var x2 = round(r * 0.76, 2);
            return align(angle, standoff, "M-" + x2 + ",0l-" + x1 + ",-" + y + "h" + x2 + "l" + x1 + ",-" + y + "l" + x1 + "," + y + "h" + x2 + "l-" + x1 + "," + y + "l" + x1 + "," + y + "h-" + x2 + "l-" + x1 + "," + y + "l-" + x1 + ",-" + y + "h-" + x2 + "Z");
          }
        },
        "star-triangle-up": {
          n: 19,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var x = round(r * sqrt3 * 0.8, 2);
            var y1 = round(r * 0.8, 2);
            var y2 = round(r * 1.6, 2);
            var rc = round(r * 4, 2);
            var aPart = "A " + rc + "," + rc + " 0 0 1 ";
            return align(angle, standoff, "M-" + x + "," + y1 + aPart + x + "," + y1 + aPart + "0,-" + y2 + aPart + "-" + x + "," + y1 + "Z");
          }
        },
        "star-triangle-down": {
          n: 20,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var x = round(r * sqrt3 * 0.8, 2);
            var y1 = round(r * 0.8, 2);
            var y2 = round(r * 1.6, 2);
            var rc = round(r * 4, 2);
            var aPart = "A " + rc + "," + rc + " 0 0 1 ";
            return align(angle, standoff, "M" + x + ",-" + y1 + aPart + "-" + x + ",-" + y1 + aPart + "0," + y2 + aPart + x + ",-" + y1 + "Z");
          }
        },
        "star-square": {
          n: 21,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rp = round(r * 1.1, 2);
            var rc = round(r * 2, 2);
            var aPart = "A " + rc + "," + rc + " 0 0 1 ";
            return align(angle, standoff, "M-" + rp + ",-" + rp + aPart + "-" + rp + "," + rp + aPart + rp + "," + rp + aPart + rp + ",-" + rp + aPart + "-" + rp + ",-" + rp + "Z");
          }
        },
        "star-diamond": {
          n: 22,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rp = round(r * 1.4, 2);
            var rc = round(r * 1.9, 2);
            var aPart = "A " + rc + "," + rc + " 0 0 1 ";
            return align(angle, standoff, "M-" + rp + ",0" + aPart + "0," + rp + aPart + rp + ",0" + aPart + "0,-" + rp + aPart + "-" + rp + ",0Z");
          }
        },
        "diamond-tall": {
          n: 23,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var x = round(r * 0.7, 2);
            var y = round(r * 1.4, 2);
            return align(angle, standoff, "M0," + y + "L" + x + ",0L0,-" + y + "L-" + x + ",0Z");
          }
        },
        "diamond-wide": {
          n: 24,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var x = round(r * 1.4, 2);
            var y = round(r * 0.7, 2);
            return align(angle, standoff, "M0," + y + "L" + x + ",0L0,-" + y + "L-" + x + ",0Z");
          }
        },
        hourglass: {
          n: 25,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = round(r, 2);
            return align(angle, standoff, "M" + rs + "," + rs + "H-" + rs + "L" + rs + ",-" + rs + "H-" + rs + "Z");
          },
          noDot: true
        },
        bowtie: {
          n: 26,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = round(r, 2);
            return align(angle, standoff, "M" + rs + "," + rs + "V-" + rs + "L-" + rs + "," + rs + "V-" + rs + "Z");
          },
          noDot: true
        },
        "circle-cross": {
          n: 27,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = round(r, 2);
            return align(angle, standoff, "M0," + rs + "V-" + rs + "M" + rs + ",0H-" + rs + "M" + rs + ",0A" + rs + "," + rs + " 0 1,1 0,-" + rs + "A" + rs + "," + rs + " 0 0,1 " + rs + ",0Z");
          },
          needLine: true,
          noDot: true
        },
        "circle-x": {
          n: 28,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = round(r, 2);
            var rc = round(r / sqrt2, 2);
            return align(angle, standoff, "M" + rc + "," + rc + "L-" + rc + ",-" + rc + "M" + rc + ",-" + rc + "L-" + rc + "," + rc + "M" + rs + ",0A" + rs + "," + rs + " 0 1,1 0,-" + rs + "A" + rs + "," + rs + " 0 0,1 " + rs + ",0Z");
          },
          needLine: true,
          noDot: true
        },
        "square-cross": {
          n: 29,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = round(r, 2);
            return align(angle, standoff, "M0," + rs + "V-" + rs + "M" + rs + ",0H-" + rs + "M" + rs + "," + rs + "H-" + rs + "V-" + rs + "H" + rs + "Z");
          },
          needLine: true,
          noDot: true
        },
        "square-x": {
          n: 30,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rs = round(r, 2);
            return align(angle, standoff, "M" + rs + "," + rs + "L-" + rs + ",-" + rs + "M" + rs + ",-" + rs + "L-" + rs + "," + rs + "M" + rs + "," + rs + "H-" + rs + "V-" + rs + "H" + rs + "Z");
          },
          needLine: true,
          noDot: true
        },
        "diamond-cross": {
          n: 31,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rd = round(r * 1.3, 2);
            return align(angle, standoff, "M" + rd + ",0L0," + rd + "L-" + rd + ",0L0,-" + rd + "ZM0,-" + rd + "V" + rd + "M-" + rd + ",0H" + rd);
          },
          needLine: true,
          noDot: true
        },
        "diamond-x": {
          n: 32,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rd = round(r * 1.3, 2);
            var r2 = round(r * 0.65, 2);
            return align(angle, standoff, "M" + rd + ",0L0," + rd + "L-" + rd + ",0L0,-" + rd + "ZM-" + r2 + ",-" + r2 + "L" + r2 + "," + r2 + "M-" + r2 + "," + r2 + "L" + r2 + ",-" + r2);
          },
          needLine: true,
          noDot: true
        },
        "cross-thin": {
          n: 33,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rc = round(r * 1.4, 2);
            return align(angle, standoff, "M0," + rc + "V-" + rc + "M" + rc + ",0H-" + rc);
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "x-thin": {
          n: 34,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r, 2);
            return align(angle, standoff, "M" + rx + "," + rx + "L-" + rx + ",-" + rx + "M" + rx + ",-" + rx + "L-" + rx + "," + rx);
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        asterisk: {
          n: 35,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rc = round(r * 1.2, 2);
            var rs = round(r * 0.85, 2);
            return align(angle, standoff, "M0," + rc + "V-" + rc + "M" + rc + ",0H-" + rc + "M" + rs + "," + rs + "L-" + rs + ",-" + rs + "M" + rs + ",-" + rs + "L-" + rs + "," + rs);
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        hash: {
          n: 36,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var r1 = round(r / 2, 2);
            var r2 = round(r, 2);
            return align(angle, standoff, "M" + r1 + "," + r2 + "V-" + r2 + "M" + (r1 - r2) + ",-" + r2 + "V" + r2 + "M" + r2 + "," + r1 + "H-" + r2 + "M-" + r2 + "," + (r1 - r2) + "H" + r2);
          },
          needLine: true,
          noFill: true
        },
        "y-up": {
          n: 37,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var x = round(r * 1.2, 2);
            var y0 = round(r * 1.6, 2);
            var y1 = round(r * 0.8, 2);
            return align(angle, standoff, "M-" + x + "," + y1 + "L0,0M" + x + "," + y1 + "L0,0M0,-" + y0 + "L0,0");
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "y-down": {
          n: 38,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var x = round(r * 1.2, 2);
            var y0 = round(r * 1.6, 2);
            var y1 = round(r * 0.8, 2);
            return align(angle, standoff, "M-" + x + ",-" + y1 + "L0,0M" + x + ",-" + y1 + "L0,0M0," + y0 + "L0,0");
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "y-left": {
          n: 39,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var y = round(r * 1.2, 2);
            var x0 = round(r * 1.6, 2);
            var x1 = round(r * 0.8, 2);
            return align(angle, standoff, "M" + x1 + "," + y + "L0,0M" + x1 + ",-" + y + "L0,0M-" + x0 + ",0L0,0");
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "y-right": {
          n: 40,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var y = round(r * 1.2, 2);
            var x0 = round(r * 1.6, 2);
            var x1 = round(r * 0.8, 2);
            return align(angle, standoff, "M-" + x1 + "," + y + "L0,0M-" + x1 + ",-" + y + "L0,0M" + x0 + ",0L0,0");
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "line-ew": {
          n: 41,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rc = round(r * 1.4, 2);
            return align(angle, standoff, "M" + rc + ",0H-" + rc);
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "line-ns": {
          n: 42,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rc = round(r * 1.4, 2);
            return align(angle, standoff, "M0," + rc + "V-" + rc);
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "line-ne": {
          n: 43,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r, 2);
            return align(angle, standoff, "M" + rx + ",-" + rx + "L-" + rx + "," + rx);
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "line-nw": {
          n: 44,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r, 2);
            return align(angle, standoff, "M" + rx + "," + rx + "L-" + rx + ",-" + rx);
          },
          needLine: true,
          noDot: true,
          noFill: true
        },
        "arrow-up": {
          n: 45,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r, 2);
            var ry = round(r * 2, 2);
            return align(angle, standoff, "M0,0L-" + rx + "," + ry + "H" + rx + "Z");
          },
          backoff: 1,
          noDot: true
        },
        "arrow-down": {
          n: 46,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r, 2);
            var ry = round(r * 2, 2);
            return align(angle, standoff, "M0,0L-" + rx + ",-" + ry + "H" + rx + "Z");
          },
          noDot: true
        },
        "arrow-left": {
          n: 47,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r * 2, 2);
            var ry = round(r, 2);
            return align(angle, standoff, "M0,0L" + rx + ",-" + ry + "V" + ry + "Z");
          },
          noDot: true
        },
        "arrow-right": {
          n: 48,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r * 2, 2);
            var ry = round(r, 2);
            return align(angle, standoff, "M0,0L-" + rx + ",-" + ry + "V" + ry + "Z");
          },
          noDot: true
        },
        "arrow-bar-up": {
          n: 49,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r, 2);
            var ry = round(r * 2, 2);
            return align(angle, standoff, "M-" + rx + ",0H" + rx + "M0,0L-" + rx + "," + ry + "H" + rx + "Z");
          },
          backoff: 1,
          needLine: true,
          noDot: true
        },
        "arrow-bar-down": {
          n: 50,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r, 2);
            var ry = round(r * 2, 2);
            return align(angle, standoff, "M-" + rx + ",0H" + rx + "M0,0L-" + rx + ",-" + ry + "H" + rx + "Z");
          },
          needLine: true,
          noDot: true
        },
        "arrow-bar-left": {
          n: 51,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r * 2, 2);
            var ry = round(r, 2);
            return align(angle, standoff, "M0,-" + ry + "V" + ry + "M0,0L" + rx + ",-" + ry + "V" + ry + "Z");
          },
          needLine: true,
          noDot: true
        },
        "arrow-bar-right": {
          n: 52,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var rx = round(r * 2, 2);
            var ry = round(r, 2);
            return align(angle, standoff, "M0,-" + ry + "V" + ry + "M0,0L-" + rx + ",-" + ry + "V" + ry + "Z");
          },
          needLine: true,
          noDot: true
        },
        arrow: {
          n: 53,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var headAngle = PI / 2.5;
            var x = 2 * r * cos(headAngle);
            var y = 2 * r * sin(headAngle);
            return align(
              angle,
              standoff,
              "M0,0L" + -x + "," + y + "L" + x + "," + y + "Z"
            );
          },
          backoff: 0.9,
          noDot: true
        },
        "arrow-wide": {
          n: 54,
          f: function(r, angle, standoff) {
            if (skipAngle(angle)) return emptyPath;
            var headAngle = PI / 4;
            var x = 2 * r * cos(headAngle);
            var y = 2 * r * sin(headAngle);
            return align(
              angle,
              standoff,
              "M0,0L" + -x + "," + y + "A " + 2 * r + "," + 2 * r + " 0 0 1 " + x + "," + y + "Z"
            );
          },
          backoff: 0.4,
          noDot: true
        }
      };
      function skipAngle(angle) {
        return angle === null;
      }
      var lastPathIn;
      var lastPathOut;
      var lastAngle;
      var lastStandoff;
      function align(angle, standoff, path) {
        if ((!angle || angle % 360 === 0) && !standoff) return path;
        if (lastAngle === angle && lastStandoff === standoff && lastPathIn === path) return lastPathOut;
        lastAngle = angle;
        lastStandoff = standoff;
        lastPathIn = path;
        function rotate(t4, xy) {
          var cosT = cos(t4);
          var sinT = sin(t4);
          var x2 = xy[0];
          var y2 = xy[1] + (standoff || 0);
          return [
            x2 * cosT - y2 * sinT,
            x2 * sinT + y2 * cosT
          ];
        }
        var t = angle / 180 * PI;
        var x = 0;
        var y = 0;
        var cmd = parseSvgPath(path);
        var str = "";
        for (var i = 0; i < cmd.length; i++) {
          var cmdI = cmd[i];
          var op = cmdI[0];
          var x0 = x;
          var y0 = y;
          if (op === "M" || op === "L") {
            x = +cmdI[1];
            y = +cmdI[2];
          } else if (op === "m" || op === "l") {
            x += +cmdI[1];
            y += +cmdI[2];
          } else if (op === "H") {
            x = +cmdI[1];
          } else if (op === "h") {
            x += +cmdI[1];
          } else if (op === "V") {
            y = +cmdI[1];
          } else if (op === "v") {
            y += +cmdI[1];
          } else if (op === "A") {
            x = +cmdI[1];
            y = +cmdI[2];
            var E2 = rotate(t, [+cmdI[6], +cmdI[7]]);
            cmdI[6] = E2[0];
            cmdI[7] = E2[1];
            cmdI[3] = +cmdI[3] + angle;
          }
          if (op === "H" || op === "V") op = "L";
          if (op === "h" || op === "v") op = "l";
          if (op === "m" || op === "l") {
            x -= x0;
            y -= y0;
          }
          var B2 = rotate(t, [x, y]);
          if (op === "H" || op === "V") op = "L";
          if (op === "M" || op === "L" || op === "m" || op === "l") {
            cmdI[1] = B2[0];
            cmdI[2] = B2[1];
          }
          cmdI[0] = op;
          str += cmdI[0] + cmdI.slice(1).join(",");
        }
        lastPathOut = str;
        return str;
      }
    }
  });

  // src/components/drawing/index.js
  var require_drawing = __commonJS({
    "src/components/drawing/index.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var Lib = require_lib();
      var numberFormat = Lib.numberFormat;
      var isNumeric = require_fast_isnumeric();
      var tinycolor = require_tinycolor();
      var Registry = require_registry();
      var Color2 = require_color();
      var Colorscale = require_colorscale();
      var strTranslate = Lib.strTranslate;
      var svgTextUtils = require_svg_text_utils();
      var xmlnsNamespaces = require_xmlns_namespaces();
      var alignment = require_alignment();
      var LINE_SPACING = alignment.LINE_SPACING;
      var DESELECTDIM = require_interactions().DESELECTDIM;
      var subTypes = require_subtypes();
      var makeBubbleSizeFn = require_make_bubble_size_func();
      var appendArrayPointValue = require_helpers2().appendArrayPointValue;
      var drawing = module.exports = {};
      drawing.font = function(s, font) {
        var variant = font.variant;
        var style = font.style;
        var weight = font.weight;
        var color2 = font.color;
        var size = font.size;
        var family = font.family;
        var shadow = font.shadow;
        var lineposition = font.lineposition;
        var textcase = font.textcase;
        if (family) s.style("font-family", family);
        if (size + 1) s.style("font-size", size + "px");
        if (color2) s.call(Color2.fill, color2);
        if (weight) s.style("font-weight", weight);
        if (style) s.style("font-style", style);
        if (variant) s.style("font-variant", variant);
        if (textcase) s.style("text-transform", dropNone(textcase2transform(textcase)));
        if (shadow) s.style("text-shadow", shadow === "auto" ? svgTextUtils.makeTextShadow(Color2.contrast(color2)) : dropNone(shadow));
        if (lineposition) s.style("text-decoration-line", dropNone(lineposition2decorationLine(lineposition)));
      };
      function dropNone(a) {
        return a === "none" ? void 0 : a;
      }
      var textcase2transformOptions = {
        normal: "none",
        lower: "lowercase",
        upper: "uppercase",
        "word caps": "capitalize"
      };
      function textcase2transform(textcase) {
        return textcase2transformOptions[textcase];
      }
      function lineposition2decorationLine(lineposition) {
        return lineposition.replace("under", "underline").replace("over", "overline").replace("through", "line-through").split("+").join(" ");
      }
      drawing.setPosition = function(s, x, y) {
        s.attr("x", x).attr("y", y);
      };
      drawing.setSize = function(s, w, h) {
        s.attr("width", w).attr("height", h);
      };
      drawing.setRect = function(s, x, y, w, h) {
        s.call(drawing.setPosition, x, y).call(drawing.setSize, w, h);
      };
      drawing.translatePoint = function(d, sel, xa, ya) {
        var x = xa.c2p(d.x);
        var y = ya.c2p(d.y);
        if (isNumeric(x) && isNumeric(y) && sel.node()) {
          if (sel.node().nodeName === "text") {
            sel.attr("x", x).attr("y", y);
          } else {
            sel.attr("transform", strTranslate(x, y));
          }
        } else {
          return false;
        }
        return true;
      };
      drawing.translatePoints = function(s, xa, ya) {
        s.each(function(d) {
          var sel = d3.select(this);
          drawing.translatePoint(d, sel, xa, ya);
        });
      };
      drawing.hideOutsideRangePoint = function(d, sel, xa, ya, xcalendar, ycalendar) {
        sel.attr(
          "display",
          xa.isPtWithinRange(d, xcalendar) && ya.isPtWithinRange(d, ycalendar) ? null : "none"
        );
      };
      drawing.hideOutsideRangePoints = function(traceGroups, subplot) {
        if (!subplot._hasClipOnAxisFalse) return;
        var xa = subplot.xaxis;
        var ya = subplot.yaxis;
        traceGroups.each(function(d) {
          var trace = d[0].trace;
          var xcalendar = trace.xcalendar;
          var ycalendar = trace.ycalendar;
          var selector = Registry.traceIs(trace, "bar-like") ? ".bartext" : ".point,.textpoint";
          traceGroups.selectAll(selector).each(function(d2) {
            drawing.hideOutsideRangePoint(d2, d3.select(this), xa, ya, xcalendar, ycalendar);
          });
        });
      };
      drawing.crispRound = function(gd, lineWidth, dflt) {
        if (!lineWidth || !isNumeric(lineWidth)) return dflt || 0;
        if (gd._context.staticPlot) return lineWidth;
        if (lineWidth < 1) return 1;
        return Math.round(lineWidth);
      };
      drawing.singleLineStyle = function(d, s, lw, lc, ld) {
        s.style("fill", "none");
        var line = (((d || [])[0] || {}).trace || {}).line || {};
        var lw1 = lw || line.width || 0;
        var dash = ld || line.dash || "";
        Color2.stroke(s, lc || line.color);
        drawing.dashLine(s, dash, lw1);
      };
      drawing.lineGroupStyle = function(s, lw, lc, ld) {
        s.style("fill", "none").each(function(d) {
          var line = (((d || [])[0] || {}).trace || {}).line || {};
          var lw1 = lw || line.width || 0;
          var dash = ld || line.dash || "";
          d3.select(this).call(Color2.stroke, lc || line.color).call(drawing.dashLine, dash, lw1);
        });
      };
      drawing.dashLine = function(s, dash, lineWidth) {
        lineWidth = +lineWidth || 0;
        dash = drawing.dashStyle(dash, lineWidth);
        s.style({
          "stroke-dasharray": dash,
          "stroke-width": lineWidth + "px"
        });
      };
      drawing.dashStyle = function(dash, lineWidth) {
        lineWidth = +lineWidth || 1;
        var dlw = Math.max(lineWidth, 3);
        if (dash === "solid") dash = "";
        else if (dash === "dot") dash = dlw + "px," + dlw + "px";
        else if (dash === "dash") dash = 3 * dlw + "px," + 3 * dlw + "px";
        else if (dash === "longdash") dash = 5 * dlw + "px," + 5 * dlw + "px";
        else if (dash === "dashdot") {
          dash = 3 * dlw + "px," + dlw + "px," + dlw + "px," + dlw + "px";
        } else if (dash === "longdashdot") {
          dash = 5 * dlw + "px," + 2 * dlw + "px," + dlw + "px," + 2 * dlw + "px";
        }
        return dash;
      };
      function setFillStyle(sel, trace, gd, forLegend) {
        var markerPattern = trace.fillpattern;
        var fillgradient = trace.fillgradient;
        var patternShape = markerPattern && drawing.getPatternAttr(markerPattern.shape, 0, "");
        if (patternShape) {
          var patternBGColor = drawing.getPatternAttr(markerPattern.bgcolor, 0, null);
          var patternFGColor = drawing.getPatternAttr(markerPattern.fgcolor, 0, null);
          var patternFGOpacity = markerPattern.fgopacity;
          var patternSize = drawing.getPatternAttr(markerPattern.size, 0, 8);
          var patternSolidity = drawing.getPatternAttr(markerPattern.solidity, 0, 0.3);
          var patternID = trace.uid;
          drawing.pattern(
            sel,
            "point",
            gd,
            patternID,
            patternShape,
            patternSize,
            patternSolidity,
            void 0,
            markerPattern.fillmode,
            patternBGColor,
            patternFGColor,
            patternFGOpacity
          );
        } else if (fillgradient && fillgradient.type !== "none") {
          var direction = fillgradient.type;
          var gradientID = "scatterfill-" + trace.uid;
          if (forLegend) {
            gradientID = "legendfill-" + trace.uid;
          }
          if (!forLegend && (fillgradient.start !== void 0 || fillgradient.stop !== void 0)) {
            var start, stop;
            if (direction === "horizontal") {
              start = {
                x: fillgradient.start,
                y: 0
              };
              stop = {
                x: fillgradient.stop,
                y: 0
              };
            } else if (direction === "vertical") {
              start = {
                x: 0,
                y: fillgradient.start
              };
              stop = {
                x: 0,
                y: fillgradient.stop
              };
            }
            start.x = trace._xA.c2p(
              start.x === void 0 ? trace._extremes.x.min[0].val : start.x,
              true
            );
            start.y = trace._yA.c2p(
              start.y === void 0 ? trace._extremes.y.min[0].val : start.y,
              true
            );
            stop.x = trace._xA.c2p(
              stop.x === void 0 ? trace._extremes.x.max[0].val : stop.x,
              true
            );
            stop.y = trace._yA.c2p(
              stop.y === void 0 ? trace._extremes.y.max[0].val : stop.y,
              true
            );
            sel.call(gradientWithBounds, gd, gradientID, "linear", fillgradient.colorscale, "fill", start, stop, true, false);
          } else {
            if (direction === "horizontal") {
              direction = direction + "reversed";
            }
            sel.call(drawing.gradient, gd, gradientID, direction, fillgradient.colorscale, "fill");
          }
        } else if (trace.fillcolor) {
          sel.call(Color2.fill, trace.fillcolor);
        }
      }
      drawing.singleFillStyle = function(sel, gd) {
        var node = d3.select(sel.node());
        var data = node.data();
        var trace = ((data[0] || [])[0] || {}).trace || {};
        setFillStyle(sel, trace, gd, false);
      };
      drawing.fillGroupStyle = function(s, gd, forLegend) {
        s.style("stroke-width", 0).each(function(d) {
          var shape = d3.select(this);
          if (d[0].trace) {
            setFillStyle(shape, d[0].trace, gd, forLegend);
          }
        });
      };
      var SYMBOLDEFS = require_symbol_defs();
      drawing.symbolNames = [];
      drawing.symbolFuncs = [];
      drawing.symbolBackOffs = [];
      drawing.symbolNeedLines = {};
      drawing.symbolNoDot = {};
      drawing.symbolNoFill = {};
      drawing.symbolList = [];
      Object.keys(SYMBOLDEFS).forEach(function(k) {
        var symDef = SYMBOLDEFS[k];
        var n = symDef.n;
        drawing.symbolList.push(
          n,
          String(n),
          k,
          n + 100,
          String(n + 100),
          k + "-open"
        );
        drawing.symbolNames[n] = k;
        drawing.symbolFuncs[n] = symDef.f;
        drawing.symbolBackOffs[n] = symDef.backoff || 0;
        if (symDef.needLine) {
          drawing.symbolNeedLines[n] = true;
        }
        if (symDef.noDot) {
          drawing.symbolNoDot[n] = true;
        } else {
          drawing.symbolList.push(
            n + 200,
            String(n + 200),
            k + "-dot",
            n + 300,
            String(n + 300),
            k + "-open-dot"
          );
        }
        if (symDef.noFill) {
          drawing.symbolNoFill[n] = true;
        }
      });
      var MAXSYMBOL = drawing.symbolNames.length;
      var DOTPATH = "M0,0.5L0.5,0L0,-0.5L-0.5,0Z";
      drawing.symbolNumber = function(v) {
        if (isNumeric(v)) {
          v = +v;
        } else if (typeof v === "string") {
          var vbase = 0;
          if (v.indexOf("-open") > 0) {
            vbase = 100;
            v = v.replace("-open", "");
          }
          if (v.indexOf("-dot") > 0) {
            vbase += 200;
            v = v.replace("-dot", "");
          }
          v = drawing.symbolNames.indexOf(v);
          if (v >= 0) {
            v += vbase;
          }
        }
        return v % 100 >= MAXSYMBOL || v >= 400 ? 0 : Math.floor(Math.max(v, 0));
      };
      function makePointPath(symbolNumber, r, t, s) {
        var base = symbolNumber % 100;
        return drawing.symbolFuncs[base](r, t, s) + (symbolNumber >= 200 ? DOTPATH : "");
      }
      var stopFormatter = numberFormat("~f");
      var gradientInfo = {
        radial: { type: "radial" },
        radialreversed: { type: "radial", reversed: true },
        horizontal: { type: "linear", start: { x: 1, y: 0 }, stop: { x: 0, y: 0 } },
        horizontalreversed: { type: "linear", start: { x: 1, y: 0 }, stop: { x: 0, y: 0 }, reversed: true },
        vertical: { type: "linear", start: { x: 0, y: 1 }, stop: { x: 0, y: 0 } },
        verticalreversed: { type: "linear", start: { x: 0, y: 1 }, stop: { x: 0, y: 0 }, reversed: true }
      };
      drawing.gradient = function(sel, gd, gradientID, type, colorscale, prop) {
        var info = gradientInfo[type];
        return gradientWithBounds(
          sel,
          gd,
          gradientID,
          info.type,
          colorscale,
          prop,
          info.start,
          info.stop,
          false,
          info.reversed
        );
      };
      function gradientWithBounds(sel, gd, gradientID, type, colorscale, prop, start, stop, inUserSpace, reversed) {
        var len = colorscale.length;
        var info;
        if (type === "linear") {
          info = {
            node: "linearGradient",
            attrs: {
              x1: start.x,
              y1: start.y,
              x2: stop.x,
              y2: stop.y,
              gradientUnits: inUserSpace ? "userSpaceOnUse" : "objectBoundingBox"
            },
            reversed
          };
        } else if (type === "radial") {
          info = {
            node: "radialGradient",
            reversed
          };
        }
        var colorStops = new Array(len);
        for (var i = 0; i < len; i++) {
          if (info.reversed) {
            colorStops[len - 1 - i] = [stopFormatter((1 - colorscale[i][0]) * 100), colorscale[i][1]];
          } else {
            colorStops[i] = [stopFormatter(colorscale[i][0] * 100), colorscale[i][1]];
          }
        }
        var fullLayout = gd._fullLayout;
        var fullID = "g" + fullLayout._uid + "-" + gradientID;
        var gradient = fullLayout._defs.select(".gradients").selectAll("#" + fullID).data([type + colorStops.join(";")], Lib.identity);
        gradient.exit().remove();
        gradient.enter().append(info.node).each(function() {
          var el = d3.select(this);
          if (info.attrs) el.attr(info.attrs);
          el.attr("id", fullID);
          var stops = el.selectAll("stop").data(colorStops);
          stops.exit().remove();
          stops.enter().append("stop");
          stops.each(function(d) {
            var tc = tinycolor(d[1]);
            d3.select(this).attr({
              offset: d[0] + "%",
              "stop-color": Color2.tinyRGB(tc),
              "stop-opacity": tc.getAlpha()
            });
          });
        });
        sel.style(prop, getFullUrl(fullID, gd)).style(prop + "-opacity", null);
        sel.classed("gradient_filled", true);
      }
      drawing.pattern = function(sel, calledBy, gd, patternID, shape, size, solidity, mcc, fillmode, bgcolor, fgcolor, fgopacity) {
        var isLegend = calledBy === "legend";
        if (mcc) {
          if (fillmode === "overlay") {
            bgcolor = mcc;
            fgcolor = Color2.contrast(bgcolor);
          } else {
            bgcolor = void 0;
            fgcolor = mcc;
          }
        }
        var fullLayout = gd._fullLayout;
        var fullID = "p" + fullLayout._uid + "-" + patternID;
        var width, height;
        var linearFn = function(x, x0, x1, y0, y1) {
          return y0 + (y1 - y0) * (x - x0) / (x1 - x0);
        };
        var path, linewidth, radius;
        var patternTag;
        var patternAttrs = {};
        var fgC = tinycolor(fgcolor);
        var fgRGB = Color2.tinyRGB(fgC);
        var fgAlpha = fgC.getAlpha();
        var opacity = fgopacity * fgAlpha;
        switch (shape) {
          case "/":
            width = size * Math.sqrt(2);
            height = size * Math.sqrt(2);
            path = "M-" + width / 4 + "," + height / 4 + "l" + width / 2 + ",-" + height / 2 + "M0," + height + "L" + width + ",0M" + width / 4 * 3 + "," + height / 4 * 5 + "l" + width / 2 + ",-" + height / 2;
            linewidth = solidity * size;
            patternTag = "path";
            patternAttrs = {
              d: path,
              opacity,
              stroke: fgRGB,
              "stroke-width": linewidth + "px"
            };
            break;
          case "\\":
            width = size * Math.sqrt(2);
            height = size * Math.sqrt(2);
            path = "M" + width / 4 * 3 + ",-" + height / 4 + "l" + width / 2 + "," + height / 2 + "M0,0L" + width + "," + height + "M-" + width / 4 + "," + height / 4 * 3 + "l" + width / 2 + "," + height / 2;
            linewidth = solidity * size;
            patternTag = "path";
            patternAttrs = {
              d: path,
              opacity,
              stroke: fgRGB,
              "stroke-width": linewidth + "px"
            };
            break;
          case "x":
            width = size * Math.sqrt(2);
            height = size * Math.sqrt(2);
            path = "M-" + width / 4 + "," + height / 4 + "l" + width / 2 + ",-" + height / 2 + "M0," + height + "L" + width + ",0M" + width / 4 * 3 + "," + height / 4 * 5 + "l" + width / 2 + ",-" + height / 2 + "M" + width / 4 * 3 + ",-" + height / 4 + "l" + width / 2 + "," + height / 2 + "M0,0L" + width + "," + height + "M-" + width / 4 + "," + height / 4 * 3 + "l" + width / 2 + "," + height / 2;
            linewidth = size - size * Math.sqrt(1 - solidity);
            patternTag = "path";
            patternAttrs = {
              d: path,
              opacity,
              stroke: fgRGB,
              "stroke-width": linewidth + "px"
            };
            break;
          case "|":
            width = size;
            height = size;
            patternTag = "path";
            path = "M" + width / 2 + ",0L" + width / 2 + "," + height;
            linewidth = solidity * size;
            patternTag = "path";
            patternAttrs = {
              d: path,
              opacity,
              stroke: fgRGB,
              "stroke-width": linewidth + "px"
            };
            break;
          case "-":
            width = size;
            height = size;
            patternTag = "path";
            path = "M0," + height / 2 + "L" + width + "," + height / 2;
            linewidth = solidity * size;
            patternTag = "path";
            patternAttrs = {
              d: path,
              opacity,
              stroke: fgRGB,
              "stroke-width": linewidth + "px"
            };
            break;
          case "+":
            width = size;
            height = size;
            patternTag = "path";
            path = "M" + width / 2 + ",0L" + width / 2 + "," + height + "M0," + height / 2 + "L" + width + "," + height / 2;
            linewidth = size - size * Math.sqrt(1 - solidity);
            patternTag = "path";
            patternAttrs = {
              d: path,
              opacity,
              stroke: fgRGB,
              "stroke-width": linewidth + "px"
            };
            break;
          case ".":
            width = size;
            height = size;
            if (solidity < Math.PI / 4) {
              radius = Math.sqrt(solidity * size * size / Math.PI);
            } else {
              radius = linearFn(solidity, Math.PI / 4, 1, size / 2, size / Math.sqrt(2));
            }
            patternTag = "circle";
            patternAttrs = {
              cx: width / 2,
              cy: height / 2,
              r: radius,
              opacity,
              fill: fgRGB
            };
            break;
        }
        var str = [
          shape || "noSh",
          bgcolor || "noBg",
          fgcolor || "noFg",
          size,
          solidity
        ].join(";");
        var pattern = fullLayout._defs.select(".patterns").selectAll("#" + fullID).data([str], Lib.identity);
        pattern.exit().remove();
        pattern.enter().append("pattern").each(function() {
          var el = d3.select(this);
          el.attr({
            id: fullID,
            width: width + "px",
            height: height + "px",
            patternUnits: "userSpaceOnUse",
            // for legends scale down patterns just a bit so that default size (i.e 8) nicely fit in small icons
            patternTransform: isLegend ? "scale(0.8)" : ""
          });
          if (bgcolor) {
            var bgC = tinycolor(bgcolor);
            var bgRGB = Color2.tinyRGB(bgC);
            var bgAlpha = bgC.getAlpha();
            var rects = el.selectAll("rect").data([0]);
            rects.exit().remove();
            rects.enter().append("rect").attr({
              width: width + "px",
              height: height + "px",
              fill: bgRGB,
              "fill-opacity": bgAlpha
            });
          }
          var patterns = el.selectAll(patternTag).data([0]);
          patterns.exit().remove();
          patterns.enter().append(patternTag).attr(patternAttrs);
        });
        sel.style("fill", getFullUrl(fullID, gd)).style("fill-opacity", null);
        sel.classed("pattern_filled", true);
      };
      drawing.initGradients = function(gd) {
        var fullLayout = gd._fullLayout;
        var gradientsGroup = Lib.ensureSingle(fullLayout._defs, "g", "gradients");
        gradientsGroup.selectAll("linearGradient,radialGradient").remove();
        d3.select(gd).selectAll(".gradient_filled").classed("gradient_filled", false);
      };
      drawing.initPatterns = function(gd) {
        var fullLayout = gd._fullLayout;
        var patternsGroup = Lib.ensureSingle(fullLayout._defs, "g", "patterns");
        patternsGroup.selectAll("pattern").remove();
        d3.select(gd).selectAll(".pattern_filled").classed("pattern_filled", false);
      };
      drawing.getPatternAttr = function(mp, i, dflt) {
        if (mp && Lib.isArrayOrTypedArray(mp)) {
          return i < mp.length ? mp[i] : dflt;
        }
        return mp;
      };
      drawing.pointStyle = function(s, trace, gd, pt) {
        if (!s.size()) return;
        var fns = drawing.makePointStyleFns(trace);
        s.each(function(d) {
          drawing.singlePointStyle(d, d3.select(this), trace, fns, gd, pt);
        });
      };
      drawing.singlePointStyle = function(d, sel, trace, fns, gd, pt) {
        var marker = trace.marker;
        var markerLine = marker.line;
        if (pt && pt.i >= 0 && d.i === void 0) d.i = pt.i;
        sel.style(
          "opacity",
          fns.selectedOpacityFn ? fns.selectedOpacityFn(d) : d.mo === void 0 ? marker.opacity : d.mo
        );
        if (fns.ms2mrc) {
          var r;
          if (d.ms === "various" || marker.size === "various") {
            r = 3;
          } else {
            r = fns.ms2mrc(d.ms);
          }
          d.mrc = r;
          if (fns.selectedSizeFn) {
            r = d.mrc = fns.selectedSizeFn(d);
          }
          var x = drawing.symbolNumber(d.mx || marker.symbol) || 0;
          d.om = x % 200 >= 100;
          var angle = getMarkerAngle(d, trace);
          var standoff = getMarkerStandoff(d, trace);
          sel.attr("d", makePointPath(x, r, angle, standoff));
        }
        var perPointGradient = false;
        var fillColor, lineColor, lineWidth;
        if (d.so) {
          lineWidth = markerLine.outlierwidth;
          lineColor = markerLine.outliercolor;
          fillColor = marker.outliercolor;
        } else {
          var markerLineWidth = (markerLine || {}).width;
          lineWidth = (d.mlw + 1 || markerLineWidth + 1 || // TODO: we need the latter for legends... can we get rid of it?
          (d.trace ? (d.trace.marker.line || {}).width : 0) + 1) - 1 || 0;
          if ("mlc" in d) lineColor = d.mlcc = fns.lineScale(d.mlc);
          else if (Lib.isArrayOrTypedArray(markerLine.color)) lineColor = Color2.defaultLine;
          else lineColor = markerLine.color;
          if (Lib.isArrayOrTypedArray(marker.color)) {
            fillColor = Color2.defaultLine;
            perPointGradient = true;
          }
          if ("mc" in d) {
            fillColor = d.mcc = fns.markerScale(d.mc);
          } else {
            fillColor = marker.color || marker.colors || "rgba(0,0,0,0)";
          }
          if (fns.selectedColorFn) {
            fillColor = fns.selectedColorFn(d);
          }
        }
        if (d.om) {
          sel.call(Color2.stroke, fillColor).style({
            "stroke-width": (lineWidth || 1) + "px",
            fill: "none"
          });
        } else {
          sel.style("stroke-width", (d.isBlank ? 0 : lineWidth) + "px");
          var markerGradient = marker.gradient;
          var gradientType = d.mgt;
          if (gradientType) perPointGradient = true;
          else gradientType = markerGradient && markerGradient.type;
          if (Lib.isArrayOrTypedArray(gradientType)) {
            gradientType = gradientType[0];
            if (!gradientInfo[gradientType]) gradientType = 0;
          }
          var markerPattern = marker.pattern;
          var patternShape = markerPattern && drawing.getPatternAttr(markerPattern.shape, d.i, "");
          if (gradientType && gradientType !== "none") {
            var gradientColor = d.mgc;
            if (gradientColor) perPointGradient = true;
            else gradientColor = markerGradient.color;
            var gradientID = trace.uid;
            if (perPointGradient) gradientID += "-" + d.i;
            drawing.gradient(
              sel,
              gd,
              gradientID,
              gradientType,
              [[0, gradientColor], [1, fillColor]],
              "fill"
            );
          } else if (patternShape) {
            var perPointPattern = false;
            var fgcolor = markerPattern.fgcolor;
            if (!fgcolor && pt && pt.color) {
              fgcolor = pt.color;
              perPointPattern = true;
            }
            var patternFGColor = drawing.getPatternAttr(fgcolor, d.i, pt && pt.color || null);
            var patternBGColor = drawing.getPatternAttr(markerPattern.bgcolor, d.i, null);
            var patternFGOpacity = markerPattern.fgopacity;
            var patternSize = drawing.getPatternAttr(markerPattern.size, d.i, 8);
            var patternSolidity = drawing.getPatternAttr(markerPattern.solidity, d.i, 0.3);
            perPointPattern = perPointPattern || d.mcc || Lib.isArrayOrTypedArray(markerPattern.shape) || Lib.isArrayOrTypedArray(markerPattern.bgcolor) || Lib.isArrayOrTypedArray(markerPattern.fgcolor) || Lib.isArrayOrTypedArray(markerPattern.size) || Lib.isArrayOrTypedArray(markerPattern.solidity);
            var patternID = trace.uid;
            if (perPointPattern) patternID += "-" + d.i;
            drawing.pattern(
              sel,
              "point",
              gd,
              patternID,
              patternShape,
              patternSize,
              patternSolidity,
              d.mcc,
              markerPattern.fillmode,
              patternBGColor,
              patternFGColor,
              patternFGOpacity
            );
          } else {
            Lib.isArrayOrTypedArray(fillColor) ? Color2.fill(sel, fillColor[d.i]) : Color2.fill(sel, fillColor);
          }
          if (lineWidth) {
            Color2.stroke(sel, lineColor);
          }
        }
      };
      drawing.makePointStyleFns = function(trace) {
        var out = {};
        var marker = trace.marker;
        out.markerScale = drawing.tryColorscale(marker, "");
        out.lineScale = drawing.tryColorscale(marker, "line");
        if (Registry.traceIs(trace, "symbols")) {
          out.ms2mrc = subTypes.isBubble(trace) ? makeBubbleSizeFn(trace) : function() {
            return (marker.size || 6) / 2;
          };
        }
        if (trace.selectedpoints) {
          Lib.extendFlat(out, drawing.makeSelectedPointStyleFns(trace));
        }
        return out;
      };
      drawing.makeSelectedPointStyleFns = function(trace) {
        var out = {};
        var selectedAttrs = trace.selected || {};
        var unselectedAttrs = trace.unselected || {};
        var marker = trace.marker || {};
        var selectedMarker = selectedAttrs.marker || {};
        var unselectedMarker = unselectedAttrs.marker || {};
        var mo = marker.opacity;
        var smo = selectedMarker.opacity;
        var usmo = unselectedMarker.opacity;
        var smoIsDefined = smo !== void 0;
        var usmoIsDefined = usmo !== void 0;
        if (Lib.isArrayOrTypedArray(mo) || smoIsDefined || usmoIsDefined) {
          out.selectedOpacityFn = function(d) {
            var base = d.mo === void 0 ? marker.opacity : d.mo;
            if (d.selected) {
              return smoIsDefined ? smo : base;
            } else {
              return usmoIsDefined ? usmo : DESELECTDIM * base;
            }
          };
        }
        var mc = marker.color;
        var smc = selectedMarker.color;
        var usmc = unselectedMarker.color;
        if (smc || usmc) {
          out.selectedColorFn = function(d) {
            var base = d.mcc || mc;
            if (d.selected) {
              return smc || base;
            } else {
              return usmc || base;
            }
          };
        }
        var ms = marker.size;
        var sms = selectedMarker.size;
        var usms = unselectedMarker.size;
        var smsIsDefined = sms !== void 0;
        var usmsIsDefined = usms !== void 0;
        if (Registry.traceIs(trace, "symbols") && (smsIsDefined || usmsIsDefined)) {
          out.selectedSizeFn = function(d) {
            var base = d.mrc || ms / 2;
            if (d.selected) {
              return smsIsDefined ? sms / 2 : base;
            } else {
              return usmsIsDefined ? usms / 2 : base;
            }
          };
        }
        return out;
      };
      drawing.makeSelectedTextStyleFns = function(trace) {
        var out = {};
        var selectedAttrs = trace.selected || {};
        var unselectedAttrs = trace.unselected || {};
        var textFont = trace.textfont || {};
        var selectedTextFont = selectedAttrs.textfont || {};
        var unselectedTextFont = unselectedAttrs.textfont || {};
        var tc = textFont.color;
        var stc = selectedTextFont.color;
        var utc = unselectedTextFont.color;
        out.selectedTextColorFn = function(d) {
          var base = d.tc || tc;
          if (d.selected) {
            return stc || base;
          } else {
            if (utc) return utc;
            else return stc ? base : Color2.addOpacity(base, DESELECTDIM);
          }
        };
        return out;
      };
      drawing.selectedPointStyle = function(s, trace) {
        if (!s.size() || !trace.selectedpoints) return;
        var fns = drawing.makeSelectedPointStyleFns(trace);
        var marker = trace.marker || {};
        var seq = [];
        if (fns.selectedOpacityFn) {
          seq.push(function(pt, d) {
            pt.style("opacity", fns.selectedOpacityFn(d));
          });
        }
        if (fns.selectedColorFn) {
          seq.push(function(pt, d) {
            Color2.fill(pt, fns.selectedColorFn(d));
          });
        }
        if (fns.selectedSizeFn) {
          seq.push(function(pt, d) {
            var mx = d.mx || marker.symbol || 0;
            var mrc2 = fns.selectedSizeFn(d);
            pt.attr("d", makePointPath(drawing.symbolNumber(mx), mrc2, getMarkerAngle(d, trace), getMarkerStandoff(d, trace)));
            d.mrc2 = mrc2;
          });
        }
        if (seq.length) {
          s.each(function(d) {
            var pt = d3.select(this);
            for (var i = 0; i < seq.length; i++) {
              seq[i](pt, d);
            }
          });
        }
      };
      drawing.tryColorscale = function(marker, prefix) {
        var cont = prefix ? Lib.nestedProperty(marker, prefix).get() : marker;
        if (cont) {
          var colorArray = cont.color;
          if ((cont.colorscale || cont._colorAx) && Lib.isArrayOrTypedArray(colorArray)) {
            return Colorscale.makeColorScaleFuncFromTrace(cont);
          }
        }
        return Lib.identity;
      };
      var TEXTOFFSETSIGN = {
        start: 1,
        end: -1,
        middle: 0,
        bottom: 1,
        top: -1
      };
      function textPointPosition(s, textPosition, fontSize, markerRadius, dontTouchParent) {
        var group = d3.select(s.node().parentNode);
        var v = textPosition.indexOf("top") !== -1 ? "top" : textPosition.indexOf("bottom") !== -1 ? "bottom" : "middle";
        var h = textPosition.indexOf("left") !== -1 ? "end" : textPosition.indexOf("right") !== -1 ? "start" : "middle";
        var r = markerRadius ? markerRadius / 0.8 + 1 : 0;
        var numLines = (svgTextUtils.lineCount(s) - 1) * LINE_SPACING + 1;
        var dx = TEXTOFFSETSIGN[h] * r;
        var dy = fontSize * 0.75 + TEXTOFFSETSIGN[v] * r + (TEXTOFFSETSIGN[v] - 1) * numLines * fontSize / 2;
        s.attr("text-anchor", h);
        if (!dontTouchParent) {
          group.attr("transform", strTranslate(dx, dy));
        }
      }
      function extracTextFontSize(d, trace) {
        var fontSize = d.ts || trace.textfont.size;
        return isNumeric(fontSize) && fontSize > 0 ? fontSize : 0;
      }
      drawing.textPointStyle = function(s, trace, gd) {
        if (!s.size()) return;
        var selectedTextColorFn;
        if (trace.selectedpoints) {
          var fns = drawing.makeSelectedTextStyleFns(trace);
          selectedTextColorFn = fns.selectedTextColorFn;
        }
        var texttemplate = trace.texttemplate;
        var fullLayout = gd._fullLayout;
        s.each(function(d) {
          var p = d3.select(this);
          var text = texttemplate ? Lib.extractOption(d, trace, "txt", "texttemplate") : Lib.extractOption(d, trace, "tx", "text");
          if (!text && text !== 0) {
            p.remove();
            return;
          }
          if (texttemplate) {
            var fn = trace._module.formatLabels;
            var labels = fn ? fn(d, trace, fullLayout) : {};
            var pointValues = {};
            appendArrayPointValue(pointValues, trace, d.i);
            var meta = trace._meta || {};
            text = Lib.texttemplateString(text, labels, fullLayout._d3locale, pointValues, d, meta);
          }
          var pos = d.tp || trace.textposition;
          var fontSize = extracTextFontSize(d, trace);
          var fontColor = selectedTextColorFn ? selectedTextColorFn(d) : d.tc || trace.textfont.color;
          p.call(drawing.font, {
            family: d.tf || trace.textfont.family,
            weight: d.tw || trace.textfont.weight,
            style: d.ty || trace.textfont.style,
            variant: d.tv || trace.textfont.variant,
            textcase: d.tC || trace.textfont.textcase,
            lineposition: d.tE || trace.textfont.lineposition,
            shadow: d.tS || trace.textfont.shadow,
            size: fontSize,
            color: fontColor
          }).text(text).call(svgTextUtils.convertToTspans, gd).call(textPointPosition, pos, fontSize, d.mrc);
        });
      };
      drawing.selectedTextStyle = function(s, trace) {
        if (!s.size() || !trace.selectedpoints) return;
        var fns = drawing.makeSelectedTextStyleFns(trace);
        s.each(function(d) {
          var tx = d3.select(this);
          var tc = fns.selectedTextColorFn(d);
          var tp = d.tp || trace.textposition;
          var fontSize = extracTextFontSize(d, trace);
          Color2.fill(tx, tc);
          var dontTouchParent = Registry.traceIs(trace, "bar-like");
          textPointPosition(tx, tp, fontSize, d.mrc2 || d.mrc, dontTouchParent);
        });
      };
      var CatmullRomExp = 0.5;
      drawing.smoothopen = function(pts, smoothness) {
        if (pts.length < 3) {
          return "M" + pts.join("L");
        }
        var path = "M" + pts[0];
        var tangents = [];
        var i;
        for (i = 1; i < pts.length - 1; i++) {
          tangents.push(makeTangent(pts[i - 1], pts[i], pts[i + 1], smoothness));
        }
        path += "Q" + tangents[0][0] + " " + pts[1];
        for (i = 2; i < pts.length - 1; i++) {
          path += "C" + tangents[i - 2][1] + " " + tangents[i - 1][0] + " " + pts[i];
        }
        path += "Q" + tangents[pts.length - 3][1] + " " + pts[pts.length - 1];
        return path;
      };
      drawing.smoothclosed = function(pts, smoothness) {
        if (pts.length < 3) {
          return "M" + pts.join("L") + "Z";
        }
        var path = "M" + pts[0];
        var pLast = pts.length - 1;
        var tangents = [makeTangent(pts[pLast], pts[0], pts[1], smoothness)];
        var i;
        for (i = 1; i < pLast; i++) {
          tangents.push(makeTangent(pts[i - 1], pts[i], pts[i + 1], smoothness));
        }
        tangents.push(
          makeTangent(pts[pLast - 1], pts[pLast], pts[0], smoothness)
        );
        for (i = 1; i <= pLast; i++) {
          path += "C" + tangents[i - 1][1] + " " + tangents[i][0] + " " + pts[i];
        }
        path += "C" + tangents[pLast][1] + " " + tangents[0][0] + " " + pts[0] + "Z";
        return path;
      };
      var lastDrawnX;
      var lastDrawnY;
      function roundEnd(pt, isY, isLastPoint) {
        if (isLastPoint) pt = applyBackoff(pt);
        return isY ? roundY(pt[1]) : roundX(pt[0]);
      }
      function roundX(p) {
        var v = d3.round(p, 2);
        lastDrawnX = v;
        return v;
      }
      function roundY(p) {
        var v = d3.round(p, 2);
        lastDrawnY = v;
        return v;
      }
      function makeTangent(prevpt, thispt, nextpt, smoothness) {
        var d1x = prevpt[0] - thispt[0];
        var d1y = prevpt[1] - thispt[1];
        var d2x = nextpt[0] - thispt[0];
        var d2y = nextpt[1] - thispt[1];
        var d1a = Math.pow(d1x * d1x + d1y * d1y, CatmullRomExp / 2);
        var d2a = Math.pow(d2x * d2x + d2y * d2y, CatmullRomExp / 2);
        var numx = (d2a * d2a * d1x - d1a * d1a * d2x) * smoothness;
        var numy = (d2a * d2a * d1y - d1a * d1a * d2y) * smoothness;
        var denom1 = 3 * d2a * (d1a + d2a);
        var denom2 = 3 * d1a * (d1a + d2a);
        return [
          [
            roundX(thispt[0] + (denom1 && numx / denom1)),
            roundY(thispt[1] + (denom1 && numy / denom1))
          ],
          [
            roundX(thispt[0] - (denom2 && numx / denom2)),
            roundY(thispt[1] - (denom2 && numy / denom2))
          ]
        ];
      }
      var STEPPATH = {
        hv: function(p0, p1, isLastPoint) {
          return "H" + roundX(p1[0]) + "V" + roundEnd(p1, 1, isLastPoint);
        },
        vh: function(p0, p1, isLastPoint) {
          return "V" + roundY(p1[1]) + "H" + roundEnd(p1, 0, isLastPoint);
        },
        hvh: function(p0, p1, isLastPoint) {
          return "H" + roundX((p0[0] + p1[0]) / 2) + "V" + roundY(p1[1]) + "H" + roundEnd(p1, 0, isLastPoint);
        },
        vhv: function(p0, p1, isLastPoint) {
          return "V" + roundY((p0[1] + p1[1]) / 2) + "H" + roundX(p1[0]) + "V" + roundEnd(p1, 1, isLastPoint);
        }
      };
      var STEPLINEAR = function(p0, p1, isLastPoint) {
        return "L" + roundEnd(p1, 0, isLastPoint) + "," + roundEnd(p1, 1, isLastPoint);
      };
      drawing.steps = function(shape) {
        var onestep = STEPPATH[shape] || STEPLINEAR;
        return function(pts) {
          var path = "M" + roundX(pts[0][0]) + "," + roundY(pts[0][1]);
          var len = pts.length;
          for (var i = 1; i < len; i++) {
            path += onestep(pts[i - 1], pts[i], i === len - 1);
          }
          return path;
        };
      };
      function applyBackoff(pt, start) {
        var backoff = pt.backoff;
        var trace = pt.trace;
        var d = pt.d;
        var i = pt.i;
        if (backoff && trace && trace.marker && trace.marker.angle % 360 === 0 && trace.line && trace.line.shape !== "spline") {
          var arrayBackoff = Lib.isArrayOrTypedArray(backoff);
          var end = pt;
          var x1 = start ? start[0] : lastDrawnX || 0;
          var y1 = start ? start[1] : lastDrawnY || 0;
          var x2 = end[0];
          var y2 = end[1];
          var dx = x2 - x1;
          var dy = y2 - y1;
          var t = Math.atan2(dy, dx);
          var b = arrayBackoff ? backoff[i] : backoff;
          if (b === "auto") {
            var endI = end.i;
            if (trace.type === "scatter") endI--;
            var endMarker = end.marker;
            var endMarkerSymbol = endMarker.symbol;
            if (Lib.isArrayOrTypedArray(endMarkerSymbol)) endMarkerSymbol = endMarkerSymbol[endI];
            var endMarkerSize = endMarker.size;
            if (Lib.isArrayOrTypedArray(endMarkerSize)) endMarkerSize = endMarkerSize[endI];
            b = endMarker ? drawing.symbolBackOffs[drawing.symbolNumber(endMarkerSymbol)] * endMarkerSize : 0;
            b += drawing.getMarkerStandoff(d[endI], trace) || 0;
          }
          var x = x2 - b * Math.cos(t);
          var y = y2 - b * Math.sin(t);
          if ((x <= x2 && x >= x1 || x >= x2 && x <= x1) && (y <= y2 && y >= y1 || y >= y2 && y <= y1)) {
            pt = [x, y];
          }
        }
        return pt;
      }
      drawing.applyBackoff = applyBackoff;
      drawing.makeTester = function() {
        var tester = Lib.ensureSingleById(d3.select("body"), "svg", "js-plotly-tester", function(s) {
          s.attr(xmlnsNamespaces.svgAttrs).style({
            position: "absolute",
            left: "-10000px",
            top: "-10000px",
            width: "9000px",
            height: "9000px",
            "z-index": "1"
          });
        });
        var testref = Lib.ensureSingle(tester, "path", "js-reference-point", function(s) {
          s.attr("d", "M0,0H1V1H0Z").style({
            "stroke-width": 0,
            fill: "black"
          });
        });
        drawing.tester = tester;
        drawing.testref = testref;
      };
      drawing.savedBBoxes = {};
      var savedBBoxesCount = 0;
      var maxSavedBBoxes = 1e4;
      drawing.bBox = function(node, inTester, hash) {
        if (!hash) hash = nodeHash(node);
        var out;
        if (hash) {
          out = drawing.savedBBoxes[hash];
          if (out) return Lib.extendFlat({}, out);
        } else if (node.childNodes.length === 1) {
          var innerNode = node.childNodes[0];
          hash = nodeHash(innerNode);
          if (hash) {
            var x = +innerNode.getAttribute("x") || 0;
            var y = +innerNode.getAttribute("y") || 0;
            var transform = innerNode.getAttribute("transform");
            if (!transform) {
              var innerBB = drawing.bBox(innerNode, false, hash);
              if (x) {
                innerBB.left += x;
                innerBB.right += x;
              }
              if (y) {
                innerBB.top += y;
                innerBB.bottom += y;
              }
              return innerBB;
            }
            hash += "~" + x + "~" + y + "~" + transform;
            out = drawing.savedBBoxes[hash];
            if (out) return Lib.extendFlat({}, out);
          }
        }
        var testNode, tester;
        if (inTester) {
          testNode = node;
        } else {
          tester = drawing.tester.node();
          testNode = node.cloneNode(true);
          tester.appendChild(testNode);
        }
        d3.select(testNode).attr("transform", null).call(svgTextUtils.positionText, 0, 0);
        var testRect = testNode.getBoundingClientRect();
        var refRect = drawing.testref.node().getBoundingClientRect();
        if (!inTester) tester.removeChild(testNode);
        var bb = {
          height: testRect.height,
          width: testRect.width,
          left: testRect.left - refRect.left,
          top: testRect.top - refRect.top,
          right: testRect.right - refRect.left,
          bottom: testRect.bottom - refRect.top
        };
        if (savedBBoxesCount >= maxSavedBBoxes) {
          drawing.savedBBoxes = {};
          savedBBoxesCount = 0;
        }
        if (hash) drawing.savedBBoxes[hash] = bb;
        savedBBoxesCount++;
        return Lib.extendFlat({}, bb);
      };
      function nodeHash(node) {
        var inputText = node.getAttribute("data-unformatted");
        if (inputText === null) return;
        return inputText + node.getAttribute("data-math") + node.getAttribute("text-anchor") + node.getAttribute("style");
      }
      drawing.setClipUrl = function(s, localId, gd) {
        s.attr("clip-path", getFullUrl(localId, gd));
      };
      function getFullUrl(localId, gd) {
        if (!localId) return null;
        var context = gd._context;
        var baseUrl = context._exportedPlot ? "" : context._baseUrl || "";
        return baseUrl ? "url('" + baseUrl + "#" + localId + "')" : "url(#" + localId + ")";
      }
      drawing.getTranslate = function(element) {
        var re = /.*\btranslate\((-?\d*\.?\d*)[^-\d]*(-?\d*\.?\d*)[^\d].*/;
        var getter = element.attr ? "attr" : "getAttribute";
        var transform = element[getter]("transform") || "";
        var translate = transform.replace(re, function(match, p1, p2) {
          return [p1, p2].join(" ");
        }).split(" ");
        return {
          x: +translate[0] || 0,
          y: +translate[1] || 0
        };
      };
      drawing.setTranslate = function(element, x, y) {
        var re = /(\btranslate\(.*?\);?)/;
        var getter = element.attr ? "attr" : "getAttribute";
        var setter = element.attr ? "attr" : "setAttribute";
        var transform = element[getter]("transform") || "";
        x = x || 0;
        y = y || 0;
        transform = transform.replace(re, "").trim();
        transform += strTranslate(x, y);
        transform = transform.trim();
        element[setter]("transform", transform);
        return transform;
      };
      drawing.getScale = function(element) {
        var re = /.*\bscale\((\d*\.?\d*)[^\d]*(\d*\.?\d*)[^\d].*/;
        var getter = element.attr ? "attr" : "getAttribute";
        var transform = element[getter]("transform") || "";
        var translate = transform.replace(re, function(match, p1, p2) {
          return [p1, p2].join(" ");
        }).split(" ");
        return {
          x: +translate[0] || 1,
          y: +translate[1] || 1
        };
      };
      drawing.setScale = function(element, x, y) {
        var re = /(\bscale\(.*?\);?)/;
        var getter = element.attr ? "attr" : "getAttribute";
        var setter = element.attr ? "attr" : "setAttribute";
        var transform = element[getter]("transform") || "";
        x = x || 1;
        y = y || 1;
        transform = transform.replace(re, "").trim();
        transform += "scale(" + x + "," + y + ")";
        transform = transform.trim();
        element[setter]("transform", transform);
        return transform;
      };
      var SCALE_RE = /\s*sc.*/;
      drawing.setPointGroupScale = function(selection, xScale, yScale) {
        xScale = xScale || 1;
        yScale = yScale || 1;
        if (!selection) return;
        var scale = xScale === 1 && yScale === 1 ? "" : "scale(" + xScale + "," + yScale + ")";
        selection.each(function() {
          var t = (this.getAttribute("transform") || "").replace(SCALE_RE, "");
          t += scale;
          t = t.trim();
          this.setAttribute("transform", t);
        });
      };
      var TEXT_POINT_LAST_TRANSLATION_RE = /translate\([^)]*\)\s*$/;
      drawing.setTextPointsScale = function(selection, xScale, yScale) {
        if (!selection) return;
        selection.each(function() {
          var transforms;
          var el = d3.select(this);
          var text = el.select("text");
          if (!text.node()) return;
          var x = parseFloat(text.attr("x") || 0);
          var y = parseFloat(text.attr("y") || 0);
          var existingTransform = (el.attr("transform") || "").match(TEXT_POINT_LAST_TRANSLATION_RE);
          if (xScale === 1 && yScale === 1) {
            transforms = [];
          } else {
            transforms = [
              strTranslate(x, y),
              "scale(" + xScale + "," + yScale + ")",
              strTranslate(-x, -y)
            ];
          }
          if (existingTransform) {
            transforms.push(existingTransform);
          }
          el.attr("transform", transforms.join(""));
        });
      };
      function getMarkerStandoff(d, trace) {
        var standoff;
        if (d) standoff = d.mf;
        if (standoff === void 0) {
          standoff = trace.marker ? trace.marker.standoff || 0 : 0;
        }
        if (!trace._geo && !trace._xA) {
          return -standoff;
        }
        return standoff;
      }
      drawing.getMarkerStandoff = getMarkerStandoff;
      var atan2 = Math.atan2;
      var cos = Math.cos;
      var sin = Math.sin;
      function rotate(t, xy) {
        var x = xy[0];
        var y = xy[1];
        return [
          x * cos(t) - y * sin(t),
          x * sin(t) + y * cos(t)
        ];
      }
      var previousLon;
      var previousLat;
      var previousX;
      var previousY;
      var previousI;
      var previousTraceUid;
      function getMarkerAngle(d, trace) {
        var angle = d.ma;
        if (angle === void 0) {
          angle = trace.marker.angle;
          if (!angle || Lib.isArrayOrTypedArray(angle)) {
            angle = 0;
          }
        }
        var x, y;
        var ref = trace.marker.angleref;
        if (ref === "previous" || ref === "north") {
          if (trace._geo) {
            var p = trace._geo.project(d.lonlat);
            x = p[0];
            y = p[1];
          } else {
            var xa = trace._xA;
            var ya = trace._yA;
            if (xa && ya) {
              x = xa.c2p(d.x);
              y = ya.c2p(d.y);
            } else {
              return 90;
            }
          }
          if (trace._geo) {
            var lon = d.lonlat[0];
            var lat = d.lonlat[1];
            var north = trace._geo.project([
              lon,
              lat + 1e-5
              // epsilon
            ]);
            var east = trace._geo.project([
              lon + 1e-5,
              // epsilon
              lat
            ]);
            var u = atan2(
              east[1] - y,
              east[0] - x
            );
            var v = atan2(
              north[1] - y,
              north[0] - x
            );
            var t;
            if (ref === "north") {
              t = angle / 180 * Math.PI;
            } else if (ref === "previous") {
              var lon1 = lon / 180 * Math.PI;
              var lat1 = lat / 180 * Math.PI;
              var lon2 = previousLon / 180 * Math.PI;
              var lat2 = previousLat / 180 * Math.PI;
              var dLon = lon2 - lon1;
              var deltaY = cos(lat2) * sin(dLon);
              var deltaX = sin(lat2) * cos(lat1) - cos(lat2) * sin(lat1) * cos(dLon);
              t = -atan2(
                deltaY,
                deltaX
              ) - Math.PI;
              previousLon = lon;
              previousLat = lat;
            }
            var A2 = rotate(u, [cos(t), 0]);
            var B2 = rotate(v, [sin(t), 0]);
            angle = atan2(
              A2[1] + B2[1],
              A2[0] + B2[0]
            ) / Math.PI * 180;
            if (ref === "previous" && !(previousTraceUid === trace.uid && d.i === previousI + 1)) {
              angle = null;
            }
          }
          if (ref === "previous" && !trace._geo) {
            if (previousTraceUid === trace.uid && d.i === previousI + 1 && isNumeric(x) && isNumeric(y)) {
              var dX = x - previousX;
              var dY = y - previousY;
              var shape = trace.line ? trace.line.shape || "" : "";
              var lastShapeChar = shape.slice(shape.length - 1);
              if (lastShapeChar === "h") dY = 0;
              if (lastShapeChar === "v") dX = 0;
              angle += atan2(dY, dX) / Math.PI * 180 + 90;
            } else {
              angle = null;
            }
          }
        }
        previousX = x;
        previousY = y;
        previousI = d.i;
        previousTraceUid = trace.uid;
        return angle;
      }
      drawing.getMarkerAngle = getMarkerAngle;
    }
  });

  // src/components/titles/index.js
  var require_titles = __commonJS({
    "src/components/titles/index.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var isNumeric = require_fast_isnumeric();
      var Plots = require_plots();
      var Registry = require_registry();
      var Lib = require_lib();
      var strTranslate = Lib.strTranslate;
      var Drawing = require_drawing();
      var Color2 = require_color();
      var svgTextUtils = require_svg_text_utils();
      var interactConstants = require_interactions();
      var OPPOSITE_SIDE = require_alignment().OPPOSITE_SIDE;
      var numStripRE = / [XY][0-9]* /;
      var SUBTITLE_PADDING_MATHJAX_EM = 1.6;
      var SUBTITLE_PADDING_EM = 1.6;
      function draw(gd, titleClass, options) {
        var fullLayout = gd._fullLayout;
        var cont = options.propContainer;
        var prop = options.propName;
        var placeholder = options.placeholder;
        var traceIndex = options.traceIndex;
        var avoid = options.avoid || {};
        var attributes = options.attributes;
        var transform = options.transform;
        var group = options.containerGroup;
        var opacity = 1;
        var title = cont.title;
        var txt = (title && title.text ? title.text : "").trim();
        var titleIsPlaceholder = false;
        var font = title && title.font ? title.font : {};
        var fontFamily = font.family;
        var fontSize = font.size;
        var fontColor = font.color;
        var fontWeight = font.weight;
        var fontStyle = font.style;
        var fontVariant = font.variant;
        var fontTextcase = font.textcase;
        var fontLineposition = font.lineposition;
        var fontShadow = font.shadow;
        var subtitleProp = options.subtitlePropName;
        var subtitleEnabled = !!subtitleProp;
        var subtitlePlaceholder = options.subtitlePlaceholder;
        var subtitle = (cont.title || {}).subtitle || { text: "", font: {} };
        var subtitleTxt = subtitle.text.trim();
        var subtitleIsPlaceholder = false;
        var subtitleOpacity = 1;
        var subtitleFont = subtitle.font;
        var subFontFamily = subtitleFont.family;
        var subFontSize = subtitleFont.size;
        var subFontColor = subtitleFont.color;
        var subFontWeight = subtitleFont.weight;
        var subFontStyle = subtitleFont.style;
        var subFontVariant = subtitleFont.variant;
        var subFontTextcase = subtitleFont.textcase;
        var subFontLineposition = subtitleFont.lineposition;
        var subFontShadow = subtitleFont.shadow;
        var editAttr;
        if (prop === "title.text") editAttr = "titleText";
        else if (prop.indexOf("axis") !== -1) editAttr = "axisTitleText";
        else if (prop.indexOf("colorbar" !== -1)) editAttr = "colorbarTitleText";
        var editable = gd._context.edits[editAttr];
        function matchesPlaceholder(text, placeholder2) {
          if (text === void 0 || placeholder2 === void 0) return false;
          return text.replace(numStripRE, " % ") === placeholder2.replace(numStripRE, " % ");
        }
        if (txt === "") opacity = 0;
        else if (matchesPlaceholder(txt, placeholder)) {
          if (!editable) txt = "";
          opacity = 0.2;
          titleIsPlaceholder = true;
        }
        if (subtitleEnabled) {
          if (subtitleTxt === "") subtitleOpacity = 0;
          else if (matchesPlaceholder(subtitleTxt, subtitlePlaceholder)) {
            if (!editable) subtitleTxt = "";
            subtitleOpacity = 0.2;
            subtitleIsPlaceholder = true;
          }
        }
        if (options._meta) {
          txt = Lib.templateString(txt, options._meta);
        } else if (fullLayout._meta) {
          txt = Lib.templateString(txt, fullLayout._meta);
        }
        var elShouldExist = txt || subtitleTxt || editable;
        var hColorbarMoveTitle;
        if (!group) {
          group = Lib.ensureSingle(fullLayout._infolayer, "g", "g-" + titleClass);
          hColorbarMoveTitle = fullLayout._hColorbarMoveTitle;
        }
        var el = group.selectAll("text." + titleClass).data(elShouldExist ? [0] : []);
        el.enter().append("text");
        el.text(txt).attr("class", titleClass);
        el.exit().remove();
        var subtitleEl = null;
        var subtitleClass = titleClass + "-subtitle";
        var subtitleElShouldExist = subtitleTxt || editable;
        if (subtitleEnabled && subtitleElShouldExist) {
          subtitleEl = group.selectAll("text." + subtitleClass).data(subtitleElShouldExist ? [0] : []);
          subtitleEl.enter().append("text");
          subtitleEl.text(subtitleTxt).attr("class", subtitleClass);
          subtitleEl.exit().remove();
        }
        if (!elShouldExist) return group;
        function titleLayout(titleEl, subtitleEl2) {
          Lib.syncOrAsync([drawTitle, scootTitle], { title: titleEl, subtitle: subtitleEl2 });
        }
        function drawTitle(titleAndSubtitleEls) {
          var titleEl = titleAndSubtitleEls.title;
          var subtitleEl2 = titleAndSubtitleEls.subtitle;
          var transformVal;
          if (!transform && hColorbarMoveTitle) {
            transform = {};
          }
          if (transform) {
            transformVal = "";
            if (transform.rotate) {
              transformVal += "rotate(" + [transform.rotate, attributes.x, attributes.y] + ")";
            }
            if (transform.offset || hColorbarMoveTitle) {
              transformVal += strTranslate(0, (transform.offset || 0) - (hColorbarMoveTitle || 0));
            }
          } else {
            transformVal = null;
          }
          titleEl.attr("transform", transformVal);
          function adjustSubtitlePosition(titleElMathGroup2) {
            if (!titleElMathGroup2) return;
            var subtitleElement = d3.select(titleElMathGroup2.node().parentNode).select("." + subtitleClass);
            if (!subtitleElement.empty()) {
              var titleElMathBbox2 = titleElMathGroup2.node().getBBox();
              if (titleElMathBbox2.height) {
                var subtitleY3 = titleElMathBbox2.y + titleElMathBbox2.height + SUBTITLE_PADDING_MATHJAX_EM * subFontSize;
                subtitleElement.attr("y", subtitleY3);
              }
            }
          }
          titleEl.style("opacity", opacity * Color2.opacity(fontColor)).call(Drawing.font, {
            color: Color2.rgb(fontColor),
            size: d3.round(fontSize, 2),
            family: fontFamily,
            weight: fontWeight,
            style: fontStyle,
            variant: fontVariant,
            textcase: fontTextcase,
            shadow: fontShadow,
            lineposition: fontLineposition
          }).attr(attributes).call(svgTextUtils.convertToTspans, gd, adjustSubtitlePosition);
          if (subtitleEl2) {
            var titleElMathGroup = group.select("." + titleClass + "-math-group");
            var titleElBbox2 = titleEl.node().getBBox();
            var titleElMathBbox = titleElMathGroup.node() ? titleElMathGroup.node().getBBox() : void 0;
            var subtitleY2 = titleElMathBbox ? titleElMathBbox.y + titleElMathBbox.height + SUBTITLE_PADDING_MATHJAX_EM * subFontSize : titleElBbox2.y + titleElBbox2.height + SUBTITLE_PADDING_EM * subFontSize;
            var subtitleAttributes = Lib.extendFlat({}, attributes, {
              y: subtitleY2
            });
            subtitleEl2.attr("transform", transformVal);
            subtitleEl2.style("opacity", subtitleOpacity * Color2.opacity(subFontColor)).call(Drawing.font, {
              color: Color2.rgb(subFontColor),
              size: d3.round(subFontSize, 2),
              family: subFontFamily,
              weight: subFontWeight,
              style: subFontStyle,
              variant: subFontVariant,
              textcase: subFontTextcase,
              shadow: subFontShadow,
              lineposition: subFontLineposition
            }).attr(subtitleAttributes).call(svgTextUtils.convertToTspans, gd);
          }
          return Plots.previousPromises(gd);
        }
        function scootTitle(titleAndSubtitleEls) {
          var titleElIn = titleAndSubtitleEls.title;
          var titleGroup = d3.select(titleElIn.node().parentNode);
          if (avoid && avoid.selection && avoid.side && txt) {
            titleGroup.attr("transform", null);
            var backside = OPPOSITE_SIDE[avoid.side];
            var shiftSign = avoid.side === "left" || avoid.side === "top" ? -1 : 1;
            var pad = isNumeric(avoid.pad) ? avoid.pad : 2;
            var titlebb = Drawing.bBox(titleGroup.node());
            var reservedMargins = { t: 0, b: 0, l: 0, r: 0 };
            var margins = gd._fullLayout._reservedMargin;
            for (var key in margins) {
              for (var side in margins[key]) {
                var val = margins[key][side];
                reservedMargins[side] = Math.max(reservedMargins[side], val);
              }
            }
            var paperbb = {
              left: reservedMargins.l,
              top: reservedMargins.t,
              right: fullLayout.width - reservedMargins.r,
              bottom: fullLayout.height - reservedMargins.b
            };
            var maxshift = avoid.maxShift || shiftSign * (paperbb[avoid.side] - titlebb[avoid.side]);
            var shift = 0;
            if (maxshift < 0) {
              shift = maxshift;
            } else {
              var offsetLeft = avoid.offsetLeft || 0;
              var offsetTop = avoid.offsetTop || 0;
              titlebb.left -= offsetLeft;
              titlebb.right -= offsetLeft;
              titlebb.top -= offsetTop;
              titlebb.bottom -= offsetTop;
              avoid.selection.each(function() {
                var avoidbb = Drawing.bBox(this);
                if (Lib.bBoxIntersect(titlebb, avoidbb, pad)) {
                  shift = Math.max(shift, shiftSign * (avoidbb[avoid.side] - titlebb[backside]) + pad);
                }
              });
              shift = Math.min(maxshift, shift);
              cont._titleScoot = Math.abs(shift);
            }
            if (shift > 0 || maxshift < 0) {
              var shiftTemplate = {
                left: [-shift, 0],
                right: [shift, 0],
                top: [0, -shift],
                bottom: [0, shift]
              }[avoid.side];
              titleGroup.attr("transform", strTranslate(shiftTemplate[0], shiftTemplate[1]));
            }
          }
        }
        el.call(titleLayout, subtitleEl);
        function setPlaceholder(element, placeholderText) {
          element.text(placeholderText).on("mouseover.opacity", function() {
            d3.select(this).transition().duration(interactConstants.SHOW_PLACEHOLDER).style("opacity", 1);
          }).on("mouseout.opacity", function() {
            d3.select(this).transition().duration(interactConstants.HIDE_PLACEHOLDER).style("opacity", 0);
          });
        }
        if (editable) {
          if (!txt) {
            setPlaceholder(el, placeholder);
            titleIsPlaceholder = true;
          } else el.on(".opacity", null);
          el.call(svgTextUtils.makeEditable, { gd }).on("edit", function(text) {
            if (traceIndex !== void 0) {
              Registry.call("_guiRestyle", gd, prop, text, traceIndex);
            } else {
              Registry.call("_guiRelayout", gd, prop, text);
            }
          }).on("cancel", function() {
            this.text(this.attr("data-unformatted")).call(titleLayout);
          }).on("input", function(d) {
            this.text(d || " ").call(svgTextUtils.positionText, attributes.x, attributes.y);
          });
          if (subtitleEnabled) {
            if (subtitleEnabled && !txt) {
              var titleElBbox = el.node().getBBox();
              var subtitleY = titleElBbox.y + titleElBbox.height + SUBTITLE_PADDING_EM * subFontSize;
              subtitleEl.attr("y", subtitleY);
            }
            if (!subtitleTxt) {
              setPlaceholder(subtitleEl, subtitlePlaceholder);
              subtitleIsPlaceholder = true;
            } else subtitleEl.on(".opacity", null);
            subtitleEl.call(svgTextUtils.makeEditable, { gd }).on("edit", function(text) {
              Registry.call("_guiRelayout", gd, "title.subtitle.text", text);
            }).on("cancel", function() {
              this.text(this.attr("data-unformatted")).call(titleLayout);
            }).on("input", function(d) {
              this.text(d || " ").call(svgTextUtils.positionText, subtitleEl.attr("x"), subtitleEl.attr("y"));
            });
          }
        }
        el.classed("js-placeholder", titleIsPlaceholder);
        if (subtitleEl) subtitleEl.classed("js-placeholder", subtitleIsPlaceholder);
        return group;
      }
      module.exports = {
        draw,
        SUBTITLE_PADDING_EM,
        SUBTITLE_PADDING_MATHJAX_EM
      };
    }
  });

  // src/plots/cartesian/set_convert.js
  var require_set_convert = __commonJS({
    "src/plots/cartesian/set_convert.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var utcFormat = require_d3_time_format().utcFormat;
      var Lib = require_lib();
      var numberFormat = Lib.numberFormat;
      var isNumeric = require_fast_isnumeric();
      var cleanNumber = Lib.cleanNumber;
      var ms2DateTime = Lib.ms2DateTime;
      var dateTime2ms = Lib.dateTime2ms;
      var ensureNumber = Lib.ensureNumber;
      var isArrayOrTypedArray = Lib.isArrayOrTypedArray;
      var numConstants = require_numerical();
      var FP_SAFE = numConstants.FP_SAFE;
      var BADNUM = numConstants.BADNUM;
      var LOG_CLIP = numConstants.LOG_CLIP;
      var ONEWEEK = numConstants.ONEWEEK;
      var ONEDAY = numConstants.ONEDAY;
      var ONEHOUR = numConstants.ONEHOUR;
      var ONEMIN = numConstants.ONEMIN;
      var ONESEC = numConstants.ONESEC;
      var axisIds = require_axis_ids();
      var constants = require_constants2();
      var HOUR_PATTERN = constants.HOUR_PATTERN;
      var WEEKDAY_PATTERN = constants.WEEKDAY_PATTERN;
      function fromLog(v) {
        return Math.pow(10, v);
      }
      function isValidCategory(v) {
        return v !== null && v !== void 0;
      }
      module.exports = function setConvert(ax, fullLayout) {
        fullLayout = fullLayout || {};
        var axId = ax._id || "x";
        var axLetter = axId.charAt(0);
        function toLog(v, clip) {
          if (v > 0) return Math.log(v) / Math.LN10;
          else if (v <= 0 && clip && ax.range && ax.range.length === 2) {
            var r0 = ax.range[0];
            var r1 = ax.range[1];
            return 0.5 * (r0 + r1 - 2 * LOG_CLIP * Math.abs(r0 - r1));
          } else return BADNUM;
        }
        function dt2ms(v, _, calendar, opts) {
          if ((opts || {}).msUTC && isNumeric(v)) {
            return +v;
          }
          var ms = dateTime2ms(v, calendar || ax.calendar);
          if (ms === BADNUM) {
            if (isNumeric(v)) {
              v = +v;
              var msecTenths = Math.floor(Lib.mod(v + 0.05, 1) * 10);
              var msRounded = Math.round(v - msecTenths / 10);
              ms = dateTime2ms(new Date(msRounded)) + msecTenths / 10;
            } else return BADNUM;
          }
          return ms;
        }
        function ms2dt(v, r, calendar) {
          return ms2DateTime(v, r, calendar || ax.calendar);
        }
        function getCategoryName(v) {
          return ax._categories[Math.round(v)];
        }
        function setCategoryIndex(v) {
          if (isValidCategory(v)) {
            if (ax._categoriesMap === void 0) {
              ax._categoriesMap = {};
            }
            if (ax._categoriesMap[v] !== void 0) {
              return ax._categoriesMap[v];
            } else {
              ax._categories.push(typeof v === "number" ? String(v) : v);
              var curLength = ax._categories.length - 1;
              ax._categoriesMap[v] = curLength;
              return curLength;
            }
          }
          return BADNUM;
        }
        function setMultiCategoryIndex(arrayIn, len) {
          var arrayOut = new Array(len);
          for (var i = 0; i < len; i++) {
            var v0 = (arrayIn[0] || [])[i];
            var v1 = (arrayIn[1] || [])[i];
            arrayOut[i] = getCategoryIndex([v0, v1]);
          }
          return arrayOut;
        }
        function getCategoryIndex(v) {
          if (ax._categoriesMap) {
            return ax._categoriesMap[v];
          }
        }
        function getCategoryPosition(v) {
          var index = getCategoryIndex(v);
          if (index !== void 0) return index;
          if (isNumeric(v)) return +v;
        }
        function getRangePosition(v) {
          return isNumeric(v) ? +v : getCategoryIndex(v);
        }
        function _l2p(v, m, b) {
          return d3.round(b + m * v, 2);
        }
        function _p2l(px, m, b) {
          return (px - b) / m;
        }
        var l2p = function l2p2(v) {
          if (!isNumeric(v)) return BADNUM;
          return _l2p(v, ax._m, ax._b);
        };
        var p2l = function(px) {
          return _p2l(px, ax._m, ax._b);
        };
        if (ax.rangebreaks) {
          var isY = axLetter === "y";
          l2p = function(v) {
            if (!isNumeric(v)) return BADNUM;
            var len = ax._rangebreaks.length;
            if (!len) return _l2p(v, ax._m, ax._b);
            var flip = isY;
            if (ax.range[0] > ax.range[1]) flip = !flip;
            var signAx = flip ? -1 : 1;
            var pos = signAx * v;
            var q = 0;
            for (var i = 0; i < len; i++) {
              var min = signAx * ax._rangebreaks[i].min;
              var max = signAx * ax._rangebreaks[i].max;
              if (pos < min) break;
              if (pos > max) q = i + 1;
              else {
                q = pos < (min + max) / 2 ? i : i + 1;
                break;
              }
            }
            var b2 = ax._B[q] || 0;
            if (!isFinite(b2)) return 0;
            return _l2p(v, ax._m2, b2);
          };
          p2l = function(px) {
            var len = ax._rangebreaks.length;
            if (!len) return _p2l(px, ax._m, ax._b);
            var q = 0;
            for (var i = 0; i < len; i++) {
              if (px < ax._rangebreaks[i].pmin) break;
              if (px > ax._rangebreaks[i].pmax) q = i + 1;
            }
            return _p2l(px, ax._m2, ax._B[q]);
          };
        }
        ax.c2l = ax.type === "log" ? toLog : ensureNumber;
        ax.l2c = ax.type === "log" ? fromLog : ensureNumber;
        ax.l2p = l2p;
        ax.p2l = p2l;
        ax.c2p = ax.type === "log" ? function(v, clip) {
          return l2p(toLog(v, clip));
        } : l2p;
        ax.p2c = ax.type === "log" ? function(px) {
          return fromLog(p2l(px));
        } : p2l;
        if (["linear", "-"].indexOf(ax.type) !== -1) {
          ax.d2r = ax.r2d = ax.d2c = ax.r2c = ax.d2l = ax.r2l = cleanNumber;
          ax.c2d = ax.c2r = ax.l2d = ax.l2r = ensureNumber;
          ax.d2p = ax.r2p = function(v) {
            return ax.l2p(cleanNumber(v));
          };
          ax.p2d = ax.p2r = p2l;
          ax.cleanPos = ensureNumber;
        } else if (ax.type === "log") {
          ax.d2r = ax.d2l = function(v, clip) {
            return toLog(cleanNumber(v), clip);
          };
          ax.r2d = ax.r2c = function(v) {
            return fromLog(cleanNumber(v));
          };
          ax.d2c = ax.r2l = cleanNumber;
          ax.c2d = ax.l2r = ensureNumber;
          ax.c2r = toLog;
          ax.l2d = fromLog;
          ax.d2p = function(v, clip) {
            return ax.l2p(ax.d2r(v, clip));
          };
          ax.p2d = function(px) {
            return fromLog(p2l(px));
          };
          ax.r2p = function(v) {
            return ax.l2p(cleanNumber(v));
          };
          ax.p2r = p2l;
          ax.cleanPos = ensureNumber;
        } else if (ax.type === "date") {
          ax.d2r = ax.r2d = Lib.identity;
          ax.d2c = ax.r2c = ax.d2l = ax.r2l = dt2ms;
          ax.c2d = ax.c2r = ax.l2d = ax.l2r = ms2dt;
          ax.d2p = ax.r2p = function(v, _, calendar) {
            return ax.l2p(dt2ms(v, 0, calendar));
          };
          ax.p2d = ax.p2r = function(px, r, calendar) {
            return ms2dt(p2l(px), r, calendar);
          };
          ax.cleanPos = function(v) {
            return Lib.cleanDate(v, BADNUM, ax.calendar);
          };
        } else if (ax.type === "category") {
          ax.d2c = ax.d2l = setCategoryIndex;
          ax.r2d = ax.c2d = ax.l2d = getCategoryName;
          ax.d2r = ax.d2l_noadd = getCategoryPosition;
          ax.r2c = function(v) {
            var index = getRangePosition(v);
            return index !== void 0 ? index : ax.fraction2r(0.5);
          };
          ax.l2r = ax.c2r = ensureNumber;
          ax.r2l = getRangePosition;
          ax.d2p = function(v) {
            return ax.l2p(ax.r2c(v));
          };
          ax.p2d = function(px) {
            return getCategoryName(p2l(px));
          };
          ax.r2p = ax.d2p;
          ax.p2r = p2l;
          ax.cleanPos = function(v) {
            if (typeof v === "string" && v !== "") return v;
            return ensureNumber(v);
          };
        } else if (ax.type === "multicategory") {
          ax.r2d = ax.c2d = ax.l2d = getCategoryName;
          ax.d2r = ax.d2l_noadd = getCategoryPosition;
          ax.r2c = function(v) {
            var index = getCategoryPosition(v);
            return index !== void 0 ? index : ax.fraction2r(0.5);
          };
          ax.r2c_just_indices = getCategoryIndex;
          ax.l2r = ax.c2r = ensureNumber;
          ax.r2l = getCategoryPosition;
          ax.d2p = function(v) {
            return ax.l2p(ax.r2c(v));
          };
          ax.p2d = function(px) {
            return getCategoryName(p2l(px));
          };
          ax.r2p = ax.d2p;
          ax.p2r = p2l;
          ax.cleanPos = function(v) {
            if (Array.isArray(v) || typeof v === "string" && v !== "") return v;
            return ensureNumber(v);
          };
          ax.setupMultiCategory = function(fullData) {
            var traceIndices = ax._traceIndices;
            var i, j;
            var group = ax._matchGroup;
            if (group && ax._categories.length === 0) {
              for (var axId2 in group) {
                if (axId2 !== axId) {
                  var ax2 = fullLayout[axisIds.id2name(axId2)];
                  traceIndices = traceIndices.concat(ax2._traceIndices);
                }
              }
            }
            var seen = [[0, {}], [0, {}]];
            var list = [];
            for (i = 0; i < traceIndices.length; i++) {
              var trace = fullData[traceIndices[i]];
              if (axLetter in trace) {
                var arrayIn = trace[axLetter];
                var len = trace._length || Lib.minRowLength(arrayIn);
                if (isArrayOrTypedArray(arrayIn[0]) && isArrayOrTypedArray(arrayIn[1])) {
                  for (j = 0; j < len; j++) {
                    var v0 = arrayIn[0][j];
                    var v1 = arrayIn[1][j];
                    if (isValidCategory(v0) && isValidCategory(v1)) {
                      list.push([v0, v1]);
                      if (!(v0 in seen[0][1])) {
                        seen[0][1][v0] = seen[0][0]++;
                      }
                      if (!(v1 in seen[1][1])) {
                        seen[1][1][v1] = seen[1][0]++;
                      }
                    }
                  }
                }
              }
            }
            list.sort(function(a, b) {
              var ind0 = seen[0][1];
              var d = ind0[a[0]] - ind0[b[0]];
              if (d) return d;
              var ind1 = seen[1][1];
              return ind1[a[1]] - ind1[b[1]];
            });
            for (i = 0; i < list.length; i++) {
              setCategoryIndex(list[i]);
            }
          };
        }
        ax.fraction2r = function(v) {
          var rl0 = ax.r2l(ax.range[0]);
          var rl1 = ax.r2l(ax.range[1]);
          return ax.l2r(rl0 + v * (rl1 - rl0));
        };
        ax.r2fraction = function(v) {
          var rl0 = ax.r2l(ax.range[0]);
          var rl1 = ax.r2l(ax.range[1]);
          return (ax.r2l(v) - rl0) / (rl1 - rl0);
        };
        ax.limitRange = function(rangeAttr) {
          var minallowed = ax.minallowed;
          var maxallowed = ax.maxallowed;
          if (minallowed === void 0 && maxallowed === void 0) return;
          if (!rangeAttr) rangeAttr = "range";
          var range = Lib.nestedProperty(ax, rangeAttr).get();
          var rng = Lib.simpleMap(range, ax.r2l);
          var axrev = rng[1] < rng[0];
          if (axrev) rng.reverse();
          var bounds = Lib.simpleMap([minallowed, maxallowed], ax.r2l);
          if (minallowed !== void 0 && rng[0] < bounds[0]) range[axrev ? 1 : 0] = minallowed;
          if (maxallowed !== void 0 && rng[1] > bounds[1]) range[axrev ? 0 : 1] = maxallowed;
          if (range[0] === range[1]) {
            var minL = ax.l2r(minallowed);
            var maxL = ax.l2r(maxallowed);
            if (minallowed !== void 0) {
              var _max = minL + 1;
              if (maxallowed !== void 0) _max = Math.min(_max, maxL);
              range[axrev ? 1 : 0] = _max;
            }
            if (maxallowed !== void 0) {
              var _min = maxL + 1;
              if (minallowed !== void 0) _min = Math.max(_min, minL);
              range[axrev ? 0 : 1] = _min;
            }
          }
        };
        ax.cleanRange = function(rangeAttr, opts) {
          ax._cleanRange(rangeAttr, opts);
          ax.limitRange(rangeAttr);
        };
        ax._cleanRange = function(rangeAttr, opts) {
          if (!opts) opts = {};
          if (!rangeAttr) rangeAttr = "range";
          var range = Lib.nestedProperty(ax, rangeAttr).get();
          var i, dflt;
          if (ax.type === "date") dflt = Lib.dfltRange(ax.calendar);
          else if (axLetter === "y") dflt = constants.DFLTRANGEY;
          else if (ax._name === "realaxis") dflt = [0, 1];
          else dflt = opts.dfltRange || constants.DFLTRANGEX;
          dflt = dflt.slice();
          if (ax.rangemode === "tozero" || ax.rangemode === "nonnegative") {
            dflt[0] = 0;
          }
          if (!range || range.length !== 2) {
            Lib.nestedProperty(ax, rangeAttr).set(dflt);
            return;
          }
          var nullRange0 = range[0] === null;
          var nullRange1 = range[1] === null;
          if (ax.type === "date" && !ax.autorange) {
            range[0] = Lib.cleanDate(range[0], BADNUM, ax.calendar);
            range[1] = Lib.cleanDate(range[1], BADNUM, ax.calendar);
          }
          for (i = 0; i < 2; i++) {
            if (ax.type === "date") {
              if (!Lib.isDateTime(range[i], ax.calendar)) {
                ax[rangeAttr] = dflt;
                break;
              }
              if (ax.r2l(range[0]) === ax.r2l(range[1])) {
                var linCenter = Lib.constrain(
                  ax.r2l(range[0]),
                  Lib.MIN_MS + 1e3,
                  Lib.MAX_MS - 1e3
                );
                range[0] = ax.l2r(linCenter - 1e3);
                range[1] = ax.l2r(linCenter + 1e3);
                break;
              }
            } else {
              if (!isNumeric(range[i])) {
                if (!(nullRange0 || nullRange1) && isNumeric(range[1 - i])) {
                  range[i] = range[1 - i] * (i ? 10 : 0.1);
                } else {
                  ax[rangeAttr] = dflt;
                  break;
                }
              }
              if (range[i] < -FP_SAFE) range[i] = -FP_SAFE;
              else if (range[i] > FP_SAFE) range[i] = FP_SAFE;
              if (range[0] === range[1]) {
                var inc = Math.max(1, Math.abs(range[0] * 1e-6));
                range[0] -= inc;
                range[1] += inc;
              }
            }
          }
        };
        ax.setScale = function(usePrivateRange) {
          var gs = fullLayout._size;
          if (ax.overlaying) {
            var ax2 = axisIds.getFromId({ _fullLayout: fullLayout }, ax.overlaying);
            ax.domain = ax2.domain;
          }
          var rangeAttr = usePrivateRange && ax._r ? "_r" : "range";
          var calendar = ax.calendar;
          ax.cleanRange(rangeAttr);
          var rl0 = ax.r2l(ax[rangeAttr][0], calendar);
          var rl1 = ax.r2l(ax[rangeAttr][1], calendar);
          var isY2 = axLetter === "y";
          if (isY2) {
            ax._offset = gs.t + (1 - ax.domain[1]) * gs.h;
            ax._length = gs.h * (ax.domain[1] - ax.domain[0]);
            ax._m = ax._length / (rl0 - rl1);
            ax._b = -ax._m * rl1;
          } else {
            ax._offset = gs.l + ax.domain[0] * gs.w;
            ax._length = gs.w * (ax.domain[1] - ax.domain[0]);
            ax._m = ax._length / (rl1 - rl0);
            ax._b = -ax._m * rl0;
          }
          ax._rangebreaks = [];
          ax._lBreaks = 0;
          ax._m2 = 0;
          ax._B = [];
          if (ax.rangebreaks) {
            var i, brk;
            ax._rangebreaks = ax.locateBreaks(
              Math.min(rl0, rl1),
              Math.max(rl0, rl1)
            );
            if (ax._rangebreaks.length) {
              for (i = 0; i < ax._rangebreaks.length; i++) {
                brk = ax._rangebreaks[i];
                ax._lBreaks += Math.abs(brk.max - brk.min);
              }
              var flip = isY2;
              if (rl0 > rl1) flip = !flip;
              if (flip) ax._rangebreaks.reverse();
              var sign = flip ? -1 : 1;
              ax._m2 = sign * ax._length / (Math.abs(rl1 - rl0) - ax._lBreaks);
              ax._B.push(-ax._m2 * (isY2 ? rl1 : rl0));
              for (i = 0; i < ax._rangebreaks.length; i++) {
                brk = ax._rangebreaks[i];
                ax._B.push(
                  ax._B[ax._B.length - 1] - sign * ax._m2 * (brk.max - brk.min)
                );
              }
              for (i = 0; i < ax._rangebreaks.length; i++) {
                brk = ax._rangebreaks[i];
                brk.pmin = l2p(brk.min);
                brk.pmax = l2p(brk.max);
              }
            }
          }
          if (!isFinite(ax._m) || !isFinite(ax._b) || ax._length < 0) {
            fullLayout._replotting = false;
            throw new Error("Something went wrong with axis scaling");
          }
        };
        ax.maskBreaks = function(v) {
          var rangebreaksIn = ax.rangebreaks || [];
          var bnds, b0, b1, vb, vDate;
          if (!rangebreaksIn._cachedPatterns) {
            rangebreaksIn._cachedPatterns = rangebreaksIn.map(function(brk2) {
              return brk2.enabled && brk2.bounds ? Lib.simpleMap(
                brk2.bounds,
                brk2.pattern ? cleanNumber : ax.d2c
                // case of pattern: ''
              ) : null;
            });
          }
          if (!rangebreaksIn._cachedValues) {
            rangebreaksIn._cachedValues = rangebreaksIn.map(function(brk2) {
              return brk2.enabled && brk2.values ? Lib.simpleMap(brk2.values, ax.d2c).sort(Lib.sorterAsc) : null;
            });
          }
          for (var i = 0; i < rangebreaksIn.length; i++) {
            var brk = rangebreaksIn[i];
            if (brk.enabled) {
              if (brk.bounds) {
                var pattern = brk.pattern;
                bnds = rangebreaksIn._cachedPatterns[i];
                b0 = bnds[0];
                b1 = bnds[1];
                switch (pattern) {
                  case WEEKDAY_PATTERN:
                    vDate = new Date(v);
                    vb = vDate.getUTCDay();
                    if (b0 > b1) {
                      b1 += 7;
                      if (vb < b0) vb += 7;
                    }
                    break;
                  case HOUR_PATTERN:
                    vDate = new Date(v);
                    var hours = vDate.getUTCHours();
                    var minutes = vDate.getUTCMinutes();
                    var seconds = vDate.getUTCSeconds();
                    var milliseconds = vDate.getUTCMilliseconds();
                    vb = hours + (minutes / 60 + seconds / 3600 + milliseconds / 36e5);
                    if (b0 > b1) {
                      b1 += 24;
                      if (vb < b0) vb += 24;
                    }
                    break;
                  case "":
                    vb = v;
                    break;
                }
                if (vb >= b0 && vb < b1) return BADNUM;
              } else {
                var vals = rangebreaksIn._cachedValues[i];
                for (var j = 0; j < vals.length; j++) {
                  b0 = vals[j];
                  b1 = b0 + brk.dvalue;
                  if (v >= b0 && v < b1) return BADNUM;
                }
              }
            }
          }
          return v;
        };
        ax.locateBreaks = function(r0, r1) {
          var i, bnds, b0, b1;
          var rangebreaksOut = [];
          if (!ax.rangebreaks) return rangebreaksOut;
          var rangebreaksIn = ax.rangebreaks.slice().sort(function(a, b) {
            if (a.pattern === WEEKDAY_PATTERN && b.pattern === HOUR_PATTERN) return -1;
            if (b.pattern === WEEKDAY_PATTERN && a.pattern === HOUR_PATTERN) return 1;
            return 0;
          });
          var addBreak = function(min, max) {
            min = Lib.constrain(min, r0, r1);
            max = Lib.constrain(max, r0, r1);
            if (min === max) return;
            var isNewBreak = true;
            for (var j2 = 0; j2 < rangebreaksOut.length; j2++) {
              var brkj = rangebreaksOut[j2];
              if (min < brkj.max && max >= brkj.min) {
                if (min < brkj.min) {
                  brkj.min = min;
                }
                if (max > brkj.max) {
                  brkj.max = max;
                }
                isNewBreak = false;
              }
            }
            if (isNewBreak) {
              rangebreaksOut.push({ min, max });
            }
          };
          for (i = 0; i < rangebreaksIn.length; i++) {
            var brk = rangebreaksIn[i];
            if (brk.enabled) {
              if (brk.bounds) {
                var t02 = r0;
                var t12 = r1;
                if (brk.pattern) {
                  t02 = Math.floor(t02);
                }
                bnds = Lib.simpleMap(brk.bounds, brk.pattern ? cleanNumber : ax.r2l);
                b0 = bnds[0];
                b1 = bnds[1];
                var t0Date = new Date(t02);
                var bndDelta;
                var step;
                switch (brk.pattern) {
                  case WEEKDAY_PATTERN:
                    step = ONEWEEK;
                    bndDelta = ((b1 < b0 ? 7 : 0) + (b1 - b0)) * ONEDAY;
                    t02 += b0 * ONEDAY - (t0Date.getUTCDay() * ONEDAY + t0Date.getUTCHours() * ONEHOUR + t0Date.getUTCMinutes() * ONEMIN + t0Date.getUTCSeconds() * ONESEC + t0Date.getUTCMilliseconds());
                    break;
                  case HOUR_PATTERN:
                    step = ONEDAY;
                    bndDelta = ((b1 < b0 ? 24 : 0) + (b1 - b0)) * ONEHOUR;
                    t02 += b0 * ONEHOUR - (t0Date.getUTCHours() * ONEHOUR + t0Date.getUTCMinutes() * ONEMIN + t0Date.getUTCSeconds() * ONESEC + t0Date.getUTCMilliseconds());
                    break;
                  default:
                    t02 = Math.min(bnds[0], bnds[1]);
                    t12 = Math.max(bnds[0], bnds[1]);
                    step = t12 - t02;
                    bndDelta = step;
                }
                for (var t = t02; t < t12; t += step) {
                  addBreak(t, t + bndDelta);
                }
              } else {
                var vals = Lib.simpleMap(brk.values, ax.d2c);
                for (var j = 0; j < vals.length; j++) {
                  b0 = vals[j];
                  b1 = b0 + brk.dvalue;
                  addBreak(b0, b1);
                }
              }
            }
          }
          rangebreaksOut.sort(function(a, b) {
            return a.min - b.min;
          });
          return rangebreaksOut;
        };
        ax.makeCalcdata = function(trace, axLetter2, opts) {
          var arrayIn, arrayOut, i, len;
          var axType = ax.type;
          var cal = axType === "date" && trace[axLetter2 + "calendar"];
          if (axLetter2 in trace) {
            arrayIn = trace[axLetter2];
            len = trace._length || Lib.minRowLength(arrayIn);
            if (Lib.isTypedArray(arrayIn) && (axType === "linear" || axType === "log")) {
              if (len === arrayIn.length) {
                return arrayIn;
              } else if (arrayIn.subarray) {
                return arrayIn.subarray(0, len);
              }
            }
            if (axType === "multicategory") {
              return setMultiCategoryIndex(arrayIn, len);
            }
            arrayOut = new Array(len);
            for (i = 0; i < len; i++) {
              arrayOut[i] = ax.d2c(arrayIn[i], 0, cal, opts);
            }
          } else {
            var v0 = axLetter2 + "0" in trace ? ax.d2c(trace[axLetter2 + "0"], 0, cal) : 0;
            var dv = trace["d" + axLetter2] ? Number(trace["d" + axLetter2]) : 1;
            arrayIn = trace[{ x: "y", y: "x" }[axLetter2]];
            len = trace._length || arrayIn.length;
            arrayOut = new Array(len);
            for (i = 0; i < len; i++) {
              arrayOut[i] = v0 + i * dv;
            }
          }
          if (ax.rangebreaks) {
            for (i = 0; i < len; i++) {
              arrayOut[i] = ax.maskBreaks(arrayOut[i]);
            }
          }
          return arrayOut;
        };
        ax.isValidRange = function(range, nullOk) {
          return Array.isArray(range) && range.length === 2 && (nullOk && range[0] === null || isNumeric(ax.r2l(range[0]))) && (nullOk && range[1] === null || isNumeric(ax.r2l(range[1])));
        };
        ax.getAutorangeDflt = function(range, options) {
          var autorangeDflt = !ax.isValidRange(range, "nullOk");
          if (autorangeDflt && options && options.reverseDflt) autorangeDflt = "reversed";
          else if (range) {
            if (range[0] === null && range[1] === null) {
              autorangeDflt = true;
            } else if (range[0] === null && range[1] !== null) {
              autorangeDflt = "min";
            } else if (range[0] !== null && range[1] === null) {
              autorangeDflt = "max";
            }
          }
          return autorangeDflt;
        };
        ax.isReversed = function() {
          var autorange = ax.autorange;
          return autorange === "reversed" || autorange === "min reversed" || autorange === "max reversed";
        };
        ax.isPtWithinRange = function(d, calendar) {
          var coord = ax.c2l(d[axLetter], null, calendar);
          var r0 = ax.r2l(ax.range[0]);
          var r1 = ax.r2l(ax.range[1]);
          if (r0 < r1) {
            return r0 <= coord && coord <= r1;
          } else {
            return r1 <= coord && coord <= r0;
          }
        };
        ax._emptyCategories = function() {
          ax._categories = [];
          ax._categoriesMap = {};
        };
        ax.clearCalc = function() {
          var group = ax._matchGroup;
          if (group) {
            var categories = null;
            var categoriesMap = null;
            for (var axId2 in group) {
              var ax2 = fullLayout[axisIds.id2name(axId2)];
              if (ax2._categories) {
                categories = ax2._categories;
                categoriesMap = ax2._categoriesMap;
                break;
              }
            }
            if (categories && categoriesMap) {
              ax._categories = categories;
              ax._categoriesMap = categoriesMap;
            } else {
              ax._emptyCategories();
            }
          } else {
            ax._emptyCategories();
          }
          if (ax._initialCategories) {
            for (var j = 0; j < ax._initialCategories.length; j++) {
              setCategoryIndex(ax._initialCategories[j]);
            }
          }
        };
        ax.sortByInitialCategories = function() {
          var affectedTraces = [];
          ax._emptyCategories();
          if (ax._initialCategories) {
            for (var j = 0; j < ax._initialCategories.length; j++) {
              setCategoryIndex(ax._initialCategories[j]);
            }
          }
          affectedTraces = affectedTraces.concat(ax._traceIndices);
          var group = ax._matchGroup;
          for (var axId2 in group) {
            if (axId === axId2) continue;
            var ax2 = fullLayout[axisIds.id2name(axId2)];
            ax2._categories = ax._categories;
            ax2._categoriesMap = ax._categoriesMap;
            affectedTraces = affectedTraces.concat(ax2._traceIndices);
          }
          return affectedTraces;
        };
        var locale = fullLayout._d3locale;
        if (ax.type === "date") {
          ax._dateFormat = locale ? locale.timeFormat : utcFormat;
          ax._extraFormat = fullLayout._extraFormat;
        }
        ax._separators = fullLayout.separators;
        ax._numFormat = locale ? locale.numberFormat : numberFormat;
        delete ax._minDtick;
        delete ax._forceTick0;
      };
    }
  });

  // src/plots/cartesian/axis_autotype.js
  var require_axis_autotype = __commonJS({
    "src/plots/cartesian/axis_autotype.js"(exports, module) {
      "use strict";
      var isNumeric = require_fast_isnumeric();
      var Lib = require_lib();
      var BADNUM = require_numerical().BADNUM;
      var isArrayOrTypedArray = Lib.isArrayOrTypedArray;
      var isDateTime = Lib.isDateTime;
      var cleanNumber = Lib.cleanNumber;
      var round = Math.round;
      module.exports = function autoType(array, calendar, opts) {
        var a = array;
        var noMultiCategory = opts.noMultiCategory;
        if (isArrayOrTypedArray(a) && !a.length) return "-";
        if (!noMultiCategory && multiCategory(a)) return "multicategory";
        if (noMultiCategory && Array.isArray(a[0])) {
          var b = [];
          for (var i = 0; i < a.length; i++) {
            if (isArrayOrTypedArray(a[i])) {
              for (var j = 0; j < a[i].length; j++) {
                b.push(a[i][j]);
              }
            }
          }
          a = b;
        }
        if (moreDates(a, calendar)) return "date";
        var convertNumeric = opts.autotypenumbers !== "strict";
        if (category(a, convertNumeric)) return "category";
        if (linearOK(a, convertNumeric)) return "linear";
        return "-";
      };
      function hasTypeNumber(v, convertNumeric) {
        return convertNumeric ? isNumeric(v) : typeof v === "number";
      }
      function linearOK(a, convertNumeric) {
        var len = a.length;
        for (var i = 0; i < len; i++) {
          if (hasTypeNumber(a[i], convertNumeric)) return true;
        }
        return false;
      }
      function moreDates(a, calendar) {
        var len = a.length;
        var inc = getIncrement(len);
        var dats = 0;
        var nums = 0;
        var seen = {};
        for (var f = 0; f < len; f += inc) {
          var i = round(f);
          var ai = a[i];
          var stri = String(ai);
          if (seen[stri]) continue;
          seen[stri] = 1;
          if (isDateTime(ai, calendar)) dats++;
          if (isNumeric(ai)) nums++;
        }
        return dats > nums * 2;
      }
      function getIncrement(len) {
        return Math.max(1, (len - 1) / 1e3);
      }
      function category(a, convertNumeric) {
        var len = a.length;
        var inc = getIncrement(len);
        var nums = 0;
        var cats = 0;
        var seen = {};
        for (var f = 0; f < len; f += inc) {
          var i = round(f);
          var ai = a[i];
          var stri = String(ai);
          if (seen[stri]) continue;
          seen[stri] = 1;
          var t = typeof ai;
          if (t === "boolean") cats++;
          else if (convertNumeric ? cleanNumber(ai) !== BADNUM : t === "number") nums++;
          else if (t === "string") cats++;
        }
        return cats > nums * 2;
      }
      function multiCategory(a) {
        return isArrayOrTypedArray(a[0]) && isArrayOrTypedArray(a[1]);
      }
    }
  });

  // src/plots/cartesian/autorange.js
  var require_autorange = __commonJS({
    "src/plots/cartesian/autorange.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var isNumeric = require_fast_isnumeric();
      var Lib = require_lib();
      var FP_SAFE = require_numerical().FP_SAFE;
      var Registry = require_registry();
      var Drawing = require_drawing();
      var axIds = require_axis_ids();
      var getFromId = axIds.getFromId;
      var isLinked = axIds.isLinked;
      module.exports = {
        applyAutorangeOptions,
        getAutoRange,
        makePadFn,
        doAutoRange,
        findExtremes,
        concatExtremes
      };
      function getAutoRange(gd, ax) {
        var i, j;
        var newRange = [];
        var fullLayout = gd._fullLayout;
        var getPadMin = makePadFn(fullLayout, ax, 0);
        var getPadMax = makePadFn(fullLayout, ax, 1);
        var extremes = concatExtremes(gd, ax);
        var minArray = extremes.min;
        var maxArray = extremes.max;
        if (minArray.length === 0 || maxArray.length === 0) {
          return Lib.simpleMap(ax.range, ax.r2l);
        }
        var minmin = minArray[0].val;
        var maxmax = maxArray[0].val;
        for (i = 1; i < minArray.length; i++) {
          if (minmin !== maxmax) break;
          minmin = Math.min(minmin, minArray[i].val);
        }
        for (i = 1; i < maxArray.length; i++) {
          if (minmin !== maxmax) break;
          maxmax = Math.max(maxmax, maxArray[i].val);
        }
        var autorange = ax.autorange;
        var axReverse = autorange === "reversed" || autorange === "min reversed" || autorange === "max reversed";
        if (!axReverse && ax.range) {
          var rng = Lib.simpleMap(ax.range, ax.r2l);
          axReverse = rng[1] < rng[0];
        }
        if (ax.autorange === "reversed") {
          ax.autorange = true;
        }
        var rangeMode = ax.rangemode;
        var toZero = rangeMode === "tozero";
        var nonNegative = rangeMode === "nonnegative";
        var axLen = ax._length;
        var minSpan = axLen / 10;
        var mbest = 0;
        var minpt, maxpt, minbest, maxbest, dp, dv;
        for (i = 0; i < minArray.length; i++) {
          minpt = minArray[i];
          for (j = 0; j < maxArray.length; j++) {
            maxpt = maxArray[j];
            dv = maxpt.val - minpt.val - calcBreaksLength(ax, minpt.val, maxpt.val);
            if (dv > 0) {
              dp = axLen - getPadMin(minpt) - getPadMax(maxpt);
              if (dp > minSpan) {
                if (dv / dp > mbest) {
                  minbest = minpt;
                  maxbest = maxpt;
                  mbest = dv / dp;
                }
              } else if (dv / axLen > mbest) {
                minbest = { val: minpt.val, nopad: 1 };
                maxbest = { val: maxpt.val, nopad: 1 };
                mbest = dv / axLen;
              }
            }
          }
        }
        function maximumPad(prev, pt) {
          return Math.max(prev, getPadMax(pt));
        }
        if (minmin === maxmax) {
          var lower = minmin - 1;
          var upper = minmin + 1;
          if (toZero) {
            if (minmin === 0) {
              newRange = [0, 1];
            } else {
              var maxPad = (minmin > 0 ? maxArray : minArray).reduce(maximumPad, 0);
              var rangeEnd = minmin / (1 - Math.min(0.5, maxPad / axLen));
              newRange = minmin > 0 ? [0, rangeEnd] : [rangeEnd, 0];
            }
          } else if (nonNegative) {
            newRange = [Math.max(0, lower), Math.max(1, upper)];
          } else {
            newRange = [lower, upper];
          }
        } else {
          if (toZero) {
            if (minbest.val >= 0) {
              minbest = { val: 0, nopad: 1 };
            }
            if (maxbest.val <= 0) {
              maxbest = { val: 0, nopad: 1 };
            }
          } else if (nonNegative) {
            if (minbest.val - mbest * getPadMin(minbest) < 0) {
              minbest = { val: 0, nopad: 1 };
            }
            if (maxbest.val <= 0) {
              maxbest = { val: 1, nopad: 1 };
            }
          }
          mbest = (maxbest.val - minbest.val - calcBreaksLength(ax, minpt.val, maxpt.val)) / (axLen - getPadMin(minbest) - getPadMax(maxbest));
          newRange = [
            minbest.val - mbest * getPadMin(minbest),
            maxbest.val + mbest * getPadMax(maxbest)
          ];
        }
        newRange = applyAutorangeOptions(newRange, ax);
        if (ax.limitRange) ax.limitRange();
        if (axReverse) newRange.reverse();
        return Lib.simpleMap(newRange, ax.l2r || Number);
      }
      function calcBreaksLength(ax, v0, v1) {
        var lBreaks = 0;
        if (ax.rangebreaks) {
          var rangebreaksOut = ax.locateBreaks(v0, v1);
          for (var i = 0; i < rangebreaksOut.length; i++) {
            var brk = rangebreaksOut[i];
            lBreaks += brk.max - brk.min;
          }
        }
        return lBreaks;
      }
      function makePadFn(fullLayout, ax, max) {
        var extrappad = 0.05 * ax._length;
        var anchorAxis = ax._anchorAxis || {};
        if ((ax.ticklabelposition || "").indexOf("inside") !== -1 || (anchorAxis.ticklabelposition || "").indexOf("inside") !== -1) {
          var axReverse = ax.isReversed();
          if (!axReverse) {
            var rng = Lib.simpleMap(ax.range, ax.r2l);
            axReverse = rng[1] < rng[0];
          }
          if (axReverse) max = !max;
        }
        var zero2 = 0;
        if (!isLinked(fullLayout, ax._id)) {
          zero2 = padInsideLabelsOnAnchorAxis(fullLayout, ax, max);
        }
        extrappad = Math.max(zero2, extrappad);
        if (ax.constrain === "domain" && ax._inputDomain) {
          extrappad *= (ax._inputDomain[1] - ax._inputDomain[0]) / (ax.domain[1] - ax.domain[0]);
        }
        return function getPad(pt) {
          if (pt.nopad) return 0;
          return pt.pad + (pt.extrapad ? extrappad : zero2);
        };
      }
      var TEXTPAD = 3;
      function padInsideLabelsOnAnchorAxis(fullLayout, ax, max) {
        var pad = 0;
        var isX = ax._id.charAt(0) === "x";
        for (var subplot in fullLayout._plots) {
          var plotinfo = fullLayout._plots[subplot];
          if (ax._id !== plotinfo.xaxis._id && ax._id !== plotinfo.yaxis._id) continue;
          var anchorAxis = (isX ? plotinfo.yaxis : plotinfo.xaxis) || {};
          if ((anchorAxis.ticklabelposition || "").indexOf("inside") !== -1) {
            if (!max && (anchorAxis.side === "left" || anchorAxis.side === "bottom") || max && (anchorAxis.side === "top" || anchorAxis.side === "right")) {
              if (anchorAxis._vals) {
                var rad = Lib.deg2rad(anchorAxis._tickAngles[anchorAxis._id + "tick"] || 0);
                var cosA = Math.abs(Math.cos(rad));
                var sinA = Math.abs(Math.sin(rad));
                if (!anchorAxis._vals[0].bb) {
                  var cls = anchorAxis._id + "tick";
                  var tickLabels = anchorAxis._selections[cls];
                  tickLabels.each(function(d) {
                    var thisLabel = d3.select(this);
                    var mathjaxGroup = thisLabel.select(".text-math-group");
                    if (mathjaxGroup.empty()) {
                      d.bb = Drawing.bBox(thisLabel.node());
                    }
                  });
                }
                for (var i = 0; i < anchorAxis._vals.length; i++) {
                  var t = anchorAxis._vals[i];
                  var bb = t.bb;
                  if (bb) {
                    var w = 2 * TEXTPAD + bb.width;
                    var h = 2 * TEXTPAD + bb.height;
                    pad = Math.max(
                      pad,
                      isX ? Math.max(w * cosA, h * sinA) : Math.max(h * cosA, w * sinA)
                    );
                  }
                }
              }
              if (anchorAxis.ticks === "inside" && anchorAxis.ticklabelposition === "inside") {
                pad += anchorAxis.ticklen || 0;
              }
            }
          }
        }
        return pad;
      }
      function concatExtremes(gd, ax, noMatch) {
        var axId = ax._id;
        var fullData = gd._fullData;
        var fullLayout = gd._fullLayout;
        var minArray = [];
        var maxArray = [];
        var i, j, d;
        function _concat(cont, indices) {
          for (i = 0; i < indices.length; i++) {
            var item = cont[indices[i]];
            var extremes = (item._extremes || {})[axId];
            if (item.visible === true && extremes) {
              for (j = 0; j < extremes.min.length; j++) {
                d = extremes.min[j];
                collapseMinArray(minArray, d.val, d.pad, { extrapad: d.extrapad });
              }
              for (j = 0; j < extremes.max.length; j++) {
                d = extremes.max[j];
                collapseMaxArray(maxArray, d.val, d.pad, { extrapad: d.extrapad });
              }
            }
          }
        }
        _concat(fullData, ax._traceIndices);
        _concat(fullLayout.annotations || [], ax._annIndices || []);
        _concat(fullLayout.shapes || [], ax._shapeIndices || []);
        if (ax._matchGroup && !noMatch) {
          for (var axId2 in ax._matchGroup) {
            if (axId2 !== ax._id) {
              var ax2 = getFromId(gd, axId2);
              var extremes2 = concatExtremes(gd, ax2, true);
              var lenRatio = ax._length / ax2._length;
              for (j = 0; j < extremes2.min.length; j++) {
                d = extremes2.min[j];
                collapseMinArray(minArray, d.val, d.pad * lenRatio, { extrapad: d.extrapad });
              }
              for (j = 0; j < extremes2.max.length; j++) {
                d = extremes2.max[j];
                collapseMaxArray(maxArray, d.val, d.pad * lenRatio, { extrapad: d.extrapad });
              }
            }
          }
        }
        return { min: minArray, max: maxArray };
      }
      function doAutoRange(gd, ax, presetRange) {
        ax.setScale();
        if (ax.autorange) {
          ax.range = presetRange ? presetRange.slice() : getAutoRange(gd, ax);
          ax._r = ax.range.slice();
          ax._rl = Lib.simpleMap(ax._r, ax.r2l);
          var axIn = ax._input;
          var edits = {};
          edits[ax._attr + ".range"] = ax.range;
          edits[ax._attr + ".autorange"] = ax.autorange;
          Registry.call("_storeDirectGUIEdit", gd.layout, gd._fullLayout._preGUI, edits);
          axIn.range = ax.range.slice();
          axIn.autorange = ax.autorange;
        }
        var anchorAx = ax._anchorAxis;
        if (anchorAx && anchorAx.rangeslider) {
          var axeRangeOpts = anchorAx.rangeslider[ax._name];
          if (axeRangeOpts) {
            if (axeRangeOpts.rangemode === "auto") {
              axeRangeOpts.range = getAutoRange(gd, ax);
            }
          }
          anchorAx._input.rangeslider[ax._name] = Lib.extendFlat({}, axeRangeOpts);
        }
      }
      function findExtremes(ax, data, opts) {
        if (!opts) opts = {};
        if (!ax._m) ax.setScale();
        var minArray = [];
        var maxArray = [];
        var len = data.length;
        var extrapad = opts.padded || false;
        var tozero = opts.tozero && (ax.type === "linear" || ax.type === "-");
        var isLog = ax.type === "log";
        var hasArrayOption = false;
        var vpadLinearized = opts.vpadLinearized || false;
        var i, v, di, dmin, dmax, ppadiplus, ppadiminus, vmin, vmax;
        function makePadAccessor(item) {
          if (Array.isArray(item)) {
            hasArrayOption = true;
            return function(i2) {
              return Math.max(Number(item[i2] || 0), 0);
            };
          } else {
            var v2 = Math.max(Number(item || 0), 0);
            return function() {
              return v2;
            };
          }
        }
        var ppadplus = makePadAccessor((ax._m > 0 ? opts.ppadplus : opts.ppadminus) || opts.ppad || 0);
        var ppadminus = makePadAccessor((ax._m > 0 ? opts.ppadminus : opts.ppadplus) || opts.ppad || 0);
        var vpadplus = makePadAccessor(opts.vpadplus || opts.vpad);
        var vpadminus = makePadAccessor(opts.vpadminus || opts.vpad);
        if (!hasArrayOption) {
          vmin = Infinity;
          vmax = -Infinity;
          if (isLog) {
            for (i = 0; i < len; i++) {
              v = data[i];
              if (v < vmin && v > 0) vmin = v;
              if (v > vmax && v < FP_SAFE) vmax = v;
            }
          } else {
            for (i = 0; i < len; i++) {
              v = data[i];
              if (v < vmin && v > -FP_SAFE) vmin = v;
              if (v > vmax && v < FP_SAFE) vmax = v;
            }
          }
          data = [vmin, vmax];
          len = 2;
        }
        var collapseOpts = { tozero, extrapad };
        function addItem(i2) {
          di = data[i2];
          if (!isNumeric(di)) return;
          ppadiplus = ppadplus(i2);
          ppadiminus = ppadminus(i2);
          if (vpadLinearized) {
            dmin = ax.c2l(di) - vpadminus(i2);
            dmax = ax.c2l(di) + vpadplus(i2);
          } else {
            vmin = di - vpadminus(i2);
            vmax = di + vpadplus(i2);
            if (isLog && vmin < vmax / 10) vmin = vmax / 10;
            dmin = ax.c2l(vmin);
            dmax = ax.c2l(vmax);
          }
          if (tozero) {
            dmin = Math.min(0, dmin);
            dmax = Math.max(0, dmax);
          }
          if (goodNumber(dmin)) {
            collapseMinArray(minArray, dmin, ppadiminus, collapseOpts);
          }
          if (goodNumber(dmax)) {
            collapseMaxArray(maxArray, dmax, ppadiplus, collapseOpts);
          }
        }
        var iMax = Math.min(6, len);
        for (i = 0; i < iMax; i++) addItem(i);
        for (i = len - 1; i >= iMax; i--) addItem(i);
        return {
          min: minArray,
          max: maxArray,
          opts
        };
      }
      function collapseMinArray(array, newVal, newPad, opts) {
        collapseArray(array, newVal, newPad, opts, lessOrEqual);
      }
      function collapseMaxArray(array, newVal, newPad, opts) {
        collapseArray(array, newVal, newPad, opts, greaterOrEqual);
      }
      function collapseArray(array, newVal, newPad, opts, atLeastAsExtreme) {
        var tozero = opts.tozero;
        var extrapad = opts.extrapad;
        var includeThis = true;
        for (var j = 0; j < array.length && includeThis; j++) {
          var v = array[j];
          if (atLeastAsExtreme(v.val, newVal) && v.pad >= newPad && (v.extrapad || !extrapad)) {
            includeThis = false;
            break;
          } else if (atLeastAsExtreme(newVal, v.val) && v.pad <= newPad && (extrapad || !v.extrapad)) {
            array.splice(j, 1);
            j--;
          }
        }
        if (includeThis) {
          var clipAtZero = tozero && newVal === 0;
          array.push({
            val: newVal,
            pad: clipAtZero ? 0 : newPad,
            extrapad: clipAtZero ? false : extrapad
          });
        }
      }
      function goodNumber(v) {
        return isNumeric(v) && Math.abs(v) < FP_SAFE;
      }
      function lessOrEqual(v0, v1) {
        return v0 <= v1;
      }
      function greaterOrEqual(v0, v1) {
        return v0 >= v1;
      }
      function applyAutorangeMinOptions(v, ax) {
        var autorangeoptions = ax.autorangeoptions;
        if (autorangeoptions && autorangeoptions.minallowed !== void 0 && hasValidMinAndMax(ax, autorangeoptions.minallowed, autorangeoptions.maxallowed)) {
          return autorangeoptions.minallowed;
        }
        if (autorangeoptions && autorangeoptions.clipmin !== void 0 && hasValidMinAndMax(ax, autorangeoptions.clipmin, autorangeoptions.clipmax)) {
          return Math.max(v, ax.d2l(autorangeoptions.clipmin));
        }
        return v;
      }
      function applyAutorangeMaxOptions(v, ax) {
        var autorangeoptions = ax.autorangeoptions;
        if (autorangeoptions && autorangeoptions.maxallowed !== void 0 && hasValidMinAndMax(ax, autorangeoptions.minallowed, autorangeoptions.maxallowed)) {
          return autorangeoptions.maxallowed;
        }
        if (autorangeoptions && autorangeoptions.clipmax !== void 0 && hasValidMinAndMax(ax, autorangeoptions.clipmin, autorangeoptions.clipmax)) {
          return Math.min(v, ax.d2l(autorangeoptions.clipmax));
        }
        return v;
      }
      function hasValidMinAndMax(ax, min, max) {
        if (min !== void 0 && max !== void 0) {
          min = ax.d2l(min);
          max = ax.d2l(max);
          return min < max;
        }
        return true;
      }
      function applyAutorangeOptions(range, ax) {
        if (!ax || !ax.autorangeoptions) return range;
        var min = range[0];
        var max = range[1];
        var include = ax.autorangeoptions.include;
        if (include !== void 0) {
          var lMin = ax.d2l(min);
          var lMax = ax.d2l(max);
          if (!Lib.isArrayOrTypedArray(include)) include = [include];
          for (var i = 0; i < include.length; i++) {
            var v = ax.d2l(include[i]);
            if (lMin >= v) {
              lMin = v;
              min = v;
            }
            if (lMax <= v) {
              lMax = v;
              max = v;
            }
          }
        }
        min = applyAutorangeMinOptions(min, ax);
        max = applyAutorangeMaxOptions(max, ax);
        return [min, max];
      }
    }
  });

  // src/plots/cartesian/axes.js
  var require_axes = __commonJS({
    "src/plots/cartesian/axes.js"(exports, module) {
      "use strict";
      var d3 = require_d3();
      var isNumeric = require_fast_isnumeric();
      var Plots = require_plots();
      var Registry = require_registry();
      var Lib = require_lib();
      var strTranslate = Lib.strTranslate;
      var svgTextUtils = require_svg_text_utils();
      var Titles = require_titles();
      var Color2 = require_color();
      var Drawing = require_drawing();
      var axAttrs = require_layout_attributes4();
      var cleanTicks = require_clean_ticks();
      var constants = require_numerical();
      var ONEMAXYEAR = constants.ONEMAXYEAR;
      var ONEAVGYEAR = constants.ONEAVGYEAR;
      var ONEMINYEAR = constants.ONEMINYEAR;
      var ONEMAXQUARTER = constants.ONEMAXQUARTER;
      var ONEAVGQUARTER = constants.ONEAVGQUARTER;
      var ONEMINQUARTER = constants.ONEMINQUARTER;
      var ONEMAXMONTH = constants.ONEMAXMONTH;
      var ONEAVGMONTH = constants.ONEAVGMONTH;
      var ONEMINMONTH = constants.ONEMINMONTH;
      var ONEWEEK = constants.ONEWEEK;
      var ONEDAY = constants.ONEDAY;
      var HALFDAY = ONEDAY / 2;
      var ONEHOUR = constants.ONEHOUR;
      var ONEMIN = constants.ONEMIN;
      var ONESEC = constants.ONESEC;
      var ONEMILLI = constants.ONEMILLI;
      var ONEMICROSEC = constants.ONEMICROSEC;
      var MINUS_SIGN = constants.MINUS_SIGN;
     