/**
 * Copyright 2014-present Palantir Technologies
 * @license MIT
 */
import { Point } from "../core/interfaces";
import { Scale } from "../scales/scale";
import { Component } from "./component";
export declare class Gridlines extends Component {
    private _betweenX;
    private _betweenY;
    private _xScale;
    private _yScale;
    private _xLinesContainer;
    private _yLinesContainer;
    private _renderCallback;
    /**
     * @constructor
     * @param {Scale} xScale The scale to base the x gridlines on. Pass null if no gridlines are desired.
     * @param {Scale} yScale The scale to base the y gridlines on. Pass null if no gridlines are desired.
     */
    constructor(xScale: Scale<any, any> | null, yScale: Scale<any, any> | null);
    /**
     * Gets the between flag for the x axis.
     *
     * @returns {boolean} The current state of betweenX
     */
    betweenX(): boolean;
    /**
     * Sets the between flag for the x axis. True causes gridlines to render
     * between ticks. False sets the causes the gridlines to render on the
     * ticks. Defaults to false.
     *
     * @param {boolean} betweenX
     * @returns {Gridlines} The calling Gridlines.
     */
    betweenX(_betweenX: boolean): this;
    /**
     * Gets the between flag for the y axis.
     *
     * @returns {boolean} The current state of betweenY
     */
    betweenY(): boolean;
    /**
   * Sets the between flag for the y axis. True causes gridlines to render
   * between ticks. False sets the causes the gridlines to render on the
   * ticks. Defaults to false.
   *
   * @param {boolean} betweenY
   * @returns {Gridlines} The calling Gridlines.
   */
    betweenY(_betweenY: boolean): this;
    destroy(): this;
    protected _setup(): void;
    renderImmediately(): this;
    computeLayout(origin?: Point, availableWidth?: number, availableHeight?: number): this;
    private _redrawXLines();
    private _redrawYLines();
}
