export declare class Dispatcher {
    /**
     * Subclasses set these in constructor. Then, these
     * get attached to the global document in _connect
     *
     * eventname is a DOM event name like "mouseup", "touchstart", etc.
     * The callback is simply registered to the event callback with bubbling.
     */
    protected _eventToProcessingFunction: {
        [eventName: string]: (e: Event) => any;
    };
    private _eventNameToCallbackSet;
    private _connected;
    private _hasNoCallbacks();
    private _connect();
    private _disconnect();
    protected _addCallbackForEvent(eventName: string, callback: Function): void;
    protected _removeCallbackForEvent(eventName: string, callback: Function): void;
    protected _callCallbacksForEvent(eventName: string, ...args: any[]): void;
}
