/**
 * Copyright 2014-present Palantir Technologies
 * @license MIT
 */
import * as d3 from "d3";
import { AttributeToAppliedProjector } from "../core/interfaces";
import { IDrawer } from "./drawer";
import { AppliedDrawStep } from "./drawStep";
export declare type CanvasDrawStep = (context: CanvasRenderingContext2D, data: any[], attrToAppliedProjector: AttributeToAppliedProjector) => void;
/**
 * A CanvasDrawer draws data onto a supplied Canvas Context.
 *
 * This class is immutable (but has internal state) and shouldn't be extended.
 */
export declare class CanvasDrawer implements IDrawer {
    private _context;
    private _drawStep;
    /**
     * @param _context The context for a canvas that this drawer will draw to.
     * @param _drawStep The draw step logic that actually draws.
     */
    constructor(_context: CanvasRenderingContext2D, _drawStep: CanvasDrawStep);
    getDrawStep(): CanvasDrawStep;
    draw(data: any[], appliedDrawSteps: AppliedDrawStep[]): void;
    getVisualPrimitives(): Element[];
    getVisualPrimitiveAtIndex(index: number): Element;
    remove(): void;
}
export declare const ContextStyleAttrs: string[];
export declare function resolveAttributesSubsetWithStyles(projector: AttributeToAppliedProjector, extraKeys: string[], datum: any, index: number): Record<string, any>;
export declare function resolveAttributes(projector: AttributeToAppliedProjector, attrKeys: string[], datum: any, index: number): Record<string, any>;
export interface IStrokeStyle {
    "stroke-opacity"?: number;
    "stroke-width"?: number;
    opacity?: number;
    stroke?: string;
}
export interface IFillStyle {
    "fill-opacity"?: number;
    fill?: string;
    opacity?: number;
}
export declare function renderArea(context: CanvasRenderingContext2D, d3Area: d3.Area<any>, data: any[], style: IFillStyle & IStrokeStyle): void;
export declare function renderLine(context: CanvasRenderingContext2D, d3Line: d3.Line<any>, data: any[], style: IStrokeStyle): void;
export declare function renderPathWithStyle(context: CanvasRenderingContext2D, style: Record<string, any>): void;
