/**
 * Copyright 2017-present Palantir Technologies
 * @license MIT
 */
import { Scale } from "../scales/scale";
/**
 * Manages deferred rendering callbacks.
 *
 * Call `setDomains` when deferred rendering is initially enabled to fix the
 * current domain values.
 *
 * Call `updateDomains` when scale domains change, which uses the domain to
 * compute CSS-tyle transform parameters passed to `applyTransformCallback`,
 * mimicking the result of a full re-render. After a deferred timeout, invoke
 * `applyTransformCallback` again with an identity transform and finally invoke
 * `renderCallback`, which should actually redraw the plot.
 */
export declare class DeferredRenderer<X, Y> {
    private renderCallback;
    private applyTransformCallback;
    static DEFERRED_RENDERING_DELAY: number;
    private domainTransformX;
    private domainTransformY;
    private timeoutToken;
    constructor(renderCallback: () => void, applyTransformCallback: (tx: number, ty: number, sx: number, sy: number) => void);
    setDomains(scaleX?: Scale<X, any>, scaleY?: Scale<Y, any>): void;
    updateDomains(scaleX?: Scale<X, any>, scaleY?: Scale<Y, any>): void;
    private renderDeferred;
    private resetTransforms();
    private applyTransform();
}
