import { ITransformableScale } from "./";
import * as Scales from "./";
import { Scale } from "./scale";
export declare class QuantitativeScale<D> extends Scale<D, number> implements ITransformableScale {
    protected static _DEFAULT_NUM_TICKS: number;
    private _tickGenerator;
    private _padProportion;
    private _paddingExceptionsProviders;
    private _domainMin;
    private _domainMax;
    private _snappingDomainEnabled;
    /**
     * A QuantitativeScale is a Scale that maps number-like values to numbers.
     * It is invertible and continuous.
     *
     * @constructor
     */
    constructor();
    autoDomain(): this;
    protected _autoDomainIfAutomaticMode(): void;
    protected _getExtent(): D[];
    /**
     * Adds a padding exception provider.
     * If one end of the domain is set to an excepted value as a result of autoDomain()-ing,
     * that end of the domain will not be padded.
     *
     * @param {Scales.PaddingExceptionProvider<D>} provider The provider function.
     * @returns {QuantitativeScale} The calling QuantitativeScale.
     */
    addPaddingExceptionsProvider(provider: Scales.IPaddingExceptionsProvider<D>): this;
    /**
     * Removes the padding exception provider.
     *
     * @param {Scales.PaddingExceptionProvider<D>} provider The provider function.
     * @returns {QuantitativeScale} The calling QuantitativeScale.
     */
    removePaddingExceptionsProvider(provider: Scales.IPaddingExceptionsProvider<D>): this;
    /**
     * Gets the padding proportion.
     */
    padProportion(): number;
    /**
     * Sets the padding porportion.
     * When autoDomain()-ing, the computed domain will be expanded by this proportion,
     * then rounded to human-readable values.
     *
     * @param {number} padProportion The padding proportion. Passing 0 disables padding.
     * @returns {QuantitativeScale} The calling QuantitativeScale.
     */
    padProportion(padProportion: number): this;
    private _padDomain(domain);
    /**
     * Gets whether or not the scale snaps its domain to nice values.
     */
    snappingDomainEnabled(): boolean;
    /**
     * Sets whether or not the scale snaps its domain to nice values.
     */
    snappingDomainEnabled(snappingDomainEnabled: boolean): this;
    protected _expandSingleValueDomain(singleValueDomain: D[]): D[];
    /**
     * Computes the domain value corresponding to a supplied range value.
     *
     * @param {number} value: A value from the Scale's range.
     * @returns {D} The domain value corresponding to the supplied range value.
     */
    invert(value: number): D;
    domain(): D[];
    domain(values: D[]): this;
    /**
     * Gets the lower end of the domain.
     *
     * @return {D}
     */
    domainMin(): D;
    /**
     * Sets the lower end of the domain.
     *
     * @return {QuantitativeScale} The calling QuantitativeScale.
     */
    domainMin(domainMin: D): this;
    /**
     * Gets the upper end of the domain.
     *
     * @return {D}
     */
    domainMax(): D;
    /**
     * Sets the upper end of the domain.
     *
     * @return {QuantitativeScale} The calling QuantitativeScale.
     */
    domainMax(domainMax: D): this;
    extentOfValues(values: D[]): D[];
    zoom(magnifyAmount: number, centerValue: number): void;
    pan(translateAmount: number): void;
    scaleTransformation(value: number): number;
    invertedTransformation(value: number): number;
    getTransformationDomain(): [number, number];
    protected _setDomain(values: D[]): void;
    /**
     * Gets the array of tick values generated by the default algorithm.
     */
    defaultTicks(): D[];
    /**
     * Gets an array of tick values spanning the domain.
     *
     * @returns {D[]}
     */
    ticks(): D[];
    /**
     * Given a domain, expands its domain onto "nice" values, e.g. whole
     * numbers.
     */
    protected _niceDomain(domain: D[], count?: number): D[];
    protected _defaultExtent(): D[];
    /**
     * Gets the TickGenerator.
     */
    tickGenerator(): Scales.TickGenerators.ITickGenerator<D>;
    /**
     * Sets the TickGenerator
     *
     * @param {TickGenerator} generator
     * @return {QuantitativeScale} The calling QuantitativeScale.
     */
    tickGenerator(generator: Scales.TickGenerators.ITickGenerator<D>): this;
}
