import { Point } from "../";
import { Component } from "../components/component";
import { SimpleSelection } from "../core/interfaces";
export declare function getTranslator(component: Component): Translator;
/**
* The translator implements CSS transform aware event measuring. When a Component is rendered an element that
 * has a css3 transform applied, mouse/touch interactions will be totally misaligned with the actual chart
 * since browsers don't send transformed values for events. Translator is responsible for re-aligning interaction
 * events by moving and measuring a special "test" div on every mouse/touch event.
*/
export declare class Translator {
    private static SAMPLE_DISTANCE;
    private _measurer;
    constructor(rootContent: SimpleSelection<void>);
    /**
     * Computes the position relative to the rootContent, taking into account css3 transforms.
     *
     * Move the measurer div to 0,0, get its getBoundingClientRect(), then to 100,000,
     * getBoundingClientRect() again, and divide the actual spacing by 100 to get the
     * scale and translate.
     */
    computePosition(clientX: number, clientY: number): Point;
    private moveMeasurer(x, y);
    /**
     * Is the event's target part of the given component's DOM tree?
     * @param component
     * @param e
     * @returns {boolean}
     */
    static isEventInside(component: Component, e: Event): boolean;
}
