export declare type ColorSpace = 'DeviceGray' | 'DeviceRGB';
export default class PNG {
    static load: (data: Uint8Array) => PNG;
    palette: number[];
    imgData: Uint8Array;
    transparency: {
        indexed?: number[];
        grayscale?: number;
        rgb?: number[];
    };
    text: {
        [key: string]: string;
    };
    width: number;
    height: number;
    bits: number;
    colorType: number;
    compressionMethod: number;
    filterMethod: number;
    interlaceMethod: number;
    colors: 1 | 3;
    hasAlphaChannel: boolean;
    pixelBitlength: number;
    colorSpace: ColorSpace;
    private data;
    private pos;
    constructor(data: Uint8Array);
    decode: () => Uint8Array;
    copyImageDataToBuffer: (imageData: Uint8Array, pixels: Uint8Array) => void;
    decodePixels: () => Uint8Array;
    private read;
    private readUInt32;
    private decodePalette;
}
