/* src/PNotify.html generated by Svelte v1.55.0 */

let PNotify;

let posTimer; // Position all timer.

// These actions need to be done once the DOM is ready.
let onDocumentLoaded = () => {
  PNotify.defaultStack.context = document.body;
  // Reposition the notices when the window resizes.
  window.addEventListener('resize', () => {
    if (posTimer) {
      clearTimeout(posTimer);
    }
    posTimer = setTimeout(() => {
      PNotify.positionAll();
    }, 10);
  });
};

// Creates the background overlay for modal stacks.
let createStackOverlay = (stack) => {
  const overlay = document.createElement("div");
  overlay.classList.add("ui-pnotify-modal-overlay");
  if (stack.context !== document.body) {
    overlay.style.height = stack.context.scrollHeight+"px";
    overlay.style.width = stack.context.scrollWidth+"px";
  }
  // Close the notices on overlay click.
  overlay.addEventListener('click', () => {
    if (stack.overlayClose) {
      PNotify.closeStack(stack);
    }
  });
  stack.overlay = overlay;
};

let insertStackOverlay = (stack) => {
  if (stack.overlay.parentNode !== stack.context) {
    stack.overlay = stack.context.insertBefore(stack.overlay, stack.context.firstChild);
  }
};

let removeStackOverlay = (stack) => {
  if (stack.overlay.parentNode) {
    stack.overlay.parentNode.removeChild(stack.overlay);
  }
};

// Default arguments for the new notice helper functions.
const getDefaultArgs = (options, type) => {
  if (typeof options !== "object") {
    options = {"text": options};
  }

  // Only assign the type if it was requested, so we don't overwrite
  // options.type if it has something assigned.
  if (type) {
    options.type = type;
  }

  return {target: document.body, data: options};
}

function _styles(styling) {
	return typeof styling === "object" ? styling : PNotify.styling[styling];
}

function _icons(icons) {
	return typeof icons === "object" ? icons : PNotify.icons[icons];
}

function data() {
  const data = Object.assign({
    "_state": "initializing", // The state can be "initializing", "opening", "open", "closing", and "closed".
    "_timer": null, // Auto close timer.
    "_animTimer": null, // Animation timer.
    "_animating": false, // Stores what is currently being animated (in or out).
    "_animatingClass": "", // Stores the class that adds entry/exit animation effects.
    "_moveClass": "", // Stores the class that adds movement animation effects.
    "_timerHide": false, // Stores whether the notice was hidden by a timer.
    "_moduleClasses": [], // Modules can add classes here to be added to the notice element. (They should play nice and not remove classes that aren't theirs.)
    "_moduleIsNoticeOpen": false, // Modules that change how the notice displays (causing the notice element to not appear) can set this to true to make PNotify assume the notice has opened.
    "_modules": {}, // Stores the instances of the modules.
    "_modulesPrependContainer": PNotify.modulesPrependContainer,
    "_modulesAppendContainer": PNotify.modulesAppendContainer,
  }, PNotify.defaults);
  data.modules = Object.assign({}, PNotify.defaults.modules);
  return data;
};

var methods = {
  // This runs an event on all the modules.
  runModules(event) {
    if (event === "init") {
      // Initializing a module should only be done if it has an init
      // function, which means it's not rendered in the template.
      for (let key in PNotify.modules) {
        if (!PNotify.modules.hasOwnProperty(key)) {
          continue;
        }
        if (typeof PNotify.modules[key].init === 'function') {
          const module = PNotify.modules[key].init(this);
          this.initModule(module);
        }
      }
    } else {
      const _modules = this.get("_modules");
      for (let module in _modules) {
        if (!_modules.hasOwnProperty(module)) {
          continue;
        }
        const moduleOptions = Object.assign({
          "_notice": this,
          "_options": this.get()
        }, this.get("modules")[module]);
        _modules[module].set(moduleOptions);
        if (typeof _modules[module][event] === 'function') {
          _modules[module][event]();
        }
      }
    }
  },

  // This passes module options to a module.
  initModule(module) {
    const modules = this.get("modules");
    if (!modules.hasOwnProperty(module.constructor.key)) {
      modules[module.constructor.key] = {};
    }
    const moduleOptions = Object.assign({
      "_notice": this,
      "_options": this.get()
    }, modules[module.constructor.key]);
    module.initModule(moduleOptions);

    // Now save the module instance.
    const _modules = this.get("_modules");
    _modules[module.constructor.key] = module;
  },

  update(options) {
    // Save old options.
    const oldHide = this.get("hide");
    const oldIcon = this.get("icon");

    this.set(options);

    // Run the modules.
    this.runModules('update');

    // Update the timed hiding.
    if (!this.get("hide")) {
      this.cancelClose();
    } else if (!oldHide) {
      this.queueClose();
    }
    this.queuePosition();

    // Font Awesome 5 replaces our lovely element with a gross SVG. In order
    // to make it play nice with Svelte, we have to clear the element and
    // make it again.
    const icon = this.get("icon");
    if (
        icon !== oldIcon
        && (
          (icon === true && this.get("icons") === "fontawesome5")
          || (typeof icon === "string" && icon.match(/(^| )fa[srlb]($| )/))
        )
      ) {
      this.set({"icon": false});
      this.set({"icon": icon});
    }

    return this;
  },

  // Display the notice.
  open() {
    if (this.get("_state") === "opening") {
      return;
    }
    if (this.get("_state") === "open") {
      if (this.get("hide")) {
        this.queueClose();
      }
      return;
    }
    this.set({
      "_state": "opening",
      // This makes the notice visibity: hidden; so its dimensions can be
      // determined.
      "_animatingClass": "ui-pnotify-initial-hidden"
    });
    // Run the modules.
    this.runModules('beforeOpen');

    let stack = this.get("stack");
    // If the notice is not in the DOM, or in the wrong context, append it.
    if (
        !this.refs.elem.parentNode
        || (
          stack
          && stack.context
          && stack.context !== this.refs.elem.parentNode
        )
      ) {
      if (stack && stack.context) {
        stack.context.appendChild(this.refs.elem);
      } else if (document.body) {
        document.body.appendChild(this.refs.elem);
      } else {
        throw new Error("No context to open this notice in.");
      }
    }

    // Wait until the DOM is updated.
    setTimeout(() => {
      if (stack) {
        // Mark the stack so it won't animate the new notice.
        stack.animation = false;
        // Now position all the notices.
        PNotify.positionAll();
        // Reset animation.
        stack.animation = true;
      }

      this.animateIn(() => {
        // Now set it to hide.
        if (this.get("hide")) {
          this.queueClose();
        }

        this.set({"_state": "open"});

        // Run the modules.
        this.runModules('afterOpen');
      });
    }, 0);

    return this;
  },

  remove(timerHide) {
    return this.close(timerHide);
  },

  // Remove the notice.
  close(timerHide) {
    if (this.get("_state") === "closing" || this.get("_state") === "closed") {
      return;
    }
    this.set({"_state": "closing", "_timerHide": !!timerHide}); // Make sure it's a boolean.
    // Run the modules.
    this.runModules('beforeClose');

    if (this.get("_timer") && clearTimeout) {
      clearTimeout(this.get("_timer"));
      this.set({"_timer": null});
    }
    this.animateOut(() => {
      this.set({"_state": "closed"});
      // Run the modules.
      this.runModules('afterClose');
      this.queuePosition();
      // If we're supposed to remove the notice from the DOM, do it.
      if (this.get("remove")) {
        this.refs.elem.parentNode.removeChild(this.refs.elem);
      }
      // Run the modules.
      this.runModules('beforeDestroy');
      // Remove object from PNotify.notices to prevent memory leak (issue #49)
      // unless destroy is off
      if (this.get("destroy")) {
        if (PNotify.notices !== null) {
          const idx = PNotify.notices.indexOf(this);
          if (idx !== -1) {
            PNotify.notices.splice(idx, 1);
          }
        }
      }
      // Run the modules.
      this.runModules('afterDestroy');
    });

    return this;
  },

  // Animate the notice in.
  animateIn(callback) {
    // Declare that the notice is animating in.
    this.set({"_animating": "in"});
    const finished = () => {
      this.refs.elem.removeEventListener('transitionend', finished);
      if (this.get("_animTimer")) {
        clearTimeout(this.get("_animTimer"));
      }
      if (this.get("_animating") !== "in") {
        return;
      }
      let visible = this.get("_moduleIsNoticeOpen");
      if (!visible) {
        const domRect = this.refs.elem.getBoundingClientRect();
        for (let prop in domRect) {
          if (domRect[prop] > 0) {
            visible = true;
            break;
          }
        }
      }
      if (visible) {
        if (callback) {
          callback.call();
        }
        // Declare that the notice has completed animating.
        this.set({"_animating": false});
      } else {
        this.set({"_animTimer": setTimeout(finished, 40)});
      }
    };

    if (this.get("animation") === "fade") {
      this.refs.elem.addEventListener('transitionend', finished);
      this.set({"_animatingClass": "ui-pnotify-in"});
      this.refs.elem.style.opacity; // This line is necessary for some reason. Some notices don't fade without it.
      this.set({"_animatingClass": "ui-pnotify-in ui-pnotify-fade-in"});
      // Just in case the event doesn't fire, call it after 650 ms.
      this.set({"_animTimer": setTimeout(finished, 650)});
    } else {
      this.set({"_animatingClass": "ui-pnotify-in"});
      finished();
    }
  },

  // Animate the notice out.
  animateOut(callback) {
    // Declare that the notice is animating out.
    this.set({"_animating": "out"});
    const finished = () => {
      this.refs.elem.removeEventListener('transitionend', finished);
      if (this.get("_animTimer")) {
        clearTimeout(this.get("_animTimer"));
      }
      if (this.get("_animating") !== "out") {
        return;
      }
      let visible = this.get("_moduleIsNoticeOpen");
      if (!visible) {
        const domRect = this.refs.elem.getBoundingClientRect();
        for (let prop in domRect) {
          if (domRect[prop] > 0) {
            visible = true;
            break;
          }
        }
      }
      if (!this.refs.elem.style.opacity || this.refs.elem.style.opacity == "0" || !visible) {
        this.set({"_animatingClass": ""});
        const stack = this.get("stack");
        if (stack && stack.overlay) {
          // Go through the modal stack to see if any are left open.
          // TODO: Rewrite this cause it sucks.
          let stillOpen = false;
          for (let i = 0; i < PNotify.notices.length; i++) {
            const notice = PNotify.notices[i];
            if (notice != this && notice.get("stack") === stack && notice.get("_state") !== "closed") {
              stillOpen = true;
              break;
            }
          }
          if (!stillOpen) {
            removeStackOverlay(stack);
          }
        }
        if (callback) {
          callback.call();
        }
        // Declare that the notice has completed animating.
        this.set({"_animating": false});
      } else {
        // In case this was called before the notice finished animating.
        this.set({"_animTimer": setTimeout(finished, 40)});
      }
    };

    if (this.get("animation") === "fade") {
      this.refs.elem.addEventListener('transitionend', finished);
      this.set({"_animatingClass": "ui-pnotify-in"});
      // Just in case the event doesn't fire, call it after 650 ms.
      this.set({"_animTimer": setTimeout(finished, 650)});
    } else {
      this.set({"_animatingClass": ""});
      finished();
    }
  },

  // Position the notice.
  position() {
    // Get the notice's stack.
    let stack = this.get("stack"),
        elem = this.refs.elem;
    if (!stack) {
      return;
    }
    if (!stack.context) {
      stack.context = document.body;
    }
    if (typeof stack.nextpos1 !== "number") {
      stack.nextpos1 = stack.firstpos1;
    }
    if (typeof stack.nextpos2 !== "number") {
      stack.nextpos2 = stack.firstpos2;
    }
    if (typeof stack.addpos2 !== "number") {
      stack.addpos2 = 0;
    }

    // Skip this notice if it's not shown.
    if (
        !elem.classList.contains("ui-pnotify-in")
        && !elem.classList.contains("ui-pnotify-initial-hidden")
      ) {
      return this;
    }

    if (stack.modal) {
      if (!stack.overlay) {
        createStackOverlay(stack);
      }
      insertStackOverlay(stack);
    }

    // Read from the DOM to cause refresh.
    const domRect = elem.getBoundingClientRect();

    if (stack.animation) {
      // Add animate class.
      this.set({"_moveClass": "ui-pnotify-move"});
    }

    let spaceY = (stack.context === document.body ? window.innerHeight : stack.context.scrollHeight),
        spaceX = (stack.context === document.body ? window.innerWidth : stack.context.scrollWidth);

    let csspos1;

    if (stack.dir1) {
      csspos1 = {
        "down": "top",
        "up": "bottom",
        "left": "right",
        "right": "left"
      }[stack.dir1];

      // Calculate the current pos1 value.
      let curpos1;
      switch (stack.dir1) {
        case "down":
          curpos1 = elem.offsetTop;
          break;
        case "up":
          curpos1 = spaceY - elem.scrollHeight - elem.offsetTop;
          break;
        case "left":
          curpos1 = spaceX - elem.scrollWidth - elem.offsetLeft;
          break;
        case "right":
          curpos1 = elem.offsetLeft;
          break;
      }
      // Remember the first pos1, so the first notice goes there.
      if (typeof stack.firstpos1 === "undefined") {
        stack.firstpos1 = curpos1;
        stack.nextpos1 = stack.firstpos1;
      }
    }

    if (stack.dir1 && stack.dir2) {
      let csspos2 = {
        "down": "top",
        "up": "bottom",
        "left": "right",
        "right": "left"
      }[stack.dir2];

      // Calculate the current pos2 value.
      let curpos2;
      switch (stack.dir2) {
        case "down":
          curpos2 = elem.offsetTop;
          break;
        case "up":
          curpos2 = spaceY - elem.scrollHeight - elem.offsetTop;
          break;
        case "left":
          curpos2 = spaceX - elem.scrollWidth - elem.offsetLeft;
          break;
        case "right":
          curpos2 = elem.offsetLeft;
          break;
      }
      // Remember the first pos2, so the first notice goes there.
      if (typeof stack.firstpos2 === "undefined") {
        stack.firstpos2 = curpos2;
        stack.nextpos2 = stack.firstpos2;
      }

      // Check that it's not beyond the viewport edge.
      const endY = stack.nextpos1 + elem.offsetHeight + (typeof stack.spacing1 === "undefined" ? 25 : stack.spacing1),
            endX = stack.nextpos1 + elem.offsetWidth + (typeof stack.spacing1 === "undefined" ? 25 : stack.spacing1);
      if (
          ((stack.dir1 === "down" || stack.dir1 === "up") && endY > spaceY)
          || ((stack.dir1 === "left" || stack.dir1 === "right") && endX > spaceX)
        ) {
        // If it is, it needs to go back to the first pos1, and over on pos2.
        stack.nextpos1 = stack.firstpos1;
        stack.nextpos2 += stack.addpos2 + (typeof stack.spacing2 === "undefined" ? 25 : stack.spacing2);
        stack.addpos2 = 0;
      }

      // Move the notice on dir2.
      if (typeof stack.nextpos2 === "number") {
        elem.style[csspos2] = stack.nextpos2+"px";
        if (!stack.animation) {
          elem.style[csspos2]; // Read from the DOM for update.
        }
      }

      // Keep track of the widest/tallest notice in the column/row, so we can push the next column/row.
      switch (stack.dir2) {
        case "down":
        case "up":
          if (elem.offsetHeight + (parseFloat(elem.style.marginTop, 10) || 0) + (parseFloat(elem.style.marginBottom, 10) || 0) > stack.addpos2) {
            stack.addpos2 = elem.offsetHeight;
          }
          break;
        case "left":
        case "right":
          if (elem.offsetWidth + (parseFloat(elem.style.marginLeft, 10) || 0) + (parseFloat(elem.style.marginRight, 10) || 0) > stack.addpos2) {
            stack.addpos2 = elem.offsetWidth;
          }
          break;
      }
    } else if (stack.dir1) {
      // Center the notice along dir1 axis, because the stack has no dir2.
      let cssMiddle, cssposCross;
      switch (stack.dir1) {
        case "down":
        case "up":
          cssposCross = ["left", "right"];
          cssMiddle = (stack.context.scrollWidth / 2) - (elem.offsetWidth / 2);
          break;
        case "left":
        case "right":
          cssposCross = ["top", "bottom"];
          cssMiddle = (spaceY / 2) - (elem.offsetHeight / 2);
          break;
      }
      elem.style[cssposCross[0]] = cssMiddle+"px";
      elem.style[cssposCross[1]] = "auto";
      if (!stack.animation) {
        elem.style[cssposCross[0]]; // Read from the DOM for update.
      }
    }

    if (stack.dir1) {
      // Move the notice on dir1.
      if (typeof stack.nextpos1 === "number") {
        elem.style[csspos1] = stack.nextpos1+"px";
        if (!stack.animation) {
          elem.style[csspos1]; // Read from the DOM for update.
        }
      }

      // Calculate the next dir1 position.
      switch (stack.dir1) {
        case "down":
        case "up":
          stack.nextpos1 += elem.offsetHeight + (typeof stack.spacing1 === "undefined" ? 25 : stack.spacing1);
          break;
        case "left":
        case "right":
          stack.nextpos1 += elem.offsetWidth + (typeof stack.spacing1 === "undefined" ? 25 : stack.spacing1);
          break;
      }
    } else {
      // Center the notice on the screen, because the stack has no dir1.
      let cssMiddleLeft = (spaceX / 2) - (elem.offsetWidth / 2),
          cssMiddleTop = (spaceY / 2) - (elem.offsetHeight / 2);
      elem.style.left = cssMiddleLeft+"px";
      elem.style.top = cssMiddleTop+"px";
      if (!stack.animation) {
        elem.style.left; // Read from the DOM for update.
      }
    }

    return this;
  },

  // Queue the position all function so it doesn't run repeatedly and
  // use up resources.
  queuePosition(milliseconds) {
    if (posTimer) {
      clearTimeout(posTimer);
    }
    if (!milliseconds) {
      milliseconds = 10;
    }
    posTimer = setTimeout(() => {
      PNotify.positionAll();
    }, milliseconds);
    return this;
  },

  cancelRemove() {
    return this.cancelClose();
  },

  // Cancel any pending removal timer.
  cancelClose() {
    if (this.get("_timer")) {
      clearTimeout(this.get("_timer"));
    }
    if (this.get("_animTimer")) {
      clearTimeout(this.get("_animTimer"));
    }
    if (this.get("_state") === "closing") {
      // If it's animating out, stop it.
      this.set({
        "_state": "open",
        "_animating": false,
        "_animatingClass": this.get("animation") === "fade" ? "ui-pnotify-in ui-pnotify-fade-in" : "ui-pnotify-in"
      });
    }
    return this;
  },

  queueRemove() {
    return this.queueClose();
  },

  // Queue a close timer.
  queueClose() {
    // Cancel any current close timer.
    this.cancelClose();
    this.set({
      "_timer": setTimeout(() => this.close(true), (isNaN(this.get("delay")) ? 0 : this.get("delay")))
    });
    return this;
  },

  addModuleClass(...classNames) {
    const moduleClasses = this.get("_moduleClasses");
    for (let i = 0; i < classNames.length; i++) {
      let className = classNames[i];
      if (moduleClasses.indexOf(className) === -1) {
        moduleClasses.push(className);
      }
    }
    this.set({"_moduleClasses": moduleClasses});
  },

  removeModuleClass(...classNames) {
    const moduleClasses = this.get("_moduleClasses");
    for (let i = 0; i < classNames.length; i++) {
      let className = classNames[i];
      const idx = moduleClasses.indexOf(className);
      if (idx !== -1) {
        moduleClasses.splice(idx, 1);
      }
    }
    this.set({"_moduleClasses": moduleClasses});
  },

  hasModuleClass(...classNames) {
    const moduleClasses = this.get("_moduleClasses");
    for (let i = 0; i < classNames.length; i++) {
      let className = classNames[i];
      if (moduleClasses.indexOf(className) === -1) {
        return false;
      }
    }
    return true;
  }
};

function oncreate() {
  this.on("mouseenter", (e) => {
    // Stop animation, reset the removal timer when the user mouses over.
    if (this.get("mouseReset") && this.get("_animating") === "out") {
      if (!this.get("_timerHide")) {
        return;
      }
      this.cancelClose();
    }
    // Stop the close timer.
    if (this.get("hide") && this.get("mouseReset")) {
      this.cancelClose();
    }
  });

  this.on("mouseleave", (e) => {
    // Start the close timer.
    if (this.get("hide") && this.get("mouseReset") && this.get("_animating") !== "out") {
      this.queueClose();
    }
    PNotify.positionAll();
  });

  let stack = this.get("stack");

  // Add the notice to the notice array.
  if (stack && stack.push === "top") {
    PNotify.notices.splice(0, 0, this);
  } else {
    PNotify.notices.push(this);
  }

  // Run the modules.
  this.runModules('init');

  // We're now initialized, but haven't been opened yet.
  this.set({"_state": "closed"});

  // Display the notice.
  if (this.get("autoDisplay")) {
    this.open();
  }
};

function setup(Component) {
  // Add static properties to the PNotify object.
  PNotify = Component;

  PNotify.VERSION = "4.0.0-alpha.2";

  PNotify.defaultStack = {
    dir1: "down",
    dir2: "left",
    firstpos1: 25,
    firstpos2: 25,
    spacing1: 36,
    spacing2: 36,
    push: "bottom",
    context: window && document.body
  };

  PNotify.defaults = {
    // The notice's title.
    title: false,
    // Whether to trust the title or escape its contents. (Not allow HTML.)
    titleTrusted: false,
    // The notice's text.
    text: false,
    // Whether to trust the text or escape its contents. (Not allow HTML.)
    textTrusted: false,
    // What styling classes to use. (Can be "brighttheme", "bootstrap3", "bootstrap4", or a styling object.)
    styling: "brighttheme",
    // What icons to use (Can be "brighttheme", "bootstrap3", "fontawesome4", "fontawesome5", or an icon object.)
    icons: "brighttheme",
    // Additional classes to be added to the notice. (For custom styling.)
    addClass: "",
    // Class to be added to the notice for corner styling.
    cornerClass: "",
    // Display the notice when it is created.
    autoDisplay: true,
    // Width of the notice.
    width: "360px",
    // Minimum height of the notice. It will expand to fit content.
    minHeight: "16px",
    // Type of the notice. "notice", "info", "success", or "error".
    type: "notice",
    // Set icon to true to use the default icon for the selected
    // style/type, false for no icon, or a string for your own icon class.
    icon: true,
    // The animation to use when displaying and hiding the notice. "none"
    // and "fade" are supported through CSS. Others are supported
    // through the Animate module and Animate.css.
    animation: "fade",
    // Speed at which the notice animates in and out. "slow", "normal",
    // or "fast". Respectively, 400ms, 250ms, 100ms.
    animateSpeed: "normal",
    // Display a drop shadow.
    shadow: true,
    // After a delay, remove the notice.
    hide: true,
    // Delay in milliseconds before the notice is removed.
    delay: 8000,
    // Reset the hide timer if the mouse moves over the notice.
    mouseReset: true,
    // Remove the notice's elements from the DOM after it is removed.
    remove: true,
    // Whether to remove the notice from the global array when it is closed.
    destroy: true,
    // The stack on which the notices will be placed. Also controls the
    // direction the notices stack.
    stack: PNotify.defaultStack,
    // This is where options for modules should be defined.
    modules: {}
  };

  // An array of all active notices.
  PNotify.notices = [];

  // This object holds all the PNotify modules. They are used to provide
  // additional functionality.
  PNotify.modules = {};

  // Modules can add themselves to these to be rendered in the template.
  PNotify.modulesPrependContainer = [];
  PNotify.modulesAppendContainer = [];

  // Helper function to create a new notice.
  PNotify.alert = (options) => new PNotify(getDefaultArgs(options));
  // Helper function to create a new notice (notice type).
  PNotify.notice = (options) => new PNotify(getDefaultArgs(options, "notice"));
  // Helper function to create a new notice (info type).
  PNotify.info = (options) => new PNotify(getDefaultArgs(options, "info"));
  // Helper function to create a new notice (success type).
  PNotify.success = (options) => new PNotify(getDefaultArgs(options, "success"));
  // Helper function to create a new notice (error type).
  PNotify.error = (options) => new PNotify(getDefaultArgs(options, "error"));

  PNotify.removeAll = () => {
    PNotify.closeAll();
  };

  // Close all notices.
  PNotify.closeAll = () => {
    for (let i = 0; i < PNotify.notices.length; i++) {
      if (PNotify.notices[i].close) {
        PNotify.notices[i].close(false);
      }
    }
  };

  PNotify.removeStack = (stack) => {
    PNotify.closeStack(stack);
  };

  // Close all notices in a single stack.
  PNotify.closeStack = (stack) => {
    if (stack === false) {
      return;
    }
    for (let i = 0; i < PNotify.notices.length; i++) {
      if (PNotify.notices[i].close && PNotify.notices[i].get("stack") === stack) {
        PNotify.notices[i].close(false);
      }
    }
  };

  // Position all notices.
  PNotify.positionAll = () => {
    // This timer is used for queueing this function so it doesn't run
    // repeatedly.
    if (posTimer) {
      clearTimeout(posTimer);
    }
    posTimer = null;
    // Reset the next position data.
    if (PNotify.notices.length > 0) {
      for (let i = 0; i < PNotify.notices.length; i++) {
        let notice = PNotify.notices[i],
            s = notice.get("stack");
        if (!s) {
          continue;
        }
        if (s.overlay) {
          removeStackOverlay(s);
        }
        s.nextpos1 = s.firstpos1;
        s.nextpos2 = s.firstpos2;
        s.addpos2 = 0;
      }
      for (let i = 0; i < PNotify.notices.length; i++) {
        PNotify.notices[i].position();
      }
    } else {
      delete PNotify.defaultStack.nextpos1;
      delete PNotify.defaultStack.nextpos2;
    }
  };

  PNotify.styling = {
    brighttheme: {
      // Bright Theme doesn't require any UI libraries.
      container: "brighttheme",
      notice: "brighttheme-notice",
      info: "brighttheme-info",
      success: "brighttheme-success",
      error: "brighttheme-error"
    },
    bootstrap3: {
      container: "alert",
      notice: "alert-warning",
      info: "alert-info",
      success: "alert-success",
      error: "alert-danger",
      icon: "ui-pnotify-icon-bs3"
    },
    bootstrap4: {
      container: "alert",
      notice: "alert-warning",
      info: "alert-info",
      success: "alert-success",
      error: "alert-danger",
      icon: "ui-pnotify-icon-bs4",
      title: "ui-pnotify-title-bs4"
    }
  };

  // icons are separate from the style, since bs4 doesn't come with any
  PNotify.icons = {
      brighttheme: {
        notice: "brighttheme-icon-notice",
        info: "brighttheme-icon-info",
        success: "brighttheme-icon-success",
        error: "brighttheme-icon-error"
      },
      bootstrap3: {
        notice: "glyphicon glyphicon-exclamation-sign",
        info: "glyphicon glyphicon-info-sign",
        success: "glyphicon glyphicon-ok-sign",
        error: "glyphicon glyphicon-warning-sign"
      },
      // User must have Font Awesome v4.0+
      fontawesome4: {
        notice: "fa fa-exclamation-circle",
        info: "fa fa-info-circle",
        success: "fa fa-check-circle",
        error: "fa fa-exclamation-triangle"
      },
      // User must have Font Awesome v5.0+
      fontawesome5: {
        notice: "fas fa-exclamation-circle",
        info: "fas fa-info-circle",
        success: "fas fa-check-circle",
        error: "fas fa-exclamation-triangle"
      }
  }

  // Run the deferred actions once the DOM is ready.
  if (window && document.body) {
    onDocumentLoaded();
  } else {
    document.addEventListener("DOMContentLoaded", onDocumentLoaded);
  }
}

function add_css() {
	var style = createElement("style");
	style.id = 'svelte-3059224252-style';
	style.textContent = "body > .ui-pnotify{position:fixed;z-index:100040}body > .ui-pnotify.ui-pnotify-modal{z-index:100042}.ui-pnotify{position:absolute;height:auto;z-index:1;display:none}.ui-pnotify.ui-pnotify-modal{z-index:3}.ui-pnotify.ui-pnotify-in{display:block}.ui-pnotify.ui-pnotify-initial-hidden{display:block;visibility:hidden}.ui-pnotify.ui-pnotify-move{transition:left .5s ease, top .5s ease, right .5s ease, bottom .5s ease}.ui-pnotify.ui-pnotify-fade-slow{transition:opacity .4s linear;opacity:0}.ui-pnotify.ui-pnotify-fade-slow.ui-pnotify.ui-pnotify-move{transition:opacity .4s linear, left .5s ease, top .5s ease, right .5s ease, bottom .5s ease}.ui-pnotify.ui-pnotify-fade-normal{transition:opacity .25s linear;opacity:0}.ui-pnotify.ui-pnotify-fade-normal.ui-pnotify.ui-pnotify-move{transition:opacity .25s linear, left .5s ease, top .5s ease, right .5s ease, bottom .5s ease}.ui-pnotify.ui-pnotify-fade-fast{transition:opacity .1s linear;opacity:0}.ui-pnotify.ui-pnotify-fade-fast.ui-pnotify.ui-pnotify-move{transition:opacity .1s linear, left .5s ease, top .5s ease, right .5s ease, bottom .5s ease}.ui-pnotify.ui-pnotify-fade-in{opacity:1}.ui-pnotify .ui-pnotify-shadow{-webkit-box-shadow:0px 6px 28px 0px rgba(0,0,0,0.1);-moz-box-shadow:0px 6px 28px 0px rgba(0,0,0,0.1);box-shadow:0px 6px 28px 0px rgba(0,0,0,0.1)}.ui-pnotify-container{background-position:0 0;padding:.8em;height:100%;margin:0}.ui-pnotify-container:after{content:\" \";visibility:hidden;display:block;height:0;clear:both}.ui-pnotify-container.ui-pnotify-sharp{-webkit-border-radius:0;-moz-border-radius:0;border-radius:0}.ui-pnotify-title{display:block;white-space:pre-line;margin-bottom:.4em;margin-top:0}.ui-pnotify.ui-pnotify-with-icon .ui-pnotify-title,.ui-pnotify.ui-pnotify-with-icon .ui-pnotify-text{margin-left:24px}[dir=rtl] .ui-pnotify.ui-pnotify-with-icon .ui-pnotify-title,[dir=rtl] .ui-pnotify.ui-pnotify-with-icon .ui-pnotify-text{margin-right:24px;margin-left:0}.ui-pnotify-title-bs4{font-size:1.2rem}.ui-pnotify-text{display:block;white-space:pre-line}.ui-pnotify-icon,.ui-pnotify-icon span{display:block;float:left}[dir=rtl] .ui-pnotify-icon,[dir=rtl] .ui-pnotify-icon span{float:right}.ui-pnotify-icon-bs3 > span{position:relative;top:2px}.ui-pnotify-icon-bs4 > span{position:relative;top:4px}.ui-pnotify-modal-overlay{background-color:rgba(0, 0, 0, .4);top:0;left:0;position:absolute;height:100%;width:100%;z-index:2}body > .ui-pnotify-modal-overlay{position:fixed;z-index:100041}";
	appendNode(style, document.head);
}

function create_main_fragment(state, component) {
	var div, div_1, text, text_1, h4, h4_class_value, text_3, div_2, div_2_class_value, text_5, div_1_class_value, div_1_style_value, div_class_value;

	var _modulesPrependContainer = state._modulesPrependContainer;

	var each_blocks = [];

	for (var i = 0; i < _modulesPrependContainer.length; i += 1) {
		each_blocks[i] = create_each_block(state, _modulesPrependContainer, _modulesPrependContainer[i], i, component);
	}

	var if_block = (state.icon !== false) && create_if_block(state, component);

	var current_block_type = select_block_type(state);
	var if_block_1 = current_block_type(state, component);

	var current_block_type_1 = select_block_type_1(state);
	var if_block_2 = current_block_type_1(state, component);

	var _modulesAppendContainer = state._modulesAppendContainer;

	var each_1_blocks = [];

	for (var i = 0; i < _modulesAppendContainer.length; i += 1) {
		each_1_blocks[i] = create_each_block_1(state, _modulesAppendContainer, _modulesAppendContainer[i], i, component);
	}

	function mouseover_handler(event) {
		component.fire('mouseover', event);
	}

	function mouseout_handler(event) {
		component.fire('mouseout', event);
	}

	function mouseenter_handler(event) {
		component.fire('mouseenter', event);
	}

	function mouseleave_handler(event) {
		component.fire('mouseleave', event);
	}

	function mousemove_handler(event) {
		component.fire('mousemove', event);
	}

	function mousedown_handler(event) {
		component.fire('mousedown', event);
	}

	function mouseup_handler(event) {
		component.fire('mouseup', event);
	}

	function click_handler(event) {
		component.fire('click', event);
	}

	function dblclick_handler(event) {
		component.fire('dblclick', event);
	}

	function focus_handler(event) {
		component.fire('focus', event);
	}

	function blur_handler(event) {
		component.fire('blur', event);
	}

	function touchstart_handler(event) {
		component.fire('touchstart', event);
	}

	function touchmove_handler(event) {
		component.fire('touchmove', event);
	}

	function touchend_handler(event) {
		component.fire('touchend', event);
	}

	function touchcancel_handler(event) {
		component.fire('touchcancel', event);
	}

	return {
		c: function create() {
			div = createElement("div");
			div_1 = createElement("div");

			for (var i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			text = createText("\n    ");
			if (if_block) if_block.c();
			text_1 = createText("\n    ");
			h4 = createElement("h4");
			if_block_1.c();
			text_3 = createText("\n    ");
			div_2 = createElement("div");
			if_block_2.c();
			text_5 = createText("\n    ");

			for (var i = 0; i < each_1_blocks.length; i += 1) {
				each_1_blocks[i].c();
			}
			this.h();
		},

		h: function hydrate() {
			h4.className = h4_class_value = "ui-pnotify-title " + (state._styles.title ? state._styles.title : '');
			setStyle(h4, "display", ( state.title === false ? 'none' : 'block' ));
			div_2.className = div_2_class_value = "ui-pnotify-text " + (state._styles.text ? state._styles.text : '');
			setStyle(div_2, "display", ( state.text === false ? 'none' : 'block' ));
			setAttribute(div_2, "role", "alert");
			div_1.className = div_1_class_value = "\n        ui-pnotify-container\n        " + (state._styles.container ? state._styles.container : '') + "\n        " + (state._styles[state.type] ? state._styles[state.type] : '') + "\n        " + state.cornerClass + "\n        " + (state.shadow ? 'ui-pnotify-shadow' : '') + "\n      ";
			div_1.style.cssText = div_1_style_value = "\n        " + (typeof state.width === 'string' ? 'width: '+state.width+';' : '') + "\n        " + (typeof state.minHeight === 'string' ? 'min-height: '+state.minHeight+';' : '') + "\n      ";
			setAttribute(div_1, "role", "alert");
			div.className = div_class_value = "\n      ui-pnotify\n      " + (state.icon !== false ? 'ui-pnotify-with-icon' : '') + "\n      " + (state._styles.element ? state._styles.element : '') + "\n      " + state.addClass + "\n      " + state._animatingClass + "\n      " + state._moveClass + "\n      " + (state.animation === 'fade' ? 'ui-pnotify-fade-'+state.animateSpeed : '') + "\n      " + (state.stack && state.stack.modal ? 'ui-pnotify-modal' : '') + "\n      " + state._moduleClasses.join(' ') + "\n    ";
			setAttribute(div, "aria-live", "assertive");
			setAttribute(div, "role", "alertdialog");
			setAttribute(div, "ui-pnotify", true);
			addListener(div, "mouseover", mouseover_handler);
			addListener(div, "mouseout", mouseout_handler);
			addListener(div, "mouseenter", mouseenter_handler);
			addListener(div, "mouseleave", mouseleave_handler);
			addListener(div, "mousemove", mousemove_handler);
			addListener(div, "mousedown", mousedown_handler);
			addListener(div, "mouseup", mouseup_handler);
			addListener(div, "click", click_handler);
			addListener(div, "dblclick", dblclick_handler);
			addListener(div, "focus", focus_handler);
			addListener(div, "blur", blur_handler);
			addListener(div, "touchstart", touchstart_handler);
			addListener(div, "touchmove", touchmove_handler);
			addListener(div, "touchend", touchend_handler);
			addListener(div, "touchcancel", touchcancel_handler);
		},

		m: function mount(target, anchor) {
			insertNode(div, target, anchor);
			appendNode(div_1, div);

			for (var i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div_1, null);
			}

			appendNode(text, div_1);
			if (if_block) if_block.m(div_1, null);
			appendNode(text_1, div_1);
			appendNode(h4, div_1);
			if_block_1.m(h4, null);
			component.refs.titleContainer = h4;
			appendNode(text_3, div_1);
			appendNode(div_2, div_1);
			if_block_2.m(div_2, null);
			component.refs.textContainer = div_2;
			appendNode(text_5, div_1);

			for (var i = 0; i < each_1_blocks.length; i += 1) {
				each_1_blocks[i].m(div_1, null);
			}

			component.refs.container = div_1;
			component.refs.elem = div;
		},

		p: function update(changed, state) {
			var _modulesPrependContainer = state._modulesPrependContainer;

			if (changed._modulesPrependContainer) {
				for (var i = each_blocks.length; i < _modulesPrependContainer.length; i += 1) {
					each_blocks[i] = create_each_block(state, _modulesPrependContainer, _modulesPrependContainer[i], i, component);
					each_blocks[i].c();
					each_blocks[i].m(div_1, text);
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].u();
					each_blocks[i].d();
				}
				each_blocks.length = _modulesPrependContainer.length;
			}

			if (state.icon !== false) {
				if (if_block) {
					if_block.p(changed, state);
				} else {
					if_block = create_if_block(state, component);
					if_block.c();
					if_block.m(div_1, text_1);
				}
			} else if (if_block) {
				if_block.u();
				if_block.d();
				if_block = null;
			}

			if (current_block_type === (current_block_type = select_block_type(state)) && if_block_1) {
				if_block_1.p(changed, state);
			} else {
				if_block_1.u();
				if_block_1.d();
				if_block_1 = current_block_type(state, component);
				if_block_1.c();
				if_block_1.m(h4, null);
			}

			if ((changed._styles) && h4_class_value !== (h4_class_value = "ui-pnotify-title " + (state._styles.title ? state._styles.title : ''))) {
				h4.className = h4_class_value;
			}

			if (changed.title) {
				setStyle(h4, "display", ( state.title === false ? 'none' : 'block' ));
			}

			if (current_block_type_1 === (current_block_type_1 = select_block_type_1(state)) && if_block_2) {
				if_block_2.p(changed, state);
			} else {
				if_block_2.u();
				if_block_2.d();
				if_block_2 = current_block_type_1(state, component);
				if_block_2.c();
				if_block_2.m(div_2, null);
			}

			if ((changed._styles) && div_2_class_value !== (div_2_class_value = "ui-pnotify-text " + (state._styles.text ? state._styles.text : ''))) {
				div_2.className = div_2_class_value;
			}

			if (changed.text) {
				setStyle(div_2, "display", ( state.text === false ? 'none' : 'block' ));
			}

			var _modulesAppendContainer = state._modulesAppendContainer;

			if (changed._modulesAppendContainer) {
				for (var i = each_1_blocks.length; i < _modulesAppendContainer.length; i += 1) {
					each_1_blocks[i] = create_each_block_1(state, _modulesAppendContainer, _modulesAppendContainer[i], i, component);
					each_1_blocks[i].c();
					each_1_blocks[i].m(div_1, null);
				}

				for (; i < each_1_blocks.length; i += 1) {
					each_1_blocks[i].u();
					each_1_blocks[i].d();
				}
				each_1_blocks.length = _modulesAppendContainer.length;
			}

			if ((changed._styles || changed.type || changed.cornerClass || changed.shadow) && div_1_class_value !== (div_1_class_value = "\n        ui-pnotify-container\n        " + (state._styles.container ? state._styles.container : '') + "\n        " + (state._styles[state.type] ? state._styles[state.type] : '') + "\n        " + state.cornerClass + "\n        " + (state.shadow ? 'ui-pnotify-shadow' : '') + "\n      ")) {
				div_1.className = div_1_class_value;
			}

			if ((changed.width || changed.minHeight) && div_1_style_value !== (div_1_style_value = "\n        " + (typeof state.width === 'string' ? 'width: '+state.width+';' : '') + "\n        " + (typeof state.minHeight === 'string' ? 'min-height: '+state.minHeight+';' : '') + "\n      ")) {
				div_1.style.cssText = div_1_style_value;
			}

			if ((changed.icon || changed._styles || changed.addClass || changed._animatingClass || changed._moveClass || changed.animation || changed.animateSpeed || changed.stack || changed._moduleClasses) && div_class_value !== (div_class_value = "\n      ui-pnotify\n      " + (state.icon !== false ? 'ui-pnotify-with-icon' : '') + "\n      " + (state._styles.element ? state._styles.element : '') + "\n      " + state.addClass + "\n      " + state._animatingClass + "\n      " + state._moveClass + "\n      " + (state.animation === 'fade' ? 'ui-pnotify-fade-'+state.animateSpeed : '') + "\n      " + (state.stack && state.stack.modal ? 'ui-pnotify-modal' : '') + "\n      " + state._moduleClasses.join(' ') + "\n    ")) {
				div.className = div_class_value;
			}
		},

		u: function unmount() {
			detachNode(div);

			for (var i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].u();
			}

			if (if_block) if_block.u();
			if_block_1.u();
			if_block_2.u();

			for (var i = 0; i < each_1_blocks.length; i += 1) {
				each_1_blocks[i].u();
			}
		},

		d: function destroy() {
			destroyEach(each_blocks);

			if (if_block) if_block.d();
			if_block_1.d();
			if (component.refs.titleContainer === h4) component.refs.titleContainer = null;
			if_block_2.d();
			if (component.refs.textContainer === div_2) component.refs.textContainer = null;

			destroyEach(each_1_blocks);

			if (component.refs.container === div_1) component.refs.container = null;
			removeListener(div, "mouseover", mouseover_handler);
			removeListener(div, "mouseout", mouseout_handler);
			removeListener(div, "mouseenter", mouseenter_handler);
			removeListener(div, "mouseleave", mouseleave_handler);
			removeListener(div, "mousemove", mousemove_handler);
			removeListener(div, "mousedown", mousedown_handler);
			removeListener(div, "mouseup", mouseup_handler);
			removeListener(div, "click", click_handler);
			removeListener(div, "dblclick", dblclick_handler);
			removeListener(div, "focus", focus_handler);
			removeListener(div, "blur", blur_handler);
			removeListener(div, "touchstart", touchstart_handler);
			removeListener(div, "touchmove", touchmove_handler);
			removeListener(div, "touchend", touchend_handler);
			removeListener(div, "touchcancel", touchcancel_handler);
			if (component.refs.elem === div) component.refs.elem = null;
		}
	};
}

// (56:4) {{#each _modulesPrependContainer as module}}
function create_each_block(state, _modulesPrependContainer, module, module_index, component) {
	var switch_instance_anchor;

	var switch_value = module;

	function switch_props(state, _modulesPrependContainer, module, module_index) {
		return {
			root: component.root
		};
	}

	if (switch_value) {
		var switch_instance = new switch_value(switch_props(state, _modulesPrependContainer, module, module_index));
	}

	function switch_instance_init(event) {
		component.initModule(event.module);
	}

	if (switch_instance) switch_instance.on("init", switch_instance_init);

	return {
		c: function create() {
			switch_instance_anchor = createComment();
			if (switch_instance) switch_instance._fragment.c();
		},

		m: function mount(target, anchor) {
			insertNode(switch_instance_anchor, target, anchor);
			if (switch_instance) switch_instance._mount(target, anchor);
		},

		u: function unmount() {
			detachNode(switch_instance_anchor);
			if (switch_instance) switch_instance._unmount();
		},

		d: function destroy() {
			if (switch_instance) switch_instance.destroy(false);
		}
	};
}

// (59:4) {{#if icon !== false}}
function create_if_block(state, component) {
	var div, span, span_class_value, div_class_value;

	return {
		c: function create() {
			div = createElement("div");
			span = createElement("span");
			this.h();
		},

		h: function hydrate() {
			span.className = span_class_value = state.icon === true ? (state._icons[state.type] ? state._icons[state.type] : '') : state.icon;
			div.className = div_class_value = "ui-pnotify-icon " + (state._styles.icon ? state._styles.icon : '');
		},

		m: function mount(target, anchor) {
			insertNode(div, target, anchor);
			appendNode(span, div);
		},

		p: function update(changed, state) {
			if ((changed.icon || changed._icons || changed.type) && span_class_value !== (span_class_value = state.icon === true ? (state._icons[state.type] ? state._icons[state.type] : '') : state.icon)) {
				span.className = span_class_value;
			}

			if ((changed._styles) && div_class_value !== (div_class_value = "ui-pnotify-icon " + (state._styles.icon ? state._styles.icon : ''))) {
				div.className = div_class_value;
			}
		},

		u: function unmount() {
			detachNode(div);
		},

		d: noop
	};
}

// (65:6) {{#if titleTrusted}}
function create_if_block_1(state, component) {
	var raw_before, raw_after;

	return {
		c: function create() {
			raw_before = createElement('noscript');
			raw_after = createElement('noscript');
		},

		m: function mount(target, anchor) {
			insertNode(raw_before, target, anchor);
			raw_before.insertAdjacentHTML("afterend", state.title);
			insertNode(raw_after, target, anchor);
		},

		p: function update(changed, state) {
			if (changed.title) {
				detachBetween(raw_before, raw_after);
				raw_before.insertAdjacentHTML("afterend", state.title);
			}
		},

		u: function unmount() {
			detachBetween(raw_before, raw_after);

			detachNode(raw_before);
			detachNode(raw_after);
		},

		d: noop
	};
}

// (67:6) {{else}}
function create_if_block_2(state, component) {
	var text;

	return {
		c: function create() {
			text = createText(state.title);
		},

		m: function mount(target, anchor) {
			insertNode(text, target, anchor);
		},

		p: function update(changed, state) {
			if (changed.title) {
				text.data = state.title;
			}
		},

		u: function unmount() {
			detachNode(text);
		},

		d: noop
	};
}

// (72:6) {{#if textTrusted}}
function create_if_block_3(state, component) {
	var raw_before, raw_after;

	return {
		c: function create() {
			raw_before = createElement('noscript');
			raw_after = createElement('noscript');
		},

		m: function mount(target, anchor) {
			insertNode(raw_before, target, anchor);
			raw_before.insertAdjacentHTML("afterend", state.text);
			insertNode(raw_after, target, anchor);
		},

		p: function update(changed, state) {
			if (changed.text) {
				detachBetween(raw_before, raw_after);
				raw_before.insertAdjacentHTML("afterend", state.text);
			}
		},

		u: function unmount() {
			detachBetween(raw_before, raw_after);

			detachNode(raw_before);
			detachNode(raw_after);
		},

		d: noop
	};
}

// (74:6) {{else}}
function create_if_block_4(state, component) {
	var text;

	return {
		c: function create() {
			text = createText(state.text);
		},

		m: function mount(target, anchor) {
			insertNode(text, target, anchor);
		},

		p: function update(changed, state) {
			if (changed.text) {
				text.data = state.text;
			}
		},

		u: function unmount() {
			detachNode(text);
		},

		d: noop
	};
}

// (78:4) {{#each _modulesAppendContainer as module}}
function create_each_block_1(state, _modulesAppendContainer, module_1, module_index_1, component) {
	var switch_instance_anchor;

	var switch_value = module_1;

	function switch_props(state, _modulesAppendContainer, module_1, module_index_1) {
		return {
			root: component.root
		};
	}

	if (switch_value) {
		var switch_instance = new switch_value(switch_props(state, _modulesAppendContainer, module_1, module_index_1));
	}

	function switch_instance_init(event) {
		component.initModule(event.module);
	}

	if (switch_instance) switch_instance.on("init", switch_instance_init);

	return {
		c: function create() {
			switch_instance_anchor = createComment();
			if (switch_instance) switch_instance._fragment.c();
		},

		m: function mount(target, anchor) {
			insertNode(switch_instance_anchor, target, anchor);
			if (switch_instance) switch_instance._mount(target, anchor);
		},

		u: function unmount() {
			detachNode(switch_instance_anchor);
			if (switch_instance) switch_instance._unmount();
		},

		d: function destroy() {
			if (switch_instance) switch_instance.destroy(false);
		}
	};
}

function select_block_type(state) {
	if (state.titleTrusted) return create_if_block_1;
	return create_if_block_2;
}

function select_block_type_1(state) {
	if (state.textTrusted) return create_if_block_3;
	return create_if_block_4;
}

function PNotify_1(options) {
	init(this, options);
	this.refs = {};
	this._state = assign(data(), options.data);
	this._recompute({ styling: 1, icons: 1 }, this._state);

	if (!document.getElementById("svelte-3059224252-style")) add_css();

	var _oncreate = oncreate.bind(this);

	if (!options.root) {
		this._oncreate = [];
		this._beforecreate = [];
		this._aftercreate = [];
	}

	this._fragment = create_main_fragment(this._state, this);

	this.root._oncreate.push(_oncreate);

	if (options.target) {
		this._fragment.c();
		this._fragment.m(options.target, options.anchor || null);

		this._lock = true;
		callAll(this._beforecreate);
		callAll(this._oncreate);
		callAll(this._aftercreate);
		this._lock = false;
	}
}

assign(PNotify_1.prototype, methods, {
 	destroy: destroy,
 	get: get,
 	fire: fire,
 	observe: observe,
 	on: on,
 	set: set,
 	teardown: destroy,
 	_set: _set,
 	_mount: _mount,
 	_unmount: _unmount,
 	_differs: _differs
 });

PNotify_1.prototype._recompute = function _recompute(changed, state) {
	if (changed.styling) {
		if (this._differs(state._styles, (state._styles = _styles(state.styling)))) changed._styles = true;
	}

	if (changed.icons) {
		if (this._differs(state._icons, (state._icons = _icons(state.icons)))) changed._icons = true;
	}
}

setup(PNotify_1);

function createElement(name) {
	return document.createElement(name);
}

function appendNode(node, target) {
	target.appendChild(node);
}

function createText(data) {
	return document.createTextNode(data);
}

function setStyle(node, key, value) {
	node.style.setProperty(key, value);
}

function setAttribute(node, attribute, value) {
	node.setAttribute(attribute, value);
}

function addListener(node, event, handler) {
	node.addEventListener(event, handler, false);
}

function insertNode(node, target, anchor) {
	target.insertBefore(node, anchor);
}

function detachNode(node) {
	node.parentNode.removeChild(node);
}

function destroyEach(iterations) {
	for (var i = 0; i < iterations.length; i += 1) {
		if (iterations[i]) iterations[i].d();
	}
}

function removeListener(node, event, handler) {
	node.removeEventListener(event, handler, false);
}

function createComment() {
	return document.createComment('');
}

function noop() {}

function detachBetween(before, after) {
	while (before.nextSibling && before.nextSibling !== after) {
		before.parentNode.removeChild(before.nextSibling);
	}
}

function init(component, options) {
	component._observers = { pre: blankObject(), post: blankObject() };
	component._handlers = blankObject();
	component._bind = options._bind;

	component.options = options;
	component.root = options.root || component;
	component.store = component.root.store || options.store;
}

function assign(target) {
	var k,
		source,
		i = 1,
		len = arguments.length;
	for (; i < len; i++) {
		source = arguments[i];
		for (k in source) target[k] = source[k];
	}

	return target;
}

function callAll(fns) {
	while (fns && fns.length) fns.shift()();
}

function destroy(detach) {
	this.destroy = noop;
	this.fire('destroy');
	this.set = this.get = noop;

	if (detach !== false) this._fragment.u();
	this._fragment.d();
	this._fragment = this._state = null;
}

function get(key) {
	return key ? this._state[key] : this._state;
}

function fire(eventName, data) {
	var handlers =
		eventName in this._handlers && this._handlers[eventName].slice();
	if (!handlers) return;

	for (var i = 0; i < handlers.length; i += 1) {
		handlers[i].call(this, data);
	}
}

function observe(key, callback, options) {
	var group = options && options.defer
		? this._observers.post
		: this._observers.pre;

	(group[key] || (group[key] = [])).push(callback);

	if (!options || options.init !== false) {
		callback.__calling = true;
		callback.call(this, this._state[key]);
		callback.__calling = false;
	}

	return {
		cancel: function() {
			var index = group[key].indexOf(callback);
			if (~index) group[key].splice(index, 1);
		}
	};
}

function on(eventName, handler) {
	if (eventName === 'teardown') return this.on('destroy', handler);

	var handlers = this._handlers[eventName] || (this._handlers[eventName] = []);
	handlers.push(handler);

	return {
		cancel: function() {
			var index = handlers.indexOf(handler);
			if (~index) handlers.splice(index, 1);
		}
	};
}

function set(newState) {
	this._set(assign({}, newState));
	if (this.root._lock) return;
	this.root._lock = true;
	callAll(this.root._beforecreate);
	callAll(this.root._oncreate);
	callAll(this.root._aftercreate);
	this.root._lock = false;
}

function _set(newState) {
	var oldState = this._state,
		changed = {},
		dirty = false;

	for (var key in newState) {
		if (this._differs(newState[key], oldState[key])) changed[key] = dirty = true;
	}
	if (!dirty) return;

	this._state = assign({}, oldState, newState);
	this._recompute(changed, this._state);
	if (this._bind) this._bind(changed, this._state);

	if (this._fragment) {
		dispatchObservers(this, this._observers.pre, changed, this._state, oldState);
		this._fragment.p(changed, this._state);
		dispatchObservers(this, this._observers.post, changed, this._state, oldState);
	}
}

function _mount(target, anchor) {
	this._fragment.m(target, anchor);
}

function _unmount() {
	if (this._fragment) this._fragment.u();
}

function _differs(a, b) {
	return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
}

function blankObject() {
	return Object.create(null);
}

function dispatchObservers(component, group, changed, newState, oldState) {
	for (var key in group) {
		if (!changed[key]) continue;

		var newValue = newState[key];
		var oldValue = oldState[key];

		var callbacks = group[key];
		if (!callbacks) continue;

		for (var i = 0; i < callbacks.length; i += 1) {
			var callback = callbacks[i];
			if (callback.__calling) continue;

			callback.__calling = true;
			callback.call(component, newValue, oldValue);
			callback.__calling = false;
		}
	}
}
export default PNotify_1;