/* src/PNotifyCallbacks.html generated by Svelte v1.55.0 */
import PNotify from "./PNotify.js";

let _open   = PNotify.prototype.open,
    _close = PNotify.prototype.close;

const callbacks = (notice, options, name) => {
  let modules = notice ? notice.get('modules') : options.modules;
  let cbs = (modules && modules.Callbacks) ? modules.Callbacks : {};
  return cbs[name] ? cbs[name] : () => true;
};

PNotify.prototype.open = function(...args) {
  let ret = callbacks(this, null, 'beforeOpen')(this);
  if (ret !== false) {
    _open.apply(this, args);
    callbacks(this, null, 'afterOpen')(this);
  }
};

PNotify.prototype.close = function(timer_hide, ...args) {
  let ret = callbacks(this, null, 'beforeClose')(this, timer_hide);
  if (ret !== false) {
    _close.apply(this, [timer_hide, ...args]);
    callbacks(this, null, 'afterClose')(this, timer_hide);
  }
};

function setup(Component) {
  Component.key = "Callbacks";

  Component.getCallbacks = callbacks;

  let _alert   = PNotify.alert,
      _notice  = PNotify.notice,
      _info    = PNotify.info,
      _success = PNotify.success,
      _error   = PNotify.error;

  let init = (original, options) => {
    callbacks(null, options, 'beforeInit')(options);
    let notice = original(options);
    callbacks(notice, null, 'afterInit')(notice);
    return notice;
  };

  PNotify.alert = (options) => {
    return init(_alert, options);
  };
  PNotify.notice = (options) => {
    return init(_notice, options);
  };
  PNotify.info = (options) => {
    return init(_info, options);
  };
  PNotify.success = (options) => {
    return init(_success, options);
  };
  PNotify.error = (options) => {
    return init(_error, options);
  };

  // Register the module with PNotify.
  PNotify.modules.Callbacks = Component;
};

function create_main_fragment(state, component) {

	return {
		c: noop,

		m: noop,

		p: noop,

		u: noop,

		d: noop
	};
}

function PNotifyCallbacks(options) {
	init(this, options);
	this._state = assign({}, options.data);

	this._fragment = create_main_fragment(this._state, this);

	if (options.target) {
		this._fragment.c();
		this._fragment.m(options.target, options.anchor || null);
	}
}

assign(PNotifyCallbacks.prototype, {
 	destroy: destroy,
 	get: get,
 	fire: fire,
 	observe: observe,
 	on: on,
 	set: set,
 	teardown: destroy,
 	_set: _set,
 	_mount: _mount,
 	_unmount: _unmount,
 	_differs: _differs
 });

PNotifyCallbacks.prototype._recompute = noop;

setup(PNotifyCallbacks);

function noop() {}

function init(component, options) {
	component._observers = { pre: blankObject(), post: blankObject() };
	component._handlers = blankObject();
	component._bind = options._bind;

	component.options = options;
	component.root = options.root || component;
	component.store = component.root.store || options.store;
}

function assign(target) {
	var k,
		source,
		i = 1,
		len = arguments.length;
	for (; i < len; i++) {
		source = arguments[i];
		for (k in source) target[k] = source[k];
	}

	return target;
}

function destroy(detach) {
	this.destroy = noop;
	this.fire('destroy');
	this.set = this.get = noop;

	if (detach !== false) this._fragment.u();
	this._fragment.d();
	this._fragment = this._state = null;
}

function get(key) {
	return key ? this._state[key] : this._state;
}

function fire(eventName, data) {
	var handlers =
		eventName in this._handlers && this._handlers[eventName].slice();
	if (!handlers) return;

	for (var i = 0; i < handlers.length; i += 1) {
		handlers[i].call(this, data);
	}
}

function observe(key, callback, options) {
	var group = options && options.defer
		? this._observers.post
		: this._observers.pre;

	(group[key] || (group[key] = [])).push(callback);

	if (!options || options.init !== false) {
		callback.__calling = true;
		callback.call(this, this._state[key]);
		callback.__calling = false;
	}

	return {
		cancel: function() {
			var index = group[key].indexOf(callback);
			if (~index) group[key].splice(index, 1);
		}
	};
}

function on(eventName, handler) {
	if (eventName === 'teardown') return this.on('destroy', handler);

	var handlers = this._handlers[eventName] || (this._handlers[eventName] = []);
	handlers.push(handler);

	return {
		cancel: function() {
			var index = handlers.indexOf(handler);
			if (~index) handlers.splice(index, 1);
		}
	};
}

function set(newState) {
	this._set(assign({}, newState));
	if (this.root._lock) return;
	this.root._lock = true;
	callAll(this.root._beforecreate);
	callAll(this.root._oncreate);
	callAll(this.root._aftercreate);
	this.root._lock = false;
}

function _set(newState) {
	var oldState = this._state,
		changed = {},
		dirty = false;

	for (var key in newState) {
		if (this._differs(newState[key], oldState[key])) changed[key] = dirty = true;
	}
	if (!dirty) return;

	this._state = assign({}, oldState, newState);
	this._recompute(changed, this._state);
	if (this._bind) this._bind(changed, this._state);

	if (this._fragment) {
		dispatchObservers(this, this._observers.pre, changed, this._state, oldState);
		this._fragment.p(changed, this._state);
		dispatchObservers(this, this._observers.post, changed, this._state, oldState);
	}
}

function _mount(target, anchor) {
	this._fragment.m(target, anchor);
}

function _unmount() {
	if (this._fragment) this._fragment.u();
}

function _differs(a, b) {
	return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
}

function blankObject() {
	return Object.create(null);
}

function callAll(fns) {
	while (fns && fns.length) fns.shift()();
}

function dispatchObservers(component, group, changed, newState, oldState) {
	for (var key in group) {
		if (!changed[key]) continue;

		var newValue = newState[key];
		var oldValue = oldState[key];

		var callbacks = group[key];
		if (!callbacks) continue;

		for (var i = 0; i < callbacks.length; i += 1) {
			var callback = callbacks[i];
			if (callback.__calling) continue;

			callback.__calling = true;
			callback.call(component, newValue, oldValue);
			callback.__calling = false;
		}
	}
}
export default PNotifyCallbacks;