/* src/PNotifyHistory.html generated by Svelte v1.55.0 */
import PNotify from "./PNotify.js";

function data() {
  return Object.assign({
    "_notice": null, // The PNotify notice.
    "_options": {}, // The options for the notice.
  }, PNotify.modules.History.defaults);
};

var methods = {
  initModule(options) {
    this.set(options);

    if (this.get("history")) {
      // Don't destroy notices that are in history.
      const notice = this.get("_notice");
      if (notice.get("destroy")) {
        notice.set({"destroy": false});
      }
    }
  },

  beforeOpen() {
    const maxInStack = this.get("maxInStack");
    if (maxInStack === Infinity) {
      return;
    }

    const stack = this.get("_options").stack;
    if (stack === false) {
      return;
    }

    // Remove oldest notifications leaving only maxInStack from the stack.
    if (PNotify.notices && (PNotify.notices.length > maxInStack)) {
      // Oldest are normally in front of array, or if stack.push=="top" then
      // they are at the end of the array!
      const top = stack.push === "top";
      const forRemoval = [];
      let currentOpen = 0;

      for (let i = (top ? 0 : PNotify.notices.length - 1); (top ? i < PNotify.notices.length : i >= 0); (top ? i++ : i--)) {
        if (
            ["opening", "open"].indexOf(PNotify.notices[i].get("_state")) !== -1
            && PNotify.notices[i].get("stack") === stack
          ) {
          if (currentOpen >= maxInStack) {
            forRemoval.push(PNotify.notices[i]);
          } else {
            currentOpen++;
          }
        }
      }

      for (let i = 0; i < forRemoval.length; i++) {
        forRemoval[i].close(false);
      }
    }
  }
};

function setup(Component) {
  Component.key = "History";

  Component.defaults = {
    // Place the notice in the history.
    history: true,
    // Maximum number of notices to have open in its stack.
    maxInStack: Infinity
  };

  Component.init = (notice) => {
    return new Component({target: document.body});
  };

  Component.showLast = (stack) => {
    if (stack === undefined) {
      stack = PNotify.defaultStack;
    }
    if (stack === false) {
      return;
    }
    const top = (stack.push === "top");

    // Look up the last history notice, and display it.
    let i = (top ? 0 : PNotify.notices.length - 1);

    let notice;
    do {
      notice = PNotify.notices[i];

      if (!notice) {
        return;
      }

      i += (top ? 1 : -1);
    } while (
      notice.get("stack") !== stack
      || !notice.get("_modules").History.get("history")
      || notice.get("_state") === "opening"
      || notice.get("_state") === "open"
    );

    notice.open();
  };

  Component.showAll = (stack) => {
    if (stack === undefined) {
      stack = PNotify.defaultStack;
    }
    if (stack === false) {
      return;
    }

    // Display all notices. (Disregarding non-history notices.)
    for (let i = 0; i < PNotify.notices.length; i++) {
      const notice = PNotify.notices[i];
      if (
          (
            stack === true
            || notice.get("stack") === stack
          )
          && notice.get("_modules").History.get("history")
        ) {
        notice.open();
      }
    };
  };

  // Register the module with PNotify.
  PNotify.modules.History = Component;
};

function create_main_fragment(state, component) {

	return {
		c: noop,

		m: noop,

		p: noop,

		u: noop,

		d: noop
	};
}

function PNotifyHistory(options) {
	init(this, options);
	this._state = assign(data(), options.data);

	this._fragment = create_main_fragment(this._state, this);

	if (options.target) {
		this._fragment.c();
		this._fragment.m(options.target, options.anchor || null);
	}
}

assign(PNotifyHistory.prototype, methods, {
 	destroy: destroy,
 	get: get,
 	fire: fire,
 	observe: observe,
 	on: on,
 	set: set,
 	teardown: destroy,
 	_set: _set,
 	_mount: _mount,
 	_unmount: _unmount,
 	_differs: _differs
 });

PNotifyHistory.prototype._recompute = noop;

setup(PNotifyHistory);

function noop() {}

function init(component, options) {
	component._observers = { pre: blankObject(), post: blankObject() };
	component._handlers = blankObject();
	component._bind = options._bind;

	component.options = options;
	component.root = options.root || component;
	component.store = component.root.store || options.store;
}

function assign(target) {
	var k,
		source,
		i = 1,
		len = arguments.length;
	for (; i < len; i++) {
		source = arguments[i];
		for (k in source) target[k] = source[k];
	}

	return target;
}

function destroy(detach) {
	this.destroy = noop;
	this.fire('destroy');
	this.set = this.get = noop;

	if (detach !== false) this._fragment.u();
	this._fragment.d();
	this._fragment = this._state = null;
}

function get(key) {
	return key ? this._state[key] : this._state;
}

function fire(eventName, data) {
	var handlers =
		eventName in this._handlers && this._handlers[eventName].slice();
	if (!handlers) return;

	for (var i = 0; i < handlers.length; i += 1) {
		handlers[i].call(this, data);
	}
}

function observe(key, callback, options) {
	var group = options && options.defer
		? this._observers.post
		: this._observers.pre;

	(group[key] || (group[key] = [])).push(callback);

	if (!options || options.init !== false) {
		callback.__calling = true;
		callback.call(this, this._state[key]);
		callback.__calling = false;
	}

	return {
		cancel: function() {
			var index = group[key].indexOf(callback);
			if (~index) group[key].splice(index, 1);
		}
	};
}

function on(eventName, handler) {
	if (eventName === 'teardown') return this.on('destroy', handler);

	var handlers = this._handlers[eventName] || (this._handlers[eventName] = []);
	handlers.push(handler);

	return {
		cancel: function() {
			var index = handlers.indexOf(handler);
			if (~index) handlers.splice(index, 1);
		}
	};
}

function set(newState) {
	this._set(assign({}, newState));
	if (this.root._lock) return;
	this.root._lock = true;
	callAll(this.root._beforecreate);
	callAll(this.root._oncreate);
	callAll(this.root._aftercreate);
	this.root._lock = false;
}

function _set(newState) {
	var oldState = this._state,
		changed = {},
		dirty = false;

	for (var key in newState) {
		if (this._differs(newState[key], oldState[key])) changed[key] = dirty = true;
	}
	if (!dirty) return;

	this._state = assign({}, oldState, newState);
	this._recompute(changed, this._state);
	if (this._bind) this._bind(changed, this._state);

	if (this._fragment) {
		dispatchObservers(this, this._observers.pre, changed, this._state, oldState);
		this._fragment.p(changed, this._state);
		dispatchObservers(this, this._observers.post, changed, this._state, oldState);
	}
}

function _mount(target, anchor) {
	this._fragment.m(target, anchor);
}

function _unmount() {
	if (this._fragment) this._fragment.u();
}

function _differs(a, b) {
	return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
}

function blankObject() {
	return Object.create(null);
}

function callAll(fns) {
	while (fns && fns.length) fns.shift()();
}

function dispatchObservers(component, group, changed, newState, oldState) {
	for (var key in group) {
		if (!changed[key]) continue;

		var newValue = newState[key];
		var oldValue = oldState[key];

		var callbacks = group[key];
		if (!callbacks) continue;

		for (var i = 0; i < callbacks.length; i += 1) {
			var callback = callbacks[i];
			if (callback.__calling) continue;

			callback.__calling = true;
			callback.call(component, newValue, oldValue);
			callback.__calling = false;
		}
	}
}
export default PNotifyHistory;