(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define("PNotifyHistory", ["exports", "PNotify"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("./PNotify"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.PNotify);
    global.PNotifyHistory = mod.exports;
  }
})(this, function (exports, _PNotify) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _PNotify2 = _interopRequireDefault(_PNotify);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  };

  var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  function data() {
    return _extends({
      "_notice": null, // The PNotify notice.
      "_options": {} // The options for the notice.
    }, _PNotify2.default.modules.History.defaults);
  };

  var methods = {
    initModule: function initModule(options) {
      this.set(options);

      if (this.get("history")) {
        // Don't destroy notices that are in history.
        var notice = this.get("_notice");
        if (notice.get("destroy")) {
          notice.set({ "destroy": false });
        }
      }
    },
    beforeOpen: function beforeOpen() {
      var maxInStack = this.get("maxInStack");
      if (maxInStack === Infinity) {
        return;
      }

      var stack = this.get("_options").stack;
      if (stack === false) {
        return;
      }

      // Remove oldest notifications leaving only maxInStack from the stack.
      if (_PNotify2.default.notices && _PNotify2.default.notices.length > maxInStack) {
        // Oldest are normally in front of array, or if stack.push=="top" then
        // they are at the end of the array!
        var top = stack.push === "top";
        var forRemoval = [];
        var currentOpen = 0;

        for (var i = top ? 0 : _PNotify2.default.notices.length - 1; top ? i < _PNotify2.default.notices.length : i >= 0; top ? i++ : i--) {
          if (["opening", "open"].indexOf(_PNotify2.default.notices[i].get("_state")) !== -1 && _PNotify2.default.notices[i].get("stack") === stack) {
            if (currentOpen >= maxInStack) {
              forRemoval.push(_PNotify2.default.notices[i]);
            } else {
              currentOpen++;
            }
          }
        }

        for (var _i = 0; _i < forRemoval.length; _i++) {
          forRemoval[_i].close(false);
        }
      }
    }
  };

  function setup(Component) {
    Component.key = "History";

    Component.defaults = {
      // Place the notice in the history.
      history: true,
      // Maximum number of notices to have open in its stack.
      maxInStack: Infinity
    };

    Component.init = function (notice) {
      return new Component({ target: document.body });
    };

    Component.showLast = function (stack) {
      if (stack === undefined) {
        stack = _PNotify2.default.defaultStack;
      }
      if (stack === false) {
        return;
      }
      var top = stack.push === "top";

      // Look up the last history notice, and display it.
      var i = top ? 0 : _PNotify2.default.notices.length - 1;

      var notice = void 0;
      do {
        notice = _PNotify2.default.notices[i];

        if (!notice) {
          return;
        }

        i += top ? 1 : -1;
      } while (notice.get("stack") !== stack || !notice.get("_modules").History.get("history") || notice.get("_state") === "opening" || notice.get("_state") === "open");

      notice.open();
    };

    Component.showAll = function (stack) {
      if (stack === undefined) {
        stack = _PNotify2.default.defaultStack;
      }
      if (stack === false) {
        return;
      }

      // Display all notices. (Disregarding non-history notices.)
      for (var i = 0; i < _PNotify2.default.notices.length; i++) {
        var notice = _PNotify2.default.notices[i];
        if ((stack === true || notice.get("stack") === stack) && notice.get("_modules").History.get("history")) {
          notice.open();
        }
      };
    };

    // Register the module with PNotify.
    _PNotify2.default.modules.History = Component;
  };

  function create_main_fragment(state, component) {

    return {
      c: noop,

      m: noop,

      p: noop,

      u: noop,

      d: noop
    };
  }

  function PNotifyHistory(options) {
    init(this, options);
    this._state = assign(data(), options.data);

    this._fragment = create_main_fragment(this._state, this);

    if (options.target) {
      this._fragment.c();
      this._fragment.m(options.target, options.anchor || null);
    }
  }

  assign(PNotifyHistory.prototype, methods, {
    destroy: destroy,
    get: get,
    fire: fire,
    observe: observe,
    on: on,
    set: set,
    teardown: destroy,
    _set: _set,
    _mount: _mount,
    _unmount: _unmount,
    _differs: _differs
  });

  PNotifyHistory.prototype._recompute = noop;

  setup(PNotifyHistory);

  function noop() {}

  function init(component, options) {
    component._observers = { pre: blankObject(), post: blankObject() };
    component._handlers = blankObject();
    component._bind = options._bind;

    component.options = options;
    component.root = options.root || component;
    component.store = component.root.store || options.store;
  }

  function assign(target) {
    var k,
        source,
        i = 1,
        len = arguments.length;
    for (; i < len; i++) {
      source = arguments[i];
      for (k in source) {
        target[k] = source[k];
      }
    }

    return target;
  }

  function destroy(detach) {
    this.destroy = noop;
    this.fire('destroy');
    this.set = this.get = noop;

    if (detach !== false) this._fragment.u();
    this._fragment.d();
    this._fragment = this._state = null;
  }

  function get(key) {
    return key ? this._state[key] : this._state;
  }

  function fire(eventName, data) {
    var handlers = eventName in this._handlers && this._handlers[eventName].slice();
    if (!handlers) return;

    for (var i = 0; i < handlers.length; i += 1) {
      handlers[i].call(this, data);
    }
  }

  function observe(key, callback, options) {
    var group = options && options.defer ? this._observers.post : this._observers.pre;

    (group[key] || (group[key] = [])).push(callback);

    if (!options || options.init !== false) {
      callback.__calling = true;
      callback.call(this, this._state[key]);
      callback.__calling = false;
    }

    return {
      cancel: function cancel() {
        var index = group[key].indexOf(callback);
        if (~index) group[key].splice(index, 1);
      }
    };
  }

  function on(eventName, handler) {
    if (eventName === 'teardown') return this.on('destroy', handler);

    var handlers = this._handlers[eventName] || (this._handlers[eventName] = []);
    handlers.push(handler);

    return {
      cancel: function cancel() {
        var index = handlers.indexOf(handler);
        if (~index) handlers.splice(index, 1);
      }
    };
  }

  function set(newState) {
    this._set(assign({}, newState));
    if (this.root._lock) return;
    this.root._lock = true;
    callAll(this.root._beforecreate);
    callAll(this.root._oncreate);
    callAll(this.root._aftercreate);
    this.root._lock = false;
  }

  function _set(newState) {
    var oldState = this._state,
        changed = {},
        dirty = false;

    for (var key in newState) {
      if (this._differs(newState[key], oldState[key])) changed[key] = dirty = true;
    }
    if (!dirty) return;

    this._state = assign({}, oldState, newState);
    this._recompute(changed, this._state);
    if (this._bind) this._bind(changed, this._state);

    if (this._fragment) {
      dispatchObservers(this, this._observers.pre, changed, this._state, oldState);
      this._fragment.p(changed, this._state);
      dispatchObservers(this, this._observers.post, changed, this._state, oldState);
    }
  }

  function _mount(target, anchor) {
    this._fragment.m(target, anchor);
  }

  function _unmount() {
    if (this._fragment) this._fragment.u();
  }

  function _differs(a, b) {
    return a != a ? b == b : a !== b || a && (typeof a === "undefined" ? "undefined" : _typeof(a)) === 'object' || typeof a === 'function';
  }

  function blankObject() {
    return Object.create(null);
  }

  function callAll(fns) {
    while (fns && fns.length) {
      fns.shift()();
    }
  }

  function dispatchObservers(component, group, changed, newState, oldState) {
    for (var key in group) {
      if (!changed[key]) continue;

      var newValue = newState[key];
      var oldValue = oldState[key];

      var callbacks = group[key];
      if (!callbacks) continue;

      for (var i = 0; i < callbacks.length; i += 1) {
        var callback = callbacks[i];
        if (callback.__calling) continue;

        callback.__calling = true;
        callback.call(component, newValue, oldValue);
        callback.__calling = false;
      }
    }
  }
  exports.default = PNotifyHistory;
});