/* src/PNotifyAnimate.html generated by Svelte v2.6.3 */
import PNotify from "./PNotify.js";

function data() {
  return Object.assign({
    '_notice': null, // The PNotify notice.
    '_options': {} // The options for the notice.
  }, PNotify.modules.Animate.defaults);
};

var methods = {
  initModule (options) {
    this.set(options);
    this.setUpAnimations();
  },

  update () {
    this.setUpAnimations();
  },

  setUpAnimations () {
    const {_notice, _options, animate} = this.get();
    if (animate) {
      _notice.set({'animation': 'none'});
      if (!_notice._animateIn) {
        _notice._animateIn = _notice.animateIn;
      }
      if (!_notice._animateOut) {
        _notice._animateOut = _notice.animateOut;
      }
      _notice.animateIn = this.animateIn.bind(this);
      _notice.animateOut = this.animateOut.bind(this);
      var animSpeed = 250;
      if (_options.animateSpeed === 'slow') {
        animSpeed = 400;
      } else if (_options.animateSpeed === 'fast') {
        animSpeed = 100;
      } else if (_options.animateSpeed > 0) {
        animSpeed = _options.animateSpeed;
      }
      animSpeed = animSpeed / 1000;
      _notice.refs.elem.style.WebkitAnimationDuration = animSpeed + 's';
      _notice.refs.elem.style.MozAnimationDuration = animSpeed + 's';
      _notice.refs.elem.style.animationDuration = animSpeed + 's';
    } else if (_notice._animateIn && _notice._animateOut) {
      _notice.animateIn = _notice._animateIn;
      delete _notice._animateIn;
      _notice.animateOut = _notice._animateOut;
      delete _notice._animateOut;
    }
  },

  animateIn (callback) {
    const {_notice} = this.get();
    // Declare that the notice is animating in.
    _notice.set({'_animating': 'in'});

    const finished = () => {
      _notice.refs.elem.removeEventListener('webkitAnimationEnd', finished);
      _notice.refs.elem.removeEventListener('mozAnimationEnd', finished);
      _notice.refs.elem.removeEventListener('MSAnimationEnd', finished);
      _notice.refs.elem.removeEventListener('oanimationend', finished);
      _notice.refs.elem.removeEventListener('animationend', finished);
      _notice.set({'_animatingClass': 'ui-pnotify-in animated'});
      if (callback) {
        callback.call();
      }
      // Declare that the notice has completed animating.
      _notice.set({'_animating': false});
    };

    _notice.refs.elem.addEventListener('webkitAnimationEnd', finished);
    _notice.refs.elem.addEventListener('mozAnimationEnd', finished);
    _notice.refs.elem.addEventListener('MSAnimationEnd', finished);
    _notice.refs.elem.addEventListener('oanimationend', finished);
    _notice.refs.elem.addEventListener('animationend', finished);
    _notice.set({'_animatingClass': 'ui-pnotify-in animated ' + this.get().inClass});
  },

  animateOut (callback) {
    const {_notice} = this.get();
    // Declare that the notice is animating out.
    _notice.set({'_animating': 'out'});

    const finished = () => {
      _notice.refs.elem.removeEventListener('webkitAnimationEnd', finished);
      _notice.refs.elem.removeEventListener('mozAnimationEnd', finished);
      _notice.refs.elem.removeEventListener('MSAnimationEnd', finished);
      _notice.refs.elem.removeEventListener('oanimationend', finished);
      _notice.refs.elem.removeEventListener('animationend', finished);
      _notice.set({'_animatingClass': 'animated'});
      if (callback) {
        callback.call();
      }
      // Declare that the notice has completed animating.
      _notice.set({'_animating': false});
    };

    _notice.refs.elem.addEventListener('webkitAnimationEnd', finished);
    _notice.refs.elem.addEventListener('mozAnimationEnd', finished);
    _notice.refs.elem.addEventListener('MSAnimationEnd', finished);
    _notice.refs.elem.addEventListener('oanimationend', finished);
    _notice.refs.elem.addEventListener('animationend', finished);
    _notice.set({'_animatingClass': 'ui-pnotify-in animated ' + this.get().outClass});
  }
};

function setup(Component) {
  Component.key = 'Animate';

  Component.defaults = {
    // Use animate.css to animate the notice.
    animate: false,
    // The class to use to animate the notice in.
    inClass: '',
    // The class to use to animate the notice out.
    outClass: ''
  };

  Component.init = (notice) => {
    notice.attention = (aniClass, callback) => {
      const cb = () => {
        notice.refs.container.removeEventListener('webkitAnimationEnd', cb);
        notice.refs.container.removeEventListener('mozAnimationEnd', cb);
        notice.refs.container.removeEventListener('MSAnimationEnd', cb);
        notice.refs.container.removeEventListener('oanimationend', cb);
        notice.refs.container.removeEventListener('animationend', cb);
        notice.refs.container.classList.remove(aniClass);
        if (callback) {
          callback.call(notice);
        }
      };
      notice.refs.container.addEventListener('webkitAnimationEnd', cb);
      notice.refs.container.addEventListener('mozAnimationEnd', cb);
      notice.refs.container.addEventListener('MSAnimationEnd', cb);
      notice.refs.container.addEventListener('oanimationend', cb);
      notice.refs.container.addEventListener('animationend', cb);
      notice.refs.container.classList.add('animated');
      notice.refs.container.classList.add(aniClass);
    };

    return new Component({target: document.body});
  };

  // Register the module with PNotify.
  PNotify.modules.Animate = Component;
};

function create_main_fragment(component, ctx) {

	return {
		c: noop,

		m: noop,

		p: noop,

		d: noop
	};
}

function PNotifyAnimate(options) {
	init(this, options);
	this._state = assign(data(), options.data);
	this._intro = true;

	this._fragment = create_main_fragment(this, this._state);

	if (options.target) {
		this._fragment.c();
		this._mount(options.target, options.anchor);
	}
}

assign(PNotifyAnimate.prototype, {
 	destroy: destroy,
 	get: get,
 	fire: fire,
 	on: on,
 	set: set,
 	_set: _set,
 	_mount: _mount,
 	_differs: _differs
 });
assign(PNotifyAnimate.prototype, methods);

PNotifyAnimate.prototype._recompute = noop;

setup(PNotifyAnimate);

function noop() {}

function init(component, options) {
	component._handlers = blankObject();
	component._bind = options._bind;

	component.options = options;
	component.root = options.root || component;
	component.store = component.root.store || options.store;
}

function assign(tar, src) {
	for (var k in src) tar[k] = src[k];
	return tar;
}

function destroy(detach) {
	this.destroy = noop;
	this.fire('destroy');
	this.set = noop;

	this._fragment.d(detach !== false);
	this._fragment = null;
	this._state = {};
}

function get() {
	return this._state;
}

function fire(eventName, data) {
	var handlers =
		eventName in this._handlers && this._handlers[eventName].slice();
	if (!handlers) return;

	for (var i = 0; i < handlers.length; i += 1) {
		var handler = handlers[i];

		if (!handler.__calling) {
			handler.__calling = true;
			handler.call(this, data);
			handler.__calling = false;
		}
	}
}

function on(eventName, handler) {
	var handlers = this._handlers[eventName] || (this._handlers[eventName] = []);
	handlers.push(handler);

	return {
		cancel: function() {
			var index = handlers.indexOf(handler);
			if (~index) handlers.splice(index, 1);
		}
	};
}

function set(newState) {
	this._set(assign({}, newState));
	if (this.root._lock) return;
	this.root._lock = true;
	callAll(this.root._beforecreate);
	callAll(this.root._oncreate);
	callAll(this.root._aftercreate);
	this.root._lock = false;
}

function _set(newState) {
	var oldState = this._state,
		changed = {},
		dirty = false;

	for (var key in newState) {
		if (this._differs(newState[key], oldState[key])) changed[key] = dirty = true;
	}
	if (!dirty) return;

	this._state = assign(assign({}, oldState), newState);
	this._recompute(changed, this._state);
	if (this._bind) this._bind(changed, this._state);

	if (this._fragment) {
		this.fire("state", { changed: changed, current: this._state, previous: oldState });
		this._fragment.p(changed, this._state);
		this.fire("update", { changed: changed, current: this._state, previous: oldState });
	}
}

function _mount(target, anchor) {
	this._fragment[this._fragment.i ? 'i' : 'm'](target, anchor || null);
}

function _differs(a, b) {
	return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
}

function blankObject() {
	return Object.create(null);
}

function callAll(fns) {
	while (fns && fns.length) fns.shift()();
}
export default PNotifyAnimate;