/* src/PNotifyReference.html generated by Svelte v2.6.3 */
import PNotify from "./PNotify.js";

function data() {
  return Object.assign({
    '_notice': null, // The PNotify notice.
    '_options': {}, // The options for the notice.
    '_mouseIsIn': false
  }, PNotify.modules.Reference.defaults);
};

var methods = {
  // This method is called from the core to give us our actual options.
  // Until it is called, our options will just be the defaults.
  initModule (options) {
    // Set our options.
    this.set(options);
    // Now that the notice is available to us, we can listen to events fired
    // from it.
    const {_notice} = this.get();
    _notice.on('mouseenter', () => this.set({'_mouseIsIn': true}));
    _notice.on('mouseleave', () => this.set({'_mouseIsIn': false}));
  },

  doSomething () {
    // Spin the notice around.
    let curAngle = 0;
    const {_notice} = this.get();
    const timer = setInterval(() => {
      curAngle += 10;
      if (curAngle === 360) {
        curAngle = 0;
        clearInterval(timer);
      }
      _notice.refs.elem.style.transform = 'rotate(' + curAngle + 'deg)';
    }, 20);
  },

  // I have nothing to put in these, just showing you that they exist. You
  // won't need to include them if you aren't using them.
  update () {
    // Called when the notice is updating its options.
  },
  beforeOpen () {
    // Called before the notice is opened.
  },
  afterOpen () {
    // Called after the notice is opened.
  },
  beforeClose () {
    // Called before the notice is closed.
  },
  afterClose () {
    // Called after the notice is closed.
  },
  beforeDestroy () {
    // Called before the notice is destroyed.
  },
  afterDestroy () {
    // Called after the notice is destroyed.
  }
};

function oncreate() {
  // This is the second way to init a module. Because we put markup in the
  // template, we have to fire this event to tell the core that we are ready
  // to receive our options.
  this.fire('init', {module: this});
};

function setup(Component) {
  // This is the key you use for registering your module with PNotify.
  Component.key = 'Reference';

  // This if the default values of your options.
  Component.defaults = {
    // Provide a thing for stuff. Turned off by default.
    putThing: false,
    // If you are displaying any text, you should use a labels options to
    // support internationalization.
    labels: {
      text: 'Spin Around'
    }
  };

  // This is the first way to init a module. If you aren't placing any
  // markup in the template, you would do this.
  // Component.init = (_notice) => {
  //   return new Component({target: document.body, data: {_notice}});
  // };

  // Register the module with PNotify.
  PNotify.modules.Reference = Component;
  // Append our markup to the container.
  PNotify.modulesAppendContainer.push(Component);

  // This is where you would add any styling or icons classes you are using in your code.
  Object.assign(PNotify.icons.brighttheme, {
    athing: 'bt-icon bt-icon-refresh'
  });
  Object.assign(PNotify.icons.bootstrap3, {
    athing: 'glyphicon glyphicon-refresh'
  });
  Object.assign(PNotify.icons.fontawesome4, {
    athing: 'fa fa-refresh'
  });
  Object.assign(PNotify.icons.fontawesome5, {
    athing: 'fas fa-sync'
  });
  if (!PNotify.icons.material) {
    PNotify.icons.material = {};
  }
  Object.assign(PNotify.icons.material, {
    athing: 'material-icons pnotify-material-icon-refresh'
  });
};

function add_css() {
	var style = createElement("style");
	style.id = 'svelte-1qy4b0e-style';
	style.textContent = ".ui-pnotify-reference-button.svelte-1qy4b0e{float:right}.ui-pnotify-reference-clearing.svelte-1qy4b0e{clear:right;line-height:0}";
	appendNode(style, document.head);
}

function create_main_fragment(component, ctx) {
	var if_block_anchor;

	var if_block = (ctx.putThing) && create_if_block(component, ctx);

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = createComment();
		},

		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insertNode(if_block_anchor, target, anchor);
		},

		p(changed, ctx) {
			if (ctx.putThing) {
				if (if_block) {
					if_block.p(changed, ctx);
				} else {
					if_block = create_if_block(component, ctx);
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},

		d(detach) {
			if (if_block) if_block.d(detach);
			if (detach) {
				detachNode(if_block_anchor);
			}
		}
	};
}

// (2:0) {#if putThing}
function create_if_block(component, ctx) {
	var button, i, i_class_value, text, text_1_value = ctx.labels.text, text_1, button_disabled_value, text_3, div;

	function click_handler(event) {
		component.doSomething();
	}

	return {
		c() {
			button = createElement("button");
			i = createElement("i");
			text = createText(" ");
			text_1 = createText(text_1_value);
			text_3 = createText("\n  \n  ");
			div = createElement("div");
			i.className = i_class_value = "" + ctx._notice.get()._icons.athing + " svelte-1qy4b0e";
			addListener(button, "click", click_handler);
			button.className = "ui-pnotify-reference-button btn btn-default svelte-1qy4b0e";
			button.type = "button";
			button.disabled = button_disabled_value = !ctx._mouseIsIn;
			div.className = "ui-pnotify-reference-clearing svelte-1qy4b0e";
		},

		m(target, anchor) {
			insertNode(button, target, anchor);
			appendNode(i, button);
			appendNode(text, button);
			appendNode(text_1, button);
			component.refs.thingElem = button;
			insertNode(text_3, target, anchor);
			insertNode(div, target, anchor);
		},

		p(changed, ctx) {
			if ((changed._notice) && i_class_value !== (i_class_value = "" + ctx._notice.get()._icons.athing + " svelte-1qy4b0e")) {
				i.className = i_class_value;
			}

			if ((changed.labels) && text_1_value !== (text_1_value = ctx.labels.text)) {
				text_1.data = text_1_value;
			}

			if ((changed._mouseIsIn) && button_disabled_value !== (button_disabled_value = !ctx._mouseIsIn)) {
				button.disabled = button_disabled_value;
			}
		},

		d(detach) {
			if (detach) {
				detachNode(button);
			}

			removeListener(button, "click", click_handler);
			if (component.refs.thingElem === button) component.refs.thingElem = null;
			if (detach) {
				detachNode(text_3);
				detachNode(div);
			}
		}
	};
}

function PNotifyReference(options) {
	init(this, options);
	this.refs = {};
	this._state = assign(data(), options.data);
	this._intro = true;

	if (!document.getElementById("svelte-1qy4b0e-style")) add_css();

	if (!options.root) {
		this._oncreate = [];
	}

	this._fragment = create_main_fragment(this, this._state);

	this.root._oncreate.push(() => {
		oncreate.call(this);
		this.fire("update", { changed: assignTrue({}, this._state), current: this._state });
	});

	if (options.target) {
		this._fragment.c();
		this._mount(options.target, options.anchor);

		callAll(this._oncreate);
	}
}

assign(PNotifyReference.prototype, {
 	destroy: destroy,
 	get: get,
 	fire: fire,
 	on: on,
 	set: set,
 	_set: _set,
 	_mount: _mount,
 	_differs: _differs
 });
assign(PNotifyReference.prototype, methods);

PNotifyReference.prototype._recompute = noop;

setup(PNotifyReference);

function createElement(name) {
	return document.createElement(name);
}

function appendNode(node, target) {
	target.appendChild(node);
}

function createComment() {
	return document.createComment('');
}

function insertNode(node, target, anchor) {
	target.insertBefore(node, anchor);
}

function detachNode(node) {
	node.parentNode.removeChild(node);
}

function createText(data) {
	return document.createTextNode(data);
}

function addListener(node, event, handler) {
	node.addEventListener(event, handler, false);
}

function removeListener(node, event, handler) {
	node.removeEventListener(event, handler, false);
}

function init(component, options) {
	component._handlers = blankObject();
	component._bind = options._bind;

	component.options = options;
	component.root = options.root || component;
	component.store = component.root.store || options.store;
}

function assign(tar, src) {
	for (var k in src) tar[k] = src[k];
	return tar;
}

function assignTrue(tar, src) {
	for (var k in src) tar[k] = 1;
	return tar;
}

function callAll(fns) {
	while (fns && fns.length) fns.shift()();
}

function destroy(detach) {
	this.destroy = noop;
	this.fire('destroy');
	this.set = noop;

	this._fragment.d(detach !== false);
	this._fragment = null;
	this._state = {};
}

function get() {
	return this._state;
}

function fire(eventName, data) {
	var handlers =
		eventName in this._handlers && this._handlers[eventName].slice();
	if (!handlers) return;

	for (var i = 0; i < handlers.length; i += 1) {
		var handler = handlers[i];

		if (!handler.__calling) {
			handler.__calling = true;
			handler.call(this, data);
			handler.__calling = false;
		}
	}
}

function on(eventName, handler) {
	var handlers = this._handlers[eventName] || (this._handlers[eventName] = []);
	handlers.push(handler);

	return {
		cancel: function() {
			var index = handlers.indexOf(handler);
			if (~index) handlers.splice(index, 1);
		}
	};
}

function set(newState) {
	this._set(assign({}, newState));
	if (this.root._lock) return;
	this.root._lock = true;
	callAll(this.root._beforecreate);
	callAll(this.root._oncreate);
	callAll(this.root._aftercreate);
	this.root._lock = false;
}

function _set(newState) {
	var oldState = this._state,
		changed = {},
		dirty = false;

	for (var key in newState) {
		if (this._differs(newState[key], oldState[key])) changed[key] = dirty = true;
	}
	if (!dirty) return;

	this._state = assign(assign({}, oldState), newState);
	this._recompute(changed, this._state);
	if (this._bind) this._bind(changed, this._state);

	if (this._fragment) {
		this.fire("state", { changed: changed, current: this._state, previous: oldState });
		this._fragment.p(changed, this._state);
		this.fire("update", { changed: changed, current: this._state, previous: oldState });
	}
}

function _mount(target, anchor) {
	this._fragment[this._fragment.i ? 'i' : 'm'](target, anchor || null);
}

function _differs(a, b) {
	return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
}

function noop() {}

function blankObject() {
	return Object.create(null);
}
export default PNotifyReference;