var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/* src/PNotifyAnimate.html generated by Svelte v2.15.3 */
(function (global, factory) {
	(typeof exports === "undefined" ? "undefined" : _typeof(exports)) === "object" && typeof module !== "undefined" ? module.exports = factory(require('./PNotify')) : typeof define === "function" && define.amd ? define('PNotifyAnimate', ["./PNotify"], factory) : global.PNotifyAnimate = factory(PNotify);
})(this, function (PNotify) {
	"use strict";

	PNotify = PNotify && PNotify.__esModule ? PNotify["default"] : PNotify;

	function data() {
		return _extends({
			'_notice': null, // The PNotify notice.
			'_options': {} // The options for the notice.
		}, PNotify.modules.Animate.defaults);
	};

	var methods = {
		initModule: function initModule(options) {
			this.set(options);
			this.setUpAnimations();
		},
		update: function update() {
			this.setUpAnimations();
		},
		setUpAnimations: function setUpAnimations() {
			var _get = this.get(),
			    _notice = _get._notice,
			    _options = _get._options,
			    animate = _get.animate;

			if (animate) {
				_notice.set({ 'animation': 'none' });
				if (!_notice._animateIn) {
					_notice._animateIn = _notice.animateIn;
				}
				if (!_notice._animateOut) {
					_notice._animateOut = _notice.animateOut;
				}
				_notice.animateIn = this.animateIn.bind(this);
				_notice.animateOut = this.animateOut.bind(this);
				var animSpeed = 250;
				if (_options.animateSpeed === 'slow') {
					animSpeed = 400;
				} else if (_options.animateSpeed === 'fast') {
					animSpeed = 100;
				} else if (_options.animateSpeed > 0) {
					animSpeed = _options.animateSpeed;
				}
				animSpeed = animSpeed / 1000;
				_notice.refs.elem.style.WebkitAnimationDuration = animSpeed + 's';
				_notice.refs.elem.style.MozAnimationDuration = animSpeed + 's';
				_notice.refs.elem.style.animationDuration = animSpeed + 's';
			} else if (_notice._animateIn && _notice._animateOut) {
				_notice.animateIn = _notice._animateIn;
				delete _notice._animateIn;
				_notice.animateOut = _notice._animateOut;
				delete _notice._animateOut;
			}
		},
		animateIn: function animateIn(callback) {
			var _get2 = this.get(),
			    _notice = _get2._notice;
			// Declare that the notice is animating in.


			_notice.set({ '_animating': 'in' });

			var finished = function finished() {
				_notice.refs.elem.removeEventListener('webkitAnimationEnd', finished);
				_notice.refs.elem.removeEventListener('mozAnimationEnd', finished);
				_notice.refs.elem.removeEventListener('MSAnimationEnd', finished);
				_notice.refs.elem.removeEventListener('oanimationend', finished);
				_notice.refs.elem.removeEventListener('animationend', finished);
				_notice.set({ '_animatingClass': 'ui-pnotify-in animated' });
				if (callback) {
					callback.call();
				}
				// Declare that the notice has completed animating.
				_notice.set({ '_animating': false });
			};

			_notice.refs.elem.addEventListener('webkitAnimationEnd', finished);
			_notice.refs.elem.addEventListener('mozAnimationEnd', finished);
			_notice.refs.elem.addEventListener('MSAnimationEnd', finished);
			_notice.refs.elem.addEventListener('oanimationend', finished);
			_notice.refs.elem.addEventListener('animationend', finished);
			_notice.set({ '_animatingClass': 'ui-pnotify-in animated ' + this.get().inClass });
		},
		animateOut: function animateOut(callback) {
			var _get3 = this.get(),
			    _notice = _get3._notice;
			// Declare that the notice is animating out.


			_notice.set({ '_animating': 'out' });

			var finished = function finished() {
				_notice.refs.elem.removeEventListener('webkitAnimationEnd', finished);
				_notice.refs.elem.removeEventListener('mozAnimationEnd', finished);
				_notice.refs.elem.removeEventListener('MSAnimationEnd', finished);
				_notice.refs.elem.removeEventListener('oanimationend', finished);
				_notice.refs.elem.removeEventListener('animationend', finished);
				_notice.set({ '_animatingClass': 'animated' });
				if (callback) {
					callback.call();
				}
				// Declare that the notice has completed animating.
				_notice.set({ '_animating': false });
			};

			_notice.refs.elem.addEventListener('webkitAnimationEnd', finished);
			_notice.refs.elem.addEventListener('mozAnimationEnd', finished);
			_notice.refs.elem.addEventListener('MSAnimationEnd', finished);
			_notice.refs.elem.addEventListener('oanimationend', finished);
			_notice.refs.elem.addEventListener('animationend', finished);
			_notice.set({ '_animatingClass': 'ui-pnotify-in animated ' + this.get().outClass });
		}
	};

	function setup(Component) {
		Component.key = 'Animate';

		Component.defaults = {
			// Use animate.css to animate the notice.
			animate: false,
			// The class to use to animate the notice in.
			inClass: '',
			// The class to use to animate the notice out.
			outClass: ''
		};

		Component.init = function (notice) {
			notice.attention = function (aniClass, callback) {
				var cb = function cb() {
					notice.refs.container.removeEventListener('webkitAnimationEnd', cb);
					notice.refs.container.removeEventListener('mozAnimationEnd', cb);
					notice.refs.container.removeEventListener('MSAnimationEnd', cb);
					notice.refs.container.removeEventListener('oanimationend', cb);
					notice.refs.container.removeEventListener('animationend', cb);
					notice.refs.container.classList.remove(aniClass);
					if (callback) {
						callback.call(notice);
					}
				};
				notice.refs.container.addEventListener('webkitAnimationEnd', cb);
				notice.refs.container.addEventListener('mozAnimationEnd', cb);
				notice.refs.container.addEventListener('MSAnimationEnd', cb);
				notice.refs.container.addEventListener('oanimationend', cb);
				notice.refs.container.addEventListener('animationend', cb);
				notice.refs.container.classList.add('animated');
				notice.refs.container.classList.add(aniClass);
			};

			return new Component({ target: document.body });
		};

		// Register the module with PNotify.
		PNotify.modules.Animate = Component;
	};

	function create_main_fragment(component, ctx) {

		return {
			c: noop,

			m: noop,

			p: noop,

			d: noop
		};
	}

	function PNotifyAnimate(options) {
		init(this, options);
		this._state = assign(data(), options.data);
		this._intro = true;

		this._fragment = create_main_fragment(this, this._state);

		if (options.target) {
			this._fragment.c();
			this._mount(options.target, options.anchor);
		}
	}

	assign(PNotifyAnimate.prototype, {
		destroy: destroy,
		get: get,
		fire: fire,
		on: on,
		set: set,
		_set: _set,
		_stage: _stage,
		_mount: _mount,
		_differs: _differs
	});
	assign(PNotifyAnimate.prototype, methods);

	PNotifyAnimate.prototype._recompute = noop;

	setup(PNotifyAnimate);

	function noop() {}

	function init(component, options) {
		component._handlers = blankObject();
		component._slots = blankObject();
		component._bind = options._bind;
		component._staged = {};

		component.options = options;
		component.root = options.root || component;
		component.store = options.store || component.root.store;

		if (!options.root) {
			component._beforecreate = [];
			component._oncreate = [];
			component._aftercreate = [];
		}
	}

	function assign(tar, src) {
		for (var k in src) {
			tar[k] = src[k];
		}return tar;
	}

	function destroy(detach) {
		this.destroy = noop;
		this.fire('destroy');
		this.set = noop;

		this._fragment.d(detach !== false);
		this._fragment = null;
		this._state = {};
	}

	function get() {
		return this._state;
	}

	function fire(eventName, data) {
		var handlers = eventName in this._handlers && this._handlers[eventName].slice();
		if (!handlers) return;

		for (var i = 0; i < handlers.length; i += 1) {
			var handler = handlers[i];

			if (!handler.__calling) {
				try {
					handler.__calling = true;
					handler.call(this, data);
				} finally {
					handler.__calling = false;
				}
			}
		}
	}

	function on(eventName, handler) {
		var handlers = this._handlers[eventName] || (this._handlers[eventName] = []);
		handlers.push(handler);

		return {
			cancel: function cancel() {
				var index = handlers.indexOf(handler);
				if (~index) handlers.splice(index, 1);
			}
		};
	}

	function set(newState) {
		this._set(assign({}, newState));
		if (this.root._lock) return;
		flush(this.root);
	}

	function _set(newState) {
		var oldState = this._state,
		    changed = {},
		    dirty = false;

		newState = assign(this._staged, newState);
		this._staged = {};

		for (var key in newState) {
			if (this._differs(newState[key], oldState[key])) changed[key] = dirty = true;
		}
		if (!dirty) return;

		this._state = assign(assign({}, oldState), newState);
		this._recompute(changed, this._state);
		if (this._bind) this._bind(changed, this._state);

		if (this._fragment) {
			this.fire("state", { changed: changed, current: this._state, previous: oldState });
			this._fragment.p(changed, this._state);
			this.fire("update", { changed: changed, current: this._state, previous: oldState });
		}
	}

	function _stage(newState) {
		assign(this._staged, newState);
	}

	function _mount(target, anchor) {
		this._fragment[this._fragment.i ? 'i' : 'm'](target, anchor || null);
	}

	function _differs(a, b) {
		return a != a ? b == b : a !== b || a && (typeof a === "undefined" ? "undefined" : _typeof(a)) === 'object' || typeof a === 'function';
	}

	function blankObject() {
		return Object.create(null);
	}

	function flush(component) {
		component._lock = true;
		callAll(component._beforecreate);
		callAll(component._oncreate);
		callAll(component._aftercreate);
		component._lock = false;
	}

	function callAll(fns) {
		while (fns && fns.length) {
			fns.shift()();
		}
	}

	return PNotifyAnimate;
});
//# sourceMappingURL=PNotifyAnimate.js.map