# point-cluster [![Build Status](https://travis-ci.org/dfcreative/point-cluster.svg?branch=master)](https://travis-ci.org/dfcreative/point-cluster)

Point clustering for data visualization purposes. Useful for Canvas2D, SVG or WebGL scatter plots.

* [ ] quad-tree, kd-tree, ann-tree and other tree types.
* [x] splatting by zoom layers.
* [x] point selection/hover by range.
* [ ] point radius and weight.
* [ ] reverse z-index order mode to keep visible points in reclustering.
* [ ] appending/removing points.
* [x] no visually noticeable clustering artifacts.
* [x] high performance (faster than [snap-points-2d](https://github.com/gl-vis/snap-points-2d)).
* [x] no memory overuse.

[DEMO](https://github.com/dfcreative/point-cluster)


## Canvas2D example

```js
const cluster = require('point-cluster')
const context = require('get-canvas-context')('2d')
document.body.appendChild(context.canvas)


// create 1 million 2d points
let coords = Array.from({length: 1000000 * 2}, Math.random)

// build a tree
let points = cluster(coords)

// data range
let range = [0.1, 0.1, .8, .8]

// current pixel size
let pixelSize = (range[2] - range[0]) / context.width

// show only levels corresponding to
let lod = points.levels(pixelSize, range)

// render only points actually visible on the screen
for (let level = 0; level < lod.length; level++) {
	let [from, to] = points.levels
	render(level[0], level[1])
}

// draw points corresponding to the identifiers
function render (ids, from, to) {
	for (let i = from; i < to; i++) {
		let x = points[i * 2]
		let y = points[i * 2 + 1]
		canvas.drawCircle(x, y)
	}
}
```

## WebGL example

```js
```

## API

### `points = cluster(coords, options?)`

Create index tree for the set of 2d `coords` based on `options`.

`points` is an array of `[x,y, x,y, ...]` or `[[x,y], [x,y], ...]` coordinates.

#### `options`

Option | Default | Description
---|---|---
`bounds` | `auto` | Data bounds, if different from `coords` bounds, eg. in case of subdata.
`nodeSize` | `1` | Min size of node, ie. tree traversal is stopped once the node contains less than the indicated number of points.
`sort` | `false` | Sort output cluster values by x-, y-coordinate or radius. By default is sorted in tree order (z-curve in case of quadtree). Can be useful for faster rendering.
`levelPoint` | `'first'` | `'first'`, `'last'` or a function, returning point id for the level.

### `points.levels`

Point ids distributed by zoom levels of details. Handy to form a buffer in WebGL and use `points.lod` method to get subranges of buffer to render.

### `points.closest(x, y)`

Get point id closest to the indicated `x, y` coordinates, optionally limited by the `maxLevel`.

### `points.range(minX, minY, maxX, maxY)`

Get point ids from the indicated range, optinally limited by the `maxLevel`.

### `points.radius(x, y, r)`

Return point ids within the radius `r` from `x, y` coordinates, optionally limited by `maxLevel`.

### `points.offsets(pxSize, minX, minY, maxX, maxY)`

Get offsets for the points visible at a specific zoom level and range. Returns list of arrays corresponding to `points.levels` ranges, eg. `{1: [120, 200], 2: [1120, 1540], ...}`. Useful for obtaining subranges to rerender.



### Related

* [snap-points-2d](https://github.com/gl-vis/snap-points-2d) — grouping points by pixels.
* [kdgrass](https://github.com/dfcreative/kdgrass) — minimal kd-tree implementation.


## License

(c) 2017 Dmitry Yv. MIT License

Development supported by [plot.ly](https://github.com/plotly/).
