'use strict'


const getBounds = require('array-bounds')
const pick = require('pick-by-alias')
const defined = require('defined')


module.exports = PointCluster

function PointCluster(srcPoints, options) {
  if (!(this instanceof PointCluster)) return new PointCluster(srcPoints, options)


  // sort out options
  if (!options) options = {}
  if (typeof options === 'string') options = { type: options }

  options = pick(options, {
    bounds: 'range bounds',
    // type: 'type kind split',
    // sort: 'sortBy sortby sort',
    // tail: 'tail reverse levelReverse reverseLevel tailFirst last',
    nodeSize: 'node nodeSize minNodeSize minSize size'
  })

  // this.type = defined(options.type, 'quad')
  // this.sort = defined(options.sort, 'x')
  // this.tail = defined(options.tail, false)
  this.nodeSize = defined(options.nodeSize, 0)

  let bounds = this.bounds = defined(options.bounds, getBounds(srcPoints, 2))
  if (bounds[0] === bounds[2]) bounds[2]++
  if (bounds[1] === bounds[3]) bounds[3]++

  this.points = this.normalize(srcPoints, bounds)

  // init variables
  let n = srcPoints.length >>> 1
  let ids = this.ids = Array(n)
  for (let i = 0; i < n; ++i) {
    ids[i] = i
  }
  // let weights = new Uint32Array(n)
  // let levels = new Uint8Array(n)


  /*
  // use x-sort if required
  if (options.sort) {
    // pack levels: uint8, x-coord: uint16 and id: uint32 to float64
    let packed = new Float64Array(n)
    let packedInt = new Uint32Array(packed.buffer)
    for (let i = 0; i < n; i++) {
      packedInt[i * 2] = i
      packedInt[i * 2 + 1] = (0x3ff00000 & (levels[i] << 20) | 0x0000ffff & ((1 - points[i * 2]) * 0xffff))
    }

    // do native sort
    packed.sort()

    // unpack data back
    let sortedLevels = new Uint8Array(n)
    let sortedWeights = new Uint32Array(n)
    let sortedIds = new Uint32Array(n)
    let sortedPoints = new Float64Array(n * 2)
    for (let i = 0; i < n; i++) {
      let id = packedInt[(n - i - 1) * 2]
      sortedLevels[i] = levels[id]
      sortedWeights[i] = weights[id]
      sortedIds[i] = ids[id]
      sortedPoints[i * 2] = points[id * 2]
      sortedPoints[i * 2 + 1] = points[id * 2 + 1]
    }

    ids = sortedIds
    levels = sortedLevels
    points = sortedPoints
    weights = sortedWeights
  }


  // form levels of details
  let lod         = []
  let lastLevel   = 0
  let prevOffset  = n
  for(let ptr = n - 1; ptr >= 0; --ptr) {
    let level = levels[ptr]
    if(level === lastLevel) continue

    lod.push({
      pixelSize: diam * Math.pow(0.5, level),
      offset: ptr + 1,
      count: prevOffset - (ptr + 1)
    })
    prevOffset = ptr+1

    lastLevel = level
  }
  lod.push({
    pixelSize: diam * Math.pow(0.5, levels[0] + 1),
    offset: 0,
    count: prevOffset
  })


  // get points within radius of the point
  function radius (xy, r) {

  }

  // get points within the range
  function range () {
    let {x, y, width, height} = parseRect(...arguments)

    // get down by levels
  }

  // get points belonging to the indicated level
  function level (size) {

  }
  */
}

// return array with normalized points
PointCluster.prototype.normalize = function(srcPoints, bounds) {
  let lox = bounds[0]
  let loy = bounds[1]
  let hix = bounds[2]
  let hiy = bounds[3]
  let scaleX = 1.0 / (hix - lox)
  let scaleY = 1.0 / (hiy - loy)
  let result = new Array(srcPoints.length)

  for (let i = 0, n = srcPoints.length / 2; i < n; i++) {
    result[2*i]   = (srcPoints[2*i]   - lox) * scaleX
    result[2*i+1] = (srcPoints[2*i+1] - loy) * scaleY
  }

  return result
}
