'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getLuminance = /*#__PURE__*/require('./getLuminance');

var _getLuminance2 = /*#__PURE__*/_interopRequireDefault(_getLuminance);

var _curry = /*#__PURE__*/require('../internalHelpers/_curry');

var _curry2 = /*#__PURE__*/_interopRequireDefault(_curry);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Selects black or white for best contrast depending on the luminosity of the given color.
 * Follows W3C specs for readability at https://www.w3.org/TR/WCAG20-TECHS/G18.html
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   color: readableColor('#000'),
 *   color: readableColor('papayawhip'),
 *   color: readableColor('rgb(255,0,0)'),
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   color: ${readableColor('#000')};
 *   color: ${readableColor('papayawhip')};
 *   color: ${readableColor('rgb(255,0,0)')};
 * `
 *
 * // CSS in JS Output
 *
 * element {
 *   color: "#fff";
 *   color: "#fff";
 *   color: "#000";
 * }
 */

function readableColor(color) {
  return (0, _getLuminance2.default)(color) > 0.179 ? '#000' : '#fff';
}

var curriedReadableColor = /*#__PURE__*/(0, _curry2.default)(readableColor);
exports.default = curriedReadableColor;
module.exports = exports['default'];